<?php
// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WCQD_METABOX_Divider_Field' ) )
{
	class WCQD_METABOX_Divider_Field extends WCQD_METABOX_Field
	{
		/**
		 * Enqueue scripts and styles
		 *
		 * @return void
		 */
		static function admin_enqueue_scripts()
		{
			wp_enqueue_style( 'rwmb-divider', WCQD_METABOX_CSS_URL . 'divider.css', array(), WCQD_METABOX_VER );
		}

		/**
		 * Show begin HTML markup for fields
		 *
		 * @param mixed $meta
		 * @param array $field
		 *
		 * @return string
		 */
		static function begin_html( $meta, $field )
		{
			$attributes = empty( $field['id'] ) ? '' : " id='{$field['id']}'";
			return "<hr$attributes>";
		}

		/**
		 * Show end HTML markup for fields
		 *
		 * @param mixed $meta
		 * @param array $field
		 *
		 * @return string
		 */
		static function end_html( $meta, $field )
		{
			return '';
		}
	}
}
