<?php
include("config.php");

$hosts=explode("\n", (string)shell_exec("dhcp-lease-list"));

$DHCPIP=array();
$FIXEDIP=array();
$ROUTESTRING="";

function getRoute($ip) {
   return(str_replace("\n", "", shell_exec("sudo -u root /usr/local/bin/route_check $ip")));  
}

foreach($hosts as $line) {
   $part = explode(" ", $line);
   if(count($part) > 4 && str_starts_with($part[2], $localnet)) {
      $cname = "";
      if($part[4] == "Chromecast") {
         $cname = str_replace("\r", "", str_replace("\n", "", shell_exec("/usr/local/bin/getChromecast ".$part[2])));
         if($cname != "") { $cname = " ".$cname; } else { $cname = " OFFLINE"; }
      }
      $ip = $part[2];
      $name = $part[4].$cname;
      $route = getRoute($ip);
      $DHCPIP[$ip] = array("name" => $name, "ip" => $ip, "route" => $route);
      $ROUTESTRING.=$route;
   }
   
}
foreach($fixed as $host => $ip) {
   $route=getRoute($ip);
   $FIXEDIP[$ip] =array("name" => $host, "ip" => $ip, "route" => $route); 
   $ROUTESTRING.=$route;
}

print(
 json_encode(
   array(
   'fixed' => $FIXEDIP, 
   'dhcp' => $DHCPIP,
   'uphash' => hash("sha256", implode("|", array_keys($DHCPIP))."-".implode("|", array_keys($FIXEDIP)).$ROUTESTRING)
   )
 )
);

?>
