<?php

include("config.php");

function activeButton($route, $act) {
   if($route == $act) {
      echo "btn-primary";
   } else {
      echo "btn-secondary";
   }

}

function hostButtons($ip, $active="no") {
   ?>
 <div class="btn-group btn-group-sm" role="group" id="<?php echo $ip;?>">
   <button type="button" data-ip="<?php echo $ip;?>" data-route="no" class="hostbtn btn <?php activeButton("no", $active);?>">NO VPN</button>
   <button type="button" data-ip="<?php echo $ip;?>" data-route="it" class="hostbtn btn <?php activeButton("it", $active);?>">ITALY VPN</button>
   <button type="button" data-ip="<?php echo $ip;?>" data-route="us" class="hostbtn btn <?php activeButton("us", $active);?>">US VPN</button>
   <button type="button" data-ip="<?php echo $ip;?>" data-route="tor" class="hostbtn btn <?php activeButton("us", $active);?>"> -TOR- </button>
</div>
   <?php
}
?><html>
<head>
<title>Routes Admin Panel</title>
<link href="/css/bootstrap.min.css" rel="stylesheet" >
<script src="/js/jquery-3.6.0.min.js" ></script>
<script src="/js/bootstrap.bundle.min.js" ></script>
</head>
<body>

<div id="BASE" data-hash="NOT_INITIALIZED">
   <div>
      <h3><b>DHCP HOSTS:</b></h1>
   </div>
   <div id="DHCP">
   </div>
   <div>
      <h3><b>FIXED IP HOSTS:</b></h1>
   </div>
	<div id="FIXED">
	</div>
</div>
<script language="javascript">

function activeButton(route, act) {
   if(route == act) return "btn-primary";
   return 'btn-secondary';
}


function addButton(block, ip, name, route) {
	           $(block).append(
               '<div>'+
               '  <div data-ip="'+ip+'" data-name="'+name+'"><b>'+ip+' - '+name+' </b><br /></div>'+
               '  <div class="btn-group btn-group-sm" role="group" id="'+ip+'" >' +
               '     <button type="button" data-ip="'+ip+'" data-route="no" class="hostbtn btn '+activeButton("no", route)+'">NO VPN</button>' +
               '     <button type="button" data-ip="'+ip+'" data-route="it" class="hostbtn btn '+activeButton("it", route)+'">IT VPN</button>' +
               '     <button type="button" data-ip="'+ip+'" data-route="us" class="hostbtn btn '+activeButton("us", route)+'">US VPN</button>' +
               '     <button type="button" data-ip="'+ip+'" data-route="tor" class="hostbtn btn '+activeButton("tor", route)+'"> -TOR- </button>' +
               '     <button type="button" data-ip="'+ip+'" data-route="rain" class="hostbtn btn '+activeButton("rain", route)+'"> RAIN </button>' +
               '     <button type="button" data-ip="'+ip+'" data-route="block" class="hostbtn btn '+activeButton("block", route)+'"> BLOCK </button>' +
               '  </div>'+
               '</div>'+
               '<hr>'
           );
}

function updateButton(ip, name, route) {
			$('div[data-ip="'+ip+'"]').attr('data-name', name);
			$('div[data-ip="'+ip+'"] b').text(ip+" - "+name);
			$('button[data-ip="'+ip+'"]').attr('data-name', name);
			$('button[data-ip="'+ip+'"].btn-primary').removeClass('btn-primary').addClass('btn-secondary');
			$('button[data-ip="'+ip+'"][data-route="'+route+'"]').removeClass('btn-secondary').addClass('btn-primary');
}

function refreshData(data) {
   if($("#BASE").attr('data-hash') != data.uphash) {
		$("#BASE").attr('data-hash', data.uphash);
      $.each(data.dhcp, function(ip, v) {
         if(document.getElementById(ip)) {
				updateButton(ip, v.name, v.route);
         } else {
				addButton("#DHCP", ip, v.name, v.route);
         }
      });

      $.each(data.fixed, function(ip, v) {
         if(document.getElementById(ip)) {
				updateButton(ip, v.name, v.route);
         } else {
            addButton("#FIXED", ip, v.name, v.route);
         }
      });
   }
};

function getData() {
   $.getJSON("route.php", refreshData);
}

function sendButton() {
   var ip = $(this).attr('data-ip');
   var route = $(this).attr('data-route');
   $.ajax('setroute.php', {
      type: 'POST',
      data: { 'ip': ip, 'route': route },
      success: getData
   });
}

$(document).ready(function() {
	getData();
   $("#DHCP").on('click', '.hostbtn',  sendButton);
   $("#FIXED").on('click', '.hostbtn', sendButton);
	setInterval(getData, 2000);
});
</script>
</body>
</html>
