/* -- help.c -- */

#include "x11vnc.h"
#include "xdamage.h"
#include "cursor.h"

/*
 * text printed out under -help option
 */

void print_help(int mode);
void xopen_display_fail_message(char *disp);
void nopassword_warning_msg(int gotloc);


void print_help(int mode) {
#if !SMALL_FOOTPRINT
	char help[] = 
"\n"
"x11vnc: allow VNC connections to real X11 displays. %s\n"
"\n"
"Typical usage is:\n"
"\n"
"   Run this command in a shell on the remote machine \"far-host\"\n"
"   with X session you wish to view:\n"
"\n"
"       x11vnc -display :0\n"
"\n"
"   Then run this in another window on the machine you are sitting at:\n"
"\n"
"       vncviewer far-host:0\n"
"\n"
"Once x11vnc establishes connections with the X11 server and starts listening\n"
"as a VNC server it will print out a string: PORT=XXXX where XXXX is typically\n"
"5900 (the default VNC server port).  One would next run something like\n"
"this on the local machine: \"vncviewer hostname:N\" where \"hostname\" is\n"
"the name of the machine running x11vnc and N is XXXX - 5900, i.e. usually\n"
"\"vncviewer hostname:0\".\n"
"\n"
"By default x11vnc will not allow the screen to be shared and it will exit\n"
"as soon as the client disconnects.  See -shared and -forever below to override\n"
"these protections.  See the FAQ for details how to tunnel the VNC connection\n"
"through an encrypted channel such as ssh(1).  In brief:\n"
"\n"
"       ssh -L 5900:localhost:5900 far-host 'x11vnc -localhost -display :0'\n"
"\n"
"       vncviewer -encodings 'copyrect tight zrle hextile' localhost:0\n"
"\n"
"Also, use of a VNC password (-rfbauth or -passwdfile) is strongly recommend.\n"
"\n"
"For additional info see: http://www.karlrunge.com/x11vnc/\n"
"                    and  http://www.karlrunge.com/x11vnc/#faq\n"
"\n"
"\n"
"Rudimentary config file support: if the file $HOME/.x11vncrc exists then each\n"
"line in it is treated as a single command line option.  Disable with -norc.\n"
"For each option name, the leading character \"-\" is not required.  E.g. a\n"
"line that is either \"forever\" or \"-forever\" may be used and are equivalent.\n"
"Likewise \"wait 100\" or \"-wait 100\" are acceptable and equivalent lines.\n"
"The \"#\" character comments out to the end of the line in the usual way\n"
"(backslash it for a literal).  Leading and trailing whitespace is trimmed off.\n"
"Lines may be continued with a \"\\\" as the last character of a line (it\n"
"becomes a space character).\n"
"\n"
"Options:\n"
"\n"
"-display disp          X11 server display to connect to, usually :0.  The X\n"
"                       server process must be running on same machine and\n"
"                       support MIT-SHM.  Equivalent to setting the DISPLAY\n"
"                       environment variable to \"disp\".\n"
"-auth file             Set the X authority file to be \"file\", equivalent to\n"
"                       setting the XAUTHORITY environment variable to \"file\"\n"
"                       before startup.  Same as -xauth file.  See Xsecurity(7),\n"
"                       xauth(1) man pages for more info.\n"
"\n"
"-id windowid           Show the window corresponding to \"windowid\" not\n"
"                       the entire display.  New windows like popup menus,\n"
"                       transient toplevels, etc, may not be seen or may be\n"
"                       clipped.  Disabling SaveUnders or BackingStore in the\n"
"                       X server may help show them.  x11vnc may crash if the\n"
"                       window is initially partially obscured, changes size,\n"
"                       is iconified, etc.  Some steps are taken to avoid this\n"
"                       and the -xrandr mechanism is used to track resizes.  Use\n"
"                       xwininfo(1) to get the window id, or use \"-id pick\"\n"
"                       to have x11vnc run xwininfo(1) for you and extract\n"
"                       the id.  The -id option is useful for exporting very\n"
"                       simple applications (e.g. the current view on a webcam).\n"
"-sid windowid          As -id, but instead of using the window directly it\n"
"                       shifts a root view to it: this shows SaveUnders menus,\n"
"                       etc, although they will be clipped if they extend beyond\n"
"                       the window.\n"
"-clip WxH+X+Y          Only show the sub-region of the full display that\n"
"                       corresponds to the rectangle with size WxH and offset\n"
"                       +X+Y.  The VNC display has size WxH (i.e. smaller than\n"
"                       the full display).  This also works for -id/-sid mode\n"
"                       where the offset is relative to the upper left corner\n"
"                       of the selected window.\n"
"\n"
"-flashcmap             In 8bpp indexed color, let the installed colormap flash\n"
"                       as the pointer moves from window to window (slow).\n"
"-shiftcmap n           Rare problem, but some 8bpp displays use less than 256\n"
"                       colorcells (e.g. 16-color grayscale, perhaps the other\n"
"                       bits are used for double buffering) *and* also need to\n"
"                       shift the pixels values away from 0, .., ncells.  \"n\"\n"
"                       indicates the shift to be applied to the pixel values.\n"
"                       To see the pixel values set DEBUG_CMAP=1 to print out\n"
"                       a colormap histogram.  Example: -shiftcmap 240\n"
"-notruecolor           For 8bpp displays, force indexed color (i.e. a colormap)\n"
"                       even if it looks like 8bpp TrueColor (rare problem).\n"
"-visual n              Experimental option: probably does not do what you\n"
"                       think.  It simply *forces* the visual used for the\n"
"                       framebuffer; this may be a bad thing... (e.g. messes\n"
"                       up colors or cause a crash). It is useful for testing\n"
"                       and for some workarounds.  n may be a decimal number,\n"
"                       or 0x hex.  Run xdpyinfo(1) for the values.  One may\n"
"                       also use \"TrueColor\", etc. see <X11/X.h> for a list.\n"
"                       If the string ends in \":m\" then for better or for\n"
"                       worse the visual depth is forced to be m.\n"
"\n"
"-overlay               Handle multiple depth visuals on one screen, e.g. 8+24\n"
"                       and 24+8 overlay visuals (the 32 bits per pixel are\n"
"                       packed with 8 for PseudoColor and 24 for TrueColor).\n"
"\n"
"                       Currently -overlay only works on Solaris via\n"
"                       XReadScreen(3X11) and IRIX using XReadDisplay(3).\n"
"                       On Solaris there is a problem with image \"bleeding\"\n"
"                       around transient popup menus (but not for the menu\n"
"                       itself): a workaround is to disable SaveUnders\n"
"                       by passing the \"-su\" argument to Xsun (in\n"
"                       /etc/dt/config/Xservers).\n"
"\n"
"                       Use -overlay as a workaround for situations like these:\n"
"                       Some legacy applications require the default visual to\n"
"                       be 8bpp (8+24), or they will use 8bpp PseudoColor even\n"
"                       when the default visual is depth 24 TrueColor (24+8).\n"
"                       In these cases colors in some windows will be incorrect\n"
"                       in x11vnc unless -overlay is used.  Another use of\n"
"                       -overlay is to enable showing the exact mouse cursor\n"
"                       shape (details below).\n"
"\n"
"                       Under -overlay, performance will be somewhat slower\n"
"                       due to the extra image transformations required.\n"
"                       For optimal performance do not use -overlay, but rather\n"
"                       configure the X server so that the default visual is\n"
"                       depth 24 TrueColor and try to have all apps use that\n"
"                       visual (e.g. some apps have -use24 or -visual options).\n"
"-overlay_nocursor      Sets -overlay, but does not try to draw the exact mouse\n"
"                       cursor shape using the overlay mechanism.\n"
"\n"
"-scale fraction        Scale the framebuffer by factor \"fraction\".  Values\n"
"                       less than 1 shrink the fb, larger ones expand it.  Note:\n"
"                       image may not be sharp and response may be slower.\n"
"                       If \"fraction\" contains a decimal point \".\" it\n"
"                       is taken as a floating point number, alternatively\n"
"                       the notation \"m/n\" may be used to denote fractions\n"
"                       exactly, e.g. -scale 2/3\n"
"\n"
"                       Scaling Options: can be added after \"fraction\" via\n"
"                       \":\", to supply multiple \":\" options use commas.\n"
"                       If you just want a quick, rough scaling without\n"
"                       blending, append \":nb\" to \"fraction\" (e.g. -scale\n"
"                       1/3:nb).  No blending is the default for 8bpp indexed\n"
"                       color, to force blending for this case use \":fb\".\n"
"\n"
"                       To disable -scrollcopyrect and -wirecopyrect under\n"
"                       -scale use \":nocr\".  If you need to to enable them use\n"
"                       \":cr\" or specify them explicitly on the command line.\n"
"                       If a slow link is detected, \":nocr\" may be applied\n"
"                       automatically.  Default: %s\n"
"\n"
"                       More esoteric options: for compatibility with vncviewers\n"
"                       the scaled width is adjusted to be a multiple of 4:\n"
"                       to disable this use \":n4\".  \":in\" use interpolation\n"
"                       scheme even when shrinking, \":pad\" pad scaled width\n"
"                       and height to be multiples of scaling denominator\n"
"                       (e.g. 3 for 2/3).\n"
"\n"
"-scale_cursor frac     By default if -scale is supplied the cursor shape is\n"
"                       scaled by the same factor.  Depending on your usage,\n"
"                       you may want to scale the cursor independently of the\n"
"                       screen or not at all.  If you specify -scale_cursor\n"
"                       the cursor will be scaled by that factor.  When using\n"
"                       -scale mode to keep the cursor at its \"natural\" size\n"
"                       use \"-scale_cursor 1\".  Most of the \":\" scaling\n"
"                       options apply here as well.\n"
"\n"
"-viewonly              All VNC clients can only watch (default %s).\n"
"-shared                VNC display is shared, i.e. more than one viewer can\n"
"                       connect at the same time (default %s).\n"
"-once                  Exit after the first successfully connected viewer\n"
"                       disconnects, opposite of -forever. This is the Default.\n"
"-forever               Keep listening for more connections rather than exiting\n"
"                       as soon as the first client(s) disconnect. Same as -many\n"
"-loop                  Create an outer loop restarting the x11vnc process\n"
"                       whenever it terminates.  -bg and -inetd are ignored in\n"
"                       this mode.  Useful for continuing even if the X server\n"
"                       terminates and restarts (you will need permission to\n"
"                       reconnect of course).   Use, e.g., -loop100 to sleep\n"
"                       100 millisecs between restarts, etc.  Default is 2000ms\n"
"                       (i.e. 2 secs)  Use, e.g. -loop300,5 to sleep 300 ms\n"
"                       and only loop 5 times.\n"
"-timeout n             Exit unless a client connects within the first n seconds\n"
"                       after startup.\n"
"-inetd                 Launched by inetd(1): stdio instead of listening socket.\n"
"                       Note: if you are not redirecting stderr to a log file\n"
"                       (via shell 2> or -o option) you MUST also specify the -q\n"
"                       option, otherwise the stderr goes to the viewer which\n"
"                       will cause it to abort.  Specifying both -inetd and -q\n"
"                       and no -o will automatically close the stderr.\n"
"-nofilexfer            Disable the TightVNC file transfer extension.  (same as\n"
"                       -disablefiletransfer).  Note that when the -viewonly\n"
"                       option is supplied all file transfers are disabled.\n"
"                       Also clients that log in viewonly cannot transfer files.\n"
"                       However, if the remote control mechanism is used to\n"
"                       change the global or per-client viewonly state the\n"
"                       filetransfer permissions will NOT change.\n"
"-http                  Instead of using -httpdir (see below) to specify\n"
"                       where the Java vncviewer applet is, have x11vnc try\n"
"                       to *guess* where the directory is by looking relative\n"
"                       to the program location and in standard locations\n"
"                       (/usr/local/share/x11vnc/classes, etc).\n"
"-connect string        For use with \"vncviewer -listen\" reverse connections.\n"
"                       If \"string\" has the form \"host\" or \"host:port\"\n"
"                       the connection is made once at startup.  Use commas\n"
"                       for a list of host's and host:port's.\n"
"\n"
"                       If \"string\" contains \"/\" it is instead interpreted\n"
"                       as a file to periodically check for new hosts.\n"
"                       The first line is read and then the file is truncated.\n"
"                       Be careful for this usage mode if x11vnc is running as\n"
"                       root (e.g. via gdm(1), etc).\n"
"-vncconnect            Monitor the VNC_CONNECT X property set by the standard\n"
"-novncconnect          VNC program vncconnect(1).  When the property is\n"
"                       set to \"host\" or \"host:port\" establish a reverse\n"
"                       connection.  Using xprop(1) instead of vncconnect may\n"
"                       work (see the FAQ).  The -remote control mechanism also\n"
"                       uses this VNC_CONNECT channel.  Default: %s\n"
"\n"
"-allow host1[,host2..] Only allow client connections from hosts matching\n"
"                       the comma separated list of hostnames or IP addresses.\n"
"                       Can also be a numerical IP prefix, e.g. \"192.168.100.\"\n"
"                       to match a simple subnet, for more control build\n"
"                       libvncserver with libwrap support (See the FAQ).  If the\n"
"                       list contains a \"/\" it instead is a interpreted as a\n"
"                       file containing addresses or prefixes that is re-read\n"
"                       each time a new client connects.  Lines can be commented\n"
"                       out with the \"#\" character in the usual way.\n"
"-localhost             Same as \"-allow 127.0.0.1\".\n"
"\n"
"                       Note: if you want to restrict which network interface\n"
"                       x11vnc listens on, see the -listen option below.\n"
"                       E.g. \"-listen localhost\" or \"-listen 192.168.3.21\".\n"
"                       As a special case, the option \"-localhost\" implies\n"
"                       \"-listen localhost\".\n"
"\n"
"                       For non-localhost -listen usage, if you use the remote\n"
"                       control mechanism (-R) to change the -listen interface\n"
"                       you may need to manually adjust the -allow list (and\n"
"                       vice versa) to avoid situations where no connections\n"
"                       (or too many) are allowed.\n"
"\n"
"-nolookup              Do not use gethostbyname() or gethostbyaddr() to look up\n"
"                       host names or IP numbers.  Use this if name resolution\n"
"                       is incorrectly set up and leads to long pauses as name\n"
"                       lookups time out, etc.\n"
"\n"
"-input string          Fine tuning of allowed user input.  If \"string\" does\n"
"                       not contain a comma \",\" the tuning applies only to\n"
"                       normal clients.  Otherwise the part before \",\" is\n"
"                       for normal clients and the part after for view-only\n"
"                       clients.  \"K\" is for Keystroke input, \"M\" for\n"
"                       Mouse-motion input, and \"B\" for Button-click input.\n"
"                       Their presence in the string enables that type of input.\n"
"                       E.g. \"-input M\" means normal users can only move\n"
"                       the mouse and  \"-input KMB,M\" lets normal users do\n"
"                       anything and enables view-only users to move the mouse.\n"
"                       This option is ignored when a global -viewonly is in\n"
"                       effect (all input is discarded in that case).\n"
"\n"
"-viewpasswd string     Supply a 2nd password for view-only logins.  The -passwd\n"
"                       (full-access) password must also be supplied.\n"
"\n"
"-passwdfile filename   Specify the libvncserver password via the first line\n"
"                       of the file \"filename\" (instead of via -passwd on\n"
"                       the command line where others might see it via ps(1)).\n"
"                       See below for how to supply multiple passwords.\n"
"\n"
"                       If the filename is prefixed with \"rm:\" it will be\n"
"                       removed after being read.  Perhaps this is useful in\n"
"                       limiting the readability of the file.  In general,\n"
"                       the password file should not be readable by untrusted\n"
"                       users (BTW: neither should the VNC -rfbauth file:\n"
"                       it is NOT encrypted).\n"
"\n"
"                       If the filename is prefixed with \"read:\" it will\n"
"                       periodically be checked for changes and reread.\n"
"\n"
"                       Note that only the first 8 characters of a password\n"
"                       are used.\n"
"\n"
"                       If multiple non-blank lines exist in the file they are\n"
"                       all taken as valid passwords.  Blank lines are ignored.\n"
"                       Password lines may be \"commented out\" (ignored) if\n"
"                       they begin with the charactor \"#\" or the line contains\n"
"                       the string \"__SKIP__\".  Lines may be annotated by use\n"
"                       of the \"__COMM__\" string: from it to the end of the\n"
"                       line is ignored.  An empty password may be specified\n"
"                       via the \"__EMPTY__\" string on a line by itself (note\n"
"                       your viewer might not accept empty passwords).\n"
"\n"
"                       If the string \"__BEGIN_VIEWONLY__\" appears on a\n"
"                       line by itself, the remaining passwords are used for\n"
"                       viewonly access.  For compatibility, as a special case\n"
"                       if the file contains only two password lines the 2nd\n"
"                       one is automatically taken as the viewonly password.\n"
"                       Otherwise the \"__BEGIN_VIEWONLY__\" token must be\n"
"                       used to have viewonly passwords.  (tip: make the 3rd\n"
"                       and last line be \"__BEGIN_VIEWONLY__\" to have 2\n"
"                       full-access passwords)\n"

"-nopw                  Disable the big warning message when you use x11vnc\n"
"                       without some sort of password.\n"
"-storepasswd pass file Store password \"pass\" as the VNC password in the\n"
"                       file \"file\".  Once the password is stored the\n"
"                       program exits.  Use the password via \"-rfbauth file\"\n"
"\n"
"-accept string         Run a command (possibly to prompt the user at the\n"
"                       X11 display) to decide whether an incoming client\n"
"                       should be allowed to connect or not.  \"string\" is\n"
"                       an external command run via system(3) or some special\n"
"                       cases described below.  Be sure to quote \"string\"\n"
"                       if it contains spaces, shell characters, etc.  If the\n"
"                       external command returns 0 the client is accepted,\n"
"                       otherwise the client is rejected.  See below for an\n"
"                       extension to accept a client view-only.\n"
"\n"
"                       If x11vnc is running as root (say from inetd(1) or from\n"
"                       display managers xdm(1), gdm(1), etc), think about the\n"
"                       security implications carefully before supplying this\n"
"                       option (likewise for the -gone option).\n"
"\n"
"                       Environment: The RFB_CLIENT_IP environment variable will\n"
"                       be set to the incoming client IP number and the port\n"
"                       in RFB_CLIENT_PORT (or -1 if unavailable).  Similarly,\n"
"                       RFB_SERVER_IP and RFB_SERVER_PORT (the x11vnc side\n"
"                       of the connection), are set to allow identification\n"
"                       of the tcp virtual circuit.  The x11vnc process\n"
"                       id will be in RFB_X11VNC_PID, a client id number in\n"
"                       RFB_CLIENT_ID, and the number of other connected clients\n"
"                       in RFB_CLIENT_COUNT.  RFB_MODE will be \"accept\".\n"
"                       RFB_STATE will be PROTOCOL_VERSION, SECURITY_TYPE,\n"
"                       AUTHENTICATION, INITIALISATION, NORMAL, or UNKNOWN\n"
"                       indicating up to which state the client has acheived.\n"
"                       RFB_LOGIN_VIEWONLY will be 0, 1, or -1 (unknown).\n"
"                       RFB_USERNAME, RFB_LOGIN_TIME, and RFB_CURRENT_TIME may\n"
"                       also be set.\n"
"\n"
"                       If \"string\" is \"popup\" then a builtin popup window\n"
"                       is used.  The popup will time out after 120 seconds,\n"
"                       use \"popup:N\" to modify the timeout to N seconds\n"
"                       (use 0 for no timeout).\n"
"\n"
"                       If \"string\" is \"xmessage\" then an xmessage(1)\n"
"                       invocation is used for the command.  xmessage must be\n"
"                       installed on the machine for this to work.\n"
"\n"
"                       Both \"popup\" and \"xmessage\" will present an option\n"
"                       for accepting the client \"View-Only\" (the client\n"
"                       can only watch).  This option will not be presented if\n"
"                       -viewonly has been specified, in which case the entire\n"
"                       display is view only.\n"
"\n"
"                       If the user supplied command is prefixed with something\n"
"                       like \"yes:0,no:*,view:3 mycommand ...\" then this\n"
"                       associates the numerical command return code with\n"
"                       the actions: accept, reject, and accept-view-only,\n"
"                       respectively.  Use \"*\" instead of a number to indicate\n"
"                       the default action (in case the command returns an\n"
"                       unexpected value).  E.g. \"no:*\" is a good choice.\n"
"\n"
"                       Note that x11vnc blocks while the external command\n"
"                       or popup is running (other clients may see no updates\n"
"                       during this period).  So a person sitting a the physical\n"
"                       display is needed to respond to an popup prompt. (use\n"
"                       a 2nd x11vnc if you lock yourself out).\n"
"\n"
"                       More -accept tricks: use \"popupmouse\" to only allow\n"
"                       mouse clicks in the builtin popup to be recognized.\n"
"                       Similarly use \"popupkey\" to only recognize\n"
"                       keystroke responses.  These are to help avoid the\n"
"                       user accidentally accepting a client by typing or\n"
"                       clicking. All 3 of the popup keywords can be followed\n"
"                       by +N+M to supply a position for the popup window.\n"
"                       The default is to center the popup window.\n"
"-afteraccept string    As -accept, except to run a user supplied command after\n"
"                       a client has been accepted and authenticated. RFB_MODE\n"
"                       will be set to \"afteraccept\" and the other RFB_*\n"
"                       variables are as in -accept.  Unlike -accept, the\n"
"                       command return code is not interpreted by x11vnc.\n"
"                       Example: -afteraccept 'killall xlock &'\n"
"-gone string           As -accept, except to run a user supplied command when\n"
"                       a client goes away (disconnects).  RFB_MODE will be\n"
"                       set to \"gone\" and the other RFB_* variables are as\n"
"                       in -accept.  Unlike -accept, the command return code\n"
"                       is not interpreted by x11vnc.  Example: -gone 'xlock &'\n"
"\n"
"-users list            If x11vnc is started as root (say from inetd(1) or from\n"
"                       display managers xdm(1), gdm(1), etc), then as soon\n"
"                       as possible after connections to the X display are\n"
"                       established try to switch to one of the users in the\n"
"                       comma separated \"list\".  If x11vnc is not running as\n"
"                       root this option is ignored.\n"
"                       \n"
"                       Why use this option?  In general it is not needed since\n"
"                       x11vnc is already connected to the X display and can\n"
"                       perform its primary functions.  The option was added\n"
"                       to make some of the *external* utility commands x11vnc\n"
"                       occasionally runs work properly.  In particular under\n"
"                       GNOME and KDE to implement the \"-solid color\" feature\n"
"                       external commands (gconftool-2 and dcop) must be run\n"
"                       as the user owning the desktop session.  Since this\n"
"                       option switches userid it also affects the userid used\n"
"                       to run the processes for the -accept and -gone options.\n"
"                       It also affects the ability to read files for options\n"
"                       such as -connect, -allow, and -remap.  Note that the\n"
"                       -connect file is also sometimes written to.\n"
"                       \n"
"                       So be careful with this option since in many situations\n"
"                       its use can decrease security.\n"
"                       \n"
"                       The switch to a user will only take place if the\n"
"                       display can still be successfully opened as that user\n"
"                       (this is primarily to try to guess the actual owner\n"
"                       of the session). Example: \"-users fred,wilma,betty\".\n"
"                       Note that a malicious user \"barney\" by quickly using\n"
"                       \"xhost +\" when logging in may get x11vnc to switch\n"
"                       to user \"fred\".  What happens next?\n"
"                       \n"
"                       Under display managers it may be a long time before\n"
"                       the switch succeeds (i.e. a user logs in).  To make\n"
"                       it switch immediately regardless if the display\n"
"                       can be reopened prefix the username with the \"+\"\n"
"                       character. E.g. \"-users +bob\" or \"-users +nobody\".\n"
"                       The latter (i.e. switching immediately to user\n"
"                       \"nobody\") is probably the only use of this option\n"
"                       that increases security.\n"
"                       \n"
"                       To immediately switch to a user *before* connections\n"
"                       to the X display are made or any files opened use the\n"
"                       \"=\" character: \"-users =bob\".  That user needs to\n"
"                       be able to open the X display of course.\n"
"                       \n"
"                       The special user \"guess=\" means to examine the utmpx\n"
"                       database (see who(1)) looking for a user attached to\n"
"                       the display number (from DISPLAY or -display option)\n"
"                       and try him/her.  To limit the list of guesses, use:\n"
"                       \"-users guess=bob,betty\".\n"
"                       \n"
"                       Even more sinister is the special user \"lurk=\" that\n"
"                       means to try to guess the DISPLAY from the utmpx login\n"
"                       database as well.  So it \"lurks\" waiting for anyone\n"
"                       to log into an X session and then connects to it.\n"
"                       Specify a list of users after the = to limit which\n"
"                       users will be tried.  To enable a different searching\n"
"                       mode, if the first user in the list is something like\n"
"                       \":0\" or \":0-2\" that indicates a range of DISPLAY\n"
"                       numbers that will be tried (regardless of whether\n"
"                       they are in the utmpx database) for all users that\n"
"                       are logged in.  Examples: \"-users lurk=\" and also\n"
"                       \"-users lurk=:0-1,bob,mary\"\n"
"                       \n"
"                       Be especially careful using the \"guess=\" and \"lurk=\"\n"
"                       modes.  They are not recommended for use on machines\n"
"                       with untrustworthy local users.\n"
"                       \n"
"-noshm                 Do not use the MIT-SHM extension for the polling.\n"
"                       Remote displays can be polled this way: be careful this\n"
"                       can use large amounts of network bandwidth.  This is\n"
"                       also of use if the local machine has a limited number\n"
"                       of shm segments and -onetile is not sufficient.\n"
"-flipbyteorder         Sometimes needed if remotely polled host has different\n"
"                       endianness.  Ignored unless -noshm is set.\n"
"-onetile               Do not use the new copy_tiles() framebuffer mechanism,\n"
"                       just use 1 shm tile for polling.  Limits shm segments\n"
"                       used to 3.\n"
"\n"
"-solid [color]         To improve performance, when VNC clients are connected\n"
"                       try to change the desktop background to a solid color.\n"
"                       The [color] is optional: the default color is \"cyan4\".\n"
"                       For a different one specify the X color (rgb.txt name,\n"
"                       e.g. \"darkblue\" or numerical \"#RRGGBB\").\n"
"\n"
"                       Currently this option only works on GNOME, KDE, CDE,\n"
"                       and classic X (i.e. with the background image on the\n"
"                       root window).  The \"gconftool-2\" and \"dcop\" external\n"
"                       commands are run for GNOME and KDE respectively.\n"
"                       Other desktops won't work, e.g. Xfce (send us the\n"
"                       corresponding commands if you find them).  If x11vnc is\n"
"                       running as root (inetd(1) or gdm(1)), the -users option\n"
"                       may be needed for GNOME and KDE.  If x11vnc guesses\n"
"                       your desktop incorrectly, you can force it by prefixing\n"
"                       color with \"gnome:\", \"kde:\", \"cde:\" or \"root:\".\n"
"-blackout string       Black out rectangles on the screen. \"string\" is a\n"
"                       comma separated list of WxH+X+Y type geometries for\n"
"                       each rectangle.  If one of the items on the list is the\n"
"                       string \"noptr\" the mouse pointer will not be allowed\n"
"                       to go into a blacked out region.\n"
"-xinerama              If your screen is composed of multiple monitors\n"
"                       glued together via XINERAMA, and that screen is\n"
"                       not a rectangle this option will try to guess the\n"
"                       areas to black out (if your system has libXinerama).\n"
"\n"
"                       In general, we have noticed on XINERAMA displays you\n"
"                       may need to use the \"-xwarppointer\" option if the mouse\n"
"                       pointer misbehaves.\n"
"\n"
"-xtrap                 Use the DEC-XTRAP extension for keystroke and mouse\n"
"                       input insertion.  For use on legacy systems, e.g. X11R5,\n"
"                       running an incomplete or missing XTEST extension.\n"
"                       By default DEC-XTRAP will be used if XTEST server grab\n"
"                       control is missing, use -xtrap to do the keystroke and\n"
"                       mouse insertion via DEC-XTRAP as well.\n"
"\n"
"-xrandr [mode]         If the display supports the XRANDR (X Resize, Rotate\n"
"                       and Reflection) extension, and you expect XRANDR events\n"
"                       to occur to the display while x11vnc is running, this\n"
"                       options indicates x11vnc should try to respond to\n"
"                       them (as opposed to simply crashing by assuming the\n"
"                       old screen size).  See the xrandr(1) manpage and run\n"
"                       'xrandr -q' for more info.  [mode] is optional and\n"
"                       described below.\n"
"\n"
"                       Since watching for XRANDR events and trapping errors\n"
"                       increases polling overhead, only use this option if\n"
"                       XRANDR changes are expected.  For example on a rotatable\n"
"                       screen PDA or laptop, or using a XRANDR-aware Desktop\n"
"                       where you resize often.  It is best to be viewing with a\n"
"                       vncviewer that supports the NewFBSize encoding, since it\n"
"                       knows how to react to screen size changes.  Otherwise,\n"
"                       libvncserver tries to do so something reasonable for\n"
"                       viewers that cannot do this (portions of the screen\n"
"                       may be clipped, unused, etc).\n"
"\n"
"                       \"mode\" defaults to \"resize\", which means create a\n"
"                       new, resized, framebuffer and hope all viewers can cope\n"
"                       with the change.  \"newfbsize\" means first disconnect\n"
"                       all viewers that do not support the NewFBSize VNC\n"
"                       encoding, and then resize the framebuffer.  \"exit\"\n"
"                       means disconnect all viewer clients, and then terminate\n"
"                       x11vnc.\n"
"-padgeom WxH           Whenever a new vncviewer connects, the framebuffer is\n"
"                       replaced with a fake, solid black one of geometry WxH.\n"
"                       Shortly afterwards the framebuffer is replaced with the\n"
"                       real one.  This is intended for use with vncviewers\n"
"                       that do not support NewFBSize and one wants to make\n"
"                       sure the initial viewer geometry will be big enough\n"
"                       to handle all subsequent resizes (e.g. under -xrandr,\n"
"                       -remote id:windowid, rescaling, etc.)\n"
"\n"
"-o logfile             Write stderr messages to file \"logfile\" instead of\n"
"                       to the terminal.  Same as \"-logfile file\".  To append\n"
"                       to the file use \"-oa file\" or \"-logappend file\".\n"
"-flag file             Write the \"PORT=NNNN\" (e.g. PORT=5900) string to\n"
"                       \"file\" in addition to stdout.  This option could be\n"
"                       useful by wrapper script to detect when x11vnc is ready.\n"
"\n"
"-rc filename           Use \"filename\" instead of $HOME/.x11vncrc for rc file.\n"
"-norc                  Do not process any .x11vncrc file for options.\n"
"\n"
"-h, -help              Print this help text.\n"
"-?, -opts              Only list the x11vnc options.\n"
"-V, -version           Print program version and last modification date.\n"
"\n"
"-dbg                   Instead of exiting after cleaning up, run a simple\n"
"                       \"debug crash shell\" when fatal errors are trapped.\n"
"\n"
"-q                     Be quiet by printing less informational output to\n"
"                       stderr.  Same as -quiet.\n"
"-bg                    Go into the background after screen setup.  Messages to\n"
"                       stderr are lost unless -o logfile is used.  Something\n"
"                       like this could be useful in a script:\n"
"                         port=`ssh $host \"x11vnc -display :0 -bg\" | grep PORT`\n"
"                         port=`echo \"$port\" | sed -e 's/PORT=//'`\n"
"                         port=`expr $port - 5900`\n"
"                         vncviewer $host:$port\n"
"\n"
"-modtweak              Option -modtweak automatically tries to adjust the AltGr\n"
"-nomodtweak            and Shift modifiers for differing language keyboards\n"
"                       between client and host.  Otherwise, only a single key\n"
"                       press/release of a Keycode is simulated (i.e. ignoring\n"
"                       the state of the modifiers: this usually works for\n"
"                       identical keyboards).  Also useful in resolving cases\n"
"                       where a Keysym is bound to multiple keys (e.g. \"<\" + \">\"\n"
"                       and \",\" + \"<\" keys).  Default: %s\n"
"-xkb                   When in modtweak mode, use the XKEYBOARD extension (if\n"
"-noxkb                 the X display supports it) to do the modifier tweaking.\n"
"                       This is powerful and should be tried if there are still\n"
"                       keymapping problems when using -modtweak by itself.\n"
"                       The default is to check whether some common keysyms,\n"
"                       e.g. !, @, [, are only accessible via -xkb mode and if\n"
"                       so then automatically enable the mode.  To disable this\n"
"                       automatic detection use -noxkb.\n"
"-skip_keycodes string  Ignore the comma separated list of decimal keycodes.\n"
"                       Perhaps these are keycodes not on your keyboard but\n"
"                       your X server thinks exist.  Currently only applies\n"
"                       to -xkb mode.  Use this option to help x11vnc in the\n"
"                       reverse problem it tries to solve: Keysym -> Keycode(s)\n"
"                       when ambiguities exist (more than one Keycode per\n"
"                       Keysym).  Run 'xmodmap -pk' to see your keymapping.\n"
"                       Example: \"-skip_keycodes 94,114\"\n"
"-sloppy_keys           Experimental option that tries to correct some\n"
"                       \"sloppy\" key behavior.  E.g. if at the viewer you\n"
"                       press Shift+Key but then release the Shift before\n"
"                       Key that could give rise to extra unwanted characters\n"
"                       (usually only between keyboards of different languages).\n"
"                       Only use this option if you observe problems with\n"
"                       some keystrokes.\n"
"-skip_dups             Some VNC viewers send impossible repeated key events,\n"
"-noskip_dups           e.g. key-down, key-down, key-up, key-up all for the same\n"
"                       key, or 20 downs in a row for the same modifier key!\n"
"                       Setting -skip_dups means to skip these duplicates and\n"
"                       just process the first event. Note: some VNC viewers\n"
"                       assume they can send down's without the corresponding\n"
"                       up's and so you should not set this option for\n"
"                       these viewers (symptom: some keys do not autorepeat)\n"
"                       Default: %s\n"
"-add_keysyms           If a Keysym is received from a VNC viewer and that\n"
"-noadd_keysyms         Keysym does not exist in the X server, then add the\n"
"                       Keysym to the X server's keyboard mapping on an unused\n"
"                       key.  Added Keysyms will be removed periodically and\n"
"                       also when x11vnc exits.  Default: %s\n"
#if 0
"-xkbcompat             Ignore the XKEYBOARD extension.  Use as a workaround for\n"
"                       some keyboard mapping problems.  E.g. if you are using\n"
"                       an international keyboard (AltGr or ISO_Level3_Shift),\n"
"                       and the OS or keyboard where the VNC viewer is run\n"
"                       is not identical to that of the X server, and you are\n"
"                       having problems typing some keys.  Implies -nobell.\n"
#endif
"-clear_mods            At startup and exit clear the modifier keys by sending\n"
"                       KeyRelease for each one. The Lock modifiers are skipped.\n"
"                       Used to clear the state if the display was accidentally\n"
"                       left with any pressed down.\n"
"-clear_keys            As -clear_mods, except try to release any pressed key.\n"
"                       Note that this option and -clear_mods can interfere\n"
"                       with a person typing at the physical keyboard.\n"
"-remap string          Read Keysym remappings from file named \"string\".\n"
"                       Format is one pair of Keysyms per line (can be name\n"
"                       or hex value) separated by a space.  If no file named\n"
"                       \"string\" exists, it is instead interpreted as this\n"
"                       form: key1-key2,key3-key4,...  See <X11/keysymdef.h>\n"
"                       header file for a list of Keysym names, or use xev(1).\n"
"                       To map a key to a button click, use the fake Keysyms\n"
"                       \"Button1\", ..., etc. E.g: \"-remap Super_R-Button2\"\n"
"                       (useful for pasting on a laptop)\n"
"\n"
"                       Dead keys: \"dead\" (or silent, mute) keys are keys that\n"
"                       do not produce a character but must be followed by a 2nd\n"
"                       keystroke.  This is often used for accenting characters,\n"
"                       e.g. to put \"`\" on top of \"a\" by pressing the dead\n"
"                       key and then \"a\".  Note that this interpretation\n"
"                       is not part of core X11, it is up to the toolkit or\n"
"                       application to decide how to react to the sequence.\n"
"                       The X11 names for these keysyms are \"dead_grave\",\n"
"                       \"dead_acute\", etc.  However some VNC viewers send the\n"
"                       keysyms \"grave\", \"acute\" instead thereby disabling\n"
"                       the accenting.  To work around this -remap can be used.\n"
"                       For example \"-remap grave-dead_grave,acute-dead_acute\"\n"
"                       As a convenience, \"-remap DEAD\" applies these remaps:\n"
"\n"
"                               g     grave-dead_grave\n"
"                               a     acute-dead_acute\n"
"                               c     asciicircum-dead_circumflex\n"
"                               t     asciitilde-dead_tilde\n"
"                               m     macron-dead_macron\n"
"                               b     breve-dead_breve\n"
"                               D     abovedot-dead_abovedot\n"
"                               d     diaeresis-dead_diaeresis\n"
"                               o     degree-dead_abovering\n"
"                               A     doubleacute-dead_doubleacute\n"
"                               r     caron-dead_caron\n"
"                               e     cedilla-dead_cedilla\n"
"\n"
"                       If you just want a subset use the first letter\n"
"                       label, e.g. \"-remap DEAD=ga\" to get the first two.\n"
"                       Additional remaps may also be supplied via commas,\n"
"                       e.g.  \"-remap DEAD=ga,Super_R-Button2\".  Finally,\n"
"                       \"DEAD=missing\" means to apply all of the above as\n"
"                       long as the left hand member is not already in the\n"
"                       X11 keymap.\n"
"\n"
"-norepeat              Option -norepeat disables X server key auto repeat when\n"
"-repeat                VNC clients are connected and VNC keyboard input is\n"
"                       not idle for more than 5 minutes.  This works around a\n"
"                       repeating keystrokes bug (triggered by long processing\n"
"                       delays between key down and key up client events: either\n"
"                       from large screen changes or high latency).\n"
"                       Default: %s\n"
"\n"
"                       Note: your VNC viewer side will likely do autorepeating,\n"
"                       so this is no loss unless someone is simultaneously at\n"
"                       the real X display.\n"
"\n"
"                       Use \"-norepeat N\" to set how many times norepeat will\n"
"                       be reset if something else (e.g. X session manager)\n"
"                       undoes it.  The default is 2.  Use a negative value\n"
"                       for unlimited resets.\n"
"\n"
"-nofb                  Ignore video framebuffer: only process keyboard and\n"
"                       pointer.  Intended for use with Win2VNC and x2vnc\n"
"                       dual-monitor setups.\n"
"-nobell                Do not watch for XBell events. (no beeps will be heard)\n"
"                       Note: XBell monitoring requires the XKEYBOARD extension.\n"
"-nosel                 Do not manage exchange of X selection/cutbuffer between\n"
"                       VNC viewers and the X server.\n"
"-noprimary             Do not poll the PRIMARY selection for changes to send\n"
"                       back to clients.  (PRIMARY is still set on received\n"
"                       changes, however).\n"
"-seldir string         If direction string is \"send\", only send the selection\n"
"                       to viewers, and if it is \"recv\" only receive it from\n"
"                       viewers.  To work around apps setting the selection\n"
"                       too frequently and messing up the other end.  You can\n"
"                       actually supply a comma separated list of directions,\n"
"                       including \"debug\" to turn on debugging output.\n"
"\n"
"-cursor [mode]         Sets how the pointer cursor shape (little icon at the\n"
"-nocursor              mouse pointer) should be handled.  The \"mode\" string\n"
"                       is optional and is described below.  The default\n"
"                       is to show some sort of cursor shape(s).  How this\n"
"                       is done depends on the VNC viewer and the X server.\n"
"                       Use -nocursor to disable cursor shapes completely.\n"
"\n"
"                       Some VNC viewers support the TightVNC CursorPosUpdates\n"
"                       and CursorShapeUpdates extensions (cuts down on\n"
"                       network traffic by not having to send the cursor image\n"
"                       every time the pointer is moved), in which case these\n"
"                       extensions are used (see -nocursorshape and -nocursorpos\n"
"                       below to disable).  For other viewers the cursor shape\n"
"                       is written directly to the framebuffer every time the\n"
"                       pointer is moved or changed and gets sent along with\n"
"                       the other framebuffer updates.  In this case, there\n"
"                       will be some lag between the vnc viewer pointer and\n"
"                       the remote cursor position.\n"
"\n"
"                       If the X display supports retrieving the cursor shape\n"
"                       information from the X server, then the default is\n"
"                       to use that mode.  On Solaris this can be done with\n"
"                       the SUN_OVL extension using -overlay (see also the\n"
"                       -overlay_nocursor option).  A similar overlay scheme\n"
"                       is used on IRIX.  Xorg (e.g. Linux) and recent Solaris\n"
"                       Xsun servers support the XFIXES extension to retrieve\n"
"                       the exact cursor shape from the X server.  If XFIXES\n"
"                       is present it is preferred over Overlay and is used by\n"
"                       default (see -noxfixes below).  This can be disabled\n"
"                       with -nocursor, and also some values of the \"mode\"\n"
"                       option below.\n"
"                       \n"
"                       Note that under XFIXES cursors with transparency (alpha\n"
"                       channel) will usually not be exactly represented and one\n"
"                       may find Overlay preferable.  See also the -alphacut\n"
"                       and -alphafrac options below as fudge factors to try\n"
"                       to improve the situation for cursors with transparency\n"
"                       for a given theme.\n"
"\n"
"                       The \"mode\" string can be used to fine-tune the\n"
"                       displaying of cursor shapes.  It can be used the\n"
"                       following ways:\n"
"\n"
"                       \"-cursor arrow\" - just show the standard arrow\n"
"                       nothing more or nothing less.\n"
"\n"
"                       \"-cursor none\" - same as \"-nocursor\"\n"
"\n"
"                       \"-cursor X\" - when the cursor appears to be on the\n"
"                       root window, draw the familiar X shape.  Some desktops\n"
"                       such as GNOME cover up the root window completely,\n"
"                       and so this will not work, try \"X1\", etc, to try to\n"
"                       shift the tree depth.  On high latency links or slow\n"
"                       machines there will be a time lag between expected and\n"
"                       the actual cursor shape.\n"
"\n"
"                       \"-cursor some\" - like \"X\" but use additional\n"
"                       heuristics to try to guess if the window should have\n"
"                       a windowmanager-like resizer cursor or a text input\n"
"                       I-beam cursor.  This is a complete hack, but may be\n"
"                       useful in some situations because it provides a little\n"
"                       more feedback about the cursor shape.\n"
"\n"
"                       \"-cursor most\" - try to show as many cursors as\n"
"                       possible.  Often this will only be the same as \"some\"\n"
"                       unless the display has overlay visuals or XFIXES\n"
"                       extensions available.  On Solaris and IRIX if XFIXES\n"
"                       is not available, -overlay mode will be attempted.\n"
"\n"
"-arrow n               Choose an alternate \"arrow\" cursor from a set of\n"
"                       some common ones.  n can be 1 to %d.  Default is: %d\n"
"                       Ignored when in XFIXES cursor-grabbing mode.\n"
"\n"
"-noxfixes              Do not use the XFIXES extension to draw the exact cursor\n"
"                       shape even if it is available.\n"
"-alphacut n            When using the XFIXES extension for the cursor shape,\n"
"                       cursors with transparency will not usually be displayed\n"
"                       exactly (but opaque ones will).  This option sets n as\n"
"                       a cutoff for cursors that have transparency (\"alpha\n"
"                       channel\" with values ranging from 0 to 255) Any cursor\n"
"                       pixel with alpha value less than n becomes completely\n"
"                       transparent.  Otherwise the pixel is completely opaque.\n"
"                       Default %d\n"
"                       \n"
"-alphafrac fraction    With the threshold in -alphacut some cursors will become\n"
"                       almost completely transparent because their alpha values\n"
"                       are not high enough.  For those cursors adjust the\n"
"                       alpha threshold until fraction of the non-zero alpha\n"
"                       channel pixels become opaque.  Default %.2f\n"
"-alpharemove           By default, XFIXES cursors pixels with transparency have\n"
"                       the alpha factor multiplied into the RGB color values\n"
"                       (i.e. that corresponding to blending the cursor with a\n"
"                       black background).  Specify this option to remove the\n"
"                       alpha factor. (useful for light colored semi-transparent\n"
"                       cursors).\n"
"-noalphablend          In XFIXES mode do not send cursor alpha channel data\n"
"                       to libvncserver.  The default is to send it.  The\n"
"                       alphablend effect will only be visible in -nocursorshape\n"
"                       mode or for clients with cursorshapeupdates turned\n"
"                       off. (However there is a hack for 32bpp with depth 24,\n"
"                       it uses the extra 8 bits to store cursor transparency\n"
"                       for use with a hacked vncviewer that applies the\n"
"                       transparency locally.  See the FAQ for more info).\n"
"\n"
"-nocursorshape         Do not use the TightVNC CursorShapeUpdates extension\n"
"                       even if clients support it.  See -cursor above.\n"
"-cursorpos             Option -cursorpos enables sending the X cursor position\n"
"-nocursorpos           back to all vnc clients that support the TightVNC\n"
"                       CursorPosUpdates extension.  Other clients will be able\n"
"                       to see the pointer motions. Default: %s\n"
"-xwarppointer          Move the pointer with XWarpPointer(3X) instead of\n"
"                       the XTEST extension.  Use this as a workaround\n"
"                       if the pointer motion behaves incorrectly, e.g.\n"
"                       on touchscreens or other non-standard setups.\n"
"                       Also sometimes needed on XINERAMA displays.\n"
"\n"
"-buttonmap string      String to remap mouse buttons.  Format: IJK-LMN, this\n"
"                       maps buttons I -> L, etc., e.g.  -buttonmap 13-31\n"
"\n"
"                       Button presses can also be mapped to keystrokes: replace\n"
"                       a button digit on the right of the dash with :<sym>:\n"
"                       or :<sym1>+<sym2>: etc. for multiple keys. For example,\n"
"                       if the viewing machine has a mouse-wheel (buttons 4 5)\n"
"                       but the x11vnc side does not, these will do scrolls:\n"
"                              -buttonmap 12345-123:Prior::Next:\n"
"                              -buttonmap 12345-123:Up+Up+Up::Down+Down+Down:\n"
"\n"
"                       See <X11/keysymdef.h> header file for a list of Keysyms,\n"
"                       or use the xev(1) program.  Note: mapping of button\n"
"                       clicks to Keysyms may not work if -modtweak or -xkb is\n"
"                       needed for the Keysym.\n"
"\n"
"                       If you include a modifier like \"Shift_L\" the\n"
"                       modifier's up/down state is toggled, e.g. to send\n"
"                       \"The\" use :Shift_L+t+Shift_L+h+e: (the 1st one is\n"
"                       shift down and the 2nd one is shift up). (note: the\n"
"                       initial state of the modifier is ignored and not reset)\n"
"                       To include button events use \"Button1\", ... etc.\n"
"\n"
"-nodragging            Do not update the display during mouse dragging events\n"
"                       (mouse button held down).  Greatly improves response on\n"
"                       slow setups, but you lose all visual feedback for drags,\n"
"                       text selection, and some menu traversals.  It overrides\n"
"                       any -pointer_mode setting.\n"
"\n"
"-wireframe [str]       Try to detect window moves or resizes when a mouse\n"
"-nowireframe           button is held down and show a wireframe instead of\n"
"                       the full opaque window.  This is based completely on\n"
"                       heuristics and may not always work: it depends on your\n"
"                       window manager and even how you move things around.\n"
"                       See -pointer_mode below for discussion of the \"bogging\n"
"                       down\" problem this tries to avoid.\n"
"                       Default: %s\n"
"\n"
"                       Shorter aliases:  -wf [str]  and -nowf\n"
"\n"
"                       The value \"str\" is optional and, of course, is\n"
"                       packed with many tunable parameters for this scheme:\n"
"\n"
"                       Format: shade,linewidth,percent,T+B+L+R,mod,t1+t2+t3+t4\n"
"                       Default: %s\n"
"\n"
"                       If you leave nothing between commas: \",,\" the default\n"
"                       value is used.  If you don't specify enough commas,\n"
"                       the trailing parameters are set to their defaults.\n"
"\n"
"                       \"shade\" indicate the \"color\" for the wireframe,\n"
"                       usually a greyscale: 0-255, however for 16 and 32bpp you\n"
"                       can specify an rgb.txt X color (e.g. \"dodgerblue\") or\n"
"                       a value > 255 is treated as RGB (e.g. red is 0xff0000).\n"
"                       \"linewidth\" sets the width of the wireframe in pixels.\n"
"                       \"percent\" indicates to not apply the wireframe scheme\n"
"                       to windows with area less than this percent of the\n"
"                       full screen.\n"
"\n"
"                       \"T+B+L+R\" indicates four integers for how close in\n"
"                       pixels the pointer has to be from the Top, Bottom, Left,\n"
"                       or Right edges of the window to consider wireframing.\n"
"                       This is a speedup to quickly exclude a window from being\n"
"                       wireframed: set them all to zero to not try the speedup\n"
"                       (scrolling and selecting text will likely be slower).\n"
"\n"
"                       \"mod\" specifies if a button down event in the\n"
"                       interior of the window with a modifier key (Alt, Shift,\n"
"                       etc.) down should indicate a wireframe opportunity.\n"
"                       It can be \"0\" or \"none\" to skip it, \"1\" or \"all\"\n"
"                       to apply it to any modifier, or \"Shift\", \"Alt\",\n"
"                       \"Control\", \"Meta\", \"Super\", or \"Hyper\" to only\n"
"                       apply for that type of modifier key.\n"
"\n"
"                       \"t1+t2+t3+t4\" specify four floating point times in\n"
"                       seconds: t1 is how long to wait for the pointer to move,\n"
"                       t2 is how long to wait for the window to start moving\n"
"                       or being resized (for some window managers this can be\n"
"                       rather long), t3 is how long to keep a wireframe moving\n"
"                       before repainting the window. t4 is the minimum time\n"
"                       between sending wireframe \"animations\".  If a slow\n"
"                       link is detected, these values may be automatically\n"
"                       changed to something better for a slow link.\n"
"\n"
"-wirecopyrect mode     Since the -wireframe mechanism evidently tracks moving\n"
"-nowirecopyrect        windows accurately, a speedup can be obtained by\n"
"                       telling the VNC viewers to locally copy the translated\n"
"                       window region.  This is the VNC CopyRect encoding:\n"
"                       the framebuffer update doesn't need to send the actual\n"
"                       new image data.\n"
"\n"
"                       Shorter aliases:  -wcr [mode]  and -nowcr\n"
"\n"
"                       \"mode\" can be \"never\" (same as -nowirecopyrect)\n"
"                       to never try the copyrect, \"top\" means only do it if\n"
"                       the window was not covered by any other windows, and\n"
"                       \"always\" means to translate the orginally unobscured\n"
"                       region (this may look odd as the remaining pieces come\n"
"                       in, but helps on a slow link).  Default: \"%s\"\n"
"\n"
"                       Note: there can be painting errors or slow response\n"
"                       when using -scale so you may want to disable CopyRect\n"
"                       in this case \"-wirecopyrect never\" on the command\n"
"                       line or by remote-control.  Or you can also use the\n"
"                       \"-scale xxx:nocr\" scale option.\n"
"\n"
"-debug_wireframe       Turn on debugging info printout for the wireframe\n"
"                       heuristics.  \"-dwf\" is an alias.  Specify multiple\n"
"                       times for more output.\n"
"\n"
"-scrollcopyrect mode   Like -wirecopyrect, but use heuristics to try to guess\n"
"-noscrollcopyrect      if a window has scrolled its contents (either vertically\n"
"                       or horizontally).  This requires the RECORD X extension\n"
"                       to \"snoop\" on X applications (currently for certain\n"
"                       XCopyArea and XConfigureWindow X protocol requests).\n"
"                       Examples: Hitting <Return> in a terminal window when the\n"
"                       cursor was at the bottom, the text scrolls up one line.\n"
"                       Hitting <Down> arrow in a web browser window, the web\n"
"                       page scrolls up a small amount.  Or scrolling with a\n"
"                       scrollbar or mouse wheel.\n"
"\n"
"                       Shorter aliases:  -scr [mode]  and -noscr\n"
"\n"
"                       This scheme will not always detect scrolls, but when\n"
"                       it does there is a nice speedup from using the VNC\n"
"                       CopyRect encoding (see -wirecopyrect).  The speedup\n"
"                       is both in reduced network traffic and reduced X\n"
"                       framebuffer polling/copying.  On the other hand, it may\n"
"                       induce undesired transients (e.g. a terminal cursor\n"
"                       being scrolled up when it should not be) or other\n"
"                       painting errors (window tearing, bunching-up, etc).\n"
"                       These are automatically repaired in a short period\n"
"                       of time.  If this is unacceptable disable the feature\n"
"                       with -noscrollcopyrect.\n"
"\n"
"                       Screen clearing kludges:  for testing at least, there\n"
"                       are some \"magic key sequences\" (must be done in less\n"
"                       than 1 second) to aid repairing painting errors that\n"
"                       may be seen when using this mode:\n"
"\n"
"                       3 Alt_L's   in a row: resend whole screen,\n"
"                       4 Alt_L's   in a row: reread and resend whole screen,\n"
"                       3 Super_L's in a row: mark whole screen for polling,\n"
"                       4 Super_L's in a row: reset RECORD context,\n"
"                       5 Super_L's in a row: try to push a black screen\n"
"\n"
"                       note: Alt_L is the Left \"Alt\" key (a single key)\n"
"                       Super_L is the Left \"Super\" key (Windows flag).\n"
"                       Both of these are modifier keys, and so should not\n"
"                       generate characters when pressed by themselves.  Also,\n"
"                       your VNC viewer may have its own refresh hot-key\n"
"                       or button.\n"
"\n"
"                       \"mode\" can be \"never\" (same as -noscrollcopyrect)\n"
"                       to never try the copyrect, \"keys\" means to try it\n"
"                       in response to keystrokes only, \"mouse\" means to\n"
"                       try it in response to mouse events only, \"always\"\n"
"                       means to do both. Default: \"%s\"\n"
"\n"
"                       Note: there can be painting errors or slow response\n"
"                       when using -scale so you may want to disable CopyRect\n"
"                       in this case \"-scrollcopyrect never\" on the command\n"
"                       line or by remote-control.  Or you can also use the\n"
"                       \"-scale xxx:nocr\" scale option.\n"
"\n"
"-scr_area n            Set the minimum area in pixels for a rectangle\n"
"                       to be considered for the -scrollcopyrect detection\n"
"                       scheme.  This is to avoid wasting the effort on small\n"
"                       rectangles that would be quickly updated the normal way.\n"
"                       E.g. suppose an app updated the position of its skinny\n"
"                       scrollbar first and then shifted the large panel\n"
"                       it controlled.  We want to be sure to skip the small\n"
"                       scrollbar and get the large panel. Default: %d\n"
"\n"
"-scr_skip list         Skip scroll detection for applications matching\n"
"                       the comma separated list of strings in \"list\".\n"
"                       Some applications implement their scrolling in\n"
"                       strange ways where the XCopyArea, etc, also applies\n"
"                       to invisible portions of the window: if we CopyRect\n"
"                       those areas it looks awful during the scroll and\n"
"                       there may be painting errors left after the scroll.\n"
"                       Soffice.bin is the worst known offender.\n"
"\n"
"                       Use \"##\" to denote the start of the application class\n"
"                       (e.g. \"##XTerm\") and \"++\" to denote the start\n"
"                       of the application instance name (e.g. \"++xterm\").\n"
"                       The string your list is matched against is of the form\n"
"                       \"^^WM_NAME##Class++Instance<same-for-any-subwindows>\"\n"
"                       The \"xlsclients -la\" command will provide this info.\n"
"\n"
"                       If a pattern is prefixed with \"KEY:\" it only applies\n"
"                       to Keystroke generated scrolls (e.g. Up arrow).  If it\n"
"                       is prefixed with \"MOUSE:\" it only applies to Mouse\n"
"                       induced scrolls (e.g. dragging on a scrollbar).\n"
"                       Default: %s\n"
"\n"
"-scr_inc list          Opposite of -scr_skip: this list is consulted first\n"
"                       and if there is a match the window will be monitored\n"
"                       via RECORD for scrolls irrespective of -scr_skip.\n"
"                       Use -scr_skip '*' to skip anything that does not match\n"
"                       your -scr_inc.  Use -scr_inc '*' to include everything.\n"
"\n"
"-scr_keys list         For keystroke scroll detection, only apply the RECORD\n"
"                       heuristics to the comma separated list of keysyms in\n"
"                       \"list\".  You may find the RECORD overhead for every\n"
"                       one of your keystrokes disrupts typing too much, but you\n"
"                       don't want to turn it off completely with \"-scr mouse\"\n"
"                       and -scr_parms does not work or is too confusing.\n"
"\n"
"                       The listed keysyms can be numeric or the keysym\n"
"                       names in the <X11/keysymdef.h> header file or from the\n"
"                       xev(1) program.  Example: \"-scr_keys Up,Down,Return\".\n"
"                       One probably wants to have application specific lists\n"
"                       (e.g. for terminals, etc) but that is too icky to think\n"
"                       about for now...\n"
"\n"
"                       If \"list\" begins with the \"-\" character the list\n"
"                       is taken as an exclude list: all keysyms except those\n"
"                       list will be considered.  The special string \"builtin\"\n"
"                       expands to an internal list of keysyms that are likely\n"
"                       to cause scrolls.  BTW, by default modifier keys,\n"
"                       Shift_L, Control_R, etc, are skipped since they almost\n"
"                       never induce scrolling by themselves.\n"
"\n"
"-scr_term list         Yet another cosmetic kludge.  Apply shell/terminal\n"
"                       heuristics to applications matching comma separated\n"
"                       list (same as for -scr_skip/-scr_inc).  For example an\n"
"                       annoying transient under scroll detection is if you\n"
"                       hit Enter in a terminal shell with full text window,\n"
"                       the solid text cursor block will be scrolled up.\n"
"                       So for a short time there are two (or more) block\n"
"                       cursors on the screen.  There are similar scenarios,\n"
"                       (e.g. an output line is duplicated).\n"
"                       \n"
"                       These transients are induced by the approximation of\n"
"                       scroll detection (e.g. it detects the scroll, but not\n"
"                       the fact that the block cursor was cleared just before\n"
"                       the scroll).  In nearly all cases these transient errors\n"
"                       are repaired when the true X framebuffer is consulted\n"
"                       by the normal polling.  But they are distracting, so\n"
"                       what this option provides is extra \"padding\" near the\n"
"                       bottom of the terminal window: a few extra lines near\n"
"                       the bottom will not be scrolled, but rather updated\n"
"                       from the actual X framebuffer.  This usually reduces\n"
"                       the annoying artifacts.  Use \"none\" to disable.\n"
"                       Default: \"%s\"\n"
"\n"
"-scr_keyrepeat lo-hi   If a key is held down (or otherwise repeats rapidly) and\n"
"                       this induces a rapid sequence of scrolls (e.g. holding\n"
"                       down an Arrow key) the \"scrollcopyrect\" detection\n"
"                       and overhead may not be able to keep up.  A time per\n"
"                       single scroll estimate is performed and if that estimate\n"
"                       predicts a sustainable scrollrate of keys per second\n"
"                       between \"lo\" and \"hi\" then repeated keys will be\n"
"                       DISCARDED to maintain the scrollrate. For example your\n"
"                       key autorepeat may be 25 keys/sec, but for a large\n"
"                       window or slow link only 8 scrolls per second can be\n"
"                       sustained, then roughly 2 out of every 3 repeated keys\n"
"                       will be discarded during this period. Default: \"%s\"\n"
"\n"
"-scr_parms string      Set various parameters for the scrollcopyrect mode.\n"
"                       The format is similar to that for -wireframe and packed\n"
"                       with lots of parameters:\n"
"\n"
"                       Format: T+B+L+R,t1+t2+t3,s1+s2+s3+s4+s5\n"
"                       Default: %s\n"
"\n"
"                       If you leave nothing between commas: \",,\" the default\n"
"                       value is used.  If you don't specify enough commas,\n"
"                       the trailing parameters are set to their defaults.\n"
"\n"
"                       \"T+B+L+R\" indicates four integers for how close in\n"
"                       pixels the pointer has to be from the Top, Bottom, Left,\n"
"                       or Right edges of the window to consider scrollcopyrect.\n"
"                       If -wireframe overlaps it takes precedence.  This is a\n"
"                       speedup to quickly exclude a window from being watched\n"
"                       for scrollcopyrect: set them all to zero to not try\n"
"                       the speedup (things like selecting text will likely\n"
"                       be slower).\n"
"\n"
"                       \"t1+t2+t3\" specify three floating point times in\n"
"                       seconds that apply to scrollcopyrect detection with\n"
"                       *Keystroke* input: t1 is how long to wait after a key\n"
"                       is pressed for the first scroll, t2 is how long to keep\n"
"                       looking after a Keystroke scroll for more scrolls.\n"
"                       t3 is how frequently to try to update surrounding\n"
"                       scrollbars outside of the scrolling area (0.0 to\n"
"                       disable)\n"
"\n"
"                       \"s1+s2+s3+s4+s5\" specify five floating point times\n"
"                       in seconds that apply to scrollcopyrect detection with\n"
"                       *Mouse* input: s1 is how long to wait after a mouse\n"
"                       button is pressed for the first scroll, s2 is how long\n"
"                       to keep waiting for additional scrolls after the first\n"
"                       Mouse scroll was detected.  s3 is how frequently to\n"
"                       try to update surrounding scrollbars outside of the\n"
"                       scrolling area (0.0 to disable).  s4 is how long to\n"
"                       buffer pointer motion (to try to get fewer, bigger\n"
"                       mouse scrolls). s5 is the maximum time to spend just\n"
"                       updating the scroll window without updating the rest\n"
"                       of the screen.\n"
"\n"
"-fixscreen string      Periodically \"repair\" the screen based on settings\n"
"                       in \"string\".  Hopefully you won't need this option,\n"
"                       it is intended for cases when the -scrollcopyrect or\n"
"                       -wirecopyrect features leave too many painting errors,\n"
"                       but it can be used for any scenario.  This option\n"
"                       periodically performs costly operations and so\n"
"                       interactive response may be reduced when it is on.\n"
"                       You can use 3 Alt_L's (the Left \"Alt\" key) taps in a\n"
"                       row described under -scrollcopyrect instead to manually\n"
"                       request a screen repaint when it is needed.\n"
"\n"
"                       \"string\" is a comma separated list of one or more of\n"
"                       the following: \"V=t\", \"C=t\", and \"X=t\".  In these\n"
"                       \"t\" stands for a time in seconds (it is a floating\n"
"                       point even though one should usually use values > 2 to\n"
"                       avoid wasting resources).  V sets how frequently the\n"
"                       entire screen should be sent to viewers (it is like the\n"
"                       3 Alt_L's).  C sets how long to wait after a CopyRect\n"
"                       to repaint the full screen.  X sets how frequently\n"
"                       to reread the full X11 framebuffer from the X server\n"
"                       and push it out to connected viewers.  Use of X should\n"
"                       be rare, please report a bug if you find you need it.\n"
"                       Examples: -fixscreen V=10 -fixscreen C=10\n"
"\n"
"-debug_scroll          Turn on debugging info printout for the scroll\n"
"                       heuristics.  \"-ds\" is an alias.  Specify it multiple\n"
"                       times for more output.\n"
"\n"
"-noxrecord             Disable any use of the RECORD extension.  This is\n"
"                       currently used by the -scrollcopyrect scheme and to\n"
"                       monitor X server grabs.\n"
"\n"
"-grab_buster           Some of the use of the RECORD extension can leave a\n"
"-nograb_buster         tiny window for XGrabServer deadlock.  This is only if\n"
"                       the whole-server grabbing application expects mouse or\n"
"                       keyboard input before releasing the grab.  It is usually\n"
"                       a window manager that does this.  x11vnc takes care to\n"
"                       avoid the the problem, but if caught x11vnc will freeze.\n"
"                       Without -grab_buster, the only solution is to go the\n"
"                       physical display and give it some input to satisfy the\n"
"                       grabbing app.  Or manually kill and restart the window\n"
"                       manager if that is feasible.  With -grab_buster, x11vnc\n"
"                       will fork a helper thread and if x11vnc appears to be\n"
"                       stuck in a grab after a period of time (20-30 sec) then\n"
"                       it will inject some user input: button clicks, Escape,\n"
"                       mouse motion, etc to try to break the grab.  If you\n"
"                       experience a lot of grab deadlock, please report a bug.\n"
"\n"
"-debug_grabs           Turn on debugging info printout with respect to\n"
"                       XGrabServer() deadlock for -scrollcopyrect mode.\n"
"\n"
"-pointer_mode n        Various pointer motion update schemes. \"-pm\" is\n"
"                       an alias.  The problem is pointer motion can cause\n"
"                       rapid changes on the screen: consider the rapid\n"
"                       changes when you drag a large window around opaquely.\n"
"                       Neither x11vnc's screen polling and vnc compression\n"
"                       routines nor the bandwidth to the vncviewers can keep\n"
"                       up these rapid screen changes: everything will bog down\n"
"                       when dragging or scrolling.  So a scheme has to be used\n"
"                       to \"eat\" much of that pointer input before re-polling\n"
"                       the screen and sending out framebuffer updates. The\n"
"                       mode number \"n\" can be 0 to %d and selects one of\n"
"                       the schemes desribed below.\n"
"\n"
"                       Note that the -wireframe and -scrollcopyrect modes\n"
"                       complement -pointer_mode by detecting (and improving)\n"
"                       certain periods of \"rapid screen change\".\n"
"\n"
"                       n=0: does the same as -nodragging. (all screen polling\n"
"                       is suspended if a mouse button is pressed.)\n"
"\n"
"                       n=1: was the original scheme used to about Jan 2004:\n"
"                       it basically just skips -input_skip keyboard or pointer\n"
"                       events before repolling the screen.\n"
"\n"
"                       n=2 is an improved scheme: by watching the current rate\n"
"                       of input events it tries to detect if it should try to\n"
"                       \"eat\" additional pointer events before continuing.\n"
"\n"
"                       n=3 is basically a dynamic -nodragging mode: it detects\n"
"                       when the mouse motion has paused and then refreshes\n"
"                       the display.\n"
"\n"
"                       n=4 attempts to measures network rates and latency,\n"
"                       the video card read rate, and how many tiles have been\n"
"                       changed on the screen.  From this, it aggressively tries\n"
"                       to push screen \"frames\" when it decides it has enough\n"
"                       resources to do so.  NOT FINISHED.\n"
"\n"
"                       The default n is %d. Note that modes 2, 3, 4 will skip\n"
"                       -input_skip keyboard events (but it will not count\n"
"                       pointer events).  Also note that these modes are not\n"
"                       available in -threads mode which has its own pointer\n"
"                       event handling mechanism.\n"
"\n"
"                       To try out the different pointer modes to see which\n"
"                       one gives the best response for your usage, it is\n"
"                       convenient to use the remote control function, for\n"
"                       example \"x11vnc -R pm:4\" or the tcl/tk gui (Tuning ->\n"
"                       pointer_mode -> n).\n"
"\n"
"-input_skip n          For the pointer handling when non-threaded: try to\n"
"                       read n user input events before scanning display. n < 0\n"
"                       means to act as though there is always user input.\n"
"                       Default: %d\n"
"\n"
"-speeds rd,bw,lat      x11vnc tries to estimate some speed parameters that\n"
"                       are used to optimize scheduling (e.g. -pointer_mode\n"
"                       4, -wireframe, -scrollcopyrect) and other things.\n"
"                       Use the -speeds option to set these manually.\n"
"                       The triple \"rd,bw,lat\" corresponds to video h/w\n"
"                       read rate in MB/sec, network bandwidth to clients in\n"
"                       KB/sec, and network latency to clients in milliseconds,\n"
"                       respectively.  If a value is left blank, e.g. \"-speeds\n"
"                       ,100,15\", then the internal scheme is used to estimate\n"
"                       the empty value(s).\n"
"\n"
"                       Typical PC video cards have read rates of 5-10 MB/sec.\n"
"                       If the framebuffer is in main memory instead of video\n"
"                       h/w (e.g. SunRay, shadowfb, dummy driver, Xvfb), the\n"
"                       read rate may be much faster.  \"x11perf -getimage500\"\n"
"                       can be used to get a lower bound (remember to factor\n"
"                       in the bytes per pixel).  It is up to you to estimate\n"
"                       the network bandwith and latency to clients.  For the\n"
"                       latency the ping(1) command can be used.\n"
"\n"
"                       For convenience there are some aliases provided,\n"
"                       e.g. \"-speeds modem\".  The aliases are: \"modem\" for\n"
"                       6,4,200; \"dsl\" for 6,100,50; and \"lan\" for 6,5000,1\n"
"\n"
"-wmdt string           For some features, e.g. -wireframe and -scrollcopyrect,\n"
"                       x11vnc has to work around issues for certain window\n"
"                       managers or desktops (currently kde and xfce).\n"
"                       By default it tries to guess which one, but it can\n"
"                       guess incorrectly.  Use this option to indicate which\n"
"                       wm/dt.  \"string\" can be \"gnome\", \"kde\", \"cde\",\n"
"                       \"xfce\", or \"root\" (classic X wm).  Anything else\n"
"                       is interpreted as \"root\".\n"
"\n"
"-debug_pointer         Print debugging output for every pointer event.\n"
"-debug_keyboard        Print debugging output for every keyboard event.\n"
"                       Same as -dp and -dk, respectively.  Use multiple\n"
"                       times for more output.\n"
"\n"
"-defer time            Time in ms to wait for updates before sending to client\n"
"                       (deferUpdateTime)  Default: %d\n"
"-wait time             Time in ms to pause between screen polls.  Used to cut\n"
"                       down on load.  Default: %d\n"
"-wait_ui factor        Factor by which to cut the -wait time if there\n"
"                       has been recent user input (pointer or keyboard).\n"
"                       Improves response, but increases the load whenever you\n"
"                       are moving the mouse or typing.  Default: %.2f\n"
"-nowait_bog            Do not detect if the screen polling is \"bogging down\"\n"
"                       and sleep more.  Some activities with no user input can\n"
"                       slow things down a lot: consider a large terminal window\n"
"                       with a long build running in it continously streaming\n"
"                       text output.  By default x11vnc will try to detect this\n"
"                       (3 screen polls in a row each longer than 0.25 sec with\n"
"                       no user input), and sleep up to 1.5 secs to let things\n"
"                       \"catch up\".  Use this option to disable that detection.\n"
"-slow_fb time          Floating point time in seconds delay all screen polling.\n"
"                       For special purpose usage where a low frame rate is\n"
"                       acceptable and desirable, but you want the user input\n"
"                       processed at the normal rate so you cannot use -wait.\n"
"-readtimeout n         Set libvncserver rfbMaxClientWait to n seconds. On\n"
"                       slow links that take a long time to paint the first\n"
"                       screen libvncserver may hit the timeout and drop the\n"
"                       connection.  Default: %d seconds.\n"
"-nap                   Monitor activity and if it is low take longer naps\n"
"-nonap                 between screen polls to really cut down load when idle.\n"
"                       Default: %s\n"
"-sb time               Time in seconds after NO activity (e.g. screen blank)\n"
"                       to really throttle down the screen polls (i.e. sleep\n"
"                       for about 1.5 secs). Use 0 to disable.  Default: %d\n"
"\n"
"-noxdamage             Do not use the X DAMAGE extension to detect framebuffer\n"
"                       changes even if it is available.  Use -xdamage if your\n"
"                       default is to have it off.\n"
"\n"
"                       x11vnc's use of the DAMAGE extension: 1) significantly\n"
"                       reduces the load when the screen is not changing much,\n"
"                       and 2) detects changed areas (small ones by default)\n"
"                       more quickly.\n"
"\n"
"                       Currently the DAMAGE extension is overly conservative\n"
"                       and often reports large areas (e.g. a whole terminal\n"
"                       or browser window) as damaged even though the actual\n"
"                       changed region is much smaller (sometimes just a few\n"
"                       pixels).  So heuristics were introduced to skip large\n"
"                       areas and use the damage rectangles only as \"hints\"\n"
"                       for the traditional scanline polling.  The following\n"
"                       tuning parameters are introduced to adjust this\n"
"                       behavior:\n"
"\n"
"-xd_area A             Set the largest DAMAGE rectangle area \"A\" (in\n"
"                       pixels: width * height) to trust as truly damaged:\n"
"                       the rectangle will be copied from the framebuffer\n"
"                       (slow) no matter what.  Set to zero to trust *all*\n"
"                       rectangles. Default: %d\n"
"-xd_mem f              Set how long DAMAGE rectangles should be \"remembered\",\n"
"                       \"f\" is a floating point number and is in units of the\n"
"                       scanline repeat cycle time (%d iterations).  The default\n"
"                       (%.1f) should give no painting problems. Increase it if\n"
"                       there are problems or decrease it to live on the edge\n"
"                       (perhaps useful on a slow machine).\n"
"\n"
"-sigpipe string        Broken pipe (SIGPIPE) handling.  \"string\" can be\n"
"                       \"ignore\" or \"exit\".  For \"ignore\" libvncserver\n"
"                       will handle the abrupt loss of a client and continue,\n"
"                       for \"exit\" x11vnc will cleanup and exit at the 1st\n"
"                       broken connection.  Default: \"ignore\".  This option\n"
"                       is obsolete.\n"
"-threads               Whether or not to use the threaded libvncserver\n"
"-nothreads             algorithm [rfbRunEventLoop] if libpthread is available\n"
"                       Default: %s\n"
"\n"
"-fs f                  If the fraction of changed tiles in a poll is greater\n"
"                       than f, the whole screen is updated.  Default: %.2f\n"
"-gaps n                Heuristic to fill in gaps in rows or cols of n or\n"
"                       less tiles.  Used to improve text paging.  Default: %d\n"
"-grow n                Heuristic to grow islands of changed tiles n or wider\n"
"                       by checking the tile near the boundary.  Default: %d\n"
"-fuzz n                Tolerance in pixels to mark a tiles edges as changed.\n"
"                       Default: %d\n"
"-debug_tiles           Print debugging output for tiles, fb updates, etc.\n"
"\n"
"-snapfb                Instead of polling the X display framebuffer (fb) for\n"
"                       changes, periodically copy all of X display fb into main\n"
"                       memory and examine that copy for changes.  Under some\n"
"                       circumstances this will improve interactive response,\n"
"                       or at least make things look smoother, but in others\n"
"                       (most!) it will make the response worse.  If the video\n"
"                       h/w fb is such that reading small tiles is very slow\n"
"                       this mode could help.  To keep the \"framerate\" up\n"
"                       the screen size x bpp cannot be too large.  Note that\n"
"                       this mode is very wasteful of memory I/O resources\n"
"                       (it makes full screen copies even if nothing changes).\n"
"                       It may be of use in video capture-like applications,\n"
"                       or where window tearing is a problem.\n"
"\n"
"-rawfb string          Experimental option, instead of polling X, poll the\n"
"                       memory object specified in \"string\".  For shared\n"
"                       memory segments it is of the form: \"shm:N@WxHxB\"\n"
"                       which specifies a shmid N and framebuffer Width, Height,\n"
"                       and Bits per pixel.  To memory map mmap(2) a file use:\n"
"                       \"map:/path/to/a/file@WxHxB\".  If there is trouble\n"
"                       with mmap, use  \"file:/...\" for slower lseek(2)\n"
"                       based reading.  If you do not supply a type \"map\"\n"
"                       is assumed if the file exists.\n"
"\n"
"                       If string is \"setup:cmd\", then the command \"cmd\"\n"
"                       is run and the first line from it is read and used\n"
"                       as \"string\".  This allows initializing the device,\n"
"                       determining WxHxB, etc. These are often done as root\n"
"                       so take care.\n"
"\n"
"                       Optional suffixes are \":R/G/B\" and \"+O\" to specify\n"
"                       red, green, and blue masks and an offset into the\n"
"                       memory object.  If the masks are not provided x11vnc\n"
"                       guesses them based on the bpp.\n"
"\n"
"                       Examples:\n"
"                           -rawfb shm:210337933@800x600x32:ff/ff00/ff0000\n"
"                           -rawfb map:/dev/fb0@1024x768x32\n"
"                           -rawfb map:/tmp/Xvfb_screen0@640x480x8+3232\n"
"                           -rawfb file:/tmp/my.pnm@250x200x24+37\n"
"\n"
"                       (see ipcs(1) and fbset(1) for the first two examples)\n"
"\n"
"                       All user input is discarded by default (but see the\n"
"                       -pipeinput option).  Most of the X11 (screen, keyboard,\n"
"                       mouse) options do not make sense and many will cause\n"
"                       this mode to crash, so please think twice before\n"
"                       setting/changing them.\n"
"\n"
"                       If you don't want x11vnc to close the X DISPLAY in\n"
"                       rawfb mode, then capitalize the prefix, SHM:, MAP:,\n"
"                       FILE:   Keeping the display open enables the default\n"
"                       remote-control channel, which could be useful.  Also,\n"
"                       if you also specify -noviewonly, then the mouse and\n"
"                       keyboard input are STILL sent to the X display, this\n"
"                       usage should be very rare, i.e. doing something strange\n"
"                       with /dev/fb0.\n"
"\n"
"-pipeinput cmd         Another experimental option: it lets you supply an\n"
"                       external command in \"cmd\" that x11vnc will pipe\n"
"                       all of the user input events to in a simple format.\n"
"                       In -pipeinput mode by default x11vnc will not process\n"
"                       any of the user input events.  If you prefix \"cmd\"\n"
"                       with \"tee:\" it will both send them to the pipe\n"
"                       command and process them.  For a description of the\n"
"                       format run \"-pipeinput tee:/bin/cat\".  Another prefix\n"
"                       is \"reopen\" which means to reopen pipe if it exits.\n"
"                       Separate multiple prefixes with commas.\n"
"\n"
"                       In combination with -rawfb one might be able to\n"
"                       do amusing things (e.g. control non-X devices).\n"
"                       To facilitate this, if -rawfb is in effect then the\n"
"                       value is stored in X11VNC_RAWFB_STR for the pipe command\n"
"                       to use if it wants. Do 'env | grep X11VNC' for more.\n"
"\n"
"-gui [gui-opts]        Start up a simple tcl/tk gui based on the the remote\n"
"                       control options -remote/-query described below.\n"
"                       Requires the \"wish\" program to be installed on the\n"
"                       machine.  \"gui-opts\" is not required: the default\n"
"                       is to start up both the full gui and x11vnc with the\n"
"                       gui showing up on the X display in the environment\n"
"                       variable DISPLAY.\n"
"\n"
"                       \"gui-opts\" can be a comma separated list of items.\n"
"                       Currently there are these types of items: 1) a gui\n"
"                       mode, a 2) gui \"simplicity\", 3) the X display the\n"
"                       gui should display on, 4) a \"tray\" or \"icon\" mode,\n"
"                       and 5) a gui geometry.\n"
"\n"
"                       1) The gui mode can be \"start\", \"conn\", or \"wait\"\n"
"                       \"start\" is the default mode above and is not required.\n"
"                       \"conn\" means do not automatically start up x11vnc,\n"
"                       but instead just try to connect to an existing x11vnc\n"
"                       process.  \"wait\" means just start the gui and nothing\n"
"                       else (you will later instruct the gui to start x11vnc\n"
"                       or connect to an existing one.)\n"
"\n"
"                       2) The gui simplicity is off by default (a power-user\n"
"                       gui with all options is presented) To start with\n"
"                       something less daunting supply the string \"simple\"\n"
"                       (\"ez\" is an alias for this).  Once the gui is\n"
"                       started you can toggle between the two with \"Misc ->\n"
"                       simple_gui\".\n"
"\n"
"                       3) Note the possible confusion regarding the potentially\n"
"                       two different X displays: x11vnc polls one, but you\n"
"                       may want the gui to appear on another.  For example, if\n"
"                       you ssh in and x11vnc is not running yet you may want\n"
"                       the gui to come back to you via your ssh redirected X\n"
"                       display (e.g. localhost:10).\n"
"\n"
"                       If you do not specify a gui X display in \"gui-opts\"\n"
"                       then the DISPLAY environment variable and -display\n"
"                       option are tried (in that order).  Regarding the x11vnc\n"
"                       X display the gui will try to communication with, it\n"
"                       first tries -display and then DISPLAY.  For example,\n"
"                       \"x11vnc -display :0 -gui otherhost:0\", will remote\n"
"                       control an x11vnc polling :0 and display the gui on\n"
"                       otherhost:0 The \"tray/icon\" mode below reverses this\n"
"                       preference, preferring to display on the x11vnc display.\n"
"\n"
"                       4) When \"tray\" or \"icon\" is specified, the gui\n"
"                       presents itself as a small icon with behavior typical\n"
"                       of a \"system tray\" or \"dock applet\".  The color\n"
"                       of the icon indicates status (connected clients) and\n"
"                       there is also a balloon status.  Clicking on the icon\n"
"                       gives a menu from which properties, etc, can be set and\n"
"                       the full gui is available under \"Advanced\".  To be\n"
"                       fully functional, the gui mode should be \"start\"\n"
"                       (the default).\n"
"\n"
"                       For \"icon\" the gui just a small standalone window.\n"
"                       For \"tray\" it will attempt to embed itself in the\n"
"                       \"system tray\" if possible. If \"=setpass\" is appended then\n"
"                       at startup the X11 user will be prompted to set the\n"
"                       VNC session password.  If =<hexnumber> is appended\n"
"                       that icon will attempt to embed itself in the window\n"
"                       given by hexnumber.  Use =noadvanced to disable the\n"
"                       full gui. (To supply more than one, use \"+\" sign).\n"
"                       E.g. -gui tray=setpass and -gui icon=0x3600028\n"
"\n"
"                       Other modes: \"full\", the default and need not be\n"
"                       specified.  \"-gui none\", do not show a gui, useful\n"
"                       to override a ~/.x11vncrc setting, etc.\n"
"\n"
"                       5) When \"geom=+X+Y\" is specified, that geometry\n"
"                       is passed to the gui toplevel.  This is the icon in\n"
"                       icon/tray mode, or the full gui otherwise.  You can\n"
"                       also specify width and height, i.e. WxH+X+Y, but it\n"
"                       is not recommended.  In \"tray\" mode the geometry is\n"
"                       ignored unless the system tray manager does not seem\n"
"                       to be running.  One could imagine using something like\n"
"                       \"-gui tray,geom=+4000+4000\" with a display manager\n"
"                       to keep the gui invisible until someone logs in...\n"
"\n"
"                       More icon tricks, \"icon=minimal\" gives an icon just\n"
"                       with the VNC display number.  You can also set the font\n"
"                       with \"iconfont=...\".  The following could be useful:\n"
"                       \"-gui icon=minimal,iconfont=5x8,geom=24x10+0-0\"\n"
"\n"
"                       General examples of the -gui option: \"x11vnc -gui\",\n"
"                       \"x11vnc -gui ez\" \"x11vnc -gui localhost:10\",\n"
"                       \"x11vnc -gui conn,host:0\", \"x11vnc -gui tray,ez\"\n"
"                       \"x11vnc -gui tray=setpass\"\n"
"\n"
"                       If you do not intend to start x11vnc from the gui\n"
"                       (i.e. just remote control an existing one), then the\n"
"                       gui process can run on a different machine from the\n"
"                       x11vnc server as long as X permissions, etc. permit\n"
"                       communication between the two.\n"
"\n"
"-remote command        Remotely control some aspects of an already running\n"
"                       x11vnc server.  \"-R\" and \"-r\" are aliases for\n"
"                       \"-remote\".  After the remote control command is\n"
"                       sent to the running server the 'x11vnc -remote ...'\n"
"                       command exits.  You can often use the -query command\n"
"                       (see below) to see if the x11vnc server processed your\n"
"                       -remote command.\n"
"\n"
"                       The default communication channel is that of X\n"
"                       properties (specifically VNC_CONNECT), and so this\n"
"                       command must be run with correct settings for DISPLAY\n"
"                       and possibly XAUTHORITY to connect to the X server\n"
"                       and set the property.  Alternatively, use the -display\n"
"                       and -auth options to set them to the correct values.\n"
"                       The running server cannot use the -novncconnect option\n"
"                       because that disables the communication channel.\n"
"                       See below for alternate channels.\n"
"\n"
"                       For example: 'x11vnc -remote stop' (which is the same as\n"
"                       'x11vnc -R stop') will close down the x11vnc server.\n"
"                       'x11vnc -R shared' will enable shared connections, and\n"
"                       'x11vnc -R scale:3/4' will rescale the desktop.\n"
"\n"
"                       The following -remote/-R commands are supported:\n"
"\n"
"                       stop            terminate the server, same as \"quit\"\n"
"                                       \"exit\" or \"shutdown\".\n"
"                       ping            see if the x11vnc server responds.\n"
"                                       Return is: ans=ping:<xdisplay>\n"
"                       blacken         try to push a black fb update to all\n"
"                                       clients (due to timings a client\n"
"                                       could miss it). Same as \"zero\", also\n"
"                                       \"zero:x1,y1,x2,y2\" for a rectangle.\n"
"                       refresh         send the entire fb to all clients.\n"
"                       reset           recreate the fb, polling memory, etc.\n"
/* ext. cmd. */
"                       id:windowid     set -id window to \"windowid\". empty\n"
"                                       or \"root\" to go back to root window\n"
"                       sid:windowid    set -sid window to \"windowid\"\n"
"                       waitmapped      wait until subwin is mapped.\n"
"                       nowaitmapped    do not wait until subwin is mapped.\n"
"                       clip:WxH+X+Y    set -clip mode to \"WxH+X+Y\"\n"
"                       flashcmap       enable  -flashcmap mode.\n"
"                       noflashcmap     disable -flashcmap mode.\n"
"                       shiftcmap:n     set -shiftcmap to n.\n"
"                       notruecolor     enable  -notruecolor mode.\n"
"                       truecolor       disable -notruecolor mode.\n"
"                       overlay         enable  -overlay mode (if applicable).\n"
"                       nooverlay       disable -overlay mode.\n"
"                       overlay_cursor  in -overlay mode, enable cursor drawing.\n"
"                       overlay_nocursor disable cursor drawing. same as\n"
"                                        nooverlay_cursor.\n"
"                       visual:vis      set -visual to \"vis\"\n"
"                       scale:frac      set -scale to \"frac\"\n"
"                       scale_cursor:f  set -scale_cursor to \"f\"\n"
"                       viewonly        enable  -viewonly mode.\n"
/* access view,share,forever */
"                       noviewonly      disable -viewonly mode.\n"
"                       shared          enable  -shared mode.\n"
"                       noshared        disable -shared mode.\n"
"                       forever         enable  -forever mode.\n"
"                       noforever       disable -forever mode.\n"
"                       timeout:n       reset -timeout to n, if there are\n"
"                                       currently no clients, exit unless one\n"
"                                       connects in the next n secs.\n"
/* access */
"                       http            enable  http client connections.\n"
"                       nohttp          disable http client connections.\n"
"                       deny            deny any new connections, same as \"lock\"\n"
"                       nodeny          allow new connections, same as \"unlock\"\n"
/* access, filename */
"                       connect:host    do reverse connection to host, \"host\"\n"
"                                       may be a comma separated list of hosts\n"
"                                       or host:ports.  See -connect.\n"
"                       disconnect:host disconnect any clients from \"host\"\n"
"                                       same as \"close:host\".  Use host\n"
"                                       \"all\" to close all current clients.\n"
"                                       If you know the client internal hex ID,\n"
"                                       e.g. 0x3 (returned by \"-query clients\"\n"
"                                       and RFB_CLIENT_ID) you can use that too.\n"
/* access */
"                       allowonce:host  For the next connection only, allow\n"
"                                       connection from \"host\".\n"
/* access */
"                       allow:hostlist  set -allow list to (comma separated)\n"
"                                       \"hostlist\". See -allow and -localhost.\n"
"                                       Do not use with -allow /path/to/file\n"
"                                       Use \"+host\" to add a single host, and\n"
"                                       use \"-host\" to delete a single host\n"
"                       localhost       enable  -localhost mode\n"
"                       nolocalhost     disable -localhost mode\n"
"                       listen:str      set -listen to str, empty to disable.\n"
"                       nolookup        enable  -nolookup mode.\n"
"                       lookup          disable -nolookup mode.\n"
"                       input:str       set -input to \"str\", empty to disable.\n"
"                       client_input:str set the K, M, B -input on a per-client\n"
"                                       basis.  select which client as for\n"
"                                       disconnect, e.g. client_input:host:MB\n"
"                                       or client_input:0x2:K\n"
/* ext. cmd. */
"                       accept:cmd      set -accept \"cmd\" (empty to disable).\n"
"                       afteraccept:cmd set -afteraccept (empty to disable).\n"
"                       gone:cmd        set -gone \"cmd\" (empty to disable).\n"
"                       noshm           enable  -noshm mode.\n"
"                       shm             disable -noshm mode (i.e. use shm).\n"
"                       flipbyteorder   enable -flipbyteorder mode, you may need\n"
"                                       to set noshm for this to do something.\n"
"                       noflipbyteorder disable -flipbyteorder mode.\n"
"                       onetile         enable  -onetile mode. (you may need to\n"
"                                       set shm for this to do something)\n"
"                       noonetile       disable -onetile mode.\n"
/* ext. cmd. */
"                       solid           enable  -solid mode\n"
"                       nosolid         disable -solid mode.\n"
"                       solid_color:color set -solid color (and apply it).\n"
"                       blackout:str    set -blackout \"str\" (empty to disable).\n"
"                                       See -blackout for the form of \"str\"\n"
"                                       (basically: WxH+X+Y,...)\n"
"                                       Use \"+WxH+X+Y\" to append a single\n"
"                                       rectangle use \"-WxH+X+Y\" to delete one\n"
"                       xinerama        enable  -xinerama mode. (if applicable)\n"
"                       noxinerama      disable -xinerama mode.\n"
"                       xtrap           enable  -xtrap input mode(if applicable)\n"
"                       noxtrap         disable -xtrap input mode.\n"
"                       xrandr          enable  -xrandr mode. (if applicable)\n"
"                       noxrandr        disable -xrandr mode.\n"
"                       xrandr_mode:mode set the -xrandr mode to \"mode\".\n"
"                       padgeom:WxH     set -padgeom to WxH (empty to disable)\n"
"                                       If WxH is \"force\" or \"do\" the padded\n"
"                                       geometry fb is immediately applied.\n"
"                       quiet           enable  -quiet mode.\n"
"                       noquiet         disable -quiet mode.\n"
"                       modtweak        enable  -modtweak mode.\n"
"                       nomodtweak      enable  -nomodtweak mode.\n"
"                       xkb             enable  -xkb modtweak mode.\n"
"                       noxkb           disable -xkb modtweak mode.\n"
"                       skip_keycodes:str enable -xkb -skip_keycodes \"str\".\n"
"                       sloppy_keys     enable  -sloppy_keys mode.\n"
"                       nosloppy_keys   disable -sloppy_keys mode.\n"
"                       skip_dups       enable  -skip_dups mode.\n"
"                       noskip_dups     disable -skip_dups mode.\n"
"                       add_keysyms     enable -add_keysyms mode.\n"
"                       noadd_keysyms   stop adding keysyms. those added will\n"
"                                       still be removed at exit.\n"
"                       clear_mods      enable  -clear_mods mode and clear them.\n"
"                       noclear_mods    disable -clear_mods mode.\n"
"                       clear_keys      enable  -clear_keys mode and clear them.\n"
"                       noclear_keys    disable -clear_keys mode.\n"
/* filename */
"                       remap:str       set -remap \"str\" (empty to disable).\n"
"                                       See -remap for the form of \"str\"\n"
"                                       (basically: key1-key2,key3-key4,...)\n"
"                                       Use \"+key1-key2\" to append a single\n"
"                                       keymapping, use \"-key1-key2\" to delete.\n"
"                       norepeat        enable  -norepeat mode.\n"
"                       repeat          disable -norepeat mode.\n"
"                       nofb            enable  -nofb mode.\n"
"                       fb              disable -nofb mode.\n"
"                       bell            enable  bell (if supported).\n"
"                       nobell          disable bell.\n"
"                       nosel           enable  -nosel mode.\n"
"                       sel             disable -nosel mode.\n"
"                       noprimary       enable  -noprimary mode.\n"
"                       primary         disable -noprimary mode.\n"
"                       seldir:str      set -seldir to \"str\"\n"
"                       cursor:mode     enable  -cursor \"mode\".\n"
"                       show_cursor     enable  showing a cursor.\n"
"                       noshow_cursor   disable showing a cursor. (same as\n"
"                                       \"nocursor\")\n"
"                       arrow:n         set -arrow to alternate n.\n"
"                       xfixes          enable  xfixes cursor shape mode.\n"
"                       noxfixes        disable xfixes cursor shape mode.\n"
"                       alphacut:n      set -alphacut to n.\n"
"                       alphafrac:f     set -alphafrac to f.\n"
"                       alpharemove     enable  -alpharemove mode.\n"
"                       noalpharemove   disable -alpharemove mode.\n"
"                       alphablend      disable -noalphablend mode.\n"
"                       noalphablend    enable  -noalphablend mode.\n"
"                       cursorshape     disable -nocursorshape mode.\n"
"                       nocursorshape   enable  -nocursorshape mode.\n"
"                       cursorpos       disable -nocursorpos mode.\n"
"                       nocursorpos     enable  -nocursorpos mode.\n"
"                       xwarp           enable  -xwarppointer mode.\n"
"                       noxwarp         disable -xwarppointer mode.\n"
"                       buttonmap:str   set -buttonmap \"str\", empty to disable\n"
"                       dragging        disable -nodragging mode.\n"
"                       nodragging      enable  -nodragging mode.\n"
"                       wireframe       enable  -wireframe mode. same as \"wf\"\n"
"                       nowireframe     disable -wireframe mode. same as \"nowf\"\n"
"                       wireframe:str   enable  -wireframe mode string.\n"
"                       wireframe_mode:str enable  -wireframe mode string.\n"
"                       wirecopyrect:str set -wirecopyrect string. same as \"wcr:\"\n"
"                       scrollcopyrect:str set -scrollcopyrect string. same \"scr\"\n"
"                       noscrollcopyrect disable -scrollcopyrect mode. \"noscr\"\n"
"                       scr_area:n      set -scr_area to n\n"
"                       scr_skip:list   set -scr_skip to \"list\"\n"
"                       scr_inc:list    set -scr_inc to \"list\"\n"
"                       scr_keys:list   set -scr_keys to \"list\"\n"
"                       scr_term:list   set -scr_term to \"list\"\n"
"                       scr_keyrepeat:str set -scr_keyrepeat to \"str\"\n"
"                       scr_parms:str   set -scr_parms parameters.\n"
"                       fixscreen:str   set -fixscreen to \"str\".\n"
"                       noxrecord       disable all use of RECORD extension.\n"
"                       xrecord         enable  use of RECORD extension.\n"
"                       reset_record    reset RECORD extension (if avail.)\n"
"                       pointer_mode:n  set -pointer_mode to n. same as \"pm\"\n"
"                       input_skip:n    set -input_skip to n.\n"
"                       speeds:str      set -speeds to str.\n"
"                       wmdt:str        set -wmdt to str.\n"
"                       debug_pointer   enable  -debug_pointer, same as \"dp\"\n"
"                       nodebug_pointer disable -debug_pointer, same as \"nodp\"\n"
"                       debug_keyboard   enable  -debug_keyboard, same as \"dk\"\n"
"                       nodebug_keyboard disable -debug_keyboard, same as \"nodk\"\n"
"                       defer:n         set -defer to n ms,same as deferupdate:n\n"
"                       wait:n          set -wait to n ms.\n"
"                       wait_ui:f       set -wait_ui factor to f.\n"
"                       wait_bog        disable -nowait_bog mode.\n"
"                       nowait_bog      enable  -nowait_bog mode.\n"
"                       slow_fb:f       set -slow_fb to f seconds.\n"
"                       readtimeout:n   set read timeout to n seconds.\n"
"                       nap             enable  -nap mode.\n"
"                       nonap           disable -nap mode.\n"
"                       sb:n            set -sb to n s, same as screen_blank:n\n"
"                       xdamage         enable  xdamage polling hints.\n"
"                       noxdamage       disable xdamage polling hints.\n"
"                       xd_area:A       set -xd_area max pixel area to \"A\"\n"
"                       xd_mem:f        set -xd_mem remembrance to \"f\"\n"
"                       fs:frac         set -fs fraction to \"frac\", e.g. 0.5\n"
"                       gaps:n          set -gaps to n.\n"
"                       grow:n          set -grow to n.\n"
"                       fuzz:n          set -fuzz to n.\n"
"                       snapfb          enable  -snapfb mode.\n"
"                       nosnapfb        disable -snapfb mode.\n"
"                       rawfb:str       set -rawfb mode to \"str\".\n"
"                       progressive:n   set libvncserver -progressive slice\n"
"                                       height parameter to n.\n"
"                       desktop:str     set -desktop name to str for new clients.\n"
"                       rfbport:n       set -rfbport to n.\n"
/* access */
"                       httpport:n      set -httpport to n.\n"
"                       httpdir:dir     set -httpdir to dir (and enable http).\n"
"                       enablehttpproxy   enable  -enablehttpproxy mode.\n"
"                       noenablehttpproxy disable -enablehttpproxy mode.\n"
"                       alwaysshared     enable  -alwaysshared mode.\n"
"                       noalwaysshared   disable -alwaysshared mode.\n"
"                                        (may interfere with other options)\n"
"                       nevershared      enable  -nevershared mode.\n"
"                       nonevershared    disable -nevershared mode.\n"
"                                        (may interfere with other options)\n"
"                       dontdisconnect   enable  -dontdisconnect mode.\n"
"                       nodontdisconnect disable -dontdisconnect mode.\n"
"                                        (may interfere with other options)\n"
"                       debug_xevents   enable  debugging X events.\n"
"                       nodebug_xevents disable debugging X events.\n"
"                       debug_xdamage   enable  debugging X DAMAGE mechanism.\n"
"                       nodebug_xdamage disable debugging X DAMAGE mechanism.\n"
"                       debug_wireframe enable   debugging wireframe mechanism.\n"
"                       nodebug_wireframe disable debugging wireframe mechanism.\n"
"                       debug_scroll    enable  debugging scrollcopy mechanism.\n"
"                       nodebug_scroll  disable debugging scrollcopy mechanism.\n"
"                       debug_tiles     enable  -debug_tiles\n"
"                       nodebug_tiles   disable -debug_tiles\n"
"                       debug_grabs     enable  -debug_grabs\n"
"                       nodebug_grabs   disable -debug_grabs\n"
"                       dbg             enable  -dbg crash shell\n"
"                       nodbg           disable -dbg crash shell\n"
"\n"
"                       noremote        disable the -remote command processing,\n"
"                                       it cannot be turned back on.\n"
"\n"
"                       The vncconnect(1) command from standard VNC\n"
"                       distributions may also be used if string is prefixed\n"
"                       with \"cmd=\" E.g. 'vncconnect cmd=stop'.  Under some\n"
"                       circumstances xprop(1) can used if it supports -set\n"
"                       (see the FAQ).\n"
"\n"
"                       If \"-connect /path/to/file\" has been supplied to the\n"
"                       running x11vnc server then that file can be used as a\n"
"                       communication channel (this is the only way to remote\n"
"                       control one of many x11vnc's polling the same X display)\n"
"                       Simply run: 'x11vnc -connect /path/to/file -remote ...'\n"
"                       or you can directly write to the file via something\n"
"                       like: \"echo cmd=stop > /path/to/file\", etc.\n"
"\n"
"-query variable        Like -remote, except just query the value of\n"
"                       \"variable\".  \"-Q\" is an alias for \"-query\".\n"
"                       Multiple queries can be done by separating variables\n"
"                       by commas, e.g. -query var1,var2. The results come\n"
"                       back in the form ans=var1:value1,ans=var2:value2,...\n"
"                       to the standard output.  If a variable is read-only,\n"
"                       it comes back with prefix \"aro=\" instead of \"ans=\".\n"
"\n"
"                       Some -remote commands are pure actions that do not make\n"
"                       sense as variables, e.g. \"stop\" or \"disconnect\",\n"
"                       in these cases the value returned is \"N/A\".  To direct\n"
"                       a query straight to the VNC_CONNECT property or connect\n"
"                       file use \"qry=...\" instead of \"cmd=...\"\n"
"\n"
"                       Here is the current list of \"variables\" that can\n"
"                       be supplied to the -query command. This includes the\n"
"                       \"N/A\" ones that return no useful info.  For variables\n"
"                       names that do not correspond to an x11vnc option or\n"
"                       remote command, we hope the name makes it obvious what\n"
"                       the returned value corresponds to (hint: the ext_*\n"
"                       variables correspond to the presence of X extensions):\n"
"\n"
"                       ans= stop quit exit shutdown ping blacken zero\n"
"                       refresh reset close disconnect id sid waitmapped\n"
"                       nowaitmapped clip flashcmap noflashcmap shiftcmap\n"
"                       truecolor notruecolor overlay nooverlay overlay_cursor\n"
"                       overlay_yescursor nooverlay_nocursor nooverlay_cursor\n"
"                       nooverlay_yescursor overlay_nocursor visual scale\n"
"                       scale_cursor viewonly noviewonly shared noshared\n"
"                       forever noforever once timeout filexfer deny lock\n"
"                       nodeny unlock connect allowonce allow localhost\n"
"                       nolocalhost listen lookup nolookup accept afteraccept\n"
"                       gone shm noshm flipbyteorder noflipbyteorder onetile\n"
"                       noonetile solid_color solid nosolid blackout xinerama\n"
"                       noxinerama xtrap noxtrap xrandr noxrandr xrandr_mode\n"
"                       padgeom quiet q noquiet modtweak nomodtweak xkb\n"
"                       noxkb skip_keycodes sloppy_keys nosloppy_keys\n"
"                       skip_dups noskip_dups add_keysyms noadd_keysyms\n"
"                       clear_mods noclear_mods clear_keys noclear_keys\n"
"                       remap repeat norepeat fb nofb bell nobell sel nosel\n"
"                       primary noprimary seldir cursorshape nocursorshape\n"
"                       cursorpos nocursorpos cursor show_cursor noshow_cursor\n"
"                       nocursor arrow xfixes noxfixes xdamage noxdamage\n"
"                       xd_area xd_mem alphacut alphafrac alpharemove\n"
"                       noalpharemove alphablend noalphablend xwarppointer\n"
"                       xwarp noxwarppointer noxwarp buttonmap dragging\n"
"                       nodragging wireframe_mode wireframe wf nowireframe\n"
"                       nowf wirecopyrect wcr nowirecopyrect nowcr scr_area\n"
"                       scr_skip scr_inc scr_keys scr_term scr_keyrepeat\n"
"                       scr_parms scrollcopyrect scr noscrollcopyrect noscr\n"
"                       fixscreen noxrecord xrecord reset_record pointer_mode\n"
"                       pm input_skip input client_input speeds wmdt\n"
"                       debug_pointer dp nodebug_pointer nodp debug_keyboard\n"
"                       dk nodebug_keyboard nodk deferupdate defer wait_ui\n"
"                       wait_bog nowait_bog slow_fb wait readtimeout nap nonap\n"
"                       sb screen_blank fs gaps grow fuzz snapfb nosnapfb\n"
"                       rawfb progressive rfbport http nohttp httpport\n"
"                       httpdir enablehttpproxy noenablehttpproxy alwaysshared\n"
"                       noalwaysshared nevershared noalwaysshared dontdisconnect\n"
"                       nodontdisconnect desktop debug_xevents nodebug_xevents\n"
"                       debug_xevents debug_xdamage nodebug_xdamage\n"
"                       debug_xdamage debug_wireframe nodebug_wireframe\n"
"                       debug_wireframe debug_scroll nodebug_scroll debug_scroll\n"
"                       debug_tiles dbt nodebug_tiles nodbt debug_tiles\n"
"                       debug_grabs nodebug_grabs dbg nodbg noremote\n"
"\n"
"                       aro=  noop display vncdisplay desktopname guess_desktop\n"
"                       http_url auth xauth users rootshift clipshift\n"
"                       scale_str scaled_x scaled_y scale_numer scale_denom\n"
"                       scale_fac scaling_blend scaling_nomult4 scaling_pad\n"
"                       scaling_interpolate inetd privremote unsafe safer nocmds\n"
"                       passwdfile using_shm logfile o flag rc norc h help V\n"
"                       version lastmod bg sigpipe threads readrate netrate\n"
"                       netlatency pipeinput clients client_count pid ext_xtest\n"
"                       ext_xtrap ext_xrecord ext_xkb ext_xshm ext_xinerama\n"
"                       ext_overlay ext_xfixes ext_xdamage ext_xrandr rootwin\n"
"                       num_buttons button_mask mouse_x mouse_y bpp depth\n"
"                       indexed_color dpy_x dpy_y wdpy_x wdpy_y off_x off_y\n"
"                       cdpy_x cdpy_y coff_x coff_y rfbauth passwd viewpasswd\n"
"\n"
"-QD variable           Just like -query variable, but returns the default\n"
"                       value for that parameter (no running x11vnc server\n"
"                       is consulted)\n"
"\n"
"-sync                  By default -remote commands are run asynchronously, that\n"
"                       is, the request is posted and the program immediately\n"
"                       exits.  Use -sync to have the program wait for an\n"
"                       acknowledgement from the x11vnc server that command was\n"
"                       processed (somehow).  On the other hand -query requests\n"
"                       are always processed synchronously because they have\n"
"                       to wait for the answer.\n"
"\n"
"                       Also note that if both -remote and -query requests are\n"
"                       supplied on the command line, the -remote is processed\n"
"                       first (synchronously: no need for -sync), and then\n"
"                       the -query request is processed in the normal way.\n"
"                       This allows for a reliable way to see if the -remote\n"
"                       command was processed by querying for any new settings.\n"
"                       Note however that there is timeout of a few seconds so\n"
"                       if the x11vnc takes longer than that to process the\n"
"                       requests the requestor will think that a failure has\n"
"                       taken place.\n"
"\n"
"-noremote              Do not process any remote control commands or queries.\n"
"-yesremote             Do process remote control commands or queries.\n"
"                       Default: %s\n"
"\n"
"                       A note about security wrt remote control commands.\n"
"                       If someone can connect to the X display and change\n"
"                       the property VNC_CONNECT, then they can remotely\n"
"                       control x11vnc.  Normally access to the X display is\n"
"                       protected.  Note that if they can modify VNC_CONNECT\n"
"                       on the X server, they have enough permissions to also\n"
"                       run their own x11vnc and thus have complete control\n"
"                       of the desktop.  If the  \"-connect /path/to/file\"\n"
"                       channel is being used, obviously anyone who can write\n"
"                       to /path/to/file can remotely control x11vnc.  So be\n"
"                       sure to protect the X display and that file's write\n"
"                       permissions.  See -privremote below.\n"
"\n"
"                       If you are paranoid and do not think -noremote is\n"
"                       enough, to disable the VNC_CONNECT property channel\n"
"                       completely use -novncconnect, or use the -safer\n"
"                       option that shuts many things off.\n"
"\n"
"-unsafe                A few remote commands are disabled by default\n"
"                       (currently: id:pick, accept:<cmd>, gone:<cmd>, and\n"
"                       rawfb:setup:<cmd>) because they are associated with\n"
"                       running external programs.  If you specify -unsafe, then\n"
"                       these remote-control commands are allowed.  Note that\n"
"                       you can still specify these parameters on the command\n"
"                       line, they just cannot be invoked via remote-control.\n"
"-safer                 Equivalent to: -novncconnect -noremote and prohibiting\n"
"                       -gui and the -connect file. Shuts off communcation\n"
"                       channels.\n"
"-privremote            Perform some sanity checks and disable remote-control\n"
"                       commands if it appears that the X DISPLAY and/or\n"
"                       connectfile can be accessed by other users.  Once\n"
"                       remote-control is disabled it cannot be turned back on.\n"
"-nocmds                No external commands (e.g. system(3), popen(3), exec(3))\n"
"                       will be run.\n"
"\n"
"-deny_all              For use with -remote nodeny: start out denying all\n"
"                       incoming clients until \"-remote nodeny\" is used to\n"
"                       let them in.\n"
"%s\n"
"\n"
"These options are passed to libvncserver:\n"
"\n"
;
	/* have both our help and rfbUsage to stdout for more(1), etc. */
	dup2(1, 2);

	/* register extention(s) to get their help output */
#ifdef LIBVNCSERVER_WITH_TIGHTVNC_FILETRANSFER
	rfbRegisterTightVNCFileTransferExtension();
#endif

	if (mode == 1) {
		char *p;	
		int l = 0;
		fprintf(stderr, "x11vnc: allow VNC connections to real "
		    "X11 displays. %s\n\nx11vnc options:\n", lastmod);
		p = strtok(help, "\n");
		while (p) {
			int w = 23;
			char tmp[100];
			if (p[0] == '-') {
				strncpy(tmp, p, w);
				fprintf(stderr, "  %s", tmp);
				l++;
				if (l % 2 == 0) {
					fprintf(stderr, "\n");
				}
			}
			p = strtok(NULL, "\n");
		}
		fprintf(stderr, "\n\nlibvncserver options:\n");
		rfbUsage();
		fprintf(stderr, "\n");
		exit(1);
	}
	fprintf(stderr, help, lastmod,
		scaling_copyrect ? ":cr":":nocr",
		view_only ? "on":"off",
		shared ? "on":"off",
		vnc_connect ? "-vncconnect":"-novncconnect",
		use_modifier_tweak ? "-modtweak":"-nomodtweak",
		skip_duplicate_key_events ? "-skip_dups":"-noskip_dups",
		add_keysyms ? "-add_keysyms":"-noadd_keysyms",
		no_autorepeat ? "-norepeat":"-repeat",
		alt_arrow_max, alt_arrow,
		alpha_threshold,
		alpha_frac,
		cursor_pos_updates ? "-cursorpos":"-nocursorpos",
		wireframe ? "-wireframe":"-nowireframe",
		WIREFRAME_PARMS,
		wireframe_copyrect_default,
		scroll_copyrect_default,
		scrollcopyrect_min_area,
		scroll_skip_str0 ? scroll_skip_str0 : "(empty)",
		scroll_term_str0,
		max_keyrepeat_str0,
		SCROLL_COPYRECT_PARMS,
		pointer_mode_max, pointer_mode,
		ui_skip,
		defer_update,
		waitms,
		wait_ui,
		rfbMaxClientWait/1000,
		take_naps ? "take naps":"no naps",
		screen_blank,
		xdamage_max_area, NSCAN, xdamage_memory,
		use_threads ? "-threads":"-nothreads",
		fs_frac,
		gaps_fill,
		grow_fill,
		tile_fuzz,
		accept_remote_cmds ? "-yesremote":"-noremote",
		""
	);

	rfbUsage();
#endif
	exit(1);
}

void xopen_display_fail_message(char *disp) {
	fprintf(stderr, "\n");
	fprintf(stderr, "*** x11vnc was unable to open the X DISPLAY: \"%s\","
	    " it cannot continue.\n", disp);
	fprintf(stderr, "*** There may be \"Xlib:\" error messages above"
	    " with details about the failure.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "Some tips and guidelines:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " * An X server (the one you wish to view) must"
	    " be running before x11vnc is\n");
	fprintf(stderr, "   started: x11vnc does not start the X server.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " * You must use -display <disp>, -OR- set and"
	    " export your DISPLAY\n");
	fprintf(stderr, "   environment variable to refer to the display of"
	    " the desired X server.\n");
	fprintf(stderr, " - Usually the display is simply \":0\" (in fact"
	    " x11vnc uses this if you forget\n");
	fprintf(stderr, "   to specify it), but in some multi-user"
	    " situations it could be \":1\", \":2\",\n"); 
	fprintf(stderr, "   or even \":137\".  Ask your administrator"
	    " or a guru if you are having\n");
	fprintf(stderr, "   difficulty determining what your X DISPLAY is.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " * Next, you need to have sufficient permissions"
	    " (Xauthority) \n");
	fprintf(stderr, "   to connect to the X DISPLAY.   Here are some"
	    " Tips:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " - Often, you just need to run x11vnc as the user"
	    " logged into the X session.\n");
	fprintf(stderr, "   So make sure to be that user when you type"
	    " x11vnc.\n");
	fprintf(stderr, " - Being root is usually not enough because the"
	    " incorrect MIT-MAGIC-COOKIE\n");
	fprintf(stderr, "   file will be accessed.  The cookie file contains"
	    " the secret key that\n");
	fprintf(stderr, "   allows x11vnc to connect to the desired"
	    " X DISPLAY.\n");
	fprintf(stderr, " - You can explicity indicate which MIT-MAGIC-COOKIE"
	    " file should be used\n");
	fprintf(stderr, "   by the -auth option, e.g.:\n");
	fprintf(stderr, "       x11vnc -auth /home/someuser/.Xauthority"
	    " -display :0\n");
	fprintf(stderr, "   you must have read permission for that file.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " - If NO ONE is logged into an X session yet, but"
	    " there is a greeter login\n");
	fprintf(stderr, "   program like \"gdm\", \"kdm\", \"xdm\", or"
	    " \"dtlogin\" running, you will need\n");
	fprintf(stderr, "   to find and use the raw display manager"
	    " MIT-MAGIC-COOKIE file.\n");
	fprintf(stderr, "   Some examples for various display managers:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "     gdm:     -auth /var/gdm/:0.Xauth\n");
	fprintf(stderr, "     kdm:     -auth /var/lib/kdm/A:0-crWk72\n");
	fprintf(stderr, "     xdm:     -auth /var/lib/xdm/authdir/authfiles/A:0-XQvaJk\n");
	fprintf(stderr, "     dtlogin: -auth /var/dt/A:0-UgaaXa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "   Only root will have read permission for the"
	    " file, and so x11vnc must be run\n");
	fprintf(stderr, "   as root.  The random characters in the filenames"
	    " will of course change,\n");
	fprintf(stderr, "   and the directory the cookie file resides in may"
	    " also be system dependent.\n");
	fprintf(stderr, "   Sometimes the command \"ps wwaux | grep auth\""
	    " can reveal the file location.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "See also: http://www.karlrunge.com/x11vnc/#faq\n");
}

void nopassword_warning_msg(int gotloc) {

	char str1[] =
"###############################################################\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
"#@                                                           @#\n"
"#@  **  WARNING  **  WARNING  **  WARNING  **  WARNING  **   @#\n"
"#@                                                           @#\n"
"#@        YOU ARE RUNNING X11VNC WITHOUT A PASSWORD!!        @#\n"
"#@                                                           @#\n"
"#@  This means anyone with network access to this computer   @#\n"
"#@  will be able to easily view and control your desktop.    @#\n"
"#@                                                           @#\n"
"#@ >>> If you did not mean to do this Press CTRL-C now!! <<< @#\n"
"#@                                                           @#\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
;
	char str2[] =
"#@                                                           @#\n"
"#@  You can create an x11vnc password file by running:       @#\n"
"#@                                                           @#\n"
"#@      x11vnc -storepasswd password /path/to/passfile       @#\n"
"#@                                                           @#\n"
"#@  and then starting x11vnc via:                            @#\n"
"#@                                                           @#\n"
"#@      x11vnc -rfbauth /path/to/passfile                    @#\n"
"#@                                                           @#\n"
"#@  an existing ~/.vnc/passwd file will work too.            @#\n"
"#@                                                           @#\n"
"#@  You can also use the -passwdfile or -passwd options.     @#\n"
"#@  (note -passwd is unsafe if local users are not trusted)  @#\n"
"#@                                                           @#\n"
"#@  Make sure any -rfbauth and -passwdfile password files    @#\n"
"#@  cannot be read by untrusted users.                       @#\n"
"#@                                                           @#\n"
"#@  Even with a password, the subsequent VNC traffic is      @#\n"
"#@  sent in the clear.  Consider tunnelling via ssh(1):      @#\n"
"#@                                                           @#\n"
"#@    http://www.karlrunge.com/x11vnc/#tunnelling            @#\n"
"#@                                                           @#\n"
"#@  Please Read the documention for more info about          @#\n"
"#@  passwords, security, and encryption.                     @#\n"
"#@                                                           @#\n"
"#@    http://www.karlrunge.com/x11vnc/#faq-passwd            @#\n"
;
	char str3[] =
"#@                                                           @#\n"
"#@  You are using the -localhost option and that is a good   @#\n"
"#@  thing!! Especially if you ssh(1) into this machine and   @#\n"
"#@  use port redirection.  Nevertheless, without a password  @#\n"
"#@  other users could possibly do redirection as well to     @#\n"
"#@  gain access to your desktop.                             @#\n"
;
	char str4[] =
"#@                                                           @#\n"
"#@  To disable this warning use the -nopw option, or put     @#\n"
"#@  the setting in your ~/.x11vncrc file.                    @#\n"
"#@                                                           @#\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
"###############################################################\n"
;
	char str5[] =
"###############################################################\n\n"
;
	if (inetd) {
		return;
	}

	fprintf(stderr, "%s", str1);
	fflush(stderr);
#if !PASSWD_REQUIRED
	usleep(2500 * 1000);
#endif
	if (!quiet) {
		fprintf(stderr, "%s", str2);
		if (gotloc) {
			fprintf(stderr, "%s", str3);
		}
		fprintf(stderr, "%s", str4);
	} else {
		fprintf(stderr, "%s", str5);
	}
	fflush(stderr);
#if !PASSWD_REQUIRED
	usleep(500 * 1000);
#endif
}


