#ifndef _TKX11VNC_H
#define _TKX11VNC_H
#ifdef NOGUI
char gui_code[] = "";
#else
/*
 * tkx11vnc.h: generated by 'tkx11vnc -spit'
 * Abandon all hope, ye who enter here...
 * ...edit tkx11vnc instead.
 */
	char gui_code[] =
"#!/bin/sh\n"
"# the next line restarts using wish. \\\n"
"exec wish \"$0\" \"$@\"\n"
"catch {rename send {}}\n"
"#\n"
"# Copyright (c) 2004-2006 Karl J. Runge <runge@karlrunge.com>\n"
"# All rights reserved.\n"
"#\n"
"#  This is free software; you can redistribute it and/or modify\n"
"#  it under the terms of the GNU General Public License as published by\n"
"#  the Free Software Foundation; either version 2 of the License, or\n"
"#  (at your option) any later version.\n"
"#\n"
"#  This software is distributed in the hope that it will be useful,\n"
"#  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"#  GNU General Public License for more details.\n"
"#\n"
"#  You should have received a copy of the GNU General Public License\n"
"#  along with this software; if not, write to the Free Software\n"
"#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,\n"
"#  USA.\n"
"\n"
"#\n"
"# tkx11vnc v0.2\n"
"# This is a simple frontend to x11vnc.  It uses the remote control\n"
"# and query features (-remote/-query aka -R/-Q) to interact with it. \n"
"# It is just a quick-n-dirty hack (it parses -help output, etc), but\n"
"# it could be of use playing with or learning about the (way too) many\n"
"# parameters x11vnc has.\n"
"# \n"
"# It can be used to interact with a running x11vnc (see the x11vnc\n"
"# -gui option), or to set the parameters and then start up x11vnc.  \n"
"# \n"
"\n"
"#\n"
"# Below is a simple picture of how the gui should be laid out and how\n"
"# the menus should be organized.  Most menu items correspond to remote\n"
"# control commands. A trailing \":\" after the item name means it is a string\n"
"# to be set rather than a boolean that can be toggled (e.g. the entry\n"
"# box must be used).\n"
"#\n"
"# Some tweak options may be set in the prefix \"=\" string.\n"
"#	A means it is an \"Action\" (not a true variable)\n"
"#	R means it is an action only valid in remote mode.\n"
"#	S means it is an action only valid in startup mode.\n"
"#	Q means it is an action worth querying after running.\n"
"#	P means the string can be +/- appended/deleted (string may not\n"
"#         be the same after the remote command)\n"
"#	G means gui internal item\n"
"#	F means can be set via file browse\n"
"#	D means for simple gui\n"
"#	-C:val1,... means it will be a checkbox (radio button)\n"
"#	   the \"-\" means no other options follow\n"
"#	0 means to skip the item.\n"
"#	-- means add a separator\n"
"#\n"
"#       The =GAL ... =GAL LOFF stuff is to provide submenus.\n"
"#\n"
"\n"
"global env started time_count\n"
"set started \"\"\n"
"proc dtime {{msg \"\"}} {\n"
"	global started time_count\n"
"	if {$started == \"\"} {\n"
"		return\n"
"	}\n"
"	set diff [expr \"[exec gtod.bin] - $started\"]\n"
"	set diff [format \"%.2f\" $diff]\n"
"	incr time_count\n"
"	if {$msg == \"\"} {\n"
"		set msg $time_count\n"
"	}\n"
"	puts -nonewline stderr \"$msg $diff \" \n"
"	puts stderr [clock format [clock seconds]]\n"
"}\n"
"\n"
"if [info exists env(X11VNC_GUI_TIME)] {\n"
"	global started time_count\n"
"	set started [exec gtod.bin]\n"
"	set time_count 0\n"
"	dtime \"S\"\n"
"}\n"
"\n"
"proc set_template {} {\n"
"	global template\n"
"	set template \"\n"
"Row: Actions   Clients   Permissions  Keyboard    Pointer  Help\n"
"Row: Displays  Screen    Tuning       Debugging   Misc\n"
"\n"
"Actions\n"
"	=SA start\n"
"	=RA stop\n"
"	--\n"
"	=DSA attach\n"
"	=DRA detach\n"
"	--\n"
"	=RA ping\n"
"	=RA update-all\n"
"	=GAL Settings::\n"
"	=GA save-settings\n"
"	=SFA load-settings:\n"
"	=SA defaults-all\n"
"	=0SA clear-all\n"
"	--\n"
"	=F rc:\n"
"	norc\n"
"	=GAL LOFF\n"
"	-- D\n"
"	=DRA stop+quit \n"
"	=DGA Quit \n"
"\n"
"Help\n"
"	=DGA gui\n"
"	=DGA all\n"
"\n"
"Clients\n"
"	=DRQA current:\n"
"	=DF   connect:\n"
"	=DRQA disconnect:\n"
"	--\n"
"	accept:\n"
"	afteraccept:\n"
"	gone:\n"
"	vncconnect\n"
"	avahi\n"
"	-- D\n"
"	tightfilexfer\n"
"	ultrafilexfer\n"
"	=GAL Java-applet::\n"
"	=D http\n"
"	httpdir:\n"
"	httpport:\n"
"	enablehttpproxy\n"
"	=GAL LOFF\n"
"\n"
"Displays\n"
"	=D display:\n"
"	=F auth:\n"
"	=S reflect:\n"
"	=D desktop:\n"
"	=D rfbport:\n"
"	=0 gui:\n"
"\n"
"Screen\n"
"	=DRA refresh\n"
"	=RA reset\n"
"	=RA blacken\n"
"	-- D\n"
"	=D scale:\n"
"	scale_cursor:\n"
"	--\n"
"	=D solid\n"
"	solid_color:\n"
"	--\n"
"	=GAL OverlayVisuals::\n"
"	overlay\n"
"	overlay_nocursor\n"
"	8to24\n"
"	8to24_opts:\n"
"	=GAL LOFF\n"
"	=GAL 8-Bit-Color::\n"
"	flashcmap\n"
"	shiftcmap:\n"
"	notruecolor\n"
"	=GAL LOFF\n"
"	=GAL SubWindow::\n"
"	id:\n"
"	sid:\n"
"	=GAL LOFF\n"
"	=GAL ResizeRotate::\n"
"	= xrandr\n"
"	=-C:resize,newfbsize,exit xrandr_mode:\n"
"	rotate:\n"
"	padgeom:\n"
"	=GAL LOFF\n"
"	=GAL Clipping::\n"
"	=P blackout:\n"
"	xinerama\n"
"	clip:\n"
"	=GAL LOFF\n"
"	=GAL Misc-Screen::\n"
"	fixscreen:\n"
"	visual:\n"
"	rawfb:\n"
"	pipeinput:\n"
"	uinput_accel:\n"
"	uinput_reset:\n"
"	uinput_always:\n"
"	24to32\n"
"	=GAL LOFF\n"
"\n"
"Keyboard\n"
"	=D norepeat\n"
"	=D add_keysyms\n"
"	modtweak\n"
"	xkb\n"
"	--\n"
"	capslock\n"
"	skip_lockkeys\n"
"	--\n"
"	skip_keycodes:\n"
"	skip_dups\n"
"	sloppy_keys\n"
"	--\n"
"	=FP remap:\n"
"	clear_mods\n"
"	clear_keys\n"
"\n"
"Pointer\n"
"	=D-C:none,arrow,X,some,most cursor:\n"
"	=-C:1,2,3,4,5,6 arrow:\n"
"	--\n"
"	cursorpos\n"
"	=D nocursorshape\n"
"	--\n"
"	noxfixes\n"
"	cursor_drag\n"
"	=GAL AlphaBlending::\n"
"	noalphablend\n"
"	alphacut:\n"
"	alphafrac:\n"
"	alpharemove\n"
"	=GAL LOFF\n"
"	--\n"
"	buttonmap:\n"
"	--\n"
"	xwarppointer\n"
"\n"
"Misc\n"
"	=GD-C:full,icon,tray WindowView:\n"
"	=GD simple-gui\n"
"	-- D\n"
"	=GA all-settings\n"
"	=RA remote-cmd:\n"
"	=GAL Selection::\n"
"	=D nosel\n"
"	noprimary\n"
"	nosetprimary\n"
"	noclipboard\n"
"	nosetclipboard\n"
"	seldir:\n"
"	=GAL LOFF\n"
"	=GAL X-ext::\n"
"	xtrap\n"
"	xrecord\n"
"	=RQA reset_record\n"
"	=GAL LOFF\n"
"	=GAL MacOSX::\n"
"	macnosaver\n"
"	macnowait\n"
"	macwheel:\n"
"	macnoswap\n"
"	macnoresize\n"
"	maciconanim:\n"
"	macmenu\n"
"	=GAL LOFF\n"
"	--\n"
"	nofb\n"
"	=D nobell\n"
"	nolookup\n"
"	rfbversion:\n"
"	bg\n"
"	=S loop\n"
"	=S loopbg\n"
"	=-C:ignore,exit sigpipe:\n"
"	=0 inetd\n"
"\n"
"Debugging\n"
"	debug_pointer\n"
"	debug_keyboard\n"
"	=F logfile:\n"
"	=GA show-logfile\n"
"	=GA tail-logfile\n"
"	quiet\n"
"	--\n"
"	=GA show-start-cmd\n"
"	=DG debug_gui\n"
"	=GAL Misc-Debug::\n"
"	debug_xevents\n"
"	debug_xdamage\n"
"	=-C:0,1,2,3 debug_wireframe:\n"
"	debug_scroll\n"
"	debug_tiles\n"
"	debug_grabs\n"
"	debug_sel\n"
"	dbg\n"
"	=GAL LOFF\n"
"\n"
"Permissions\n"
"	=DRQA lock\n"
"	=DRQA unlock\n"
"	=D shared\n"
"	=D forever\n"
"	--\n"
"	=DFP allow:\n"
"	=D localhost\n"
"	=RA allowonce:\n"
"	listen:\n"
"	-- D\n"
"	=D viewonly\n"
"	input:\n"
"	--\n"
"	=GAL Passwords::\n"
"	passwd:\n"
"	viewpasswd:\n"
"	=F passwdfile:\n"
"	=F rfbauth:\n"
"	usepw\n"
"	--\n"
"	unixpw\n"
"	unixpw_list:\n"
"	unixpw_nis\n"
"	unixpw_nis_list:\n"
"	=0 storepasswd\n"
"	=GAL LOFF\n"
"	=GAL SSL::\n"
"	ssl\n"
"	=F ssl_pem:\n"
"	stunnel\n"
"	=F stunnel_pem:\n"
"	=F ssldir:\n"
"	=F sslverify:\n"
"	ssltimeout:\n"
"	https:\n"
"	=GAL LOFF\n"
"	=GAL Misc-Perms::\n"
"	safer\n"
"	unsafe\n"
"	=RA noremote\n"
"	=0S alwaysshared\n"
"	=0S nevershared\n"
"	=0S dontdisconnect\n"
"	=SQA deny_all\n"
"	timeout:\n"
"	grabkbd\n"
"	grabptr\n"
"	grabalways\n"
"	forcedpms\n"
"	clientdpms\n"
"	noserverdpms\n"
"	noultraext\n"
"	=GAL LOFF\n"
"\n"
"Tuning\n"
"	=D-C:0,1,2,3,4 pointer_mode:\n"
"	input_skip:\n"
"	allinput\n"
"	=D nodragging\n"
"	-- D\n"
"	speeds:\n"
"	=D wait:\n"
"	defer:\n"
"	=D nap\n"
"	screen_blank:\n"
"	--\n"
"	=GAL WireFrame::\n"
"	wireframe\n"
"	wireframe_mode:\n"
"	=-C:never,top,always wirecopyrect:\n"
"	=GAL LOFF\n"
"	=GAL ScrollCopyRect::\n"
"	=-C:never,keys,mouse,always scrollcopyrect:\n"
"	scr_area:\n"
"	scr_skip:\n"
"	scr_inc:\n"
"	scr_keys:\n"
"	scr_term:\n"
"	scr_keyrepeat:\n"
"	scr_parms:\n"
"	=GAL LOFF\n"
"	=GAL XDAMAGE::\n"
"	xdamage\n"
"	xd_area:\n"
"	xd_mem:\n"
"	=GAL LOFF\n"
"	=GAL Ncache::\n"
"	ncache\n"
"	ncache_size:\n"
"	ncache_cr\n"
"	ncache_no_moveraise\n"
"	ncache_no_dtchange\n"
"	ncache_no_rootpixmap\n"
"	ncache_keep_anims\n"
"	=A ncache_reset_rootpixmap\n"
"	=GAL LOFF\n"
"	--\n"
"	=GAL SharedMemory::\n"
"	noshm\n"
"	flipbyteorder\n"
"	onetile\n"
"	=GAL LOFF\n"
"	=GAL Misc-Tuning::\n"
"	progressive:\n"
"	fs:\n"
"	gaps:\n"
"	grow:\n"
"	fuzz:\n"
"	wait_ui:\n"
"	nowait_bog\n"
"	readtimeout:\n"
"	snapfb\n"
"	threads\n"
"	wmdt:\n"
"	rfbwait:\n"
"	nodpms\n"
"	nofbpm\n"
"	=GAL LOFF\n"
"\"\n"
"}\n"
"\n"
"proc set_internal_help {} {\n"
"	global helptext helpall\n"
"\n"
"	# set some internal item help here:\n"
"	set helptext(start) \"\n"
"Launch x11vnc with the settings you have prescribed in the gui.\n"
"The x11vnc process is started in an xterm window so you can see the\n"
"output, kill it, etc.\n"
"\n"
"By viewing this help item, the command built so far will be displayed\n"
"in the gui text area.  Have a look.  If you Press start it will be shown\n"
"as well and you will be asked to confirm running it.\n"
"\n"
"If you want to use a saved profile \\\"rc file\\\" you can do \\\"Misc -> rc\\\" and\n"
"select the file and simply start x11vnc using the rc file.  Alternatively,\n"
"you could first use the \\\"Actions -> load-settings\\\" action to load in\n"
"an \\\"rc file\\\" and then press \\\"Actions -> start\\\" to start up x11vnc\n"
"based on those values.\n"
"\"\n"
"	set helptext(stop) \"\n"
"The \\\"Actions -> stop\\\" action sends a signal to the running x11vnc\n"
"server indicating it should shutdown all connections and exit.\n"
"\n"
"The GUI stays running in case you want to start a new x11vnc or attach\n"
"to another one.  Use \\\"Actions -> Quit\\\" if you then want to have the\n"
"gui exit. Use \\\"Actions -> stop+quit\\\" to have both exit at once.\n"
"\"\n"
"\n"
"	set helptext(show-start-cmd) \"\n"
"Displays in the text area what the x11vnc start command (i.e. the command\n"
"run by \\\"Actions -> start\\\") looks like for the current values of the\n"
"settings.  This can be done even in the attached state.  Intended for\n"
"debugging the gui.  The help item for \\\"Actions -> start\\\" gives the\n"
"same info.\n"
"\n"
"If you want to load in a saved profile \\\"rc file\\\" use \\\"Misc -> rc\\\"\n"
"and select the file.  \\\"Actions -> load-settings\\\" does a similar thing\n"
"with an rc-file, but reading the file and setting the gui variables to\n"
"its values.\n"
"\"\n"
"\n"
"	set helptext(debug_gui) \"\n"
"Set debug_gui to get more output printed in the text area.\n"
"\"\n"
"\n"
"	set helptext(detach) \"\n"
"No longer be associated with the x11vnc server.  Switch to the\n"
"non-connected state.  The x11vnc server keeps running: it does not exit.\n"
"\n"
"You can either later reattach to it \\\"Actions -> attach\\\", or start\n"
"up a new x11vnc \\\"Actions -> start\\\", or exit \\\"Actions -> Quit\\\".\n"
"\"\n"
"\n"
"	set helptext(attach) \"\n"
"Attach to a running x11vnc server, if possible.  Switches to connected\n"
"state if successful.  Usually the channel used to attach is via the X\n"
"display (VNC_CONNECT rootwin property) being polled by the x11vnc server.\n"
"To change or set the X display to use do \\\"Displays -> display\\\".\n"
"\n"
"Sometimes the \\\"-connect /path/to/filename\\\" is used as the communcation\n"
"channel.  The running x11vnc has to know that \\\"/path/to/filename\\\"\n"
"is the communication channel (i.e. it is using the same -connect option).\n"
"\"\n"
"\n"
"	set helptext(ping) \"\n"
"Check if x11vnc still responds to \\\"ping\\\" remote command.\n"
"\"\n"
"\n"
"	set helptext(update-all) \"\n"
"Query the x11vnc server for the current values of all variables.\n"
"Populate the values into the gui's database.\n"
"\n"
"Normally the gui will refresh this info every time it interacts with\n"
"the x11vnc server (including after a few minutes of inactivity), so one\n"
"doesn't need to use this action very often (unless something else is\n"
"changing the state of the x11vnc server, or new clients have connected,\n"
"etc).\n"
"\"\n"
"\n"
"	set helptext(clear-all) \"\n"
"Forget any variable settings either entered in by you or set at the\n"
"default.  Basically sets everything to 0 or the string (unset).\n"
"\n"
"This action is only available in \\\"startup\\\" mode, not when connected\n"
"to a running x11vnc server (in that case the variable settings reflect\n"
"the state of the running x11vnc).  To detach from a running x11vnc\n"
"server use \\\"Actions -> detach\\\"; to completely stop the x11vnc server\n"
"use \\\"Actions -> stop\\\".\n"
"\"\n"
"\n"
"	set helptext(defaults-all) \"\n"
"Reset all variable settings to the default values.  Basically sets\n"
"everything to the default queries \\\"x11vnc -QD var\\\" retrieved at startup.\n"
"\n"
"This action is only available in \\\"startup\\\" mode, not when connected\n"
"to a running x11vnc server (in that case the variable settings reflect\n"
"the state of the running x11vnc).  To detach from a running x11vnc\n"
"server use \\\"Actions -> detach\\\"; to completely stop the x11vnc server\n"
"use \\\"Actions -> stop\\\".\n"
"\"\n"
"\n"
"	set helptext(load-settings) \"\n"
"Read in the \\\"rc file\\\" you prescribe in the dialog and then set the\n"
"variables to those in the rc-file.  Any variables not mentioned in the\n"
"rc-file are set to their default value.\n"
"\n"
"You could then do \\\"Actions -> start\\\" to start x11vnc with these\n"
"parameters.  Or you could make some further changes to variables\n"
"using the gui before starting x11vnc.\n"
"\n"
"This action is only available in \\\"startup\\\" mode, not when connected\n"
"to a running x11vnc server (in that case the variable settings reflect\n"
"the state of the running x11vnc).  To detach from a running x11vnc\n"
"server use \\\"Actions -> detach\\\"; to completely stop the x11vnc server\n"
"use \\\"Actions -> stop\\\".\n"
"\"\n"
"\n"
"	set helptext(save-settings) \"\n"
"Construct a ~/.x11vncrc file based on the current settings and\n"
"offer to save it in a file (default ~/.x11vncrc).  If saved in a\n"
"file other than the default, you can access the profile by using\n"
"the \\\"-rc <filename>\\\" option when starting x11vnc.\n"
"\n"
"If an rc file entry begins with \\\"#d\\\" that means the current\n"
"setting is at the Default value and so you probably want to leave\n"
"it commented out with the \\\"#\\\" character.\n"
"\n"
"If an rc file entry begins with \\\"#?\\\" that means we think\n"
"you probably do not really want to force the value to this setting.\n"
"\n"
"In either case, feel free to uncomment the line and/or change any\n"
"of the parameter values in the file. \n"
"\"\n"
"\n"
"	set helptext(all-settings) \"\n"
"Displays the gui's database of all of the x11vnc server's current\n"
"settings.  Use \\\"Actions -> update-all\\\"  or \\\"Control+R\\\" to\n"
"refresh this list if it ever gets out of sync.\n"
"\"\n"
"\n"
"	set helptext(remote-cmd) \"\n"
"Run a remote command (-R) or query (-Q) directly.  Only a few\n"
"remote commands are not on a menu, but for those few you can\n"
"run the command directly this way.  Just enter the command into\n"
"the Entry box when prompted.  Use the prefix \\\"Q:\\\" to indicate\n"
"a -Q query.  Examples: \\\"zero:20,20,100,100\\\", \\\"Q:ext_xfixes\\\"  \n"
"\"\n"
"\n"
"	set helptext(stop+quit) \"\n"
"Send the stop command to the x11vnc server, then terminate the tkx11vnc gui.\n"
"\"\n"
"\n"
"	set helptext(show-logfile) \"\n"
"View the current contents of the logfile (if it exists and is accessible\n"
"by the gui process).\n"
"\"\n"
"\n"
"	set helptext(tail-logfile) \"\n"
"Run the tail(1) command with -f option on the logfile in an xterm.\n"
"(if it exists and is accessible by the gui process).\n"
"\"\n"
"\n"
"	set helptext(Quit) \"\n"
"Terminate the tkx11vnc gui.  Any x11vnc server will be left running.\n"
"\"\n"
"\n"
"	set helptext(current) \"\n"
"Shows a menu of currently connected VNC clients on the x11vnc server.\n"
"\n"
"Allows you to find more information about them, change their input\n"
"permissions, or disconnect them.\n"
"\n"
"Note that the File transfer permission only applies to UltraVNC\n"
"file transfer, not TightVNC file transfer.\n"
"\n"
"You will be prompted to confirm any disconnections.\n"
"\"\n"
"\n"
"	set helptext(client) \"\n"
"After selecting a VNC client from the \\\"Clients -> current\\\" menu,\n"
"you will be presented with a dialog that shows the information\n"
"about the VNC client.\n"
"\n"
"You can choose to disconnect the client by clicking on the \n"
"\\\"Disconnect\\\" checkbox and pressing \\\"OK\\\".  There will be a\n"
"confirmation dialog to doublecheck.\n"
"\n"
"Alternatively, you can fine tune the VNC client's input permissions\n"
"by selecting any of the Keystrokes, Mouse-Motion, Button-Click,\n"
"Clipboard-Input, or Files checkboxes and pressing \\\"OK\\\".  This is like\n"
"the \\\"-input\\\" option but on a per-client basis.\n"
"\n"
"To not change any aspects of the VNC client press \\\"Cancel\\\".\n"
"\"\n"
"\n"
"	set helptext(solid_color) \"\n"
"Set the -solid color value.\n"
"\"\n"
"\n"
"	set helptext(xrandr_mode) \"\n"
"Set the -xrandr mode value.\n"
"\"\n"
"\n"
"	set helptext(unixpw_list) \"\n"
"Set the -unixpw usernames list value.\n"
"\"\n"
"\n"
"	set helptext(unixpw_nis_list) \"\n"
"Set the -unixpw_nis usernames list value.\n"
"\"\n"
"\n"
"	set helptext(stunnel_pem) \"\n"
"Set the -stunnel pem filename value.\n"
"\"\n"
"\n"
"	set helptext(ssl_pem) \"\n"
"Set the -ssl pem filename value.\n"
"\"\n"
"\n"
"	set helptext(wireframe_mode) \"\n"
"Set the -wireframe mode string value.\n"
"\"\n"
"\n"
"	set helptext(simple-gui) \"\n"
"Toggle between menu items corresponding the most basic ones\n"
"and all possible settings.  I.e. toggle between a simple gui\n"
"and one for power users.\n"
"\"\n"
"\n"
"	set helptext(Tray) \"\n"
"The tray/icon mode (started with \\\"x11vnc -gui tray ...\\\", etc.) presents\n"
"a small icon that indicates the status of the running x11vnc server.\n"
"\n"
"Depending on your environment, this icon may be embedded in a system\n"
"tray or applet dock, or simply be a standalone window.  \\\"-gui tray\\\"\n"
"will attempt to embed the icon in the system tray, while \\\"-gui icon\\\"\n"
"is for a standalone window.  Use \\\"-gui tray=setpass\\\" (or icon=setpass)\n"
"to be prompted to set the session password at startup.\n"
"\n"
"When the icon has a light background, that means no VNC viewers are\n"
"currently connected to the VNC display.\n"
"\n"
"When the icon has a dark background (i.e. reverse-video), that means at\n"
"least one VNC viewer is connected to the VNC display.\n"
"\n"
"Moving the mouse pointer over the icon will popup a \\\"status balloon\\\"\n"
"indicating the VNC display name and the names and info of any connected VNC\n"
"viewers.  Press the middle mouse button if the balloon does not appear.\n"
"\n"
"Clicking the left or right mouse button on the icon displays a menu\n"
"of actions:\n"
"\n"
"    Properties      - Brings up the Properties dialog to set some basic\n"
"                      parameters.  The full tkx11vnc GUI may be accessed\n"
"                      via the \\\"Advanced ...\\\" button.  Press \\\"Help ...\\\"\n"
"                      in the Properties dialog for more info.\n"
"    \n"
"    Help            - Displays this help text.\n"
"    \n"
"    New Client      - Presents an entry box where you type in the name\n"
"                      of a computer that is running a VNC viewer in\n"
"                      \\\"listen\\\" mode (e.g. vncviewer -listen).  For a\n"
"                      non-standard listening port use \\\"host:port\\\".\n"
"\n"
"                      Pressing \\\"OK\\\" will initiate the reverse\n"
"                      connection.  Use a blank hostname to skip it.\n"
"    \n"
"    Disconnect      - Shows a popup menu of connected clients.  Click on\n"
"                      one to disconnect it, or click on \\\"All Clients\\\"\n"
"                      disconnect all clients.\n"
"\n"
"    Window View     - Switch between the \\\"full\\\" gui (also known as\n"
"                      \\\"Advanced\\\"), \\\"icon\\\" mode (small icon window with\n"
"                      popups), or \\\"tray\\\" mode (small icon embedded in the\n"
"                      system tray).  This is a shortcut for the action:\n"
"                      \\\"Properties -> Advanced -> Misc -> WindowView\\\".\n"
"    \n"
"    Stop x11vnc     - Directs the x11vnc server to disconnect all vncviewers\n"
"                      and then exit.  The tray/icon GUI then exits as well.\n"
"\n"
"    Custom          - If you have a \\$HOME/.x11vnc.gui file each uncommented\n"
"                      line in it becomes an additional menu item for this\n"
"                      menu.  The remote control command is run directly\n"
"                      via \\\"x11vnc -R <command>\\\", or if prefixed with \n"
"                      \\\"action:\\\" runs a gui internal action, or if \\\"sep\\\"\n"
"                      adds a separator.  Set X11VNC_CUSTOM_GUI to use\n"
"                      a different filename.  Example file contents:\n"
"\n"
"                             scale:3/4\n"
"                             scale:1\n"
"                             scale_cursor:1\n"
"                             sep\n"
"                             action:all-settings\n"
"                             #debug_keyboard\n"
"                             sep\n"
"                             action:Quit\n"
"\n"
"Termination:\n"
"\n"
"If the x11vnc server stops for any reason, the tray/icon gui will exit.\n"
"\n"
"If you delete the tray/icon (e.g. X out button), that is the same\n"
"as the \\\"Stop x11vnc\\\" action in the menu. (This will disconnect any\n"
"VNC viewer you are currently using to access the display since the\n"
"x11vnc server is terminated).\n"
"\n"
"To terminate the tray/icon gui window but not the x11vnc server press\n"
"Control-C on the tray/icon window.  You can also do this (and much\n"
"more) via Properties -> Advanced -> Actions -> Quit\n"
"\"\n"
"\n"
"	set helptext(NewClient) \"\n"
"    New Client      - Presents an entry box where you type in the name\n"
"                      of a computer that is running a VNC viewer in\n"
"                      \\\"listen\\\" mode (e.g. vncviewer -listen).  For a\n"
"                      non-standard listening port use \\\"host:port\\\".\n"
"\n"
"                      Pressing \\\"OK\\\" will initiate the reverse\n"
"                      connection.  Use a blank hostname to skip it.\n"
"    \n"
"\"\n"
"\n"
"	set helptext(Properties) \"\n"
"The Properties dialog allows you to set some basic parameters of a\n"
"running x11vnc server.  After modifying them press \\\"OK\\\" or \\\"Apply\\\"\n"
"to apply the changes, or press \\\"Cancel\\\" to skip applying them.\n"
"\n"
" - \\\"Accept Connections\\\" toggles whether VNC viewers are allowed\n"
"   to connect or not.  It corresponds to the \\\"-R unlock\\\" and \\\"-R lock\\\"\n"
"   remote-control commands.\n"
"   \n"
" - \\\"Ask for Confirmation\\\" toggles whether a popup menu will be presented\n"
"   at the X display when a new VNC viewer attempts to connect.  The person\n"
"   sitting at the X display can choose to accept or reject the connection\n"
"   or accept the connection in View-Only mode.  It corresponds to the \n"
"   \\\"-R accept:popup\\\" and \\\"-R accept:\\\" remote-control commands.\n"
"   \n"
" - \\\"All Clients ViewOnly\\\" toggles whether the entire VNC desktop is\n"
"   view only.  All clients will only be able to watch when this is set\n"
"   (regardless of how they logged in).  It corresponds to the\n"
"   \\\"-R viewonly\\\" and \\\"-R noviewonly\\\" remote-control commands.\n"
"   \n"
" - \\\"Shared\\\" toggles whether multiple simultaneous connections are\n"
"   allowed or not.  It corresponds to the \\\"-R shared\\\" and \\\"-R noshared\\\"\n"
"   remote-control commands.\n"
"\n"
" - \\\"Password\\\" lets you set the session password viewers may use to gain full\n"
"   access to the display.  This will only work if x11vnc was started with \n"
"   the -gui icon or -gui tray mode.\n"
"   \n"
" - \\\"ViewOnly Password\\\" lets you set the session password viewers may\n"
"   use to gain view only access to the display.  This will only work if\n"
"   x11vnc was started with the -gui icon or -gui tray mode.\n"
"\n"
"NOTE: These \\\"session\\\" passwords only last for the current x11vnc\n"
"session (they are not remembered, see the -storepasswd, -passwdfile,\n"
"and -rfbauth x11vnc options for using stored passwords).\n"
"\n"
"If you set \\\"Password\\\" to the empty string that makes the \\\"View-Only\n"
"Password\\\" empty as well and removes the need for any password to log in.\n"
"\n"
"If you set \\\"ViewOnly Password\\\" to the empty string that just removes\n"
"the ViewOnly log in aspect: \\\"Password\\\" is still required to log in.\n"
"\n"
" - The \\\"Help ...\\\" button shows this help text.\n"
"   \n"
" - The \\\"Advanced ...\\\" button replaces the Properties dialog with the full\n"
"   tkx11vnc GUI.  All dynamic settings can be modified in the full GUI.\n"
"\n"
"\n"
"--------------------------------------------------------------------\n"
"Don't Lock Yourself Out:\n"
"\n"
"   If you are sitting at the physical X display you cannot get into too\n"
"   much trouble setting the Properties dialog values.\n"
"\n"
"   However IF you are using a VNC Viewer to REMOTELY access the X display\n"
"   some items in the Properties dialog can lock you out of further access:\n"
"\n"
"      \\\"Accept Connections\\\"  if you disable this remotely, and\n"
"      accidentally disconnect your VNC viewer then you will not be\n"
"      able to reconnect.\n"
"   \n"
"      \\\"Ask for Confirmation\\\"  if you enable this only someone\n"
"      sitting at the X display can confirm any new VNC connections.\n"
"      Furthermore, any current VNC viewers will be blocked while\n"
"      waiting for the confirmation (times out in 120 sec by default). \n"
"   \n"
"      \\\"All Clients ViewOnly\\\"  if you enable this remotely, well\n"
"      you can no longer provide input to disable it.\n"
"   \n"
"   If you do lock yourself out you could log in remotely and start up\n"
"   a second x11vnc and connect to that one to try to fix things in the\n"
"   first one.\n"
"\n"
"   Note that if there are two or more x11vnc's on the same display the\n"
"   use of the GUI may be ill-behaved.  Terminate the second x11vnc as\n"
"   soon as you have fixed the setting in the first one.  Use of a remote\n"
"   control command, e.g. \\\"x11vnc -R noviewonly\\\" or \\\"x11vnc -R unlock\\\"\n"
"   is a good way to avoid this problem.\n"
"\"\n"
"\n"
"	set helptext(all) $helpall\n"
"\n"
"	set helptext(Misc-Tuning:) \"\n"
"x11vnc has what seems like hundreds of tuning parameters!  In this\n"
"sub-menu we place some lesser used ones.  Most likely you'll want to\n"
"leave them at their default values, but you can try them out quickly\n"
"with the gui to see if they improve things.\n"
"\"\n"
"\n"
"	set helptext(Passwords:) \"\n"
"The items in this sub-menu pertain to setting passwords.  Note that x11vnc\n"
"has two types of password files: RealVNC-style ones (you can create them\n"
"with x11vnc -storepasswd or other VNC utility program) you use these\n"
"via -rfbauth; and plain-text file passwords you use via -passwdfile.\n"
"\n"
"Normally passwords cannot be changed by remote-control (e.g. the gui),\n"
"but for the case of the \\\"Icon\\\" and \\\"Tray\\\" modes this constraint has\n"
"been relaxed.\n"
"\n"
"In neither the RealVNC-style nor the plain-text file cases should the\n"
"password files be readable by users you do not want to access the VNC\n"
"server.  Contrary to popular belief, the  RealVNC-style passwords are\n"
"not encrypted, merely obscured.\n"
"\n"
"x11vnc has the even less secure -passwd and -viewpasswd supplied on\n"
"the command line.  Be careful with these since they could be read by\n"
"users with something like the ps(1) command.  On some operating systems\n"
"x11vnc tries to quickly overwrite them on the command line but it doesn't\n"
"work everywhere.\n"
"\n"
"Regarding ViewOnly passwords (where a VNC client using that password\n"
"can only watch the screen, not interact with it), this is not available\n"
"with -rfbauth, but only with -passwdfile, -passwd, and -viewpasswd.\n"
"\"\n"
"\n"
"	set helptext(SSL:) \"\n"
"In this sub-menu we provide the options related to SSL encrpytion\n"
"and authentication.\n"
"\n"
"There is a built-in mode (-ssl) using the OpenSSL library, and a 2nd\n"
"using the external stunnel program (-stunnel, that needs to be installed\n"
"on the system).  Either may require or benefit from having PEM certificate\n"
"files specified.\n"
"\n"
"\"\n"
"\n"
"	set helptext(Misc-Perms:) \"\n"
"In this sub-menu we provide some lesser used permission options.\n"
"\n"
"Regarding -alwaysshared, -nevershared, and -dontdisconnect, you probably\n"
"should never use them and just use x11vnc's -shared and -forever options\n"
"instead (these give basically the same functionality and if you mixed\n"
"them too much unexpected things may happen).\n"
"\"\n"
"#'\n"
"\n"
"	set helptext(AlphaBlending:) \"\n"
"In this sub-menu we provide some tweak parameters for cursors (little\n"
"icon at the mouse pointer) that have transparency (i.e. an Alpha channel\n"
"in addition to Red, Green, and Blue RGB channels).  For these cursors,\n"
"some of the graphics underneath the cursor is allowed to be blended in:\n"
"e.g. a drop-shadow (a terrible effect IMNSHO).\n"
"\n"
"AlphaBlending for x11vnc is only available when the XFIXES X extension is\n"
"present (since otherwise it cannot see the cursors at all and so applies\n"
"heuristics to show some fake cursors).  AlphaBlending is only a problem\n"
"with x11vnc when the cursors are not opaque.\n"
"\n"
"Opaque cursors (e.g. bitmap or simply colored cursor) are rendered\n"
"correctly by x11vnc.  Only when there is transparency does x11vnc have\n"
"to make some approximation to transform the cursor to be opaque (the\n"
"VNC protocol does not provide for an alpha channel in cursors, only RGB).\n"
"\n"
"The items in this sub-menu let you tweak x11vnc's approximation scheme\n"
"for cursors with transparency.  Hopefully you won't have to use them.\n"
"Certain cursor \\\"themes\\\" may require adjustment however.\n"
"\"\n"
"#'\n"
"	set helptext(OverlayVisuals:) \"\n"
"In this sub-menu are some options that involve fixing color problems\n"
"for \\\"Overlay\\\" or \\\"Multi-Depth\\\" visuals.  This problem is rare\n"
"since overlay and multi-depth visual video hardware is rare. \n"
"Some Sun, SGI, and HP machines are known to have them.\n"
"\n"
"The short answer is if you have a multi-depth visual display (e.g.  8 and\n"
"24 bits), and you see messed up colors in x11vnc try the \\\"-overlay\\\"\n"
"option on Solaris or IRIX.\n"
"\n"
"A brief Background on pixels, color, and visuals:\n"
"\n"
"   Pixels (picture elements) are kept in video memory as a certain number\n"
"   of bits-per-pixel (bpp).  Most common are 8bpp, 16bpp, and 32bpp.\n"
"   Less common are 24bpp, 4bpp, and 1bpp (monochrome).\n"
"\n"
"   How pixel values (i.e. values of the bits) are rendered into colors on\n"
"   the screen can be done via different \\\"Recipes\\\".  These different\n"
"   recipes are referred to as \\\"visuals\\\".  E.g. for 8bpp there is\n"
"   a PseudoColor visual that maintains a mapping (that can be changed\n"
"   dynamically) of the pixel values (256 possible ones) into RGB values.\n"
"   Other 8bpp visuals, e.g. StaticGrey and TrueColor have fixed, regular\n"
"   mappings and so provide less variation in kinds of colors.\n"
"\n"
"   A visual's \\\"depth\\\" is how many of the pixels are used in the\n"
"   actual recipe.  This may sound wasteful (i.e. not using some of the\n"
"   bits), but for 32bpp (4 billion colors) that is too much and nearly\n"
"   always only 24 for them are used.  The most common Visual seems to\n"
"   be depth 24 TrueColor at 32bpp.  This provides 16 million colors\n"
"   which is more than the number of pixels on most screens (1280x1024 =\n"
"   1.3 million pixels).  Another sometimes used visual that ignores some\n"
"   bits is depth 15 TrueColor at 16bpp.\n"
"\n"
"OK, now, finally, to the Overlay Visuals.  Some hardware (or software\n"
"emulations) allow different depth visuals to be used on the display\n"
"at the same time.  The pixels of windows using different depth visuals\n"
"may overlap.\n"
"\n"
"The most common seems to be both 8 and 24 depth visuals on a 32bpp setup.\n"
"24 of the pixels can be used for one visual and the remaining 8 for the\n"
"other.  This is sometimes referred to as \\\"8+24\\\" mode.  Furthermore,\n"
"a speedup is achieved because writing graphics data to, say, the 8bit\n"
"visual does not destroy the image data in the 24bit visual.  Evidently\n"
"popup menus can be done very quickly this way: they use the 8bit visual\n"
"and when the popup goes away the graphics data in the 24bit visual is\n"
"immediately reexposed without having the application redraw it.\n"
"\n"
"Also, some legacy applications can only use 8bpp visuals.  But in these\n"
"days of high color graphics and web browsers one would like the rest\n"
"of the desktop to use depth 24 visuals.  They often work on the multi\n"
"depth visuals.\n"
"\n"
"How does this effect x11vnc?  x11vnc nearly always polls the root window\n"
"(container of all other windows).  The root window will be one depth,\n"
"e.g. 8 or 24.  Any windows using the *other* depth will appear to have\n"
"messed up colors (or just be black or some other solid color) when viewed\n"
"via x11vnc.\n"
"\n"
"How to fix?  Solaris and IRIX provide an API to extract the full snapshot\n"
"of the display with all the colors correct.  It comes to x11vnc as depth\n"
"24 TrueColor.  To enable this use the \\\"-overlay\\\" option.  Performance\n"
"may be slower, but if the colors are correct that is a big improvement.\n"
"\"\n"
"\n"
"	set helptext(8-Bit-Color:) \"\n"
"Some older displays (e.g. with limited Video RAM) use 8 bits-per-pixel\n"
"color.  This allows for only 256 different colors on the screen at the\n"
"same time.  This sometimes leads to problems with viewing these 8bpp\n"
"displays via x11vnc.  This sub-menu has some options that correspond to\n"
"workarounds for this case.  If you can configure the machine to use 16bpp\n"
"it may be worth it to avoid the color problems (e.g. color flashing\n"
"as the 8bit colormap is switched).\n"
"\"\n"
"	set helptext(SubWindow:) \"\n"
"This sub-menu has a couple options regarding having x11vnc poll a \n"
"single window, not the entire display.  This way just the window\n"
"is shared.\n"
"\n"
"Note if the application pops up multiple windows they are not tracked\n"
"and shared.  So this is not application sharing.  The application has to\n"
"be very simple (e.g. a simple terminal or the image window on a webcam)\n"
"for this mode to be usable.\n"
"\"\n"
"	set helptext(ResizeRotate:) \"\n"
"This sub-menu has some options regarding screens that support the X\n"
"Resize, Reflection, and Rotation Extension (RANDR), and one expects screen\n"
"resizing, reflection, or rotation to take place during the x11vnc session.\n"
"This is pretty rare, but x11vnc seems to handle it reasonably well using\n"
"this X extension.\n"
"\n"
"This mode is on by default in -id mode to try to track the changing\n"
"size of the SubWindow.  It is not on by default for full-screen mode\n"
"because of the extra overhead, etc.\n"
"\"\n"
"\n"
"	set helptext(WireFrame:) \"\n"
"This sub-menu has some options for the x11vnc wireframing speedup scheme.\n"
"\n"
"For x11vnc, Wireframing means to watch for toplevel windows being Opaquely\n"
"Moved or Resized.  When x11vnc detects this, it stops polling the screen\n"
"and simply shows a \\\"wireframe\\\" outline of the window as it is being\n"
"moved or resized.  This avoids \\\"screen polling thrashing\\\" when the\n"
"screen is changing so rapidly during this period.  For various reasons\n"
"this is usually much faster then letting the window manager do its\n"
"own wireframing (you are encouraged to do Opaque moves and resizes\n"
"when using x11vnc!)\n"
"\n"
"Also, once a moved window is released in its new position, x11vnc uses\n"
"the VNC CopyRect encoding to very efficiently update the VNC viewers\n"
"(each just copies the image data locally).\n"
"\n"
"This sort of scheme was used much in the 1990's on local displays because\n"
"video hardware was slow at the time.  x11vnc tries to use this same trick\n"
"as a speedup for its activities (the network is much slower than video\n"
"hardware writes, and the video hardware reads that x11vnc uses to poll\n"
"the screen are still slow today).\n"
"\"\n"
"#'\"\n"
"\n"
"	set helptext(Safe:) \"\n"
"In this sub-menu are some options for making x11vnc operations\n"
"more, or less, safe.  E.g. disable the running of external commands, etc.\n"
"\n"
"You can also turn off the Remote control channel (NOTE that doing that\n"
"will disable the GUI from being able to communicate with x11vnc).\n"
"\"\n"
"\n"
"	set helptext(X-ext:) \"\n"
"In this sub-menu are a few rarely used options regarding some X extensions\n"
"used by x11vnc.\n"
"\"\n"
"	set helptext(Clipping:) \"\n"
"In this sub-menu are some options regarding clipping or blacking out\n"
"portions of the Screen.  E.g. under XINERAMA when the multiple monitors\n"
"are not the same size.\n"
"\n"
"\"\n"
"	set helptext(Misc-Screen:) \"\n"
"In this sub-menu are some little used options modifying aspects of\n"
"the screen source.\n"
"\"\n"
"\n"
"	set helptext(Settings:) \"\n"
"In this sub-menu are some options for saving and loading option settings.\n"
"The default file to store settings in is ~/.x11vncrc, but you can save\n"
"different \\\"profiles\\\" in other files for later use.\n"
"\n"
"\"\n"
"	set helptext(Java-applet:) \"\n"
"In this sub-menu are some options for running the built-in HTTP server\n"
"that delivers the TightVNC Java VNC Viewer applet (VncViewer.jar) to\n"
"clients.  The viewer runs in their Web browser.\n"
"\n"
"The default port listened on is 5800, so the URL is typically:\n"
"\n"
"	http://hostname:5800/\n"
"\n"
"but this can be altered by -httpport, etc.\n"
"\"\n"
"\n"
"	set helptext(ScrollCopyRect:) \"\n"
"This sub-menu has some options for the x11vnc Scroll detection and\n"
"CopyRect speedup scheme.\n"
"\n"
"For this mode, x11vnc \\\"spies\\\" on communication between the X server and\n"
"applications using the RECORD extension.  It looks for various patterns\n"
"to detect a scrolled window.  This only works for some applications,\n"
"fortunately some important ones.\n"
"\n"
"Once the scroll is detected it uses the VNC CopyRect encoding for a\n"
"big speedup.  Screen polling is also sped up for this scheme.\n"
"\n"
"There are many tweakable parameters for this mode and they are described\n"
"in the sub-menu items.\n"
"\"\n"
"\n"
"	set helptext(XDAMAGE:) \"\n"
"The DAMAGE X extension allows the X server to send signals to x11vnc\n"
"telling it which regions of the screen have been changed.  This improves\n"
"x11vnc's performance markedly.  The DAMAGE extension must be available\n"
"on the display for this to work.\n"
"\n"
"Unfortunately DAMAGE cannot be trusted completely for the changed regions,\n"
"because often the reported changed region is much larger than the actual\n"
"changed regions.  Nevertheless, x11vnc uses the DAMAGE information very\n"
"effectively as hints to improve its performance.\n"
"\n"
"The items in the sub-menu allow tweaking x11vnc's DAMAGE algorithm.\n"
"\"\n"
"\n"
"	set helptext(Ncache:) \"\n"
"A simple client-side (viewer) caching scheme is enabled with the\n"
"\\\"-ncache n\\\" option.  It simply uses \\\"n\\\" framebuffer sized areas\n"
"below the actual display for caching window pixel data.  \n"
"\n"
"Drawbacks are it uses a lot of RAM (roughly n times more), and the\n"
"pixels cache area is visible in the viewers.\n"
"\n"
"The items in the sub-menu allow tweaking x11vnc's -ncache algorithm.\n"
"\"\n"
"\n"
"	set helptext(SharedMemory:) \"\n"
"This sub-menu provides some options regarding SYSV shared memory usage\n"
"(shm) by x11vnc.  Usually you want shm turned on because the x11vnc\n"
"process is nearly always running on the same machine the X server process\n"
"is running on.  SharedMemory gives a performance speedup.  However, if you\n"
"need to modify this scenario for special usage these options allow you to.\n"
"\"\n"
"\n"
"	set helptext(Misc-Debug:) \"\n"
"This sub-menu contains a lot of debugging parameters usually used\n"
"for debugging x11vnc itself.  This is unlike the -debug_pointer and\n"
"-debug_keyboard options that are useful in learning information, quirks,\n"
"etc. about your local display and environment.\n"
"\"\n"
"\n"
"	set helptext(Selection:) \"\n"
"This sub-menu contains some options centering around the Selection\n"
"(also referred to as the Clipboard, Cutbuffers, etc).  x11vnc will try\n"
"to exchange the selections between the VNC viewers and the X server.\n"
"You can adjust that behavior with these options.\n"
"\"\n"
"\n"
"	set helptext(WindowView) \"\n"
"Set the Window View Mode for the gui.  There are three modes:\n"
"\n"
"  - full:  Presents the full gui (Actions, Clients, etc, buttons,\n"
"           and the Text area and Set/Entry box).\n"
"\n"
"  - icon:  Presents a small icon instead of the full gui.  Moving\n"
"           the mouse over it shows the VNC display name and any\n"
"           connected clients.  Clicking on the icon pops up a menu\n"
"           of actions to perform.  Among them is \\\"Properties\\\" that\n"
"           allows setting more parameters.  Clicking on \\\"Advanced\\\"\n"
"           in \\\"Properties\\\" brings up the full gui.\n"
"\n"
"  - tray:  Attempt to embed the small icon in the system tray.  If\n"
"           this fails it will resort to icon mode where the small icon\n"
"           is a standalone window.\n"
"\n"
"Note that in \\\"full\\\" mode if you delete the full gui window the gui\n"
"terminates (but the x11vnc server keeps running).  However under \\\"icon\\\"\n"
"or \\\"tray\\\" mode if you bring up the full gui window via \\\"Properties ->\n"
"Advanced\\\" and then delete it the gui does NOT terminate.\n"
"\n"
"Also note that by default in \\\"icon\\\" mode if you delete the icon\n"
"window both the gui *and* the x11vnc server terminate.\n"
"\"\n"
"\n"
"	set helptext(gui) \"\n"
"tkx11vnc is a simple frontend to x11vnc.  Nothing fancy, it merely\n"
"provides an interface to each of the many x11vnc command line options and\n"
"remote control commands.  See \\\"Help -> all\\\" for much info about x11vnc.\n"
"\n"
"For a simplier gui, run x11vnc in \\\"tray\\\" or \\\"icon\\\" mode such as\n"
"\\\"-gui tray\\\", \\\"-gui icon\\\", or \\\"-gui tray=setpass\\\".  In that\n"
"mode the full gui is only available under \\\"Advanced ...\\\".\n"
"\n"
"Also, \\\"-gui ez\\\" will show fewer menu items (toggle via Misc -> simple_gui)\n"
"\n"
"All menu items have a (?) button one can click on to get more information\n"
"about the option or command.\n"
"\n"
"There are two states tkx11vnc can be in:\n"
"\n"
"	1) Available to control a running x11vnc process.\n"
"\n"
"	2) Getting ready to start a x11vnc process.\n"
"\n"
"Most people will just use state 1).\n"
"\n"
"In state 1) the Menu items available in the menus are those that\n"
"correspond to the x11vnc \\\"remote control\\\" commands.  See the -remote\n"
"entry under \\\"Help -> all\\\" for a complete list.  Also available is\n"
"the \\\"Actions -> stop\\\" item to shut down the running x11vnc server,\n"
"thereby changing to state 2).  There are other actions available too.\n"
"\n"
"In state 2) the Menu items available in the menus (\\\"Actions\\\", \\\"Clients\\\",\n"
"etc.) are those that correspond to command line options used in starting\n"
"an x11vnc process, and the \\\"Actions -> start\\\" item executes\n"
"x11vnc thereby changing to state 1).  To see what x11vnc startup command\n"
"you have built so far, look at the (?) help for  \\\"Actions -> start\\\"\n"
"and it will show you what the command looks like.\n"
"\n"
"There is much overlap between the menu items available in state 1)\n"
"and state 2), but it is worth keeping in mind it is not 100%.\n"
"For example, you cannot set passwords or password files in state 1).\n"
"(update: simple password setting is now allowed in \\\"tray\\\" or \\\"icon\\\" mode).\n"
"\n"
"\n"
"Also note that there may be *two* separate X displays involved, not just\n"
"one:  1) the X display x11vnc will be polling (and making available to\n"
"VNC viewers), and 2) the X display this GUI is intended to display on.\n"
"\n"
"For example, one might use ssh to access the remote machine where the\n"
"GUI would display on :11 and x11vnc would poll display :0.  By default\n"
"the gui will display on the value in the DISPLAY env. variable followed\n"
"by the value from the -display option.  To override this, use something\n"
"like: \\\"-gui otherhost:0\\\", etc.\n"
"\n"
"\n"
"GUI components: \n"
"--- ----------\n"
"\n"
"1) At the top of the gui is a info text label where information will\n"
"   be posted, e.g. when traversing menu items text indicating how to get\n"
"   help on the item and its current value will be displayed.\n"
"\n"
"2) Below the info label is the area where the menu buttons, \\\"Actions\\\",\n"
"   \\\"Clients\\\", etc., are presented.  If a menu item has a checkbox,\n"
"   it corresponds to a boolean on/off variable.  Otherwise it is\n"
"   either a string variable, or an action not associated with a\n"
"   variable (for the most part).\n"
"\n"
"3) Below the menu button area is a label indicating the current x11vnc\n"
"   X display being polled and the corresponding VNC display name.  Both\n"
"   will be \\\"(*none*)\\\" when there is no connection established.\n"
"\n"
"4) Below the x11 and vnc displays label is a text area there scrolling\n"
"   information about actions being taken and commands being run is displayed.\n"
"   To scroll click in the area and use PageUp/PageDown or the arrow keys.\n"
"\n"
"5) At the bottom is an entry area.  When one selects a menu item that\n"
"   requires supplying a string value, the label will be set to the\n"
"   parameter name and one types in the new value.  Then one presses the\n"
"   \\\"OK\\\" button or presses \\\"Enter\\\" to set the value.  Or you can press\n"
"   \\\"Cancel\\\" or \\\"Escape\\\" to avoid changing the variable.\n"
"\n"
"   Many variables are boolean toggles (for example, \\\"Permissions ->\n"
"   viewonly\\\") or Radio button selections.  Selecting these menu items\n"
"   will NOT activate the entry area but rather toggle the variable\n"
"   immediately.\n"
"\n"
"\n"
"CASCADES BUG: There is a bug not yet worked around for the cascade menus\n"
"where the (?) help button gets in the way.  To get the mouse over to\n"
"the cascade menu click and release mouse to activate the cascade, then\n"
"you can click on its items.  Dragging with a mouse button held down will\n"
"not work (sorry!).\n"
"\n"
"\n"
"Key Bindings:\n"
"\n"
"	In the Text Area: Control-/ selects all of the text.\n"
"	Anywhere: Control-d invokes \\\"Actions -> detach\\\"\n"
"	Anywhere: Control-a invokes \\\"Actions -> attach\\\"\n"
"	Anywhere: Control-p invokes \\\"Actions -> ping\\\"\n"
"	Anywhere: Control-u and Control-r invoke \\\"Actions -> update-all\\\"\n"
"\"\n"
"\n"
"set under_wally \"\n"
"Misc:\n"
"\n"
"Since x11vnc has so many settings and to avoid further confusion,\n"
"the libvncserver options:\n"
"\n"
"	-alwaysshared\n"
"	-nevershared\n"
"	-dontdisconnect\n"
"\n"
"are not available for changing in a running x11vnc (even though it\n"
"is feasible).  These options overlap with the x11vnc options -shared\n"
"and -forever which are hopefully enough for most usage.  They may be\n"
"specified for x11vnc startup if desired.\n"
"\n"
"\"\n"
"\n"
"global beginner_mode\n"
"if {$beginner_mode} {\n"
"	set helptext(gui) \"\n"
"tkx11vnc is a simple frontend to x11vnc.  It is currently running in\n"
"\\\"ez\\\" or \\\"simple\\\" mode.  For many more options run it in normal\n"
"mode by toggling \\\"Misc -> simple_gui\\\".\n"
"\n"
"All menu items have a (?) button one can click on to get more information\n"
"about the option or command.\n"
"\n"
"GUI components: \n"
"--- ----------\n"
"\n"
"1) At the top of the gui is a info text label where information will\n"
"   be posted, e.g. when traversing menu items text indicating how to get\n"
"   help on the item and its current value will be displayed.\n"
"\n"
"2) Below the info label is the area where the menu buttons, \\\"Actions\\\",\n"
"   \\\"Clients\\\", etc., are presented.  If a menu item has a checkbox,\n"
"   it corresponds to a boolean on/off variable.  Otherwise it is\n"
"   either a string variable, or an action not associated with a\n"
"   variable (for the most part).\n"
"\n"
"3) Below the menu button area is a label indicating the current x11vnc\n"
"   X display being polled and the corresponding VNC display name.  Both\n"
"   will be \\\"(*none*)\\\" when there is no connection established.\n"
"\n"
"4) Below the x11 and vnc displays label is a text area there scrolling\n"
"   information about actions being taken and commands being run is displayed.\n"
"   To scroll click in the area and use PageUp/PageDown or the arrow keys.\n"
"\n"
"5) At the bottom is an entry area.  When one selects a menu item that\n"
"   requires supplying a string value, the label will be set to the\n"
"   parameter name and one types in the new value.  Then one presses the\n"
"   \\\"OK\\\" button or presses \\\"Enter\\\" to set the value.  Or you can press\n"
"   \\\"Cancel\\\" or \\\"Escape\\\" to avoid changing the variable.\n"
"\n"
"   Many variables are boolean toggles (for example, \\\"Permissions ->\n"
"   viewonly\\\") or Radio button selections.  Selecting these menu items\n"
"   will NOT activate the entry area but rather toggle the variable\n"
"   immediately.\n"
"\n"
"CASCADES BUG: There is a bug not yet worked around for the cascade menus\n"
"where the (?) help button gets in the way.  To get the mouse over to\n"
"the cascade menu click and release mouse to activate the cascade, then\n"
"you can click on its items.  Dragging with a mouse button held down will\n"
"not work (sorry!).\n"
"\n"
"\"\n"
"}\n"
"\n"
"}\n"
"\n"
"proc center_win {w} {\n"
"	wm withdraw $w\n"
"	set x [expr [winfo screenwidth  $w]/2 - [winfo reqwidth  $w]/2];\n"
"	set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2];\n"
"	wm geometry $w +$x+$y\n"
"	wm deiconify $w\n"
"	update\n"
"}\n"
"\n"
"proc textwidth {text} {\n"
"	set min 0;\n"
"	foreach line [split $text \"\\n\"] {\n"
"		set n [string length $line]\n"
"		if {$n > $min} {\n"
"			set min $n\n"
"		}\n"
"	}\n"
"	return $min\n"
"}\n"
"\n"
"proc textheight {text} {\n"
"	set count 0;\n"
"	foreach line [split $text \"\\n\"] {\n"
"		incr count\n"
"	}\n"
"	return $count\n"
"}\n"
"\n"
"proc set_name {name} {\n"
"	global full_win icon_mode\n"
"	global saved_set_name\n"
"\n"
"	if {![info exists saved_set_name]} {\n"
"		set saved_set_name \"tkx11vnc\"\n"
"	}\n"
"	if {$name == \"RESTORE\"} {\n"
"		set name $saved_set_name\n"
"	} else {\n"
"		set saved_set_name $name\n"
"	}\n"
"	if {![info exists full_win]} {\n"
"		return\n"
"	}\n"
"	set w \".\"\n"
"	if {$icon_mode} {\n"
"		wm title    $w \"$name\"\n"
"		wm iconname $w \"$name\"\n"
"		set w $full_win\n"
"	}\n"
"	wm title    $w \"$name\"\n"
"	wm iconname $w \"$name\"\n"
"}\n"
"\n"
"proc make_toplevel {w {title \"\"}} {\n"
"	catch {destroy $w}\n"
"	toplevel  $w;\n"
"	bind $w <Escape> \"destroy $w\"\n"
"	if {$title != \"\"} {\n"
"		wm title    $w $title\n"
"		wm iconname $w $title\n"
"	}\n"
"}\n"
"\n"
"proc textwin {name title text {entry \"\"}} {\n"
"	global max_text_height max_text_width\n"
"	global bfont ffont\n"
"\n"
"	set width  [textwidth $text]\n"
"	incr width\n"
"	if {$width > $max_text_width} {\n"
"		set width $max_text_width\n"
"	}\n"
"	set height [textheight $text]\n"
"	if {$height > $max_text_height} {\n"
"		set height $max_text_height\n"
"	}\n"
"\n"
"	set w \".text_$name\"\n"
"	make_toplevel $w $title\n"
"\n"
"	frame     $w.f -bd 0;\n"
"	pack      $w.f -fill both -expand 1\n"
"	text      $w.f.t -width $width -height $height -setgrid 1 -bd 2 \\\n"
"			-yscrollcommand \"$w.f.y set\" -relief ridge \\\n"
"			-font $ffont;\n"
"	scrollbar $w.f.y -orient v -relief sunken -command \"$w.f.t yview\";\n"
"	button    $w.f.b -text \"Dismiss\" -command \"destroy $w\" -font $bfont \\\n"
"			-pady 2\n"
"\n"
"	$w.f.t insert 1.0 $text;\n"
"\n"
"	bind $w <Enter> \"focus $w.f.t\"\n"
"\n"
"	if {$entry != \"\"} {\n"
"		# varname+Label Name\n"
"		set list [split $entry \"+\"]\n"
"		set varname [lindex $list 0]\n"
"		set labname [lindex $list 1]\n"
"		frame $w.f.ef -bd 1 -relief groove\n"
"		label $w.f.ef.l -text \"$labname\" -anchor w -font $bfont\n"
"		entry $w.f.ef.e -relief sunken -font $ffont \\\n"
"			-textvariable $varname\n"
"		button $w.f.ef.b -text \"OK\" -font $bfont \\\n"
"			-command \"set ${varname}_ok 1; destroy $w\" \n"
"		bind $w.f.ef.e <KeyPress-Return> \"set ${varname}_ok 1; destroy $w\"\n"
"		\n"
"		pack $w.f.ef.l -side left\n"
"		pack $w.f.ef.e -side left -fill x -expand 1\n"
"		pack $w.f.ef.b -side right\n"
"	}\n"
"\n"
"	wm withdraw $w\n"
"	pack $w.f.b -side bottom -fill x \n"
"	if {$entry != \"\"} {\n"
"		pack $w.f.ef -side bottom -fill x \n"
"		bind $w <Enter> \"focus $w.f.ef.e\"\n"
"		$w.f.ef.e icursor end\n"
"	} else {\n"
"		bind $w <Enter> \"focus $w.f.t\"\n"
"	}\n"
"	pack $w.f.y -side right -fill y;\n"
"	pack $w.f.t -side top -fill both -expand 1;\n"
"	update\n"
"\n"
"	center_win $w\n"
"\n"
"	return $w\n"
"}\n"
"\n"
"proc active_when_connected {item} {\n"
"	global helpremote helptext\n"
"	global icon_mode\n"
"\n"
"	if {$icon_mode} {\n"
"		if {$item == \"passwd\"} {\n"
"			return 1\n"
"		}\n"
"		if {$item == \"viewpasswd\"} {\n"
"			return 1\n"
"		}\n"
"	}\n"
"\n"
"	if {[opt_match G $item]} {\n"
"		return 1\n"
"	} elseif {[opt_match R $item]} {\n"
"		return 1\n"
"	} elseif {[opt_match S $item]} {\n"
"		return 0\n"
"	} elseif {[is_action $item]} {\n"
"		if {[opt_match R $item]} {\n"
"			return 1\n"
"		} else {\n"
"			return 0\n"
"		}\n"
"	} elseif {[info exists helpremote($item)]} {\n"
"		return 1\n"
"	} else {\n"
"		return 0\n"
"	}\n"
"}\n"
"\n"
"proc active_when_starting {item} {\n"
"	global helpremote helptext beginner_mode\n"
"\n"
"	if {$beginner_mode} {\n"
"		if {[opt_match G $item]} {\n"
"			return 1\n"
"		}\n"
"		if {$item == \"display\"} {\n"
"			return 1\n"
"		}\n"
"		if {$item == \"attach\"} {\n"
"			return 1\n"
"		}\n"
"		if {$item == \"debug_gui\"} {\n"
"			return 1\n"
"		}\n"
"		return 0\n"
"	}\n"
"\n"
"	if {[opt_match G $item]} {\n"
"		return 1\n"
"	} elseif {[opt_match S $item]} {\n"
"		return 1\n"
"	} elseif {[opt_match R $item]} {\n"
"		return 0\n"
"	} elseif {[is_action $item]} {\n"
"		if {[opt_match S $item]} {\n"
"			return 1\n"
"		} else {\n"
"			return 0\n"
"		}\n"
"	} elseif {[info exists helptext($item)]} {\n"
"		return 1\n"
"	} else {\n"
"		return 0\n"
"	}\n"
"}\n"
"\n"
"proc help_win {item} {\n"
"	global helptext helpremote menu_var\n"
"	global query_ans query_aro\n"
"	global beginner_mode\n"
"\n"
"	set ok 0\n"
"	set text \"Help on $item:\\n\\n\"\n"
"\n"
"	if {$item == \"NewClient\"} {\n"
"		;\n"
"	} elseif {[is_gui_internal $item]} {\n"
"		if {$item != \"gui\" && $item != \"all\" && $item != \"Misc-Tuning:\" \\\n"
"		    && $item != \"Properties\" && $item != \"Tray\"} {\n"
"			append text \"    + Is a gui internal Action (cannot be set).\\n\";\n"
"		}\n"
"	} elseif {[is_action $item]} {\n"
"		append text \"    + Is a remote control Action (cannot be set).\\n\";\n"
"	} elseif {[active_when_connected $item]} {\n"
"		append text \"    + Can be changed in a running x11vnc.\\n\";\n"
"	} else {\n"
"		append text \"    - Cannot be changed in a running x11vnc.\\n\";\n"
"	}\n"
"	if {$item == \"NewClient\"} {\n"
"		;\n"
"	} elseif {[is_gui_internal $item]} {\n"
"		;\n"
"	} elseif {[active_when_starting $item]} {\n"
"		append text \"    + Can be set at x11vnc startup.\\n\";\n"
"	} else {\n"
"		if {! $beginner_mode} {\n"
"			append text \"    - Cannot be set at x11vnc startup.\\n\";\n"
"		}\n"
"	}\n"
"	append text \"\\n\"\n"
"\n"
"	if {[info exists helptext($item)]} {\n"
"		append text \"\\n\"\n"
"		if {[is_gui_internal $item]} {\n"
"			append text \"==== x11vnc help: ====\\n\";\n"
"		} else {\n"
"			append text \"==== x11vnc startup option help: ====\\n\";\n"
"		}\n"
"		append text \"\\n\"\n"
"		append text $helptext($item)\n"
"		append text \"\\n\"\n"
"		set ok 1\n"
"	}\n"
"\n"
"	if {[info exists helpremote($item)]} {\n"
"		append text \"\\n\"\n"
"		append text \"==== x11vnc remote control help: ====\\n\";\n"
"		append text \"\\n\"\n"
"		append text $helpremote($item)\n"
"		set ok 1\n"
"	}\n"
"\n"
"	if {![is_action $item] && [info exists menu_var($item)]} {\n"
"		global unset_str\n"
"		append text \"\\n\\n\"\n"
"		append text \"==== current $item value: ====\\n\";\n"
"		append text \"\\n\"\n"
"\n"
"		if {$item == \"passwd\" || $item == \"viewpasswd\"} {\n"
"			;\n"
"		} elseif {$menu_var($item) == \"\"} {\n"
"			append text \"$unset_str\\n\"\n"
"		} else {\n"
"			append text \"$menu_var($item)\\n\"\n"
"		}\n"
"		if {$item == \"http\" || $item == \"httpdir\" || $item == \"httpport\"} {\n"
"			global vnc_url;\n"
"			append text \"\\nURL: $vnc_url\\n\"\n"
"		}\n"
"	}\n"
"\n"
"	if {$item == \"start\"} {\n"
"		set str [get_start_x11vnc_txt]\n"
"		append_text \"$str\\n\"\n"
"#		append text \"\\nPossible \\$HOME/.x11vncrc settings for this command:\\n\\n\"\n"
"#		set rctxt [get_start_x11vnc_cmd 1]\n"
"#		append text \"$rctxt\\n\"\n"
"	}\n"
"\n"
"	regsub -all { } $item \" \" name\n"
"\n"
"	if {$ok} {\n"
"		textwin $name \"x11vnc help: $item\" \"$text\";\n"
"	}\n"
"	return $ok\n"
"}\n"
"\n"
"proc parse_help {} {\n"
"	global env x11vnc_prog;\n"
"	global helpall helptext;\n"
"\n"
"	set helppipe [open \"| $x11vnc_prog -help\" \"r\"];\n"
"	if {$helppipe == \"\"} {\n"
"		puts stderr \"failed to run $x11vnc_prog -help\";\n"
"		exit 1;\n"
"	}\n"
"\n"
"	set sawopts 0;\n"
"	set curropt \"\";\n"
"	while {[gets $helppipe line] > -1} {\n"
"		append helpall \"$line\\n\"	\n"
"\n"
"		# XXX\n"
"		if {[regexp {^Options:} $line]} {\n"
"			set sawopts 1;\n"
"			continue;\n"
"		}\n"
"		# XXX\n"
"		if {[regexp {^These options} $line]} {\n"
"			continue;\n"
"		}\n"
"\n"
"		if {! $sawopts} {\n"
"			continue;\n"
"		}\n"
"		if {[regexp {^-([0-9A-z_][0-9A-z_]*)} $line match name]} {\n"
"			set allnames($name) 1;\n"
"			if {\"$curropt\" != \"no$name\" && \"no$curropt\" != \"$name\"} {\n"
"				set curropt $name;\n"
"				set helptext($curropt) \"$line\\n\";\n"
"			} else {\n"
"				append helptext($curropt) \"$line\\n\";\n"
"			}\n"
"		} elseif {$curropt != \"\"} {\n"
"			append helptext($curropt) \"$line\\n\";\n"
"		}\n"
"	}\n"
"	foreach name [array names allnames] {\n"
"		if {[regexp {^no} $name]} {\n"
"			regsub {^no} $name \"\" pair\n"
"		} else {\n"
"			set pair \"no$name\"\n"
"		}\n"
"		if {[info exists helptext($name)]} {\n"
"			if ![info exists helptext($pair)] {\n"
"				set helptext($pair) $helptext($name);\n"
"			}\n"
"		} elseif {[info exists helptext($pair)]} {\n"
"			if ![info exists helptext($name)] {\n"
"				set helptext($name) $helptext($pair);\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	set_internal_help\n"
"}\n"
"\n"
"proc tweak_both {new old} {\n"
"	tweak_help $new $old\n"
"	tweak_remote_help $new $old\n"
"}\n"
"\n"
"proc tweak_remote_help {new old} {\n"
"	global helpremote\n"
"	if ![info exists helpremote($new)] {\n"
"		if {[info exists helpremote($old)]} {\n"
"			set helpremote($new) $helpremote($old)\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc tweak_help {new old} {\n"
"	global helptext\n"
"	if ![info exists helptext($new)] {\n"
"		if {[info exists helptext($old)]} {\n"
"			set helptext($new) $helptext($old)\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc parse_remote_help {} {\n"
"	global helpremote helptext help_indent remote_name;\n"
"\n"
"	set sawopts 0;\n"
"	set curropt \"\";\n"
"	set possopts \"\";\n"
"	set offset [expr $help_indent - 1];\n"
"	foreach line [split $helptext(remote) \"\\n\"] {\n"
"		\n"
"		set line [string range $line $offset end];\n"
"\n"
"		# XXX\n"
"		if {[regexp {^The following -remote/-R commands} $line]} {\n"
"			set sawopts 1;\n"
"			continue;\n"
"		}\n"
"		# XXX\n"
"		if {[regexp {^The vncconnect.*command} $line]} {\n"
"			set sawopts 0;\n"
"		}\n"
"\n"
"		if {! $sawopts} {\n"
"			continue;\n"
"		}\n"
"		if {[regexp {^([0-9A-z_][0-9A-z_:]*)} $line match name]} {\n"
"			regsub {:.*$} $name \"\" popt\n"
"			lappend possopts $popt\n"
"			if {\"$curropt\" != \"no$name\" && \"no$curropt\" != \"$name\"} {\n"
"				set curropt $name;\n"
"				regsub {:.*$} $curropt \"\" curropt\n"
"				set remote_name($curropt) $name\n"
"				set helpremote($curropt) \"$line\\n\";\n"
"			} else {\n"
"				append helpremote($curropt) \"$line\\n\";\n"
"			}\n"
"		} elseif {$curropt != \"\"} {\n"
"			append helpremote($curropt) \"$line\\n\";\n"
"		}\n"
"	}\n"
"\n"
"	foreach popt $possopts {\n"
"		if {[info exists helpremote($popt)]} {\n"
"			continue\n"
"		}\n"
"		if {[regexp {^no} $popt]} {\n"
"			regsub {^no} $popt \"\" try\n"
"		} else {\n"
"			set try \"no$popt\"\n"
"		}\n"
"		if {[info exists helpremote($try)]} {\n"
"			set helpremote($popt) $helpremote($try)\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc parse_query_help {} {\n"
"	global query_ans query_aro query_ans_list query_aro_list helptext;\n"
"\n"
"	set sawans 0;\n"
"	set sawaro 0;\n"
"	set ans_str \"\"\n"
"	set aro_str \"\"\n"
"\n"
"	foreach line [split $helptext(query) \"\\n\"] {\n"
"\n"
"		if {! $sawans && [regexp {^ *ans=} $line]} {\n"
"			set sawans 1\n"
"		}\n"
"		if {! $sawans} {\n"
"			continue\n"
"		}\n"
"\n"
"		if {[regexp {^ *aro=} $line]} {\n"
"			set sawaro 1\n"
"		}\n"
"		if {$sawaro && [regexp {^[ 	]*$} $line]} {\n"
"			set sawans 0\n"
"			break\n"
"		}\n"
"\n"
"		regsub {ans=} $line \"\" line\n"
"		regsub {aro=} $line \"\" line\n"
"		set line [string trim $line]\n"
"\n"
"		if {$sawaro} {\n"
"			set aro_str \"$aro_str $line\"\n"
"		} else {\n"
"			set ans_str \"$ans_str $line\"\n"
"		}\n"
"	}\n"
"\n"
"	regsub -all {  *} $ans_str \" \" ans_str\n"
"	regsub -all {  *} $aro_str \" \" aro_str\n"
"\n"
"	set ans_str [string trim $ans_str]\n"
"	set aro_str [string trim $aro_str]\n"
"	set query_ans_list [split $ans_str]\n"
"	set query_aro_list [split $aro_str]\n"
"\n"
"	foreach item $query_ans_list {\n"
"		if {[regexp {^[ 	]*$} $item]} {\n"
"			continue\n"
"		}\n"
"		set query_ans($item) 1\n"
"	}\n"
"	foreach item $query_aro_list {\n"
"		if {[regexp {^[ 	]*$} $item]} {\n"
"			continue\n"
"		}\n"
"		set query_aro($item) 1\n"
"	}\n"
"}\n"
"\n"
"proc in_debug_mode {} {\n"
"	global menu_var\n"
"	if {![info exists menu_var(debug_gui)]} {\n"
"		return 0\n"
"	}\n"
"	return $menu_var(debug_gui)\n"
"}\n"
"\n"
"# Menubar utilities:\n"
"proc menus_state {state} {\n"
"	global menu_b\n"
"\n"
"	foreach case [array names menu_b] {\n"
"		set menu_button $menu_b($case)\n"
"		if {![winfo exists $menu_button]} {\n"
"			continue\n"
"		}\n"
"		$menu_button configure -state $state\n"
"	}\n"
"}\n"
"\n"
"proc menus_enable {} {\n"
"	global menus_disabled\n"
"\n"
"	menus_state \"normal\"\n"
"	set menus_disabled 0\n"
"}\n"
"\n"
"proc menus_disable {} {\n"
"	global menus_disabled\n"
"\n"
"	set menus_disabled 1\n"
"	menus_state \"disabled\"\n"
"}\n"
"\n"
"# Entry box utilities:\n"
"proc entry_state {x state} {\n"
"	global entry_box entry_label entry_ok entry_help entry_skip entry_browse\n"
"	global old_labels\n"
"	if {$x == \"all\"} {\n"
"		if {!$old_labels} {\n"
"			$entry_label configure -state $state\n"
"		}\n"
"		$entry_box    configure -state $state\n"
"		$entry_ok     configure -state $state\n"
"		$entry_skip   configure -state $state\n"
"		$entry_help   configure -state $state\n"
"		$entry_browse configure -state $state\n"
"	} elseif {$x == \"label\"} {\n"
"		if {!$old_labels} {\n"
"			$entry_label configure -state $state\n"
"		}\n"
"	} elseif {$x == \"box\"} {\n"
"		$entry_box    configure -state $state\n"
"	} elseif {$x == \"ok\"} {\n"
"		$entry_ok     configure -state $state\n"
"	} elseif {$x == \"skip\"} {\n"
"		$entry_skip   configure -state $state\n"
"	} elseif {$x == \"help\"} {\n"
"		$entry_help   configure -state $state\n"
"	} elseif {$x == \"browse\"} {\n"
"		$entry_browse configure -state $state\n"
"	}\n"
"}\n"
"\n"
"proc entry_enable {{x \"all\"}} {\n"
"	entry_state $x normal\n"
"}\n"
"\n"
"proc entry_disable {{x \"all\"}} {\n"
"	entry_state $x disabled\n"
"}\n"
"\n"
"proc entry_browse_button {{show 1}} {\n"
"	global entry_browse\n"
"	if {$show} {\n"
"		pack $entry_browse -side left\n"
"	}  else {\n"
"		pack forget $entry_browse\n"
"	}\n"
"}\n"
"proc entry_focus {} {\n"
"	global entry_box\n"
"	focus $entry_box\n"
"}\n"
"proc entry_select {} {\n"
"	global entry_box\n"
"	$entry_box selection range 0 end\n"
"}\n"
"proc entry_get {} {\n"
"	global entry_box\n"
"	return [$entry_box get]\n"
"}\n"
"proc entry_insert {str} {\n"
"	global entry_box\n"
"	entry_delete\n"
"	$entry_box insert end $str\n"
"	$entry_box icursor end\n"
"}\n"
"proc entry_delete {} {\n"
"	global entry_box\n"
"	$entry_box delete 0 end\n"
"}\n"
"\n"
"\n"
"# Utilities for remote control and updating vars.\n"
"\n"
"proc push_new_value {item name new {query 1}} {\n"
"	global menu_var always_update remote_output query_output\n"
"	global query_result_list\n"
"\n"
"	set debug [in_debug_mode]\n"
"\n"
"	set getout 0\n"
"	set print_getout 0;\n"
"\n"
"	set do_query_all 0\n"
"\n"
"	set newnew \"\"\n"
"	if {$item == \"disconnect\"} {\n"
"		set newnew \"N/A\"\n"
"		set do_query_all 1\n"
"	} elseif {$always_update} {\n"
"		set do_query_all 1\n"
"	}\n"
"\n"
"	if {$item == \"remote-cmd\"} {\n"
"		# kludge for arbitrary remote command:\n"
"		if {[regexp {^Q:} $new]} {\n"
"			# extra kludge for Q:var to mean -Q var\n"
"			regsub {^Q:} $new \"\" new\n"
"			set qonly 1\n"
"		} else {\n"
"			set qonly 0\n"
"		}\n"
"		# need to extract item from new:\n"
"		set qtmp $new\n"
"		regsub {:.*$} $qtmp \"\" qtmp\n"
"		if {$qonly} {\n"
"			set rargs [list \"-Q\" \"$qtmp\"]\n"
"			set print_getout 1\n"
"			set qargs \"\"\n"
"		} else {\n"
"			set rargs [list \"-R\" \"$new\"]\n"
"			set qargs \"\"\n"
"		}\n"
"		set getout 1\n"
"\n"
"	} elseif {[value_is_string $item]} {\n"
"		# string var:\n"
"		set rargs [list \"-R\" \"$name:$new\"]\n"
"		set qargs [list \"-Q\" \"$name\"]\n"
"	} else {\n"
"		# boolean var:\n"
"		set rargs [list \"-R\" \"$name\"]\n"
"		set qargs [list \"-Q\" \"$name\"]\n"
"	}\n"
"\n"
"	if {! $query && ! $always_update} {\n"
"		set getout 1\n"
"	} elseif {$item == \"noremote\"} {\n"
"		set getout 1\n"
"	} elseif {[is_action $item] && ![opt_match Q $item] && $rargs != \"\"} {\n"
"		set getout 1\n"
"	} elseif {[regexp {^(sid|id)$} $item] && ![regexp {^0x} $new]} {\n"
"		set getout 1\n"
"	}\n"
"\n"
"	set remote_output \"\"\n"
"	set query_output \"\"\n"
"\n"
"	if {!$debug} {\n"
"		if [regexp {passwd} $rargs] {\n"
"			append_text \"x11vnc ...\"\n"
"		} else {\n"
"			append_text \"x11vnc $rargs ...\"\n"
"		}\n"
"	}\n"
"\n"
"	if {$getout} {\n"
"		set remote_output [run_remote_cmd $rargs]\n"
"		if {$print_getout} {\n"
"			append_text \"\\t$remote_output\"\n"
"		}\n"
"		append_text \"\\n\"\n"
"		return\n"
"	}\n"
"\n"
"	if {$do_query_all} {\n"
"		set all [all_query_vars]\n"
"		set qargs [list \"-Q\" $all]\n"
"\n"
"		global last_query_all_time\n"
"		set last_query_all_time [clock seconds]\n"
"	}\n"
"\n"
"	set rqargs [concat $rargs $qargs]\n"
"\n"
"	set query [run_remote_cmd $rqargs]\n"
"	set query_output $query\n"
"\n"
"	set query_result_list \"\"\n"
"\n"
"	if {$newnew != \"\"} {\n"
"		set new $newnew\n"
"	}\n"
"\n"
"	if {![see_if_ok $query $item \"$name:$new\"]} {\n"
"		# failed\n"
"		if  {[regexp {^a..=} $query]} {\n"
"			# but some result came back\n"
"			# synchronize everything with a 2nd call.\n"
"			set query_output [query_all 1]\n"
"		} else {\n"
"			# server may be dead\n"
"			if {$item != \"ping\" && $item != \"attach\"} {\n"
"				try_connect\n"
"			}\n"
"		}\n"
"	} else {\n"
"		# succeeded\n"
"		# synchronize this variable (or variables)\n"
"		# for a speedup used the list parsed by see_if_ok.\n"
"		update_menu_vars \"USE_LIST\"\n"
"\n"
"		if {$do_query_all} {\n"
"			global all_settings\n"
"			set all_settings $query\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc set_kmbc_str {} {\n"
"	global vl_bk vl_bm vl_bb vl_bc vl_bf vr_bk vr_bm vr_bb vr_bc vr_bf\n"
"\n"
"	set str \"\"\n"
"	if {$vl_bk} {\n"
"		append str \"K\"\n"
"	}\n"
"	if {$vl_bm} {\n"
"		append str \"M\"\n"
"	}\n"
"	if {$vl_bb} {\n"
"		append str \"B\"\n"
"	}\n"
"	if {$vl_bc} {\n"
"		append str \"C\"\n"
"	}\n"
"	if {$vl_bf} {\n"
"		append str \"F\"\n"
"	}\n"
"	if {$vr_bk || $vr_bm || $vr_bb || $vr_bc || $vr_bf} {\n"
"		append str \",\"\n"
"	}\n"
"	if {$vr_bk} {\n"
"		append str \"K\"\n"
"	}\n"
"	if {$vr_bm} {\n"
"		append str \"M\"\n"
"	}\n"
"	if {$vr_bb} {\n"
"		append str \"B\"\n"
"	}\n"
"	if {$vr_bc} {\n"
"		append str \"C\"\n"
"	}\n"
"	if {$vr_bf} {\n"
"		append str \"F\"\n"
"	}\n"
"	entry_insert $str\n"
"}\n"
"\n"
"proc insert_input_window {} {\n"
"	global text_area cleanup_window\n"
"	global ffont menu_var\n"
"	global vl_bk vl_bm vl_bb vl_bc vl_bf vr_bk vr_bm vr_bb vr_bc vr_bf\n"
"\n"
"	append_text \"\\nUse these checkboxes to set the input permissions, \"\n"
"	append_text \"or type in the \\\"KMBCF...\\\"\\n\"\n"
"	append_text \"-input string manually.  Then press \\\"OK\\\" or \\\"Cancel\\\".\\n\"\n"
"	append_text \"(note: an empty setting means use the default behavior, \"\n"
"	append_text \"see viewonly)\\n\\n\"\n"
"	set w \"$text_area.wk_f\"\n"
"	catch {destroy $w}\n"
"	frame $w -bd 1 -relief ridge -cursor {top_left_arrow}\n"
"	set fl $w.fl\n"
"	frame $fl\n"
"	set fr $w.fr\n"
"	frame $fr\n"
"	label $fl.l -font $ffont -text \"Normal clients:   \"\n"
"	checkbutton $fl.bk -pady 1 -font $ffont -anchor w -variable vl_bk \\\n"
"		-pady 1 -command set_kmbc_str -text \"Keystrokes\" \n"
"	checkbutton $fl.bm -font $ffont -anchor w -variable vl_bm \\\n"
"		-pady 1 -command set_kmbc_str -text \"Mouse-Motion\" \n"
"	checkbutton $fl.bb -font $ffont -anchor w -variable vl_bb \\\n"
"		-pady 1 -command set_kmbc_str -text \"Button-Click\"\n"
"	checkbutton $fl.bc -font $ffont -anchor w -variable vl_bc \\\n"
"		-pady 1 -command set_kmbc_str -text \"Clipboard-Input\"\n"
"	checkbutton $fl.bf -font $ffont -anchor w -variable vl_bf \\\n"
"		-pady 1 -command set_kmbc_str -text \"Files\"\n"
"	label $fr.l -pady 1 -font $ffont -text \"View-Only clients:\"\n"
"	checkbutton $fr.bk -font $ffont -anchor w -variable vr_bk \\\n"
"		-pady 1 -command set_kmbc_str -text \"Keystrokes\" \n"
"	checkbutton $fr.bm -font $ffont -anchor w -variable vr_bm \\\n"
"		-pady 1 -command set_kmbc_str -text \"Mouse-Motion\" \n"
"	checkbutton $fr.bb -font $ffont -anchor w -variable vr_bb \\\n"
"		-pady 1 -command set_kmbc_str -text \"Button-Click\"\n"
"	checkbutton $fr.bc -font $ffont -anchor w -variable vr_bc \\\n"
"		-pady 1 -command set_kmbc_str -text \"Clipboard-Input\"\n"
"	checkbutton $fr.bf -font $ffont -anchor w -variable vr_bf \\\n"
"		-pady 1 -command set_kmbc_str -text \"Files\"\n"
"\n"
"	if {[info exists menu_var(input)]} {\n"
"		set input_str $menu_var(input)\n"
"	} else {\n"
"		set input_str \"\"\n"
"	}\n"
"\n"
"	if {[regexp {(.*),(.*)} $input_str match normal viewonly]} {\n"
"		;\n"
"	} else {\n"
"		set normal $input_str\n"
"		set viewonly \"\"\n"
"	}\n"
"	set vl_bk 0\n"
"	set vl_bm 0\n"
"	set vl_bb 0\n"
"	set vl_bc 0\n"
"	set vl_bf 0\n"
"\n"
"	set vr_bk 0\n"
"	set vr_bm 0\n"
"	set vr_bb 0\n"
"	set vr_bc 0\n"
"	set vr_bf 0\n"
"\n"
"	if {[regexp -nocase {K} $normal]} {\n"
"		set vl_bk 1\n"
"	}\n"
"	if {[regexp -nocase {M} $normal]} {\n"
"		set vl_bm 1\n"
"	}\n"
"	if {[regexp -nocase {B} $normal]} {\n"
"		set vl_bb 1\n"
"	}\n"
"	if {[regexp -nocase {C} $normal]} {\n"
"		set vl_bc 1\n"
"	}\n"
"	if {[regexp -nocase {F} $normal]} {\n"
"		set vl_bf 1\n"
"	}\n"
"	if {[regexp -nocase {K} $viewonly]} {\n"
"		set vr_bk 1\n"
"	}\n"
"	if {[regexp -nocase {M} $viewonly]} {\n"
"		set vr_bm 1\n"
"	}\n"
"	if {[regexp -nocase {B} $viewonly]} {\n"
"		set vr_bb 1\n"
"	}\n"
"	if {[regexp -nocase {C} $viewonly]} {\n"
"		set vr_bc 1\n"
"	}\n"
"	if {[regexp -nocase {F} $viewonly]} {\n"
"		set vr_bf 1\n"
"	}\n"
"\n"
"	pack $fl.l $fl.bk $fl.bm $fl.bb $fl.bc $fl.bf -side top -fill x\n"
"	pack $fr.l $fr.bk $fr.bm $fr.bb $fr.bc $fr.bf -side top -fill x\n"
"	pack $fl $fr -side left\n"
"	update\n"
"	update idletasks\n"
"	$text_area window create end -window $w\n"
"	$text_area see end\n"
"	$text_area insert end \"\\n\"\n"
"#	$text_area insert end \"\\n\\n\\n\\n\\n\\n\\n\\n\\n\"\n"
"\n"
"	set cleanup_window $w\n"
"}\n"
"\n"
"proc set_ca_str {w} {\n"
"	global ca_bk ca_bm ca_bb ca_bc ca_bf ca_di\n"
"\n"
"	if {$ca_di} {\n"
"		entry_insert \"disconnect\"\n"
"		$w.bk configure -state disabled\n"
"		$w.bm configure -state disabled\n"
"		$w.bb configure -state disabled\n"
"		$w.bc configure -state disabled\n"
"		$w.bf configure -state disabled\n"
"		return\n"
"	}\n"
"\n"
"	$w.bk configure -state normal\n"
"	$w.bm configure -state normal\n"
"	$w.bb configure -state normal\n"
"	$w.bc configure -state normal\n"
"	$w.bf configure -state normal\n"
"\n"
"	set str \"\"\n"
"	if {$ca_bk} {\n"
"		append str \"K\"\n"
"	}\n"
"	if {$ca_bm} {\n"
"		append str \"M\"\n"
"	}\n"
"	if {$ca_bb} {\n"
"		append str \"B\"\n"
"	}\n"
"	if {$ca_bc} {\n"
"		append str \"C\"\n"
"	}\n"
"	if {$ca_bf} {\n"
"		append str \"F\"\n"
"	}\n"
"	entry_insert $str\n"
"}\n"
"\n"
"proc insert_client_action_window {input} {\n"
"	global text_area cleanup_window\n"
"	global ffont menu_var\n"
"	global ca_bk ca_bm ca_bb ca_bc ca_bf ca_di\n"
"\n"
"	append_text \"\\nUse these checkboxes to set the input permissions \"\n"
"	append_text \"for this client\\n-OR- whether to disconnect it instead.  \"\n"
"	append_text \"Then press \\\"OK\\\" or \\\"Cancel\\\".\\n\\n\"\n"
"	set w \"$text_area.ca_f\"\n"
"	catch {destroy $w}\n"
"	frame $w -bd 1 -relief ridge -cursor {top_left_arrow}\n"
"	checkbutton $w.di -pady 1 -font $ffont -anchor w -variable ca_di \\\n"
"		-pady 1 -command \"set_ca_str $w\" -text \"Disconnect  \" \n"
"	checkbutton $w.bk -font $ffont -anchor w -variable ca_bk \\\n"
"		-pady 1 -command \"set_ca_str $w\" -text \"Keystrokes\" \n"
"	checkbutton $w.bm -font $ffont -anchor w -variable ca_bm \\\n"
"		-pady 1 -command \"set_ca_str $w\" -text \"Mouse-Motion\" \n"
"	checkbutton $w.bb -font $ffont -anchor w -variable ca_bb \\\n"
"		-pady 1 -command \"set_ca_str $w\" -text \"Button-Click\"\n"
"	checkbutton $w.bc -font $ffont -anchor w -variable ca_bc \\\n"
"		-pady 1 -command \"set_ca_str $w\" -text \"Clipboard\"\n"
"	checkbutton $w.bf -font $ffont -anchor w -variable ca_bf \\\n"
"		-pady 1 -command \"set_ca_str $w\" -text \"Files\"\n"
"\n"
"	set ca_di 0\n"
"	set ca_bk 0\n"
"	set ca_bm 0\n"
"	set ca_bb 0\n"
"	set ca_bf 0\n"
"	set ca_bc 0\n"
"\n"
"	if {[regexp -nocase {K} $input]} {\n"
"		set ca_bk 1\n"
"	}\n"
"	if {[regexp -nocase {M} $input]} {\n"
"		set ca_bm 1\n"
"	}\n"
"	if {[regexp -nocase {B} $input]} {\n"
"		set ca_bb 1\n"
"	}\n"
"	if {[regexp -nocase {C} $input]} {\n"
"		set ca_bc 1\n"
"	}\n"
"	if {[regexp -nocase {F} $input]} {\n"
"		set ca_bf 1\n"
"	}\n"
"\n"
"	pack $w.di $w.bk $w.bm $w.bb $w.bc $w.bf -side left\n"
"	update\n"
"	update idletasks\n"
"	$text_area window create end -window $w\n"
"	$text_area see end\n"
"	$text_area insert end \"\\n\"\n"
"\n"
"	set cleanup_window $w\n"
"}\n"
"\n"
"proc cleanup_text_window {} {\n"
"	global cleanup_window\n"
"	if {[info exists cleanup_window]} {\n"
"		catch {destroy $cleanup_window}\n"
"	}\n"
"}\n"
"\n"
"# For updating a string variable.   Also used for simple OK/Cancel dialogs\n"
"# with entry = 0.\n"
"proc entry_dialog {item {entry 1}} {\n"
"	global menu_var entry_str entry_set entry_dialog_item\n"
"	global unset_str connected_to_x11vnc entry_box\n"
"\n"
"	set entry_str \"Set $item\"\n"
"	set entry_set 0\n"
"	set entry_dialog_item $item\n"
"\n"
"	entry_enable\n"
"	menus_disable\n"
"\n"
"	if {$item == \"passwd\" || $item == \"viewpasswd\"} {\n"
"		$entry_box configure -show \"*\"\n"
"	}\n"
"\n"
"	if {$entry} {\n"
"		entry_insert \"\"\n"
"		if {[info exists menu_var($item)] &&\n"
"		    $menu_var($item) != $unset_str} {\n"
"			entry_insert $menu_var($item)\n"
"			entry_select\n"
"		}\n"
"\n"
"		if {[is_browse $item]} {\n"
"			entry_browse_button\n"
"		}\n"
"		set_info \"Set parameter in entry box, \"\n"
"		entry_focus\n"
"	} else {\n"
"		entry_disable box\n"
"	}\n"
"\n"
"	set clean_text_window 0;\n"
"\n"
"	if {$item == \"input\"} {\n"
"		insert_input_window\n"
"		set clean_text_window 1\n"
"	}\n"
"\n"
"	update\n"
"\n"
"	# wait for user reply:\n"
"	vwait entry_set\n"
"\n"
"	set rc $entry_set\n"
"	set entry_set 0\n"
"\n"
"	set value [entry_get]\n"
"	update\n"
"\n"
"	entry_browse_button 0\n"
"	set entry_str \"Set... :\"\n"
"\n"
"	entry_delete\n"
"	entry_disable\n"
"	menus_enable\n"
"\n"
"	if {$clean_text_window} {\n"
"		cleanup_text_window;\n"
"	}\n"
"\n"
"	update\n"
"\n"
"	if {! $entry} {\n"
"		;\n"
"	} elseif {$rc} {\n"
"		set menu_var($item) $value\n"
"	} else {\n"
"		if {[in_debug_mode]} {\n"
"			append_text \"skipped setting $item\\n\"\n"
"		}\n"
"	}\n"
"\n"
"	$entry_box configure -show \"\"\n"
"\n"
"	return $rc\n"
"}\n"
"\n"
"proc warning_dialog {msg {item \"gui\"} } {\n"
"	append_text $msg\n"
"	# just reuse the entry widgets for a yes/no dialog\n"
"	return [entry_dialog $item 0]\n"
"}\n"
"\n"
"# For updating a boolean toggle:\n"
"proc check_var {item} {\n"
"	global menu_var\n"
"\n"
"	set inval $menu_var($item);\n"
"\n"
"	if {$item == \"debug_gui\"} {\n"
"		return \"\";\n"
"	}\n"
"\n"
"	set rname $item\n"
"	if {! $inval} {\n"
"		if {[regexp {^no} $item]} {\n"
"			regsub {^no} $rname \"\" rname\n"
"		} else {\n"
"			set rname \"no$rname\"\n"
"		}\n"
"	}\n"
"	return $rname\n"
"}\n"
"\n"
"proc see_if_ok {query item expected} {\n"
"	global query_result_list\n"
"\n"
"	set ok 0\n"
"	set found \"\"\n"
"\n"
"	set query_result_list [split_query $query]\n"
"\n"
"	foreach q $query_result_list {\n"
"		# XXX following will crash if $item is not a good regexp\n"
"		# need to protect it \\Q$item\\E style...\n"
"#		if {[regexp \"^$item:\" $q]} {\n"
"#			set found $q\n"
"#		}\n"
"		if {[string first \"$item:\" $q] == 0} {\n"
"			set found $q\n"
"		}\n"
"		if {$q == $expected} {\n"
"			set ok 1\n"
"			if {$found != \"\"} {\n"
"				break;\n"
"			}\n"
"		}\n"
"	}\n"
"	if {$found == \"\"} {\n"
"		set msg $query\n"
"		regsub {^a..=} $msg {} msg\n"
"		if {[string length $msg] > 60} {\n"
"			set msg [string range $msg 0 60]\n"
"		}\n"
"	} else {\n"
"		set msg $found\n"
"	}\n"
"	if {!$ok && $found != \"\"} {\n"
"		# check for floating point match:\n"
"		set v1 \"\"\n"
"		set v2 \"\"\n"
"		regexp {:([0-9.][0-9.]*)$} $found m0 v1\n"
"		regexp {:([0-9.][0-9.]*)$} $expected m0 v2\n"
"		if {$v1 != \"\" && $v2 != \"\"} {\n"
"			set diff \"\"\n"
"			catch {set diff [expr \"$v1 - $v2\"]}\n"
"			if {$diff != \"\"} {\n"
"				if {$diff < 0} {\n"
"					set diff [expr \"0.0 - $diff\"]\n"
"				}\n"
"				if {$diff < 0.00001} {\n"
"					set ok 1\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	if {$ok} {\n"
"		append_text \"\\tSet OK  ($msg)\\n\"\n"
"		return 1\n"
"\n"
"	} elseif {[opt_match P $item] && [regexp {:(-|\\+)} $expected]} {\n"
"		# e.g. blackout:+30x30+20+20\n"
"		append_text \"\\t($msg)\\n\"\n"
"		return 1\n"
"	} elseif {[regexp {:[0-9]\\.[0-9]} $expected]} {\n"
"		append_text \"\\t($msg)\\n\"\n"
"		return 1\n"
"	} elseif {$item == \"connect\" || $item == \"disconnect\"\n"
"	    || $item == \"client\" || $item == \"client_input\"} {\n"
"		append_text \"\\t($msg)\\n\"\n"
"		return 1\n"
"	} elseif {$item == \"passwd\" || $item == \"viewpasswd\"} {\n"
"		append_text \"\\t($msg)\\n\"\n"
"		return 1\n"
"	} else {\n"
"		append_text \"\\t*FAILED* $msg\\n\"\n"
"		return 0\n"
"	}\n"
"}\n"
"\n"
"proc get_default_vars {} {\n"
"	global default_var\n"
"\n"
"	set qry [all_query_vars]\n"
"\n"
"	append qry \",vncconnect\"\n"
"\n"
"	set qargs [list \"-QD\" $qry]\n"
"	set all [run_remote_cmd $qargs]\n"
"\n"
"	if {[regexp {ans=} $all]} {\n"
"		#append_text \"Retrieved all default settings.\\n\"\n"
"	} else {\n"
"		#append_text \"Failed to retrieve default settings.\\n\"\n"
"	}\n"
"\n"
"	set query_result_list [split_query $all]\n"
"\n"
"	set default_var(gui) \"\"\n"
"\n"
"	foreach piece $query_result_list {\n"
"		if {[regexp {^([^:][^:]*):(.*)$} $piece m0 item val]} {\n"
"			if {$val == \"N/A\"} {\n"
"				if {$item == \"vncconnect\"} {\n"
"					set val 1\n"
"				} else {\n"
"					set val \"\"\n"
"				}\n"
"			}\n"
"			if {$item == \"display\"} {\n"
"				set val \"\"\n"
"			} elseif {$item == \"desktop\"} {\n"
"				set val \"\"\n"
"			} elseif {$item == \"auth\"} {\n"
"				set val \"\"\n"
"			} elseif {$item == \"gui\"} {\n"
"				continue\n"
"			} \n"
"			# some hacks we do here for now..\n"
"			if {$item == \"cursor\" && $val == \"\"} {\n"
"				set val \"most\"\n"
"			} elseif {$item == \"scrollcopyrect\" && $val == \"\"} {\n"
"				set val \"always\"\n"
"			} elseif {$item == \"wirecopyrect\" && $val == \"\"} {\n"
"				set val \"always\"\n"
"#			} elseif {$item == \"overlay_nocursor\" && $val == 0} {\n"
"#				set val 1\n"
"			}\n"
"\n"
"			set default_var($item) $val\n"
"#puts \"default: $item -> $val\"\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc tilde_expand {file} {\n"
"	global env\n"
"	if {[file exists $file]} {\n"
"		return $file\n"
"	}\n"
"\n"
"	set user \"\"\n"
"	if {[info exists env(USER)]} {\n"
"		set user $env(USER)\n"
"	}\n"
"	if {$user == \"\" && [info exists env(LOGNAME)]} {\n"
"		set user $env(LOGNAME)\n"
"	}\n"
"\n"
"	set home \"\"\n"
"	if {[info exists env(HOME)]} {\n"
"		set home $env(HOME)\n"
"	} elseif {$user != \"\"} {\n"
"		set home \"/home/$user\"\n"
"	}\n"
"\n"
"	if {[regexp {^~} $file]} {\n"
"		if {[regexp {^~/} $file]} {\n"
"			if {$home != \"\"} {\n"
"				regsub {^~} $file $home file\n"
"			}\n"
"		} else {\n"
"			regsub {^~} $file \"/home/\" file\n"
"		}\n"
"	}\n"
"	return $file\n"
"}\n"
"\n"
"proc insert_cmdline_vars {} {\n"
"	global env cmd_var menu_var default_var x11vnc_cmdline\n"
"	if {![info exists x11vnc_cmdline]} {\n"
"		return\n"
"	}\n"
"	if {$x11vnc_cmdline == \"\"} {\n"
"		return\n"
"	}\n"
"	set cmd_var(novar) 1 \n"
"	set str [string trim $x11vnc_cmdline]\n"
"\n"
"	while {[regexp -- {^-} $str]} {\n"
"		if {[regexp -- {^--*([^ \\t][^ \\t]*)(.*)$} $str m var rest]} {\n"
"			set rest [string trim $rest]\n"
"			set var [string trim $var]\n"
"			if {[regexp {^\\{\\{([^\\}]*)\\}\\}(.*)} $rest m val rest]} {\n"
"				set str [string trim $rest]\n"
"				set cmd_var($var) $val\n"
"			} else {\n"
"				set str $rest\n"
"				set cmd_var($var) \"boolean\"\n"
"			}\n"
"		} else {\n"
"			break\n"
"		}\n"
"	}\n"
"\n"
"	if {[info exists cmd_var(rc)]} {\n"
"		load_settings $cmd_var(rc)\n"
"	} elseif {[info exists cmd_var(norc)]} {\n"
"		;\n"
"	} else {\n"
"		set filex [tilde_expand \"~/.x11vncrc\"]\n"
"		if {[file exists $filex]} {\n"
"			load_settings $filex\n"
"		}\n"
"	}\n"
"\n"
"	foreach var [array names cmd_var] {\n"
"		if {$var == \"novar\"} {\n"
"			continue\n"
"		}\n"
"		if {[regexp {^[ \\t]*$} $var]} {\n"
"			continue\n"
"		}\n"
"		if {[info exists menu_var($var)]} {\n"
"			if {$cmd_var($var) == \"boolean\"} {\n"
"				set menu_var($var) 1\n"
"			} else {\n"
"				set menu_var($var) $cmd_var($var)\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc copy_default_vars {} {\n"
"	global menu_var default_var\n"
"	foreach item [array names default_var] {\n"
"		if {[info exists menu_var($item)]} {\n"
"			if {[info exists default_var($item)]} {\n"
"				set menu_var($item) $default_var($item)\n"
"			}\n"
"		}\n"
"	}\n"
"	foreach item [array names menu_var] {\n"
"		if {[info exists default_var($item)]} {\n"
"			set menu_var($item) $default_var($item)\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc update_menu_vars {{query \"\"}} {\n"
"	global all_settings menu_var query_result_list\n"
"\n"
"	set debug [in_debug_mode]\n"
"\n"
"	if {$query == \"USE_LIST\"} {\n"
"		;\n"
"	} elseif {$query == \"\"} {\n"
"		set query_result_list [split_query $all_settings]\n"
"	} else {\n"
"		set query_result_list [split_query $query]\n"
"	}\n"
"\n"
"	foreach piece $query_result_list {\n"
"#puts stderr \"UMV: $piece\"\n"
"		if {[regexp {^([^:][^:]*):(.*)$} $piece m0 item val]} {\n"
"			if {[info exists menu_var($item)]} {\n"
"				set old $menu_var($item)\n"
"#puts stderr \"     $old\"\n"
"				if {$val == \"N/A\"} {\n"
"					continue\n"
"				}\n"
"				set menu_var($item) $val\n"
"			}\n"
"			if {$item == \"clients\"} {\n"
"				update_clients_menu $val\n"
"			} elseif {$item == \"display\"} {\n"
"				set_x11_display $val\n"
"			} elseif {$item == \"vncdisplay\"} {\n"
"				set_vnc_display $val\n"
"			} elseif {$item == \"http_url\"} {\n"
"				set_vnc_url $val\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc load_settings {{file \"\"}} {\n"
"	global menu_var default_var env\n"
"\n"
"	if {$file == \"\"} {\n"
"		if {![info exists menu_var(load-settings)]} {\n"
"			return\n"
"		}\n"
"		set file $menu_var(load-settings)\n"
"	}\n"
"	if {$file == \"\"} {\n"
"		return\n"
"	}\n"
"\n"
"	set fh \"\"\n"
"	set filex [tilde_expand $file]\n"
"	catch {set fh [open $filex \"r\"]}\n"
"\n"
"	if {$fh == \"\"} {\n"
"		append_text \"load_settings: *** failed to open $filex ***\\n\"\n"
"		return\n"
"	}\n"
"	copy_default_vars\n"
"\n"
"	set str \"\"\n"
"	while {[gets $fh line] > -1} {\n"
"		regsub -all {\\\\#} $line {__QUOTED_HASH__} line\n"
"		if {[regexp {^[ \\t]*#} $line]} {\n"
"			continue\n"
"		}\n"
"		for {set i 0} {$i < 5} {incr i} {\n"
"			regsub {#.*$} $line \"\" line\n"
"		}\n"
"		if {[regexp {^[ \\t]*$} $line]} {\n"
"			continue\n"
"		}\n"
"		regsub -all {__QUOTED_HASH__} $line {#} line\n"
"		if {[regexp {\\\\$} $line]} {\n"
"			regsub {\\\\$} $line \" \" line\n"
"			append str \"$line\"\n"
"		} else {\n"
"			append str \"$line\\n\"\n"
"		}\n"
"	}\n"
"	close $fh\n"
"\n"
"	set count 0\n"
"	set parms \"\"\n"
"\n"
"	foreach line [split $str \"\\n\"] {\n"
"		set line [string trim $line]\n"
"		regsub {^--*} $line \"\" line\n"
"		regsub -all {[ \\t][ \\t]*} $line \" \" line\n"
"		set list [split $line]\n"
"		set item [lindex $list 0]\n"
"		set value [lindex $list 1]\n"
"		if {[regexp {^[ \\t]*$} $item]} {\n"
"			continue\n"
"		}\n"
"		if {$item == \"gui\"} {\n"
"			continue\n"
"		}\n"
"		if {[info exists menu_var($item)]} {\n"
"			if {[value_is_bool $item]} {\n"
"				set menu_var($item) 1\n"
"				incr count\n"
"				append parms \"  -$item\\n\"\n"
"			} elseif {[value_is_string $item]} {\n"
"				if {$value != \"\"} {\n"
"					set menu_var($item) $value\n"
"					set nitem [get_nitem $item]\n"
"					append parms \"  -$nitem $value\\n\"\n"
"					incr count\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	append_text \"loaded $count parameter settings from $filex\"\n"
"	if {$count > 0} {\n"
"		append_text \":\\n\"\n"
"		append_text $parms\n"
"	} else {\n"
"		append_text \".\\n\"\n"
"	}\n"
"}\n"
"\n"
"proc save_settings {} {\n"
"	set rc_text [get_settings_rcfile]\n"
"\n"
"	set top \"#\n"
"# This file is based on the current x11vnc settings and can be used as\n"
"# as a ~/.x11vncrc defaults file.  If saved to another filename, these\n"
"# settings can be passed to x11vnc at startup via \\\"-rc <filename>\\\".\n"
"#\n"
"# The rc file comment character is \\\"#\\\".  Use \\\"\\\\#\\\" for the literal char.\n"
"# You can continue lines using \\\"\\\\\\\" as the last character of a line.\n"
"#\n"
"# Lines beginning with \\\"#d\\\" indicate the parameter value is at its default\n"
"# setting and you probably want to leave it commented out.\n"
"#\n"
"# Lines beginning with \\\"#?\\\" indicate parameters you probably do not\n"
"# want to hardwire to the current setting (uncomment if you want that).\n"
"# \n"
"# Some parameters are boolean, e.g. -forever, and take no value; while\n"
"# the others, e.g. -wait 50, take a string or numerical value.\n"
"#\n"
"# For booleans, the line will end with comment \\\"default: on\\\" or\n"
"# \\\"default: off\\\" indicating the default setting.  (Note: often\n"
"# \\\"-nofoobar\\\" corresponds to option \\\"-foobar\\\" and the former is\n"
"# \\\"the default\\\", e.g. -norepeat).\n"
"#\n"
"# For string or numerical options, the value \\\"\\\" in a line below\n"
"# means the default is unset and you will need to supply some non-empty\n"
"# value to use the parameter.  For reference, if the default differs\n"
"# from your value it placed at the end of the line as a comment.\n"
"# \n"
"# Feel free to uncomment or comment any of the lines or to change any\n"
"# of the values of the parameters.  Don't be surprised that most if not\n"
"# all of the lines below are commented out (x11vnc has so many parameters,\n"
"# most of them will be at their default values).\n"
"#-------------------------------------------------------------------------\n"
"\n"
"\"\n"
"\n"
"	set rc_text \"$top$rc_text\"\n"
"\n"
"	global env save_settings_var save_settings_var_ok\n"
"	if {[info exists env(HOME)]} {\n"
"		set save_settings_var \"$env(HOME)/.x11vncrc\"\n"
"	} else {\n"
"		set save_settings_var \".x11vncrc\"\n"
"	}\n"
"	set save_settings_var_ok 0\n"
"\n"
"	set w [textwin \"save_settings\" \"Save Settings...\" $rc_text \\\n"
"		\"save_settings_var+Save as:\"]\n"
"\n"
"	tkwait window $w\n"
"\n"
"	if {$save_settings_var_ok == 1} {\n"
"		set file $save_settings_var\n"
"		if {$file == \"\"} {\n"
"			return\n"
"		}\n"
"		set file [tilde_expand $file]\n"
"		append_text \"\\nSaving current settings to $file ...\\n\" \n"
"		if {[file exists $file]} {\n"
"			set backup \"${file}~\"\n"
"			append_text \"Backing up $file -> $backup ...\\n\"\n"
"			catch {file delete -force $backup}\n"
"			set emsg \"*** Backup to $backup failed. ***\\n\"\n"
"			if {![file exists $backup]} {\n"
"				catch {file copy -force $file $backup}\n"
"				if {![file exists $backup]} {\n"
"					append_text $emsg\n"
"					bell\n"
"				}\n"
"			} else {\n"
"				append_text $emsg\n"
"				bell\n"
"			}\n"
"		}\n"
"		set fh \"\"\n"
"		catch {set fh [open $file \"w\"]}\n"
"		if {$fh != \"\"} {\n"
"			puts $fh $rc_text\n"
"			close $fh\n"
"			if {![file exists $file]} {\n"
"				append_text \"*** Saving to $file failed. ***\\n\"\n"
"				bell\n"
"			} else {\n"
"				append_text \"Done.\\n\"\n"
"			}\n"
"		} else {\n"
"			append_text \"*** Open of $file failed. ***\\n\"\n"
"			bell\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc clear_all {} {\n"
"	global menu_var unset_str\n"
"\n"
"	set debug [in_debug_mode]\n"
"	\n"
"	foreach item [array names menu_var] {\n"
"		if {$item == \"debug_gui\"} {\n"
"			continue\n"
"		}\n"
"		if {[info exists menu_var($item)]} {\n"
"			if {[is_action $item]} {\n"
"				set menu_var($item) \"\"\n"
"			} elseif {[value_is_bool $item]} {\n"
"				set menu_var($item) 0\n"
"			} elseif {[value_is_string $item]} {\n"
"				set menu_var($item) $unset_str\n"
"			}\n"
"		}\n"
"	}\n"
"	append_text \"Cleared all settings.\\n\"\n"
"}\n"
"\n"
"proc defaults_all {} {\n"
"	copy_default_vars\n"
"	append_text \"Reset all variables to default values.\\n\"\n"
"}\n"
"\n"
"proc all_query_vars {} {\n"
"	global query_ans_list query_aro_list all_settings\n"
"	global cache_all_query_vars\n"
"	\n"
"	if {$cache_all_query_vars != \"\"} {\n"
"		return $cache_all_query_vars\n"
"	}\n"
"\n"
"	set qry \"\"\n"
"	foreach item $query_ans_list {\n"
"		if {$qry == \"\"} {\n"
"			set qry $item\n"
"		} else {\n"
"			append qry \",$item\"\n"
"		}\n"
"	}\n"
"	foreach item $query_aro_list {\n"
"		if {$qry == \"\"} {\n"
"			set qry $item\n"
"		} else {\n"
"			append qry \",$item\"\n"
"		}\n"
"	}\n"
"	set cache_all_query_vars $qry\n"
"\n"
"	return $qry\n"
"}\n"
"\n"
"proc query_all {{quiet 0}} {\n"
"	global query_ans_list query_aro_list all_settings\n"
"	global last_query_all_time\n"
"\n"
"	set qry [all_query_vars]\n"
"\n"
"	set qargs [list \"-Q\" $qry]\n"
"	set all [run_remote_cmd $qargs]\n"
"\n"
"	if {[regexp {ans=} $all]} {\n"
"		if {! $quiet} {\n"
"			append_text \"Retrieved all current settings.\\n\"\n"
"		}\n"
"		set all_settings $all\n"
"		update_menu_vars $all\n"
"	} else {\n"
"		if {! $quiet} {\n"
"			append_text \"Failed to retrieve current settings.\\n\"\n"
"		}\n"
"	}\n"
"	set last_query_all_time [clock seconds]\n"
"	return $all\n"
"}\n"
"\n"
"proc set_info {str} {\n"
"	global info_str info_label\n"
"#set w1 [$info_label cget -width]\n"
"#set w2 [winfo width $info_label]\n"
"#puts \"set_info: w=$w1  winfo=$w2\"\n"
"#append_text \"$str\\n\"\n"
"	set info_str \"$str\"\n"
"	update\n"
"}\n"
"\n"
"proc append_text {str} {\n"
"	global text_area text_area_str\n"
"\n"
"	if {![info exists text_area_str]} {\n"
"		set text_area_str \"\"\n"
"	}\n"
"	append text_area_str $str\n"
"\n"
"	if {![info exists text_area]} {\n"
"		puts stderr $str\n"
"		return\n"
"	}\n"
"	if {$text_area == \"\"} {\n"
"		puts stderr $str\n"
"		return\n"
"	}\n"
"	if {![winfo exists $text_area]} {\n"
"		puts stderr $str\n"
"		return\n"
"	}\n"
"	\n"
"	$text_area insert end $str\n"
"	$text_area see end\n"
"}\n"
"\n"
"proc show_all_settings {} {\n"
"	global all_settings\n"
"	global client_sock client_tail\n"
"	global x11vnc_client_file\n"
"\n"
"	set txt \"\\nRead-Write settings:\\n\\n\"\n"
"	foreach item [split_query $all_settings]  {\n"
"		regsub {:} $item {: } item\n"
"		append txt \"  $item\\n\"\n"
"		if {[regexp {noremote} $item]} {\n"
"			append txt \"\\nRead-Only settings:\\n\\n\"\n"
"		}\n"
"	}\n"
"	append txt \"\\nInternal settings:\\n\\n\"\n"
"	append txt \"x11vnc_client_file: $x11vnc_client_file\\n\"\n"
"	if {[info exists client_tail]} {\n"
"		append txt \"client_tail: $client_tail\\n\"\n"
"	} else {\n"
"		append txt \"client_tail: unset\\n\"\n"
"	}\n"
"	if {[info exists client_sock]} {\n"
"		append txt \"client_sock: $client_sock\\n\"\n"
"	} else {\n"
"		append txt \"client_sock: unset\\n\"\n"
"	}\n"
"	set estr \"\"\n"
"	catch {set estr [exec env | grep -i X11VNC]}\n"
"	append txt \"$estr\\n\"\n"
"	textwin \"Settings\" \"All Current Settings\" $txt\n"
"}\n"
"\n"
"proc show_logfile {} {\n"
"	global menu_var unset_str\n"
"\n"
"	set logfile [tilde_expand $menu_var(logfile)]\n"
"	\n"
"	if {$logfile == \"\" || $logfile == $unset_str} {\n"
"		set txt \"\\nNo logfile was specified at x11vnc startup.\\n\\n\"	\n"
"	} elseif {![file exists $logfile]} {\n"
"		set txt \"\\nLogfile \\\"$logfile\\\" does not exist.\\n\\n\"\n"
"	} else {\n"
"		set fh \"-3\"\n"
"		set err \"\"\n"
"		catch {set fh [open $logfile \"r\"]} err\n"
"		if {$fh == \"-3\"} {\n"
"			set txt \"\\nError opening \\\"$logfile\\\" $err.\\n\\n\"\n"
"		} else {\n"
"			set txt \"\\nLogfile \\\"$logfile\\\" current contents:\\n\"\n"
"			while {[gets $fh line] > -1} {\n"
"				append txt \"$line\\n\"\n"
"			}\n"
"			close $fh\n"
"		}\n"
"	}\n"
"	textwin \"Logfile\" \"Logfile\" $txt\n"
"}\n"
"\n"
"proc tail_logfile {} {\n"
"	global menu_var unset_str ffont\n"
"	set logfile $menu_var(logfile)\n"
"	\n"
"	set txt \"\"\n"
"	if {$logfile == \"\" || $logfile == $unset_str} {\n"
"		set txt \"\\nNo logfile was specified at x11vnc startup.\\n\\n\"	\n"
"	} elseif {![file exists $logfile]} {\n"
"		set txt \"\\nLogfile \\\"$logfile\\\" does not exist.\\n\\n\"\n"
"	} else {\n"
"		set cmd \"\"\n"
"		set xterm_cmd \"xterm -sb -fn $ffont -geometry 80x45 -title x11vnc-logfile -e\"\n"
"		set cmd [split $xterm_cmd]\n"
"		lappend cmd \"tail\"\n"
"		lappend cmd \"-3000f\"\n"
"		lappend cmd $logfile\n"
"		lappend cmd \"&\"\n"
"		catch {[eval exec $cmd]}\n"
"	}\n"
"	if {$txt != \"\"} {\n"
"		textwin \"Logfile\" \"Logfile\" $txt\n"
"	}\n"
"}\n"
"\n"
"proc set_connected {yesno} {\n"
"	global connected_to_x11vnc\n"
"	set orig $connected_to_x11vnc\n"
"	\n"
"	if {$yesno == \"yes\"} {\n"
"		set connected_to_x11vnc 1\n"
"	} else {\n"
"		set connected_to_x11vnc 0\n"
"		no_x11_display\n"
"		no_vnc_display\n"
"	}\n"
"	if {$orig != $connected_to_x11vnc} {\n"
"		set_widgets\n"
"	}\n"
"}\n"
"\n"
"proc detach_from_display {} {\n"
"	global connected_to_x11vnc reply_xdisplay x11vnc_xdisplay\n"
"	set str \"Detaching from X display.\"\n"
"	if {$reply_xdisplay != \"\"} {\n"
"		set str \"Detaching from $reply_xdisplay.\"\n"
"	} elseif {$x11vnc_xdisplay != \"\"} {\n"
"		set str \"Detaching from $x11vnc_xdisplay.\"\n"
"	}\n"
"	if {$connected_to_x11vnc} {\n"
"		append_text \"$str\\n\"\n"
"	}\n"
"	set_connected no\n"
"}\n"
"\n"
"proc do_stop_quit {} {\n"
"	push_new_value \"stop\" \"stop\" 1 0\n"
"	set_connected no\n"
"	update\n"
"	after 250\n"
"	destroy .\n"
"}\n"
"\n"
"# Menu item is an action:\n"
"proc do_action {item} {\n"
"	global menu_var connected_to_x11vnc beginner_mode\n"
"\n"
"	if {[in_debug_mode]} {\n"
"		append_text \"action: \\\"$item\\\"\\n\"\n"
"	}\n"
"#puts \"action: \\\"$item\\\"\\n\"\n"
"\n"
"	if {$item == \"ping\"} {\n"
"		if {$beginner_mode} {\n"
"			try_connect_and_query_all\n"
"		} else {\n"
"			try_connect\n"
"		}\n"
"		return\n"
"	} elseif {$item == \"start\"} {\n"
"		start_x11vnc\n"
"		return\n"
"	} elseif {$item == \"detach\"} {\n"
"		detach_from_display\n"
"		return\n"
"	} elseif {$item == \"attach\"} {\n"
"		try_connect_and_query_all\n"
"		return\n"
"	} elseif {$item == \"update-all\"} {\n"
"		query_all\n"
"		return\n"
"	} elseif {$item == \"clear-all\"} {\n"
"		clear_all\n"
"		return\n"
"	} elseif {$item == \"defaults-all\"} {\n"
"		defaults_all\n"
"		return\n"
"	} elseif {$item == \"save-settings\"} {\n"
"		save_settings\n"
"		return\n"
"	} elseif {$item == \"show-start-cmd\"} {\n"
"		show_start_cmd\n"
"		return\n"
"	} elseif {$item == \"all-settings\"} {\n"
"		show_all_settings\n"
"		return\n"
"	} elseif {$item == \"show-logfile\"} {\n"
"		show_logfile\n"
"		return\n"
"	} elseif {$item == \"tail-logfile\"} {\n"
"		tail_logfile\n"
"		return\n"
"	} elseif {$item == \"Misc-Tuning:\"} {\n"
"		menu_help \"$item\"\n"
"		return\n"
"	} elseif {$item == \"WindowView\"} {\n"
"		change_view_state\n"
"		return\n"
"	} elseif {$item == \"quit\" || $item == \"Quit\"} {\n"
"		destroy .\n"
"		exit 0\n"
"	} elseif {$item == \"stop+quit\"} {\n"
"		do_stop_quit\n"
"	}\n"
"\n"
"	if {[value_is_string $item]} {\n"
"		if {! [entry_dialog $item]} {\n"
"			return\n"
"		}\n"
"		set new $menu_var($item)\n"
"		set name $item\n"
"	} else {\n"
"		set new 1\n"
"		set name $item\n"
"	}\n"
"\n"
"	if {$item == \"load-settings\"} {\n"
"		load_settings\n"
"		return\n"
"	}\n"
"\n"
"	if {! $connected_to_x11vnc} {\n"
"		;\n"
"	} elseif {[regexp {^(stop|quit|exit|shutdown)$} $item]} {\n"
"		# just do -R\n"
"		append_text \"stopping remote x11vnc server...\\n\"\n"
"		push_new_value $item $name $new 0\n"
"		set_connected no\n"
"		\n"
"	} elseif {[opt_match Q $item]} {\n"
"		push_new_value $item $name $new 1\n"
"	} else {\n"
"		push_new_value $item $name $new 0\n"
"	}\n"
"}\n"
"\n"
"proc ptime {time} {\n"
"	set usec [lindex [split $time] 0]\n"
"	set sec [format \"%.3f\" [expr \"$usec / 1000000.0\"]]\n"
"	puts \"time: $sec secs.\"\n"
"}\n"
"\n"
"proc do_var {item} {\n"
"	global connected_to_x11vnc item_cascade menu_var\n"
"\n"
"	set debug [in_debug_mode]\n"
"\n"
"	set string 0\n"
"	if {[is_action $item] || $item == \"WindowView\"} {\n"
"		# Menu item is action:\n"
"		if {$debug} {\n"
"			ptime [time {do_action $item}]\n"
"		} else {\n"
"			do_action $item\n"
"		}\n"
"		return\n"
"	}\n"
"\n"
"	if {[value_is_string $item]} {\n"
"		# Menu item is a string:\n"
"		if {$item_cascade($item) != \"\"} {\n"
"			# Cascade sets variable automatically\n"
"		} else {\n"
"			# Otherwise Entry box\n"
"			if {![entry_dialog $item]} {\n"
"				return\n"
"			}\n"
"		}\n"
"		set new $menu_var($item)\n"
"		set name $item\n"
"	} else {\n"
"		# Menu item is a boolean:\n"
"		set name [check_var $item]\n"
"		if {$name == \"\"} {\n"
"			return\n"
"		}\n"
"		set new 1\n"
"	}\n"
"	if {$connected_to_x11vnc} {\n"
"		if {$debug} {\n"
"			ptime [time {push_new_value $item $name $new 1}]\n"
"		} else {\n"
"			push_new_value $item $name $new 1\n"
"		}\n"
"\n"
"		if {$item == \"http\"} {\n"
"			global vnc_url\n"
"			append_text \"  URL: $vnc_url\\n\"\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc menu_help {item} {\n"
"	if ![help_win $item] {\n"
"		textwin \"nohelp\" \"No help available\" \\\n"
"			\"Sorry, no help avaiable for \\\"$item\\\"\"\n"
"	}\n"
"}\n"
"\n"
"proc opt_match {c item} {\n"
"	global item_opts\n"
"	if {[info exists item_opts($item)]} {\n"
"		if {[regexp \"^\\[A-z\\]*$c\" $item_opts($item)]} {\n"
"			return 1\n"
"		}\n"
"	}\n"
"	return 0\n"
"}\n"
"\n"
"proc is_action {item} {\n"
"	return [opt_match A $item]\n"
"}\n"
"\n"
"proc is_gui_internal {item} {\n"
"	if {$item == \"Properties\"} {\n"
"		return 1\n"
"	}\n"
"	if {$item == \"Tray\"} {\n"
"		return 1\n"
"	}\n"
"	return [opt_match G $item]\n"
"}\n"
"\n"
"proc is_browse {item} {\n"
"	return [opt_match F $item]\n"
"}\n"
"\n"
"proc value_is_string {item} {\n"
"	global item_bool\n"
"	if {![info exists item_bool($item)]} {\n"
"		return 0\n"
"	}\n"
"	if {! $item_bool($item)} {\n"
"		return 1\n"
"	} else {\n"
"		return 0\n"
"	}\n"
"}\n"
"\n"
"proc value_is_bool {item} {\n"
"	global item_bool\n"
"	if {![info exists item_bool($item)]} {\n"
"		return 0\n"
"	}\n"
"	if {$item_bool($item)} {\n"
"		return 1\n"
"	} else {\n"
"		return 0\n"
"	}\n"
"}\n"
"\n"
"proc split_query0 {query} {\n"
"	# original slower way with regexp/regsub\n"
"	regsub -all {aro=} $query {ans=} query\n"
"	set items {}\n"
"	while {1} {\n"
"		if {! [regexp {^ans=(.*)$} $query m0 m1]} {\n"
"			break\n"
"		}\n"
"		set item $m1\n"
"		set m2 \"\"\n"
"		regexp {,ans=.*$} $item m2\n"
"		regsub {,ans=.*$} $item \"\" item\n"
"		if {$item != \"\"} {\n"
"			lappend items $item\n"
"		}\n"
"		set query $m2\n"
"		regsub {^,} $query \"\" query\n"
"	}\n"
"	return $items\n"
"}\n"
"\n"
"proc split_query {query} {\n"
"	regsub -all {aro=} $query {ans=} query\n"
"	set items {}\n"
"	while {1} {\n"
"		set n [string first \"ans=\" $query]\n"
"		if {$n < 0} {\n"
"			break\n"
"		}\n"
"		set from [expr $n+4]\n"
"\n"
"		set m [string first \",ans=\" $query]\n"
"		if {$m < 0} {\n"
"			set more 0\n"
"			set item [string range $query $from end]\n"
"		} else {\n"
"			set more 1\n"
"			set to   [expr $m-1]\n"
"			set item [string range $query $from $to]\n"
"		}\n"
"		if {$item != \"\"} {\n"
"			lappend items $item\n"
"		}\n"
"		if {$more} {\n"
"			incr m\n"
"			set query [string range $query $m end]\n"
"		} else {\n"
"			set query \"\"\n"
"		}\n"
"	}\n"
"	return $items\n"
"}\n"
"\n"
"proc set_x11_display {name} {\n"
"	global x11_display\n"
"	set x11_display \"x11vnc X display: $name\"\n"
"	set_name \"tkx11vnc - $name\"\n"
"}\n"
"proc set_vnc_display {name} {\n"
"	global vnc_display icon_mode\n"
"	set vnc_display \"VNC display: $name\"\n"
"\n"
"	if {$icon_mode} {\n"
"		set_icon_label\n"
"	}\n"
"}\n"
"proc set_vnc_url {name} {\n"
"	global vnc_url\n"
"	set vnc_url $name\n"
"}\n"
"proc no_x11_display {} {\n"
"	set_x11_display \"(*none*)\"\n"
"	set_name \"tkx11vnc\"\n"
"}\n"
"proc no_vnc_display {} {\n"
"	set_vnc_display \"(*none*)\"\n"
"}\n"
"proc no_vnc_url {} {\n"
"	set_vnc_url \"(*none*)\"\n"
"}\n"
"\n"
"proc get_vnc_display_number {} {\n"
"	global vnc_display\n"
"	if ![info exists vnc_display] {\n"
"		return \"none\"\n"
"	}\n"
"	if {$vnc_display == \"\"} {\n"
"		return \"none\"\n"
"	}\n"
"	set str $vnc_display\n"
"	regsub {VNC display: *} $str \"\" str\n"
"	if [regexp {:([0-9][0-9]*)} $str m0 n] {\n"
"		return $n\n"
"	}\n"
"	return \"none\"\n"
"}\n"
"\n"
"proc fetch_displays {} {\n"
"\n"
"	set qargs [list \"-Q\" \"display,vncdisplay\"]\n"
"	set result [run_remote_cmd $qargs]\n"
"\n"
"	set got_x11 0\n"
"	set got_vnc 0\n"
"	set got_url 0\n"
"\n"
"	foreach item [split_query $result] {\n"
"		if {[regexp {^display:(.*)$} $item m0 m1]} {\n"
"			set_x11_display $m1\n"
"			set got_x11 1\n"
"		} elseif {[regexp {^vncdisplay:(.*)$} $item m0 m1]} {\n"
"			set_vnc_display $m1\n"
"			set got_vnc 1\n"
"		} elseif {[regexp {^http_url:(.*)$} $item m0 m1]} {\n"
"			set_vnc_url $m1\n"
"			set got_url 1\n"
"		}\n"
"	}\n"
"	if {! $got_x11} {\n"
"		no_x11_display\n"
"	}\n"
"	if {! $got_vnc} {\n"
"		no_vnc_display\n"
"	}\n"
"	if {! $got_url} {\n"
"		no_vnc_url\n"
"	}\n"
"}\n"
"\n"
"proc client_dialog {client} {\n"
"	set cid \"\"\n"
"	set host \"\"\n"
"	set ip \"\"\n"
"	global menu_var text_area cleanup_window item_bool\n"
"\n"
"	#<id>:<ip>:<port>:<user>:<unix>:<hostname>:<input>:<loginview>:<time>\n"
"	append_text \"\\nClient info string:\\n - $client\\n\\n\"\n"
"	if {[regexp {^(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*)$} \\\n"
"	    $client m0 m1 m2 m3 m4 m5 m6 m7 m8 m9]} {\n"
"		set cid  $m1\n"
"		set ip   $m2\n"
"		set port $m3\n"
"		set user $m4\n"
"		set unix $m5\n"
"		set host $m6\n"
"		regsub {\\..*$} $host \"\" host\n"
"		set input $m7\n"
"		set logvo $m8\n"
"		set ltime $m9\n"
"		append_text \"Host: $host, Port: $port, User: $user\"\n"
"		if {$unix != \"\" && $unix != \"none\"} {\n"
"			append_text \", Unix: $unix\"\n"
"		}\n"
"		append_text \", IP: $ip, Id: $cid\\n\"\n"
"		append_text \" - originally logged in as: \"\n"
"		if {$logvo == \"1\" } {\n"
"			append_text \"View-Only Client\"\n"
"		} else {\n"
"			append_text \"Normal Client\"\n"
"		}\n"
"		if {$ltime != \"\"} {\n"
"			set tim [clock format $ltime]\n"
"			append_text \",  $tim\"\n"
"		}\n"
"		append_text \"\\n\"\n"
"		append_text \" - currently allowed input: \"\n"
"		set sk 0\n"
"		set sm 0\n"
"		set sb 0\n"
"		set sc 0\n"
"		set sf 0\n"
"		if {[regexp -nocase {K} $input]} {\n"
"			append_text \"Keystrokes\"\n"
"			set sk 1\n"
"		}\n"
"		if {[regexp -nocase {M} $input]} {\n"
"			if {$sk} {\n"
"				append_text \", \"\n"
"			}\n"
"			append_text \"Mouse-Motion\"\n"
"			set sm 1\n"
"		}\n"
"		if {[regexp -nocase {B} $input]} {\n"
"			if {$sk || $sm} {\n"
"				append_text \", \"\n"
"			}\n"
"			append_text \"Button-Click\"\n"
"			set sb 1\n"
"		}\n"
"		if {[regexp -nocase {C} $input]} {\n"
"			if {$sk || $sm || $sb} {\n"
"				append_text \", \"\n"
"			}\n"
"			append_text \"Clipboard\"\n"
"			set sm 1\n"
"		}\n"
"		if {[regexp -nocase {F} $input]} {\n"
"			if {$sk || $sm || $sb || $sf} {\n"
"				append_text \", \"\n"
"			}\n"
"			append_text \"Files\"\n"
"			set sf 1\n"
"		}\n"
"		if {! $sk && ! $sm && ! $sb && ! $sm && ! $sf} {\n"
"			append_text \"None\"\n"
"		}\n"
"		append_text \"\\n\"\n"
"	}\n"
"	if {$cid == \"\"} {\n"
"		append_text \"Invalid client info string: $client\\n\"\n"
"		return\n"
"	}\n"
"\n"
"	regsub -all {_} $input \"\" input\n"
"	set menu_var(client) \"$input\"\n"
"	set item_bool(client) 0\n"
"\n"
"	insert_client_action_window $input\n"
"	set rc [entry_dialog client 1]\n"
"\n"
"	cleanup_text_window\n"
"\n"
"	set val $menu_var(client)\n"
"	#puts \"rc: $rc  val: $val\"\n"
"\n"
"	if {! $rc} {\n"
"		return;\n"
"	} elseif {[regexp -nocase {(disconnect|close)} $val]} {\n"
"		disconnect_dialog $client\n"
"	} else {\n"
"		regsub -all -nocase {[^KMBCF]} $val \"\" val\n"
"		set item_bool(client_input) 0\n"
"		push_new_value \"client_input\" \"client_input\" \"$cid:$val\" 0\n"
"	}\n"
"}\n"
"\n"
"proc disconnect_dialog {client} {\n"
"	set cid \"\"\n"
"	set host \"\"\n"
"	set msg \"\\n\"\n"
"	append msg \"*** Client info string:\\n    $client\\n\"\n"
"	if {[regexp {^(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*)$} \\\n"
"	    $client m0 m1 m2 m3 m4 m5 m6 m7 m8 m9]} {\n"
"		set cid  $m1\n"
"		set ip   $m2\n"
"		set port $m3\n"
"		set user $m4\n"
"		set unix $m5\n"
"		set host $m6\n"
"		regsub {\\..*$} $host \"\" host\n"
"		set input $m7\n"
"		set logvo $m8\n"
"		set ltime $m9\n"
"		append_text \"Host: $host, Port: $port, IP: $ip, User: $user\"\n"
"		if {$unix != \"\" && $unix != \"none\"} {\n"
"			append_text \", Unix: $unix\"\n"
"		}\n"
"		append_text \", Id: $cid\\n\"\n"
"	}\n"
"	if {$cid == \"\"} {\n"
"		append_text \"Invalid client info string: $client\\n\"\n"
"		return\n"
"	}\n"
"	append msg \"*** To *DISCONNECT* this client press \\\"OK\\\" again, otherwise press \\\"Cancel\\\"\\n\"\n"
"	bell\n"
"	if {[warning_dialog $msg \"current\"]} {\n"
"		push_new_value \"disconnect\" \"disconnect\" $cid 1\n"
"	} else {\n"
"		append_text \"disconnect cancelled.\\n\"\n"
"	}\n"
"}\n"
"\n"
"proc update_clients_and_repost {} {\n"
"	global item_cascade menu_m menu_b\n"
"\n"
"	append_text \"Refreshing connected clients list... \"\n"
"	query_all 1\n"
"	update\n"
"\n"
"	set saw 0\n"
"	set casc $item_cascade(current)\n"
"	set last [$casc index end]\n"
"	for {set i 0} {$i <= $last} {incr i} {\n"
"		if {[$casc type $i] == \"separator\"} {\n"
"			continue\n"
"		}\n"
"		set name [$casc entrycget $i -label]\n"
"		if {[regexp {^num-clients} $name]} {\n"
"			continue\n"
"		}\n"
"		if {[regexp {^refresh-list} $name]} {\n"
"			continue\n"
"		}\n"
"		if {! $saw} {\n"
"			append_text \"\\n\"\n"
"		}\n"
"		set saw 1\n"
"		append_text \"client: $name\\n\"\n"
"	}\n"
"	if {! $saw} {\n"
"		append_text \"done.\\n\"\n"
"	}\n"
"}\n"
"\n"
"proc update_clients_menu {list} {\n"
"	global item_cascade ffont\n"
"	global saved_clients_str\n"
"\n"
"	if {![info exists saved_clients_str]} {\n"
"		set saved_clients_str \"\"\n"
"	}\n"
"	if {$list == \"INIT\"} {\n"
"		set list $saved_clients_str\n"
"	} else {\n"
"		set saved_clients_str $list\n"
"	}\n"
"\n"
"	set subm $item_cascade(current);\n"
"	catch {destroy $subm}\n"
"	menu $subm -tearoff 0 -font $ffont\n"
"	$subm add command\n"
"	$subm add command -label \"refresh-list\" \\\n"
"		-command \"update_clients_and_repost\"\n"
"	$subm add separator\n"
"	set count 0\n"
"	foreach client [split $list \",\"] {\n"
"		if {![regexp {^[a-z0-9]*[a-z0-9]:} $client]} {\n"
"			#append_text \"Skipping client line: \"\n"
"			#append_text $client\n"
"			#append_text \"\\n\"\n"
"			continue\n"
"		}\n"
"		regsub -all {[{}()~!$&*|;'\"`{}<>\\[\\]]} $client \"\" client\n"
"		#'\n"
"		if {[regexp {^(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*)$} \\\n"
"		    $client m0 m1 m2 m3 m4 m5 m6 m7 m8 m9]} {\n"
"			set id   $m1\n"
"			set user $m4\n"
"			set unix $m5\n"
"			set host $m6\n"
"			regsub {\\..*$} $host \"\" host\n"
"			set clabel \"$host $id\"\n"
"			if {$unix != \"\" && $unix != \"none\"} {\n"
"				set clabel \"$unix@$clabel\"\n"
"			} elseif {$user != \"unknown-user\"} {\n"
"				set clabel \"$user@$clabel\"\n"
"			}\n"
"		} else {\n"
"			regsub {:.*$} $client \"\" clabel\n"
"		}\n"
"		$subm add command -label \"$clabel\" \\\n"
"			-command \"client_dialog \\{$client\\}\"\n"
"		incr count\n"
"	}\n"
"	$subm entryconfigure 0 -label \"num-clients: $count\"\n"
"}\n"
"\n"
"proc set_widgets {} {\n"
"	global connected_to_x11vnc item_case item_menu item_entry menu_m\n"
"\n"
"	foreach item [array names item_case] {\n"
"		if ![info exists item_case($item)] { continue; }\n"
"		set case $item_case($item)\n"
"		if ![info exists item_menu($item)] { continue; }\n"
"		set menu $item_menu($item)\n"
"		if ![info exists item_entry($item)] { continue; }\n"
"		set entry $item_entry($item)\n"
"		if {$entry < 0} {\n"
"			# skip case under beginner_mode \n"
"			continue\n"
"		}\n"
"		set type [$menu type $entry]\n"
"		if {$type == \"separator\" || $type == \"tearoff\"} {\n"
"			continue\n"
"		}\n"
"		if {![winfo exists $menu]} {\n"
"			continue\n"
"		}\n"
"		if {$connected_to_x11vnc} {\n"
"			if {[active_when_connected $item]} {\n"
"				$menu entryconfigure $entry -state normal\n"
"			} else {\n"
"				$menu entryconfigure $entry -state disabled\n"
"			}\n"
"		} else {\n"
"			if {[active_when_starting $item]} {\n"
"				$menu entryconfigure $entry -state normal\n"
"			} else {\n"
"				$menu entryconfigure $entry -state disabled\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc toggle_simple_gui {} {\n"
"	global beginner_mode simple_gui_created\n"
"	global connected_to_x11vnc make_gui_count\n"
"\n"
"	if {$beginner_mode} {\n"
"		append_text \"\\nSwitching to simple-gui mode.\\n\"\n"
"	} else {\n"
"		append_text \"\\nSwitching to power-user gui mode.\\n\"\n"
"	}\n"
"\n"
"	if {$make_gui_count == 1} {\n"
"		incr make_gui_count\n"
"	}\n"
"	set simple_gui_created 1\n"
"	make_menu_items\n"
"	set_widgets\n"
"	set_internal_help\n"
"	append_text \"\\n\"\n"
"}\n"
"\n"
"proc little_qs {m} {\n"
"	global bfont ffont beginner_mode\n"
"	global helpremote helptext helplabel\n"
"	global tk_version osname\n"
"\n"
"	if {$tk_version < 8.0} {\n"
"		return\n"
"	}\n"
"	if {$osname == \"Darwin\"} {\n"
"		return\n"
"	}\n"
"\n"
"	set n [$m index end]\n"
"\n"
"	for {set i 0} {$i <= $n} {incr i} {\n"
"		set type [$m type $i]\n"
"#puts \"$m - $i - $type\"\n"
"		if {$type == \"separator\"} {\n"
"			$m add separator\n"
"		} elseif {$type == \"tearoff\"} {\n"
"			continue;\n"
"		} else {\n"
"			set label [$m entrycget $i -label]\n"
"			set str \"\"\n"
"			if {[info exists helpremote($label)]} {\n"
"				set str \"(?)\"\n"
"			} elseif {[info exists helptext($label)]} {\n"
"				set str \"(?)\"\n"
"			}\n"
"			$m add command -label $str \\\n"
"				-font $ffont \\\n"
"				-command \"menu_help $label\";\n"
"\n"
"			if {$str == \"\"} {\n"
"				$m entryconfigure end -state disabled\n"
"			}\n"
"			set arg \"$m,$i\"\n"
"#puts \"helplabel: $arg -> $label\"\n"
"			set helplabel($arg) $label\n"
"			set j [$m index end]\n"
"			set arg \"$m,$j\"\n"
"			set helplabel($arg) $label\n"
"		}\n"
"		if {$i == 0} {\n"
"			$m entryconfigure end -columnbreak 1\n"
"		}\n"
"	}\n"
"\n"
"	menu_bindings $m\n"
"}\n"
"\n"
"proc make_menu_items {} {\n"
"	global template \n"
"	global menu_b menu_m menu_count\n"
"	global item_opts item_bool item_case item_menu item_entry menu_var unset_str\n"
"	global item_cascade\n"
"	global bfont ffont beginner_mode simple_gui_created\n"
"	global helptext helpremote helplabel\n"
"\n"
"	# some tweaks...\n"
"	if {![info exists menu_var(deny)]} {\n"
"		set menu_var(deny) 0\n"
"	}\n"
"\n"
"	set case \"\";\n"
"	set L_casc \"\"\n"
"	set L_casc_count 0\n"
"	set L_menus [list]\n"
"\n"
"	# Extract the menu items:\n"
"	foreach line [split $template \"\\n\"] {\n"
"		if {[regexp {^Row:} $line]} {\n"
"			continue\n"
"		}\n"
"		if {[regexp {^[A-z]} $line]} {\n"
"			set case [string trim $line]\n"
"\n"
"			if {$simple_gui_created} {\n"
"				set i0 0\n"
"				#if {$case == \"Misc\"} { # kludge for simple_gui\n"
"				#	set i0 1\n"
"				#}\n"
"				catch {$menu_m($case) delete $i0 end}\n"
"			}\n"
"			set menu_count($case) 0\n"
"			continue;\n"
"		}\n"
"\n"
"		set item [string trim $line]\n"
"		regsub -all {  *} $item \" \" item\n"
"		if {$item == \"\"} {\n"
"			continue;\n"
"		}\n"
"		set opts \"\"\n"
"		if {[regexp {^=} $item]} {\n"
"			set opts [lindex [split $item] 0]\n"
"			regsub {^=} $opts \"\" opts\n"
"			set item [lindex [split $item] 1]\n"
"		}\n"
"		if {[regexp {^0} $opts]} {\n"
"			continue;\n"
"		}\n"
"		if {[regexp {:$} $item]} {\n"
"			set bool 0\n"
"		} else {\n"
"			set bool 1\n"
"		}\n"
"		regsub {:$} $item {} item\n"
"\n"
"		if {$item == \"LOFF\"} {\n"
"			set L_casc \"\"\n"
"			continue\n"
"		}\n"
"\n"
"		if {$item == \"-- D\"} {\n"
"			set beginner_sep 1\n"
"			set item \"--\"\n"
"		} else {\n"
"			set beginner_sep 0\n"
"		}\n"
"\n"
"		set item_opts($item) $opts\n"
"		set item_case($item) $case\n"
"		set item_bool($item) $bool\n"
"		set item_cascade($item) \"\"\n"
"\n"
"		if {$L_casc == \"\"} {\n"
"			set item_entry($item) $menu_count($case)\n"
"			set m $menu_m($case)\n"
"		} else {\n"
"			# hack for cascades for crowded menus.  See =GAL opts.\n"
"			set item_entry($item) $L_casc_count\n"
"			set m $L_casc\n"
"		}\n"
"\n"
"		set mvar 0 \n"
"\n"
"		if {$beginner_mode && ! $beginner_sep && ![opt_match D $item]} {\n"
"			set item_entry($item) \"-1\"\n"
"			continue;\n"
"		}\n"
"\n"
"		set item_menu($item) $m\n"
"\n"
"		if {0} { puts \"ITEM: $item\\t- $opts\\t- $case\\t- \\\n"
"			$bool\\t- $menu_count($case)\" }\n"
"\n"
"		# Create the menu items, its variables, etc., etc.\n"
"\n"
"		if {$item == \"--\"} {\n"
"			$m add separator\n"
"\n"
"		} elseif {$item == \"Quit\"} {\n"
"			# Quit item must shut us down:\n"
"			$m add command -label \"$item\" -underline 0 \\\n"
"				-font $ffont \\\n"
"				-command {destroy .; exit 0}\n"
"\n"
"		} elseif {$case == \"Help\"} {\n"
"			# Help is simple help:\n"
"			$m add command -label \"$item\" \\\n"
"				-font $ffont \\\n"
"				-command \"menu_help $item\"\n"
"\n"
"		} elseif {[opt_match L $item]} {\n"
"			# Special sub-menu cascade (=GAL ends with LOFF)\n"
"			set subm $m.casc_L$menu_count($case)\n"
"			catch {destroy $subm}\n"
"			menu $subm -tearoff 0 -font $ffont\n"
"			set item_cascade($item) $subm\n"
"			$m add cascade -label \"$item\" \\\n"
"				-font $ffont \\\n"
"				-menu $subm\n"
"			set L_casc $subm\n"
"			set L_casc_count -1\n"
"			lappend L_menus $L_casc\n"
"\n"
"		} elseif {$item == \"current\"} {\n"
"			# Current clients cascade\n"
"			set subm $m.current_cascade\n"
"			catch {destroy $subm}\n"
"			set item_cascade($item) $subm\n"
"			update_clients_menu \"INIT\"\n"
"			$m add cascade -label \"$item\" \\\n"
"				-font $ffont \\\n"
"				-menu $subm\n"
"\n"
"		} elseif {[is_action $item]} {\n"
"			# Action\n"
"			$m add command -label \"$item\" \\\n"
"				-font $ffont \\\n"
"				-command \"do_var $item\"\n"
"			if {![info exists menu_var($item)]} {\n"
"				set menu_var($item) \"\";	# for convenience\n"
"			}\n"
"\n"
"		} elseif {! $item_bool($item)} {\n"
"			# String\n"
"			if {[regexp -- {-C:(.*)} $item_opts($item) m0 m1]} {\n"
"				# Radiobutton select\n"
"				set subm $m.radio_cascade$menu_count($case)\n"
"				catch {destroy $subm}\n"
"				menu $subm -tearoff 0 -font $ffont\n"
"				foreach val [split $m1 \",\"] {\n"
"					$subm add radiobutton -label \"$val\" \\\n"
"						-command \"do_var $item\" \\\n"
"						-value \"$val\" \\\n"
"						-font $ffont \\\n"
"						-variable menu_var($item)\n"
"				}\n"
"				$m add cascade -label \"$item\" \\\n"
"					-font $ffont \\\n"
"					-menu $subm\n"
"				set item_cascade($item) $subm\n"
"			} else {\n"
"				# Arbitrary_string\n"
"				$m add command -label \"$item\" \\\n"
"					-font $ffont \\\n"
"					-command \"do_var $item\"\n"
"			}\n"
"			set mvar 1\n"
"\n"
"		} elseif {$item == \"simple-gui\"} {\n"
"			$m add checkbutton -label \"$item\" \\\n"
"				-command \"toggle_simple_gui\" \\\n"
"				-font $ffont \\\n"
"				-variable beginner_mode\n"
"		} else {\n"
"			# Boolean\n"
"			$m add checkbutton -label \"$item\" \\\n"
"				-command \"do_var $item\" \\\n"
"				-font $ffont \\\n"
"				-variable menu_var($item)\n"
"			if {![info exists menu_var($item)]} {\n"
"				set menu_var($item) 0\n"
"			}\n"
"		}\n"
"\n"
"		if {$L_casc_count == -1} {\n"
"			incr menu_count($case)\n"
"			incr L_casc_count\n"
"		} elseif {$L_casc != \"\"} {\n"
"			incr L_casc_count\n"
"		} else {\n"
"			incr menu_count($case)\n"
"		}\n"
"\n"
"		if {$mvar} {\n"
"			if {![info exists menu_var($item)]} {\n"
"				set menu_var($item) $unset_str\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	# Now make the little \"(?)\" help buttons\n"
"	global osname\n"
"	foreach case [array names menu_m] {\n"
"		if {$case == \"Help\"} {\n"
"			continue;\n"
"		}\n"
"		little_qs $menu_m($case);\n"
"	}\n"
"	foreach m $L_menus {\n"
"		little_qs $m\n"
"	}\n"
"}\n"
"\n"
"proc check_update_vars {} {\n"
"	global last_query_all_time query_all_freq icon_mode\n"
"	global connected_to_x11vnc client_tail client_sock\n"
"\n"
"	set now [clock seconds]\n"
"\n"
"	set delay $query_all_freq\n"
"	if {$client_tail != \"\" && $client_sock == \"\"} {\n"
"		set delay [expr 2 * $query_all_freq]\n"
"	}\n"
"\n"
"	if {$connected_to_x11vnc} {\n"
"		set quiet 0\n"
"		set refresh [expr \"$last_query_all_time + $delay\"]\n"
"\n"
"		# puts \"menu_posted $now $last_query_all_time\"\n"
"		# puts \"menu_posted $refresh\"\n"
"\n"
"		if {$now > $refresh} {\n"
"			append_text \"Refreshing current settings... \"\n"
"			query_all $quiet\n"
"			if {$quiet} {\n"
"				append_text \"done\\n\"\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc menu_posted {} {\n"
"	check_update_vars\n"
"}\n"
"\n"
"proc props_widgets {state} {\n"
"	global props_buttons\n"
"	foreach w $props_buttons {\n"
"		$w configure -state $state	\n"
"	}\n"
"	update\n"
"}\n"
"\n"
"proc props_apply {} {\n"
"	global props_accept props_confirm props_viewonly props_shared\n"
"	global props_passwd props_viewpasswd\n"
"	global prop0_accept prop0_confirm prop0_viewonly prop0_shared\n"
"	global prop0_passwd prop0_viewpasswd\n"
"	global menu_var\n"
"	global client_sock\n"
"\n"
"	props_widgets disabled\n"
"\n"
"	set aft 500\n"
"	if {[info exists client_sock]} {\n"
"		if {$client_sock != \"\"} {\n"
"			set aft 150\n"
"		}\n"
"	}\n"
"	set did 0\n"
"\n"
"	if {$props_accept != $prop0_accept} {\n"
"		if {$did > 0} {after $aft}; incr did\n"
"		if {$props_accept} {\n"
"			push_new_value \"unlock\" \"unlock\" 1 0\n"
"		} else {\n"
"			push_new_value \"lock\" \"lock\" 1 0\n"
"		}\n"
"		set prop0_accept $props_accept\n"
"	}\n"
"\n"
"	if {$props_confirm != $prop0_confirm} {\n"
"		if {$did > 0} {after $aft}; incr did\n"
"		if {$props_confirm} {\n"
"			push_new_value \"accept\" \"accept\" \"popup\" 1\n"
"		} else {\n"
"			push_new_value \"accept\" \"accept\" \"\" 1\n"
"		}\n"
"		if {$menu_var(accept) == \"popup\"} {\n"
"			set props_confirm 1\n"
"		} elseif {$menu_var(accept) == \"\"} {\n"
"			set props_confirm 0\n"
"		}\n"
"		set prop0_confirm $props_confirm\n"
"	}\n"
"\n"
"	if {$props_viewonly != $prop0_viewonly} {\n"
"		if {$did > 0} {after $aft}; incr did\n"
"		if {$props_viewonly} {\n"
"			push_new_value \"viewonly\" \"viewonly\" 1 1\n"
"		} else {\n"
"			push_new_value \"viewonly\" \"noviewonly\" 1 1\n"
"		}\n"
"		if {$menu_var(viewonly)} {\n"
"			set props_viewonly 1\n"
"		} else {\n"
"			set props_viewonly 0\n"
"		}\n"
"		set prop0_viewonly $props_viewonly\n"
"	}\n"
"\n"
"	if {$props_shared != $prop0_shared} {\n"
"		if {$did > 0} {after $aft}; incr did\n"
"		if {$props_shared} {\n"
"			push_new_value \"shared\" \"shared\" 1 1\n"
"		} else {\n"
"			push_new_value \"shared\" \"noshared\" 1 1\n"
"		}\n"
"		if {$menu_var(shared)} {\n"
"			set props_shared 1\n"
"		} else {\n"
"			set props_shared 0\n"
"		}\n"
"		set prop0_shared $props_shared\n"
"	}\n"
"\n"
"	set fpw 0\n"
"	if {$props_passwd != $prop0_passwd} {\n"
"		set fpw 1\n"
"	}\n"
"	set vpw 0\n"
"	if {$props_viewpasswd != $prop0_viewpasswd} {\n"
"		set vpw 1\n"
"	}\n"
"\n"
"	set pw_ord [list]\n"
"	if {!$fpw && !$vpw } {\n"
"		# neither change\n"
"		;\n"
"	} elseif {$fpw && !$vpw} {\n"
"		# full password change\n"
"		if {$props_passwd == \"\"} {\n"
"			if {$prop0_viewpasswd != \"\"} {\n"
"				# set view to \"\" as well and first\n"
"				set props_viewpasswd \"\"\n"
"				set pw_ord [list vpw fpw]\n"
"			} else {\n"
"				set pw_ord [list fpw]\n"
"			}\n"
"		} else {\n"
"			# assume view state OK\n"
"			set pw_ord [list fpw]\n"
"		}\n"
"		\n"
"	} elseif {!$fpw && $vpw} {\n"
"		# view password change\n"
"		if {$props_viewpasswd == \"\"} {\n"
"			# assume full state OK\n"
"			set pw_ord [list vpw]\n"
"		} else {\n"
"			if {$prop0_passwd == \"\"} {\n"
"				# could be trouble, x11vnc makes random\n"
"				# full passwd...\n"
"				set pw_ord [list vpw]\n"
"			} else {\n"
"				# OK, full non-null.\n"
"				set pw_ord [list vpw]\n"
"			}\n"
"		}\n"
"	} elseif {$fpw && $vpw} {\n"
"		# both full and view password change\n"
"		if {$props_passwd == \"\" && $props_viewpasswd == \"\"} {\n"
"			# OK, do view first\n"
"			set pw_ord [list vpw fpw]\n"
"		} elseif {$props_passwd == \"\" && $props_viewpasswd != \"\"} {\n"
"			# Not good, do view first anyway x11vnc will fix.\n"
"			set pw_ord [list vpw fpw]\n"
"		} elseif {$props_passwd != \"\" && $props_viewpasswd == \"\"} {\n"
"			# OK, view first\n"
"			set pw_ord [list vpw fpw]\n"
"		} elseif {$props_passwd != \"\" && $props_viewpasswd != \"\"} {\n"
"			# OK, full first\n"
"			set pw_ord [list fpw vpw]\n"
"		}\n"
"	}\n"
"\n"
"	foreach case $pw_ord {\n"
"		if {$case == \"fpw\"} {\n"
"			if {$did > 0} {after $aft}; incr did\n"
"			push_new_value \"passwd\" \"passwd\" \"$props_passwd\" 1\n"
"			set prop0_passwd $props_passwd\n"
"		}\n"
"		if {$case == \"vpw\"} {\n"
"			if {$did > 0} {after $aft}; incr did\n"
"			push_new_value \"viewpasswd\" \"viewpasswd\" \"$props_viewpasswd\" 1\n"
"			set prop0_viewpasswd $props_viewpasswd\n"
"		}\n"
"	}\n"
"\n"
"	props_widgets normal\n"
"}\n"
"\n"
"proc props_advanced {} {\n"
"	global icon_mode icon_win props_win full_win\n"
"	global props_advanced_first\n"
"\n"
"	if ![info exists props_advanced_first] {\n"
"		center_win $full_win\n"
"		set props_advanced_first 1\n"
"		set first 1\n"
"	} else {\n"
"		set first 0\n"
"	}\n"
"	update\n"
"	wm deiconify $full_win\n"
"	update\n"
"\n"
"	if {$first} {\n"
"		set w $full_win\n"
"		wm minsize $w [winfo width $w] [winfo height $w]\n"
"	}\n"
"}\n"
"\n"
"proc do_props {{msg \"\"}} {\n"
"	global props_accept props_confirm props_viewonly props_shared\n"
"	global props_passwd props_viewpasswd\n"
"	global prop0_accept prop0_confirm prop0_viewonly prop0_shared\n"
"	global prop0_passwd prop0_viewpasswd\n"
"	global menu_var unset_str\n"
"	global have_labelframes ffont bfont\n"
"	global props_buttons icon_noadvanced\n"
"	global icon_mode icon_mode_at_startup\n"
"	global screen_height screen_width\n"
"\n"
"	check_update_vars\n"
"\n"
"	set pady 1m\n"
"	if {$screen_height <= 360} {\n"
"		set pady 0m\n"
"	}\n"
"\n"
"	if [info exists menu_var(deny)] {\n"
"		if {$menu_var(deny) == $unset_str || $menu_var(deny) == 0} {\n"
"			set props_accept 1\n"
"		} else {\n"
"			set props_accept 0\n"
"		}\n"
"	} else {\n"
"		set menu_var(deny) 0\n"
"		set props_accept 1\n"
"	}\n"
"	set prop0_accept $props_accept\n"
"\n"
"	if [info exists menu_var(accept)] {\n"
"		if {$menu_var(accept) == $unset_str || $menu_var(accept) == \"\"} {\n"
"			set props_confirm 0\n"
"		} else {\n"
"			set props_confirm 1\n"
"		}\n"
"	} else {\n"
"		set menu_var(accept) \"\"\n"
"		set props_confirm 0\n"
"	}\n"
"	set prop0_confirm $props_confirm\n"
"\n"
"	if [info exists menu_var(viewonly)] {\n"
"		if {$menu_var(viewonly) == $unset_str || $menu_var(viewonly) == \"\"} {\n"
"			set props_viewonly 0\n"
"		} elseif ($menu_var(viewonly)) {\n"
"			set props_viewonly 1\n"
"		} else {\n"
"			set props_viewonly 0\n"
"		}\n"
"	} else {\n"
"		set menu_var(viewonly) 0\n"
"		set props_viewonly 0\n"
"	}\n"
"	set prop0_viewonly $props_viewonly\n"
"\n"
"	if [info exists menu_var(shared)] {\n"
"		if {$menu_var(shared) == $unset_str || $menu_var(shared) == \"\"} {\n"
"			set props_shared 0\n"
"		} elseif ($menu_var(shared)) {\n"
"			set props_shared 1\n"
"		} else {\n"
"			set props_shared 0\n"
"		}\n"
"	} else {\n"
"		set menu_var(shared) 0\n"
"		set props_shared 0\n"
"	}\n"
"	set prop0_shared $props_shared\n"
"\n"
"	if ![info exists props_passwd] {\n"
"		set props_passwd \"\"\n"
"	}\n"
"	set prop0_passwd $props_passwd\n"
"\n"
"	if ![info exists props_viewpasswd] {\n"
"		set props_viewpasswd \"\"\n"
"	}\n"
"	set prop0_viewpasswd $props_viewpasswd\n"
"\n"
"	if [info exists props_buttons] {\n"
"		catch {unset props_buttons}\n"
"	}\n"
"	set props_buttons [list]\n"
"\n"
"	set w .props\n"
"	catch {destroy $w}\n"
"	toplevel $w\n"
"	wm title $w \"x11vnc Properties\"\n"
"	set b1 \"$w.buttons1\"\n"
"	frame $b1\n"
"	button $b1.ok -text OK -command \"props_apply; destroy $w\" -font $bfont\n"
"	button $b1.cancel -text Cancel -command \"destroy $w\" -font $bfont\n"
"	button $b1.apply  -text Apply -command \"props_apply\" -font $bfont\n"
"\n"
"	bind $w <KeyPress-Escape> \"destroy $w\"\n"
"\n"
"	pack $b1.apply $b1.cancel $b1.ok -side right -expand 1\n"
"	lappend props_buttons $b1.apply $b1.cancel $b1.ok\n"
"\n"
"	set b2 \"$w.buttons2\"\n"
"	frame $b2\n"
"\n"
"	button $b2.advanced -text \"Advanced ...\" \\\n"
"		-command \"destroy $w; props_advanced\" -font $bfont\n"
"	if {! $icon_noadvanced} {\n"
"		lappend props_buttons $b2.advanced\n"
"		pack $b2.advanced -side right -expand 1\n"
"	}\n"
"\n"
"	button $b2.help -text \"Help ...\" -command \"menu_help Properties\" -font $bfont\n"
"	lappend props_buttons $b2.help\n"
"	pack $b2.help -side right -expand 1\n"
"\n"
"	set vp \"$w.viewpw\"\n"
"	if {$have_labelframes} {\n"
"		labelframe $vp -text \"ViewOnly Password\" -font $bfont\n"
"	} else {\n"
"		frame $vp\n"
"		set l $vp.l\n"
"		label $l -text \"ViewOnly Password:\" -justify left -anchor w -font $bfont\n"
"		pack $vp.l -fill x -expand 1 -padx 1m -pady 0m -side top\n"
"	}\n"
"	entry $vp.e -show \"*\" -textvariable props_viewpasswd -font $bfont\n"
"	pack $vp.e -fill x -expand 1 -padx 1m -pady $pady -side top\n"
"\n"
"\n"
"	lappend props_buttons $vp.e\n"
"\n"
"	set pw \"$w.passwd\"\n"
"	if {$have_labelframes} {\n"
"		labelframe $pw -text \"Password\" -font $bfont\n"
"	} else {\n"
"		frame $pw\n"
"		set l $pw.l\n"
"		label $l -text \"Password:\" -justify left -anchor w -font $bfont\n"
"		pack $pw.l -fill x -expand 1 -padx 1m -pady 0m -side top\n"
"	}\n"
"	entry $pw.e -show \"*\" -textvariable props_passwd -font $bfont\n"
"	pack $pw.e -fill x -expand 1 -padx 1m -pady $pady -side top\n"
"\n"
"	if {! $icon_mode_at_startup} {\n"
"		$vp.e configure -state disabled\n"
"		catch {$vp.l configure -state disabled}\n"
"		catch {$vp configure -state disabled}\n"
"		catch {$vp configure -foreground grey60}\n"
"		$pw.e configure -state disabled\n"
"		catch {$pw.l configure -state disabled}\n"
"		catch {$pw configure -state disabled}\n"
"		catch {$pw configure -foreground grey60}\n"
"	}\n"
"\n"
"	lappend props_buttons $pw.e\n"
"\n"
"	set sh \"$w.shared\"\n"
"	frame $sh\n"
"	checkbutton $sh.button -text \"Shared\" \\\n"
"		-variable props_shared -anchor w -font $bfont\n"
"	pack $sh.button -fill x -expand 1 -padx 1m -pady $pady\n"
"\n"
"	set vo \"$w.viewonly\"\n"
"	frame $vo\n"
"	checkbutton $vo.button -text \"All Clients ViewOnly\" \\\n"
"		-variable props_viewonly -anchor w -font $bfont\n"
"	pack $vo.button -fill x -expand 1 -padx 1m -pady $pady\n"
"\n"
"	set cf \"$w.confirm\"\n"
"	frame $cf\n"
"	checkbutton $cf.button -text \"Ask for Confirmation\" \\\n"
"		-variable props_confirm -anchor w -font $bfont\n"
"	pack $cf.button -fill x -expand 1 -padx 1m -pady $pady\n"
"\n"
"	set ac \"$w.accept\"\n"
"	frame $ac\n"
"	checkbutton $ac.button -text \"Accept Connections\" \\\n"
"		-variable props_accept -anchor w -font $bfont\n"
"	pack $ac.button -fill x -expand 1 -padx 1m -pady $pady\n"
"\n"
"	set px \"6m\"\n"
"	pack $b1 -side bottom -fill x -pady $pady -padx $px\n"
"	pack $b2 -side bottom -fill x -pady $pady -padx $px\n"
"	pack $vp -side bottom -fill x -pady $pady -padx $px\n"
"	pack $pw -side bottom -fill x -pady $pady -padx $px\n"
"	pack $sh -side bottom -fill x -pady 0m -padx $px\n"
"	pack $vo -side bottom -fill x -pady 0m -padx $px\n"
"	pack $cf -side bottom -fill x -pady 0m -padx $px\n"
"	pack $ac -side bottom -fill x -pady 0m -padx $px\n"
"\n"
"	if {$msg != \"\"} {\n"
"		set tw [textwidth $msg]\n"
"		set th [textheight $msg]\n"
"		set th [expr $th - 1]\n"
"		set ms \"$w.msg\"\n"
"		text $ms -font $ffont -relief ridge -width $tw -height $th\n"
"		$ms insert 1.0 $msg\n"
"		pack $ms -side bottom -fill x -pady $pady -padx $px\n"
"		update\n"
"	}\n"
"\n"
"	lappend props_buttons $ac.button $cf.button $vo.button $sh.button\n"
"\n"
"	wm resizable $w 1 0\n"
"	center_win $w\n"
"	update\n"
"	wm minsize $w [winfo width $w] [winfo height $w]\n"
"\n"
"	tkwait window $w\n"
"}\n"
"\n"
"proc do_new_client {} {\n"
"	global newclient ffont bfont\n"
"\n"
"	set w .newclient\n"
"	catch {destroy $w}\n"
"	toplevel $w\n"
"	label $w.l -text \"Hostname: \" -font $bfont\n"
"	set newclient \"\"\n"
"	entry $w.e -width 16 -textvariable newclient -font $bfont \n"
"	button $w.b -text OK -command \"destroy $w\" -font $bfont\n"
"	button $w.h -text Help -command \"menu_help NewClient\" -font $bfont\n"
"	bind $w.e <Return> \"update; after 100; destroy $w\"\n"
"\n"
"	wm title $w \"New Client\"\n"
"\n"
"	pack $w.l $w.e $w.h $w.b -side left -pady 1m -padx 0.5m\n"
"	focus $w.e\n"
"	center_win $w\n"
"	update \n"
"	\n"
"	tkwait window $w\n"
"\n"
"	regsub -all {[{}()~!$&*|;'\"`{}<>\\[\\]]} $newclient \"\" newclient\n"
"	#'\n"
"	if {$newclient != \"\"} {\n"
"		push_new_value \"connect\" \"connect\" \"$newclient\" 1\n"
"	}\n"
"}\n"
"\n"
"proc do_disconnect_all {} {\n"
"	push_new_value \"disconnect\" \"disconnect\" \"all\" 1\n"
"}\n"
"\n"
"proc do_disconnect_client {id} {\n"
"	push_new_value \"disconnect\" \"disconnect\" \"$id\" 1\n"
"}\n"
"\n"
"proc popup_post {m} {\n"
"	global popup_cascade_posted client_balloon\n"
"	global client_id_list\n"
"\n"
"	set popup_cascade_posted 0\n"
"	\n"
"	set wd \"$m.disconnect\"\n"
"\n"
"	if {![winfo exists $wd]} {\n"
"		return\n"
"	}\n"
"\n"
"	catch {$wd delete 0 end}\n"
"\n"
"	$wd add command -label \"Disconnect client:\"\n"
"	$wd add separator\n"
"	$wd add command -label \"All Clients\" -command do_disconnect_all\n"
"\n"
"	if {![info exists client_id_list]} {\n"
"		return\n"
"	}\n"
"\n"
"	foreach client $client_id_list {\n"
"		if {$client == \"\"} {\n"
"			continue\n"
"		}\n"
"		if {[regexp {^([^:]*):(.*)$} $client mat id lab]} {\n"
"			set nid [expr \"$id + 0\"]\n"
"			$wd add command -label \"$nid $lab\" \\\n"
"				-command \"do_disconnect_client $id\"\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc pmenu {m x y} {\n"
"	if {![winfo exists $m]} {\n"
"		return\n"
"	}\n"
"	set x [expr $x-10]\n"
"	set y [expr $y-10]\n"
"	$m post $x $y\n"
"	# XXX more care needed\n"
"	grab set -global $m\n"
"}\n"
"\n"
"proc set_client_balloon {str} {\n"
"	global client_balloon vnc_display\n"
"	global client_id_list\n"
"\n"
"	set client_id_list [list]\n"
"	\n"
"	set client_balloon \"$vnc_display\"\n"
"	set count 0\n"
"	regsub -all {^.*aro=clients:} $str \"\" str\n"
"	regsub -all {aro=.*$} $str \"\" str\n"
"	regsub -all {ans=.*$} $str \"\" str\n"
"	foreach client [split $str \",\"] {\n"
"		#puts \"client: $client\"\n"
"		if [regexp {^[ 	]*$} $client] {\n"
"			continue\n"
"		}\n"
"		if {[regexp {^(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*):(.*)$} \\\n"
"		    $client m0 m1 m2 m3 m4 m5 m6 m7 m8 m9]} {\n"
"			set id    $m1\n"
"			set nid   [expr \"$m1 + 0\"]\n"
"			set ip    $m2\n"
"			set port  $m3\n"
"			set user  $m4\n"
"			set unix  $m5\n"
"			if {[string length $user] >= 24} {\n"
"				# weird identd hash...\n"
"				set user [string range $user 0 8]\n"
"				set user \"${user}...\"\n"
"			}\n"
"			if {$unix != \"\" && $unix != \"none\"} {\n"
"				set user $unix\n"
"			}\n"
"			set host  $m6\n"
"			set input $m7\n"
"			set vo    $m8\n"
"			set ltime $m9\n"
"			if [regexp {^[ 	]*$} $host] {\n"
"				set host $ip\n"
"			}\n"
"			set client_balloon \"${client_balloon}\\n$nid $user\\@$host\"\n"
"			if {$vo == \"1\"} {\n"
"				set client_balloon \"${client_balloon} - view\"\n"
"				lappend client_id_list \"$id:$user\\@$host - view\"\n"
"			} else {\n"
"				set client_balloon \"${client_balloon} - full\"\n"
"				lappend client_id_list \"$id:$user\\@$host - full\"\n"
"			}\n"
"		} else {\n"
"			set i [expr $count+1]\n"
"			if {$i == 1} {\n"
"				set client_balloon \"${client_balloon}\\nunknown-host$i\"\n"
"			}\n"
"		}\n"
"		incr count\n"
"	}\n"
"	if {$count == 0} {\n"
"		set client_balloon \"${client_balloon}\\nNo connections.\"\n"
"	}\n"
"	icon_win_cfg $count\n"
"}\n"
"\n"
"proc read_client_info {channel} {\n"
"	global x11vnc_client_file client_str client_info_read\n"
"	global read_client_info_lock\n"
"	set db 0\n"
"\n"
"	if {![info exists read_client_info_lock]} {\n"
"		set read_client_info_lock 0\n"
"	}\n"
"\n"
"	if {$channel != \"\"} {\n"
"\n"
"		if {$read_client_info_lock} {\n"
"			return\n"
"		}\n"
"		set read_client_info_lock 1\n"
"		after 100\n"
"		set str \"\"\n"
"		set count [gets $channel str]\n"
"		if {$db} {puts stderr \"read_client_info-$channel: $str\"}\n"
"\n"
"		if {$count == -1 || [eof $channel]} {\n"
"			close $channel\n"
"			catch {file delete $x11vnc_client_file}\n"
"			set read_client_info_lock 0\n"
"			clean_icon_exit\n"
"		}\n"
"		if {$count > 0 && ![regexp {^[ 	]*$} $str]} {\n"
"			set client_info_read 1\n"
"			if {$str == \"quit\"} {\n"
"				catch {file delete $x11vnc_client_file}\n"
"				set read_client_info_lock 0\n"
"				clean_icon_exit\n"
"			} elseif {$str == \"skip\"} {\n"
"				;\n"
"			} elseif [regexp {^clients:} $str] {\n"
"				regsub {^clients:} $str \"\" str\n"
"				if {$str == \"none\"} {\n"
"					set str \"\"\n"
"				}\n"
"				update_clients_menu $str\n"
"				set client_str $str\n"
"				set_client_balloon $str\n"
"			}\n"
"		}\n"
"		set read_client_info_lock 0\n"
"	}\n"
"}\n"
"\n"
"proc read_client_tail {} {\n"
"	global client_tail\n"
"\n"
"	if {$client_tail != \"\"} {\n"
"		read_client_info $client_tail\n"
"	}\n"
"}\n"
"\n"
"proc read_client_sock {} {\n"
"	global client_sock\n"
"\n"
"	if {$client_sock != \"\"} {\n"
"		read_client_info $client_sock\n"
"	}\n"
"}\n"
"\n"
"proc show_client_balloon {} {\n"
"	global icon_mode icon_win props_win full_win\n"
"	global client_balloon ffont connected_to_x11vnc\n"
"\n"
"	set noinfo \"tkx11vnc: no client information\"\n"
"	set noinfo \"$noinfo\\navailable from x11vnc ...\"\n"
"	if ![info exists client_balloon] {\n"
"		set client_balloon $noinfo\n"
"	}\n"
"	if {$client_balloon == \"\"} {\n"
"		set client_balloon $noinfo\n"
"	}\n"
"\n"
"	set x [expr [winfo rootx $icon_win] + ([winfo width $icon_win]/2)]\n"
"	set y [expr [winfo rooty $icon_win] + [winfo height $icon_win] + 4]\n"
"\n"
"	set infotext $client_balloon\n"
"	if {!$connected_to_x11vnc} {\n"
"		set infotext \"Not currently attached to x11vnc\\nLast available info:\\n$infotext\"\n"
"	}\n"
"\n"
"	set w .client_balloon\n"
"	catch {destroy $w}\n"
"	toplevel $w -bg black -screen [winfo screen $icon_win]\n"
"	wm overrideredirect $w 1\n"
"	label $w.l -text \"$infotext\" -relief flat -bg \"#ffffaa\" -fg black \\\n"
"		-padx 2 -pady 0 -anchor w -justify left -font $ffont\n"
"	pack $w.l -side left -padx 1 -pady 1\n"
"\n"
"	set w2 [winfo reqwidth  $w.l]\n"
"	set h2 [winfo reqheight $w.l]\n"
"\n"
"	set W [winfo screenwidth  $w]\n"
"	set H [winfo screenheight $w]\n"
"\n"
"	if {[expr $x+$w2] > $W} {\n"
"		set w3 [winfo width $icon_win]\n"
"		set x [expr \"$W - $w2 - $w3 - 4\"] \n"
"	}\n"
"	if {[expr $y+$h2] > $H} {\n"
"		set h3 [winfo height $icon_win]\n"
"		set y [expr \"$H - $h2 - $h3 - 4\"] \n"
"	}\n"
"\n"
"	wm geometry $w +${x}+${y}\n"
"}\n"
"\n"
"proc kill_client_balloon {} {\n"
"	global client_balloon_id client_balloon_win\n"
"	if [info exists client_balloon_id] {\n"
"		catch {after cancel $client_balloon_id}\n"
"	}\n"
"	if [winfo exists .client_balloon] {\n"
"		destroy .client_balloon\n"
"	}\n"
"}\n"
"\n"
"proc icon_win_cfg {clients} {\n"
"	global icon_win client_tail client_sock client_info_read\n"
"\n"
"	if {![info exists icon_win]} {\n"
"		return\n"
"	}\n"
"	if {$icon_win == \"\"} {\n"
"		return\n"
"	}\n"
"	if {$clients > 0} {\n"
"		$icon_win configure -bg black -fg white\n"
"	} else {\n"
"		$icon_win configure -bg white -fg black\n"
"	}\n"
"\n"
"	if {$client_tail == \"\" || !$client_info_read} {\n"
"		if {$client_sock == \"\"} {\n"
"			$icon_win configure -fg red\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc server_accept {sock addr port} {\n"
"	global socket_cookie server socket_got_callback\n"
"	global client_tail client_sock\n"
"	set db 0\n"
"\n"
"	if {$db} {puts stderr \"sock=$sock addr=$addr port=$port\"}\n"
"\n"
"	update; update idletasks\n"
"	after 50\n"
"	update; update idletasks\n"
"	set count [gets $sock str]\n"
"\n"
"	if {$count >= 0} {\n"
"		set str [string trim $str]\n"
"		if {$db} {puts stderr \"server_accept: \\\"$str\\\"\"}\n"
"		if {$str == \"COOKIE:$socket_cookie\"} {\n"
"			set client_sock $sock\n"
"			if {$db} {puts stderr \"cookie matched. $client_sock\"}\n"
"		} else {\n"
"			if {$db} {puts stderr \"cookie NO matched.\"}\n"
"		}\n"
"	}\n"
"	catch {close $server}\n"
"	set socket_got_callback 1\n"
"	if {$db} {puts stderr \"socket_got_callback $socket_got_callback\"}\n"
"}\n"
"\n"
"proc try_client_info_sock {} {\n"
"	global socket_cookie server socket_got_callback\n"
"	global x11vnc_started x11vnc_xdisplay hostname client_sock\n"
"	global x11vnc_xdisplay0 menu_var\n"
"\n"
"	set db 0\n"
"#dtime t1\n"
"	set start 13037\n"
"	set tries 100\n"
"	set socket_got_callback 0\n"
"\n"
"	set xd $x11vnc_xdisplay\n"
"	if {$xd == \"\" && $x11vnc_xdisplay0 != \"\"} {\n"
"		set xd $x11vnc_xdisplay0\n"
"	}\n"
"	if {$xd == \"\" && [info exists menu_var(display)]} {\n"
"		set xd $menu_var(display)\n"
"	}\n"
"\n"
"	set myaddr \"\"\n"
"	regsub {\\..*$} $hostname \"\" shost\n"
"	if {$x11vnc_started} {\n"
"		set myaddr \"127.0.0.1\"\n"
"	} elseif {$xd != \"\"} {\n"
"		if {[regexp {^:} $xd]} {\n"
"			set myaddr \"127.0.0.1\"\n"
"		} elseif {[regexp -nocase \"^$shost\" $xd]} {\n"
"			set myaddr \"127.0.0.1\"\n"
"		} elseif {[regexp -nocase \"^localhost\" $xd]} {\n"
"			set myaddr \"127.0.0.1\"\n"
"		} else {\n"
"			set myaddr $hostname\n"
"		}\n"
"	} else {\n"
"		set myaddr $hostname\n"
"	}\n"
"	\n"
"	for {set i 0} {$i <= $tries} {incr i} {\n"
"		set port [expr $start + $i]\n"
"		set server [socket -server server_accept -myaddr $myaddr $port]\n"
"		if {$server == \"\"} {\n"
"			continue\n"
"		}\n"
"		if {[eof $server]} {\n"
"			continue\n"
"		}\n"
"		set err \"\"\n"
"		catch {set err [fconfigure $server -error]}\n"
"		#puts \"err: $server: $err\"\n"
"		if {$err == \"\"} {\n"
"			break\n"
"		}\n"
"	}\n"
"	if {$server == \"\"} {\n"
"		append_text \"try_client_info_sock: server socket failed.\\n\"\n"
"		return\n"
"	}\n"
"	if {! $x11vnc_started} {\n"
"		run_remote_cmd [list \"-nosync\" \"-R\" \"noop\"]\n"
"		if {$db} {dtime A}\n"
"		after 250\n"
"		if {$db} {dtime A}\n"
"	}\n"
"\n"
"	# set the cookie to some obscured randomness\n"
"	set socket_cookie [clock clicks]\n"
"	set r [expr rand()]\n"
"	if {$r != \"\"} {\n"
"		append socket_cookie $r\n"
"	}\n"
"	set r \"\"\n"
"	catch {set r [winfo id .]}\n"
"	if {$r != \"\"} {\n"
"		append socket_cookie $r\n"
"	}\n"
"	if {[regexp {([0-9])([0-9])$} [clock clicks] m m1 m2]} {\n"
"		regsub -all {\\.} $socket_cookie $m1 socket_cookie\n"
"		regsub -all {x}  $socket_cookie $m2 socket_cookie\n"
"	}\n"
"	run_remote_cmd [list \"-nosync\" \"-R\" \\\n"
"		\"client_info_sock:$myaddr:$port:$socket_cookie\"]\n"
"#dtime t2\n"
"	if {$db} {puts \"client_info_sock:$myaddr:$port:$socket_cookie\"}\n"
"	for {set i 0} {$i < 10} {incr i} {\n"
"		after 50\n"
"		update; update idletasks\n"
"#dtime aa\n"
"		if {$socket_got_callback != 0} {\n"
"#puts \"break-\"\n"
"			break\n"
"		}\n"
"	}\n"
"#dtime t3\n"
"\n"
"	set aftid \"\"\n"
"	if {$socket_got_callback == 0} {\n"
"		set aftid [after 10000 {set socket_got_callback 2}]\n"
"		tkwait variable socket_got_callback\n"
"	}\n"
"\n"
"	if {$aftid != \"\"} {\n"
"		catch {after cancel $aftid}\n"
"	}\n"
"\n"
"	if {$socket_got_callback != 1} {\n"
"		puts stderr \"try_client_info_sock failed: no callback\\n\"\n"
"		catch {close $server}\n"
"	} else {\n"
"		setup_client_sock 1\n"
"	}\n"
"#dtime t4\n"
"}\n"
"\n"
"proc set_icon_label {} {\n"
"	global icon_win\n"
"\n"
"	set lab [get_icon_label]\n"
"	\n"
"	if {[info exists icon_win]} {\n"
"		$icon_win configure -text $lab\n"
"	}\n"
"}\n"
"\n"
"proc get_icon_label {{set 0}} {\n"
"	global icon_minimal \n"
"\n"
"	set lab0 \"x11\\nvnc\"\n"
"	\n"
"	if {$icon_minimal} {\n"
"		set lab [get_vnc_display_number]\n"
"		if {$lab != \"none\"} {\n"
"			set lab \"  :$lab\"\n"
"		}\n"
"	} else {\n"
"		set lab $lab0\n"
"	}\n"
"	return $lab\n"
"}\n"
"\n"
"# currently unused\n"
"proc lmenu {menu} {\n"
"	global popup_cascade_posted\n"
"	global left_iconwin_menu\n"
"	set left_iconwin_menu 1\n"
"	after 100\n"
"	update\n"
"	if {!$popup_cascade_posted && $left_iconwin_menu} {\n"
"		for {set i 0} {$i < 3} {incr i} {\n"
"			after 100\n"
"			update\n"
"		}\n"
"		if {!$popup_cascade_posted && $left_iconwin_menu} {\n"
"			$menu unpost\n"
"			return\n"
"		}\n"
"	}\n"
"	# kludge for WindowView\n"
"	if {$popup_cascade_posted} {\n"
"		focus $menu\n"
"	}\n"
"}\n"
"\n"
"proc old_balloon {} {\n"
"	global client_str saved_client_str\n"
"	set str \"\"\n"
"	if {[info exists client_str]} {\n"
"		if {$client_str != \"\"} {\n"
"			set str $client_str\n"
"		}\n"
"	}\n"
"	if {$str == \"\"} {\n"
"		if {[info exists saved_client_str]} {\n"
"			set str $saved_client_str\n"
"		}\n"
"	}\n"
"	if {$str != \"\"} {\n"
"		set_client_balloon $str\n"
"	}\n"
"}\n"
"\n"
"proc get_custom_menu_items {} {\n"
"	global env custom_last_read\n"
"\n"
"	if {![info exists custom_last_read]} {\n"
"		set custom_last_read 0\n"
"	}\n"
"	if {[info exists env(X11VNC_CUSTOM_GUI)]} {\n"
"		set custom \"$env(X11VNC_CUSTOM_GUI)\"\n"
"	} elseif {![info exists env(HOME)]} {\n"
"		return [list \"none\"]\n"
"	} else {\n"
"		set custom \"$env(HOME)/.x11vnc.gui\"\n"
"	}\n"
"	if {![file exists $custom]} {\n"
"		return [list \"none\"]\n"
"	}\n"
"\n"
"#	if {[file mtime $custom] <= $custom_last_read} {\n"
"#		return [list \"nochange\"]\n"
"#	}\n"
"\n"
"	set in \"\"\n"
"	catch {set in [open $custom \"r\"]} \n"
"	if {$in == \"\"} {\n"
"		return [list \"none\"]\n"
"	}\n"
"\n"
"	set custom_last_read [clock seconds]\n"
"\n"
"	set count 0\n"
"	while {[gets $in line] > -1} {\n"
"		if {[regexp {^[ \\t]*#} $line]} {\n"
"			continue\n"
"		}\n"
"		set line [string trim $line]\n"
"		if {$line != \"\"} {\n"
"			lappend items $line\n"
"			incr count\n"
"		}\n"
"	}\n"
"	close $in\n"
"	\n"
"	if {$count > 0} {\n"
"		return $items\n"
"	} else {\n"
"		return [list \"none\"]\n"
"	}\n"
"}\n"
"\n"
"proc make_custom_menu {menu font} {\n"
"	set items [get_custom_menu_items]\n"
"	set i0 [lindex $items 0]\n"
"	catch {$menu delete 0 end}\n"
"	if {$i0 != \"none\"} {\n"
"		$menu add command -font $font -label \"Custom items:\"\n"
"		$menu add separator\n"
"		foreach item $items {\n"
"			if {$item == \"sep\" || $item == \"separator\"} {\n"
"				$menu add separator\n"
"				continue\n"
"			}\n"
"			if {[regexp {^action:(.*)$} $item m action]} {\n"
"				$menu add command -font $font -label \"$action\" \\\n"
"				    -command \"do_var $action\"\n"
"				continue\n"
"			}\n"
"			$menu add command -font $font -label \"$item\" \\\n"
"		 	    -command \"run_remote_cmd \\[list \\\"-R\\\" \\\"$item\\\"\\]\"\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc make_icon {} {\n"
"	global icon_mode icon_embed_id icon_win props_win full_win\n"
"	global tray_embed tray_running env\n"
"	global x11vnc_client_file client_tail client_sock client_str saved_clients_str\n"
"	global client_balloon_id\n"
"	global bfont sfont snfont ffont\n"
"	global icon_minimal gui_start_mode\n"
"	global popup_cascade_posted menu_var x11vnc_gui_geom\n"
"	set min_x 24\n"
"	set min_y 24\n"
"	\n"
"	set font $bfont\n"
"	set mfont $font\n"
"\n"
"	if {$tray_embed} {\n"
"		set font $sfont\n"
"		set mfont $snfont\n"
"	}\n"
"	if {[info exists env(X11VNC_ICON_FONT)]} {\n"
"		set font $env(X11VNC_ICON_FONT)\n"
"	}\n"
"	if {[regexp {([0-9][0-9]*)x([0-9][0-9]*)} $x11vnc_gui_geom m mx my]} {\n"
"		if {$mx < $min_x} {\n"
"			set min_x $mx\n"
"		}\n"
"		if {$my < $min_y} {\n"
"			set min_y $my\n"
"		}\n"
"	}\n"
"	wm minsize . $min_x $min_y\n"
"\n"
"	if {$tray_embed && $tray_running} {\n"
"		wm withdraw .\n"
"	}\n"
"\n"
"	set l .icon\n"
"	set icon_win $l\n"
"	catch destroy {$icon_win}\n"
"	if {$icon_minimal} {\n"
"		set bw 1\n"
"	} else {\n"
"		set bw 5\n"
"	}\n"
"	set lab [get_icon_label]\n"
"	label $l -text $lab -borderwidth $bw -font $font\n"
"	icon_win_cfg 0\n"
"\n"
"\n"
"	set popup_cascade_posted 0\n"
"	pack $l -fill both -expand 1\n"
"	set menu \"$l.menu\"\n"
"	menu $menu -tearoff 0 -postcommand \"popup_post $menu\"\n"
"	$menu add command -font $mfont -label \"Properties\" -command do_props\n"
"	$menu add command -font $mfont -label \"Help\" -command \"menu_help Tray\"\n"
"	$menu add separator\n"
"	$menu add command -font $mfont -label \"New Client\" -command do_new_client\n"
"\n"
"	set wd \"$menu.disconnect\"\n"
"	catch {destroy $wd}\n"
"	menu $wd -tearoff 0 -font $ffont \\\n"
"		-postcommand {set popup_cascade_posted 1}\n"
"	$wd add command -label \"Disconnect client:\"\n"
"	$wd add separator\n"
"	$wd add command -label \"All Clients\" -command do_disconnect_all\n"
"	$menu add cascade -font $mfont -label \"Disconnect:\" -menu $wd\n"
"\n"
"	$menu add separator\n"
"\n"
"	set wv \"$menu.windowview\"\n"
"	catch {destroy $wv}\n"
"	menu $wv -tearoff 0 -font $ffont \\\n"
"		-postcommand {set popup_cascade_posted 1}\n"
"	foreach val {full icon tray} {\n"
"		$wv add radiobutton -label \"$val\" \\\n"
"			-value \"$val\" -font $ffont \\\n"
"			-command \"do_var WindowView\" \\\n"
"			-variable menu_var(WindowView)\n"
"	}\n"
"	$menu add cascade -font $mfont -label \"Window View:\" -menu $wv\n"
"\n"
"	$menu add command -font $mfont -label \"Stop x11vnc\" -command clean_icon_exit\n"
"\n"
"	set items [get_custom_menu_items]\n"
"	set i0 [lindex $items 0]\n"
"	if {$i0 != \"none\" && $i0 != \"nochange\"} {\n"
"		$menu add separator\n"
"		set cm \"$menu.custom\"\n"
"		catch {destroy $cm}\n"
"		menu $cm -tearoff 0 -font $ffont \\\n"
"			-postcommand \"set popup_cascade_posted 1; make_custom_menu $cm $ffont\"\n"
"		$menu add cascade -font $mfont -label \"Custom:\" -menu $cm\n"
"	}\n"
"\n"
"	bind $icon_win <ButtonRelease-1> \"pmenu $menu %X %Y\"\n"
"	bind $icon_win <ButtonRelease-3> \"pmenu $menu %X %Y\"\n"
"	bind $icon_win <Enter> {set client_balloon_id [after 500 show_client_balloon]}\n"
"	bind $icon_win <Button> {kill_client_balloon}\n"
"	bind $icon_win <Leave>  {kill_client_balloon}\n"
"	bind $icon_win <ButtonPress-2> {kill_client_balloon; show_client_balloon}\n"
"#	bind $menu <Leave> \"lmenu $menu\"\n"
"#	bind $menu <Enter> \"set left_iconwin_menu 0\"\n"
"##	bind $menu <KeyPress-Escape> \"$menu unpost\"\n"
"\n"
"	bind . <Control-KeyPress-c> {destroy .; exit 0}\n"
"\n"
"	if {!$tray_embed || !$tray_running} {\n"
"		global x11vnc_gui_geom\n"
"		if {$x11vnc_gui_geom != \"\"} {\n"
"			set doit 1\n"
"			if {[regexp {x} $x11vnc_gui_geom]} {\n"
"				if {$gui_start_mode == \"full\"} {\n"
"					set doit 0\n"
"				}\n"
"			} \n"
"			if {$doit} {\n"
"				wm geometry . $x11vnc_gui_geom\n"
"			}\n"
"		}\n"
"	}\n"
"	wm iconname . \"tkx11vnc\"\n"
"	wm title . \"tkx11vnc\"\n"
"	update\n"
"	wm deiconify .\n"
"	update\n"
"\n"
"	old_balloon\n"
"}\n"
"\n"
"proc setup_client_channel {} {\n"
"	global client_sock client_tail\n"
"\n"
"# XXX/setup_client_channel\n"
"	if {$client_sock == \"\" } {\n"
"		stop_watch on\n"
"		try_client_info_sock\n"
"		if {$client_sock == \"\" } {\n"
"			after 500\n"
"			try_client_info_sock\n"
"		}\n"
"		stop_watch off\n"
"	}\n"
"	if {$client_tail == \"\" && $client_sock == \"\"} {\n"
"		set m \"\\n\"\n"
"		set m \"${m}tkx11vnc:\\n\"\n"
"		set m \"${m}\\n\"\n"
"		set m \"${m}    Warning -- running in icon/tray mode but the\\n\"\n"
"		set m \"${m}    connected client info channel from x11vnc is\\n\"\n"
"		set m \"${m}    not working.  The viewer client list and icon\\n\"\n"
"		set m \"${m}    color indicator will not be accurate.\\n\"\n"
"		set m \"${m}\\n\"\n"
"		set m \"${m}    You may need to restart \\\"x11vnc -gui tray ...\\\"\\n\"\n"
"		set m \"${m}    for this to work properly.\\n\"\n"
"		set m \"${m}\\n\"\n"
"		textwin \"Warning\" \"Warning\" $m\n"
"		update\n"
"	}\n"
"}\n"
"\n"
"proc clean_client_tail {} {\n"
"	global client_tail client_info_read\n"
"	if [info exists client_tail] {\n"
"		if {$client_tail != \"\"} {\n"
"			set p \"\"\n"
"			catch {set p [pid $client_tail]}\n"
"			if {$p != \"\"} {\n"
"				catch {exec kill -TERM $p >/dev/null 2>/dev/null}\n"
"			}\n"
"			catch {close $client_tail}\n"
"			set client_tail \"\"\n"
"		}\n"
"	}\n"
"	set client_info_read 0\n"
"}\n"
"\n"
"proc clean_icon_exit {} {\n"
"	clean_client_tail\n"
"	push_new_value \"stop\" \"stop\" 1 0\n"
"	set_connected no\n"
"	update\n"
"	destroy .\n"
"	exit\n"
"}\n"
"\n"
"proc make_gui {mode} {\n"
"	global icon_mode tray_embed full_win icon_win\n"
"	global top_widget_names x11vnc_gui_geom\n"
"	global gui_current_state make_gui_count\n"
"	global x11vnc_connect connected_to_x11vnc\n"
"	global x11_display\n"
"	global gui_start_mode\n"
"\n"
"	incr make_gui_count\n"
"\n"
"	if {$gui_start_mode == \"\"} {\n"
"		set gui_start_mode $mode\n"
"	}\n"
"\n"
"	wm withdraw .\n"
"\n"
"	set full_geom \"\"\n"
"	if {[winfo exists .full]} {\n"
"		catch {set full_geom [wm geometry .full]}\n"
"	}\n"
"\n"
"	set fw .full\n"
"	set full_win $fw\n"
"	catch {pack forget $full_win}\n"
"	catch {pack forget $icon_win}\n"
"	catch {destroy $full_win}\n"
"	catch {destroy $icon_win}\n"
"\n"
"	wm minsize . 1 1\n"
"\n"
"	set gui_current_state \"\"\n"
"\n"
"	if {$mode == \"full\"} {\n"
"		frame $fw\n"
"		set icon_mode 0\n"
"\n"
"		wm protocol .     WM_DELETE_WINDOW \"destroy .; exit\"\n"
"		make_widgets $fw\n"
"\n"
"		set w \".\"\n"
"		wm geometry $w \"\"\n"
"		if {$x11vnc_gui_geom != \"\"} {\n"
"			set doit 1\n"
"			if {[regexp {x} $x11vnc_gui_geom]} {\n"
"				if {$gui_start_mode != $mode} {\n"
"					set doit 0\n"
"				}\n"
"			}\n"
"			if {$doit} {\n"
"				wm geometry $w $x11vnc_gui_geom\n"
"			}\n"
"		}\n"
"		pack $fw -fill both -expand 1\n"
"\n"
"	} elseif {$mode == \"icon\" || $mode == \"tray\"} {\n"
"\n"
"		toplevel $fw\n"
"		wm withdraw $fw\n"
"\n"
"		wm protocol $fw WM_DELETE_WINDOW \"wm withdraw .full\"\n"
"		wm protocol .   WM_DELETE_WINDOW \"clean_icon_exit\"\n"
"		\n"
"		if {$mode == \"icon\"} {\n"
"			set tray_embed 0\n"
"		} elseif {$mode == \"tray\"} {\n"
"			set tray_embed 1\n"
"		}\n"
"		set icon_mode 1\n"
"		make_widgets $fw\n"
"		set w $fw\n"
"		make_icon\n"
"		wm geometry $fw \"\"\n"
"		wm geometry .   \"\"\n"
"	} else {\n"
"		return\n"
"	}\n"
"	set_view_variable $mode\n"
"	set gui_current_state $mode\n"
"\n"
"\n"
"	update\n"
"	wm deiconify .\n"
"	update idletasks\n"
"	wm minsize $w [winfo width $w] [winfo height $w]\n"
"	if {$mode == \"full\" && $make_gui_count > 1} {\n"
"		center_win .\n"
"	}\n"
"\n"
"\n"
"	if {$make_gui_count == 1} {\n"
"		copy_default_vars\n"
"		if {$x11vnc_connect} {\n"
"			try_connect_and_query_all\n"
"		} else {\n"
"			insert_cmdline_vars\n"
"		}\n"
"	} else {\n"
"		set_name \"RESTORE\"\n"
"	}\n"
"\n"
"	setup_client_tail\n"
"\n"
"	set_widgets\n"
"\n"
"	if {$mode == \"tray\"} {\n"
"		setup_tray_embed\n"
"	}\n"
"}\n"
"\n"
"proc make_widgets {top} {\n"
"	global template make_gui_count\n"
"	global menu_b menu_m menu_count\n"
"	global item_opts item_bool item_case item_menu item_entry menu_var unset_str\n"
"	global item_cascade\n"
"	global info_label info_str x11_display vnc_display\n"
"	global text_area text_area_str\n"
"	global entry_box entry_str entry_set entry_label entry_ok entry_browse\n"
"	global entry_help entry_skip\n"
"	global bfont ffont beginner_mode\n"
"	global helptext helpremote helplabel\n"
"	global icon_mode icon_win props_win full_win\n"
"	global top_widget_names\n"
"	global screen_height screen_width\n"
"\n"
"\n"
"	# Make the top label\n"
"	set label_width 84\n"
"	if {$screen_width <= 400} {\n"
"		set label_width 64\n"
"	}\n"
"	set info_label \"$top.info\"\n"
"	label $info_label -textvariable info_str -bd 2 -relief groove \\\n"
"		-anchor w -width $label_width -font $ffont\n"
"	pack $info_label -side top -fill x -expand 0\n"
"\n"
"	set top_widget_names(info) $info_label\n"
"\n"
"	# Extract the Rows:\n"
"	set row 0;\n"
"	set colmax 0;\n"
"	foreach line [split $template \"\\n\"] {\n"
"		if {[regexp {^Row: (.*)} $line rest]} {\n"
"			set col 0\n"
"			foreach case [split $rest] {\n"
"				if {$case == \"\" || $case == \"Row:\"} {\n"
"					continue\n"
"				}\n"
"				set menu_row($case) $row\n"
"				set menu_col($case) $col\n"
"\n"
"				lappend cases($col) $case;\n"
"				set len [string length $case]\n"
"				if {[info exists max_len($col)]} {\n"
"					if {$len > $max_len($col)} {\n"
"						set max_len($col) $len\n"
"					}\n"
"				} else {\n"
"					set max_len($col) $len\n"
"				}\n"
"				incr col\n"
"				if {$col > $colmax} {\n"
"					set colmax $col\n"
"				}\n"
"			}\n"
"			incr row;\n"
"		}\n"
"	}\n"
"\n"
"	# Make frames for the rows and make the menu buttons.\n"
"	set f \"$top.menuframe\"\n"
"	frame $f\n"
"	for {set c 0} {$c < $colmax} {incr c} {\n"
"		set colf \"$f.menuframe$c\"\n"
"		frame $colf\n"
"		pack $colf -side left -fill y\n"
"		set fbg [$colf cget -background]\n"
"		foreach case $cases($c) {\n"
"			set menub \"$colf.menu$case\";\n"
"			set menu \"$colf.menu$case.menu\";\n"
"			set menu_b($case) $menub\n"
"			set menu_m($case) $menu\n"
"			set ul 0\n"
"			foreach char [split $case \"\"] {\n"
"				set char [string tolower $char]\n"
"				if {![info exists underlined($char)]} {\n"
"					set underlined($char) 1\n"
"					break\n"
"				}\n"
"				incr ul\n"
"			}\n"
"			global osname\n"
"			set tstr \"$case\"\n"
"			if {$osname == \"Darwin\"} {\n"
"				#set tstr \" $case   \"\n"
"			}\n"
"			menubutton $menub -text \"$tstr\" -underline $ul \\\n"
"				-anchor w -menu $menu -background $fbg \\\n"
"				-font $bfont\n"
"			pack $menub -side top -fill x\n"
"			menu $menu -tearoff 0 -postcommand menu_posted\n"
"		}\n"
"	}\n"
"	pack $f -side top -fill x\n"
"	set top_widget_names(menuframe) $f\n"
"\n"
"	make_menu_items\n"
"\n"
"	# Make the x11 and vnc display label bar:\n"
"	set df \"$top.displayframe\"\n"
"	frame $df -bd 1 -relief groove\n"
"	set top_widget_names(displayframe) $df\n"
"\n"
"	set df_x11 \"$df.xdisplay\"\n"
"\n"
"	if {$make_gui_count == 1} {\n"
"		no_x11_display\n"
"	}\n"
"	set lw [expr {$label_width / 2}]\n"
"	label $df_x11 -textvariable x11_display -width $lw -anchor w \\\n"
"		-font $ffont\n"
"\n"
"	set df_vnc \"$df.vdisplay\"\n"
"\n"
"	if {$make_gui_count == 1} {\n"
"		no_vnc_display\n"
"	}\n"
"	label $df_vnc -textvariable vnc_display -width $lw -anchor w \\\n"
"		-font $ffont\n"
"\n"
"	pack $df_x11 $df_vnc -side left \n"
"	pack $df -side top -fill x\n"
"\n"
"	# text area\n"
"	global text_height\n"
"	set text_area \"$top.text\"\n"
"	if {$screen_width <= 400} {\n"
"		text $text_area -height $text_height -width $label_width \\\n"
"			-relief ridge -font $ffont\n"
"	} else {\n"
"		text $text_area -height $text_height -relief ridge -font $ffont\n"
"	}\n"
"	pack $text_area -side top -fill both -expand 1\n"
"	set top_widget_names(text) $text_area\n"
"\n"
"\n"
"	if {$text_area_str == \"\"} {\n"
"		set str \"Click Help -> gui for overview.\"\n"
"		append_text \"\\n$str\\n\\n\"\n"
"	} else {\n"
"		append_text $text_area_str\n"
"	}\n"
"\n"
"	# Make entry box stuff\n"
"	set ef \"$top.entryframe\"\n"
"	frame $ef -bd 1 -relief groove\n"
"	set top_widget_names(entryframe) $ef\n"
"\n"
"	# Entry Label\n"
"	set ef_label \"$ef.label\"\n"
"	label $ef_label -textvariable entry_str -anchor w -font $bfont\n"
"\n"
"	set entry_str \"Set... : \"\n"
"	set ef_entry \"$ef.entry\"\n"
"	entry $ef_entry -relief sunken -font $ffont\n"
"	bind $ef_entry <KeyPress-Return> {set entry_set 1}\n"
"	bind $ef_entry <KeyPress-Escape> {set entry_set 0}\n"
"\n"
"	set ok_s \"OK\"\n"
"	set cancel_s \"Cancel\"\n"
"	set help_s \"Help\"\n"
"	set browse_s \"Browse...\"\n"
"	global osname\n"
"	if {$osname == \"Darwin\"} {\n"
"		set ok_s \" OK   \"\n"
"		set cancel_s \" Cancel   \"\n"
"		set help_s \" Help   \"\n"
"		set browse_s \" Browse...   \"\n"
"	}\n"
"\n"
"	# Entry OK button\n"
"	set bpx \"1m\"\n"
"	set bpy \"1\"\n"
"	set hlt \"0\"\n"
"	set ef_ok \"$ef.ok\"\n"
"	button $ef_ok -text $ok_s -pady $bpy -padx $bpx -command {set entry_set 1} \\\n"
"		-highlightthickness $hlt \\\n"
"		-font $bfont\n"
"\n"
"	# Entry Skip button\n"
"	set ef_skip \"$ef.skip\"\n"
"	button $ef_skip -text $cancel_s -pady $bpy -padx $bpx -command {set entry_set 0} \\\n"
"		-highlightthickness $hlt \\\n"
"		-font $bfont\n"
"\n"
"	# Entry Help button\n"
"	set ef_help \"$ef.help\"\n"
"	button $ef_help -text $help_s -pady $bpy -padx $bpx -command \\\n"
"		{menu_help $entry_dialog_item} -font $bfont \\\n"
"		-highlightthickness $hlt\n"
"\n"
"	# Entry Browse button\n"
"	set ef_browse \"$ef.browse\"\n"
"	button $ef_browse -text $browse_s -pady $bpy -padx $bpx -font $bfont \\\n"
"		-highlightthickness $hlt \\\n"
"		-command {entry_insert [tk_getOpenFile]} \n"
"\n"
"	pack $ef_label -side left\n"
"	pack $ef_entry -side left -fill x -expand 1\n"
"	pack $ef_ok   -side right\n"
"	pack $ef_skip -side right\n"
"	pack $ef_help -side right\n"
"	pack $ef -side bottom -fill x\n"
"\n"
"	set entry_ok $ef_ok\n"
"	set entry_skip $ef_skip\n"
"	set entry_help $ef_help\n"
"	set entry_box $ef_entry\n"
"	set entry_browse $ef_browse\n"
"	set entry_label $ef_label\n"
"	entry_disable\n"
"\n"
"}\n"
"\n"
"proc menu_bindings {m} {\n"
"	set db 0\n"
"	if {$db} {puts \"menu_bindings $m\"}\n"
"\n"
"	bind $m <<MenuSelect>> {\n"
"#syntax hilite bug \\\n"
"MenuSelect>>\n"
"		set n [%W index active]\n"
"		set db 0\n"
"		if {$db} {puts stderr \"menu_bindings %W $n\"}\n"
"		set label \"    \"\n"
"		if {$n != \"none\"} {\n"
"			set str %W,$n\n"
"			set which \"\"\n"
"\n"
"			if {$db} {puts \"menu_bindings $str\"}\n"
"			if {[info exists helplabel($str)]} {\n"
"				set vname [format %%-16s $helplabel($str)]\n"
"				set label \"Click (?) for help on: $vname\"\n"
"				set which $helplabel($str)\n"
"			}\n"
"			if {$which == \"\"} {\n"
"				;\n"
"			} elseif {$which == \"passwd\" || $which == \"viewpasswd\"} {\n"
"				;\n"
"			} elseif {[is_action $which]} {\n"
"				if {[info exists menu_var($which)] \n"
"				    && $menu_var($which) != \"\"} {\n"
"					set label \"$label value: $menu_var($which)\"\n"
"				} else {\n"
"					set label \"$label (is action)\"\n"
"				}\n"
"			} elseif {[info exists menu_var($which)]} {\n"
"				set label \"$label value: $menu_var($which)\"\n"
"				if {$which == \"http\"} {\n"
"					global vnc_url\n"
"					set label \"$label  URL: $vnc_url\"\n"
"				}\n"
"			}\n"
"		}\n"
"		set_info $label\n"
"	}\n"
"}\n"
"\n"
"proc key_bindings {} {\n"
"	global env menus_disabled\n"
"	if {[info exists env(USER)] && $env(USER) == \"runge\"} {\n"
"		# quick restart\n"
"		bind . <Control-KeyPress-k> {exec $argv0 $argv &; destroy .}\n"
"	}\n"
"	bind . <Control-KeyPress-p> { \\\n"
"		global menus_disabled; \\\n"
"		if {!$menus_disabled} {try_connect_and_query_all} \\\n"
"	}\n"
"	bind . <Control-KeyPress-u> { \\\n"
"		global menus_disabled; \\\n"
"		if {!$menus_disabled} {query_all 0} \\\n"
"	}\n"
"	bind . <Control-KeyPress-r> { \\\n"
"		global menus_disabled; \\\n"
"		if {!$menus_disabled} {query_all 0} \\\n"
"	}\n"
"	bind . <Control-KeyPress-d> { \\\n"
"		global menus_disabled; \\\n"
"		if {!$menus_disabled} {detach_from_display} \\\n"
"	}\n"
"	bind . <Control-KeyPress-a> { \\\n"
"		global menus_disabled; \\\n"
"		if {!$menus_disabled} {try_connect_and_query_all} \\\n"
"	}\n"
"}\n"
"\n"
"proc stop_watch {onoff} {\n"
"	global orig_cursor text_area entry_box\n"
"\n"
"	set widgets [list .]\n"
"	if [info exists text_area] {\n"
"		if {$text_area != \"\"} {\n"
"			lappend widgets $text_area\n"
"		}\n"
"	}\n"
"	if [info exists entry_box] {\n"
"		if {$entry_box != \"\"} {\n"
"			lappend widgets $entry_box\n"
"		}\n"
"	}\n"
"\n"
"	if {$onoff == \"on\"} {\n"
"		foreach item $widgets {\n"
"			if {![winfo exists $item]} {\n"
"				continue\n"
"			}\n"
"			$item config -cursor {watch}\n"
"		}\n"
"	} else {\n"
"		foreach item $widgets {\n"
"			if {![winfo exists $item]} {\n"
"				continue\n"
"			}\n"
"			$item config -cursor {}\n"
"		}\n"
"	}\n"
"	update\n"
"}\n"
"\n"
"proc double_check_noremote {} {\n"
"	set msg \"\\n\\n\"\n"
"	append msg \"*** WARNING: setting \\\"noremote\\\" will disable ALL remote control commands (i.e.\\n\"\n"
"	append msg \"*** WARNING: *this* gui will be locked out). Do you really want to do this?\\n\"\n"
"	append msg \"*** WARNING: If so, press \\\"OK\\\", otherwise press \\\"Cancel\\\"\\n\"\n"
"	append msg \"\\n\"\n"
"	bell\n"
"	return [warning_dialog $msg \"noremote\"]\n"
"}\n"
"\n"
"proc get_settings_rcfile {} {\n"
"	global menu_var default_var unset_str\n"
"	global x11vnc_gui_params\n"
"\n"
"	set rc_txt \"\"\n"
"\n"
"	set menu_var(gui) $x11vnc_gui_params\n"
"\n"
"	foreach item [lsort [array names menu_var]] {\n"
"		if {$item == \"gui\"} {\n"
"			;\n"
"		} elseif {![active_when_starting $item]} {\n"
"			continue\n"
"		} elseif {[is_action $item]} {\n"
"			continue\n"
"		}\n"
"		if {$item == \"debug_gui\"} {\n"
"			continue\n"
"		} elseif {$item == \"WindowView\"} {\n"
"			continue\n"
"		} elseif {$item == \"rc\" || $item == \"norc\"} {\n"
"			continue\n"
"		}\n"
"\n"
"		set def \"\"\n"
"		if {[info exists default_var($item)]} {\n"
"			set def $default_var($item)\n"
"		}\n"
"\n"
"		set qst \"\"\n"
"		set hmm \"#? \"\n"
"		if {$item == \"display\"} {\n"
"			set qst $hmm\n"
"		} elseif {$item == \"desktop\"} {\n"
"			set qst $hmm\n"
"		} elseif {$item == \"dontdisconnect\"} {\n"
"			set qst $hmm\n"
"		} elseif {$item == \"alwaysshared\"} {\n"
"			set qst $hmm\n"
"		} elseif {$item == \"nevershared\"} {\n"
"			set qst $hmm\n"
"		}\n"
"\n"
"		if {![info exists menu_var($item)]} {\n"
"			set mv $def\n"
"		} else {\n"
"			set mv $menu_var($item)\n"
"		}\n"
"		if {$mv == $unset_str} {\n"
"			set mv \"\"\n"
"		}\n"
"		set ntab 3\n"
"\n"
"		if {$item == \"gui\" || [value_is_string $item]} {\n"
"			set nitem [get_nitem $item]\n"
"\n"
"			if {$mv == \"\" && $def != \"\"}  {\n"
"				set qst $hmm\n"
"			}\n"
"			set n 0\n"
"			if {$qst != \"\"} {\n"
"				append rc_txt $qst\n"
"				incr n [string length $qst]\n"
"			} elseif {$mv == $def} {\n"
"				append rc_txt \"#d \"\n"
"				incr n [string length \"#d \"]\n"
"			}\n"
"			set mt $mv\n"
"			regsub -all {#} $mt {\\#} mt\n"
"			if {$mt == \"\"} {\n"
"				set mt {\"\"}\n"
"			}\n"
"			append rc_txt \"-$nitem $mt\"\n"
"\n"
"			if {$mv != $def} {\n"
"				set m [string length \"-$nitem $mt\"]\n"
"				incr n $m\n"
"				set n [expr $n / 8]\n"
"				set c 0\n"
"				for {set i $n} {$i <= $ntab} {incr i} {\n"
"					append rc_txt \"\\t\"\n"
"					incr c\n"
"				}\n"
"				if {$c == 0} {\n"
"					append rc_txt \"\\t\"\n"
"				}\n"
"				regsub -all {#} $def {\\#} def\n"
"				if {$def == \"\"} {\n"
"					set def {\"\"}\n"
"				}\n"
"				append rc_txt \"# default:  $def\"\n"
"			}\n"
"			append rc_txt \"\\n\"\n"
"\n"
"		} elseif {[value_is_bool $item]} {\n"
"			set n 0\n"
"			if {$qst != \"\"} {\n"
"				append rc_txt $qst\n"
"				incr n [string length $qst]\n"
"			} elseif {$mv == $def} {\n"
"				append rc_txt \"#d \"\n"
"				incr n [string length \"#d \"]\n"
"			}\n"
"			if {$def == 1} {\n"
"				set dv \"on\"\n"
"			} else {\n"
"				set dv \"off\"\n"
"			}\n"
"			append rc_txt \"-$item\"\n"
"			set m [string length \"-$item\"]\n"
"			incr n $m\n"
"			set n [expr $n / 8]\n"
"			for {set i $n} {$i <= $ntab} {incr i} {\n"
"				append rc_txt \"\\t\"\n"
"			}\n"
"			append rc_txt \"# default: $dv\"\n"
"			append rc_txt \"\\n\"\n"
"\n"
"		}\n"
"	}\n"
"	return $rc_txt\n"
"}\n"
"\n"
"proc double_check_start_x11vnc {} {\n"
"	global hostname\n"
"	set msg [get_start_x11vnc_txt]\n"
"	bell\n"
"	append msg \"\\n\"\n"
"	append msg \"*** To run the above command on machine \\\"$hostname\\\" (thereby\\n\"\n"
"	append msg \"*** starting x11vnc) press \\\"OK\\\", otherwise press \\\"Cancel\\\".\\n\"\n"
"	return [warning_dialog $msg \"start\"]\n"
"}\n"
"\n"
"proc get_start_x11vnc_txt {} {\n"
"	set cmd [get_start_x11vnc_cmd]\n"
"	set str [join $cmd]\n"
"	set msg \"\"\n"
"	append msg \"\\n\"\n"
"	append msg \"==== The command built so far is: ====\\n\";\n"
"	append msg \"\\n\"\n"
"	append msg \"$str\\n\"\n"
"	return $msg\n"
"}\n"
"\n"
"proc show_start_cmd {} {\n"
"	set msg [get_start_x11vnc_txt]\n"
"	append_text \"$msg\\n\"\n"
"}\n"
"\n"
"proc get_nitem {item} {\n"
"	set nitem $item\n"
"	if {$nitem == \"screen_blank\"} {\n"
"		set nitem \"sb\"\n"
"	} elseif {$nitem == \"xrandr_mode\"} {\n"
"		set nitem \"xrandr\"\n"
"	} elseif {$nitem == \"unixpw_list\"} {\n"
"		set nitem \"unixpw\"\n"
"	} elseif {$nitem == \"unixpw_nis_list\"} {\n"
"		set nitem \"unixpw_nis\"\n"
"	} elseif {$nitem == \"stunnel_pem\"} {\n"
"		set nitem \"stunnel\"\n"
"	} elseif {$nitem == \"ssl_pem\"} {\n"
"		set nitem \"ssl\"\n"
"	} elseif {$nitem == \"wireframe_mode\"} {\n"
"		set nitem \"wireframe\"\n"
"	} elseif {$nitem == \"solid_color\"} {\n"
"		set nitem \"solid\"\n"
"	}\n"
"	return $nitem\n"
"}\n"
"\n"
"proc get_start_x11vnc_cmd {{show_rc 0}} {\n"
"	global cmd_var menu_var default_var unset_str x11vnc_prog\n"
"\n"
"	set xterm_cmd \"xterm -iconic -geometry 80x35 -title x11vnc-console -e\"\n"
"\n"
"	set cmd [split $xterm_cmd]\n"
"\n"
"	lappend cmd $x11vnc_prog\n"
"\n"
"	lappend cmd \"-gui\"\n"
"	lappend cmd \"none\"\n"
"\n"
"	set rc_txt \"\"\n"
"\n"
"	set saw_id 0\n"
"\n"
"	foreach item [lsort [array names menu_var]] {\n"
"		if {$item == \"gui\"} {\n"
"			continue\n"
"		} elseif {![active_when_starting $item]} {\n"
"			continue\n"
"		} elseif {[is_action $item]} {\n"
"			continue\n"
"		} elseif {$item == \"debug_gui\"} {\n"
"			continue\n"
"		} elseif {$item == \"WindowView\"} {\n"
"			continue\n"
"		}\n"
"\n"
"		if {$item == \"id\" || $item == \"sid\"} {\n"
"			set val $menu_var($item);\n"
"			if {$val == \"0x0\" || $val == \"root\"} {\n"
"				continue\n"
"			}\n"
"		}\n"
"		if {$item == \"sid\" && $saw_id} {\n"
"			continue\n"
"		}\n"
"		if {$item == \"id\"} {\n"
"			set saw_id 1\n"
"		} elseif {$item == \"httpport\" && $menu_var($item) == \"0\"} {\n"
"			continue\n"
"		} elseif {$item == \"progressive\" && $menu_var($item) == \"0\"} {\n"
"			continue\n"
"		} elseif {$item == \"dontdisconnect\" && $menu_var($item) == \"-1\"} {\n"
"			continue\n"
"		} elseif {$item == \"alwaysshared\" && $menu_var($item) == \"-1\"} {\n"
"			continue\n"
"		}\n"
"\n"
"		if {[value_is_bool $item]} {\n"
"			if {[info exists menu_var($item)]} {\n"
"				set add 1\n"
"				if {[info exists default_var($item)]} {\n"
"					if {$menu_var($item) == $default_var($item)} {\n"
"						set add 0;\n"
"					}\n"
"				} elseif {! $menu_var($item)} {\n"
"					set add 0\n"
"				}\n"
"				if {$add} {\n"
"					lappend cmd \"-$item\"\n"
"					append rc_txt \"-$item\\n\"\n"
"				}\n"
"			}\n"
"		} elseif {[value_is_string $item]} {\n"
"			if {![info exists menu_var($item)]} {\n"
"				continue\n"
"			}\n"
"			if {$menu_var($item) != \"\" && $menu_var($item) != $unset_str} {\n"
"				set add 1\n"
"				set nitem [get_nitem $item]\n"
"\n"
"				if {[info exists default_var($item)]} {\n"
"					if {$menu_var($item) == $default_var($item)} {\n"
"						set add 0;\n"
"					}\n"
"				}\n"
"				if {$add} {\n"
"					lappend cmd \"-$nitem\"\n"
"					set mv $menu_var($item)\n"
"\n"
"					if {[regexp {^~} $mv]}  {\n"
"						if {$item == \"auth\" ||\n"
"						    $item == \"rc\" ||\n"
"						    $item == \"accept\" || \n"
"						    $item == \"connect\" || \n"
"						    $item == \"allow\" || \n"
"						    $item == \"passwdfile\" || \n"
"						    $item == \"o\" || \n"
"						    $item == \"logfile\" || \n"
"						    $item == \"remap\" || \n"
"						    $item == \"httpdir\"} { \n"
"							set mv [tilde_expand $mv]\n"
"						}\n"
"					}\n"
"					\n"
"					lappend cmd $mv\n"
"					set mt $mv\n"
"					regsub -all {#} $mt {\\#} mt\n"
"					append rc_txt \"-$nitem $mt\\n\"\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	lappend cmd \"2>\"\n"
"	lappend cmd \"/dev/null\"\n"
"	lappend cmd \"&\"\n"
"	\n"
"	if {$show_rc} {\n"
"		return $rc_txt\n"
"	} else {\n"
"		return $cmd\n"
"	}\n"
"}\n"
"\n"
"proc start_x11vnc {} {\n"
"	global menu_var unset_str\n"
"	global x11vnc_prog x11vnc_xdisplay\n"
"	global connected_to_x11vnc\n"
"\n"
"	if {$connected_to_x11vnc} {\n"
"		append_text \"\\n\"\n"
"		append_text \"WARNING: Still connected to an x11vnc server.\\n\"\n"
"		append_text \"WARNING: Use \\\"stop\\\" or \\\"detach\\\" first.\\n\"\n"
"		return 0\n"
"	}\n"
"\n"
"	if {![double_check_start_x11vnc]} {\n"
"		return\n"
"	}\n"
"\n"
"	set x11vnc_xdisplay \"\"\n"
"	if {[info exists menu_var(display)]} {\n"
"		if {$menu_var(display) != \"\" && $menu_var(display) != $unset_str} {\n"
"			set x11vnc_xdisplay $menu_var(display)\n"
"		}\n"
"	}\n"
"\n"
"	set cmd [get_start_x11vnc_cmd]\n"
"\n"
"	set str [join $cmd]\n"
"	regsub { -e} $str \" -e \\\\\\n   \" str\n"
"\n"
"	if {0} {\n"
"		puts \"running: $str\"\n"
"		foreach word $cmd {\n"
"			puts \"   word: $word\"\n"
"		}\n"
"	}\n"
"\n"
"	append_text \"Starting x11vnc in an iconified xterm with command:\\n\"\n"
"	append_text \"  $str\\n\\n\"\n"
"	catch {[eval exec $cmd]}\n"
"	after 500\n"
"	try_connect_and_query_all 3\n"
"	if {!$connected_to_x11vnc} {\n"
"		append_text \"\\nStarting x11vnc seems to have failed.\\n\"\n"
"		if {[regexp -- {-o } $str] || [regexp -- {-logfile} $str]} {\n"
"			append_text \"Examine the logfile (Debugging -> show-logfile) for error messages.\\n\"\n"
"		} else {\n"
"			append_text \"Rerun with a logfile (if needed) and examine the logfile\\n\"\n"
"			append_text \"(Debugging -> show-logfile) for error messages.\\n\"\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc run_remote_cmd_via_sock {opts} {\n"
"	global client_sock\n"
"\n"
"	set db 0\n"
"	if {[file channels $client_sock] == \"\"} {\n"
"		set client_sock \"\"\n"
"		return \"fail\"\n"
"	}\n"
"	if {[eof $client_sock]} {\n"
"		catch {close $client_sock}\n"
"		set client_sock \"\"\n"
"		return \"fail\"\n"
"	}\n"
"	set result \"\"\n"
"		\n"
"	setup_client_sock 0\n"
"\n"
"	set docmd \"\"\n"
"	foreach opt $opts {\n"
"		if {$opt == \"-R\"} {\n"
"			set docmd \"-R\"\n"
"			continue\n"
"		} elseif {$opt == \"-Q\"} {\n"
"			set docmd \"-Q\"\n"
"			continue\n"
"		}\n"
"\n"
"		if {$docmd == \"\"} {\n"
"			continue\n"
"		} elseif {$docmd == \"-R\"} {\n"
"			set str \"cmd=$opt\"\n"
"		} elseif {$docmd == \"-Q\"} {\n"
"			set str \"qry=$opt\"\n"
"		} else {\n"
"			set docmd \"\"\n"
"			continue\n"
"		}\n"
"\n"
"		if {$db} {puts stderr \"run_remote_cmd_via_sock: $docmd \\\"$str\\\"\"}\n"
"		puts $client_sock $str\n"
"		if {$db} {puts stderr \"run_remote_cmd_via_sock: flush\"}\n"
"		flush $client_sock\n"
"		if {$db} {puts stderr \"run_remote_cmd_via_sock: gets\"}\n"
"		gets $client_sock res\n"
"		if {$db} {puts stderr \"run_remote_cmd_via_sock: \\\"$res\\\"\"}\n"
"		set res [string trim $res]\n"
"\n"
"		if [regexp {^clients:} $res] {\n"
"			regsub {^clients:} $res \"\" tmp\n"
"			if {$tmp == \"none\"} {\n"
"				set tmp \"\"\n"
"			}\n"
"			update_clients_menu $tmp\n"
"			set client_str $tmp\n"
"			set_client_balloon $tmp\n"
"\n"
"			if ![regexp {^clients} $opt] {\n"
"				# we could block here...\n"
"				if {$db} {puts stderr \"run_remote_cmd_via_sock: gets\"}\n"
"				gets $client_sock res\n"
"				if {$db} {puts stderr \"run_remote_cmd_via_sock: \\\"$res\\\"\"}\n"
"				set res [string trim $res]\n"
"			}\n"
"		}\n"
"\n"
"		set docmd \"\"\n"
"\n"
"		if {$res != \"\"} {\n"
"			append result \"$res\\n\"\n"
"		}\n"
"	}\n"
"	\n"
"	setup_client_sock 1\n"
"\n"
"	set result [string trim $result]\n"
"\n"
"	return $result\n"
"}\n"
"\n"
"proc run_remote_cmd {opts} {\n"
"	global menu_var x11vnc_prog x11vnc_cmdline x11vnc_xdisplay\n"
"	global x11vnc_auth_file x11vnc_connect_file\n"
"	global client_sock\n"
"\n"
"	set debug [in_debug_mode]\n"
"\n"
"	if {[lindex $opts 0] == \"-R\" && [lindex $opts 1] == \"noremote\"} {\n"
"		set str [join $opts]\n"
"		if ![double_check_noremote] {\n"
"			append_text \"skipping: x11vnc $str\"\n"
"			return \"\"\n"
"		} else {\n"
"			append_text \"running: x11vnc $str (please do \\\"Actions -> detach\\\" to clean things up)\\n\"\n"
"			append_text \"subsequent -R/-Q commands should fail...\"\n"
"		}\n"
"	}\n"
"\n"
"	if {$client_sock != \"\"} {\n"
"		menus_disable\n"
"		stop_watch on\n"
"		set result [run_remote_cmd_via_sock $opts]\n"
"		stop_watch off\n"
"		menus_enable\n"
"		if {$result != \"fail\"} {\n"
"			return $result\n"
"		}\n"
"	}\n"
"\n"
"	set cmd \"\"\n"
"\n"
"	lappend cmd $x11vnc_prog;\n"
"\n"
"	if {$x11vnc_connect_file != \"\"} {\n"
"		lappend cmd \"-connect\"\n"
"		lappend cmd $x11vnc_connect_file\n"
"	} else {\n"
"		if {$x11vnc_xdisplay != \"\"} {\n"
"			lappend cmd \"-display\"\n"
"			lappend cmd $x11vnc_xdisplay\n"
"		}\n"
"		if {$x11vnc_auth_file != \"\"} {\n"
"			lappend cmd \"-auth\"\n"
"			lappend cmd $x11vnc_auth_file\n"
"		}\n"
"	}\n"
"	lappend cmd \"-sync\"\n"
"	foreach word $opts {\n"
"		lappend cmd $word\n"
"	}\n"
"	lappend cmd \"2>\"\n"
"	lappend cmd \"/dev/null\"\n"
"\n"
"	if {0 || $debug} {\n"
"		set str [join $cmd]\n"
"		puts \"running: $str\"\n"
"		foreach word $cmd {\n"
"			puts \"   word: $word\"\n"
"		}\n"
"	}\n"
"\n"
"	set output \"\"\n"
"	menus_disable\n"
"\n"
"	stop_watch on\n"
"	catch {set output [eval exec $cmd]}\n"
"	stop_watch off\n"
"\n"
"	menus_enable\n"
"	if {$debug} {\n"
"		if {[string length $output] > 100} {\n"
"			set str [string range $output 0 100]\n"
"			append_text \"output: $str ...\\n\"\n"
"		} else {\n"
"			append_text \"output: $output\\n\"\n"
"		}\n"
"	}\n"
"	return $output\n"
"}\n"
"\n"
"proc try_connect_and_query_all {{n 2}} {\n"
"	for {set i 0} {$i < $n} {incr i} {\n"
"		if {$i > 0} {\n"
"			after 500\n"
"			append_text \"trying again ...\\n\"\n"
"		}\n"
"		if {[try_connect]} {\n"
"			query_all\n"
"			break\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc try_connect {} {\n"
"	global x11vnc_xdisplay connected_to_x11vnc reply_xdisplay\n"
"	global menu_var unset_str\n"
"\n"
"	set db 0\n"
"#dtime c1\n"
"\n"
"	if {! $connected_to_x11vnc} {\n"
"		if {[info exists menu_var(display)]} {\n"
"			set d $menu_var(display)\n"
"			if {$d != \"\" && $d != $unset_str && $d != $x11vnc_xdisplay} {\n"
"				set x11vnc_xdisplay $menu_var(display)\n"
"				append_text \"Setting X display to: $x11vnc_xdisplay\\n\"\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	set_info \"Pinging $x11vnc_xdisplay ...\"\n"
"	set rargs [list \"-Q\" \"ping\"]\n"
"	set result [run_remote_cmd $rargs]\n"
"#dtime c2a\n"
"\n"
"	if {$db} {puts \"try_connect: \\\"$result\\\"\"}\n"
"\n"
"	if {[regexp {^ans=ping:} $result]} {\n"
"		regsub {^ans=ping:} $result {} reply_xdisplay\n"
"		set msg \"Connected to $reply_xdisplay\"\n"
"		set_info $msg\n"
"		append_text \"$msg\\n\"\n"
"		set_connected yes\n"
"\n"
"		setup_client_channel\n"
"#dtime c2b\n"
"		setup_client_sock 1\n"
"		setup_client_tail\n"
"\n"
"		fetch_displays\n"
"#dtime c3a\n"
"		return 1\n"
"	} else {\n"
"		set str \"x11vnc server.\"\n"
"		if {$x11vnc_xdisplay != \"\"} {\n"
"			set str $x11vnc_xdisplay\n"
"		}\n"
"		set msg \"No reply from $str\"\n"
"		set_info $msg\n"
"		append_text \"$msg\\n\"\n"
"		set_connected no\n"
"		return 0\n"
"	}\n"
"}\n"
"\n"
"proc set_view_variable {val} {\n"
"	global menu_var\n"
"	set menu_var(WindowView) $val\n"
"}\n"
"proc get_view_variable {} {\n"
"	global menu_var\n"
"	if {![info exists menu_var(WindowView)]} {\n"
"		set menu_var(WindowView) \"none\"\n"
"	}\n"
"	return $menu_var(WindowView)\n"
"}\n"
"\n"
"proc change_view_state {} {\n"
"	global menu_var gui_current_state\n"
"\n"
"	set new [get_view_variable]\n"
"\n"
"	if {![info exists gui_current_state]} {\n"
"		set gui_current_state \"\"\n"
"	}\n"
"	set old $gui_current_state\n"
"	#puts \"$old -> $new\"\n"
"\n"
"	if {$old == $new} {\n"
"		return\n"
"	}\n"
"\n"
"	if {$old == \"full\" || $old == \"icon\" || $old == \"tray\"} {\n"
"		;\n"
"	} else {\n"
"		set old \"none\"\n"
"	}\n"
"\n"
"	if {$new == \"full\" || $new == \"icon\" || $new == \"tray\"} {\n"
"		if {$old == \"tray\"} {\n"
"			# sigh XReparentWindow would be too easy...\n"
"			# undo_tray_embed\n"
"			restart_everything $new\n"
"			destroy .\n"
"			exit\n"
"		}\n"
"		make_gui $new\n"
"	} else {\n"
"		set_view_variable $old\n"
"	}\n"
"}\n"
"\n"
"proc setup_client_tail {} {\n"
"	global client_tail\n"
"	if {$client_tail != \"\"} {\n"
"		fileevent $client_tail readable read_client_tail\n"
"	}\n"
"}\n"
"\n"
"proc setup_client_sock {{enable 1}} {\n"
"	global client_sock\n"
"	if {$client_sock != \"\"} {\n"
"		if {$enable} {\n"
"			fileevent $client_sock readable read_client_sock\n"
"		} else {\n"
"			fileevent $client_sock readable \"\"\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"proc setup_tray_embed {} {\n"
"	global icon_win\n"
"	update\n"
"	set w [winfo width .]\n"
"	set h [winfo height .]\n"
"	if {$w < 24} {\n"
"		set w 24\n"
"	}\n"
"	if {$h < 24} {\n"
"		set h 24\n"
"	}\n"
"	wm minsize . $w $h\n"
"	set wid [winfo id .]	\n"
"	push_new_value \"remote-cmd\" \"remote-cmd\" \"trayembed:$wid\" 0\n"
"}\n"
"\n"
"proc restart_everything {gui_mode} {\n"
"	global env gui_argv0 x11vnc_prog full_win\n"
"	global icon_mode_at_startup\n"
"	global tray_embed tray_running\n"
"	if {$gui_mode == \"full\"} {\n"
"		set env(X11VNC_ICON_MODE) 0\n"
"	} elseif {$gui_mode == \"icon\"} {\n"
"		set env(X11VNC_ICON_MODE) 1\n"
"	} elseif {$gui_mode == \"tray\"} {\n"
"		if {$tray_running} {\n"
"			set env(X11VNC_ICON_MODE) \"RUNNING\"\n"
"		} else {\n"
"			set env(X11VNC_ICON_MODE) \"TRAY\"\n"
"		}\n"
"	}\n"
"	puts stderr \"\"\n"
"	puts stderr \"tkx11vnc: restarting gui to leave tray mode.\"\n"
"	puts stderr \"  new gui will be running in the background.\"\n"
"	puts stderr \"  use kill(1) rather than Ctrl-C to kill it.\"\n"
"	puts stderr \"\"\n"
"	if {[info exists env(X11VNC_RESTART_DEPTH)]} {\n"
"		set n $env(X11VNC_RESTART_DEPTH)\n"
"		incr n\n"
"		set env(X11VNC_RESTART_DEPTH) $n\n"
"	} else {\n"
"		set env(X11VNC_RESTART_DEPTH) 0\n"
"	}\n"
"	set env(X11VNC_ICON_SETPASS) \"\"\n"
"\n"
"	if {![info exists env(X11VNC_WISHCMD)]} {\n"
"		puts stderr \"failure in restart_everything.\"\n"
"		exit 1;\n"
"	}\n"
"\n"
"	set code [exec $x11vnc_prog -printgui]\n"
"	if {[string length $code] < 20000} {\n"
"		puts stderr \"failure in restart_everything.\"\n"
"		exit 1;\n"
"	}\n"
"	set tmp \"/tmp/x11vnc[pid]\"\n"
"	file delete -force $tmp\n"
"	if {[file exists $tmp]} {\n"
"		puts stderr \"failure in restart_everything.\"\n"
"		exit 1;\n"
"	}\n"
"	set fh [open $tmp \"a\"]\n"
"	if {![file owned $tmp]}  {\n"
"		puts stderr \"failure in restart_everything.\"\n"
"		exit 1;\n"
"	}\n"
"	file attributes $tmp -permissions \"0400\"\n"
"	puts $fh $code\n"
"	close $fh\n"
"\n"
"	#puts stderr [exec ls -l $tmp]\n"
"\n"
"	wm withdraw .\n"
"	catch {wm withdraw $full_win}\n"
"	update\n"
"\n"
"	exec $env(X11VNC_WISHCMD) $tmp &\n"
"	after 2000\n"
"	file delete -force $tmp\n"
"	\n"
"	destroy .\n"
"	exit\n"
"}\n"
"\n"
"proc undo_tray_embed {} {\n"
"	global icon_win\n"
"	set wid [winfo id .]	\n"
"	push_new_value \"remote-cmd\" \"remote-cmd\" \"trayunembed:$wid\" 0\n"
"}\n"
"\n"
"############################################################################\n"
"# main:\n"
"\n"
"if [info exists env(X11VNC_GUI_TIME)] {\n"
"	dtime M\n"
"}\n"
"\n"
"wm withdraw .\n"
"\n"
"global env x11vnc_prog x11vnc_cmdline x11vnc_xdisplay x11vnc_connect;\n"
"global x11vnc_xdisplay0\n"
"global x11vnc_client_file x11vnc_gui_geom x11vnc_started vnc_url\n"
"global x11vnc_gui_params\n"
"global x11vnc_auth_file x11vnc_connect_file beginner_mode simple_gui_created\n"
"global helpall helptext helpremote helplabel hostname osname\n"
"global all_settings reply_xdisplay always_update\n"
"global max_text_height max_text_width\n"
"global text_height\n"
"global menu_var unset_str menus_disabled\n"
"global bfont ffont sfont snfont old_labels have_labelframes\n"
"global connected_to_x11vnc\n"
"global cache_all_query_vars\n"
"global last_query_all_time query_all_freq client_tail client_sock client_info_read\n"
"global icon_mode icon_mode_at_startup\n"
"global tray_embed tray_running icon_setpasswd icon_embed_id\n"
"global icon_noadvanced icon_minimal\n"
"global make_gui_count text_area_str\n"
"global gui_argv0 gui_start_mode\n"
"global screen_height screen_width\n"
"\n"
"set unset_str \"(unset)\"\n"
"set vnc_url $unset_str\n"
"set connected_to_x11vnc 0\n"
"set menus_disabled 0\n"
"set max_text_height 40\n"
"set max_text_width 90\n"
"set text_height 14\n"
"set bfont \"-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*\"\n"
"set sfont \"-adobe-helvetica-bold-r-*-*-*-100-*-*-*-*-*-*\"\n"
"set snfont \"-adobe-helvetica-medium-r-*-*-*-100-*-*-*-*-*-*\"\n"
"set ffont \"fixed\"\n"
"set help_indent 24;\n"
"set reply_xdisplay \"\"\n"
"set all_settings \"None so far.\"\n"
"set always_update 1\n"
"set cache_all_query_vars \"\"\n"
"set query_all_freq 120\n"
"set last_query_all_time [clock seconds]\n"
"set client_tail \"\"\n"
"set client_sock \"\"\n"
"set client_info_read 0\n"
"set make_gui_count 0\n"
"set text_area_str \"\"\n"
"set gui_argv0 $argv0\n"
"set gui_start_mode \"\"\n"
"\n"
"if {$tk_version < 8.0} {\n"
"	puts stderr \"\"\n"
"	puts stderr \"*** tkx11vnc: tk version is old $tk_version, please use 8.0 or higher.\"\n"
"	puts stderr \"***           will try to continue with reduced functionality...\"\n"
"	puts stderr \"\"\n"
"}\n"
"if {[regexp {^[34]} $tk_version] || $tk_version == \"8.0\"} {\n"
"	set old_labels 1\n"
"} else {\n"
"	set old_labels 0\n"
"}\n"
"set have_labelframes 1\n"
"if {$tk_version < 8.4} {\n"
"	set have_labelframes 0\n"
"}\n"
"\n"
"set screen_height [winfo screenheight .]\n"
"set screen_width  [winfo screenwidth  .]\n"
"if {$screen_height < 500} {\n"
"	# short screen, PDA?\n"
"	set max_text_height 22\n"
"	set text_height 13\n"
"	if {$screen_height <= 360} {\n"
"		# very short.\n"
"		set max_text_height 16\n"
"		set max_text_width  60\n"
"		set text_height 11\n"
"	}\n"
"}\n"
"if {[info exists env(X11VNC_GUI_TEXT_HEIGHT)]} {\n"
"	set max_text_height $env(X11VNC_GUI_TEXT_HEIGHT)\n"
"}\n"
"if {[info exists env(X11VNC_GUI_TEXT_WIDTH)]} {\n"
"	set max_text_width  $env(X11VNC_GUI_TEXT_WIDTH)\n"
"}\n"
"\n"
"if {\"$argv\" == \"-spit\"} {\n"
"	set fh [open $argv0 r]\n"
"	puts \"#ifndef _TKX11VNC_H\"\n"
"	puts \"#define _TKX11VNC_H\"\n"
"	puts \"#ifdef NOGUI\"\n"
"	puts \"char gui_code\\[\\] = \\\"\\\";\"\n"
"	puts \"#else\"\n"
"	puts \"/*\"\n"
"	puts \" * tkx11vnc.h: generated by 'tkx11vnc -spit'\"\n"
"	puts \" * Abandon all hope, ye who enter here...\"\n"
"	puts \" * ...edit tkx11vnc instead.\"\n"
"	puts \" */\"\n"
"	puts \"	char gui_code\\[\\] =\"\n"
"	while {[gets $fh line] > -1} {\n"
"		regsub -all {\\\\} $line {\\\\\\\\} line\n"
"		regsub -all {\"} $line {\\\\\"} line\n"
"		puts \"\\\"$line\\\\n\\\"\"\n"
"	}\n"
"	puts \"#endif\"\n"
"	puts \"/* ifdef NOGUI */\"\n"
"	puts \"#endif\"\n"
"	puts \"/* ifndef _TKX11VNC_H */\"\n"
"	close $fh\n"
"	puts \";\"\n"
"	exit 0\n"
"}\n"
"\n"
"\n"
"set_view_variable \"full\"\n"
"\n"
"#puts [exec env | grep X11VNC]\n"
"\n"
"# Read environment for clues:\n"
"\n"
"set x11vnc_client_file \"\";\n"
"if {[info exists env(X11VNC_CLIENT_FILE)]} {\n"
"	set x11vnc_client_file $env(X11VNC_CLIENT_FILE);\n"
"	set file $x11vnc_client_file\n"
"\n"
"	set client_tail \"\"\n"
"	if {[file exists $file] && [file isfile $file]} {\n"
"		if {[file readable $file] && [file owned $file]} {\n"
"			set client_tail [open \"|tail -f $x11vnc_client_file\" \"r\"]\n"
"		}\n"
"	}\n"
"	if {$client_tail != \"\"} {\n"
"		gets $client_tail tmp\n"
"		if [eof $client_tail] {\n"
"#puts \"eof $client_tail\"\n"
"			clean_client_tail\n"
"			set client_tail \"\"\n"
"		}\n"
"	}\n"
"	catch {file delete -force $x11vnc_client_file}\n"
"}\n"
"\n"
"if {[info exists env(X11VNC_PROG)]} {\n"
"	set x11vnc_prog $env(X11VNC_PROG);\n"
"} else {\n"
"	set x11vnc_prog \"x11vnc\";\n"
"}\n"
"\n"
"if {[info exists env(X11VNC_CMDLINE)]} {\n"
"	set x11vnc_cmdline $env(X11VNC_CMDLINE);\n"
"} else {\n"
"	set x11vnc_cmdline \"\";\n"
"}\n"
"\n"
"if {[info exists env(X11VNC_CONNECT)]} {\n"
"	set x11vnc_connect 1\n"
"} else {\n"
"	set x11vnc_connect 0;\n"
"}\n"
"\n"
"if {[info exists env(X11VNC_GUI_GEOM)]} {\n"
"	set x11vnc_gui_geom $env(X11VNC_GUI_GEOM);\n"
"} else {\n"
"	set x11vnc_gui_geom \"\"\n"
"}\n"
"if {[info exists env(X11VNC_GUI_PARAMS)]} {\n"
"	set x11vnc_gui_params $env(X11VNC_GUI_PARAMS);\n"
"} else {\n"
"	set x11vnc_gui_params \"\"\n"
"}\n"
"\n"
"if {[info exists env(X11VNC_CONNECT_FILE)]} {\n"
"	set x11vnc_connect_file $env(X11VNC_CONNECT_FILE);\n"
"} else {\n"
"	set x11vnc_connect_file \"\";\n"
"}\n"
"\n"
"set x11vnc_started 0\n"
"if {[info exists env(X11VNC_STARTED)]} {\n"
"	set x11vnc_started 1\n"
"}\n"
"\n"
"set x11vnc_xdisplay \"\"\n"
"if {[info exists env(X11VNC_XDISPLAY)]} {\n"
"	set x11vnc_xdisplay $env(X11VNC_XDISPLAY);\n"
"	set x11vnc_connect 1\n"
"\n"
"} elseif {$argv != \"\" && [regexp {:[0-9]} $argv]} {\n"
"	set env(X11VNC_XDISPLAY) \"$argv\"\n"
"	set x11vnc_xdisplay \"$argv\"\n"
"	set x11vnc_connect 1\n"
"\n"
"} elseif {[info exists env(DISPLAY)]} {\n"
"	set x11vnc_xdisplay $env(DISPLAY);\n"
"} else {\n"
"	set x11vnc_xdisplay \":0\";\n"
"}\n"
"set x11vnc_xdisplay0 $x11vnc_xdisplay\n"
"\n"
"if {[info exists env(X11VNC_AUTH_FILE)]} {\n"
"	set x11vnc_auth_file $env(X11VNC_AUTH_FILE)\n"
"} else {\n"
"	set x11vnc_auth_file \"\"\n"
"}\n"
"\n"
"set simple_gui_created 0\n"
"if {[info exists env(X11VNC_SIMPLE_GUI)]} {\n"
"	set beginner_mode 1\n"
"} else {\n"
"	set beginner_mode 0\n"
"}\n"
"\n"
"set icon_mode 0\n"
"set tray_embed 0\n"
"set tray_running 0\n"
"\n"
"if {![info exists env(X11VNC_ICON_MODE_AT_STARTUP)]} {\n"
"	if {[info exists env(X11VNC_ICON_MODE)]} {\n"
"		if {$env(X11VNC_ICON_MODE) != 0} {\n"
"			set env(X11VNC_ICON_MODE_AT_STARTUP) 1\n"
"		} else {\n"
"			set env(X11VNC_ICON_MODE_AT_STARTUP) 0\n"
"		}\n"
"	} else {\n"
"		set env(X11VNC_ICON_MODE_AT_STARTUP) 0\n"
"	}\n"
"}\n"
"set icon_mode_at_startup $env(X11VNC_ICON_MODE_AT_STARTUP)\n"
"\n"
"if {![info exists env(X11VNC_ICON_MODE)]} {\n"
"	set icon_mode 0\n"
"} elseif {$env(X11VNC_ICON_MODE) == \"\" || $env(X11VNC_ICON_MODE) == \"0\"} {\n"
"	set icon_mode 0\n"
"} else {\n"
"	set icon_mode 1\n"
"	set_view_variable \"icon\"\n"
"	if [regexp -nocase {TRAY} $env(X11VNC_ICON_MODE)] {\n"
"		set tray_embed 1\n"
"	}\n"
"	if [regexp -nocase {RUNNING} $env(X11VNC_ICON_MODE)] {\n"
"		set tray_running 1\n"
"	}\n"
"}\n"
"\n"
"set icon_setpasswd 0\n"
"if {[info exists env(X11VNC_ICON_SETPASS)]} {\n"
"	if {$env(X11VNC_ICON_SETPASS) != \"\"} {\n"
"		set icon_setpasswd 1\n"
"	}\n"
"}\n"
"\n"
"set icon_noadvanced 0\n"
"if {[info exists env(X11VNC_ICON_NOADVANCED)]} {\n"
"	set icon_noadvanced 1\n"
"}\n"
"\n"
"set icon_minimal 0\n"
"if {[info exists env(X11VNC_ICON_MINIMAL)]} {\n"
"	set icon_minimal 1\n"
"}\n"
"\n"
"if {[info exists env(X11VNC_ICON_EMBED_ID)]} {\n"
"	set icon_embed_id $env(X11VNC_ICON_EMBED_ID)\n"
"} else {\n"
"	set icon_embed_id \"\"\n"
"}\n"
"\n"
"\n"
"set hostname [exec uname -n]\n"
"set osname [exec uname]\n"
"\n"
"if {[regexp -nocase {IRIX} $osname]} {\n"
"	# IRIX \"fixed\" font is huge and doublespaced... \n"
"	set ffont $snfont\n"
"}\n"
"if {[regexp -nocase {Darwin} $osname]} {\n"
"	set ffont {Monaco 10}\n"
"	set bfont {system}\n"
"}\n"
"\n"
"#puts [exec env]\n"
"#puts \"x11vnc_xdisplay: $x11vnc_xdisplay\"\n"
"\n"
"set env(X11VNC_STD_HELP) 1\n"
"\n"
"# scrape the help output for the text and remote control vars:\n"
"parse_help;\n"
"parse_remote_help;\n"
"parse_query_help;\n"
"\n"
"# tweaks to duplicate help text:\n"
"tweak_remote_help lock deny\n"
"tweak_remote_help unlock deny\n"
"\n"
"tweak_both quiet q\n"
"tweak_help logfile o\n"
"tweak_both xwarppointer xwarp\n"
"tweak_both screen_blank sb\n"
"\n"
"set_template\n"
"\n"
"set_name \"tkx11vnc\"\n"
"\n"
"key_bindings;\n"
"\n"
"get_default_vars\n"
"\n"
"dtime D\n"
"\n"
"if {$icon_mode} {\n"
"	if {$tray_embed} {\n"
"		make_gui \"tray\"\n"
"	} else {\n"
"		make_gui \"icon\"\n"
"	}\n"
"	dtime G\n"
"	old_balloon\n"
"	if {$icon_setpasswd} {\n"
"		set m \"You must specify a Session Password\\n\" \n"
"		set m \"${m}before VNC clients can connect.\\n\" \n"
"		set m \"${m}Enter one in the Password field\\n\" \n"
"		set m \"${m}and Press \\\"OK\\\". The password(s) is\\n\" \n"
"		set m \"${m}only for this x11vnc session.\\n\" \n"
"		do_props $m\n"
"		#push_new_value \"unlock\" \"unlock\" 1 0\n"
"	}\n"
"} else {\n"
"	make_gui \"full\"\n"
"	dtime G\n"
"}\n"
"\n"
"\n"
"# main loop.\n"
#endif
/* ifdef NOGUI */
#endif
/* ifndef _TKX11VNC_H */
;
