/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    VncViewer viewer;
    RfbProto rfb;
    ColorModel cm8;
    ColorModel cm24;
    Color[] colors;
    int bytesPixel;
    Image memImage;
    Graphics memGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean listenersInstalled;
    boolean showSoftCursor = false;
    int[] softCursorPixels;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int hotX;
    int hotY;

    VncCanvas(VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.rfb = this.viewer.rfb;
        this.tightInflaters = new Inflater[4];
        this.cm8 = new DirectColorModel(8, 7, 56, 192);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.colors = new Color[256];
        int n = 0;
        while (n < 256) {
            this.colors[n] = new Color(this.cm8.getRGB(n));
            ++n;
        }
        this.setPixelFormat();
        this.listenersInstalled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
    }

    void decodeGradientData(int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[n3 * 3];
        byte[] byArray3 = new byte[n3 * 3];
        byte[] byArray4 = new byte[3];
        int[] nArray = new int[3];
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < 3) {
                byArray4[n7] = (byte)(byArray2[n7] + byArray[n6 * n3 * 3 + n7]);
                byArray3[n7] = byArray4[n7];
                ++n7;
            }
            this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            int n8 = 1;
            while (n8 < n3) {
                n7 = 0;
                while (n7 < 3) {
                    nArray[n7] = (byArray2[n8 * 3 + n7] & 0xFF) + (byArray4[n7] & 0xFF) - (byArray2[(n8 - 1) * 3 + n7] & 0xFF);
                    if (nArray[n7] > 255) {
                        nArray[n7] = 255;
                    } else if (nArray[n7] < 0) {
                        nArray[n7] = 0;
                    }
                    byArray4[n7] = (byte)(nArray[n7] + byArray[(n6 * n3 + n8) * 3 + n7]);
                    byArray3[n8 * 3 + n7] = byArray4[n7];
                    ++n7;
                }
                this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
                ++n8;
            }
            System.arraycopy(byArray3, 0, byArray2, 0, n3 * 3);
            n5 += this.rfb.framebufferWidth - n3;
            ++n6;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) throws IOException {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels8[n5++] = byArray2[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels8[n5++] = byArray2[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) throws IOException {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels24[n5++] = nArray[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels24[n5++] = nArray[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    public synchronized void enableInput(boolean bl) {
        if (bl && !this.listenersInstalled) {
            this.listenersInstalled = true;
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.viewer.options.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(true);
            }
        } else if (!bl && this.listenersInstalled) {
            this.listenersInstalled = false;
            this.removeKeyListener(this);
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.viewer.options.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(false);
            }
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = (n4 + 7) / 8;
        int n7 = n6 * n5;
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            if (n == -240) {
                this.rfb.is.skipBytes(6 + n7 * 2);
            } else {
                this.rfb.is.skipBytes(n4 * n5 + n7);
            }
            return;
        }
        this.softCursorPixels = new int[n4 * n5];
        if (n == -240) {
            byte[] byArray = new byte[6];
            this.rfb.is.readFully(byArray);
            int[] nArray = new int[]{0xFF000000 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF, 0xFF000000 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF};
            byte[] byArray2 = new byte[n7];
            this.rfb.is.readFully(byArray2);
            byte[] byArray3 = new byte[n7];
            this.rfb.is.readFully(byArray3);
            int n8 = 0;
            int n9 = 0;
            while (n9 < n5) {
                int n10;
                int n11;
                int n12 = 0;
                while (n12 < n4 / 8) {
                    byte by = byArray2[n9 * n6 + n12];
                    byte by2 = byArray3[n9 * n6 + n12];
                    n11 = 7;
                    while (n11 >= 0) {
                        n10 = (by2 >> n11 & 1) != 0 ? nArray[by >> n11 & 1] : 0;
                        this.softCursorPixels[n8++] = n10;
                        --n11;
                    }
                    ++n12;
                }
                n11 = 7;
                while (n11 >= 8 - n4 % 8) {
                    n10 = (byArray3[n9 * n6 + n12] >> n11 & 1) != 0 ? nArray[byArray2[n9 * n6 + n12] >> n11 & 1] : 0;
                    this.softCursorPixels[n8++] = n10;
                    --n11;
                }
                ++n9;
            }
        } else {
            byte[] byArray = new byte[n4 * n5 * this.bytesPixel];
            this.rfb.is.readFully(byArray);
            byte[] byArray4 = new byte[n7];
            this.rfb.is.readFully(byArray4);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15;
                int n16;
                int n17 = 0;
                while (n17 < n4 / 8) {
                    byte by = byArray4[n14 * n6 + n17];
                    n16 = 7;
                    while (n16 >= 0) {
                        n15 = (by >> n16 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(byArray[n13]) : 0xFF000000 | (byArray[n13 * 4 + 1] & 0xFF) << 16 | (byArray[n13 * 4 + 2] & 0xFF) << 8 | byArray[n13 * 4 + 3] & 0xFF) : 0;
                        this.softCursorPixels[n13++] = n15;
                        --n16;
                    }
                    ++n17;
                }
                n16 = 7;
                while (n16 >= 8 - n4 % 8) {
                    n15 = (byArray4[n14 * n6 + n17] >> n16 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(byArray[n13]) : 0xFF000000 | (byArray[n13 * 4 + 1] & 0xFF) << 16 | (byArray[n13 * 4 + 2] & 0xFF) << 8 | byArray[n13 * 4 + 3] & 0xFF) : 0;
                    this.softCursorPixels[n13++] = n15;
                    --n16;
                }
                ++n14;
            }
        }
        this.softCursorSource = new MemoryImageSource(n4, n5, this.softCursorPixels, 0, n4);
        this.softCursor = this.createImage(this.softCursorSource);
        this.cursorWidth = n4;
        this.cursorHeight = n5;
        this.hotX = n2;
        this.hotY = n3;
        this.showSoftCursor = true;
        this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    void handleRawRect(int n, int n2, int n3, int n4) throws IOException {
        if (this.bytesPixel == 1) {
            int n5 = n2;
            while (n5 < n2 + n4) {
                this.rfb.is.readFully(this.pixels8, n5 * this.rfb.framebufferWidth + n, n3);
                ++n5;
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            int n6 = n2;
            while (n6 < n2 + n4) {
                this.rfb.is.readFully(byArray);
                int n7 = n6 * this.rfb.framebufferWidth + n;
                int n8 = 0;
                while (n8 < n3) {
                    this.pixels24[n7 + n8] = (byArray[n8 * 4 + 1] & 0xFF) << 16 | (byArray[n8 * 4 + 2] & 0xFF) << 8 | byArray[n8 * 4 + 3] & 0xFF;
                    ++n8;
                }
                ++n6;
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleTightRect(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        byte[] byArray;
        int n6;
        int n7 = this.rfb.is.readUnsignedByte();
        int n8 = 0;
        while (n8 < 4) {
            if ((n7 & 1) != 0 && this.tightInflaters[n8] != null) {
                this.tightInflaters[n8] = null;
            }
            n7 >>= 1;
            ++n8;
        }
        if (n7 > 9) {
            throw new IOException("Incorrect tight subencoding: " + n7);
        }
        if (n7 == 8) {
            if (this.bytesPixel == 1) {
                this.memGraphics.setColor(this.colors[this.rfb.is.readUnsignedByte()]);
            } else {
                byte[] byArray2 = new byte[3];
                this.rfb.is.readFully(byArray2);
                Color color = new Color(0xFF000000 | (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF);
                this.memGraphics.setColor(color);
            }
            this.memGraphics.fillRect(n, n2, n3, n4);
            this.scheduleRepaint(n, n2, n3, n4);
            return;
        }
        if (n7 == 9) {
            byte[] byArray3 = new byte[this.rfb.readCompactLen()];
            this.rfb.is.readFully(byArray3);
            Image image = Toolkit.getDefaultToolkit().createImage(byArray3);
            Rectangle rectangle = this.jpegRect = new Rectangle(n, n2, n3, n4);
            synchronized (rectangle) {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        int n9 = 0;
        int n10 = n3;
        byte[] byArray4 = new byte[2];
        int[] nArray = new int[256];
        boolean bl = false;
        if ((n7 & 4) != 0) {
            n6 = this.rfb.is.readUnsignedByte();
            if (n6 == 1) {
                n9 = this.rfb.is.readUnsignedByte() + 1;
                if (this.bytesPixel == 1) {
                    if (n9 != 2) {
                        throw new IOException("Incorrect tight palette size: " + n9);
                    }
                    byArray4[0] = this.rfb.is.readByte();
                    byArray4[1] = this.rfb.is.readByte();
                } else {
                    byArray = new byte[n9 * 3];
                    this.rfb.is.readFully(byArray);
                    n5 = 0;
                    while (n5 < n9) {
                        nArray[n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                        ++n5;
                    }
                }
                if (n9 == 2) {
                    n10 = (n3 + 7) / 8;
                }
            } else if (n6 == 2) {
                bl = true;
            } else if (n6 != 0) {
                throw new IOException("Incorrect tight filter id: " + n6);
            }
        }
        if (n9 == 0 && this.bytesPixel == 4) {
            n10 *= 3;
        }
        if ((n6 = n4 * n10) < 12) {
            if (n9 != 0) {
                byArray = new byte[n6];
                this.rfb.is.readFully(byArray);
                if (n9 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(n, n2, n3, n4, byArray, byArray4);
                    } else {
                        this.decodeMonoData(n, n2, n3, n4, byArray, nArray);
                    }
                } else {
                    n5 = 0;
                    int n11 = n2;
                    while (n11 < n2 + n4) {
                        int n12 = n;
                        while (n12 < n + n3) {
                            this.pixels24[n11 * this.rfb.framebufferWidth + n12] = nArray[byArray[n5++] & 0xFF];
                            ++n12;
                        }
                        ++n11;
                    }
                }
            } else if (bl) {
                byArray = new byte[n3 * n4 * 3];
                this.rfb.is.readFully(byArray);
                this.decodeGradientData(n, n2, n3, n4, byArray);
            } else if (this.bytesPixel == 1) {
                int n13 = n2;
                while (n13 < n2 + n4) {
                    this.rfb.is.readFully(this.pixels8, n13 * this.rfb.framebufferWidth + n, n3);
                    ++n13;
                }
            } else {
                byArray = new byte[n3 * 3];
                int n14 = n2;
                while (n14 < n2 + n4) {
                    this.rfb.is.readFully(byArray);
                    int n15 = n14 * this.rfb.framebufferWidth + n;
                    n5 = 0;
                    while (n5 < n3) {
                        this.pixels24[n15 + n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                        ++n5;
                    }
                    ++n14;
                }
            }
        } else {
            int n16 = this.rfb.readCompactLen();
            byte[] byArray5 = new byte[n16];
            this.rfb.is.readFully(byArray5);
            int n17 = n7 & 3;
            if (this.tightInflaters[n17] == null) {
                this.tightInflaters[n17] = new Inflater();
            }
            Inflater inflater = this.tightInflaters[n17];
            inflater.setInput(byArray5);
            try {
                if (n9 != 0) {
                    byte[] byArray6 = new byte[n6];
                    inflater.inflate(byArray6);
                    if (n9 == 2) {
                        if (this.bytesPixel == 1) {
                            this.decodeMonoData(n, n2, n3, n4, byArray6, byArray4);
                        }
                        this.decodeMonoData(n, n2, n3, n4, byArray6, nArray);
                    }
                    int n18 = 0;
                    int n19 = n2;
                    while (n19 < n2 + n4) {
                        int n20 = n;
                        while (n20 < n + n3) {
                            this.pixels24[n19 * this.rfb.framebufferWidth + n20] = nArray[byArray6[n18++] & 0xFF];
                            ++n20;
                        }
                        ++n19;
                    }
                }
                if (bl) {
                    byte[] byArray7 = new byte[n3 * n4 * 3];
                    inflater.inflate(byArray7);
                    this.decodeGradientData(n, n2, n3, n4, byArray7);
                }
                if (this.bytesPixel == 1) {
                    int n21 = n2;
                    while (n21 < n2 + n4) {
                        inflater.inflate(this.pixels8, n21 * this.rfb.framebufferWidth + n, n3);
                        ++n21;
                    }
                }
                byte[] byArray8 = new byte[n3 * 3];
                int n22 = n2;
                while (n22 < n2 + n4) {
                    inflater.inflate(byArray8);
                    int n23 = n22 * this.rfb.framebufferWidth + n;
                    int n24 = 0;
                    while (n24 < n3) {
                        this.pixels24[n23 + n24] = (byArray8[n24 * 3] & 0xFF) << 16 | (byArray8[n24 * 3 + 1] & 0xFF) << 8 | byArray8[n24 * 3 + 2] & 0xFF;
                        ++n24;
                    }
                    ++n22;
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException.toString());
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleUpdatedPixels(int n, int n2, int n3, int n4) {
        this.pixelsSource.newPixels(n, n2, n3, n4);
        this.memGraphics.setClip(n, n2, n3, n4);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void handleZlibRect(int n, int n2, int n3, int n4) throws IOException {
        try {
            if (this.bytesPixel == 1) {
                int n5 = n2;
                while (n5 < n2 + n4) {
                    this.zlibInflater.inflate(this.pixels8, n5 * this.rfb.framebufferWidth + n, n3);
                    ++n5;
                }
            } else {
                byte[] byArray = new byte[n3 * 4];
                int n6 = n2;
                while (n6 < n2 + n4) {
                    this.zlibInflater.inflate(byArray);
                    int n7 = n6 * this.rfb.framebufferWidth + n;
                    int n8 = 0;
                    while (n8 < n3) {
                        this.pixels24[n7 + n8] = (byArray[n8 * 4 + 1] & 0xFF) << 16 | (byArray[n8 * 4 + 2] & 0xFF) << 8 | byArray[n8 * 4 + 3] & 0xFF;
                        ++n8;
                    }
                    ++n6;
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException(dataFormatException.toString());
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xA0) == 0) {
            return true;
        }
        if ((n & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(image, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle;
        Image image = this.memImage;
        synchronized (image) {
            graphics.drawImage(this.memImage, 0, 0, null);
        }
        if (this.showSoftCursor && (rectangle = new Rectangle(n2 = this.cursorX - this.hotX, n = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(graphics.getClipBounds())) {
            graphics.drawImage(this.softCursor, n2, n, null);
        }
    }

    public void processLocalKeyEvent(KeyEvent keyEvent) {
        if (this.rfb != null && this.rfb.inNormalProtocol) {
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writeKeyEvent(keyEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.rfb.notify();
            }
        }
        keyEvent.consume();
    }

    public void processLocalMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (this.rfb != null && this.rfb.inNormalProtocol) {
            if (bl) {
                this.softCursorMove(mouseEvent.getX(), mouseEvent.getY());
            }
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writePointerEvent(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    public void processNormalProtocol() throws IOException {
        int n;
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        block20: while (true) {
            n = this.rfb.readServerMessageType();
            switch (n) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    int n2 = 0;
                    while (n2 < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            this.rfb.setFramebufferSize(this.rfb.updateRectW, this.rfb.updateRectH);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240 || this.rfb.updateRectEncoding == -239) {
                            this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                        } else {
                            switch (this.rfb.updateRectEncoding) {
                                case 0: {
                                    this.handleRawRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    break;
                                }
                                case 1: {
                                    this.rfb.readCopyRect();
                                    int n3 = this.rfb.copyRectSrcX;
                                    int n4 = this.rfb.copyRectSrcY;
                                    int n5 = this.rfb.updateRectX;
                                    int n6 = this.rfb.updateRectY;
                                    int n7 = this.rfb.updateRectW;
                                    int n8 = this.rfb.updateRectH;
                                    this.memGraphics.copyArea(n3, n4, n7, n8, n5 - n3, n6 - n4);
                                    this.scheduleRepaint(n5, n6, n7, n8);
                                    break;
                                }
                                case 2: {
                                    int n9;
                                    int n10;
                                    int n11;
                                    Color color;
                                    int n12;
                                    int n3 = this.rfb.updateRectX;
                                    int n4 = this.rfb.updateRectY;
                                    int n5 = this.rfb.updateRectW;
                                    int n6 = this.rfb.updateRectH;
                                    int n13 = this.rfb.is.readInt();
                                    if (this.bytesPixel == 1) {
                                        this.memGraphics.setColor(this.colors[this.rfb.is.readUnsignedByte()]);
                                        this.memGraphics.fillRect(n3, n4, n5, n6);
                                        n12 = 0;
                                        while (n12 < n13) {
                                            color = this.colors[this.rfb.is.readUnsignedByte()];
                                            int n14 = n3 + this.rfb.is.readUnsignedShort();
                                            n11 = n4 + this.rfb.is.readUnsignedShort();
                                            n10 = this.rfb.is.readUnsignedShort();
                                            n9 = this.rfb.is.readUnsignedShort();
                                            this.memGraphics.setColor(color);
                                            this.memGraphics.fillRect(n14, n11, n10, n9);
                                            ++n12;
                                        }
                                    } else {
                                        color = new Color(0xFF000000 | this.rfb.is.readInt());
                                        this.memGraphics.setColor(color);
                                        this.memGraphics.fillRect(n3, n4, n5, n6);
                                        n12 = 0;
                                        while (n12 < n13) {
                                            color = new Color(0xFF000000 | this.rfb.is.readInt());
                                            int n15 = n3 + this.rfb.is.readUnsignedShort();
                                            n11 = n4 + this.rfb.is.readUnsignedShort();
                                            n10 = this.rfb.is.readUnsignedShort();
                                            n9 = this.rfb.is.readUnsignedShort();
                                            this.memGraphics.setColor(color);
                                            this.memGraphics.fillRect(n15, n11, n10, n9);
                                            ++n12;
                                        }
                                    }
                                    this.scheduleRepaint(n3, n4, n5, n6);
                                    break;
                                }
                                case 4: {
                                    int n9;
                                    int n10;
                                    int n11;
                                    int n12;
                                    int n3 = this.rfb.updateRectX;
                                    int n4 = this.rfb.updateRectY;
                                    int n5 = this.rfb.updateRectW;
                                    int n6 = this.rfb.updateRectH;
                                    int n16 = this.rfb.is.readInt();
                                    if (this.bytesPixel == 1) {
                                        this.memGraphics.setColor(this.colors[this.rfb.is.readUnsignedByte()]);
                                        this.memGraphics.fillRect(n3, n4, n5, n6);
                                        n12 = 0;
                                        while (n12 < n16) {
                                            Color color = this.colors[this.rfb.is.readUnsignedByte()];
                                            int n17 = n3 + this.rfb.is.readUnsignedByte();
                                            n11 = n4 + this.rfb.is.readUnsignedByte();
                                            n10 = this.rfb.is.readUnsignedByte();
                                            n9 = this.rfb.is.readUnsignedByte();
                                            this.memGraphics.setColor(color);
                                            this.memGraphics.fillRect(n17, n11, n10, n9);
                                            ++n12;
                                        }
                                    } else {
                                        Color color = new Color(0xFF000000 | this.rfb.is.readInt());
                                        this.memGraphics.setColor(color);
                                        this.memGraphics.fillRect(n3, n4, n5, n6);
                                        n12 = 0;
                                        while (n12 < n16) {
                                            color = new Color(0xFF000000 | this.rfb.is.readInt());
                                            int n18 = n3 + this.rfb.is.readUnsignedByte();
                                            n11 = n4 + this.rfb.is.readUnsignedByte();
                                            n10 = this.rfb.is.readUnsignedByte();
                                            n9 = this.rfb.is.readUnsignedByte();
                                            this.memGraphics.setColor(color);
                                            this.memGraphics.fillRect(n18, n11, n10, n9);
                                            ++n12;
                                        }
                                    }
                                    this.scheduleRepaint(n3, n4, n5, n6);
                                    break;
                                }
                                case 5: {
                                    int n9;
                                    int n10;
                                    int n12;
                                    int n3 = this.rfb.updateRectX;
                                    int n4 = this.rfb.updateRectY;
                                    int n5 = this.rfb.updateRectW;
                                    int n6 = this.rfb.updateRectH;
                                    Color color = new Color(0);
                                    Color color2 = new Color(0);
                                    int n11 = n4;
                                    while (n11 < n4 + n6) {
                                        n10 = 16;
                                        if (n4 + n6 - n11 < 16) {
                                            n10 = n4 + n6 - n11;
                                        }
                                        n9 = n3;
                                        while (n9 < n3 + n5) {
                                            int n19;
                                            int n20;
                                            int n21;
                                            int n22 = 16;
                                            if (n3 + n5 - n9 < 16) {
                                                n22 = n3 + n5 - n9;
                                            }
                                            if (((n12 = this.rfb.is.readUnsignedByte()) & 1) != 0) {
                                                if (this.bytesPixel == 1) {
                                                    int n23 = n11;
                                                    while (n23 < n11 + n10) {
                                                        this.rfb.is.readFully(this.pixels8, n23 * this.rfb.framebufferWidth + n9, n22);
                                                        ++n23;
                                                    }
                                                } else {
                                                    byte[] byArray = new byte[n22 * 4];
                                                    n21 = n11;
                                                    while (n21 < n11 + n10) {
                                                        this.rfb.is.readFully(byArray);
                                                        n20 = n21 * this.rfb.framebufferWidth + n9;
                                                        n19 = 0;
                                                        while (n19 < n22) {
                                                            this.pixels24[n20 + n19] = (byArray[n19 * 4 + 1] & 0xFF) << 16 | (byArray[n19 * 4 + 2] & 0xFF) << 8 | byArray[n19 * 4 + 3] & 0xFF;
                                                            ++n19;
                                                        }
                                                        ++n21;
                                                    }
                                                }
                                                this.handleUpdatedPixels(n9, n11, n22, n10);
                                            } else {
                                                if ((n12 & 2) != 0) {
                                                    color = this.bytesPixel == 1 ? this.colors[this.rfb.is.readUnsignedByte()] : new Color(0xFF000000 | this.rfb.is.readInt());
                                                }
                                                this.memGraphics.setColor(color);
                                                this.memGraphics.fillRect(n9, n11, n22, n10);
                                                if ((n12 & 4) != 0) {
                                                    color2 = this.bytesPixel == 1 ? this.colors[this.rfb.is.readUnsignedByte()] : new Color(0xFF000000 | this.rfb.is.readInt());
                                                }
                                                if ((n12 & 8) != 0) {
                                                    int n24;
                                                    int n25;
                                                    int n26;
                                                    int n27;
                                                    int n28 = this.rfb.is.readUnsignedByte();
                                                    if (this.bytesPixel == 1) {
                                                        if ((n12 & 0x10) != 0) {
                                                            n27 = 0;
                                                            while (n27 < n28) {
                                                                color2 = this.colors[this.rfb.is.readUnsignedByte()];
                                                                n19 = this.rfb.is.readUnsignedByte();
                                                                n20 = this.rfb.is.readUnsignedByte();
                                                                n21 = n9 + (n19 >> 4);
                                                                n26 = n11 + (n19 & 0xF);
                                                                n25 = (n20 >> 4) + 1;
                                                                n24 = (n20 & 0xF) + 1;
                                                                this.memGraphics.setColor(color2);
                                                                this.memGraphics.fillRect(n21, n26, n25, n24);
                                                                ++n27;
                                                            }
                                                        } else {
                                                            this.memGraphics.setColor(color2);
                                                            n27 = 0;
                                                            while (n27 < n28) {
                                                                n19 = this.rfb.is.readUnsignedByte();
                                                                n20 = this.rfb.is.readUnsignedByte();
                                                                n21 = n9 + (n19 >> 4);
                                                                n26 = n11 + (n19 & 0xF);
                                                                n25 = (n20 >> 4) + 1;
                                                                n24 = (n20 & 0xF) + 1;
                                                                this.memGraphics.fillRect(n21, n26, n25, n24);
                                                                ++n27;
                                                            }
                                                        }
                                                    } else if ((n12 & 0x10) != 0) {
                                                        n27 = 0;
                                                        while (n27 < n28) {
                                                            color2 = new Color(0xFF000000 | this.rfb.is.readInt());
                                                            n19 = this.rfb.is.readUnsignedByte();
                                                            n20 = this.rfb.is.readUnsignedByte();
                                                            n21 = n9 + (n19 >> 4);
                                                            n26 = n11 + (n19 & 0xF);
                                                            n25 = (n20 >> 4) + 1;
                                                            n24 = (n20 & 0xF) + 1;
                                                            this.memGraphics.setColor(color2);
                                                            this.memGraphics.fillRect(n21, n26, n25, n24);
                                                            ++n27;
                                                        }
                                                    } else {
                                                        this.memGraphics.setColor(color2);
                                                        n27 = 0;
                                                        while (n27 < n28) {
                                                            n19 = this.rfb.is.readUnsignedByte();
                                                            n20 = this.rfb.is.readUnsignedByte();
                                                            n21 = n9 + (n19 >> 4);
                                                            n26 = n11 + (n19 & 0xF);
                                                            n25 = (n20 >> 4) + 1;
                                                            n24 = (n20 & 0xF) + 1;
                                                            this.memGraphics.fillRect(n21, n26, n25, n24);
                                                            ++n27;
                                                        }
                                                    }
                                                }
                                            }
                                            n9 += 16;
                                        }
                                        this.scheduleRepaint(n3, n11, n5, n10);
                                        n11 += 16;
                                    }
                                    break;
                                }
                                case 6: {
                                    int n3 = this.rfb.is.readInt();
                                    if (this.zlibBuf == null || this.zlibBufLen < n3) {
                                        this.zlibBufLen = n3 * 2;
                                        this.zlibBuf = new byte[this.zlibBufLen];
                                    }
                                    this.rfb.is.readFully(this.zlibBuf, 0, n3);
                                    if (this.zlibInflater == null) {
                                        this.zlibInflater = new Inflater();
                                    }
                                    this.zlibInflater.setInput(this.zlibBuf, 0, n3);
                                    this.handleZlibRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    break;
                                }
                                case 7: {
                                    this.handleTightRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    break;
                                }
                                default: {
                                    throw new IOException("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                                }
                            }
                        }
                        ++n2;
                    }
                    if (this.viewer.deferUpdateRequests > 0) {
                        RfbProto rfbProto = this.rfb;
                        synchronized (rfbProto) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.viewer.options.eightBitColors != (this.bytesPixel == 1)) {
                        this.setPixelFormat();
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                        continue block20;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, true);
                    continue block20;
                }
                case 1: {
                    throw new IOException("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block20;
                }
                case 3: {
                    String string = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(string);
                    continue block20;
                }
            }
            break;
        }
        throw new IOException("Unknown RFB message type " + n);
    }

    void resizeDesktopFrame() {
        Dimension dimension;
        this.setSize(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.rfb.framebufferWidth + 2 * Math.min(insets.left, insets.right), this.rfb.framebufferHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension dimension2 = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension dimension3 = dimension = this.viewer.vncFrame.getSize();
        boolean bl = false;
        if (dimension.height > dimension2.height) {
            dimension3.height = dimension2.height;
            bl = true;
        }
        if (dimension.width > dimension2.width) {
            dimension3.width = dimension2.width;
            bl = true;
        }
        if (bl) {
            ((Component)this.viewer.vncFrame).setSize(dimension3);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    void scheduleRepaint(int n, int n2, int n3, int n4) {
        this.repaint(this.viewer.deferScreenUpdates, n, n2, n3, n4);
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors) {
            this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, true, true, 255, 255, 255, 16, 8, 0);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.softCursorPixels = null;
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    synchronized void softCursorMove(int n, int n2) {
        if (this.showSoftCursor) {
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, n - this.hotX, n2 - this.hotY, this.cursorWidth, this.cursorHeight);
        }
        this.cursorX = n;
        this.cursorY = n2;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void updateFramebufferSize() {
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (this.memImage == null) {
            this.memImage = this.viewer.createImage(n, n2);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != n || this.memImage.getHeight(null) != n2) {
            Image image = this.memImage;
            synchronized (image) {
                this.memImage = this.viewer.createImage(n, n2);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm8, this.pixels8, 0, n);
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm24, this.pixels24, 0, n);
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = this.createImage(this.pixelsSource);
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                this.resizeDesktopFrame();
            }
        } else {
            this.setSize(n, n2);
        }
    }
}

