#ifndef _SSLTOOLS_H
#define _SSLTOOLS_H

/* quoted scripts, edit source not this file. */


char genCA[] = 
"#!/bin/sh\n"
"\n"
"DIR=$BASE_DIR\n"
"if [ \"x$DIR\" = \"x\" ]; then\n"
"	DIR=\"$HOME/dotkjr_vnc/certs\"\n"
"	rm -rf \"$DIR\"\n"
"fi\n"
"if echo \"$DIR\" | grep '^/' > /dev/null; then\n"
"        :\n"
"else\n"
"        DIR=\"`pwd`/$DIR\"\n"
"fi\n"
"\n"
"PATH=/usr/bin:/bin:/usr/sbin:$PATH; export PATH\n"
"if [ \"x$OPENSSL\" = \"x\" ]; then\n"
"	OPENSSL=\"openssl\"\n"
"fi\n"
"\n"
"type \"$OPENSSL\" > /dev/null	|| exit 1\n"
"\n"
"if [ -f \"$DIR/CA/cacert.pem\" ]; then\n"
"	echo \"Files will be overwritten in $DIR/CA\"\n"
"	printf \"Continue? [y]/n \"\n"
"	read x\n"
"	if [ \"x$x\" = \"xn\" ]; then\n"
"		exit 1;\n"
"	fi\n"
"fi\n"
"\n"
"#mkdir -p \"$DIR/HASH\"		|| exit 1\n"
"mkdir -p \"$DIR/clients\"		|| exit 1\n"
"#mkdir -p \"$DIR/clients/HASH\"	|| exit 1\n"
"mkdir -p \"$DIR/CA/certs\"	|| exit 1\n"
"mkdir -p \"$DIR/CA/crl\"		|| exit 1\n"
"mkdir -p \"$DIR/CA/newcerts\"	|| exit 1\n"
"mkdir -p \"$DIR/CA/private\"	|| exit 1\n"
"chmod go-rwx \"$DIR/CA/private\"	|| exit 1\n"
"mkdir -p \"$DIR/tmp\"		|| exit 1\n"
"chmod go-rwx \"$DIR/tmp\"		|| exit 1\n"
"touch \"$DIR/CA/index.txt\"	|| exit 1\n"
"if [ ! -f \"$DIR/CA/serial\" ]; then\n"
"	echo \"01\" > \"$DIR/CA/serial\"	|| exit 1\n"
"fi\n"
"\n"
"cnf='\n"
"HOME			= .\n"
"RANDFILE		= $ENV::HOME/.rnd\n"
"\n"
"####################################################################\n"
"[ ca ]\n"
"default_ca	= CA_default		# The default ca section\n"
"\n"
"####################################################################\n"
"[ CA_default ]\n"
"\n"
"dir		= ./CA			# Where everything is kept\n"
"certs		= $dir/certs		# Where the issued certs are kept\n"
"crl_dir		= $dir/crl		# Where the issued crl are kept\n"
"database	= $dir/index.txt	# database index file.\n"
"new_certs_dir	= $dir/newcerts		# default place for new certs.\n"
"certificate	= $dir/cacert.pem 	# The CA certificate\n"
"serial		= $dir/serial 		# The current serial number\n"
"crl		= $dir/crl.pem 		# The current CRL\n"
"private_key	= $dir/private/cakey.pem # The private key\n"
"RANDFILE	= $dir/private/.rand	# private random number file\n"
"\n"
"x509_extensions	= usr_cert		# The extentions to add to the cert\n"
"\n"
"name_opt 	= ca_default		# Subject Name options\n"
"cert_opt 	= ca_default		# Certificate field options\n"
"\n"
"default_days	= 365			# how long to certify for\n"
"default_crl_days= 30			# how long before next CRL\n"
"default_md	= md5			# which md to use.\n"
"preserve	= no			# keep passed DN ordering\n"
"\n"
"policy		= policy_match\n"
"\n"
"# For the CA policy\n"
"[ policy_match ]\n"
"countryName		= match\n"
"stateOrProvinceName	= match\n"
"organizationName	= match\n"
"organizationalUnitName	= optional\n"
"commonName		= supplied\n"
"emailAddress		= optional\n"
"\n"
"[ policy_anything ]\n"
"countryName		= optional\n"
"stateOrProvinceName	= optional\n"
"localityName		= optional\n"
"organizationName	= optional\n"
"organizationalUnitName	= optional\n"
"commonName		= supplied\n"
"emailAddress		= optional\n"
"\n"
"####################################################################\n"
"[ req ]\n"
"default_bits		= 2048\n"
"default_keyfile 	= privkey.pem\n"
"distinguished_name	= req_distinguished_name\n"
"attributes		= req_attributes\n"
"x509_extensions	= v3_ca	# The extentions to add to the self signed cert\n"
"\n"
"string_mask = nombstr\n"
"\n"
"# req_extensions = v3_req # The extensions to add to a certificate request\n"
"\n"
"[ req_distinguished_name ]\n"
"countryName			= Country Name (2 letter code)\n"
"countryName_default		= AU\n"
"countryName_min			= 2\n"
"countryName_max			= 2\n"
"\n"
"stateOrProvinceName		= State or Province Name (full name)\n"
"stateOrProvinceName_default	= mystate\n"
"\n"
"localityName			= Locality Name (eg, city)\n"
"\n"
"0.organizationName		= Organization Name (eg, company)\n"
"0.organizationName_default	= x11vnc server CA\n"
"\n"
"organizationalUnitName		= Organizational Unit Name (eg, section)\n"
"\n"
"commonName			= Common Name (eg, YOUR name)\n"
"commonName_default		= %USER x11vnc server CA\n"
"commonName_max			= 64\n"
"\n"
"emailAddress			= Email Address\n"
"emailAddress_default		= x11vnc@CA.nowhere\n"
"emailAddress_max		= 64\n"
"\n"
"[ req_attributes ]\n"
"challengePassword		= A challenge password\n"
"challengePassword_min		= 4\n"
"challengePassword_max		= 20\n"
"\n"
"unstructuredName		= An optional company name\n"
"\n"
"[ usr_cert ]\n"
"\n"
"basicConstraints=CA:FALSE\n"
"\n"
"nsComment			= \"OpenSSL Generated Certificate\"\n"
"\n"
"subjectKeyIdentifier=hash\n"
"authorityKeyIdentifier=keyid,issuer:always\n"
"\n"
"[ v3_req ]\n"
"\n"
"basicConstraints = CA:FALSE\n"
"keyUsage = nonRepudiation, digitalSignature, keyEncipherment\n"
"\n"
"[ v3_ca ]\n"
"\n"
"subjectKeyIdentifier=hash\n"
"\n"
"authorityKeyIdentifier=keyid:always,issuer:always\n"
"\n"
"basicConstraints = CA:true\n"
"\n"
"[ crl_ext ]\n"
"\n"
"authorityKeyIdentifier=keyid:always,issuer:always\n"
"\n"
"'\n"
"selfcnf='\n"
"####################################################################\n"
"[ req ]\n"
"default_bits		= 2048\n"
"encrypt_key		= yes\n"
"distinguished_name	= req_distinguished_name\n"
"x509_extensions		= cert_type\n"
"\n"
"[ req_distinguished_name ]\n"
"countryName			= Country Name (2 letter code)\n"
"countryName_default		= AU\n"
"countryName_min			= 2\n"
"countryName_max			= 2\n"
"\n"
"stateOrProvinceName		= State or Province Name (full name)\n"
"stateOrProvinceName_default	= mystate\n"
"\n"
"localityName			= Locality Name (eg, city)\n"
"\n"
"0.organizationName		= Organization Name (eg, company)\n"
"0.organizationName_default	= x11vnc server self-signed\n"
"\n"
"organizationalUnitName		= Organizational Unit Name (eg, section)\n"
"\n"
"commonName			= Common Name (eg, YOUR name)\n"
"commonName_default		= x11vnc server self-signed %NAME\n"
"commonName_max			= 64\n"
"\n"
"emailAddress			= Email Address\n"
"emailAddress_default		= x11vnc@self-signed.nowhere\n"
"emailAddress_max		= 64\n"
"\n"
"[ cert_type ]\n"
"nsCertType = server\n"
"\n"
"'\n"
"echo \"$cnf\" | sed -e \"s/%USER/$USER/\" \\\n"
"	> \"$DIR/CA/ssl.cnf\" || exit 1\n"
"echo \"$cnf\" | sed -e \"s/%USER *//\" -e 's/server CA/server %NAME/g' -e 's/@CA/@server/' \\\n"
"	> \"$DIR/CA/ssl.cnf.server\" || exit 1\n"
"echo \"$cnf\" | sed -e \"s/%USER *//\" -e 's/server CA/client %NAME/g' -e 's/@CA/@client/' \\\n"
"	> \"$DIR/CA/ssl.cnf.client\" || exit 1\n"
"\n"
"echo \"$selfcnf\" > \"$DIR/CA/self.cnf.server\" || exit 1\n"
"echo \"$selfcnf\" | sed -e 's/ server/ client/g' \\\n"
"	> \"$DIR/CA/self.cnf.client\" || exit 1\n"
"\n"
"cd \"$DIR\"	|| exit 1\n"
"\n"
"echo \"\"\n"
"echo \"----------------------------------------------------------------------\"\n"
"echo \"Generating your x11vnc CA (certificate authority) key and certificate:\"\n"
"echo \"\"\n"
"echo \"Please supply a passphrase and any other information you care to.\"\n"
"echo \"----------------------------------------------------------------------\"\n"
"echo \"\"\n"
"\n"
"\"$OPENSSL\" req -config \"$DIR/CA/ssl.cnf\" -new -x509 \\\n"
"	-keyout \"$DIR/CA/private/cakey.pem\" \\\n"
"	-out \"$DIR/CA/cacert.pem\"\n"
"\n"
"chmod go-rwx \"$DIR/CA/private/cakey.pem\"\n"
"\n"
"if [ $? != 0 ]; then\n"
"	echo \"openssl failed.\"\n"
"	exit 1\n"
"fi\n"
"\n"
"echo \"\"\n"
"echo \"----------------------------------------------------------------------\"\n"
"echo \"Your public x11vnc CA cert is:\"\n"
"echo \"\"\n"
"echo \"        $DIR/CA/cacert.pem\"\n"
"echo \"\"\n"
"echo \"   It may be copied to other applications, e.g. Web browser, Java\"\n"
"echo \"   Applet keystore, or stunnel cfg, to use to verify signed server\"\n"
"echo \"   or client certs, etc.\"\n"
"echo \"\"\n"
"echo \"Your private x11vnc CA key is:\"\n"
"echo \"\"\n"
"echo \"        $DIR/CA/private/cakey.pem\"\n"
"echo \"\"\n"
"echo \"   It will be used to sign server or client certs, keep it secret.\"\n"
"echo \"----------------------------------------------------------------------\"\n"
"echo \"\"\n"
"printf \"Press Enter to print the cacert.pem certificate to the screen: \"\n"
"read x\n"
"echo \"\"\n"
"cat \"$DIR/CA/cacert.pem\"\n"
;

char genCert[] = 
"#!/bin/sh\n"
"\n"
"direrror() {\n"
"	echo \"\"\n"
"	echo \"You need first to run:\"\n"
"	echo \"\"\n"
"	if echo \"$DIR\" | grep '/\\.vnc/certs' > /dev/null; then\n"
"		echo \"	x11vnc -sslGenCA\"\n"
"	else\n"
"		echo \"	x11vnc -sslGenCA $DIR\"\n"
"	fi\n"
"	echo \"\"\n"
"	echo \"to create the CA cert file and other needed config files and directories.\"\n"
"	echo \"\"\n"
"	echo \"Then you can run: x11vnc -sslGenCert $type $name0\"\n"
"	echo \"\"\n"
"	if [ \"X$1\" != \"X\" ]; then\n"
"		echo \"(missing file/dir: $1)\"\n"
"		echo \"\"\n"
"	fi\n"
"	exit 1\n"
"}\n"
"\n"
"make_HASH() {\n"
"	crt=\"$1\"\n"
"	remove=\"$2\"\n"
"	if [ ! -f \"$crt\" ]; then\n"
"		return\n"
"	fi\n"
"	dirhash=`dirname \"$crt\"`/HASH\n"
"	bashash=`basename \"$crt\"`\n"
"	if [ ! -d \"$dirhash\" ]; then\n"
"		return\n"
"	fi\n"
"	hash=`\"$OPENSSL\" x509 -hash -noout -in \"$crt\" 2>/dev/null | head -1`\n"
"	if [ \"X$hash\" != \"X\" ]; then\n"
"		for i in 0 1 2 3 4 5 6 7 8 9\n"
"		do\n"
"			lnk=\"$dirhash/$hash.$i\"\n"
"			if [ \"X$remove\" = \"X1\" ]; then\n"
"				if [ -h \"$lnk\" ]; then\n"
"					if cmp \"$lnk\" \"$crt\" > /dev/null 2>&1; then\n"
"						ls -l \"$lnk\"\n"
"						rm -i \"$lnk\"\n"
"					fi\n"
"				fi\n"
"			else\n"
"				if [ -h \"$lnk\" ]; then\n"
"					if [ ! -f \"$lnk\" ]; then\n"
"						rm -f \"$lnk\" 1>/dev/null 2>&1\n"
"					else\n"
"						continue\n"
"					fi\n"
"				fi\n"
"				if [ \"x$HASH_verbose\" = \"x1\" ]; then\n"
"					echo \"creating: $lnk -> ../$bashash\"\n"
"				fi\n"
"				ln -s \"../$bashash\" \"$lnk\"\n"
"				break\n"
"			fi\n"
"		done\n"
"	fi\n"
"}\n"
"\n"
"create_key() {\n"
"	\n"
"	echo \"----------------------------------------------------------------------\"\n"
"	echo \"Creating new x11vnc certificate and key for name: $type $name0\"\n"
"	echo \"\"\n"
"\n"
"	cnf=\"$DIR/tmp/cnf.$$\"\n"
"	trap \"rm -f \\\"$cnf\\\"\" 0 1 2 15\n"
"\n"
"	rm -f \"$DIR/$dest.key\" \"$DIR/$dest.crt\" \"$DIR/$dest.req\"\n"
"\n"
"	if [ \"x$self\" = \"x1\" ]; then\n"
"		if [ ! -f \"$DIR/CA/self.cnf.$type\" ]; then\n"
"			direrror \"$DIR/CA/self.cnf.$type\"\n"
"		fi\n"
"		cat \"$DIR/CA/self.cnf.$type\" | sed -e \"s/%NAME/$name0/\" > \"$cnf\" || exit 1\n"
"		\"$OPENSSL\" req -config \"$cnf\" -nodes -new -newkey rsa:2048 -x509 \\\n"
"			-keyout \"$DIR/$dest.key\" \\\n"
"			-out    \"$DIR/$dest.crt\"\n"
"	else\n"
"		if [ ! -f \"$DIR/CA/ssl.cnf.$type\" ]; then\n"
"			direrror \"$DIR/CA/ssl.cnf.$type\"\n"
"		fi\n"
"		cat \"$DIR/CA/ssl.cnf.$type\" | sed  -e \"s/%NAME/$name0/\" > \"$cnf\" || exit 1\n"
"		\"$OPENSSL\" req -config \"$cnf\" -nodes -new -newkey rsa:2048 \\\n"
"			-keyout \"$DIR/$dest.key\" \\\n"
"			-out    \"$DIR/$dest.req\"\n"
"	fi\n"
"	rc=$?\n"
"	if [ -f \"$DIR/$dest.key\" ]; then\n"
"		chmod go-rwx \"$DIR/$dest.key\"\n"
"	fi\n"
"\n"
"\n"
"\n"
"	if [ $rc != 0 ]; then\n"
"		echo \"openssl 'req' command failed\"\n"
"		rm -f \"$DIR/$dest.key\" \"$DIR/$dest.crt\" \"$DIR/$dest.req\"\n"
"		exit 1\n"
"	fi\n"
"}\n"
"\n"
"enc_key() {\n"
"	\n"
"	echo \"\"\n"
"	echo \"----------------------------------------------------------------------\"\n"
"	echo \"Do you want to protect the generated private key with a passphrase?\"\n"
"	echo \"Doing so will significantly decrease the chances someone could steal\"\n"
"	if [ \"x$type\" = \"xserver\" ]; then\n"
"	echo \"the key and pretend to be your x11vnc server.  The downside is it is\"\n"
"	else\n"
"	echo \"the key and pretend to be your VNC client.  The downside is it is\"\n"
"	fi\n"
"	echo \"inconvenient because you will have to supply the passphrase every\"\n"
"	if [ \"x$type\" = \"xserver\" ]; then\n"
"	echo \"time you start x11vnc using this key.\"\n"
"	else\n"
"	echo \"time you start the VNC viewer SSL tunnel using this key.\"\n"
"	fi\n"
"	echo \"\"\n"
"	printf \"Protect key with a passphrase?  [y]/n \"\n"
"	read x\n"
"	estr=\" *unencrypted*\"\n"
"	if [ \"x$ENCRYPT_ONLY\" != \"x\" ]; then\n"
"		target=\"$ENCRYPT_ONLY\"\n"
"	else\n"
"		target=\"$DIR/$dest.key\"\n"
"		bdir=`dirname \"$DIR/$dest.key\"`\n"
"		if [ ! -d \"$bdir\" ]; then\n"
"			direrror \"$bdir\"\n"
"		fi\n"
"	fi\n"
"	if [ \"x$x\" != \"xn\" ]; then\n"
"		\"$OPENSSL\" rsa -in \"$target\" -des3 -out \"$target\"\n"
"		if [ $? != 0 ]; then\n"
"			echo \"openssl 'rsa' command failed\"\n"
"			rm -f \"$DIR/$dest.key\" \"$DIR/$dest.crt\" \"$DIR/$dest.req\"\n"
"			exit 1\n"
"		fi\n"
"		estr=\" encrypted\"\n"
"	fi\n"
"	echo \"\"\n"
"}\n"
"\n"
"sign_key() {\n"
"	cd \"$DIR\" || exit 1\n"
"\n"
"	if [ \"x$self\" = \"x1\" ]; then\n"
"		:\n"
"	else\n"
"		if echo \"$name0\" | grep '^req:' > /dev/null; then\n"
"			echo \"\"\n"
"			echo \"----------------------------------------------------------------------\"\n"
"			echo \"Your x11vnc $type certificate request is:\"\n"
"			echo \"\"\n"
"			echo \"        $DIR/$dest.req\"\n"
"			echo \"\"\n"
"			echo \"   It may be sent to an external CA for signing, afterward you can\"\n"
"			echo \"   save the cert they send you in:\"\n"
"			echo \"\"\n"
"			echo \"        $DIR/$dest.crt\"\n"
"			echo \"\"\n"
"			echo \"Your$estr private x11vnc $type key is:\"\n"
"			echo \"\"\n"
"			echo \"        $DIR/$dest.key\"\n"
"			echo \"\"\n"
"			echo \"   You should combine it and the received cert in the file:\"\n"
"			echo \"\"\n"
"			echo \"        $DIR/$dest.pem\"\n"
"			echo \"\"\n"
"			echo \"   It will be needed by applications to identify themselves.\"\n"
"			echo \"   This file should be kept secret.\"\n"
"			echo \"----------------------------------------------------------------------\"\n"
"			echo \"\"\n"
"			printf \"Press Enter to print the $dest.req cert request to the screen: \"\n"
"			read x\n"
"			echo \"\"\n"
"			cat \"$DIR/$dest.req\"\n"
"			exit 0\n"
"		fi\n"
"		echo \"\"\n"
"		echo \"\"\n"
"		echo \"----------------------------------------------------------------------\"\n"
"		echo \"Now signing the new key with CA private key.  You will need to supply\"\n"
"		echo \"the CA key passphrase and reply \\\"y\\\" to sign and commit the key.\"\n"
"		echo \"\"\n"
"		\"$OPENSSL\" ca -config \"$cnf\" -policy policy_anything -notext \\\n"
"			-in  \"$DIR/$dest.req\" \\\n"
"			-out \"$DIR/$dest.crt\"\n"
"		if [ $? != 0 ]; then\n"
"			echo \"\"\n"
"			echo \"openssl 'ca' command failed\"\n"
"			echo \"\"\n"
"			echo \"  You may have a duplicate DN entry for this name in:\"\n"
"			echo \"\"\n"
"			echo \"          $DIR/CA/index.txt\"\n"
"			echo \"\"\n"
"			echo \"  remove the duplicate in that file and try again.\"\n"
"			echo \"\"\n"
"			rm -f \"$DIR/$dest.key\" \"$DIR/$dest.crt\" \"$DIR/$dest.req\"\n"
"			exit 1\n"
"		fi\n"
"	fi\n"
"\n"
"	cat  \"$DIR/$dest.key\"  \"$DIR/$dest.crt\" \\\n"
"		> \"$DIR/$dest.pem\" || exit 1 \n"
"\n"
"	make_HASH \"$DIR/$dest.crt\" 0\n"
"\n"
"	rm -f \"$DIR/$dest.key\" \"$DIR/$dest.req\" || exit 1\n"
"	chmod go-rwx \"$DIR/$dest.pem\" || exit 1\n"
"\n"
"	if [ \"x$type\" = \"xserver\" -o \"x$type\" = \"xclient\" ]; then\n"
"		echo \"\"\n"
"		echo \"----------------------------------------------------------------------\"\n"
"		echo \"Your public x11vnc $type cert is:\"\n"
"		echo \"\"\n"
"		echo \"        $DIR/$dest.crt\"\n"
"		echo \"\"\n"
"		echo \"   It may be copied to other machines / applications to be used for\"\n"
"		echo \"   authentication.  However, since it is signed with the x11vnc CA\"\n"
"		echo \"   key, all the applications need is the x11vnc CA certificate.\"\n"
"		echo \"\"\n"
"		echo \"Your$estr private x11vnc $type key is:\"\n"
"		echo \"\"\n"
"		echo \"        $DIR/$dest.pem\"\n"
"		echo \"\"\n"
"		echo \"   It will be needed by applications to identify themselves.\"\n"
"		echo \"   This file should be kept secret.\"\n"
"		echo \"----------------------------------------------------------------------\"\n"
"		echo \"\"\n"
"	fi\n"
"\n"
"	printf \"Press Enter to print the $dest.crt certificate to the screen: \"\n"
"	read x\n"
"	echo \"\"\n"
"	cat \"$DIR/$dest.crt\"\n"
"}\n"
"\n"
"DIR=$BASE_DIR\n"
"if [ \"x$DIR\" = \"x\" ]; then\n"
"        DIR=\"$HOME/dotkjr_vnc/certs\"\n"
"fi\n"
"if echo \"$DIR\" | grep '^/' > /dev/null; then\n"
"	:\n"
"else\n"
"	DIR=\"`pwd`/$DIR\"\n"
"fi\n"
"\n"
"if [ \"x$HASHON\" != \"x\" ]; then\n"
"	for dir in \"$DIR/HASH\" \"$DIR/clients/HASH\"\n"
"	do\n"
"		if [ -d \"$dir\" ]; then\n"
"			rm -rf \"$dir\"\n"
"		fi\n"
"	done\n"
"	dir=\"$DIR/HASH\"\n"
"	mkdir -p \"$dir\" || exit 1\n"
"	dir=\"$DIR/clients/HASH\"\n"
"	mkdir -p \"$dir\" || exit 1\n"
"	HASH_verbose=1\n"
"	for f in \"$DIR\"/*.crt \"$DIR\"/clients/*.crt\n"
"	do\n"
"		if [ -f \"$f\" ]; then\n"
"			make_HASH \"$f\" 0\n"
"		fi\n"
"	done\n"
"	exit\n"
"fi\n"
"if [ \"x$HASHOFF\" != \"x\" ]; then\n"
"	dir=\"$DIR/HASH\"\n"
"	for dir in \"$DIR/HASH\" \"$DIR/clients/HASH\"\n"
"	do\n"
"		if [ -d \"$dir\" ]; then\n"
"			for f in \"$dir\"/*\n"
"			do\n"
"				if [ -f \"$f\" ]; then\n"
"					echo \"deleting: $f\"\n"
"					rm -f \"$f\"\n"
"				fi\n"
"			done\n"
"			rm -rf \"$dir\"\n"
"		fi\n"
"	done\n"
"	exit\n"
"fi\n"
"\n"
"PATH=/usr/bin:/bin:/usr/sbin:$PATH; export PATH\n"
"if [ \"x$OPENSSL\" = \"x\" ]; then\n"
"        OPENSSL=\"openssl\"\n"
"fi\n"
"\n"
"type \"$OPENSSL\" > /dev/null	|| exit 1\n"
"\n"
"self=\"\"\n"
"if [ \"x$SELF\" != \"x\" ]; then\n"
"	self=1\n"
"elif [ \"x$1\" = \"x-self\" ]; then\n"
"	shift\n"
"	self=1\n"
"fi\n"
"\n"
"if [ \"x$TYPE\" != \"x\" ]; then\n"
"	type=\"$TYPE\"\n"
"else\n"
"	if [ \"X$1\" != \"X\" ]; then\n"
"		type=\"$1\"\n"
"		shift\n"
"	fi\n"
"fi\n"
"if [ \"x$NAME\" != \"x\" ]; then\n"
"	name=\"$NAME\"\n"
"else\n"
"	if [ \"X$1\" != \"X\" ]; then\n"
"		name=\"$1\"\n"
"		shift\n"
"	fi\n"
"fi\n"
"\n"
"if echo \"$name\" | grep '^self:' > /dev/null; then\n"
"	self=1\n"
"fi\n"
"\n"
"if [ \"x$type\" = \"xserver\" ]; then\n"
"	name0=\"$name\"\n"
"	if echo \"$name\" | grep '^-' > /dev/null; then\n"
"		:\n"
"	elif [ \"x$name\" != \"x\" ]; then\n"
"		name=\"-$name\";\n"
"	fi\n"
"	dest=\"server$name\"\n"
"elif [ \"x$type\" = \"xclient\" ]; then\n"
"	if [ \"x$name\" = \"x\" ]; then\n"
"		name=\"nobody\"\n"
"	fi\n"
"	name0=\"$name\"\n"
"	dest=\"clients/$name\"\n"
"else\n"
"	exit 1\n"
"fi\n"
"\n"
"#set -xv\n"
"\n"
"if [ \"x$INFO_ONLY\" != \"x\" ]; then\n"
"	echo \"\"\n"
"	echo \"VNC Certificate file:\"\n"
"	echo \"	$INFO_ONLY\"\n"
"	echo \"\"\n"
"	\"$OPENSSL\" x509 -text -in \"$INFO_ONLY\"\n"
"	exit \n"
"elif [ \"x$DELETE_ONLY\" != \"x\" ]; then\n"
"	echo \"\"\n"
"	echo \"VNC Certificate file:\"\n"
"	echo \"	$DELETE_ONLY\"\n"
"	echo \"\"\n"
"	\n"
"	base=`echo \"$DELETE_ONLY\" | sed -e 's/\\....$//'`\n"
"	for suff in crt pem key req\n"
"	do\n"
"		try=\"$base.$suff\"\n"
"		if [ -f \"$try\" ]; then\n"
"			make_HASH \"$try\" 1\n"
"			rm -i \"$try\"\n"
"		fi\n"
"	done\n"
"	if echo \"$base\" | grep 'CA/cacert$' > /dev/null; then\n"
"		base2=`echo \"$base\" | sed -e 's,cacert$,private/cakey,'`\n"
"	else\n"
"		echo \"\"\n"
"		exit\n"
"	fi\n"
"	echo \"\"\n"
"	for suff in crt pem key req\n"
"	do\n"
"		try=\"$base2.$suff\"\n"
"		if [ -f \"$try\" ]; then\n"
"			make_HASH \"$try\" 1\n"
"			rm -i \"$try\"\n"
"		fi\n"
"	done\n"
"	echo \"\"\n"
"	exit \n"
"elif [ \"x$ENCRYPT_ONLY\" != \"x\" ]; then\n"
"	if [ \"x$type\" = \"x\" ]; then\n"
"		type=\"server\"\n"
"	fi\n"
"	echo \"\"\n"
"	echo \"Key PEM file:\"\n"
"	echo \"	$ENCRYPT_ONLY\"\n"
"	enc_key\n"
"	exit\n"
"fi\n"
"\n"
"if [ ! -d \"$DIR/tmp\" ]; then\n"
"	direrror \"$DIR/tmp\"\n"
"fi\n"
"bdir=`dirname \"$DIR/$dest.key\"`\n"
"if [ ! -d \"$bdir\" ]; then\n"
"	direrror \"$bdir\"\n"
"fi\n"
"if [ ! -f \"$DIR/CA/cacert.pem\" ]; then\n"
"	direrror \"$DIR/CA/cacert.pem\"\n"
"fi\n"
"\n"
"create_key\n"
"enc_key\n"
"sign_key\n"
;

#endif /* _SSLTOOLS_H */
