/* -- help.c -- */

#include "x11vnc.h"
#include "xdamage.h"
#include "cursor.h"

/*
 * text printed out under -help option
 */

void print_help(int mode);
void print_license(void);
void xopen_display_fail_message(char *disp);
void nopassword_warning_msg(int gotloc);


void print_help(int mode) {
#if !SKIP_HELP
	char help[] = 
"\n"
"x11vnc: allow VNC connections to real X11 displays. %s\n"
"\n"
"(type \"x11vnc -opts\" to just list the options.)\n"
"\n"
"Typical usage is:\n"
"\n"
"   Run this command in a shell on the remote machine \"far-host\"\n"
"   with X session you wish to view:\n"
"\n"
"       x11vnc -display :0\n"
"\n"
"   Then run this in another window on the machine you are sitting at:\n"
"\n"
"       vncviewer far-host:0\n"
"\n"
"Once x11vnc establishes connections with the X11 server and starts listening\n"
"as a VNC server it will print out a string: PORT=XXXX where XXXX is typically\n"
"5900 (the default VNC server port).  One would next run something like\n"
"this on the local machine: \"vncviewer hostname:N\" where \"hostname\" is\n"
"the name of the machine running x11vnc and N is XXXX - 5900, i.e. usually\n"
"\"vncviewer hostname:0\".\n"
"\n"
"By default x11vnc will not allow the screen to be shared and it will exit\n"
"as soon as the client disconnects.  See -shared and -forever below to override\n"
"these protections.  See the FAQ for details how to tunnel the VNC connection\n"
"through an encrypted channel such as ssh(1).  In brief:\n"
"\n"
"       ssh -t -L 5900:localhost:5900 far-host 'x11vnc -localhost -display :0'\n"
"\n"
"       vncviewer -encodings 'copyrect tight zrle hextile' localhost:0\n"
"\n"
"Also, use of a VNC password (-rfbauth or -passwdfile) is strongly recommended.\n"
"\n"
"For additional info see: http://www.karlrunge.com/x11vnc/\n"
"                    and  http://www.karlrunge.com/x11vnc/#faq\n"
"\n"
"\n"
"Config file support: if the file $HOME/.x11vncrc exists then each line in\n"
"it is treated as a single command line option.  Disable with -norc.  For\n"
"each option name, the leading character \"-\" is not required.  E.g. a line\n"
"that is either \"forever\" or \"-forever\" may be used and are equivalent.\n"
"Likewise \"wait 100\" or \"-wait 100\" are acceptable and equivalent lines.\n"
"The \"#\" character comments out to the end of the line in the usual way\n"
"(backslash it for a literal).  Leading and trailing whitespace is trimmed off.\n"
"Lines may be continued with a \"\\\" as the last character of a line (it\n"
"becomes a space character).\n"
"\n"
"Options:\n"
"\n"
"-display disp          X11 server display to connect to, usually :0.  The X\n"
"                       server process must be running on same machine and\n"
"                       support MIT-SHM.  Equivalent to setting the DISPLAY\n"
"                       environment variable to \"disp\".\n"
"\n"
"                       See the description below of the \"-display WAIT:...\"\n"
"                       extensions, where alias \"-find\" will find the user's\n"
"                       display automatically, and \"-create\" will create a\n"
"                       Xvfb session if no session is found.\n"
"\n"
"-auth file             Set the X authority file to be \"file\", equivalent to\n"
"                       setting the XAUTHORITY environment variable to \"file\"\n"
"                       before startup.  Same as -xauth file.  See Xsecurity(7),\n"
"                       xauth(1) man pages for more info.\n"
"\n"
"-N                     If the X display is :N, try to set the VNC display\n"
"                       to also be :N  This just sets the -rfbport option\n"
"                       to 5900+N.  The program will exit immediately if that\n"
"                       port is not available.\n"
"\n"
"-reflect host:N        Instead of connecting to and polling an X display,\n"
"                       connect to the remote VNC server host:N and be a\n"
"                       reflector/repeater for it.  This is useful for trying\n"
"                       to manage the case of many simultaneous VNC viewers\n"
"                       (e.g. classroom broadcasting) where, e.g. you put\n"
"                       a repeater on each network switch, etc, to improve\n"
"                       performance by distributing the load and network\n"
"                       traffic.  Implies -shared (use -noshared as a later\n"
"                       option to disable). See the discussion below under\n"
"                       -rawfb vnc:host:N for more details.\n"
"\n"
"-id windowid           Show the X window corresponding to \"windowid\" not\n"
"                       the entire display.  New windows like popup menus,\n"
"                       transient toplevels, etc, may not be seen or may be\n"
"                       clipped.  Disabling SaveUnders or BackingStore in the\n"
"                       X server may help show them.  x11vnc may crash if the\n"
"                       window is initially partially obscured, changes size,\n"
"                       is iconified, etc.  Some steps are taken to avoid this\n"
"                       and the -xrandr mechanism is used to track resizes.  Use\n"
"                       xwininfo(1) to get the window id, or use \"-id pick\"\n"
"                       to have x11vnc run xwininfo(1) for you and extract\n"
"                       the id.  The -id option is useful for exporting very\n"
"                       simple applications (e.g. the current view on a webcam).\n"
"-sid windowid          As -id, but instead of using the window directly it\n"
"                       shifts a root view to it: this shows SaveUnders menus,\n"
"                       etc, although they will be clipped if they extend beyond\n"
"                       the window.\n"
"-clip WxH+X+Y          Only show the sub-region of the full display that\n"
"                       corresponds to the rectangle geometry with size WxH and\n"
"                       offset +X+Y.  The VNC display has size WxH (i.e. smaller\n"
"                       than the full display).  This also works for -id/-sid\n"
"                       mode where the offset is relative to the upper left\n"
"                       corner of the selected window.  An example use of this\n"
"                       option would be to split a large (e.g. Xinerama) display\n"
"                       into two parts to be accessed via separate viewers by\n"
"                       running a separate x11vnc on each part.\n"
"\n"
"-flashcmap             In 8bpp indexed color, let the installed colormap flash\n"
"                       as the pointer moves from window to window (slow).\n"
"                       Also try the -8to24 option to avoid flash altogether.\n"
"-shiftcmap n           Rare problem, but some 8bpp displays use less than 256\n"
"                       colorcells (e.g. 16-color grayscale, perhaps the other\n"
"                       bits are used for double buffering) *and* also need to\n"
"                       shift the pixels values away from 0, .., ncells.  \"n\"\n"
"                       indicates the shift to be applied to the pixel values.\n"
"                       To see the pixel values set DEBUG_CMAP=1 to print out\n"
"                       a colormap histogram.  Example: -shiftcmap 240\n"
"-notruecolor           For 8bpp displays, force indexed color (i.e. a colormap)\n"
"                       even if it looks like 8bpp TrueColor (rare problem).\n"
"-visual n              This option probably does not do what you think.\n"
"                       It simply *forces* the visual used for the framebuffer;\n"
"                       this may be a bad thing... (e.g. messes up colors or\n"
"                       cause a crash). It is useful for testing and for some\n"
"                       workarounds.  n may be a decimal number, or 0x hex.\n"
"                       Run xdpyinfo(1) for the values.  One may also use\n"
"                       \"TrueColor\", etc. see <X11/X.h> for a list.  If the\n"
"                       string ends in \":m\" then for better or for worse the\n"
"                       visual depth is forced to be m.\n"
"\n"
"-overlay               Handle multiple depth visuals on one screen, e.g. 8+24\n"
"                       and 24+8 overlay visuals (the 32 bits per pixel are\n"
"                       packed with 8 for PseudoColor and 24 for TrueColor).\n"
"\n"
"                       Currently -overlay only works on Solaris via\n"
"                       XReadScreen(3X11) and IRIX using XReadDisplay(3).\n"
"                       On Solaris there is a problem with image \"bleeding\"\n"
"                       around transient popup menus (but not for the menu\n"
"                       itself): a workaround is to disable SaveUnders\n"
"                       by passing the \"-su\" argument to Xsun (in\n"
"                       /etc/dt/config/Xservers).\n"
"\n"
"                       Use -overlay as a workaround for situations like these:\n"
"                       Some legacy applications require the default visual to\n"
"                       be 8bpp (8+24), or they will use 8bpp PseudoColor even\n"
"                       when the default visual is depth 24 TrueColor (24+8).\n"
"                       In these cases colors in some windows will be incorrect\n"
"                       in x11vnc unless -overlay is used.  Another use of\n"
"                       -overlay is to enable showing the exact mouse cursor\n"
"                       shape (details below).\n"
"\n"
"                       Under -overlay, performance will be somewhat slower\n"
"                       due to the extra image transformations required.\n"
"                       For optimal performance do not use -overlay, but rather\n"
"                       configure the X server so that the default visual is\n"
"                       depth 24 TrueColor and try to have all apps use that\n"
"                       visual (e.g. some apps have -use24 or -visual options).\n"
"-overlay_nocursor      Sets -overlay, but does not try to draw the exact mouse\n"
"                       cursor shape using the overlay mechanism.\n"
"\n"
"-8to24 [opts]          Try this option if -overlay is not supported on your\n"
"                       OS, and you have a legacy 8bpp app that you want to\n"
"                       view on a multi-depth display with default depth 24\n"
"                       (and is 32 bpp) OR have a default depth 8 display with\n"
"                       depth 24 overlay windows for some apps.  This option\n"
"                       may not work on all X servers and hardware (tested\n"
"                       on XFree86/Xorg mga driver and Xsun).  The \"opts\"\n"
"                       string is not required and is described below.\n"
"\n"
"                       This mode enables a hack where x11vnc monitors windows\n"
"                       within 3 levels from the root window.  If it finds\n"
"                       any that are 8bpp it extracts the indexed color\n"
"                       pixel values using XGetImage() and then applies a\n"
"                       transformation using the colormap(s) to create TrueColor\n"
"                       RGB values that it in turn inserts into bits 1-24 of\n"
"                       the framebuffer.  This creates a depth 24 \"view\"\n"
"                       of the display that is then exported via VNC.\n"
"\n"
"                       Conversely, for default depth 8 displays, the depth\n"
"                       24 regions are read by XGetImage() and everything is\n"
"                       transformed and inserted into a depth 24 TrueColor\n"
"                       framebuffer.\n"
"\n"
"                       Note that even if there are *no* depth 24 visuals or\n"
"                       windows (i.e. pure 8bpp), this mode is potentially\n"
"                       an improvement over -flashcmap because it avoids the\n"
"                       flashing and shows each window in the correct color.\n"
"\n"
"                       This method appear to work, but may still have bugs\n"
"                       and it does hog resources.  If there are multiple 8bpp\n"
"                       windows using different colormaps, one may have to\n"
"                       iconify all but one for the colors to be correct.\n"
"\n"
"                       There may be painting errors for clipping and switching\n"
"                       between windows of depths 8 and 24.  Heuristics are\n"
"                       applied to try to minimize the painting errors.  One can\n"
"                       also press 3 Alt_L's in a row to refresh the screen\n"
"                       if the error does not repair itself.  Also the option\n"
"                       -fixscreen 8=3.0 or -fixscreen V=3.0 may be used to\n"
"                       periodically refresh the screen at the cost of bandwidth\n"
"                       (every 3 sec for this example).\n"
"\n"
"                       The [opts] string can contain the following settings.\n"
"                       Multiple settings are separated by commas.\n"
"\n"
"                       For for some X servers with default depth 24 a\n"
"                       speedup may be achieved via the option \"nogetimage\".\n"
"                       This enables a scheme were XGetImage() is not used\n"
"                       to retrieve the 8bpp data.  Instead, it assumes that\n"
"                       the 8bpp data is in bits 25-32 of the 32bit X pixels.\n"
"                       There is no requirement that the X server should put\n"
"                       the data there for our poll requests, but some do and\n"
"                       so the extra steps to retrieve it can be skipped.\n"
"                       Tested with mga driver with XFree86/Xorg.  For the\n"
"                       default depth 8 case this option is ignored.\n"
"\n"
"                       To adjust how often XGetImage() is used to poll the\n"
"                       non-default visual regions for changes, use the option\n"
"                       \"poll=t\" where \"t\" is a floating point time.\n"
"                       (default: %.2f)\n"
"\n"
"                       Setting the option \"level2\" will limit the search\n"
"                       for non-default visual windows to two levels from the\n"
"                       root window.  Do this on slow machines where you know\n"
"                       the window manager only imposes one extra window between\n"
"                       the app window and the root window.\n"
"\n"
"                       Also for very slow machines use \"cachewin=t\"\n"
"                       where t is a floating point amount of time to cache\n"
"                       XGetWindowAttributes results.  E.g. cachewin=5.0.\n"
"                       This may lead to the windows being unnoticed for this\n"
"                       amount of time when deiconifying, painting errors, etc.\n"
"\n"
"                       While testing on a very old SS20 these options gave\n"
"                       tolerable response: -8to24 poll=0.2,cachewin=5.0. For\n"
"                       this machine -overlay is supported and gives better\n"
"                       response.\n"
"\n"
"                       Debugging for this mode can be enabled by setting\n"
"                       \"dbg=1\", \"dbg=2\", or \"dbg=3\".\n"
"\n"
"-24to32                Very rare problem: if the framebuffer (X display\n"
"                       or -rawfb) is 24bpp instead of the usual 32bpp, then\n"
"                       dynamically transform the pixels to 32bpp.  This will be\n"
"                       slower, but can be used to work around problems where\n"
"                       VNC viewers cannot handle 24bpp (e.g. \"main: setPF:\n"
"                       not 8, 16 or 32 bpp?\").  See the FAQ for more info.\n"
"\n"
"                       In the case of -rawfb mode, the pixels are directly\n"
"                       modified by inserting a 0 byte to pad them out to 32bpp.\n"
"                       For X displays, a kludge is done that is equivalent to\n"
"                       \"-noshm -visual TrueColor:32\".  (If better performance\n"
"                       is needed for the latter, feel free to ask).\n"
"\n"
"-scale fraction        Scale the framebuffer by factor \"fraction\".  Values\n"
"                       less than 1 shrink the fb, larger ones expand it.  Note:\n"
"                       image may not be sharp and response may be slower.\n"
"                       If \"fraction\" contains a decimal point \".\" it\n"
"                       is taken as a floating point number, alternatively\n"
"                       the notation \"m/n\" may be used to denote fractions\n"
"                       exactly, e.g. -scale 2/3\n"
"\n"
"                       Scaling Options: can be added after \"fraction\" via\n"
"                       \":\", to supply multiple \":\" options use commas.\n"
"                       If you just want a quick, rough scaling without\n"
"                       blending, append \":nb\" to \"fraction\" (e.g. -scale\n"
"                       1/3:nb).  No blending is the default for 8bpp indexed\n"
"                       color, to force blending for this case use \":fb\".\n"
"\n"
"                       To disable -scrollcopyrect and -wirecopyrect under\n"
"                       -scale use \":nocr\".  If you need to to enable them use\n"
"                       \":cr\" or specify them explicitly on the command line.\n"
"                       If a slow link is detected, \":nocr\" may be applied\n"
"                       automatically.  Default: %s\n"
"\n"
"                       More esoteric options: for compatibility with vncviewers\n"
"                       the scaled width is adjusted to be a multiple of 4:\n"
"                       to disable this use \":n4\".  \":in\" use interpolation\n"
"                       scheme even when shrinking, \":pad\" pad scaled width\n"
"                       and height to be multiples of scaling denominator\n"
"                       (e.g. 3 for 2/3).\n"
"\n"
"-scale_cursor frac     By default if -scale is supplied the cursor shape is\n"
"                       scaled by the same factor.  Depending on your usage,\n"
"                       you may want to scale the cursor independently of the\n"
"                       screen or not at all.  If you specify -scale_cursor\n"
"                       the cursor will be scaled by that factor.  When using\n"
"                       -scale mode to keep the cursor at its \"natural\" size\n"
"                       use \"-scale_cursor 1\".  Most of the \":\" scaling\n"
"                       options apply here as well.\n"
"\n"
"-viewonly              All VNC clients can only watch (default %s).\n"
"-shared                VNC display is shared, i.e. more than one viewer can\n"
"                       connect at the same time (default %s).\n"
"-once                  Exit after the first successfully connected viewer\n"
"                       disconnects, opposite of -forever. This is the Default.\n"
"-forever               Keep listening for more connections rather than exiting\n"
"                       as soon as the first client(s) disconnect. Same as -many\n"
"\n"
"-loop                  Create an outer loop restarting the x11vnc process\n"
"                       whenever it terminates.  -bg and -inetd are ignored\n"
"                       in this mode (however see -loopbg below).\n"
"\n"
"                       Useful for continuing even if the X server terminates\n"
"                       and restarts (at that moment the process will need\n"
"                       permission to reconnect to the new X server of course).\n"
"\n"
"                       Use, e.g., -loop100 to sleep 100 millisecs between\n"
"                       restarts, etc.  Default is 2000ms (i.e. 2 secs) Use,\n"
"                       e.g. -loop300,5 to sleep 300 ms and only loop 5 times.\n"
"\n"
"                       If -loopbg (plus any numbers) is specified instead,\n"
"                       the \"-bg\" option is implied and the mode approximates\n"
"                       inetd(8) usage to some degree.  In this case when\n"
"                       it goes into the background any listening sockets\n"
"                       (i.e. ports 5900, 5800) are closed, so the next one\n"
"                       in the loop can use them.  This mode will only be of\n"
"                       use if a VNC client (the only client for that process)\n"
"                       is already connected before the process goes into the\n"
"                       background, for example, usage of -display WAIT:..,\n"
"                       -svc, and -connect can make use of this \"poor man's\"\n"
"                       inetd mode.  The default wait time is 500ms in this\n"
"                       mode.  This usage could use useful:  -svc -loopbg\n"
"\n"
"-timeout n             Exit unless a client connects within the first n seconds\n"
"                       after startup.\n"
"-sleepin n             At startup sleep n seconds before proceeding (e.g. to\n"
"                       allow redirs and listening clients to start up)\n"
"\n"
"-inetd                 Launched by inetd(8): stdio instead of listening socket.\n"
"                       Note: if you are not redirecting stderr to a log file\n"
"                       (via shell 2> or -o option) you MUST also specify the -q\n"
"                       option, otherwise the stderr goes to the viewer which\n"
"                       will cause it to abort.  Specifying both -inetd and -q\n"
"                       and no -o will automatically close the stderr.\n"
"\n"
"-tightfilexfer         Enable the TightVNC file transfer extension. Note that\n"
"                       that when the -viewonly option is supplied all file\n"
"                       transfers are disabled.  Also clients that log in\n"
"                       viewonly cannot transfer files.  However, if the remote\n"
"                       control mechanism is used to change the global or\n"
"                       per-client viewonly state the filetransfer permissions\n"
"                       will NOT change.\n"
"\n"
"                       IMPORTANT: please understand if -tightfilexfer is\n"
"                       specified and you run x11vnc as root for, say, inetd\n"
"                       or display manager (gdm, kdm, ...) access and you do\n"
"                       not have it switch users via the -users option, then\n"
"                       VNC Viewers that connect are able to do filetransfer\n"
"                       reads and writes as *root*.\n"
"\n"
"                       Also, tightfilexfer is disabled in -unixpw mode.\n"
"\n"
"-ultrafilexfer         Note: to enable UltraVNC filetransfer and to get it to\n"
"                       work you probably need to supply these libvncserver\n"
"                       options: \"-rfbversion 3.6 -permitfiletransfer\"\n"
"                       \"-ultrafilexfer\" is an alias for this combination.\n"
"\n"
"                       IMPORTANT: please understand if -ultrafilexfer is\n"
"                       specified and you run x11vnc as root for, say, inetd\n"
"                       or display manager (gdm, kdm, ...) access and you do\n"
"                       not have it switch users via the -users option, then\n"
"                       VNC Viewers that connect are able to do filetransfer\n"
"                       reads and writes as *root*.\n"
"\n"
"                       Note that sadly you cannot do both -tightfilexfer and\n"
"                       -ultrafilexfer at the same time because the latter\n"
"                       requires setting the version to 3.6 and tightvnc will\n"
"                       not do filetransfer when it sees that version number.\n"
"\n"
"-http                  Instead of using -httpdir (see below) to specify\n"
"                       where the Java vncviewer applet is, have x11vnc try\n"
"                       to *guess* where the directory is by looking relative\n"
"                       to the program location and in standard locations\n"
"                       (/usr/local/share/x11vnc/classes, etc).  Under -ssl or\n"
"                       -stunnel the ssl classes subdirectory is sought.\n"
#ifndef NO_SSL_OR_UNIXPW
"-http_ssl              As -http, but force lookup for ssl classes subdir.\n"
#endif
"\n"
"-avahi                 Use the Avahi/mDNS ZeroConf protocol to advertize\n"
"                       this VNC server to the local network. (Related terms:\n"
"                       Rendezvous, Bonjour).  Depending on your setup, you\n"
"                       may need to start avahi-daemon and open udp port 5353\n"
"                       in your firewall.\n"
"-mdns                  Same as -avahi.\n"
"\n"
"-connect string        For use with \"vncviewer -listen\" reverse connections.\n"
"                       If \"string\" has the form \"host\" or \"host:port\"\n"
"                       the connection is made once at startup.  Use commas\n"
"                       for a list of host's and host:port's.\n"
"\n"
"                       Note that unlike most vnc servers, x11vnc will require a\n"
"                       password for reverse as well as for forward connections.\n"
"                       (provided password auth has been enabled, -rfbauth, etc)\n"
"                       If you do not want to require a password for reverse\n"
"                       connections set X11VNC_REVERSE_CONNECTION_NO_AUTH=1 in\n"
"                       your environment before starting x11vnc.\n"
"\n"
"                       If \"string\" contains \"/\" it is instead interpreted\n"
"                       as a file to periodically check for new hosts.\n"
"                       The first line is read and then the file is truncated.\n"
"                       Be careful about the location of this file if x11vnc\n"
"                       is running as root (e.g. via gdm(1), etc).\n"
"\n"
"-connect_or_exit str   As with -connect, except if none of the reverse\n"
"                       connections succeed, then x11vnc shutdowns immediately.\n"
"\n"
"                       If you do not want x11vnc to listen on ANY interface\n"
"                       use -rfbport 0\n"
"\n"
"-vncconnect            Monitor the VNC_CONNECT X property set by the standard\n"
"-novncconnect          VNC program vncconnect(1).  When the property is\n"
"                       set to \"host\" or \"host:port\" establish a reverse\n"
"                       connection.  Using xprop(1) instead of vncconnect may\n"
"                       work (see the FAQ).  The -remote control mechanism uses\n"
"                       X11VNC_REMOTE channel, and this option disables/enables\n"
"                       it as well.  Default: %s\n"
"\n"
"-allow host1[,host2..] Only allow client connections from hosts matching\n"
"                       the comma separated list of hostnames or IP addresses.\n"
"                       Can also be a numerical IP prefix, e.g. \"192.168.100.\"\n"
"                       to match a simple subnet, for more control build\n"
"                       libvncserver with libwrap support (See the FAQ).  If the\n"
"                       list contains a \"/\" it instead is a interpreted as a\n"
"                       file containing addresses or prefixes that is re-read\n"
"                       each time a new client connects.  Lines can be commented\n"
"                       out with the \"#\" character in the usual way.\n"
"-localhost             Basically the same as \"-allow 127.0.0.1\".\n"
"\n"
"                       Note: if you want to restrict which network interface\n"
"                       x11vnc listens on, see the -listen option below.\n"
"                       E.g. \"-listen localhost\" or \"-listen 192.168.3.21\".\n"
"                       As a special case, the option \"-localhost\" implies\n"
"                       \"-listen localhost\".\n"
"\n"
"                       A rare case, but for non-localhost -listen usage, if\n"
"                       you use the remote control mechanism (-R) to change\n"
"                       the -listen interface you may need to manually adjust\n"
"                       the -allow list (and vice versa) to avoid situations\n"
"                       where no connections (or too many) are allowed.\n"
"\n"
"                       If you do not want x11vnc to listen on ANY interface\n"
"                       (evidently you are using -connect or -connect_or_exit,\n"
"                       or plan to use remote control: -R connect:host), use\n"
"                       -rfbport 0\n"
"\n"
"-nolookup              Do not use gethostbyname() or gethostbyaddr() to look up\n"
"                       host names or IP numbers.  Use this if name resolution\n"
"                       is incorrectly set up and leads to long pauses as name\n"
"                       lookups time out, etc.\n"
"\n"
"-input string          Fine tuning of allowed user input.  If \"string\" does\n"
"                       not contain a comma \",\" the tuning applies only to\n"
"                       normal clients.  Otherwise the part before \",\" is\n"
"                       for normal clients and the part after for view-only\n"
"                       clients.  \"K\" is for Keystroke input, \"M\" for\n"
"                       Mouse-motion input, \"B\" for Button-click input, \"C\"\n"
"                       is for Clipboard input, and \"F\" is for File transfer\n"
"                       (ultravnc only).  Their presence in the string enables\n"
"                       that type of input.  E.g. \"-input M\" means normal\n"
"                       users can only move the mouse and  \"-input KMBCF,M\"\n"
"                       lets normal users do anything and enables view-only\n"
"                       users to move the mouse.  This option is ignored when\n"
"                       a global -viewonly is in effect (all input is discarded\n"
"                       in that case).\n"
"\n"
"-grabkbd               When VNC viewers are connected, attempt to the grab\n"
"                       the keyboard so a (non-malicious) user sitting at the\n"
"                       physical display is not able to enter keystrokes.\n"
"                       This method uses XGrabKeyboard(3X11) and so it is\n"
"                       not secure and does not rule out the person at the\n"
"                       physical display injecting keystrokes by flooding the\n"
"                       server with them, grabbing the keyboard himself, etc.\n"
"                       Some degree of cooperation from the person at the\n"
"                       display is assumed.  This is intended for remote\n"
"                       help-desk or educational usage modes.\n"
"-grabptr               As -grabkbd, but for the mouse pointer using\n"
"                       XGrabPointer(3X11).  Unfortunately due to the way the X\n"
"                       server works, the mouse can still be moved around by the\n"
"                       user at the physical display, but he will not be able to\n"
"                       change window focus with it.  Also some window managers\n"
"                       that call XGrabServer(3X11) for resizes, etc, will\n"
"                       act on the local user's input.  Again, some degree of\n"
"                       cooperation from the person at the display is assumed.\n"
"\n"
"-grabalways            Apply both -grabkbd and -grabptr even when no VNC\n"
"                       viewers are connected.  If you only want one of them,\n"
"                       use the -R remote control to turn the other back on,\n"
"                       e.g. -R nograbptr.\n"
"\n"
"-viewpasswd string     Supply a 2nd password for view-only logins.  The -passwd\n"
"                       (full-access) password must also be supplied.\n"
"\n"
"-passwdfile filename   Specify the libvncserver password via the first line\n"
"                       of the file \"filename\" (instead of via -passwd on\n"
"                       the command line where others might see it via ps(1)).\n"
"\n"
"                       See the descriptions below for how to supply multiple\n"
"                       passwords, view-only passwords, to specify external\n"
"                       programs for the authentication, and other features.\n"
"\n"
"                       If the filename is prefixed with \"rm:\" it will be\n"
"                       removed after being read.  Perhaps this is useful in\n"
"                       limiting the readability of the file.  In general, the\n"
"                       password file should not be readable by untrusted users\n"
"                       (BTW: neither should the VNC -rfbauth file: it is NOT\n"
"                       encrypted, only obscured with a fixed key).\n"
"\n"
"                       If the filename is prefixed with \"read:\" it will\n"
"                       periodically be checked for changes and reread.  It is\n"
"                       guaranteed to be reread just when a new client connects\n"
"                       so that the latest passwords will be used.\n"
"\n"
"                       If \"filename\" is prefixed with \"cmd:\" then the\n"
"                       string after the \":\" is run as an external command:\n"
"                       the output of the command will be interpreted as if it\n"
"                       were read from a password file (see below).  If the\n"
"                       command does not exit with 0, then x11vnc terminates\n"
"                       immediately.  To specify more than 1000 passwords this\n"
"                       way set X11VNC_MAX_PASSWDS before starting x11vnc.\n"
"                       The environment variables are set as in -accept.\n"
"\n"
"                       Note that due to the VNC protocol only the first 8\n"
"                       characters of a password are used (DES key).\n"
"\n"
"                       If \"filename\" is prefixed with \"custom:\" then a\n"
"                       custom password checker is supplied as an external\n"
"                       command following the \":\". The command will be run\n"
"                       when a client authenticates.  If the command exits with\n"
"                       0 the client is accepted, otherwise it is rejected.\n"
"                       The environment variables are set as in -accept.\n"
"\n"
"                       The standard input to the custom command will be a\n"
"                       decimal digit \"len\" followed by a newline. \"len\"\n"
"                       specifies the challenge size and is usually 16 (the\n"
"                       VNC spec).  Then follows len bytes which is the random\n"
"                       challenge string that was sent to the client. This is\n"
"                       then followed by len more bytes holding the client's\n"
"                       response (i.e. the challenge string encrypted via DES\n"
"                       with the user password in the standard situation).\n"
"\n"
"                       The \"custom:\" scheme can be useful to implement\n"
"                       dynamic passwords or to implement methods where longer\n"
"                       passwords and/or different encryption algorithms\n"
"                       are used.  The latter will require customizing the VNC\n"
"                       client as well.  One could create an MD5SUM based scheme\n"
"                       for example.\n"
"\n"
"                       File format for -passwdfile:\n"
"\n"
"                       If multiple non-blank lines exist in the file they are\n"
"                       all taken as valid passwords.  Blank lines are ignored.\n"
"                       Password lines may be \"commented out\" (ignored) if\n"
"                       they begin with the charactor \"#\" or the line contains\n"
"                       the string \"__SKIP__\".  Lines may be annotated by use\n"
"                       of the \"__COMM__\" string: from it to the end of the\n"
"                       line is ignored.  An empty password may be specified\n"
"                       via the \"__EMPTY__\" string on a line by itself (note\n"
"                       your viewer might not accept empty passwords).\n"
"\n"
"                       If the string \"__BEGIN_VIEWONLY__\" appears on a\n"
"                       line by itself, the remaining passwords are used for\n"
"                       viewonly access.  For compatibility, as a special case\n"
"                       if the file contains only two password lines the 2nd\n"
"                       one is automatically taken as the viewonly password.\n"
"                       Otherwise the \"__BEGIN_VIEWONLY__\" token must be\n"
"                       used to have viewonly passwords.  (tip: make the 3rd\n"
"                       and last line be \"__BEGIN_VIEWONLY__\" to have 2\n"
"                       full-access passwords)\n"
"\n"
#ifndef NO_SSL_OR_UNIXPW
"-unixpw [list]         Use Unix username and password authentication.  x11vnc\n"
"                       uses the su(1) program to verify the user's password.\n"
"                       [list] is an optional comma separated list of allowed\n"
"                       Unix usernames.  If the [list] string begins with the\n"
"                       character \"!\" then the entire list is taken as an\n"
"                       exclude list.  See below for per-user options that can\n"
"                       be applied.\n"
"\n"
"                       A familiar \"login:\" and \"Password:\" dialog is\n"
"                       presented to the user on a black screen inside the\n"
"                       vncviewer.  The connection is dropped if the user fails\n"
"                       to supply the correct password in 3 tries or does not\n"
"                       send one before a 25 second timeout.  Existing clients\n"
"                       are view-only during this period.\n"
"\n"
"                       If the first character received is \"Escape\" then the\n"
"                       unix username will not be displayed after \"login:\"\n"
"                       as it is typed.  This could be of use for VNC viewers\n"
"                       that automatically type the username and password.\n"
"\n"
"                       Since the detailed behavior of su(1) can vary from\n"
"                       OS to OS and for local configurations, test the mode\n"
"                       carefully.  x11vnc will attempt to be conservative and\n"
"                       reject a login if anything abnormal occurs.\n"
"\n"
"                       One case to note: FreeBSD and the other BSD's by\n"
"                       default it is impossible for the user running x11vnc to\n"
"                       validate his *own* password via su(1) (commenting out\n"
"                       the pam_self.so entry in /etc/pam.d/su eliminates this\n"
"                       behavior).  So the x11vnc login will always *FAIL* for\n"
"                       this case (even when the correct password is supplied).\n"
"\n"
"                       A possible workaround for this on *BSD would be to\n"
"                       start x11vnc as root with the \"-users +nobody\" option\n"
"                       to immediately switch to user nobody where the su'ing\n"
"                       will proceed normally.\n"
"\n"
"                       Another source of potential problems are PAM modules\n"
"                       that prompt for extra info, e.g. password aging modules.\n"
"                       These logins will fail as well even when the correct\n"
"                       password is supplied.\n"
"\n"
"                       **IMPORTANT**: to prevent the Unix password being sent\n"
"                       in *clear text* over the network, one of two schemes\n"
"                       will be enforced: 1) the -ssl builtin SSL mode, or 2)\n"
"                       require both -localhost and -stunnel be enabled.\n"
"\n"
"                       Method 1) ensures the traffic is encrypted between\n"
"                       viewer and server.  A PEM file will be required, see the\n"
"                       discussion under -ssl below (under some circumstances\n"
"                       a temporary one can be automatically generated).\n"
"\n"
"                       Method 2) requires the viewer connection to appear\n"
"                       to come from the same machine x11vnc is running on\n"
"                       (e.g. from a ssh -L port redirection).  And that the\n"
"                       -stunnel SSL mode be used for encryption over the\n"
"                       network.(see the description of -stunnel below).\n"
"\n"
"                       Note: as a convenience, if you ssh(1) in and start\n"
"                       x11vnc it will check if the environment variable\n"
"                       SSH_CONNECTION is set and appears reasonable.  If it\n"
"                       does, then the -ssl or -stunnel requirement will be\n"
"                       dropped since it is assumed you are using ssh for the\n"
"                       encrypted tunnelling.  -localhost is still enforced.\n"
"                       Use -ssl or -stunnel to force SSL usage even if\n"
"                       SSH_CONNECTION is set.\n"
"\n"
"                       To override the above restrictions you can set\n"
"                       environment variables before starting x11vnc:\n"
"\n"
"                       Set UNIXPW_DISABLE_SSL=1 to disable requiring either\n"
"                       -ssl or -stunnel.  Evidently you will be using a\n"
"                       different method to encrypt the data between the\n"
"                       vncviewer and x11vnc: perhaps ssh(1) or an IPSEC VPN.\n"
"\n"
"                       Note that use of -localhost with ssh(1) is roughly\n"
"                       the same as requiring a Unix user login (since a Unix\n"
"                       password or the user's public key authentication is\n"
"                       used by sshd on the machine where x11vnc runs and only\n"
"                       local connections from that machine are accepted).\n"
"\n"
"                       Set UNIXPW_DISABLE_LOCALHOST=1 to disable the -localhost\n"
"                       requirement in Method 2).  One should never do this\n"
"                       (i.e. allow the Unix passwords to be sniffed on the\n"
"                       network).\n"
"\n"
"                       Regarding reverse connections (e.g. -R connect:host\n"
"                       and -connect host), when the -localhost constraint is\n"
"                       in effect then reverse connections can only be used\n"
"                       to connect to the same machine x11vnc is running on\n"
"                       (default port 5500).  Please use a ssh or stunnel port\n"
"                       redirection to the viewer machine to tunnel the reverse\n"
"                       connection over an encrypted channel.\n"
"\n"
"                       In -inetd mode the Method 1) will be enforced (not\n"
"                       Method 2).  With -ssl in effect reverse connections\n"
"                       are disabled.  If you override this via env. var, be\n"
"                       sure to also use encryption from the viewer to inetd.\n"
"                       Tip: you can also have your own stunnel spawn x11vnc\n"
"                       in -inetd mode (thereby bypassing inetd).  See the FAQ\n"
"                       for details.\n"
"\n"
"                       The user names in the comma separated [list] can have\n"
"                       per-user options after a \":\", e.g. \"fred:opts\"\n"
"                       where \"opts\" is a \"+\" separated list of\n"
"                       \"viewonly\", \"fullaccess\", \"input=XXXX\", or\n"
"                       \"deny\", e.g. \"karl,wally:viewonly,boss:input=M\".\n"
"                       For \"input=\" it is the K,M,B,C described under -input.\n"
"\n"
"                       If an item in the list is \"*\" that means those\n"
"                       options apply to all users.  It also means all users\n"
"                       are allowed to log in after supplying a valid password.\n"
"                       Use \"deny\" to explicitly deny some users if you use\n"
"                       \"*\" to set a global option.  If [list] begins with\n"
"                       the \"!\" character then \"*\" is ignored for checking\n"
"                       if the user is allowed, but the any value of options\n"
"                       associated with it does apply as normal.\n"
"\n"
"                       There are also some utilities for testing password\n"
"                       if [list] starts with the \"%\" character.  See the\n"
"                       quick_pw() function in the source for details.\n"
"\n"
"-unixpw_nis [list]     As -unixpw above, however do not use su(1) but rather\n"
"                       use the traditional getpwnam(3) + crypt(3) method to\n"
"                       verify passwords. All of the above -unixpw options and\n"
"                       contraints apply.\n"
"\n"
"                       This mode requires that the encrypted passwords be\n"
"                       readable.  Encrypted passwords stored in /etc/shadow\n"
"                       will be inaccessible unless x11vnc is run as root.\n"
"\n"
"                       This is called \"NIS\" mode simply because in most\n"
"                       NIS setups user encrypted passwords are accessible\n"
"                       (e.g. \"ypcat passwd\") by an ordinary user and so that\n"
"                       user can authenticate ANY user.\n"
"\n"
"                       NIS is not required for this mode to work (only that\n"
"                       getpwnam(3) return the encrypted password is required),\n"
"                       but it is unlikely it will work for any most modern\n"
"                       environments unless x11vnc is run as root to be able\n"
"                       to access /etc/shadow (note running as root is often\n"
"                       done when running x11vnc from inetd and xdm/gdm/kdm).\n"
"\n"
"                       Looked at another way, if you do not want to use the\n"
"                       su(1) method provided by -unixpw, you can run x11vnc\n"
"                       as root and use -unixpw_nis.  Any users with passwords\n"
"                       in /etc/shadow can then be authenticated.  You may want\n"
"                       to use -users unixpw= to switch the process user after\n"
"                       the user logs in.\n"
"\n"
"-unixpw_cmd cmd        As -unixpw above, however do not use su(1) but rather\n"
"                       run the externally supplied command \"cmd\".  The first\n"
"                       line of its stdin will the username and the second line\n"
"                       the received password.  If the command exits with status\n"
"                       0 (success) the VNC client will be accepted.  It will be\n"
"                       rejected for any other return status.\n"
"\n"
"                       Dynamic passwords and non-unix passwords can be\n"
"                       implemented this way by providing your own custom helper\n"
"                       program.  Note that under unixpw mode the remote viewer\n"
"                       is given 3 tries to enter the correct password.\n"
"\n"
"                       If a list of allowed users is needed use -unixpw [list]\n"
"                       in addition to this option.\n"
"\n"
#endif
"-find                  Find the user's display using FINDDISPLAY. It is an\n"
"                       alias for \"-display WAIT:cmd=FINDDISPLAY\".\n"
"\n"
"-create                First try to find the user's display using FINDDISPLAY,\n"
"                       if that doesn't work create an X session via the\n"
"                       FINDCREATEDISPLAY method. This is an alias for\n"
"                       \"-display WAIT:cmd=FINDCREATEDISPLAY-Xvfb\".\n"
"\n"
"-svc                   Terminal services mode. Also \"-service\". Alias for\n"
"                       -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb -unixpw\n"
"                       -users unixpw= -ssl SAVE\n"
"\n"
"-xdmsvc                Terminal services mode. Also \"-xdm_service\". Alias for\n"
"                       -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp -unixpw\n"
"                       -users unixpw= -ssl SAVE\n"
"\n"
"-display WAIT:...      A special usage mode for the normal -display option.\n"
"                       Useful with -unixpw, but can be used independently\n"
"                       of it.  If the display string begins with WAIT: then\n"
"                       x11vnc waits until a VNC client connects before opening\n"
"                       the X display (or -rawfb device).\n"
"\n"
"                       This could be useful for delaying opening the display\n"
"                       for certain usage modes (say if x11vnc is started at\n"
"                       boot time and no X server is running or users logged\n"
"                       in yet).\n"
"\n"
"                       If the string is, e.g. WAIT:0.0 or WAIT:1, i.e. \"WAIT\"\n"
"                       in front of a normal X display, then that indicated\n"
"                       display is used.\n"
"\n"
"                       One can also insert a geometry between colons, e.g.\n"
"                       WAIT:1280x1024:... to set the size of the display the\n"
"                       VNC client first attaches to since some VNC viewers\n"
"                       will not automatically adjust to a new framebuffer size.\n"
"\n"
"                       A more interesting case is like this:\n"
"\n"
"                            WAIT:cmd=/usr/local/bin/find_display\n"
"\n"
"                       in which case the command after \"cmd=\" is run to\n"
"                       dynamically work out the DISPLAY and optionally the\n"
"                       XAUTHORITY data.  The first line of the command output\n"
"                       must be of the form DISPLAY=<xdisplay>.  On Linux\n"
"                       if the virtual terminal is known append \",VT=n\" to\n"
"                       this string and the chvt(1) program will also be run.\n"
"                       Any remaining output is taken as XAUTHORITY data.\n"
"                       It can be either of the form XAUTHORITY=<file> or raw\n"
"                       xauthority data for the display (e.g. \"xauth extract -\n"
"                       $DISPLAY\" output).\n"
"\n"
#ifndef NO_SSL_OR_UNIXPW
"                       In the case of -unixpw (but not -unixpw_nis), then the\n"
"                       above command is run as the user who just authenticated\n"
"                       via the login and password prompt.\n"
"\n"
"                       Also in the case of -unixpw, the user logging in can\n"
"                       place a colon at the end of her username and supply\n"
"                       a few options: scale=, scale_cursor= (or sc=), solid\n"
"                       (or so), id=, clear_mods (or cm), clear_keys (or ck),\n"
"                       repeat, speeds= (or sp=), readtimeout= (or rd=),\n"
"                       rotate= (or ro=), or noncache (or nc) separated by\n"
"                       commas if there is more than one.  After the user logs\n"
"                       in successfully, these options will be applied to the\n"
"                       VNC screen.  For example,\n"
"\n"
"                          login: fred:scale=3/4,sc=1,repeat\n"
"                          Password: ...\n"
"\n"
"                          login: runge:sp=modem,rd=120,solid\n"
"\n"
"                       for convenience m/n implies scale= e.g. fred:3/4  If you\n"
"                       type and enter your password incorrectly, to retrieve\n"
"                       your long \"login:\" line press the Up arrow once\n"
"                       (before typing anything else).\n"
"\n"
"                       Another option is \"geom=WxH\" or \"geom=WxHxD\"\n"
"                       (or ge=). This only has an effect in FINDCREATEDISPLAY\n"
"                       mode when a virtual X server such as Xvfb is going to\n"
"                       be created.  It sets the width and height of the new\n"
"                       display, and optionally the color depth as well. You\n"
"                       can also supply \"kde\", \"gnome\", \"fvwm\", \"twm\",\n"
"                       or \"failsafe\" to have the created display use that\n"
"                       mode for the user session.\n"
"\n"
"                       To disable the option setting set the environment\n"
"                       variable X11VNC_NO_UNIXPW_OPTS=1 before starting x11vnc.\n"
"                       To set any other options, the user can use the gui\n"
"                       (x11vnc -gui connect) or the remote control method\n"
"                       (x11vnc -R opt:val) during his VNC session.\n"
"\n"
"                       The combination of -display WAIT:cmd=... and -unixpw\n"
"                       allows automatic pairing of an unix authenticated VNC\n"
"                       user with his desktop.  This could be very useful on\n"
"                       SunRays and also any system where multiple users share\n"
"                       a given machine.  The user does not need to remember\n"
"                       special ports or passwords set up for his desktop\n"
"                       and VNC.\n"
"\n"
"                       A nice way to use WAIT:cmd=... is out of inetd(8)\n"
"                       (it automatically forks a new x11vnc for each user).\n"
"                       You can have the x11vnc inetd spawned process run as,\n"
"                       say, root or nobody.  When run as root (for either inetd\n"
"                       or display manager), you can also supply the option\n"
"                       \"-users unixpw=\" to have the x11vnc process switch to\n"
"                       the user as well.  Note: there will be a 2nd SSL helper\n"
"                       process that will not switch, but it is only encoding\n"
"                       and decoding the encrypted stream at that point.\n"
"\n"
#endif
"                       As a special case, WAIT:cmd=FINDDISPLAY will run a\n"
"                       script that works on most Unixes to determine a user's\n"
"                       DISPLAY variable and xauthority data (see who(1)).\n"
"\n"
"                       To have this default script printed to stdout (e.g. for\n"
"                       customization) run with WAIT:cmd=FINDDISPLAY-print\n"
"\n"
"                       As another special case, WAIT:cmd=HTTPONCE will allow\n"
"                       x11vnc to service one http request and then exit.\n"
"                       This is usually done in -inetd mode to run on, say,\n"
"                       port 5800 and allow the Java vncviewer to be downloaded\n"
"                       by client web browsers.  For example:\n"
"\n"
"                        5815 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc \\\n"
"                          -inetd -q -http_ssl -prog /.../x11vnc \\\n"
"                          -display WAIT:cmd=HTTPONCE\n"
"\n"
"                       Where /.../x11vnc is the full path to x11vnc.\n"
"                       It is used in the Apache SSL-portal example (see FAQ).\n"
"\n"
"                       In this mode you can set X11VNC_SKIP_DISPLAY to a comma\n"
"                       separated list of displays (e.g. \":0,:1\") to ignore\n"
"                       in the finding process.  This can also be set by the\n"
"                       user via \"nd=\" using \"-\" instead of \",\"\n"
"\n"
"                       An interesting option is WAIT:cmd=FINDCREATEDISPLAY\n"
"                       that is like FINDDISPLAY in that is uses the same method\n"
"                       to find an existing display.  However, if it does not\n"
"                       find one it will try to *start* up an X server session\n"
"                       for the user.  This is the only time x11vnc tries to\n"
"                       start up an X server.\n"
"\n"
"                       By default FINDCREATEDISPLAY will try Xdummy and\n"
"                       then Xvfb.  The Xdummy wrapper is part of the x11vnc\n"
"                       source code (x11vnc/misc/Xdummy)  It should be available\n"
"                       in PATH and have run \"Xdummy -install\" once to create\n"
"                       the shared library.  Xdummy requires root permission\n"
"                       and only works on Linux.  Xvfb is available on most\n"
"                       platforms and does not require root.\n"
"\n"
"                       When x11vnc exits (i.e. user disconnects) the X\n"
"                       server session stays running in the background.\n"
"                       The FINDDISPLAY will find it directly next time.\n"
"                       The user must exit the X session in the usual way for\n"
"                       it to terminate (or kill the X server process if all\n"
"                       else fails).\n"
"\n"
"                       So this is a somewhat odd mode for x11vnc in that it\n"
"                       will start up and poll virtual X servers!  This can\n"
"                       be used from, say, inetd(8) to provide a means of\n"
"                       definitely getting a desktop (either real or virtual)\n"
"                       on the machine.  E.g. a desktop service:\n"
"\n"
"                         5900 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc\n"
"                          -inetd -q -http -ssl SAVE -unixpw -users unixpw=\\\n"
"                          -passwd secret -prog /.../x11vnc \\\n"
"                          -display WAIT:cmd=FINDCREATEDISPLAY\n"
"\n"
"                       Where /.../x11vnc is the full path to x11vnc.\n"
"\n"
"                       If for some reason you do not want x11vnc to ever\n"
"                       try to find an existing display set the env. var\n"
"                       X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (also -env ...)\n"
"\n"
"                       Use WAIT:cmd=FINDCREATEDISPLAY-print to print out the\n"
"                       script used.  You can specify the preferred order via\n"
"                       e.g., WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb,X  and/or\n"
"                       leave out ones you do not want.  The the extra case\n"
"                       \"X\" means try to start up a real, hardware X server\n"
"                       using xinit(1) or startx(1).  If there is already an\n"
"                       X server running the X case may only work on Linux\n"
"                       (see startx(1)).\n"
"\n"
"                       You can set the environment variable FD_GEOM (or\n"
"                       X11VNC_CREATE_GEOM) to WxH or WxHxD to set the width\n"
"                       and height and optionally the color depth of the\n"
"                       created display.\n"
"\n"
"                       If you want the FINDCREATEDISPLAY session to contact an\n"
"                       XDMCP login manager (xdm/gdm/kdm) on the same machine,\n"
"                       then use \"Xvfb.xdmcp\" instead of \"Xvfb\", etc.\n"
"                       The user will have to supply his username and password\n"
"                       one more time (but he gets to select his desktop type\n"
"                       so that can be useful).  For this to work, you will\n"
"                       need to enable localhost XDMCP (udp port 177) for the\n"
"                       display manager.  This seems to be:\n"
"\n"
"                        for gdm in gdm.conf:   Enable=true in section [xdmcp]\n"
"                        for kdm in kdmrc:      Enable=true in section [Xdmcp]\n"
"                        for xdm in xdm-config: DisplayManager.requestPort: 177\n"
"\n"
"                       See the shorthand options above \"-svc\" and \"-xdmsvc\"\n"
"                       that specify the above options for some useful cases.\n"
"\n"
"                       If you set the env. var WAITBG=1 x11vnc will go into\n"
"                       the background once listening in wait mode.\n"
"\n"
#ifndef NO_SSL_OR_UNIXPW
"-nossl                 Disable the -ssl option (see below). Since -ssl is off\n"
"                       by default -nossl would only be used on the commandline\n"
"                       to unset any *earlier* -ssl option (or -svc...)\n"
"\n"
"-ssl [pem]             Use the openssl library (www.openssl.org) to provide a\n"
"                       built-in encrypted SSL tunnel between VNC viewers and\n"
"                       x11vnc.  This requires libssl support to be compiled\n"
"                       into x11vnc at build time.  If x11vnc is not built\n"
"                       with libssl support it will exit immediately when -ssl\n"
"                       is prescribed.\n"
"\n"
"                       [pem] is optional, use \"-ssl /path/to/mycert.pem\"\n"
"                       to specify a PEM certificate file to use to identify\n"
"                       and provide a key for this server.  See openssl(1) for\n"
"                       more info about PEMs and the -sslGenCert option below.\n"
"\n"
"                       The connecting VNC viewer SSL tunnel can optionally\n"
"                       authenticate this server if they have the public\n"
"                       key part of the certificate (or a common certificate\n"
"                       authority, CA, is a more sophisicated way to verify\n"
"                       this server's cert, see -sslGenCA below).  This is\n"
"                       used to prevent man-in-the-middle attacks.  Otherwise,\n"
"                       if the VNC viewer accepts this server's key without\n"
"                       verification, at least the traffic is protected\n"
"                       from passive sniffing on the network (but NOT from\n"
"                       man-in-the-middle attacks).\n"
"\n"
"                       If [pem] is not supplied and the openssl(1) utility\n"
"                       command exists in PATH, then a temporary, self-signed\n"
"                       certificate will be generated for this session (this\n"
"                       may take 5-30 seconds on slow machines).  If openssl(1)\n"
"                       cannot be used to generate a temporary certificate\n"
"                       x11vnc exits immediately.\n"
"\n"
"                       If successful in using openssl(1) to generate a\n"
"                       temporary certificate, the public part of it will be\n"
"                       displayed to stderr (e.g. one could copy it to the\n"
"                       client-side to provide authentication of the server to\n"
"                       VNC viewers.)  See following paragraphs for how to save\n"
"                       keys to reuse when x11vnc is restarted.\n"
"\n"
"                       Set the env. var. X11VNC_SHOW_TMP_PEM=1 to have x11vnc\n"
"                       print out the entire certificate, including the PRIVATE\n"
"                       KEY part, to stderr.  One could reuse this cert if saved\n"
"                       in a [pem] file.  Similarly, set X11VNC_KEEP_TMP_PEM=1\n"
"                       to not delete the temporary PEM file: the file name\n"
"                       will be printed to stderr (so one could move it to\n"
"                       a safe place for reuse).  You will be prompted for a\n"
"                       passphrase for the private key.\n"
"\n"
"                       If [pem] is \"SAVE\" then the certificate will be saved\n"
"                       to the file ~/.vnc/certs/server.pem, or if that file\n"
"                       exists it will be used directly.  Similarly, if [pem]\n"
"                       is \"SAVE_PROMPT\" the server.pem certificate will be\n"
"                       made based on your answers to its prompts for info such\n"
"                       as OrganizationalName, CommonName, etc.\n"
"\n"
"                       Use \"SAVE-<string>\" and \"SAVE_PROMPT-<string>\"\n"
"                       to refer to the file ~/.vnc/certs/server-<string>.pem\n"
"                       instead.  E.g. \"SAVE-charlie\" will store to the file\n"
"                       ~/.vnc/certs/server-charlie.pem\n"
"\n"
"                       See -ssldir below to use a directory besides the\n"
"                       default ~/.vnc/certs\n"
"\n"
"                       Example: x11vnc -ssl SAVE -display :0 ...\n"
"\n"
#if 0
"                       Reverse connections are disabled in -ssl mode because\n"
"                       there is no way to ensure that data channel will\n"
"                       be encrypted.  Set X11VNC_SSL_ALLOW_REVERSE=1 to\n"
"                       override this.\n"
"\n"
#endif
"                       Your VNC viewer will also need to be able to connect\n"
"                       via SSL.  See the discussion below under -stunnel and\n"
"                       the FAQ (ss_vncviewer script) for how this might be\n"
"                       achieved.  E.g. on Unix it is easy to write a shell\n"
"                       script that starts up stunnel and then vncviewer.\n"
"                       Also in the x11vnc source a SSL enabled Java VNC Viewer\n"
"                       applet is provided in the classes/ssl directory.\n"
"\n"
"-ssltimeout n          Set SSL read timeout to n seconds.  In some situations\n"
"                       (i.e. an iconified viewer in Windows) the viewer stops\n"
"                       talking and the connection is dropped after the default\n"
"                       timeout (25s for about the first minute, 43200s later).\n"
"                       Set to zero to poll forever.  Set to a negative value\n"
"                       to use the builtin setting.\n"
"\n"
"-sslnofail             Exit at the first SSL connection failure. Useful when\n"
"                       scripting SSL connections (e.g. x11vnc is started via\n"
"                       ssh) and you do not want x11vnc waiting around for more\n"
"                       connections, tying up ports, etc.\n"
"\n"
"-ssldir [dir]          Use [dir] as an alternate ssl certificate and key\n"
"                       management toplevel directory.  The default is\n"
"                       ~/.vnc/certs\n"
"\n"
"                       This directory is used to store server and other\n"
"                       certificates and keys and also other materials.  E.g. in\n"
"                       the simplest case, \"-ssl SAVE\" will store the x11vnc\n"
"                       server cert in [dir]/server.pem\n"
"\n"
"                       Use of alternate directories via -ssldir allows you to\n"
"                       manage multiple VNC Certificate Authority (CA) keys.\n"
"                       Another use is if ~/.vnc/cert is on an NFS share you\n"
"                       might want your certificates and keys to be on a local\n"
"                       filesystem to prevent network snooping (for example\n"
"                       -ssldir /var/lib/x11vnc-certs).\n"
"\n"
"                       -ssldir affects nearly all of the other -ssl* options,\n"
"                       e.g. -ssl SAVE, -sslGenCert, etc..\n"
"\n"
"-sslverify [path]      For either of the -ssl or -stunnel modes, use [path]\n"
"                       to provide certificates to authenticate incoming VNC\n"
"                       *Client* connections (normally only the server is\n"
"                       authenticated in SSL.)  This can be used as a method\n"
"                       to replace standard password authentication of clients.\n"
"\n"
"                       If [path] is a directory it contains the client (or CA)\n"
"                       certificates in separate files.  If [path] is a file,\n"
"                       it contains multiple certificates.  See special tokens\n"
"                       below.  These correspond to the \"CApath = dir\" and\n"
"                       \"CAfile = file\" stunnel options.  See the stunnel(8)\n"
"                       manpage for details.\n"
"\n"
"                       Examples:\n"
"                              x11vnc -ssl -sslverify ~/my.crt\n"
"                              x11vnc -ssl -sslverify ~/my_pem_dir/\n"
"\n"
"                       Note that if [path] is a directory, it must contain\n"
"                       the certs in separate files named like <HASH>.0, where\n"
"                       the value of <HASH> is found by running the command\n"
"                       \"openssl x509 -hash -noout -in file.crt\". Evidently\n"
"                       one uses <HASH>.1 if there is a collision...\n"
"\n"
"                       The the key-management utility \"-sslCertInfo HASHON\"\n"
"                       and \"-sslCertInfo HASHOFF\" will create/delete these\n"
"                       hashes for you automatically (via symlink) in the HASH\n"
"                       subdirs it manages.  Then you can point -sslverify to\n"
"                       the HASH subdir.\n"
"\n"
"                       Special tokens: in -ssl mode, if [path] is not a file or\n"
"                       a directory, it is taken as a comma separated list of\n"
"                       tokens that are interpreted as follows:\n"
"\n"
"                       If a token is \"CA\" that means load the CA/cacert.pem\n"
"                       file from the ssl directory.  If a token is \"clients\"\n"
"                       then all the files clients/*.crt in the ssl directory\n"
"                       are loaded.  Otherwise the file clients/token.crt\n"
"                       is attempted to be loaded.  As a kludge, use a token\n"
"                       like ../server-foo to load a server cert if you find\n"
"                       that necessary.\n"
"\n"
"                       Use -ssldir to use a directory different from the\n"
"                       ~/.vnc/certs default.\n"
"\n"
"                       Note that if the \"CA\" cert is loaded you do not need\n"
"                       to load any of the certs that have been signed by it.\n"
"                       You will need to load any additional self-signed certs\n"
"                       however.\n"
"\n"
"                       Examples:\n"
"                              x11vnc -ssl -sslverify CA\n"
"                              x11vnc -ssl -sslverify self:fred,self:jim\n"
"                              x11vnc -ssl -sslverify CA,clients\n"
"\n"
"                       Usually \"-sslverify CA\" is the most effective.\n"
"                       See the -sslGenCA and -sslGenCert options below for\n"
"                       how to set up and manage the CA framework.\n"
"\n"
"\n"
"\n"
"                       NOTE: the following utilities, -sslGenCA, -sslGenCert,\n"
"                       -sslEncKey, and -sslCertInfo are provided for\n"
"                       completeness, but for casual usage they are overkill.\n"
"\n"
"                       They provide VNC Certificate Authority (CA) key creation\n"
"                       and server / client key generation and signing.  So they\n"
"                       provide a basic Public Key management framework for\n"
"                       VNC-ing with x11vnc. (note that they require openssl(1)\n"
"                       be installed on the system)\n"
"\n"
"                       However, the simplest usage mode (where x11vnc\n"
"                       automatically generates its own, self-signed, temporary\n"
"                       key and the VNC viewers always accept it, e.g. accepting\n"
"                       via a dialog box) is probably safe enough for most\n"
"                       scenarios.  CA management is not needed.\n"
"\n"
"                       To protect against Man-In-The-Middle attacks the\n"
"                       simplest mode can be improved by using \"-ssl SAVE\"\n"
"                       to have x11vnc create a longer term self-signed\n"
"                       certificate, and then (safely) copy the corresponding\n"
"                       public key cert to the desired client machines (care\n"
"                       must be taken the private key part is not stolen;\n"
"                       you will be prompted for a passphrase).\n"
"\n"
"                       So keep in mind no CA key creation or management\n"
"                       (-sslGenCA and -sslGenCert) is needed for either of\n"
"                       the above two common usage modes.\n"
"\n"
"                       One might want to use -sslGenCA and -sslGenCert\n"
"                       if you had a large number of VNC client and server\n"
"                       workstations.  That way the administrator could generate\n"
"                       a single CA key with -sslGenCA and distribute its\n"
"                       certificate part to all of the workstations.\n"
"\n"
"                       Next, he could create signed VNC server keys\n"
"                       (-sslGenCert server ...) for each workstation or user\n"
"                       that then x11vnc would use to authenticate itself to\n"
"                       any VNC client that has the CA cert.\n"
"\n"
"                       Optionally, the admin could also make it so the\n"
"                       VNC clients themselves are authenticated to x11vnc\n"
"                       (-sslGenCert client ...)  For this -sslverify would be\n"
"                       pointed to the CA cert (and/or self-signed certs).\n"
"\n"
"                       x11vnc will be able to use all of these cert and\n"
"                       key files.  On the VNC client side, they will need to\n"
"                       be \"imported\" somehow.  Web browsers have \"Manage\n"
"                       Certificates\" actions as does the Java applet plugin\n"
"                       Control Panel.  stunnel can also use these files (see\n"
"                       the ss_vncviewer example script in the FAQ.)\n"
"\n"
"-sslGenCA [dir]        Generate your own Certificate Authority private key,\n"
"                       certificate, and other files in directory [dir].\n"
"\n"
"                       If [dir] is not supplied, a -ssldir setting is used,\n"
"                       or otherwise ~/.vnc/certs is used.\n"
"\n"
"                       This command also creates directories where server and\n"
"                       client certs and keys will be stored.  The openssl(1)\n"
"                       program must be installed on the system and available\n"
"                       in PATH.\n"
"\n"
"                       After the CA files and directories are created the\n"
"                       command exits; the VNC server is not run.\n"
"\n"
"                       You will be prompted for information to put into the CA\n"
"                       certificate.  The info does not have to be accurate just\n"
"                       as long as clients accept the cert for VNC connections.\n"
"                       You will also need to supply a passphrase of at least\n"
"                       4 characters for the CA private key.\n"
"\n"
"                       Once you have generated the CA you can distribute\n"
"                       its certificate part, [dir]/CA/cacert.pem, to other\n"
"                       workstations where VNC viewers will be run.  One will\n"
"                       need to \"import\" this certicate in the applications,\n"
"                       e.g. Web browser, Java applet plugin, stunnel, etc.\n"
"                       Next, you can create and sign keys using the CA with\n"
"                       the -sslGenCert option below.\n"
"\n"
"                       Examples:\n"
"                                x11vnc -sslGenCA\n"
"                                x11vnc -sslGenCA  ~/myCAdir\n"
"                                x11vnc -ssldir ~/myCAdir -sslGenCA\n"
"\n"
"                       (the last two lines are equivalent)\n"
"\n"
"-sslGenCert type name  Generate a VNC server or client certificate and private\n"
"                       key pair signed by the CA created previously with\n"
"                       -sslGenCA.  The openssl(1) program must be installed\n"
"                       on the system and available in PATH.\n"
"\n"
"                       After the Certificate is generated the command exits;\n"
"                       the VNC server is not run.\n"
"\n"
"                       The type of key to be generated is the string \"type\".\n"
"                       It is either \"server\" (i.e. for use by x11vnc) or\n"
"                       \"client\" (for a VNC viewer).  Note that typically\n"
"                       only \"server\" is used: the VNC clients authenticate\n"
"                       themselves by a non-public-key method (e.g. VNC or\n"
"                       unix password).  \"type\" is required.\n"
"\n"
"                       An arbitrary default name you want to associate with\n"
"                       the key is supplied by the \"name\" string.  You can\n"
"                       change it at the various prompts when creating the key.\n"
"                       \"name\" is optional.\n"
"\n"
"                       If name is left blank for clients keys then \"nobody\"\n"
"                       is used.  If left blank for server keys, then the\n"
"                       primary server key: \"server.pem\" is created (this\n"
"                       is the saved one referenced by \"-ssl SAVE\" when the\n"
"                       server is started)\n"
"\n"
"                       If \"name\" begins with the string \"self:\" then\n"
"                       a self-signed certificate is created instead of one\n"
"                       signed by your CA key.\n"
"\n"
"                       If \"name\" begins with the string \"req:\" then only a\n"
"                       key (.key) and a certificate signing *request* (.req)\n"
"                       are generated.  You can then send the .req file to\n"
"                       an external CA (even a professional one, e.g. Thawte)\n"
"                       and then combine the .key and the received cert into\n"
"                       the .pem file with the same basename.\n"
"\n"
"                       The distinction between \"server\" and \"client\" is\n"
"                       simply the choice of output filenames and sub-directory.\n"
"                       This makes it so the -ssl SAVE-name option can easily\n"
"                       pick up the x11vnc PEM file this option generates.\n"
"                       And similarly makes it easy for the -sslverify option\n"
"                       to pick up your client certs.\n"
"\n"
"                       There is nothing special about the filename or directory\n"
"                       location of either the \"server\" and \"client\" certs.\n"
"                       You can rename the files or move them to wherever\n"
"                       you like.\n"
"\n"
"                       Precede this option with -ssldir [dir] to use a\n"
"                       directory other than the default ~/.vnc/certs You will\n"
"                       need to run -sslGenCA on that directory first before\n"
"                       doing any -sslGenCert key creation.\n"
"\n"
"                       Note you cannot recreate a cert with exactly the same\n"
"                       distiguished name (DN) as an existing one.  To do so,\n"
"                       you will need to edit the [dir]/CA/index.txt file to\n"
"                       delete the line.\n"
"\n"
"                       Similar to -sslGenCA, you will be prompted to fill\n"
"                       in some information that will be recorded in the\n"
"                       certificate when it is created.  Tip: if you know\n"
"                       the fully-quailified hostname other people will be\n"
"                       connecting to you can use that as the CommonName \"CN\"\n"
"                       to avoid some applications (e.g. web browsers and java\n"
"                       plugin) complaining it does not match the hostname.\n"
"\n"
"                       You will also need to supply the CA private key\n"
"                       passphrase to unlock the private key created from\n"
"                       -sslGenCA.  This private key is used to sign the server\n"
"                       or client certicate.\n"
"\n"
"                       The \"server\" certs can be used by x11vnc directly by\n"
"                       pointing to them via the -ssl [pem] option.  The default\n"
"                       file will be ~/.vnc/certs/server.pem.  This one would\n"
"                       be used by simply typing -ssl SAVE.  The pem file\n"
"                       contains both the certificate and the private key.\n"
"                       server.crt file contains the cert only.\n"
"\n"
"                       The \"client\" cert + private key file will need\n"
"                       to be copied and imported into the VNC viewer\n"
"                       side applications (Web browser, Java plugin,\n"
"                       stunnel, etc.)  Once that is done you can delete the\n"
"                       \"client\" private key file on this machine since\n"
"                       it is only needed on the VNC viewer side.  The,\n"
"                       e.g. ~/.vnc/certs/clients/<name>.pem contains both\n"
"                       the cert and private key.  The <name>.crt contains the\n"
"                       certificate only.\n"
"\n"
"                       NOTE: It is very important to know one should always\n"
"                       generate new keys with a passphrase.  Otherwise if an\n"
"                       untrusted user steals the key file he could use it to\n"
"                       masquerade as the x11vnc server (or VNC viewer client).\n"
"                       You will be prompted whether to encrypt the key with\n"
"                       a passphrase or not.  It is recommended that you do.\n"
"                       One inconvenience to a passphrase is that it must\n"
"                       be suppled every time x11vnc or the client app is\n"
"                       started up.\n"
"\n"
"                       Examples:\n"
"\n"
"                               x11vnc -sslGenCert server\n"
"                               x11vnc -ssl SAVE -display :0 ...\n"
"\n"
"                       and then on viewer using ss_vncviewer stunnel wrapper\n"
"                       (see the FAQ):\n"

"                               ss_vncviewer -verify ./cacert.crt hostname:0\n"
"\n"
"                       (this assumes the cacert.crt cert from -sslGenCA\n"
"                       was safely copied to the VNC viewer machine where\n"
"                       ss_vncviewer is run)\n"
"\n"
"                       Example using a name:\n"
"\n"
"                               x11vnc -sslGenCert server charlie\n"
"                               x11vnc -ssl SAVE-charlie -display :0 ...\n"
"\n"
"                       Example for a client certificate (rarely used):\n"
"\n"
"                               x11vnc -sslGenCert client roger\n"
"                               scp ~/.vnc/certs/clients/roger.pem somehost:.\n"
"                               rm  ~/.vnc/certs/clients/roger.pem\n"
"\n"
"                       x11vnc is then started with the the option -sslverify\n"
"                       ~/.vnc/certs/clients/roger.crt (or simply -sslverify\n"
"                       roger), and on the viewer user on somehost could do\n"
"                       for example:\n"
"\n"
"                               ss_vncviewer -mycert ./roger.pem hostname:0\n"
"\n"
"                       If you set the env. var REQ_ARGS='...' it will be\n"
"                       passed to openssl req(1).  A common use would be\n"
"                       REQ_ARGS='-days 730' to bump up the expiration date\n"
"                       (2 years in this case).\n"
"\n"
"-sslEncKey [pem]       Utility to encrypt an existing PEM file with a\n"
"                       passphrase you supply when prompted.  For that key to be\n"
"                       used (e.g. by x11vnc) the passphrase must be supplied\n"
"                       each time.\n"
"\n"
"                       The \"SAVE\" notation described under -ssl applies as\n"
"                       well. (precede this option with -ssldir [dir] to refer\n"
"                       a directory besides the default ~/.vnc/certs)\n"
"\n"
"                       The openssl(1) program must be installed on the system\n"
"                       and available in PATH.  After the Key file is encrypted\n"
"                       the command exits; the VNC server is not run.\n"
"\n"
"                       Examples:\n"
"                               x11vnc -sslEncKey /path/to/foo.pem\n"
"                               x11vnc -sslEncKey SAVE\n"
"                               x11vnc -sslEncKey SAVE-charlie\n"
"\n"
"-sslCertInfo [pem]     Prints out information about an existing PEM file.\n"
"                       In addition the public certificate is also printed.\n"
"                       The openssl(1) program must be in PATH. Basically the\n"
"                       command \"openssl x509 -text\" is run on the pem.\n"
"\n"
"                       The \"SAVE\" notation described under -ssl applies\n"
"                       as well.\n"
"\n"
"                       Using  \"LIST\" will give a list of all certs being\n"
"                       managed (in the ~/.vnc/certs dir, use -ssldir to refer\n"
"                       to another dir).  \"ALL\" will print out the info for\n"
"                       every managed key (this can be very long).  Giving a\n"
"                       client or server cert shortname will also try a lookup\n"
"                       (e.g. -sslCertInfo charlie).  Use \"LISTL\" or \"LL\"\n"
"                       for a long (ls -l style) listing.\n"
"\n"
"                       Using \"HASHON\" will create subdirs [dir]/HASH and\n"
"                       [dir]/HASH with OpenSSL hash filenames (e.g. 0d5fbbf1.0)\n"
"                       symlinks pointing up to the corresponding *.crt file.\n"
"                       ([dir] is ~/.vnc/certs or one given by -ssldir.)\n"
"                       This is a useful way for other OpenSSL applications\n"
"                       (e.g. stunnel) to access all of the certs without\n"
"                       having to concatenate them.  x11vnc will not use them\n"
"                       unless you specifically reference them.  \"HASHOFF\"\n"
"                       removes these HASH subdirs.\n"
"\n"
"                       The LIST, LISTL, LL, ALL, HASHON, HASHOFF words can\n"
"                       also be lowercase, e.g. \"list\".\n"
"\n"
"-sslDelCert [pem]      Prompts you to delete all .crt .pem .key .req files\n"
"                       associated with [pem].  \"SAVE\" and lookups as in\n"
"                       -sslCertInfo apply as well.\n"
"\n"
"\n"
"-stunnel [pem]         Use the stunnel(8) (www.stunnel.org) to provide an\n"
"                       encrypted SSL tunnel between viewers and x11vnc.\n"
"\n"
"                       This external tunnel method was implemented prior to the\n"
"                       integrated -ssl encryption described above.  It still\n"
"                       works well.  This requires stunnel to be installed\n"
"                       on the system and available via PATH (n.b. stunnel is\n"
"                       often installed in sbin directories).  Version 4.x of\n"
"                       stunnel is assumed (but see -stunnel3 below.)\n"
"\n"
"                       [pem] is optional, use \"-stunnel /path/to/stunnel.pem\"\n"
"                       to specify a PEM certificate file to pass to stunnel.\n"
"                       Whether one is needed or not depends on your stunnel\n"
"                       configuration.  stunnel often generates one at install\n"
"                       time.  See the stunnel documentation for details.\n"
"\n"
"                       stunnel is started up as a child process of x11vnc and\n"
"                       any SSL connections stunnel receives are decrypted and\n"
"                       sent to x11vnc over a local socket.  The strings\n"
"                       \"The SSL VNC desktop is ...\" and \"SSLPORT=...\"\n"
"                       are printed out at startup to indicate this.\n"
"\n"
"                       The -localhost option is enforced by default\n"
"                       to avoid people routing around the SSL channel.\n"
"                       Set STUNNEL_DISABLE_LOCALHOST=1 before starting x11vnc\n"
"                       to disable the requirement.\n"
"\n"
"                       Your VNC viewer will also need to be able to connect via\n"
"                       SSL.  Unfortunately not too many do this.  UltraVNC has\n"
"                       an encryption plugin but it does not seem to be SSL.\n"
"\n"
"                       Also, in the x11vnc distribution, a patched TightVNC\n"
"                       Java applet is provided in classes/ssl that does SSL\n"
"                       connections (only).\n"
"\n"
"                       It is also not too difficult to set up an stunnel or\n"
"                       other SSL tunnel on the viewer side.  A simple example\n"
"                       on Unix using stunnel 3.x is:\n"
"\n"
"                         %% stunnel -c -d localhost:5901 -r remotehost:5900\n"
"                         %% vncviewer localhost:1\n"
"\n"
"                       For Windows, stunnel has been ported to it and there\n"
"                       are probably other such tools available.  See the FAQ\n"
"                       for more examples.\n"
"\n"
"-stunnel3  [pem]       Use version 3.x stunnel command line syntax instead of\n"
"                       version 4.x\n"
"\n"
"-https [port]          Choose a separate HTTPS port (-ssl mode only).\n"
"\n"
"                       In -ssl mode, it turns out you can use the\n"
"                       single VNC port (e.g. 5900) for both VNC and HTTPS\n"
"                       connections. (HTTPS is used to retrieve a SSL-aware\n"
"                       VncViewer.jar applet that is provided with x11vnc).\n"
"                       Since both use SSL the implementation was extended to\n"
"                       detect if HTTP traffic (i.e. GET) is taking place and\n"
"                       handle it accordingly.  The URL would be, e.g.:\n"
"\n"
"                       https://mymachine.org:5900/\n"
"\n"
"                       This is convenient for firewalls, etc, because only one\n"
"                       port needs to be allowed in.  However, this heuristic\n"
"                       adds a few seconds delay to each connection and can be\n"
"                       unreliable (especially if the user takes much time to\n"
"                       ponder the Certificate dialogs in his browser, Java VM,\n"
"                       or VNC Viewer applet.  That's right 3 separate \"Are\n"
"                       you sure you want to connect?\" dialogs!)\n"
"\n"
"                       So use the -https option to provide a separate, more\n"
"                       reliable HTTPS port that x11vnc will listen on.  If\n"
"                       [port] is not provided (or is 0), one is autoselected.\n"
"                       The URL to use is printed out at startup.\n"
"\n"
"                       The SSL Java applet directory is specified via the\n"
"                       -httpdir option.  If not supplied it will try to guess\n"
"                       the directory as though the -http option was supplied.\n"
"\n"
"-httpsredir [port]     In -ssl mode with the Java applet retrieved via HTTPS:\n"
"                       when the HTML file containing applet parameters\n"
"                       ('index.vnc' or 'proxy.vnc') is sent do not set the\n"
"                       applet PORT parameter to the actual VNC port but set it\n"
"                       to \"port\" instead.  If \"port\" is not supplied, then\n"
"                       the port number is guessed from the Host: HTTP header.\n"
"\n"
"                       This is useful when an incoming TCP connection\n"
"                       redirection is performed by a router/gateway/firewall\n"
"                       from one port to an internal machine where x11vnc is\n"
"                       listening on a different port. The Java applet needs to\n"
"                       connect to the firewall/router port, not the VNC port\n"
"                       on the internal workstation. For example, one could\n"
"                       redir from mygateway.com:443 to workstation:5900.\n"
"\n"
"                       This spares the user from having to type in\n"
"                       https://mygateway.com/?PORT=443 into their web browser\n"
"                       (note 443 is the default https port; other ports must\n"
"                       be explicity indicated: https://mygateway.com:8000/...)\n"
"\n"
#endif
"-usepw                 If no other password method was supplied on the command\n"
"                       line, first look for ~/.vnc/passwd and if found use it\n"
"                       with -rfbauth; next, look for ~/.vnc/passwdfile and\n"
"                       use it with -passwdfile; otherwise, prompt the user\n"
"                       for a password to create ~/.vnc/passwd and use it with\n"
"                       the -rfbauth option.  If none of these succeed x11vnc\n"
"                       exits immediately.\n"
"\n"
"-storepasswd pass file Store password \"pass\" as the VNC password in the\n"
"                       file \"file\".  Once the password is stored the\n"
"                       program exits.  Use the password via \"-rfbauth file\"\n"
"\n"
"                       If called with no arguments, \"x11vnc -storepasswd\",\n"
"                       the user is prompted for a password and it is stored\n"
"                       in the file ~/.vnc/passwd.  Called with one argument,\n"
"                       that will be the file to store the prompted password in.\n"
"\n"
"-nopw                  Disable the big warning message when you use x11vnc\n"
"                       without some sort of password.\n"
"\n"
"-accept string         Run a command (possibly to prompt the user at the\n"
"                       X11 display) to decide whether an incoming client\n"
"                       should be allowed to connect or not.  \"string\" is\n"
"                       an external command run via system(3) or some special\n"
"                       cases described below.  Be sure to quote \"string\"\n"
"                       if it contains spaces, shell characters, etc.  If the\n"
"                       external command returns 0 the client is accepted,\n"
"                       otherwise the client is rejected.  See below for an\n"
"                       extension to accept a client view-only.\n"
"\n"
"                       If x11vnc is running as root (say from inetd(8) or from\n"
"                       display managers xdm(1), gdm(1), etc), think about the\n"
"                       security implications carefully before supplying this\n"
"                       option (likewise for the -gone option).\n"
"\n"
"                       Environment: The RFB_CLIENT_IP environment variable will\n"
"                       be set to the incoming client IP number and the port\n"
"                       in RFB_CLIENT_PORT (or -1 if unavailable).  Similarly,\n"
"                       RFB_SERVER_IP and RFB_SERVER_PORT (the x11vnc side\n"
"                       of the connection), are set to allow identification\n"
"                       of the tcp virtual circuit.  The x11vnc process\n"
"                       id will be in RFB_X11VNC_PID, a client id number in\n"
"                       RFB_CLIENT_ID, and the number of other connected clients\n"
"                       in RFB_CLIENT_COUNT.  RFB_MODE will be \"accept\".\n"
"                       RFB_STATE will be PROTOCOL_VERSION, SECURITY_TYPE,\n"
"                       AUTHENTICATION, INITIALISATION, NORMAL, or UNKNOWN\n"
"                       indicating up to which state the client has acheived.\n"
"                       RFB_LOGIN_VIEWONLY will be 0, 1, or -1 (unknown).\n"
"                       RFB_USERNAME, RFB_LOGIN_TIME, and RFB_CURRENT_TIME may\n"
"                       also be set.\n"
"\n"
"                       If \"string\" is \"popup\" then a builtin popup window\n"
"                       is used.  The popup will time out after 120 seconds,\n"
"                       use \"popup:N\" to modify the timeout to N seconds\n"
"                       (use 0 for no timeout).\n"
"\n"
"                       In the case of \"popup\" and when the -unixpw option\n"
"                       is specified, then a *second* window will be popped\n"
"                       up after the user successfully logs in via his UNIX\n"
"                       password.  This time the user will be identified as\n"
"                       UNIX:username@hostname, the \"UNIX:\" prefix indicates\n"
"                       which user the viewer logged as via -unixpw.  The first\n"
"                       popup is only for whether to allow him to even *try*\n"
"                       to login via unix password.\n"
"\n"
"                       If \"string\" is \"xmessage\" then an xmessage(1)\n"
"                       invocation is used for the command.  xmessage must be\n"
"                       installed on the machine for this to work.\n"
"\n"
"                       Both \"popup\" and \"xmessage\" will present an option\n"
"                       for accepting the client \"View-Only\" (the client\n"
"                       can only watch).  This option will not be presented if\n"
"                       -viewonly has been specified, in which case the entire\n"
"                       display is view only.\n"
"\n"
"                       If the user supplied command is prefixed with something\n"
"                       like \"yes:0,no:*,view:3 mycommand ...\" then this\n"
"                       associates the numerical command return code with\n"
"                       the actions: accept, reject, and accept-view-only,\n"
"                       respectively.  Use \"*\" instead of a number to indicate\n"
"                       the default action (in case the command returns an\n"
"                       unexpected value).  E.g. \"no:*\" is a good choice.\n"
"\n"
"                       Note that x11vnc blocks while the external command\n"
"                       or popup is running (other clients may see no updates\n"
"                       during this period).  So a person sitting a the physical\n"
"                       display is needed to respond to an popup prompt. (use\n"
"                       a 2nd x11vnc if you lock yourself out).\n"
"\n"
"                       More -accept tricks: use \"popupmouse\" to only allow\n"
"                       mouse clicks in the builtin popup to be recognized.\n"
"                       Similarly use \"popupkey\" to only recognize\n"
"                       keystroke responses.  These are to help avoid the\n"
"                       user accidentally accepting a client by typing or\n"
"                       clicking. All 3 of the popup keywords can be followed\n"
"                       by +N+M to supply a position for the popup window.\n"
"                       The default is to center the popup window.\n"
"-afteraccept string    As -accept, except to run a user supplied command after\n"
"                       a client has been accepted and authenticated. RFB_MODE\n"
"                       will be set to \"afteraccept\" and the other RFB_*\n"
"                       variables are as in -accept.  Unlike -accept, the\n"
"                       command return code is not interpreted by x11vnc.\n"
"                       Example: -afteraccept 'killall xlock &'\n"
"-gone string           As -accept, except to run a user supplied command when\n"
"                       a client goes away (disconnects).  RFB_MODE will be\n"
"                       set to \"gone\" and the other RFB_* variables are as\n"
"                       in -accept.  The \"popup\" actions apply as well.\n"
"                       Unlike -accept, the command return code is not\n"
"                       interpreted by x11vnc.  Example: -gone 'xlock &'\n"
"\n"
"-users list            If x11vnc is started as root (say from inetd(8) or from\n"
"                       display managers xdm(1), gdm(1), etc), then as soon\n"
"                       as possible after connections to the X display are\n"
"                       established try to switch to one of the users in the\n"
"                       comma separated \"list\".  If x11vnc is not running as\n"
"                       root this option is ignored.\n"
"\n"
"                       Why use this option?  In general it is not needed since\n"
"                       x11vnc is already connected to the X display and can\n"
"                       perform its primary functions.  The option was added\n"
"                       to make some of the *external* utility commands x11vnc\n"
"                       occasionally runs work properly.  In particular under\n"
"                       GNOME and KDE to implement the \"-solid color\" feature\n"
"                       external commands (gconftool-2 and dcop) unfortunately\n"
"                       must be run as the user owning the desktop session.\n"
"                       Since this option switches userid it also affects the\n"
"                       userid used to run the processes for the -accept and\n"
"                       -gone options.  It also affects the ability to read\n"
"                       files for options such as -connect, -allow, and -remap\n"
"                       and also the ultra and tight filetransfer feature if\n"
"                       enabled.  Note that the -connect file is also sometimes\n"
"                       written to.\n"
"\n"
"                       So be careful with this option since in some situations\n"
"                       its use can decrease security.\n"
"\n"
"                       In general the switch to a user will only take place\n"
"                       if the display can still be successfully opened as that\n"
"                       user (this is primarily to try to guess the actual owner\n"
"                       of the session). Example: \"-users fred,wilma,betty\".\n"
"                       Note that a malicious local user \"barney\" by\n"
"                       quickly using \"xhost +\" when logging in may possibly\n"
"                       get the x11vnc process to switch to user \"fred\".\n"
"                       What happens next?\n"
"\n"
"                       Under display managers it may be a long time before\n"
"                       the switch succeeds (i.e. a user logs in).  To instead\n"
"                       make it switch immediately regardless if the display\n"
"                       can be reopened prefix the username with the \"+\"\n"
"                       character. E.g. \"-users +bob\" or \"-users +nobody\".\n"
"\n"
"                       The latter (i.e. switching immediately to user\n"
"                       \"nobody\") is the only obvious use of the -users option\n"
"                       that increases security.\n"
"\n"
"                       Use the following notation to associate a group with\n"
"                       a user: user1.group1,user2.group2,...  Note that\n"
"                       initgroups(2) will still be called first to try to\n"
"                       switch to ALL of a user's groups (primary and additional\n"
"                       groups).  Only if that fails or it is not available\n"
"                       then the single group specified as above (or the user's\n"
"                       primary group if not specified) is switched to with\n"
"                       setgid(2).  Use -env X11VNC_SINGLE_GROUP=1 to prevent\n"
"                       trying initgroups(2) and only switch to the single\n"
"                       group.  This sort of setting is only really needed to\n"
"                       make the ultra or tight filetransfer permissions work\n"
"                       properly. This format applies to any comma separated list\n"
"                       of users, even the special \"=\" modes described below.\n"
"\n"
"                       In -unixpw mode, if \"-users unixpw=\" is supplied\n"
"                       then after a user authenticates himself via the\n"
"                       -unixpw mechanism, x11vnc will try to switch to that\n"
"                       user as though \"-users +username\" had been supplied.\n"
"                       If you want to limit which users this will be done for,\n"
"                       provide them as a comma separated list after \"unixpw=\"\n"
"                       Groups can also be specified as described above.\n"
"\n"
"                       Similarly, in -ssl mode, if \"-users sslpeer=\" is\n"
"                       supplied then after an SSL client authenticates with his\n"
"                       cert (the -sslverify option is required for this) x11vnc\n"
"                       will extract a UNIX username from the \"emailAddress\"\n"
"                       field (username@hostname.com) of the \"Subject\" of the\n"
"                       x509 SSL cert and then try to switch to that user as\n"
"                       though \"-users +username\" had been supplied.  If you\n"
"                       want to limit which users this will be done for, provide\n"
"                       them as a comma separated list after \"sslpeer=\".\n"
"                       Set the env. var X11VNC_SSLPEER_CN to use the Common\n"
"                       Name (normally a hostname) instead of the Email field.\n"
"\n"
"                       NOTE: for sslpeer= mode the x11vnc administrator must\n"
"                       take care that any client certs he adds to -sslverify\n"
"                       have the intended UNIX username in the \"emailAddress\"\n"
"                       field of the cert.  Otherwise a user may be able to\n"
"                       log in as another.  This command can be of use in\n"
"                       checking: \"openssl x509 -text -in file.crt\", see the\n"
"                       \"Subject:\" line.  Also, along with the normal RFB_*\n"
"                       env. vars. (see -accept) passed to external cmd=\n"
"                       commands, RFB_SSL_CLIENT_CERT will be set to the\n"
"                       client's x509 certificate string.\n"
"\n"
"                       The sslpeer= mode can aid finding X sessions via the\n"
"                       FINDDISPLAY and FINDCREATEDISPLAY mechanisms.\n"
"\n"
"                       To immediately switch to a user *before* connections\n"
"                       to the X display are made or any files opened use the\n"
"                       \"=\" character: \"-users =bob\".  That user needs to\n"
"                       be able to open the X display and any files of course.\n"
"\n"
"                       The special user \"guess=\" means to examine the utmpx\n"
"                       database (see who(1)) looking for a user attached to\n"
"                       the display number (from DISPLAY or -display option)\n"
"                       and try him/her.  To limit the list of guesses, use:\n"
"                       \"-users guess=bob,betty\".\n"
"\n"
"                       Even more sinister is the special user \"lurk=\"\n"
"                       that means to try to guess the DISPLAY from the utmpx\n"
"                       login database as well.  So it \"lurks\" waiting for\n"
"                       anyone to log into an X session and then connects to it.\n"
"                       Specify a list of users after the = to limit which users\n"
"                       will be tried.  To enable a different searching mode, if\n"
"                       the first user in the list is something like \":0\" or\n"
"                       \":0-2\" that indicates a range of DISPLAY numbers that\n"
"                       will be tried (regardless of whether they are in the\n"
"                       utmpx database) for all users that are logged in.  Also\n"
"                       see the \"-display WAIT:...\" functionality.  Examples:\n"
"                       \"-users lurk=\" and also \"-users lurk=:0-1,bob,mary\"\n"
"\n"
"                       Be especially careful using the \"guess=\" and \"lurk=\"\n"
"                       modes.  They are not recommended for use on machines\n"
"                       with untrustworthy local users.\n"
"\n"
"-noshm                 Do not use the MIT-SHM extension for the polling.\n"
"                       Remote displays can be polled this way: be careful this\n"
"                       can use large amounts of network bandwidth.  This is\n"
"                       also of use if the local machine has a limited number\n"
"                       of shm segments and -onetile is not sufficient.\n"
"-flipbyteorder         Sometimes needed if remotely polled host has different\n"
"                       endianness.  Ignored unless -noshm is set.\n"
"-onetile               Do not use the new copy_tiles() framebuffer mechanism,\n"
"                       just use 1 shm tile for polling.  Limits shm segments\n"
"                       used to 3.\n"
"\n"
"-solid [color]         To improve performance, when VNC clients are connected\n"
"                       try to change the desktop background to a solid color.\n"
"                       The [color] is optional: the default color is \"cyan4\".\n"
"                       For a different one specify the X color (rgb.txt name,\n"
"                       e.g. \"darkblue\" or numerical \"#RRGGBB\").\n"
"\n"
"                       Currently this option only works on GNOME, KDE, CDE,\n"
"                       and classic X (i.e. with the background image on the\n"
"                       root window).  The \"gconftool-2\" and \"dcop\" external\n"
"                       commands are run for GNOME and KDE respectively.\n"
"                       Other desktops won't work, e.g. Xfce (send us the\n"
"                       corresponding commands if you find them).  If x11vnc is\n"
"                       running as root (inetd(8) or gdm(1)), the -users option\n"
"                       may be needed for GNOME and KDE.  If x11vnc guesses\n"
"                       your desktop incorrectly, you can force it by prefixing\n"
"                       color with \"gnome:\", \"kde:\", \"cde:\" or \"root:\".\n"
"-blackout string       Black out rectangles on the screen. \"string\" is a\n"
"                       comma separated list of WxH+X+Y type geometries for\n"
"                       each rectangle.  If one of the items on the list is the\n"
"                       string \"noptr\" the mouse pointer will not be allowed\n"
"                       to go into a blacked out region.\n"
"-xinerama              If your screen is composed of multiple monitors\n"
"-noxinerama            glued together via XINERAMA, and that screen is\n"
"                       not a rectangle this option will try to guess the\n"
"                       areas to black out (if your system has libXinerama).\n"
"                       default: %s\n"
"\n"
"                       In general, we have noticed on XINERAMA displays you may\n"
"                       need to use the \"-xwarppointer\" option if the mouse\n"
"                       pointer misbehaves and it is enabled by default. Use\n"
"                       \"-noxwarppointer\" if you do not want this.\n"
"\n"
"-xtrap                 Use the DEC-XTRAP extension for keystroke and mouse\n"
"                       input insertion.  For use on legacy systems, e.g. X11R5,\n"
"                       running an incomplete or missing XTEST extension.\n"
"                       By default DEC-XTRAP will be used if XTEST server grab\n"
"                       control is missing, use -xtrap to do the keystroke and\n"
"                       mouse insertion via DEC-XTRAP as well.\n"
"\n"
"-xrandr [mode]         If the display supports the XRANDR (X Resize, Rotate\n"
"                       and Reflection) extension, and you expect XRANDR events\n"
"                       to occur to the display while x11vnc is running, this\n"
"                       options indicates x11vnc should try to respond to\n"
"                       them (as opposed to simply crashing by assuming the\n"
"                       old screen size).  See the xrandr(1) manpage and run\n"
"                       'xrandr -q' for more info.  [mode] is optional and\n"
"                       described below.\n"
"\n"
"                       Since watching for XRANDR events and trapping errors\n"
"                       increases polling overhead, only use this option if\n"
"                       XRANDR changes are expected.  For example on a rotatable\n"
"                       screen PDA or laptop, or using a XRANDR-aware Desktop\n"
"                       where you resize often.  It is best to be viewing with a\n"
"                       vncviewer that supports the NewFBSize encoding, since it\n"
"                       knows how to react to screen size changes.  Otherwise,\n"
"                       libvncserver tries to do so something reasonable for\n"
"                       viewers that cannot do this (portions of the screen\n"
"                       may be clipped, unused, etc).\n"
"\n"
"                       \"mode\" defaults to \"resize\", which means create a\n"
"                       new, resized, framebuffer and hope all viewers can cope\n"
"                       with the change.  \"newfbsize\" means first disconnect\n"
"                       all viewers that do not support the NewFBSize VNC\n"
"                       encoding, and then resize the framebuffer.  \"exit\"\n"
"                       means disconnect all viewer clients, and then terminate\n"
"                       x11vnc.\n"
"\n"
"-rotate string         Rotate and/or flip the framebuffer view exported by VNC.\n"
"                       This transformation is independent of XRANDR and is\n"
"                       done in software in main memory and so may be slower.\n"
"                       This mode could be useful on a handheld with portrait or\n"
"                       landscape modes that do not correspond to the scanline\n"
"                       order of the actual framebuffer.  \"string\" can be:\n"
"\n"
"                             x     flip along x-axis\n"
"                             y     flip along y-axis\n"
"                            xy     flip along x- and y-axes\n"
"                           +90     rotate 90 degrees clockwise\n"
"                           -90     rotate 90 degrees counter-clockwise\n"
"                          +90x     rotate 90 degrees CW, then flip along x\n"
"                          +90y     rotate 90 degrees CW, then flip along y\n"
"\n"
"                       these give all possible rotations and reflections.\n"
"\n"
"                       Aliases: same as xy:  yx, +180, -180, 180\n"
"                                same as -90: +270, 270\n"
"                                same as +90: 90, (ditto for 90x, 90y)\n"
"\n"
"                       Like -scale, this transformation is applied at the very\n"
"                       end of any chain of framebuffer transformations and so\n"
"                       any options with geometries, e.g. -blackout, -clip, etc.\n"
"                       are relative to the original X (or -rawfb) framebuffer,\n"
"                       not the final one sent to VNC viewers.\n"
"\n"
"                       If you do not want the cursor shape to be rotated\n"
"                       prefix \"string\" with \"nc:\", e.g. \"nc:+90\",\n"
"                       \"nc:xy\", etc.\n"
"\n"
"-padgeom WxH           Whenever a new vncviewer connects, the framebuffer is\n"
"                       replaced with a fake, solid black one of geometry WxH.\n"
"                       Shortly afterwards the framebuffer is replaced with the\n"
"                       real one.  This is intended for use with vncviewers\n"
"                       that do not support NewFBSize and one wants to make\n"
"                       sure the initial viewer geometry will be big enough\n"
"                       to handle all subsequent resizes (e.g. under -xrandr,\n"
"                       -remote id:windowid, rescaling, etc.)\n"
"\n"
"-o logfile             Write stderr messages to file \"logfile\" instead of\n"
"                       to the terminal.  Same as \"-logfile file\".  To append\n"
"                       to the file use \"-oa file\" or \"-logappend file\".\n"
"-flag file             Write the \"PORT=NNNN\" (e.g. PORT=5900) string to\n"
"                       \"file\" in addition to stdout.  This option could be\n"
"                       useful by wrapper script to detect when x11vnc is ready.\n"
"\n"
"-rc filename           Use \"filename\" instead of $HOME/.x11vncrc for rc file.\n"
"-norc                  Do not process any .x11vncrc file for options.\n"
"\n"
"-env VAR=VALUE         Set the environment variable 'VAR' to value 'VALUE'\n"
"                       at x11vnc startup.  This is a convenience utility to\n"
"                       avoid shell script wrappers, etc. to set the env. var.\n"
"                       You may specify as many of these as needed on the\n"
"                       command line.\n"
"-prog /path/to/x11vnc  Set the full path to the x11vnc program for cases when\n"
"                       it cannot be determined from argv[0] (e.g. tcpd/inetd)\n"
"\n"
"-h, -help              Print this help text.\n"
"-?, -opts              Only list the x11vnc options.\n"
"-V, -version           Print program version and last modification date.\n"
"-license               Print out license information.  Same as -copying and\n"
"                       -warranty.\n"
"\n"
"-dbg                   Instead of exiting after cleaning up, run a simple\n"
"                       \"debug crash shell\" when fatal errors are trapped.\n"
"\n"
"-q, -quiet             Be quiet by printing less informational output to\n"
"                       stderr.\n"
"-v, -verbose           Print out more information to stderr.\n"
"\n"
"-bg                    Go into the background after screen setup.  Messages to\n"
"                       stderr are lost unless -o logfile is used.  Something\n"
"                       like this could be useful in a script:\n"
"                        port=`ssh -t $host \"x11vnc -display :0 -bg\" | grep PORT`\n"
"                        port=`echo \"$port\" | sed -e 's/PORT=//'`\n"
"                        port=`expr $port - 5900`\n"
"                        vncviewer $host:$port\n"
"\n"
"-modtweak              Option -modtweak automatically tries to adjust the AltGr\n"
"-nomodtweak            and Shift modifiers for differing language keyboards\n"
"                       between client and host.  Otherwise, only a single key\n"
"                       press/release of a Keycode is simulated (i.e. ignoring\n"
"                       the state of the modifiers: this usually works for\n"
"                       identical keyboards).  Also useful in resolving cases\n"
"                       where a Keysym is bound to multiple keys (e.g. \"<\" + \">\"\n"
"                       and \",\" + \"<\" keys).  Default: %s\n"
"\n"
"                       On some HP-UX systems it is been noted that they have\n"
"                       an odd keymapping where a single keycode will have a\n"
"                       keysym, e.g. \"#\", up to three times.  You can check\n"
"                       via \"xmodmap -pk\" or the -dk option.  The failure\n"
"                       is when you try to type \"#\" it yields \"3\".  If you\n"
"                       see this problem try setting the environment variable\n"
"                       MODTWEAK_LOWEST=1 to see if it helps.\n"
"\n"
"-xkb                   When in modtweak mode, use the XKEYBOARD extension (if\n"
"-noxkb                 the X display supports it) to do the modifier tweaking.\n"
"                       This is powerful and should be tried if there are still\n"
"                       keymapping problems when using -modtweak by itself.\n"
"                       The default is to check whether some common keysyms,\n"
"                       e.g. !, @, [, are only accessible via -xkb mode and if\n"
"                       so then automatically enable the mode.  To disable this\n"
"                       automatic detection use -noxkb.\n"
"\n"
"-capslock              When in -modtweak (the default) or -xkb mode,\n"
"                       if a keysym in the range A-Z comes in check the X\n"
"                       server to see if the Caps_Lock is set.  If it is do\n"
"                       not artificially press Shift to generate the keysym.\n"
"                       This will enable the CapsLock key to behave correctly\n"
"                       in some circumstances: namely *both* the VNC viewer\n"
"                       machine and the x11vnc X server are in the CapsLock\n"
"                       on state.  If one side has CapsLock on and the other\n"
"                       off and the keyboard is not behaving as you think it\n"
"                       should you should correct the CapsLock states (hint:\n"
"                       pressing CapsLock inside and outside of the viewer can\n"
"                       help toggle them both to the correct state).  However,\n"
"                       for best results do not use this option, but rather\n"
"                       *only* enable CapsLock on the VNC viewer side (i.e. by\n"
"                       pressing CapsLock outside of the viewer window, also\n"
"                       -skip_lockkeys below).  Also try -nomodtweak for a\n"
"                       possible workaround.\n"
"\n"
"-skip_lockkeys         Have x11vnc ignore all Caps_Lock, Shift_Lock, Num_Lock,\n"
"                       Scroll_Lock keysyms received from viewers.  The idea is\n"
"                       you press Caps_Lock on the VNC Viewer side but that does\n"
"                       not change the lock state in the x11vnc-side X server.\n"
"                       Nevertheless your capitalized letters come in over\n"
"                       the wire and are applied correctly to the x11vnc-side\n"
"                       X server.  Note this mode probably won't do what you\n"
"                       want in -nomodtweak mode.  Also, a kludge for KP_n\n"
"                       digits is always done it this mode: they are mapped to\n"
"                       regular digit keysyms.  See also -capslock above.\n"
"\n"
"-skip_keycodes string  Ignore the comma separated list of decimal keycodes.\n"
"                       Perhaps these are keycodes not on your keyboard but\n"
"                       your X server thinks exist.  Currently only applies\n"
"                       to -xkb mode.  Use this option to help x11vnc in the\n"
"                       reverse problem it tries to solve: Keysym -> Keycode(s)\n"
"                       when ambiguities exist (more than one Keycode per\n"
"                       Keysym).  Run 'xmodmap -pk' to see your keymapping.\n"
"                       Example: \"-skip_keycodes 94,114\"\n"
"-sloppy_keys           Experimental option that tries to correct some\n"
"                       \"sloppy\" key behavior.  E.g. if at the viewer you\n"
"                       press Shift+Key but then release the Shift before\n"
"                       Key that could give rise to extra unwanted characters\n"
"                       (usually only between keyboards of different languages).\n"
"                       Only use this option if you observe problems with\n"
"                       some keystrokes.\n"
"-skip_dups             Some VNC viewers send impossible repeated key events,\n"
"-noskip_dups           e.g. key-down, key-down, key-up, key-up all for the same\n"
"                       key, or 20 downs in a row for the same modifier key!\n"
"                       Setting -skip_dups means to skip these duplicates and\n"
"                       just process the first event. Note: some VNC viewers\n"
"                       assume they can send down's without the corresponding\n"
"                       up's and so you should not set this option for\n"
"                       these viewers (symptom: some keys do not autorepeat)\n"
"                       Default: %s\n"
"-add_keysyms           If a Keysym is received from a VNC viewer and that\n"
"-noadd_keysyms         Keysym does not exist in the X server, then add the\n"
"                       Keysym to the X server's keyboard mapping on an unused\n"
"                       key.  Added Keysyms will be removed periodically and\n"
"                       also when x11vnc exits.  Default: %s\n"
#if 0
"-xkbcompat             Ignore the XKEYBOARD extension.  Use as a workaround for\n"
"                       some keyboard mapping problems.  E.g. if you are using\n"
"                       an international keyboard (AltGr or ISO_Level3_Shift),\n"
"                       and the OS or keyboard where the VNC viewer is run\n"
"                       is not identical to that of the X server, and you are\n"
"                       having problems typing some keys.  Implies -nobell.\n"
#endif
"-clear_mods            At startup and exit clear the modifier keys by sending\n"
"                       KeyRelease for each one. The Lock modifiers are skipped.\n"
"                       Used to clear the state if the display was accidentally\n"
"                       left with any pressed down.\n"
"-clear_keys            As -clear_mods, except try to release any pressed key.\n"
"                       Note that this option and -clear_mods can interfere\n"
"                       with a person typing at the physical keyboard.\n"
"-remap string          Read Keysym remappings from file named \"string\".\n"
"                       Format is one pair of Keysyms per line (can be name\n"
"                       or hex value) separated by a space.  If no file named\n"
"                       \"string\" exists, it is instead interpreted as this\n"
"                       form: key1-key2,key3-key4,...  See <X11/keysymdef.h>\n"
"                       header file for a list of Keysym names, or use xev(1).\n"
"                       To map a key to a button click, use the fake Keysyms\n"
"                       \"Button1\", ..., etc. E.g: \"-remap Super_R-Button2\"\n"
"                       (useful for pasting on a laptop)\n"
"\n"
"                       To disable a keysym (i.e. make it so it will not be\n"
"                       injected), remap it to \"NoSymbol\" or \"None\".\n"
"\n"
"                       Dead keys: \"dead\" (or silent, mute) keys are keys that\n"
"                       do not produce a character but must be followed by a 2nd\n"
"                       keystroke.  This is often used for accenting characters,\n"
"                       e.g. to put \"`\" on top of \"a\" by pressing the dead\n"
"                       key and then \"a\".  Note that this interpretation\n"
"                       is not part of core X11, it is up to the toolkit or\n"
"                       application to decide how to react to the sequence.\n"
"                       The X11 names for these keysyms are \"dead_grave\",\n"
"                       \"dead_acute\", etc.  However some VNC viewers send the\n"
"                       keysyms \"grave\", \"acute\" instead thereby disabling\n"
"                       the accenting.  To work around this -remap can be used.\n"
"                       For example \"-remap grave-dead_grave,acute-dead_acute\"\n"
"                       As a convenience, \"-remap DEAD\" applies these remaps:\n"
"\n"
"                               g     grave-dead_grave\n"
"                               a     acute-dead_acute\n"
"                               c     asciicircum-dead_circumflex\n"
"                               t     asciitilde-dead_tilde\n"
"                               m     macron-dead_macron\n"
"                               b     breve-dead_breve\n"
"                               D     abovedot-dead_abovedot\n"
"                               d     diaeresis-dead_diaeresis\n"
"                               o     degree-dead_abovering\n"
"                               A     doubleacute-dead_doubleacute\n"
"                               r     caron-dead_caron\n"
"                               e     cedilla-dead_cedilla\n"
"\n"
"                       If you just want a subset use the first letter\n"
"                       label, e.g. \"-remap DEAD=ga\" to get the first two.\n"
"                       Additional remaps may also be supplied via commas,\n"
"                       e.g.  \"-remap DEAD=ga,Super_R-Button2\".  Finally,\n"
"                       \"DEAD=missing\" means to apply all of the above as\n"
"                       long as the left hand member is not already in the\n"
"                       X11 keymap.\n"
"\n"
"-norepeat              Option -norepeat disables X server key auto repeat when\n"
"-repeat                VNC clients are connected and VNC keyboard input is\n"
"                       not idle for more than 5 minutes.  This works around a\n"
"                       repeating keystrokes bug (triggered by long processing\n"
"                       delays between key down and key up client events: either\n"
"                       from large screen changes or high latency).\n"
"                       Default: %s\n"
"\n"
"                       Note: your VNC viewer side will likely do autorepeating,\n"
"                       so this is no loss unless someone is simultaneously at\n"
"                       the real X display.\n"
"\n"
"                       Use \"-norepeat N\" to set how many times norepeat will\n"
"                       be reset if something else (e.g. X session manager)\n"
"                       undoes it.  The default is 2.  Use a negative value\n"
"                       for unlimited resets.\n"
"\n"
"-nofb                  Ignore video framebuffer: only process keyboard and\n"
"                       pointer.  Intended for use with Win2VNC and x2vnc\n"
"                       dual-monitor setups.\n"
"-nobell                Do not watch for XBell events. (no beeps will be heard)\n"
"                       Note: XBell monitoring requires the XKEYBOARD extension.\n"
"-nosel                 Do not manage exchange of X selection/cutbuffer between\n"
"                       VNC viewers and the X server at all.\n"
"-noprimary             Do not poll the PRIMARY selection for changes to send\n"
"                       back to clients.  (PRIMARY is still set on received\n"
"                       changes, however).\n"
"-nosetprimary          Do not set the PRIMARY selection for changes received\n"
"                       from VNC clients.\n"
"-noclipboard           Do not poll the CLIPBOARD selection for changes to send\n"
"                       back to clients.  (CLIPBOARD is still set on received\n"
"                       changes, however).\n"
"-nosetclipboard        Do not set the CLIPBOARD selection for changes\n"
"                       received from VNC clients.\n"
"-seldir string         If direction string is \"send\", only send the selection\n"
"                       to viewers, and if it is \"recv\" only receive it from\n"
"                       viewers.  To work around apps setting the selection\n"
"                       too frequently and messing up the other end.  You can\n"
"                       actually supply a comma separated list of directions,\n"
"                       including \"debug\" to turn on debugging output.\n"
"\n"
"-cursor [mode]         Sets how the pointer cursor shape (little icon at the\n"
"-nocursor              mouse pointer) should be handled.  The \"mode\" string\n"
"                       is optional and is described below.  The default\n"
"                       is to show some sort of cursor shape(s).  How this\n"
"                       is done depends on the VNC viewer and the X server.\n"
"                       Use -nocursor to disable cursor shapes completely.\n"
"\n"
"                       Some VNC viewers support the TightVNC CursorPosUpdates\n"
"                       and CursorShapeUpdates extensions (cuts down on\n"
"                       network traffic by not having to send the cursor image\n"
"                       every time the pointer is moved), in which case these\n"
"                       extensions are used (see -nocursorshape and -nocursorpos\n"
"                       below to disable).  For other viewers the cursor shape\n"
"                       is written directly to the framebuffer every time the\n"
"                       pointer is moved or changed and gets sent along with\n"
"                       the other framebuffer updates.  In this case, there\n"
"                       will be some lag between the vnc viewer pointer and\n"
"                       the remote cursor position.\n"
"\n"
"                       If the X display supports retrieving the cursor shape\n"
"                       information from the X server, then the default is\n"
"                       to use that mode.  On Solaris this can be done with\n"
"                       the SUN_OVL extension using -overlay (see also the\n"
"                       -overlay_nocursor option).  A similar overlay scheme\n"
"                       is used on IRIX.  Xorg (e.g. Linux) and recent Solaris\n"
"                       Xsun servers support the XFIXES extension to retrieve\n"
"                       the exact cursor shape from the X server.  If XFIXES\n"
"                       is present it is preferred over Overlay and is used by\n"
"                       default (see -noxfixes below).  This can be disabled\n"
"                       with -nocursor, and also some values of the \"mode\"\n"
"                       option below.\n"
"\n"
"                       Note that under XFIXES cursors with transparency (alpha\n"
"                       channel) will usually not be exactly represented and one\n"
"                       may find Overlay preferable.  See also the -alphacut\n"
"                       and -alphafrac options below as fudge factors to try\n"
"                       to improve the situation for cursors with transparency\n"
"                       for a given theme.\n"
"\n"
"                       The \"mode\" string can be used to fine-tune the\n"
"                       displaying of cursor shapes.  It can be used the\n"
"                       following ways:\n"
"\n"
"                       \"-cursor arrow\" - just show the standard arrow\n"
"                       nothing more or nothing less.\n"
"\n"
"                       \"-cursor none\" - same as \"-nocursor\"\n"
"\n"
"                       \"-cursor X\" - when the cursor appears to be on the\n"
"                       root window, draw the familiar X shape.  Some desktops\n"
"                       such as GNOME cover up the root window completely,\n"
"                       and so this will not work, try \"X1\", etc, to try to\n"
"                       shift the tree depth.  On high latency links or slow\n"
"                       machines there will be a time lag between expected and\n"
"                       the actual cursor shape.\n"
"\n"
"                       \"-cursor some\" - like \"X\" but use additional\n"
"                       heuristics to try to guess if the window should have\n"
"                       a windowmanager-like resizer cursor or a text input\n"
"                       I-beam cursor.  This is a complete hack, but may be\n"
"                       useful in some situations because it provides a little\n"
"                       more feedback about the cursor shape.\n"
"\n"
"                       \"-cursor most\" - try to show as many cursors as\n"
"                       possible.  Often this will only be the same as \"some\"\n"
"                       unless the display has overlay visuals or XFIXES\n"
"                       extensions available.  On Solaris and IRIX if XFIXES\n"
"                       is not available, -overlay mode will be attempted.\n"
"\n"
"-cursor_drag           Show cursor shape changes even when the mouse is being\n"
"                       dragged with a mouse button down.  This is useful if you\n"
"                       want to be able to see Drag-and-Drop cursor icons, etc.\n"
"\n"
"-arrow n               Choose an alternate \"arrow\" cursor from a set of\n"
"                       some common ones.  n can be 1 to %d.  Default is: %d\n"
"                       Ignored when in XFIXES cursor-grabbing mode.\n"
"\n"
"-noxfixes              Do not use the XFIXES extension to draw the exact cursor\n"
"                       shape even if it is available.\n"
"-alphacut n            When using the XFIXES extension for the cursor shape,\n"
"                       cursors with transparency will not usually be displayed\n"
"                       exactly (but opaque ones will).  This option sets n as\n"
"                       a cutoff for cursors that have transparency (\"alpha\n"
"                       channel\" with values ranging from 0 to 255) Any cursor\n"
"                       pixel with alpha value less than n becomes completely\n"
"                       transparent.  Otherwise the pixel is completely opaque.\n"
"                       Default %d\n"
"\n"
"-alphafrac fraction    With the threshold in -alphacut some cursors will become\n"
"                       almost completely transparent because their alpha values\n"
"                       are not high enough.  For those cursors adjust the\n"
"                       alpha threshold until fraction of the non-zero alpha\n"
"                       channel pixels become opaque.  Default %.2f\n"
"-alpharemove           By default, XFIXES cursors pixels with transparency have\n"
"                       the alpha factor multiplied into the RGB color values\n"
"                       (i.e. that corresponding to blending the cursor with a\n"
"                       black background).  Specify this option to remove the\n"
"                       alpha factor. (useful for light colored semi-transparent\n"
"                       cursors).\n"
"-noalphablend          In XFIXES mode do not send cursor alpha channel data\n"
"                       to libvncserver.  The default is to send it.  The\n"
"                       alphablend effect will only be visible in -nocursorshape\n"
"                       mode or for clients with cursorshapeupdates turned\n"
"                       off. (However there is a hack for 32bpp with depth 24,\n"
"                       it uses the extra 8 bits to store cursor transparency\n"
"                       for use with a hacked vncviewer that applies the\n"
"                       transparency locally.  See the FAQ for more info).\n"
"\n"
"-nocursorshape         Do not use the TightVNC CursorShapeUpdates extension\n"
"                       even if clients support it.  See -cursor above.\n"
"-cursorpos             Option -cursorpos enables sending the X cursor position\n"
"-nocursorpos           back to all vnc clients that support the TightVNC\n"
"                       CursorPosUpdates extension.  Other clients will be able\n"
"                       to see the pointer motions. Default: %s\n"
"-xwarppointer          Move the pointer with XWarpPointer(3X) instead of\n"
"-noxwarppointer        the XTEST extension.  Use this as a workaround\n"
"                       if the pointer motion behaves incorrectly, e.g.\n"
"                       on touchscreens or other non-standard setups.\n"
"\n"
"                       It is also sometimes needed on XINERAMA displays and is\n"
"                       enabled by default if XINERAMA is found to be active.\n"
"                       To prevent this, use -noxwarppointer.\n"
"\n"
"-buttonmap string      String to remap mouse buttons.  Format: IJK-LMN, this\n"
"                       maps buttons I -> L, etc., e.g.  -buttonmap 13-31\n"
"\n"
"                       Button presses can also be mapped to keystrokes: replace\n"
"                       a button digit on the right of the dash with :<sym>:\n"
"                       or :<sym1>+<sym2>: etc. for multiple keys. For example,\n"
"                       if the viewing machine has a mouse-wheel (buttons 4 5)\n"
"                       but the x11vnc side does not, these will do scrolls:\n"
"                              -buttonmap 12345-123:Prior::Next:\n"
"                              -buttonmap 12345-123:Up+Up+Up::Down+Down+Down:\n"
"\n"
"                       See <X11/keysymdef.h> header file for a list of Keysyms,\n"
"                       or use the xev(1) program.  Note: mapping of button\n"
"                       clicks to Keysyms may not work if -modtweak or -xkb is\n"
"                       needed for the Keysym.\n"
"\n"
"                       If you include a modifier like \"Shift_L\" the\n"
"                       modifier's up/down state is toggled, e.g. to send\n"
"                       \"The\" use :Shift_L+t+Shift_L+h+e: (the 1st one is\n"
"                       shift down and the 2nd one is shift up). (note: the\n"
"                       initial state of the modifier is ignored and not reset)\n"
"                       To include button events use \"Button1\", ... etc.\n"
"\n"
"-nodragging            Do not update the display during mouse dragging events\n"
"                       (mouse button held down).  Greatly improves response on\n"
"                       slow setups, but you lose all visual feedback for drags,\n"
"                       text selection, and some menu traversals.  It overrides\n"
"                       any -pointer_mode setting.\n"
"\n"
#ifndef NO_NCACHE
"-ncache n              Client-side caching scheme.  Framebuffer memory \"n\"\n"
"                       (an integer) times that of the full display is allocated\n"
"                       below the actual framebuffer to cache screen contents\n"
"                       for rapid retrieval.  So a W x H frambuffer is expanded\n"
"                       to a W x (n+1)*H one.  Use 0 to disable.  Default: XXX.\n"
"\n"
"                       The \"n\" is actually optional, the default is 10.\n"
"\n"
"                       For this and the other -ncache* options below you can\n"
"                       abbreviate \"-ncache\" with \"-nc\".  Also, \"-nonc\"\n"
"                       is the same as \"-ncache 0\"\n"
"\n"
"                       This is an experimental option, currently implemented\n"
"                       in an awkward way in that in the VNC Viewer you can\n"
"                       see the cache contents if you scroll down, etc.  So you\n"
"                       will have to set things up so you can't see that region.\n"
"                       If this method is successful, the changes required for\n"
"                       clients to do this less awkwardly will be investigated.\n"
"\n"
"                       Note that this mode consumes a huge amount of memory,\n"
"                       both on the x11vnc server side and on the VNC Viewer\n"
"                       side.  If n=2 then the amount of RAM used is roughly\n"
"                       tripled for both x11vnc and the VNC Viewer.  As a rule\n"
"                       of thumb, note that 1280x1024 at depth 24 is about 5MB\n"
"                       of pixel data.\n"
"\n"
"                       For reasonable response when cycling through 4 to 6\n"
"                       large (e.g. web browser) windows a value n of 6 to 12\n"
"                       is recommended. (that's right: ~10X more memory...)\n"
"\n"
"                       Because of the way window backingstore and saveunders\n"
"                       are implemented, n must be even.  It will be incremented\n"
"                       by 1 if it is not.\n"
"\n"
"                       This mode also works for native MacOS X, but may not\n"
"                       be as effective as the X version.  This is due to a\n"
"                       number of things, one is the drop-shadow compositing\n"
"                       that leaves extra areas that need to be repaired (see\n"
"                       -ncache_pad).  Another is the window iconification\n"
"                       animations need to be avoided (see -macicontime).\n"
"                       It appears the that the 'Scale' animation mode gives\n"
"                       better results than the 'Genie' one.  Also, window event\n"
"                       detection not as accurate as the X version.\n"
"\n"
"-ncache_cr             In -ncache mode, try to do copyrect opaque window\n"
"                       moves/drags instead of wireframes (this can induce\n"
"                       painting errors).  The wireframe will still be used when\n"
"                       moving a window whose save-unders has not yet been set\n"
"                       or has been invalidated.\n"
"\n"
"                       Some VNC Viewers provide better response than others\n"
"                       with this option.  On Unix, realvnc viewer gives\n"
"                       smoother drags than tightvnc viewer.  Response may also\n"
"                       be choppy if the server side machine is too slow.\n"
"\n"
"                       Sometimes on very slow modem connections, this actually\n"
"                       gives an improvement because no pixel data at all\n"
"                       (not even the box animation) is sent during the drag.\n"
"\n"
"-ncache_no_moveraise   In -ncache mode, do not assume that moving a window\n"
"                       will cause the window manager to raise it to the top\n"
"                       of the stack.  The default is to assume it does, and\n"
"                       so at the beginning of any wireframe, etc, window moves\n"
"                       the window will be pushed to top in the VNC viewer.\n"
"\n"
"-ncache_no_dtchange    In -ncache mode, do not try to guess when the desktop\n"
"                       (viewport) changes to another one (i.e. another\n"
"                       workarea).  The default is to try to guess and when\n"
"                       detected try to make the transistion more smoothly.\n"
"\n"
"-ncache_no_rootpixmap  In -ncache mode, do not try to snapshot the desktop\n"
"                       background to use in guessing or reconstructing window\n"
"                       save-unders.\n"
"\n"
"-ncache_keep_anims     In -ncache mode, do not try to disable window\n"
"                       manager animations and other effects (that usually\n"
"                       degrade ncache performance or cause painting errors).\n"
"                       The default is to try to disable them on KDE (but not\n"
"                       GNOME) when VNC clients are connected.\n"
"\n"
"                       For other window managers or desktops that provide\n"
"                       animations, effects, compositing, translucency,\n"
"                       etc. that interfere with the -ncache method you will\n"
"                       have to disable them manually.\n"
"\n"
"-ncache_old_wm         In -ncache mode, enable some heuristics for old style\n"
"                       window managers such as fvwm and twm.\n"
"\n"
"-ncache_pad n          In -ncache mode, pad each window with n pixels for the\n"
"                       caching rectangles.  This can be used to try to improve\n"
"                       the situation with dropshadows or other compositing\n"
"                       (e.g. MacOS X window manager), although it could make\n"
"                       things worse.  The default is 0 on Unix and 24 on\n"
"                       MacOS X.\n"
"-debug_ncache          Turn on debugging and profiling output under -ncache.\n"
"\n"
#endif
"-wireframe [str]       Try to detect window moves or resizes when a mouse\n"
"-nowireframe           button is held down and show a wireframe instead of\n"
"                       the full opaque window.  This is based completely on\n"
"                       heuristics and may not always work: it depends on your\n"
"                       window manager and even how you move things around.\n"
"                       See -pointer_mode below for discussion of the \"bogging\n"
"                       down\" problem this tries to avoid.\n"
"                       Default: %s\n"
"\n"
"                       Shorter aliases:  -wf [str]  and -nowf\n"
"\n"
"                       The value \"str\" is optional and, of course, is\n"
"                       packed with many tunable parameters for this scheme:\n"
"\n"
"                       Format: shade,linewidth,percent,T+B+L+R,mod,t1+t2+t3+t4\n"
"                       Default: %s\n"
"\n"
"                       If you leave nothing between commas: \",,\" the default\n"
"                       value is used.  If you don't specify enough commas,\n"
"                       the trailing parameters are set to their defaults.\n"
"\n"
"                       \"shade\" indicate the \"color\" for the wireframe,\n"
"                       usually a greyscale: 0-255, however for 16 and 32bpp you\n"
"                       can specify an rgb.txt X color (e.g. \"dodgerblue\") or\n"
"                       a value > 255 is treated as RGB (e.g. red is 0xff0000).\n"
"                       \"linewidth\" sets the width of the wireframe in pixels.\n"
"                       \"percent\" indicates to not apply the wireframe scheme\n"
"                       to windows with area less than this percent of the\n"
"                       full screen.\n"
"\n"
"                       \"T+B+L+R\" indicates four integers for how close in\n"
"                       pixels the pointer has to be from the Top, Bottom, Left,\n"
"                       or Right edges of the window to consider wireframing.\n"
"                       This is a speedup to quickly exclude a window from being\n"
"                       wireframed: set them all to zero to not try the speedup\n"
"                       (scrolling and selecting text will likely be slower).\n"
"\n"
"                       \"mod\" specifies if a button down event in the\n"
"                       interior of the window with a modifier key (Alt, Shift,\n"
"                       etc.) down should indicate a wireframe opportunity.\n"
"                       It can be \"0\" or \"none\" to skip it, \"1\" or \"all\"\n"
"                       to apply it to any modifier, or \"Shift\", \"Alt\",\n"
"                       \"Control\", \"Meta\", \"Super\", or \"Hyper\" to only\n"
"                       apply for that type of modifier key.\n"
"\n"
"                       \"t1+t2+t3+t4\" specify four floating point times in\n"
"                       seconds: t1 is how long to wait for the pointer to move,\n"
"                       t2 is how long to wait for the window to start moving\n"
"                       or being resized (for some window managers this can be\n"
"                       rather long), t3 is how long to keep a wireframe moving\n"
"                       before repainting the window. t4 is the minimum time\n"
"                       between sending wireframe \"animations\".  If a slow\n"
"                       link is detected, these values may be automatically\n"
"                       changed to something better for a slow link.\n"
"\n"
"-nowireframelocal      By default, mouse motion and button presses of a\n"
"                       user sitting at the LOCAL display are monitored for\n"
"                       wireframing opportunities (so that the changes will be\n"
"                       sent efficiently to the VNC clients).  Use this option\n"
"                       to disable this behavior.\n"
"\n"
"-wirecopyrect mode     Since the -wireframe mechanism evidently tracks moving\n"
"-nowirecopyrect        windows accurately, a speedup can be obtained by\n"
"                       telling the VNC viewers to locally copy the translated\n"
"                       window region.  This is the VNC CopyRect encoding:\n"
"                       the framebuffer update doesn't need to send the actual\n"
"                       new image data.\n"
"\n"
"                       Shorter aliases:  -wcr [mode]  and -nowcr\n"
"\n"
"                       \"mode\" can be \"never\" (same as -nowirecopyrect)\n"
"                       to never try the copyrect, \"top\" means only do it if\n"
"                       the window was not covered by any other windows, and\n"
"                       \"always\" means to translate the orginally unobscured\n"
"                       region (this may look odd as the remaining pieces come\n"
"                       in, but helps on a slow link).  Default: \"%s\"\n"
"\n"
"                       Note: there can be painting errors or slow response\n"
"                       when using -scale so you may want to disable CopyRect\n"
"                       in this case \"-wirecopyrect never\" on the command\n"
"                       line or by remote-control.  Or you can also use the\n"
"                       \"-scale xxx:nocr\" scale option.\n"
"\n"
"-debug_wireframe       Turn on debugging info printout for the wireframe\n"
"                       heuristics.  \"-dwf\" is an alias.  Specify multiple\n"
"                       times for more output.\n"
"\n"
"-scrollcopyrect mode   Like -wirecopyrect, but use heuristics to try to guess\n"
"-noscrollcopyrect      if a window has scrolled its contents (either vertically\n"
"                       or horizontally).  This requires the RECORD X extension\n"
"                       to \"snoop\" on X applications (currently for certain\n"
"                       XCopyArea and XConfigureWindow X protocol requests).\n"
"                       Examples: Hitting <Return> in a terminal window when the\n"
"                       cursor was at the bottom, the text scrolls up one line.\n"
"                       Hitting <Down> arrow in a web browser window, the web\n"
"                       page scrolls up a small amount.  Or scrolling with a\n"
"                       scrollbar or mouse wheel.\n"
"\n"
"                       Shorter aliases:  -scr [mode]  and -noscr\n"
"\n"
"                       This scheme will not always detect scrolls, but when\n"
"                       it does there is a nice speedup from using the VNC\n"
"                       CopyRect encoding (see -wirecopyrect).  The speedup\n"
"                       is both in reduced network traffic and reduced X\n"
"                       framebuffer polling/copying.  On the other hand, it may\n"
"                       induce undesired transients (e.g. a terminal cursor\n"
"                       being scrolled up when it should not be) or other\n"
"                       painting errors (window tearing, bunching-up, etc).\n"
"                       These are automatically repaired in a short period\n"
"                       of time.  If this is unacceptable disable the feature\n"
"                       with -noscrollcopyrect.\n"
"\n"
"                       Screen clearing kludges:  for testing at least, there\n"
"                       are some \"magic key sequences\" (must be done in less\n"
"                       than 1 second) to aid repairing painting errors that\n"
"                       may be seen when using this mode:\n"
"\n"
"                       3 Alt_L's   in a row: resend whole screen,\n"
"                       4 Alt_L's   in a row: reread and resend whole screen,\n"
"                       3 Super_L's in a row: mark whole screen for polling,\n"
"                       4 Super_L's in a row: reset RECORD context,\n"
"                       5 Super_L's in a row: try to push a black screen\n"
"\n"
"                       note: Alt_L is the Left \"Alt\" key (a single key)\n"
"                       Super_L is the Left \"Super\" key (Windows flag).\n"
"                       Both of these are modifier keys, and so should not\n"
"                       generate characters when pressed by themselves.  Also,\n"
"                       your VNC viewer may have its own refresh hot-key\n"
"                       or button.\n"
"\n"
"                       \"mode\" can be \"never\" (same as -noscrollcopyrect)\n"
"                       to never try the copyrect, \"keys\" means to try it\n"
"                       in response to keystrokes only, \"mouse\" means to\n"
"                       try it in response to mouse events only, \"always\"\n"
"                       means to do both. Default: \"%s\"\n"
"\n"
"                       Note: there can be painting errors or slow response\n"
"                       when using -scale so you may want to disable CopyRect\n"
"                       in this case \"-scrollcopyrect never\" on the command\n"
"                       line or by remote-control.  Or you can also use the\n"
"                       \"-scale xxx:nocr\" scale option.\n"
"\n"
"-scr_area n            Set the minimum area in pixels for a rectangle\n"
"                       to be considered for the -scrollcopyrect detection\n"
"                       scheme.  This is to avoid wasting the effort on small\n"
"                       rectangles that would be quickly updated the normal way.\n"
"                       E.g. suppose an app updated the position of its skinny\n"
"                       scrollbar first and then shifted the large panel\n"
"                       it controlled.  We want to be sure to skip the small\n"
"                       scrollbar and get the large panel. Default: %d\n"
"\n"
"-scr_skip list         Skip scroll detection for applications matching\n"
"                       the comma separated list of strings in \"list\".\n"
"                       Some applications implement their scrolling in\n"
"                       strange ways where the XCopyArea, etc, also applies\n"
"                       to invisible portions of the window: if we CopyRect\n"
"                       those areas it looks awful during the scroll and\n"
"                       there may be painting errors left after the scroll.\n"
"                       Soffice.bin is the worst known offender.\n"
"\n"
"                       Use \"##\" to denote the start of the application class\n"
"                       (e.g. \"##XTerm\") and \"++\" to denote the start\n"
"                       of the application instance name (e.g. \"++xterm\").\n"
"                       The string your list is matched against is of the form\n"
"                       \"^^WM_NAME##Class++Instance<same-for-any-subwindows>\"\n"
"                       The \"xlsclients -la\" command will provide this info.\n"
"\n"
"                       If a pattern is prefixed with \"KEY:\" it only applies\n"
"                       to Keystroke generated scrolls (e.g. Up arrow).  If it\n"
"                       is prefixed with \"MOUSE:\" it only applies to Mouse\n"
"                       induced scrolls (e.g. dragging on a scrollbar).\n"
"                       Default: %s\n"
"\n"
"-scr_inc list          Opposite of -scr_skip: this list is consulted first\n"
"                       and if there is a match the window will be monitored\n"
"                       via RECORD for scrolls irrespective of -scr_skip.\n"
"                       Use -scr_skip '*' to skip anything that does not match\n"
"                       your -scr_inc.  Use -scr_inc '*' to include everything.\n"
"\n"
"-scr_keys list         For keystroke scroll detection, only apply the RECORD\n"
"                       heuristics to the comma separated list of keysyms in\n"
"                       \"list\".  You may find the RECORD overhead for every\n"
"                       one of your keystrokes disrupts typing too much, but you\n"
"                       don't want to turn it off completely with \"-scr mouse\"\n"
"                       and -scr_parms does not work or is too confusing.\n"
"\n"
"                       The listed keysyms can be numeric or the keysym\n"
"                       names in the <X11/keysymdef.h> header file or from the\n"
"                       xev(1) program.  Example: \"-scr_keys Up,Down,Return\".\n"
"                       One probably wants to have application specific lists\n"
"                       (e.g. for terminals, etc) but that is too icky to think\n"
"                       about for now...\n"
"\n"
"                       If \"list\" begins with the \"-\" character the list\n"
"                       is taken as an exclude list: all keysyms except those\n"
"                       list will be considered.  The special string \"builtin\"\n"
"                       expands to an internal list of keysyms that are likely\n"
"                       to cause scrolls.  BTW, by default modifier keys,\n"
"                       Shift_L, Control_R, etc, are skipped since they almost\n"
"                       never induce scrolling by themselves.\n"
"\n"
"-scr_term list         Yet another cosmetic kludge.  Apply shell/terminal\n"
"                       heuristics to applications matching comma separated\n"
"                       list (same as for -scr_skip/-scr_inc).  For example an\n"
"                       annoying transient under scroll detection is if you\n"
"                       hit Enter in a terminal shell with full text window,\n"
"                       the solid text cursor block will be scrolled up.\n"
"                       So for a short time there are two (or more) block\n"
"                       cursors on the screen.  There are similar scenarios,\n"
"                       (e.g. an output line is duplicated).\n"
"\n"
"                       These transients are induced by the approximation of\n"
"                       scroll detection (e.g. it detects the scroll, but not\n"
"                       the fact that the block cursor was cleared just before\n"
"                       the scroll).  In nearly all cases these transient errors\n"
"                       are repaired when the true X framebuffer is consulted\n"
"                       by the normal polling.  But they are distracting, so\n"
"                       what this option provides is extra \"padding\" near the\n"
"                       bottom of the terminal window: a few extra lines near\n"
"                       the bottom will not be scrolled, but rather updated\n"
"                       from the actual X framebuffer.  This usually reduces\n"
"                       the annoying artifacts.  Use \"none\" to disable.\n"
"                       Default: \"%s\"\n"
"\n"
"-scr_keyrepeat lo-hi   If a key is held down (or otherwise repeats rapidly) and\n"
"                       this induces a rapid sequence of scrolls (e.g. holding\n"
"                       down an Arrow key) the \"scrollcopyrect\" detection\n"
"                       and overhead may not be able to keep up.  A time per\n"
"                       single scroll estimate is performed and if that estimate\n"
"                       predicts a sustainable scrollrate of keys per second\n"
"                       between \"lo\" and \"hi\" then repeated keys will be\n"
"                       DISCARDED to maintain the scrollrate. For example your\n"
"                       key autorepeat may be 25 keys/sec, but for a large\n"
"                       window or slow link only 8 scrolls per second can be\n"
"                       sustained, then roughly 2 out of every 3 repeated keys\n"
"                       will be discarded during this period. Default: \"%s\"\n"
"\n"
"-scr_parms string      Set various parameters for the scrollcopyrect mode.\n"
"                       The format is similar to that for -wireframe and packed\n"
"                       with lots of parameters:\n"
"\n"
"                       Format: T+B+L+R,t1+t2+t3,s1+s2+s3+s4+s5\n"
"                       Default: %s\n"
"\n"
"                       If you leave nothing between commas: \",,\" the default\n"
"                       value is used.  If you don't specify enough commas,\n"
"                       the trailing parameters are set to their defaults.\n"
"\n"
"                       \"T+B+L+R\" indicates four integers for how close in\n"
"                       pixels the pointer has to be from the Top, Bottom, Left,\n"
"                       or Right edges of the window to consider scrollcopyrect.\n"
"                       If -wireframe overlaps it takes precedence.  This is a\n"
"                       speedup to quickly exclude a window from being watched\n"
"                       for scrollcopyrect: set them all to zero to not try\n"
"                       the speedup (things like selecting text will likely\n"
"                       be slower).\n"
"\n"
"                       \"t1+t2+t3\" specify three floating point times in\n"
"                       seconds that apply to scrollcopyrect detection with\n"
"                       *Keystroke* input: t1 is how long to wait after a key\n"
"                       is pressed for the first scroll, t2 is how long to keep\n"
"                       looking after a Keystroke scroll for more scrolls.\n"
"                       t3 is how frequently to try to update surrounding\n"
"                       scrollbars outside of the scrolling area (0.0 to\n"
"                       disable)\n"
"\n"
"                       \"s1+s2+s3+s4+s5\" specify five floating point times\n"
"                       in seconds that apply to scrollcopyrect detection with\n"
"                       *Mouse* input: s1 is how long to wait after a mouse\n"
"                       button is pressed for the first scroll, s2 is how long\n"
"                       to keep waiting for additional scrolls after the first\n"
"                       Mouse scroll was detected.  s3 is how frequently to\n"
"                       try to update surrounding scrollbars outside of the\n"
"                       scrolling area (0.0 to disable).  s4 is how long to\n"
"                       buffer pointer motion (to try to get fewer, bigger\n"
"                       mouse scrolls). s5 is the maximum time to spend just\n"
"                       updating the scroll window without updating the rest\n"
"                       of the screen.\n"
"\n"
"-fixscreen string      Periodically \"repair\" the screen based on settings\n"
"                       in \"string\".  Hopefully you won't need this option,\n"
"                       it is intended for cases when the -scrollcopyrect or\n"
"                       -wirecopyrect features leave too many painting errors,\n"
"                       but it can be used for any scenario.  This option\n"
"                       periodically performs costly operations and so\n"
"                       interactive response may be reduced when it is on.\n"
"                       You can use 3 Alt_L's (the Left \"Alt\" key) taps in\n"
"                       a row (as described under -scrollcopyrect) instead to\n"
"                       manually request a screen repaint when it is needed.\n"
"\n"
"                       \"string\" is a comma separated list of one or more of\n"
"                       the following: \"V=t\", \"C=t\", \"X=t\", and \"8=t\".\n"
"                       In these \"t\" stands for a time in seconds (it is\n"
"                       a floating point even though one should usually use\n"
"                       values > 2 to avoid wasting resources).  V sets how\n"
"                       frequently the entire screen should be sent to viewers\n"
"                       (it is like the 3 Alt_L's).  C sets how long to wait\n"
"                       after a CopyRect to repaint the full screen.  X sets\n"
"                       how frequently to reread the full X11 framebuffer from\n"
"                       the X server and push it out to connected viewers.\n"
"                       Use of X should be rare, please report a bug if you\n"
"                       find you need it. 8= applies only for -8to24 mode: it\n"
"                       sets how often the non-default visual regions of the\n"
"                       screen (e.g. 8bpp windows) are refreshed.  Examples:\n"
"                       -fixscreen V=10 -fixscreen C=10\n"
"\n"
"-debug_scroll          Turn on debugging info printout for the scroll\n"
"                       heuristics.  \"-ds\" is an alias.  Specify it multiple\n"
"                       times for more output.\n"
"\n"
"-noxrecord             Disable any use of the RECORD extension.  This is\n"
"                       currently used by the -scrollcopyrect scheme and to\n"
"                       monitor X server grabs.\n"
"\n"
"-grab_buster           Some of the use of the RECORD extension can leave a\n"
"-nograb_buster         tiny window for XGrabServer deadlock.  This is only if\n"
"                       the whole-server grabbing application expects mouse or\n"
"                       keyboard input before releasing the grab.  It is usually\n"
"                       a window manager that does this.  x11vnc takes care to\n"
"                       avoid the the problem, but if caught x11vnc will freeze.\n"
"                       Without -grab_buster, the only solution is to go the\n"
"                       physical display and give it some input to satisfy the\n"
"                       grabbing app.  Or manually kill and restart the window\n"
"                       manager if that is feasible.  With -grab_buster, x11vnc\n"
"                       will fork a helper thread and if x11vnc appears to be\n"
"                       stuck in a grab after a period of time (20-30 sec) then\n"
"                       it will inject some user input: button clicks, Escape,\n"
"                       mouse motion, etc to try to break the grab.  If you\n"
"                       experience a lot of grab deadlock, please report a bug.\n"
"\n"
"-debug_grabs           Turn on debugging info printout with respect to\n"
"                       XGrabServer() deadlock for -scrollcopyrect mode.\n"
"\n"
"-debug_sel             Turn on debugging info printout with respect to\n"
"                       PRIMARY, CLIPBOARD, and CUTBUFFER0 selections.\n"
"\n"
"-pointer_mode n        Various pointer motion update schemes. \"-pm\" is\n"
"                       an alias.  The problem is pointer motion can cause\n"
"                       rapid changes on the screen: consider the rapid\n"
"                       changes when you drag a large window around opaquely.\n"
"                       Neither x11vnc's screen polling and vnc compression\n"
"                       routines nor the bandwidth to the vncviewers can keep\n"
"                       up these rapid screen changes: everything will bog down\n"
"                       when dragging or scrolling.  So a scheme has to be used\n"
"                       to \"eat\" much of that pointer input before re-polling\n"
"                       the screen and sending out framebuffer updates. The\n"
"                       mode number \"n\" can be 0 to %d and selects one of\n"
"                       the schemes desribed below.\n"
"\n"
"                       Note that the -wireframe and -scrollcopyrect modes\n"
"                       complement -pointer_mode by detecting (and improving)\n"
"                       certain periods of \"rapid screen change\".\n"
"\n"
"                       n=0: does the same as -nodragging. (all screen polling\n"
"                       is suspended if a mouse button is pressed.)\n"
"\n"
"                       n=1: was the original scheme used to about Jan 2004:\n"
"                       it basically just skips -input_skip keyboard or pointer\n"
"                       events before repolling the screen.\n"
"\n"
"                       n=2 is an improved scheme: by watching the current rate\n"
"                       of input events it tries to detect if it should try to\n"
"                       \"eat\" additional pointer events before continuing.\n"
"\n"
"                       n=3 is basically a dynamic -nodragging mode: it detects\n"
"                       when the mouse motion has paused and then refreshes\n"
"                       the display.\n"
"\n"
"                       n=4 attempts to measures network rates and latency,\n"
"                       the video card read rate, and how many tiles have been\n"
"                       changed on the screen.  From this, it aggressively tries\n"
"                       to push screen \"frames\" when it decides it has enough\n"
"                       resources to do so.  NOT FINISHED.\n"
"\n"
"                       The default n is %d. Note that modes 2, 3, 4 will skip\n"
"                       -input_skip keyboard events (but it will not count\n"
"                       pointer events).  Also note that these modes are not\n"
"                       available in -threads mode which has its own pointer\n"
"                       event handling mechanism.\n"
"\n"
"                       To try out the different pointer modes to see which\n"
"                       one gives the best response for your usage, it is\n"
"                       convenient to use the remote control function, for\n"
"                       example \"x11vnc -R pm:4\" or the tcl/tk gui (Tuning ->\n"
"                       pointer_mode -> n).\n"
"\n"
"-input_skip n          For the pointer handling when non-threaded: try to\n"
"                       read n user input events before scanning display. n < 0\n"
"                       means to act as though there is always user input.\n"
"                       Default: %d\n"
"\n"
"-allinput              Have x11vnc read and process all available client input\n"
"                       before proceeding.\n"
"\n"
"-speeds rd,bw,lat      x11vnc tries to estimate some speed parameters that\n"
"                       are used to optimize scheduling (e.g. -pointer_mode\n"
"                       4, -wireframe, -scrollcopyrect) and other things.\n"
"                       Use the -speeds option to set these manually.\n"
"                       The triple \"rd,bw,lat\" corresponds to video h/w\n"
"                       read rate in MB/sec, network bandwidth to clients in\n"
"                       KB/sec, and network latency to clients in milliseconds,\n"
"                       respectively.  If a value is left blank, e.g. \"-speeds\n"
"                       ,100,15\", then the internal scheme is used to estimate\n"
"                       the empty value(s).\n"
"\n"
"                       Typical PC video cards have read rates of 5-10 MB/sec.\n"
"                       If the framebuffer is in main memory instead of video\n"
"                       h/w (e.g. SunRay, shadowfb, dummy driver, Xvfb), the\n"
"                       read rate may be much faster.  \"x11perf -getimage500\"\n"
"                       can be used to get a lower bound (remember to factor\n"
"                       in the bytes per pixel).  It is up to you to estimate\n"
"                       the network bandwith and latency to clients.  For the\n"
"                       latency the ping(1) command can be used.\n"
"\n"
"                       For convenience there are some aliases provided,\n"
"                       e.g. \"-speeds modem\".  The aliases are: \"modem\" for\n"
"                       6,4,200; \"dsl\" for 6,100,50; and \"lan\" for 6,5000,1\n"
"\n"
"-wmdt string           For some features, e.g. -wireframe and -scrollcopyrect,\n"
"                       x11vnc has to work around issues for certain window\n"
"                       managers or desktops (currently kde and xfce).\n"
"                       By default it tries to guess which one, but it can\n"
"                       guess incorrectly.  Use this option to indicate which\n"
"                       wm/dt.  \"string\" can be \"gnome\", \"kde\", \"cde\",\n"
"                       \"xfce\", or \"root\" (classic X wm).  Anything else\n"
"                       is interpreted as \"root\".\n"
"\n"
"-debug_pointer         Print debugging output for every pointer event.\n"
"-debug_keyboard        Print debugging output for every keyboard event.\n"
"                       Same as -dp and -dk, respectively.  Use multiple\n"
"                       times for more output.\n"
"\n"
"-defer time            Time in ms to wait for updates before sending to client\n"
"                       (deferUpdateTime)  Default: %d\n"
"-wait time             Time in ms to pause between screen polls.  Used to cut\n"
"                       down on load.  Default: %d\n"
"-wait_ui factor        Factor by which to cut the -wait time if there\n"
"                       has been recent user input (pointer or keyboard).\n"
"                       Improves response, but increases the load whenever you\n"
"                       are moving the mouse or typing.  Default: %.2f\n"
"-nowait_bog            Do not detect if the screen polling is \"bogging down\"\n"
"                       and sleep more.  Some activities with no user input can\n"
"                       slow things down a lot: consider a large terminal window\n"
"                       with a long build running in it continously streaming\n"
"                       text output.  By default x11vnc will try to detect this\n"
"                       (3 screen polls in a row each longer than 0.25 sec with\n"
"                       no user input), and sleep up to 1.5 secs to let things\n"
"                       \"catch up\".  Use this option to disable that detection.\n"
"-slow_fb time          Floating point time in seconds delay all screen polling.\n"
"                       For special purpose usage where a low frame rate is\n"
"                       acceptable and desirable, but you want the user input\n"
"                       processed at the normal rate so you cannot use -wait.\n"
"-xrefresh time         Floating point time in seconds to indicate how often to\n"
"                       do the equivalent of xrefresh(1) to force all windows\n"
"                       (in the viewable area if -id, -sid, or -clip is used)\n"
"                       to repaint themselves.  Use this only if applications\n"
"                       misbehave by not repainting themselves properly.\n"
"                       See also -noxdamage.\n"
"-readtimeout n         Set libvncserver rfbMaxClientWait to n seconds. On\n"
"                       slow links that take a long time to paint the first\n"
"                       screen libvncserver may hit the timeout and drop the\n"
"                       connection.  Default: %d seconds.\n"
"-nap                   Monitor activity and if it is low take longer naps\n"
"-nonap                 between screen polls to really cut down load when idle.\n"
"                       Default: %s\n"
"-sb time               Time in seconds after NO activity (e.g. screen blank)\n"
"                       to really throttle down the screen polls (i.e. sleep\n"
"                       for about 1.5 secs). Use 0 to disable.  Default: %d\n"
"\n"
"-nofbpm                If the system supports the FBPM (Frame Buffer Power\n"
"-fbpm                  Management) extension (i.e. some Sun systems), then\n"
"                       prevent the video h/w from going into a reduced power\n"
"                       state when VNC clients are connected.\n"
"\n"
"                       FBPM capable video h/w save energy when the workstation\n"
"                       is idle by going into low power states (similar to DPMS\n"
"                       for monitors).  This interferes with x11vnc's polling\n"
"                       of the framebuffer data.\n"
"\n"
"                       \"-nofbpm\" means prevent FBPM low power states whenever\n"
"                       VNC clients are connected, while \"-fbpm\" means to not\n"
"                       monitor the FBPM state at all.  See the xset(1) manpage\n"
"                       for details.  -nofbpm is basically the same as running\n"
"                       \"xset fbpm force on\" periodically.  Default: %s\n"
"\n"
"-nodpms                If the system supports the DPMS (Display Power Management\n"
"-dpms                  Signaling) extension, then prevent the monitor from\n"
"                       going into a reduced power state when VNC clients\n"
"                       are connected.\n"
"\n"
"                       DPMS reduced power monitor states are a good thing\n"
"                       and you normally want the power down to take place\n"
"                       (usually x11vnc has no problem exporting the display in\n"
"                       this state).  You probably only want to use \"-nodpms\"\n"
"                       to work around problems with Screen Savers kicking\n"
"                       on in DPMS low power states.  There is known problem\n"
"                       with kdesktop_lock on KDE where the screen saver keeps\n"
"                       kicking in every time user input stops for a second\n"
"                       or two.  Specifying \"-nodpms\" works around it.\n"
"\n"
"                       \"-nodpms\" means prevent DPMS low power states whenever\n"
"                       VNC clients are connected, while \"-dpms\" means to not\n"
"                       monitor the DPMS state at all.  See the xset(1) manpage\n"
"                       for details.  -nodpms is basically the same as running\n"
"                       \"xset dpms force on\" periodically.  Default: %s\n"
"\n"
"-forcedpms             If the system supports the DPMS (Display Power\n"
"                       Management Signaling) extension, then try to keep the\n"
"                       monitor in a powered off state.  This is to prevent\n"
"                       nosey people at the physical display from viewing\n"
"                       what is on the screen.  Be sure lock the screen before\n"
"                       disconnecting.\n"
"\n"
"                       This method is far from bullet proof, e.g. suppose\n"
"                       someone attaches a non-DPMS monitor, or loads the\n"
"                       machine so that there is a gap of time before x11vnc\n"
"                       restores the powered off state?  On many machines if\n"
"                       he floods it with keyboard and mouse input he can see\n"
"                       flashes of what is on the screen before the DPMS off\n"
"                       state is reestablished.  For this to work securely\n"
"                       there would need to be support in the X server to do\n"
"                       this exactly rather than approximately with DPMS.\n"
"\n"
"-clientdpms            As -forcedpms but only when VNC clients are connected.\n"
"\n"
"-noserverdpms          The UltraVNC ServerInput extension is supported.\n"
"                       This allows the VNC viewer to click a button that will\n"
"                       cause the server (x11vnc) to try to disable keyboard\n"
"                       and mouse input at the physical display and put the\n"
"                       monitor in dpms powered off state.  Use this option to\n"
"                       skip powering off the monitor.\n"
"\n"
"-noultraext            Disable the following UltraVNC extensions: SingleWindow\n"
"                       and ServerInput.  The others managed by libvncserver\n"
"                       (textchat, 1/n scaling, rfbEncodingUltra) are not.\n"
"\n"
"-noxdamage             Do not use the X DAMAGE extension to detect framebuffer\n"
"                       changes even if it is available.  Use -xdamage if your\n"
"                       default is to have it off.\n"
"\n"
"                       x11vnc's use of the DAMAGE extension: 1) significantly\n"
"                       reduces the load when the screen is not changing much,\n"
"                       and 2) detects changed areas (small ones by default)\n"
"                       more quickly.\n"
"\n"
"                       Currently the DAMAGE extension is overly conservative\n"
"                       and often reports large areas (e.g. a whole terminal\n"
"                       or browser window) as damaged even though the actual\n"
"                       changed region is much smaller (sometimes just a few\n"
"                       pixels).  So heuristics were introduced to skip large\n"
"                       areas and use the damage rectangles only as \"hints\"\n"
"                       for the traditional scanline polling.  The following\n"
"                       tuning parameters are introduced to adjust this\n"
"                       behavior:\n"
"\n"
"-xd_area A             Set the largest DAMAGE rectangle area \"A\" (in\n"
"                       pixels: width * height) to trust as truly damaged:\n"
"                       the rectangle will be copied from the framebuffer\n"
"                       (slow) no matter what.  Set to zero to trust *all*\n"
"                       rectangles. Default: %d\n"
"-xd_mem f              Set how long DAMAGE rectangles should be \"remembered\",\n"
"                       \"f\" is a floating point number and is in units of the\n"
"                       scanline repeat cycle time (%d iterations).  The default\n"
"                       (%.1f) should give no painting problems. Increase it if\n"
"                       there are problems or decrease it to live on the edge\n"
"                       (perhaps useful on a slow machine).\n"
"\n"
"-sigpipe string        Broken pipe (SIGPIPE) handling.  \"string\" can be\n"
"                       \"ignore\" or \"exit\".  For \"ignore\" libvncserver\n"
"                       will handle the abrupt loss of a client and continue,\n"
"                       for \"exit\" x11vnc will cleanup and exit at the 1st\n"
"                       broken connection.\n"
"\n"
"                       This option is not really needed since libvncserver\n"
"                       is doing the correct thing now for quite some time.\n"
"                       However, for convenience you can use it to ignore other\n"
"                       signals, e.g. \"-sigpipe ignore:HUP,INT,TERM\" in case\n"
"                       that would be useful for some sort of application.\n"
"                       You can also put \"exit:..\" in the list to have x11vnc\n"
"                       cleanup on the listed signals. \"-sig\" is an alias\n"
"                       for this option if you don't like the 'pipe'. Example:\n"
"                       -sig ignore:INT,TERM,exit:USR1\n"
"\n"
"-threads               Whether or not to use the threaded libvncserver\n"
"-nothreads             algorithm [rfbRunEventLoop] if libpthread is available\n"
"                       Default: %s\n"
"\n"
"-fs f                  If the fraction of changed tiles in a poll is greater\n"
"                       than f, the whole screen is updated.  Default: %.2f\n"
"-gaps n                Heuristic to fill in gaps in rows or cols of n or\n"
"                       less tiles.  Used to improve text paging.  Default: %d\n"
"-grow n                Heuristic to grow islands of changed tiles n or wider\n"
"                       by checking the tile near the boundary.  Default: %d\n"
"-fuzz n                Tolerance in pixels to mark a tiles edges as changed.\n"
"                       Default: %d\n"
"-debug_tiles           Print debugging output for tiles, fb updates, etc.\n"
"\n"
"-snapfb                Instead of polling the X display framebuffer (fb)\n"
"                       for changes, periodically copy all of X display fb\n"
"                       into main memory and examine that copy for changes.\n"
"                       (This setting also applies for non-X -rawfb modes).\n"
"                       Under some circumstances this will improve interactive\n"
"                       response, or at least make things look smoother, but in\n"
"                       others (most!) it will make the response worse.  If the\n"
"                       video h/w fb is such that reading small tiles is very\n"
"                       slow this mode could help.  To keep the \"framerate\"\n"
"                       up the screen size x bpp cannot be too large.  Note that\n"
"                       this mode is very wasteful of memory I/O resources\n"
"                       (it makes full screen copies even if nothing changes).\n"
"                       It may be of use in video capture-like applications,\n"
"                       webcams, or where window tearing is a problem.\n"
"\n"
"-rawfb string          Instead of polling X, poll the memory object specified\n"
"                       in \"string\".\n"
"\n"
"                       For file polling to memory map mmap(2) a file use:\n"
"                       \"map:/path/to/a/file@WxHxB\", with framebuffer Width,\n"
"                       Height, and Bits per pixel.  \"mmap:...\" is the\n"
"                       same.\n"
"\n"
"                       If there is trouble with mmap, use  \"file:/...\"\n"
"                       for slower lseek(2) based reading.  Use \"snap:...\"\n"
"                       to imply -snapfb mode and the \"file:\" access (this\n"
"                       is for devices that only provide the fb all at once).\n"
"\n"
"                       For shared memory segments string is of the form:\n"
"                       \"shm:N@WxHxB\" which specifies a shmid N and with\n"
"                       WxHxB as above.  See shmat(1) and ipcs(1)\n"
"\n"
"                       If you do not supply a type \"map\" is assumed if\n"
"                       the file exists (see the next paragraphs for some\n"
"                       exceptions to this.)\n"
"\n"
"                       If string is \"setup:cmd\", then the command \"cmd\"\n"
"                       is run and the first line from it is read and used\n"
"                       as \"string\".  This allows initializing the device,\n"
"                       determining WxHxB, etc. These are often done as root\n"
"                       so take care.\n"
"\n"
"                       If the string begins with \"video\", see the VIDEO4LINUX\n"
"                       discusion below where the device may be queried for\n"
"                       (and possibly set) the framebuffer parameters.\n"
"\n"
"                       If the string begins with \"console\", \"/dev/fb\", or\n"
"                       \"fb\", see the LINUX CONSOLE discussion below where\n"
"                       the framebuffer device is opened and keystrokes (and\n"
"                       possibly mouse events) are inserted into the console.\n"
"\n"
"                       If the string begins with \"vnc\", see the VNC HOST\n"
"                       discussion below where the framebuffer is taken as that\n"
"                       of another remote VNC server.\n"
"\n"
"                       Optional suffixes are \":R/G/B\" and \"+O\" to specify\n"
"                       red, green, and blue masks and an offset into the\n"
"                       memory object.  If the masks are not provided x11vnc\n"
"                       guesses them based on the bpp.\n"
"\n"
"                       Another optional suffix is the Bytes Per Line which in\n"
"                       some cases is not WxB/4.  Specify it as WxHxB-BPL\n"
"                       e.g. 800x600x16-2048.  This could be a normal width\n"
"                       1024 at 16bpp fb, but only width 800 shows up.\n"
"\n"
"                       Examples:\n"
"                           -rawfb shm:210337933@800x600x32:ff/ff00/ff0000\n"
"                           -rawfb map:/dev/fb0@1024x768x32\n"
"                           -rawfb map:/tmp/Xvfb_screen0@640x480x8+3232\n"
"                           -rawfb file:/tmp/my.pnm@250x200x24+37\n"
"                           -rawfb file:/dev/urandom@128x128x8\n"
"                           -rawfb snap:/dev/video0@320x240x24 -24to32\n"
"                           -rawfb video0\n"
"                           -rawfb video -pipeinput VID\n"
"                           -rawfb console\n"
"                           -rawfb vnc:somehost:0\n"
"\n"
"                       (see ipcs(1) and fbset(1) for the first two examples)\n"
"\n"
"                       In general all user input is discarded by default (see\n"
"                       the -pipeinput option for how to use a helper program\n"
"                       to insert).  Most of the X11 (screen, keyboard, mouse)\n"
"                       options do not make sense and many will cause this\n"
"                       mode to crash, so please think twice before setting or\n"
"                       changing them in a running x11vnc.\n"
"\n"
"                       If you DO NOT want x11vnc to close the X DISPLAY in\n"
"                       rawfb mode, prepend a \"+\" e.g. +file:/dev/fb0...\n"
"                       Keeping the display open enables the default\n"
"                       remote-control channel, which could be useful.\n"
"                       Alternatively, if you specify -noviewonly, then the\n"
"                       mouse and keyboard input are STILL sent to the X\n"
"                       display, this usage should be very rare, i.e. doing\n"
"                       something strange with /dev/fb0.\n"
"\n"
"                       If the device is not \"seekable\" (e.g. webcam) try\n"
"                       reading it all at once in full snaps via the \"snap:\"\n"
"                       mode (note: this is a resource hog).  If you are using\n"
"                       file: or map: and the device needs to be reopened for\n"
"                       *every* snapfb snapshot, set the environment variable:\n"
"                       SNAPFB_RAWFB_RESET=1 as well.\n"
"\n"
"                       If you want x11vnc to dynamically transform a 24bpp\n"
"                       rawfb to 32bpp (note that this will be slower) also\n"
"                       supply the -24to32 option.  This would be useful for,\n"
"                       say, a video camera that delivers the pixel data as\n"
"                       24bpp packed RGB.  This is the default under \"video\"\n"
"                       mode if the bpp is 24.\n"
"\n"
"                       VIDEO4LINUX: on Linux some attempt is made to handle\n"
"                       video devices (webcams or TV tuners) automatically.\n"
"                       The idea is the WxHxB will be extracted from the\n"
"                       device itself.  So if you do not supply \"@WxHxB...\n"
"                       parameters x11vnc will try to determine them.  It first\n"
"                       tries the v4l API if that support has been compiled in.\n"
"                       Otherwise it will run the v4l-info(1) external program\n"
"                       if it is available.\n"
"\n"
"                       The simplest examples are \"-rawfb video\" and \"-rawfb\n"
"                       video1\" which imply the device file /dev/video and\n"
"                       /dev/video1, respectively.  You can also supply the\n"
"                       /dev if you like, e.g. \"-rawfb /dev/video0\"\n"
"\n"
"                       Since the video capture device framebuffer usually\n"
"                       changes continuously (e.g. brightness fluctuations),\n"
"                       you may want to use the -wait, -slow_fb, or -defer\n"
"                       options to lower the \"framerate\" to cut down on\n"
"                       network VNC traffic.\n"
"\n"
"                       A more sophisticated video device scheme allows\n"
"                       initializing the device's settings using:\n"
"\n"
"                           -rawfb video:<settings>\n"
"\n"
"                       The prefix could also be, as above, e.g. \"video1:\" to\n"
"                       specify the device file.  The v4l API must be available\n"
"                       for this to work.  Otherwise, you will need to try\n"
"                       to initialize the device with an external program,\n"
"                       e.g. xawtv, spcaview, and hope they persist when x11vnc\n"
"                       re-opens the device.\n"
"\n"
"                       <settings> is a comma separated list of key=value pairs.\n"
"                       The device's brightness, color, contrast, and hue can\n"
"                       be set to percentages, e.g. br=80,co=50,cn=44,hu=60.\n"
"\n"
"                       The device filename can be set too if needed (if it\n"
"                       does not start with \"video\"), e.g. fn=/dev/qcam.\n"
"\n"
"                       The width, height and bpp of the framebuffer can be\n"
"                       set via, e.g., w=160,h=120,bpp=16.\n"
"\n"
"                       Related to the bpp above, the pixel format can be set\n"
"                       via the fmt=XXX, where XXX can be one of: GREY, HI240,\n"
"                       RGB555, RGB565, RGB24, and RGB32 (with bpp 8, 8, 16, 16,\n"
"                       24, and 32 respectively).  See http://www.linuxtv.org\n"
"                       for more info (V4L api).\n"
"\n"
"                       For TV/rf tuner cards one can set the tuning mode\n"
"                       via tun=XXX where XXX can be one of PAL, NTSC, SECAM,\n"
"                       or AUTO.\n"
"\n"
"                       One can switch the input channel by the inp=XXX setting,\n"
"                       where XXX is the name of the input channel (Television,\n"
"                       Composite1, S-Video, etc).  Use the name that is in the\n"
"                       information about the device that is printed at startup.\n"
"\n"
"                       For input channels with tuners (e.g. Television) one\n"
"                       can change which station is selected by the sta=XXX\n"
"                       setting.  XXX is the station number.  Currently only\n"
"                       the ntsc-cable-us (US cable) channels are built into\n"
"                       x11vnc.  See the -freqtab option below to supply one\n"
"                       from xawtv. If XXX is greater than 500, then it is\n"
"                       interpreted as a raw frequency in KHz.\n"
"\n"
"                       Example:\n"
"\n"
"                       -rawfb video:br=80,w=320,h=240,fmt=RGB32,tun=NTSC,sta=47\n"
"\n"
"                       one might need to add inp=Television too for the input\n"
"                       channel to be TV if the card doesn't come up by default\n"
"                       in that one.\n"
"\n"
"                       Note that not all video capture devices will support\n"
"                       all of the above settings.\n"
"\n"
"                       See the -pipeinput VID option below for a way to control\n"
"                       the settings through the VNC Viewer via keystrokes.\n"
"                       As a shortcut, if the string begins \"Video..\" instead\n"
"                       of \"video..\" then -pipeinput VID is implied.\n"
"\n"
"                       As above, if you specify a \"@WxHxB...\" after the\n"
"                       <settings> string they are used verbatim: the device\n"
"                       is not queried for the current values.  Otherwise the\n"
"                       device will be queried.\n"
"\n"
"                       LINUX CONSOLE:  If the libvncserver LinuxVNC program\n"
"                       is on your system you may want to use that instead of\n"
"                       the following method because it will be faster and more\n"
"                       accurate for Linux text console.\n"
"\n"
"                       If the rawfb string begins with \"console\" the\n"
"                       framebuffer device /dev/fb0 is opened (this requires\n"
"                       the appropriate kernel modules to be installed) and so\n"
"                       is /dev/tty0.  The latter is used to inject keystrokes\n"
"                       (not all are supported, but the basic ones are).\n"
"                       You will need to be root to inject keystrokes.\n"
"                       /dev/tty0 refers to the active VT, to indicate one\n"
"                       explicitly, use \"console2\", etc. using the VT number.\n"
"\n"
"                       If the Linux version seems to be 2.6 or later and the\n"
"                       \"uinput\" module appears to be present, then the uinput\n"
"                       method will be used instead of /dev/ttyN.  uinput allows\n"
"                       insertion of BOTH keystrokes and mouse input and so it\n"
"                       preferred when accessing graphical (e.g. QT-embedded)\n"
"                       linux console apps.  See -pipeinput UINPUT below for\n"
"                       more information on this mode; you will have to use\n"
"                       -pipeinput if you want to tweak any UINPUT parameters.\n"
"                       You may also want to also use the -nodragging and\n"
"                       -cursor none options.  Use \"console0\", etc  or\n"
"                       -pipeinput CONSOLE to force the /dev/ttyN method.\n"
"\n"
"                       Note you can change VT remotely using the chvt(1)\n"
"                       command.  Sometimes switching out and back corrects\n"
"                       the framebuffer state.\n"
"\n"
"                       To skip input injecting entirely use \"consolex\".\n"
"\n"
"                       The string \"/dev/fb0\" (1, etc.) can be used instead\n"
"                       of \"console\".  This can be used to specify a different\n"
"                       framebuffer device, e.g. /dev/fb1.  As a shortcut the\n"
"                       \"/dev/\" can be dropped.  If the name is something\n"
"                       nonstandard, use \"console:/dev/foofb\"\n"
"\n"
"                       If you do not want x11vnc to guess the framebuffer's\n"
"                       WxHxB and masks automatically (sometimes the kernel\n"
"                       gives inaccurate information), specify them with a\n"
"                       @WxHxB at the end of the string.\n"
"\n"
"                       Examples:\n"
"                           -rawfb console\n"
"                           -rawfb /dev/fb0           (same)\n"
"                           -rawfb console3           (force /dev/tty3)\n"
"                           -rawfb consolex           (no keystrokes or mouse)\n"
"                           -rawfb console:/dev/nonstd\n"
"                           -rawfb console -pipeinput UINPUT:accel=4.0\n"
"\n"
"                       VNC HOST: if the -rawfb string is of the form\n"
"                       \"vnc:host:N\" then the VNC display \"N\" on the remote\n"
"                       VNC server \"host\" is connected to (i.e. x11vnc acts as\n"
"                       a VNC client itself) and that framebuffer is exported.\n"
"\n"
"                       This mode is really only of use if you are trying\n"
"                       to improve performance in the case of many (e.g. >\n"
"                       10) simultaneous VNC viewers, and you try a divide\n"
"                       and conquer scheme to reduce bandwidth and improve\n"
"                       responsiveness.\n"
"\n"
"                       For example, if there will be 64 simultaneous VNC\n"
"                       viewers this can lead to a lot of redundant VNC traffic\n"
"                       to and from the server host:N, extra CPU usage,\n"
"                       and all viewers response can be reduced by having\n"
"                       to wait for writes to the slowest client to finish.\n"
"                       However, if you set up 8 reflectors/repeaters started\n"
"                       with option -rawfb vnc:host:N, then there are only\n"
"                       8 connections to host:N.  Each repeater then handles\n"
"                       8 vnc viewer connections thereby spreading the load\n"
"                       around.  In classroom broadcast usage, try to put the\n"
"                       repeaters on different switches.  This mode is the same\n"
"                       as -reflect host:N.  Replace \"host:N\" by \"listen\"\n"
"                       or \"listen:port\" for a reverse connection.\n"
"\n"
"                       Overall performance will not be as good as a single\n"
"                       direct connection because, among other things,\n"
"                       there is an additional level of framebuffer polling\n"
"                       and pointer motion can still induce many changes per\n"
"                       second that must be propagated.  Tip: if the remote VNC\n"
"                       is x11vnc doing wireframing, or an X display that does\n"
"                       wireframing that gives much better response than opaque\n"
"                       window dragging.  Consider the -nodragging option if\n"
"                       the problem is severe.\n"
"\n"
"                       The VNC HOST mode implies -shared.  Use -noshared as\n"
"                       a subsequent cmdline option to disable sharing.\n"
"\n"
"-freqtab file          For use with \"-rawfb video\" for TV tuner devices to\n"
"                       specify station frequencies.  Instead of using the built\n"
"                       in ntsc-cable-us mapping of station number to frequency,\n"
"                       use the data in file.  For stations that are not\n"
"                       numeric, e.g. SE20, they are placed above the highest\n"
"                       numbered station in the order they are found.  Example:\n"
"                       \"-freqtab /usr/X11R6/share/xawtv/europe-west.list\"\n"
"                       You can make your own freqtab by copying the xawtv\n"
"                       format.\n"
"\n"
"-pipeinput cmd         This option lets you supply an external command in\n"
"                       \"cmd\" that x11vnc will pipe all of the user input\n"
"                       events to in a simple format.  In -pipeinput mode by\n"
"                       default x11vnc will not process any of the user input\n"
"                       events.  If you prefix \"cmd\" with \"tee:\" it will\n"
"                       both send them to the pipe command and process them.\n"
"                       For a description of the format run \"-pipeinput\n"
"                       tee:/bin/cat\".  Another prefix is \"reopen\" which\n"
"                       means to reopen pipe if it exits.  Separate multiple\n"
"                       prefixes with commas.\n"
"\n"
"                       In combination with -rawfb one might be able to\n"
"                       do amusing things (e.g. control non-X devices).\n"
"                       To facilitate this, if -rawfb is in effect then the\n"
"                       value is stored in X11VNC_RAWFB_STR for the pipe command\n"
"                       to use if it wants. Do 'env | grep X11VNC' for more.\n"
"\n"
"                       Built-in pipeinput modes (no external program required):\n"
"\n"
"                       If cmd is \"VID\" and you are using the -rawfb for a\n"
"                       video capture device, then an internal list of keyboard\n"
"                       mappings is used to set parameters of the video.\n"
"                       The mappings are:\n"
"\n"
"                         \"B\" and \"b\" adjust the brightness up and down.\n"
"                         \"H\" and \"h\" adjust the hue.\n"
"                         \"C\" and \"c\" adjust the colour.\n"
"                         \"N\" and \"n\" adjust the contrast.\n"
"                         \"S\" and \"s\" adjust the size of the capture screen.\n"
"                         \"I\" and \"i\" cycle through input channels.\n"
"                         Up and Down arrows adjust the station (if a tuner)\n"
"                         F1, F2, ..., F6 will switch the video capture pixel\n"
"                         format to HI240, RGB565, RGB24, RGB32, RGB555, and\n"
"                         GREY respectively.  See -rawfb video for details.\n"
"\n"
"                       If cmd is \"CONSOLE\" or \"CONSOLEn\" where n\n"
"                       is a Linux console number, then the linux console\n"
"                       keystroke insertion to /dev/ttyN (see -rawfb console)\n"
"                       is performed.\n"
"\n"
"                       If cmd begins with \"UINPUT\" then the Linux uinput\n"
"                       module is used to insert both keystroke and mouse events\n"
"                       to the Linux console (see -rawfb above).  This usually\n"
"                       is the /dev/input/uinput device file (you may need to\n"
"                       create it with \"mknod /dev/input/uinput c 10 223\"\n"
"                       and insert the module with \"modprobe uinput\".\n"
"\n"
"                       The UINPUT mode currently only does US keyboards (a\n"
"                       scan code option may be added), and not all keysyms\n"
"                       are supported.\n"
"\n"
"                       You may want to use the options -cursor none and\n"
"                       -nodragging in this mode.\n"
"\n"
"                       Additional tuning options may be supplied via:\n"
"                       UINPUT:opt1,opt2,... (a comma separated list). If an\n"
"                       option begins with \"/\" it is taken as the uinput\n"
"                       device file.\n"
"                       \n"
"                       Which uinput is injected can be controlled by an option\n"
"                       string made of the characters \"K\", \"M\", and \"B\"\n"
"                       (see the -input option), e.g. \"KM\" allows keystroke\n"
"                       and motion but not button clicks.\n"
"\n"
"                       A UINPUT option of the form: accel=f, or accel=fx+fy\n"
"                       sets the mouse motion \"acceleration\".  This is used\n"
"                       to correct raw mouse relative motion into how much the\n"
"                       application cursor moves (x11vnc has no control over,\n"
"                       or knowledge of how the windowing application interprets\n"
"                       the raw mouse motions).  Typically the acceleration\n"
"                       for an X display is 2 (see xset \"m\" option).  \"f\"\n"
"                       is a floating point number, e.g. 3.0.  Use \"fx+fy\"\n"
"                       if you need to supply different corrections for x and y.\n"
"\n"
"                       Note: the default acceleration is 2.0 since it seems\n"
"                       both X and qt-embedded often (but not always) use\n"
"                       this value.\n"
"\n"
"                       Even with a correct accel setting the mouse position\n"
"                       will get out of sync (probably due to a mouse\n"
"                       \"threshold\" setting where the acceleration doe not\n"
"                       apply, set xset(1)).  The option reset=N sets the\n"
"                       number of ms (default 150) after which the cursor is\n"
"                       attempted to be reset (by forcing the mouse to (0,\n"
"                       0) via small increments and then back out to (x, y)\n"
"                       in 1 jump), This correction seems to be needed but can\n"
"                       cause jerkiness or unexpected behavior with menus, etc.\n"
"                       Use reset=0 to disable.\n"
"\n"
"                       If the uinput device has an absolute pointer (as opposed\n"
"                       to a normal mouse that is a relative pointer) you can\n"
"                       specify the option \"abs\".  Note that a touchpad\n"
"                       on a laptop is an absolute device to some degree.\n"
"                       This (usually) avoids all the problems with mouse\n"
"                       acceleration.  If x11vnc has trouble deducing the size\n"
"                       of the device, use \"abs=WxH\".  Furthermore, if the\n"
"                       device is a touchscreen (assumed to have an absolute\n"
"                       pointer) use \"touch\" or \"touch=WxH\".\n"
"\n"
"                       If you set the env. var X11VNC_UINPUT_THRESHOLDS then\n"
"                       the thresh=n mode will be enabled.  It is currently\n"
"                       not working well.  If |dx| <= thresh and |dy| < thresh\n"
"                       no acceleration is applied.  Use \"thresh=+n\" |dx| +\n"
"                       |dy| < thresh to be used instead (X11?)\n"
"\n"
"                       Example:\n"
"                           -pipeinput UINPUT:accel=4.0 -cursor none\n"
"\n"
"                       You can also set the env. var X11VNC_UINPUT_DEBUG=1 or\n"
"                       higher to get debugging output for UINPUT mode.\n"
"\n"
"-macnodim              For the native Mac OS X server, disable dimming. \n"
"-macnosleep            For the native Mac OS X server, disable display sleep.\n"
"-macnosaver            For the native Mac OS X server, disable screensaver.\n"
"-macnowait             For the native Mac OS X server, do not wait for the\n"
"                       user to switch back to his display.\n"
"-macwheel n            For the native Mac OS X server, set the mouse wheel\n"
"                       speed to n (default 5).\n"
"-macnoswap             For the native Mac OS X server, do not swap mouse\n"
"                       buttons 2 and 3.\n"
"-macnoresize           For the native Mac OS X server, do not resize or reset\n"
"                       the framebuffer even if it is detected that the screen\n"
"                       resolution or depth has changed.\n"
"-maciconanim n         For the native Mac OS X server, set n to the number\n"
"                       of milliseconds that the window iconify/deiconify\n"
"                       animation takes.  In -ncache mode this value will be\n"
"                       used to skip the animation if possible. (default 400)\n"
"-macmenu               For the native Mac OS X server, in -ncache client-side\n"
"                       caching mode, try to cache pull down menus (not perfect\n"
"                       because they have animated fades, etc.)\n"
"\n"
"-gui [gui-opts]        Start up a simple tcl/tk gui based on the the remote\n"
"                       control options -remote/-query described below.\n"
"                       Requires the \"wish\" program to be installed on the\n"
"                       machine.  \"gui-opts\" is not required: the default\n"
"                       is to start up both the full gui and x11vnc with the\n"
"                       gui showing up on the X display in the environment\n"
"                       variable DISPLAY.\n"
"\n"
"                       \"gui-opts\" can be a comma separated list of items.\n"
"                       Currently there are these types of items: 1) a gui\n"
"                       mode, a 2) gui \"simplicity\", 3) the X display the\n"
"                       gui should display on, 4) a \"tray\" or \"icon\" mode,\n"
"                       and 5) a gui geometry.\n"
"\n"
"                       1) The gui mode can be \"start\", \"conn\", or \"wait\"\n"
"                       \"start\" is the default mode above and is not required.\n"
"                       \"conn\" means do not automatically start up x11vnc,\n"
"                       but instead just try to connect to an existing x11vnc\n"
"                       process.  \"wait\" means just start the gui and nothing\n"
"                       else (you will later instruct the gui to start x11vnc\n"
"                       or connect to an existing one.)\n"
"\n"
"                       2) The gui simplicity is off by default (a power-user\n"
"                       gui with all options is presented) To start with\n"
"                       something less daunting supply the string \"simple\"\n"
"                       (\"ez\" is an alias for this).  Once the gui is\n"
"                       started you can toggle between the two with \"Misc ->\n"
"                       simple_gui\".\n"
"\n"
"                       3) Note the possible confusion regarding the potentially\n"
"                       two different X displays: x11vnc polls one, but you\n"
"                       may want the gui to appear on another.  For example, if\n"
"                       you ssh in and x11vnc is not running yet you may want\n"
"                       the gui to come back to you via your ssh redirected X\n"
"                       display (e.g. localhost:10).\n"
"\n"
"                       If you do not specify a gui X display in \"gui-opts\"\n"
"                       then the DISPLAY environment variable and -display\n"
"                       option are tried (in that order).  Regarding the x11vnc\n"
"                       X display the gui will try to communication with, it\n"
"                       first tries -display and then DISPLAY.  For example,\n"
"                       \"x11vnc -display :0 -gui otherhost:0\", will remote\n"
"                       control an x11vnc polling :0 and display the gui on\n"
"                       otherhost:0 The \"tray/icon\" mode below reverses this\n"
"                       preference, preferring to display on the x11vnc display.\n"
"\n"
"                       4) When \"tray\" or \"icon\" is specified, the gui\n"
"                       presents itself as a small icon with behavior typical\n"
"                       of a \"system tray\" or \"dock applet\".  The color\n"
"                       of the icon indicates status (connected clients) and\n"
"                       there is also a balloon status.  Clicking on the icon\n"
"                       gives a menu from which properties, etc, can be set and\n"
"                       the full gui is available under \"Advanced\".  To be\n"
"                       fully functional, the gui mode should be \"start\"\n"
"                       (the default).\n"
"\n"
"                       For \"icon\" the gui just a small standalone window.\n"
"                       For \"tray\" it will attempt to embed itself in the\n"
"                       \"system tray\" if possible. If \"=setpass\" is appended then\n"
"                       at startup the X11 user will be prompted to set the\n"
"                       VNC session password.  If =<hexnumber> is appended\n"
"                       that icon will attempt to embed itself in the window\n"
"                       given by hexnumber.  Use =noadvanced to disable the\n"
"                       full gui. (To supply more than one, use \"+\" sign).\n"
"                       E.g. -gui tray=setpass and -gui icon=0x3600028\n"
"\n"
"                       Other modes: \"full\", the default and need not be\n"
"                       specified.  \"-gui none\", do not show a gui, useful\n"
"                       to override a ~/.x11vncrc setting, etc.\n"
"\n"
"                       5) When \"geom=+X+Y\" is specified, that geometry\n"
"                       is passed to the gui toplevel.  This is the icon in\n"
"                       icon/tray mode, or the full gui otherwise.  You can\n"
"                       also specify width and height, i.e. WxH+X+Y, but it\n"
"                       is not recommended.  In \"tray\" mode the geometry is\n"
"                       ignored unless the system tray manager does not seem\n"
"                       to be running.  One could imagine using something like\n"
"                       \"-gui tray,geom=+4000+4000\" with a display manager\n"
"                       to keep the gui invisible until someone logs in...\n"
"\n"
"                       More icon tricks, \"icon=minimal\" gives an icon just\n"
"                       with the VNC display number.  You can also set the font\n"
"                       with \"iconfont=...\".  The following could be useful:\n"
"                       \"-gui icon=minimal,iconfont=5x8,geom=24x10+0-0\"\n"
"\n"
"                       General examples of the -gui option: \"x11vnc -gui\",\n"
"                       \"x11vnc -gui ez\" \"x11vnc -gui localhost:10\",\n"
"                       \"x11vnc -gui conn,host:0\", \"x11vnc -gui tray,ez\"\n"
"                       \"x11vnc -gui tray=setpass\"\n"
"\n"
"                       If you do not intend to start x11vnc from the gui\n"
"                       (i.e. just remote control an existing one), then the\n"
"                       gui process can run on a different machine from the\n"
"                       x11vnc server as long as X permissions, etc. permit\n"
"                       communication between the two.\n"
"\n"
"-remote command        Remotely control some aspects of an already running\n"
"                       x11vnc server.  \"-R\" and \"-r\" are aliases for\n"
"                       \"-remote\".  After the remote control command is\n"
"                       sent to the running server the 'x11vnc -remote ...'\n"
"                       command exits.  You can often use the -query command\n"
"                       (see below) to see if the x11vnc server processed your\n"
"                       -remote command.\n"
"\n"
"                       The default communication channel is that of X\n"
"                       properties (specifically X11VNC_REMOTE), and so this\n"
"                       command must be run with correct settings for DISPLAY\n"
"                       and possibly XAUTHORITY to connect to the X server\n"
"                       and set the property.  Alternatively, use the -display\n"
"                       and -auth options to set them to the correct values.\n"
"                       The running server cannot use the -novncconnect option\n"
"                       because that disables the communication channel.\n"
"                       See below for alternate channels.\n"
"\n"
"                       For example: 'x11vnc -remote stop' (which is the same as\n"
"                       'x11vnc -R stop') will close down the x11vnc server.\n"
"                       'x11vnc -R shared' will enable shared connections, and\n"
"                       'x11vnc -R scale:3/4' will rescale the desktop.\n"
"\n"
"                       The following -remote/-R commands are supported:\n"
"\n"
"                       stop            terminate the server, same as \"quit\"\n"
"                                       \"exit\" or \"shutdown\".\n"
"                       ping            see if the x11vnc server responds.\n"
"                                       Return is: ans=ping:<xdisplay>\n"
"                       blacken         try to push a black fb update to all\n"
"                                       clients (due to timings a client\n"
"                                       could miss it). Same as \"zero\", also\n"
"                                       \"zero:x1,y1,x2,y2\" for a rectangle.\n"
"                       refresh         send the entire fb to all clients.\n"
"                       reset           recreate the fb, polling memory, etc.\n"
/* ext. cmd. */
"                       id:windowid     set -id window to \"windowid\". empty\n"
"                                       or \"root\" to go back to root window\n"
"                       sid:windowid    set -sid window to \"windowid\"\n"
"                       waitmapped      wait until subwin is mapped.\n"
"                       nowaitmapped    do not wait until subwin is mapped.\n"
"                       clip:WxH+X+Y    set -clip mode to \"WxH+X+Y\"\n"
"                       flashcmap       enable  -flashcmap mode.\n"
"                       noflashcmap     disable -flashcmap mode.\n"
"                       shiftcmap:n     set -shiftcmap to n.\n"
"                       notruecolor     enable  -notruecolor mode.\n"
"                       truecolor       disable -notruecolor mode.\n"
"                       overlay         enable  -overlay mode (if applicable).\n"
"                       nooverlay       disable -overlay mode.\n"
"                       overlay_cursor  in -overlay mode, enable cursor drawing.\n"
"                       overlay_nocursor disable cursor drawing. same as\n"
"                                        nooverlay_cursor.\n"
"                       8to24           enable  -8to24 mode (if applicable).\n"
"                       no8to24         disable -8to24 mode.\n"
"                       8to24_opts:str  set the -8to24 opts to \"str\".\n"
"                       24to32          enable  -24to32 mode (if applicable).\n"
"                       no24to32        disable -24to32 mode.\n"
"                       visual:vis      set -visual to \"vis\"\n"
"                       scale:frac      set -scale to \"frac\"\n"
"                       scale_cursor:f  set -scale_cursor to \"f\"\n"
"                       viewonly        enable  -viewonly mode.\n"
/* access view,share,forever */
"                       noviewonly      disable -viewonly mode.\n"
"                       shared          enable  -shared mode.\n"
"                       noshared        disable -shared mode.\n"
"                       forever         enable  -forever mode.\n"
"                       noforever       disable -forever mode.\n"
"                       timeout:n       reset -timeout to n, if there are\n"
"                                       currently no clients, exit unless one\n"
"                                       connects in the next n secs.\n"
"                       tightfilexfer   enable  filetransfer for NEW clients.\n"
"                       notightfilexfer disable filetransfer for NEW clients.\n"
"                       ultrafilexfer   enable  filetransfer for clients.\n"
"                       noultrafilexfer disable filetransfer for clients.\n"
"                       rfbversion:n.m  set -rfbversion for new clients.\n"
/* access */
"                       http            enable  http client connections.\n"
"                       nohttp          disable http client connections.\n"
"                       deny            deny any new connections, same as \"lock\"\n"
"                       nodeny          allow new connections, same as \"unlock\"\n"
"                       avahi           enable  avahi service advertizing.\n"
"                       noavahi         disable avahi service advertizing.\n"
"                       mdns            enable  avahi service advertizing.\n"
"                       nomdns          disable avahi service advertizing.\n"
/* access, filename */
"                       connect:host    do reverse connection to host, \"host\"\n"
"                                       may be a comma separated list of hosts\n"
"                                       or host:ports.  See -connect.  Passwords\n"
"                                       required as with fwd connections.\n"
"                                       See X11VNC_REVERSE_CONNECTION_NO_AUTH=1\n"
"                       disconnect:host disconnect any clients from \"host\"\n"
"                                       same as \"close:host\".  Use host\n"
"                                       \"all\" to close all current clients.\n"
"                                       If you know the client internal hex ID,\n"
"                                       e.g. 0x3 (returned by \"-query clients\"\n"
"                                       and RFB_CLIENT_ID) you can use that too.\n"
/* access */
"                       allowonce:host  For the next connection only, allow\n"
"                                       connection from \"host\".\n"
/* access */
"                       allow:hostlist  set -allow list to (comma separated)\n"
"                                       \"hostlist\". See -allow and -localhost.\n"
"                                       Do not use with -allow /path/to/file\n"
"                                       Use \"+host\" to add a single host, and\n"
"                                       use \"-host\" to delete a single host\n"
"                       localhost       enable  -localhost mode\n"
"                       nolocalhost     disable -localhost mode\n"
"                       listen:str      set -listen to str, empty to disable.\n"
"                       nolookup        enable  -nolookup mode.\n"
"                       lookup          disable -nolookup mode.\n"
"                       input:str       set -input to \"str\", empty to disable.\n"
"                       grabkbd         enable  -grabkbd mode.\n"
"                       nograbkbd       disable -grabkbd mode.\n"
"                       grabptr         enable  -grabptr mode.\n"
"                       nograbptr       disable -grabptr mode.\n"
"                       grabalways      enable  -grabalways mode.\n"
"                       nograbalways    disable -grabalways mode.\n"
"                       client_input:str set the K, M, B -input on a per-client\n"
"                                       basis.  select which client as for\n"
"                                       disconnect, e.g. client_input:host:MB\n"
"                                       or client_input:0x2:K\n"
/* ext. cmd. */
"                       accept:cmd      set -accept \"cmd\" (empty to disable).\n"
"                       afteraccept:cmd set -afteraccept (empty to disable).\n"
"                       gone:cmd        set -gone \"cmd\" (empty to disable).\n"
"                       noshm           enable  -noshm mode.\n"
"                       shm             disable -noshm mode (i.e. use shm).\n"
"                       flipbyteorder   enable -flipbyteorder mode, you may need\n"
"                                       to set noshm for this to do something.\n"
"                       noflipbyteorder disable -flipbyteorder mode.\n"
"                       onetile         enable  -onetile mode. (you may need to\n"
"                                       set shm for this to do something)\n"
"                       noonetile       disable -onetile mode.\n"
/* ext. cmd. */
"                       solid           enable  -solid mode\n"
"                       nosolid         disable -solid mode.\n"
"                       solid_color:color set -solid color (and apply it).\n"
"                       blackout:str    set -blackout \"str\" (empty to disable).\n"
"                                       See -blackout for the form of \"str\"\n"
"                                       (basically: WxH+X+Y,...)\n"
"                                       Use \"+WxH+X+Y\" to append a single\n"
"                                       rectangle use \"-WxH+X+Y\" to delete one\n"
"                       xinerama        enable  -xinerama mode. (if applicable)\n"
"                       noxinerama      disable -xinerama mode.\n"
"                       xtrap           enable  -xtrap input mode(if applicable)\n"
"                       noxtrap         disable -xtrap input mode.\n"
"                       xrandr          enable  -xrandr mode. (if applicable)\n"
"                       noxrandr        disable -xrandr mode.\n"
"                       xrandr_mode:mode set the -xrandr mode to \"mode\".\n"
"                       rotate:mode     set the -rotate mode to \"mode\".\n"
"                       padgeom:WxH     set -padgeom to WxH (empty to disable)\n"
"                                       If WxH is \"force\" or \"do\" the padded\n"
"                                       geometry fb is immediately applied.\n"
"                       quiet           enable  -quiet mode.\n"
"                       noquiet         disable -quiet mode.\n"
"                       modtweak        enable  -modtweak mode.\n"
"                       nomodtweak      enable  -nomodtweak mode.\n"
"                       xkb             enable  -xkb modtweak mode.\n"
"                       noxkb           disable -xkb modtweak mode.\n"
"                       capslock        enable  -capslock mode.\n"
"                       nocapslock      disable -capslock mode.\n"
"                       skip_lockkeys   enable  -skip_lockkeys mode.\n"
"                       noskip_lockkeys disable -skip_lockkeys mode.\n"
"                       skip_keycodes:str enable -xkb -skip_keycodes \"str\".\n"
"                       sloppy_keys     enable  -sloppy_keys mode.\n"
"                       nosloppy_keys   disable -sloppy_keys mode.\n"
"                       skip_dups       enable  -skip_dups mode.\n"
"                       noskip_dups     disable -skip_dups mode.\n"
"                       add_keysyms     enable -add_keysyms mode.\n"
"                       noadd_keysyms   stop adding keysyms. those added will\n"
"                                       still be removed at exit.\n"
"                       clear_mods      enable  -clear_mods mode and clear them.\n"
"                       noclear_mods    disable -clear_mods mode.\n"
"                       clear_keys      enable  -clear_keys mode and clear them.\n"
"                       noclear_keys    disable -clear_keys mode.\n"
/* filename */
"                       remap:str       set -remap \"str\" (empty to disable).\n"
"                                       See -remap for the form of \"str\"\n"
"                                       (basically: key1-key2,key3-key4,...)\n"
"                                       Use \"+key1-key2\" to append a single\n"
"                                       keymapping, use \"-key1-key2\" to delete.\n"
"                       norepeat        enable  -norepeat mode.\n"
"                       repeat          disable -norepeat mode.\n"
"                       nofb            enable  -nofb mode.\n"
"                       fb              disable -nofb mode.\n"
"                       bell            enable  bell (if supported).\n"
"                       nobell          disable bell.\n"
"                       nosel           enable  -nosel mode.\n"
"                       sel             disable -nosel mode.\n"
"                       noprimary       enable  -noprimary mode.\n"
"                       primary         disable -noprimary mode.\n"
"                       nosetprimary    enable  -nosetprimary mode.\n"
"                       setprimary      disable -nosetprimary mode.\n"
"                       noclipboard     enable  -noclipboard mode.\n"
"                       clipboard       disable -noclipboard mode.\n"
"                       nosetclipboard  enable  -nosetclipboard mode.\n"
"                       setclipboard    disable -nosetclipboard mode.\n"
"                       seldir:str      set -seldir to \"str\"\n"
"                       cursor:mode     enable  -cursor \"mode\".\n"
"                       show_cursor     enable  showing a cursor.\n"
"                       noshow_cursor   disable showing a cursor. (same as\n"
"                                       \"nocursor\")\n"
"                       cursor_drag     enable  cursor changes during drag.\n"
"                       nocursor_drag   disable cursor changes during drag.\n"
"                       arrow:n         set -arrow to alternate n.\n"
"                       xfixes          enable  xfixes cursor shape mode.\n"
"                       noxfixes        disable xfixes cursor shape mode.\n"
"                       alphacut:n      set -alphacut to n.\n"
"                       alphafrac:f     set -alphafrac to f.\n"
"                       alpharemove     enable  -alpharemove mode.\n"
"                       noalpharemove   disable -alpharemove mode.\n"
"                       alphablend      disable -noalphablend mode.\n"
"                       noalphablend    enable  -noalphablend mode.\n"
"                       cursorshape     disable -nocursorshape mode.\n"
"                       nocursorshape   enable  -nocursorshape mode.\n"
"                       cursorpos       disable -nocursorpos mode.\n"
"                       nocursorpos     enable  -nocursorpos mode.\n"
"                       xwarp           enable  -xwarppointer mode.\n"
"                       noxwarp         disable -xwarppointer mode.\n"
"                       buttonmap:str   set -buttonmap \"str\", empty to disable\n"
"                       dragging        disable -nodragging mode.\n"
"                       nodragging      enable  -nodragging mode.\n"
"                       ncache          reenable -ncache mode.\n"
"                       noncache        disable  -ncache mode.\n"
"                       ncache_size:n   set -ncache size to n.\n"
"                       ncache_cr       enable  -ncache_cr mode.\n"
"                       noncache_cr     disable -ncache_cr mode.\n"
"                       ncache_no_moveraise     enable  no_moveraise mode.\n"
"                       noncache_no_moveraise   disable no_moveraise mode.\n"
"                       ncache_no_dtchange      enable  ncache_no_dtchange mode.\n"
"                       noncache_no_dtchange    disable ncache_no_dtchange mode.\n"
"                       ncache_no_rootpixmap    enable  ncache_no_rootpixmap.\n"
"                       noncache_no_rootpixmap  disable ncache_no_rootpixmap.\n"
"                       ncache_reset_rootpixmap recheck the root pixmap\n"
"                       ncache_keep_anims       enable  ncache_keep_anims.\n"
"                       noncache_keep_anims     disable ncache_keep_anims.\n"
"                       wireframe       enable  -wireframe mode. same as \"wf\"\n"
"                       nowireframe     disable -wireframe mode. same as \"nowf\"\n"
"                       wireframe:str   enable  -wireframe mode string.\n"
"                       wireframe_mode:str enable  -wireframe mode string.\n"
"                       wireframelocal  enable  wireframelocal. same as \"wfl\"\n"
"                       nowireframe     disable wireframelocal. same as \"nowfl\"\n"
"                       wirecopyrect:str set -wirecopyrect string. same as \"wcr:\"\n"
"                       scrollcopyrect:str set -scrollcopyrect string. same \"scr\"\n"
"                       noscrollcopyrect disable -scrollcopyrect mode. \"noscr\"\n"
"                       scr_area:n      set -scr_area to n\n"
"                       scr_skip:list   set -scr_skip to \"list\"\n"
"                       scr_inc:list    set -scr_inc to \"list\"\n"
"                       scr_keys:list   set -scr_keys to \"list\"\n"
"                       scr_term:list   set -scr_term to \"list\"\n"
"                       scr_keyrepeat:str set -scr_keyrepeat to \"str\"\n"
"                       scr_parms:str   set -scr_parms parameters.\n"
"                       fixscreen:str   set -fixscreen to \"str\".\n"
"                       noxrecord       disable all use of RECORD extension.\n"
"                       xrecord         enable  use of RECORD extension.\n"
"                       reset_record    reset RECORD extension (if avail.)\n"
"                       pointer_mode:n  set -pointer_mode to n. same as \"pm\"\n"
"                       input_skip:n    set -input_skip to n.\n"
"                       allinput        enable  use of -allinput mode.\n"
"                       noallinput      disable use of -allinput mode.\n"
"                       ssltimeout:n    set -ssltimeout to n.\n"
"                       speeds:str      set -speeds to str.\n"
"                       wmdt:str        set -wmdt to str.\n"
"                       debug_pointer   enable  -debug_pointer, same as \"dp\"\n"
"                       nodebug_pointer disable -debug_pointer, same as \"nodp\"\n"
"                       debug_keyboard   enable  -debug_keyboard, same as \"dk\"\n"
"                       nodebug_keyboard disable -debug_keyboard, same as \"nodk\"\n"
"                       defer:n         set -defer to n ms,same as deferupdate:n\n"
"                       wait:n          set -wait to n ms.\n"
"                       wait_ui:f       set -wait_ui factor to f.\n"
"                       wait_bog        disable -nowait_bog mode.\n"
"                       nowait_bog      enable  -nowait_bog mode.\n"
"                       slow_fb:f       set -slow_fb to f seconds.\n"
"                       xrefresh:f      set -xrefresh to f seconds.\n"
"                       readtimeout:n   set read timeout to n seconds.\n"
"                       nap             enable  -nap mode.\n"
"                       nonap           disable -nap mode.\n"
"                       sb:n            set -sb to n s, same as screen_blank:n\n"
"                       fbpm            disable -nofbpm mode.\n"
"                       nofbpm          enable  -nofbpm mode.\n"
"                       dpms            disable -nodpms mode.\n"
"                       nodpms          enable  -nodpms mode.\n"
"                       forcedpms       enable  -forcedpms mode.\n"
"                       noforcedpms     disable -forcedpms mode.\n"
"                       clientdpms      enable  -clientdpms mode.\n"
"                       noclientdpms    disable -clientdpms mode.\n"
"                       noserverdpms    enable  -noserverdpms mode.\n"
"                       serverdpms      disable -noserverdpms mode.\n"
"                       noultraext      enable  -noultraext mode.\n"
"                       ultraext        disable -noultraext mode.\n"
"                       xdamage         enable  xdamage polling hints.\n"
"                       noxdamage       disable xdamage polling hints.\n"
"                       xd_area:A       set -xd_area max pixel area to \"A\"\n"
"                       xd_mem:f        set -xd_mem remembrance to \"f\"\n"
"                       fs:frac         set -fs fraction to \"frac\", e.g. 0.5\n"
"                       gaps:n          set -gaps to n.\n"
"                       grow:n          set -grow to n.\n"
"                       fuzz:n          set -fuzz to n.\n"
"                       snapfb          enable  -snapfb mode.\n"
"                       nosnapfb        disable -snapfb mode.\n"
"                       rawfb:str       set -rawfb mode to \"str\".\n"
"                       uinput_accel:f  set uinput_accel to f.\n"
"                       uinput_reset:n  set uinput_reset to n ms.\n"
"                       uinput_always:n set uinput_always to 1/0.\n"
"                       progressive:n   set libvncserver -progressive slice\n"
"                                       height parameter to n.\n"
"                       desktop:str     set -desktop name to str for new clients.\n"
"                       rfbport:n       set -rfbport to n.\n"
"                       macnosaver      enable  -macnosaver mode.\n"
"                       macsaver        disable -macnosaver mode.\n"
"                       macnowait       enable  -macnowait  mode.\n"
"                       macwait         disable -macnowait  mode.\n"
"                       macwheel:n      set -macwheel to n.\n"
"                       macnoswap       enable  -macnoswap mouse button mode.\n"
"                       macswap         disable -macnoswap mouse button mode.\n"
"                       macnoresize     enable  -macnoresize mode.\n"
"                       macresize       disable -macnoresize mode.\n"
"                       maciconanim:n   set -maciconanim to n.\n"
"                       macmenu         enable  -macmenu  mode.\n"
"                       macnomenu       disable -macnmenu mode.\n"
/* access */
"                       httpport:n      set -httpport to n.\n"
"                       httpdir:dir     set -httpdir to dir (and enable http).\n"
"                       enablehttpproxy   enable  -enablehttpproxy mode.\n"
"                       noenablehttpproxy disable -enablehttpproxy mode.\n"
"                       alwaysshared     enable  -alwaysshared mode.\n"
"                       noalwaysshared   disable -alwaysshared mode.\n"
"                                        (may interfere with other options)\n"
"                       nevershared      enable  -nevershared mode.\n"
"                       nonevershared    disable -nevershared mode.\n"
"                                        (may interfere with other options)\n"
"                       dontdisconnect   enable  -dontdisconnect mode.\n"
"                       nodontdisconnect disable -dontdisconnect mode.\n"
"                                        (may interfere with other options)\n"
"                       debug_xevents   enable  debugging X events.\n"
"                       nodebug_xevents disable debugging X events.\n"
"                       debug_xdamage   enable  debugging X DAMAGE mechanism.\n"
"                       nodebug_xdamage disable debugging X DAMAGE mechanism.\n"
"                       debug_wireframe enable   debugging wireframe mechanism.\n"
"                       nodebug_wireframe disable debugging wireframe mechanism.\n"
"                       debug_scroll    enable  debugging scrollcopy mechanism.\n"
"                       nodebug_scroll  disable debugging scrollcopy mechanism.\n"
"                       debug_tiles     enable  -debug_tiles\n"
"                       nodebug_tiles   disable -debug_tiles\n"
"                       debug_grabs     enable  -debug_grabs\n"
"                       nodebug_grabs   disable -debug_grabs\n"
"                       debug_sel       enable  -debug_sel\n"
"                       nodebug_sel     disable -debug_sel\n"
"                       debug_ncache    enable  -debug_ncache\n"
"                       nodebug_ncache  disable -debug_ncache\n"
"                       dbg             enable  -dbg crash shell\n"
"                       nodbg           disable -dbg crash shell\n"
"\n"
"                       noremote        disable the -remote command processing,\n"
"                                       it cannot be turned back on.\n"
"\n"
"                       The vncconnect(1) command from standard VNC\n"
"                       distributions may also be used if string is prefixed\n"
"                       with \"cmd=\" E.g. 'vncconnect cmd=stop'.  Under some\n"
"                       circumstances xprop(1) can used if it supports -set\n"
"                       (see the FAQ).\n"
"\n"
"                       If \"-connect /path/to/file\" has been supplied to the\n"
"                       running x11vnc server then that file can be used as a\n"
"                       communication channel (this is the only way to remote\n"
"                       control one of many x11vnc's polling the same X display)\n"
"                       Simply run: 'x11vnc -connect /path/to/file -remote ...'\n"
"                       or you can directly write to the file via something\n"
"                       like: \"echo cmd=stop > /path/to/file\", etc.\n"
"\n"
"-query variable        Like -remote, except just query the value of\n"
"                       \"variable\".  \"-Q\" is an alias for \"-query\".\n"
"                       Multiple queries can be done by separating variables\n"
"                       by commas, e.g. -query var1,var2. The results come\n"
"                       back in the form ans=var1:value1,ans=var2:value2,...\n"
"                       to the standard output.  If a variable is read-only,\n"
"                       it comes back with prefix \"aro=\" instead of \"ans=\".\n"
"\n"
"                       Some -remote commands are pure actions that do not make\n"
"                       sense as variables, e.g. \"stop\" or \"disconnect\", in\n"
"                       these cases the value returned is \"N/A\".  To direct a\n"
"                       query straight to the X11VNC_REMOTE property or connect\n"
"                       file use \"qry=...\" instead of \"cmd=...\"\n"
"\n"
"                       ans= stop quit exit shutdown ping blacken zero\n"
"                       refresh reset close disconnect id sid waitmapped\n"
"                       nowaitmapped clip flashcmap noflashcmap shiftcmap\n"
"                       truecolor notruecolor overlay nooverlay overlay_cursor\n"
"                       overlay_yescursor nooverlay_nocursor nooverlay_cursor\n"
"                       nooverlay_yescursor overlay_nocursor 8to24 no8to24\n"
"                       8to24_opts 24to32 no24to32 visual scale scale_cursor\n"
"                       viewonly noviewonly shared noshared forever noforever\n"
"                       once timeout tightfilexfer notightfilexfer ultrafilexfer\n"
"                       noultrafilexfer rfbversion deny lock nodeny unlock\n"
"                       avahi mdns noavahi nomdns connect allowonce allow\n"
"                       localhost nolocalhost listen lookup nolookup accept\n"
"                       afteraccept gone shm noshm flipbyteorder noflipbyteorder\n"
"                       onetile noonetile solid_color solid nosolid blackout\n"
"                       xinerama noxinerama xtrap noxtrap xrandr noxrandr\n"
"                       xrandr_mode rotate padgeom quiet q noquiet modtweak\n"
"                       nomodtweak xkb noxkb capslock nocapslock skip_lockkeys\n"
"                       noskip_lockkeys skip_keycodes sloppy_keys nosloppy_keys\n"
"                       skip_dups noskip_dups add_keysyms noadd_keysyms\n"
"                       clear_mods noclear_mods clear_keys noclear_keys\n"
"                       remap repeat norepeat fb nofb bell nobell sel nosel\n"
"                       primary noprimary setprimary nosetprimary clipboard\n"
"                       noclipboard setclipboard nosetclipboard seldir\n"
"                       cursorshape nocursorshape cursorpos nocursorpos\n"
"                       cursor_drag nocursor_drag cursor show_cursor\n"
"                       noshow_cursor nocursor arrow xfixes noxfixes xdamage\n"
"                       noxdamage xd_area xd_mem alphacut alphafrac alpharemove\n"
"                       noalpharemove alphablend noalphablend xwarppointer\n"
"                       xwarp noxwarppointer noxwarp buttonmap dragging\n"
"                       nodragging ncache_cr noncache_cr ncache_no_moveraise\n"
"                       noncache_no_moveraise ncache_no_dtchange\n"
"                       noncache_no_dtchange ncache_no_rootpixmap\n"
"                       noncache_no_rootpixmap ncache_reset_rootpixmap\n"
"                       ncache_keep_anims noncache_keep_anims ncache_old_wm\n"
"                       noncache_old_wm ncache noncache ncache_size debug_ncache\n"
"                       nodebug_ncache wireframe_mode wireframe wf nowireframe\n"
"                       nowf wireframelocal wfl nowireframelocal nowfl\n"
"                       wirecopyrect wcr nowirecopyrect nowcr scr_area\n"
"                       scr_skip scr_inc scr_keys scr_term scr_keyrepeat\n"
"                       scr_parms scrollcopyrect scr noscrollcopyrect noscr\n"
"                       fixscreen noxrecord xrecord reset_record pointer_mode\n"
"                       pm input_skip allinput noallinput input grabkbd\n"
"                       nograbkbd grabptr nograbptr grabalways nograbalways\n"
"                       client_input ssltimeout speeds wmdt debug_pointer dp\n"
"                       nodebug_pointer nodp debug_keyboard dk nodebug_keyboard\n"
"                       nodk deferupdate defer wait_ui wait_bog nowait_bog\n"
"                       slow_fb xrefresh wait readtimeout nap nonap sb\n"
"                       screen_blank fbpm nofbpm dpms nodpms clientdpms\n"
"                       noclientdpms forcedpms noforcedpms noserverdpms\n"
"                       serverdpms noultraext ultraext fs gaps grow fuzz snapfb\n"
"                       nosnapfb rawfb uinput_accel uinput_thresh uinput_reset\n"
"                       uinput_always progressive rfbport http nohttp httpport\n"
"                       httpdir enablehttpproxy noenablehttpproxy alwaysshared\n"
"                       noalwaysshared nevershared noalwaysshared dontdisconnect\n"
"                       nodontdisconnect desktop debug_xevents nodebug_xevents\n"
"                       debug_xevents debug_xdamage nodebug_xdamage\n"
"                       debug_xdamage debug_wireframe nodebug_wireframe\n"
"                       debug_wireframe debug_scroll nodebug_scroll debug_scroll\n"
"                       debug_tiles dbt nodebug_tiles nodbt debug_tiles\n"
"                       debug_grabs nodebug_grabs debug_sel nodebug_sel dbg\n"
"                       nodbg macnosaver macsaver nomacnosaver macnowait macwait\n"
"                       nomacnowait macwheel macnoswap macswap nomacnoswap\n"
"                       macnoresize macresize nomacnoresize maciconanim macmenu\n"
"                       macnomenu nomacmenu noremote\n"
"\n"
"                       aro=  noop display vncdisplay desktopname guess_desktop\n"
"                       http_url auth xauth users rootshift clipshift\n"
"                       scale_str scaled_x scaled_y scale_numer scale_denom\n"
"                       scale_fac scaling_blend scaling_nomult4 scaling_pad\n"
"                       scaling_interpolate inetd privremote unsafe safer\n"
"                       nocmds passwdfile unixpw unixpw_nis unixpw_list ssl\n"
"                       ssl_pem sslverify stunnel stunnel_pem https httpsredir\n"
"                       usepw using_shm logfile o flag rc norc h help V version\n"
"                       lastmod bg sigpipe threads readrate netrate netlatency\n"
"                       pipeinput clients client_count pid ext_xtest ext_xtrap\n"
"                       ext_xrecord ext_xkb ext_xshm ext_xinerama ext_overlay\n"
"                       ext_xfixes ext_xdamage ext_xrandr rootwin num_buttons\n"
"                       button_mask mouse_x mouse_y bpp depth indexed_color\n"
"                       dpy_x dpy_y wdpy_x wdpy_y off_x off_y cdpy_x cdpy_y\n"
"                       coff_x coff_y rfbauth passwd viewpasswd\n"
"\n"
"\n"
"-QD variable           Just like -query variable, but returns the default\n"
"                       value for that parameter (no running x11vnc server\n"
"                       is consulted)\n"
"\n"
"-sync                  By default -remote commands are run asynchronously, that\n"
"                       is, the request is posted and the program immediately\n"
"                       exits.  Use -sync to have the program wait for an\n"
"                       acknowledgement from the x11vnc server that command was\n"
"                       processed (somehow).  On the other hand -query requests\n"
"                       are always processed synchronously because they have\n"
"                       to wait for the answer.\n"
"\n"
"                       Also note that if both -remote and -query requests are\n"
"                       supplied on the command line, the -remote is processed\n"
"                       first (synchronously: no need for -sync), and then\n"
"                       the -query request is processed in the normal way.\n"
"                       This allows for a reliable way to see if the -remote\n"
"                       command was processed by querying for any new settings.\n"
"                       Note however that there is timeout of a few seconds so\n"
"                       if the x11vnc takes longer than that to process the\n"
"                       requests the requestor will think that a failure has\n"
"                       taken place.\n"
"\n"
"-noremote              Do not process any remote control commands or queries.\n"
"-yesremote             Do process remote control commands or queries.\n"
"                       Default: %s\n"
"\n"
"                       A note about security wrt remote control commands.\n"
"                       If someone can connect to the X display and change\n"
"                       the property X11VNC_REMOTE, then they can remotely\n"
"                       control x11vnc.  Normally access to the X display is\n"
"                       protected.  Note that if they can modify X11VNC_REMOTE\n"
"                       on the X server, they have enough permissions to also\n"
"                       run their own x11vnc and thus have complete control\n"
"                       of the desktop.  If the  \"-connect /path/to/file\"\n"
"                       channel is being used, obviously anyone who can write\n"
"                       to /path/to/file can remotely control x11vnc.  So be\n"
"                       sure to protect the X display and that file's write\n"
"                       permissions.  See -privremote below.\n"
"\n"
"                       If you are paranoid and do not think -noremote is\n"
"                       enough, to disable the X11VNC_REMOTE property channel\n"
"                       completely use -novncconnect, or use the -safer option\n"
"                       that shuts many things off.\n"
"\n"
"-unsafe                A few remote commands are disabled by default\n"
"                       (currently: id:pick, accept:<cmd>, gone:<cmd>, and\n"
"                       rawfb:setup:<cmd>) because they are associated with\n"
"                       running external programs.  If you specify -unsafe, then\n"
"                       these remote-control commands are allowed.  Note that\n"
"                       you can still specify these parameters on the command\n"
"                       line, they just cannot be invoked via remote-control.\n"
"-safer                 Equivalent to: -novncconnect -noremote and prohibiting\n"
"                       -gui and the -connect file. Shuts off communcation\n"
"                       channels.\n"
"-privremote            Perform some sanity checks and disable remote-control\n"
"                       commands if it appears that the X DISPLAY and/or\n"
"                       connectfile can be accessed by other users.  Once\n"
"                       remote-control is disabled it cannot be turned back on.\n"
"-nocmds                No external commands (e.g. system(3), popen(3), exec(3))\n"
"                       will be run.\n"
"-allowedcmds list      \"list\" contains a comma separated list of the only\n"
"                       external commands that can be run.  The full list of\n"
"                       associated options is:\n"
"\n"
"                        stunnel, ssl, unixpw, WAIT, id, accept, afteraccept,\n"
"                        gone, pipeinput, v4l-info, rawfb-setup, dt, gui,\n"
"                        storepasswd, passwdfile, custom_passwd, crash.\n"
"\n"
"                       See each option's help to learn the associated external\n"
"                       command.  Note that the -nocmds option takes precedence\n"
"                       and disables all external commands.\n"
"\n"
"-deny_all              For use with -remote nodeny: start out denying all\n"
"                       incoming clients until \"-remote nodeny\" is used to\n"
"                       let them in.\n"
"%s\n"
"\n"
"These options are passed to libvncserver:\n"
"\n"
;
	/* have both our help and rfbUsage to stdout for more(1), etc. */
	dup2(1, 2);

	/* register extension(s) to get their help output */
#ifdef LIBVNCSERVER_WITH_TIGHTVNC_FILETRANSFER
	rfbRegisterTightVNCFileTransferExtension();
#endif

	if (mode == 1) {
		char *p;	
		int l = 0;
		fprintf(stderr, "x11vnc: allow VNC connections to real "
		    "X11 displays. %s\n\nx11vnc options:\n", lastmod);
		p = strtok(help, "\n");
		while (p) {
			int w = 23;
			char tmp[100];
			if (p[0] == '-') {
				strncpy(tmp, p, w);
				fprintf(stderr, "  %s", tmp);
				l++;
				if (l % 3 == 0) {
					fprintf(stderr, "\n");
				}
			}
			p = strtok(NULL, "\n");
		}
		fprintf(stderr, "\n\nlibvncserver options:\n");
		rfbUsage();
		fprintf(stderr, "\n");
		exit(1);
	}
	fprintf(stderr, help, lastmod,
		POLL_8TO24_DELAY,
		scaling_copyrect ? ":cr":":nocr",
		view_only ? "on":"off",
		shared ? "on":"off",
		vnc_connect ? "-vncconnect":"-novncconnect",
		xinerama ? "-xinerama":"-noxinerama",
		use_modifier_tweak ? "-modtweak":"-nomodtweak",
		skip_duplicate_key_events ? "-skip_dups":"-noskip_dups",
		add_keysyms ? "-add_keysyms":"-noadd_keysyms",
		no_autorepeat ? "-norepeat":"-repeat",
		alt_arrow_max, alt_arrow,
		alpha_threshold,
		alpha_frac,
		cursor_pos_updates ? "-cursorpos":"-nocursorpos",
		wireframe ? "-wireframe":"-nowireframe",
		WIREFRAME_PARMS,
		wireframe_copyrect_default,
		scroll_copyrect_default,
		scrollcopyrect_min_area,
		scroll_skip_str0 ? scroll_skip_str0 : "(empty)",
		scroll_term_str0,
		max_keyrepeat_str0,
		SCROLL_COPYRECT_PARMS,
		pointer_mode_max, pointer_mode,
		ui_skip,
		defer_update,
		waitms,
		wait_ui,
		rfbMaxClientWait/1000,
		take_naps ? "take naps":"no naps",
		screen_blank,
		watch_fbpm ? "-nofbpm":"-fbpm",
		watch_dpms ? "-nodpms":"-dpms",
		xdamage_max_area, NSCAN, xdamage_memory,
		use_threads ? "-threads":"-nothreads",
		fs_frac,
		gaps_fill,
		grow_fill,
		tile_fuzz,
		accept_remote_cmds ? "-yesremote":"-noremote",
		""
	);

	rfbUsage();
#endif
	exit(1);
}

void xopen_display_fail_message(char *disp) {
	fprintf(stderr, "\n");
	fprintf(stderr, "*** x11vnc was unable to open the X DISPLAY: \"%s\","
	    " it cannot continue.\n", disp);
	fprintf(stderr, "*** There may be \"Xlib:\" error messages above"
	    " with details about the failure.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "Some tips and guidelines:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " * An X server (the one you wish to view) must"
	    " be running before x11vnc is\n");
	fprintf(stderr, "   started: x11vnc does not start the X server.  (however, see the\n");
	fprintf(stderr, "   recent -create option if that is what you really want).\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " * You must use -display <disp>, -OR- set and"
	    " export your $DISPLAY\n");
	fprintf(stderr, "   environment variable to refer to the display of"
	    " the desired X server.\n");
	fprintf(stderr, " - Usually the display is simply \":0\" (in fact"
	    " x11vnc uses this if you forget\n");
	fprintf(stderr, "   to specify it), but in some multi-user"
	    " situations it could be \":1\", \":2\",\n"); 
	fprintf(stderr, "   or even \":137\".  Ask your administrator"
	    " or a guru if you are having\n");
	fprintf(stderr, "   difficulty determining what your X DISPLAY is.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " * Next, you need to have sufficient permissions"
	    " (Xauthority) \n");
	fprintf(stderr, "   to connect to the X DISPLAY.   Here are some"
	    " Tips:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " - Often, you just need to run x11vnc as the user"
	    " logged into the X session.\n");
	fprintf(stderr, "   So make sure to be that user when you type"
	    " x11vnc.\n");
	fprintf(stderr, " - Being root is usually not enough because the"
	    " incorrect MIT-MAGIC-COOKIE\n");
	fprintf(stderr, "   file will be accessed.  The cookie file contains"
	    " the secret key that\n");
	fprintf(stderr, "   allows x11vnc to connect to the desired"
	    " X DISPLAY.\n");
	fprintf(stderr, " - You can explicity indicate which MIT-MAGIC-COOKIE"
	    " file should be used\n");
	fprintf(stderr, "   by the -auth option, e.g.:\n");
	fprintf(stderr, "       x11vnc -auth /home/someuser/.Xauthority"
	    " -display :0\n");
	fprintf(stderr, "       x11vnc -auth /tmp/.gdmzndVlR"
	    " -display :0\n");
	fprintf(stderr, "   you must have read permission for the auth file.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " - If NO ONE is logged into an X session yet, but"
	    " there is a greeter login\n");
	fprintf(stderr, "   program like \"gdm\", \"kdm\", \"xdm\", or"
	    " \"dtlogin\" running, you will need\n");
	fprintf(stderr, "   to find and use the raw display manager"
	    " MIT-MAGIC-COOKIE file.\n");
	fprintf(stderr, "   Some examples for various display managers:\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "     gdm:     -auth /var/gdm/:0.Xauth\n");
	fprintf(stderr, "     kdm:     -auth /var/lib/kdm/A:0-crWk72\n");
	fprintf(stderr, "     xdm:     -auth /var/lib/xdm/authdir/authfiles/A:0-XQvaJk\n");
	fprintf(stderr, "     dtlogin: -auth /var/dt/A:0-UgaaXa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "   Only root will have read permission for the"
	    " file, and so x11vnc must be run\n");
	fprintf(stderr, "   as root.  The random characters in the filenames"
	    " will of course change,\n");
	fprintf(stderr, "   and the directory the cookie file resides in may"
	    " also be system dependent.\n");
	fprintf(stderr, "   Sometimes the command \"ps wwwaux | grep auth\""
	    " can reveal the file location.\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "See also: http://www.karlrunge.com/x11vnc/#faq\n");
}

void nopassword_warning_msg(int gotloc) {

	char str1[] =
"###############################################################\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
"#@                                                           @#\n"
"#@  **  WARNING  **  WARNING  **  WARNING  **  WARNING  **   @#\n"
"#@                                                           @#\n"
"#@        YOU ARE RUNNING X11VNC WITHOUT A PASSWORD!!        @#\n"
"#@                                                           @#\n"
"#@  This means anyone with network access to this computer   @#\n"
"#@  will be able to view and control your desktop.           @#\n"
"#@                                                           @#\n"
"#@ >>> If you did not mean to do this Press CTRL-C now!! <<< @#\n"
"#@                                                           @#\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
;
	char str2[] =
"#@                                                           @#\n"
"#@  You can create an x11vnc password file by running:       @#\n"
"#@                                                           @#\n"
"#@       x11vnc -storepasswd password /path/to/passfile      @#\n"
"#@  or   x11vnc -storepasswd /path/to/passfile               @#\n"
"#@  or   x11vnc -storepasswd                                 @#\n"
"#@                                                           @#\n"
"#@  (the last one will use ~/.vnc/passwd)                    @#\n"
"#@                                                           @#\n"
"#@  and then starting x11vnc via:                            @#\n"
"#@                                                           @#\n"
"#@      x11vnc -rfbauth /path/to/passfile                    @#\n"
"#@                                                           @#\n"
"#@  an existing ~/.vnc/passwd file from another VNC          @#\n"
"#@  application will work fine too.                          @#\n"
"#@                                                           @#\n"
"#@  You can also use the -passwdfile or -passwd options.     @#\n"
"#@  (note -passwd is unsafe if local users are not trusted)  @#\n"
"#@                                                           @#\n"
"#@  Make sure any -rfbauth and -passwdfile password files    @#\n"
"#@  cannot be read by untrusted users.                       @#\n"
"#@                                                           @#\n"
"#@  Use x11vnc -usepw to automatically use your              @#\n"
"#@  ~/.vnc/passwd or ~/.vnc/passwdfile password files.       @#\n"
"#@  (and prompt you to create ~/.vnc/passwd if neither       @#\n"
"#@  file exists.)  Under -usepw, x11vnc will exit if it      @#\n"
"#@  cannot find a password to use.                           @#\n"
"#@                                                           @#\n"
"#@                                                           @#\n"
"#@  Even with a password, the subsequent VNC traffic is      @#\n"
"#@  sent in the clear.  Consider tunnelling via ssh(1):      @#\n"
"#@                                                           @#\n"
"#@    http://www.karlrunge.com/x11vnc/#tunnelling            @#\n"
"#@                                                           @#\n"
"#@  Or using the x11vnc SSL options: -ssl and -stunnel       @#\n"
"#@                                                           @#\n"
"#@  Please Read the documention for more info about          @#\n"
"#@  passwords, security, and encryption.                     @#\n"
"#@                                                           @#\n"
"#@    http://www.karlrunge.com/x11vnc/#faq-passwd            @#\n"
;
	char str3[] =
"#@                                                           @#\n"
"#@  You are using the -localhost option and that is a good   @#\n"
"#@  thing!! Especially if you ssh(1) into this machine and   @#\n"
"#@  use port redirection.  Nevertheless, without a password  @#\n"
"#@  other users could possibly do redirection as well to     @#\n"
"#@  gain access to your desktop.                             @#\n"
;
	char str4[] =
"#@                                                           @#\n"
"#@  To disable this warning use the -nopw option, or put     @#\n"
"#@  the setting in your ~/.x11vncrc file.                    @#\n"
"#@                                                           @#\n"
"#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#\n"
"###############################################################\n"
;
	char str5[] =
"###############################################################\n\n"
;
	if (inetd) {
		return;
	}

	fprintf(stderr, "%s", str1);
	fflush(stderr);
#if !PASSWD_REQUIRED
	usleep(1000 * 1000);
#endif
	if (!quiet) {
		fprintf(stderr, "%s", str2);
		if (gotloc) {
			fprintf(stderr, "%s", str3);
		}
		fprintf(stderr, "%s", str4);
	} else {
		fprintf(stderr, "%s", str5);
	}
	fflush(stderr);
#if !PASSWD_REQUIRED
	usleep(500 * 1000);
#endif
}

void print_license(void) {
	char license[] = 
#if !SKIP_HELP
"		    GNU GENERAL PUBLIC LICENSE\n"
"		       Version 2, June 1991\n"
"\n"
" Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n"
"                          59 Temple Place - Suite 330, Boston, MA\n"
"                          02111-1307, USA.\n"
" Everyone is permitted to copy and distribute verbatim copies\n"
" of this license document, but changing it is not allowed.\n"
"\n"
"			    Preamble\n"
"\n"
"  The licenses for most software are designed to take away your\n"
"freedom to share and change it.  By contrast, the GNU General Public\n"
"License is intended to guarantee your freedom to share and change free\n"
"software--to make sure the software is free for all its users.  This\n"
"General Public License applies to most of the Free Software\n"
"Foundation's software and to any other program whose authors commit to\n"
"using it.  (Some other Free Software Foundation software is covered by\n"
"the GNU Library General Public License instead.)  You can apply it to\n"
"your programs, too.\n"
"\n"
"  When we speak of free software, we are referring to freedom, not\n"
"price.  Our General Public Licenses are designed to make sure that you\n"
"have the freedom to distribute copies of free software (and charge for\n"
"this service if you wish), that you receive source code or can get it\n"
"if you want it, that you can change the software or use pieces of it\n"
"in new free programs; and that you know you can do these things.\n"
"\n"
"  To protect your rights, we need to make restrictions that forbid\n"
"anyone to deny you these rights or to ask you to surrender the rights.\n"
"These restrictions translate to certain responsibilities for you if you\n"
"distribute copies of the software, or if you modify it.\n"
"\n"
"  For example, if you distribute copies of such a program, whether\n"
"gratis or for a fee, you must give the recipients all the rights that\n"
"you have.  You must make sure that they, too, receive or can get the\n"
"source code.  And you must show them these terms so they know their\n"
"rights.\n"
"\n"
"  We protect your rights with two steps: (1) copyright the software, and\n"
"(2) offer you this license which gives you legal permission to copy,\n"
"distribute and/or modify the software.\n"
"\n"
"  Also, for each author's protection and ours, we want to make certain\n"
"that everyone understands that there is no warranty for this free\n"
"software.  If the software is modified by someone else and passed on, we\n"
"want its recipients to know that what they have is not the original, so\n"
"that any problems introduced by others will not reflect on the original\n"
"authors' reputations.\n"
"\n"
"  Finally, any free program is threatened constantly by software\n"
"patents.  We wish to avoid the danger that redistributors of a free\n"
"program will individually obtain patent licenses, in effect making the\n"
"program proprietary.  To prevent this, we have made it clear that any\n"
"patent must be licensed for everyone's free use or not licensed at all.\n"
"\n"
"  The precise terms and conditions for copying, distribution and\n"
"modification follow.\n"
"\n"
"		    GNU GENERAL PUBLIC LICENSE\n"
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
"\n"
"  0. This License applies to any program or other work which contains\n"
"a notice placed by the copyright holder saying it may be distributed\n"
"under the terms of this General Public License.  The \"Program\", below,\n"
"refers to any such program or work, and a \"work based on the Program\"\n"
"means either the Program or any derivative work under copyright law:\n"
"that is to say, a work containing the Program or a portion of it,\n"
"either verbatim or with modifications and/or translated into another\n"
"language.  (Hereinafter, translation is included without limitation in\n"
"the term \"modification\".)  Each licensee is addressed as \"you\".\n"
"\n"
"Activities other than copying, distribution and modification are not\n"
"covered by this License; they are outside its scope.  The act of\n"
"running the Program is not restricted, and the output from the Program\n"
"is covered only if its contents constitute a work based on the\n"
"Program (independent of having been made by running the Program).\n"
"Whether that is true depends on what the Program does.\n"
"\n"
"  1. You may copy and distribute verbatim copies of the Program's\n"
"source code as you receive it, in any medium, provided that you\n"
"conspicuously and appropriately publish on each copy an appropriate\n"
"copyright notice and disclaimer of warranty; keep intact all the\n"
"notices that refer to this License and to the absence of any warranty;\n"
"and give any other recipients of the Program a copy of this License\n"
"along with the Program.\n"
"\n"
"You may charge a fee for the physical act of transferring a copy, and\n"
"you may at your option offer warranty protection in exchange for a fee.\n"
"\n"
"  2. You may modify your copy or copies of the Program or any portion\n"
"of it, thus forming a work based on the Program, and copy and\n"
"distribute such modifications or work under the terms of Section 1\n"
"above, provided that you also meet all of these conditions:\n"
"\n"
"    a) You must cause the modified files to carry prominent notices\n"
"    stating that you changed the files and the date of any change.\n"
"\n"
"    b) You must cause any work that you distribute or publish, that in\n"
"    whole or in part contains or is derived from the Program or any\n"
"    part thereof, to be licensed as a whole at no charge to all third\n"
"    parties under the terms of this License.\n"
"\n"
"    c) If the modified program normally reads commands interactively\n"
"    when run, you must cause it, when started running for such\n"
"    interactive use in the most ordinary way, to print or display an\n"
"    announcement including an appropriate copyright notice and a\n"
"    notice that there is no warranty (or else, saying that you provide\n"
"    a warranty) and that users may redistribute the program under\n"
"    these conditions, and telling the user how to view a copy of this\n"
"    License.  (Exception: if the Program itself is interactive but\n"
"    does not normally print such an announcement, your work based on\n"
"    the Program is not required to print an announcement.)\n"
"\n"
"These requirements apply to the modified work as a whole.  If\n"
"identifiable sections of that work are not derived from the Program,\n"
"and can be reasonably considered independent and separate works in\n"
"themselves, then this License, and its terms, do not apply to those\n"
"sections when you distribute them as separate works.  But when you\n"
"distribute the same sections as part of a whole which is a work based\n"
"on the Program, the distribution of the whole must be on the terms of\n"
"this License, whose permissions for other licensees extend to the\n"
"entire whole, and thus to each and every part regardless of who wrote it.\n"
"\n"
"Thus, it is not the intent of this section to claim rights or contest\n"
"your rights to work written entirely by you; rather, the intent is to\n"
"exercise the right to control the distribution of derivative or\n"
"collective works based on the Program.\n"
"\n"
"In addition, mere aggregation of another work not based on the Program\n"
"with the Program (or with a work based on the Program) on a volume of\n"
"a storage or distribution medium does not bring the other work under\n"
"the scope of this License.\n"
"\n"
"  3. You may copy and distribute the Program (or a work based on it,\n"
"under Section 2) in object code or executable form under the terms of\n"
"Sections 1 and 2 above provided that you also do one of the following:\n"
"\n"
"    a) Accompany it with the complete corresponding machine-readable\n"
"    source code, which must be distributed under the terms of Sections\n"
"    1 and 2 above on a medium customarily used for software interchange; or,\n"
"\n"
"    b) Accompany it with a written offer, valid for at least three\n"
"    years, to give any third party, for a charge no more than your\n"
"    cost of physically performing source distribution, a complete\n"
"    machine-readable copy of the corresponding source code, to be\n"
"    distributed under the terms of Sections 1 and 2 above on a medium\n"
"    customarily used for software interchange; or,\n"
"\n"
"    c) Accompany it with the information you received as to the offer\n"
"    to distribute corresponding source code.  (This alternative is\n"
"    allowed only for noncommercial distribution and only if you\n"
"    received the program in object code or executable form with such\n"
"    an offer, in accord with Subsection b above.)\n"
"\n"
"The source code for a work means the preferred form of the work for\n"
"making modifications to it.  For an executable work, complete source\n"
"code means all the source code for all modules it contains, plus any\n"
"associated interface definition files, plus the scripts used to\n"
"control compilation and installation of the executable.  However, as a\n"
"special exception, the source code distributed need not include\n"
"anything that is normally distributed (in either source or binary\n"
"form) with the major components (compiler, kernel, and so on) of the\n"
"operating system on which the executable runs, unless that component\n"
"itself accompanies the executable.\n"
"\n"
"If distribution of executable or object code is made by offering\n"
"access to copy from a designated place, then offering equivalent\n"
"access to copy the source code from the same place counts as\n"
"distribution of the source code, even though third parties are not\n"
"compelled to copy the source along with the object code.\n"
"\n"
"  4. You may not copy, modify, sublicense, or distribute the Program\n"
"except as expressly provided under this License.  Any attempt\n"
"otherwise to copy, modify, sublicense or distribute the Program is\n"
"void, and will automatically terminate your rights under this License.\n"
"However, parties who have received copies, or rights, from you under\n"
"this License will not have their licenses terminated so long as such\n"
"parties remain in full compliance.\n"
"\n"
"  5. You are not required to accept this License, since you have not\n"
"signed it.  However, nothing else grants you permission to modify or\n"
"distribute the Program or its derivative works.  These actions are\n"
"prohibited by law if you do not accept this License.  Therefore, by\n"
"modifying or distributing the Program (or any work based on the\n"
"Program), you indicate your acceptance of this License to do so, and\n"
"all its terms and conditions for copying, distributing or modifying\n"
"the Program or works based on it.\n"
"\n"
"  6. Each time you redistribute the Program (or any work based on the\n"
"Program), the recipient automatically receives a license from the\n"
"original licensor to copy, distribute or modify the Program subject to\n"
"these terms and conditions.  You may not impose any further\n"
"restrictions on the recipients' exercise of the rights granted herein.\n"
"You are not responsible for enforcing compliance by third parties to\n"
"this License.\n"
"\n"
"  7. If, as a consequence of a court judgment or allegation of patent\n"
"infringement or for any other reason (not limited to patent issues),\n"
"conditions are imposed on you (whether by court order, agreement or\n"
"otherwise) that contradict the conditions of this License, they do not\n"
"excuse you from the conditions of this License.  If you cannot\n"
"distribute so as to satisfy simultaneously your obligations under this\n"
"License and any other pertinent obligations, then as a consequence you\n"
"may not distribute the Program at all.  For example, if a patent\n"
"license would not permit royalty-free redistribution of the Program by\n"
"all those who receive copies directly or indirectly through you, then\n"
"the only way you could satisfy both it and this License would be to\n"
"refrain entirely from distribution of the Program.\n"
"\n"
"If any portion of this section is held invalid or unenforceable under\n"
"any particular circumstance, the balance of the section is intended to\n"
"apply and the section as a whole is intended to apply in other\n"
"circumstances.\n"
"\n"
"It is not the purpose of this section to induce you to infringe any\n"
"patents or other property right claims or to contest validity of any\n"
"such claims; this section has the sole purpose of protecting the\n"
"integrity of the free software distribution system, which is\n"
"implemented by public license practices.  Many people have made\n"
"generous contributions to the wide range of software distributed\n"
"through that system in reliance on consistent application of that\n"
"system; it is up to the author/donor to decide if he or she is willing\n"
"to distribute software through any other system and a licensee cannot\n"
"impose that choice.\n"
"\n"
"This section is intended to make thoroughly clear what is believed to\n"
"be a consequence of the rest of this License.\n"
"\n"
"  8. If the distribution and/or use of the Program is restricted in\n"
"certain countries either by patents or by copyrighted interfaces, the\n"
"original copyright holder who places the Program under this License\n"
"may add an explicit geographical distribution limitation excluding\n"
"those countries, so that distribution is permitted only in or among\n"
"countries not thus excluded.  In such case, this License incorporates\n"
"the limitation as if written in the body of this License.\n"
"\n"
"  9. The Free Software Foundation may publish revised and/or new versions\n"
"of the General Public License from time to time.  Such new versions will\n"
"be similar in spirit to the present version, but may differ in detail to\n"
"address new problems or concerns.\n"
"\n"
"Each version is given a distinguishing version number.  If the Program\n"
"specifies a version number of this License which applies to it and \"any\n"
"later version\", you have the option of following the terms and conditions\n"
"either of that version or of any later version published by the Free\n"
"Software Foundation.  If the Program does not specify a version number of\n"
"this License, you may choose any version ever published by the Free Software\n"
"Foundation.\n"
"\n"
"  10. If you wish to incorporate parts of the Program into other free\n"
"programs whose distribution conditions are different, write to the author\n"
"to ask for permission.  For software which is copyrighted by the Free\n"
"Software Foundation, write to the Free Software Foundation; we sometimes\n"
"make exceptions for this.  Our decision will be guided by the two goals\n"
"of preserving the free status of all derivatives of our free software and\n"
"of promoting the sharing and reuse of software generally.\n"
"\n"
#endif
"			    NO WARRANTY\n"
"\n"
"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n"
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"
"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n"
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n"
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"
"REPAIR OR CORRECTION.\n"
"\n"
"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"
"POSSIBILITY OF SUCH DAMAGES.\n"
"\n"
#if !SKIP_HELP
"		     END OF TERMS AND CONDITIONS\n"
"\n"
"	Appendix: How to Apply These Terms to Your New Programs\n"
"\n"
"  If you develop a new program, and you want it to be of the greatest\n"
"possible use to the public, the best way to achieve this is to make it\n"
"free software which everyone can redistribute and change under these terms.\n"
"\n"
"  To do so, attach the following notices to the program.  It is safest\n"
"to attach them to the start of each source file to most effectively\n"
"convey the exclusion of warranty; and each file should have at least\n"
"the \"copyright\" line and a pointer to where the full notice is found.\n"
"\n"
"    <one line to give the program's name and a brief idea of what it does.>\n"
"    Copyright (C) 19yy  <name of author>\n"
"\n"
"    This program is free software; you can redistribute it and/or modify\n"
"    it under the terms of the GNU General Public License as published by\n"
"    the Free Software Foundation; either version 2 of the License, or\n"
"    (at your option) any later version.\n"
"\n"
"    This program is distributed in the hope that it will be useful,\n"
"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"    GNU General Public License for more details.\n"
"\n"
"    You should have received a copy of the GNU General Public License\n"
"    along with this program; if not, write to the Free Software\n"
"    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n"
"\n"
"Also add information on how to contact you by electronic and paper mail.\n"
"\n"
"If the program is interactive, make it output a short notice like this\n"
"when it starts in an interactive mode:\n"
"\n"
"    Gnomovision version 69, Copyright (C) 19yy name of author\n"
"    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n"
"    This is free software, and you are welcome to redistribute it\n"
"    under certain conditions; type `show c' for details.\n"
"\n"
"The hypothetical commands `show w' and `show c' should show the appropriate\n"
"parts of the General Public License.  Of course, the commands you use may\n"
"be called something other than `show w' and `show c'; they could even be\n"
"mouse-clicks or menu items--whatever suits your program.\n"
"\n"
"You should also get your employer (if you work as a programmer) or your\n"
"school, if any, to sign a \"copyright disclaimer\" for the program, if\n"
"necessary.  Here is a sample; alter the names:\n"
"\n"
"  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n"
"  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n"
"\n"
"  <signature of Ty Coon>, 1 April 1989\n"
"  Ty Coon, President of Vice\n"
"\n"
"This General Public License does not permit incorporating your program into\n"
"proprietary programs.  If your program is a subroutine library, you may\n"
"consider it more useful to permit linking proprietary applications with the\n"
"library.  If this is what you want to do, use the GNU Library General\n"
"Public License instead of this License.\n"
#endif
;

	char top[] =
"\n"
"x11vnc: a VNC server for X displays.  %s\n"
"\n"
"Copyright (c) 2002-2006 Karl J. Runge <runge@karlrunge.com>\n"
"All rights reserved.\n"
"\n"
;
	dup2(1, 2);
	fprintf(stderr, top, lastmod);
	fprintf(stderr, "%s", license);
	exit(1);
}

