/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class vncCanvas
extends Canvas {
    vncviewer v;
    rfbProto rfb;
    ColorModel cm;
    Color[] colors;
    Image rawPixelsImage;
    animatedMemoryImageSource amis;
    byte[] pixels;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    Graphics sg;
    Graphics sg2;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    boolean prevCursorSet = false;
    byte[] rcSavedArea;
    byte[] rcSource;
    boolean[] rcMask;
    int rcHotX;
    int rcHotY;
    int rcWidth;
    int rcHeight;
    int rcCursorX = 0;
    int rcCursorY = 0;
    int rcLockX;
    int rcLockY;
    int rcLockWidth;
    int rcLockHeight;
    boolean rcCursorHidden;
    boolean rcLockSet;

    vncCanvas(vncviewer vncviewer2) throws IOException {
        this.v = vncviewer2;
        this.rfb = this.v.rfb;
        this.cm = new DirectColorModel(8, 7, 56, 192);
        this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
        this.colors = new Color[256];
        int n = 0;
        while (n < 256) {
            this.colors[n] = new Color(this.cm.getRGB(n));
            ++n;
        }
        this.pixels = new byte[this.rfb.framebufferWidth * this.rfb.framebufferHeight];
        this.amis = new animatedMemoryImageSource(this.rfb.framebufferWidth, this.rfb.framebufferHeight, this.cm, this.pixels);
        this.rawPixelsImage = this.createImage(this.amis);
        this.tightInflaters = new Inflater[4];
    }

    void drawMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) throws IOException {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            int n9 = 0;
            while (n9 < n3 / 8) {
                byte by = byArray[n7 * n6 + n9];
                n8 = 7;
                while (n8 >= 0) {
                    this.pixels[n5++] = byArray2[by >> n8 & 1];
                    --n8;
                }
                ++n9;
            }
            n8 = 7;
            while (n8 >= 8 - n3 % 8) {
                this.pixels[n5++] = byArray2[byArray[n7 * n6 + n9] >> n8 & 1];
                --n8;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n7;
        }
    }

    void drawRawRect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = n2;
        while (n5 < n2 + n4) {
            this.rfb.is.readFully(this.pixels, n5 * this.rfb.framebufferWidth + n, n3);
            ++n5;
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
    }

    void drawTightRect(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6 = this.rfb.is.readUnsignedByte();
        int n7 = 0;
        while (n7 < 4) {
            if ((n6 & 1) != 0 && this.tightInflaters[n7] != null) {
                this.tightInflaters[n7] = null;
            }
            n6 >>= 1;
            ++n7;
        }
        if (n6 > 8) {
            throw new IOException("Incorrect tight subencoding: " + n6);
        }
        if (n6 == 8) {
            int n8 = this.rfb.is.readUnsignedByte();
            this.sg.setColor(this.colors[n8]);
            this.sg.fillRect(n, n2, n3, n4);
            this.fillLargeArea(n, n2, n3, n4, (byte)n8);
            this.handleUpdatedPixels(n, n2, n3, n4);
            return;
        }
        int n9 = 0;
        int n10 = n3;
        byte[] byArray = new byte[2];
        if ((n6 & 4) != 0) {
            n5 = this.rfb.is.readUnsignedByte();
            if (n5 == 1) {
                n9 = this.rfb.is.readUnsignedByte() + 1;
                if (n9 != 2) {
                    throw new IOException("Incorrect tight palette size: " + n9);
                }
                byArray[0] = this.rfb.is.readByte();
                byArray[1] = this.rfb.is.readByte();
                n10 = (n3 + 7) / 8;
            } else if (n5 != 0) {
                throw new IOException("Incorrect tight filter id: " + n5);
            }
        }
        if ((n5 = n4 * n10) < 12) {
            if (n9 == 2) {
                byte[] byArray2 = new byte[n5];
                this.rfb.is.readFully(byArray2, 0, n5);
                this.drawMonoData(n, n2, n3, n4, byArray2, byArray);
            } else {
                int n11 = n2;
                while (n11 < n2 + n4) {
                    this.rfb.is.readFully(this.pixels, n11 * this.rfb.framebufferWidth + n, n3);
                    ++n11;
                }
            }
        } else {
            int n12 = this.rfb.readCompactLen();
            byte[] byArray3 = new byte[n12];
            this.rfb.is.readFully(byArray3, 0, n12);
            int n13 = n6 & 3;
            if (this.tightInflaters[n13] == null) {
                this.tightInflaters[n13] = new Inflater();
            }
            Inflater inflater = this.tightInflaters[n13];
            inflater.setInput(byArray3, 0, n12);
            try {
                if (n9 == 2) {
                    byte[] byArray4 = new byte[n5];
                    inflater.inflate(byArray4, 0, n5);
                    this.drawMonoData(n, n2, n3, n4, byArray4, byArray);
                }
                int n14 = n2;
                while (n14 < n2 + n4) {
                    inflater.inflate(this.pixels, n14 * this.rfb.framebufferWidth + n, n3);
                    ++n14;
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException.toString());
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
    }

    void drawZlibRect(int n, int n2, int n3, int n4) throws IOException {
        try {
            int n5 = n2;
            while (n5 < n2 + n4) {
                this.zlibInflater.inflate(this.pixels, n5 * this.rfb.framebufferWidth + n, n3);
                ++n5;
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException(dataFormatException.toString());
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
    }

    void fillLargeArea(int n, int n2, int n3, int n4, byte by) {
        byte[] byArray = new byte[n3];
        int n5 = 0;
        while (n5 < n3) {
            byArray[n5] = by;
            ++n5;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n6 = n2 * this.rfb.framebufferWidth + n;
        int n7 = 0;
        while (n7 < n4) {
            byteArrayInputStream.reset();
            byteArrayInputStream.read(this.pixels, n6, n3);
            n6 += this.rfb.framebufferWidth;
            ++n7;
        }
    }

    void fillSmallArea(int n, int n2, int n3, int n4, byte by) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n3) {
                this.pixels[n5++] = by;
                ++n7;
            }
            n5 += this.rfb.framebufferWidth - n3;
            ++n6;
        }
    }

    void handleCopyRect() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.rfb.copyRectSrcX;
        int n5 = this.rfb.copyRectSrcY;
        int n6 = this.rfb.updateRectX;
        int n7 = this.rfb.updateRectY;
        int n8 = this.rfb.updateRectW;
        int n9 = this.rfb.updateRectH;
        this.sg.copyArea(n4, n5, n8, n9, n6 - n4, n7 - n5);
        if (n5 > n7) {
            n3 = 0;
            n2 = n9;
            n = 1;
        } else if (n5 < n7) {
            n3 = n9 - 1;
            n2 = -1;
            n = -1;
        } else {
            this.handleCopyRectSlow();
            return;
        }
        int n10 = n3;
        while (n10 != n2) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pixels);
            byteArrayInputStream.skip((n5 + n10) * this.rfb.framebufferWidth + n4);
            byteArrayInputStream.read(this.pixels, (n7 + n10) * this.rfb.framebufferWidth + n6, n8);
            n10 += n;
        }
        this.handleUpdatedPixels(n6, n7, n8, n9);
    }

    void handleCopyRectSlow() throws IOException {
        int n = this.rfb.copyRectSrcX;
        int n2 = this.rfb.copyRectSrcY;
        int n3 = this.rfb.updateRectX;
        int n4 = this.rfb.updateRectY;
        int n5 = this.rfb.updateRectW;
        int n6 = this.rfb.updateRectH;
        if (n2 * this.rfb.framebufferWidth + n > n4 * this.rfb.framebufferWidth + n3) {
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    this.pixels[(n4 + n7) * this.rfb.framebufferWidth + (n3 + n8)] = this.pixels[(n2 + n7) * this.rfb.framebufferWidth + (n + n8)];
                    ++n8;
                }
                ++n7;
            }
        } else {
            int n9 = n6 - 1;
            while (n9 >= 0) {
                int n10 = n5 - 1;
                while (n10 >= 0) {
                    this.pixels[(n4 + n9) * this.rfb.framebufferWidth + (n3 + n10)] = this.pixels[(n2 + n9) * this.rfb.framebufferWidth + (n + n10)];
                    --n10;
                }
                --n9;
            }
        }
        this.handleUpdatedPixels(n3, n4, n5, n6);
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7;
        int n8;
        byte[] byArray;
        int n9 = (n4 + 7) / 8;
        int n10 = n9 * n5;
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        if (this.v.options.ignoreCursorUpdates) {
            if (n == -240) {
                this.rfb.is.skipBytes(6 + n10 * 2);
            } else {
                this.rfb.is.skipBytes(n4 * n5 + n10);
            }
            return;
        }
        this.rcSource = new byte[n4 * n5];
        if (n == -240) {
            byArray = new byte[6];
            this.rfb.is.readFully(byArray, 0, 6);
            byte[] byArray2 = new byte[2];
            byArray2[1] = (byte)(byArray[0] >> 5 & 7 | byArray[1] >> 2 & 0x38 | byArray[2] & 0xC0);
            byArray2[0] = (byte)(byArray[3] >> 5 & 7 | byArray[4] >> 2 & 0x38 | byArray[5] & 0xC0);
            byte[] byArray3 = new byte[n10];
            this.rfb.is.readFully(byArray3, 0, n10);
            int n11 = 0;
            n8 = 0;
            while (n8 < n5) {
                n7 = 0;
                while (n7 < n4 / 8) {
                    byte by = byArray3[n8 * n9 + n7];
                    n6 = 7;
                    while (n6 >= 0) {
                        this.rcSource[n11++] = byArray2[by >> n6 & 1];
                        --n6;
                    }
                    ++n7;
                }
                n6 = 7;
                while (n6 >= 8 - n4 % 8) {
                    this.rcSource[n11++] = byArray2[byArray3[n8 * n9 + n7] >> n6 & 1];
                    --n6;
                }
                ++n8;
            }
        } else {
            this.rfb.is.readFully(this.rcSource, 0, n4 * n5);
        }
        byArray = new byte[n10];
        this.rfb.is.readFully(byArray, 0, n10);
        this.rcMask = new boolean[n4 * n5];
        n6 = 0;
        int n12 = 0;
        while (n12 < n5) {
            int n13 = 0;
            while (n13 < n4 / 8) {
                n8 = byArray[n12 * n9 + n13];
                n7 = 7;
                while (n7 >= 0) {
                    this.rcMask[n6++] = (n8 >> n7 & 1) != 0;
                    --n7;
                }
                ++n13;
            }
            n7 = 7;
            while (n7 >= 8 - n4 % 8) {
                this.rcMask[n6++] = (byArray[n12 * n9 + n13] >> n7 & 1) != 0;
                --n7;
            }
            ++n12;
        }
        this.rcSavedArea = new byte[n4 * n5];
        this.rcHotX = n2;
        this.rcHotY = n3;
        this.rcWidth = n4;
        this.rcHeight = n5;
        this.softCursorSaveArea();
        this.softCursorDraw();
        this.rcCursorHidden = false;
        this.rcLockSet = false;
        this.prevCursorSet = true;
    }

    public boolean handleEvent(Event event) {
        block8: {
            if (this.rfb == null || !this.rfb.inNormalProtocol) break block8;
            try {
                switch (event.id) {
                    case 503: 
                    case 506: {
                        this.softCursorMove(event.x, event.y);
                    }
                    case 501: 
                    case 502: {
                        if (this.v.gotFocus) {
                            this.requestFocus();
                        }
                        this.rfb.writePointerEvent(event);
                        break;
                    }
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: {
                        this.rfb.writeKeyEvent(event);
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    synchronized void handleUpdatedPixels(int n, int n2, int n3, int n4) throws IOException {
        this.amis.newPixels(n, n2, n3, n4);
        try {
            this.sg.setClip(n, n2, n3, n4);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.sg2 = this.sg.create();
            this.sg.clipRect(n, n2, n3, n4);
        }
        this.sg.drawImage(this.rawPixelsImage, 0, 0, this);
        if (this.sg2 == null) {
            this.sg.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        } else {
            this.sg.dispose();
            this.sg = this.sg2;
            this.sg2 = null;
        }
    }

    public Dimension minimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.rawPixelsImage, 0, 0, this);
    }

    public Dimension preferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public void processNormalProtocol() throws IOException {
        int n;
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        this.sg = this.getGraphics();
        block15: while (true) {
            n = this.rfb.readServerMessageType();
            switch (n) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    int n2 = 0;
                    while (n2 < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -240 || this.rfb.updateRectEncoding == -239) {
                            this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                        } else {
                            this.softCursorLockArea(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                            switch (this.rfb.updateRectEncoding) {
                                case 0: {
                                    this.drawRawRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    break;
                                }
                                case 1: {
                                    this.rfb.readCopyRect();
                                    this.softCursorLockArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    this.handleCopyRect();
                                    break;
                                }
                                case 2: {
                                    int n3;
                                    int n4;
                                    int n5;
                                    int n6;
                                    int n7;
                                    int n8 = this.rfb.updateRectX;
                                    int n9 = this.rfb.updateRectY;
                                    int n10 = this.rfb.updateRectW;
                                    int n11 = this.rfb.updateRectH;
                                    int n12 = this.rfb.is.readInt();
                                    int n13 = this.rfb.is.read();
                                    this.fillLargeArea(n8, n9, n10, n11, (byte)n13);
                                    int n14 = 0;
                                    while (n14 < n12) {
                                        n7 = this.rfb.is.read();
                                        n6 = n8 + this.rfb.is.readUnsignedShort();
                                        n5 = n9 + this.rfb.is.readUnsignedShort();
                                        n4 = this.rfb.is.readUnsignedShort();
                                        n3 = this.rfb.is.readUnsignedShort();
                                        this.fillSmallArea(n6, n5, n4, n3, (byte)n7);
                                        ++n14;
                                    }
                                    this.handleUpdatedPixels(n8, n9, n10, n11);
                                    break;
                                }
                                case 4: {
                                    int n3;
                                    int n4;
                                    int n5;
                                    int n6;
                                    int n7;
                                    int n8 = this.rfb.updateRectX;
                                    int n9 = this.rfb.updateRectY;
                                    int n10 = this.rfb.updateRectW;
                                    int n11 = this.rfb.updateRectH;
                                    int n12 = this.rfb.is.readInt();
                                    int n13 = this.rfb.is.read();
                                    this.fillLargeArea(n8, n9, n10, n11, (byte)n13);
                                    int n14 = 0;
                                    while (n14 < n12) {
                                        n7 = this.rfb.is.read();
                                        n6 = n8 + this.rfb.is.read();
                                        n5 = n9 + this.rfb.is.read();
                                        n4 = this.rfb.is.read();
                                        n3 = this.rfb.is.read();
                                        this.fillSmallArea(n6, n5, n4, n3, (byte)n7);
                                        ++n14;
                                    }
                                    this.handleUpdatedPixels(n8, n9, n10, n11);
                                    break;
                                }
                                case 5: {
                                    int n4;
                                    int n5;
                                    int n6;
                                    int n7;
                                    int n14;
                                    int n8 = this.rfb.updateRectX;
                                    int n9 = this.rfb.updateRectY;
                                    int n10 = this.rfb.updateRectW;
                                    int n11 = this.rfb.updateRectH;
                                    int n12 = 0;
                                    int n13 = 0;
                                    int n3 = n9;
                                    while (n3 < n9 + n11) {
                                        n14 = 16;
                                        if (n9 + n11 - n3 < 16) {
                                            n14 = n9 + n11 - n3;
                                        }
                                        int n15 = n8;
                                        while (n15 < n8 + n10) {
                                            int n16;
                                            int n17;
                                            int n18 = 16;
                                            if (n8 + n10 - n15 < 16) {
                                                n18 = n8 + n10 - n15;
                                            }
                                            if (((n17 = this.rfb.is.read()) & 1) != 0) {
                                                n16 = n3;
                                                while (n16 < n3 + n14) {
                                                    this.rfb.is.readFully(this.pixels, n16 * this.rfb.framebufferWidth + n15, n18);
                                                    ++n16;
                                                }
                                            } else {
                                                if ((n17 & 2) != 0) {
                                                    n12 = this.rfb.is.read();
                                                }
                                                this.fillLargeArea(n15, n3, n18, n14, (byte)n12);
                                                if ((n17 & 4) != 0) {
                                                    n13 = this.rfb.is.read();
                                                }
                                                if ((n17 & 8) != 0) {
                                                    int n19;
                                                    int n20;
                                                    int n21;
                                                    n16 = this.rfb.is.read();
                                                    if ((n17 & 0x10) != 0) {
                                                        n21 = 0;
                                                        while (n21 < n16) {
                                                            n13 = this.rfb.is.read();
                                                            n20 = this.rfb.is.read();
                                                            n19 = this.rfb.is.read();
                                                            n7 = n15 + (n20 >> 4);
                                                            n6 = n3 + (n20 & 0xF);
                                                            n5 = (n19 >> 4) + 1;
                                                            n4 = (n19 & 0xF) + 1;
                                                            this.fillSmallArea(n7, n6, n5, n4, (byte)n13);
                                                            ++n21;
                                                        }
                                                    } else {
                                                        n21 = 0;
                                                        while (n21 < n16) {
                                                            n20 = this.rfb.is.read();
                                                            n19 = this.rfb.is.read();
                                                            n7 = n15 + (n20 >> 4);
                                                            n6 = n3 + (n20 & 0xF);
                                                            n5 = (n19 >> 4) + 1;
                                                            n4 = (n19 & 0xF) + 1;
                                                            this.fillSmallArea(n7, n6, n5, n4, (byte)n13);
                                                            ++n21;
                                                        }
                                                    }
                                                }
                                            }
                                            n15 += 16;
                                        }
                                        this.handleUpdatedPixels(n8, n3, n10, n14);
                                        n3 += 16;
                                    }
                                    break;
                                }
                                case 6: {
                                    int n8 = this.rfb.is.readInt();
                                    if (this.zlibBuf == null || this.zlibBufLen < n8) {
                                        this.zlibBuf = new byte[n8 * 2];
                                        this.zlibBufLen = n8 * 2;
                                    }
                                    this.rfb.is.readFully(this.zlibBuf, 0, n8);
                                    if (this.zlibInflater == null) {
                                        this.zlibInflater = new Inflater();
                                    }
                                    this.zlibInflater.setInput(this.zlibBuf, 0, n8);
                                    this.drawZlibRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    break;
                                }
                                case 7: {
                                    this.drawTightRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                    break;
                                }
                                default: {
                                    throw new IOException("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                                }
                            }
                            this.softCursorUnlockScreen();
                        }
                        ++n2;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, true);
                    continue block15;
                }
                case 1: {
                    throw new IOException("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    System.out.print('\u0007');
                    continue block15;
                }
                case 3: {
                    String string = this.rfb.readServerCutText();
                    this.v.clipboard.setCutText(string);
                    continue block15;
                }
            }
            break;
        }
        throw new IOException("Unknown RFB message type " + n);
    }

    void softCursorDraw() throws IOException {
        int n = 0;
        while (n < this.rcHeight) {
            int n2 = this.rcCursorY - this.rcHotY + n;
            if (n2 >= 0 && n2 < this.rfb.framebufferHeight) {
                int n3 = 0;
                while (n3 < this.rcWidth) {
                    int n4;
                    int n5 = this.rcCursorX - this.rcHotX + n3;
                    if (n5 >= 0 && n5 < this.rfb.framebufferWidth && this.rcMask[n4 = n * this.rcWidth + n3]) {
                        this.pixels[n2 * this.rfb.framebufferWidth + n5] = this.rcSource[n4];
                    }
                    ++n3;
                }
            }
            ++n;
        }
        Rectangle rectangle = new Rectangle();
        this.softCursorToScreen(rectangle, null);
        this.handleUpdatedPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    synchronized void softCursorFree() throws IOException {
        if (this.prevCursorSet) {
            this.softCursorRestoreArea();
            this.rcSavedArea = null;
            this.rcSource = null;
            this.rcMask = null;
            this.prevCursorSet = false;
        }
    }

    boolean softCursorInLockedArea() {
        return this.rcLockX < this.rcCursorX - this.rcHotX + this.rcWidth && this.rcLockY < this.rcCursorY - this.rcHotY + this.rcHeight && this.rcLockX + this.rcLockWidth > this.rcCursorX - this.rcHotX && this.rcLockY + this.rcLockHeight > this.rcCursorY - this.rcHotY;
    }

    synchronized void softCursorLockArea(int n, int n2, int n3, int n4) throws IOException {
        if (!this.prevCursorSet) {
            return;
        }
        if (!this.rcLockSet) {
            this.rcLockX = n;
            this.rcLockY = n2;
            this.rcLockWidth = n3;
            this.rcLockHeight = n4;
            this.rcLockSet = true;
        } else {
            int n5 = n < this.rcLockX ? n : this.rcLockX;
            int n6 = n2 < this.rcLockY ? n2 : this.rcLockY;
            this.rcLockWidth = n + n3 > this.rcLockX + this.rcLockWidth ? n + n3 - n5 : this.rcLockX + this.rcLockWidth - n5;
            this.rcLockHeight = n2 + n4 > this.rcLockY + this.rcLockHeight ? n2 + n4 - n6 : this.rcLockY + this.rcLockHeight - n6;
            this.rcLockX = n5;
            this.rcLockY = n6;
        }
        if (!this.rcCursorHidden && this.softCursorInLockedArea()) {
            this.softCursorRestoreArea();
            this.rcCursorHidden = true;
        }
    }

    synchronized void softCursorMove(int n, int n2) throws IOException {
        if (this.prevCursorSet && !this.rcCursorHidden) {
            this.softCursorRestoreArea();
            this.rcCursorHidden = true;
        }
        this.rcCursorX = n;
        this.rcCursorY = n2;
        if (!(!this.prevCursorSet || this.rcLockSet && this.softCursorInLockedArea())) {
            this.softCursorSaveArea();
            this.softCursorDraw();
            this.rcCursorHidden = false;
        }
    }

    void softCursorRestoreArea() throws IOException {
        Rectangle rectangle = new Rectangle();
        this.softCursorToScreen(rectangle, null);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            int n7 = n;
            while (n7 < n + n3) {
                this.pixels[n6 * this.rfb.framebufferWidth + n7] = this.rcSavedArea[n5++];
                ++n7;
            }
            ++n6;
        }
        this.handleUpdatedPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void softCursorSaveArea() {
        Rectangle rectangle = new Rectangle();
        this.softCursorToScreen(rectangle, null);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            int n7 = n;
            while (n7 < n + n3) {
                this.rcSavedArea[n5++] = this.pixels[n6 * this.rfb.framebufferWidth + n7];
                ++n7;
            }
            ++n6;
        }
    }

    void softCursorToScreen(Rectangle rectangle, Point point) {
        int n = 0;
        int n2 = 0;
        int n3 = this.rcCursorX - this.rcHotX;
        int n4 = this.rcCursorY - this.rcHotY;
        int n5 = this.rcWidth;
        int n6 = this.rcHeight;
        if (n3 < 0) {
            n = -n3;
            n5 -= n;
            n3 = 0;
        } else if (n3 + n5 > this.rfb.framebufferWidth) {
            n5 = this.rfb.framebufferWidth - n3;
        }
        if (n4 < 0) {
            n2 = -n4;
            n6 -= n2;
            n4 = 0;
        } else if (n4 + n6 > this.rfb.framebufferHeight) {
            n6 = this.rfb.framebufferHeight - n4;
        }
        if (n5 < 0) {
            n = 0;
            n3 = 0;
            n5 = 0;
        }
        if (n6 < 0) {
            n2 = 0;
            n4 = 0;
            n6 = 0;
        }
        if (rectangle != null) {
            rectangle.setBounds(n3, n4, n5, n6);
        }
        if (point != null) {
            point.setLocation(n, n2);
        }
    }

    synchronized void softCursorUnlockScreen() throws IOException {
        if (!this.prevCursorSet) {
            return;
        }
        if (this.rcCursorHidden) {
            this.softCursorSaveArea();
            this.softCursorDraw();
            this.rcCursorHidden = false;
        }
        this.rcLockSet = false;
    }

    public void update(Graphics graphics) {
    }
}

