// Copyright (c) 2012-2017 VideoStitch SAS
// Copyright (c) 2018 stitchEm

#ifndef EMOR_COEFS_HPP_
#define EMOR_COEFS_HPP_

namespace VideoStitch {
namespace Core {
namespace {
/**
 * EMoR Coefficients, from:
 * http://www1.cs.columbia.edu/CAVE/software/dorf/response/emor.txt
 */
const float f0[1024] = {
    0.000000e+000f, 8.833750e-003f, 1.497601e-002f, 2.023710e-002f, 2.498590e-002f, 2.937536e-002f, 3.348347e-002f,
    3.740247e-002f, 4.116645e-002f, 4.481240e-002f, 4.835121e-002f, 5.178991e-002f, 5.514774e-002f, 5.843527e-002f,
    6.167138e-002f, 6.485830e-002f, 6.799864e-002f, 7.109369e-002f, 7.414113e-002f, 7.714684e-002f, 8.011208e-002f,
    8.303313e-002f, 8.591695e-002f, 8.876004e-002f, 9.156913e-002f, 9.434381e-002f, 9.708718e-002f, 9.980128e-002f,
    1.024881e-001f, 1.051487e-001f, 1.077847e-001f, 1.103984e-001f, 1.129923e-001f, 1.155692e-001f, 1.181306e-001f,
    1.206751e-001f, 1.232042e-001f, 1.257223e-001f, 1.282268e-001f, 1.307177e-001f, 1.331949e-001f, 1.356606e-001f,
    1.381127e-001f, 1.405497e-001f, 1.429754e-001f, 1.453869e-001f, 1.477816e-001f, 1.501633e-001f, 1.525314e-001f,
    1.548870e-001f, 1.572343e-001f, 1.595739e-001f, 1.619041e-001f, 1.642287e-001f, 1.665419e-001f, 1.688466e-001f,
    1.711441e-001f, 1.734281e-001f, 1.757041e-001f, 1.779716e-001f, 1.802266e-001f, 1.824685e-001f, 1.847028e-001f,
    1.869270e-001f, 1.891430e-001f, 1.913527e-001f, 1.935541e-001f, 1.957470e-001f, 1.979323e-001f, 2.001116e-001f,
    2.022840e-001f, 2.044483e-001f, 2.066046e-001f, 2.087546e-001f, 2.108964e-001f, 2.130336e-001f, 2.151646e-001f,
    2.172897e-001f, 2.194090e-001f, 2.215230e-001f, 2.236334e-001f, 2.257399e-001f, 2.278428e-001f, 2.299395e-001f,
    2.320352e-001f, 2.341277e-001f, 2.362148e-001f, 2.383003e-001f, 2.403819e-001f, 2.424598e-001f, 2.445341e-001f,
    2.466031e-001f, 2.486695e-001f, 2.507313e-001f, 2.527875e-001f, 2.548405e-001f, 2.568878e-001f, 2.589288e-001f,
    2.609657e-001f, 2.629976e-001f, 2.650239e-001f, 2.670452e-001f, 2.690614e-001f, 2.710740e-001f, 2.730820e-001f,
    2.750845e-001f, 2.770829e-001f, 2.790768e-001f, 2.810665e-001f, 2.830520e-001f, 2.850325e-001f, 2.870062e-001f,
    2.889752e-001f, 2.909403e-001f, 2.929002e-001f, 2.948523e-001f, 2.967999e-001f, 2.987424e-001f, 3.006780e-001f,
    3.026081e-001f, 3.045304e-001f, 3.064477e-001f, 3.083587e-001f, 3.102641e-001f, 3.121645e-001f, 3.140588e-001f,
    3.159478e-001f, 3.178321e-001f, 3.197115e-001f, 3.215854e-001f, 3.234539e-001f, 3.253173e-001f, 3.271750e-001f,
    3.290263e-001f, 3.308733e-001f, 3.327147e-001f, 3.345507e-001f, 3.363827e-001f, 3.382077e-001f, 3.400275e-001f,
    3.418430e-001f, 3.436523e-001f, 3.454572e-001f, 3.472560e-001f, 3.490492e-001f, 3.508357e-001f, 3.526168e-001f,
    3.543927e-001f, 3.561617e-001f, 3.579243e-001f, 3.596821e-001f, 3.614338e-001f, 3.631794e-001f, 3.649187e-001f,
    3.666514e-001f, 3.683797e-001f, 3.701042e-001f, 3.718237e-001f, 3.735390e-001f, 3.752482e-001f, 3.769527e-001f,
    3.786515e-001f, 3.803469e-001f, 3.820369e-001f, 3.837210e-001f, 3.853998e-001f, 3.870728e-001f, 3.887416e-001f,
    3.904061e-001f, 3.920668e-001f, 3.937225e-001f, 3.953728e-001f, 3.970202e-001f, 3.986625e-001f, 4.003001e-001f,
    4.019333e-001f, 4.035619e-001f, 4.051867e-001f, 4.068054e-001f, 4.084197e-001f, 4.100310e-001f, 4.116374e-001f,
    4.132398e-001f, 4.148394e-001f, 4.164354e-001f, 4.180263e-001f, 4.196143e-001f, 4.211982e-001f, 4.227779e-001f,
    4.243544e-001f, 4.259255e-001f, 4.274937e-001f, 4.290582e-001f, 4.306178e-001f, 4.321742e-001f, 4.337241e-001f,
    4.352709e-001f, 4.368133e-001f, 4.383513e-001f, 4.398857e-001f, 4.414162e-001f, 4.429419e-001f, 4.444639e-001f,
    4.459815e-001f, 4.474938e-001f, 4.490017e-001f, 4.505049e-001f, 4.520032e-001f, 4.534963e-001f, 4.549859e-001f,
    4.564702e-001f, 4.579507e-001f, 4.594252e-001f, 4.608951e-001f, 4.623603e-001f, 4.638208e-001f, 4.652769e-001f,
    4.667274e-001f, 4.681745e-001f, 4.696162e-001f, 4.710546e-001f, 4.724894e-001f, 4.739204e-001f, 4.753461e-001f,
    4.767679e-001f, 4.781860e-001f, 4.795997e-001f, 4.810095e-001f, 4.824153e-001f, 4.838171e-001f, 4.852141e-001f,
    4.866072e-001f, 4.879966e-001f, 4.893811e-001f, 4.907610e-001f, 4.921370e-001f, 4.935079e-001f, 4.948743e-001f,
    4.962369e-001f, 4.975940e-001f, 4.989463e-001f, 5.002944e-001f, 5.016375e-001f, 5.029762e-001f, 5.043101e-001f,
    5.056411e-001f, 5.069678e-001f, 5.082890e-001f, 5.096068e-001f, 5.109207e-001f, 5.122312e-001f, 5.135380e-001f,
    5.148395e-001f, 5.161376e-001f, 5.174326e-001f, 5.187239e-001f, 5.200108e-001f, 5.212956e-001f, 5.225765e-001f,
    5.238539e-001f, 5.251270e-001f, 5.263976e-001f, 5.276647e-001f, 5.289288e-001f, 5.301895e-001f, 5.314460e-001f,
    5.326988e-001f, 5.339488e-001f, 5.351959e-001f, 5.364394e-001f, 5.376781e-001f, 5.389128e-001f, 5.401439e-001f,
    5.413711e-001f, 5.425948e-001f, 5.438155e-001f, 5.450334e-001f, 5.462481e-001f, 5.474585e-001f, 5.486653e-001f,
    5.498682e-001f, 5.510679e-001f, 5.522646e-001f, 5.534584e-001f, 5.546488e-001f, 5.558350e-001f, 5.570184e-001f,
    5.581970e-001f, 5.593729e-001f, 5.605464e-001f, 5.617169e-001f, 5.628855e-001f, 5.640514e-001f, 5.652144e-001f,
    5.663742e-001f, 5.675307e-001f, 5.686837e-001f, 5.698335e-001f, 5.709814e-001f, 5.721262e-001f, 5.732678e-001f,
    5.744062e-001f, 5.755408e-001f, 5.766719e-001f, 5.777991e-001f, 5.789228e-001f, 5.800434e-001f, 5.811608e-001f,
    5.822757e-001f, 5.833864e-001f, 5.844935e-001f, 5.855962e-001f, 5.866946e-001f, 5.877900e-001f, 5.888820e-001f,
    5.899714e-001f, 5.910584e-001f, 5.921409e-001f, 5.932197e-001f, 5.942954e-001f, 5.953670e-001f, 5.964353e-001f,
    5.975001e-001f, 5.985620e-001f, 5.996207e-001f, 6.006759e-001f, 6.017287e-001f, 6.027787e-001f, 6.038259e-001f,
    6.048711e-001f, 6.059128e-001f, 6.069513e-001f, 6.079871e-001f, 6.090199e-001f, 6.100498e-001f, 6.110774e-001f,
    6.121015e-001f, 6.131222e-001f, 6.141404e-001f, 6.151544e-001f, 6.161652e-001f, 6.171720e-001f, 6.181760e-001f,
    6.191776e-001f, 6.201763e-001f, 6.211720e-001f, 6.221657e-001f, 6.231560e-001f, 6.241430e-001f, 6.251274e-001f,
    6.261093e-001f, 6.270888e-001f, 6.280658e-001f, 6.290399e-001f, 6.300118e-001f, 6.309817e-001f, 6.319492e-001f,
    6.329147e-001f, 6.338775e-001f, 6.348380e-001f, 6.357973e-001f, 6.367547e-001f, 6.377090e-001f, 6.386612e-001f,
    6.396111e-001f, 6.405584e-001f, 6.415040e-001f, 6.424475e-001f, 6.433883e-001f, 6.443268e-001f, 6.452632e-001f,
    6.461974e-001f, 6.471300e-001f, 6.480595e-001f, 6.489846e-001f, 6.499076e-001f, 6.508284e-001f, 6.517463e-001f,
    6.526614e-001f, 6.535751e-001f, 6.544869e-001f, 6.553963e-001f, 6.563038e-001f, 6.572084e-001f, 6.581105e-001f,
    6.590103e-001f, 6.599075e-001f, 6.608029e-001f, 6.616960e-001f, 6.625868e-001f, 6.634748e-001f, 6.643607e-001f,
    6.652449e-001f, 6.661269e-001f, 6.670068e-001f, 6.678847e-001f, 6.687603e-001f, 6.696338e-001f, 6.705051e-001f,
    6.713738e-001f, 6.722403e-001f, 6.731052e-001f, 6.739680e-001f, 6.748279e-001f, 6.756849e-001f, 6.765397e-001f,
    6.773922e-001f, 6.782424e-001f, 6.790905e-001f, 6.799357e-001f, 6.807790e-001f, 6.816211e-001f, 6.824613e-001f,
    6.832992e-001f, 6.841354e-001f, 6.849693e-001f, 6.858009e-001f, 6.866306e-001f, 6.874586e-001f, 6.882845e-001f,
    6.891088e-001f, 6.899312e-001f, 6.907522e-001f, 6.915713e-001f, 6.923889e-001f, 6.932055e-001f, 6.940204e-001f,
    6.948331e-001f, 6.956444e-001f, 6.964545e-001f, 6.972630e-001f, 6.980709e-001f, 6.988765e-001f, 6.996802e-001f,
    7.004820e-001f, 7.012829e-001f, 7.020820e-001f, 7.028784e-001f, 7.036729e-001f, 7.044662e-001f, 7.052567e-001f,
    7.060448e-001f, 7.068312e-001f, 7.076163e-001f, 7.084000e-001f, 7.091818e-001f, 7.099615e-001f, 7.107392e-001f,
    7.115153e-001f, 7.122902e-001f, 7.130639e-001f, 7.138360e-001f, 7.146063e-001f, 7.153750e-001f, 7.161427e-001f,
    7.169086e-001f, 7.176714e-001f, 7.184334e-001f, 7.191948e-001f, 7.199551e-001f, 7.207136e-001f, 7.214710e-001f,
    7.222273e-001f, 7.229821e-001f, 7.237351e-001f, 7.244873e-001f, 7.252385e-001f, 7.259878e-001f, 7.267357e-001f,
    7.274823e-001f, 7.282280e-001f, 7.289722e-001f, 7.297146e-001f, 7.304559e-001f, 7.311956e-001f, 7.319334e-001f,
    7.326702e-001f, 7.334058e-001f, 7.341401e-001f, 7.348725e-001f, 7.356036e-001f, 7.363326e-001f, 7.370595e-001f,
    7.377838e-001f, 7.385062e-001f, 7.392276e-001f, 7.399476e-001f, 7.406657e-001f, 7.413815e-001f, 7.420955e-001f,
    7.428083e-001f, 7.435197e-001f, 7.442295e-001f, 7.449381e-001f, 7.456450e-001f, 7.463493e-001f, 7.470524e-001f,
    7.477545e-001f, 7.484556e-001f, 7.491544e-001f, 7.498516e-001f, 7.505475e-001f, 7.512428e-001f, 7.519365e-001f,
    7.526290e-001f, 7.533205e-001f, 7.540111e-001f, 7.547005e-001f, 7.553885e-001f, 7.560757e-001f, 7.567612e-001f,
    7.574450e-001f, 7.581269e-001f, 7.588078e-001f, 7.594872e-001f, 7.601647e-001f, 7.608397e-001f, 7.615131e-001f,
    7.621848e-001f, 7.628556e-001f, 7.635244e-001f, 7.641918e-001f, 7.648576e-001f, 7.655221e-001f, 7.661856e-001f,
    7.668478e-001f, 7.675096e-001f, 7.681704e-001f, 7.688298e-001f, 7.694874e-001f, 7.701442e-001f, 7.708006e-001f,
    7.714566e-001f, 7.721111e-001f, 7.727647e-001f, 7.734175e-001f, 7.740696e-001f, 7.747209e-001f, 7.753715e-001f,
    7.760213e-001f, 7.766698e-001f, 7.773165e-001f, 7.779616e-001f, 7.786055e-001f, 7.792483e-001f, 7.798897e-001f,
    7.805297e-001f, 7.811681e-001f, 7.818059e-001f, 7.824431e-001f, 7.830795e-001f, 7.837143e-001f, 7.843478e-001f,
    7.849804e-001f, 7.856122e-001f, 7.862434e-001f, 7.868737e-001f, 7.875034e-001f, 7.881315e-001f, 7.887587e-001f,
    7.893850e-001f, 7.900109e-001f, 7.906364e-001f, 7.912619e-001f, 7.918865e-001f, 7.925099e-001f, 7.931321e-001f,
    7.937540e-001f, 7.943754e-001f, 7.949960e-001f, 7.956153e-001f, 7.962338e-001f, 7.968516e-001f, 7.974686e-001f,
    7.980840e-001f, 7.986981e-001f, 7.993113e-001f, 7.999234e-001f, 8.005342e-001f, 8.011433e-001f, 8.017515e-001f,
    8.023587e-001f, 8.029649e-001f, 8.035695e-001f, 8.041722e-001f, 8.047736e-001f, 8.053747e-001f, 8.059753e-001f,
    8.065749e-001f, 8.071730e-001f, 8.077706e-001f, 8.083676e-001f, 8.089641e-001f, 8.095600e-001f, 8.101552e-001f,
    8.107499e-001f, 8.113440e-001f, 8.119368e-001f, 8.125279e-001f, 8.131183e-001f, 8.137079e-001f, 8.142971e-001f,
    8.148864e-001f, 8.154749e-001f, 8.160624e-001f, 8.166492e-001f, 8.172353e-001f, 8.178209e-001f, 8.184058e-001f,
    8.189893e-001f, 8.195708e-001f, 8.201507e-001f, 8.207299e-001f, 8.213078e-001f, 8.218841e-001f, 8.224596e-001f,
    8.230342e-001f, 8.236078e-001f, 8.241803e-001f, 8.247514e-001f, 8.253219e-001f, 8.258914e-001f, 8.264596e-001f,
    8.270267e-001f, 8.275923e-001f, 8.281567e-001f, 8.287201e-001f, 8.292832e-001f, 8.298456e-001f, 8.304071e-001f,
    8.309677e-001f, 8.315275e-001f, 8.320871e-001f, 8.326465e-001f, 8.332050e-001f, 8.337630e-001f, 8.343207e-001f,
    8.348772e-001f, 8.354332e-001f, 8.359882e-001f, 8.365424e-001f, 8.370960e-001f, 8.376492e-001f, 8.382020e-001f,
    8.387537e-001f, 8.393034e-001f, 8.398514e-001f, 8.403982e-001f, 8.409439e-001f, 8.414888e-001f, 8.420314e-001f,
    8.425724e-001f, 8.431122e-001f, 8.436513e-001f, 8.441898e-001f, 8.447275e-001f, 8.452641e-001f, 8.457995e-001f,
    8.463338e-001f, 8.468673e-001f, 8.474001e-001f, 8.479313e-001f, 8.484619e-001f, 8.489916e-001f, 8.495206e-001f,
    8.500489e-001f, 8.505759e-001f, 8.511019e-001f, 8.516276e-001f, 8.521532e-001f, 8.526788e-001f, 8.532041e-001f,
    8.537274e-001f, 8.542500e-001f, 8.547719e-001f, 8.552934e-001f, 8.558142e-001f, 8.563345e-001f, 8.568541e-001f,
    8.573727e-001f, 8.578908e-001f, 8.584080e-001f, 8.589247e-001f, 8.594402e-001f, 8.599549e-001f, 8.604689e-001f,
    8.609809e-001f, 8.614913e-001f, 8.620006e-001f, 8.625081e-001f, 8.630143e-001f, 8.635199e-001f, 8.640247e-001f,
    8.645286e-001f, 8.650318e-001f, 8.655342e-001f, 8.660358e-001f, 8.665362e-001f, 8.670353e-001f, 8.675341e-001f,
    8.680320e-001f, 8.685293e-001f, 8.690256e-001f, 8.695210e-001f, 8.700148e-001f, 8.705079e-001f, 8.710004e-001f,
    8.714923e-001f, 8.719839e-001f, 8.724751e-001f, 8.729660e-001f, 8.734568e-001f, 8.739459e-001f, 8.744347e-001f,
    8.749232e-001f, 8.754115e-001f, 8.758991e-001f, 8.763859e-001f, 8.768713e-001f, 8.773560e-001f, 8.778394e-001f,
    8.783218e-001f, 8.788030e-001f, 8.792834e-001f, 8.797630e-001f, 8.802419e-001f, 8.807204e-001f, 8.811979e-001f,
    8.816744e-001f, 8.821505e-001f, 8.826258e-001f, 8.831009e-001f, 8.835756e-001f, 8.840499e-001f, 8.845239e-001f,
    8.849976e-001f, 8.854704e-001f, 8.859428e-001f, 8.864150e-001f, 8.868866e-001f, 8.873580e-001f, 8.878287e-001f,
    8.882986e-001f, 8.887683e-001f, 8.892373e-001f, 8.897059e-001f, 8.901739e-001f, 8.906407e-001f, 8.911065e-001f,
    8.915716e-001f, 8.920358e-001f, 8.924988e-001f, 8.929612e-001f, 8.934233e-001f, 8.938844e-001f, 8.943450e-001f,
    8.948051e-001f, 8.952646e-001f, 8.957233e-001f, 8.961818e-001f, 8.966400e-001f, 8.970972e-001f, 8.975541e-001f,
    8.980107e-001f, 8.984668e-001f, 8.989224e-001f, 8.993777e-001f, 8.998324e-001f, 9.002873e-001f, 9.007422e-001f,
    9.011971e-001f, 9.016515e-001f, 9.021055e-001f, 9.025588e-001f, 9.030118e-001f, 9.034647e-001f, 9.039173e-001f,
    9.043691e-001f, 9.048198e-001f, 9.052697e-001f, 9.057189e-001f, 9.061676e-001f, 9.066155e-001f, 9.070628e-001f,
    9.075091e-001f, 9.079547e-001f, 9.083993e-001f, 9.088430e-001f, 9.092861e-001f, 9.097289e-001f, 9.101710e-001f,
    9.106125e-001f, 9.110534e-001f, 9.114935e-001f, 9.119334e-001f, 9.123729e-001f, 9.128117e-001f, 9.132502e-001f,
    9.136887e-001f, 9.141261e-001f, 9.145633e-001f, 9.150005e-001f, 9.154379e-001f, 9.158750e-001f, 9.163116e-001f,
    9.167482e-001f, 9.171846e-001f, 9.176209e-001f, 9.180570e-001f, 9.184931e-001f, 9.189291e-001f, 9.193650e-001f,
    9.198002e-001f, 9.202344e-001f, 9.206675e-001f, 9.211001e-001f, 9.215318e-001f, 9.219623e-001f, 9.223921e-001f,
    9.228206e-001f, 9.232483e-001f, 9.236752e-001f, 9.241015e-001f, 9.245273e-001f, 9.249527e-001f, 9.253776e-001f,
    9.258018e-001f, 9.262260e-001f, 9.266500e-001f, 9.270736e-001f, 9.274966e-001f, 9.279189e-001f, 9.283404e-001f,
    9.287611e-001f, 9.291817e-001f, 9.296025e-001f, 9.300234e-001f, 9.304442e-001f, 9.308649e-001f, 9.312853e-001f,
    9.317051e-001f, 9.321247e-001f, 9.325440e-001f, 9.329630e-001f, 9.333813e-001f, 9.337989e-001f, 9.342158e-001f,
    9.346318e-001f, 9.350470e-001f, 9.354616e-001f, 9.358757e-001f, 9.362891e-001f, 9.367019e-001f, 9.371142e-001f,
    9.375252e-001f, 9.379359e-001f, 9.383464e-001f, 9.387562e-001f, 9.391652e-001f, 9.395733e-001f, 9.399811e-001f,
    9.403880e-001f, 9.407948e-001f, 9.412017e-001f, 9.416088e-001f, 9.420160e-001f, 9.424232e-001f, 9.428301e-001f,
    9.432357e-001f, 9.436407e-001f, 9.440456e-001f, 9.444499e-001f, 9.448543e-001f, 9.452587e-001f, 9.456630e-001f,
    9.460668e-001f, 9.464702e-001f, 9.468731e-001f, 9.472752e-001f, 9.476769e-001f, 9.480781e-001f, 9.484789e-001f,
    9.488786e-001f, 9.492763e-001f, 9.496733e-001f, 9.500697e-001f, 9.504652e-001f, 9.508601e-001f, 9.512542e-001f,
    9.516477e-001f, 9.520401e-001f, 9.524325e-001f, 9.528247e-001f, 9.532167e-001f, 9.536083e-001f, 9.539985e-001f,
    9.543878e-001f, 9.547762e-001f, 9.551640e-001f, 9.555517e-001f, 9.559390e-001f, 9.563265e-001f, 9.567139e-001f,
    9.571011e-001f, 9.574878e-001f, 9.578741e-001f, 9.582601e-001f, 9.586452e-001f, 9.590301e-001f, 9.594146e-001f,
    9.597986e-001f, 9.601827e-001f, 9.605663e-001f, 9.609499e-001f, 9.613334e-001f, 9.617168e-001f, 9.621000e-001f,
    9.624829e-001f, 9.628657e-001f, 9.632470e-001f, 9.636274e-001f, 9.640080e-001f, 9.643889e-001f, 9.647693e-001f,
    9.651495e-001f, 9.655296e-001f, 9.659094e-001f, 9.662882e-001f, 9.666668e-001f, 9.670450e-001f, 9.674231e-001f,
    9.678013e-001f, 9.681793e-001f, 9.685573e-001f, 9.689350e-001f, 9.693117e-001f, 9.696878e-001f, 9.700628e-001f,
    9.704373e-001f, 9.708112e-001f, 9.711849e-001f, 9.715584e-001f, 9.719319e-001f, 9.723043e-001f, 9.726759e-001f,
    9.730465e-001f, 9.734168e-001f, 9.737866e-001f, 9.741559e-001f, 9.745245e-001f, 9.748921e-001f, 9.752583e-001f,
    9.756247e-001f, 9.759911e-001f, 9.763572e-001f, 9.767229e-001f, 9.770882e-001f, 9.774521e-001f, 9.778142e-001f,
    9.781752e-001f, 9.785354e-001f, 9.788955e-001f, 9.792559e-001f, 9.796167e-001f, 9.799774e-001f, 9.803373e-001f,
    9.806962e-001f, 9.810546e-001f, 9.814132e-001f, 9.817717e-001f, 9.821283e-001f, 9.824845e-001f, 9.828408e-001f,
    9.831978e-001f, 9.835534e-001f, 9.839081e-001f, 9.842627e-001f, 9.846173e-001f, 9.849717e-001f, 9.853253e-001f,
    9.856776e-001f, 9.860290e-001f, 9.863792e-001f, 9.867276e-001f, 9.870745e-001f, 9.874211e-001f, 9.877674e-001f,
    9.881133e-001f, 9.884589e-001f, 9.888046e-001f, 9.891491e-001f, 9.894908e-001f, 9.898319e-001f, 9.901736e-001f,
    9.905145e-001f, 9.908552e-001f, 9.911950e-001f, 9.915323e-001f, 9.918691e-001f, 9.922037e-001f, 9.925383e-001f,
    9.928728e-001f, 9.932051e-001f, 9.935379e-001f, 9.938715e-001f, 9.942054e-001f, 9.945395e-001f, 9.948709e-001f,
    9.952013e-001f, 9.955306e-001f, 9.958570e-001f, 9.961821e-001f, 9.965066e-001f, 9.968276e-001f, 9.971488e-001f,
    9.974682e-001f, 9.977856e-001f, 9.981028e-001f, 9.984198e-001f, 9.987365e-001f, 9.990528e-001f, 9.993689e-001f,
    9.996846e-001f, 1.000000e+000f};

const float h1[1024] = {
    0.000000e+000f,  -1.452326e-003f, -2.133227e-003f, -2.674255e-003f, -3.149903e-003f, -3.582399e-003f,
    -3.980914e-003f, -4.359803e-003f, -4.725236e-003f, -5.080627e-003f, -5.427092e-003f, -5.765801e-003f,
    -6.098779e-003f, -6.426347e-003f, -6.750412e-003f, -7.071325e-003f, -7.389887e-003f, -7.705940e-003f,
    -8.018821e-003f, -8.329350e-003f, -8.636635e-003f, -8.939656e-003f, -9.239358e-003f, -9.535422e-003f,
    -9.828782e-003f, -1.011918e-002f, -1.040701e-002f, -1.069241e-002f, -1.097627e-002f, -1.125855e-002f,
    -1.153943e-002f, -1.181888e-002f, -1.209722e-002f, -1.237451e-002f, -1.265082e-002f, -1.292588e-002f,
    -1.319994e-002f, -1.347363e-002f, -1.374673e-002f, -1.401901e-002f, -1.429037e-002f, -1.456117e-002f,
    -1.483101e-002f, -1.509930e-002f, -1.536673e-002f, -1.563288e-002f, -1.589735e-002f, -1.616107e-002f,
    -1.642365e-002f, -1.668546e-002f, -1.694699e-002f, -1.720795e-002f, -1.746800e-002f, -1.772795e-002f,
    -1.798663e-002f, -1.824441e-002f, -1.850145e-002f, -1.875670e-002f, -1.901103e-002f, -1.926427e-002f,
    -1.951601e-002f, -1.976624e-002f, -2.001590e-002f, -2.026443e-002f, -2.051216e-002f, -2.075924e-002f,
    -2.100532e-002f, -2.125028e-002f, -2.149434e-002f, -2.173771e-002f, -2.198008e-002f, -2.222141e-002f,
    -2.246182e-002f, -2.270150e-002f, -2.293991e-002f, -2.317745e-002f, -2.341402e-002f, -2.364972e-002f,
    -2.388422e-002f, -2.411771e-002f, -2.435039e-002f, -2.458214e-002f, -2.481298e-002f, -2.504251e-002f,
    -2.527139e-002f, -2.549926e-002f, -2.572567e-002f, -2.595116e-002f, -2.617529e-002f, -2.639808e-002f,
    -2.661950e-002f, -2.683932e-002f, -2.705793e-002f, -2.727509e-002f, -2.749054e-002f, -2.770478e-002f,
    -2.791765e-002f, -2.812906e-002f, -2.833907e-002f, -2.854777e-002f, -2.875515e-002f, -2.896148e-002f,
    -2.916651e-002f, -2.937037e-002f, -2.957319e-002f, -2.977480e-002f, -2.997510e-002f, -3.017387e-002f,
    -3.037131e-002f, -3.056735e-002f, -3.076189e-002f, -3.095487e-002f, -3.114650e-002f, -3.133707e-002f,
    -3.152595e-002f, -3.171299e-002f, -3.189852e-002f, -3.208257e-002f, -3.226478e-002f, -3.244534e-002f,
    -3.262393e-002f, -3.280084e-002f, -3.297597e-002f, -3.314928e-002f, -3.332076e-002f, -3.349039e-002f,
    -3.365804e-002f, -3.382414e-002f, -3.398861e-002f, -3.415137e-002f, -3.431267e-002f, -3.447234e-002f,
    -3.463056e-002f, -3.478694e-002f, -3.494207e-002f, -3.509573e-002f, -3.524784e-002f, -3.539876e-002f,
    -3.554815e-002f, -3.569617e-002f, -3.584304e-002f, -3.598837e-002f, -3.613225e-002f, -3.627470e-002f,
    -3.641544e-002f, -3.655459e-002f, -3.669223e-002f, -3.682852e-002f, -3.696315e-002f, -3.709616e-002f,
    -3.722770e-002f, -3.735784e-002f, -3.748648e-002f, -3.761366e-002f, -3.773904e-002f, -3.786323e-002f,
    -3.798581e-002f, -3.810706e-002f, -3.822713e-002f, -3.834571e-002f, -3.846347e-002f, -3.857978e-002f,
    -3.869504e-002f, -3.880919e-002f, -3.892227e-002f, -3.903446e-002f, -3.914561e-002f, -3.925559e-002f,
    -3.936454e-002f, -3.947248e-002f, -3.957931e-002f, -3.968514e-002f, -3.978970e-002f, -3.989321e-002f,
    -3.999547e-002f, -4.009679e-002f, -4.019671e-002f, -4.029567e-002f, -4.039327e-002f, -4.048966e-002f,
    -4.058472e-002f, -4.067842e-002f, -4.077072e-002f, -4.086172e-002f, -4.095115e-002f, -4.103928e-002f,
    -4.112599e-002f, -4.121130e-002f, -4.129514e-002f, -4.137745e-002f, -4.145831e-002f, -4.153784e-002f,
    -4.161594e-002f, -4.169268e-002f, -4.176806e-002f, -4.184201e-002f, -4.191495e-002f, -4.198670e-002f,
    -4.205730e-002f, -4.212682e-002f, -4.219527e-002f, -4.226271e-002f, -4.232926e-002f, -4.239516e-002f,
    -4.246016e-002f, -4.252416e-002f, -4.258751e-002f, -4.264987e-002f, -4.271121e-002f, -4.277182e-002f,
    -4.283147e-002f, -4.289001e-002f, -4.294758e-002f, -4.300416e-002f, -4.305989e-002f, -4.311482e-002f,
    -4.316872e-002f, -4.322183e-002f, -4.327415e-002f, -4.332560e-002f, -4.337624e-002f, -4.342598e-002f,
    -4.347473e-002f, -4.352182e-002f, -4.356825e-002f, -4.361366e-002f, -4.365823e-002f, -4.370212e-002f,
    -4.374504e-002f, -4.378715e-002f, -4.382844e-002f, -4.386884e-002f, -4.390862e-002f, -4.394763e-002f,
    -4.398574e-002f, -4.402313e-002f, -4.405966e-002f, -4.409571e-002f, -4.413102e-002f, -4.416548e-002f,
    -4.419924e-002f, -4.423225e-002f, -4.426458e-002f, -4.429625e-002f, -4.432721e-002f, -4.435773e-002f,
    -4.438731e-002f, -4.441590e-002f, -4.444384e-002f, -4.447094e-002f, -4.449737e-002f, -4.452283e-002f,
    -4.454739e-002f, -4.457123e-002f, -4.459430e-002f, -4.461653e-002f, -4.463811e-002f, -4.465908e-002f,
    -4.467913e-002f, -4.469845e-002f, -4.471662e-002f, -4.473380e-002f, -4.475009e-002f, -4.476545e-002f,
    -4.477980e-002f, -4.479333e-002f, -4.480625e-002f, -4.481868e-002f, -4.483077e-002f, -4.484231e-002f,
    -4.485350e-002f, -4.486444e-002f, -4.487481e-002f, -4.488466e-002f, -4.489428e-002f, -4.490342e-002f,
    -4.491209e-002f, -4.492045e-002f, -4.492805e-002f, -4.493506e-002f, -4.494158e-002f, -4.494787e-002f,
    -4.495373e-002f, -4.495914e-002f, -4.496418e-002f, -4.496864e-002f, -4.497266e-002f, -4.497585e-002f,
    -4.497837e-002f, -4.498044e-002f, -4.498202e-002f, -4.498301e-002f, -4.498330e-002f, -4.498296e-002f,
    -4.498195e-002f, -4.498020e-002f, -4.497782e-002f, -4.497470e-002f, -4.497100e-002f, -4.496672e-002f,
    -4.496213e-002f, -4.495708e-002f, -4.495139e-002f, -4.494517e-002f, -4.493846e-002f, -4.493136e-002f,
    -4.492396e-002f, -4.491610e-002f, -4.490805e-002f, -4.489969e-002f, -4.489106e-002f, -4.488211e-002f,
    -4.487255e-002f, -4.486277e-002f, -4.485249e-002f, -4.484181e-002f, -4.483081e-002f, -4.481932e-002f,
    -4.480724e-002f, -4.479465e-002f, -4.478147e-002f, -4.476786e-002f, -4.475389e-002f, -4.473952e-002f,
    -4.472469e-002f, -4.470938e-002f, -4.469373e-002f, -4.467754e-002f, -4.466059e-002f, -4.464314e-002f,
    -4.462507e-002f, -4.460638e-002f, -4.458708e-002f, -4.456743e-002f, -4.454741e-002f, -4.452720e-002f,
    -4.450653e-002f, -4.448564e-002f, -4.446457e-002f, -4.444315e-002f, -4.442160e-002f, -4.439973e-002f,
    -4.437771e-002f, -4.435557e-002f, -4.433333e-002f, -4.431076e-002f, -4.428809e-002f, -4.426507e-002f,
    -4.424180e-002f, -4.421827e-002f, -4.419435e-002f, -4.416995e-002f, -4.414517e-002f, -4.411995e-002f,
    -4.409431e-002f, -4.406830e-002f, -4.404176e-002f, -4.401464e-002f, -4.398713e-002f, -4.395903e-002f,
    -4.393053e-002f, -4.390148e-002f, -4.387187e-002f, -4.384186e-002f, -4.381149e-002f, -4.378073e-002f,
    -4.374977e-002f, -4.371862e-002f, -4.368725e-002f, -4.365557e-002f, -4.362372e-002f, -4.359164e-002f,
    -4.355944e-002f, -4.352701e-002f, -4.349412e-002f, -4.346092e-002f, -4.342764e-002f, -4.339421e-002f,
    -4.336059e-002f, -4.332684e-002f, -4.329287e-002f, -4.325861e-002f, -4.322421e-002f, -4.318963e-002f,
    -4.315485e-002f, -4.311988e-002f, -4.308463e-002f, -4.304913e-002f, -4.301337e-002f, -4.297723e-002f,
    -4.294067e-002f, -4.290364e-002f, -4.286630e-002f, -4.282879e-002f, -4.279104e-002f, -4.275296e-002f,
    -4.271456e-002f, -4.267588e-002f, -4.263693e-002f, -4.259777e-002f, -4.255827e-002f, -4.251860e-002f,
    -4.247873e-002f, -4.243858e-002f, -4.239825e-002f, -4.235783e-002f, -4.231732e-002f, -4.227674e-002f,
    -4.223604e-002f, -4.219519e-002f, -4.215421e-002f, -4.211319e-002f, -4.207202e-002f, -4.203058e-002f,
    -4.198890e-002f, -4.194710e-002f, -4.190514e-002f, -4.186294e-002f, -4.182052e-002f, -4.177779e-002f,
    -4.173476e-002f, -4.169156e-002f, -4.164812e-002f, -4.160442e-002f, -4.156042e-002f, -4.151617e-002f,
    -4.147183e-002f, -4.142717e-002f, -4.138201e-002f, -4.133632e-002f, -4.129025e-002f, -4.124396e-002f,
    -4.119736e-002f, -4.115062e-002f, -4.110383e-002f, -4.105702e-002f, -4.101012e-002f, -4.096321e-002f,
    -4.091652e-002f, -4.086999e-002f, -4.082333e-002f, -4.077658e-002f, -4.072966e-002f, -4.068264e-002f,
    -4.063561e-002f, -4.058844e-002f, -4.054119e-002f, -4.049385e-002f, -4.044649e-002f, -4.039923e-002f,
    -4.035198e-002f, -4.030469e-002f, -4.025731e-002f, -4.020983e-002f, -4.016225e-002f, -4.011440e-002f,
    -4.006619e-002f, -4.001770e-002f, -3.996890e-002f, -3.991991e-002f, -3.987055e-002f, -3.982097e-002f,
    -3.977121e-002f, -3.972128e-002f, -3.967103e-002f, -3.962057e-002f, -3.956995e-002f, -3.951911e-002f,
    -3.946820e-002f, -3.941725e-002f, -3.936621e-002f, -3.931499e-002f, -3.926351e-002f, -3.921183e-002f,
    -3.915993e-002f, -3.910795e-002f, -3.905590e-002f, -3.900372e-002f, -3.895139e-002f, -3.889896e-002f,
    -3.884661e-002f, -3.879430e-002f, -3.874202e-002f, -3.868974e-002f, -3.863756e-002f, -3.858543e-002f,
    -3.853330e-002f, -3.848104e-002f, -3.842885e-002f, -3.837659e-002f, -3.832437e-002f, -3.827206e-002f,
    -3.821967e-002f, -3.816718e-002f, -3.811467e-002f, -3.806202e-002f, -3.800927e-002f, -3.795642e-002f,
    -3.790338e-002f, -3.785004e-002f, -3.779642e-002f, -3.774283e-002f, -3.768910e-002f, -3.763511e-002f,
    -3.758087e-002f, -3.752642e-002f, -3.747180e-002f, -3.741704e-002f, -3.736217e-002f, -3.730733e-002f,
    -3.725246e-002f, -3.719750e-002f, -3.714247e-002f, -3.708753e-002f, -3.703262e-002f, -3.697800e-002f,
    -3.692337e-002f, -3.686882e-002f, -3.681430e-002f, -3.675979e-002f, -3.670506e-002f, -3.665026e-002f,
    -3.659535e-002f, -3.654034e-002f, -3.648529e-002f, -3.643007e-002f, -3.637474e-002f, -3.631929e-002f,
    -3.626369e-002f, -3.620801e-002f, -3.615226e-002f, -3.609632e-002f, -3.604017e-002f, -3.598370e-002f,
    -3.592686e-002f, -3.586971e-002f, -3.581237e-002f, -3.575475e-002f, -3.569686e-002f, -3.563889e-002f,
    -3.558077e-002f, -3.552268e-002f, -3.546456e-002f, -3.540657e-002f, -3.534881e-002f, -3.529128e-002f,
    -3.523379e-002f, -3.517636e-002f, -3.511898e-002f, -3.506159e-002f, -3.500414e-002f, -3.494666e-002f,
    -3.488908e-002f, -3.483150e-002f, -3.477383e-002f, -3.471608e-002f, -3.465814e-002f, -3.460010e-002f,
    -3.454205e-002f, -3.448395e-002f, -3.442572e-002f, -3.436726e-002f, -3.430844e-002f, -3.424929e-002f,
    -3.418989e-002f, -3.413021e-002f, -3.407043e-002f, -3.401052e-002f, -3.395045e-002f, -3.389023e-002f,
    -3.382983e-002f, -3.376928e-002f, -3.370871e-002f, -3.364813e-002f, -3.358757e-002f, -3.352692e-002f,
    -3.346630e-002f, -3.340576e-002f, -3.334525e-002f, -3.328481e-002f, -3.322440e-002f, -3.316406e-002f,
    -3.310386e-002f, -3.304379e-002f, -3.298377e-002f, -3.292377e-002f, -3.286372e-002f, -3.280355e-002f,
    -3.274319e-002f, -3.268266e-002f, -3.262198e-002f, -3.256111e-002f, -3.250009e-002f, -3.243891e-002f,
    -3.237754e-002f, -3.231607e-002f, -3.225447e-002f, -3.219283e-002f, -3.213101e-002f, -3.206899e-002f,
    -3.200680e-002f, -3.194430e-002f, -3.188145e-002f, -3.181831e-002f, -3.175498e-002f, -3.169153e-002f,
    -3.162793e-002f, -3.156425e-002f, -3.150052e-002f, -3.143672e-002f, -3.137295e-002f, -3.130926e-002f,
    -3.124574e-002f, -3.118237e-002f, -3.111912e-002f, -3.105597e-002f, -3.099290e-002f, -3.092988e-002f,
    -3.086698e-002f, -3.080408e-002f, -3.074124e-002f, -3.067840e-002f, -3.061561e-002f, -3.055281e-002f,
    -3.048987e-002f, -3.042686e-002f, -3.036359e-002f, -3.030020e-002f, -3.023671e-002f, -3.017308e-002f,
    -3.010935e-002f, -3.004546e-002f, -2.998135e-002f, -2.991703e-002f, -2.985247e-002f, -2.978771e-002f,
    -2.972264e-002f, -2.965720e-002f, -2.959146e-002f, -2.952556e-002f, -2.945951e-002f, -2.939339e-002f,
    -2.932716e-002f, -2.926086e-002f, -2.919452e-002f, -2.912804e-002f, -2.906153e-002f, -2.899507e-002f,
    -2.892880e-002f, -2.886262e-002f, -2.879658e-002f, -2.873073e-002f, -2.866496e-002f, -2.859924e-002f,
    -2.853353e-002f, -2.846785e-002f, -2.840220e-002f, -2.833658e-002f, -2.827092e-002f, -2.820524e-002f,
    -2.813952e-002f, -2.807372e-002f, -2.800790e-002f, -2.794213e-002f, -2.787632e-002f, -2.781050e-002f,
    -2.774459e-002f, -2.767845e-002f, -2.761209e-002f, -2.754545e-002f, -2.747860e-002f, -2.741149e-002f,
    -2.734402e-002f, -2.727633e-002f, -2.720847e-002f, -2.714041e-002f, -2.707219e-002f, -2.700379e-002f,
    -2.693523e-002f, -2.686658e-002f, -2.679786e-002f, -2.672913e-002f, -2.666035e-002f, -2.659160e-002f,
    -2.652289e-002f, -2.645426e-002f, -2.638563e-002f, -2.631707e-002f, -2.624859e-002f, -2.618019e-002f,
    -2.611194e-002f, -2.604383e-002f, -2.597575e-002f, -2.590775e-002f, -2.583979e-002f, -2.577181e-002f,
    -2.570380e-002f, -2.563576e-002f, -2.556754e-002f, -2.549921e-002f, -2.543084e-002f, -2.536250e-002f,
    -2.529422e-002f, -2.522590e-002f, -2.515742e-002f, -2.508879e-002f, -2.501993e-002f, -2.495078e-002f,
    -2.488133e-002f, -2.481160e-002f, -2.474170e-002f, -2.467165e-002f, -2.460146e-002f, -2.453125e-002f,
    -2.446102e-002f, -2.439082e-002f, -2.432065e-002f, -2.425063e-002f, -2.418066e-002f, -2.411074e-002f,
    -2.404082e-002f, -2.397092e-002f, -2.390089e-002f, -2.383077e-002f, -2.376058e-002f, -2.369044e-002f,
    -2.362035e-002f, -2.355029e-002f, -2.348017e-002f, -2.340993e-002f, -2.333951e-002f, -2.326897e-002f,
    -2.319835e-002f, -2.312768e-002f, -2.305693e-002f, -2.298606e-002f, -2.291496e-002f, -2.284367e-002f,
    -2.277219e-002f, -2.270046e-002f, -2.262853e-002f, -2.255652e-002f, -2.248440e-002f, -2.241222e-002f,
    -2.234001e-002f, -2.226780e-002f, -2.219553e-002f, -2.212314e-002f, -2.205074e-002f, -2.197841e-002f,
    -2.190626e-002f, -2.183424e-002f, -2.176229e-002f, -2.169028e-002f, -2.161810e-002f, -2.154568e-002f,
    -2.147305e-002f, -2.140035e-002f, -2.132762e-002f, -2.125478e-002f, -2.118175e-002f, -2.110860e-002f,
    -2.103531e-002f, -2.096183e-002f, -2.088818e-002f, -2.081438e-002f, -2.074048e-002f, -2.066639e-002f,
    -2.059209e-002f, -2.051752e-002f, -2.044265e-002f, -2.036751e-002f, -2.029207e-002f, -2.021638e-002f,
    -2.014058e-002f, -2.006472e-002f, -1.998890e-002f, -1.991314e-002f, -1.983744e-002f, -1.976183e-002f,
    -1.968627e-002f, -1.961074e-002f, -1.953539e-002f, -1.946019e-002f, -1.938501e-002f, -1.930989e-002f,
    -1.923479e-002f, -1.915966e-002f, -1.908452e-002f, -1.900944e-002f, -1.893439e-002f, -1.885926e-002f,
    -1.878408e-002f, -1.870884e-002f, -1.863348e-002f, -1.855796e-002f, -1.848231e-002f, -1.840652e-002f,
    -1.833057e-002f, -1.825440e-002f, -1.817798e-002f, -1.810133e-002f, -1.802449e-002f, -1.794747e-002f,
    -1.787021e-002f, -1.779264e-002f, -1.771478e-002f, -1.763670e-002f, -1.755842e-002f, -1.747999e-002f,
    -1.740148e-002f, -1.732291e-002f, -1.724431e-002f, -1.716563e-002f, -1.708696e-002f, -1.700842e-002f,
    -1.693010e-002f, -1.685210e-002f, -1.677433e-002f, -1.669677e-002f, -1.661930e-002f, -1.654190e-002f,
    -1.646447e-002f, -1.638702e-002f, -1.630954e-002f, -1.623204e-002f, -1.615443e-002f, -1.607676e-002f,
    -1.599907e-002f, -1.592144e-002f, -1.584389e-002f, -1.576632e-002f, -1.568863e-002f, -1.561081e-002f,
    -1.553288e-002f, -1.545472e-002f, -1.537633e-002f, -1.529772e-002f, -1.521894e-002f, -1.513999e-002f,
    -1.506083e-002f, -1.498161e-002f, -1.490233e-002f, -1.482310e-002f, -1.474395e-002f, -1.466488e-002f,
    -1.458589e-002f, -1.450702e-002f, -1.442836e-002f, -1.434983e-002f, -1.427133e-002f, -1.419289e-002f,
    -1.411455e-002f, -1.403623e-002f, -1.395785e-002f, -1.387951e-002f, -1.380115e-002f, -1.372280e-002f,
    -1.364444e-002f, -1.356610e-002f, -1.348754e-002f, -1.340874e-002f, -1.332979e-002f, -1.325070e-002f,
    -1.317143e-002f, -1.309201e-002f, -1.301245e-002f, -1.293275e-002f, -1.285271e-002f, -1.277242e-002f,
    -1.269182e-002f, -1.261105e-002f, -1.253009e-002f, -1.244900e-002f, -1.236778e-002f, -1.228641e-002f,
    -1.220500e-002f, -1.212366e-002f, -1.204226e-002f, -1.196090e-002f, -1.187970e-002f, -1.179848e-002f,
    -1.171736e-002f, -1.163649e-002f, -1.155585e-002f, -1.147541e-002f, -1.139521e-002f, -1.131516e-002f,
    -1.123521e-002f, -1.115536e-002f, -1.107554e-002f, -1.099559e-002f, -1.091568e-002f, -1.083583e-002f,
    -1.075604e-002f, -1.067644e-002f, -1.059687e-002f, -1.051720e-002f, -1.043748e-002f, -1.035779e-002f,
    -1.027803e-002f, -1.019800e-002f, -1.011781e-002f, -1.003758e-002f, -9.957239e-003f, -9.876816e-003f,
    -9.796439e-003f, -9.716210e-003f, -9.636026e-003f, -9.555834e-003f, -9.475533e-003f, -9.395003e-003f,
    -9.314153e-003f, -9.233184e-003f, -9.152170e-003f, -9.071143e-003f, -8.990137e-003f, -8.909167e-003f,
    -8.828271e-003f, -8.747499e-003f, -8.666663e-003f, -8.585664e-003f, -8.504367e-003f, -8.422923e-003f,
    -8.341348e-003f, -8.259648e-003f, -8.177829e-003f, -8.095776e-003f, -8.013583e-003f, -7.931298e-003f,
    -7.848872e-003f, -7.766315e-003f, -7.683466e-003f, -7.600526e-003f, -7.517544e-003f, -7.434385e-003f,
    -7.351137e-003f, -7.267938e-003f, -7.184759e-003f, -7.101645e-003f, -7.018527e-003f, -6.935418e-003f,
    -6.851983e-003f, -6.768426e-003f, -6.685034e-003f, -6.601836e-003f, -6.518750e-003f, -6.435825e-003f,
    -6.353018e-003f, -6.270365e-003f, -6.187727e-003f, -6.105019e-003f, -6.022069e-003f, -5.938993e-003f,
    -5.855980e-003f, -5.773054e-003f, -5.690185e-003f, -5.607578e-003f, -5.525072e-003f, -5.442573e-003f,
    -5.360150e-003f, -5.277665e-003f, -5.194958e-003f, -5.111897e-003f, -5.028772e-003f, -4.945543e-003f,
    -4.862157e-003f, -4.778586e-003f, -4.694894e-003f, -4.611060e-003f, -4.527402e-003f, -4.443631e-003f,
    -4.359563e-003f, -4.274865e-003f, -4.189983e-003f, -4.104942e-003f, -4.019846e-003f, -3.934731e-003f,
    -3.849588e-003f, -3.764451e-003f, -3.679434e-003f, -3.594517e-003f, -3.509579e-003f, -3.424345e-003f,
    -3.339334e-003f, -3.254477e-003f, -3.169773e-003f, -3.085151e-003f, -3.000545e-003f, -2.915934e-003f,
    -2.831347e-003f, -2.746836e-003f, -2.662332e-003f, -2.577334e-003f, -2.492046e-003f, -2.406713e-003f,
    -2.321474e-003f, -2.236671e-003f, -2.151859e-003f, -2.066829e-003f, -1.981710e-003f, -1.896570e-003f,
    -1.811610e-003f, -1.726102e-003f, -1.639910e-003f, -1.553454e-003f, -1.466765e-003f, -1.379805e-003f,
    -1.292726e-003f, -1.205572e-003f, -1.118955e-003f, -1.032592e-003f, -9.464431e-004f, -8.607769e-004f,
    -7.746067e-004f, -6.883249e-004f, -6.019335e-004f, -5.156037e-004f, -4.293733e-004f, -3.432325e-004f,
    -2.572296e-004f, -1.713395e-004f, -8.560801e-005f, -1.734677e-018f};

const float h2[1024] = {
    0.000000e+000f,  -6.834736e-003f, -1.030655e-002f, -1.309653e-002f, -1.550273e-002f, -1.765338e-002f,
    -1.961569e-002f, -2.144469e-002f, -2.316949e-002f, -2.480979e-002f, -2.637446e-002f, -2.787000e-002f,
    -2.930205e-002f, -3.067509e-002f, -3.199528e-002f, -3.326566e-002f, -3.448766e-002f, -3.566654e-002f,
    -3.680414e-002f, -3.790353e-002f, -3.896870e-002f, -3.999961e-002f, -4.099430e-002f, -4.195820e-002f,
    -4.289104e-002f, -4.379444e-002f, -4.467011e-002f, -4.551842e-002f, -4.634050e-002f, -4.713816e-002f,
    -4.791264e-002f, -4.866400e-002f, -4.939394e-002f, -5.010301e-002f, -5.079321e-002f, -5.146556e-002f,
    -5.212060e-002f, -5.275808e-002f, -5.338037e-002f, -5.398612e-002f, -5.457620e-002f, -5.515033e-002f,
    -5.570914e-002f, -5.625304e-002f, -5.678294e-002f, -5.729777e-002f, -5.779807e-002f, -5.828404e-002f,
    -5.875630e-002f, -5.921497e-002f, -5.966021e-002f, -6.009192e-002f, -6.051124e-002f, -6.091733e-002f,
    -6.131049e-002f, -6.169107e-002f, -6.205854e-002f, -6.241281e-002f, -6.275280e-002f, -6.307833e-002f,
    -6.339045e-002f, -6.368931e-002f, -6.397532e-002f, -6.424917e-002f, -6.450968e-002f, -6.475804e-002f,
    -6.499499e-002f, -6.522048e-002f, -6.543458e-002f, -6.563702e-002f, -6.582738e-002f, -6.600698e-002f,
    -6.617651e-002f, -6.633596e-002f, -6.648488e-002f, -6.662203e-002f, -6.674955e-002f, -6.686704e-002f,
    -6.697447e-002f, -6.707293e-002f, -6.716189e-002f, -6.724087e-002f, -6.731006e-002f, -6.737121e-002f,
    -6.742258e-002f, -6.746481e-002f, -6.749928e-002f, -6.752386e-002f, -6.753829e-002f, -6.754365e-002f,
    -6.754009e-002f, -6.752833e-002f, -6.750745e-002f, -6.747733e-002f, -6.743835e-002f, -6.738998e-002f,
    -6.733389e-002f, -6.726971e-002f, -6.719592e-002f, -6.711396e-002f, -6.702469e-002f, -6.692758e-002f,
    -6.682206e-002f, -6.670795e-002f, -6.658773e-002f, -6.646093e-002f, -6.632665e-002f, -6.618518e-002f,
    -6.603761e-002f, -6.588456e-002f, -6.572434e-002f, -6.555916e-002f, -6.538862e-002f, -6.521215e-002f,
    -6.502931e-002f, -6.484248e-002f, -6.464931e-002f, -6.445091e-002f, -6.424875e-002f, -6.404104e-002f,
    -6.382964e-002f, -6.361353e-002f, -6.339300e-002f, -6.316857e-002f, -6.293894e-002f, -6.270501e-002f,
    -6.246678e-002f, -6.222511e-002f, -6.198001e-002f, -6.173081e-002f, -6.147881e-002f, -6.122315e-002f,
    -6.096412e-002f, -6.070220e-002f, -6.043667e-002f, -6.016932e-002f, -5.989955e-002f, -5.962626e-002f,
    -5.935165e-002f, -5.907452e-002f, -5.879482e-002f, -5.851286e-002f, -5.822720e-002f, -5.793945e-002f,
    -5.764931e-002f, -5.735722e-002f, -5.706336e-002f, -5.676615e-002f, -5.646789e-002f, -5.616717e-002f,
    -5.586355e-002f, -5.555858e-002f, -5.525142e-002f, -5.494337e-002f, -5.463375e-002f, -5.432268e-002f,
    -5.400878e-002f, -5.369359e-002f, -5.337638e-002f, -5.305805e-002f, -5.273846e-002f, -5.241742e-002f,
    -5.209304e-002f, -5.176789e-002f, -5.144062e-002f, -5.111253e-002f, -5.078344e-002f, -5.045272e-002f,
    -5.011944e-002f, -4.978481e-002f, -4.944995e-002f, -4.911371e-002f, -4.877491e-002f, -4.843408e-002f,
    -4.809225e-002f, -4.774920e-002f, -4.740392e-002f, -4.705772e-002f, -4.671063e-002f, -4.636272e-002f,
    -4.601150e-002f, -4.565978e-002f, -4.530795e-002f, -4.495361e-002f, -4.459696e-002f, -4.424074e-002f,
    -4.388182e-002f, -4.352130e-002f, -4.316080e-002f, -4.279696e-002f, -4.243225e-002f, -4.206572e-002f,
    -4.169662e-002f, -4.132640e-002f, -4.095428e-002f, -4.058141e-002f, -4.020654e-002f, -3.983143e-002f,
    -3.945481e-002f, -3.907752e-002f, -3.869863e-002f, -3.831916e-002f, -3.793909e-002f, -3.755856e-002f,
    -3.717837e-002f, -3.679812e-002f, -3.641870e-002f, -3.603933e-002f, -3.566199e-002f, -3.528460e-002f,
    -3.490798e-002f, -3.453196e-002f, -3.415788e-002f, -3.378426e-002f, -3.341166e-002f, -3.303988e-002f,
    -3.266905e-002f, -3.229894e-002f, -3.192930e-002f, -3.156158e-002f, -3.119414e-002f, -3.082719e-002f,
    -3.046210e-002f, -3.009774e-002f, -2.973468e-002f, -2.937301e-002f, -2.901148e-002f, -2.865136e-002f,
    -2.829204e-002f, -2.793274e-002f, -2.757493e-002f, -2.721877e-002f, -2.686271e-002f, -2.650782e-002f,
    -2.615378e-002f, -2.580023e-002f, -2.544731e-002f, -2.509595e-002f, -2.474575e-002f, -2.439674e-002f,
    -2.404838e-002f, -2.370154e-002f, -2.335531e-002f, -2.301049e-002f, -2.266754e-002f, -2.232499e-002f,
    -2.198264e-002f, -2.164178e-002f, -2.130193e-002f, -2.096273e-002f, -2.062418e-002f, -2.028711e-002f,
    -1.995205e-002f, -1.961796e-002f, -1.928439e-002f, -1.895179e-002f, -1.862081e-002f, -1.829111e-002f,
    -1.796200e-002f, -1.763426e-002f, -1.730856e-002f, -1.698441e-002f, -1.666101e-002f, -1.633836e-002f,
    -1.601732e-002f, -1.569876e-002f, -1.538064e-002f, -1.506325e-002f, -1.474730e-002f, -1.443237e-002f,
    -1.411902e-002f, -1.380695e-002f, -1.349567e-002f, -1.318542e-002f, -1.287660e-002f, -1.256888e-002f,
    -1.226211e-002f, -1.195664e-002f, -1.165172e-002f, -1.134866e-002f, -1.104682e-002f, -1.074621e-002f,
    -1.044633e-002f, -1.014755e-002f, -9.850819e-003f, -9.554834e-003f, -9.260157e-003f, -8.967085e-003f,
    -8.674770e-003f, -8.383864e-003f, -8.094663e-003f, -7.806046e-003f, -7.518072e-003f, -7.231338e-003f,
    -6.945811e-003f, -6.661126e-003f, -6.377697e-003f, -6.095236e-003f, -5.814124e-003f, -5.534324e-003f,
    -5.255688e-003f, -4.978303e-003f, -4.701866e-003f, -4.426695e-003f, -4.152214e-003f, -3.878992e-003f,
    -3.607353e-003f, -3.336666e-003f, -3.067033e-003f, -2.797994e-003f, -2.529929e-003f, -2.263697e-003f,
    -1.998356e-003f, -1.733835e-003f, -1.470706e-003f, -1.208125e-003f, -9.470783e-004f, -6.878352e-004f,
    -4.302868e-004f, -1.744681e-004f, 8.006053e-005f,  3.337304e-004f,  5.862463e-004f,  8.373778e-004f,
    1.086435e-003f,  1.334537e-003f,  1.581397e-003f,  1.826863e-003f,  2.071398e-003f,  2.314104e-003f,
    2.555159e-003f,  2.794924e-003f,  3.033519e-003f,  3.270476e-003f,  3.505720e-003f,  3.739996e-003f,
    3.972842e-003f,  4.204140e-003f,  4.434708e-003f,  4.664032e-003f,  4.890714e-003f,  5.116126e-003f,
    5.340849e-003f,  5.564195e-003f,  5.786559e-003f,  6.007642e-003f,  6.226949e-003f,  6.444732e-003f,
    6.661478e-003f,  6.876964e-003f,  7.091547e-003f,  7.304253e-003f,  7.515924e-003f,  7.726824e-003f,
    7.935763e-003f,  8.142976e-003f,  8.349168e-003f,  8.553944e-003f,  8.757340e-003f,  8.959792e-003f,
    9.161106e-003f,  9.361287e-003f,  9.559349e-003f,  9.756497e-003f,  9.952685e-003f,  1.014762e-002f,
    1.034074e-002f,  1.053309e-002f,  1.072541e-002f,  1.091594e-002f,  1.110504e-002f,  1.129373e-002f,
    1.148156e-002f,  1.166782e-002f,  1.185313e-002f,  1.203736e-002f,  1.222075e-002f,  1.240279e-002f,
    1.258331e-002f,  1.276309e-002f,  1.294256e-002f,  1.312040e-002f,  1.329677e-002f,  1.347249e-002f,
    1.364706e-002f,  1.382051e-002f,  1.399266e-002f,  1.416408e-002f,  1.433441e-002f,  1.450364e-002f,
    1.467111e-002f,  1.483672e-002f,  1.500138e-002f,  1.516571e-002f,  1.532860e-002f,  1.549030e-002f,
    1.565125e-002f,  1.581128e-002f,  1.596967e-002f,  1.612637e-002f,  1.628214e-002f,  1.643701e-002f,
    1.659115e-002f,  1.674467e-002f,  1.689665e-002f,  1.704747e-002f,  1.719766e-002f,  1.734634e-002f,
    1.749310e-002f,  1.763928e-002f,  1.778497e-002f,  1.792967e-002f,  1.807319e-002f,  1.821614e-002f,
    1.835842e-002f,  1.849997e-002f,  1.864049e-002f,  1.878001e-002f,  1.891777e-002f,  1.905389e-002f,
    1.918975e-002f,  1.932466e-002f,  1.945806e-002f,  1.959045e-002f,  1.972178e-002f,  1.985215e-002f,
    1.998132e-002f,  2.010955e-002f,  2.023659e-002f,  2.036272e-002f,  2.048797e-002f,  2.061253e-002f,
    2.073551e-002f,  2.085671e-002f,  2.097730e-002f,  2.109728e-002f,  2.121611e-002f,  2.133362e-002f,
    2.145057e-002f,  2.156713e-002f,  2.168222e-002f,  2.179582e-002f,  2.190811e-002f,  2.201902e-002f,
    2.212963e-002f,  2.223941e-002f,  2.234774e-002f,  2.245507e-002f,  2.256168e-002f,  2.266780e-002f,
    2.277300e-002f,  2.287686e-002f,  2.298009e-002f,  2.308251e-002f,  2.318447e-002f,  2.328479e-002f,
    2.338382e-002f,  2.348174e-002f,  2.357885e-002f,  2.367505e-002f,  2.377069e-002f,  2.386548e-002f,
    2.395961e-002f,  2.405276e-002f,  2.414502e-002f,  2.423653e-002f,  2.432725e-002f,  2.441701e-002f,
    2.450582e-002f,  2.459374e-002f,  2.468095e-002f,  2.476778e-002f,  2.485295e-002f,  2.493731e-002f,
    2.502082e-002f,  2.510419e-002f,  2.518703e-002f,  2.526896e-002f,  2.534992e-002f,  2.543015e-002f,
    2.550961e-002f,  2.558855e-002f,  2.566690e-002f,  2.574410e-002f,  2.581993e-002f,  2.589510e-002f,
    2.596982e-002f,  2.604419e-002f,  2.611726e-002f,  2.618891e-002f,  2.625982e-002f,  2.633075e-002f,
    2.640090e-002f,  2.646978e-002f,  2.653755e-002f,  2.660499e-002f,  2.667202e-002f,  2.673802e-002f,
    2.680315e-002f,  2.686678e-002f,  2.692976e-002f,  2.699183e-002f,  2.705374e-002f,  2.711568e-002f,
    2.717667e-002f,  2.723653e-002f,  2.729552e-002f,  2.735416e-002f,  2.741264e-002f,  2.747052e-002f,
    2.752731e-002f,  2.758320e-002f,  2.763833e-002f,  2.769307e-002f,  2.774696e-002f,  2.780023e-002f,
    2.785280e-002f,  2.790422e-002f,  2.795501e-002f,  2.800557e-002f,  2.805546e-002f,  2.810432e-002f,
    2.815198e-002f,  2.819804e-002f,  2.824345e-002f,  2.828880e-002f,  2.833374e-002f,  2.837770e-002f,
    2.842043e-002f,  2.846258e-002f,  2.850428e-002f,  2.854542e-002f,  2.858598e-002f,  2.862594e-002f,
    2.866495e-002f,  2.870252e-002f,  2.873966e-002f,  2.877646e-002f,  2.881295e-002f,  2.884832e-002f,
    2.888255e-002f,  2.891574e-002f,  2.894903e-002f,  2.898223e-002f,  2.901508e-002f,  2.904705e-002f,
    2.907791e-002f,  2.910819e-002f,  2.913826e-002f,  2.916796e-002f,  2.919735e-002f,  2.922622e-002f,
    2.925391e-002f,  2.928040e-002f,  2.930629e-002f,  2.933194e-002f,  2.935745e-002f,  2.938241e-002f,
    2.940608e-002f,  2.942892e-002f,  2.945141e-002f,  2.947362e-002f,  2.949535e-002f,  2.951647e-002f,
    2.953636e-002f,  2.955591e-002f,  2.957522e-002f,  2.959431e-002f,  2.961273e-002f,  2.963049e-002f,
    2.964725e-002f,  2.966316e-002f,  2.967857e-002f,  2.969379e-002f,  2.970889e-002f,  2.972363e-002f,
    2.973772e-002f,  2.975090e-002f,  2.976332e-002f,  2.977532e-002f,  2.978702e-002f,  2.979864e-002f,
    2.980987e-002f,  2.982054e-002f,  2.983048e-002f,  2.983975e-002f,  2.984855e-002f,  2.985685e-002f,
    2.986464e-002f,  2.987176e-002f,  2.987795e-002f,  2.988374e-002f,  2.988937e-002f,  2.989469e-002f,
    2.989998e-002f,  2.990470e-002f,  2.990875e-002f,  2.991192e-002f,  2.991424e-002f,  2.991637e-002f,
    2.991777e-002f,  2.991885e-002f,  2.991928e-002f,  2.991874e-002f,  2.991738e-002f,  2.991572e-002f,
    2.991373e-002f,  2.991128e-002f,  2.990860e-002f,  2.990584e-002f,  2.990235e-002f,  2.989797e-002f,
    2.989336e-002f,  2.988847e-002f,  2.988322e-002f,  2.987778e-002f,  2.987201e-002f,  2.986577e-002f,
    2.985911e-002f,  2.985255e-002f,  2.984558e-002f,  2.983821e-002f,  2.983035e-002f,  2.982172e-002f,
    2.981263e-002f,  2.980268e-002f,  2.979215e-002f,  2.978133e-002f,  2.977045e-002f,  2.975935e-002f,
    2.974743e-002f,  2.973463e-002f,  2.972134e-002f,  2.970785e-002f,  2.969386e-002f,  2.967948e-002f,
    2.966457e-002f,  2.964874e-002f,  2.963212e-002f,  2.961527e-002f,  2.959817e-002f,  2.958032e-002f,
    2.956216e-002f,  2.954350e-002f,  2.952412e-002f,  2.950376e-002f,  2.948252e-002f,  2.946105e-002f,
    2.943933e-002f,  2.941770e-002f,  2.939591e-002f,  2.937378e-002f,  2.935096e-002f,  2.932764e-002f,
    2.930405e-002f,  2.928041e-002f,  2.925683e-002f,  2.923300e-002f,  2.920860e-002f,  2.918345e-002f,
    2.915766e-002f,  2.913147e-002f,  2.910496e-002f,  2.907784e-002f,  2.905027e-002f,  2.902246e-002f,
    2.899426e-002f,  2.896544e-002f,  2.893613e-002f,  2.890619e-002f,  2.887590e-002f,  2.884529e-002f,
    2.881411e-002f,  2.878199e-002f,  2.874931e-002f,  2.871610e-002f,  2.868268e-002f,  2.864918e-002f,
    2.861521e-002f,  2.858077e-002f,  2.854600e-002f,  2.851046e-002f,  2.847440e-002f,  2.843823e-002f,
    2.840170e-002f,  2.836473e-002f,  2.832715e-002f,  2.828919e-002f,  2.825080e-002f,  2.821174e-002f,
    2.817164e-002f,  2.813137e-002f,  2.809064e-002f,  2.804988e-002f,  2.800906e-002f,  2.796814e-002f,
    2.792655e-002f,  2.788389e-002f,  2.784049e-002f,  2.779686e-002f,  2.775313e-002f,  2.770916e-002f,
    2.766488e-002f,  2.762008e-002f,  2.757387e-002f,  2.752694e-002f,  2.748006e-002f,  2.743309e-002f,
    2.738562e-002f,  2.733757e-002f,  2.728918e-002f,  2.724059e-002f,  2.719126e-002f,  2.714126e-002f,
    2.709101e-002f,  2.704059e-002f,  2.699002e-002f,  2.693964e-002f,  2.688949e-002f,  2.683898e-002f,
    2.678728e-002f,  2.673486e-002f,  2.668206e-002f,  2.662915e-002f,  2.657626e-002f,  2.652307e-002f,
    2.646954e-002f,  2.641526e-002f,  2.636039e-002f,  2.630526e-002f,  2.625021e-002f,  2.619506e-002f,
    2.613945e-002f,  2.608340e-002f,  2.602684e-002f,  2.596993e-002f,  2.591262e-002f,  2.585493e-002f,
    2.579680e-002f,  2.573835e-002f,  2.567970e-002f,  2.562103e-002f,  2.556225e-002f,  2.550317e-002f,
    2.544336e-002f,  2.538317e-002f,  2.532253e-002f,  2.526149e-002f,  2.520069e-002f,  2.513982e-002f,
    2.507873e-002f,  2.501757e-002f,  2.495623e-002f,  2.489478e-002f,  2.483325e-002f,  2.477154e-002f,
    2.470957e-002f,  2.464714e-002f,  2.458375e-002f,  2.451995e-002f,  2.445596e-002f,  2.439214e-002f,
    2.432815e-002f,  2.426368e-002f,  2.419895e-002f,  2.413401e-002f,  2.406879e-002f,  2.400333e-002f,
    2.393762e-002f,  2.387124e-002f,  2.380421e-002f,  2.373677e-002f,  2.366924e-002f,  2.360201e-002f,
    2.353462e-002f,  2.346708e-002f,  2.339930e-002f,  2.333108e-002f,  2.326216e-002f,  2.319319e-002f,
    2.312445e-002f,  2.305565e-002f,  2.298672e-002f,  2.291752e-002f,  2.284820e-002f,  2.277878e-002f,
    2.270904e-002f,  2.263863e-002f,  2.256796e-002f,  2.249704e-002f,  2.242582e-002f,  2.235437e-002f,
    2.228287e-002f,  2.221145e-002f,  2.213982e-002f,  2.206778e-002f,  2.199519e-002f,  2.192199e-002f,
    2.184854e-002f,  2.177484e-002f,  2.170073e-002f,  2.162616e-002f,  2.155125e-002f,  2.147579e-002f,
    2.139931e-002f,  2.132241e-002f,  2.124553e-002f,  2.116845e-002f,  2.109140e-002f,  2.101413e-002f,
    2.093653e-002f,  2.085859e-002f,  2.078051e-002f,  2.070170e-002f,  2.062251e-002f,  2.054327e-002f,
    2.046379e-002f,  2.038417e-002f,  2.030452e-002f,  2.022499e-002f,  2.014550e-002f,  2.006557e-002f,
    1.998500e-002f,  1.990404e-002f,  1.982261e-002f,  1.974109e-002f,  1.965972e-002f,  1.957832e-002f,
    1.949669e-002f,  1.941454e-002f,  1.933192e-002f,  1.924860e-002f,  1.916515e-002f,  1.908171e-002f,
    1.899820e-002f,  1.891452e-002f,  1.883073e-002f,  1.874656e-002f,  1.866178e-002f,  1.857668e-002f,
    1.849097e-002f,  1.840473e-002f,  1.831818e-002f,  1.823158e-002f,  1.814483e-002f,  1.805806e-002f,
    1.797132e-002f,  1.788475e-002f,  1.779823e-002f,  1.771130e-002f,  1.762377e-002f,  1.753588e-002f,
    1.744771e-002f,  1.735949e-002f,  1.727150e-002f,  1.718335e-002f,  1.709513e-002f,  1.700680e-002f,
    1.691792e-002f,  1.682779e-002f,  1.673734e-002f,  1.664724e-002f,  1.655709e-002f,  1.646661e-002f,
    1.637596e-002f,  1.628514e-002f,  1.619373e-002f,  1.610176e-002f,  1.600926e-002f,  1.591590e-002f,
    1.582272e-002f,  1.572961e-002f,  1.563630e-002f,  1.554271e-002f,  1.544886e-002f,  1.535515e-002f,
    1.526130e-002f,  1.516701e-002f,  1.507180e-002f,  1.497624e-002f,  1.488052e-002f,  1.478434e-002f,
    1.468826e-002f,  1.459273e-002f,  1.449716e-002f,  1.440158e-002f,  1.430571e-002f,  1.420940e-002f,
    1.411214e-002f,  1.401480e-002f,  1.391760e-002f,  1.382018e-002f,  1.372267e-002f,  1.362512e-002f,
    1.352760e-002f,  1.343008e-002f,  1.333228e-002f,  1.323431e-002f,  1.313591e-002f,  1.303727e-002f,
    1.293852e-002f,  1.283950e-002f,  1.274032e-002f,  1.264080e-002f,  1.254123e-002f,  1.244169e-002f,
    1.234195e-002f,  1.224205e-002f,  1.214193e-002f,  1.204189e-002f,  1.194184e-002f,  1.184131e-002f,
    1.174076e-002f,  1.164014e-002f,  1.153936e-002f,  1.143851e-002f,  1.133759e-002f,  1.123653e-002f,
    1.113548e-002f,  1.103454e-002f,  1.093387e-002f,  1.083302e-002f,  1.073188e-002f,  1.063088e-002f,
    1.052970e-002f,  1.042837e-002f,  1.032659e-002f,  1.022455e-002f,  1.012248e-002f,  1.002035e-002f,
    9.918116e-003f,  9.815804e-003f,  9.713331e-003f,  9.610621e-003f,  9.507541e-003f,  9.404811e-003f,
    9.301925e-003f,  9.198768e-003f,  9.094977e-003f,  8.991043e-003f,  8.887070e-003f,  8.782970e-003f,
    8.678326e-003f,  8.573843e-003f,  8.469633e-003f,  8.365521e-003f,  8.261370e-003f,  8.157106e-003f,
    8.052351e-003f,  7.947350e-003f,  7.842282e-003f,  7.737671e-003f,  7.632770e-003f,  7.527568e-003f,
    7.422291e-003f,  7.316904e-003f,  7.211409e-003f,  7.106033e-003f,  7.000307e-003f,  6.894502e-003f,
    6.788705e-003f,  6.682880e-003f,  6.576743e-003f,  6.470157e-003f,  6.363435e-003f,  6.256815e-003f,
    6.150156e-003f,  6.043626e-003f,  5.936934e-003f,  5.829892e-003f,  5.723172e-003f,  5.616471e-003f,
    5.509550e-003f,  5.401966e-003f,  5.294037e-003f,  5.186386e-003f,  5.078716e-003f,  4.971001e-003f,
    4.863286e-003f,  4.755597e-003f,  4.647307e-003f,  4.538980e-003f,  4.430595e-003f,  4.322479e-003f,
    4.214607e-003f,  4.106767e-003f,  3.998947e-003f,  3.891184e-003f,  3.783453e-003f,  3.675667e-003f,
    3.567486e-003f,  3.459373e-003f,  3.351252e-003f,  3.242571e-003f,  3.134150e-003f,  3.025716e-003f,
    2.917545e-003f,  2.810184e-003f,  2.702678e-003f,  2.595736e-003f,  2.488716e-003f,  2.381184e-003f,
    2.272856e-003f,  2.164048e-003f,  2.054665e-003f,  1.945212e-003f,  1.835736e-003f,  1.726726e-003f,
    1.618062e-003f,  1.509930e-003f,  1.402651e-003f,  1.295712e-003f,  1.188421e-003f,  1.080173e-003f,
    9.714036e-004f,  8.630221e-004f,  7.551179e-004f,  6.472019e-004f,  5.393068e-004f,  4.314098e-004f,
    3.235321e-004f,  2.156618e-004f,  1.078233e-004f,  1.817274e-018f};

const float h3[1024] = {
    0.000000e+000f,  -1.492129e-002f, -2.127088e-002f, -2.618806e-002f, -3.030776e-002f, -3.390256e-002f,
    -3.710799e-002f, -4.003321e-002f, -4.274783e-002f, -4.528460e-002f, -4.765963e-002f, -4.988519e-002f,
    -5.197049e-002f, -5.392217e-002f, -5.575409e-002f, -5.747167e-002f, -5.908103e-002f, -6.059303e-002f,
    -6.201298e-002f, -6.335102e-002f, -6.461079e-002f, -6.579581e-002f, -6.690524e-002f, -6.794801e-002f,
    -6.892519e-002f, -6.984189e-002f, -7.069960e-002f, -7.150041e-002f, -7.224501e-002f, -7.293687e-002f,
    -7.357614e-002f, -7.416297e-002f, -7.469762e-002f, -7.517955e-002f, -7.561567e-002f, -7.600640e-002f,
    -7.634987e-002f, -7.664419e-002f, -7.689663e-002f, -7.710327e-002f, -7.726759e-002f, -7.738455e-002f,
    -7.745873e-002f, -7.749457e-002f, -7.748945e-002f, -7.744165e-002f, -7.735865e-002f, -7.723364e-002f,
    -7.707189e-002f, -7.687827e-002f, -7.664647e-002f, -7.637822e-002f, -7.608302e-002f, -7.575068e-002f,
    -7.538839e-002f, -7.499824e-002f, -7.457771e-002f, -7.412979e-002f, -7.364984e-002f, -7.314172e-002f,
    -7.260533e-002f, -7.204270e-002f, -7.145579e-002f, -7.084881e-002f, -7.021362e-002f, -6.955401e-002f,
    -6.887651e-002f, -6.817895e-002f, -6.746294e-002f, -6.672660e-002f, -6.597115e-002f, -6.519937e-002f,
    -6.441377e-002f, -6.361464e-002f, -6.280368e-002f, -6.197680e-002f, -6.113930e-002f, -6.029036e-002f,
    -5.943020e-002f, -5.856084e-002f, -5.768074e-002f, -5.678807e-002f, -5.588325e-002f, -5.497403e-002f,
    -5.405088e-002f, -5.311932e-002f, -5.218269e-002f, -5.123219e-002f, -5.027069e-002f, -4.930252e-002f,
    -4.832386e-002f, -4.733829e-002f, -4.634025e-002f, -4.533376e-002f, -4.432209e-002f, -4.329936e-002f,
    -4.226919e-002f, -4.123282e-002f, -4.018882e-002f, -3.913876e-002f, -3.808507e-002f, -3.702615e-002f,
    -3.596504e-002f, -3.490341e-002f, -3.384366e-002f, -3.278206e-002f, -3.171784e-002f, -3.065539e-002f,
    -2.959573e-002f, -2.854068e-002f, -2.748243e-002f, -2.643014e-002f, -2.538179e-002f, -2.433511e-002f,
    -2.329353e-002f, -2.225788e-002f, -2.122554e-002f, -2.019842e-002f, -1.918127e-002f, -1.816785e-002f,
    -1.716183e-002f, -1.616060e-002f, -1.516746e-002f, -1.418151e-002f, -1.320141e-002f, -1.222747e-002f,
    -1.126370e-002f, -1.030776e-002f, -9.360055e-003f, -8.420152e-003f, -7.488138e-003f, -6.566507e-003f,
    -5.655479e-003f, -4.756311e-003f, -3.866571e-003f, -2.990216e-003f, -2.126094e-003f, -1.267782e-003f,
    -4.210361e-004f, 4.168841e-004f,  1.246749e-003f,  2.066966e-003f,  2.877267e-003f,  3.679979e-003f,
    4.472107e-003f,  5.252754e-003f,  6.023304e-003f,  6.788588e-003f,  7.544078e-003f,  8.288665e-003f,
    9.025675e-003f,  9.753873e-003f,  1.047475e-002f,  1.118661e-002f,  1.188755e-002f,  1.258288e-002f,
    1.326729e-002f,  1.394282e-002f,  1.461229e-002f,  1.527265e-002f,  1.592762e-002f,  1.657146e-002f,
    1.720636e-002f,  1.782967e-002f,  1.844406e-002f,  1.904969e-002f,  1.964527e-002f,  2.023076e-002f,
    2.081047e-002f,  2.138261e-002f,  2.194487e-002f,  2.250196e-002f,  2.304905e-002f,  2.358819e-002f,
    2.411839e-002f,  2.463960e-002f,  2.514865e-002f,  2.565030e-002f,  2.614183e-002f,  2.662619e-002f,
    2.710025e-002f,  2.756598e-002f,  2.802123e-002f,  2.846987e-002f,  2.891075e-002f,  2.934243e-002f,
    2.976562e-002f,  3.018131e-002f,  3.058678e-002f,  3.098458e-002f,  3.137367e-002f,  3.175329e-002f,
    3.212513e-002f,  3.248639e-002f,  3.283770e-002f,  3.318035e-002f,  3.351670e-002f,  3.384299e-002f,
    3.416177e-002f,  3.447175e-002f,  3.477535e-002f,  3.507138e-002f,  3.536013e-002f,  3.564247e-002f,
    3.591487e-002f,  3.617964e-002f,  3.643723e-002f,  3.668991e-002f,  3.693380e-002f,  3.717302e-002f,
    3.740944e-002f,  3.763660e-002f,  3.785714e-002f,  3.806982e-002f,  3.827548e-002f,  3.847419e-002f,
    3.866396e-002f,  3.885067e-002f,  3.903115e-002f,  3.920685e-002f,  3.937780e-002f,  3.954491e-002f,
    3.970796e-002f,  3.986178e-002f,  4.001373e-002f,  4.015855e-002f,  4.029890e-002f,  4.043529e-002f,
    4.056528e-002f,  4.069092e-002f,  4.081260e-002f,  4.092676e-002f,  4.103873e-002f,  4.114570e-002f,
    4.124747e-002f,  4.134345e-002f,  4.143188e-002f,  4.151645e-002f,  4.159395e-002f,  4.166355e-002f,
    4.173055e-002f,  4.179073e-002f,  4.184467e-002f,  4.189187e-002f,  4.193239e-002f,  4.196968e-002f,
    4.200237e-002f,  4.202886e-002f,  4.205290e-002f,  4.207137e-002f,  4.208656e-002f,  4.209566e-002f,
    4.209963e-002f,  4.209968e-002f,  4.209733e-002f,  4.208945e-002f,  4.207928e-002f,  4.206520e-002f,
    4.204744e-002f,  4.202663e-002f,  4.199872e-002f,  4.196584e-002f,  4.193164e-002f,  4.189285e-002f,
    4.184639e-002f,  4.179631e-002f,  4.174293e-002f,  4.168768e-002f,  4.162983e-002f,  4.156668e-002f,
    4.149975e-002f,  4.142993e-002f,  4.135414e-002f,  4.127279e-002f,  4.119022e-002f,  4.110327e-002f,
    4.101329e-002f,  4.092093e-002f,  4.082437e-002f,  4.072230e-002f,  4.061815e-002f,  4.051180e-002f,
    4.040312e-002f,  4.029203e-002f,  4.017848e-002f,  4.006180e-002f,  3.994356e-002f,  3.982271e-002f,
    3.969911e-002f,  3.957502e-002f,  3.945107e-002f,  3.932636e-002f,  3.919872e-002f,  3.906977e-002f,
    3.893930e-002f,  3.880742e-002f,  3.867382e-002f,  3.853734e-002f,  3.839708e-002f,  3.825433e-002f,
    3.811106e-002f,  3.796525e-002f,  3.781681e-002f,  3.766634e-002f,  3.751375e-002f,  3.735865e-002f,
    3.720277e-002f,  3.704359e-002f,  3.688229e-002f,  3.671925e-002f,  3.655369e-002f,  3.638574e-002f,
    3.621416e-002f,  3.604147e-002f,  3.586678e-002f,  3.569232e-002f,  3.551728e-002f,  3.534102e-002f,
    3.516244e-002f,  3.498119e-002f,  3.479838e-002f,  3.461231e-002f,  3.442526e-002f,  3.423686e-002f,
    3.404634e-002f,  3.385433e-002f,  3.366179e-002f,  3.346944e-002f,  3.327630e-002f,  3.308278e-002f,
    3.288709e-002f,  3.268883e-002f,  3.248765e-002f,  3.228683e-002f,  3.208361e-002f,  3.187810e-002f,
    3.166924e-002f,  3.146022e-002f,  3.124957e-002f,  3.103519e-002f,  3.081974e-002f,  3.060306e-002f,
    3.038578e-002f,  3.016596e-002f,  2.994620e-002f,  2.972404e-002f,  2.949999e-002f,  2.927360e-002f,
    2.904702e-002f,  2.882051e-002f,  2.859334e-002f,  2.836347e-002f,  2.813350e-002f,  2.790291e-002f,
    2.767057e-002f,  2.743701e-002f,  2.720281e-002f,  2.696625e-002f,  2.673157e-002f,  2.649659e-002f,
    2.626168e-002f,  2.602569e-002f,  2.578910e-002f,  2.555118e-002f,  2.531368e-002f,  2.507698e-002f,
    2.484014e-002f,  2.460235e-002f,  2.436583e-002f,  2.412815e-002f,  2.388920e-002f,  2.365033e-002f,
    2.341059e-002f,  2.316970e-002f,  2.292831e-002f,  2.268420e-002f,  2.244054e-002f,  2.219756e-002f,
    2.195360e-002f,  2.170899e-002f,  2.146600e-002f,  2.122240e-002f,  2.097791e-002f,  2.073426e-002f,
    2.049191e-002f,  2.025015e-002f,  2.000811e-002f,  1.976600e-002f,  1.952313e-002f,  1.928183e-002f,
    1.904155e-002f,  1.880019e-002f,  1.855812e-002f,  1.831728e-002f,  1.807667e-002f,  1.783590e-002f,
    1.759459e-002f,  1.735397e-002f,  1.711338e-002f,  1.687298e-002f,  1.663316e-002f,  1.639232e-002f,
    1.615232e-002f,  1.591339e-002f,  1.567317e-002f,  1.543240e-002f,  1.519348e-002f,  1.495407e-002f,
    1.471271e-002f,  1.447120e-002f,  1.423002e-002f,  1.398939e-002f,  1.374940e-002f,  1.350901e-002f,
    1.326724e-002f,  1.302598e-002f,  1.278601e-002f,  1.254618e-002f,  1.230531e-002f,  1.206388e-002f,
    1.182352e-002f,  1.158297e-002f,  1.134161e-002f,  1.110085e-002f,  1.085994e-002f,  1.061897e-002f,
    1.037977e-002f,  1.014137e-002f,  9.901052e-003f,  9.659893e-003f,  9.419405e-003f,  9.179110e-003f,
    8.937359e-003f,  8.695699e-003f,  8.456020e-003f,  8.215845e-003f,  7.975956e-003f,  7.736163e-003f,
    7.496472e-003f,  7.256680e-003f,  7.015320e-003f,  6.775422e-003f,  6.534686e-003f,  6.293493e-003f,
    6.053075e-003f,  5.813559e-003f,  5.574828e-003f,  5.336566e-003f,  5.099228e-003f,  4.863776e-003f,
    4.628290e-003f,  4.393131e-003f,  4.158830e-003f,  3.925326e-003f,  3.692849e-003f,  3.459805e-003f,
    3.227877e-003f,  2.996216e-003f,  2.765209e-003f,  2.535830e-003f,  2.308013e-003f,  2.081011e-003f,
    1.854741e-003f,  1.629909e-003f,  1.406858e-003f,  1.184176e-003f,  9.618576e-004f,  7.402950e-004f,
    5.197663e-004f,  2.995273e-004f,  8.047108e-005f,  -1.378609e-004f, -3.561288e-004f, -5.742468e-004f,
    -7.912948e-004f, -1.006561e-003f, -1.221347e-003f, -1.436459e-003f, -1.652513e-003f, -1.867854e-003f,
    -2.082229e-003f, -2.296697e-003f, -2.511206e-003f, -2.725272e-003f, -2.938945e-003f, -3.151963e-003f,
    -3.364068e-003f, -3.575356e-003f, -3.785537e-003f, -3.996126e-003f, -4.205662e-003f, -4.413863e-003f,
    -4.620833e-003f, -4.828086e-003f, -5.034579e-003f, -5.239381e-003f, -5.442322e-003f, -5.644325e-003f,
    -5.846386e-003f, -6.048032e-003f, -6.249134e-003f, -6.448037e-003f, -6.646043e-003f, -6.841923e-003f,
    -7.036523e-003f, -7.230505e-003f, -7.423379e-003f, -7.614369e-003f, -7.804266e-003f, -7.992173e-003f,
    -8.178170e-003f, -8.364124e-003f, -8.549087e-003f, -8.733346e-003f, -8.918920e-003f, -9.103168e-003f,
    -9.287606e-003f, -9.472283e-003f, -9.655203e-003f, -9.837420e-003f, -1.001970e-002f, -1.020096e-002f,
    -1.038267e-002f, -1.056340e-002f, -1.074229e-002f, -1.091976e-002f, -1.109704e-002f, -1.127340e-002f,
    -1.144945e-002f, -1.162365e-002f, -1.179651e-002f, -1.196920e-002f, -1.214148e-002f, -1.231243e-002f,
    -1.248266e-002f, -1.265180e-002f, -1.281936e-002f, -1.298695e-002f, -1.315444e-002f, -1.332086e-002f,
    -1.348694e-002f, -1.365192e-002f, -1.381604e-002f, -1.398117e-002f, -1.414626e-002f, -1.431091e-002f,
    -1.447517e-002f, -1.463846e-002f, -1.480160e-002f, -1.496485e-002f, -1.512775e-002f, -1.528922e-002f,
    -1.544980e-002f, -1.560926e-002f, -1.576820e-002f, -1.592641e-002f, -1.608491e-002f, -1.624321e-002f,
    -1.640017e-002f, -1.655687e-002f, -1.671230e-002f, -1.686651e-002f, -1.702076e-002f, -1.717454e-002f,
    -1.732689e-002f, -1.747800e-002f, -1.762782e-002f, -1.777712e-002f, -1.792688e-002f, -1.807691e-002f,
    -1.822576e-002f, -1.837435e-002f, -1.852222e-002f, -1.866919e-002f, -1.881573e-002f, -1.896344e-002f,
    -1.911117e-002f, -1.925852e-002f, -1.940528e-002f, -1.955111e-002f, -1.969716e-002f, -1.984384e-002f,
    -1.999016e-002f, -2.013557e-002f, -2.028047e-002f, -2.042520e-002f, -2.057056e-002f, -2.071559e-002f,
    -2.085892e-002f, -2.100088e-002f, -2.114227e-002f, -2.128283e-002f, -2.142158e-002f, -2.155918e-002f,
    -2.169606e-002f, -2.183246e-002f, -2.196871e-002f, -2.210460e-002f, -2.223865e-002f, -2.237185e-002f,
    -2.250417e-002f, -2.263552e-002f, -2.276588e-002f, -2.289492e-002f, -2.302223e-002f, -2.314923e-002f,
    -2.327584e-002f, -2.340239e-002f, -2.352801e-002f, -2.365306e-002f, -2.377671e-002f, -2.389804e-002f,
    -2.401916e-002f, -2.413960e-002f, -2.425943e-002f, -2.437922e-002f, -2.449893e-002f, -2.461832e-002f,
    -2.473598e-002f, -2.485238e-002f, -2.496896e-002f, -2.508484e-002f, -2.520058e-002f, -2.531536e-002f,
    -2.542905e-002f, -2.554121e-002f, -2.565210e-002f, -2.576196e-002f, -2.586960e-002f, -2.597567e-002f,
    -2.608072e-002f, -2.618498e-002f, -2.628824e-002f, -2.639022e-002f, -2.648999e-002f, -2.658812e-002f,
    -2.668522e-002f, -2.678123e-002f, -2.687642e-002f, -2.696982e-002f, -2.706123e-002f, -2.715124e-002f,
    -2.724066e-002f, -2.732941e-002f, -2.741711e-002f, -2.750363e-002f, -2.758979e-002f, -2.767590e-002f,
    -2.776181e-002f, -2.784758e-002f, -2.793144e-002f, -2.801439e-002f, -2.809756e-002f, -2.818080e-002f,
    -2.826359e-002f, -2.834509e-002f, -2.842487e-002f, -2.850355e-002f, -2.858192e-002f, -2.866000e-002f,
    -2.873745e-002f, -2.881340e-002f, -2.888830e-002f, -2.896095e-002f, -2.903270e-002f, -2.910387e-002f,
    -2.917398e-002f, -2.924238e-002f, -2.930963e-002f, -2.937588e-002f, -2.944073e-002f, -2.950452e-002f,
    -2.956450e-002f, -2.962310e-002f, -2.968106e-002f, -2.973823e-002f, -2.979351e-002f, -2.984713e-002f,
    -2.989988e-002f, -2.995041e-002f, -3.000066e-002f, -3.005056e-002f, -3.010012e-002f, -3.014840e-002f,
    -3.019567e-002f, -3.024223e-002f, -3.028617e-002f, -3.032814e-002f, -3.036954e-002f, -3.041102e-002f,
    -3.045222e-002f, -3.049327e-002f, -3.053466e-002f, -3.057574e-002f, -3.061549e-002f, -3.065404e-002f,
    -3.069146e-002f, -3.072746e-002f, -3.076229e-002f, -3.079727e-002f, -3.083157e-002f, -3.086484e-002f,
    -3.089665e-002f, -3.092718e-002f, -3.095631e-002f, -3.098415e-002f, -3.101104e-002f, -3.103658e-002f,
    -3.106086e-002f, -3.108326e-002f, -3.110436e-002f, -3.112487e-002f, -3.114376e-002f, -3.116162e-002f,
    -3.117918e-002f, -3.119660e-002f, -3.121399e-002f, -3.123114e-002f, -3.124711e-002f, -3.126241e-002f,
    -3.127668e-002f, -3.129050e-002f, -3.130314e-002f, -3.131486e-002f, -3.132576e-002f, -3.133567e-002f,
    -3.134454e-002f, -3.135222e-002f, -3.135904e-002f, -3.136564e-002f, -3.137218e-002f, -3.137862e-002f,
    -3.138390e-002f, -3.138817e-002f, -3.139153e-002f, -3.139400e-002f, -3.139580e-002f, -3.139690e-002f,
    -3.139783e-002f, -3.139858e-002f, -3.139891e-002f, -3.139831e-002f, -3.139585e-002f, -3.139237e-002f,
    -3.138806e-002f, -3.138327e-002f, -3.137886e-002f, -3.137495e-002f, -3.137116e-002f, -3.136708e-002f,
    -3.136174e-002f, -3.135583e-002f, -3.135000e-002f, -3.134365e-002f, -3.133670e-002f, -3.133094e-002f,
    -3.132526e-002f, -3.131825e-002f, -3.130912e-002f, -3.129914e-002f, -3.128862e-002f, -3.127698e-002f,
    -3.126509e-002f, -3.125428e-002f, -3.124434e-002f, -3.123373e-002f, -3.122201e-002f, -3.120911e-002f,
    -3.119552e-002f, -3.118113e-002f, -3.116580e-002f, -3.114961e-002f, -3.113421e-002f, -3.111750e-002f,
    -3.110020e-002f, -3.108284e-002f, -3.106499e-002f, -3.104645e-002f, -3.102719e-002f, -3.100783e-002f,
    -3.098805e-002f, -3.096867e-002f, -3.094856e-002f, -3.092767e-002f, -3.090604e-002f, -3.088390e-002f,
    -3.086107e-002f, -3.083835e-002f, -3.081606e-002f, -3.079334e-002f, -3.076981e-002f, -3.074538e-002f,
    -3.071995e-002f, -3.069313e-002f, -3.066548e-002f, -3.063684e-002f, -3.060647e-002f, -3.057544e-002f,
    -3.054392e-002f, -3.051034e-002f, -3.047645e-002f, -3.044176e-002f, -3.040569e-002f, -3.036833e-002f,
    -3.032999e-002f, -3.029101e-002f, -3.025124e-002f, -3.021057e-002f, -3.016863e-002f, -3.012580e-002f,
    -3.008211e-002f, -3.003763e-002f, -2.999231e-002f, -2.994693e-002f, -2.990135e-002f, -2.985585e-002f,
    -2.980960e-002f, -2.976303e-002f, -2.971655e-002f, -2.966943e-002f, -2.962093e-002f, -2.957121e-002f,
    -2.952121e-002f, -2.947046e-002f, -2.941903e-002f, -2.936703e-002f, -2.931414e-002f, -2.926076e-002f,
    -2.920690e-002f, -2.915168e-002f, -2.909498e-002f, -2.903775e-002f, -2.897961e-002f, -2.892032e-002f,
    -2.886049e-002f, -2.879999e-002f, -2.873869e-002f, -2.867589e-002f, -2.861158e-002f, -2.854613e-002f,
    -2.847926e-002f, -2.841161e-002f, -2.834415e-002f, -2.827651e-002f, -2.820831e-002f, -2.813997e-002f,
    -2.807145e-002f, -2.800227e-002f, -2.793237e-002f, -2.786218e-002f, -2.779120e-002f, -2.771971e-002f,
    -2.764775e-002f, -2.757554e-002f, -2.750195e-002f, -2.742777e-002f, -2.735320e-002f, -2.727702e-002f,
    -2.719959e-002f, -2.712069e-002f, -2.704102e-002f, -2.695988e-002f, -2.687810e-002f, -2.679571e-002f,
    -2.671273e-002f, -2.662901e-002f, -2.654375e-002f, -2.645708e-002f, -2.636810e-002f, -2.627746e-002f,
    -2.618469e-002f, -2.609053e-002f, -2.599556e-002f, -2.589976e-002f, -2.580349e-002f, -2.570639e-002f,
    -2.560821e-002f, -2.550845e-002f, -2.540844e-002f, -2.530785e-002f, -2.520559e-002f, -2.510217e-002f,
    -2.499837e-002f, -2.489339e-002f, -2.478844e-002f, -2.468330e-002f, -2.457710e-002f, -2.446992e-002f,
    -2.436192e-002f, -2.425277e-002f, -2.414230e-002f, -2.403049e-002f, -2.391828e-002f, -2.380561e-002f,
    -2.369251e-002f, -2.357840e-002f, -2.346281e-002f, -2.334630e-002f, -2.322889e-002f, -2.310974e-002f,
    -2.298976e-002f, -2.286840e-002f, -2.274575e-002f, -2.262220e-002f, -2.249813e-002f, -2.237310e-002f,
    -2.224729e-002f, -2.212094e-002f, -2.199337e-002f, -2.186401e-002f, -2.173349e-002f, -2.160165e-002f,
    -2.146829e-002f, -2.133448e-002f, -2.119999e-002f, -2.106507e-002f, -2.092976e-002f, -2.079391e-002f,
    -2.065639e-002f, -2.051733e-002f, -2.037726e-002f, -2.023626e-002f, -2.009377e-002f, -1.995007e-002f,
    -1.980568e-002f, -1.966048e-002f, -1.951412e-002f, -1.936651e-002f, -1.921762e-002f, -1.906792e-002f,
    -1.891756e-002f, -1.876641e-002f, -1.861296e-002f, -1.845867e-002f, -1.830355e-002f, -1.814728e-002f,
    -1.799036e-002f, -1.783077e-002f, -1.767085e-002f, -1.751058e-002f, -1.734999e-002f, -1.718899e-002f,
    -1.702579e-002f, -1.686109e-002f, -1.669571e-002f, -1.652990e-002f, -1.636388e-002f, -1.619736e-002f,
    -1.603026e-002f, -1.586195e-002f, -1.569253e-002f, -1.552149e-002f, -1.534850e-002f, -1.517396e-002f,
    -1.499892e-002f, -1.482333e-002f, -1.464706e-002f, -1.446959e-002f, -1.429032e-002f, -1.410958e-002f,
    -1.392775e-002f, -1.374517e-002f, -1.356104e-002f, -1.337471e-002f, -1.318766e-002f, -1.299876e-002f,
    -1.280845e-002f, -1.261703e-002f, -1.242486e-002f, -1.223155e-002f, -1.203656e-002f, -1.184078e-002f,
    -1.164411e-002f, -1.144457e-002f, -1.124374e-002f, -1.104176e-002f, -1.083946e-002f, -1.063695e-002f,
    -1.043423e-002f, -1.023041e-002f, -1.002511e-002f, -9.819270e-003f, -9.612281e-003f, -9.401320e-003f,
    -9.189639e-003f, -8.978009e-003f, -8.766439e-003f, -8.554695e-003f, -8.342656e-003f, -8.130345e-003f,
    -7.916270e-003f, -7.699817e-003f, -7.482708e-003f, -7.262805e-003f, -7.040255e-003f, -6.817261e-003f,
    -6.593612e-003f, -6.368892e-003f, -6.143592e-003f, -5.916395e-003f, -5.688754e-003f, -5.459543e-003f,
    -5.228324e-003f, -4.994517e-003f, -4.757789e-003f, -4.520199e-003f, -4.281770e-003f, -4.040579e-003f,
    -3.798196e-003f, -3.554220e-003f, -3.309345e-003f, -3.064056e-003f, -2.817498e-003f, -2.566793e-003f,
    -2.312722e-003f, -2.057098e-003f, -1.799981e-003f, -1.542788e-003f, -1.285585e-003f, -1.028354e-003f,
    -7.711852e-004f, -5.140255e-004f, -2.569877e-004f, -7.472155e-018f};

const float h4[1024] = {
    0.000000e+000f,  -3.686752e-002f, -4.707916e-002f, -5.424298e-002f, -5.974686e-002f, -6.421704e-002f,
    -6.809730e-002f, -7.150207e-002f, -7.456737e-002f, -7.735639e-002f, -7.991997e-002f, -8.227440e-002f,
    -8.439895e-002f, -8.625641e-002f, -8.779916e-002f, -8.904610e-002f, -9.001451e-002f, -9.072532e-002f,
    -9.124275e-002f, -9.158673e-002f, -9.182539e-002f, -9.200225e-002f, -9.208038e-002f, -9.210195e-002f,
    -9.201929e-002f, -9.184150e-002f, -9.158301e-002f, -9.123810e-002f, -9.083478e-002f, -9.035514e-002f,
    -8.977864e-002f, -8.910458e-002f, -8.833068e-002f, -8.745202e-002f, -8.646511e-002f, -8.537988e-002f,
    -8.419200e-002f, -8.287240e-002f, -8.145336e-002f, -7.994302e-002f, -7.834295e-002f, -7.665127e-002f,
    -7.490048e-002f, -7.308915e-002f, -7.122782e-002f, -6.932175e-002f, -6.738629e-002f, -6.542944e-002f,
    -6.343609e-002f, -6.141668e-002f, -5.936762e-002f, -5.726929e-002f, -5.513005e-002f, -5.294581e-002f,
    -5.074574e-002f, -4.853045e-002f, -4.630711e-002f, -4.409634e-002f, -4.189540e-002f, -3.972582e-002f,
    -3.758626e-002f, -3.549378e-002f, -3.341818e-002f, -3.135686e-002f, -2.930771e-002f, -2.727640e-002f,
    -2.526127e-002f, -2.327324e-002f, -2.131527e-002f, -1.937966e-002f, -1.746311e-002f, -1.557883e-002f,
    -1.372572e-002f, -1.189704e-002f, -1.009320e-002f, -8.330456e-003f, -6.600937e-003f, -4.892731e-003f,
    -3.204983e-003f, -1.539323e-003f, 1.087786e-004f,  1.741523e-003f,  3.357796e-003f,  4.946539e-003f,
    6.526105e-003f,  8.087222e-003f,  9.623635e-003f,  1.114311e-002f,  1.263078e-002f,  1.409044e-002f,
    1.553051e-002f,  1.693758e-002f,  1.832100e-002f,  1.967297e-002f,  2.099259e-002f,  2.228373e-002f,
    2.354167e-002f,  2.476117e-002f,  2.593983e-002f,  2.709688e-002f,  2.822413e-002f,  2.932345e-002f,
    3.039570e-002f,  3.144278e-002f,  3.247026e-002f,  3.347581e-002f,  3.445661e-002f,  3.541730e-002f,
    3.635977e-002f,  3.728128e-002f,  3.817157e-002f,  3.903504e-002f,  3.988187e-002f,  4.070002e-002f,
    4.147968e-002f,  4.222756e-002f,  4.294408e-002f,  4.363506e-002f,  4.429347e-002f,  4.491849e-002f,
    4.550622e-002f,  4.606525e-002f,  4.659057e-002f,  4.708795e-002f,  4.755407e-002f,  4.798880e-002f,
    4.839570e-002f,  4.878390e-002f,  4.914796e-002f,  4.949170e-002f,  4.981731e-002f,  5.012803e-002f,
    5.041794e-002f,  5.068709e-002f,  5.093673e-002f,  5.117082e-002f,  5.139053e-002f,  5.160546e-002f,
    5.180635e-002f,  5.198778e-002f,  5.216079e-002f,  5.232146e-002f,  5.245521e-002f,  5.258058e-002f,
    5.268417e-002f,  5.277219e-002f,  5.284493e-002f,  5.289987e-002f,  5.294295e-002f,  5.295232e-002f,
    5.293886e-002f,  5.290820e-002f,  5.285789e-002f,  5.278694e-002f,  5.269092e-002f,  5.258416e-002f,
    5.245384e-002f,  5.230755e-002f,  5.215269e-002f,  5.197809e-002f,  5.179503e-002f,  5.160154e-002f,
    5.138270e-002f,  5.115835e-002f,  5.092048e-002f,  5.066528e-002f,  5.040347e-002f,  5.012365e-002f,
    4.983004e-002f,  4.953082e-002f,  4.922354e-002f,  4.890520e-002f,  4.855925e-002f,  4.820714e-002f,
    4.784969e-002f,  4.748517e-002f,  4.708991e-002f,  4.668237e-002f,  4.626548e-002f,  4.584670e-002f,
    4.539089e-002f,  4.493146e-002f,  4.446371e-002f,  4.396844e-002f,  4.345779e-002f,  4.294188e-002f,
    4.240077e-002f,  4.184042e-002f,  4.127357e-002f,  4.066929e-002f,  4.005822e-002f,  3.942501e-002f,
    3.876983e-002f,  3.809920e-002f,  3.740036e-002f,  3.669153e-002f,  3.595514e-002f,  3.521205e-002f,
    3.445416e-002f,  3.368468e-002f,  3.290001e-002f,  3.210693e-002f,  3.130610e-002f,  3.049788e-002f,
    2.969452e-002f,  2.888758e-002f,  2.808967e-002f,  2.729010e-002f,  2.650343e-002f,  2.571092e-002f,
    2.492943e-002f,  2.414864e-002f,  2.338439e-002f,  2.262252e-002f,  2.186761e-002f,  2.111868e-002f,
    2.037299e-002f,  1.963561e-002f,  1.889743e-002f,  1.817550e-002f,  1.745468e-002f,  1.673810e-002f,
    1.603273e-002f,  1.532968e-002f,  1.463230e-002f,  1.393855e-002f,  1.324819e-002f,  1.256748e-002f,
    1.189409e-002f,  1.121913e-002f,  1.055384e-002f,  9.891197e-003f,  9.226005e-003f,  8.570603e-003f,
    7.924821e-003f,  7.278813e-003f,  6.636009e-003f,  6.003245e-003f,  5.370034e-003f,  4.736873e-003f,
    4.114991e-003f,  3.497752e-003f,  2.884234e-003f,  2.272889e-003f,  1.669924e-003f,  1.068295e-003f,
    4.689074e-004f,  -1.273354e-004f, -7.135699e-004f, -1.299002e-003f, -1.884465e-003f, -2.465799e-003f,
    -3.035150e-003f, -3.602649e-003f, -4.165791e-003f, -4.726458e-003f, -5.272796e-003f, -5.815489e-003f,
    -6.352506e-003f, -6.881806e-003f, -7.399020e-003f, -7.909706e-003f, -8.412922e-003f, -8.907683e-003f,
    -9.398501e-003f, -9.875158e-003f, -1.034606e-002f, -1.081212e-002f, -1.127346e-002f, -1.172512e-002f,
    -1.216630e-002f, -1.260043e-002f, -1.302984e-002f, -1.345338e-002f, -1.386666e-002f, -1.427369e-002f,
    -1.467342e-002f, -1.506746e-002f, -1.545470e-002f, -1.583157e-002f, -1.620119e-002f, -1.656596e-002f,
    -1.692563e-002f, -1.728027e-002f, -1.762665e-002f, -1.796578e-002f, -1.829915e-002f, -1.862659e-002f,
    -1.894976e-002f, -1.926897e-002f, -1.958175e-002f, -1.989009e-002f, -2.019472e-002f, -2.049394e-002f,
    -2.078876e-002f, -2.107657e-002f, -2.136162e-002f, -2.164384e-002f, -2.192293e-002f, -2.219727e-002f,
    -2.246562e-002f, -2.273129e-002f, -2.299395e-002f, -2.325271e-002f, -2.351119e-002f, -2.376432e-002f,
    -2.401186e-002f, -2.425936e-002f, -2.450587e-002f, -2.475234e-002f, -2.500292e-002f, -2.524975e-002f,
    -2.549221e-002f, -2.573377e-002f, -2.597303e-002f, -2.620966e-002f, -2.644458e-002f, -2.667915e-002f,
    -2.691132e-002f, -2.714220e-002f, -2.736910e-002f, -2.759550e-002f, -2.782144e-002f, -2.804273e-002f,
    -2.826174e-002f, -2.848028e-002f, -2.869335e-002f, -2.890189e-002f, -2.910718e-002f, -2.930464e-002f,
    -2.949511e-002f, -2.968108e-002f, -2.986668e-002f, -3.004672e-002f, -3.022181e-002f, -3.039373e-002f,
    -3.056167e-002f, -3.072471e-002f, -3.088472e-002f, -3.104097e-002f, -3.119396e-002f, -3.134184e-002f,
    -3.148208e-002f, -3.161625e-002f, -3.174617e-002f, -3.187219e-002f, -3.199329e-002f, -3.210708e-002f,
    -3.221758e-002f, -3.232474e-002f, -3.242694e-002f, -3.252236e-002f, -3.261333e-002f, -3.269782e-002f,
    -3.277689e-002f, -3.284772e-002f, -3.291825e-002f, -3.298548e-002f, -3.304762e-002f, -3.310467e-002f,
    -3.315795e-002f, -3.320481e-002f, -3.323905e-002f, -3.327168e-002f, -3.330400e-002f, -3.333563e-002f,
    -3.336245e-002f, -3.338772e-002f, -3.341355e-002f, -3.343043e-002f, -3.344169e-002f, -3.344942e-002f,
    -3.345532e-002f, -3.345876e-002f, -3.346031e-002f, -3.346090e-002f, -3.345749e-002f, -3.344829e-002f,
    -3.343847e-002f, -3.342726e-002f, -3.341415e-002f, -3.340012e-002f, -3.338378e-002f, -3.336691e-002f,
    -3.334871e-002f, -3.333131e-002f, -3.330978e-002f, -3.328701e-002f, -3.326246e-002f, -3.323938e-002f,
    -3.321396e-002f, -3.318061e-002f, -3.314734e-002f, -3.311349e-002f, -3.308041e-002f, -3.304688e-002f,
    -3.301147e-002f, -3.297355e-002f, -3.293685e-002f, -3.289329e-002f, -3.284876e-002f, -3.280400e-002f,
    -3.276137e-002f, -3.271631e-002f, -3.266975e-002f, -3.262341e-002f, -3.257818e-002f, -3.253365e-002f,
    -3.248434e-002f, -3.243188e-002f, -3.237650e-002f, -3.232121e-002f, -3.226633e-002f, -3.220718e-002f,
    -3.214571e-002f, -3.208198e-002f, -3.201791e-002f, -3.195090e-002f, -3.187977e-002f, -3.180300e-002f,
    -3.172280e-002f, -3.164116e-002f, -3.155572e-002f, -3.146735e-002f, -3.137357e-002f, -3.127847e-002f,
    -3.118422e-002f, -3.108368e-002f, -3.097873e-002f, -3.087175e-002f, -3.076270e-002f, -3.065118e-002f,
    -3.053370e-002f, -3.041047e-002f, -3.028623e-002f, -3.016156e-002f, -3.003651e-002f, -2.990797e-002f,
    -2.977988e-002f, -2.965398e-002f, -2.952611e-002f, -2.939309e-002f, -2.925492e-002f, -2.911300e-002f,
    -2.897271e-002f, -2.883175e-002f, -2.868896e-002f, -2.854478e-002f, -2.839884e-002f, -2.825371e-002f,
    -2.810742e-002f, -2.796095e-002f, -2.781175e-002f, -2.765748e-002f, -2.750248e-002f, -2.734364e-002f,
    -2.718256e-002f, -2.701869e-002f, -2.685742e-002f, -2.669690e-002f, -2.653339e-002f, -2.637057e-002f,
    -2.620674e-002f, -2.603931e-002f, -2.586909e-002f, -2.569720e-002f, -2.552496e-002f, -2.534904e-002f,
    -2.517170e-002f, -2.499340e-002f, -2.481836e-002f, -2.464383e-002f, -2.446611e-002f, -2.428726e-002f,
    -2.410204e-002f, -2.391778e-002f, -2.373298e-002f, -2.354938e-002f, -2.336368e-002f, -2.317681e-002f,
    -2.298983e-002f, -2.280452e-002f, -2.262086e-002f, -2.243574e-002f, -2.224932e-002f, -2.206124e-002f,
    -2.187361e-002f, -2.168629e-002f, -2.149628e-002f, -2.130444e-002f, -2.111423e-002f, -2.092539e-002f,
    -2.073661e-002f, -2.054704e-002f, -2.035571e-002f, -2.016589e-002f, -1.997657e-002f, -1.978525e-002f,
    -1.959239e-002f, -1.939691e-002f, -1.920034e-002f, -1.900579e-002f, -1.881134e-002f, -1.861693e-002f,
    -1.842240e-002f, -1.822638e-002f, -1.803051e-002f, -1.783656e-002f, -1.764623e-002f, -1.745772e-002f,
    -1.726663e-002f, -1.707309e-002f, -1.687929e-002f, -1.668741e-002f, -1.649485e-002f, -1.630447e-002f,
    -1.611337e-002f, -1.592193e-002f, -1.572956e-002f, -1.553841e-002f, -1.534620e-002f, -1.515653e-002f,
    -1.496662e-002f, -1.477267e-002f, -1.457842e-002f, -1.438401e-002f, -1.418770e-002f, -1.399272e-002f,
    -1.379496e-002f, -1.359669e-002f, -1.340046e-002f, -1.320370e-002f, -1.300539e-002f, -1.280573e-002f,
    -1.260308e-002f, -1.239963e-002f, -1.219630e-002f, -1.198908e-002f, -1.177731e-002f, -1.156688e-002f,
    -1.135609e-002f, -1.114344e-002f, -1.092908e-002f, -1.071463e-002f, -1.049985e-002f, -1.028499e-002f,
    -1.006678e-002f, -9.845976e-003f, -9.624370e-003f, -9.401041e-003f, -9.175400e-003f, -8.950493e-003f,
    -8.722643e-003f, -8.491283e-003f, -8.259034e-003f, -8.025257e-003f, -7.789180e-003f, -7.551850e-003f,
    -7.311113e-003f, -7.066043e-003f, -6.818615e-003f, -6.570490e-003f, -6.322606e-003f, -6.072834e-003f,
    -5.820865e-003f, -5.565984e-003f, -5.309028e-003f, -5.051837e-003f, -4.791712e-003f, -4.528116e-003f,
    -4.262771e-003f, -3.996271e-003f, -3.728189e-003f, -3.461617e-003f, -3.195312e-003f, -2.928175e-003f,
    -2.661061e-003f, -2.393332e-003f, -2.125493e-003f, -1.858081e-003f, -1.590996e-003f, -1.324668e-003f,
    -1.058363e-003f, -7.913172e-004f, -5.221920e-004f, -2.510189e-004f, 2.140818e-005f,  2.928121e-004f,
    5.630597e-004f,  8.352630e-004f,  1.108931e-003f,  1.383521e-003f,  1.657981e-003f,  1.932709e-003f,
    2.207605e-003f,  2.482357e-003f,  2.758673e-003f,  3.037314e-003f,  3.311569e-003f,  3.585463e-003f,
    3.857855e-003f,  4.131148e-003f,  4.404711e-003f,  4.682437e-003f,  4.962140e-003f,  5.241502e-003f,
    5.520677e-003f,  5.798921e-003f,  6.076529e-003f,  6.355233e-003f,  6.630229e-003f,  6.896276e-003f,
    7.160813e-003f,  7.423036e-003f,  7.683619e-003f,  7.942773e-003f,  8.200177e-003f,  8.456512e-003f,
    8.710720e-003f,  8.964936e-003f,  9.218669e-003f,  9.469419e-003f,  9.718448e-003f,  9.967114e-003f,
    1.021657e-002f,  1.046084e-002f,  1.069793e-002f,  1.093269e-002f,  1.116588e-002f,  1.139857e-002f,
    1.163240e-002f,  1.186718e-002f,  1.210047e-002f,  1.233178e-002f,  1.256112e-002f,  1.278869e-002f,
    1.301435e-002f,  1.324011e-002f,  1.346778e-002f,  1.369427e-002f,  1.391720e-002f,  1.413625e-002f,
    1.435342e-002f,  1.457140e-002f,  1.478901e-002f,  1.500581e-002f,  1.521804e-002f,  1.542812e-002f,
    1.563485e-002f,  1.583790e-002f,  1.603386e-002f,  1.622727e-002f,  1.642084e-002f,  1.661401e-002f,
    1.680573e-002f,  1.699682e-002f,  1.718835e-002f,  1.737690e-002f,  1.756313e-002f,  1.774984e-002f,
    1.793515e-002f,  1.811611e-002f,  1.829717e-002f,  1.847575e-002f,  1.865394e-002f,  1.883276e-002f,
    1.901329e-002f,  1.919362e-002f,  1.937381e-002f,  1.955299e-002f,  1.973262e-002f,  1.991024e-002f,
    2.007569e-002f,  2.023895e-002f,  2.040218e-002f,  2.056510e-002f,  2.072457e-002f,  2.088419e-002f,
    2.104356e-002f,  2.119746e-002f,  2.135005e-002f,  2.150264e-002f,  2.165576e-002f,  2.180790e-002f,
    2.195855e-002f,  2.210787e-002f,  2.224657e-002f,  2.237759e-002f,  2.250815e-002f,  2.263985e-002f,
    2.277238e-002f,  2.290370e-002f,  2.303282e-002f,  2.315917e-002f,  2.328280e-002f,  2.340484e-002f,
    2.352691e-002f,  2.364822e-002f,  2.376566e-002f,  2.388233e-002f,  2.399686e-002f,  2.410843e-002f,
    2.421724e-002f,  2.432245e-002f,  2.442169e-002f,  2.451867e-002f,  2.461635e-002f,  2.471437e-002f,
    2.480897e-002f,  2.490082e-002f,  2.499110e-002f,  2.508133e-002f,  2.517542e-002f,  2.527088e-002f,
    2.536616e-002f,  2.546041e-002f,  2.555259e-002f,  2.564398e-002f,  2.573504e-002f,  2.582530e-002f,
    2.591610e-002f,  2.600670e-002f,  2.609049e-002f,  2.616960e-002f,  2.624690e-002f,  2.632224e-002f,
    2.639638e-002f,  2.646646e-002f,  2.653611e-002f,  2.660697e-002f,  2.667836e-002f,  2.674905e-002f,
    2.681822e-002f,  2.688619e-002f,  2.695308e-002f,  2.701991e-002f,  2.708692e-002f,  2.715228e-002f,
    2.721881e-002f,  2.728731e-002f,  2.735443e-002f,  2.741990e-002f,  2.748351e-002f,  2.754559e-002f,
    2.760754e-002f,  2.766992e-002f,  2.773132e-002f,  2.778697e-002f,  2.784087e-002f,  2.789418e-002f,
    2.794661e-002f,  2.799862e-002f,  2.805053e-002f,  2.810131e-002f,  2.815085e-002f,  2.820139e-002f,
    2.824903e-002f,  2.829519e-002f,  2.833650e-002f,  2.837695e-002f,  2.841817e-002f,  2.846024e-002f,
    2.850330e-002f,  2.854653e-002f,  2.858834e-002f,  2.862776e-002f,  2.866714e-002f,  2.870822e-002f,
    2.874992e-002f,  2.879280e-002f,  2.883658e-002f,  2.887837e-002f,  2.891985e-002f,  2.896213e-002f,
    2.900452e-002f,  2.904645e-002f,  2.908751e-002f,  2.912664e-002f,  2.916125e-002f,  2.919489e-002f,
    2.922734e-002f,  2.925837e-002f,  2.928688e-002f,  2.931367e-002f,  2.933987e-002f,  2.936466e-002f,
    2.938917e-002f,  2.941494e-002f,  2.943962e-002f,  2.946136e-002f,  2.948006e-002f,  2.949563e-002f,
    2.950960e-002f,  2.952191e-002f,  2.953362e-002f,  2.954413e-002f,  2.955414e-002f,  2.956491e-002f,
    2.957439e-002f,  2.957989e-002f,  2.958568e-002f,  2.959031e-002f,  2.959346e-002f,  2.959619e-002f,
    2.960041e-002f,  2.960541e-002f,  2.961041e-002f,  2.961507e-002f,  2.962047e-002f,  2.962507e-002f,
    2.962887e-002f,  2.963091e-002f,  2.963218e-002f,  2.963440e-002f,  2.963310e-002f,  2.963052e-002f,
    2.962576e-002f,  2.961695e-002f,  2.960482e-002f,  2.959002e-002f,  2.957304e-002f,  2.955240e-002f,
    2.953086e-002f,  2.950836e-002f,  2.948497e-002f,  2.946018e-002f,  2.943453e-002f,  2.940795e-002f,
    2.938030e-002f,  2.935177e-002f,  2.932053e-002f,  2.928996e-002f,  2.926032e-002f,  2.923058e-002f,
    2.920033e-002f,  2.916999e-002f,  2.913908e-002f,  2.910708e-002f,  2.907456e-002f,  2.904135e-002f,
    2.900909e-002f,  2.897787e-002f,  2.894670e-002f,  2.891464e-002f,  2.888131e-002f,  2.884690e-002f,
    2.881171e-002f,  2.877515e-002f,  2.873658e-002f,  2.869810e-002f,  2.865913e-002f,  2.861727e-002f,
    2.857394e-002f,  2.852956e-002f,  2.848188e-002f,  2.843185e-002f,  2.838120e-002f,  2.832874e-002f,
    2.827399e-002f,  2.821993e-002f,  2.816489e-002f,  2.810958e-002f,  2.805411e-002f,  2.800055e-002f,
    2.794712e-002f,  2.789330e-002f,  2.783867e-002f,  2.778228e-002f,  2.772642e-002f,  2.767076e-002f,
    2.761538e-002f,  2.755842e-002f,  2.750172e-002f,  2.744443e-002f,  2.738648e-002f,  2.732786e-002f,
    2.726752e-002f,  2.720471e-002f,  2.714402e-002f,  2.708276e-002f,  2.701978e-002f,  2.695388e-002f,
    2.688552e-002f,  2.681497e-002f,  2.674168e-002f,  2.666553e-002f,  2.658529e-002f,  2.650240e-002f,
    2.641919e-002f,  2.633420e-002f,  2.624774e-002f,  2.615760e-002f,  2.606572e-002f,  2.597198e-002f,
    2.587634e-002f,  2.577769e-002f,  2.567703e-002f,  2.557585e-002f,  2.547455e-002f,  2.537420e-002f,
    2.527359e-002f,  2.517095e-002f,  2.506483e-002f,  2.495609e-002f,  2.484646e-002f,  2.473641e-002f,
    2.462477e-002f,  2.451235e-002f,  2.439961e-002f,  2.428628e-002f,  2.417314e-002f,  2.405808e-002f,
    2.394161e-002f,  2.382471e-002f,  2.370691e-002f,  2.358810e-002f,  2.346806e-002f,  2.334681e-002f,
    2.322358e-002f,  2.309854e-002f,  2.297210e-002f,  2.284372e-002f,  2.271237e-002f,  2.258113e-002f,
    2.244906e-002f,  2.231511e-002f,  2.218007e-002f,  2.204387e-002f,  2.190615e-002f,  2.176667e-002f,
    2.162626e-002f,  2.148471e-002f,  2.133846e-002f,  2.119118e-002f,  2.104237e-002f,  2.089317e-002f,
    2.074246e-002f,  2.058801e-002f,  2.043430e-002f,  2.027965e-002f,  2.012410e-002f,  1.996752e-002f,
    1.980653e-002f,  1.964417e-002f,  1.947994e-002f,  1.931414e-002f,  1.914714e-002f,  1.897797e-002f,
    1.880728e-002f,  1.863435e-002f,  1.845874e-002f,  1.828167e-002f,  1.809997e-002f,  1.791451e-002f,
    1.772691e-002f,  1.753726e-002f,  1.734495e-002f,  1.714788e-002f,  1.694687e-002f,  1.674338e-002f,
    1.653714e-002f,  1.632927e-002f,  1.611793e-002f,  1.590216e-002f,  1.568510e-002f,  1.546762e-002f,
    1.524848e-002f,  1.502823e-002f,  1.480667e-002f,  1.458427e-002f,  1.435927e-002f,  1.413336e-002f,
    1.390664e-002f,  1.367515e-002f,  1.344395e-002f,  1.321234e-002f,  1.298018e-002f,  1.274746e-002f,
    1.251421e-002f,  1.228035e-002f,  1.204704e-002f,  1.181207e-002f,  1.157563e-002f,  1.133152e-002f,
    1.108539e-002f,  1.083813e-002f,  1.058951e-002f,  1.033983e-002f,  1.008932e-002f,  9.837875e-003f,
    9.583791e-003f,  9.327003e-003f,  9.068603e-003f,  8.805135e-003f,  8.541302e-003f,  8.276973e-003f,
    8.011151e-003f,  7.741779e-003f,  7.471056e-003f,  7.199198e-003f,  6.926701e-003f,  6.652117e-003f,
    6.372945e-003f,  6.090283e-003f,  5.804499e-003f,  5.518835e-003f,  5.233289e-003f,  4.946827e-003f,
    4.659788e-003f,  4.373713e-003f,  4.083638e-003f,  3.791420e-003f,  3.495903e-003f,  3.187555e-003f,
    2.873031e-003f,  2.557847e-003f,  2.241773e-003f,  1.924788e-003f,  1.606810e-003f,  1.287795e-003f,
    9.675759e-004f,  6.462152e-004f,  3.236570e-004f,  7.435108e-018f};

const float h5[1024] = {
    0.000000e+000f,  -6.469713e-002f, -7.828328e-002f, -8.686220e-002f, -9.211825e-002f, -9.558424e-002f,
    -9.846409e-002f, -1.007057e-001f, -1.024699e-001f, -1.037916e-001f, -1.047760e-001f, -1.054649e-001f,
    -1.057462e-001f, -1.056053e-001f, -1.049179e-001f, -1.037458e-001f, -1.021393e-001f, -1.002687e-001f,
    -9.822223e-002f, -9.594575e-002f, -9.350405e-002f, -9.096367e-002f, -8.826829e-002f, -8.553726e-002f,
    -8.273321e-002f, -7.986001e-002f, -7.690865e-002f, -7.387185e-002f, -7.074680e-002f, -6.755361e-002f,
    -6.429751e-002f, -6.099197e-002f, -5.764445e-002f, -5.425388e-002f, -5.085381e-002f, -4.744986e-002f,
    -4.403984e-002f, -4.058302e-002f, -3.713389e-002f, -3.370350e-002f, -3.029566e-002f, -2.686463e-002f,
    -2.344809e-002f, -2.008649e-002f, -1.671963e-002f, -1.337802e-002f, -1.010702e-002f, -6.864855e-003f,
    -3.672138e-003f, -5.307672e-004f, 2.589418e-003f,  5.674849e-003f,  8.695555e-003f,  1.171779e-002f,
    1.464808e-002f,  1.752246e-002f,  2.036470e-002f,  2.309187e-002f,  2.575660e-002f,  2.832696e-002f,
    3.079189e-002f,  3.314843e-002f,  3.544774e-002f,  3.764760e-002f,  3.976008e-002f,  4.179727e-002f,
    4.374745e-002f,  4.559640e-002f,  4.735952e-002f,  4.903644e-002f,  5.060058e-002f,  5.208287e-002f,
    5.348482e-002f,  5.480818e-002f,  5.602395e-002f,  5.716275e-002f,  5.821523e-002f,  5.920252e-002f,
    6.010275e-002f,  6.094844e-002f,  6.173664e-002f,  6.243826e-002f,  6.308983e-002f,  6.368032e-002f,
    6.421476e-002f,  6.469794e-002f,  6.511787e-002f,  6.548597e-002f,  6.576099e-002f,  6.598615e-002f,
    6.614675e-002f,  6.624009e-002f,  6.624674e-002f,  6.618259e-002f,  6.602643e-002f,  6.579915e-002f,
    6.550360e-002f,  6.512106e-002f,  6.463925e-002f,  6.409128e-002f,  6.346120e-002f,  6.275858e-002f,
    6.201425e-002f,  6.120558e-002f,  6.035688e-002f,  5.946349e-002f,  5.851048e-002f,  5.750876e-002f,
    5.646295e-002f,  5.539168e-002f,  5.424992e-002f,  5.308774e-002f,  5.189343e-002f,  5.066878e-002f,
    4.939702e-002f,  4.810207e-002f,  4.677344e-002f,  4.542653e-002f,  4.406433e-002f,  4.265098e-002f,
    4.122814e-002f,  3.978345e-002f,  3.831821e-002f,  3.683513e-002f,  3.531468e-002f,  3.378772e-002f,
    3.224818e-002f,  3.070666e-002f,  2.914897e-002f,  2.758195e-002f,  2.601353e-002f,  2.445871e-002f,
    2.290973e-002f,  2.136340e-002f,  1.982237e-002f,  1.829095e-002f,  1.677156e-002f,  1.525633e-002f,
    1.376226e-002f,  1.226910e-002f,  1.078235e-002f,  9.318496e-003f,  7.867929e-003f,  6.432017e-003f,
    5.003915e-003f,  3.604318e-003f,  2.223420e-003f,  8.547227e-004f,  -4.877055e-004f, -1.807694e-003f,
    -3.107970e-003f, -4.385532e-003f, -5.638788e-003f, -6.866865e-003f, -8.074734e-003f, -9.267347e-003f,
    -1.042628e-002f, -1.155523e-002f, -1.266292e-002f, -1.374568e-002f, -1.480350e-002f, -1.582305e-002f,
    -1.681563e-002f, -1.776001e-002f, -1.868603e-002f, -1.958011e-002f, -2.043513e-002f, -2.125504e-002f,
    -2.205138e-002f, -2.282605e-002f, -2.356869e-002f, -2.428369e-002f, -2.496682e-002f, -2.561731e-002f,
    -2.624393e-002f, -2.684944e-002f, -2.742411e-002f, -2.797223e-002f, -2.849773e-002f, -2.900693e-002f,
    -2.948752e-002f, -2.994816e-002f, -3.038768e-002f, -3.081011e-002f, -3.121545e-002f, -3.160541e-002f,
    -3.197178e-002f, -3.232573e-002f, -3.266658e-002f, -3.298497e-002f, -3.328772e-002f, -3.357785e-002f,
    -3.385232e-002f, -3.411056e-002f, -3.434806e-002f, -3.457410e-002f, -3.478713e-002f, -3.498274e-002f,
    -3.515363e-002f, -3.531586e-002f, -3.546732e-002f, -3.561505e-002f, -3.574698e-002f, -3.587096e-002f,
    -3.596673e-002f, -3.606402e-002f, -3.614986e-002f, -3.623441e-002f, -3.630137e-002f, -3.636224e-002f,
    -3.642192e-002f, -3.646557e-002f, -3.650864e-002f, -3.652658e-002f, -3.654059e-002f, -3.653371e-002f,
    -3.651568e-002f, -3.650123e-002f, -3.647878e-002f, -3.645327e-002f, -3.641473e-002f, -3.637458e-002f,
    -3.633287e-002f, -3.628509e-002f, -3.623413e-002f, -3.617405e-002f, -3.609516e-002f, -3.601382e-002f,
    -3.592722e-002f, -3.584515e-002f, -3.576005e-002f, -3.566187e-002f, -3.555786e-002f, -3.543635e-002f,
    -3.532140e-002f, -3.520260e-002f, -3.506985e-002f, -3.493287e-002f, -3.477655e-002f, -3.460915e-002f,
    -3.445059e-002f, -3.428397e-002f, -3.410934e-002f, -3.392135e-002f, -3.371533e-002f, -3.350538e-002f,
    -3.330485e-002f, -3.308700e-002f, -3.286704e-002f, -3.263976e-002f, -3.240353e-002f, -3.215252e-002f,
    -3.190454e-002f, -3.165636e-002f, -3.140870e-002f, -3.114935e-002f, -3.088873e-002f, -3.062491e-002f,
    -3.035330e-002f, -3.008189e-002f, -2.980032e-002f, -2.950477e-002f, -2.920876e-002f, -2.890041e-002f,
    -2.857632e-002f, -2.825969e-002f, -2.793609e-002f, -2.761030e-002f, -2.728419e-002f, -2.694444e-002f,
    -2.659894e-002f, -2.625316e-002f, -2.590819e-002f, -2.555708e-002f, -2.519867e-002f, -2.482573e-002f,
    -2.444520e-002f, -2.405853e-002f, -2.366800e-002f, -2.327730e-002f, -2.289013e-002f, -2.249635e-002f,
    -2.209150e-002f, -2.167495e-002f, -2.125765e-002f, -2.083612e-002f, -2.041710e-002f, -2.000520e-002f,
    -1.959938e-002f, -1.919129e-002f, -1.877985e-002f, -1.835896e-002f, -1.793262e-002f, -1.751796e-002f,
    -1.711021e-002f, -1.671708e-002f, -1.633344e-002f, -1.594612e-002f, -1.554789e-002f, -1.514211e-002f,
    -1.473306e-002f, -1.433118e-002f, -1.393662e-002f, -1.355774e-002f, -1.317637e-002f, -1.279617e-002f,
    -1.241989e-002f, -1.203777e-002f, -1.164872e-002f, -1.125977e-002f, -1.087416e-002f, -1.050511e-002f,
    -1.014183e-002f, -9.779162e-003f, -9.419219e-003f, -9.068369e-003f, -8.724870e-003f, -8.378705e-003f,
    -8.025508e-003f, -7.678557e-003f, -7.342223e-003f, -7.004579e-003f, -6.672211e-003f, -6.340469e-003f,
    -6.006833e-003f, -5.667340e-003f, -5.336685e-003f, -5.008936e-003f, -4.681159e-003f, -4.362073e-003f,
    -4.048104e-003f, -3.733661e-003f, -3.409438e-003f, -3.093370e-003f, -2.775665e-003f, -2.451900e-003f,
    -2.122110e-003f, -1.808526e-003f, -1.494753e-003f, -1.172514e-003f, -8.560255e-004f, -5.530390e-004f,
    -2.482669e-004f, 6.327031e-005f,  3.705023e-004f,  6.780779e-004f,  9.896990e-004f,  1.303300e-003f,
    1.608933e-003f,  1.903439e-003f,  2.192033e-003f,  2.478485e-003f,  2.758963e-003f,  3.041980e-003f,
    3.327492e-003f,  3.612473e-003f,  3.893617e-003f,  4.170845e-003f,  4.443882e-003f,  4.714857e-003f,
    4.977444e-003f,  5.232276e-003f,  5.473099e-003f,  5.719741e-003f,  5.960384e-003f,  6.197108e-003f,
    6.425966e-003f,  6.652598e-003f,  6.876645e-003f,  7.096168e-003f,  7.316715e-003f,  7.532865e-003f,
    7.745077e-003f,  7.954218e-003f,  8.159821e-003f,  8.371581e-003f,  8.576753e-003f,  8.777826e-003f,
    8.972151e-003f,  9.174652e-003f,  9.376912e-003f,  9.576662e-003f,  9.775730e-003f,  9.973411e-003f,
    1.016606e-002f,  1.035288e-002f,  1.053215e-002f,  1.071271e-002f,  1.089768e-002f,  1.107173e-002f,
    1.123799e-002f,  1.141147e-002f,  1.159198e-002f,  1.177428e-002f,  1.195221e-002f,  1.212903e-002f,
    1.231008e-002f,  1.249142e-002f,  1.266480e-002f,  1.283348e-002f,  1.299771e-002f,  1.316520e-002f,
    1.332222e-002f,  1.347624e-002f,  1.363001e-002f,  1.378710e-002f,  1.393893e-002f,  1.409555e-002f,
    1.425783e-002f,  1.442263e-002f,  1.458512e-002f,  1.474156e-002f,  1.489157e-002f,  1.503672e-002f,
    1.517820e-002f,  1.531295e-002f,  1.544401e-002f,  1.557124e-002f,  1.570071e-002f,  1.582456e-002f,
    1.594279e-002f,  1.606681e-002f,  1.619073e-002f,  1.631032e-002f,  1.642245e-002f,  1.652711e-002f,
    1.663151e-002f,  1.673808e-002f,  1.684839e-002f,  1.694630e-002f,  1.704264e-002f,  1.714222e-002f,
    1.724219e-002f,  1.734485e-002f,  1.744845e-002f,  1.755396e-002f,  1.765652e-002f,  1.775528e-002f,
    1.785925e-002f,  1.796461e-002f,  1.807811e-002f,  1.819162e-002f,  1.830988e-002f,  1.843336e-002f,
    1.855691e-002f,  1.868156e-002f,  1.879863e-002f,  1.891709e-002f,  1.903567e-002f,  1.915606e-002f,
    1.927826e-002f,  1.940671e-002f,  1.953632e-002f,  1.966803e-002f,  1.980208e-002f,  1.993816e-002f,
    2.007503e-002f,  2.021599e-002f,  2.036183e-002f,  2.050835e-002f,  2.064794e-002f,  2.079284e-002f,
    2.093873e-002f,  2.108389e-002f,  2.121629e-002f,  2.134323e-002f,  2.147300e-002f,  2.160443e-002f,
    2.173438e-002f,  2.186495e-002f,  2.199561e-002f,  2.212724e-002f,  2.225363e-002f,  2.237569e-002f,
    2.249110e-002f,  2.260387e-002f,  2.271555e-002f,  2.282435e-002f,  2.293389e-002f,  2.303817e-002f,
    2.313783e-002f,  2.323866e-002f,  2.334169e-002f,  2.344180e-002f,  2.353482e-002f,  2.362114e-002f,
    2.370497e-002f,  2.378883e-002f,  2.387323e-002f,  2.395422e-002f,  2.403218e-002f,  2.410758e-002f,
    2.417310e-002f,  2.423806e-002f,  2.429789e-002f,  2.435348e-002f,  2.440469e-002f,  2.445107e-002f,
    2.449678e-002f,  2.454035e-002f,  2.457773e-002f,  2.460996e-002f,  2.463956e-002f,  2.466377e-002f,
    2.468411e-002f,  2.469747e-002f,  2.470441e-002f,  2.470438e-002f,  2.470047e-002f,  2.468993e-002f,
    2.467398e-002f,  2.466152e-002f,  2.464754e-002f,  2.463338e-002f,  2.462103e-002f,  2.461048e-002f,
    2.460505e-002f,  2.460307e-002f,  2.460096e-002f,  2.460043e-002f,  2.460160e-002f,  2.460665e-002f,
    2.461550e-002f,  2.462380e-002f,  2.463099e-002f,  2.463669e-002f,  2.464766e-002f,  2.465821e-002f,
    2.466327e-002f,  2.466966e-002f,  2.467323e-002f,  2.467568e-002f,  2.467941e-002f,  2.468133e-002f,
    2.468430e-002f,  2.468566e-002f,  2.468287e-002f,  2.468217e-002f,  2.468345e-002f,  2.468323e-002f,
    2.467766e-002f,  2.466956e-002f,  2.466029e-002f,  2.465382e-002f,  2.464682e-002f,  2.463666e-002f,
    2.462295e-002f,  2.460483e-002f,  2.458508e-002f,  2.456382e-002f,  2.454258e-002f,  2.452160e-002f,
    2.449445e-002f,  2.446215e-002f,  2.442702e-002f,  2.438685e-002f,  2.434432e-002f,  2.429725e-002f,
    2.424789e-002f,  2.419664e-002f,  2.414239e-002f,  2.408240e-002f,  2.402071e-002f,  2.395808e-002f,
    2.388684e-002f,  2.381085e-002f,  2.373556e-002f,  2.365988e-002f,  2.358518e-002f,  2.351202e-002f,
    2.343433e-002f,  2.335242e-002f,  2.326923e-002f,  2.318460e-002f,  2.310367e-002f,  2.302928e-002f,
    2.295453e-002f,  2.287819e-002f,  2.279826e-002f,  2.271765e-002f,  2.263280e-002f,  2.254679e-002f,
    2.245907e-002f,  2.236747e-002f,  2.227408e-002f,  2.217659e-002f,  2.207895e-002f,  2.197686e-002f,
    2.186393e-002f,  2.174706e-002f,  2.162682e-002f,  2.150253e-002f,  2.137813e-002f,  2.124852e-002f,
    2.111178e-002f,  2.097042e-002f,  2.082634e-002f,  2.067989e-002f,  2.052427e-002f,  2.036544e-002f,
    2.020594e-002f,  2.004695e-002f,  1.988641e-002f,  1.972133e-002f,  1.955308e-002f,  1.938313e-002f,
    1.920888e-002f,  1.903272e-002f,  1.885401e-002f,  1.867309e-002f,  1.848854e-002f,  1.829809e-002f,
    1.810801e-002f,  1.791995e-002f,  1.773515e-002f,  1.754897e-002f,  1.736490e-002f,  1.718336e-002f,
    1.700188e-002f,  1.681903e-002f,  1.663972e-002f,  1.646311e-002f,  1.629235e-002f,  1.612415e-002f,
    1.595575e-002f,  1.578185e-002f,  1.560191e-002f,  1.542351e-002f,  1.524853e-002f,  1.507342e-002f,
    1.490000e-002f,  1.472524e-002f,  1.454808e-002f,  1.436873e-002f,  1.418834e-002f,  1.400464e-002f,
    1.382014e-002f,  1.363393e-002f,  1.344717e-002f,  1.325962e-002f,  1.306770e-002f,  1.287641e-002f,
    1.268371e-002f,  1.248988e-002f,  1.229512e-002f,  1.209297e-002f,  1.188538e-002f,  1.168147e-002f,
    1.147991e-002f,  1.127749e-002f,  1.107289e-002f,  1.086519e-002f,  1.065663e-002f,  1.044708e-002f,
    1.023466e-002f,  1.001842e-002f,  9.797728e-003f,  9.575952e-003f,  9.353547e-003f,  9.130139e-003f,
    8.906888e-003f,  8.680285e-003f,  8.448413e-003f,  8.210929e-003f,  7.970192e-003f,  7.728476e-003f,
    7.485796e-003f,  7.241040e-003f,  6.994088e-003f,  6.743012e-003f,  6.486717e-003f,  6.228414e-003f,
    5.965036e-003f,  5.703174e-003f,  5.440872e-003f,  5.178946e-003f,  4.915254e-003f,  4.649898e-003f,
    4.385245e-003f,  4.119458e-003f,  3.855736e-003f,  3.593426e-003f,  3.331036e-003f,  3.070594e-003f,
    2.810871e-003f,  2.551814e-003f,  2.294389e-003f,  2.038227e-003f,  1.784816e-003f,  1.536631e-003f,
    1.290172e-003f,  1.044451e-003f,  8.014830e-004f,  5.612823e-004f,  3.223942e-004f,  8.606447e-005f,
    -1.492419e-004f, -3.836474e-004f, -6.161727e-004f, -8.459682e-004f, -1.072967e-003f, -1.297765e-003f,
    -1.521848e-003f, -1.744353e-003f, -1.967006e-003f, -2.189597e-003f, -2.412024e-003f, -2.634081e-003f,
    -2.860468e-003f, -3.088981e-003f, -3.318789e-003f, -3.549015e-003f, -3.781653e-003f, -4.016864e-003f,
    -4.253058e-003f, -4.490186e-003f, -4.729270e-003f, -4.970168e-003f, -5.211515e-003f, -5.453856e-003f,
    -5.702097e-003f, -5.950879e-003f, -6.198840e-003f, -6.446401e-003f, -6.696393e-003f, -6.948213e-003f,
    -7.203690e-003f, -7.461122e-003f, -7.718444e-003f, -7.974375e-003f, -8.228753e-003f, -8.480625e-003f,
    -8.735986e-003f, -8.991849e-003f, -9.247726e-003f, -9.505388e-003f, -9.764156e-003f, -1.002380e-002f,
    -1.028405e-002f, -1.054084e-002f, -1.079839e-002f, -1.105724e-002f, -1.131689e-002f, -1.157669e-002f,
    -1.183838e-002f, -1.210115e-002f, -1.236222e-002f, -1.262037e-002f, -1.288148e-002f, -1.314344e-002f,
    -1.340458e-002f, -1.366718e-002f, -1.393092e-002f, -1.419661e-002f, -1.446416e-002f, -1.472882e-002f,
    -1.499741e-002f, -1.527085e-002f, -1.554702e-002f, -1.582706e-002f, -1.610954e-002f, -1.639179e-002f,
    -1.667363e-002f, -1.695181e-002f, -1.722961e-002f, -1.751060e-002f, -1.779443e-002f, -1.807916e-002f,
    -1.836610e-002f, -1.865573e-002f, -1.895005e-002f, -1.924631e-002f, -1.953794e-002f, -1.982801e-002f,
    -2.011786e-002f, -2.040675e-002f, -2.069546e-002f, -2.098438e-002f, -2.127256e-002f, -2.155927e-002f,
    -2.184541e-002f, -2.213186e-002f, -2.241507e-002f, -2.269731e-002f, -2.297683e-002f, -2.325343e-002f,
    -2.352645e-002f, -2.379552e-002f, -2.406015e-002f, -2.432153e-002f, -2.458049e-002f, -2.483710e-002f,
    -2.509053e-002f, -2.534055e-002f, -2.558961e-002f, -2.583631e-002f, -2.608061e-002f, -2.632558e-002f,
    -2.656768e-002f, -2.680694e-002f, -2.704260e-002f, -2.727655e-002f, -2.750937e-002f, -2.774004e-002f,
    -2.797067e-002f, -2.820135e-002f, -2.843305e-002f, -2.866541e-002f, -2.889548e-002f, -2.912432e-002f,
    -2.935349e-002f, -2.958233e-002f, -2.981045e-002f, -3.003581e-002f, -3.025792e-002f, -3.047710e-002f,
    -3.069430e-002f, -3.090894e-002f, -3.112030e-002f, -3.132802e-002f, -3.152953e-002f, -3.172998e-002f,
    -3.192716e-002f, -3.212286e-002f, -3.231720e-002f, -3.250905e-002f, -3.269861e-002f, -3.288566e-002f,
    -3.307003e-002f, -3.325347e-002f, -3.343313e-002f, -3.361087e-002f, -3.378396e-002f, -3.395387e-002f,
    -3.412284e-002f, -3.429113e-002f, -3.445767e-002f, -3.462374e-002f, -3.479154e-002f, -3.495918e-002f,
    -3.512264e-002f, -3.528609e-002f, -3.544544e-002f, -3.560309e-002f, -3.575832e-002f, -3.591354e-002f,
    -3.606808e-002f, -3.622087e-002f, -3.637071e-002f, -3.651832e-002f, -3.665980e-002f, -3.679747e-002f,
    -3.693382e-002f, -3.706887e-002f, -3.720216e-002f, -3.733594e-002f, -3.747021e-002f, -3.760209e-002f,
    -3.773188e-002f, -3.786154e-002f, -3.798599e-002f, -3.810754e-002f, -3.822909e-002f, -3.835180e-002f,
    -3.847460e-002f, -3.859646e-002f, -3.871935e-002f, -3.884211e-002f, -3.896610e-002f, -3.909227e-002f,
    -3.921192e-002f, -3.932457e-002f, -3.943722e-002f, -3.955001e-002f, -3.966218e-002f, -3.977233e-002f,
    -3.988096e-002f, -3.998759e-002f, -4.009208e-002f, -4.019456e-002f, -4.029081e-002f, -4.037704e-002f,
    -4.045696e-002f, -4.052301e-002f, -4.058132e-002f, -4.063269e-002f, -4.067976e-002f, -4.072108e-002f,
    -4.075773e-002f, -4.079054e-002f, -4.081888e-002f, -4.083108e-002f, -4.083847e-002f, -4.084045e-002f,
    -4.083695e-002f, -4.082632e-002f, -4.080907e-002f, -4.078653e-002f, -4.075970e-002f, -4.073380e-002f,
    -4.070558e-002f, -4.066605e-002f, -4.062168e-002f, -4.057635e-002f, -4.053042e-002f, -4.048439e-002f,
    -4.043798e-002f, -4.038752e-002f, -4.033951e-002f, -4.029268e-002f, -4.024423e-002f, -4.018799e-002f,
    -4.012350e-002f, -4.005710e-002f, -3.998893e-002f, -3.991869e-002f, -3.984632e-002f, -3.977418e-002f,
    -3.970271e-002f, -3.962869e-002f, -3.955072e-002f, -3.946492e-002f, -3.936503e-002f, -3.926086e-002f,
    -3.915602e-002f, -3.904906e-002f, -3.894186e-002f, -3.883076e-002f, -3.871626e-002f, -3.860040e-002f,
    -3.848227e-002f, -3.835984e-002f, -3.821386e-002f, -3.806576e-002f, -3.791635e-002f, -3.776568e-002f,
    -3.761430e-002f, -3.745988e-002f, -3.730235e-002f, -3.714267e-002f, -3.698171e-002f, -3.681943e-002f,
    -3.663804e-002f, -3.645160e-002f, -3.626004e-002f, -3.606420e-002f, -3.586515e-002f, -3.566253e-002f,
    -3.545444e-002f, -3.524196e-002f, -3.502434e-002f, -3.479720e-002f, -3.454854e-002f, -3.428425e-002f,
    -3.401370e-002f, -3.373672e-002f, -3.345306e-002f, -3.315869e-002f, -3.285711e-002f, -3.254918e-002f,
    -3.223500e-002f, -3.191521e-002f, -3.158003e-002f, -3.122345e-002f, -3.086254e-002f, -3.049347e-002f,
    -3.012136e-002f, -2.974533e-002f, -2.936611e-002f, -2.898553e-002f, -2.859750e-002f, -2.820706e-002f,
    -2.781376e-002f, -2.739560e-002f, -2.697754e-002f, -2.656104e-002f, -2.614437e-002f, -2.572719e-002f,
    -2.530948e-002f, -2.488978e-002f, -2.446722e-002f, -2.404288e-002f, -2.361898e-002f, -2.315664e-002f,
    -2.268684e-002f, -2.221551e-002f, -2.174211e-002f, -2.126660e-002f, -2.078944e-002f, -2.031042e-002f,
    -1.983102e-002f, -1.934786e-002f, -1.886225e-002f, -1.834936e-002f, -1.782041e-002f, -1.728978e-002f,
    -1.675420e-002f, -1.620606e-002f, -1.565660e-002f, -1.510645e-002f, -1.455489e-002f, -1.400285e-002f,
    -1.344636e-002f, -1.287052e-002f, -1.227259e-002f, -1.167410e-002f, -1.107524e-002f, -1.047727e-002f,
    -9.877835e-003f, -9.273231e-003f, -8.655532e-003f, -8.031998e-003f, -7.408098e-003f, -6.768808e-003f,
    -6.094122e-003f, -5.420056e-003f, -4.746569e-003f, -4.072105e-003f, -3.396666e-003f, -2.720035e-003f,
    -2.041980e-003f, -1.362527e-003f, -6.818454e-004f, -8.441329e-018f};
}  // namespace
}  // namespace Core
}  // namespace VideoStitch

#endif
