#!/bin/bash -eu

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )/.." && pwd )"
GET_APP=false

if [[ $# == 1 ]] ; then
	APPS[0]=$1
	GET_APP=true
else
	APPS=("Studio" "VahanaVR" "Player" "StartMyOrah")
fi

if [ ! -d "${DIR}/src/include/" ] ; then
	mkdir ${DIR}/src/include/
fi

for APP in "${APPS[@]}"
do
	fileContent="// WARNING: Autogenerated, do not edit.\n"
	LOWERAPP=$(echo $APP | tr '[:upper:]' '[:lower:]')
	VERSION=`git describe --tags --match "${APP}-v?.*"`
	BRANCH=$(git rev-parse --abbrev-ref HEAD)
	#FIXME As soon as tags for each app will have been defined
	#This if block should be removed
	if [ -z $VERSION ]; then
		VERSION=$(git describe --tags --match v?.*)
		fileContent="$fileContent#define APPS_VIDEOSTITCH_VERSION \"${VERSION}-$BRANCH\"\n"
	else
		fileContent="$fileContent#define APPS_VIDEOSTITCH_VERSION \"${VERSION#*-}-$BRANCH\"\n"
	fi
	if [ ! -f "${DIR}/src/include/${LOWERAPP}Version.hpp" ] ; then
		echo -e $fileContent > "${DIR}/src/include/${LOWERAPP}Version.hpp"
	fi
done

if $GET_APP; then
	echo "${VERSION#*-}"
fi