// Copyright (c) 2012-2017 VideoStitch SAS
// Copyright (c) 2018 stitchEm

#ifndef ANDROIDAPPLICATION_H_
#define ANDROIDAPPLICATION_H_

#include <thread>
#include <mutex>
#include "NvAppBase/android/NvAndroidNativeAppGlue.h"
#include "NvEGLUtil/NvEGLUtil.h"

using namespace VideoStitch;

typedef NvEGLWinUtil NvEGLUtil;

typedef struct {
  double x;
  double y;
} vector2d;

class NativeApp {
 public:
  // Application state
  enum State { INITIALIZATION, SELECTION, MAIN_LOOP, EXIT };

  NativeApp(android_app *app, NvEGLUtil *egl);
  virtual ~NativeApp();
  void renderFrame(void);

  State getState(void) const;

 private:
  // Handle commands
  void handleCommand(int cmd);
  // Handle inputs
  int handleInput(AInputEvent const *event);

  // Wrapper to handle commands generated by the UI
  static void HandleCommand(android_app *app, int32_t cmd);
  // Wrapper to handle input events generated by the UI
  static int32_t HandleInput(android_app *app, AInputEvent *event);
  void launchStitcher(void *outBuffer, std::mutex &outMutex, const char *fileName);
  int stitchRun(VideoStitch::Core::Controller *controller, VideoStitch::Core::StitchOutput *stitchOutput,
                const int firstFrame, const int lastFrame);

  // Handler to plain texture fragment program
  GLint mPlainTextureProgram;
  // flag to notify screenPress
  bool mScreenPressed;
  // Handler to source texture
  //        GLuint mInputImageTexture;
  // Handler to output texture
  GLuint mOutputImageTexture;
  // width of input image
  int mTextureWidth;
  // height of input image
  int mTextureHeight;
  // Box Filter
  //        gpu_bf::BoxFilterDemo boxfilter;
  // Holds a point to EGL wrapper
  NvEGLUtil *mEgl;
  // Holds a pointer to android native activity instance
  android_app *mNativeAppInstance;
  // Holds application state
  State mCurrentApplicationState;
  // mStitcherBuffer for holding output from kernel
  unsigned int *mStitcherBuffer;
  std::mutex mStitcherMutex;
  std::thread *mStitcherThread;

  std::mutex mOrientationMutex;
  bool mOrientationFlag;
  double mYaw;
  double mPitch;
  double mRoll;
  float mColorChannels[3];
  float mAlphaStep;
  vector2d mPos;
};

#endif /* ANDROIDAPPLICATION_H_ */
