// Copyright (c) 2012-2017 VideoStitch SAS
// Copyright (c) 2018 stitchEm

#ifndef EMOR_INV_COEFS_HPP_
#define EMOR_INV_COEFS_HPP_

namespace VideoStitch {
namespace Core {
namespace {
/**
 * EMoR inverse coefficients, from:
 * http://www1.cs.columbia.edu/CAVE/software/dorf/response/invemor.txt
 */
const float fInv0[1024] = {
    0.000000e+000f, 1.477256e-003f, 2.737898e-003f, 3.858105e-003f, 4.877501e-003f, 5.819777e-003f, 6.700519e-003f,
    7.532015e-003f, 8.323902e-003f, 9.085110e-003f, 9.816742e-003f, 1.051719e-002f, 1.119348e-002f, 1.184927e-002f,
    1.248706e-002f, 1.310836e-002f, 1.371501e-002f, 1.430845e-002f, 1.488919e-002f, 1.545915e-002f, 1.601947e-002f,
    1.656868e-002f, 1.710786e-002f, 1.763954e-002f, 1.816409e-002f, 1.868202e-002f, 1.919384e-002f, 1.970013e-002f,
    2.020145e-002f, 2.069803e-002f, 2.119012e-002f, 2.167658e-002f, 2.215623e-002f, 2.263206e-002f, 2.310436e-002f,
    2.357320e-002f, 2.403910e-002f, 2.450196e-002f, 2.496192e-002f, 2.541903e-002f, 2.587329e-002f, 2.632477e-002f,
    2.677024e-002f, 2.721375e-002f, 2.765540e-002f, 2.809528e-002f, 2.853420e-002f, 2.897388e-002f, 2.941151e-002f,
    2.984418e-002f, 3.027385e-002f, 3.070138e-002f, 3.112383e-002f, 3.154393e-002f, 3.196235e-002f, 3.237907e-002f,
    3.279429e-002f, 3.320812e-002f, 3.362059e-002f, 3.403191e-002f, 3.444217e-002f, 3.485135e-002f, 3.525754e-002f,
    3.566134e-002f, 3.606424e-002f, 3.646630e-002f, 3.686738e-002f, 3.726786e-002f, 3.766775e-002f, 3.806709e-002f,
    3.846602e-002f, 3.886461e-002f, 3.926180e-002f, 3.965717e-002f, 4.005235e-002f, 4.044736e-002f, 4.084235e-002f,
    4.123742e-002f, 4.163233e-002f, 4.202693e-002f, 4.242082e-002f, 4.281423e-002f, 4.320657e-002f, 4.359637e-002f,
    4.398566e-002f, 4.437448e-002f, 4.476288e-002f, 4.515076e-002f, 4.553832e-002f, 4.592557e-002f, 4.631260e-002f,
    4.669941e-002f, 4.708620e-002f, 4.747111e-002f, 4.785581e-002f, 4.824055e-002f, 4.862516e-002f, 4.900963e-002f,
    4.939392e-002f, 4.977822e-002f, 5.016234e-002f, 5.054640e-002f, 5.093011e-002f, 5.131254e-002f, 5.169442e-002f,
    5.207628e-002f, 5.245792e-002f, 5.283941e-002f, 5.322091e-002f, 5.360254e-002f, 5.398451e-002f, 5.436656e-002f,
    5.474869e-002f, 5.513042e-002f, 5.551149e-002f, 5.589278e-002f, 5.627396e-002f, 5.665528e-002f, 5.703689e-002f,
    5.741860e-002f, 5.780036e-002f, 5.818207e-002f, 5.856357e-002f, 5.894459e-002f, 5.932454e-002f, 5.970394e-002f,
    6.008290e-002f, 6.046159e-002f, 6.084004e-002f, 6.121843e-002f, 6.159673e-002f, 6.197504e-002f, 6.235353e-002f,
    6.273225e-002f, 6.311054e-002f, 6.348897e-002f, 6.386763e-002f, 6.424637e-002f, 6.462534e-002f, 6.500475e-002f,
    6.538453e-002f, 6.576474e-002f, 6.614533e-002f, 6.652623e-002f, 6.690713e-002f, 6.728824e-002f, 6.766955e-002f,
    6.805103e-002f, 6.843249e-002f, 6.881406e-002f, 6.919566e-002f, 6.957729e-002f, 6.995908e-002f, 7.034095e-002f,
    7.072298e-002f, 7.110500e-002f, 7.148700e-002f, 7.186898e-002f, 7.225112e-002f, 7.263336e-002f, 7.301572e-002f,
    7.339807e-002f, 7.378068e-002f, 7.416369e-002f, 7.454717e-002f, 7.493111e-002f, 7.531555e-002f, 7.570061e-002f,
    7.608625e-002f, 7.647253e-002f, 7.685955e-002f, 7.724725e-002f, 7.763534e-002f, 7.802366e-002f, 7.841244e-002f,
    7.880214e-002f, 7.919242e-002f, 7.958317e-002f, 7.997455e-002f, 8.036661e-002f, 8.075916e-002f, 8.115193e-002f,
    8.154477e-002f, 8.193767e-002f, 8.233068e-002f, 8.272424e-002f, 8.311811e-002f, 8.351236e-002f, 8.390691e-002f,
    8.430197e-002f, 8.469743e-002f, 8.509340e-002f, 8.548978e-002f, 8.588655e-002f, 8.628385e-002f, 8.668222e-002f,
    8.708152e-002f, 8.748141e-002f, 8.788185e-002f, 8.828293e-002f, 8.868463e-002f, 8.908685e-002f, 8.948966e-002f,
    8.989305e-002f, 9.029707e-002f, 9.070218e-002f, 9.110851e-002f, 9.151570e-002f, 9.192383e-002f, 9.233269e-002f,
    9.274223e-002f, 9.315233e-002f, 9.356289e-002f, 9.397371e-002f, 9.438483e-002f, 9.479646e-002f, 9.520934e-002f,
    9.562284e-002f, 9.603692e-002f, 9.645145e-002f, 9.686642e-002f, 9.728162e-002f, 9.769687e-002f, 9.811201e-002f,
    9.852718e-002f, 9.894242e-002f, 9.935901e-002f, 9.977592e-002f, 1.001931e-001f, 1.006107e-001f, 1.010286e-001f,
    1.014468e-001f, 1.018654e-001f, 1.022844e-001f, 1.027037e-001f, 1.031234e-001f, 1.035442e-001f, 1.039658e-001f,
    1.043878e-001f, 1.048103e-001f, 1.052333e-001f, 1.056568e-001f, 1.060809e-001f, 1.065057e-001f, 1.069312e-001f,
    1.073576e-001f, 1.077852e-001f, 1.082145e-001f, 1.086448e-001f, 1.090759e-001f, 1.095079e-001f, 1.099403e-001f,
    1.103731e-001f, 1.108063e-001f, 1.112397e-001f, 1.116734e-001f, 1.121078e-001f, 1.125435e-001f, 1.129796e-001f,
    1.134162e-001f, 1.138531e-001f, 1.142904e-001f, 1.147279e-001f, 1.151657e-001f, 1.156038e-001f, 1.160423e-001f,
    1.164814e-001f, 1.169221e-001f, 1.173633e-001f, 1.178051e-001f, 1.182474e-001f, 1.186904e-001f, 1.191342e-001f,
    1.195789e-001f, 1.200245e-001f, 1.204710e-001f, 1.209185e-001f, 1.213680e-001f, 1.218186e-001f, 1.222701e-001f,
    1.227224e-001f, 1.231757e-001f, 1.236300e-001f, 1.240850e-001f, 1.245409e-001f, 1.249978e-001f, 1.254555e-001f,
    1.259149e-001f, 1.263757e-001f, 1.268369e-001f, 1.272983e-001f, 1.277599e-001f, 1.282217e-001f, 1.286837e-001f,
    1.291459e-001f, 1.296084e-001f, 1.300712e-001f, 1.305347e-001f, 1.309996e-001f, 1.314649e-001f, 1.319308e-001f,
    1.323972e-001f, 1.328641e-001f, 1.333315e-001f, 1.337996e-001f, 1.342682e-001f, 1.347375e-001f, 1.352075e-001f,
    1.356796e-001f, 1.361524e-001f, 1.366258e-001f, 1.371000e-001f, 1.375749e-001f, 1.380505e-001f, 1.385269e-001f,
    1.390042e-001f, 1.394824e-001f, 1.399612e-001f, 1.404423e-001f, 1.409239e-001f, 1.414060e-001f, 1.418886e-001f,
    1.423715e-001f, 1.428550e-001f, 1.433390e-001f, 1.438233e-001f, 1.443082e-001f, 1.447935e-001f, 1.452803e-001f,
    1.457679e-001f, 1.462556e-001f, 1.467435e-001f, 1.472318e-001f, 1.477203e-001f, 1.482094e-001f, 1.486990e-001f,
    1.491891e-001f, 1.496798e-001f, 1.501717e-001f, 1.506655e-001f, 1.511598e-001f, 1.516549e-001f, 1.521508e-001f,
    1.526477e-001f, 1.531454e-001f, 1.536440e-001f, 1.541436e-001f, 1.546444e-001f, 1.551465e-001f, 1.556510e-001f,
    1.561566e-001f, 1.566633e-001f, 1.571706e-001f, 1.576782e-001f, 1.581861e-001f, 1.586944e-001f, 1.592029e-001f,
    1.597115e-001f, 1.602205e-001f, 1.607314e-001f, 1.612429e-001f, 1.617547e-001f, 1.622672e-001f, 1.627801e-001f,
    1.632935e-001f, 1.638076e-001f, 1.643225e-001f, 1.648382e-001f, 1.653550e-001f, 1.658739e-001f, 1.663941e-001f,
    1.669153e-001f, 1.674375e-001f, 1.679605e-001f, 1.684844e-001f, 1.690095e-001f, 1.695355e-001f, 1.700624e-001f,
    1.705903e-001f, 1.711201e-001f, 1.716517e-001f, 1.721842e-001f, 1.727172e-001f, 1.732512e-001f, 1.737863e-001f,
    1.743220e-001f, 1.748586e-001f, 1.753961e-001f, 1.759341e-001f, 1.764733e-001f, 1.770141e-001f, 1.775553e-001f,
    1.780969e-001f, 1.786393e-001f, 1.791824e-001f, 1.797259e-001f, 1.802701e-001f, 1.808149e-001f, 1.813603e-001f,
    1.819062e-001f, 1.824543e-001f, 1.830029e-001f, 1.835522e-001f, 1.841021e-001f, 1.846526e-001f, 1.852037e-001f,
    1.857557e-001f, 1.863082e-001f, 1.868613e-001f, 1.874151e-001f, 1.879708e-001f, 1.885278e-001f, 1.890854e-001f,
    1.896436e-001f, 1.902028e-001f, 1.907630e-001f, 1.913239e-001f, 1.918856e-001f, 1.924481e-001f, 1.930113e-001f,
    1.935760e-001f, 1.941417e-001f, 1.947082e-001f, 1.952753e-001f, 1.958428e-001f, 1.964110e-001f, 1.969798e-001f,
    1.975490e-001f, 1.981188e-001f, 1.986891e-001f, 1.992606e-001f, 1.998335e-001f, 2.004069e-001f, 2.009809e-001f,
    2.015556e-001f, 2.021313e-001f, 2.027075e-001f, 2.032845e-001f, 2.038624e-001f, 2.044413e-001f, 2.050214e-001f,
    2.056038e-001f, 2.061875e-001f, 2.067723e-001f, 2.073581e-001f, 2.079446e-001f, 2.085321e-001f, 2.091204e-001f,
    2.097096e-001f, 2.103000e-001f, 2.108914e-001f, 2.114851e-001f, 2.120801e-001f, 2.126761e-001f, 2.132731e-001f,
    2.138707e-001f, 2.144686e-001f, 2.150669e-001f, 2.156660e-001f, 2.162658e-001f, 2.168663e-001f, 2.174684e-001f,
    2.180718e-001f, 2.186760e-001f, 2.192811e-001f, 2.198872e-001f, 2.204940e-001f, 2.211018e-001f, 2.217107e-001f,
    2.223205e-001f, 2.229314e-001f, 2.235436e-001f, 2.241575e-001f, 2.247723e-001f, 2.253881e-001f, 2.260048e-001f,
    2.266224e-001f, 2.272410e-001f, 2.278605e-001f, 2.284810e-001f, 2.291025e-001f, 2.297252e-001f, 2.303496e-001f,
    2.309750e-001f, 2.316014e-001f, 2.322288e-001f, 2.328571e-001f, 2.334866e-001f, 2.341173e-001f, 2.347496e-001f,
    2.353832e-001f, 2.360178e-001f, 2.366545e-001f, 2.372924e-001f, 2.379313e-001f, 2.385714e-001f, 2.392125e-001f,
    2.398548e-001f, 2.404980e-001f, 2.411424e-001f, 2.417877e-001f, 2.424340e-001f, 2.430818e-001f, 2.437308e-001f,
    2.443806e-001f, 2.450310e-001f, 2.456824e-001f, 2.463345e-001f, 2.469875e-001f, 2.476415e-001f, 2.482966e-001f,
    2.489524e-001f, 2.496098e-001f, 2.502687e-001f, 2.509285e-001f, 2.515894e-001f, 2.522517e-001f, 2.529152e-001f,
    2.535800e-001f, 2.542463e-001f, 2.549144e-001f, 2.555841e-001f, 2.562555e-001f, 2.569287e-001f, 2.576029e-001f,
    2.582783e-001f, 2.589545e-001f, 2.596323e-001f, 2.603114e-001f, 2.609921e-001f, 2.616743e-001f, 2.623580e-001f,
    2.630435e-001f, 2.637309e-001f, 2.644197e-001f, 2.651098e-001f, 2.658010e-001f, 2.664934e-001f, 2.671868e-001f,
    2.678814e-001f, 2.685770e-001f, 2.692738e-001f, 2.699717e-001f, 2.706715e-001f, 2.713726e-001f, 2.720750e-001f,
    2.727788e-001f, 2.734841e-001f, 2.741906e-001f, 2.748987e-001f, 2.756084e-001f, 2.763193e-001f, 2.770315e-001f,
    2.777453e-001f, 2.784602e-001f, 2.791761e-001f, 2.798931e-001f, 2.806108e-001f, 2.813291e-001f, 2.820484e-001f,
    2.827687e-001f, 2.834894e-001f, 2.842107e-001f, 2.849328e-001f, 2.856559e-001f, 2.863794e-001f, 2.871033e-001f,
    2.878280e-001f, 2.885538e-001f, 2.892806e-001f, 2.900085e-001f, 2.907377e-001f, 2.914678e-001f, 2.921990e-001f,
    2.929322e-001f, 2.936666e-001f, 2.944022e-001f, 2.951392e-001f, 2.958773e-001f, 2.966168e-001f, 2.973575e-001f,
    2.980994e-001f, 2.988425e-001f, 2.995872e-001f, 3.003341e-001f, 3.010828e-001f, 3.018327e-001f, 3.025843e-001f,
    3.033377e-001f, 3.040933e-001f, 3.048509e-001f, 3.056102e-001f, 3.063707e-001f, 3.071326e-001f, 3.078965e-001f,
    3.086619e-001f, 3.094288e-001f, 3.101971e-001f, 3.109667e-001f, 3.117377e-001f, 3.125102e-001f, 3.132843e-001f,
    3.140597e-001f, 3.148362e-001f, 3.156143e-001f, 3.163942e-001f, 3.171757e-001f, 3.179586e-001f, 3.187431e-001f,
    3.195291e-001f, 3.203168e-001f, 3.211061e-001f, 3.218967e-001f, 3.226890e-001f, 3.234832e-001f, 3.242806e-001f,
    3.250800e-001f, 3.258812e-001f, 3.266844e-001f, 3.274893e-001f, 3.282961e-001f, 3.291047e-001f, 3.299151e-001f,
    3.307276e-001f, 3.315426e-001f, 3.323615e-001f, 3.331823e-001f, 3.340052e-001f, 3.348296e-001f, 3.356559e-001f,
    3.364836e-001f, 3.373129e-001f, 3.381440e-001f, 3.389768e-001f, 3.398111e-001f, 3.406486e-001f, 3.414881e-001f,
    3.423288e-001f, 3.431714e-001f, 3.440159e-001f, 3.448618e-001f, 3.457091e-001f, 3.465585e-001f, 3.474094e-001f,
    3.482619e-001f, 3.491170e-001f, 3.499750e-001f, 3.508346e-001f, 3.516960e-001f, 3.525590e-001f, 3.534239e-001f,
    3.542906e-001f, 3.551589e-001f, 3.560288e-001f, 3.569002e-001f, 3.577739e-001f, 3.586511e-001f, 3.595298e-001f,
    3.604101e-001f, 3.612919e-001f, 3.621754e-001f, 3.630602e-001f, 3.639464e-001f, 3.648337e-001f, 3.657226e-001f,
    3.666130e-001f, 3.675079e-001f, 3.684047e-001f, 3.693031e-001f, 3.702028e-001f, 3.711038e-001f, 3.720055e-001f,
    3.729085e-001f, 3.738129e-001f, 3.747189e-001f, 3.756259e-001f, 3.765372e-001f, 3.774503e-001f, 3.783655e-001f,
    3.792823e-001f, 3.802004e-001f, 3.811199e-001f, 3.820413e-001f, 3.829644e-001f, 3.838895e-001f, 3.848165e-001f,
    3.857473e-001f, 3.866814e-001f, 3.876177e-001f, 3.885556e-001f, 3.894956e-001f, 3.904372e-001f, 3.913807e-001f,
    3.923261e-001f, 3.932734e-001f, 3.942231e-001f, 3.951765e-001f, 3.961346e-001f, 3.970947e-001f, 3.980568e-001f,
    3.990208e-001f, 3.999867e-001f, 4.009543e-001f, 4.019241e-001f, 4.028963e-001f, 4.038703e-001f, 4.048471e-001f,
    4.058301e-001f, 4.068154e-001f, 4.078022e-001f, 4.087909e-001f, 4.097813e-001f, 4.107738e-001f, 4.117686e-001f,
    4.127655e-001f, 4.137644e-001f, 4.147651e-001f, 4.157725e-001f, 4.167821e-001f, 4.177943e-001f, 4.188099e-001f,
    4.198286e-001f, 4.208502e-001f, 4.218751e-001f, 4.229033e-001f, 4.239342e-001f, 4.249681e-001f, 4.260087e-001f,
    4.270545e-001f, 4.281033e-001f, 4.291544e-001f, 4.302083e-001f, 4.312648e-001f, 4.323243e-001f, 4.333859e-001f,
    4.344498e-001f, 4.355162e-001f, 4.365869e-001f, 4.376633e-001f, 4.387419e-001f, 4.398226e-001f, 4.409054e-001f,
    4.419904e-001f, 4.430772e-001f, 4.441661e-001f, 4.452577e-001f, 4.463516e-001f, 4.474485e-001f, 4.485527e-001f,
    4.496586e-001f, 4.507668e-001f, 4.518776e-001f, 4.529909e-001f, 4.541065e-001f, 4.552241e-001f, 4.563439e-001f,
    4.574659e-001f, 4.585899e-001f, 4.597226e-001f, 4.608568e-001f, 4.619925e-001f, 4.631293e-001f, 4.642676e-001f,
    4.654081e-001f, 4.665511e-001f, 4.676967e-001f, 4.688444e-001f, 4.699939e-001f, 4.711507e-001f, 4.723117e-001f,
    4.734752e-001f, 4.746406e-001f, 4.758081e-001f, 4.769782e-001f, 4.781511e-001f, 4.793259e-001f, 4.805027e-001f,
    4.816828e-001f, 4.828697e-001f, 4.840633e-001f, 4.852592e-001f, 4.864575e-001f, 4.876592e-001f, 4.888639e-001f,
    4.900715e-001f, 4.912817e-001f, 4.924951e-001f, 4.937120e-001f, 4.949337e-001f, 4.961640e-001f, 4.973977e-001f,
    4.986341e-001f, 4.998730e-001f, 5.011138e-001f, 5.023570e-001f, 5.036028e-001f, 5.048504e-001f, 5.060995e-001f,
    5.073515e-001f, 5.086140e-001f, 5.098794e-001f, 5.111469e-001f, 5.124161e-001f, 5.136877e-001f, 5.149620e-001f,
    5.162395e-001f, 5.175194e-001f, 5.188013e-001f, 5.200862e-001f, 5.213809e-001f, 5.226801e-001f, 5.239816e-001f,
    5.252864e-001f, 5.265944e-001f, 5.279053e-001f, 5.292193e-001f, 5.305359e-001f, 5.318561e-001f, 5.331789e-001f,
    5.345105e-001f, 5.358494e-001f, 5.371919e-001f, 5.385380e-001f, 5.398877e-001f, 5.412416e-001f, 5.425985e-001f,
    5.439588e-001f, 5.453220e-001f, 5.466886e-001f, 5.480612e-001f, 5.494425e-001f, 5.508270e-001f, 5.522152e-001f,
    5.536064e-001f, 5.550010e-001f, 5.563989e-001f, 5.578012e-001f, 5.592064e-001f, 5.606141e-001f, 5.620263e-001f,
    5.634495e-001f, 5.648759e-001f, 5.663060e-001f, 5.677399e-001f, 5.691766e-001f, 5.706165e-001f, 5.720603e-001f,
    5.735081e-001f, 5.749596e-001f, 5.764154e-001f, 5.778844e-001f, 5.793581e-001f, 5.808358e-001f, 5.823175e-001f,
    5.838036e-001f, 5.852938e-001f, 5.867884e-001f, 5.882880e-001f, 5.897926e-001f, 5.913013e-001f, 5.928210e-001f,
    5.943471e-001f, 5.958764e-001f, 5.974098e-001f, 5.989470e-001f, 6.004887e-001f, 6.020334e-001f, 6.035817e-001f,
    6.051345e-001f, 6.066907e-001f, 6.082564e-001f, 6.098326e-001f, 6.114136e-001f, 6.129989e-001f, 6.145888e-001f,
    6.161829e-001f, 6.177816e-001f, 6.193858e-001f, 6.209950e-001f, 6.226082e-001f, 6.242284e-001f, 6.258622e-001f,
    6.275011e-001f, 6.291444e-001f, 6.307920e-001f, 6.324457e-001f, 6.341036e-001f, 6.357665e-001f, 6.374354e-001f,
    6.391098e-001f, 6.407888e-001f, 6.424865e-001f, 6.441900e-001f, 6.458998e-001f, 6.476140e-001f, 6.493339e-001f,
    6.510594e-001f, 6.527905e-001f, 6.545270e-001f, 6.562691e-001f, 6.580176e-001f, 6.597829e-001f, 6.615564e-001f,
    6.633360e-001f, 6.651216e-001f, 6.669126e-001f, 6.687086e-001f, 6.705112e-001f, 6.723208e-001f, 6.741380e-001f,
    6.759613e-001f, 6.777997e-001f, 6.796534e-001f, 6.815140e-001f, 6.833799e-001f, 6.852528e-001f, 6.871315e-001f,
    6.890163e-001f, 6.909087e-001f, 6.928068e-001f, 6.947108e-001f, 6.966290e-001f, 6.985671e-001f, 7.005132e-001f,
    7.024672e-001f, 7.044298e-001f, 7.063980e-001f, 7.083728e-001f, 7.103546e-001f, 7.123452e-001f, 7.143444e-001f,
    7.163524e-001f, 7.183896e-001f, 7.204359e-001f, 7.224905e-001f, 7.245525e-001f, 7.266246e-001f, 7.287066e-001f,
    7.307961e-001f, 7.328947e-001f, 7.350028e-001f, 7.371211e-001f, 7.392717e-001f, 7.414343e-001f, 7.436061e-001f,
    7.457885e-001f, 7.479840e-001f, 7.501906e-001f, 7.524064e-001f, 7.546306e-001f, 7.568639e-001f, 7.591079e-001f,
    7.613802e-001f, 7.636769e-001f, 7.659834e-001f, 7.683037e-001f, 7.706373e-001f, 7.729814e-001f, 7.753358e-001f,
    7.777012e-001f, 7.800781e-001f, 7.824678e-001f, 7.848826e-001f, 7.873337e-001f, 7.897965e-001f, 7.922734e-001f,
    7.947627e-001f, 7.972671e-001f, 7.997864e-001f, 8.023179e-001f, 8.048668e-001f, 8.074288e-001f, 8.100120e-001f,
    8.126469e-001f, 8.152965e-001f, 8.179622e-001f, 8.206483e-001f, 8.233516e-001f, 8.260734e-001f, 8.288131e-001f,
    8.315727e-001f, 8.343446e-001f, 8.371342e-001f, 8.399934e-001f, 8.428773e-001f, 8.457888e-001f, 8.487272e-001f,
    8.516942e-001f, 8.546887e-001f, 8.577007e-001f, 8.607361e-001f, 8.638108e-001f, 8.669571e-001f, 8.701564e-001f,
    8.734027e-001f, 8.766781e-001f, 8.799727e-001f, 8.832960e-001f, 8.866553e-001f, 8.900595e-001f, 8.935105e-001f,
    8.969939e-001f, 9.005120e-001f, 9.045323e-001f, 9.082241e-001f, 9.119395e-001f, 9.157112e-001f, 9.195482e-001f,
    9.234328e-001f, 9.273786e-001f, 9.314110e-001f, 9.355407e-001f, 9.397977e-001f, 9.450196e-001f, 9.509351e-001f,
    9.559072e-001f, 9.607881e-001f, 9.656764e-001f, 9.707481e-001f, 9.773920e-001f, 9.829417e-001f, 9.885159e-001f,
    9.941525e-001f, 1.000000e+000f};

const float hInv1[1024] = {
    0.000000e+000f,  -3.706679e-004f, -6.814894e-004f, -9.541366e-004f, -1.200249e-003f, -1.426712e-003f,
    -1.637806e-003f, -1.836267e-003f, -2.024306e-003f, -2.203649e-003f, -2.376028e-003f, -2.542911e-003f,
    -2.704507e-003f, -2.861239e-003f, -3.013712e-003f, -3.162217e-003f, -3.307209e-003f, -3.449026e-003f,
    -3.587871e-003f, -3.723937e-003f, -3.857590e-003f, -3.989245e-003f, -4.119038e-003f, -4.246882e-003f,
    -4.372804e-003f, -4.496979e-003f, -4.619460e-003f, -4.740346e-003f, -4.859837e-003f, -4.978036e-003f,
    -5.094972e-003f, -5.210795e-003f, -5.325719e-003f, -5.439404e-003f, -5.551922e-003f, -5.663349e-003f,
    -5.773777e-003f, -5.883208e-003f, -5.991623e-003f, -6.099054e-003f, -6.205496e-003f, -6.311011e-003f,
    -6.415960e-003f, -6.520054e-003f, -6.623255e-003f, -6.725578e-003f, -6.826867e-003f, -6.926829e-003f,
    -7.026117e-003f, -7.125291e-003f, -7.223958e-003f, -7.321931e-003f, -7.419616e-003f, -7.516768e-003f,
    -7.613367e-003f, -7.709394e-003f, -7.804855e-003f, -7.899793e-003f, -7.994219e-003f, -8.088160e-003f,
    -8.181627e-003f, -8.274628e-003f, -8.367352e-003f, -8.459712e-003f, -8.551646e-003f, -8.643177e-003f,
    -8.734306e-003f, -8.825122e-003f, -8.915633e-003f, -9.005845e-003f, -9.095798e-003f, -9.185478e-003f,
    -9.275059e-003f, -9.364625e-003f, -9.454052e-003f, -9.543292e-003f, -9.632467e-003f, -9.721534e-003f,
    -9.810445e-003f, -9.899013e-003f, -9.987071e-003f, -1.007457e-002f, -1.016154e-002f, -1.024815e-002f,
    -1.033421e-002f, -1.041978e-002f, -1.050487e-002f, -1.058952e-002f, -1.067369e-002f, -1.075741e-002f,
    -1.084071e-002f, -1.092361e-002f, -1.100617e-002f, -1.108853e-002f, -1.117067e-002f, -1.125255e-002f,
    -1.133419e-002f, -1.141559e-002f, -1.149677e-002f, -1.157775e-002f, -1.165856e-002f, -1.173920e-002f,
    -1.181969e-002f, -1.190009e-002f, -1.198039e-002f, -1.206064e-002f, -1.214071e-002f, -1.222067e-002f,
    -1.230052e-002f, -1.238033e-002f, -1.246016e-002f, -1.253995e-002f, -1.261963e-002f, -1.269928e-002f,
    -1.277886e-002f, -1.285834e-002f, -1.293768e-002f, -1.301696e-002f, -1.309619e-002f, -1.317537e-002f,
    -1.325442e-002f, -1.333328e-002f, -1.341188e-002f, -1.349014e-002f, -1.356790e-002f, -1.364519e-002f,
    -1.372204e-002f, -1.379850e-002f, -1.387464e-002f, -1.395054e-002f, -1.402616e-002f, -1.410158e-002f,
    -1.417690e-002f, -1.425209e-002f, -1.432713e-002f, -1.440206e-002f, -1.447688e-002f, -1.455162e-002f,
    -1.462635e-002f, -1.470105e-002f, -1.477576e-002f, -1.485047e-002f, -1.492514e-002f, -1.499979e-002f,
    -1.507431e-002f, -1.514875e-002f, -1.522309e-002f, -1.529729e-002f, -1.537128e-002f, -1.544510e-002f,
    -1.551872e-002f, -1.559211e-002f, -1.566534e-002f, -1.573837e-002f, -1.581116e-002f, -1.588368e-002f,
    -1.595599e-002f, -1.602805e-002f, -1.609989e-002f, -1.617154e-002f, -1.624302e-002f, -1.631431e-002f,
    -1.638549e-002f, -1.645658e-002f, -1.652758e-002f, -1.659843e-002f, -1.666931e-002f, -1.674024e-002f,
    -1.681128e-002f, -1.688244e-002f, -1.695371e-002f, -1.702501e-002f, -1.709624e-002f, -1.716739e-002f,
    -1.723849e-002f, -1.730947e-002f, -1.738051e-002f, -1.745163e-002f, -1.752283e-002f, -1.759406e-002f,
    -1.766524e-002f, -1.773627e-002f, -1.780703e-002f, -1.787745e-002f, -1.794756e-002f, -1.801728e-002f,
    -1.808679e-002f, -1.815616e-002f, -1.822537e-002f, -1.829451e-002f, -1.836356e-002f, -1.843253e-002f,
    -1.850141e-002f, -1.857021e-002f, -1.863898e-002f, -1.870764e-002f, -1.877626e-002f, -1.884488e-002f,
    -1.891349e-002f, -1.898213e-002f, -1.905077e-002f, -1.911940e-002f, -1.918802e-002f, -1.925665e-002f,
    -1.932529e-002f, -1.939390e-002f, -1.946250e-002f, -1.953126e-002f, -1.960022e-002f, -1.966929e-002f,
    -1.973839e-002f, -1.980742e-002f, -1.987635e-002f, -1.994515e-002f, -2.001378e-002f, -2.008226e-002f,
    -2.015051e-002f, -2.021878e-002f, -2.028705e-002f, -2.035529e-002f, -2.042343e-002f, -2.049135e-002f,
    -2.055896e-002f, -2.062620e-002f, -2.069308e-002f, -2.075966e-002f, -2.082588e-002f, -2.089190e-002f,
    -2.095780e-002f, -2.102356e-002f, -2.108920e-002f, -2.115471e-002f, -2.122013e-002f, -2.128543e-002f,
    -2.135060e-002f, -2.141563e-002f, -2.148041e-002f, -2.154502e-002f, -2.160958e-002f, -2.167410e-002f,
    -2.173858e-002f, -2.180305e-002f, -2.186752e-002f, -2.193206e-002f, -2.199664e-002f, -2.206132e-002f,
    -2.212600e-002f, -2.219079e-002f, -2.225584e-002f, -2.232107e-002f, -2.238638e-002f, -2.245158e-002f,
    -2.251668e-002f, -2.258156e-002f, -2.264624e-002f, -2.271071e-002f, -2.277493e-002f, -2.283878e-002f,
    -2.290247e-002f, -2.296599e-002f, -2.302931e-002f, -2.309241e-002f, -2.315521e-002f, -2.321774e-002f,
    -2.328006e-002f, -2.334218e-002f, -2.340415e-002f, -2.346577e-002f, -2.352728e-002f, -2.358872e-002f,
    -2.365008e-002f, -2.371140e-002f, -2.377271e-002f, -2.383406e-002f, -2.389548e-002f, -2.395701e-002f,
    -2.401868e-002f, -2.408025e-002f, -2.414183e-002f, -2.420345e-002f, -2.426509e-002f, -2.432674e-002f,
    -2.438843e-002f, -2.445014e-002f, -2.451192e-002f, -2.457374e-002f, -2.463560e-002f, -2.469736e-002f,
    -2.475893e-002f, -2.482029e-002f, -2.488130e-002f, -2.494192e-002f, -2.500218e-002f, -2.506217e-002f,
    -2.512190e-002f, -2.518141e-002f, -2.524069e-002f, -2.529971e-002f, -2.535839e-002f, -2.541694e-002f,
    -2.547538e-002f, -2.553373e-002f, -2.559201e-002f, -2.565024e-002f, -2.570845e-002f, -2.576659e-002f,
    -2.582471e-002f, -2.588276e-002f, -2.594057e-002f, -2.599835e-002f, -2.605615e-002f, -2.611396e-002f,
    -2.617183e-002f, -2.622978e-002f, -2.628788e-002f, -2.634617e-002f, -2.640463e-002f, -2.646321e-002f,
    -2.652163e-002f, -2.657998e-002f, -2.663823e-002f, -2.669640e-002f, -2.675448e-002f, -2.681251e-002f,
    -2.687051e-002f, -2.692845e-002f, -2.698636e-002f, -2.704422e-002f, -2.710181e-002f, -2.715913e-002f,
    -2.721620e-002f, -2.727303e-002f, -2.732961e-002f, -2.738607e-002f, -2.744239e-002f, -2.749860e-002f,
    -2.755473e-002f, -2.761084e-002f, -2.766681e-002f, -2.772261e-002f, -2.777842e-002f, -2.783429e-002f,
    -2.789024e-002f, -2.794629e-002f, -2.800244e-002f, -2.805873e-002f, -2.811521e-002f, -2.817192e-002f,
    -2.822882e-002f, -2.828570e-002f, -2.834280e-002f, -2.840004e-002f, -2.845724e-002f, -2.851419e-002f,
    -2.857078e-002f, -2.862705e-002f, -2.868299e-002f, -2.873860e-002f, -2.879393e-002f, -2.884878e-002f,
    -2.890338e-002f, -2.895779e-002f, -2.901203e-002f, -2.906603e-002f, -2.911989e-002f, -2.917366e-002f,
    -2.922736e-002f, -2.928097e-002f, -2.933450e-002f, -2.938782e-002f, -2.944102e-002f, -2.949424e-002f,
    -2.954742e-002f, -2.960054e-002f, -2.965366e-002f, -2.970681e-002f, -2.975995e-002f, -2.981312e-002f,
    -2.986630e-002f, -2.991938e-002f, -2.997238e-002f, -3.002534e-002f, -3.007822e-002f, -3.013107e-002f,
    -3.018389e-002f, -3.023667e-002f, -3.028943e-002f, -3.034215e-002f, -3.039476e-002f, -3.044718e-002f,
    -3.049926e-002f, -3.055110e-002f, -3.060276e-002f, -3.065431e-002f, -3.070576e-002f, -3.075712e-002f,
    -3.080840e-002f, -3.085961e-002f, -3.091070e-002f, -3.096169e-002f, -3.101243e-002f, -3.106309e-002f,
    -3.111367e-002f, -3.116420e-002f, -3.121469e-002f, -3.126514e-002f, -3.131556e-002f, -3.136598e-002f,
    -3.141643e-002f, -3.146690e-002f, -3.151726e-002f, -3.156767e-002f, -3.161813e-002f, -3.166863e-002f,
    -3.171924e-002f, -3.176988e-002f, -3.182052e-002f, -3.187118e-002f, -3.192187e-002f, -3.197253e-002f,
    -3.202301e-002f, -3.207326e-002f, -3.212334e-002f, -3.217328e-002f, -3.222305e-002f, -3.227273e-002f,
    -3.232229e-002f, -3.237167e-002f, -3.242090e-002f, -3.246988e-002f, -3.251861e-002f, -3.256704e-002f,
    -3.261532e-002f, -3.266345e-002f, -3.271149e-002f, -3.275949e-002f, -3.280743e-002f, -3.285532e-002f,
    -3.290325e-002f, -3.295123e-002f, -3.299933e-002f, -3.304744e-002f, -3.309576e-002f, -3.314423e-002f,
    -3.319275e-002f, -3.324120e-002f, -3.328962e-002f, -3.333797e-002f, -3.338634e-002f, -3.343478e-002f,
    -3.348335e-002f, -3.353190e-002f, -3.358053e-002f, -3.362921e-002f, -3.367782e-002f, -3.372615e-002f,
    -3.377403e-002f, -3.382148e-002f, -3.386861e-002f, -3.391553e-002f, -3.396222e-002f, -3.400862e-002f,
    -3.405479e-002f, -3.410073e-002f, -3.414653e-002f, -3.419220e-002f, -3.423773e-002f, -3.428312e-002f,
    -3.432841e-002f, -3.437359e-002f, -3.441868e-002f, -3.446361e-002f, -3.450831e-002f, -3.455297e-002f,
    -3.459747e-002f, -3.464185e-002f, -3.468607e-002f, -3.473020e-002f, -3.477423e-002f, -3.481817e-002f,
    -3.486201e-002f, -3.490574e-002f, -3.494928e-002f, -3.499275e-002f, -3.503618e-002f, -3.507956e-002f,
    -3.512293e-002f, -3.516630e-002f, -3.520975e-002f, -3.525324e-002f, -3.529676e-002f, -3.534028e-002f,
    -3.538366e-002f, -3.542705e-002f, -3.547042e-002f, -3.551377e-002f, -3.555710e-002f, -3.560045e-002f,
    -3.564378e-002f, -3.568709e-002f, -3.573027e-002f, -3.577331e-002f, -3.581614e-002f, -3.585881e-002f,
    -3.590129e-002f, -3.594360e-002f, -3.598576e-002f, -3.602773e-002f, -3.606952e-002f, -3.611116e-002f,
    -3.615268e-002f, -3.619413e-002f, -3.623546e-002f, -3.627668e-002f, -3.631784e-002f, -3.635900e-002f,
    -3.640014e-002f, -3.644132e-002f, -3.648262e-002f, -3.652412e-002f, -3.656581e-002f, -3.660775e-002f,
    -3.664982e-002f, -3.669177e-002f, -3.673361e-002f, -3.677528e-002f, -3.681678e-002f, -3.685804e-002f,
    -3.689910e-002f, -3.693993e-002f, -3.698057e-002f, -3.702106e-002f, -3.706138e-002f, -3.710139e-002f,
    -3.714113e-002f, -3.718066e-002f, -3.721993e-002f, -3.725895e-002f, -3.729775e-002f, -3.733637e-002f,
    -3.737485e-002f, -3.741322e-002f, -3.745144e-002f, -3.748950e-002f, -3.752750e-002f, -3.756548e-002f,
    -3.760350e-002f, -3.764158e-002f, -3.767977e-002f, -3.771805e-002f, -3.775641e-002f, -3.779489e-002f,
    -3.783337e-002f, -3.787178e-002f, -3.791007e-002f, -3.794830e-002f, -3.798639e-002f, -3.802438e-002f,
    -3.806230e-002f, -3.810014e-002f, -3.813793e-002f, -3.817563e-002f, -3.821318e-002f, -3.825045e-002f,
    -3.828737e-002f, -3.832406e-002f, -3.836050e-002f, -3.839677e-002f, -3.843287e-002f, -3.846884e-002f,
    -3.850470e-002f, -3.854052e-002f, -3.857625e-002f, -3.861182e-002f, -3.864716e-002f, -3.868239e-002f,
    -3.871746e-002f, -3.875244e-002f, -3.878733e-002f, -3.882217e-002f, -3.885693e-002f, -3.889170e-002f,
    -3.892640e-002f, -3.896107e-002f, -3.899562e-002f, -3.903022e-002f, -3.906484e-002f, -3.909959e-002f,
    -3.913451e-002f, -3.916969e-002f, -3.920516e-002f, -3.924068e-002f, -3.927615e-002f, -3.931141e-002f,
    -3.934628e-002f, -3.938083e-002f, -3.941521e-002f, -3.944940e-002f, -3.948354e-002f, -3.951762e-002f,
    -3.955159e-002f, -3.958545e-002f, -3.961908e-002f, -3.965240e-002f, -3.968527e-002f, -3.971775e-002f,
    -3.975003e-002f, -3.978216e-002f, -3.981413e-002f, -3.984592e-002f, -3.987765e-002f, -3.990928e-002f,
    -3.994083e-002f, -3.997228e-002f, -4.000372e-002f, -4.003494e-002f, -4.006621e-002f, -4.009753e-002f,
    -4.012889e-002f, -4.016029e-002f, -4.019175e-002f, -4.022323e-002f, -4.025482e-002f, -4.028651e-002f,
    -4.031816e-002f, -4.034928e-002f, -4.038001e-002f, -4.041021e-002f, -4.043987e-002f, -4.046904e-002f,
    -4.049777e-002f, -4.052604e-002f, -4.055386e-002f, -4.058123e-002f, -4.060819e-002f, -4.063445e-002f,
    -4.066016e-002f, -4.068559e-002f, -4.071071e-002f, -4.073550e-002f, -4.075998e-002f, -4.078422e-002f,
    -4.080817e-002f, -4.083200e-002f, -4.085568e-002f, -4.087897e-002f, -4.090187e-002f, -4.092459e-002f,
    -4.094719e-002f, -4.096969e-002f, -4.099210e-002f, -4.101449e-002f, -4.103686e-002f, -4.105920e-002f,
    -4.108158e-002f, -4.110390e-002f, -4.112606e-002f, -4.114836e-002f, -4.117073e-002f, -4.119310e-002f,
    -4.121553e-002f, -4.123802e-002f, -4.126054e-002f, -4.128316e-002f, -4.130584e-002f, -4.132856e-002f,
    -4.135085e-002f, -4.137302e-002f, -4.139503e-002f, -4.141678e-002f, -4.143807e-002f, -4.145884e-002f,
    -4.147922e-002f, -4.149924e-002f, -4.151896e-002f, -4.153841e-002f, -4.155709e-002f, -4.157537e-002f,
    -4.159343e-002f, -4.161128e-002f, -4.162887e-002f, -4.164627e-002f, -4.166347e-002f, -4.168053e-002f,
    -4.169741e-002f, -4.171409e-002f, -4.173020e-002f, -4.174598e-002f, -4.176170e-002f, -4.177730e-002f,
    -4.179274e-002f, -4.180804e-002f, -4.182322e-002f, -4.183832e-002f, -4.185342e-002f, -4.186857e-002f,
    -4.188354e-002f, -4.189808e-002f, -4.191258e-002f, -4.192692e-002f, -4.194102e-002f, -4.195492e-002f,
    -4.196866e-002f, -4.198221e-002f, -4.199574e-002f, -4.200906e-002f, -4.202212e-002f, -4.203427e-002f,
    -4.204614e-002f, -4.205764e-002f, -4.206872e-002f, -4.207938e-002f, -4.208975e-002f, -4.209985e-002f,
    -4.210967e-002f, -4.211916e-002f, -4.212840e-002f, -4.213661e-002f, -4.214455e-002f, -4.215232e-002f,
    -4.216000e-002f, -4.216734e-002f, -4.217447e-002f, -4.218140e-002f, -4.218806e-002f, -4.219447e-002f,
    -4.220065e-002f, -4.220590e-002f, -4.221059e-002f, -4.221494e-002f, -4.221905e-002f, -4.222291e-002f,
    -4.222653e-002f, -4.222977e-002f, -4.223266e-002f, -4.223517e-002f, -4.223729e-002f, -4.223869e-002f,
    -4.223901e-002f, -4.223891e-002f, -4.223840e-002f, -4.223757e-002f, -4.223638e-002f, -4.223492e-002f,
    -4.223307e-002f, -4.223087e-002f, -4.222838e-002f, -4.222556e-002f, -4.222162e-002f, -4.221757e-002f,
    -4.221348e-002f, -4.220947e-002f, -4.220531e-002f, -4.220112e-002f, -4.219708e-002f, -4.219321e-002f,
    -4.218940e-002f, -4.218563e-002f, -4.218053e-002f, -4.217517e-002f, -4.216952e-002f, -4.216340e-002f,
    -4.215699e-002f, -4.215031e-002f, -4.214338e-002f, -4.213612e-002f, -4.212862e-002f, -4.212073e-002f,
    -4.211140e-002f, -4.210105e-002f, -4.209019e-002f, -4.207889e-002f, -4.206721e-002f, -4.205518e-002f,
    -4.204283e-002f, -4.203028e-002f, -4.201757e-002f, -4.200449e-002f, -4.199045e-002f, -4.197544e-002f,
    -4.196038e-002f, -4.194520e-002f, -4.192981e-002f, -4.191421e-002f, -4.189845e-002f, -4.188271e-002f,
    -4.186697e-002f, -4.185102e-002f, -4.183452e-002f, -4.181683e-002f, -4.179888e-002f, -4.178052e-002f,
    -4.176171e-002f, -4.174234e-002f, -4.172245e-002f, -4.170208e-002f, -4.168123e-002f, -4.165968e-002f,
    -4.163740e-002f, -4.161329e-002f, -4.158860e-002f, -4.156345e-002f, -4.153785e-002f, -4.151176e-002f,
    -4.148527e-002f, -4.145833e-002f, -4.143115e-002f, -4.140336e-002f, -4.137520e-002f, -4.134533e-002f,
    -4.131476e-002f, -4.128380e-002f, -4.125250e-002f, -4.122076e-002f, -4.118866e-002f, -4.115623e-002f,
    -4.112346e-002f, -4.109010e-002f, -4.105640e-002f, -4.102135e-002f, -4.098537e-002f, -4.094922e-002f,
    -4.091286e-002f, -4.087644e-002f, -4.083970e-002f, -4.080263e-002f, -4.076525e-002f, -4.072758e-002f,
    -4.068947e-002f, -4.065014e-002f, -4.060925e-002f, -4.056795e-002f, -4.052634e-002f, -4.048442e-002f,
    -4.044213e-002f, -4.039922e-002f, -4.035567e-002f, -4.031139e-002f, -4.026642e-002f, -4.022038e-002f,
    -4.017213e-002f, -4.012325e-002f, -4.007387e-002f, -4.002381e-002f, -3.997331e-002f, -3.992227e-002f,
    -3.987075e-002f, -3.981876e-002f, -3.976641e-002f, -3.971344e-002f, -3.965825e-002f, -3.960252e-002f,
    -3.954651e-002f, -3.949009e-002f, -3.943321e-002f, -3.937609e-002f, -3.931847e-002f, -3.926059e-002f,
    -3.920225e-002f, -3.914344e-002f, -3.908245e-002f, -3.902008e-002f, -3.895700e-002f, -3.889304e-002f,
    -3.882843e-002f, -3.876326e-002f, -3.869705e-002f, -3.863003e-002f, -3.856213e-002f, -3.849353e-002f,
    -3.842306e-002f, -3.835093e-002f, -3.827807e-002f, -3.820454e-002f, -3.813013e-002f, -3.805510e-002f,
    -3.797951e-002f, -3.790342e-002f, -3.782664e-002f, -3.774921e-002f, -3.767049e-002f, -3.758917e-002f,
    -3.750738e-002f, -3.742498e-002f, -3.734200e-002f, -3.725849e-002f, -3.717452e-002f, -3.708996e-002f,
    -3.700494e-002f, -3.691950e-002f, -3.683353e-002f, -3.674412e-002f, -3.665405e-002f, -3.656320e-002f,
    -3.647169e-002f, -3.637960e-002f, -3.628669e-002f, -3.619290e-002f, -3.609827e-002f, -3.600281e-002f,
    -3.590650e-002f, -3.580699e-002f, -3.570604e-002f, -3.560407e-002f, -3.550142e-002f, -3.539778e-002f,
    -3.529324e-002f, -3.518797e-002f, -3.508205e-002f, -3.497529e-002f, -3.486767e-002f, -3.475733e-002f,
    -3.464435e-002f, -3.453039e-002f, -3.441555e-002f, -3.429960e-002f, -3.418293e-002f, -3.406567e-002f,
    -3.394739e-002f, -3.382821e-002f, -3.370800e-002f, -3.358524e-002f, -3.345891e-002f, -3.333127e-002f,
    -3.320242e-002f, -3.307204e-002f, -3.294059e-002f, -3.280808e-002f, -3.267451e-002f, -3.253969e-002f,
    -3.240345e-002f, -3.226576e-002f, -3.212292e-002f, -3.197874e-002f, -3.183292e-002f, -3.168610e-002f,
    -3.153797e-002f, -3.138799e-002f, -3.123657e-002f, -3.108369e-002f, -3.092927e-002f, -3.077294e-002f,
    -3.061155e-002f, -3.044834e-002f, -3.028347e-002f, -3.011670e-002f, -2.994799e-002f, -2.977748e-002f,
    -2.960529e-002f, -2.943169e-002f, -2.925652e-002f, -2.907966e-002f, -2.889846e-002f, -2.871340e-002f,
    -2.852629e-002f, -2.833704e-002f, -2.814575e-002f, -2.795228e-002f, -2.775726e-002f, -2.755995e-002f,
    -2.736048e-002f, -2.715863e-002f, -2.695249e-002f, -2.674042e-002f, -2.652666e-002f, -2.630985e-002f,
    -2.609062e-002f, -2.586830e-002f, -2.564352e-002f, -2.541669e-002f, -2.518592e-002f, -2.495234e-002f,
    -2.471529e-002f, -2.447100e-002f, -2.422366e-002f, -2.397329e-002f, -2.371875e-002f, -2.346003e-002f,
    -2.319774e-002f, -2.293137e-002f, -2.266066e-002f, -2.238920e-002f, -2.211452e-002f, -2.182980e-002f,
    -2.154045e-002f, -2.124386e-002f, -2.094103e-002f, -2.063227e-002f, -2.031858e-002f, -2.000225e-002f,
    -1.968033e-002f, -1.934677e-002f, -1.898635e-002f, -1.862573e-002f, -1.826109e-002f, -1.788969e-002f,
    -1.751771e-002f, -1.714099e-002f, -1.675907e-002f, -1.636672e-002f, -1.596240e-002f, -1.554893e-002f,
    -1.512689e-002f, -1.446370e-002f, -1.400828e-002f, -1.355645e-002f, -1.309401e-002f, -1.261733e-002f,
    -1.213440e-002f, -1.164163e-002f, -1.113086e-002f, -1.059870e-002f, -1.003953e-002f, -9.121323e-003f,
    -7.871813e-003f, -7.111556e-003f, -6.411784e-003f, -5.718638e-003f, -4.962077e-003f, -3.505064e-003f,
    -2.593092e-003f, -1.709185e-003f, -8.650688e-004f, 0.000000e+000f};

const float hInv2[1024] = {
    0.000000e+000f,  -1.380706e-003f, -2.537619e-003f, -3.548232e-003f, -4.452111e-003f, -5.273238e-003f,
    -6.028433e-003f, -6.728530e-003f, -7.383660e-003f, -7.999797e-003f, -8.583057e-003f, -9.135808e-003f,
    -9.662426e-003f, -1.016601e-002f, -1.064938e-002f, -1.111449e-002f, -1.156316e-002f, -1.199686e-002f,
    -1.241708e-002f, -1.282460e-002f, -1.321998e-002f, -1.360340e-002f, -1.397568e-002f, -1.433806e-002f,
    -1.469119e-002f, -1.503557e-002f, -1.537149e-002f, -1.569976e-002f, -1.602076e-002f, -1.633465e-002f,
    -1.664175e-002f, -1.694207e-002f, -1.723519e-002f, -1.752263e-002f, -1.780453e-002f, -1.808108e-002f,
    -1.835268e-002f, -1.861944e-002f, -1.888151e-002f, -1.913918e-002f, -1.939260e-002f, -1.964168e-002f,
    -1.988536e-002f, -2.012495e-002f, -2.036070e-002f, -2.059275e-002f, -2.082114e-002f, -2.104594e-002f,
    -2.126740e-002f, -2.148601e-002f, -2.170167e-002f, -2.191439e-002f, -2.212292e-002f, -2.232825e-002f,
    -2.253078e-002f, -2.273052e-002f, -2.292768e-002f, -2.312206e-002f, -2.331385e-002f, -2.350313e-002f,
    -2.368987e-002f, -2.387418e-002f, -2.405547e-002f, -2.423400e-002f, -2.441034e-002f, -2.458450e-002f,
    -2.475648e-002f, -2.492637e-002f, -2.509422e-002f, -2.526006e-002f, -2.542396e-002f, -2.558596e-002f,
    -2.574561e-002f, -2.590270e-002f, -2.605803e-002f, -2.621151e-002f, -2.636305e-002f, -2.651292e-002f,
    -2.666100e-002f, -2.680745e-002f, -2.695221e-002f, -2.709542e-002f, -2.723671e-002f, -2.737560e-002f,
    -2.751293e-002f, -2.764863e-002f, -2.778284e-002f, -2.791539e-002f, -2.804663e-002f, -2.817625e-002f,
    -2.830440e-002f, -2.843113e-002f, -2.855648e-002f, -2.867969e-002f, -2.880139e-002f, -2.892175e-002f,
    -2.904081e-002f, -2.915861e-002f, -2.927501e-002f, -2.939023e-002f, -2.950419e-002f, -2.961702e-002f,
    -2.972864e-002f, -2.983874e-002f, -2.994745e-002f, -3.005493e-002f, -3.016126e-002f, -3.026651e-002f,
    -3.037072e-002f, -3.047370e-002f, -3.057557e-002f, -3.067618e-002f, -3.077586e-002f, -3.087431e-002f,
    -3.097135e-002f, -3.106753e-002f, -3.116268e-002f, -3.125682e-002f, -3.134997e-002f, -3.144200e-002f,
    -3.153315e-002f, -3.162334e-002f, -3.171247e-002f, -3.180041e-002f, -3.188698e-002f, -3.197249e-002f,
    -3.205701e-002f, -3.214052e-002f, -3.222297e-002f, -3.230442e-002f, -3.238497e-002f, -3.246459e-002f,
    -3.254320e-002f, -3.262084e-002f, -3.269717e-002f, -3.277273e-002f, -3.284746e-002f, -3.292126e-002f,
    -3.299417e-002f, -3.306629e-002f, -3.313748e-002f, -3.320776e-002f, -3.327724e-002f, -3.334596e-002f,
    -3.341351e-002f, -3.348020e-002f, -3.354618e-002f, -3.361134e-002f, -3.367560e-002f, -3.373913e-002f,
    -3.380186e-002f, -3.386380e-002f, -3.392484e-002f, -3.398514e-002f, -3.404450e-002f, -3.410286e-002f,
    -3.416045e-002f, -3.421727e-002f, -3.427326e-002f, -3.432849e-002f, -3.438296e-002f, -3.443667e-002f,
    -3.448964e-002f, -3.454186e-002f, -3.459316e-002f, -3.464345e-002f, -3.469297e-002f, -3.474187e-002f,
    -3.478997e-002f, -3.483721e-002f, -3.488369e-002f, -3.492943e-002f, -3.497440e-002f, -3.501855e-002f,
    -3.506201e-002f, -3.510461e-002f, -3.514654e-002f, -3.518767e-002f, -3.522810e-002f, -3.526789e-002f,
    -3.530703e-002f, -3.534542e-002f, -3.538307e-002f, -3.542007e-002f, -3.545643e-002f, -3.549198e-002f,
    -3.552687e-002f, -3.556111e-002f, -3.559473e-002f, -3.562756e-002f, -3.565969e-002f, -3.569121e-002f,
    -3.572212e-002f, -3.575238e-002f, -3.578202e-002f, -3.581092e-002f, -3.583915e-002f, -3.586663e-002f,
    -3.589350e-002f, -3.591977e-002f, -3.594546e-002f, -3.597052e-002f, -3.599497e-002f, -3.601882e-002f,
    -3.604210e-002f, -3.606463e-002f, -3.608645e-002f, -3.610773e-002f, -3.612835e-002f, -3.614836e-002f,
    -3.616768e-002f, -3.618631e-002f, -3.620431e-002f, -3.622168e-002f, -3.623839e-002f, -3.625450e-002f,
    -3.627005e-002f, -3.628503e-002f, -3.629932e-002f, -3.631296e-002f, -3.632598e-002f, -3.633847e-002f,
    -3.635038e-002f, -3.636174e-002f, -3.637250e-002f, -3.638264e-002f, -3.639216e-002f, -3.640108e-002f,
    -3.640939e-002f, -3.641717e-002f, -3.642438e-002f, -3.643106e-002f, -3.643709e-002f, -3.644258e-002f,
    -3.644748e-002f, -3.645181e-002f, -3.645561e-002f, -3.645881e-002f, -3.646151e-002f, -3.646367e-002f,
    -3.646530e-002f, -3.646631e-002f, -3.646684e-002f, -3.646674e-002f, -3.646602e-002f, -3.646472e-002f,
    -3.646297e-002f, -3.646074e-002f, -3.645806e-002f, -3.645487e-002f, -3.645102e-002f, -3.644667e-002f,
    -3.644175e-002f, -3.643632e-002f, -3.643045e-002f, -3.642403e-002f, -3.641717e-002f, -3.640988e-002f,
    -3.640208e-002f, -3.639374e-002f, -3.638486e-002f, -3.637550e-002f, -3.636551e-002f, -3.635498e-002f,
    -3.634391e-002f, -3.633231e-002f, -3.632014e-002f, -3.630763e-002f, -3.629470e-002f, -3.628122e-002f,
    -3.626727e-002f, -3.625272e-002f, -3.623763e-002f, -3.622199e-002f, -3.620586e-002f, -3.618916e-002f,
    -3.617198e-002f, -3.615439e-002f, -3.613635e-002f, -3.611781e-002f, -3.609870e-002f, -3.607906e-002f,
    -3.605882e-002f, -3.603807e-002f, -3.601676e-002f, -3.599492e-002f, -3.597259e-002f, -3.594984e-002f,
    -3.592654e-002f, -3.590272e-002f, -3.587838e-002f, -3.585353e-002f, -3.582817e-002f, -3.580239e-002f,
    -3.577611e-002f, -3.574945e-002f, -3.572249e-002f, -3.569521e-002f, -3.566761e-002f, -3.563950e-002f,
    -3.561093e-002f, -3.558190e-002f, -3.555245e-002f, -3.552254e-002f, -3.549221e-002f, -3.546147e-002f,
    -3.543020e-002f, -3.539856e-002f, -3.536657e-002f, -3.533405e-002f, -3.530107e-002f, -3.526770e-002f,
    -3.523396e-002f, -3.519978e-002f, -3.516531e-002f, -3.513042e-002f, -3.509512e-002f, -3.505951e-002f,
    -3.502372e-002f, -3.498764e-002f, -3.495120e-002f, -3.491428e-002f, -3.487697e-002f, -3.483931e-002f,
    -3.480125e-002f, -3.476283e-002f, -3.472405e-002f, -3.468486e-002f, -3.464545e-002f, -3.460576e-002f,
    -3.456561e-002f, -3.452506e-002f, -3.448406e-002f, -3.444270e-002f, -3.440093e-002f, -3.435868e-002f,
    -3.431606e-002f, -3.427303e-002f, -3.422971e-002f, -3.418606e-002f, -3.414212e-002f, -3.409779e-002f,
    -3.405301e-002f, -3.400776e-002f, -3.396208e-002f, -3.391605e-002f, -3.386957e-002f, -3.382267e-002f,
    -3.377538e-002f, -3.372800e-002f, -3.368010e-002f, -3.363166e-002f, -3.358280e-002f, -3.353354e-002f,
    -3.348386e-002f, -3.343371e-002f, -3.338318e-002f, -3.333228e-002f, -3.328091e-002f, -3.322929e-002f,
    -3.317728e-002f, -3.312482e-002f, -3.307187e-002f, -3.301850e-002f, -3.296473e-002f, -3.291048e-002f,
    -3.285585e-002f, -3.280075e-002f, -3.274511e-002f, -3.268922e-002f, -3.263287e-002f, -3.257599e-002f,
    -3.251866e-002f, -3.246094e-002f, -3.240277e-002f, -3.234405e-002f, -3.228488e-002f, -3.222529e-002f,
    -3.216523e-002f, -3.210483e-002f, -3.204412e-002f, -3.198296e-002f, -3.192145e-002f, -3.185941e-002f,
    -3.179673e-002f, -3.173373e-002f, -3.167030e-002f, -3.160634e-002f, -3.154205e-002f, -3.147731e-002f,
    -3.141236e-002f, -3.134714e-002f, -3.128146e-002f, -3.121519e-002f, -3.114855e-002f, -3.108153e-002f,
    -3.101401e-002f, -3.094607e-002f, -3.087780e-002f, -3.080908e-002f, -3.074024e-002f, -3.067110e-002f,
    -3.060149e-002f, -3.053140e-002f, -3.046100e-002f, -3.039022e-002f, -3.031896e-002f, -3.024738e-002f,
    -3.017548e-002f, -3.010320e-002f, -3.003072e-002f, -2.995782e-002f, -2.988463e-002f, -2.981105e-002f,
    -2.973687e-002f, -2.966223e-002f, -2.958726e-002f, -2.951187e-002f, -2.943599e-002f, -2.935970e-002f,
    -2.928309e-002f, -2.920624e-002f, -2.912890e-002f, -2.905129e-002f, -2.897328e-002f, -2.889482e-002f,
    -2.881596e-002f, -2.873677e-002f, -2.865708e-002f, -2.857700e-002f, -2.849654e-002f, -2.841578e-002f,
    -2.833468e-002f, -2.825317e-002f, -2.817117e-002f, -2.808878e-002f, -2.800621e-002f, -2.792334e-002f,
    -2.783999e-002f, -2.775609e-002f, -2.767181e-002f, -2.758743e-002f, -2.750263e-002f, -2.741739e-002f,
    -2.733178e-002f, -2.724585e-002f, -2.715948e-002f, -2.707270e-002f, -2.698558e-002f, -2.689802e-002f,
    -2.680999e-002f, -2.672187e-002f, -2.663339e-002f, -2.654454e-002f, -2.645518e-002f, -2.636532e-002f,
    -2.627522e-002f, -2.618472e-002f, -2.609368e-002f, -2.600227e-002f, -2.591044e-002f, -2.581830e-002f,
    -2.572573e-002f, -2.563273e-002f, -2.553920e-002f, -2.544516e-002f, -2.535077e-002f, -2.525613e-002f,
    -2.516088e-002f, -2.506522e-002f, -2.496913e-002f, -2.487276e-002f, -2.477599e-002f, -2.467869e-002f,
    -2.458091e-002f, -2.448272e-002f, -2.438410e-002f, -2.428506e-002f, -2.418560e-002f, -2.408555e-002f,
    -2.398503e-002f, -2.388409e-002f, -2.378300e-002f, -2.368153e-002f, -2.357962e-002f, -2.347728e-002f,
    -2.337452e-002f, -2.327135e-002f, -2.316767e-002f, -2.306357e-002f, -2.295886e-002f, -2.285371e-002f,
    -2.274818e-002f, -2.264224e-002f, -2.253584e-002f, -2.242896e-002f, -2.232174e-002f, -2.221403e-002f,
    -2.210588e-002f, -2.199720e-002f, -2.188807e-002f, -2.177841e-002f, -2.166840e-002f, -2.155796e-002f,
    -2.144709e-002f, -2.133579e-002f, -2.122389e-002f, -2.111151e-002f, -2.099879e-002f, -2.088554e-002f,
    -2.077186e-002f, -2.065786e-002f, -2.054348e-002f, -2.042852e-002f, -2.031323e-002f, -2.019760e-002f,
    -2.008134e-002f, -1.996468e-002f, -1.984768e-002f, -1.973028e-002f, -1.961242e-002f, -1.949408e-002f,
    -1.937530e-002f, -1.925612e-002f, -1.913650e-002f, -1.901646e-002f, -1.889604e-002f, -1.877485e-002f,
    -1.865308e-002f, -1.853067e-002f, -1.840764e-002f, -1.828390e-002f, -1.815937e-002f, -1.803439e-002f,
    -1.790873e-002f, -1.778231e-002f, -1.765525e-002f, -1.752768e-002f, -1.739967e-002f, -1.727136e-002f,
    -1.714254e-002f, -1.701325e-002f, -1.688353e-002f, -1.675350e-002f, -1.662305e-002f, -1.649209e-002f,
    -1.636058e-002f, -1.622845e-002f, -1.609593e-002f, -1.596322e-002f, -1.582997e-002f, -1.569629e-002f,
    -1.556213e-002f, -1.542766e-002f, -1.529277e-002f, -1.515758e-002f, -1.502197e-002f, -1.488613e-002f,
    -1.475005e-002f, -1.461369e-002f, -1.447692e-002f, -1.433997e-002f, -1.420284e-002f, -1.406561e-002f,
    -1.392816e-002f, -1.379033e-002f, -1.365225e-002f, -1.351381e-002f, -1.337487e-002f, -1.323562e-002f,
    -1.309598e-002f, -1.295600e-002f, -1.281558e-002f, -1.267476e-002f, -1.253351e-002f, -1.239184e-002f,
    -1.224976e-002f, -1.210743e-002f, -1.196473e-002f, -1.182152e-002f, -1.167779e-002f, -1.153375e-002f,
    -1.138952e-002f, -1.124491e-002f, -1.110006e-002f, -1.095480e-002f, -1.080910e-002f, -1.066301e-002f,
    -1.051664e-002f, -1.036987e-002f, -1.022263e-002f, -1.007491e-002f, -9.926863e-003f, -9.778299e-003f,
    -9.629206e-003f, -9.479888e-003f, -9.330225e-003f, -9.180250e-003f, -9.029736e-003f, -8.878773e-003f,
    -8.727338e-003f, -8.575517e-003f, -8.423305e-003f, -8.270836e-003f, -8.117941e-003f, -7.964661e-003f,
    -7.810990e-003f, -7.656787e-003f, -7.502118e-003f, -7.347186e-003f, -7.191605e-003f, -7.035531e-003f,
    -6.879039e-003f, -6.722144e-003f, -6.564889e-003f, -6.407487e-003f, -6.249413e-003f, -6.090871e-003f,
    -5.931831e-003f, -5.772405e-003f, -5.612440e-003f, -5.452035e-003f, -5.291017e-003f, -5.129698e-003f,
    -4.967789e-003f, -4.805462e-003f, -4.642417e-003f, -4.478781e-003f, -4.314676e-003f, -4.149981e-003f,
    -3.984674e-003f, -3.818684e-003f, -3.651952e-003f, -3.484713e-003f, -3.317105e-003f, -3.149171e-003f,
    -2.980807e-003f, -2.811812e-003f, -2.642034e-003f, -2.471873e-003f, -2.301294e-003f, -2.130406e-003f,
    -1.958804e-003f, -1.786640e-003f, -1.613924e-003f, -1.440865e-003f, -1.267425e-003f, -1.093432e-003f,
    -9.188499e-004f, -7.437556e-004f, -5.681595e-004f, -3.918928e-004f, -2.152634e-004f, -3.840933e-005f,
    1.388878e-004f,  3.167162e-004f,  4.945427e-004f,  6.728475e-004f,  8.514123e-004f,  1.030223e-003f,
    1.209529e-003f,  1.389108e-003f,  1.569282e-003f,  1.749760e-003f,  1.930617e-003f,  2.111944e-003f,
    2.293420e-003f,  2.475297e-003f,  2.657542e-003f,  2.840094e-003f,  3.022974e-003f,  3.206289e-003f,
    3.390227e-003f,  3.574669e-003f,  3.759420e-003f,  3.944650e-003f,  4.129904e-003f,  4.315339e-003f,
    4.501200e-003f,  4.687318e-003f,  4.873995e-003f,  5.061234e-003f,  5.248981e-003f,  5.437239e-003f,
    5.625715e-003f,  5.814437e-003f,  6.003174e-003f,  6.192198e-003f,  6.381767e-003f,  6.571641e-003f,
    6.761942e-003f,  6.952501e-003f,  7.143531e-003f,  7.335128e-003f,  7.526899e-003f,  7.718937e-003f,
    7.911239e-003f,  8.103503e-003f,  8.296160e-003f,  8.489272e-003f,  8.682967e-003f,  8.877145e-003f,
    9.071732e-003f,  9.266590e-003f,  9.461674e-003f,  9.657076e-003f,  9.852716e-003f,  1.004835e-002f,
    1.024472e-002f,  1.044162e-002f,  1.063897e-002f,  1.083673e-002f,  1.103515e-002f,  1.123390e-002f,
    1.143302e-002f,  1.163246e-002f,  1.183230e-002f,  1.203209e-002f,  1.223234e-002f,  1.243312e-002f,
    1.263429e-002f,  1.283589e-002f,  1.303791e-002f,  1.324075e-002f,  1.344416e-002f,  1.364830e-002f,
    1.385287e-002f,  1.405732e-002f,  1.426189e-002f,  1.446701e-002f,  1.467249e-002f,  1.487877e-002f,
    1.508553e-002f,  1.529243e-002f,  1.549970e-002f,  1.570735e-002f,  1.591524e-002f,  1.612325e-002f,
    1.633149e-002f,  1.653964e-002f,  1.674808e-002f,  1.695718e-002f,  1.716665e-002f,  1.737638e-002f,
    1.758647e-002f,  1.779674e-002f,  1.800720e-002f,  1.821791e-002f,  1.842861e-002f,  1.863974e-002f,
    1.885109e-002f,  1.906238e-002f,  1.927413e-002f,  1.948622e-002f,  1.969859e-002f,  1.991134e-002f,
    2.012457e-002f,  2.033795e-002f,  2.055052e-002f,  2.076334e-002f,  2.097614e-002f,  2.118909e-002f,
    2.140257e-002f,  2.161672e-002f,  2.183073e-002f,  2.204468e-002f,  2.225936e-002f,  2.247434e-002f,
    2.268879e-002f,  2.290243e-002f,  2.311654e-002f,  2.333120e-002f,  2.354619e-002f,  2.376138e-002f,
    2.397638e-002f,  2.419221e-002f,  2.440812e-002f,  2.462415e-002f,  2.483977e-002f,  2.505449e-002f,
    2.526956e-002f,  2.548532e-002f,  2.570141e-002f,  2.591753e-002f,  2.613366e-002f,  2.635010e-002f,
    2.656685e-002f,  2.678406e-002f,  2.700066e-002f,  2.721644e-002f,  2.743297e-002f,  2.765008e-002f,
    2.786691e-002f,  2.808376e-002f,  2.830037e-002f,  2.851711e-002f,  2.873420e-002f,  2.895173e-002f,
    2.916914e-002f,  2.938571e-002f,  2.960230e-002f,  2.981918e-002f,  3.003642e-002f,  3.025388e-002f,
    3.047129e-002f,  3.068832e-002f,  3.090576e-002f,  3.112341e-002f,  3.134130e-002f,  3.155832e-002f,
    3.177516e-002f,  3.199213e-002f,  3.220943e-002f,  3.242669e-002f,  3.264375e-002f,  3.286111e-002f,
    3.307851e-002f,  3.329647e-002f,  3.351449e-002f,  3.373148e-002f,  3.394802e-002f,  3.416480e-002f,
    3.438177e-002f,  3.459905e-002f,  3.481659e-002f,  3.503397e-002f,  3.525162e-002f,  3.546922e-002f,
    3.568671e-002f,  3.590381e-002f,  3.611971e-002f,  3.633615e-002f,  3.655233e-002f,  3.676820e-002f,
    3.698390e-002f,  3.719954e-002f,  3.741477e-002f,  3.762999e-002f,  3.784502e-002f,  3.805927e-002f,
    3.827239e-002f,  3.848548e-002f,  3.869846e-002f,  3.891112e-002f,  3.912377e-002f,  3.933628e-002f,
    3.954853e-002f,  3.976029e-002f,  3.997216e-002f,  4.018378e-002f,  4.039365e-002f,  4.060349e-002f,
    4.081284e-002f,  4.102173e-002f,  4.123006e-002f,  4.143837e-002f,  4.164652e-002f,  4.185434e-002f,
    4.206080e-002f,  4.226710e-002f,  4.247193e-002f,  4.267628e-002f,  4.288001e-002f,  4.308339e-002f,
    4.328656e-002f,  4.348910e-002f,  4.369158e-002f,  4.389370e-002f,  4.409512e-002f,  4.429601e-002f,
    4.449555e-002f,  4.469309e-002f,  4.489005e-002f,  4.508657e-002f,  4.528221e-002f,  4.547716e-002f,
    4.567085e-002f,  4.586390e-002f,  4.605641e-002f,  4.624848e-002f,  4.643978e-002f,  4.662839e-002f,
    4.681564e-002f,  4.700235e-002f,  4.718857e-002f,  4.737394e-002f,  4.755836e-002f,  4.774268e-002f,
    4.792619e-002f,  4.810848e-002f,  4.829004e-002f,  4.846807e-002f,  4.864474e-002f,  4.882018e-002f,
    4.899443e-002f,  4.916763e-002f,  4.933912e-002f,  4.950947e-002f,  4.967827e-002f,  4.984503e-002f,
    5.001084e-002f,  5.017339e-002f,  5.033537e-002f,  5.049553e-002f,  5.065465e-002f,  5.081302e-002f,
    5.097031e-002f,  5.112593e-002f,  5.128044e-002f,  5.143252e-002f,  5.158333e-002f,  5.173167e-002f,
    5.187521e-002f,  5.201761e-002f,  5.215924e-002f,  5.229866e-002f,  5.243674e-002f,  5.257302e-002f,
    5.270632e-002f,  5.283815e-002f,  5.296871e-002f,  5.309521e-002f,  5.321711e-002f,  5.333508e-002f,
    5.345026e-002f,  5.356186e-002f,  5.367134e-002f,  5.377853e-002f,  5.388269e-002f,  5.398251e-002f,
    5.407914e-002f,  5.417283e-002f,  5.425936e-002f,  5.434245e-002f,  5.442081e-002f,  5.449691e-002f,
    5.456919e-002f,  5.463745e-002f,  5.470278e-002f,  5.476401e-002f,  5.482035e-002f,  5.487145e-002f,
    5.491466e-002f,  5.495483e-002f,  5.499070e-002f,  5.502202e-002f,  5.504626e-002f,  5.506480e-002f,
    5.507908e-002f,  5.508837e-002f,  5.509176e-002f,  5.509037e-002f,  5.508130e-002f,  5.506469e-002f,
    5.504226e-002f,  5.501149e-002f,  5.497314e-002f,  5.492907e-002f,  5.487915e-002f,  5.482218e-002f,
    5.475930e-002f,  5.468910e-002f,  5.461169e-002f,  5.452295e-002f,  5.442757e-002f,  5.432349e-002f,
    5.421169e-002f,  5.409030e-002f,  5.396074e-002f,  5.382497e-002f,  5.367777e-002f,  5.352149e-002f,
    5.335712e-002f,  5.318157e-002f,  5.299479e-002f,  5.279605e-002f,  5.258339e-002f,  5.235704e-002f,
    5.211555e-002f,  5.186179e-002f,  5.159240e-002f,  5.132070e-002f,  5.103851e-002f,  5.074100e-002f,
    5.043067e-002f,  5.009421e-002f,  4.973575e-002f,  4.935512e-002f,  4.895530e-002f,  4.854740e-002f,
    4.811690e-002f,  4.764371e-002f,  4.706587e-002f,  4.650470e-002f,  4.593629e-002f,  4.534170e-002f,
    4.474376e-002f,  4.412589e-002f,  4.348096e-002f,  4.279121e-002f,  4.205265e-002f,  4.128471e-002f,
    4.048974e-002f,  3.877263e-002f,  3.788250e-002f,  3.701317e-002f,  3.610274e-002f,  3.513388e-002f,
    3.413506e-002f,  3.308996e-002f,  3.196537e-002f,  3.074525e-002f,  2.939912e-002f,  2.658509e-002f,
    2.261612e-002f,  2.050075e-002f,  1.859532e-002f,  1.673826e-002f,  1.467582e-002f,  1.015304e-002f,
    7.539017e-003f,  5.011997e-003f,  2.597830e-003f,  0.000000e+000f};

const float hInv3[1024] = {
    0.000000e+000f,  -1.966839e-003f, -3.591180e-003f, -4.993148e-003f, -6.239044e-003f, -7.361541e-003f,
    -8.389511e-003f, -9.339801e-003f, -1.022619e-002f, -1.106100e-002f, -1.185191e-002f, -1.259061e-002f,
    -1.329160e-002f, -1.396254e-002f, -1.460719e-002f, -1.522683e-002f, -1.582421e-002f, -1.639999e-002f,
    -1.695729e-002f, -1.749608e-002f, -1.801787e-002f, -1.851602e-002f, -1.899179e-002f, -1.945418e-002f,
    -1.990387e-002f, -2.034123e-002f, -2.076620e-002f, -2.117981e-002f, -2.158230e-002f, -2.197431e-002f,
    -2.235616e-002f, -2.272505e-002f, -2.307672e-002f, -2.342042e-002f, -2.375600e-002f, -2.408425e-002f,
    -2.440564e-002f, -2.472019e-002f, -2.502813e-002f, -2.532968e-002f, -2.562541e-002f, -2.591441e-002f,
    -2.618794e-002f, -2.645629e-002f, -2.671985e-002f, -2.697872e-002f, -2.723388e-002f, -2.748576e-002f,
    -2.773307e-002f, -2.797437e-002f, -2.821109e-002f, -2.844384e-002f, -2.866481e-002f, -2.887993e-002f,
    -2.909166e-002f, -2.929993e-002f, -2.950482e-002f, -2.970608e-002f, -2.990367e-002f, -3.009803e-002f,
    -3.028875e-002f, -3.047628e-002f, -3.065546e-002f, -3.082844e-002f, -3.099849e-002f, -3.116545e-002f,
    -3.132970e-002f, -3.149063e-002f, -3.164834e-002f, -3.180300e-002f, -3.195478e-002f, -3.210327e-002f,
    -3.224521e-002f, -3.237865e-002f, -3.250892e-002f, -3.263511e-002f, -3.275758e-002f, -3.287599e-002f,
    -3.299138e-002f, -3.310449e-002f, -3.321632e-002f, -3.332669e-002f, -3.343441e-002f, -3.353524e-002f,
    -3.363447e-002f, -3.373225e-002f, -3.382829e-002f, -3.392293e-002f, -3.401612e-002f, -3.410786e-002f,
    -3.419812e-002f, -3.428680e-002f, -3.437388e-002f, -3.445333e-002f, -3.453058e-002f, -3.460547e-002f,
    -3.467862e-002f, -3.474991e-002f, -3.481909e-002f, -3.488623e-002f, -3.495141e-002f, -3.501494e-002f,
    -3.507679e-002f, -3.513295e-002f, -3.518527e-002f, -3.523577e-002f, -3.528423e-002f, -3.533110e-002f,
    -3.537587e-002f, -3.541824e-002f, -3.545852e-002f, -3.549612e-002f, -3.553209e-002f, -3.556406e-002f,
    -3.559189e-002f, -3.561836e-002f, -3.564298e-002f, -3.566592e-002f, -3.568723e-002f, -3.570689e-002f,
    -3.572536e-002f, -3.574251e-002f, -3.575848e-002f, -3.577326e-002f, -3.578487e-002f, -3.579626e-002f,
    -3.580776e-002f, -3.581877e-002f, -3.582928e-002f, -3.583928e-002f, -3.584837e-002f, -3.585611e-002f,
    -3.586263e-002f, -3.586778e-002f, -3.586777e-002f, -3.586676e-002f, -3.586409e-002f, -3.585986e-002f,
    -3.585433e-002f, -3.584722e-002f, -3.583791e-002f, -3.582700e-002f, -3.581450e-002f, -3.580064e-002f,
    -3.578282e-002f, -3.576323e-002f, -3.574255e-002f, -3.572062e-002f, -3.569772e-002f, -3.567434e-002f,
    -3.565025e-002f, -3.562539e-002f, -3.559966e-002f, -3.557335e-002f, -3.554447e-002f, -3.551383e-002f,
    -3.548306e-002f, -3.545177e-002f, -3.541966e-002f, -3.538698e-002f, -3.535371e-002f, -3.531956e-002f,
    -3.528466e-002f, -3.524860e-002f, -3.521048e-002f, -3.516928e-002f, -3.512678e-002f, -3.508278e-002f,
    -3.503683e-002f, -3.498877e-002f, -3.493888e-002f, -3.488733e-002f, -3.483457e-002f, -3.478079e-002f,
    -3.472583e-002f, -3.466768e-002f, -3.460757e-002f, -3.454567e-002f, -3.448217e-002f, -3.441719e-002f,
    -3.435115e-002f, -3.428442e-002f, -3.421753e-002f, -3.415069e-002f, -3.408377e-002f, -3.401517e-002f,
    -3.394597e-002f, -3.387597e-002f, -3.380535e-002f, -3.373329e-002f, -3.365997e-002f, -3.358578e-002f,
    -3.351067e-002f, -3.343428e-002f, -3.335670e-002f, -3.327714e-002f, -3.319585e-002f, -3.311291e-002f,
    -3.302862e-002f, -3.294302e-002f, -3.285606e-002f, -3.276788e-002f, -3.267851e-002f, -3.258794e-002f,
    -3.249626e-002f, -3.240283e-002f, -3.230723e-002f, -3.220990e-002f, -3.211058e-002f, -3.200970e-002f,
    -3.190722e-002f, -3.180380e-002f, -3.169973e-002f, -3.159527e-002f, -3.149043e-002f, -3.138474e-002f,
    -3.127840e-002f, -3.117102e-002f, -3.106265e-002f, -3.095331e-002f, -3.084328e-002f, -3.073346e-002f,
    -3.062434e-002f, -3.051620e-002f, -3.040860e-002f, -3.030118e-002f, -3.019367e-002f, -3.008615e-002f,
    -2.997844e-002f, -2.987045e-002f, -2.976202e-002f, -2.965337e-002f, -2.954412e-002f, -2.943475e-002f,
    -2.932485e-002f, -2.921462e-002f, -2.910414e-002f, -2.899348e-002f, -2.888244e-002f, -2.877074e-002f,
    -2.865821e-002f, -2.854463e-002f, -2.843042e-002f, -2.831500e-002f, -2.819846e-002f, -2.808050e-002f,
    -2.796133e-002f, -2.784078e-002f, -2.771842e-002f, -2.759459e-002f, -2.746935e-002f, -2.734355e-002f,
    -2.721726e-002f, -2.709102e-002f, -2.696490e-002f, -2.683883e-002f, -2.671293e-002f, -2.658809e-002f,
    -2.646330e-002f, -2.633841e-002f, -2.621351e-002f, -2.608870e-002f, -2.596409e-002f, -2.583992e-002f,
    -2.571572e-002f, -2.559167e-002f, -2.546747e-002f, -2.534397e-002f, -2.522034e-002f, -2.509622e-002f,
    -2.497177e-002f, -2.484657e-002f, -2.472044e-002f, -2.459337e-002f, -2.446517e-002f, -2.433571e-002f,
    -2.420496e-002f, -2.407371e-002f, -2.394179e-002f, -2.380879e-002f, -2.367483e-002f, -2.353998e-002f,
    -2.340412e-002f, -2.326734e-002f, -2.312955e-002f, -2.299089e-002f, -2.285134e-002f, -2.271140e-002f,
    -2.257144e-002f, -2.243179e-002f, -2.229282e-002f, -2.215476e-002f, -2.201766e-002f, -2.188115e-002f,
    -2.174519e-002f, -2.160985e-002f, -2.147536e-002f, -2.134149e-002f, -2.120844e-002f, -2.107539e-002f,
    -2.094222e-002f, -2.080879e-002f, -2.067517e-002f, -2.054106e-002f, -2.040646e-002f, -2.027174e-002f,
    -2.013647e-002f, -2.000085e-002f, -1.986546e-002f, -1.972941e-002f, -1.959259e-002f, -1.945515e-002f,
    -1.931705e-002f, -1.917788e-002f, -1.903774e-002f, -1.889622e-002f, -1.875334e-002f, -1.860944e-002f,
    -1.846543e-002f, -1.832141e-002f, -1.817748e-002f, -1.803336e-002f, -1.788895e-002f, -1.774428e-002f,
    -1.759905e-002f, -1.745355e-002f, -1.730772e-002f, -1.716162e-002f, -1.701596e-002f, -1.687088e-002f,
    -1.672629e-002f, -1.658218e-002f, -1.643854e-002f, -1.629489e-002f, -1.615134e-002f, -1.600750e-002f,
    -1.586341e-002f, -1.571896e-002f, -1.557404e-002f, -1.542910e-002f, -1.528392e-002f, -1.513796e-002f,
    -1.499090e-002f, -1.484271e-002f, -1.469360e-002f, -1.454325e-002f, -1.439152e-002f, -1.423813e-002f,
    -1.408320e-002f, -1.392718e-002f, -1.376950e-002f, -1.361051e-002f, -1.345110e-002f, -1.329235e-002f,
    -1.313460e-002f, -1.297773e-002f, -1.282185e-002f, -1.266683e-002f, -1.251242e-002f, -1.235853e-002f,
    -1.220519e-002f, -1.205217e-002f, -1.189931e-002f, -1.174701e-002f, -1.159466e-002f, -1.144194e-002f,
    -1.128911e-002f, -1.113615e-002f, -1.098294e-002f, -1.082924e-002f, -1.067501e-002f, -1.051984e-002f,
    -1.036434e-002f, -1.020873e-002f, -1.005245e-002f, -9.895465e-003f, -9.738041e-003f, -9.579849e-003f,
    -9.420823e-003f, -9.261355e-003f, -9.101149e-003f, -8.940406e-003f, -8.779631e-003f, -8.618267e-003f,
    -8.456074e-003f, -8.293726e-003f, -8.131020e-003f, -7.967837e-003f, -7.804873e-003f, -7.641933e-003f,
    -7.479290e-003f, -7.317384e-003f, -7.155562e-003f, -6.993296e-003f, -6.831157e-003f, -6.669236e-003f,
    -6.507261e-003f, -6.345222e-003f, -6.183646e-003f, -6.022218e-003f, -5.860293e-003f, -5.698692e-003f,
    -5.536748e-003f, -5.374494e-003f, -5.212143e-003f, -5.049675e-003f, -4.886855e-003f, -4.723991e-003f,
    -4.561025e-003f, -4.397728e-003f, -4.233721e-003f, -4.068919e-003f, -3.903604e-003f, -3.737749e-003f,
    -3.570730e-003f, -3.403513e-003f, -3.235868e-003f, -3.067657e-003f, -2.898930e-003f, -2.729813e-003f,
    -2.560363e-003f, -2.391116e-003f, -2.222493e-003f, -2.054283e-003f, -1.886625e-003f, -1.718936e-003f,
    -1.551512e-003f, -1.384398e-003f, -1.217584e-003f, -1.051581e-003f, -8.858093e-004f, -7.201158e-004f,
    -5.547316e-004f, -3.895848e-004f, -2.243384e-004f, -5.921775e-005f, 1.059822e-004f,  2.712131e-004f,
    4.370167e-004f,  6.036588e-004f,  7.713905e-004f,  9.400408e-004f,  1.110214e-003f,  1.281555e-003f,
    1.453370e-003f,  1.625212e-003f,  1.797671e-003f,  1.970354e-003f,  2.143343e-003f,  2.317256e-003f,
    2.492200e-003f,  2.668139e-003f,  2.844772e-003f,  3.021951e-003f,  3.199321e-003f,  3.376032e-003f,
    3.551143e-003f,  3.724886e-003f,  3.897569e-003f,  4.069707e-003f,  4.241390e-003f,  4.412715e-003f,
    4.583785e-003f,  4.753939e-003f,  4.924032e-003f,  5.093895e-003f,  5.263328e-003f,  5.432351e-003f,
    5.601433e-003f,  5.770470e-003f,  5.939402e-003f,  6.108045e-003f,  6.276087e-003f,  6.444282e-003f,
    6.612206e-003f,  6.779708e-003f,  6.946687e-003f,  7.113328e-003f,  7.279783e-003f,  7.446017e-003f,
    7.612186e-003f,  7.778048e-003f,  7.943520e-003f,  8.108631e-003f,  8.273793e-003f,  8.438541e-003f,
    8.603300e-003f,  8.768351e-003f,  8.934221e-003f,  9.100179e-003f,  9.266750e-003f,  9.433547e-003f,
    9.599827e-003f,  9.766012e-003f,  9.932237e-003f,  1.009857e-002f,  1.026489e-002f,  1.043112e-002f,
    1.059739e-002f,  1.076378e-002f,  1.092990e-002f,  1.109568e-002f,  1.126048e-002f,  1.142460e-002f,
    1.158801e-002f,  1.175065e-002f,  1.191302e-002f,  1.207466e-002f,  1.223591e-002f,  1.239666e-002f,
    1.255705e-002f,  1.271685e-002f,  1.287597e-002f,  1.303478e-002f,  1.319331e-002f,  1.335189e-002f,
    1.351070e-002f,  1.366987e-002f,  1.382948e-002f,  1.398999e-002f,  1.415172e-002f,  1.431458e-002f,
    1.447820e-002f,  1.464091e-002f,  1.480350e-002f,  1.496528e-002f,  1.512640e-002f,  1.528697e-002f,
    1.544713e-002f,  1.560691e-002f,  1.576672e-002f,  1.592610e-002f,  1.608575e-002f,  1.624329e-002f,
    1.639994e-002f,  1.655645e-002f,  1.671218e-002f,  1.686687e-002f,  1.702112e-002f,  1.717496e-002f,
    1.732864e-002f,  1.748210e-002f,  1.763514e-002f,  1.778652e-002f,  1.793727e-002f,  1.808838e-002f,
    1.823991e-002f,  1.839187e-002f,  1.854457e-002f,  1.869797e-002f,  1.885149e-002f,  1.900568e-002f,
    1.915961e-002f,  1.931247e-002f,  1.946403e-002f,  1.961523e-002f,  1.976594e-002f,  1.991587e-002f,
    2.006527e-002f,  2.021437e-002f,  2.036332e-002f,  2.051137e-002f,  2.065815e-002f,  2.080310e-002f,
    2.094557e-002f,  2.108679e-002f,  2.122632e-002f,  2.136482e-002f,  2.150281e-002f,  2.164089e-002f,
    2.177871e-002f,  2.191563e-002f,  2.205207e-002f,  2.218757e-002f,  2.232051e-002f,  2.245280e-002f,
    2.258438e-002f,  2.271551e-002f,  2.284626e-002f,  2.297666e-002f,  2.310622e-002f,  2.323546e-002f,
    2.336454e-002f,  2.349375e-002f,  2.362020e-002f,  2.374685e-002f,  2.387338e-002f,  2.400049e-002f,
    2.412878e-002f,  2.425854e-002f,  2.438938e-002f,  2.452046e-002f,  2.465088e-002f,  2.478022e-002f,
    2.490717e-002f,  2.503224e-002f,  2.515708e-002f,  2.528110e-002f,  2.540465e-002f,  2.552781e-002f,
    2.565030e-002f,  2.577199e-002f,  2.589283e-002f,  2.601235e-002f,  2.612937e-002f,  2.624383e-002f,
    2.635685e-002f,  2.646946e-002f,  2.658120e-002f,  2.669239e-002f,  2.680348e-002f,  2.691442e-002f,
    2.702523e-002f,  2.713526e-002f,  2.724457e-002f,  2.735194e-002f,  2.746013e-002f,  2.756777e-002f,
    2.767555e-002f,  2.778380e-002f,  2.789195e-002f,  2.799997e-002f,  2.810846e-002f,  2.821642e-002f,
    2.832466e-002f,  2.843016e-002f,  2.853420e-002f,  2.863659e-002f,  2.873672e-002f,  2.883550e-002f,
    2.893277e-002f,  2.902819e-002f,  2.912165e-002f,  2.921310e-002f,  2.930243e-002f,  2.938811e-002f,
    2.947135e-002f,  2.955326e-002f,  2.963369e-002f,  2.971291e-002f,  2.979015e-002f,  2.986640e-002f,
    2.994159e-002f,  3.001591e-002f,  3.008902e-002f,  3.016003e-002f,  3.022845e-002f,  3.029631e-002f,
    3.036281e-002f,  3.042880e-002f,  3.049392e-002f,  3.055882e-002f,  3.062330e-002f,  3.068711e-002f,
    3.075038e-002f,  3.081252e-002f,  3.087263e-002f,  3.093255e-002f,  3.099232e-002f,  3.105140e-002f,
    3.111032e-002f,  3.116886e-002f,  3.122663e-002f,  3.128395e-002f,  3.134037e-002f,  3.139612e-002f,
    3.144927e-002f,  3.150173e-002f,  3.155311e-002f,  3.160231e-002f,  3.164882e-002f,  3.169281e-002f,
    3.173454e-002f,  3.177476e-002f,  3.181250e-002f,  3.184878e-002f,  3.188169e-002f,  3.191346e-002f,
    3.194373e-002f,  3.197212e-002f,  3.199901e-002f,  3.202554e-002f,  3.205045e-002f,  3.207361e-002f,
    3.209555e-002f,  3.211650e-002f,  3.213518e-002f,  3.215201e-002f,  3.216799e-002f,  3.218322e-002f,
    3.219685e-002f,  3.220924e-002f,  3.222039e-002f,  3.223028e-002f,  3.224050e-002f,  3.225093e-002f,
    3.226026e-002f,  3.226707e-002f,  3.227286e-002f,  3.227752e-002f,  3.228153e-002f,  3.228387e-002f,
    3.228520e-002f,  3.228611e-002f,  3.228593e-002f,  3.228524e-002f,  3.228232e-002f,  3.227557e-002f,
    3.226718e-002f,  3.225747e-002f,  3.224612e-002f,  3.223264e-002f,  3.221771e-002f,  3.220026e-002f,
    3.218160e-002f,  3.216118e-002f,  3.213981e-002f,  3.211469e-002f,  3.208782e-002f,  3.206007e-002f,
    3.203126e-002f,  3.200167e-002f,  3.197165e-002f,  3.194031e-002f,  3.190743e-002f,  3.187400e-002f,
    3.183946e-002f,  3.180115e-002f,  3.175928e-002f,  3.171587e-002f,  3.167146e-002f,  3.162530e-002f,
    3.157741e-002f,  3.152789e-002f,  3.147663e-002f,  3.142246e-002f,  3.136501e-002f,  3.130346e-002f,
    3.123699e-002f,  3.116953e-002f,  3.109936e-002f,  3.102779e-002f,  3.095295e-002f,  3.087560e-002f,
    3.079631e-002f,  3.071589e-002f,  3.063382e-002f,  3.054973e-002f,  3.045998e-002f,  3.036949e-002f,
    3.027739e-002f,  3.018344e-002f,  3.008859e-002f,  2.999360e-002f,  2.989827e-002f,  2.980283e-002f,
    2.970704e-002f,  2.960970e-002f,  2.950349e-002f,  2.939527e-002f,  2.928523e-002f,  2.917266e-002f,
    2.905757e-002f,  2.894071e-002f,  2.882180e-002f,  2.869959e-002f,  2.857575e-002f,  2.845008e-002f,
    2.831566e-002f,  2.817780e-002f,  2.803695e-002f,  2.789301e-002f,  2.774673e-002f,  2.759854e-002f,
    2.744850e-002f,  2.729682e-002f,  2.714465e-002f,  2.699143e-002f,  2.683162e-002f,  2.666496e-002f,
    2.649675e-002f,  2.632743e-002f,  2.615595e-002f,  2.598346e-002f,  2.581048e-002f,  2.563700e-002f,
    2.546115e-002f,  2.528375e-002f,  2.510156e-002f,  2.491103e-002f,  2.471859e-002f,  2.452439e-002f,
    2.432807e-002f,  2.412877e-002f,  2.392610e-002f,  2.372015e-002f,  2.351167e-002f,  2.329986e-002f,
    2.308513e-002f,  2.285558e-002f,  2.262340e-002f,  2.238864e-002f,  2.215123e-002f,  2.191134e-002f,
    2.166893e-002f,  2.142404e-002f,  2.117648e-002f,  2.092594e-002f,  2.067282e-002f,  2.040455e-002f,
    2.013124e-002f,  1.985568e-002f,  1.957826e-002f,  1.929783e-002f,  1.901505e-002f,  1.872934e-002f,
    1.844247e-002f,  1.815118e-002f,  1.785771e-002f,  1.755223e-002f,  1.723858e-002f,  1.692252e-002f,
    1.660536e-002f,  1.628761e-002f,  1.596799e-002f,  1.564605e-002f,  1.532118e-002f,  1.499559e-002f,
    1.466648e-002f,  1.432733e-002f,  1.397388e-002f,  1.361818e-002f,  1.326007e-002f,  1.290029e-002f,
    1.253904e-002f,  1.217461e-002f,  1.180746e-002f,  1.143719e-002f,  1.106476e-002f,  1.068498e-002f,
    1.028033e-002f,  9.872624e-003f,  9.461763e-003f,  9.049343e-003f,  8.634534e-003f,  8.216368e-003f,
    7.795413e-003f,  7.370769e-003f,  6.943927e-003f,  6.514843e-003f,  6.061363e-003f,  5.602106e-003f,
    5.141048e-003f,  4.677731e-003f,  4.213148e-003f,  3.746919e-003f,  3.281348e-003f,  2.812686e-003f,
    2.341426e-003f,  1.867539e-003f,  1.372858e-003f,  8.657118e-004f,  3.559656e-004f,  -1.565810e-004f,
    -6.724358e-004f, -1.194563e-003f, -1.719430e-003f, -2.248734e-003f, -2.781376e-003f, -3.315120e-003f,
    -3.866493e-003f, -4.438732e-003f, -5.015597e-003f, -5.594566e-003f, -6.175830e-003f, -6.759827e-003f,
    -7.346464e-003f, -7.936339e-003f, -8.528588e-003f, -9.122071e-003f, -9.725078e-003f, -1.035609e-002f,
    -1.098837e-002f, -1.162109e-002f, -1.225259e-002f, -1.288795e-002f, -1.352328e-002f, -1.415860e-002f,
    -1.479598e-002f, -1.543840e-002f, -1.608183e-002f, -1.675517e-002f, -1.743171e-002f, -1.810839e-002f,
    -1.878658e-002f, -1.946581e-002f, -2.014412e-002f, -2.082697e-002f, -2.151165e-002f, -2.219821e-002f,
    -2.288776e-002f, -2.360226e-002f, -2.432553e-002f, -2.504945e-002f, -2.577604e-002f, -2.650347e-002f,
    -2.723117e-002f, -2.796133e-002f, -2.869360e-002f, -2.942647e-002f, -3.016289e-002f, -3.091634e-002f,
    -3.168529e-002f, -3.245680e-002f, -3.322924e-002f, -3.400264e-002f, -3.477588e-002f, -3.554869e-002f,
    -3.632230e-002f, -3.709553e-002f, -3.786996e-002f, -3.864972e-002f, -3.944912e-002f, -4.024791e-002f,
    -4.104873e-002f, -4.185212e-002f, -4.265380e-002f, -4.345909e-002f, -4.426347e-002f, -4.506652e-002f,
    -4.586677e-002f, -4.666974e-002f, -4.749296e-002f, -4.831592e-002f, -4.913525e-002f, -4.995770e-002f,
    -5.078286e-002f, -5.160197e-002f, -5.242122e-002f, -5.323735e-002f, -5.404900e-002f, -5.485658e-002f,
    -5.567221e-002f, -5.648935e-002f, -5.730473e-002f, -5.811605e-002f, -5.892537e-002f, -5.972585e-002f,
    -6.052435e-002f, -6.131953e-002f, -6.210712e-002f, -6.288800e-002f, -6.366737e-002f, -6.444464e-002f,
    -6.521699e-002f, -6.598779e-002f, -6.675729e-002f, -6.751857e-002f, -6.827863e-002f, -6.902994e-002f,
    -6.977257e-002f, -7.051074e-002f, -7.123471e-002f, -7.194008e-002f, -7.264710e-002f, -7.334053e-002f,
    -7.402887e-002f, -7.471274e-002f, -7.539262e-002f, -7.607043e-002f, -7.672512e-002f, -7.736703e-002f,
    -7.799883e-002f, -7.859128e-002f, -7.916153e-002f, -7.970872e-002f, -8.023127e-002f, -8.071652e-002f,
    -8.117552e-002f, -8.161300e-002f, -8.202531e-002f, -8.244722e-002f, -8.285887e-002f, -8.320079e-002f,
    -8.351897e-002f, -8.378219e-002f, -8.401684e-002f, -8.422844e-002f, -8.442230e-002f, -8.459404e-002f,
    -8.471103e-002f, -8.468607e-002f, -8.432258e-002f, -8.403595e-002f, -8.378662e-002f, -8.346766e-002f,
    -8.314768e-002f, -8.278308e-002f, -8.236903e-002f, -8.184399e-002f, -8.119819e-002f, -8.046697e-002f,
    -7.966105e-002f, -7.533033e-002f, -7.419390e-002f, -7.321201e-002f, -7.215726e-002f, -7.100417e-002f,
    -6.984035e-002f, -6.859966e-002f, -6.718541e-002f, -6.555212e-002f, -6.358785e-002f, -5.725615e-002f,
    -4.660865e-002f, -4.258397e-002f, -3.927632e-002f, -3.603078e-002f, -3.204807e-002f, -1.945943e-002f,
    -1.376409e-002f, -8.588147e-003f, -4.240431e-003f, 0.000000e+000f};

const float hInv4[1024] = {
    0.000000e+000f,  -3.778279e-003f, -6.786376e-003f, -9.305227e-003f, -1.146437e-002f, -1.335215e-002f,
    -1.503918e-002f, -1.656443e-002f, -1.795737e-002f, -1.927228e-002f, -2.049997e-002f, -2.166384e-002f,
    -2.275593e-002f, -2.377559e-002f, -2.473027e-002f, -2.562439e-002f, -2.645844e-002f, -2.723503e-002f,
    -2.795514e-002f, -2.862921e-002f, -2.925882e-002f, -2.986054e-002f, -3.043680e-002f, -3.098096e-002f,
    -3.149602e-002f, -3.198254e-002f, -3.244185e-002f, -3.287617e-002f, -3.328632e-002f, -3.367069e-002f,
    -3.403109e-002f, -3.437539e-002f, -3.471309e-002f, -3.503462e-002f, -3.534025e-002f, -3.563049e-002f,
    -3.590648e-002f, -3.616836e-002f, -3.641770e-002f, -3.665554e-002f, -3.688275e-002f, -3.710044e-002f,
    -3.731963e-002f, -3.752959e-002f, -3.773055e-002f, -3.792154e-002f, -3.810049e-002f, -3.826385e-002f,
    -3.842028e-002f, -3.857853e-002f, -3.873136e-002f, -3.887740e-002f, -3.902315e-002f, -3.916298e-002f,
    -3.929706e-002f, -3.942464e-002f, -3.954672e-002f, -3.966221e-002f, -3.977213e-002f, -3.987679e-002f,
    -3.997667e-002f, -4.007119e-002f, -4.016473e-002f, -4.025457e-002f, -4.033815e-002f, -4.041639e-002f,
    -4.048804e-002f, -4.055275e-002f, -4.061056e-002f, -4.066069e-002f, -4.070341e-002f, -4.073849e-002f,
    -4.076647e-002f, -4.078798e-002f, -4.080105e-002f, -4.080581e-002f, -4.080122e-002f, -4.078796e-002f,
    -4.076755e-002f, -4.074489e-002f, -4.072293e-002f, -4.070347e-002f, -4.068556e-002f, -4.067113e-002f,
    -4.065914e-002f, -4.064936e-002f, -4.064094e-002f, -4.063291e-002f, -4.062728e-002f, -4.062356e-002f,
    -4.062129e-002f, -4.061951e-002f, -4.061845e-002f, -4.061581e-002f, -4.061126e-002f, -4.060528e-002f,
    -4.059728e-002f, -4.058678e-002f, -4.057251e-002f, -4.055510e-002f, -4.053355e-002f, -4.050791e-002f,
    -4.047722e-002f, -4.043970e-002f, -4.039611e-002f, -4.034732e-002f, -4.029268e-002f, -4.023342e-002f,
    -4.016961e-002f, -4.009870e-002f, -4.002226e-002f, -3.993963e-002f, -3.985184e-002f, -3.975855e-002f,
    -3.965877e-002f, -3.955583e-002f, -3.944882e-002f, -3.933742e-002f, -3.922167e-002f, -3.910243e-002f,
    -3.898025e-002f, -3.885630e-002f, -3.873339e-002f, -3.861230e-002f, -3.849282e-002f, -3.837921e-002f,
    -3.826981e-002f, -3.816366e-002f, -3.806035e-002f, -3.795891e-002f, -3.785762e-002f, -3.775618e-002f,
    -3.765372e-002f, -3.754939e-002f, -3.743724e-002f, -3.732328e-002f, -3.720648e-002f, -3.708665e-002f,
    -3.696350e-002f, -3.683761e-002f, -3.670773e-002f, -3.657465e-002f, -3.643898e-002f, -3.630097e-002f,
    -3.615454e-002f, -3.600468e-002f, -3.585407e-002f, -3.570336e-002f, -3.555241e-002f, -3.540270e-002f,
    -3.525445e-002f, -3.510735e-002f, -3.496037e-002f, -3.481558e-002f, -3.466761e-002f, -3.451752e-002f,
    -3.436860e-002f, -3.422294e-002f, -3.407909e-002f, -3.393714e-002f, -3.379553e-002f, -3.365411e-002f,
    -3.351250e-002f, -3.337086e-002f, -3.322462e-002f, -3.307061e-002f, -3.291406e-002f, -3.275470e-002f,
    -3.258993e-002f, -3.242004e-002f, -3.224683e-002f, -3.207156e-002f, -3.189502e-002f, -3.171721e-002f,
    -3.153787e-002f, -3.134765e-002f, -3.115390e-002f, -3.095620e-002f, -3.075535e-002f, -3.055249e-002f,
    -3.034935e-002f, -3.014740e-002f, -2.994889e-002f, -2.975657e-002f, -2.956913e-002f, -2.937579e-002f,
    -2.918342e-002f, -2.899210e-002f, -2.880221e-002f, -2.861228e-002f, -2.842260e-002f, -2.823329e-002f,
    -2.804370e-002f, -2.785353e-002f, -2.766238e-002f, -2.746323e-002f, -2.725889e-002f, -2.705256e-002f,
    -2.684487e-002f, -2.663572e-002f, -2.642563e-002f, -2.621417e-002f, -2.600079e-002f, -2.578586e-002f,
    -2.556915e-002f, -2.534612e-002f, -2.511226e-002f, -2.487396e-002f, -2.463040e-002f, -2.438355e-002f,
    -2.413528e-002f, -2.388760e-002f, -2.364143e-002f, -2.339698e-002f, -2.315466e-002f, -2.291105e-002f,
    -2.265831e-002f, -2.240438e-002f, -2.214980e-002f, -2.189457e-002f, -2.164068e-002f, -2.139037e-002f,
    -2.114575e-002f, -2.090801e-002f, -2.067663e-002f, -2.044984e-002f, -2.021510e-002f, -1.998235e-002f,
    -1.975166e-002f, -1.952281e-002f, -1.929543e-002f, -1.906901e-002f, -1.884372e-002f, -1.862016e-002f,
    -1.839793e-002f, -1.817734e-002f, -1.794902e-002f, -1.771818e-002f, -1.748761e-002f, -1.725687e-002f,
    -1.702580e-002f, -1.679363e-002f, -1.656042e-002f, -1.632509e-002f, -1.608786e-002f, -1.584773e-002f,
    -1.559841e-002f, -1.533764e-002f, -1.507097e-002f, -1.479962e-002f, -1.452627e-002f, -1.425381e-002f,
    -1.398337e-002f, -1.371665e-002f, -1.345292e-002f, -1.319278e-002f, -1.293273e-002f, -1.266685e-002f,
    -1.240360e-002f, -1.214321e-002f, -1.188608e-002f, -1.163218e-002f, -1.138398e-002f, -1.114070e-002f,
    -1.090141e-002f, -1.066518e-002f, -1.043167e-002f, -1.018890e-002f, -9.947636e-003f, -9.707482e-003f,
    -9.467606e-003f, -9.227907e-003f, -8.988176e-003f, -8.747325e-003f, -8.504651e-003f, -8.259597e-003f,
    -8.010941e-003f, -7.751194e-003f, -7.487530e-003f, -7.222049e-003f, -6.955965e-003f, -6.689267e-003f,
    -6.421473e-003f, -6.152446e-003f, -5.881950e-003f, -5.610049e-003f, -5.337010e-003f, -5.056806e-003f,
    -4.773926e-003f, -4.495110e-003f, -4.222550e-003f, -3.957375e-003f, -3.699009e-003f, -3.445065e-003f,
    -3.195864e-003f, -2.949634e-003f, -2.706695e-003f, -2.463269e-003f, -2.215863e-003f, -1.970884e-003f,
    -1.727762e-003f, -1.485847e-003f, -1.244941e-003f, -1.004227e-003f, -7.631903e-004f, -5.225846e-004f,
    -2.824247e-004f, -4.058919e-005f, 2.088256e-004f,  4.579873e-004f,  7.083758e-004f,  9.599893e-004f,
    1.213376e-003f,  1.469624e-003f,  1.729799e-003f,  1.994671e-003f,  2.264396e-003f,  2.537229e-003f,
    2.819314e-003f,  3.102117e-003f,  3.383547e-003f,  3.663172e-003f,  3.941704e-003f,  4.220204e-003f,
    4.498431e-003f,  4.775988e-003f,  5.053130e-003f,  5.328684e-003f,  5.607015e-003f,  5.884909e-003f,
    6.157092e-003f,  6.424691e-003f,  6.687545e-003f,  6.947930e-003f,  7.205827e-003f,  7.461321e-003f,
    7.715465e-003f,  7.968929e-003f,  8.224624e-003f,  8.484386e-003f,  8.744709e-003f,  9.005815e-003f,
    9.268433e-003f,  9.533049e-003f,  9.799401e-003f,  1.006873e-002f,  1.034145e-002f,  1.061917e-002f,
    1.090187e-002f,  1.119417e-002f,  1.149068e-002f,  1.178929e-002f,  1.208710e-002f,  1.237983e-002f,
    1.266487e-002f,  1.294242e-002f,  1.321323e-002f,  1.347745e-002f,  1.373491e-002f,  1.399231e-002f,
    1.424472e-002f,  1.449267e-002f,  1.473638e-002f,  1.497507e-002f,  1.521069e-002f,  1.544412e-002f,
    1.567557e-002f,  1.590417e-002f,  1.613019e-002f,  1.635811e-002f,  1.658504e-002f,  1.681039e-002f,
    1.703417e-002f,  1.725669e-002f,  1.747816e-002f,  1.769793e-002f,  1.791665e-002f,  1.813553e-002f,
    1.835449e-002f,  1.857572e-002f,  1.879873e-002f,  1.902092e-002f,  1.924127e-002f,  1.946022e-002f,
    1.967725e-002f,  1.989383e-002f,  2.010889e-002f,  2.032180e-002f,  2.053218e-002f,  2.074033e-002f,
    2.094727e-002f,  2.114976e-002f,  2.134810e-002f,  2.154276e-002f,  2.173464e-002f,  2.192419e-002f,
    2.211184e-002f,  2.229833e-002f,  2.248210e-002f,  2.266389e-002f,  2.284829e-002f,  2.303042e-002f,
    2.321075e-002f,  2.339011e-002f,  2.356888e-002f,  2.374685e-002f,  2.392377e-002f,  2.410171e-002f,
    2.428013e-002f,  2.445969e-002f,  2.464310e-002f,  2.482880e-002f,  2.501589e-002f,  2.520466e-002f,
    2.539466e-002f,  2.558473e-002f,  2.577512e-002f,  2.596579e-002f,  2.615712e-002f,  2.634738e-002f,
    2.653747e-002f,  2.672515e-002f,  2.690960e-002f,  2.709133e-002f,  2.727007e-002f,  2.744684e-002f,
    2.762048e-002f,  2.779108e-002f,  2.795816e-002f,  2.812039e-002f,  2.827889e-002f,  2.843507e-002f,
    2.858845e-002f,  2.873918e-002f,  2.888721e-002f,  2.903349e-002f,  2.917947e-002f,  2.932488e-002f,
    2.946949e-002f,  2.961416e-002f,  2.976193e-002f,  2.991529e-002f,  3.007295e-002f,  3.023333e-002f,
    3.039424e-002f,  3.055355e-002f,  3.071090e-002f,  3.086741e-002f,  3.102406e-002f,  3.118197e-002f,
    3.134134e-002f,  3.150632e-002f,  3.167296e-002f,  3.184051e-002f,  3.200591e-002f,  3.216559e-002f,
    3.231644e-002f,  3.245866e-002f,  3.259443e-002f,  3.272530e-002f,  3.285083e-002f,  3.297491e-002f,
    3.309552e-002f,  3.321129e-002f,  3.332461e-002f,  3.343451e-002f,  3.354172e-002f,  3.364481e-002f,
    3.374538e-002f,  3.384330e-002f,  3.393852e-002f,  3.403254e-002f,  3.412545e-002f,  3.421600e-002f,
    3.430281e-002f,  3.438603e-002f,  3.446546e-002f,  3.454220e-002f,  3.461640e-002f,  3.468709e-002f,
    3.475510e-002f,  3.482058e-002f,  3.488620e-002f,  3.494951e-002f,  3.501130e-002f,  3.507118e-002f,
    3.513017e-002f,  3.518758e-002f,  3.524496e-002f,  3.530133e-002f,  3.535658e-002f,  3.541029e-002f,
    3.546530e-002f,  3.552015e-002f,  3.557269e-002f,  3.562289e-002f,  3.567232e-002f,  3.572066e-002f,
    3.576720e-002f,  3.581137e-002f,  3.585158e-002f,  3.588632e-002f,  3.591873e-002f,  3.594815e-002f,
    3.597272e-002f,  3.599178e-002f,  3.600564e-002f,  3.601334e-002f,  3.601588e-002f,  3.601235e-002f,
    3.600455e-002f,  3.599313e-002f,  3.598049e-002f,  3.596644e-002f,  3.595112e-002f,  3.593366e-002f,
    3.591373e-002f,  3.589394e-002f,  3.587401e-002f,  3.585543e-002f,  3.583887e-002f,  3.582519e-002f,
    3.581472e-002f,  3.580629e-002f,  3.579381e-002f,  3.577553e-002f,  3.575036e-002f,  3.571467e-002f,
    3.566920e-002f,  3.561397e-002f,  3.555059e-002f,  3.547879e-002f,  3.539771e-002f,  3.531256e-002f,
    3.521788e-002f,  3.511371e-002f,  3.500000e-002f,  3.487890e-002f,  3.475106e-002f,  3.461671e-002f,
    3.447704e-002f,  3.433351e-002f,  3.418622e-002f,  3.404142e-002f,  3.389589e-002f,  3.374873e-002f,
    3.359978e-002f,  3.345138e-002f,  3.330475e-002f,  3.316183e-002f,  3.301949e-002f,  3.287904e-002f,
    3.274005e-002f,  3.260503e-002f,  3.247271e-002f,  3.234054e-002f,  3.220715e-002f,  3.207431e-002f,
    3.194163e-002f,  3.181024e-002f,  3.167968e-002f,  3.155125e-002f,  3.142206e-002f,  3.129537e-002f,
    3.117132e-002f,  3.104506e-002f,  3.091577e-002f,  3.078345e-002f,  3.064711e-002f,  3.050877e-002f,
    3.036833e-002f,  3.022656e-002f,  3.008333e-002f,  2.993928e-002f,  2.980142e-002f,  2.966119e-002f,
    2.951746e-002f,  2.937187e-002f,  2.922562e-002f,  2.907754e-002f,  2.892724e-002f,  2.877700e-002f,
    2.862645e-002f,  2.847513e-002f,  2.833268e-002f,  2.819198e-002f,  2.805166e-002f,  2.791404e-002f,
    2.778043e-002f,  2.765126e-002f,  2.752608e-002f,  2.740240e-002f,  2.727615e-002f,  2.714497e-002f,
    2.701512e-002f,  2.688412e-002f,  2.674930e-002f,  2.660927e-002f,  2.646620e-002f,  2.632217e-002f,
    2.617570e-002f,  2.602662e-002f,  2.587258e-002f,  2.571193e-002f,  2.554786e-002f,  2.538503e-002f,
    2.521658e-002f,  2.504415e-002f,  2.486729e-002f,  2.468660e-002f,  2.450211e-002f,  2.431411e-002f,
    2.412415e-002f,  2.393243e-002f,  2.374165e-002f,  2.355967e-002f,  2.337595e-002f,  2.319129e-002f,
    2.300602e-002f,  2.282144e-002f,  2.263715e-002f,  2.245256e-002f,  2.226703e-002f,  2.208080e-002f,
    2.188962e-002f,  2.170272e-002f,  2.150401e-002f,  2.129037e-002f,  2.106234e-002f,  2.081796e-002f,
    2.056065e-002f,  2.029051e-002f,  2.000564e-002f,  1.970785e-002f,  1.939921e-002f,  1.908967e-002f,
    1.877302e-002f,  1.844759e-002f,  1.811245e-002f,  1.776782e-002f,  1.741628e-002f,  1.705827e-002f,
    1.669040e-002f,  1.631598e-002f,  1.593677e-002f,  1.556193e-002f,  1.518988e-002f,  1.481252e-002f,
    1.443024e-002f,  1.404298e-002f,  1.365170e-002f,  1.325897e-002f,  1.286554e-002f,  1.247225e-002f,
    1.207856e-002f,  1.169218e-002f,  1.132497e-002f,  1.096137e-002f,  1.059795e-002f,  1.023831e-002f,
    9.880217e-003f,  9.523918e-003f,  9.170284e-003f,  8.821918e-003f,  8.476080e-003f,  8.134338e-003f,
    7.813432e-003f,  7.490492e-003f,  7.165004e-003f,  6.832579e-003f,  6.492566e-003f,  6.141795e-003f,
    5.782214e-003f,  5.415402e-003f,  5.039957e-003f,  4.660200e-003f,  4.294224e-003f,  3.927508e-003f,
    3.556450e-003f,  3.181603e-003f,  2.802940e-003f,  2.420006e-003f,  2.034341e-003f,  1.645073e-003f,
    1.253660e-003f,  8.571973e-004f,  4.747085e-004f,  1.021895e-004f,  -2.733159e-004f, -6.490595e-004f,
    -1.025983e-003f, -1.404754e-003f, -1.785844e-003f, -2.166046e-003f, -2.545054e-003f, -2.920506e-003f,
    -3.281447e-003f, -3.622679e-003f, -3.962294e-003f, -4.303671e-003f, -4.649887e-003f, -4.997182e-003f,
    -5.347716e-003f, -5.701594e-003f, -6.059682e-003f, -6.417756e-003f, -6.773829e-003f, -7.105894e-003f,
    -7.444165e-003f, -7.789014e-003f, -8.142199e-003f, -8.501984e-003f, -8.868333e-003f, -9.240628e-003f,
    -9.619499e-003f, -1.000216e-002f, -1.038806e-002f, -1.074392e-002f, -1.109773e-002f, -1.145422e-002f,
    -1.181540e-002f, -1.217650e-002f, -1.253541e-002f, -1.289335e-002f, -1.325066e-002f, -1.360607e-002f,
    -1.396207e-002f, -1.429384e-002f, -1.461788e-002f, -1.494387e-002f, -1.526627e-002f, -1.559258e-002f,
    -1.591848e-002f, -1.624901e-002f, -1.658510e-002f, -1.692640e-002f, -1.727298e-002f, -1.760473e-002f,
    -1.791894e-002f, -1.823932e-002f, -1.856727e-002f, -1.890077e-002f, -1.924063e-002f, -1.958724e-002f,
    -1.993984e-002f, -2.030038e-002f, -2.066603e-002f, -2.102580e-002f, -2.135140e-002f, -2.167948e-002f,
    -2.201023e-002f, -2.234486e-002f, -2.268429e-002f, -2.302581e-002f, -2.336487e-002f, -2.370174e-002f,
    -2.403963e-002f, -2.438464e-002f, -2.468537e-002f, -2.499296e-002f, -2.530747e-002f, -2.563513e-002f,
    -2.597161e-002f, -2.631502e-002f, -2.666266e-002f, -2.701296e-002f, -2.737040e-002f, -2.773330e-002f,
    -2.806068e-002f, -2.838371e-002f, -2.871775e-002f, -2.905858e-002f, -2.940521e-002f, -2.975703e-002f,
    -3.011314e-002f, -3.047322e-002f, -3.083481e-002f, -3.120337e-002f, -3.154174e-002f, -3.184960e-002f,
    -3.215853e-002f, -3.246662e-002f, -3.277743e-002f, -3.308532e-002f, -3.339424e-002f, -3.370158e-002f,
    -3.400935e-002f, -3.431619e-002f, -3.460076e-002f, -3.483435e-002f, -3.507512e-002f, -3.531981e-002f,
    -3.557086e-002f, -3.583204e-002f, -3.609830e-002f, -3.637111e-002f, -3.664899e-002f, -3.693739e-002f,
    -3.722864e-002f, -3.745590e-002f, -3.769140e-002f, -3.793261e-002f, -3.817856e-002f, -3.842905e-002f,
    -3.868603e-002f, -3.895068e-002f, -3.921906e-002f, -3.949457e-002f, -3.977421e-002f, -3.998629e-002f,
    -4.018775e-002f, -4.038910e-002f, -4.060019e-002f, -4.081298e-002f, -4.102751e-002f, -4.124583e-002f,
    -4.146780e-002f, -4.169144e-002f, -4.191705e-002f, -4.208992e-002f, -4.222661e-002f, -4.236221e-002f,
    -4.249943e-002f, -4.263342e-002f, -4.277061e-002f, -4.290645e-002f, -4.304704e-002f, -4.319248e-002f,
    -4.334020e-002f, -4.345690e-002f, -4.351198e-002f, -4.357233e-002f, -4.363041e-002f, -4.369060e-002f,
    -4.375327e-002f, -4.381826e-002f, -4.389215e-002f, -4.397413e-002f, -4.406673e-002f, -4.414843e-002f,
    -4.414210e-002f, -4.414140e-002f, -4.414826e-002f, -4.416194e-002f, -4.417435e-002f, -4.419210e-002f,
    -4.421092e-002f, -4.423286e-002f, -4.425444e-002f, -4.427900e-002f, -4.419100e-002f, -4.409243e-002f,
    -4.399721e-002f, -4.390398e-002f, -4.380575e-002f, -4.370322e-002f, -4.360344e-002f, -4.350542e-002f,
    -4.340950e-002f, -4.331944e-002f, -4.314580e-002f, -4.293684e-002f, -4.273682e-002f, -4.254710e-002f,
    -4.236491e-002f, -4.219374e-002f, -4.203339e-002f, -4.187979e-002f, -4.173122e-002f, -4.159195e-002f,
    -4.140052e-002f, -4.113887e-002f, -4.088439e-002f, -4.063536e-002f, -4.038995e-002f, -4.014413e-002f,
    -3.990019e-002f, -3.966431e-002f, -3.943176e-002f, -3.919557e-002f, -3.892895e-002f, -3.854901e-002f,
    -3.817390e-002f, -3.779922e-002f, -3.742891e-002f, -3.706369e-002f, -3.669877e-002f, -3.634091e-002f,
    -3.598140e-002f, -3.561627e-002f, -3.525173e-002f, -3.473044e-002f, -3.420338e-002f, -3.368344e-002f,
    -3.315862e-002f, -3.263199e-002f, -3.211346e-002f, -3.160120e-002f, -3.108926e-002f, -3.057891e-002f,
    -3.006655e-002f, -2.943242e-002f, -2.876613e-002f, -2.810458e-002f, -2.745152e-002f, -2.680560e-002f,
    -2.616883e-002f, -2.553842e-002f, -2.491822e-002f, -2.430788e-002f, -2.369176e-002f, -2.299806e-002f,
    -2.223044e-002f, -2.146536e-002f, -2.070532e-002f, -1.994321e-002f, -1.919159e-002f, -1.844348e-002f,
    -1.769618e-002f, -1.695097e-002f, -1.620312e-002f, -1.541079e-002f, -1.449686e-002f, -1.358570e-002f,
    -1.267635e-002f, -1.177188e-002f, -1.087594e-002f, -9.972071e-003f, -9.075723e-003f, -8.186147e-003f,
    -7.298838e-003f, -6.403344e-003f, -5.335510e-003f, -4.277439e-003f, -3.222898e-003f, -2.171006e-003f,
    -1.107659e-003f, -4.540933e-005f, 1.033960e-003f,  2.115767e-003f,  3.193851e-003f,  4.272948e-003f,
    5.500896e-003f,  6.763265e-003f,  8.021898e-003f,  9.281093e-003f,  1.053455e-002f,  1.178868e-002f,
    1.305516e-002f,  1.432125e-002f,  1.557356e-002f,  1.680887e-002f,  1.814650e-002f,  1.954310e-002f,
    2.094075e-002f,  2.235043e-002f,  2.375893e-002f,  2.515883e-002f,  2.655285e-002f,  2.793617e-002f,
    2.929203e-002f,  3.063485e-002f,  3.202690e-002f,  3.349920e-002f,  3.495898e-002f,  3.640019e-002f,
    3.783443e-002f,  3.927635e-002f,  4.071000e-002f,  4.214031e-002f,  4.353427e-002f,  4.490859e-002f,
    4.629790e-002f,  4.782648e-002f,  4.932651e-002f,  5.078565e-002f,  5.221646e-002f,  5.359495e-002f,
    5.494292e-002f,  5.627183e-002f,  5.757462e-002f,  5.888570e-002f,  6.021349e-002f,  6.165751e-002f,
    6.310311e-002f,  6.453080e-002f,  6.597170e-002f,  6.743673e-002f,  6.893331e-002f,  7.038959e-002f,
    7.177035e-002f,  7.300503e-002f,  7.394534e-002f,  7.511746e-002f,  7.642173e-002f,  7.758371e-002f,
    7.865834e-002f,  7.954943e-002f,  8.028040e-002f,  8.079938e-002f,  8.113260e-002f,  8.136380e-002f,
    8.145903e-002f,  7.854080e-002f,  7.841114e-002f,  7.834592e-002f,  7.813521e-002f,  7.777400e-002f,
    7.745587e-002f,  7.708642e-002f,  7.650118e-002f,  7.566620e-002f,  7.440254e-002f,  6.815737e-002f,
    5.930303e-002f,  5.581550e-002f,  5.273708e-002f,  4.957380e-002f,  4.519876e-002f,  2.620510e-002f,
    1.889050e-002f,  1.221843e-002f,  6.258578e-003f,  0.000000e+000f};

const float hInv5[1024] = {
    0.000000e+000f,  -2.360896e-003f, -4.274943e-003f, -5.905649e-003f, -7.368838e-003f, -8.715672e-003f,
    -9.986865e-003f, -1.127152e-002f, -1.255103e-002f, -1.401107e-002f, -1.540896e-002f, -1.661416e-002f,
    -1.776548e-002f, -1.887420e-002f, -1.992056e-002f, -2.089192e-002f, -2.177797e-002f, -2.255967e-002f,
    -2.323417e-002f, -2.385498e-002f, -2.443536e-002f, -2.494330e-002f, -2.538212e-002f, -2.579366e-002f,
    -2.618314e-002f, -2.655469e-002f, -2.691086e-002f, -2.725425e-002f, -2.758442e-002f, -2.790527e-002f,
    -2.821810e-002f, -2.850432e-002f, -2.874125e-002f, -2.897076e-002f, -2.919356e-002f, -2.941006e-002f,
    -2.962066e-002f, -2.982512e-002f, -3.002458e-002f, -3.021412e-002f, -3.039782e-002f, -3.057600e-002f,
    -3.071039e-002f, -3.085683e-002f, -3.101921e-002f, -3.120300e-002f, -3.146204e-002f, -3.188786e-002f,
    -3.229566e-002f, -3.250488e-002f, -3.264314e-002f, -3.276630e-002f, -3.283809e-002f, -3.289057e-002f,
    -3.293160e-002f, -3.296372e-002f, -3.298658e-002f, -3.300410e-002f, -3.301314e-002f, -3.301770e-002f,
    -3.301732e-002f, -3.301279e-002f, -3.298054e-002f, -3.292965e-002f, -3.287543e-002f, -3.281661e-002f,
    -3.275425e-002f, -3.268864e-002f, -3.261840e-002f, -3.254792e-002f, -3.247575e-002f, -3.240479e-002f,
    -3.231332e-002f, -3.219677e-002f, -3.207115e-002f, -3.193980e-002f, -3.180072e-002f, -3.165655e-002f,
    -3.150798e-002f, -3.136203e-002f, -3.122037e-002f, -3.108775e-002f, -3.095780e-002f, -3.081271e-002f,
    -3.067594e-002f, -3.054767e-002f, -3.042727e-002f, -3.031475e-002f, -3.021188e-002f, -3.012629e-002f,
    -3.005729e-002f, -3.000457e-002f, -2.996459e-002f, -2.991192e-002f, -2.986609e-002f, -2.982627e-002f,
    -2.979014e-002f, -2.975685e-002f, -2.972446e-002f, -2.969059e-002f, -2.965303e-002f, -2.961156e-002f,
    -2.956256e-002f, -2.948764e-002f, -2.939490e-002f, -2.928878e-002f, -2.916809e-002f, -2.903948e-002f,
    -2.890468e-002f, -2.876563e-002f, -2.862065e-002f, -2.846906e-002f, -2.831303e-002f, -2.814246e-002f,
    -2.795660e-002f, -2.776824e-002f, -2.757558e-002f, -2.737743e-002f, -2.717653e-002f, -2.697106e-002f,
    -2.676146e-002f, -2.655060e-002f, -2.633791e-002f, -2.612573e-002f, -2.590844e-002f, -2.569521e-002f,
    -2.548775e-002f, -2.528486e-002f, -2.508429e-002f, -2.488695e-002f, -2.469060e-002f, -2.449273e-002f,
    -2.429495e-002f, -2.409691e-002f, -2.388210e-002f, -2.366506e-002f, -2.344623e-002f, -2.322420e-002f,
    -2.299895e-002f, -2.277070e-002f, -2.253783e-002f, -2.230124e-002f, -2.206187e-002f, -2.181865e-002f,
    -2.156294e-002f, -2.130231e-002f, -2.104026e-002f, -2.077838e-002f, -2.051815e-002f, -2.025831e-002f,
    -2.000006e-002f, -1.974314e-002f, -1.948838e-002f, -1.923539e-002f, -1.897857e-002f, -1.871924e-002f,
    -1.846154e-002f, -1.820525e-002f, -1.795018e-002f, -1.769669e-002f, -1.744302e-002f, -1.718785e-002f,
    -1.693206e-002f, -1.667613e-002f, -1.641509e-002f, -1.614473e-002f, -1.587220e-002f, -1.559493e-002f,
    -1.531124e-002f, -1.502021e-002f, -1.472502e-002f, -1.442649e-002f, -1.412617e-002f, -1.382395e-002f,
    -1.352061e-002f, -1.320828e-002f, -1.289145e-002f, -1.256965e-002f, -1.224447e-002f, -1.191597e-002f,
    -1.158634e-002f, -1.125793e-002f, -1.093432e-002f, -1.061726e-002f, -1.030640e-002f, -9.993893e-003f,
    -9.682586e-003f, -9.373169e-003f, -9.066173e-003f, -8.760538e-003f, -8.455617e-003f, -8.151591e-003f,
    -7.847199e-003f, -7.543073e-003f, -7.237269e-003f, -6.928794e-003f, -6.617495e-003f, -6.305938e-003f,
    -5.993645e-003f, -5.679285e-003f, -5.364366e-003f, -5.048492e-003f, -4.731993e-003f, -4.414662e-003f,
    -4.095669e-003f, -3.774429e-003f, -3.446633e-003f, -3.114165e-003f, -2.776847e-003f, -2.437561e-003f,
    -2.099448e-003f, -1.764101e-003f, -1.432330e-003f, -1.104074e-003f, -7.790922e-004f, -4.543868e-004f,
    -1.275020e-004f, 2.002446e-004f,  5.283561e-004f,  8.574387e-004f,  1.185628e-003f,  1.510524e-003f,
    1.830254e-003f,  2.141882e-003f,  2.447411e-003f,  2.747272e-003f,  3.044848e-003f,  3.338406e-003f,
    3.629571e-003f,  3.919979e-003f,  4.208891e-003f,  4.496244e-003f,  4.781103e-003f,  5.064221e-003f,
    5.345375e-003f,  5.624560e-003f,  5.900758e-003f,  6.175870e-003f,  6.450757e-003f,  6.726506e-003f,
    7.002304e-003f,  7.277071e-003f,  7.552118e-003f,  7.828428e-003f,  8.105385e-003f,  8.384147e-003f,
    8.664888e-003f,  8.950609e-003f,  9.243485e-003f,  9.542554e-003f,  9.841377e-003f,  1.013791e-002f,
    1.043041e-002f,  1.071721e-002f,  1.099986e-002f,  1.127745e-002f,  1.154890e-002f,  1.181582e-002f,
    1.207918e-002f,  1.233816e-002f,  1.259130e-002f,  1.283850e-002f,  1.307568e-002f,  1.330593e-002f,
    1.352991e-002f,  1.374851e-002f,  1.396283e-002f,  1.416982e-002f,  1.437312e-002f,  1.457440e-002f,
    1.477219e-002f,  1.496488e-002f,  1.515135e-002f,  1.533460e-002f,  1.551404e-002f,  1.569097e-002f,
    1.586731e-002f,  1.603821e-002f,  1.620491e-002f,  1.636772e-002f,  1.652547e-002f,  1.667613e-002f,
    1.682034e-002f,  1.695802e-002f,  1.709067e-002f,  1.721987e-002f,  1.734386e-002f,  1.746008e-002f,
    1.756567e-002f,  1.766106e-002f,  1.774322e-002f,  1.781093e-002f,  1.786764e-002f,  1.791514e-002f,
    1.795522e-002f,  1.798977e-002f,  1.801989e-002f,  1.804206e-002f,  1.805476e-002f,  1.806296e-002f,
    1.806841e-002f,  1.807116e-002f,  1.807273e-002f,  1.807456e-002f,  1.807728e-002f,  1.808166e-002f,
    1.808750e-002f,  1.809402e-002f,  1.809617e-002f,  1.810150e-002f,  1.811140e-002f,  1.812623e-002f,
    1.814668e-002f,  1.817493e-002f,  1.821286e-002f,  1.826138e-002f,  1.832033e-002f,  1.838854e-002f,
    1.845877e-002f,  1.853527e-002f,  1.861878e-002f,  1.870843e-002f,  1.880372e-002f,  1.890667e-002f,
    1.901622e-002f,  1.913154e-002f,  1.925391e-002f,  1.938211e-002f,  1.950902e-002f,  1.963660e-002f,
    1.976425e-002f,  1.989111e-002f,  2.001646e-002f,  2.014201e-002f,  2.026922e-002f,  2.039623e-002f,
    2.052702e-002f,  2.066212e-002f,  2.079641e-002f,  2.093092e-002f,  2.107065e-002f,  2.121470e-002f,
    2.136350e-002f,  2.151766e-002f,  2.167667e-002f,  2.184260e-002f,  2.201580e-002f,  2.219621e-002f,
    2.238208e-002f,  2.256652e-002f,  2.275779e-002f,  2.295384e-002f,  2.315021e-002f,  2.334222e-002f,
    2.352593e-002f,  2.370248e-002f,  2.387301e-002f,  2.403658e-002f,  2.419374e-002f,  2.433362e-002f,
    2.446694e-002f,  2.459478e-002f,  2.471821e-002f,  2.483618e-002f,  2.495028e-002f,  2.506116e-002f,
    2.516786e-002f,  2.527170e-002f,  2.537354e-002f,  2.546428e-002f,  2.554905e-002f,  2.563264e-002f,
    2.571565e-002f,  2.579792e-002f,  2.587973e-002f,  2.596072e-002f,  2.604172e-002f,  2.612296e-002f,
    2.620385e-002f,  2.627993e-002f,  2.634934e-002f,  2.641793e-002f,  2.648479e-002f,  2.654848e-002f,
    2.660933e-002f,  2.666906e-002f,  2.672773e-002f,  2.678375e-002f,  2.683798e-002f,  2.688663e-002f,
    2.692371e-002f,  2.695753e-002f,  2.698646e-002f,  2.701216e-002f,  2.703694e-002f,  2.706029e-002f,
    2.708222e-002f,  2.710441e-002f,  2.712650e-002f,  2.714839e-002f,  2.715769e-002f,  2.716565e-002f,
    2.717228e-002f,  2.717899e-002f,  2.718524e-002f,  2.719172e-002f,  2.719880e-002f,  2.720865e-002f,
    2.722124e-002f,  2.723657e-002f,  2.724388e-002f,  2.725178e-002f,  2.726217e-002f,  2.727563e-002f,
    2.728934e-002f,  2.730537e-002f,  2.732247e-002f,  2.733968e-002f,  2.735655e-002f,  2.737263e-002f,
    2.737971e-002f,  2.737885e-002f,  2.737602e-002f,  2.737024e-002f,  2.736166e-002f,  2.735150e-002f,
    2.733956e-002f,  2.732451e-002f,  2.730438e-002f,  2.727793e-002f,  2.724206e-002f,  2.719246e-002f,
    2.713968e-002f,  2.708444e-002f,  2.702614e-002f,  2.696616e-002f,  2.690682e-002f,  2.684817e-002f,
    2.678989e-002f,  2.673148e-002f,  2.667604e-002f,  2.661577e-002f,  2.656029e-002f,  2.650729e-002f,
    2.645613e-002f,  2.640410e-002f,  2.635084e-002f,  2.629706e-002f,  2.624410e-002f,  2.619299e-002f,
    2.614627e-002f,  2.609591e-002f,  2.604961e-002f,  2.600482e-002f,  2.595933e-002f,  2.590764e-002f,
    2.584154e-002f,  2.576003e-002f,  2.566730e-002f,  2.556480e-002f,  2.545335e-002f,  2.532731e-002f,
    2.519074e-002f,  2.504769e-002f,  2.489727e-002f,  2.474134e-002f,  2.458094e-002f,  2.441477e-002f,
    2.424408e-002f,  2.406926e-002f,  2.389065e-002f,  2.370325e-002f,  2.350808e-002f,  2.330940e-002f,
    2.310516e-002f,  2.289756e-002f,  2.268670e-002f,  2.247216e-002f,  2.225307e-002f,  2.203178e-002f,
    2.180787e-002f,  2.158273e-002f,  2.134920e-002f,  2.111582e-002f,  2.088052e-002f,  2.064596e-002f,
    2.041193e-002f,  2.018045e-002f,  1.995076e-002f,  1.972457e-002f,  1.950034e-002f,  1.927617e-002f,
    1.904591e-002f,  1.881836e-002f,  1.859350e-002f,  1.837115e-002f,  1.815161e-002f,  1.793664e-002f,
    1.772397e-002f,  1.751181e-002f,  1.730085e-002f,  1.709166e-002f,  1.687527e-002f,  1.665797e-002f,
    1.644159e-002f,  1.622558e-002f,  1.600662e-002f,  1.578945e-002f,  1.557444e-002f,  1.535957e-002f,
    1.514813e-002f,  1.493803e-002f,  1.472395e-002f,  1.450698e-002f,  1.429042e-002f,  1.407539e-002f,
    1.386222e-002f,  1.365111e-002f,  1.344279e-002f,  1.324022e-002f,  1.304365e-002f,  1.285188e-002f,
    1.266125e-002f,  1.246627e-002f,  1.226600e-002f,  1.206146e-002f,  1.183758e-002f,  1.156838e-002f,
    1.125646e-002f,  1.090574e-002f,  1.051599e-002f,  1.008868e-002f,  9.627202e-003f,  9.128324e-003f,
    8.597165e-003f,  8.035804e-003f,  7.447901e-003f,  6.835471e-003f,  6.202072e-003f,  5.551010e-003f,
    4.884796e-003f,  4.206815e-003f,  3.519273e-003f,  2.818272e-003f,  2.110670e-003f,  1.401120e-003f,
    6.903936e-004f,  -1.638198e-005f, -7.135974e-004f, -1.398900e-003f, -2.074787e-003f, -2.737984e-003f,
    -3.384653e-003f, -4.020880e-003f, -4.640462e-003f, -5.241373e-003f, -5.823547e-003f, -6.383119e-003f,
    -6.919046e-003f, -7.425275e-003f, -7.902649e-003f, -8.346696e-003f, -8.756090e-003f, -9.132169e-003f,
    -9.479906e-003f, -9.791314e-003f, -1.007961e-002f, -1.035880e-002f, -1.063062e-002f, -1.089370e-002f,
    -1.114753e-002f, -1.139318e-002f, -1.163197e-002f, -1.186163e-002f, -1.208560e-002f, -1.230246e-002f,
    -1.251026e-002f, -1.271252e-002f, -1.290469e-002f, -1.308656e-002f, -1.325855e-002f, -1.342436e-002f,
    -1.357860e-002f, -1.372395e-002f, -1.386068e-002f, -1.398954e-002f, -1.410597e-002f, -1.421204e-002f,
    -1.430540e-002f, -1.438351e-002f, -1.444606e-002f, -1.449812e-002f, -1.454279e-002f, -1.458684e-002f,
    -1.463257e-002f, -1.467814e-002f, -1.472142e-002f, -1.476059e-002f, -1.479612e-002f, -1.482843e-002f,
    -1.485531e-002f, -1.487635e-002f, -1.489828e-002f, -1.492339e-002f, -1.495162e-002f, -1.498154e-002f,
    -1.500862e-002f, -1.503822e-002f, -1.506732e-002f, -1.509371e-002f, -1.511928e-002f, -1.514425e-002f,
    -1.516862e-002f, -1.518908e-002f, -1.521013e-002f, -1.522560e-002f, -1.523903e-002f, -1.524846e-002f,
    -1.524989e-002f, -1.524585e-002f, -1.524007e-002f, -1.523235e-002f, -1.521934e-002f, -1.520238e-002f,
    -1.518278e-002f, -1.517016e-002f, -1.516821e-002f, -1.518027e-002f, -1.520240e-002f, -1.523723e-002f,
    -1.528238e-002f, -1.534124e-002f, -1.541303e-002f, -1.549901e-002f, -1.559409e-002f, -1.569997e-002f,
    -1.581460e-002f, -1.594058e-002f, -1.607554e-002f, -1.621647e-002f, -1.636636e-002f, -1.652340e-002f,
    -1.668474e-002f, -1.685008e-002f, -1.702049e-002f, -1.720293e-002f, -1.739779e-002f, -1.760038e-002f,
    -1.780702e-002f, -1.801748e-002f, -1.823522e-002f, -1.845753e-002f, -1.868053e-002f, -1.890412e-002f,
    -1.912907e-002f, -1.935389e-002f, -1.957958e-002f, -1.980122e-002f, -2.001761e-002f, -2.023081e-002f,
    -2.043903e-002f, -2.064446e-002f, -2.084856e-002f, -2.104685e-002f, -2.123686e-002f, -2.142329e-002f,
    -2.161328e-002f, -2.180088e-002f, -2.198794e-002f, -2.217370e-002f, -2.236667e-002f, -2.256801e-002f,
    -2.277625e-002f, -2.299049e-002f, -2.320262e-002f, -2.341636e-002f, -2.363713e-002f, -2.385964e-002f,
    -2.407775e-002f, -2.429353e-002f, -2.450728e-002f, -2.472070e-002f, -2.493195e-002f, -2.513812e-002f,
    -2.533786e-002f, -2.553328e-002f, -2.572258e-002f, -2.590886e-002f, -2.608742e-002f, -2.626136e-002f,
    -2.642732e-002f, -2.658576e-002f, -2.673664e-002f, -2.687400e-002f, -2.699704e-002f, -2.710480e-002f,
    -2.720365e-002f, -2.729421e-002f, -2.737359e-002f, -2.745109e-002f, -2.752881e-002f, -2.761109e-002f,
    -2.769737e-002f, -2.778342e-002f, -2.787029e-002f, -2.795776e-002f, -2.804384e-002f, -2.813663e-002f,
    -2.823293e-002f, -2.833815e-002f, -2.844657e-002f, -2.856556e-002f, -2.869072e-002f, -2.881630e-002f,
    -2.894820e-002f, -2.908186e-002f, -2.921889e-002f, -2.936393e-002f, -2.951308e-002f, -2.966011e-002f,
    -2.982728e-002f, -3.004358e-002f, -3.030748e-002f, -3.061102e-002f, -3.095579e-002f, -3.133872e-002f,
    -3.175770e-002f, -3.221663e-002f, -3.270650e-002f, -3.321987e-002f, -3.375717e-002f, -3.431416e-002f,
    -3.489001e-002f, -3.547975e-002f, -3.608464e-002f, -3.670345e-002f, -3.733331e-002f, -3.797427e-002f,
    -3.862149e-002f, -3.927308e-002f, -3.992326e-002f, -4.057412e-002f, -4.121805e-002f, -4.184837e-002f,
    -4.246811e-002f, -4.306527e-002f, -4.364204e-002f, -4.419689e-002f, -4.472849e-002f, -4.522967e-002f,
    -4.569501e-002f, -4.612203e-002f, -4.650379e-002f, -4.684126e-002f, -4.712785e-002f, -4.735643e-002f,
    -4.752612e-002f, -4.763849e-002f, -4.770748e-002f, -4.771900e-002f, -4.767239e-002f, -4.755962e-002f,
    -4.738832e-002f, -4.719806e-002f, -4.699385e-002f, -4.676563e-002f, -4.652292e-002f, -4.626246e-002f,
    -4.599168e-002f, -4.570958e-002f, -4.542004e-002f, -4.511216e-002f, -4.478959e-002f, -4.444727e-002f,
    -4.408761e-002f, -4.371019e-002f, -4.331740e-002f, -4.290329e-002f, -4.248020e-002f, -4.204135e-002f,
    -4.157690e-002f, -4.108876e-002f, -4.057962e-002f, -4.005352e-002f, -3.950325e-002f, -3.892208e-002f,
    -3.831182e-002f, -3.767926e-002f, -3.703787e-002f, -3.638723e-002f, -3.570871e-002f, -3.500656e-002f,
    -3.428858e-002f, -3.355839e-002f, -3.282371e-002f, -3.207244e-002f, -3.131090e-002f, -3.054011e-002f,
    -2.976208e-002f, -2.898263e-002f, -2.818930e-002f, -2.738675e-002f, -2.657148e-002f, -2.574571e-002f,
    -2.491286e-002f, -2.406676e-002f, -2.321062e-002f, -2.234741e-002f, -2.146643e-002f, -2.058671e-002f,
    -1.969661e-002f, -1.880264e-002f, -1.789329e-002f, -1.697492e-002f, -1.604023e-002f, -1.509356e-002f,
    -1.413334e-002f, -1.316553e-002f, -1.219498e-002f, -1.121350e-002f, -1.022420e-002f, -9.218249e-003f,
    -8.194948e-003f, -7.166028e-003f, -6.118933e-003f, -5.062977e-003f, -4.002526e-003f, -2.938600e-003f,
    -1.874053e-003f, -8.124279e-004f, 2.426266e-004f,  1.299519e-003f,  2.356924e-003f,  3.423349e-003f,
    4.494925e-003f,  5.567379e-003f,  6.637724e-003f,  7.705697e-003f,  8.774098e-003f,  9.833285e-003f,
    1.086581e-002f,  1.189999e-002f,  1.292715e-002f,  1.395299e-002f,  1.497549e-002f,  1.600173e-002f,
    1.703227e-002f,  1.805900e-002f,  1.908315e-002f,  2.011093e-002f,  2.112233e-002f,  2.213348e-002f,
    2.314845e-002f,  2.416172e-002f,  2.517577e-002f,  2.618429e-002f,  2.719920e-002f,  2.821283e-002f,
    2.923392e-002f,  3.025381e-002f,  3.124036e-002f,  3.220577e-002f,  3.316308e-002f,  3.410222e-002f,
    3.502958e-002f,  3.594870e-002f,  3.685940e-002f,  3.774501e-002f,  3.862478e-002f,  3.950079e-002f,
    4.035807e-002f,  4.118645e-002f,  4.201368e-002f,  4.283345e-002f,  4.364499e-002f,  4.444504e-002f,
    4.522483e-002f,  4.600111e-002f,  4.677178e-002f,  4.752748e-002f,  4.826989e-002f,  4.897104e-002f,
    4.966668e-002f,  5.035375e-002f,  5.102643e-002f,  5.169880e-002f,  5.237010e-002f,  5.304156e-002f,
    5.370162e-002f,  5.436628e-002f,  5.501398e-002f,  5.560999e-002f,  5.619190e-002f,  5.677848e-002f,
    5.734037e-002f,  5.788572e-002f,  5.841639e-002f,  5.893213e-002f,  5.943382e-002f,  5.992121e-002f,
    6.039367e-002f,  6.080280e-002f,  6.117986e-002f,  6.150898e-002f,  6.180408e-002f,  6.205528e-002f,
    6.228023e-002f,  6.246853e-002f,  6.263032e-002f,  6.276013e-002f,  6.284891e-002f,  6.287447e-002f,
    6.282524e-002f,  6.272784e-002f,  6.258828e-002f,  6.241053e-002f,  6.222478e-002f,  6.201195e-002f,
    6.177584e-002f,  6.151671e-002f,  6.123411e-002f,  6.090018e-002f,  6.048345e-002f,  6.003673e-002f,
    5.956052e-002f,  5.905527e-002f,  5.853810e-002f,  5.799391e-002f,  5.740801e-002f,  5.679262e-002f,
    5.615924e-002f,  5.548418e-002f,  5.470384e-002f,  5.389553e-002f,  5.305557e-002f,  5.214974e-002f,
    5.116006e-002f,  5.012557e-002f,  4.902787e-002f,  4.785994e-002f,  4.663504e-002f,  4.536721e-002f,
    4.395278e-002f,  4.248978e-002f,  4.099954e-002f,  3.947331e-002f,  3.791131e-002f,  3.633650e-002f,
    3.470608e-002f,  3.305575e-002f,  3.140630e-002f,  2.974680e-002f,  2.798749e-002f,  2.616536e-002f,
    2.434344e-002f,  2.247793e-002f,  2.057273e-002f,  1.865802e-002f,  1.672675e-002f,  1.478296e-002f,
    1.284464e-002f,  1.090682e-002f,  8.908942e-003f,  6.784438e-003f,  4.679112e-003f,  2.573731e-003f,
    4.510803e-004f,  -1.689202e-003f, -3.864831e-003f, -6.055147e-003f, -8.218578e-003f, -1.038528e-002f,
    -1.258716e-002f, -1.503817e-002f, -1.742672e-002f, -1.978906e-002f, -2.213819e-002f, -2.441817e-002f,
    -2.674576e-002f, -2.907635e-002f, -3.139250e-002f, -3.364778e-002f, -3.592420e-002f, -3.835364e-002f,
    -4.077078e-002f, -4.329452e-002f, -4.592237e-002f, -4.866156e-002f, -5.149681e-002f, -5.426273e-002f,
    -5.699712e-002f, -5.989997e-002f, -6.346216e-002f, -6.690931e-002f, -7.034904e-002f, -7.359218e-002f,
    -7.650300e-002f, -7.901830e-002f, -8.141704e-002f, -8.367779e-002f, -8.590537e-002f, -8.815674e-002f,
    -9.019702e-002f, -9.961888e-002f, -1.015927e-001f, -1.026727e-001f, -1.034023e-001f, -1.038345e-001f,
    -1.044770e-001f, -1.051726e-001f, -1.057127e-001f, -1.059350e-001f, -1.060081e-001f, -1.063140e-001f,
    -1.128114e-001f, -1.102135e-001f, -1.078385e-001f, -1.045745e-001f, -9.780112e-002f, -4.743233e-002f,
    -3.300751e-002f, -2.056588e-002f, -1.011251e-002f, 0.000000e+000f};
}  // namespace
}  // namespace Core
}  // namespace VideoStitch

#endif
