if(ANDROID_STL MATCHES "gnustl")
  add_definitions(-DANDROID__GNUSTL)
endif(ANDROID_STL MATCHES "gnustl")

if (BUILD_STATIC_LIB)
  # use .a rather than .so to avoid soname incompatibility with android APK (only .so are installed)
  set (CMAKE_FIND_LIBRARY_SUFFIXES ".a;.so")
endif (BUILD_STATIC_LIB)

find_library(CERES_OPTIMIZED_LIBRARY NAMES "ceres" PATHS ${CMAKE_EXTERNAL_DEPS}/lib NO_DEFAULT_PATH NO_CMAKE_FIND_ROOT_PATH)
if (EXISTS "${CERES_OPTIMIZED_LIBRARY}" AND (CMAKE_BUILD_TYPE STREQUAL "Release"))
  set(CERES_LIBS
      optimized ${CERES_OPTIMIZED_LIBRARY})
else ()
  add_definitions(-DCERESLIB_UNSUPPORTED)
endif ()

find_library(ZLIB_LIBRARY z)
find_library(LOG_LIBRARY log)
set( CMAKE_CXX_CREATE_SHARED_LIBRARY "${CMAKE_CXX_CREATE_SHARED_LIBRARY} ${ZLIB_LIBRARY} ${LOG_LIBRARY} -lgomp")
set( CMAKE_CXX_LINK_EXECUTABLE       "${CMAKE_CXX_LINK_EXECUTABLE} ${LOG_LIBRARY}")
set( CMAKE_CXX_LINK_FLAGS            "${CMAKE_CXX_LINK_FLAGS} -fuse-ld=gold" CACHE STRING "use gold linker")

if (${TARGET_PRODUCT} MATCHES "msm8996")
  if ( ANDROID_TOOLCHAIN_NAME MATCHES aarch64.* )
    set (TARGET_PRODUCTLIB ${ANDROID_NDK}/../../../vendor/qcom/proprietary/prebuilt_HY11/target/product/${TARGET_PRODUCT}/system/vendor/lib64)
  else ()
    set (TARGET_PRODUCTLIB ${ANDROID_NDK}/../../../vendor/qcom/proprietary/prebuilt_HY11/target/product/${TARGET_PRODUCT}/system/vendor/lib)
  endif()
  set (OpenCL_INCLUDE_DIRS ${ANDROID_NDK}/../../../external/opencv3/3rdparty/include/opencl/1.2)
else()
  set (TARGET_PRODUCTLIB ${CMAKE_EXTERNAL_DEPS}/lib)
  set (OpenCL_INCLUDE_DIRS ${CMAKE_EXTERNAL_DEPS}/include)
endif()
find_library(GLES_LIBRARIES GLESv2)
find_library(EGL_LIBRARIES EGL)
set(OpenGL_LIBRARIES ${GLES_LIBRARIES} ${EGL_LIBRARIES})

find_library(GLEW_LIBRARIES_ NAMES GLEW PATHS ${CMAKE_EXTERNAL_DEPS}/lib NO_DEFAULT_PATH NO_CMAKE_FIND_ROOT_PATH)
if(EXISTS "${GLEW_LIBRARIES_}")
  set(GLEW_LIBRARIES ${GLEW_LIBRARIES_})
  add_definitions(-DGLEW_NO_GLU)
  include_directories(SYSTEM "${CMAKE_EXTERNAL_DEPS}/include/GLEW")
else()
  message(WARNING "OpenGL Extension Wrangler Library (GLEW) not found")
  add_definitions(-DGLEWLIB_UNSUPPORTED)
endif()

find_library(OpenCL_LIBRARIES NAMES "OpenCL" PATHS ${TARGET_PRODUCTLIB} NO_DEFAULT_PATH NO_CMAKE_FIND_ROOT_PATH)
if (EXISTS "${OpenCL_LIBRARIES}")
  set (OpenCL_FOUND ON)
endif (EXISTS "${OpenCL_LIBRARIES}")

