/*
 * WSSSH (wsssh) - SSH Wrapper with WebSocket ProxyCommand
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef WSSH_H
#define WSSH_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>

// Configuration structure for wsssh
typedef struct {
    char *client_id;
    char *wssshd_host;
    int wssshd_port;
    int wssshd_port_explicit;  // Flag to track if --wssshd-port was explicitly set
    int debug;
    char *tunnel;
    char *tunnel_control;
    char *enc;
    char *user;
    char *target_host;
    char *ssh_string;
    int remaining_argc;
    char **remaining_argv;
} wsssh_wrapper_config_t;

// Function declarations
void print_wsssh_usage(const char *program_name);
int parse_wsssh_args(int argc, char *argv[], wsssh_wrapper_config_t *config);
int parse_target_string(const char *target, wsssh_wrapper_config_t *config);
char *build_proxy_command(wsssh_wrapper_config_t *config);
char *build_ssh_command(wsssh_wrapper_config_t *config, const char *proxy_command);
int execute_ssh_command(const char *ssh_command, int debug);

#endif // WSSH_H