/*
 * WSSSH Library - WebSocket functions
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef WEBSOCKET_H
#define WEBSOCKET_H

#include <openssl/ssl.h>

// WSSSH version
#define WSSSH_VERSION "1.6.5"

// Function declarations
int websocket_handshake(SSL *ssl, const char *host, int port, const char *path, int debug);
int send_websocket_frame(SSL *ssl, const char *data);
int send_websocket_binary_frame(SSL *ssl, const unsigned char *data, size_t data_len);
int parse_websocket_frame(const char *buffer, int bytes_read, char **payload, int *payload_len);

// Bridge mode transport layer functions
int setup_websocket_connection(const char *host, int port, const char *client_id, int debug, SSL_CTX **ctx_out);
int send_websocket_message(int sock, const char *message, int len, const char *channel, int debug);
int send_pong_frame_ws(int sock, const char *ping_payload, int payload_len);

#endif // WEBSOCKET_H