/*
 * WSSSH Tunnel (wsssht) - C Implementation
 * WebSocket tunnel setup tool for manual connections.
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef WSSSHT_H
#define WSSSHT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <getopt.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <pthread.h>
#include <sys/select.h>

#include "wssshlib.h"
#include "websocket.h"
#include "wssh_ssl.h"
#include "tunnel.h"

// Thread arguments structure for concurrent tunnel handling
typedef struct {
    int accepted_sock;
    wsssh_config_t *config;
    const char *client_id;
    const char *wssshd_host;
    int wssshd_port;
    const char *tunnel_host;
} tunnel_thread_args_t;

// Function declarations
void print_usage(const char *program_name);
int parse_connection_string(const char *conn_str, char **service, char **client_id, char **wssshd_host, int *wssshd_port);
int wsssht_parse_args(int argc, char *argv[], wsssh_config_t *config, int *remaining_argc, char ***remaining_argv);
int run_bridge_mode(wsssh_config_t *config, const char *client_id, const char *wssshd_host, int wssshd_port);
int run_script_mode(wsssh_config_t *config, const char *client_id, const char *wssshd_host, int wssshd_port);
int run_daemon_mode(wsssh_config_t *config, const char *client_id, const char *wssshd_host, int wssshd_port);
int run_pipe_mode(wsssh_config_t *config, const char *client_id, const char *wssshd_host, int wssshd_port);
void *run_tunnel_thread(void *arg);

#endif // WSSSHT_H