/**
 * Embedded web assets implementation for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <string.h>
#include "assets.h"
#include "image_data.h"
#include "favicon_data.h"
#include "html_pages/login_page.h"
#include "html_pages/terminal_page.h"
#include "html_pages/vnc_page.h"
#include "html_pages/xterm_page.h"
#include "html_pages/xterm_addon_page.h"
#include "html_pages/mstsc_page.h"
#include "html_pages/novnc_css_page.h"
#include "novnc_asset_map.c"
#include "rdp_assets.h"
#include "rdp_asset_map.c"

// HTML pages are now defined in separate header files in html_pages/ directory
// This file now only contains fallback definitions for compatibility
const char *index_html = NULL; // Generated dynamically
const char *login_html = NULL; // Now in html_pages/login_page.h
const char *terminal_html = NULL; // Now in html_pages/terminal_page.h
const char *users_html = NULL; // Now in html_pages/users_page.h
const char *vnc_html = NULL; // Now in html_pages/vnc_page.h

// Embedded image from image.jpg (declared in image_data.h)

const char *get_embedded_asset(const char *path, size_t *size) {
    if (size) *size = 0;

    // Note: index.html is generated dynamically in web.c
    if (strcmp(path, "/") == 0 || strcmp(path, "/index.html") == 0) {
        return NULL; // Handled dynamically
    } else if (strcmp(path, "/login") == 0 || strcmp(path, "/login.html") == 0) {
        if (size) *size = strlen(login_page_html);
        return login_page_html;
    } else if (strcmp(path, "/terminal.html") == 0) {
        if (size) *size = strlen(terminal_page_html);
        return terminal_page_html;
    } else if (strcmp(path, "/users.html") == 0) {
        return NULL; // Handled dynamically
    } else if (strcmp(path, "/image.jpg") == 0) {
        if (size) *size = image_jpg_len;
        return (const char *)image_jpg;
    } else if (strcmp(path, "/favicon.ico") == 0) {
        if (size) *size = favicon_ico_len;
        return (const char *)favicon_ico;
    } else if (strcmp(path, "/xterm.js") == 0) {
        if (size) *size = strlen(xterm_js);
        return xterm_js;
    } else if (strcmp(path, "/xterm-addon-fit.js") == 0) {
        if (size) *size = strlen(xterm_addon_fit_js);
        return xterm_addon_fit_js;
    } else if (strcmp(path, "/mstsc.js") == 0) {
        if (size) *size = strlen(mstsc_js);
        return mstsc_js;
    } else if (strcmp(path, "/novnc.css") == 0) {
        if (size) *size = strlen(novnc_css);
        return novnc_css;
    } else if (strncmp(path, "/novnc/", 7) == 0) {
        const char *content = get_novnc_asset(path);
        if (content && size) *size = strlen(content);
        return content;
    } else if (strncmp(path, "/rdpwasm/", 9) == 0) {
        const char *content = get_rdp_asset(path, size);
        return content;
    }

    return NULL;
}