/*
 * WebSocket SCP (wsscp) - Header file
 * SCP wrapper with WebSocket ProxyCommand support.
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef WSSCP_H
#define WSSCP_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <getopt.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <pthread.h>
#include <sys/select.h>

// Configuration structure for wsscp
typedef struct {
    char *client_id;
    char *wssshd_host;
    int wssshd_port;
    int wssshd_port_explicit;  // Flag to track if --wssshd-port was explicitly set
    int debug;
    char *tunnel;
    char *tunnel_control;
    char *enc;
    char *user;
    char *target_host;
    char *ssh_string;
    char *source_file;
    char *destination;
    int remaining_argc;
    char **remaining_argv;
} wsscp_wrapper_config_t;

// Function declarations
int parse_wsscp_args(int argc, char *argv[], wsscp_wrapper_config_t *config);
int parse_target_string(const char *target, wsscp_wrapper_config_t *config);
int parse_scp_port_from_args(wsscp_wrapper_config_t *config);
char *build_proxy_command(wsscp_wrapper_config_t *config);
char *find_wsssht_path();
int execute_scp_command(char *command, int debug);
void print_usage(const char *program_name);

#endif /* WSSCP_H */