// keymap: { text: { mod_flags: scancode } }
// deadkeys: { text: [ idxAccent, idxKeymap, idxKeymap ? ]
// accents: [ { mod_flags: scancode } ]
const layouts = [
{
  klid: 0x00000405,
  localeName: "cs",
  displayName: "Czech",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '+': { 0x0: 0x2, 0x1: 0x4e, },
    'ě': { 0x0: 0x3, },
    'š': { 0x0: 0x4, },
    'č': { 0x0: 0x5, },
    'ř': { 0x0: 0x6, },
    'ž': { 0x0: 0x7, },
    'ý': { 0x0: 0x8, },
    'á': { 0x0: 0x9, },
    'í': { 0x0: 0xa, },
    'é': { 0x0: 0xb, },
    '=': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ú': { 0x0: 0x1a, },
    ')': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ů': { 0x0: 0x27, },
    '§': { 0x0: 0x28, },
    ';': { 0x0: 0x29, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '\\': { 0x0: 0x56, 0x2: 0x10, },
    '/': { 0x0: 0x35, 0x1: 0x1a, 0x5: 0x1a, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, 0x5: 0x3, },
    '3': { 0x1: 0x4, 0x5: 0x4, },
    '4': { 0x1: 0x5, 0x5: 0x5, },
    '5': { 0x1: 0x6, 0x5: 0x6, },
    '6': { 0x1: 0x7, 0x5: 0x7, },
    '7': { 0x1: 0x8, 0x5: 0x8, },
    '8': { 0x1: 0x9, 0x5: 0x9, },
    '9': { 0x1: 0xa, 0x5: 0xa, },
    '0': { 0x1: 0xb, 0x5: 0xb, },
    '%': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '(': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '"': { 0x1: 0x27, 0x5: 0x27, },
    '!': { 0x1: 0x28, },
    '\'': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '?': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '|': { 0x1: 0x56, 0x2: 0x11, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0x35, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '~': { 0x2: 0x2, },
    '€': { 0x2: 0x12, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    'đ': { 0x2: 0x1f, },
    'Đ': { 0x2: 0x20, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    '$': { 0x2: 0x27, },
    'ß': { 0x2: 0x28, },
    '¤': { 0x2: 0x2b, },
    '#': { 0x2: 0x2d, },
    '&': { 0x2: 0x2e, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
    'Ě': { 0x4: 0x3, },
    'Š': { 0x4: 0x4, },
    'Č': { 0x4: 0x5, },
    'Ř': { 0x4: 0x6, },
    'Ž': { 0x4: 0x7, },
    'Ý': { 0x4: 0x8, },
    'Á': { 0x4: 0x9, },
    'Í': { 0x4: 0xa, },
    'É': { 0x4: 0xb, },
    'Ú': { 0x4: 0x1a, },
    'Ů': { 0x4: 0x27, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'Ä': [1, ['A', ]],
    'ë': [1, ['e', ]],
    'Ë': [1, ['E', ]],
    'ï': [1, ['i', ]],
    'Ï': [1, ['I', ]],
    'ö': [1, ['o', ]],
    'Ö': [1, ['O', ]],
    'ü': [1, ['u', ]],
    'Ü': [1, ['U', ]],
    'ÿ': [1, ['y', ]],
    'Ÿ': [1, ['Y', ]],
    '¨': [1, [' ', ]],
    'č': [2, ['c', ]],
    'Č': [2, ['C', ]],
    'ď': [2, ['d', ]],
    'Ď': [2, ['D', ]],
    'ě': [2, ['e', ]],
    'Ě': [2, ['E', ]],
    'ľ': [2, ['l', ]],
    'Ľ': [2, ['L', ]],
    'ň': [2, ['n', ]],
    'Ň': [2, ['N', ]],
    'ř': [2, ['r', ]],
    'Ř': [2, ['R', ]],
    'š': [2, ['s', ]],
    'Š': [2, ['S', ]],
    'ť': [2, ['t', ]],
    'Ť': [2, ['T', ]],
    'ž': [2, ['z', ]],
    'Ž': [2, ['Z', ]],
    'ˇ': [2, [' ', ]],
    'å': [3, ['a', ]],
    'Å': [3, ['A', ]],
    'ů': [3, ['u', ]],
    'Ů': [3, ['U', ]],
    '°': [3, [' ', ]],
    'â': [4, ['a', ]],
    'Â': [4, ['A', ]],
    'ê': [4, ['e', ]],
    'Ê': [4, ['E', ]],
    'î': [4, ['i', ]],
    'Î': [4, ['I', ]],
    'ô': [4, ['o', ]],
    'Ô': [4, ['O', ]],
    'û': [4, ['u', ]],
    'Û': [4, ['U', ]],
    '^': [4, [' ', ]],
    'ă': [5, ['a', ]],
    'Ă': [5, ['A', ]],
    'ğ': [5, ['g', ]],
    'Ğ': [5, ['G', ]],
    '˘': [5, [' ', ]],
    'ą': [6, ['a', ]],
    'Ą': [6, ['A', ]],
    'ę': [6, ['e', ]],
    'Ę': [6, ['E', ]],
    'į': [6, ['i', ]],
    'Į': [6, ['I', ]],
    'ų': [6, ['u', ]],
    'Ų': [6, ['U', ]],
    '˛': [6, [' ', ]],
    'à': [7, ['a', ]],
    'À': [7, ['A', ]],
    'è': [7, ['e', ]],
    'È': [7, ['E', ]],
    'ì': [7, ['i', ]],
    'Ì': [7, ['I', ]],
    'ò': [7, ['o', ]],
    'Ò': [7, ['O', ]],
    'ù': [7, ['u', ]],
    'Ù': [7, ['U', ]],
    '`': [7, [' ', ]],
    'ė': [8, ['e', ]],
    'Ė': [8, ['E', ]],
    'ı': [8, ['i', ]],
    'İ': [8, ['I', ]],
    'ż': [8, ['z', ]],
    'Ż': [8, ['Z', ]],
    '·': [8, [' ', ]],
    'ő': [9, ['o', ]],
    'Ő': [9, ['O', ]],
    'ű': [9, ['u', ]],
    'Ű': [9, ['U', ]],
    '˝': [9, [' ', ]],
    'ç': [10, ['c', ]],
    'Ç': [10, ['C', ]],
    'ģ': [10, ['g', ]],
    'Ģ': [10, ['G', ]],
    'ķ': [10, ['k', ]],
    'Ķ': [10, ['K', ]],
    'ļ': [10, ['l', ]],
    'Ļ': [10, ['L', ]],
    'ņ': [10, ['n', ]],
    'Ņ': [10, ['N', ]],
    'ŗ': [10, ['r', ]],
    'Ŗ': [10, ['R', ]],
    'ş': [10, ['s', ]],
    'Ş': [10, ['S', ]],
    'ţ': [10, ['t', ]],
    'Ţ': [10, ['T', ]],
    '¸': [10, [' ', ]],
  },
  accents: [
    {0x0: 0xd, 0x2: 0xa, },
    {0x0: 0x2b, 0x2: 0xc, },
    {0x1: 0xd, 0x2: 0x3, },
    {0x1: 0x29, 0x2: 0x6, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x7, },
    {0x2: 0x8, },
    {0x2: 0x9, },
    {0x2: 0xb, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00000406,
  localeName: "da",
  displayName: "Danish",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'æ': { 0x0: 0x27, 0x5: 0x27, },
    'ø': { 0x0: 0x28, 0x5: 0x28, },
    '½': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Æ': { 0x1: 0x27, 0x4: 0x27, },
    'Ø': { 0x1: 0x28, 0x4: 0x28, },
    '§': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '|': { 0x2: 0xd, },
    'µ': { 0x2: 0x32, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'â': [3, ['a', ]],
    'ê': [3, ['e', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'û': [3, ['u', ]],
    'Â': [3, ['A', ]],
    'Ê': [3, ['E', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'Û': [3, ['U', ]],
    '^': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x00000407,
  localeName: "de-DE",
  displayName: "German",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, 0x5: 0x2, },
    '2': { 0x0: 0x3, 0x5: 0x3, },
    '3': { 0x0: 0x4, 0x5: 0x4, },
    '4': { 0x0: 0x5, 0x5: 0x5, },
    '5': { 0x0: 0x6, 0x5: 0x6, },
    '6': { 0x0: 0x7, 0x5: 0x7, },
    '7': { 0x0: 0x8, 0x5: 0x8, },
    '8': { 0x0: 0x9, 0x5: 0x9, },
    '9': { 0x0: 0xa, 0x5: 0xa, },
    '0': { 0x0: 0xb, 0x5: 0xb, },
    'ß': { 0x0: 0xc, 0x5: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ü': { 0x0: 0x1a, 0x5: 0x1a, },
    '+': { 0x0: 0x1b, 0x1: 0x4e, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '#': { 0x0: 0x2b, 0x5: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, 0x5: 0x33, },
    '.': { 0x0: 0x34, 0x5: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, 0x4: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, 0x4: 0x2, },
    '"': { 0x1: 0x3, 0x4: 0x3, },
    '§': { 0x1: 0x4, 0x4: 0x4, },
    '$': { 0x1: 0x5, 0x4: 0x5, },
    '%': { 0x1: 0x6, 0x4: 0x6, },
    '&': { 0x1: 0x7, 0x4: 0x7, },
    '(': { 0x1: 0x9, 0x4: 0x9, },
    ')': { 0x1: 0xa, 0x4: 0xa, },
    '=': { 0x1: 0xb, 0x4: 0xb, },
    '?': { 0x1: 0xc, 0x4: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ü': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '°': { 0x1: 0x29, },
    '\'': { 0x1: 0x2b, 0x4: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, 0x4: 0x33, },
    ':': { 0x1: 0x34, 0x4: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0x35, },
    'ẞ': { 0x3: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    '@': { 0x2: 0x10, },
    '€': { 0x2: 0x12, },
    '~': { 0x2: 0x1b, },
    'µ': { 0x2: 0x32, },
    '|': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'â': [1, ['a', ]],
    'ê': [1, ['e', ]],
    'î': [1, ['i', ]],
    'ô': [1, ['o', ]],
    'û': [1, ['u', ]],
    'Â': [1, ['A', ]],
    'Ê': [1, ['E', ]],
    'Î': [1, ['I', ]],
    'Ô': [1, ['O', ]],
    'Û': [1, ['U', ]],
    '^': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x29, },
    {0x1: 0xd, },
  ]
},
{
  klid: 0x00000408,
  localeName: "el",
  displayName: "Greek",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    ';': { 0x0: 0x10, },
    'ς': { 0x0: 0x11, },
    'ε': { 0x0: 0x12, 0x5: 0x12, },
    'ρ': { 0x0: 0x13, 0x5: 0x13, },
    'τ': { 0x0: 0x14, 0x5: 0x14, },
    'υ': { 0x0: 0x15, 0x5: 0x15, },
    'θ': { 0x0: 0x16, 0x5: 0x16, },
    'ι': { 0x0: 0x17, 0x5: 0x17, },
    'ο': { 0x0: 0x18, 0x5: 0x18, },
    'π': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'α': { 0x0: 0x1e, 0x5: 0x1e, },
    'σ': { 0x0: 0x1f, 0x5: 0x1f, },
    'δ': { 0x0: 0x20, 0x5: 0x20, },
    'φ': { 0x0: 0x21, 0x5: 0x21, },
    'γ': { 0x0: 0x22, 0x5: 0x22, },
    'η': { 0x0: 0x23, 0x5: 0x23, },
    'ξ': { 0x0: 0x24, 0x5: 0x24, },
    'κ': { 0x0: 0x25, 0x5: 0x25, },
    'λ': { 0x0: 0x26, 0x5: 0x26, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },
    'χ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },
    'ω': { 0x0: 0x2f, 0x5: 0x2f, },
    'β': { 0x0: 0x30, 0x5: 0x30, },
    'ν': { 0x0: 0x31, 0x5: 0x31, },
    'μ': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '<': { 0x0: 0x56, 0x1: 0x33, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    ':': { 0x1: 0x10, },
    'Ε': { 0x1: 0x12, 0x4: 0x12, },
    'Ρ': { 0x1: 0x13, 0x4: 0x13, },
    'Τ': { 0x1: 0x14, 0x4: 0x14, },
    'Υ': { 0x1: 0x15, 0x4: 0x15, },
    'Θ': { 0x1: 0x16, 0x4: 0x16, },
    'Ι': { 0x1: 0x17, 0x4: 0x17, },
    'Ο': { 0x1: 0x18, 0x4: 0x18, },
    'Π': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'Α': { 0x1: 0x1e, 0x4: 0x1e, },
    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },
    'Δ': { 0x1: 0x20, 0x4: 0x20, },
    'Φ': { 0x1: 0x21, 0x4: 0x21, },
    'Γ': { 0x1: 0x22, 0x4: 0x22, },
    'Η': { 0x1: 0x23, 0x4: 0x23, },
    'Ξ': { 0x1: 0x24, 0x4: 0x24, },
    'Κ': { 0x1: 0x25, 0x4: 0x25, },
    'Λ': { 0x1: 0x26, 0x4: 0x26, },
    '"': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },
    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },
    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },
    'Β': { 0x1: 0x30, 0x4: 0x30, },
    'Ν': { 0x1: 0x31, 0x4: 0x31, },
    'Μ': { 0x1: 0x32, 0x4: 0x32, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x28, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '£': { 0x2: 0x5, },
    '§': { 0x2: 0x6, },
    '¶': { 0x2: 0x7, },
    '¤': { 0x2: 0x9, },
    '¦': { 0x2: 0xa, },
    '°': { 0x2: 0xb, },
    '±': { 0x2: 0xc, },
    '½': { 0x2: 0xd, },
    '€': { 0x2: 0x12, },
    '®': { 0x2: 0x13, },
    '¥': { 0x2: 0x15, },
    '«': { 0x2: 0x1a, },
    '»': { 0x2: 0x1b, },
    '¬': { 0x2: 0x2b, },
    '©': { 0x2: 0x2e, },
  },
  deadkeys: {
    'ά': [0, ['α', ]],
    'έ': [0, ['ε', ]],
    'ί': [0, ['ι', ]],
    'ό': [0, ['ο', ]],
    'ύ': [0, ['υ', ]],
    'ώ': [0, ['ω', ]],
    'ή': [0, ['η', ]],
    'Ά': [0, ['Α', ]],
    'Έ': [0, ['Ε', ]],
    'Ί': [0, ['Ι', ]],
    'Ό': [0, ['Ο', ]],
    'Ύ': [0, ['Υ', ]],
    'Ώ': [0, ['Ω', ]],
    'Ή': [0, ['Η', ]],
    '΄': [0, [' ', ]],
    'ΐ': [1, ['ι', ]],
    'ΰ': [1, ['υ', ]],
    '΅': [1, [' ', ]],
    'ϊ': [2, ['ι', ]],
    'ϋ': [2, ['υ', ]],
    'Ϊ': [2, ['Ι', ]],
    'Ϋ': [2, ['Υ', ]],
    '¨': [2, [' ', ]],
  },
  accents: [
    {0x0: 0x27, },
    {0x1: 0x11, 0x2: 0x27, },
    {0x1: 0x27, },
  ]
},
{
  klid: 0x00000409,
  localeName: "en-US",
  displayName: "United States - English",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0000040a,
  localeName: "es-ES",
  displayName: "Spanish",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '¡': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '+': { 0x0: 0x1b, 0x1: 0x4e, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ñ': { 0x0: 0x27, 0x5: 0x27, },
    'º': { 0x0: 0x29, },
    'ç': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '·': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '¿': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ñ': { 0x1: 0x27, 0x4: 0x27, },
    'ª': { 0x1: 0x29, },
    'Ç': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '|': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '€': { 0x2: 0x6, },
    '¬': { 0x2: 0x7, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '{': { 0x2: 0x28, },
    '\\': { 0x2: 0x29, },
    '}': { 0x2: 0x2b, },
  },
  deadkeys: {
    'à': [0, ['a', ]],
    'è': [0, ['e', ]],
    'ì': [0, ['i', ]],
    'ò': [0, ['o', ]],
    'ù': [0, ['u', ]],
    'À': [0, ['A', ]],
    'È': [0, ['E', ]],
    'Ì': [0, ['I', ]],
    'Ò': [0, ['O', ]],
    'Ù': [0, ['U', ]],
    '`': [0, [' ', ]],
    'á': [1, ['a', ]],
    'é': [1, ['e', ]],
    'í': [1, ['i', ]],
    'ó': [1, ['o', ]],
    'ú': [1, ['u', ]],
    'ý': [1, ['y', ]],
    'Á': [1, ['A', ]],
    'É': [1, ['E', ]],
    'Í': [1, ['I', ]],
    'Ó': [1, ['O', ]],
    'Ú': [1, ['U', ]],
    'Ý': [1, ['Y', ]],
    '´': [1, [' ', ]],
    'â': [2, ['a', ]],
    'ê': [2, ['e', ]],
    'î': [2, ['i', ]],
    'ô': [2, ['o', ]],
    'û': [2, ['u', ]],
    'Â': [2, ['A', ]],
    'Ê': [2, ['E', ]],
    'Î': [2, ['I', ]],
    'Ô': [2, ['O', ]],
    'Û': [2, ['U', ]],
    '^': [2, [' ', ]],
    'ä': [3, ['a', ]],
    'ë': [3, ['e', ]],
    'ï': [3, ['i', ]],
    'ö': [3, ['o', ]],
    'ü': [3, ['u', ]],
    'ÿ': [3, ['y', ]],
    'Ä': [3, ['A', ]],
    'Ë': [3, ['E', ]],
    'Ï': [3, ['I', ]],
    'Ö': [3, ['O', ]],
    'Ü': [3, ['U', ]],
    '¨': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'ñ': [4, ['n', ]],
    'õ': [4, ['o', ]],
    'Ã': [4, ['A', ]],
    'Ñ': [4, ['N', ]],
    'Õ': [4, ['O', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, },
    {0x0: 0x28, },
    {0x1: 0x1a, },
    {0x1: 0x28, },
    {0x2: 0x5, },
  ]
},
{
  klid: 0x0000040b,
  localeName: "fi",
  displayName: "Finnish",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '§': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '½': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    'µ': { 0x2: 0x32, },
    '|': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'â': [3, ['a', ]],
    'ê': [3, ['e', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'û': [3, ['u', ]],
    'Â': [3, ['A', ]],
    'Ê': [3, ['E', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'Û': [3, ['U', ]],
    '^': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x0000040c,
  localeName: "fr-FR",
  displayName: "French",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '&': { 0x0: 0x2, 0x5: 0x2, },
    'é': { 0x0: 0x3, 0x5: 0x3, },
    '"': { 0x0: 0x4, 0x5: 0x4, },
    '\'': { 0x0: 0x5, 0x5: 0x5, },
    '(': { 0x0: 0x6, 0x5: 0x6, },
    '-': { 0x0: 0x7, 0x1: 0x4a, 0x5: 0x7, },
    'è': { 0x0: 0x8, 0x5: 0x8, },
    '_': { 0x0: 0x9, 0x5: 0x9, },
    'ç': { 0x0: 0xa, 0x5: 0xa, },
    'à': { 0x0: 0xb, 0x5: 0xb, },
    ')': { 0x0: 0xc, 0x5: 0xc, },
    '=': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'a': { 0x0: 0x10, 0x5: 0x10, },
    'z': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '$': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'q': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'm': { 0x0: 0x27, 0x5: 0x27, },
    'ù': { 0x0: 0x28, 0x5: 0x28, },
    '²': { 0x0: 0x29, },
    '*': { 0x0: 0x2b, 0x1: 0x37, 0x5: 0x2b, },
    'w': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    ',': { 0x0: 0x32, 0x5: 0x32, },
    ';': { 0x0: 0x33, 0x5: 0x33, },
    ':': { 0x0: 0x34, 0x5: 0x34, },
    '!': { 0x0: 0x35, 0x5: 0x35, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, 0x4: 0xd, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, 0x4: 0x2, },
    '2': { 0x1: 0x3, 0x4: 0x3, },
    '3': { 0x1: 0x4, 0x4: 0x4, },
    '4': { 0x1: 0x5, 0x4: 0x5, },
    '5': { 0x1: 0x6, 0x4: 0x6, },
    '6': { 0x1: 0x7, 0x4: 0x7, },
    '7': { 0x1: 0x8, 0x4: 0x8, },
    '8': { 0x1: 0x9, 0x4: 0x9, },
    '9': { 0x1: 0xa, 0x4: 0xa, },
    '0': { 0x1: 0xb, 0x4: 0xb, },
    '°': { 0x1: 0xc, 0x4: 0xc, },
    'A': { 0x1: 0x10, 0x4: 0x10, },
    'Z': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '£': { 0x1: 0x1b, 0x4: 0x1b, },
    'Q': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'M': { 0x1: 0x27, 0x4: 0x27, },
    '%': { 0x1: 0x28, 0x4: 0x28, },
    'µ': { 0x1: 0x2b, 0x4: 0x2b, },
    'W': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    '?': { 0x1: 0x32, 0x4: 0x32, },
    '.': { 0x1: 0x33, 0x4: 0x33, },
    '§': { 0x1: 0x35, 0x4: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1f': { 0x1: 0x7, },
    '\x1c': { 0x1: 0x9, 0x0: 0x2b, },
    '\x1e': { 0x1: 0xa, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '#': { 0x2: 0x4, },
    '{': { 0x2: 0x5, },
    '[': { 0x2: 0x6, },
    '|': { 0x2: 0x7, },
    '\\': { 0x2: 0x9, },
    '^': { 0x2: 0xa, },
    '@': { 0x2: 0xb, },
    ']': { 0x2: 0xc, },
    '}': { 0x2: 0xd, },
    '€': { 0x2: 0x12, },
    '¤': { 0x2: 0x1b, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'ã': [2, ['a', ]],
    'Ã': [2, ['A', ]],
    'ñ': [2, ['n', ]],
    'Ñ': [2, ['N', ]],
    'õ': [2, ['o', ]],
    'Õ': [2, ['O', ]],
    '~': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, 0x5: 0x1a, },
    {0x1: 0x1a, 0x4: 0x1a, },
    {0x2: 0x3, },
    {0x2: 0x8, },
  ]
},
{
  klid: 0x0000040f,
  localeName: "is",
  displayName: "Icelandic",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    'ö': { 0x0: 0xc, 0x5: 0xc, },
    '-': { 0x0: 0xd, 0x1: 0x4a, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ð': { 0x0: 0x1a, 0x5: 0x1a, },
    '\'': { 0x0: 0x1b, 0x1: 0x28, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'æ': { 0x0: 0x27, 0x5: 0x27, },
    '+': { 0x0: 0x2b, 0x1: 0x4e, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    'þ': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    'Ö': { 0x1: 0xc, 0x4: 0xc, },
    '_': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ð': { 0x1: 0x1a, 0x4: 0x1a, },
    '?': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Æ': { 0x1: 0x27, 0x4: 0x27, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    'Þ': { 0x1: 0x35, 0x4: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    '@': { 0x2: 0x10, },
    '~': { 0x2: 0x1b, },
    '°': { 0x2: 0x29, },
    'µ': { 0x2: 0x32, },
    '|': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'å': [1, ['a', ]],
    'Å': [1, ['A', ]],
    '°': [1, [' ', ]],
    'ä': [2, ['a', ]],
    'ë': [2, ['e', ]],
    'ï': [2, ['i', ]],
    'ö': [2, ['o', ]],
    'ü': [2, ['u', ]],
    'ÿ': [2, ['y', ]],
    'Ä': [2, ['A', ]],
    'Ë': [2, ['E', ]],
    'Ï': [2, ['I', ]],
    'Ö': [2, ['O', ]],
    'Ü': [2, ['U', ]],
    '¨': [2, [' ', ]],
    'â': [3, ['a', ]],
    'ê': [3, ['e', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'û': [3, ['u', ]],
    'Â': [3, ['A', ]],
    'Ê': [3, ['E', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'Û': [3, ['U', ]],
    '^': [3, [' ', ]],
    'à': [4, ['a', ]],
    'è': [4, ['e', ]],
    'ì': [4, ['i', ]],
    'ò': [4, ['o', ]],
    'ù': [4, ['u', ]],
    'À': [4, ['A', ]],
    'È': [4, ['E', ]],
    'Ì': [4, ['I', ]],
    'Ò': [4, ['O', ]],
    'Ù': [4, ['U', ]],
    '`': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x28, },
    {0x0: 0x29, },
    {0x1: 0x29, },
    {0x2: 0x28, },
    {0x2: 0x2b, },
  ]
},
{
  klid: 0x00000410,
  localeName: "it-IT",
  displayName: "Italian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    'ì': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'è': { 0x0: 0x1a, },
    '+': { 0x0: 0x1b, 0x1: 0x4e, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ò': { 0x0: 0x27, },
    'à': { 0x0: 0x28, },
    '\\': { 0x0: 0x29, },
    'ù': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '^': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'é': { 0x1: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'ç': { 0x1: 0x27, },
    '°': { 0x1: 0x28, },
    '|': { 0x1: 0x29, },
    '§': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '{': { 0x3: 0x1a, },
    '}': { 0x3: 0x1b, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\x1f': { 0x0: 0x35, },
    '€': { 0x2: 0x6, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '@': { 0x2: 0x27, },
    '#': { 0x2: 0x28, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000413,
  localeName: "nl-NL",
  displayName: "Dutch",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '/': { 0x0: 0xc, 0x1: 0x35, },
    '°': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '*': { 0x0: 0x1b, 0x1: 0x37, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    '+': { 0x0: 0x27, 0x1: 0x4e, },
    '@': { 0x0: 0x29, },
    '<': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    ']': { 0x0: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '_': { 0x1: 0x8, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '\'': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '|': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '±': { 0x1: 0x27, },
    '§': { 0x1: 0x29, },
    '>': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '=': { 0x1: 0x35, },
    '[': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1c': { 0x0: 0xc, },
    '\x1d': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1f': { 0x0: 0x35, },
    '¹': { 0x2: 0x2, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '¼': { 0x2: 0x5, },
    '½': { 0x2: 0x6, },
    '¾': { 0x2: 0x7, },
    '£': { 0x2: 0x8, },
    '{': { 0x2: 0x9, },
    '}': { 0x2: 0xa, },
    '\\': { 0x2: 0xc, },
    '€': { 0x2: 0x12, },
    '¶': { 0x2: 0x13, },
    'ß': { 0x2: 0x1f, },
    '¬': { 0x2: 0x29, },
    '«': { 0x2: 0x2c, },
    '»': { 0x2: 0x2d, },
    '¢': { 0x2: 0x2e, },
    'µ': { 0x2: 0x32, },
    '·': { 0x2: 0x34, },
    '¦': { 0x2: 0x56, },
  },
  deadkeys: {
    'ä': [0, ['a', ]],
    'ë': [0, ['e', ]],
    'ï': [0, ['i', ]],
    'ö': [0, ['o', ]],
    'ü': [0, ['u', ]],
    'ÿ': [0, ['y', ]],
    'Ä': [0, ['A', ]],
    'Ë': [0, ['E', ]],
    'Ï': [0, ['I', ]],
    'Ö': [0, ['O', ]],
    'Ü': [0, ['U', ]],
    '¨': [0, [' ', ]],
    'á': [1, ['a', ]],
    'é': [1, ['e', ]],
    'í': [1, ['i', ]],
    'ó': [1, ['o', ]],
    'ú': [1, ['u', ]],
    'ý': [1, ['y', ]],
    'Á': [1, ['A', ]],
    'É': [1, ['E', ]],
    'Í': [1, ['I', ]],
    'Ó': [1, ['O', ]],
    'Ú': [1, ['U', ]],
    'Ý': [1, ['Y', ]],
    '´': [1, [' ', ]],
    'ã': [2, ['a', ]],
    'õ': [2, ['o', ]],
    'ñ': [2, ['n', ]],
    'Ã': [2, ['A', ]],
    'Õ': [2, ['O', ]],
    'Ñ': [2, ['N', ]],
    '~': [2, [' ', ]],
    'â': [3, ['a', ]],
    'ê': [3, ['e', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'û': [3, ['u', ]],
    'Â': [3, ['A', ]],
    'Ê': [3, ['E', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'Û': [3, ['U', ]],
    '^': [3, [' ', ]],
    'à': [4, ['a', ]],
    'è': [4, ['e', ]],
    'ì': [4, ['i', ]],
    'ò': [4, ['o', ]],
    'ù': [4, ['u', ]],
    'À': [4, ['A', ]],
    'È': [4, ['E', ]],
    'Ì': [4, ['I', ]],
    'Ò': [4, ['O', ]],
    'Ù': [4, ['U', ]],
    '`': [4, [' ', ]],
    'ç': [5, ['c', ]],
    'Ç': [5, ['C', ]],
    '¸': [5, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, },
    {0x0: 0x28, },
    {0x1: 0xd, },
    {0x1: 0x1a, },
    {0x1: 0x28, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00000414,
  localeName: "nb",
  displayName: "Norwegian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\\': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ø': { 0x0: 0x27, 0x5: 0x27, },
    'æ': { 0x0: 0x28, 0x5: 0x28, },
    '|': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ø': { 0x1: 0x27, 0x4: 0x27, },
    'Æ': { 0x1: 0x28, 0x4: 0x28, },
    '§': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    'µ': { 0x2: 0x32, },
  },
  deadkeys: {
    'ä': [0, ['a', ]],
    'ë': [0, ['e', ]],
    'ï': [0, ['i', ]],
    'ö': [0, ['o', ]],
    'ü': [0, ['u', ]],
    'ÿ': [0, ['y', ]],
    'Ä': [0, ['A', ]],
    'Ë': [0, ['E', ]],
    'Ï': [0, ['I', ]],
    'Ö': [0, ['O', ]],
    'Ü': [0, ['U', ]],
    '¨': [0, [' ', ]],
    'à': [1, ['a', ]],
    'è': [1, ['e', ]],
    'ì': [1, ['i', ]],
    'ò': [1, ['o', ]],
    'ù': [1, ['u', ]],
    'À': [1, ['A', ]],
    'È': [1, ['E', ]],
    'Ì': [1, ['I', ]],
    'Ò': [1, ['O', ]],
    'Ù': [1, ['U', ]],
    '`': [1, [' ', ]],
    'â': [2, ['a', ]],
    'ê': [2, ['e', ]],
    'î': [2, ['i', ]],
    'ô': [2, ['o', ]],
    'û': [2, ['u', ]],
    'Â': [2, ['A', ]],
    'Ê': [2, ['E', ]],
    'Î': [2, ['I', ]],
    'Ô': [2, ['O', ]],
    'Û': [2, ['U', ]],
    '^': [2, [' ', ]],
    'á': [3, ['a', ]],
    'é': [3, ['e', ]],
    'í': [3, ['i', ]],
    'ó': [3, ['o', ]],
    'ú': [3, ['u', ]],
    'ý': [3, ['y', ]],
    'Á': [3, ['A', ]],
    'É': [3, ['E', ]],
    'Í': [3, ['I', ]],
    'Ó': [3, ['O', ]],
    'Ú': [3, ['U', ]],
    'Ý': [3, ['Y', ]],
    '´': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0xd, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x00000415,
  localeName: "pl",
  displayName: "Polish (Programmers)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, 0x0: 0xc, },
    'Ę': { 0x3: 0x12, 0x6: 0x12, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Ą': { 0x3: 0x1e, 0x6: 0x1e, },
    'Ś': { 0x3: 0x1f, 0x6: 0x1f, },
    'Ł': { 0x3: 0x26, 0x6: 0x26, },
    'Ż': { 0x3: 0x2c, 0x6: 0x2c, },
    'Ź': { 0x3: 0x2d, 0x6: 0x2d, },
    'Ć': { 0x3: 0x2e, 0x6: 0x2e, },
    'Ń': { 0x3: 0x31, 0x6: 0x31, },
    'ę': { 0x7: 0x12, 0x2: 0x12, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'ą': { 0x7: 0x1e, 0x2: 0x1e, },
    'ś': { 0x7: 0x1f, 0x2: 0x1f, },
    'ł': { 0x7: 0x26, 0x2: 0x26, },
    'ż': { 0x7: 0x2c, 0x2: 0x2c, },
    'ź': { 0x7: 0x2d, 0x2: 0x2d, },
    'ć': { 0x7: 0x2e, 0x2: 0x2e, },
    'ń': { 0x7: 0x31, 0x2: 0x31, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '€': { 0x2: 0x16, },
  },
  deadkeys: {
    'ę': [0, ['e', ]],
    'ó': [0, ['o', ]],
    'ą': [0, ['a', ]],
    'ś': [0, ['s', ]],
    'ł': [0, ['l', ]],
    'ż': [0, ['z', ]],
    'ź': [0, ['x', ]],
    'ć': [0, ['c', ]],
    'ń': [0, ['n', ]],
    'Ę': [0, ['E', ]],
    'Ó': [0, ['O', ]],
    'Ą': [0, ['A', ]],
    'Ś': [0, ['S', ]],
    'Ł': [0, ['L', ]],
    'Ż': [0, ['Z', ]],
    'Ź': [0, ['X', ]],
    'Ć': [0, ['C', ]],
    'Ń': [0, ['N', ]],
    '~': [0, [' ', ]],
  },
  accents: [
    {0x1: 0x29, },
  ]
},
{
  klid: 0x00000416,
  localeName: "pt-BR",
  displayName: "Portuguese (Brazil ABNT)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ç': { 0x0: 0x27, 0x5: 0x27, },
    '\'': { 0x0: 0x29, },
    ']': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, 0x1: 0x7e, },
    ';': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, },
    '/': { 0x0: 0x73, 0x1: 0x35, 0x2: 0x10, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ç': { 0x1: 0x27, 0x4: 0x27, },
    '"': { 0x1: 0x29, },
    '}': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    ':': { 0x1: 0x35, },
    '|': { 0x1: 0x56, },
    '?': { 0x1: 0x73, 0x2: 0x11, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '¹': { 0x2: 0x2, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '£': { 0x2: 0x5, },
    '¢': { 0x2: 0x6, },
    '¬': { 0x2: 0x7, },
    '§': { 0x2: 0xd, },
    '°': { 0x2: 0x12, },
    'ª': { 0x2: 0x1b, },
    'º': { 0x2: 0x2b, },
    '₢': { 0x2: 0x2e, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ã': [1, ['a', ]],
    'õ': [1, ['o', ]],
    'ñ': [1, ['n', ]],
    'Ã': [1, ['A', ]],
    'Õ': [1, ['O', ]],
    'Ñ': [1, ['N', ]],
    '~': [1, [' ', ]],
    'ä': [2, ['a', ]],
    'ë': [2, ['e', ]],
    'ï': [2, ['i', ]],
    'ö': [2, ['o', ]],
    'ü': [2, ['u', ]],
    'ÿ': [2, ['y', ]],
    'Ä': [2, ['A', ]],
    'Ë': [2, ['E', ]],
    'Ï': [2, ['I', ]],
    'Ö': [2, ['O', ]],
    'Ü': [2, ['U', ]],
    '¨': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
    'â': [4, ['a', ]],
    'ê': [4, ['e', ]],
    'î': [4, ['i', ]],
    'ô': [4, ['o', ]],
    'û': [4, ['u', ]],
    'Â': [4, ['A', ]],
    'Ê': [4, ['E', ]],
    'Î': [4, ['I', ]],
    'Ô': [4, ['O', ]],
    'Û': [4, ['U', ]],
    '^': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, },
    {0x0: 0x28, },
    {0x1: 0x7, },
    {0x1: 0x1a, },
    {0x1: 0x28, },
  ]
},
{
  klid: 0x00000418,
  localeName: "ro-RO",
  displayName: "Romanian (Legacy)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\'': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ă': { 0x0: 0x1a, 0x5: 0x1a, },
    'î': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ş': { 0x0: 0x27, 0x5: 0x27, },
    'ţ': { 0x0: 0x28, 0x5: 0x28, },
    ']': { 0x0: 0x29, },
    'â': { 0x0: 0x2b, 0x5: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, 0x2: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ă': { 0x1: 0x1a, 0x4: 0x1a, },
    'Î': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ş': { 0x1: 0x27, 0x4: 0x27, },
    'Ţ': { 0x1: 0x28, 0x4: 0x28, },
    '[': { 0x1: 0x29, },
    'Â': { 0x1: 0x2b, 0x4: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x1e': { 0x1: 0x8, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, 0x2: 0x56, },
    '~': { 0x2: 0x2, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    'đ': { 0x2: 0x1f, },
    'Đ': { 0x2: 0x20, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    '$': { 0x2: 0x27, },
    'ß': { 0x2: 0x28, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
    'ň': [0, ['n', ]],
    'č': [0, ['c', ]],
    'ď': [0, ['d', ]],
    'š': [0, ['s', ]],
    'ľ': [0, ['l', ]],
    'ě': [0, ['e', ]],
    'ř': [0, ['r', ]],
    'ť': [0, ['t', ]],
    'ž': [0, ['z', ]],
    'Ň': [0, ['N', ]],
    'Č': [0, ['C', ]],
    'Ď': [0, ['D', ]],
    'Š': [0, ['S', ]],
    'Ľ': [0, ['L', ]],
    'Ě': [0, ['E', ]],
    'Ř': [0, ['R', ]],
    'Ť': [0, ['T', ]],
    'Ž': [0, ['Z', ]],
    'ˇ': [0, [' ', ]],
    'â': [1, ['a', ]],
    'î': [1, ['i', ]],
    'ô': [1, ['o', ]],
    'Â': [1, ['A', ]],
    'Î': [1, ['I', ]],
    'Ô': [1, ['O', ]],
    '^': [1, [' ', ]],
    'ă': [2, ['a', ]],
    'Ă': [2, ['A', ]],
    '˘': [2, [' ', ]],
    'ů': [3, ['u', ]],
    'Ů': [3, ['U', ]],
    '°': [3, [' ', ]],
    'ą': [4, ['a', ]],
    'ę': [4, ['e', ]],
    'Ą': [4, ['A', ]],
    'Ę': [4, ['E', ]],
    '˛': [4, [' ', ]],
    'ż': [5, ['z', ]],
    'Ż': [5, ['Z', ]],
    '·': [5, [' ', ]],
    'ń': [6, ['n', ]],
    'ć': [6, ['c', ]],
    'ý': [6, ['y', ]],
    'á': [6, ['a', ]],
    'ś': [6, ['s', ]],
    'ĺ': [6, ['l', ]],
    'é': [6, ['e', ]],
    'ŕ': [6, ['r', ]],
    'ú': [6, ['u', ]],
    'í': [6, ['i', ]],
    'ź': [6, ['z', ]],
    'ó': [6, ['o', ]],
    'Ń': [6, ['N', ]],
    'Ć': [6, ['C', ]],
    'Ý': [6, ['Y', ]],
    'Á': [6, ['A', ]],
    'Ś': [6, ['S', ]],
    'Ĺ': [6, ['L', ]],
    'É': [6, ['E', ]],
    'Ŕ': [6, ['R', ]],
    'Ú': [6, ['U', ]],
    'Í': [6, ['I', ]],
    'Ź': [6, ['Z', ]],
    'Ó': [6, ['O', ]],
    '´': [6, [' ', ]],
    'ű': [7, ['u', ]],
    'ő': [7, ['o', ]],
    'Ű': [7, ['U', ]],
    'Ő': [7, ['O', ]],
    '˝': [7, [' ', ]],
    'ä': [8, ['a', ]],
    'ë': [8, ['e', ]],
    'ü': [8, ['u', ]],
    'ö': [8, ['o', ]],
    'Ä': [8, ['A', ]],
    'Ë': [8, ['E', ]],
    'Ü': [8, ['U', ]],
    'Ö': [8, ['O', ]],
    '¨': [8, [' ', ]],
    'ç': [9, ['c', ]],
    'ș': [9, ['s', ]],
    'ţ': [9, ['t', ]],
    'Ç': [9, ['C', ]],
    'Ș': [9, ['S', ]],
    'Ţ': [9, ['T', ]],
    '¸': [9, [' ', ]],
  },
  accents: [
    {0x2: 0x3, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x6, },
    {0x2: 0x7, },
    {0x2: 0x9, },
    {0x2: 0xa, },
    {0x2: 0xb, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00000419,
  localeName: "ru",
  displayName: "Russian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'щ': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'ы': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ж': { 0x0: 0x27, 0x5: 0x27, },
    'э': { 0x0: 0x28, 0x5: 0x28, },
    'ё': { 0x0: 0x29, 0x5: 0x29, },
    '\\': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'ь': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    '.': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '/': { 0x0: 0x35, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '№': { 0x1: 0x4, },
    ';': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    ':': { 0x1: 0x7, },
    '?': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Щ': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ж': { 0x1: 0x27, 0x4: 0x27, },
    'Э': { 0x1: 0x28, 0x4: 0x28, },
    'Ё': { 0x1: 0x29, 0x4: 0x29, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Ь': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    ',': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '₽': { 0x2: 0x9, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0000041a,
  localeName: "hr-HR",
  displayName: "Croatian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'š': { 0x0: 0x1a, 0x5: 0x1a, },
    'đ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'č': { 0x0: 0x27, 0x5: 0x27, },
    'ć': { 0x0: 0x28, 0x5: 0x28, },
    'ž': { 0x0: 0x2b, 0x5: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Š': { 0x1: 0x1a, 0x4: 0x1a, },
    'Đ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Č': { 0x1: 0x27, 0x4: 0x27, },
    'Ć': { 0x1: 0x28, 0x4: 0x28, },
    'Ž': { 0x1: 0x2b, 0x4: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '~': { 0x2: 0x2, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '€': { 0x2: 0x12, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    'ß': { 0x2: 0x28, },
    '¤': { 0x2: 0x2b, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
    'Ç': [0, ['C', ]],
    'ç': [0, ['c', ]],
    'Ş': [0, ['S', ]],
    'ş': [0, ['s', ]],
    '¸': [0, [' ', ]],
    'Ë': [1, ['E', ]],
    'ë': [1, ['e', ]],
    'Ü': [1, ['U', ]],
    'ü': [1, ['u', ]],
    'Ö': [1, ['O', ]],
    'ö': [1, ['o', ]],
    'Ä': [1, ['A', ]],
    'ä': [1, ['a', ]],
    '¨': [1, [' ', ]],
    'č': [2, ['c', ]],
    'Č': [2, ['C', ]],
    'ď': [2, ['d', ]],
    'Ď': [2, ['D', ]],
    'ě': [2, ['e', ]],
    'Ě': [2, ['E', ]],
    'ľ': [2, ['l', ]],
    'Ľ': [2, ['L', ]],
    'ň': [2, ['n', ]],
    'Ň': [2, ['N', ]],
    'ř': [2, ['r', ]],
    'Ř': [2, ['R', ]],
    'š': [2, ['s', ]],
    'Š': [2, ['S', ]],
    'ť': [2, ['t', ]],
    'Ť': [2, ['T', ]],
    'ž': [2, ['z', ]],
    'Ž': [2, ['Z', ]],
    'ˇ': [2, [' ', ]],
    'Î': [3, ['I', ]],
    'î': [3, ['i', ]],
    'Ô': [3, ['O', ]],
    'ô': [3, ['o', ]],
    'Â': [3, ['A', ]],
    'â': [3, ['a', ]],
    '^': [3, [' ', ]],
    'Ă': [4, ['A', ]],
    'ă': [4, ['a', ]],
    '˘': [4, [' ', ]],
    'Ů': [5, ['U', ]],
    'ů': [5, ['u', ]],
    '°': [5, [' ', ]],
    'Ę': [6, ['E', ]],
    'ę': [6, ['e', ]],
    'Ą': [6, ['A', ]],
    'ą': [6, ['a', ]],
    '˛': [6, [' ', ]],
    'Ż': [7, ['Z', ]],
    'ż': [7, ['z', ]],
    '˙': [7, [' ', ]],
    'Á': [8, ['A', ]],
    'á': [8, ['a', ]],
    'Ć': [8, ['C', ]],
    'ć': [8, ['c', ]],
    'É': [8, ['E', ]],
    'é': [8, ['e', ]],
    'Í': [8, ['I', ]],
    'í': [8, ['i', ]],
    'Ĺ': [8, ['L', ]],
    'ĺ': [8, ['l', ]],
    'Ń': [8, ['N', ]],
    'ń': [8, ['n', ]],
    'Ó': [8, ['O', ]],
    'ó': [8, ['o', ]],
    'Ŕ': [8, ['R', ]],
    'ŕ': [8, ['r', ]],
    'Ś': [8, ['S', ]],
    'ś': [8, ['s', ]],
    'Ú': [8, ['U', ]],
    'ú': [8, ['u', ]],
    'Ý': [8, ['Y', ]],
    'ý': [8, ['y', ]],
    'Ź': [8, ['Z', ]],
    'ź': [8, ['z', ]],
    '´': [8, [' ', ]],
    'Ű': [9, ['U', ]],
    'ű': [9, ['u', ]],
    'Ő': [9, ['O', ]],
    'ő': [9, ['o', ]],
    '˝': [9, [' ', ]],
  },
  accents: [
    {0x0: 0x29, 0x2: 0xd, },
    {0x1: 0x29, 0x2: 0xc, },
    {0x2: 0x3, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x6, },
    {0x2: 0x7, },
    {0x2: 0x9, },
    {0x2: 0xa, },
    {0x2: 0xb, },
  ]
},
{
  klid: 0x0000041b,
  localeName: "sk",
  displayName: "Slovak",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '+': { 0x0: 0x2, 0x1: 0x4e, },
    'ľ': { 0x0: 0x3, },
    'š': { 0x0: 0x4, },
    'č': { 0x0: 0x5, },
    'ť': { 0x0: 0x6, },
    'ž': { 0x0: 0x7, },
    'ý': { 0x0: 0x8, },
    'á': { 0x0: 0x9, },
    'í': { 0x0: 0xa, },
    'é': { 0x0: 0xb, },
    '=': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ú': { 0x0: 0x1a, },
    'ä': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ô': { 0x0: 0x27, },
    '§': { 0x0: 0x28, },
    ';': { 0x0: 0x29, },
    'ň': { 0x0: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '&': { 0x0: 0x56, 0x2: 0x2e, },
    '/': { 0x0: 0x35, 0x1: 0x1a, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, },
    '3': { 0x1: 0x4, },
    '4': { 0x1: 0x5, },
    '5': { 0x1: 0x6, },
    '6': { 0x1: 0x7, },
    '7': { 0x1: 0x8, },
    '8': { 0x1: 0x9, },
    '9': { 0x1: 0xa, },
    '0': { 0x1: 0xb, },
    '%': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '(': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '"': { 0x1: 0x27, },
    '!': { 0x1: 0x28, },
    ')': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '?': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1d': { 0x1: 0x22, },
    '\x1f': { 0x1: 0x35, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\a': { 0x0: 0x22, },
    '\x1c': { 0x0: 0x2b, },
    '\x16': { 0x0: 0x2f, },
    '~': { 0x2: 0x2, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '€': { 0x2: 0x12, },
    '\'': { 0x2: 0x19, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    'đ': { 0x2: 0x1f, },
    'Đ': { 0x2: 0x20, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    '$': { 0x2: 0x27, },
    'ß': { 0x2: 0x28, },
    '¤': { 0x2: 0x2b, },
    '>': { 0x2: 0x2c, },
    '#': { 0x2: 0x2d, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '<': { 0x2: 0x33, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    '´': [0, [' ', ]],
    'č': [1, ['c', ]],
    'Č': [1, ['C', ]],
    'ď': [1, ['d', ]],
    'Ď': [1, ['D', ]],
    'ě': [1, ['e', ]],
    'Ě': [1, ['E', ]],
    'ľ': [1, ['l', ]],
    'Ľ': [1, ['L', ]],
    'ň': [1, ['n', ]],
    'Ň': [1, ['N', ]],
    'ř': [1, ['r', ]],
    'Ř': [1, ['R', ]],
    'š': [1, ['s', ]],
    'Š': [1, ['S', ]],
    'ť': [1, ['t', ]],
    'Ť': [1, ['T', ]],
    'ž': [1, ['z', ]],
    'Ž': [1, ['Z', ]],
    'ˇ': [1, [' ', ]],
    'ů': [2, ['u', ]],
    'Ů': [2, ['U', ]],
    '°': [2, [' ', ]],
    'â': [3, ['a', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'Â': [3, ['A', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    '^': [3, [' ', ]],
    'ă': [4, ['a', ]],
    'Ă': [4, ['A', ]],
    '˘': [4, [' ', ]],
    'ą': [5, ['a', ]],
    'Ą': [5, ['A', ]],
    'ę': [5, ['e', ]],
    'Ę': [5, ['E', ]],
    '˛': [5, [' ', ]],
    'ż': [6, ['z', ]],
    'Ż': [6, ['Z', ]],
    '·': [6, [' ', ]],
    'ő': [7, ['o', ]],
    'Ő': [7, ['O', ]],
    'ű': [7, ['u', ]],
    'Ű': [7, ['U', ]],
    '˝': [7, [' ', ]],
    'ä': [8, ['a', ]],
    'Ä': [8, ['A', ]],
    'ö': [8, ['o', ]],
    'Ö': [8, ['O', ]],
    'ü': [8, ['u', ]],
    'Ü': [8, ['U', ]],
    '¨': [8, [' ', ]],
    'ç': [9, ['c', ]],
    'Ç': [9, ['C', ]],
    'ş': [9, ['s', ]],
    'Ş': [9, ['S', ]],
    'ţ': [9, ['t', ]],
    'Ţ': [9, ['T', ]],
    '¸': [9, [' ', ]],
  },
  accents: [
    {0x0: 0xd, 0x2: 0xa, },
    {0x1: 0xd, 0x2: 0x3, },
    {0x1: 0x29, 0x2: 0x6, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x7, },
    {0x2: 0x9, },
    {0x2: 0xb, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x0000041d,
  localeName: "sv-SE",
  displayName: "Swedish",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '§': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '½': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    'µ': { 0x2: 0x32, },
    '|': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'â': [3, ['a', ]],
    'ê': [3, ['e', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'û': [3, ['u', ]],
    'Â': [3, ['A', ]],
    'Ê': [3, ['E', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'Û': [3, ['U', ]],
    '^': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x0000041f,
  localeName: "tr",
  displayName: "Turkish Q",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '*': { 0x0: 0xc, 0x1: 0x37, },
    '-': { 0x0: 0xd, 0x1: 0x4a, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'ı': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ğ': { 0x0: 0x1a, 0x5: 0x1a, },
    'ü': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ş': { 0x0: 0x27, 0x5: 0x27, },
    'i': { 0x0: 0x28, 0x5: 0x28, 0x7: 0x17, 0x2: 0x17, },
    '"': { 0x0: 0x29, },
    ',': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    'ö': { 0x0: 0x33, 0x5: 0x33, },
    'ç': { 0x0: 0x34, 0x5: 0x34, },
    '.': { 0x0: 0x35, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x5, },
    '<': { 0x0: 0x56, 0x2: 0x29, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '\'': { 0x1: 0x3, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '_': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ğ': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ü': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ş': { 0x1: 0x27, 0x4: 0x27, },
    'İ': { 0x1: 0x28, 0x3: 0x17, 0x6: 0x17, 0x4: 0x28, },
    'é': { 0x1: 0x29, },
    ';': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    'Ö': { 0x1: 0x33, 0x4: 0x33, },
    'Ç': { 0x1: 0x34, 0x4: 0x34, },
    ':': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x2, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xd, },
    'Æ': { 0x3: 0x1e, 0x6: 0x1e, },
    'æ': { 0x7: 0x1e, 0x2: 0x1e, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '£': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '½': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    '|': { 0x2: 0xd, },
    '@': { 0x2: 0x10, },
    '€': { 0x2: 0x12, },
    '₺': { 0x2: 0x14, },
    'ß': { 0x2: 0x1f, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', 'ı', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', 'İ', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', 'ı', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', 'İ', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'ã': [2, ['a', ]],
    'õ': [2, ['o', ]],
    'ñ': [2, ['n', ]],
    'Ã': [2, ['A', ]],
    'Õ': [2, ['O', ]],
    'Ñ': [2, ['N', ]],
    '~': [2, [' ', ]],
    'á': [3, ['a', ]],
    'é': [3, ['e', ]],
    'í': [3, ['i', 'ı', ]],
    'ó': [3, ['o', ]],
    'ú': [3, ['u', ]],
    'Á': [3, ['A', ]],
    'É': [3, ['E', ]],
    'Í': [3, ['I', 'İ', ]],
    'Ó': [3, ['O', ]],
    'Ú': [3, ['U', ]],
    '´': [3, [' ', ]],
    'à': [4, ['a', ]],
    'è': [4, ['e', ]],
    'ì': [4, ['i', 'ı', ]],
    'ò': [4, ['o', ]],
    'ù': [4, ['u', ]],
    'À': [4, ['A', ]],
    'È': [4, ['E', ]],
    'Ì': [4, ['I', 'İ', ]],
    'Ò': [4, ['O', ]],
    'Ù': [4, ['U', ]],
    '`': [4, [' ', ]],
  },
  accents: [
    {0x1: 0x4, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
    {0x2: 0x27, },
    {0x2: 0x2b, },
  ]
},
{
  klid: 0x00000422,
  localeName: "uk",
  displayName: "Ukrainian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'щ': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ї': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'і': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ж': { 0x0: 0x27, 0x5: 0x27, },
    'є': { 0x0: 0x28, 0x5: 0x28, },
    'ё': { 0x0: 0x29, 0x5: 0x29, },
    '\\': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'ь': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    '.': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    'ґ': { 0x0: 0x56, 0x5: 0x56, 0x7: 0x16, 0x2: 0x16, },
    '/': { 0x0: 0x35, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '№': { 0x1: 0x4, },
    ';': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    ':': { 0x1: 0x7, },
    '?': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Щ': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ї': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'І': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ж': { 0x1: 0x27, 0x4: 0x27, },
    'Є': { 0x1: 0x28, 0x4: 0x28, },
    'Ё': { 0x1: 0x29, 0x4: 0x29, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Ь': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    ',': { 0x1: 0x35, },
    'Ґ': { 0x1: 0x56, 0x3: 0x16, 0x6: 0x16, 0x4: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000424,
  localeName: "sl",
  displayName: "Slovenian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'š': { 0x0: 0x1a, 0x5: 0x1a, },
    'đ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'č': { 0x0: 0x27, 0x5: 0x27, },
    'ć': { 0x0: 0x28, 0x5: 0x28, },
    'ž': { 0x0: 0x2b, 0x5: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Š': { 0x1: 0x1a, 0x4: 0x1a, },
    'Đ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Č': { 0x1: 0x27, 0x4: 0x27, },
    'Ć': { 0x1: 0x28, 0x4: 0x28, },
    'Ž': { 0x1: 0x2b, 0x4: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '~': { 0x2: 0x2, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '€': { 0x2: 0x12, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    'ß': { 0x2: 0x28, },
    '¤': { 0x2: 0x2b, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
    'Ç': [0, ['C', ]],
    'ç': [0, ['c', ]],
    'Ş': [0, ['S', ]],
    'ş': [0, ['s', ]],
    '¸': [0, [' ', ]],
    'Ë': [1, ['E', ]],
    'ë': [1, ['e', ]],
    'Ü': [1, ['U', ]],
    'ü': [1, ['u', ]],
    'Ö': [1, ['O', ]],
    'ö': [1, ['o', ]],
    'Ä': [1, ['A', ]],
    'ä': [1, ['a', ]],
    '¨': [1, [' ', ]],
    'č': [2, ['c', ]],
    'Č': [2, ['C', ]],
    'ď': [2, ['d', ]],
    'Ď': [2, ['D', ]],
    'ě': [2, ['e', ]],
    'Ě': [2, ['E', ]],
    'ľ': [2, ['l', ]],
    'Ľ': [2, ['L', ]],
    'ň': [2, ['n', ]],
    'Ň': [2, ['N', ]],
    'ř': [2, ['r', ]],
    'Ř': [2, ['R', ]],
    'š': [2, ['s', ]],
    'Š': [2, ['S', ]],
    'ť': [2, ['t', ]],
    'Ť': [2, ['T', ]],
    'ž': [2, ['z', ]],
    'Ž': [2, ['Z', ]],
    'ˇ': [2, [' ', ]],
    'Î': [3, ['I', ]],
    'î': [3, ['i', ]],
    'Ô': [3, ['O', ]],
    'ô': [3, ['o', ]],
    'Â': [3, ['A', ]],
    'â': [3, ['a', ]],
    '^': [3, [' ', ]],
    'Ă': [4, ['A', ]],
    'ă': [4, ['a', ]],
    '˘': [4, [' ', ]],
    'Ů': [5, ['U', ]],
    'ů': [5, ['u', ]],
    '°': [5, [' ', ]],
    'Ę': [6, ['E', ]],
    'ę': [6, ['e', ]],
    'Ą': [6, ['A', ]],
    'ą': [6, ['a', ]],
    '˛': [6, [' ', ]],
    'Ż': [7, ['Z', ]],
    'ż': [7, ['z', ]],
    '˙': [7, [' ', ]],
    'Á': [8, ['A', ]],
    'á': [8, ['a', ]],
    'Ć': [8, ['C', ]],
    'ć': [8, ['c', ]],
    'É': [8, ['E', ]],
    'é': [8, ['e', ]],
    'Í': [8, ['I', ]],
    'í': [8, ['i', ]],
    'Ĺ': [8, ['L', ]],
    'ĺ': [8, ['l', ]],
    'Ń': [8, ['N', ]],
    'ń': [8, ['n', ]],
    'Ó': [8, ['O', ]],
    'ó': [8, ['o', ]],
    'Ŕ': [8, ['R', ]],
    'ŕ': [8, ['r', ]],
    'Ś': [8, ['S', ]],
    'ś': [8, ['s', ]],
    'Ú': [8, ['U', ]],
    'ú': [8, ['u', ]],
    'Ý': [8, ['Y', ]],
    'ý': [8, ['y', ]],
    'Ź': [8, ['Z', ]],
    'ź': [8, ['z', ]],
    '´': [8, [' ', ]],
    'Ű': [9, ['U', ]],
    'ű': [9, ['u', ]],
    'Ő': [9, ['O', ]],
    'ő': [9, ['o', ]],
    '˝': [9, [' ', ]],
  },
  accents: [
    {0x0: 0x29, 0x2: 0xd, },
    {0x1: 0x29, 0x2: 0xc, },
    {0x2: 0x3, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x6, },
    {0x2: 0x7, },
    {0x2: 0x9, },
    {0x2: 0xa, },
    {0x2: 0xb, },
  ]
},
{
  klid: 0x00000425,
  localeName: "et",
  displayName: "Estonian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ü': { 0x0: 0x1a, 0x5: 0x1a, },
    'õ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ü': { 0x1: 0x1a, 0x4: 0x1a, },
    'Õ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '@': { 0x3: 0x3, 0x2: 0x3, },
    '£': { 0x3: 0x4, 0x2: 0x4, },
    '$': { 0x3: 0x5, 0x2: 0x5, },
    '{': { 0x3: 0x8, 0x2: 0x8, },
    '[': { 0x3: 0x9, 0x2: 0x9, },
    ']': { 0x3: 0xa, 0x2: 0xa, },
    '}': { 0x3: 0xb, 0x2: 0xb, },
    '\\': { 0x3: 0xc, 0x2: 0xc, },
    '§': { 0x3: 0x1b, 0x2: 0x1b, },
    'Š': { 0x3: 0x1f, 0x6: 0x1f, },
    '^': { 0x3: 0x28, },
    '½': { 0x3: 0x2b, 0x2: 0x2b, },
    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },
    '|': { 0x3: 0x56, 0x2: 0x56, },
    'š': { 0x7: 0x1f, 0x2: 0x1f, },
    'ž': { 0x7: 0x2c, 0x2: 0x2c, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x28, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '€': { 0x2: 0x6, },
  },
  deadkeys: {
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    '´': [0, [' ', ]],
    'š': [1, ['s', ]],
    'Š': [1, ['S', ]],
    'č': [1, ['c', ]],
    'Č': [1, ['C', ]],
    'ž': [1, ['z', ]],
    'Ž': [1, ['Z', ]],
    'ˇ': [1, [' ', ]],
    'à': [2, ['a', ]],
    'ò': [2, ['o', ]],
    'è': [2, ['e', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'Ò': [2, ['O', ]],
    'È': [2, ['E', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'õ': [3, ['o', ]],
    'Õ': [3, ['O', ]],
    '~': [3, [' ', ]],
    'â': [4, ['a', ]],
    'î': [4, ['i', ]],
    'ê': [4, ['e', ]],
    'û': [4, ['u', ]],
    'ĝ': [4, ['g', ]],
    'Â': [4, ['A', ]],
    'Î': [4, ['I', ]],
    'Ê': [4, ['E', ]],
    'Û': [4, ['U', ]],
    'Ĝ': [4, ['G', ]],
    '^': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x29, },
    {0x1: 0xd, },
    {0x1: 0x29, },
    {0x2: 0x28, },
  ]
},
{
  klid: 0x00000426,
  localeName: "lv",
  displayName: "Latvian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    'f': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'ū': { 0x0: 0x10, 0x5: 0x10, },
    'g': { 0x0: 0x11, 0x5: 0x11, },
    'j': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    'm': { 0x0: 0x14, 0x5: 0x14, },
    'v': { 0x0: 0x15, 0x5: 0x15, },
    'n': { 0x0: 0x16, 0x5: 0x16, },
    'z': { 0x0: 0x17, 0x5: 0x17, },
    'ē': { 0x0: 0x18, 0x5: 0x18, },
    'č': { 0x0: 0x19, 0x5: 0x19, },
    'ž': { 0x0: 0x1a, 0x5: 0x1a, },
    'h': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'š': { 0x0: 0x1e, 0x5: 0x1e, },
    'u': { 0x0: 0x1f, 0x5: 0x1f, },
    's': { 0x0: 0x20, 0x5: 0x20, },
    'i': { 0x0: 0x21, 0x5: 0x21, },
    'l': { 0x0: 0x22, 0x5: 0x22, },
    'd': { 0x0: 0x23, 0x5: 0x23, },
    'a': { 0x0: 0x24, 0x5: 0x24, },
    't': { 0x0: 0x25, 0x5: 0x25, },
    'e': { 0x0: 0x26, 0x5: 0x26, },
    'c': { 0x0: 0x27, 0x5: 0x27, },
    '\xad': { 0x0: 0x29, },
    'ķ': { 0x0: 0x2b, 0x5: 0x2b, 0x7: 0x2f, 0x2: 0x2f, },
    'ņ': { 0x0: 0x2c, 0x5: 0x2c, },
    'b': { 0x0: 0x2d, 0x5: 0x2d, },
    'ī': { 0x0: 0x2e, 0x5: 0x2e, },
    'k': { 0x0: 0x2f, 0x5: 0x2f, },
    'p': { 0x0: 0x30, 0x5: 0x30, },
    'o': { 0x0: 0x31, 0x5: 0x31, },
    'ā': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    'ļ': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x4e, },
    'ģ': { 0x0: 0x56, 0x5: 0x56, 0x7: 0x11, 0x2: 0x11, },
    '/': { 0x0: 0x35, 0x1: 0x7, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '«': { 0x1: 0x3, 0x2: 0x2, },
    '»': { 0x1: 0x4, },
    '$': { 0x1: 0x5, 0x3: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x8, },
    '×': { 0x1: 0x9, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'F': { 0x1: 0xd, 0x4: 0xd, },
    'Ū': { 0x1: 0x10, 0x4: 0x10, },
    'G': { 0x1: 0x11, 0x4: 0x11, },
    'J': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'M': { 0x1: 0x14, 0x4: 0x14, },
    'V': { 0x1: 0x15, 0x4: 0x15, },
    'N': { 0x1: 0x16, 0x4: 0x16, },
    'Z': { 0x1: 0x17, 0x4: 0x17, },
    'Ē': { 0x1: 0x18, 0x4: 0x18, },
    'Č': { 0x1: 0x19, 0x4: 0x19, },
    'Ž': { 0x1: 0x1a, 0x4: 0x1a, },
    'H': { 0x1: 0x1b, 0x4: 0x1b, },
    'Š': { 0x1: 0x1e, 0x4: 0x1e, },
    'U': { 0x1: 0x1f, 0x4: 0x1f, },
    'S': { 0x1: 0x20, 0x4: 0x20, },
    'I': { 0x1: 0x21, 0x4: 0x21, },
    'L': { 0x1: 0x22, 0x4: 0x22, },
    'D': { 0x1: 0x23, 0x4: 0x23, },
    'A': { 0x1: 0x24, 0x4: 0x24, },
    'T': { 0x1: 0x25, 0x4: 0x25, },
    'E': { 0x1: 0x26, 0x4: 0x26, },
    'C': { 0x1: 0x27, 0x4: 0x27, },
    '?': { 0x1: 0x29, },
    'Ķ': { 0x1: 0x2b, 0x3: 0x2f, 0x6: 0x2f, 0x4: 0x2b, },
    'Ņ': { 0x1: 0x2c, 0x4: 0x2c, },
    'B': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ī': { 0x1: 0x2e, 0x4: 0x2e, },
    'K': { 0x1: 0x2f, 0x4: 0x2f, },
    'P': { 0x1: 0x30, 0x4: 0x30, },
    'O': { 0x1: 0x31, 0x4: 0x31, },
    'Ā': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, 0x3: 0xd, },
    ':': { 0x1: 0x34, 0x2: 0x9, },
    'Ļ': { 0x1: 0x35, 0x4: 0x35, },
    'Ģ': { 0x1: 0x56, 0x3: 0x11, 0x6: 0x11, 0x4: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '@': { 0x3: 0x3, },
    '#': { 0x3: 0x4, },
    '^': { 0x3: 0x7, },
    '±': { 0x3: 0x8, },
    '—': { 0x3: 0xc, },
    'Q': { 0x3: 0x10, 0x6: 0x10, },
    'Ŗ': { 0x3: 0x13, 0x6: 0x13, },
    'W': { 0x3: 0x14, 0x6: 0x14, },
    'Y': { 0x3: 0x15, 0x6: 0x15, },
    '{': { 0x3: 0x1a, },
    '}': { 0x3: 0x1b, },
    'X': { 0x3: 0x2d, 0x6: 0x2d, },
    'Õ': { 0x3: 0x31, 0x6: 0x31, },
    '|': { 0x3: 0x56, },
    'q': { 0x7: 0x10, 0x2: 0x10, },
    'ŗ': { 0x7: 0x13, 0x2: 0x13, },
    'w': { 0x7: 0x14, 0x2: 0x14, },
    'y': { 0x7: 0x15, 0x2: 0x15, },
    'x': { 0x7: 0x2d, 0x2: 0x2d, },
    'õ': { 0x7: 0x31, 0x2: 0x31, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\x1d': { 0x0: 0x2e, },
    '€': { 0x2: 0x5, },
    '"': { 0x2: 0x6, },
    '’': { 0x2: 0x7, },
    '–': { 0x2: 0xc, },
    '=': { 0x2: 0xd, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'ń': [0, ['n', ]],
    'ć': [0, ['c', ]],
    'ó': [0, ['o', ]],
    'é': [0, ['e', ]],
    'ś': [0, ['s', ]],
    'ź': [0, ['z', ]],
    'Ń': [0, ['N', ]],
    'Ć': [0, ['C', ]],
    'Ó': [0, ['O', ]],
    'É': [0, ['E', ]],
    'Ś': [0, ['S', ]],
    'Ź': [0, ['Z', ]],
    '´': [0, [' ', ]],
    'å': [1, ['a', ]],
    'Å': [1, ['A', ]],
    'ė': [1, ['e', ]],
    'Ė': [1, ['E', ]],
    'ż': [1, ['z', ]],
    'Ż': [1, ['Z', ]],
    'ġ': [1, ['g', ]],
    '°': [1, [' ', ]],
    'õ': [2, ['o', ]],
    'Õ': [2, ['O', ]],
    '~': [2, [' ', ]],
    'ä': [3, ['a', ]],
    'ü': [3, ['u', ]],
    'ö': [3, ['o', ]],
    'Ä': [3, ['A', ]],
    'Ü': [3, ['U', ]],
    'Ö': [3, ['O', ]],
    '¨': [3, [' ', ]],
  },
  accents: [
    {0x0: 0x28, 0x2: 0x28, },
    {0x1: 0x28, },
    {0x3: 0x6, },
    {0x3: 0x28, },
  ]
},
{
  klid: 0x00000427,
  localeName: "lt",
  displayName: "Lithuanian IBM",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '!': { 0x0: 0x2, },
    '"': { 0x0: 0x3, },
    '/': { 0x0: 0x4, 0x1: 0x35, },
    ';': { 0x0: 0x5, },
    ':': { 0x0: 0x6, },
    ',': { 0x0: 0x7, },
    '.': { 0x0: 0x8, },
    '?': { 0x0: 0x9, },
    '(': { 0x0: 0xa, },
    ')': { 0x0: 0xb, },
    '_': { 0x0: 0xc, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'ą': { 0x0: 0x10, 0x5: 0x10, },
    'ž': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'į': { 0x0: 0x1a, 0x5: 0x1a, },
    '“': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ų': { 0x0: 0x27, 0x5: 0x27, },
    'ė': { 0x0: 0x28, 0x5: 0x28, },
    '`': { 0x0: 0x29, },
    '|': { 0x0: 0x2b, 0x1: 0x56, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'ū': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    'č': { 0x0: 0x33, 0x5: 0x33, },
    'š': { 0x0: 0x34, 0x5: 0x34, },
    'ę': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '-': { 0x0: 0x4a, 0x1: 0xc, },
    '\\': { 0x0: 0x56, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, },
    '3': { 0x1: 0x4, },
    '4': { 0x1: 0x5, },
    '5': { 0x1: 0x6, },
    '6': { 0x1: 0x7, },
    '7': { 0x1: 0x8, },
    '8': { 0x1: 0x9, },
    '9': { 0x1: 0xa, },
    '0': { 0x1: 0xb, },
    '=': { 0x1: 0xd, },
    'Ą': { 0x1: 0x10, 0x4: 0x10, },
    'Ž': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Į': { 0x1: 0x1a, 0x4: 0x1a, },
    '”': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ų': { 0x1: 0x27, 0x4: 0x27, },
    'Ė': { 0x1: 0x28, 0x4: 0x28, },
    '~': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ū': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    'Č': { 0x1: 0x33, 0x4: 0x33, },
    'Š': { 0x1: 0x34, 0x4: 0x34, },
    'Ę': { 0x1: 0x35, 0x4: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0000042f,
  localeName: "mk",
  displayName: "Macedonian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'љ': { 0x0: 0x10, 0x5: 0x10, },
    'њ': { 0x0: 0x11, 0x5: 0x11, },
    'е': { 0x0: 0x12, 0x5: 0x12, },
    'р': { 0x0: 0x13, 0x5: 0x13, },
    'т': { 0x0: 0x14, 0x5: 0x14, },
    'ѕ': { 0x0: 0x15, 0x5: 0x15, },
    'у': { 0x0: 0x16, 0x5: 0x16, },
    'и': { 0x0: 0x17, 0x5: 0x17, },
    'о': { 0x0: 0x18, 0x5: 0x18, },
    'п': { 0x0: 0x19, 0x5: 0x19, },
    'ш': { 0x0: 0x1a, 0x5: 0x1a, },
    'ѓ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'а': { 0x0: 0x1e, 0x5: 0x1e, },
    'с': { 0x0: 0x1f, 0x5: 0x1f, },
    'д': { 0x0: 0x20, 0x5: 0x20, },
    'ф': { 0x0: 0x21, 0x5: 0x21, },
    'г': { 0x0: 0x22, 0x5: 0x22, },
    'х': { 0x0: 0x23, 0x5: 0x23, },
    'ј': { 0x0: 0x24, 0x5: 0x24, },
    'к': { 0x0: 0x25, 0x5: 0x25, },
    'л': { 0x0: 0x26, 0x5: 0x26, },
    'ч': { 0x0: 0x27, 0x5: 0x27, },
    'ќ': { 0x0: 0x28, 0x5: 0x28, },
    '`': { 0x0: 0x29, },
    'ж': { 0x0: 0x2b, 0x5: 0x2b, },
    'з': { 0x0: 0x2c, 0x5: 0x2c, },
    'џ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ц': { 0x0: 0x2e, 0x5: 0x2e, },
    'в': { 0x0: 0x2f, 0x5: 0x2f, },
    'б': { 0x0: 0x30, 0x5: 0x30, },
    'н': { 0x0: 0x31, 0x5: 0x31, },
    'м': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    'ё': { 0x0: 0x56, 0x5: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '„': { 0x1: 0x3, },
    '“': { 0x1: 0x4, },
    '’': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '‘': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Љ': { 0x1: 0x10, 0x4: 0x10, },
    'Њ': { 0x1: 0x11, 0x4: 0x11, },
    'Е': { 0x1: 0x12, 0x4: 0x12, },
    'Р': { 0x1: 0x13, 0x4: 0x13, },
    'Т': { 0x1: 0x14, 0x4: 0x14, },
    'Ѕ': { 0x1: 0x15, 0x4: 0x15, },
    'У': { 0x1: 0x16, 0x4: 0x16, },
    'И': { 0x1: 0x17, 0x4: 0x17, },
    'О': { 0x1: 0x18, 0x4: 0x18, },
    'П': { 0x1: 0x19, 0x4: 0x19, },
    'Ш': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ѓ': { 0x1: 0x1b, 0x4: 0x1b, },
    'А': { 0x1: 0x1e, 0x4: 0x1e, },
    'С': { 0x1: 0x1f, 0x4: 0x1f, },
    'Д': { 0x1: 0x20, 0x4: 0x20, },
    'Ф': { 0x1: 0x21, 0x4: 0x21, },
    'Г': { 0x1: 0x22, 0x4: 0x22, },
    'Х': { 0x1: 0x23, 0x4: 0x23, },
    'Ј': { 0x1: 0x24, 0x4: 0x24, },
    'К': { 0x1: 0x25, 0x4: 0x25, },
    'Л': { 0x1: 0x26, 0x4: 0x26, },
    'Ч': { 0x1: 0x27, 0x4: 0x27, },
    'Ќ': { 0x1: 0x28, 0x4: 0x28, },
    '~': { 0x1: 0x29, },
    'Ж': { 0x1: 0x2b, 0x4: 0x2b, },
    'З': { 0x1: 0x2c, 0x4: 0x2c, },
    'Џ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ц': { 0x1: 0x2e, 0x4: 0x2e, },
    'В': { 0x1: 0x2f, 0x4: 0x2f, },
    'Б': { 0x1: 0x30, 0x4: 0x30, },
    'Н': { 0x1: 0x31, 0x4: 0x31, },
    'М': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    'Ё': { 0x1: 0x56, 0x4: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '€': { 0x2: 0x12, },
    'Ђ': { 0x2: 0x1a, },
    'ђ': { 0x2: 0x1b, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'Ћ': { 0x2: 0x27, },
    'ћ': { 0x2: 0x28, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000438,
  localeName: "fo",
  displayName: "Faeroese",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    'ð': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'æ': { 0x0: 0x27, 0x5: 0x27, },
    'ø': { 0x0: 0x28, 0x5: 0x28, },
    '½': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ð': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Æ': { 0x1: 0x27, 0x4: 0x27, },
    'Ø': { 0x1: 0x28, 0x4: 0x28, },
    '§': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '\x1f': { 0x0: 0x35, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '|': { 0x2: 0xd, },
    'µ': { 0x2: 0x32, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'à': [1, ['a', ]],
    'è': [1, ['e', ]],
    'ì': [1, ['i', ]],
    'ò': [1, ['o', ]],
    'ù': [1, ['u', ]],
    'À': [1, ['A', ]],
    'È': [1, ['E', ]],
    'Ì': [1, ['I', ]],
    'Ò': [1, ['O', ]],
    'Ù': [1, ['U', ]],
    '`': [1, [' ', ]],
    'ä': [2, ['a', ]],
    'ë': [2, ['e', ]],
    'ï': [2, ['i', ]],
    'ö': [2, ['o', ]],
    'ü': [2, ['u', ]],
    'ÿ': [2, ['y', ]],
    'Ä': [2, ['A', ]],
    'Ë': [2, ['E', ]],
    'Ï': [2, ['I', ]],
    'Ö': [2, ['O', ]],
    'Ü': [2, ['U', ]],
    '¨': [2, [' ', ]],
    'ã': [3, ['a', ]],
    'õ': [3, ['o', ]],
    'ñ': [3, ['n', ]],
    'Ã': [3, ['A', ]],
    'Õ': [3, ['O', ]],
    'Ñ': [3, ['N', ]],
    '~': [3, [' ', ]],
    'â': [4, ['a', ]],
    'ê': [4, ['e', ]],
    'î': [4, ['i', ]],
    'ô': [4, ['o', ]],
    'û': [4, ['u', ]],
    'Â': [4, ['A', ]],
    'Ê': [4, ['E', ]],
    'Î': [4, ['I', ]],
    'Ô': [4, ['O', ]],
    'Û': [4, ['U', ]],
    '^': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x1: 0xd, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
    {0x2: 0x28, },
  ]
},
{
  klid: 0x0000043a,
  localeName: "mt",
  displayName: "Maltese 47-Key",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ġ': { 0x0: 0x1a, 0x5: 0x1a, },
    'ħ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    'ċ': { 0x0: 0x29, 0x5: 0x29, },
    'ż': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '€': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ġ': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ħ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    'Ċ': { 0x1: 0x29, 0x4: 0x29, },
    'Ż': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    'È': { 0x3: 0x12, 0x6: 0x12, },
    'Ù': { 0x3: 0x16, 0x6: 0x16, },
    'Ì': { 0x3: 0x17, 0x6: 0x17, },
    'Ò': { 0x3: 0x18, 0x6: 0x18, },
    '{': { 0x3: 0x1a, },
    '}': { 0x3: 0x1b, },
    'À': { 0x3: 0x1e, 0x6: 0x1e, },
    '~': { 0x3: 0x29, },
    '|': { 0x3: 0x2b, },
    'è': { 0x7: 0x12, 0x2: 0x12, },
    'ù': { 0x7: 0x16, 0x2: 0x16, },
    'ì': { 0x7: 0x17, 0x2: 0x17, },
    'ò': { 0x7: 0x18, 0x2: 0x18, },
    'à': { 0x7: 0x1e, 0x2: 0x1e, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '£': { 0x2: 0x4, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '`': { 0x2: 0x29, },
    '\\': { 0x2: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0000043b,
  localeName: "se-Latn-NO",
  displayName: "Norwegian with Sami",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\\': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ø': { 0x0: 0x27, 0x5: 0x27, },
    'æ': { 0x0: 0x28, 0x5: 0x28, },
    '|': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ø': { 0x1: 0x27, 0x4: 0x27, },
    'Æ': { 0x1: 0x28, 0x4: 0x28, },
    '§': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    'Â': { 0x3: 0x10, 0x6: 0x10, },
    'Ŧ': { 0x3: 0x14, 0x6: 0x14, },
    'Ï': { 0x3: 0x17, 0x6: 0x17, },
    'Õ': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    'Š': { 0x3: 0x1f, 0x6: 0x1f, },
    'Đ': { 0x3: 0x20, 0x6: 0x20, },
    'Ǥ': { 0x3: 0x21, 0x6: 0x21, },
    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },
    'Ȟ': { 0x3: 0x23, 0x6: 0x23, },
    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },
    'Ö': { 0x3: 0x27, 0x6: 0x27, },
    'Ä': { 0x3: 0x28, 0x6: 0x28, },
    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },
    'Č': { 0x3: 0x2e, 0x6: 0x2e, },
    'Ǯ': { 0x3: 0x2f, 0x6: 0x2f, },
    'Ʒ': { 0x3: 0x30, 0x6: 0x30, },
    'Ŋ': { 0x3: 0x31, 0x6: 0x31, },
    'â': { 0x7: 0x10, 0x2: 0x10, },
    'ŧ': { 0x7: 0x14, 0x2: 0x14, },
    'ï': { 0x7: 0x17, 0x2: 0x17, },
    'õ': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    'š': { 0x7: 0x1f, 0x2: 0x1f, },
    'đ': { 0x7: 0x20, 0x2: 0x20, },
    'ǥ': { 0x7: 0x21, 0x2: 0x21, },
    'ǧ': { 0x7: 0x22, 0x2: 0x22, },
    'ȟ': { 0x7: 0x23, 0x2: 0x23, },
    'ǩ': { 0x7: 0x25, 0x2: 0x25, },
    'ö': { 0x7: 0x27, 0x2: 0x27, },
    'ä': { 0x7: 0x28, 0x2: 0x28, },
    'ž': { 0x7: 0x2c, 0x2: 0x2c, },
    'č': { 0x7: 0x2e, 0x2: 0x2e, },
    'ǯ': { 0x7: 0x2f, 0x2: 0x2f, },
    'ʒ': { 0x7: 0x30, 0x2: 0x30, },
    'ŋ': { 0x7: 0x31, 0x2: 0x31, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    'µ': { 0x2: 0x32, },
  },
  deadkeys: {
    'ä': [0, ['a', ]],
    'Ä': [0, ['A', ]],
    'ë': [0, ['e', ]],
    'Ë': [0, ['E', ]],
    'ï': [0, ['i', ]],
    'Ï': [0, ['I', ]],
    'ö': [0, ['o', ]],
    'Ö': [0, ['O', ]],
    'ü': [0, ['u', ]],
    'Ü': [0, ['U', ]],
    'ẅ': [0, ['w', ]],
    'Ẅ': [0, ['W', ]],
    'ÿ': [0, ['y', ]],
    'Ÿ': [0, ['Y', ]],
    '¨': [0, [' ', ]],
    'à': [1, ['a', ]],
    'À': [1, ['A', ]],
    'è': [1, ['e', ]],
    'È': [1, ['E', ]],
    'ì': [1, ['i', ]],
    'Ì': [1, ['I', ]],
    'ò': [1, ['o', ]],
    'Ò': [1, ['O', ]],
    'ù': [1, ['u', ]],
    'Ù': [1, ['U', ]],
    'ẁ': [1, ['w', ]],
    'Ẁ': [1, ['W', ]],
    'ỳ': [1, ['y', ]],
    'Ỳ': [1, ['Y', ]],
    '`': [1, [' ', ]],
    'â': [2, ['a', ]],
    'Â': [2, ['A', ]],
    'ĉ': [2, ['c', ]],
    'Ĉ': [2, ['C', ]],
    'ê': [2, ['e', ]],
    'Ê': [2, ['E', ]],
    'ĝ': [2, ['g', ]],
    'Ĝ': [2, ['G', ]],
    'ĥ': [2, ['h', ]],
    'Ĥ': [2, ['H', ]],
    'î': [2, ['i', ]],
    'Î': [2, ['I', ]],
    'ĵ': [2, ['j', ]],
    'Ĵ': [2, ['J', ]],
    'ô': [2, ['o', ]],
    'Ô': [2, ['O', ]],
    'ŝ': [2, ['s', ]],
    'Ŝ': [2, ['S', ]],
    'û': [2, ['u', ]],
    'Û': [2, ['U', ]],
    'ŵ': [2, ['w', ]],
    'Ŵ': [2, ['W', ]],
    'ŷ': [2, ['y', ]],
    'Ŷ': [2, ['Y', ]],
    '^': [2, [' ', ]],
    'á': [3, ['a', ]],
    'Á': [3, ['A', ]],
    'ć': [3, ['c', ]],
    'Ć': [3, ['C', ]],
    'é': [3, ['e', ]],
    'É': [3, ['E', ]],
    'í': [3, ['i', ]],
    'Í': [3, ['I', ]],
    'ĺ': [3, ['l', ]],
    'Ĺ': [3, ['L', ]],
    'ń': [3, ['n', ]],
    'Ń': [3, ['N', ]],
    'ó': [3, ['o', ]],
    'Ó': [3, ['O', ]],
    'ŕ': [3, ['r', ]],
    'Ŕ': [3, ['R', ]],
    'ś': [3, ['s', ]],
    'Ś': [3, ['S', ]],
    'ú': [3, ['u', ]],
    'Ú': [3, ['U', ]],
    'ẃ': [3, ['w', ]],
    'Ẃ': [3, ['W', ]],
    'ý': [3, ['y', ]],
    'Ý': [3, ['Y', ]],
    'ź': [3, ['z', ]],
    'Ź': [3, ['Z', ]],
    'ǻ': [3, ['å', ]],
    'Ǻ': [3, ['Å', ]],
    'ǽ': [3, ['æ', ]],
    'Ǽ': [3, ['Æ', ]],
    'ǿ': [3, ['ø', ]],
    'Ǿ': [3, ['Ø', ]],
    '´': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'Ã': [4, ['A', ]],
    'ĩ': [4, ['i', ]],
    'Ĩ': [4, ['I', ]],
    'ñ': [4, ['n', ]],
    'Ñ': [4, ['N', ]],
    'õ': [4, ['o', ]],
    'Õ': [4, ['O', ]],
    'ũ': [4, ['u', ]],
    'Ũ': [4, ['U', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0xd, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x0000043f,
  localeName: "kk",
  displayName: "Kazakh",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '"': { 0x0: 0x2, },
    'ә': { 0x0: 0x3, 0x5: 0x3, },
    'і': { 0x0: 0x4, 0x5: 0x4, },
    'ң': { 0x0: 0x5, 0x5: 0x5, },
    'ғ': { 0x0: 0x6, 0x5: 0x6, },
    ',': { 0x0: 0x7, },
    '.': { 0x0: 0x8, },
    'ү': { 0x0: 0x9, 0x5: 0x9, },
    'ұ': { 0x0: 0xa, 0x5: 0xa, },
    'қ': { 0x0: 0xb, 0x5: 0xb, },
    'ө': { 0x0: 0xc, 0x5: 0xc, },
    'һ': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'щ': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'ы': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ж': { 0x0: 0x27, 0x5: 0x27, },
    'э': { 0x0: 0x28, 0x5: 0x28, },
    '(': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, 0x5: 0x56, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'ь': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    '№': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '-': { 0x0: 0x4a, 0x1: 0x4a, },
    '+': { 0x0: 0x4e, 0x1: 0x4e, },
    '/': { 0x0: 0x35, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    'Ә': { 0x1: 0x3, 0x4: 0x3, },
    'І': { 0x1: 0x4, 0x4: 0x4, },
    'Ң': { 0x1: 0x5, 0x4: 0x5, },
    'Ғ': { 0x1: 0x6, 0x4: 0x6, },
    ';': { 0x1: 0x7, },
    ':': { 0x1: 0x8, },
    'Ү': { 0x1: 0x9, 0x4: 0x9, },
    'Ұ': { 0x1: 0xa, 0x4: 0xa, },
    'Қ': { 0x1: 0xb, 0x4: 0xb, },
    'Ө': { 0x1: 0xc, 0x4: 0xc, },
    'Һ': { 0x1: 0xd, 0x4: 0xd, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Щ': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ж': { 0x1: 0x27, 0x4: 0x27, },
    'Э': { 0x1: 0x28, 0x4: 0x28, },
    ')': { 0x1: 0x29, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Ь': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    '?': { 0x1: 0x35, },
    '|': { 0x1: 0x56, 0x4: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000440,
  localeName: "ky-Cyrl",
  displayName: "Kyrgyz Cyrillic",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'щ': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'ы': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ж': { 0x0: 0x27, 0x5: 0x27, },
    'э': { 0x0: 0x28, 0x5: 0x28, },
    'ё': { 0x0: 0x29, 0x5: 0x29, },
    '\\': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'ь': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    '.': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '/': { 0x0: 0x35, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '№': { 0x1: 0x4, },
    ';': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    ':': { 0x1: 0x7, },
    '?': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Щ': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ж': { 0x1: 0x27, 0x4: 0x27, },
    'Э': { 0x1: 0x28, 0x4: 0x28, },
    'Ё': { 0x1: 0x29, 0x4: 0x29, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Ь': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    ',': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    'Ү': { 0x3: 0x12, 0x6: 0x12, },
    'Ң': { 0x3: 0x15, 0x6: 0x15, },
    'Ө': { 0x3: 0x24, 0x6: 0x24, },
    'ү': { 0x7: 0x12, 0x2: 0x12, },
    'ң': { 0x7: 0x15, 0x2: 0x15, },
    'ө': { 0x7: 0x24, 0x2: 0x24, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000444,
  localeName: "tt-Cyrl",
  displayName: "Tatar (Legacy)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ө': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'ә': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ү': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'ы': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ң': { 0x0: 0x27, 0x5: 0x27, },
    'э': { 0x0: 0x28, 0x5: 0x28, },
    'һ': { 0x0: 0x29, 0x5: 0x29, },
    '\\': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'җ': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    '.': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    'ґ': { 0x0: 0x56, 0x5: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '№': { 0x1: 0x4, },
    ';': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    ':': { 0x1: 0x7, },
    '?': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ө': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Ә': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ү': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ң': { 0x1: 0x27, 0x4: 0x27, },
    'Э': { 0x1: 0x28, 0x4: 0x28, },
    'Һ': { 0x1: 0x29, 0x4: 0x29, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Җ': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    ',': { 0x1: 0x35, },
    'Ґ': { 0x1: 0x56, 0x4: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '₽': { 0x3: 0x9, },
    'Ц': { 0x3: 0x11, 0x6: 0x11, },
    'Ҡ': { 0x3: 0x13, 0x6: 0x13, },
    'Ғ': { 0x3: 0x16, 0x6: 0x16, },
    'Щ': { 0x3: 0x18, 0x6: 0x18, },
    'Ъ': { 0x3: 0x1b, 0x6: 0x1b, },
    'Ж': { 0x3: 0x27, 0x6: 0x27, },
    'Ё': { 0x3: 0x29, 0x6: 0x29, },
    'Ь': { 0x3: 0x32, 0x6: 0x32, },
    'ц': { 0x7: 0x11, 0x2: 0x11, },
    'ҡ': { 0x7: 0x13, 0x2: 0x13, },
    'ғ': { 0x7: 0x16, 0x2: 0x16, },
    'щ': { 0x7: 0x18, 0x2: 0x18, },
    'ъ': { 0x7: 0x1b, 0x2: 0x1b, },
    'ж': { 0x7: 0x27, 0x2: 0x27, },
    'ё': { 0x7: 0x29, 0x2: 0x29, },
    'ь': { 0x7: 0x32, 0x2: 0x32, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '[': { 0x2: 0x8, },
    ']': { 0x2: 0x9, },
    '{': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\'': { 0x2: 0x28, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000450,
  localeName: "mn-Cyrl",
  displayName: "Mongolian Cyrillic",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '№': { 0x0: 0x2, },
    '-': { 0x0: 0x3, 0x1: 0x4a, },
    '"': { 0x0: 0x4, },
    '₮': { 0x0: 0x5, },
    ':': { 0x0: 0x6, },
    '.': { 0x0: 0x7, },
    '_': { 0x0: 0x8, },
    ',': { 0x0: 0x9, },
    '%': { 0x0: 0xa, },
    '?': { 0x0: 0xb, },
    'е': { 0x0: 0xc, 0x5: 0xc, },
    'щ': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'ф': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'ж': { 0x0: 0x13, 0x5: 0x13, },
    'э': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'ү': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'к': { 0x0: 0x1a, 0x5: 0x1a, },
    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'й': { 0x0: 0x1e, 0x5: 0x1e, },
    'ы': { 0x0: 0x1f, 0x5: 0x1f, },
    'б': { 0x0: 0x20, 0x5: 0x20, },
    'ө': { 0x0: 0x21, 0x5: 0x21, },
    'а': { 0x0: 0x22, 0x5: 0x22, },
    'х': { 0x0: 0x23, 0x5: 0x23, },
    'р': { 0x0: 0x24, 0x5: 0x24, },
    'о': { 0x0: 0x25, 0x5: 0x25, },
    'л': { 0x0: 0x26, 0x5: 0x26, },
    'д': { 0x0: 0x27, 0x5: 0x27, },
    'п': { 0x0: 0x28, 0x5: 0x28, },
    '=': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'ё': { 0x0: 0x2e, 0x5: 0x2e, },
    'с': { 0x0: 0x2f, 0x5: 0x2f, },
    'м': { 0x0: 0x30, 0x5: 0x30, },
    'и': { 0x0: 0x31, 0x5: 0x31, },
    'т': { 0x0: 0x32, 0x5: 0x32, },
    'ь': { 0x0: 0x33, 0x5: 0x33, },
    'в': { 0x0: 0x34, 0x5: 0x34, },
    'ю': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x29, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, },
    '3': { 0x1: 0x4, },
    '4': { 0x1: 0x5, },
    '5': { 0x1: 0x6, },
    '6': { 0x1: 0x7, },
    '7': { 0x1: 0x8, },
    '8': { 0x1: 0x9, },
    '9': { 0x1: 0xa, },
    '0': { 0x1: 0xb, },
    'Е': { 0x1: 0xc, 0x4: 0xc, },
    'Щ': { 0x1: 0xd, 0x4: 0xd, },
    'Ф': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'Ж': { 0x1: 0x13, 0x4: 0x13, },
    'Э': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Ү': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'К': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },
    'Й': { 0x1: 0x1e, 0x4: 0x1e, },
    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },
    'Б': { 0x1: 0x20, 0x4: 0x20, },
    'Ө': { 0x1: 0x21, 0x4: 0x21, },
    'А': { 0x1: 0x22, 0x4: 0x22, },
    'Х': { 0x1: 0x23, 0x4: 0x23, },
    'Р': { 0x1: 0x24, 0x4: 0x24, },
    'О': { 0x1: 0x25, 0x4: 0x25, },
    'Л': { 0x1: 0x26, 0x4: 0x26, },
    'Д': { 0x1: 0x27, 0x4: 0x27, },
    'П': { 0x1: 0x28, 0x4: 0x28, },
    '|': { 0x1: 0x2b, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ё': { 0x1: 0x2e, 0x4: 0x2e, },
    'С': { 0x1: 0x2f, 0x4: 0x2f, },
    'М': { 0x1: 0x30, 0x4: 0x30, },
    'И': { 0x1: 0x31, 0x4: 0x31, },
    'Т': { 0x1: 0x32, 0x4: 0x32, },
    'Ь': { 0x1: 0x33, 0x4: 0x33, },
    'В': { 0x1: 0x34, 0x4: 0x34, },
    'Ю': { 0x1: 0x35, 0x4: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000452,
  localeName: "cy",
  displayName: "United Kingdom Extended",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '#': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, 0x3: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '@': { 0x1: 0x28, },
    '¬': { 0x1: 0x29, },
    '~': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '|': { 0x1: 0x56, 0x3: 0x1b, },
    'Ẃ': { 0x3: 0x11, 0x6: 0x11, },
    'É': { 0x3: 0x12, 0x6: 0x12, },
    'Ý': { 0x3: 0x15, 0x6: 0x15, },
    'Ú': { 0x3: 0x16, 0x6: 0x16, },
    'Í': { 0x3: 0x17, 0x6: 0x17, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    '`': { 0x3: 0x28, },
    'Ç': { 0x3: 0x2e, 0x6: 0x2e, },
    'ẃ': { 0x7: 0x11, 0x2: 0x11, },
    'é': { 0x7: 0x12, 0x2: 0x12, },
    'ý': { 0x7: 0x15, 0x2: 0x15, },
    'ú': { 0x7: 0x16, 0x2: 0x16, },
    'í': { 0x7: 0x17, 0x2: 0x17, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    'ç': { 0x7: 0x2e, 0x2: 0x2e, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '€': { 0x2: 0x5, },
    '¦': { 0x2: 0x29, },
  },
  deadkeys: {
    'à': [0, ['a', ]],
    'À': [0, ['A', ]],
    'è': [0, ['e', ]],
    'È': [0, ['E', ]],
    'ì': [0, ['i', ]],
    'Ì': [0, ['I', ]],
    'ò': [0, ['o', ]],
    'Ò': [0, ['O', ]],
    'ù': [0, ['u', ]],
    'Ù': [0, ['U', ]],
    'ẁ': [0, ['w', ]],
    'Ẁ': [0, ['W', ]],
    'ỳ': [0, ['y', ]],
    'Ỳ': [0, ['Y', ]],
    '`': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'Ä': [1, ['A', ]],
    'ë': [1, ['e', ]],
    'Ë': [1, ['E', ]],
    'ï': [1, ['i', ]],
    'Ï': [1, ['I', ]],
    'ö': [1, ['o', ]],
    'Ö': [1, ['O', ]],
    'ü': [1, ['u', ]],
    'Ü': [1, ['U', ]],
    'ẅ': [1, ['w', ]],
    'Ẅ': [1, ['W', ]],
    'ÿ': [1, ['y', ]],
    'Ÿ': [1, ['Y', ]],
    '¨': [1, [' ', ]],
    'â': [2, ['a', ]],
    'Â': [2, ['A', ]],
    'ê': [2, ['e', ]],
    'Ê': [2, ['E', ]],
    'î': [2, ['i', ]],
    'Î': [2, ['I', ]],
    'ô': [2, ['o', ]],
    'Ô': [2, ['O', ]],
    'û': [2, ['u', ]],
    'Û': [2, ['U', ]],
    'ŵ': [2, ['w', ]],
    'Ŵ': [2, ['W', ]],
    'ŷ': [2, ['y', ]],
    'Ŷ': [2, ['Y', ]],
    '^': [2, [' ', ]],
    'á': [3, ['a', ]],
    'Á': [3, ['A', ]],
    'é': [3, ['e', ]],
    'É': [3, ['E', ]],
    'í': [3, ['i', ]],
    'Í': [3, ['I', ]],
    'ó': [3, ['o', ]],
    'Ó': [3, ['O', ]],
    'ú': [3, ['u', ]],
    'Ú': [3, ['U', ]],
    'ẃ': [3, ['w', ]],
    'Ẃ': [3, ['W', ]],
    'ý': [3, ['y', ]],
    'Ý': [3, ['Y', ]],
    '´': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'Ã': [4, ['A', ]],
    'ñ': [4, ['n', ]],
    'Ñ': [4, ['N', ]],
    'õ': [4, ['o', ]],
    'Õ': [4, ['O', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x29, },
    {0x2: 0x3, },
    {0x2: 0x7, },
    {0x2: 0x28, },
    {0x2: 0x2b, },
  ]
},
{
  klid: 0x0000046e,
  localeName: "lb",
  displayName: "Luxembourgish",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'è': { 0x0: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'é': { 0x0: 0x27, },
    'à': { 0x0: 0x28, },
    '§': { 0x0: 0x29, 0x2: 0x6, },
    '$': { 0x0: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x4, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x2, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '"': { 0x1: 0x3, },
    'ç': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'ü': { 0x1: 0x1a, },
    '!': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'ö': { 0x1: 0x27, },
    'ä': { 0x1: 0x28, },
    '°': { 0x1: 0x29, 0x2: 0x5, },
    '£': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\x1f': { 0x0: 0x35, },
    '¦': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '¬': { 0x2: 0x7, },
    '|': { 0x2: 0x8, },
    '¢': { 0x2: 0x9, },
    '€': { 0x2: 0x12, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '{': { 0x2: 0x28, },
    '}': { 0x2: 0x2b, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '"': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'á': [3, ['a', ]],
    'é': [3, ['e', ]],
    'í': [3, ['i', ]],
    'ó': [3, ['o', ]],
    'ú': [3, ['u', ]],
    'ý': [3, ['y', ]],
    'Á': [3, ['A', ]],
    'É': [3, ['E', ]],
    'Í': [3, ['I', ]],
    'Ó': [3, ['O', ]],
    'Ú': [3, ['U', ]],
    'Ý': [3, ['Y', ]],
    '´': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00000481,
  localeName: "mi-Latn",
  displayName: "Maori",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
    'ā': [0, ['a', ]],
    'ē': [0, ['e', ]],
    'ī': [0, ['i', ]],
    'ō': [0, ['o', ]],
    'ū': [0, ['u', ]],
    'Ā': [0, ['A', ]],
    'Ē': [0, ['E', ]],
    'Ī': [0, ['I', ]],
    'Ō': [0, ['O', ]],
    'Ū': [0, ['U', ]],
    '`': [0, ['`', ]],
    '~': [0, [' ', ]],
  },
  accents: [
    {0x0: 0x29, },
  ]
},
{
  klid: 0x00000807,
  localeName: "de-CH",
  displayName: "Swiss German",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ü': { 0x0: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, },
    'ä': { 0x0: 0x28, },
    '§': { 0x0: 0x29, 0x2: 0x6, },
    '$': { 0x0: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x4, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x2, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '"': { 0x1: 0x3, },
    'ç': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'è': { 0x1: 0x1a, },
    '!': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'é': { 0x1: 0x27, },
    'à': { 0x1: 0x28, },
    '°': { 0x1: 0x29, 0x2: 0x5, },
    '£': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    'È': { 0x5: 0x1a, },
    'É': { 0x5: 0x27, },
    'À': { 0x5: 0x28, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\x1f': { 0x0: 0x35, },
    '¦': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '¬': { 0x2: 0x7, },
    '|': { 0x2: 0x8, },
    '¢': { 0x2: 0x9, },
    '€': { 0x2: 0x12, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '{': { 0x2: 0x28, },
    '}': { 0x2: 0x2b, },
    '\\': { 0x2: 0x56, },
    'Ü': { 0x4: 0x1a, },
    'Ö': { 0x4: 0x27, },
    'Ä': { 0x4: 0x28, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'á': [3, ['a', ]],
    'é': [3, ['e', ]],
    'í': [3, ['i', ]],
    'ó': [3, ['o', ]],
    'ú': [3, ['u', ]],
    'ý': [3, ['y', ]],
    'Á': [3, ['A', ]],
    'É': [3, ['E', ]],
    'Í': [3, ['I', ]],
    'Ó': [3, ['O', ]],
    'Ú': [3, ['U', ]],
    'Ý': [3, ['Y', ]],
    '´': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00000809,
  localeName: "en-GB",
  displayName: "United Kingdom",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '#': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, 0x2: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '@': { 0x1: 0x28, },
    '¬': { 0x1: 0x29, },
    '~': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '|': { 0x1: 0x56, 0x3: 0x2b, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    'É': { 0x3: 0x12, 0x6: 0x12, },
    'Ú': { 0x3: 0x16, 0x6: 0x16, },
    'Í': { 0x3: 0x17, 0x6: 0x17, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    'é': { 0x7: 0x12, 0x2: 0x12, },
    'ú': { 0x7: 0x16, 0x2: 0x16, },
    'í': { 0x7: 0x17, 0x2: 0x17, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '€': { 0x2: 0x5, },
    '¦': { 0x2: 0x29, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0000080a,
  localeName: "es-MX",
  displayName: "Latin American",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '¿': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '+': { 0x0: 0x1b, 0x1: 0x4e, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ñ': { 0x0: 0x27, 0x5: 0x27, },
    '{': { 0x0: 0x28, },
    '|': { 0x0: 0x29, },
    '}': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '¡': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ñ': { 0x1: 0x27, 0x4: 0x27, },
    '[': { 0x1: 0x28, },
    '°': { 0x1: 0x29, },
    ']': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1c': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x2b, },
    '\x1f': { 0x0: 0x35, },
    '\\': { 0x2: 0xc, },
    '@': { 0x2: 0x10, },
    '~': { 0x2: 0x1b, },
    '¬': { 0x2: 0x29, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'â': [2, ['a', ]],
    'ê': [2, ['e', ]],
    'î': [2, ['i', ]],
    'ô': [2, ['o', ]],
    'û': [2, ['u', ]],
    'Â': [2, ['A', ]],
    'Ê': [2, ['E', ]],
    'Î': [2, ['I', ]],
    'Ô': [2, ['O', ]],
    'Û': [2, ['U', ]],
    '^': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, },
    {0x1: 0x1a, },
    {0x2: 0x28, },
    {0x2: 0x2b, },
  ]
},
{
  klid: 0x0000080c,
  localeName: "fr-BE",
  displayName: "Belgian French",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '&': { 0x0: 0x2, 0x5: 0x2, },
    'é': { 0x0: 0x3, 0x5: 0x3, },
    '"': { 0x0: 0x4, 0x5: 0x4, },
    '\'': { 0x0: 0x5, 0x5: 0x5, },
    '(': { 0x0: 0x6, 0x5: 0x6, },
    '§': { 0x0: 0x7, 0x5: 0x7, },
    'è': { 0x0: 0x8, 0x5: 0x8, },
    '!': { 0x0: 0x9, 0x5: 0x9, },
    'ç': { 0x0: 0xa, 0x5: 0xa, },
    'à': { 0x0: 0xb, 0x5: 0xb, },
    ')': { 0x0: 0xc, 0x5: 0xc, },
    '-': { 0x0: 0xd, 0x1: 0x4a, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'a': { 0x0: 0x10, 0x5: 0x10, },
    'z': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '$': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'q': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'm': { 0x0: 0x27, 0x5: 0x27, },
    'ù': { 0x0: 0x28, 0x5: 0x28, },
    '²': { 0x0: 0x29, },
    'µ': { 0x0: 0x2b, 0x5: 0x2b, },
    'w': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    ',': { 0x0: 0x32, 0x5: 0x32, },
    ';': { 0x0: 0x33, 0x5: 0x33, },
    ':': { 0x0: 0x34, 0x5: 0x34, },
    '=': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x35, 0x4: 0x35, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, 0x4: 0x2, },
    '2': { 0x1: 0x3, 0x4: 0x3, },
    '3': { 0x1: 0x4, 0x4: 0x4, },
    '4': { 0x1: 0x5, 0x4: 0x5, },
    '5': { 0x1: 0x6, 0x4: 0x6, },
    '6': { 0x1: 0x7, 0x4: 0x7, },
    '7': { 0x1: 0x8, 0x4: 0x8, },
    '8': { 0x1: 0x9, 0x4: 0x9, },
    '9': { 0x1: 0xa, 0x4: 0xa, },
    '0': { 0x1: 0xb, 0x4: 0xb, },
    '°': { 0x1: 0xc, 0x4: 0xc, },
    '_': { 0x1: 0xd, 0x4: 0xd, },
    'A': { 0x1: 0x10, 0x4: 0x10, },
    'Z': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Q': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'M': { 0x1: 0x27, 0x4: 0x27, },
    '%': { 0x1: 0x28, 0x4: 0x28, },
    '³': { 0x1: 0x29, },
    '£': { 0x1: 0x2b, 0x4: 0x2b, },
    'W': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    '?': { 0x1: 0x32, 0x4: 0x32, },
    '.': { 0x1: 0x33, 0x4: 0x33, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '|': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '{': { 0x2: 0x5, },
    '[': { 0x2: 0x6, },
    '^': { 0x2: 0x7, },
    '}': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
    ']': { 0x2: 0x1b, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'á': [2, ['a', ]],
    'é': [2, ['e', ]],
    'í': [2, ['i', ]],
    'ó': [2, ['o', ]],
    'ú': [2, ['u', ]],
    'ý': [2, ['y', ]],
    'Á': [2, ['A', ]],
    'É': [2, ['E', ]],
    'Í': [2, ['I', ]],
    'Ó': [2, ['O', ]],
    'Ú': [2, ['U', ]],
    'Ý': [2, ['Y', ]],
    '´': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, 0x5: 0x1a, },
    {0x1: 0x1a, 0x4: 0x1a, },
    {0x3: 0x28, 0x2: 0x28, },
    {0x3: 0x2b, 0x2: 0x2b, },
    {0x3: 0x35, 0x2: 0x35, },
  ]
},
{
  klid: 0x00000813,
  localeName: "nl-BE",
  displayName: "Belgian (Period)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '&': { 0x0: 0x2, 0x5: 0x2, },
    'é': { 0x0: 0x3, 0x5: 0x3, },
    '"': { 0x0: 0x4, 0x5: 0x4, },
    '\'': { 0x0: 0x5, 0x5: 0x5, },
    '(': { 0x0: 0x6, 0x5: 0x6, },
    '§': { 0x0: 0x7, 0x5: 0x7, },
    'è': { 0x0: 0x8, 0x5: 0x8, },
    '!': { 0x0: 0x9, 0x5: 0x9, },
    'ç': { 0x0: 0xa, 0x5: 0xa, },
    'à': { 0x0: 0xb, 0x5: 0xb, },
    ')': { 0x0: 0xc, 0x5: 0xc, },
    '-': { 0x0: 0xd, 0x1: 0x4a, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'a': { 0x0: 0x10, 0x5: 0x10, },
    'z': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '$': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'q': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'm': { 0x0: 0x27, 0x5: 0x27, },
    'ù': { 0x0: 0x28, 0x5: 0x28, },
    '²': { 0x0: 0x29, },
    'µ': { 0x0: 0x2b, 0x5: 0x2b, },
    'w': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    ',': { 0x0: 0x32, 0x5: 0x32, },
    ';': { 0x0: 0x33, 0x5: 0x33, },
    ':': { 0x0: 0x34, 0x5: 0x34, },
    '=': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x35, 0x4: 0x35, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, 0x4: 0x2, },
    '2': { 0x1: 0x3, 0x4: 0x3, },
    '3': { 0x1: 0x4, 0x4: 0x4, },
    '4': { 0x1: 0x5, 0x4: 0x5, },
    '5': { 0x1: 0x6, 0x4: 0x6, },
    '6': { 0x1: 0x7, 0x4: 0x7, },
    '7': { 0x1: 0x8, 0x4: 0x8, },
    '8': { 0x1: 0x9, 0x4: 0x9, },
    '9': { 0x1: 0xa, 0x4: 0xa, },
    '0': { 0x1: 0xb, 0x4: 0xb, },
    '°': { 0x1: 0xc, 0x4: 0xc, },
    '_': { 0x1: 0xd, 0x4: 0xd, },
    'A': { 0x1: 0x10, 0x4: 0x10, },
    'Z': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Q': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'M': { 0x1: 0x27, 0x4: 0x27, },
    '%': { 0x1: 0x28, 0x4: 0x28, },
    '³': { 0x1: 0x29, },
    '£': { 0x1: 0x2b, 0x4: 0x2b, },
    'W': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    '?': { 0x1: 0x32, 0x4: 0x32, },
    '.': { 0x1: 0x33, 0x4: 0x33, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '|': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '{': { 0x2: 0x5, },
    '[': { 0x2: 0x6, },
    '^': { 0x2: 0x7, },
    '}': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
    ']': { 0x2: 0x1b, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'á': [2, ['a', ]],
    'é': [2, ['e', ]],
    'í': [2, ['i', ]],
    'ó': [2, ['o', ]],
    'ú': [2, ['u', ]],
    'ý': [2, ['y', ]],
    'Á': [2, ['A', ]],
    'É': [2, ['E', ]],
    'Í': [2, ['I', ]],
    'Ó': [2, ['O', ]],
    'Ú': [2, ['U', ]],
    'Ý': [2, ['Y', ]],
    '´': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, 0x5: 0x1a, },
    {0x1: 0x1a, 0x4: 0x1a, },
    {0x3: 0x28, 0x2: 0x28, },
    {0x3: 0x2b, 0x2: 0x2b, },
    {0x3: 0x35, 0x2: 0x35, },
  ]
},
{
  klid: 0x00000816,
  localeName: "pt-PT",
  displayName: "Portuguese",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '«': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '+': { 0x0: 0x1a, 0x1: 0x4e, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ç': { 0x0: 0x27, 0x5: 0x27, },
    'º': { 0x0: 0x28, },
    '\\': { 0x0: 0x29, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1a, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '»': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ç': { 0x1: 0x27, 0x4: 0x27, },
    'ª': { 0x1: 0x28, },
    '|': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1f': { 0x0: 0x35, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '§': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ã': [1, ['a', ]],
    'õ': [1, ['o', ]],
    'ñ': [1, ['n', ]],
    'Ã': [1, ['A', ]],
    'Õ': [1, ['O', ]],
    'Ñ': [1, ['N', ]],
    '~': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'â': [3, ['a', ]],
    'ê': [3, ['e', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'û': [3, ['u', ]],
    'Â': [3, ['A', ]],
    'Ê': [3, ['E', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'Û': [3, ['U', ]],
    '^': [3, [' ', ]],
    'ä': [4, ['a', ]],
    'ë': [4, ['e', ]],
    'ï': [4, ['i', ]],
    'ö': [4, ['o', ]],
    'ü': [4, ['u', ]],
    'ÿ': [4, ['y', ]],
    'Ä': [4, ['A', ]],
    'Ë': [4, ['E', ]],
    'Ï': [4, ['I', ]],
    'Ö': [4, ['O', ]],
    'Ü': [4, ['U', ]],
    '¨': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1b, },
    {0x0: 0x2b, },
    {0x1: 0x1b, },
    {0x1: 0x2b, },
    {0x2: 0x1a, },
  ]
},
{
  klid: 0x0000081a,
  localeName: "sr-Latn-CS",
  displayName: "Serbian (Latin)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'š': { 0x0: 0x1a, 0x5: 0x1a, },
    'đ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'č': { 0x0: 0x27, 0x5: 0x27, },
    'ć': { 0x0: 0x28, 0x5: 0x28, },
    'ž': { 0x0: 0x2b, 0x5: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Š': { 0x1: 0x1a, 0x4: 0x1a, },
    'Đ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Č': { 0x1: 0x27, 0x4: 0x27, },
    'Ć': { 0x1: 0x28, 0x4: 0x28, },
    '~': { 0x1: 0x29, 0x2: 0x2, },
    'Ž': { 0x1: 0x2b, 0x4: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '€': { 0x2: 0x12, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    'ß': { 0x2: 0x28, },
    '¤': { 0x2: 0x2b, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
    'ç': [0, ['c', ]],
    'ş': [0, ['s', ]],
    'Ç': [0, ['C', ]],
    'Ş': [0, ['S', ]],
    '‚': [1, [' ', ]],
    'ň': [2, ['n', ]],
    'č': [2, ['c', ]],
    'ď': [2, ['d', ]],
    'š': [2, ['s', ]],
    'ľ': [2, ['l', ]],
    'ě': [2, ['e', ]],
    'ř': [2, ['r', ]],
    'ť': [2, ['t', ]],
    'ž': [2, ['z', ]],
    'Ň': [2, ['N', ]],
    'Č': [2, ['C', ]],
    'Ď': [2, ['D', ]],
    'Š': [2, ['S', ]],
    'Ľ': [2, ['L', ]],
    'Ě': [2, ['E', ]],
    'Ř': [2, ['R', ]],
    'Ť': [2, ['T', ]],
    'Ž': [2, ['Z', ]],
    'ˇ': [2, [' ', ]],
    'â': [3, ['a', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    'Â': [3, ['A', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    '^': [3, [' ', ]],
    'ă': [4, ['a', ]],
    'Ă': [4, ['A', ]],
    '˘': [4, [' ', ]],
    'ů': [5, ['u', ]],
    'Ů': [5, ['U', ]],
    '°': [5, [' ', ]],
    'ą': [6, ['a', ]],
    'ę': [6, ['e', ]],
    'Ą': [6, ['A', ]],
    'Ę': [6, ['E', ]],
    '˛': [6, [' ', ]],
    'ż': [7, ['z', ]],
    'Ż': [7, ['Z', ]],
    '˙': [7, [' ', ]],
    'ń': [8, ['n', ]],
    'ć': [8, ['c', ]],
    'ý': [8, ['y', ]],
    'á': [8, ['a', ]],
    'ś': [8, ['s', ]],
    'ĺ': [8, ['l', ]],
    'é': [8, ['e', ]],
    'ŕ': [8, ['r', ]],
    'ú': [8, ['u', ]],
    'í': [8, ['i', ]],
    'ź': [8, ['z', ]],
    'ó': [8, ['o', ]],
    'Ń': [8, ['N', ]],
    'Ć': [8, ['C', ]],
    'Ý': [8, ['Y', ]],
    'Á': [8, ['A', ]],
    'Ś': [8, ['S', ]],
    'Ĺ': [8, ['L', ]],
    'É': [8, ['E', ]],
    'Ŕ': [8, ['R', ]],
    'Ú': [8, ['U', ]],
    'Í': [8, ['I', ]],
    'Ź': [8, ['Z', ]],
    'Ó': [8, ['O', ]],
    '´': [8, [' ', ]],
    'ű': [9, ['u', ]],
    'ő': [9, ['o', ]],
    'Ű': [9, ['U', ]],
    'Ő': [9, ['O', ]],
    '˝': [9, [' ', ]],
    'ä': [10, ['a', ]],
    'ë': [10, ['e', ]],
    'ü': [10, ['u', ]],
    'ö': [10, ['o', ]],
    'Ä': [10, ['A', ]],
    'Ë': [10, ['E', ]],
    'Ü': [10, ['U', ]],
    'Ö': [10, ['O', ]],
    '¨': [10, [' ', ]],
    '¸': [11, [' ', ]],
  },
  accents: [
    {0x0: 0x29, 0x2: 0xd, },
    {0x0: 0x29, },
    {0x2: 0x3, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x6, },
    {0x2: 0x7, },
    {0x2: 0x9, },
    {0x2: 0xa, },
    {0x2: 0xb, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x0000083b,
  localeName: "se-Latn-SE",
  displayName: "Swedish with Sami",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '§': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '½': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    'Â': { 0x3: 0x10, 0x6: 0x10, },
    'Ŧ': { 0x3: 0x14, 0x6: 0x14, },
    'Ï': { 0x3: 0x17, 0x6: 0x17, },
    'Õ': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    'Š': { 0x3: 0x1f, 0x6: 0x1f, },
    'Đ': { 0x3: 0x20, 0x6: 0x20, },
    'Ǥ': { 0x3: 0x21, 0x6: 0x21, },
    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },
    'Ȟ': { 0x3: 0x23, 0x6: 0x23, },
    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },
    'Ø': { 0x3: 0x27, 0x6: 0x27, },
    'Æ': { 0x3: 0x28, 0x6: 0x28, },
    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },
    'Č': { 0x3: 0x2e, 0x6: 0x2e, },
    'Ǯ': { 0x3: 0x2f, 0x6: 0x2f, },
    'Ʒ': { 0x3: 0x30, 0x6: 0x30, },
    'Ŋ': { 0x3: 0x31, 0x6: 0x31, },
    'â': { 0x7: 0x10, 0x2: 0x10, },
    'ŧ': { 0x7: 0x14, 0x2: 0x14, },
    'ï': { 0x7: 0x17, 0x2: 0x17, },
    'õ': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    'š': { 0x7: 0x1f, 0x2: 0x1f, },
    'đ': { 0x7: 0x20, 0x2: 0x20, },
    'ǥ': { 0x7: 0x21, 0x2: 0x21, },
    'ǧ': { 0x7: 0x22, 0x2: 0x22, },
    'ȟ': { 0x7: 0x23, 0x2: 0x23, },
    'ǩ': { 0x7: 0x25, 0x2: 0x25, },
    'ø': { 0x7: 0x27, 0x2: 0x27, },
    'æ': { 0x7: 0x28, 0x2: 0x28, },
    'ž': { 0x7: 0x2c, 0x2: 0x2c, },
    'č': { 0x7: 0x2e, 0x2: 0x2e, },
    'ǯ': { 0x7: 0x2f, 0x2: 0x2f, },
    'ʒ': { 0x7: 0x30, 0x2: 0x30, },
    'ŋ': { 0x7: 0x31, 0x2: 0x31, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    'µ': { 0x2: 0x32, },
    '|': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ẃ': [0, ['w', ]],
    'Ẃ': [0, ['W', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    'ǻ': [0, ['å', ]],
    'Ǻ': [0, ['Å', ]],
    'ǽ': [0, ['æ', ]],
    'Ǽ': [0, ['Æ', ]],
    'ǿ': [0, ['ø', ]],
    'Ǿ': [0, ['Ø', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'Ä': [1, ['A', ]],
    'ë': [1, ['e', ]],
    'Ë': [1, ['E', ]],
    'ï': [1, ['i', ]],
    'Ï': [1, ['I', ]],
    'ö': [1, ['o', ]],
    'Ö': [1, ['O', ]],
    'ü': [1, ['u', ]],
    'Ü': [1, ['U', ]],
    'ẅ': [1, ['w', ]],
    'Ẅ': [1, ['W', ]],
    'ÿ': [1, ['y', ]],
    'Ÿ': [1, ['Y', ]],
    '¨': [1, [' ', ]],
    'à': [2, ['a', ]],
    'À': [2, ['A', ]],
    'è': [2, ['e', ]],
    'È': [2, ['E', ]],
    'ì': [2, ['i', ]],
    'Ì': [2, ['I', ]],
    'ò': [2, ['o', ]],
    'Ò': [2, ['O', ]],
    'ù': [2, ['u', ]],
    'Ù': [2, ['U', ]],
    'ẁ': [2, ['w', ]],
    'Ẁ': [2, ['W', ]],
    'ỳ': [2, ['y', ]],
    'Ỳ': [2, ['Y', ]],
    '`': [2, [' ', ]],
    'â': [3, ['a', ]],
    'Â': [3, ['A', ]],
    'ĉ': [3, ['c', ]],
    'Ĉ': [3, ['C', ]],
    'ê': [3, ['e', ]],
    'Ê': [3, ['E', ]],
    'ĝ': [3, ['g', ]],
    'Ĝ': [3, ['G', ]],
    'ĥ': [3, ['h', ]],
    'Ĥ': [3, ['H', ]],
    'î': [3, ['i', ]],
    'Î': [3, ['I', ]],
    'ĵ': [3, ['j', ]],
    'Ĵ': [3, ['J', ]],
    'ô': [3, ['o', ]],
    'Ô': [3, ['O', ]],
    'ŝ': [3, ['s', ]],
    'Ŝ': [3, ['S', ]],
    'û': [3, ['u', ]],
    'Û': [3, ['U', ]],
    'ŵ': [3, ['w', ]],
    'Ŵ': [3, ['W', ]],
    'ŷ': [3, ['y', ]],
    'Ŷ': [3, ['Y', ]],
    '^': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'Ã': [4, ['A', ]],
    'ĩ': [4, ['i', ]],
    'Ĩ': [4, ['I', ]],
    'ñ': [4, ['n', ]],
    'Ñ': [4, ['N', ]],
    'õ': [4, ['o', ]],
    'Õ': [4, ['O', ]],
    'ũ': [4, ['u', ]],
    'Ũ': [4, ['U', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x00000843,
  localeName: "uz-Cyrl",
  displayName: "Uzbek Cyrillic",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    'ғ': { 0x0: 0xc, 0x5: 0xc, },
    'ҳ': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'ў': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'қ': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ж': { 0x0: 0x27, 0x5: 0x27, },
    'э': { 0x0: 0x28, 0x5: 0x28, },
    'ё': { 0x0: 0x29, 0x5: 0x29, },
    '\\': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'ь': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    '.': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '-': { 0x0: 0x4a, 0x1: 0x4a, },
    '+': { 0x0: 0x4e, 0x1: 0x4e, },
    '/': { 0x0: 0x35, 0x1: 0x2b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '№': { 0x1: 0x4, },
    ';': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    ':': { 0x1: 0x7, },
    '?': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    'Ғ': { 0x1: 0xc, 0x4: 0xc, },
    'Ҳ': { 0x1: 0xd, 0x4: 0xd, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Ў': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'Қ': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ж': { 0x1: 0x27, 0x4: 0x27, },
    'Э': { 0x1: 0x28, 0x4: 0x28, },
    'Ё': { 0x1: 0x29, 0x4: 0x29, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Ь': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    ',': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0000085d,
  localeName: "iu-Latn",
  displayName: "Inuktitut - Latin",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, 0x1: 0x2, 0x5: 0x2, },
    '2': { 0x0: 0x3, 0x1: 0x3, 0x5: 0x3, },
    '3': { 0x0: 0x4, 0x1: 0x4, 0x5: 0x4, },
    '4': { 0x0: 0x5, 0x1: 0x5, 0x5: 0x5, },
    '5': { 0x0: 0x6, 0x1: 0x6, 0x5: 0x6, },
    '6': { 0x0: 0x7, 0x1: 0x7, 0x5: 0x7, },
    '7': { 0x0: 0x8, 0x1: 0x8, 0x5: 0x8, },
    '8': { 0x0: 0x9, 0x1: 0x9, 0x5: 0x9, },
    '9': { 0x0: 0xa, 0x1: 0xa, 0x5: 0xa, },
    '0': { 0x0: 0xb, 0x1: 0xb, 0x5: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, 0x4: 0xc, },
    '=': { 0x0: 0xd, 0x2: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, },
    'w': { 0x0: 0x11, },
    'e': { 0x0: 0x12, },
    'r': { 0x0: 0x13, },
    't': { 0x0: 0x14, },
    'y': { 0x0: 0x15, },
    'u': { 0x0: 0x16, },
    'i': { 0x0: 0x17, },
    'o': { 0x0: 0x18, },
    'p': { 0x0: 0x19, },
    '[': { 0x0: 0x1a, 0x2: 0xa, },
    ']': { 0x0: 0x1b, 0x2: 0xb, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, },
    's': { 0x0: 0x1f, },
    'd': { 0x0: 0x20, },
    'f': { 0x0: 0x21, },
    'g': { 0x0: 0x22, },
    'h': { 0x0: 0x23, },
    'j': { 0x0: 0x24, },
    'k': { 0x0: 0x25, },
    'l': { 0x0: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, },
    'x': { 0x0: 0x2d, },
    'c': { 0x0: 0x2e, },
    'v': { 0x0: 0x2f, },
    'b': { 0x0: 0x30, },
    'n': { 0x0: 0x31, },
    'm': { 0x0: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, 0x4: 0x2b, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x7, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, 0x5: 0xd, 0x3: 0xb, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, },
    'W': { 0x1: 0x11, },
    'E': { 0x1: 0x12, },
    'R': { 0x1: 0x13, },
    'T': { 0x1: 0x14, },
    'Y': { 0x1: 0x15, },
    'U': { 0x1: 0x16, },
    'I': { 0x1: 0x17, },
    'O': { 0x1: 0x18, },
    'P': { 0x1: 0x19, },
    '{': { 0x1: 0x1a, 0x3: 0x2f, },
    '}': { 0x1: 0x1b, 0x3: 0x30, },
    'A': { 0x1: 0x1e, },
    'S': { 0x1: 0x1f, },
    'D': { 0x1: 0x20, },
    'F': { 0x1: 0x21, },
    'G': { 0x1: 0x22, },
    'H': { 0x1: 0x23, },
    'J': { 0x1: 0x24, },
    'K': { 0x1: 0x25, },
    'L': { 0x1: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '~': { 0x1: 0x29, 0x3: 0x29, },
    '|': { 0x1: 0x2b, 0x3: 0x2b, },
    'Z': { 0x1: 0x2c, },
    'X': { 0x1: 0x2d, },
    'C': { 0x1: 0x2e, },
    'V': { 0x1: 0x2f, },
    'B': { 0x1: 0x30, },
    'N': { 0x1: 0x31, },
    'M': { 0x1: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, 0x5: 0x2f, },
    '−': { 0x5: 0xc, },
    'ᒋ': { 0x5: 0x10, },
    'ᐱ': { 0x5: 0x11, },
    'ᕆ': { 0x5: 0x12, },
    'ᖖ': { 0x5: 0x13, },
    'ᙱ': { 0x5: 0x14, },
    'ᙳ': { 0x5: 0x15, },
    'ᙵ': { 0x5: 0x16, },
    'ᖤ': { 0x5: 0x17, },
    'ᖠ': { 0x5: 0x18, },
    'ᖦ': { 0x5: 0x19, },
    'ᔅ': { 0x5: 0x1a, },
    'ᒍ': { 0x5: 0x1e, },
    'ᐳ': { 0x5: 0x1f, },
    'ᕈ': { 0x5: 0x20, },
    'ᕕ': { 0x5: 0x21, },
    '(': { 0x5: 0x22, },
    ')': { 0x5: 0x23, },
    'ᔪ': { 0x5: 0x24, },
    'ᕗ': { 0x5: 0x25, },
    'ᖢ': { 0x5: 0x26, },
    'ᒐ': { 0x5: 0x2c, },
    'ᐸ': { 0x5: 0x2d, },
    'ᕋ': { 0x5: 0x2e, },
    'ᕼ': { 0x5: 0x30, },
    'ᓇ': { 0x5: 0x31, },
    'ᓚ': { 0x5: 0x32, },
    'ᕙ': { 0x5: 0x35, },
    '¢': { 0x3: 0x2, },
    '®': { 0x3: 0x3, },
    '¼': { 0x3: 0x4, },
    '½': { 0x3: 0x5, },
    '¾': { 0x3: 0x6, },
    '^': { 0x3: 0x7, },
    '⅔': { 0x3: 0x8, },
    '©': { 0x3: 0x9, },
    '÷': { 0x3: 0xa, },
    'ᒌ': { 0x3: 0x10, },
    'ᐲ': { 0x3: 0x11, },
    'ᕇ': { 0x3: 0x12, },
    'ᙲ': { 0x3: 0x14, },
    'ᙴ': { 0x3: 0x15, },
    'ᙶ': { 0x3: 0x16, },
    'ᖥ': { 0x3: 0x17, },
    'ᖡ': { 0x3: 0x18, },
    '”': { 0x3: 0x1a, },
    '’': { 0x3: 0x1b, },
    'ᒎ': { 0x3: 0x1e, },
    'ᐴ': { 0x3: 0x1f, },
    'ᕉ': { 0x3: 0x20, },
    'ᕖ': { 0x3: 0x21, },
    'ᔫ': { 0x3: 0x24, },
    'ᕘ': { 0x3: 0x25, },
    'ᖣ': { 0x3: 0x26, },
    'Ŋ': { 0x3: 0x27, },
    'Ł': { 0x3: 0x28, },
    'ᒑ': { 0x3: 0x2c, },
    'ᐹ': { 0x3: 0x2d, },
    'ᕌ': { 0x3: 0x2e, },
    'ᓈ': { 0x3: 0x31, },
    'ᓛ': { 0x3: 0x32, },
    'ᕚ': { 0x3: 0x35, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '!': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '%': { 0x2: 0x6, },
    '&': { 0x2: 0x8, },
    '•': { 0x2: 0x9, },
    'ᖐ': { 0x2: 0x10, },
    'ᐄ': { 0x2: 0x11, },
    'ᖀ': { 0x2: 0x12, },
    'ᑮ': { 0x2: 0x13, },
    'ᑏ': { 0x2: 0x14, },
    'ᓰ': { 0x2: 0x15, },
    'ᒦ': { 0x2: 0x16, },
    'ᓃ': { 0x2: 0x17, },
    'ᓖ': { 0x2: 0x18, },
    'ᔩ': { 0x2: 0x19, },
    '“': { 0x2: 0x1a, },
    '‘': { 0x2: 0x1b, },
    'ᖒ': { 0x2: 0x1e, },
    'ᐆ': { 0x2: 0x1f, },
    'ᖂ': { 0x2: 0x20, },
    'ᑰ': { 0x2: 0x21, },
    'ᑑ': { 0x2: 0x22, },
    'ᓲ': { 0x2: 0x23, },
    'ᒨ': { 0x2: 0x24, },
    'ᓅ': { 0x2: 0x25, },
    'ᓘ': { 0x2: 0x26, },
    'ŋ': { 0x2: 0x27, },
    'ł': { 0x2: 0x28, },
    'ᖔ': { 0x2: 0x2c, },
    'ᐋ': { 0x2: 0x2d, },
    'ᖄ': { 0x2: 0x2e, },
    'ᑳ': { 0x2: 0x2f, },
    'ᑖ': { 0x2: 0x30, },
    'ᓵ': { 0x2: 0x31, },
    'ᒫ': { 0x2: 0x32, },
    'ᔮ': { 0x2: 0x35, },
    'ᖕ': { 0x4: 0x2, },
    'ᑉ': { 0x4: 0x3, },
    'ᕐ': { 0x4: 0x4, },
    'ᒃ': { 0x4: 0x5, },
    'ᑦ': { 0x4: 0x6, },
    'ᖅ': { 0x4: 0x7, },
    'ᒻ': { 0x4: 0x8, },
    'ᓐ': { 0x4: 0x9, },
    'ᓪ': { 0x4: 0xa, },
    'ᔾ': { 0x4: 0xb, },
    'ᕝ': { 0x4: 0xd, },
    'ᖏ': { 0x4: 0x10, },
    'ᐃ': { 0x4: 0x11, },
    'ᕿ': { 0x4: 0x12, },
    'ᑭ': { 0x4: 0x13, },
    'ᑎ': { 0x4: 0x14, },
    'ᓯ': { 0x4: 0x15, },
    'ᒥ': { 0x4: 0x16, },
    'ᓂ': { 0x4: 0x17, },
    'ᓕ': { 0x4: 0x18, },
    'ᔨ': { 0x4: 0x19, },
    'ᒡ': { 0x4: 0x1a, },
    'ᐞ': { 0x4: 0x1b, },
    'ᖑ': { 0x4: 0x1e, },
    'ᐅ': { 0x4: 0x1f, },
    'ᖁ': { 0x4: 0x20, },
    'ᑯ': { 0x4: 0x21, },
    'ᑐ': { 0x4: 0x22, },
    'ᓱ': { 0x4: 0x23, },
    'ᒧ': { 0x4: 0x24, },
    'ᓄ': { 0x4: 0x25, },
    'ᓗ': { 0x4: 0x26, },
    'ᖓ': { 0x4: 0x2c, },
    'ᐊ': { 0x4: 0x2d, },
    'ᖃ': { 0x4: 0x2e, },
    'ᑲ': { 0x4: 0x2f, },
    'ᑕ': { 0x4: 0x30, },
    'ᓴ': { 0x4: 0x31, },
    'ᒪ': { 0x4: 0x32, },
    'ᔭ': { 0x4: 0x35, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00000c0c,
  localeName: "fr-CA",
  displayName: "Canadian French (Legacy)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ç': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    'è': { 0x0: 0x28, 0x5: 0x28, },
    '°': { 0x0: 0x29, 0x1: 0x29, 0x2: 0x1a, },
    'à': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, 0x1: 0x34, },
    'é': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    'ù': { 0x0: 0x56, 0x5: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x35, 0x2: 0x35, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '?': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ç': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    'È': { 0x1: 0x28, 0x4: 0x28, },
    'À': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '\'': { 0x1: 0x33, },
    'É': { 0x1: 0x35, 0x4: 0x35, },
    'Ù': { 0x1: 0x56, 0x4: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '¡': { 0x3: 0x2, },
    '²': { 0x3: 0x3, },
    '£': { 0x3: 0x4, },
    '¤': { 0x3: 0x5, },
    '±': { 0x3: 0xa, },
    '¿': { 0x3: 0xc, },
    '®': { 0x3: 0x13, },
    'Ø': { 0x3: 0x18, 0x6: 0x18, },
    'Þ': { 0x3: 0x19, 0x6: 0x19, },
    'Æ': { 0x3: 0x1e, 0x6: 0x1e, },
    '§': { 0x3: 0x1f, },
    'Ð': { 0x3: 0x20, 0x6: 0x20, },
    '©': { 0x3: 0x2e, },
    'º': { 0x3: 0x32, },
    '|': { 0x3: 0x56, 0x2: 0xc, },
    'ø': { 0x7: 0x18, 0x2: 0x18, },
    'þ': { 0x7: 0x19, 0x2: 0x19, },
    'æ': { 0x7: 0x1e, 0x2: 0x1e, },
    'ð': { 0x7: 0x20, 0x2: 0x20, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '¹': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '¼': { 0x2: 0x5, },
    '½': { 0x2: 0x6, },
    '¾': { 0x2: 0x7, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '¶': { 0x2: 0x13, },
    '¥': { 0x2: 0x15, },
    'ß': { 0x2: 0x1f, },
    'ª': { 0x2: 0x21, },
    '¬': { 0x2: 0x29, },
    '«': { 0x2: 0x2c, },
    '»': { 0x2: 0x2d, },
    '¢': { 0x2: 0x2e, },
    'µ': { 0x2: 0x32, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'á': [2, ['a', ]],
    'é': [2, ['e', ]],
    'í': [2, ['i', ]],
    'ó': [2, ['o', ]],
    'ú': [2, ['u', ]],
    'ý': [2, ['y', ]],
    'Á': [2, ['A', ]],
    'É': [2, ['E', ]],
    'Í': [2, ['I', ]],
    'Ó': [2, ['O', ]],
    'Ú': [2, ['U', ]],
    'Ý': [2, ['Y', ]],
    '´': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
    'ç': [4, ['c', ]],
    'Ç': [4, ['C', ]],
    'ã': [5, ['a', ]],
    'õ': [5, ['o', ]],
    'ñ': [5, ['n', ]],
    'Ã': [5, ['A', ]],
    'Õ': [5, ['O', ]],
    'Ñ': [5, ['N', ]],
    '~': [5, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, 0x1: 0x1a, },
    {0x3: 0x1b, },
    {0x3: 0x27, 0x2: 0x27, },
    {0x3: 0x2b, 0x2: 0x2b, },
    {0x2: 0xd, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x00000c1a,
  localeName: "sr-Cyrl-CS",
  displayName: "Serbian (Cyrillic)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'љ': { 0x0: 0x10, 0x5: 0x10, },
    'њ': { 0x0: 0x11, 0x5: 0x11, },
    'е': { 0x0: 0x12, 0x5: 0x12, },
    'р': { 0x0: 0x13, 0x5: 0x13, },
    'т': { 0x0: 0x14, 0x5: 0x14, },
    'з': { 0x0: 0x15, 0x5: 0x15, },
    'у': { 0x0: 0x16, 0x5: 0x16, },
    'и': { 0x0: 0x17, 0x5: 0x17, },
    'о': { 0x0: 0x18, 0x5: 0x18, },
    'п': { 0x0: 0x19, 0x5: 0x19, },
    'ш': { 0x0: 0x1a, 0x5: 0x1a, },
    'ђ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'а': { 0x0: 0x1e, 0x5: 0x1e, },
    'с': { 0x0: 0x1f, 0x5: 0x1f, },
    'д': { 0x0: 0x20, 0x5: 0x20, },
    'ф': { 0x0: 0x21, 0x5: 0x21, },
    'г': { 0x0: 0x22, 0x5: 0x22, },
    'х': { 0x0: 0x23, 0x5: 0x23, },
    'ј': { 0x0: 0x24, 0x5: 0x24, },
    'к': { 0x0: 0x25, 0x5: 0x25, },
    'л': { 0x0: 0x26, 0x5: 0x26, },
    'ч': { 0x0: 0x27, 0x5: 0x27, },
    'ћ': { 0x0: 0x28, 0x5: 0x28, },
    '`': { 0x0: 0x29, },
    'ж': { 0x0: 0x2b, 0x5: 0x2b, },
    'ѕ': { 0x0: 0x2c, 0x5: 0x2c, },
    'џ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ц': { 0x0: 0x2e, 0x5: 0x2e, },
    'в': { 0x0: 0x2f, 0x5: 0x2f, },
    'б': { 0x0: 0x30, 0x5: 0x30, },
    'н': { 0x0: 0x31, 0x5: 0x31, },
    'м': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Љ': { 0x1: 0x10, 0x4: 0x10, },
    'Њ': { 0x1: 0x11, 0x4: 0x11, },
    'Е': { 0x1: 0x12, 0x4: 0x12, },
    'Р': { 0x1: 0x13, 0x4: 0x13, },
    'Т': { 0x1: 0x14, 0x4: 0x14, },
    'З': { 0x1: 0x15, 0x4: 0x15, },
    'У': { 0x1: 0x16, 0x4: 0x16, },
    'И': { 0x1: 0x17, 0x4: 0x17, },
    'О': { 0x1: 0x18, 0x4: 0x18, },
    'П': { 0x1: 0x19, 0x4: 0x19, },
    'Ш': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ђ': { 0x1: 0x1b, 0x4: 0x1b, },
    'А': { 0x1: 0x1e, 0x4: 0x1e, },
    'С': { 0x1: 0x1f, 0x4: 0x1f, },
    'Д': { 0x1: 0x20, 0x4: 0x20, },
    'Ф': { 0x1: 0x21, 0x4: 0x21, },
    'Г': { 0x1: 0x22, 0x4: 0x22, },
    'Х': { 0x1: 0x23, 0x4: 0x23, },
    'Ј': { 0x1: 0x24, 0x4: 0x24, },
    'К': { 0x1: 0x25, 0x4: 0x25, },
    'Л': { 0x1: 0x26, 0x4: 0x26, },
    'Ч': { 0x1: 0x27, 0x4: 0x27, },
    'Ћ': { 0x1: 0x28, 0x4: 0x28, },
    '~': { 0x1: 0x29, },
    'Ж': { 0x1: 0x2b, 0x4: 0x2b, },
    'Ѕ': { 0x1: 0x2c, 0x4: 0x2c, },
    'Џ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ц': { 0x1: 0x2e, 0x4: 0x2e, },
    'В': { 0x1: 0x2f, 0x4: 0x2f, },
    'Б': { 0x1: 0x30, 0x4: 0x30, },
    'Н': { 0x1: 0x31, 0x4: 0x31, },
    'М': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '€': { 0x2: 0x12, },
  },
  deadkeys: {
    'ѓ': [0, ['г', ]],
    'ќ': [0, ['к', ]],
    'Ѓ': [0, ['Г', ]],
    'Ќ': [0, ['К', ]],
    '\'': [0, [' ', ]],
  },
  accents: [
    {0x0: 0xc, },
  ]
},
{
  klid: 0x00001009,
  localeName: "en-CA",
  displayName: "Canadian French",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '#': { 0x0: 0x29, },
    '<': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, 0x1: 0x34, },
    'é': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '«': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x4, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '?': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '|': { 0x1: 0x29, },
    '>': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '\'': { 0x1: 0x33, },
    'É': { 0x1: 0x35, 0x4: 0x35, },
    '»': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '±': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '¢': { 0x2: 0x5, },
    '¤': { 0x2: 0x6, },
    '¬': { 0x2: 0x7, },
    '¦': { 0x2: 0x8, },
    '²': { 0x2: 0x9, },
    '³': { 0x2: 0xa, },
    '¼': { 0x2: 0xb, },
    '½': { 0x2: 0xc, },
    '¾': { 0x2: 0xd, },
    '§': { 0x2: 0x18, },
    '¶': { 0x2: 0x19, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '~': { 0x2: 0x27, },
    '{': { 0x2: 0x28, },
    '\\': { 0x2: 0x29, },
    '}': { 0x2: 0x2b, },
    'µ': { 0x2: 0x32, },
    '¯': { 0x2: 0x33, },
    '\xad': { 0x2: 0x34, },
    '°': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ç': [1, ['c', ]],
    'Ç': [1, ['C', ]],
    '¸': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'ä': [3, ['a', ]],
    'ë': [3, ['e', ]],
    'ï': [3, ['i', ]],
    'ö': [3, ['o', ]],
    'ü': [3, ['u', ]],
    'ÿ': [3, ['y', ]],
    'Ä': [3, ['A', ]],
    'Ë': [3, ['E', ]],
    'Ï': [3, ['I', ]],
    'Ö': [3, ['O', ]],
    'Ü': [3, ['U', ]],
    '¨': [3, [' ', ]],
    'á': [4, ['a', ]],
    'é': [4, ['e', ]],
    'í': [4, ['i', ]],
    'ó': [4, ['o', ]],
    'ú': [4, ['u', ]],
    'ý': [4, ['y', ]],
    'Á': [4, ['A', ]],
    'É': [4, ['E', ]],
    'Í': [4, ['I', ]],
    'Ó': [4, ['O', ]],
    'Ú': [4, ['U', ]],
    'Ý': [4, ['Y', ]],
    '´': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, 0x1: 0x1a, },
    {0x0: 0x1b, },
    {0x0: 0x28, 0x1: 0x28, },
    {0x1: 0x1b, },
    {0x2: 0x35, },
  ]
},
{
  klid: 0x0000100c,
  localeName: "fr-CH",
  displayName: "Swiss French",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'è': { 0x0: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'é': { 0x0: 0x27, },
    'à': { 0x0: 0x28, },
    '§': { 0x0: 0x29, 0x2: 0x6, },
    '$': { 0x0: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x4, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x2, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '"': { 0x1: 0x3, },
    'ç': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'ü': { 0x1: 0x1a, },
    '!': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'ö': { 0x1: 0x27, },
    'ä': { 0x1: 0x28, },
    '°': { 0x1: 0x29, 0x2: 0x5, },
    '£': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\x1f': { 0x0: 0x35, },
    '¦': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '¬': { 0x2: 0x7, },
    '|': { 0x2: 0x8, },
    '¢': { 0x2: 0x9, },
    '€': { 0x2: 0x12, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '{': { 0x2: 0x28, },
    '}': { 0x2: 0x2b, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '"': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'á': [3, ['a', ]],
    'é': [3, ['e', ]],
    'í': [3, ['i', ]],
    'ó': [3, ['o', ]],
    'ú': [3, ['u', ]],
    'ý': [3, ['y', ]],
    'Á': [3, ['A', ]],
    'É': [3, ['E', ]],
    'Í': [3, ['I', ]],
    'Ó': [3, ['O', ]],
    'Ú': [3, ['U', ]],
    'Ý': [3, ['Y', ]],
    '´': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00001809,
  localeName: "en-IE",
  displayName: "Irish",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '#': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '@': { 0x1: 0x28, },
    '¬': { 0x1: 0x29, },
    '~': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '|': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    'É': { 0x3: 0x12, 0x6: 0x12, },
    'Ú': { 0x3: 0x16, 0x6: 0x16, },
    'Í': { 0x3: 0x17, 0x6: 0x17, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    '`': { 0x3: 0x28, },
    '¦': { 0x3: 0x29, 0x2: 0x29, },
    'é': { 0x7: 0x12, 0x2: 0x12, },
    'ú': { 0x7: 0x16, 0x2: 0x16, },
    'í': { 0x7: 0x17, 0x2: 0x17, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '€': { 0x2: 0x5, },
  },
  deadkeys: {
    'à': [0, ['a', ]],
    'è': [0, ['e', ]],
    'ì': [0, ['i', ]],
    'ò': [0, ['o', ]],
    'ù': [0, ['u', ]],
    'À': [0, ['A', ]],
    'È': [0, ['E', ]],
    'Ì': [0, ['I', ]],
    'Ò': [0, ['O', ]],
    'Ù': [0, ['U', ]],
    '`': [0, [' ', ]],
    'á': [1, ['a', ]],
    'é': [1, ['e', ]],
    'í': [1, ['i', ]],
    'ó': [1, ['o', ]],
    'ú': [1, ['u', ]],
    'ý': [1, ['y', ]],
    'Á': [1, ['A', ]],
    'É': [1, ['E', ]],
    'Í': [1, ['I', ]],
    'Ó': [1, ['O', ]],
    'Ú': [1, ['U', ]],
    'Ý': [1, ['Y', ]],
    '´': [1, [' ', ]],
  },
  accents: [
    {0x0: 0x29, },
    {0x2: 0x28, },
  ]
},
{
  klid: 0x0000201a,
  localeName: "bs-Cyrl",
  displayName: "Bosnian (Cyrillic)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'љ': { 0x0: 0x10, 0x5: 0x10, },
    'њ': { 0x0: 0x11, 0x5: 0x11, },
    'е': { 0x0: 0x12, 0x5: 0x12, },
    'р': { 0x0: 0x13, 0x5: 0x13, },
    'т': { 0x0: 0x14, 0x5: 0x14, },
    'з': { 0x0: 0x15, 0x5: 0x15, },
    'у': { 0x0: 0x16, 0x5: 0x16, },
    'и': { 0x0: 0x17, 0x5: 0x17, },
    'о': { 0x0: 0x18, 0x5: 0x18, },
    'п': { 0x0: 0x19, 0x5: 0x19, },
    'ш': { 0x0: 0x1a, 0x5: 0x1a, },
    'ђ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'а': { 0x0: 0x1e, 0x5: 0x1e, },
    'с': { 0x0: 0x1f, 0x5: 0x1f, },
    'д': { 0x0: 0x20, 0x5: 0x20, },
    'ф': { 0x0: 0x21, 0x5: 0x21, },
    'г': { 0x0: 0x22, 0x5: 0x22, },
    'х': { 0x0: 0x23, 0x5: 0x23, },
    'ј': { 0x0: 0x24, 0x5: 0x24, },
    'к': { 0x0: 0x25, 0x5: 0x25, },
    'л': { 0x0: 0x26, 0x5: 0x26, },
    'ч': { 0x0: 0x27, 0x5: 0x27, },
    'ћ': { 0x0: 0x28, 0x5: 0x28, },
    '`': { 0x0: 0x29, },
    'ж': { 0x0: 0x2b, 0x5: 0x2b, },
    'ѕ': { 0x0: 0x2c, 0x5: 0x2c, },
    'џ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ц': { 0x0: 0x2e, 0x5: 0x2e, },
    'в': { 0x0: 0x2f, 0x5: 0x2f, },
    'б': { 0x0: 0x30, 0x5: 0x30, },
    'н': { 0x0: 0x31, 0x5: 0x31, },
    'м': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Љ': { 0x1: 0x10, 0x4: 0x10, },
    'Њ': { 0x1: 0x11, 0x4: 0x11, },
    'Е': { 0x1: 0x12, 0x4: 0x12, },
    'Р': { 0x1: 0x13, 0x4: 0x13, },
    'Т': { 0x1: 0x14, 0x4: 0x14, },
    'З': { 0x1: 0x15, 0x4: 0x15, },
    'У': { 0x1: 0x16, 0x4: 0x16, },
    'И': { 0x1: 0x17, 0x4: 0x17, },
    'О': { 0x1: 0x18, 0x4: 0x18, },
    'П': { 0x1: 0x19, 0x4: 0x19, },
    'Ш': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ђ': { 0x1: 0x1b, 0x4: 0x1b, },
    'А': { 0x1: 0x1e, 0x4: 0x1e, },
    'С': { 0x1: 0x1f, 0x4: 0x1f, },
    'Д': { 0x1: 0x20, 0x4: 0x20, },
    'Ф': { 0x1: 0x21, 0x4: 0x21, },
    'Г': { 0x1: 0x22, 0x4: 0x22, },
    'Х': { 0x1: 0x23, 0x4: 0x23, },
    'Ј': { 0x1: 0x24, 0x4: 0x24, },
    'К': { 0x1: 0x25, 0x4: 0x25, },
    'Л': { 0x1: 0x26, 0x4: 0x26, },
    'Ч': { 0x1: 0x27, 0x4: 0x27, },
    'Ћ': { 0x1: 0x28, 0x4: 0x28, },
    '~': { 0x1: 0x29, },
    'Ж': { 0x1: 0x2b, 0x4: 0x2b, },
    'Ѕ': { 0x1: 0x2c, 0x4: 0x2c, },
    'Џ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ц': { 0x1: 0x2e, 0x4: 0x2e, },
    'В': { 0x1: 0x2f, 0x4: 0x2f, },
    'Б': { 0x1: 0x30, 0x4: 0x30, },
    'Н': { 0x1: 0x31, 0x4: 0x31, },
    'М': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '^': { 0x2: 0x4, },
    '°': { 0x2: 0x6, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '€': { 0x2: 0x12, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
    'ѓ': [0, ['г', ]],
    'ќ': [0, ['к', ]],
    'Ѓ': [0, ['Г', ]],
    'Ќ': [0, ['К', ]],
    '\'': [0, [' ', ]],
  },
  accents: [
    {0x0: 0xc, },
  ]
},
{
  klid: 0x00010402,
  localeName: "bg",
  displayName: "Bulgarian (Latin)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00010405,
  localeName: "cs",
  displayName: "Czech (QWERTY)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '+': { 0x0: 0x2, 0x1: 0x4e, 0x3: 0xd, },
    'ě': { 0x0: 0x3, },
    'š': { 0x0: 0x4, },
    'č': { 0x0: 0x5, },
    'ř': { 0x0: 0x6, },
    'ž': { 0x0: 0x7, },
    'ý': { 0x0: 0x8, },
    'á': { 0x0: 0x9, },
    'í': { 0x0: 0xa, },
    'é': { 0x0: 0xb, },
    '=': { 0x0: 0xc, 0x2: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ú': { 0x0: 0x1a, },
    ')': { 0x0: 0x1b, 0x2: 0xb, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ů': { 0x0: 0x27, },
    '§': { 0x0: 0x28, },
    ';': { 0x0: 0x29, 0x2: 0x27, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, 0x2: 0xc, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '\\': { 0x0: 0x56, 0x2: 0x2b, },
    '/': { 0x0: 0x35, 0x1: 0x1a, 0x5: 0x1a, 0x2: 0x35, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, 0x5: 0x3, },
    '3': { 0x1: 0x4, 0x5: 0x4, },
    '4': { 0x1: 0x5, 0x5: 0x5, },
    '5': { 0x1: 0x6, 0x5: 0x6, },
    '6': { 0x1: 0x7, 0x5: 0x7, },
    '7': { 0x1: 0x8, 0x5: 0x8, },
    '8': { 0x1: 0x9, 0x5: 0x9, },
    '9': { 0x1: 0xa, 0x5: 0xa, },
    '0': { 0x1: 0xb, 0x5: 0xb, },
    '%': { 0x1: 0xc, 0x2: 0x6, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '(': { 0x1: 0x1b, 0x2: 0xa, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '"': { 0x1: 0x27, 0x5: 0x27, },
    '!': { 0x1: 0x28, 0x2: 0x2, },
    '\'': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '?': { 0x1: 0x33, 0x3: 0x35, },
    ':': { 0x1: 0x34, 0x3: 0x27, },
    '_': { 0x1: 0x35, 0x3: 0xc, },
    '|': { 0x1: 0x56, 0x3: 0x2b, },
    '{': { 0x3: 0x1a, },
    '}': { 0x3: 0x1b, },
    '~': { 0x3: 0x29, },
    '×': { 0x3: 0x33, },
    '÷': { 0x3: 0x34, },
    '\x1e': { 0x0: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '^': { 0x2: 0x7, },
    '&': { 0x2: 0x8, },
    '€': { 0x2: 0x12, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '¤': { 0x2: 0x28, },
    '`': { 0x2: 0x29, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
    'ß': { 0x2: 0x56, },
    'Ě': { 0x4: 0x3, },
    'Š': { 0x4: 0x4, },
    'Č': { 0x4: 0x5, },
    'Ř': { 0x4: 0x6, },
    'Ž': { 0x4: 0x7, },
    'Ý': { 0x4: 0x8, },
    'Á': { 0x4: 0x9, },
    'Í': { 0x4: 0xa, },
    'É': { 0x4: 0xb, },
    'Ú': { 0x4: 0x1a, },
    'Ů': { 0x4: 0x27, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'Ä': [1, ['A', ]],
    'ë': [1, ['e', ]],
    'Ë': [1, ['E', ]],
    'ï': [1, ['i', ]],
    'Ï': [1, ['I', ]],
    'ö': [1, ['o', ]],
    'Ö': [1, ['O', ]],
    'ü': [1, ['u', ]],
    'Ü': [1, ['U', ]],
    'ÿ': [1, ['y', ]],
    'Ÿ': [1, ['Y', ]],
    '¨': [1, [' ', ]],
    'č': [2, ['c', ]],
    'Č': [2, ['C', ]],
    'ď': [2, ['d', ]],
    'Ď': [2, ['D', ]],
    'ě': [2, ['e', ]],
    'Ě': [2, ['E', ]],
    'ř': [2, ['r', ]],
    'Ř': [2, ['R', ]],
    'ľ': [2, ['l', ]],
    'Ľ': [2, ['L', ]],
    'ň': [2, ['n', ]],
    'Ň': [2, ['N', ]],
    'š': [2, ['s', ]],
    'Š': [2, ['S', ]],
    'ť': [2, ['t', ]],
    'Ť': [2, ['T', ]],
    'ž': [2, ['z', ]],
    'Ž': [2, ['Z', ]],
    'ˇ': [2, [' ', ]],
    'å': [3, ['a', ]],
    'Å': [3, ['A', ]],
    'ů': [3, ['u', ]],
    'Ů': [3, ['U', ]],
    '°': [3, [' ', ]],
    'â': [4, ['a', ]],
    'Â': [4, ['A', ]],
    'ê': [4, ['e', ]],
    'Ê': [4, ['E', ]],
    'î': [4, ['i', ]],
    'Î': [4, ['I', ]],
    'ô': [4, ['o', ]],
    'Ô': [4, ['O', ]],
    'û': [4, ['u', ]],
    'Û': [4, ['U', ]],
    '^': [4, [' ', ]],
    'ő': [5, ['o', ]],
    'Ő': [5, ['O', ]],
    'ű': [5, ['u', ]],
    'Ű': [5, ['U', ]],
    '˝': [5, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x2b, },
    {0x1: 0xd, },
    {0x1: 0x29, },
    {0x3: 0x28, },
    {0x3: 0x56, },
  ]
},
{
  klid: 0x00010407,
  localeName: "de-DE",
  displayName: "German (IBM)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    'ß': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ü': { 0x0: 0x1a, 0x5: 0x1a, },
    '+': { 0x0: 0x1b, 0x1: 0x4e, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '#': { 0x0: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '§': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ü': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '°': { 0x1: 0x29, },
    '\'': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0x35, },
    '²': { 0x3: 0x3, 0x2: 0x3, },
    '³': { 0x3: 0x4, 0x2: 0x4, },
    '{': { 0x3: 0x8, 0x2: 0x8, },
    '[': { 0x3: 0x9, 0x2: 0x9, },
    ']': { 0x3: 0xa, 0x2: 0xa, },
    '}': { 0x3: 0xb, 0x2: 0xb, },
    'ẞ': { 0x3: 0xc, },
    '@': { 0x3: 0x10, 0x2: 0x10, },
    '~': { 0x3: 0x1b, 0x2: 0x1b, },
    'µ': { 0x3: 0x32, 0x2: 0x32, },
    '|': { 0x3: 0x56, 0x2: 0x56, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\\': { 0x2: 0xc, },
    '€': { 0x2: 0x12, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'â': [1, ['a', ]],
    'ê': [1, ['e', ]],
    'î': [1, ['i', ]],
    'ô': [1, ['o', ]],
    'û': [1, ['u', ]],
    'Â': [1, ['A', ]],
    'Ê': [1, ['E', ]],
    'Î': [1, ['I', ]],
    'Ô': [1, ['O', ]],
    'Û': [1, ['U', ]],
    '^': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x29, },
    {0x1: 0xd, },
  ]
},
{
  klid: 0x00010408,
  localeName: "el",
  displayName: "Greek (220)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    ']': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    ';': { 0x0: 0x10, },
    'ς': { 0x0: 0x11, },
    'ε': { 0x0: 0x12, 0x5: 0x12, },
    'ρ': { 0x0: 0x13, 0x5: 0x13, },
    'τ': { 0x0: 0x14, 0x5: 0x14, },
    'υ': { 0x0: 0x15, 0x5: 0x15, },
    'θ': { 0x0: 0x16, 0x5: 0x16, },
    'ι': { 0x0: 0x17, 0x5: 0x17, },
    'ο': { 0x0: 0x18, 0x5: 0x18, },
    'π': { 0x0: 0x19, 0x5: 0x19, },
    '+': { 0x0: 0x1a, 0x1: 0x4e, },
    '}': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'α': { 0x0: 0x1e, 0x5: 0x1e, },
    'σ': { 0x0: 0x1f, 0x5: 0x1f, },
    'δ': { 0x0: 0x20, 0x5: 0x20, },
    'φ': { 0x0: 0x21, 0x5: 0x21, },
    'γ': { 0x0: 0x22, 0x5: 0x22, },
    'η': { 0x0: 0x23, 0x5: 0x23, },
    'ξ': { 0x0: 0x24, 0x5: 0x24, },
    'κ': { 0x0: 0x25, 0x5: 0x25, },
    'λ': { 0x0: 0x26, 0x5: 0x26, },
    '½': { 0x0: 0x29, 0x2: 0xd, },
    '#': { 0x0: 0x2b, },
    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },
    'χ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },
    'ω': { 0x0: 0x2f, 0x5: 0x2f, },
    'β': { 0x0: 0x30, 0x5: 0x30, },
    'ν': { 0x0: 0x31, 0x5: 0x31, },
    'μ': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1a, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, 0x2: 0x5, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '[': { 0x1: 0xd, },
    ':': { 0x1: 0x10, },
    '~': { 0x1: 0x11, },
    'Ε': { 0x1: 0x12, 0x4: 0x12, },
    'Ρ': { 0x1: 0x13, 0x4: 0x13, },
    'Τ': { 0x1: 0x14, 0x4: 0x14, },
    'Υ': { 0x1: 0x15, 0x4: 0x15, },
    'Θ': { 0x1: 0x16, 0x4: 0x16, },
    'Ι': { 0x1: 0x17, 0x4: 0x17, },
    'Ο': { 0x1: 0x18, 0x4: 0x18, },
    'Π': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1b, },
    'Α': { 0x1: 0x1e, 0x4: 0x1e, },
    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },
    'Δ': { 0x1: 0x20, 0x4: 0x20, },
    'Φ': { 0x1: 0x21, 0x4: 0x21, },
    'Γ': { 0x1: 0x22, 0x4: 0x22, },
    'Η': { 0x1: 0x23, 0x4: 0x23, },
    'Ξ': { 0x1: 0x24, 0x4: 0x24, },
    'Κ': { 0x1: 0x25, 0x4: 0x25, },
    'Λ': { 0x1: 0x26, 0x4: 0x26, },
    '±': { 0x1: 0x29, 0x2: 0xc, },
    '@': { 0x1: 0x2b, },
    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },
    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },
    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },
    'Β': { 0x1: 0x30, 0x4: 0x30, },
    'Ν': { 0x1: 0x31, 0x4: 0x31, },
    'Μ': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0x35, },
    '\x1d': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '§': { 0x2: 0x6, },
    '¶': { 0x2: 0x7, },
    '¤': { 0x2: 0x9, },
    '¦': { 0x2: 0xa, },
    '°': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
    '®': { 0x2: 0x13, },
    '¥': { 0x2: 0x15, },
    '«': { 0x2: 0x1a, },
    '»': { 0x2: 0x1b, },
    '¬': { 0x2: 0x2b, },
    '©': { 0x2: 0x2e, },
  },
  deadkeys: {
    'ά': [0, ['α', ]],
    'έ': [0, ['ε', ]],
    'ί': [0, ['ι', ]],
    'ό': [0, ['ο', ]],
    'ύ': [0, ['υ', ]],
    'ώ': [0, ['ω', ]],
    'ή': [0, ['η', ]],
    'Ά': [0, ['Α', ]],
    'Έ': [0, ['Ε', ]],
    'Ί': [0, ['Ι', ]],
    'Ό': [0, ['Ο', ]],
    'Ύ': [0, ['Υ', ]],
    'Ώ': [0, ['Ω', ]],
    'Ή': [0, ['Η', ]],
    '΄': [0, [' ', ]],
    'ϊ': [1, ['ι', ]],
    'ϋ': [1, ['υ', ]],
    'Ϊ': [1, ['Ι', ]],
    'Ϋ': [1, ['Υ', ]],
    '¨': [1, [' ', ]],
    'ΐ': [2, ['ι', ]],
    'ΰ': [2, ['υ', ]],
    '΅': [2, [' ', ]],
  },
  accents: [
    {0x0: 0x27, },
    {0x0: 0x28, 0x1: 0x27, },
    {0x1: 0x28, 0x2: 0x27, },
  ]
},
{
  klid: 0x00010409,
  localeName: "en-US",
  displayName: "United States-Dvorak",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '[': { 0x0: 0xc, },
    ']': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    '\'': { 0x0: 0x10, },
    ',': { 0x0: 0x11, },
    '.': { 0x0: 0x12, },
    'p': { 0x0: 0x13, 0x5: 0x13, },
    'y': { 0x0: 0x14, 0x5: 0x14, },
    'f': { 0x0: 0x15, 0x5: 0x15, },
    'g': { 0x0: 0x16, 0x5: 0x16, },
    'c': { 0x0: 0x17, 0x5: 0x17, },
    'r': { 0x0: 0x18, 0x5: 0x18, },
    'l': { 0x0: 0x19, 0x5: 0x19, },
    '/': { 0x0: 0x1a, 0x1: 0x35, },
    '=': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    'o': { 0x0: 0x1f, 0x5: 0x1f, },
    'e': { 0x0: 0x20, 0x5: 0x20, },
    'u': { 0x0: 0x21, 0x5: 0x21, },
    'i': { 0x0: 0x22, 0x5: 0x22, },
    'd': { 0x0: 0x23, 0x5: 0x23, },
    'h': { 0x0: 0x24, 0x5: 0x24, },
    't': { 0x0: 0x25, 0x5: 0x25, },
    'n': { 0x0: 0x26, 0x5: 0x26, },
    's': { 0x0: 0x27, 0x5: 0x27, },
    '-': { 0x0: 0x28, 0x1: 0x4a, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    ';': { 0x0: 0x2c, },
    'q': { 0x0: 0x2d, 0x5: 0x2d, },
    'j': { 0x0: 0x2e, 0x5: 0x2e, },
    'k': { 0x0: 0x2f, 0x5: 0x2f, },
    'x': { 0x0: 0x30, 0x5: 0x30, },
    'b': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    'w': { 0x0: 0x33, 0x5: 0x33, },
    'v': { 0x0: 0x34, 0x5: 0x34, },
    'z': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x1b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '{': { 0x1: 0xc, },
    '}': { 0x1: 0xd, },
    '"': { 0x1: 0x10, },
    '<': { 0x1: 0x11, },
    '>': { 0x1: 0x12, },
    'P': { 0x1: 0x13, 0x4: 0x13, },
    'Y': { 0x1: 0x14, 0x4: 0x14, },
    'F': { 0x1: 0x15, 0x4: 0x15, },
    'G': { 0x1: 0x16, 0x4: 0x16, },
    'C': { 0x1: 0x17, 0x4: 0x17, },
    'R': { 0x1: 0x18, 0x4: 0x18, },
    'L': { 0x1: 0x19, 0x4: 0x19, },
    '?': { 0x1: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'O': { 0x1: 0x1f, 0x4: 0x1f, },
    'E': { 0x1: 0x20, 0x4: 0x20, },
    'U': { 0x1: 0x21, 0x4: 0x21, },
    'I': { 0x1: 0x22, 0x4: 0x22, },
    'D': { 0x1: 0x23, 0x4: 0x23, },
    'H': { 0x1: 0x24, 0x4: 0x24, },
    'T': { 0x1: 0x25, 0x4: 0x25, },
    'N': { 0x1: 0x26, 0x4: 0x26, },
    'S': { 0x1: 0x27, 0x4: 0x27, },
    '_': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    ':': { 0x1: 0x2c, },
    'Q': { 0x1: 0x2d, 0x4: 0x2d, },
    'J': { 0x1: 0x2e, 0x4: 0x2e, },
    'K': { 0x1: 0x2f, 0x4: 0x2f, },
    'X': { 0x1: 0x30, 0x4: 0x30, },
    'B': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    'W': { 0x1: 0x33, 0x4: 0x33, },
    'V': { 0x1: 0x34, 0x4: 0x34, },
    'Z': { 0x1: 0x35, 0x4: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0x28, },
    '\x1d': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0001040a,
  localeName: "es-ES",
  displayName: "Spanish Variation",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '÷': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ñ': { 0x0: 0x27, 0x5: 0x27, },
    'ç': { 0x0: 0x28, 0x5: 0x28, },
    '\'': { 0x0: 0x29, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '=': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0xc, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xc, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x4, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    'ª': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '(': { 0x1: 0x5, },
    ')': { 0x1: 0x6, },
    '¡': { 0x1: 0x7, },
    '!': { 0x1: 0x8, },
    '¿': { 0x1: 0x9, },
    '?': { 0x1: 0xa, },
    '₧': { 0x1: 0xb, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '×': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ñ': { 0x1: 0x27, 0x4: 0x27, },
    'Ç': { 0x1: 0x28, 0x4: 0x28, },
    '·': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '%': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '|': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '¼': { 0x2: 0x5, },
    '½': { 0x2: 0x6, },
    '¬': { 0x2: 0x7, },
    '_': { 0x2: 0x8, },
    '§': { 0x2: 0xa, },
    '\\': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '$': { 0x2: 0x1e, },
    '&': { 0x2: 0x1f, },
    '£': { 0x2: 0x24, },
    '±': { 0x2: 0x25, },
    '~': { 0x2: 0x27, },
    '{': { 0x2: 0x28, },
    '}': { 0x2: 0x2b, },
  },
  deadkeys: {
    'ä': [0, ['a', ]],
    'ë': [0, ['e', ]],
    'ï': [0, ['i', ]],
    'ö': [0, ['o', ]],
    'ü': [0, ['u', ]],
    'ÿ': [0, ['y', ]],
    'Ä': [0, ['A', ]],
    'Ë': [0, ['E', ]],
    'Ï': [0, ['I', ]],
    'Ö': [0, ['O', ]],
    'Ü': [0, ['U', ]],
    '¨': [0, [' ', ]],
    'à': [1, ['a', ]],
    'è': [1, ['e', ]],
    'ì': [1, ['i', ]],
    'ò': [1, ['o', ]],
    'ù': [1, ['u', ]],
    'À': [1, ['A', ]],
    'È': [1, ['E', ]],
    'Ì': [1, ['I', ]],
    'Ò': [1, ['O', ]],
    'Ù': [1, ['U', ]],
    '`': [1, [' ', ]],
    'á': [2, ['a', ]],
    'é': [2, ['e', ]],
    'í': [2, ['i', ]],
    'ó': [2, ['o', ]],
    'ú': [2, ['u', ]],
    'ý': [2, ['y', ]],
    'Á': [2, ['A', ]],
    'É': [2, ['E', ]],
    'Í': [2, ['I', ]],
    'Ó': [2, ['O', ]],
    'Ú': [2, ['U', ]],
    '´': [2, [' ', ]],
    'ã': [3, ['a', ]],
    'ñ': [3, ['n', ]],
    'õ': [3, ['o', ]],
    'Ã': [3, ['A', ]],
    'Ñ': [3, ['N', ]],
    'Õ': [3, ['O', ]],
    '~': [3, [' ', ]],
    'â': [4, ['a', ]],
    'ê': [4, ['e', ]],
    'î': [4, ['i', ]],
    'ô': [4, ['o', ]],
    'û': [4, ['u', ]],
    'Â': [4, ['A', ]],
    'Ê': [4, ['E', ]],
    'Î': [4, ['I', ]],
    'Ô': [4, ['O', ]],
    'Û': [4, ['U', ]],
    '^': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, 0x1: 0xd, },
    {0x0: 0x1b, 0x1: 0x1b, },
    {0x0: 0x2b, 0x1: 0x2b, },
    {0x2: 0xd, },
    {0x2: 0x34, },
  ]
},
{
  klid: 0x0001040e,
  localeName: "hu",
  displayName: "Hungarian 101-key",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    'ö': { 0x0: 0xb, 0x5: 0xb, },
    'ü': { 0x0: 0xc, 0x5: 0xc, },
    'ó': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ő': { 0x0: 0x1a, 0x5: 0x1a, },
    'ú': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'é': { 0x0: 0x27, 0x5: 0x27, },
    'á': { 0x0: 0x28, 0x5: 0x28, },
    'í': { 0x0: 0x29, 0x5: 0x29, 0x2: 0x24, },
    'ű': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x4, },
    '/': { 0x0: 0x35, 0x1: 0x7, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '\'': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '!': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '=': { 0x1: 0x8, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    'Ö': { 0x1: 0xb, 0x4: 0xb, },
    'Ü': { 0x1: 0xc, 0x4: 0xc, },
    'Ó': { 0x1: 0xd, 0x4: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ő': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ú': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'É': { 0x1: 0x27, 0x4: 0x27, },
    'Á': { 0x1: 0x28, 0x4: 0x28, },
    'Í': { 0x1: 0x29, 0x2: 0x17, 0x4: 0x29, },
    'Ű': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '?': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '~': { 0x2: 0x2, },
    'ˇ': { 0x2: 0x3, },
    '^': { 0x2: 0x4, },
    '˘': { 0x2: 0x5, },
    '°': { 0x2: 0x6, },
    '˛': { 0x2: 0x7, },
    '`': { 0x2: 0x8, },
    '˙': { 0x2: 0x9, },
    '´': { 0x2: 0xa, },
    '˝': { 0x2: 0xb, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    'Ä': { 0x2: 0x12, },
    '§': { 0x2: 0x13, },
    '¤': { 0x2: 0x14, },
    '€': { 0x2: 0x16, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    'ä': { 0x2: 0x1e, },
    'đ': { 0x2: 0x1f, },
    'Đ': { 0x2: 0x20, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    '$': { 0x2: 0x27, },
    'ß': { 0x2: 0x28, },
    '0': { 0x2: 0x29, },
    '>': { 0x2: 0x2c, },
    '#': { 0x2: 0x2d, },
    '&': { 0x2: 0x2e, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '<': { 0x2: 0x32, },
    ';': { 0x2: 0x33, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00010410,
  localeName: "it-IT",
  displayName: "Italian (142)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    'ì': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'è': { 0x0: 0x1a, },
    '+': { 0x0: 0x1b, 0x1: 0x4e, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ò': { 0x0: 0x27, },
    'à': { 0x0: 0x28, },
    '\\': { 0x0: 0x29, },
    'ù': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '^': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'é': { 0x1: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'ç': { 0x1: 0x27, },
    '°': { 0x1: 0x28, },
    '|': { 0x1: 0x29, },
    '§': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\x1f': { 0x0: 0x35, },
    '#': { 0x2: 0x4, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '@': { 0x2: 0x10, },
    '~': { 0x2: 0x1b, },
    '`': { 0x2: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00010415,
  localeName: "pl",
  displayName: "Polish (214)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\'': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'z': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ż': { 0x0: 0x1a, },
    'ś': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ł': { 0x0: 0x27, 0x5: 0x27, },
    'ą': { 0x0: 0x28, },
    'ó': { 0x0: 0x2b, },
    'y': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x2: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Z': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'ń': { 0x1: 0x1a, },
    'ć': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ł': { 0x1: 0x27, 0x4: 0x27, },
    'ę': { 0x1: 0x28, },
    'ź': { 0x1: 0x2b, },
    'Y': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x2: 0x34, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '~': { 0x2: 0x2, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '¦': { 0x2: 0x11, },
    '€': { 0x2: 0x16, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    'đ': { 0x2: 0x1f, },
    'Đ': { 0x2: 0x20, },
    '$': { 0x2: 0x27, },
    'ß': { 0x2: 0x28, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '§': { 0x2: 0x32, },
  },
  deadkeys: {
    'Ą': [0, ['A', ]],
    'Ę': [0, ['E', ]],
    'ą': [0, ['a', ]],
    'ę': [0, ['e', ]],
    '˛': [0, [' ', ]],
    'Ż': [1, ['Z', ]],
    'ż': [1, ['z', ]],
    '·': [1, [' ', ]],
    'Ť': [2, ['T', ]],
    'Ž': [2, ['Z', ]],
    'Č': [2, ['C', ]],
    'Ě': [2, ['E', ]],
    'Ď': [2, ['D', ]],
    'Ř': [2, ['R', ]],
    'Š': [2, ['S', ]],
    'Ň': [2, ['N', ]],
    'ť': [2, ['t', ]],
    'ž': [2, ['z', ]],
    'č': [2, ['c', ]],
    'ě': [2, ['e', ]],
    'ď': [2, ['d', ]],
    'ř': [2, ['r', ]],
    'š': [2, ['s', ]],
    'ň': [2, ['n', ]],
    'ˇ': [2, [' ', ]],
    'Â': [3, ['A', ]],
    'Î': [3, ['I', ]],
    'Ô': [3, ['O', ]],
    'â': [3, ['a', ]],
    'î': [3, ['i', ]],
    'ô': [3, ['o', ]],
    '^': [3, [' ', ]],
    'Ă': [4, ['A', ]],
    'ă': [4, ['a', ]],
    '˘': [4, [' ', ]],
    'Ů': [5, ['U', ]],
    'ů': [5, ['u', ]],
    '°': [5, [' ', ]],
    'Ŕ': [6, ['R', ]],
    'Á': [6, ['A', ]],
    'Ĺ': [6, ['L', ]],
    'Ć': [6, ['C', ]],
    'É': [6, ['E', ]],
    'Í': [6, ['I', ]],
    'Ń': [6, ['N', ]],
    'Ó': [6, ['O', ]],
    'Ú': [6, ['U', ]],
    'Ý': [6, ['Y', ]],
    'Ś': [6, ['S', ]],
    'Ź': [6, ['Z', ]],
    'ŕ': [6, ['r', ]],
    'á': [6, ['a', ]],
    'ĺ': [6, ['l', ]],
    'ć': [6, ['c', ]],
    'é': [6, ['e', ]],
    'í': [6, ['i', ]],
    'ń': [6, ['n', ]],
    'ó': [6, ['o', ]],
    'ú': [6, ['u', ]],
    'ý': [6, ['y', ]],
    'ś': [6, ['s', ]],
    'ź': [6, ['z', ]],
    '´': [6, [' ', ]],
    'Ő': [7, ['O', ]],
    'Ű': [7, ['U', ]],
    'ő': [7, ['o', ]],
    'ű': [7, ['u', ]],
    '˝': [7, [' ', ]],
    'Ä': [8, ['A', ]],
    'Ë': [8, ['E', ]],
    'Ö': [8, ['O', ]],
    'Ü': [8, ['U', ]],
    'ä': [8, ['a', ]],
    'ë': [8, ['e', ]],
    'ö': [8, ['o', ]],
    'ü': [8, ['u', ]],
    '¨': [8, [' ', ]],
    'Ş': [9, ['S', ]],
    'Ç': [9, ['C', ]],
    'Ţ': [9, ['T', ]],
    'ş': [9, ['s', ]],
    'ç': [9, ['c', ]],
    'ţ': [9, ['t', ]],
    '¸': [9, [' ', ]],
  },
  accents: [
    {0x0: 0x29, 0x2: 0x7, },
    {0x1: 0x29, 0x2: 0x9, },
    {0x2: 0x3, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x6, },
    {0x2: 0xa, },
    {0x2: 0xb, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x00010416,
  localeName: "pt-BR",
  displayName: "Portuguese (Brazil ABNT2)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ç': { 0x0: 0x27, 0x5: 0x27, },
    '\'': { 0x0: 0x29, },
    ']': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, 0x1: 0x7e, },
    ';': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, },
    '/': { 0x0: 0x73, 0x1: 0x35, 0x2: 0x10, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ç': { 0x1: 0x27, 0x4: 0x27, },
    '"': { 0x1: 0x29, },
    '}': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    ':': { 0x1: 0x35, },
    '|': { 0x1: 0x56, },
    '?': { 0x1: 0x73, 0x2: 0x11, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '¹': { 0x2: 0x2, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '£': { 0x2: 0x5, },
    '¢': { 0x2: 0x6, },
    '¬': { 0x2: 0x7, },
    '§': { 0x2: 0xd, },
    '°': { 0x2: 0x12, },
    'ª': { 0x2: 0x1b, },
    'º': { 0x2: 0x2b, },
    '₢': { 0x2: 0x2e, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'ã': [1, ['a', ]],
    'õ': [1, ['o', ]],
    'ñ': [1, ['n', ]],
    'Ã': [1, ['A', ]],
    'Õ': [1, ['O', ]],
    'Ñ': [1, ['N', ]],
    '~': [1, [' ', ]],
    'ä': [2, ['a', ]],
    'ë': [2, ['e', ]],
    'ï': [2, ['i', ]],
    'ö': [2, ['o', ]],
    'ü': [2, ['u', ]],
    'ÿ': [2, ['y', ]],
    'Ä': [2, ['A', ]],
    'Ë': [2, ['E', ]],
    'Ï': [2, ['I', ]],
    'Ö': [2, ['O', ]],
    'Ü': [2, ['U', ]],
    '¨': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
    'â': [4, ['a', ]],
    'ê': [4, ['e', ]],
    'î': [4, ['i', ]],
    'ô': [4, ['o', ]],
    'û': [4, ['u', ]],
    'Â': [4, ['A', ]],
    'Ê': [4, ['E', ]],
    'Î': [4, ['I', ]],
    'Ô': [4, ['O', ]],
    'Û': [4, ['U', ]],
    '^': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, },
    {0x0: 0x28, },
    {0x1: 0x7, },
    {0x1: 0x1a, },
    {0x1: 0x28, },
  ]
},
{
  klid: 0x00010419,
  localeName: "ru",
  displayName: "Russian (Typewriter)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '№': { 0x0: 0x2, },
    '-': { 0x0: 0x3, 0x1: 0x4a, },
    '/': { 0x0: 0x4, 0x1: 0x35, },
    '"': { 0x0: 0x5, },
    ':': { 0x0: 0x6, },
    ',': { 0x0: 0x7, },
    '.': { 0x0: 0x8, },
    '_': { 0x0: 0x9, },
    '?': { 0x0: 0xa, },
    '%': { 0x0: 0xb, },
    '!': { 0x0: 0xc, },
    ';': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'й': { 0x0: 0x10, 0x5: 0x10, },
    'ц': { 0x0: 0x11, 0x5: 0x11, },
    'у': { 0x0: 0x12, 0x5: 0x12, },
    'к': { 0x0: 0x13, 0x5: 0x13, },
    'е': { 0x0: 0x14, 0x5: 0x14, },
    'н': { 0x0: 0x15, 0x5: 0x15, },
    'г': { 0x0: 0x16, 0x5: 0x16, },
    'ш': { 0x0: 0x17, 0x5: 0x17, },
    'щ': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'х': { 0x0: 0x1a, 0x5: 0x1a, },
    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ф': { 0x0: 0x1e, 0x5: 0x1e, },
    'ы': { 0x0: 0x1f, 0x5: 0x1f, },
    'в': { 0x0: 0x20, 0x5: 0x20, },
    'а': { 0x0: 0x21, 0x5: 0x21, },
    'п': { 0x0: 0x22, 0x5: 0x22, },
    'р': { 0x0: 0x23, 0x5: 0x23, },
    'о': { 0x0: 0x24, 0x5: 0x24, },
    'л': { 0x0: 0x25, 0x5: 0x25, },
    'д': { 0x0: 0x26, 0x5: 0x26, },
    'ж': { 0x0: 0x27, 0x5: 0x27, },
    'э': { 0x0: 0x28, 0x5: 0x28, },
    '|': { 0x0: 0x29, },
    ')': { 0x0: 0x2b, },
    'я': { 0x0: 0x2c, 0x5: 0x2c, },
    'ч': { 0x0: 0x2d, 0x5: 0x2d, },
    'с': { 0x0: 0x2e, 0x5: 0x2e, },
    'м': { 0x0: 0x2f, 0x5: 0x2f, },
    'и': { 0x0: 0x30, 0x5: 0x30, },
    'т': { 0x0: 0x31, 0x5: 0x31, },
    'ь': { 0x0: 0x32, 0x5: 0x32, },
    'б': { 0x0: 0x33, 0x5: 0x33, },
    'ю': { 0x0: 0x34, 0x5: 0x34, },
    'ё': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x29, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, },
    '3': { 0x1: 0x4, },
    '4': { 0x1: 0x5, },
    '5': { 0x1: 0x6, },
    '6': { 0x1: 0x7, },
    '7': { 0x1: 0x8, },
    '8': { 0x1: 0x9, },
    '9': { 0x1: 0xa, },
    '0': { 0x1: 0xb, },
    '=': { 0x1: 0xc, },
    '\\': { 0x1: 0xd, },
    'Й': { 0x1: 0x10, 0x4: 0x10, },
    'Ц': { 0x1: 0x11, 0x4: 0x11, },
    'У': { 0x1: 0x12, 0x4: 0x12, },
    'К': { 0x1: 0x13, 0x4: 0x13, },
    'Е': { 0x1: 0x14, 0x4: 0x14, },
    'Н': { 0x1: 0x15, 0x4: 0x15, },
    'Г': { 0x1: 0x16, 0x4: 0x16, },
    'Ш': { 0x1: 0x17, 0x4: 0x17, },
    'Щ': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Х': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },
    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },
    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },
    'В': { 0x1: 0x20, 0x4: 0x20, },
    'А': { 0x1: 0x21, 0x4: 0x21, },
    'П': { 0x1: 0x22, 0x4: 0x22, },
    'Р': { 0x1: 0x23, 0x4: 0x23, },
    'О': { 0x1: 0x24, 0x4: 0x24, },
    'Л': { 0x1: 0x25, 0x4: 0x25, },
    'Д': { 0x1: 0x26, 0x4: 0x26, },
    'Ж': { 0x1: 0x27, 0x4: 0x27, },
    'Э': { 0x1: 0x28, 0x4: 0x28, },
    '(': { 0x1: 0x2b, },
    'Я': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },
    'С': { 0x1: 0x2e, 0x4: 0x2e, },
    'М': { 0x1: 0x2f, 0x4: 0x2f, },
    'И': { 0x1: 0x30, 0x4: 0x30, },
    'Т': { 0x1: 0x31, 0x4: 0x31, },
    'Ь': { 0x1: 0x32, 0x4: 0x32, },
    'Б': { 0x1: 0x33, 0x4: 0x33, },
    'Ю': { 0x1: 0x34, 0x4: 0x34, },
    'Ё': { 0x1: 0x35, 0x4: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '₽': { 0x2: 0x9, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0001041b,
  localeName: "sk",
  displayName: "Slovak (QWERTY)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '+': { 0x0: 0x2, 0x1: 0x4e, },
    'ľ': { 0x0: 0x3, },
    'š': { 0x0: 0x4, },
    'č': { 0x0: 0x5, },
    'ť': { 0x0: 0x6, },
    'ž': { 0x0: 0x7, },
    'ý': { 0x0: 0x8, },
    'á': { 0x0: 0x9, },
    'í': { 0x0: 0xa, },
    'é': { 0x0: 0xb, },
    '=': { 0x0: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ú': { 0x0: 0x1a, },
    'ä': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ô': { 0x0: 0x27, },
    '§': { 0x0: 0x28, },
    ';': { 0x0: 0x29, },
    'ň': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '&': { 0x0: 0x56, 0x2: 0x2e, },
    '/': { 0x0: 0x35, 0x1: 0x1a, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, },
    '2': { 0x1: 0x3, },
    '3': { 0x1: 0x4, },
    '4': { 0x1: 0x5, },
    '5': { 0x1: 0x6, },
    '6': { 0x1: 0x7, },
    '7': { 0x1: 0x8, },
    '8': { 0x1: 0x9, },
    '9': { 0x1: 0xa, },
    '0': { 0x1: 0xb, },
    '%': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '(': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '"': { 0x1: 0x27, },
    '!': { 0x1: 0x28, },
    ')': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '?': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    '~': { 0x2: 0x2, },
    '`': { 0x2: 0x8, },
    '\\': { 0x2: 0x10, },
    '|': { 0x2: 0x11, },
    '€': { 0x2: 0x12, },
    '\'': { 0x2: 0x19, },
    '÷': { 0x2: 0x1a, },
    '×': { 0x2: 0x1b, },
    'đ': { 0x2: 0x1f, },
    'Đ': { 0x2: 0x20, },
    '[': { 0x2: 0x21, },
    ']': { 0x2: 0x22, },
    'ł': { 0x2: 0x25, },
    'Ł': { 0x2: 0x26, },
    '$': { 0x2: 0x27, },
    'ß': { 0x2: 0x28, },
    '¤': { 0x2: 0x2b, },
    '>': { 0x2: 0x2c, },
    '#': { 0x2: 0x2d, },
    '@': { 0x2: 0x2f, },
    '{': { 0x2: 0x30, },
    '}': { 0x2: 0x31, },
    '<': { 0x2: 0x33, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    '´': [0, [' ', ]],
    'č': [1, ['c', ]],
    'Č': [1, ['C', ]],
    'ď': [1, ['d', ]],
    'Ď': [1, ['D', ]],
    'ě': [1, ['e', ]],
    'Ě': [1, ['E', ]],
    'ř': [1, ['r', ]],
    'Ř': [1, ['R', ]],
    'ľ': [1, ['l', ]],
    'Ľ': [1, ['L', ]],
    'ň': [1, ['n', ]],
    'Ň': [1, ['N', ]],
    'š': [1, ['s', ]],
    'Š': [1, ['S', ]],
    'ť': [1, ['t', ]],
    'Ť': [1, ['T', ]],
    'ž': [1, ['z', ]],
    'Ž': [1, ['Z', ]],
    'ˇ': [1, [' ', ]],
    'ů': [2, ['u', ]],
    'Ů': [2, ['U', ]],
    '°': [2, [' ', ]],
    'â': [3, ['a', ]],
    'Â': [3, ['A', ]],
    'î': [3, ['i', ]],
    'Î': [3, ['I', ]],
    'ô': [3, ['o', ]],
    'Ô': [3, ['O', ]],
    '^': [3, [' ', ]],
    'ă': [4, ['a', ]],
    'Ă': [4, ['A', ]],
    '˘': [4, [' ', ]],
    'ą': [5, ['a', ]],
    'Ą': [5, ['A', ]],
    'ę': [5, ['e', ]],
    'Ę': [5, ['E', ]],
    '˛': [5, [' ', ]],
    'ż': [6, ['z', ]],
    'Ż': [6, ['Z', ]],
    '˙': [6, [' ', ]],
    'ő': [7, ['o', ]],
    'Ő': [7, ['O', ]],
    'ű': [7, ['u', ]],
    'Ű': [7, ['U', ]],
    '˝': [7, [' ', ]],
    'ä': [8, ['a', ]],
    'Ä': [8, ['A', ]],
    'ë': [8, ['e', ]],
    'Ë': [8, ['E', ]],
    'ö': [8, ['o', ]],
    'Ö': [8, ['O', ]],
    'ü': [8, ['u', ]],
    'Ü': [8, ['U', ]],
    '¨': [8, [' ', ]],
    'ç': [9, ['c', ]],
    'Ç': [9, ['C', ]],
    'ş': [9, ['s', ]],
    'Ş': [9, ['S', ]],
    'ţ': [9, ['t', ]],
    'Ţ': [9, ['T', ]],
    '¸': [9, [' ', ]],
  },
  accents: [
    {0x0: 0xd, 0x2: 0xa, },
    {0x1: 0xd, 0x2: 0x3, },
    {0x1: 0x29, 0x2: 0x6, },
    {0x2: 0x4, },
    {0x2: 0x5, },
    {0x2: 0x7, },
    {0x2: 0x9, },
    {0x2: 0xb, },
    {0x2: 0xc, },
    {0x2: 0xd, },
  ]
},
{
  klid: 0x0001041f,
  localeName: "tr",
  displayName: "Turkish F",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '/': { 0x0: 0xc, 0x1: 0x35, },
    '-': { 0x0: 0xd, 0x1: 0x4a, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'f': { 0x0: 0x10, 0x5: 0x10, },
    'g': { 0x0: 0x11, 0x5: 0x11, },
    'ğ': { 0x0: 0x12, 0x5: 0x12, },
    'ı': { 0x0: 0x13, 0x5: 0x13, },
    'o': { 0x0: 0x14, 0x5: 0x14, },
    'd': { 0x0: 0x15, 0x5: 0x15, },
    'r': { 0x0: 0x16, 0x5: 0x16, },
    'n': { 0x0: 0x17, 0x5: 0x17, },
    'h': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'q': { 0x0: 0x1a, 0x5: 0x1a, },
    'w': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'u': { 0x0: 0x1e, 0x5: 0x1e, },
    'i': { 0x0: 0x1f, 0x5: 0x1f, },
    'e': { 0x0: 0x20, 0x5: 0x20, },
    'a': { 0x0: 0x21, 0x5: 0x21, },
    'ü': { 0x0: 0x22, 0x5: 0x22, },
    't': { 0x0: 0x23, 0x5: 0x23, },
    'k': { 0x0: 0x24, 0x5: 0x24, },
    'm': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'y': { 0x0: 0x27, 0x5: 0x27, },
    'ş': { 0x0: 0x28, 0x5: 0x28, },
    '+': { 0x0: 0x29, 0x1: 0x4e, },
    'x': { 0x0: 0x2b, 0x5: 0x2b, },
    'j': { 0x0: 0x2c, 0x5: 0x2c, },
    'ö': { 0x0: 0x2d, 0x5: 0x2d, },
    'v': { 0x0: 0x2e, 0x5: 0x2e, },
    'c': { 0x0: 0x2f, 0x5: 0x2f, },
    'ç': { 0x0: 0x30, 0x5: 0x30, },
    'z': { 0x0: 0x31, 0x5: 0x31, },
    's': { 0x0: 0x32, 0x5: 0x32, },
    'b': { 0x0: 0x33, 0x5: 0x33, },
    '.': { 0x0: 0x34, },
    ',': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x29, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, 0x3: 0x2c, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '\'': { 0x1: 0x8, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '_': { 0x1: 0xd, },
    'F': { 0x1: 0x10, 0x4: 0x10, },
    'G': { 0x1: 0x11, 0x4: 0x11, },
    'Ğ': { 0x1: 0x12, 0x4: 0x12, },
    'I': { 0x1: 0x13, 0x4: 0x13, },
    'O': { 0x1: 0x14, 0x4: 0x14, },
    'D': { 0x1: 0x15, 0x4: 0x15, },
    'R': { 0x1: 0x16, 0x4: 0x16, },
    'N': { 0x1: 0x17, 0x4: 0x17, },
    'H': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Q': { 0x1: 0x1a, 0x4: 0x1a, },
    'W': { 0x1: 0x1b, 0x4: 0x1b, },
    'U': { 0x1: 0x1e, 0x4: 0x1e, },
    'İ': { 0x1: 0x1f, 0x4: 0x1f, },
    'E': { 0x1: 0x20, 0x4: 0x20, },
    'A': { 0x1: 0x21, 0x4: 0x21, },
    'Ü': { 0x1: 0x22, 0x4: 0x22, },
    'T': { 0x1: 0x23, 0x4: 0x23, },
    'K': { 0x1: 0x24, 0x4: 0x24, },
    'M': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Y': { 0x1: 0x27, 0x4: 0x27, },
    'Ş': { 0x1: 0x28, 0x4: 0x28, },
    'X': { 0x1: 0x2b, 0x4: 0x2b, },
    'J': { 0x1: 0x2c, 0x4: 0x2c, },
    'Ö': { 0x1: 0x2d, 0x4: 0x2d, },
    'V': { 0x1: 0x2e, 0x4: 0x2e, },
    'C': { 0x1: 0x2f, 0x4: 0x2f, },
    'Ç': { 0x1: 0x30, 0x4: 0x30, },
    'Z': { 0x1: 0x31, 0x4: 0x31, },
    'S': { 0x1: 0x32, 0x4: 0x32, },
    'B': { 0x1: 0x33, 0x4: 0x33, },
    ':': { 0x1: 0x34, },
    ';': { 0x1: 0x35, },
    '>': { 0x1: 0x56, 0x3: 0x2d, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xd, },
    '¡': { 0x3: 0x2, },
    '³': { 0x3: 0x4, },
    '¤': { 0x3: 0x5, },
    '¿': { 0x3: 0xc, },
    '®': { 0x3: 0x13, },
    'Ø': { 0x3: 0x18, 0x6: 0x18, },
    'Æ': { 0x3: 0x1e, 0x6: 0x1e, },
    '§': { 0x3: 0x1f, 0x6: 0x1f, },
    'ª': { 0x3: 0x21, },
    '©': { 0x3: 0x2e, },
    'º': { 0x3: 0x32, },
    '¦': { 0x3: 0x56, },
    'ø': { 0x7: 0x18, 0x2: 0x18, },
    'æ': { 0x7: 0x1e, 0x2: 0x1e, },
    'ß': { 0x7: 0x1f, 0x2: 0x1f, },
    '\x1c': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x22, },
    '¹': { 0x2: 0x2, },
    '²': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '¼': { 0x2: 0x5, },
    '½': { 0x2: 0x6, },
    '¾': { 0x2: 0x7, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    '|': { 0x2: 0xd, },
    '@': { 0x2: 0x10, },
    '¶': { 0x2: 0x13, },
    '¥': { 0x2: 0x15, },
    '£': { 0x2: 0x19, },
    '€': { 0x2: 0x20, },
    '₺': { 0x2: 0x23, },
    '¬': { 0x2: 0x29, },
    '«': { 0x2: 0x2c, },
    '»': { 0x2: 0x2d, },
    '¢': { 0x2: 0x2e, },
    'µ': { 0x2: 0x32, },
    '×': { 0x2: 0x33, },
    '÷': { 0x2: 0x34, },
    '\xad': { 0x2: 0x35, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', 'ı', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', 'İ', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', 'ı', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', 'İ', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'ã': [2, ['a', ]],
    'õ': [2, ['o', ]],
    'ñ': [2, ['n', ]],
    'Ã': [2, ['A', ]],
    'Õ': [2, ['O', ]],
    'Ñ': [2, ['N', ]],
    '~': [2, [' ', ]],
    'á': [3, ['a', ]],
    'é': [3, ['e', ]],
    'í': [3, ['i', 'ı', ]],
    'ó': [3, ['o', ]],
    'ú': [3, ['u', ]],
    'Á': [3, ['A', ]],
    'É': [3, ['E', ]],
    'Í': [3, ['I', 'İ', ]],
    'Ó': [3, ['O', ]],
    'Ú': [3, ['U', ]],
    '´': [3, [' ', ]],
    'à': [4, ['a', ]],
    'è': [4, ['e', ]],
    'ì': [4, ['i', 'ı', ]],
    'ò': [4, ['o', ]],
    'ù': [4, ['u', ]],
    'À': [4, ['A', ]],
    'È': [4, ['E', ]],
    'Ì': [4, ['I', 'İ', ]],
    'Ò': [4, ['O', ]],
    'Ù': [4, ['U', ]],
    '`': [4, [' ', ]],
  },
  accents: [
    {0x1: 0x4, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
    {0x2: 0x27, },
    {0x2: 0x2b, },
  ]
},
{
  klid: 0x00010426,
  localeName: "lv",
  displayName: "Latvian (QWERTY)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '§': { 0x3: 0x5, },
    '°': { 0x3: 0x6, },
    '±': { 0x3: 0x8, },
    '×': { 0x3: 0x9, },
    '—': { 0x3: 0xc, },
    'Ē': { 0x3: 0x12, 0x6: 0x12, },
    'Ŗ': { 0x3: 0x13, 0x6: 0x13, },
    'Ū': { 0x3: 0x16, 0x6: 0x16, },
    'Ī': { 0x3: 0x17, 0x6: 0x17, },
    'Õ': { 0x3: 0x18, 0x6: 0x18, },
    'Ā': { 0x3: 0x1e, 0x6: 0x1e, },
    'Š': { 0x3: 0x1f, 0x6: 0x1f, },
    'Ģ': { 0x3: 0x22, 0x6: 0x22, },
    'Ķ': { 0x3: 0x25, 0x6: 0x25, },
    'Ļ': { 0x3: 0x26, 0x6: 0x26, },
    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },
    'Č': { 0x3: 0x2e, 0x6: 0x2e, },
    'Ņ': { 0x3: 0x31, 0x6: 0x31, },
    'ē': { 0x7: 0x12, 0x2: 0x12, },
    'ŗ': { 0x7: 0x13, 0x2: 0x13, },
    'ū': { 0x7: 0x16, 0x2: 0x16, },
    'ī': { 0x7: 0x17, 0x2: 0x17, },
    'õ': { 0x7: 0x18, 0x2: 0x18, },
    'ā': { 0x7: 0x1e, 0x2: 0x1e, },
    'š': { 0x7: 0x1f, 0x2: 0x1f, },
    'ģ': { 0x7: 0x22, 0x2: 0x22, },
    'ķ': { 0x7: 0x25, 0x2: 0x25, },
    'ļ': { 0x7: 0x26, 0x2: 0x26, },
    'ž': { 0x7: 0x2c, 0x2: 0x2c, },
    'č': { 0x7: 0x2e, 0x2: 0x2e, },
    'ņ': { 0x7: 0x31, 0x2: 0x31, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '\xa0': { 0x2: 0x2, },
    '«': { 0x2: 0x3, },
    '»': { 0x2: 0x4, },
    '€': { 0x2: 0x5, },
    '’': { 0x2: 0x7, },
    '–': { 0x2: 0xc, },
    '\xad': { 0x2: 0x29, },
  },
  deadkeys: {
    'å': [0, ['a', ]],
    'Å': [0, ['A', ]],
    'ė': [0, ['e', ]],
    'Ė': [0, ['E', ]],
    'ż': [0, ['z', ]],
    'Ż': [0, ['Z', ]],
    'ġ': [0, ['g', ]],
    '°': [0, [' ', ]],
    'õ': [1, ['o', ]],
    'Õ': [1, ['O', ]],
    '~': [1, [' ', ]],
    'ä': [2, ['a', ]],
    'ü': [2, ['u', ]],
    'ö': [2, ['o', ]],
    'Ä': [2, ['A', ]],
    'Ü': [2, ['U', ]],
    'Ö': [2, ['O', ]],
    '¨': [2, [' ', ]],
    'ń': [3, ['n', ]],
    'ć': [3, ['c', ]],
    'ó': [3, ['o', ]],
    'é': [3, ['e', ]],
    'ś': [3, ['s', ]],
    'ź': [3, ['z', ]],
    'Ń': [3, ['N', ]],
    'Ć': [3, ['C', ]],
    'Ó': [3, ['O', ]],
    'É': [3, ['E', ]],
    'Ś': [3, ['S', ]],
    'Ź': [3, ['Z', ]],
    '´': [3, [' ', ]],
  },
  accents: [
    {0x0: 0x2b, },
    {0x1: 0x29, },
    {0x3: 0x28, },
    {0x2: 0x28, },
  ]
},
{
  klid: 0x00010427,
  localeName: "lt",
  displayName: "Lithuanian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    'ą': { 0x0: 0x2, 0x5: 0x2, },
    'č': { 0x0: 0x3, 0x5: 0x3, },
    'ę': { 0x0: 0x4, 0x5: 0x4, },
    'ė': { 0x0: 0x5, 0x5: 0x5, },
    'į': { 0x0: 0x6, 0x5: 0x6, },
    'š': { 0x0: 0x7, 0x5: 0x7, },
    'ų': { 0x0: 0x8, 0x5: 0x8, },
    'ū': { 0x0: 0x9, 0x5: 0x9, },
    '9': { 0x0: 0xa, 0x2: 0xa, },
    '0': { 0x0: 0xb, 0x2: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    'ž': { 0x0: 0xd, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x3: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x4e, 0x3: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    'Ą': { 0x1: 0x2, 0x4: 0x2, },
    'Č': { 0x1: 0x3, 0x4: 0x3, },
    'Ę': { 0x1: 0x4, 0x4: 0x4, },
    'Ė': { 0x1: 0x5, 0x4: 0x5, },
    'Į': { 0x1: 0x6, 0x4: 0x6, },
    'Š': { 0x1: 0x7, 0x4: 0x7, },
    'Ų': { 0x1: 0x8, 0x4: 0x8, },
    'Ū': { 0x1: 0x9, 0x4: 0x9, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Ž': { 0x1: 0xd, 0x4: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '!': { 0x3: 0x2, },
    '@': { 0x3: 0x3, },
    '#': { 0x3: 0x4, },
    '$': { 0x3: 0x5, },
    '%': { 0x3: 0x6, },
    '^': { 0x3: 0x7, },
    '&': { 0x3: 0x8, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '1': { 0x2: 0x2, },
    '2': { 0x2: 0x3, },
    '3': { 0x2: 0x4, },
    '4': { 0x2: 0x5, },
    '5': { 0x2: 0x6, },
    '6': { 0x2: 0x7, },
    '7': { 0x2: 0x8, },
    '8': { 0x2: 0x9, },
    '=': { 0x2: 0xd, },
    '€': { 0x2: 0x12, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0001043a,
  localeName: "mt",
  displayName: "Maltese 48-Key",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ġ': { 0x0: 0x1a, 0x5: 0x1a, },
    'ħ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    'ċ': { 0x0: 0x29, 0x5: 0x29, },
    '#': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    'ż': { 0x0: 0x56, 0x5: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '€': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ġ': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ħ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '@': { 0x1: 0x28, },
    'Ċ': { 0x1: 0x29, 0x4: 0x29, },
    '~': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    'Ż': { 0x1: 0x56, 0x4: 0x56, },
    'È': { 0x3: 0x12, 0x6: 0x12, },
    'Ù': { 0x3: 0x16, 0x6: 0x16, },
    'Ì': { 0x3: 0x17, 0x6: 0x17, },
    'Ò': { 0x3: 0x18, 0x6: 0x18, },
    '{': { 0x3: 0x1a, },
    '}': { 0x3: 0x1b, },
    'À': { 0x3: 0x1e, 0x6: 0x1e, },
    '¬': { 0x3: 0x29, },
    '|': { 0x3: 0x56, },
    '£': { 0x7: 0x4, 0x2: 0x4, },
    'è': { 0x7: 0x12, 0x2: 0x12, },
    'ù': { 0x7: 0x16, 0x2: 0x16, },
    'ì': { 0x7: 0x17, 0x2: 0x17, },
    'ò': { 0x7: 0x18, 0x2: 0x18, },
    'à': { 0x7: 0x1e, 0x2: 0x1e, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '[': { 0x2: 0x1a, },
    ']': { 0x2: 0x1b, },
    '`': { 0x2: 0x29, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x0001043b,
  localeName: "se-Latn-NO",
  displayName: "Sami Extended Norway",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\\': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'á': { 0x0: 0x10, 0x5: 0x10, },
    'š': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'ŧ': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    'ŋ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ø': { 0x0: 0x27, 0x5: 0x27, },
    'æ': { 0x0: 0x28, 0x5: 0x28, },
    '|': { 0x0: 0x29, },
    'đ': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'č': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x3: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    'ž': { 0x0: 0x56, 0x5: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Á': { 0x1: 0x10, 0x4: 0x10, },
    'Š': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Ŧ': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ŋ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ø': { 0x1: 0x27, 0x4: 0x27, },
    'Æ': { 0x1: 0x28, 0x4: 0x28, },
    '§': { 0x1: 0x29, },
    'Đ': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'Č': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    'Ž': { 0x1: 0x56, 0x4: 0x56, },
    'Q': { 0x3: 0x10, 0x6: 0x10, },
    'W': { 0x3: 0x11, 0x6: 0x11, },
    'Y': { 0x3: 0x15, 0x6: 0x15, },
    'Ï': { 0x3: 0x17, 0x6: 0x17, },
    'Õ': { 0x3: 0x18, 0x6: 0x18, },
    'Â': { 0x3: 0x1e, 0x6: 0x1e, },
    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },
    'Ǥ': { 0x3: 0x23, 0x6: 0x23, },
    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },
    'Ö': { 0x3: 0x27, 0x6: 0x27, },
    'Ä': { 0x3: 0x28, 0x6: 0x28, },
    'Ʒ': { 0x3: 0x2c, 0x6: 0x2c, },
    'X': { 0x3: 0x2d, 0x6: 0x2d, },
    'Ǯ': { 0x3: 0x56, 0x6: 0x56, },
    'q': { 0x7: 0x10, 0x2: 0x10, },
    'w': { 0x7: 0x11, 0x2: 0x11, },
    'y': { 0x7: 0x15, 0x2: 0x15, },
    'ï': { 0x7: 0x17, 0x2: 0x17, },
    'õ': { 0x7: 0x18, 0x2: 0x18, },
    'â': { 0x7: 0x1e, 0x2: 0x1e, },
    'ǧ': { 0x7: 0x22, 0x2: 0x22, },
    'ǥ': { 0x7: 0x23, 0x2: 0x23, },
    'ǩ': { 0x7: 0x25, 0x2: 0x25, },
    'ö': { 0x7: 0x27, 0x2: 0x27, },
    'ä': { 0x7: 0x28, 0x2: 0x28, },
    'ʒ': { 0x7: 0x2c, 0x2: 0x2c, },
    'x': { 0x7: 0x2d, 0x2: 0x2d, },
    'ǯ': { 0x7: 0x56, 0x2: 0x56, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\'': { 0x2: 0x2b, },
    'µ': { 0x2: 0x32, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
  },
  deadkeys: {
    'à': [0, ['a', ]],
    'À': [0, ['A', ]],
    'è': [0, ['e', ]],
    'È': [0, ['E', ]],
    'ì': [0, ['i', ]],
    'Ì': [0, ['I', ]],
    'ò': [0, ['o', ]],
    'Ò': [0, ['O', ]],
    'ù': [0, ['u', ]],
    'Ù': [0, ['U', ]],
    'ẁ': [0, ['w', ]],
    'Ẁ': [0, ['W', ]],
    'ỳ': [0, ['y', ]],
    'Ỳ': [0, ['Y', ]],
    '`': [0, [' ', ]],
    'â': [1, ['a', ]],
    'Â': [1, ['A', ]],
    'ĉ': [1, ['c', ]],
    'Ĉ': [1, ['C', ]],
    'ê': [1, ['e', ]],
    'Ê': [1, ['E', ]],
    'ĝ': [1, ['g', ]],
    'Ĝ': [1, ['G', ]],
    'ĥ': [1, ['h', ]],
    'Ĥ': [1, ['H', ]],
    'î': [1, ['i', ]],
    'Î': [1, ['I', ]],
    'ĵ': [1, ['j', ]],
    'Ĵ': [1, ['J', ]],
    'ô': [1, ['o', ]],
    'Ô': [1, ['O', ]],
    'ŝ': [1, ['s', ]],
    'Ŝ': [1, ['S', ]],
    'û': [1, ['u', ]],
    'Û': [1, ['U', ]],
    'ŵ': [1, ['w', ]],
    'Ŵ': [1, ['W', ]],
    'ŷ': [1, ['y', ]],
    'Ŷ': [1, ['Y', ]],
    '^': [1, [' ', ]],
    'č': [2, ['c', ]],
    'Č': [2, ['C', ]],
    'ď': [2, ['d', ]],
    'Ď': [2, ['D', ]],
    'ě': [2, ['e', ]],
    'Ě': [2, ['E', ]],
    'ǧ': [2, ['g', ]],
    'Ǧ': [2, ['G', ]],
    'ȟ': [2, ['h', ]],
    'Ȟ': [2, ['H', ]],
    'ǩ': [2, ['k', ]],
    'Ǩ': [2, ['K', ]],
    'ľ': [2, ['l', ]],
    'Ľ': [2, ['L', ]],
    'ň': [2, ['n', ]],
    'Ň': [2, ['N', ]],
    'ř': [2, ['r', ]],
    'Ř': [2, ['R', ]],
    'š': [2, ['s', ]],
    'Š': [2, ['S', ]],
    'ť': [2, ['t', ]],
    'Ť': [2, ['T', ]],
    'ž': [2, ['z', ]],
    'Ž': [2, ['Z', ]],
    'ǯ': [2, ['ʒ', ]],
    'Ǯ': [2, ['Ʒ', ]],
    'ˇ': [2, [' ', ]],
    'á': [3, ['a', ]],
    'Á': [3, ['A', ]],
    'ć': [3, ['c', ]],
    'Ć': [3, ['C', ]],
    'é': [3, ['e', ]],
    'É': [3, ['E', ]],
    'í': [3, ['i', ]],
    'Í': [3, ['I', ]],
    'ĺ': [3, ['l', ]],
    'Ĺ': [3, ['L', ]],
    'ń': [3, ['n', ]],
    'Ń': [3, ['N', ]],
    'ó': [3, ['o', ]],
    'Ó': [3, ['O', ]],
    'ŕ': [3, ['r', ]],
    'Ŕ': [3, ['R', ]],
    'ś': [3, ['s', ]],
    'Ś': [3, ['S', ]],
    'ú': [3, ['u', ]],
    'Ú': [3, ['U', ]],
    'ẃ': [3, ['w', ]],
    'Ẃ': [3, ['W', ]],
    'ý': [3, ['y', ]],
    'Ý': [3, ['Y', ]],
    'ź': [3, ['z', ]],
    'Ź': [3, ['Z', ]],
    'ǻ': [3, ['å', ]],
    'Ǻ': [3, ['Å', ]],
    'ǽ': [3, ['æ', ]],
    'Ǽ': [3, ['Æ', ]],
    'ǿ': [3, ['ø', ]],
    'Ǿ': [3, ['Ø', ]],
    '´': [3, [' ', ]],
    'ä': [4, ['a', ]],
    'Ä': [4, ['A', ]],
    'ë': [4, ['e', ]],
    'Ë': [4, ['E', ]],
    'ï': [4, ['i', ]],
    'Ï': [4, ['I', ]],
    'ö': [4, ['o', ]],
    'Ö': [4, ['O', ]],
    'ü': [4, ['u', ]],
    'Ü': [4, ['U', ]],
    'ẅ': [4, ['w', ]],
    'Ẅ': [4, ['W', ]],
    'ÿ': [4, ['y', ]],
    'Ÿ': [4, ['Y', ]],
    '¨': [4, [' ', ]],
    'ã': [5, ['a', ]],
    'Ã': [5, ['A', ]],
    'ĩ': [5, ['i', ]],
    'Ĩ': [5, ['I', ]],
    'ñ': [5, ['n', ]],
    'Ñ': [5, ['N', ]],
    'õ': [5, ['o', ]],
    'Õ': [5, ['O', ]],
    'ũ': [5, ['u', ]],
    'Ũ': [5, ['U', ]],
    '~': [5, [' ', ]],
  },
  accents: [
    {0x1: 0xd, },
    {0x3: 0x1a, },
    {0x3: 0x1b, },
    {0x2: 0xd, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x0001080c,
  localeName: "fr-BE",
  displayName: "Belgian (Comma)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '&': { 0x0: 0x2, 0x5: 0x2, },
    'é': { 0x0: 0x3, 0x5: 0x3, },
    '"': { 0x0: 0x4, 0x5: 0x4, },
    '\'': { 0x0: 0x5, 0x5: 0x5, },
    '(': { 0x0: 0x6, 0x5: 0x6, },
    '§': { 0x0: 0x7, 0x5: 0x7, },
    'è': { 0x0: 0x8, 0x5: 0x8, },
    '!': { 0x0: 0x9, 0x5: 0x9, },
    'ç': { 0x0: 0xa, 0x5: 0xa, },
    'à': { 0x0: 0xb, 0x5: 0xb, },
    ')': { 0x0: 0xc, 0x5: 0xc, },
    '-': { 0x0: 0xd, 0x1: 0x4a, 0x5: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'a': { 0x0: 0x10, 0x5: 0x10, },
    'z': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '$': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'q': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'm': { 0x0: 0x27, 0x5: 0x27, },
    'ù': { 0x0: 0x28, 0x5: 0x28, },
    '²': { 0x0: 0x29, },
    'µ': { 0x0: 0x2b, 0x5: 0x2b, },
    'w': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    ',': { 0x0: 0x32, 0x5: 0x32, },
    ';': { 0x0: 0x33, 0x5: 0x33, },
    ':': { 0x0: 0x34, 0x5: 0x34, },
    '=': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x35, 0x4: 0x35, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '1': { 0x1: 0x2, 0x4: 0x2, },
    '2': { 0x1: 0x3, 0x4: 0x3, },
    '3': { 0x1: 0x4, 0x4: 0x4, },
    '4': { 0x1: 0x5, 0x4: 0x5, },
    '5': { 0x1: 0x6, 0x4: 0x6, },
    '6': { 0x1: 0x7, 0x4: 0x7, },
    '7': { 0x1: 0x8, 0x4: 0x8, },
    '8': { 0x1: 0x9, 0x4: 0x9, },
    '9': { 0x1: 0xa, 0x4: 0xa, },
    '0': { 0x1: 0xb, 0x4: 0xb, },
    '°': { 0x1: 0xc, 0x4: 0xc, },
    '_': { 0x1: 0xd, 0x4: 0xd, },
    'A': { 0x1: 0x10, 0x4: 0x10, },
    'Z': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Q': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'M': { 0x1: 0x27, 0x4: 0x27, },
    '%': { 0x1: 0x28, 0x4: 0x28, },
    '³': { 0x1: 0x29, },
    '£': { 0x1: 0x2b, 0x4: 0x2b, },
    'W': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    '?': { 0x1: 0x32, 0x4: 0x32, },
    '.': { 0x1: 0x33, 0x4: 0x33, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '|': { 0x2: 0x2, },
    '@': { 0x2: 0x3, },
    '#': { 0x2: 0x4, },
    '{': { 0x2: 0x5, },
    '[': { 0x2: 0x6, },
    '^': { 0x2: 0x7, },
    '}': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
    ']': { 0x2: 0x1b, },
    '\\': { 0x2: 0x56, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    '¨': [1, [' ', ]],
    'á': [2, ['a', ]],
    'é': [2, ['e', ]],
    'í': [2, ['i', ]],
    'ó': [2, ['o', ]],
    'ú': [2, ['u', ]],
    'ý': [2, ['y', ]],
    'Á': [2, ['A', ]],
    'É': [2, ['E', ]],
    'Í': [2, ['I', ]],
    'Ó': [2, ['O', ]],
    'Ú': [2, ['U', ]],
    'Ý': [2, ['Y', ]],
    '´': [2, [' ', ]],
    'à': [3, ['a', ]],
    'è': [3, ['e', ]],
    'ì': [3, ['i', ]],
    'ò': [3, ['o', ]],
    'ù': [3, ['u', ]],
    'À': [3, ['A', ]],
    'È': [3, ['E', ]],
    'Ì': [3, ['I', ]],
    'Ò': [3, ['O', ]],
    'Ù': [3, ['U', ]],
    '`': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, 0x5: 0x1a, },
    {0x1: 0x1a, 0x4: 0x1a, },
    {0x3: 0x28, 0x2: 0x28, },
    {0x3: 0x2b, 0x2: 0x2b, },
    {0x3: 0x35, 0x2: 0x35, },
  ]
},
{
  klid: 0x0001083b,
  localeName: "se-Latn-SE",
  displayName: "Finnish with Sami",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '§': { 0x0: 0x29, },
    '\'': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '½': { 0x1: 0x29, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    'Â': { 0x3: 0x10, 0x6: 0x10, },
    'Ŧ': { 0x3: 0x14, 0x6: 0x14, },
    'Ï': { 0x3: 0x17, 0x6: 0x17, },
    'Õ': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    'Š': { 0x3: 0x1f, 0x6: 0x1f, },
    'Đ': { 0x3: 0x20, 0x6: 0x20, },
    'Ǥ': { 0x3: 0x21, 0x6: 0x21, },
    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },
    'Ȟ': { 0x3: 0x23, 0x6: 0x23, },
    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },
    'Ø': { 0x3: 0x27, 0x6: 0x27, },
    'Æ': { 0x3: 0x28, 0x6: 0x28, },
    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },
    'Č': { 0x3: 0x2e, 0x6: 0x2e, },
    'Ǯ': { 0x3: 0x2f, 0x6: 0x2f, },
    'Ʒ': { 0x3: 0x30, 0x6: 0x30, },
    'Ŋ': { 0x3: 0x31, 0x6: 0x31, },
    'â': { 0x7: 0x10, 0x2: 0x10, },
    'ŧ': { 0x7: 0x14, 0x2: 0x14, },
    'ï': { 0x7: 0x17, 0x2: 0x17, },
    'õ': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    'š': { 0x7: 0x1f, 0x2: 0x1f, },
    'đ': { 0x7: 0x20, 0x2: 0x20, },
    'ǥ': { 0x7: 0x21, 0x2: 0x21, },
    'ǧ': { 0x7: 0x22, 0x2: 0x22, },
    'ȟ': { 0x7: 0x23, 0x2: 0x23, },
    'ǩ': { 0x7: 0x25, 0x2: 0x25, },
    'ø': { 0x7: 0x27, 0x2: 0x27, },
    'æ': { 0x7: 0x28, 0x2: 0x28, },
    'ž': { 0x7: 0x2c, 0x2: 0x2c, },
    'č': { 0x7: 0x2e, 0x2: 0x2e, },
    'ǯ': { 0x7: 0x2f, 0x2: 0x2f, },
    'ʒ': { 0x7: 0x30, 0x2: 0x30, },
    'ŋ': { 0x7: 0x31, 0x2: 0x31, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    'µ': { 0x2: 0x32, },
    '|': { 0x2: 0x56, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ẃ': [0, ['w', ]],
    'Ẃ': [0, ['W', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    'ǻ': [0, ['å', ]],
    'Ǻ': [0, ['Å', ]],
    'ǽ': [0, ['æ', ]],
    'Ǽ': [0, ['Æ', ]],
    'ǿ': [0, ['ø', ]],
    'Ǿ': [0, ['Ø', ]],
    '´': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'Ä': [1, ['A', ]],
    'ë': [1, ['e', ]],
    'Ë': [1, ['E', ]],
    'ï': [1, ['i', ]],
    'Ï': [1, ['I', ]],
    'ö': [1, ['o', ]],
    'Ö': [1, ['O', ]],
    'ü': [1, ['u', ]],
    'Ü': [1, ['U', ]],
    'ẅ': [1, ['w', ]],
    'Ẅ': [1, ['W', ]],
    'ÿ': [1, ['y', ]],
    'Ÿ': [1, ['Y', ]],
    '¨': [1, [' ', ]],
    'à': [2, ['a', ]],
    'À': [2, ['A', ]],
    'è': [2, ['e', ]],
    'È': [2, ['E', ]],
    'ì': [2, ['i', ]],
    'Ì': [2, ['I', ]],
    'ò': [2, ['o', ]],
    'Ò': [2, ['O', ]],
    'ù': [2, ['u', ]],
    'Ù': [2, ['U', ]],
    'ẁ': [2, ['w', ]],
    'Ẁ': [2, ['W', ]],
    'ỳ': [2, ['y', ]],
    'Ỳ': [2, ['Y', ]],
    '`': [2, [' ', ]],
    'â': [3, ['a', ]],
    'Â': [3, ['A', ]],
    'ĉ': [3, ['c', ]],
    'Ĉ': [3, ['C', ]],
    'ê': [3, ['e', ]],
    'Ê': [3, ['E', ]],
    'ĝ': [3, ['g', ]],
    'Ĝ': [3, ['G', ]],
    'ĥ': [3, ['h', ]],
    'Ĥ': [3, ['H', ]],
    'î': [3, ['i', ]],
    'Î': [3, ['I', ]],
    'ĵ': [3, ['j', ]],
    'Ĵ': [3, ['J', ]],
    'ô': [3, ['o', ]],
    'Ô': [3, ['O', ]],
    'ŝ': [3, ['s', ]],
    'Ŝ': [3, ['S', ]],
    'û': [3, ['u', ]],
    'Û': [3, ['U', ]],
    'ŵ': [3, ['w', ]],
    'Ŵ': [3, ['W', ]],
    'ŷ': [3, ['y', ]],
    'Ŷ': [3, ['Y', ]],
    '^': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'Ã': [4, ['A', ]],
    'ĩ': [4, ['i', ]],
    'Ĩ': [4, ['I', ]],
    'ñ': [4, ['n', ]],
    'Ñ': [4, ['N', ]],
    'õ': [4, ['o', ]],
    'Õ': [4, ['O', ]],
    'ũ': [4, ['u', ]],
    'Ũ': [4, ['U', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x0: 0x1b, },
    {0x1: 0xd, },
    {0x1: 0x1b, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x00011009,
  localeName: "en-CA",
  displayName: "Canadian Multilingual Standard",
  ctrlRightIsOem8: true,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'ç': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    'è': { 0x0: 0x28, 0x5: 0x28, },
    '/': { 0x0: 0x29, 0x1: 0x35, },
    'à': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    'é': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, 0x21: 0x39, 0x20: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    'ù': { 0x0: 0x56, 0x5: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '?': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Ç': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    'È': { 0x1: 0x28, 0x4: 0x28, },
    '\\': { 0x1: 0x29, },
    'À': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '\'': { 0x1: 0x33, },
    '"': { 0x1: 0x34, },
    'É': { 0x1: 0x35, 0x4: 0x35, },
    'Ù': { 0x1: 0x56, 0x4: 0x56, },
    '¡': { 0x21: 0x2, },
    '£': { 0x21: 0x4, },
    '€': { 0x21: 0x5, 0x2: 0x12, },
    '⅜': { 0x21: 0x6, },
    '⅝': { 0x21: 0x7, },
    '⅞': { 0x21: 0x8, },
    '™': { 0x21: 0x9, },
    '±': { 0x21: 0xa, },
    '¿': { 0x21: 0xc, },
    'Ω': { 0x21: 0x10, },
    'Ł': { 0x21: 0x11, },
    'Œ': { 0x21: 0x12, },
    '®': { 0x21: 0x13, },
    'Ŧ': { 0x21: 0x14, },
    '¥': { 0x21: 0x15, },
    '↑': { 0x21: 0x16, },
    'ı': { 0x21: 0x17, },
    'Ø': { 0x21: 0x18, },
    'Þ': { 0x21: 0x19, },
    'Æ': { 0x21: 0x1e, },
    '§': { 0x21: 0x1f, },
    'Ð': { 0x21: 0x20, },
    'ª': { 0x21: 0x21, },
    'Ŋ': { 0x21: 0x22, },
    'Ħ': { 0x21: 0x23, },
    'Ĳ': { 0x21: 0x24, },
    'Ŀ': { 0x21: 0x26, },
    '\xad': { 0x21: 0x29, },
    '©': { 0x21: 0x2e, },
    '‘': { 0x21: 0x2f, },
    '’': { 0x21: 0x30, },
    '♪': { 0x21: 0x31, },
    'º': { 0x21: 0x32, },
    '×': { 0x21: 0x33, },
    '÷': { 0x21: 0x34, },
    '¦': { 0x21: 0x56, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '¤': { 0x2: 0x5, },
    '{': { 0x2: 0x8, },
    '}': { 0x2: 0x9, },
    '[': { 0x2: 0xa, },
    ']': { 0x2: 0xb, },
    '¬': { 0x2: 0xd, },
    '°': { 0x2: 0x27, },
    '|': { 0x2: 0x29, },
    '«': { 0x2: 0x2c, },
    '»': { 0x2: 0x2d, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
    '\xa0': { 0x2: 0x39, },
    '¹': { 0x20: 0x2, },
    '²': { 0x20: 0x3, },
    '³': { 0x20: 0x4, },
    '¼': { 0x20: 0x5, },
    '½': { 0x20: 0x6, },
    '¾': { 0x20: 0x7, },
    'ł': { 0x20: 0x11, },
    'œ': { 0x20: 0x12, },
    '¶': { 0x20: 0x13, },
    'ŧ': { 0x20: 0x14, },
    '←': { 0x20: 0x15, },
    '↓': { 0x20: 0x16, },
    '→': { 0x20: 0x17, },
    'ø': { 0x20: 0x18, },
    'þ': { 0x20: 0x19, },
    '~': { 0x20: 0x1b, },
    'æ': { 0x20: 0x1e, },
    'ß': { 0x20: 0x1f, },
    'ð': { 0x20: 0x20, },
    'ŋ': { 0x20: 0x22, },
    'ħ': { 0x20: 0x23, },
    'ĳ': { 0x20: 0x24, },
    'ĸ': { 0x20: 0x25, },
    'ŀ': { 0x20: 0x26, },
    '¢': { 0x20: 0x2e, },
    '“': { 0x20: 0x2f, },
    '”': { 0x20: 0x30, },
    'ŉ': { 0x20: 0x31, },
    'µ': { 0x20: 0x32, },
    '―': { 0x20: 0x33, },
  },
  deadkeys: {
    'â': [0, ['a', ]],
    'ê': [0, ['e', ]],
    'î': [0, ['i', ]],
    'ô': [0, ['o', ]],
    'û': [0, ['u', ]],
    'Â': [0, ['A', ]],
    'Ê': [0, ['E', ]],
    'Î': [0, ['I', ]],
    'Ô': [0, ['O', ]],
    'Û': [0, ['U', ]],
    'Ĉ': [0, ['C', ]],
    'ĉ': [0, ['c', ]],
    'Ĝ': [0, ['G', ]],
    'ĝ': [0, ['g', ]],
    'Ĥ': [0, ['H', ]],
    'ĥ': [0, ['h', ]],
    'Ĵ': [0, ['J', ]],
    'ĵ': [0, ['j', ]],
    'Ŝ': [0, ['S', ]],
    'ŝ': [0, ['s', ]],
    'Ŵ': [0, ['W', ]],
    'ŵ': [0, ['w', ]],
    'Ŷ': [0, ['Y', ]],
    'ŷ': [0, ['y', ]],
    '^': [0, [' ', ]],
    'ä': [1, ['a', ]],
    'ë': [1, ['e', ]],
    'ï': [1, ['i', ]],
    'ö': [1, ['o', ]],
    'ü': [1, ['u', ]],
    'ÿ': [1, ['y', ]],
    'Ä': [1, ['A', ]],
    'Ë': [1, ['E', ]],
    'Ï': [1, ['I', ]],
    'Ö': [1, ['O', ]],
    'Ü': [1, ['U', ]],
    'Ÿ': [1, ['Y', ]],
    '¨': [1, [' ', ]],
    'ą': [2, ['a', ]],
    'ę': [2, ['e', ]],
    'į': [2, ['i', ]],
    'ų': [2, ['u', ]],
    'Ą': [2, ['A', ]],
    'Ę': [2, ['E', ]],
    'Į': [2, ['I', ]],
    'Ų': [2, ['U', ]],
    '˛': [2, [' ', ]],
    'å': [3, ['a', ]],
    'ů': [3, ['u', ]],
    'Å': [3, ['A', ]],
    'Ů': [3, ['U', ]],
    '˚': [3, [' ', ]],
    'ā': [4, ['a', ]],
    'ē': [4, ['e', ]],
    'ī': [4, ['i', ]],
    'ō': [4, ['o', ]],
    'ū': [4, ['u', ]],
    'Ā': [4, ['A', ]],
    'Ē': [4, ['E', ]],
    'Ī': [4, ['I', ]],
    'Ō': [4, ['O', ]],
    'Ū': [4, ['U', ]],
    '¯': [4, [' ', ]],
    'ő': [5, ['o', ]],
    'ű': [5, ['u', ]],
    'Ő': [5, ['O', ]],
    'Ű': [5, ['U', ]],
    '˝': [5, [' ', ]],
    'č': [6, ['c', ]],
    'ď': [6, ['d', ]],
    'ě': [6, ['e', ]],
    'ľ': [6, ['l', ]],
    'ň': [6, ['n', ]],
    'ř': [6, ['r', ]],
    'š': [6, ['s', ]],
    'ť': [6, ['t', ]],
    'ž': [6, ['z', ]],
    'Č': [6, ['C', ]],
    'Ď': [6, ['D', ]],
    'Ě': [6, ['E', ]],
    'Ľ': [6, ['L', ]],
    'Ň': [6, ['N', ]],
    'Ř': [6, ['R', ]],
    'Š': [6, ['S', ]],
    'Ť': [6, ['T', ]],
    'Ž': [6, ['Z', ]],
    'ˇ': [6, [' ', ]],
    'ă': [7, ['a', ]],
    'ğ': [7, ['g', ]],
    'ŭ': [7, ['u', ]],
    'Ă': [7, ['A', ]],
    'Ğ': [7, ['G', ]],
    'Ŭ': [7, ['U', ]],
    '˘': [7, [' ', ]],
    'ċ': [8, ['c', ]],
    'ė': [8, ['e', ]],
    'ġ': [8, ['g', ]],
    'ż': [8, ['z', ]],
    'Ċ': [8, ['C', ]],
    'Ė': [8, ['E', ]],
    'Ġ': [8, ['G', ]],
    'İ': [8, ['I', ]],
    'Ż': [8, ['Z', ]],
    '·': [8, [' ', ]],
    'à': [9, ['a', ]],
    'è': [9, ['e', ]],
    'ì': [9, ['i', ]],
    'ò': [9, ['o', ]],
    'ù': [9, ['u', ]],
    'À': [9, ['A', ]],
    'È': [9, ['E', ]],
    'Ì': [9, ['I', ]],
    'Ò': [9, ['O', ]],
    'Ù': [9, ['U', ]],
    '`': [9, [' ', ]],
    'ã': [10, ['a', ]],
    'ĩ': [10, ['i', ]],
    'ñ': [10, ['n', ]],
    'õ': [10, ['o', ]],
    'ũ': [10, ['u', ]],
    'Ã': [10, ['A', ]],
    'Ĩ': [10, ['I', ]],
    'Ñ': [10, ['N', ]],
    'Õ': [10, ['O', ]],
    'Ũ': [10, ['U', ]],
    '~': [10, [' ', ]],
    'ç': [11, ['c', ]],
    'ģ': [11, ['g', ]],
    'ķ': [11, ['k', ]],
    'ļ': [11, ['l', ]],
    'ņ': [11, ['n', ]],
    'ŗ': [11, ['r', ]],
    'ş': [11, ['s', ]],
    'ţ': [11, ['t', ]],
    'Ç': [11, ['C', ]],
    'Ģ': [11, ['G', ]],
    'Ķ': [11, ['K', ]],
    'Ļ': [11, ['L', ]],
    'Ņ': [11, ['N', ]],
    'Ŗ': [11, ['R', ]],
    'Ş': [11, ['S', ]],
    'Ţ': [11, ['T', ]],
    '¸': [11, [' ', ]],
    'á': [12, ['a', ]],
    'é': [12, ['e', ]],
    'í': [12, ['i', ]],
    'ó': [12, ['o', ]],
    'ú': [12, ['u', ]],
    'ý': [12, ['y', ]],
    'Á': [12, ['A', ]],
    'É': [12, ['E', ]],
    'Í': [12, ['I', ]],
    'Ó': [12, ['O', ]],
    'Ú': [12, ['U', ]],
    'Ý': [12, ['Y', ]],
    'Ć': [12, ['C', ]],
    'ć': [12, ['c', ]],
    'Ĺ': [12, ['L', ]],
    'ĺ': [12, ['l', ]],
    'Ń': [12, ['N', ]],
    'ń': [12, ['n', ]],
    'Ŕ': [12, ['R', ]],
    'ŕ': [12, ['r', ]],
    'Ś': [12, ['S', ]],
    'ś': [12, ['s', ]],
    'Ź': [12, ['Z', ]],
    'ź': [12, ['z', ]],
    '´': [12, [' ', ]],
  },
  accents: [
    {0x0: 0x1a, },
    {0x1: 0x1a, },
    {0x21: 0xd, },
    {0x21: 0x1a, },
    {0x21: 0x1b, },
    {0x21: 0x27, },
    {0x21: 0x28, },
    {0x21: 0x2b, },
    {0x21: 0x35, 0x20: 0x34, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
    {0x20: 0xd, },
    {0x20: 0x27, },
  ]
},
{
  klid: 0x00011809,
  localeName: "en-IE",
  displayName: "Scottish Gaelic",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '#': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\\': { 0x0: 0x56, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '@': { 0x1: 0x28, },
    '`': { 0x1: 0x29, },
    '~': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '|': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    'É': { 0x3: 0x12, 0x6: 0x12, },
    'Ý': { 0x3: 0x15, 0x6: 0x15, },
    'Ú': { 0x3: 0x16, 0x6: 0x16, },
    'Í': { 0x3: 0x17, 0x6: 0x17, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    '’': { 0x3: 0x28, },
    '¬': { 0x3: 0x29, },
    'é': { 0x7: 0x12, 0x2: 0x12, },
    'ý': { 0x7: 0x15, 0x2: 0x15, },
    'ú': { 0x7: 0x16, 0x2: 0x16, },
    'í': { 0x7: 0x17, 0x2: 0x17, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '€': { 0x2: 0x5, },
    '⁊': { 0x2: 0x8, },
    '¦': { 0x2: 0x29, },
  },
  deadkeys: {
    'à': [0, ['a', ]],
    'è': [0, ['e', ]],
    'ì': [0, ['i', ]],
    'ò': [0, ['o', ]],
    'ù': [0, ['u', ]],
    'À': [0, ['A', ]],
    'È': [0, ['E', ]],
    'Ì': [0, ['I', ]],
    'Ò': [0, ['O', ]],
    'Ù': [0, ['U', ]],
    '`': [0, [' ', ]],
    'á': [1, ['a', ]],
    'é': [1, ['e', ]],
    'í': [1, ['i', ]],
    'ó': [1, ['o', ]],
    'ú': [1, ['u', ]],
    'ý': [1, ['y', ]],
    'Á': [1, ['A', ]],
    'É': [1, ['E', ]],
    'Í': [1, ['I', ]],
    'Ó': [1, ['O', ]],
    'Ú': [1, ['U', ]],
    'Ý': [1, ['Y', ]],
    '\'': [1, [' ', ]],
  },
  accents: [
    {0x0: 0x29, },
    {0x2: 0x28, },
  ]
},
{
  klid: 0x00020405,
  localeName: "cs",
  displayName: "Czech Programmers",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, 0x2: 0x35, },
    '=': { 0x0: 0xd, 0x2: 0xc, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, 0x2: 0x29, },
    '\'': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, 0x3: 0x1a, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, 0x2: 0x2, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, 0x3: 0x28, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, 0x3: 0xc, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, 0x3: 0x1b, },
    ')': { 0x1: 0xb, 0x2: 0x1b, },
    '_': { 0x1: 0xc, 0x3: 0x35, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, 0x2: 0x34, },
    '"': { 0x1: 0x28, 0x3: 0x27, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, 0x2: 0x33, },
    '×': { 0x3: 0x33, },
    '÷': { 0x3: 0x34, },
    '\x1e': { 0x0: 0x7, },
    '\x1f': { 0x0: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1d': { 0x0: 0x27, },
    '\x1c': { 0x0: 0x2b, },
    'ě': { 0x2: 0x3, },
    'š': { 0x2: 0x4, },
    'č': { 0x2: 0x5, },
    'ř': { 0x2: 0x6, },
    'ž': { 0x2: 0x7, },
    'ý': { 0x2: 0x8, },
    'á': { 0x2: 0x9, },
    'í': { 0x2: 0xa, },
    'é': { 0x2: 0xb, },
    '€': { 0x2: 0x12, },
    'ú': { 0x2: 0x1a, },
    'ů': { 0x2: 0x27, },
    '§': { 0x2: 0x28, },
    'ß': { 0x2: 0x56, },
  },
  deadkeys: {
    'č': [0, ['c', ]],
    'Č': [0, ['C', ]],
    'ď': [0, ['d', ]],
    'Ď': [0, ['D', ]],
    'ě': [0, ['e', ]],
    'Ě': [0, ['E', ]],
    'ř': [0, ['r', ]],
    'Ř': [0, ['R', ]],
    'ľ': [0, ['l', ]],
    'Ľ': [0, ['L', ]],
    'ň': [0, ['n', ]],
    'Ň': [0, ['N', ]],
    'š': [0, ['s', ]],
    'Š': [0, ['S', ]],
    'ť': [0, ['t', ]],
    'Ť': [0, ['T', ]],
    'ž': [0, ['z', ]],
    'Ž': [0, ['Z', ]],
    'ˇ': [0, [' ', ]],
    'å': [1, ['a', ]],
    'Å': [1, ['A', ]],
    'ů': [1, ['u', ]],
    'Ů': [1, ['U', ]],
    '°': [1, [' ', ]],
    'â': [2, ['a', ]],
    'Â': [2, ['A', ]],
    'ê': [2, ['e', ]],
    'Ê': [2, ['E', ]],
    'î': [2, ['i', ]],
    'Î': [2, ['I', ]],
    'ô': [2, ['o', ]],
    'Ô': [2, ['O', ]],
    'û': [2, ['u', ]],
    'Û': [2, ['U', ]],
    '^': [2, [' ', ]],
    'ő': [3, ['o', ]],
    'Ő': [3, ['O', ]],
    'ű': [3, ['u', ]],
    'Ű': [3, ['U', ]],
    '˝': [3, [' ', ]],
    'á': [4, ['a', ]],
    'Á': [4, ['A', ]],
    'ś': [4, ['s', ]],
    'Ś': [4, ['S', ]],
    'ć': [4, ['c', ]],
    'Ć': [4, ['C', ]],
    'é': [4, ['e', ]],
    'É': [4, ['E', ]],
    'ŕ': [4, ['r', ]],
    'Ŕ': [4, ['R', ]],
    'í': [4, ['i', ]],
    'Í': [4, ['I', ]],
    'ó': [4, ['o', ]],
    'Ó': [4, ['O', ]],
    'ú': [4, ['u', ]],
    'Ú': [4, ['U', ]],
    'ý': [4, ['y', ]],
    'Ý': [4, ['Y', ]],
    'ĺ': [4, ['l', ]],
    'Ĺ': [4, ['L', ]],
    'ń': [4, ['n', ]],
    'Ń': [4, ['N', ]],
    'ź': [4, ['z', ]],
    'Ź': [4, ['Z', ]],
    '´': [4, [' ', ]],
    'ä': [5, ['a', ]],
    'Ä': [5, ['A', ]],
    'ë': [5, ['e', ]],
    'Ë': [5, ['E', ]],
    'ï': [5, ['i', ]],
    'Ï': [5, ['I', ]],
    'ö': [5, ['o', ]],
    'Ö': [5, ['O', ]],
    'ü': [5, ['u', ]],
    'Ü': [5, ['U', ]],
    'ÿ': [5, ['y', ]],
    'Ÿ': [5, ['Y', ]],
    '¨': [5, [' ', ]],
  },
  accents: [
    {0x3: 0xd, },
    {0x3: 0x29, },
    {0x3: 0x2b, },
    {0x3: 0x56, },
    {0x2: 0xd, },
    {0x2: 0x2b, },
  ]
},
{
  klid: 0x00020408,
  localeName: "el",
  displayName: "Greek (319)",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    '·': { 0x0: 0x10, 0x5: 0x10, },
    'ς': { 0x0: 0x11, 0x5: 0x11, },
    'ε': { 0x0: 0x12, 0x5: 0x12, },
    'ρ': { 0x0: 0x13, 0x5: 0x13, },
    'τ': { 0x0: 0x14, 0x5: 0x14, },
    'υ': { 0x0: 0x15, 0x5: 0x15, },
    'θ': { 0x0: 0x16, 0x5: 0x16, },
    'ι': { 0x0: 0x17, 0x5: 0x17, },
    'ο': { 0x0: 0x18, 0x5: 0x18, },
    'π': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'α': { 0x0: 0x1e, 0x5: 0x1e, },
    'σ': { 0x0: 0x1f, 0x5: 0x1f, },
    'δ': { 0x0: 0x20, 0x5: 0x20, },
    'φ': { 0x0: 0x21, 0x5: 0x21, },
    'γ': { 0x0: 0x22, 0x5: 0x22, },
    'η': { 0x0: 0x23, 0x5: 0x23, },
    'ξ': { 0x0: 0x24, 0x5: 0x24, },
    'κ': { 0x0: 0x25, 0x5: 0x25, },
    'λ': { 0x0: 0x26, 0x5: 0x26, },
    '’': { 0x0: 0x28, },
    '½': { 0x0: 0x29, },
    '²': { 0x0: 0x2b, },
    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },
    'χ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },
    'ω': { 0x0: 0x2f, 0x5: 0x2f, },
    'β': { 0x0: 0x30, 0x5: 0x30, },
    'ν': { 0x0: 0x31, 0x5: 0x31, },
    'μ': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '§': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '£': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '¬': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '°': { 0x1: 0xc, },
    '―': { 0x1: 0x10, 0x4: 0x10, },
    '¦': { 0x1: 0x11, 0x4: 0x11, },
    'Ε': { 0x1: 0x12, 0x4: 0x12, },
    'Ρ': { 0x1: 0x13, 0x4: 0x13, },
    'Τ': { 0x1: 0x14, 0x4: 0x14, },
    'Υ': { 0x1: 0x15, 0x4: 0x15, },
    'Θ': { 0x1: 0x16, 0x4: 0x16, },
    'Ι': { 0x1: 0x17, 0x4: 0x17, },
    'Ο': { 0x1: 0x18, 0x4: 0x18, },
    'Π': { 0x1: 0x19, 0x4: 0x19, },
    '«': { 0x1: 0x1a, },
    '»': { 0x1: 0x1b, },
    'Α': { 0x1: 0x1e, 0x4: 0x1e, },
    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },
    'Δ': { 0x1: 0x20, 0x4: 0x20, },
    'Φ': { 0x1: 0x21, 0x4: 0x21, },
    'Γ': { 0x1: 0x22, 0x4: 0x22, },
    'Η': { 0x1: 0x23, 0x4: 0x23, },
    'Ξ': { 0x1: 0x24, 0x4: 0x24, },
    'Κ': { 0x1: 0x25, 0x4: 0x25, },
    'Λ': { 0x1: 0x26, 0x4: 0x26, },
    '‘': { 0x1: 0x28, },
    '±': { 0x1: 0x29, },
    '³': { 0x1: 0x2b, },
    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },
    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },
    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },
    'Β': { 0x1: 0x30, 0x4: 0x30, },
    'Ν': { 0x1: 0x31, 0x4: 0x31, },
    'Μ': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '©': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '€': { 0x2: 0x12, },
  },
  deadkeys: {
    'ά': [0, ['α', ]],
    'έ': [0, ['ε', ]],
    'ί': [0, ['ι', ]],
    'ό': [0, ['ο', ]],
    'ύ': [0, ['υ', ]],
    'ώ': [0, ['ω', ]],
    'ή': [0, ['η', ]],
    'Ά': [0, ['Α', ]],
    'Έ': [0, ['Ε', ]],
    'Ί': [0, ['Ι', ]],
    'Ό': [0, ['Ο', ]],
    'Ύ': [0, ['Υ', ]],
    'Ώ': [0, ['Ω', ]],
    'Ή': [0, ['Η', ]],
    '΄': [0, [' ', ]],
    'ϊ': [1, ['ι', ]],
    'ϋ': [1, ['υ', ]],
    'Ϊ': [1, ['Ι', ]],
    'Ϋ': [1, ['Υ', ]],
    '¨': [1, [' ', ]],
    'ΐ': [2, ['ι', ]],
    'ΰ': [2, ['υ', ]],
    '΅': [2, [' ', ]],
  },
  accents: [
    {0x0: 0x27, },
    {0x1: 0x27, },
    {0x2: 0x27, },
  ]
},
{
  klid: 0x00020409,
  localeName: "en-US",
  displayName: "United States-International",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '¹': { 0x3: 0x2, },
    '£': { 0x3: 0x5, },
    '÷': { 0x3: 0xd, },
    'Ä': { 0x3: 0x10, 0x6: 0x10, },
    'Å': { 0x3: 0x11, 0x6: 0x11, },
    'É': { 0x3: 0x12, 0x6: 0x12, },
    'Þ': { 0x3: 0x14, 0x6: 0x14, },
    'Ü': { 0x3: 0x15, 0x6: 0x15, },
    'Ú': { 0x3: 0x16, 0x6: 0x16, },
    'Í': { 0x3: 0x17, 0x6: 0x17, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Ö': { 0x3: 0x19, 0x6: 0x19, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    '§': { 0x3: 0x1f, },
    'Ð': { 0x3: 0x20, 0x6: 0x20, },
    'Ø': { 0x3: 0x26, 0x6: 0x26, },
    '°': { 0x3: 0x27, },
    '¨': { 0x3: 0x28, },
    '¦': { 0x3: 0x2b, },
    'Æ': { 0x3: 0x2c, 0x6: 0x2c, },
    '¢': { 0x3: 0x2e, },
    'Ñ': { 0x3: 0x31, 0x6: 0x31, },
    'Ç': { 0x3: 0x33, 0x6: 0x33, },
    'ä': { 0x7: 0x10, 0x2: 0x10, },
    'å': { 0x7: 0x11, 0x2: 0x11, },
    'é': { 0x7: 0x12, 0x2: 0x12, },
    'þ': { 0x7: 0x14, 0x2: 0x14, },
    'ü': { 0x7: 0x15, 0x2: 0x15, },
    'ú': { 0x7: 0x16, 0x2: 0x16, },
    'í': { 0x7: 0x17, 0x2: 0x17, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'ö': { 0x7: 0x19, 0x2: 0x19, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    'ð': { 0x7: 0x20, 0x2: 0x20, },
    'ø': { 0x7: 0x26, 0x2: 0x26, },
    'æ': { 0x7: 0x2c, 0x2: 0x2c, },
    'ñ': { 0x7: 0x31, 0x2: 0x31, },
    'ç': { 0x7: 0x33, 0x2: 0x33, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '¡': { 0x2: 0x2, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '¤': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '¼': { 0x2: 0x7, },
    '½': { 0x2: 0x8, },
    '¾': { 0x2: 0x9, },
    '‘': { 0x2: 0xa, },
    '’': { 0x2: 0xb, },
    '¥': { 0x2: 0xc, },
    '×': { 0x2: 0xd, },
    '®': { 0x2: 0x13, },
    '«': { 0x2: 0x1a, },
    '»': { 0x2: 0x1b, },
    'ß': { 0x2: 0x1f, },
    '¶': { 0x2: 0x27, },
    '´': { 0x2: 0x28, },
    '¬': { 0x2: 0x2b, },
    '©': { 0x2: 0x2e, },
    'µ': { 0x2: 0x32, },
    '¿': { 0x2: 0x35, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '\'': [0, [' ', ]],
    'ç': [0, ['c', ]],
    'Ç': [0, ['C', ]],
    'à': [1, ['a', ]],
    'è': [1, ['e', ]],
    'ì': [1, ['i', ]],
    'ò': [1, ['o', ]],
    'ù': [1, ['u', ]],
    'À': [1, ['A', ]],
    'È': [1, ['E', ]],
    'Ì': [1, ['I', ]],
    'Ò': [1, ['O', ]],
    'Ù': [1, ['U', ]],
    '`': [1, [' ', ]],
    'â': [2, ['a', ]],
    'ê': [2, ['e', ]],
    'î': [2, ['i', ]],
    'ô': [2, ['o', ]],
    'û': [2, ['u', ]],
    'Â': [2, ['A', ]],
    'Ê': [2, ['E', ]],
    'Î': [2, ['I', ]],
    'Ô': [2, ['O', ]],
    'Û': [2, ['U', ]],
    '^': [2, [' ', ]],
    'ä': [3, ['a', ]],
    'ë': [3, ['e', ]],
    'ï': [3, ['i', ]],
    'ö': [3, ['o', ]],
    'ü': [3, ['u', ]],
    'ÿ': [3, ['y', ]],
    'Ä': [3, ['A', ]],
    'Ë': [3, ['E', ]],
    'Ï': [3, ['I', ]],
    'Ö': [3, ['O', ]],
    'Ü': [3, ['U', ]],
    '"': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x28, },
    {0x0: 0x29, },
    {0x1: 0x7, },
    {0x1: 0x28, },
    {0x1: 0x29, },
  ]
},
{
  klid: 0x0002083b,
  localeName: "se-Latn-SE",
  displayName: "Sami Extended Finland-Sweden",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '+': { 0x0: 0xc, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'á': { 0x0: 0x10, 0x5: 0x10, },
    'š': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'ŧ': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    'å': { 0x0: 0x1a, 0x5: 0x1a, },
    'ŋ': { 0x0: 0x1b, 0x5: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    'ö': { 0x0: 0x27, 0x5: 0x27, },
    'ä': { 0x0: 0x28, 0x5: 0x28, },
    '§': { 0x0: 0x29, },
    'đ': { 0x0: 0x2b, 0x5: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'č': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x37, 0x3: 0x2b, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    'ž': { 0x0: 0x56, 0x5: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '¤': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Á': { 0x1: 0x10, 0x4: 0x10, },
    'Š': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Ŧ': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    'Å': { 0x1: 0x1a, 0x4: 0x1a, },
    'Ŋ': { 0x1: 0x1b, 0x4: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    'Ö': { 0x1: 0x27, 0x4: 0x27, },
    'Ä': { 0x1: 0x28, 0x4: 0x28, },
    '½': { 0x1: 0x29, },
    'Đ': { 0x1: 0x2b, 0x4: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'Č': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    'Ž': { 0x1: 0x56, 0x4: 0x56, },
    'Q': { 0x3: 0x10, 0x6: 0x10, },
    'W': { 0x3: 0x11, 0x6: 0x11, },
    'Y': { 0x3: 0x15, 0x6: 0x15, },
    'Ï': { 0x3: 0x17, 0x6: 0x17, },
    'Õ': { 0x3: 0x18, 0x6: 0x18, },
    'Â': { 0x3: 0x1e, 0x6: 0x1e, },
    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },
    'Ǥ': { 0x3: 0x23, 0x6: 0x23, },
    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },
    'Ø': { 0x3: 0x27, 0x6: 0x27, },
    'Æ': { 0x3: 0x28, 0x6: 0x28, },
    'Ʒ': { 0x3: 0x2c, 0x6: 0x2c, },
    'X': { 0x3: 0x2d, 0x6: 0x2d, },
    'Ǯ': { 0x3: 0x56, 0x6: 0x56, },
    'q': { 0x7: 0x10, 0x2: 0x10, },
    'w': { 0x7: 0x11, 0x2: 0x11, },
    'y': { 0x7: 0x15, 0x2: 0x15, },
    'ï': { 0x7: 0x17, 0x2: 0x17, },
    'õ': { 0x7: 0x18, 0x2: 0x18, },
    'â': { 0x7: 0x1e, 0x2: 0x1e, },
    'ǧ': { 0x7: 0x22, 0x2: 0x22, },
    'ǥ': { 0x7: 0x23, 0x2: 0x23, },
    'ǩ': { 0x7: 0x25, 0x2: 0x25, },
    'ø': { 0x7: 0x27, 0x2: 0x27, },
    'æ': { 0x7: 0x28, 0x2: 0x28, },
    'ʒ': { 0x7: 0x2c, 0x2: 0x2c, },
    'x': { 0x7: 0x2d, 0x2: 0x2d, },
    'ǯ': { 0x7: 0x56, 0x2: 0x56, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '@': { 0x2: 0x3, },
    '£': { 0x2: 0x4, },
    '$': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '{': { 0x2: 0x8, },
    '[': { 0x2: 0x9, },
    ']': { 0x2: 0xa, },
    '}': { 0x2: 0xb, },
    '\\': { 0x2: 0xc, },
    '|': { 0x2: 0x29, },
    '\'': { 0x2: 0x2b, },
    'µ': { 0x2: 0x32, },
    '<': { 0x2: 0x33, },
    '>': { 0x2: 0x34, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'Á': [0, ['A', ]],
    'ć': [0, ['c', ]],
    'Ć': [0, ['C', ]],
    'é': [0, ['e', ]],
    'É': [0, ['E', ]],
    'í': [0, ['i', ]],
    'Í': [0, ['I', ]],
    'ĺ': [0, ['l', ]],
    'Ĺ': [0, ['L', ]],
    'ń': [0, ['n', ]],
    'Ń': [0, ['N', ]],
    'ó': [0, ['o', ]],
    'Ó': [0, ['O', ]],
    'ŕ': [0, ['r', ]],
    'Ŕ': [0, ['R', ]],
    'ś': [0, ['s', ]],
    'Ś': [0, ['S', ]],
    'ú': [0, ['u', ]],
    'Ú': [0, ['U', ]],
    'ẃ': [0, ['w', ]],
    'Ẃ': [0, ['W', ]],
    'ý': [0, ['y', ]],
    'Ý': [0, ['Y', ]],
    'ź': [0, ['z', ]],
    'Ź': [0, ['Z', ]],
    'ǻ': [0, ['å', ]],
    'Ǻ': [0, ['Å', ]],
    'ǽ': [0, ['æ', ]],
    'Ǽ': [0, ['Æ', ]],
    'ǿ': [0, ['ø', ]],
    'Ǿ': [0, ['Ø', ]],
    '´': [0, [' ', ]],
    'à': [1, ['a', ]],
    'À': [1, ['A', ]],
    'è': [1, ['e', ]],
    'È': [1, ['E', ]],
    'ì': [1, ['i', ]],
    'Ì': [1, ['I', ]],
    'ò': [1, ['o', ]],
    'Ò': [1, ['O', ]],
    'ù': [1, ['u', ]],
    'Ù': [1, ['U', ]],
    'ẁ': [1, ['w', ]],
    'Ẁ': [1, ['W', ]],
    'ỳ': [1, ['y', ]],
    'Ỳ': [1, ['Y', ]],
    '`': [1, [' ', ]],
    'â': [2, ['a', ]],
    'Â': [2, ['A', ]],
    'ĉ': [2, ['c', ]],
    'Ĉ': [2, ['C', ]],
    'ê': [2, ['e', ]],
    'Ê': [2, ['E', ]],
    'ĝ': [2, ['g', ]],
    'Ĝ': [2, ['G', ]],
    'ĥ': [2, ['h', ]],
    'Ĥ': [2, ['H', ]],
    'î': [2, ['i', ]],
    'Î': [2, ['I', ]],
    'ĵ': [2, ['j', ]],
    'Ĵ': [2, ['J', ]],
    'ô': [2, ['o', ]],
    'Ô': [2, ['O', ]],
    'ŝ': [2, ['s', ]],
    'Ŝ': [2, ['S', ]],
    'û': [2, ['u', ]],
    'Û': [2, ['U', ]],
    'ŵ': [2, ['w', ]],
    'Ŵ': [2, ['W', ]],
    'ŷ': [2, ['y', ]],
    'Ŷ': [2, ['Y', ]],
    '^': [2, [' ', ]],
    'č': [3, ['c', ]],
    'Č': [3, ['C', ]],
    'ď': [3, ['d', ]],
    'Ď': [3, ['D', ]],
    'ě': [3, ['e', ]],
    'Ě': [3, ['E', ]],
    'ǧ': [3, ['g', ]],
    'Ǧ': [3, ['G', ]],
    'ȟ': [3, ['h', ]],
    'Ȟ': [3, ['H', ]],
    'ǩ': [3, ['k', ]],
    'Ǩ': [3, ['K', ]],
    'ľ': [3, ['l', ]],
    'Ľ': [3, ['L', ]],
    'ň': [3, ['n', ]],
    'Ň': [3, ['N', ]],
    'ř': [3, ['r', ]],
    'Ř': [3, ['R', ]],
    'š': [3, ['s', ]],
    'Š': [3, ['S', ]],
    'ť': [3, ['t', ]],
    'Ť': [3, ['T', ]],
    'ž': [3, ['z', ]],
    'Ž': [3, ['Z', ]],
    'ǯ': [3, ['ʒ', ]],
    'Ǯ': [3, ['Ʒ', ]],
    'ˇ': [3, [' ', ]],
    'ä': [4, ['a', ]],
    'Ä': [4, ['A', ]],
    'ë': [4, ['e', ]],
    'Ë': [4, ['E', ]],
    'ï': [4, ['i', ]],
    'Ï': [4, ['I', ]],
    'ö': [4, ['o', ]],
    'Ö': [4, ['O', ]],
    'ü': [4, ['u', ]],
    'Ü': [4, ['U', ]],
    'ẅ': [4, ['w', ]],
    'Ẅ': [4, ['W', ]],
    'ÿ': [4, ['y', ]],
    'Ÿ': [4, ['Y', ]],
    '¨': [4, [' ', ]],
    'ã': [5, ['a', ]],
    'Ã': [5, ['A', ]],
    'ĩ': [5, ['i', ]],
    'Ĩ': [5, ['I', ]],
    'ñ': [5, ['n', ]],
    'Ñ': [5, ['N', ]],
    'õ': [5, ['o', ]],
    'Õ': [5, ['O', ]],
    'ũ': [5, ['u', ]],
    'Ũ': [5, ['U', ]],
    '~': [5, [' ', ]],
  },
  accents: [
    {0x0: 0xd, },
    {0x1: 0xd, },
    {0x3: 0x1a, },
    {0x3: 0x1b, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
  ]
},
{
  klid: 0x00030402,
  localeName: "bg",
  displayName: "Bulgarian",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '.': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    ',': { 0x0: 0x10, 0x4: 0x10, },
    'у': { 0x0: 0x11, 0x5: 0x11, },
    'е': { 0x0: 0x12, 0x5: 0x12, },
    'и': { 0x0: 0x13, 0x5: 0x13, },
    'ш': { 0x0: 0x14, 0x5: 0x14, },
    'щ': { 0x0: 0x15, 0x5: 0x15, },
    'к': { 0x0: 0x16, 0x5: 0x16, },
    'с': { 0x0: 0x17, 0x5: 0x17, },
    'д': { 0x0: 0x18, 0x5: 0x18, },
    'з': { 0x0: 0x19, 0x5: 0x19, },
    'ц': { 0x0: 0x1a, 0x5: 0x1a, },
    ';': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'ь': { 0x0: 0x1e, },
    'я': { 0x0: 0x1f, 0x5: 0x1f, },
    'а': { 0x0: 0x20, 0x5: 0x20, },
    'о': { 0x0: 0x21, 0x5: 0x21, },
    'ж': { 0x0: 0x22, 0x5: 0x22, },
    'г': { 0x0: 0x23, 0x5: 0x23, },
    'т': { 0x0: 0x24, 0x5: 0x24, },
    'н': { 0x0: 0x25, 0x5: 0x25, },
    'в': { 0x0: 0x26, 0x5: 0x26, },
    'м': { 0x0: 0x27, 0x5: 0x27, },
    'ч': { 0x0: 0x28, 0x5: 0x28, },
    '(': { 0x0: 0x29, },
    '„': { 0x0: 0x2b, },
    'ю': { 0x0: 0x2c, 0x5: 0x2c, },
    'й': { 0x0: 0x2d, 0x5: 0x2d, },
    'ъ': { 0x0: 0x2e, 0x5: 0x2e, },
    'э': { 0x0: 0x2f, 0x5: 0x2f, },
    'ф': { 0x0: 0x30, 0x5: 0x30, },
    'х': { 0x0: 0x31, 0x5: 0x31, },
    'п': { 0x0: 0x32, 0x5: 0x32, },
    'р': { 0x0: 0x33, 0x5: 0x33, },
    'л': { 0x0: 0x34, 0x5: 0x34, },
    'б': { 0x0: 0x35, 0x5: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x37, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x4, },
    'ѝ': { 0x0: 0x56, 0x1: 0x1e, 0x5: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x9, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '?': { 0x1: 0x3, },
    '"': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '=': { 0x1: 0x7, },
    ':': { 0x1: 0x8, },
    '–': { 0x1: 0xa, },
    '№': { 0x1: 0xb, },
    '$': { 0x1: 0xc, },
    '€': { 0x1: 0xd, },
    'ы': { 0x1: 0x10, },
    'У': { 0x1: 0x11, 0x4: 0x11, },
    'Е': { 0x1: 0x12, 0x4: 0x12, },
    'И': { 0x1: 0x13, 0x4: 0x13, },
    'Ш': { 0x1: 0x14, 0x4: 0x14, },
    'Щ': { 0x1: 0x15, 0x4: 0x15, },
    'К': { 0x1: 0x16, 0x4: 0x16, },
    'С': { 0x1: 0x17, 0x4: 0x17, },
    'Д': { 0x1: 0x18, 0x4: 0x18, },
    'З': { 0x1: 0x19, 0x4: 0x19, },
    'Ц': { 0x1: 0x1a, 0x4: 0x1a, },
    '§': { 0x1: 0x1b, },
    'Я': { 0x1: 0x1f, 0x4: 0x1f, },
    'А': { 0x1: 0x20, 0x4: 0x20, },
    'О': { 0x1: 0x21, 0x4: 0x21, },
    'Ж': { 0x1: 0x22, 0x4: 0x22, },
    'Г': { 0x1: 0x23, 0x4: 0x23, },
    'Т': { 0x1: 0x24, 0x4: 0x24, },
    'Н': { 0x1: 0x25, 0x4: 0x25, },
    'В': { 0x1: 0x26, 0x4: 0x26, },
    'М': { 0x1: 0x27, 0x4: 0x27, },
    'Ч': { 0x1: 0x28, 0x4: 0x28, },
    ')': { 0x1: 0x29, },
    '“': { 0x1: 0x2b, },
    'Ю': { 0x1: 0x2c, 0x4: 0x2c, },
    'Й': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ъ': { 0x1: 0x2e, 0x4: 0x2e, },
    'Э': { 0x1: 0x2f, 0x4: 0x2f, },
    'Ф': { 0x1: 0x30, 0x4: 0x30, },
    'Х': { 0x1: 0x31, 0x4: 0x31, },
    'П': { 0x1: 0x32, 0x4: 0x32, },
    'Р': { 0x1: 0x33, 0x4: 0x33, },
    'Л': { 0x1: 0x34, 0x4: 0x34, },
    'Б': { 0x1: 0x35, 0x4: 0x35, },
    'Ѝ': { 0x1: 0x56, 0x5: 0x1e, 0x4: 0x56, },
    'Ы': { 0x5: 0x10, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    'Ь': { 0x4: 0x1e, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00030408,
  localeName: "el",
  displayName: "Greek (220) Latin",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    ']': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '+': { 0x0: 0x1a, 0x1: 0x4e, },
    '}': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    '\\': { 0x0: 0x29, },
    '#': { 0x0: 0x2b, 0x1: 0x4, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0x1a, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    '[': { 0x1: 0xd, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '|': { 0x1: 0x29, },
    '@': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0x35, },
    '\x1d': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x29, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '£': { 0x2: 0x5, },
    '§': { 0x2: 0x6, },
    '¶': { 0x2: 0x7, },
    '¤': { 0x2: 0x9, },
    '¦': { 0x2: 0xa, },
    '°': { 0x2: 0xb, },
    '±': { 0x2: 0xc, },
    '½': { 0x2: 0xd, },
    '€': { 0x2: 0x12, },
    '«': { 0x2: 0x1a, },
    '»': { 0x2: 0x1b, },
    '¬': { 0x2: 0x2b, },
  },
  deadkeys: {
    'ά': [0, ['α', ]],
    'έ': [0, ['ε', ]],
    'ί': [0, ['ι', ]],
    'ό': [0, ['ο', ]],
    'ύ': [0, ['υ', ]],
    'ώ': [0, ['ω', ]],
    'ή': [0, ['η', ]],
    'Ά': [0, ['Α', ]],
    'Έ': [0, ['Ε', ]],
    'Ί': [0, ['Ι', ]],
    'Ό': [0, ['Ο', ]],
    'Ύ': [0, ['Υ', ]],
    'Ώ': [0, ['Ω', ]],
    'Ή': [0, ['Η', ]],
    '΄': [0, [' ', ]],
    'ϊ': [1, ['ι', ]],
    'ϋ': [1, ['υ', ]],
    'Ϊ': [1, ['Ι', ]],
    'Ϋ': [1, ['Υ', ]],
    '¨': [1, [' ', ]],
    'ΐ': [2, ['ι', ]],
    'ΰ': [2, ['υ', ]],
    '΅': [2, [' ', ]],
  },
  accents: [
    {0x0: 0x27, },
    {0x0: 0x28, 0x1: 0x27, },
    {0x1: 0x28, 0x2: 0x27, },
  ]
},
{
  klid: 0x00030409,
  localeName: "en-US",
  displayName: "United States-Dvorak for left hand",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '[': { 0x0: 0x2, },
    ']': { 0x0: 0x3, },
    '/': { 0x0: 0x4, 0x1: 0x35, },
    'p': { 0x0: 0x5, 0x5: 0x5, },
    'f': { 0x0: 0x6, 0x5: 0x6, },
    'm': { 0x0: 0x7, 0x5: 0x7, },
    'l': { 0x0: 0x8, 0x5: 0x8, },
    'j': { 0x0: 0x9, 0x5: 0x9, },
    '4': { 0x0: 0xa, },
    '3': { 0x0: 0xb, },
    '2': { 0x0: 0xc, },
    '1': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    ';': { 0x0: 0x10, },
    'q': { 0x0: 0x11, 0x5: 0x11, },
    'b': { 0x0: 0x12, 0x5: 0x12, },
    'y': { 0x0: 0x13, 0x5: 0x13, },
    'u': { 0x0: 0x14, 0x5: 0x14, },
    'r': { 0x0: 0x15, 0x5: 0x15, },
    's': { 0x0: 0x16, 0x5: 0x16, },
    'o': { 0x0: 0x17, 0x5: 0x17, },
    '.': { 0x0: 0x18, },
    '6': { 0x0: 0x19, },
    '5': { 0x0: 0x1a, },
    '=': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    '-': { 0x0: 0x1e, 0x1: 0x4a, },
    'k': { 0x0: 0x1f, 0x5: 0x1f, },
    'c': { 0x0: 0x20, 0x5: 0x20, },
    'd': { 0x0: 0x21, 0x5: 0x21, },
    't': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'e': { 0x0: 0x24, 0x5: 0x24, },
    'a': { 0x0: 0x25, 0x5: 0x25, },
    'z': { 0x0: 0x26, 0x5: 0x26, },
    '8': { 0x0: 0x27, },
    '7': { 0x0: 0x28, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    '\'': { 0x0: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'g': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'w': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'i': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '0': { 0x0: 0x34, },
    '9': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x27, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x1b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '{': { 0x1: 0x2, },
    '}': { 0x1: 0x3, },
    '?': { 0x1: 0x4, },
    'P': { 0x1: 0x5, 0x4: 0x5, },
    'F': { 0x1: 0x6, 0x4: 0x6, },
    'M': { 0x1: 0x7, 0x4: 0x7, },
    'L': { 0x1: 0x8, 0x4: 0x8, },
    'J': { 0x1: 0x9, 0x4: 0x9, },
    '$': { 0x1: 0xa, },
    '#': { 0x1: 0xb, },
    '@': { 0x1: 0xc, },
    '!': { 0x1: 0xd, },
    ':': { 0x1: 0x10, },
    'Q': { 0x1: 0x11, 0x4: 0x11, },
    'B': { 0x1: 0x12, 0x4: 0x12, },
    'Y': { 0x1: 0x13, 0x4: 0x13, },
    'U': { 0x1: 0x14, 0x4: 0x14, },
    'R': { 0x1: 0x15, 0x4: 0x15, },
    'S': { 0x1: 0x16, 0x4: 0x16, },
    'O': { 0x1: 0x17, 0x4: 0x17, },
    '>': { 0x1: 0x18, },
    '^': { 0x1: 0x19, },
    '%': { 0x1: 0x1a, },
    '_': { 0x1: 0x1e, },
    'K': { 0x1: 0x1f, 0x4: 0x1f, },
    'C': { 0x1: 0x20, 0x4: 0x20, },
    'D': { 0x1: 0x21, 0x4: 0x21, },
    'T': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'E': { 0x1: 0x24, 0x4: 0x24, },
    'A': { 0x1: 0x25, 0x4: 0x25, },
    'Z': { 0x1: 0x26, 0x4: 0x26, },
    '&': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    '"': { 0x1: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'G': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'W': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'I': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    ')': { 0x1: 0x34, },
    '(': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x19, },
    '\x1f': { 0x1: 0x1e, },
    '\x1d': { 0x0: 0x3, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00040408,
  localeName: "el",
  displayName: "Greek (319) Latin",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\'': { 0x0: 0xc, },
    '+': { 0x0: 0xd, 0x1: 0x4e, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    '\\': { 0x0: 0x29, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '-': { 0x0: 0x35, 0x1: 0x4a, },
    '*': { 0x0: 0x37, 0x1: 0xd, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '<': { 0x0: 0x56, },
    '/': { 0x0: 0x35, 0x1: 0x8, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '"': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x7, },
    '(': { 0x1: 0x9, },
    ')': { 0x1: 0xa, },
    '=': { 0x1: 0xb, },
    '?': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    '|': { 0x1: 0x29, },
    '@': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    ';': { 0x1: 0x33, },
    ':': { 0x1: 0x34, },
    '_': { 0x1: 0x35, },
    '>': { 0x1: 0x56, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '€': { 0x2: 0x12, },
  },
  deadkeys: {
    'á': [0, ['a', ]],
    'é': [0, ['e', ]],
    'í': [0, ['i', ]],
    'ó': [0, ['o', ]],
    'ú': [0, ['u', ]],
    'ý': [0, ['y', ]],
    'Á': [0, ['A', ]],
    'É': [0, ['E', ]],
    'Í': [0, ['I', ]],
    'Ó': [0, ['O', ]],
    'Ú': [0, ['U', ]],
    'Ý': [0, ['Y', ]],
    '´': [0, [' ', ]],
    'â': [1, ['a', ]],
    'ê': [1, ['e', ]],
    'î': [1, ['i', ]],
    'ô': [1, ['o', ]],
    'û': [1, ['u', ]],
    'Â': [1, ['A', ]],
    'Ê': [1, ['E', ]],
    'Î': [1, ['I', ]],
    'Ô': [1, ['O', ]],
    'Û': [1, ['U', ]],
    '^': [1, [' ', ]],
    'à': [2, ['a', ]],
    'è': [2, ['e', ]],
    'ì': [2, ['i', ]],
    'ò': [2, ['o', ]],
    'ù': [2, ['u', ]],
    'À': [2, ['A', ]],
    'È': [2, ['E', ]],
    'Ì': [2, ['I', ]],
    'Ò': [2, ['O', ]],
    'Ù': [2, ['U', ]],
    '`': [2, [' ', ]],
    'ä': [3, ['a', ]],
    'ë': [3, ['e', ]],
    'ï': [3, ['i', ]],
    'ö': [3, ['o', ]],
    'ü': [3, ['u', ]],
    'ÿ': [3, ['y', ]],
    'Ä': [3, ['A', ]],
    'Ë': [3, ['E', ]],
    'Ï': [3, ['I', ]],
    'Ö': [3, ['O', ]],
    'Ü': [3, ['U', ]],
    '¨': [3, [' ', ]],
    'ã': [4, ['a', ]],
    'õ': [4, ['o', ]],
    'ñ': [4, ['n', ]],
    'Ã': [4, ['A', ]],
    'Õ': [4, ['O', ]],
    'Ñ': [4, ['N', ]],
    '~': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x27, },
    {0x0: 0x28, },
    {0x0: 0x2b, },
    {0x1: 0x27, },
    {0x1: 0x28, },
  ]
},
{
  klid: 0x00040409,
  localeName: "en-US",
  displayName: "United States-Dvorak for right hand",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    'j': { 0x0: 0x6, 0x5: 0x6, },
    'l': { 0x0: 0x7, 0x5: 0x7, },
    'm': { 0x0: 0x8, 0x5: 0x8, },
    'f': { 0x0: 0x9, 0x5: 0x9, },
    'p': { 0x0: 0xa, 0x5: 0xa, },
    '/': { 0x0: 0xb, 0x1: 0x35, },
    '[': { 0x0: 0xc, },
    ']': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    '5': { 0x0: 0x10, },
    '6': { 0x0: 0x11, },
    'q': { 0x0: 0x12, 0x5: 0x12, },
    '.': { 0x0: 0x13, },
    'o': { 0x0: 0x14, 0x5: 0x14, },
    'r': { 0x0: 0x15, 0x5: 0x15, },
    's': { 0x0: 0x16, 0x5: 0x16, },
    'u': { 0x0: 0x17, 0x5: 0x17, },
    'y': { 0x0: 0x18, 0x5: 0x18, },
    'b': { 0x0: 0x19, 0x5: 0x19, },
    ';': { 0x0: 0x1a, },
    '=': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    '7': { 0x0: 0x1e, },
    '8': { 0x0: 0x1f, },
    'z': { 0x0: 0x20, 0x5: 0x20, },
    'a': { 0x0: 0x21, 0x5: 0x21, },
    'e': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    't': { 0x0: 0x24, 0x5: 0x24, },
    'd': { 0x0: 0x25, 0x5: 0x25, },
    'c': { 0x0: 0x26, 0x5: 0x26, },
    'k': { 0x0: 0x27, 0x5: 0x27, },
    '-': { 0x0: 0x28, 0x1: 0x4a, },
    '`': { 0x0: 0x29, },
    '\\': { 0x0: 0x2b, },
    '9': { 0x0: 0x2c, },
    '0': { 0x0: 0x2d, },
    'x': { 0x0: 0x2e, 0x5: 0x2e, },
    ',': { 0x0: 0x2f, },
    'i': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'w': { 0x0: 0x32, 0x5: 0x32, },
    'v': { 0x0: 0x33, 0x5: 0x33, },
    'g': { 0x0: 0x34, 0x5: 0x34, },
    '\'': { 0x0: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x1f, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0x1b, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    'J': { 0x1: 0x6, 0x4: 0x6, },
    'L': { 0x1: 0x7, 0x4: 0x7, },
    'M': { 0x1: 0x8, 0x4: 0x8, },
    'F': { 0x1: 0x9, 0x4: 0x9, },
    'P': { 0x1: 0xa, 0x4: 0xa, },
    '?': { 0x1: 0xb, },
    '{': { 0x1: 0xc, },
    '}': { 0x1: 0xd, },
    '%': { 0x1: 0x10, },
    '^': { 0x1: 0x11, },
    'Q': { 0x1: 0x12, 0x4: 0x12, },
    '>': { 0x1: 0x13, },
    'O': { 0x1: 0x14, 0x4: 0x14, },
    'R': { 0x1: 0x15, 0x4: 0x15, },
    'S': { 0x1: 0x16, 0x4: 0x16, },
    'U': { 0x1: 0x17, 0x4: 0x17, },
    'Y': { 0x1: 0x18, 0x4: 0x18, },
    'B': { 0x1: 0x19, 0x4: 0x19, },
    ':': { 0x1: 0x1a, },
    '&': { 0x1: 0x1e, },
    'Z': { 0x1: 0x20, 0x4: 0x20, },
    'A': { 0x1: 0x21, 0x4: 0x21, },
    'E': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'T': { 0x1: 0x24, 0x4: 0x24, },
    'D': { 0x1: 0x25, 0x4: 0x25, },
    'C': { 0x1: 0x26, 0x4: 0x26, },
    'K': { 0x1: 0x27, 0x4: 0x27, },
    '_': { 0x1: 0x28, },
    '~': { 0x1: 0x29, },
    '|': { 0x1: 0x2b, },
    '(': { 0x1: 0x2c, },
    ')': { 0x1: 0x2d, },
    'X': { 0x1: 0x2e, 0x4: 0x2e, },
    '<': { 0x1: 0x2f, },
    'I': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'W': { 0x1: 0x32, 0x4: 0x32, },
    'V': { 0x1: 0x33, 0x4: 0x33, },
    'G': { 0x1: 0x34, 0x4: 0x34, },
    '"': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x11, },
    '\x1f': { 0x1: 0x28, },
    '\x1d': { 0x0: 0xd, },
    '\x7f': { 0x0: 0xe, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
  },
  deadkeys: {
  },
  accents: [
  ]
},
{
  klid: 0x00050408,
  localeName: "el",
  displayName: "Greek Latin",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '-': { 0x0: 0xc, 0x1: 0x4a, },
    '=': { 0x0: 0xd, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'q': { 0x0: 0x10, 0x5: 0x10, },
    'w': { 0x0: 0x11, 0x5: 0x11, },
    'e': { 0x0: 0x12, 0x5: 0x12, },
    'r': { 0x0: 0x13, 0x5: 0x13, },
    't': { 0x0: 0x14, 0x5: 0x14, },
    'y': { 0x0: 0x15, 0x5: 0x15, },
    'u': { 0x0: 0x16, 0x5: 0x16, },
    'i': { 0x0: 0x17, 0x5: 0x17, },
    'o': { 0x0: 0x18, 0x5: 0x18, },
    'p': { 0x0: 0x19, 0x5: 0x19, },
    '[': { 0x0: 0x1a, },
    ']': { 0x0: 0x1b, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'a': { 0x0: 0x1e, 0x5: 0x1e, },
    's': { 0x0: 0x1f, 0x5: 0x1f, },
    'd': { 0x0: 0x20, 0x5: 0x20, },
    'f': { 0x0: 0x21, 0x5: 0x21, },
    'g': { 0x0: 0x22, 0x5: 0x22, },
    'h': { 0x0: 0x23, 0x5: 0x23, },
    'j': { 0x0: 0x24, 0x5: 0x24, },
    'k': { 0x0: 0x25, 0x5: 0x25, },
    'l': { 0x0: 0x26, 0x5: 0x26, },
    ';': { 0x0: 0x27, },
    '\'': { 0x0: 0x28, },
    '\\': { 0x0: 0x2b, },
    'z': { 0x0: 0x2c, 0x5: 0x2c, },
    'x': { 0x0: 0x2d, 0x5: 0x2d, },
    'c': { 0x0: 0x2e, 0x5: 0x2e, },
    'v': { 0x0: 0x2f, 0x5: 0x2f, },
    'b': { 0x0: 0x30, 0x5: 0x30, },
    'n': { 0x0: 0x31, 0x5: 0x31, },
    'm': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '+': { 0x0: 0x4e, 0x1: 0xd, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    '_': { 0x1: 0xc, },
    'Q': { 0x1: 0x10, 0x4: 0x10, },
    'W': { 0x1: 0x11, 0x4: 0x11, },
    'E': { 0x1: 0x12, 0x4: 0x12, },
    'R': { 0x1: 0x13, 0x4: 0x13, },
    'T': { 0x1: 0x14, 0x4: 0x14, },
    'Y': { 0x1: 0x15, 0x4: 0x15, },
    'U': { 0x1: 0x16, 0x4: 0x16, },
    'I': { 0x1: 0x17, 0x4: 0x17, },
    'O': { 0x1: 0x18, 0x4: 0x18, },
    'P': { 0x1: 0x19, 0x4: 0x19, },
    '{': { 0x1: 0x1a, },
    '}': { 0x1: 0x1b, },
    'A': { 0x1: 0x1e, 0x4: 0x1e, },
    'S': { 0x1: 0x1f, 0x4: 0x1f, },
    'D': { 0x1: 0x20, 0x4: 0x20, },
    'F': { 0x1: 0x21, 0x4: 0x21, },
    'G': { 0x1: 0x22, 0x4: 0x22, },
    'H': { 0x1: 0x23, 0x4: 0x23, },
    'J': { 0x1: 0x24, 0x4: 0x24, },
    'K': { 0x1: 0x25, 0x4: 0x25, },
    'L': { 0x1: 0x26, 0x4: 0x26, },
    ':': { 0x1: 0x27, },
    '"': { 0x1: 0x28, },
    '|': { 0x1: 0x2b, },
    'Z': { 0x1: 0x2c, 0x4: 0x2c, },
    'X': { 0x1: 0x2d, 0x4: 0x2d, },
    'C': { 0x1: 0x2e, 0x4: 0x2e, },
    'V': { 0x1: 0x2f, 0x4: 0x2f, },
    'B': { 0x1: 0x30, 0x4: 0x30, },
    'N': { 0x1: 0x31, 0x4: 0x31, },
    'M': { 0x1: 0x32, 0x4: 0x32, },
    '<': { 0x1: 0x33, },
    '>': { 0x1: 0x34, },
    '?': { 0x1: 0x35, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '¹': { 0x3: 0x2, },
    '£': { 0x3: 0x5, },
    '÷': { 0x3: 0xd, },
    'Ä': { 0x3: 0x10, 0x6: 0x10, },
    'Å': { 0x3: 0x11, 0x6: 0x11, },
    'É': { 0x3: 0x12, 0x6: 0x12, },
    'Þ': { 0x3: 0x14, 0x6: 0x14, },
    'Ü': { 0x3: 0x15, 0x6: 0x15, },
    'Ú': { 0x3: 0x16, 0x6: 0x16, },
    'Í': { 0x3: 0x17, 0x6: 0x17, },
    'Ó': { 0x3: 0x18, 0x6: 0x18, },
    'Ö': { 0x3: 0x19, 0x6: 0x19, },
    'Á': { 0x3: 0x1e, 0x6: 0x1e, },
    '§': { 0x3: 0x1f, },
    'Ð': { 0x3: 0x20, 0x6: 0x20, },
    'Ø': { 0x3: 0x26, 0x6: 0x26, },
    '°': { 0x3: 0x27, },
    '¦': { 0x3: 0x2b, },
    'Æ': { 0x3: 0x2c, 0x6: 0x2c, },
    '¢': { 0x3: 0x2e, },
    'Ñ': { 0x3: 0x31, 0x6: 0x31, },
    'Ç': { 0x3: 0x33, 0x6: 0x33, },
    'ä': { 0x7: 0x10, 0x2: 0x10, },
    'å': { 0x7: 0x11, 0x2: 0x11, },
    'é': { 0x7: 0x12, 0x2: 0x12, },
    'þ': { 0x7: 0x14, 0x2: 0x14, },
    'ü': { 0x7: 0x15, 0x2: 0x15, },
    'ú': { 0x7: 0x16, 0x2: 0x16, },
    'í': { 0x7: 0x17, 0x2: 0x17, },
    'ó': { 0x7: 0x18, 0x2: 0x18, },
    'ö': { 0x7: 0x19, 0x2: 0x19, },
    'á': { 0x7: 0x1e, 0x2: 0x1e, },
    'ð': { 0x7: 0x20, 0x2: 0x20, },
    'ø': { 0x7: 0x26, 0x2: 0x26, },
    'æ': { 0x7: 0x2c, 0x2: 0x2c, },
    'ñ': { 0x7: 0x31, 0x2: 0x31, },
    'ç': { 0x7: 0x33, 0x2: 0x33, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x2b, },
    '¡': { 0x2: 0x2, },
    '²': { 0x2: 0x3, },
    '³': { 0x2: 0x4, },
    '¤': { 0x2: 0x5, },
    '€': { 0x2: 0x6, },
    '¼': { 0x2: 0x7, },
    '½': { 0x2: 0x8, },
    '¾': { 0x2: 0x9, },
    '‘': { 0x2: 0xa, },
    '’': { 0x2: 0xb, },
    '¥': { 0x2: 0xc, },
    '×': { 0x2: 0xd, },
    '®': { 0x2: 0x13, },
    '«': { 0x2: 0x1a, },
    '»': { 0x2: 0x1b, },
    'ß': { 0x2: 0x1f, },
    '¶': { 0x2: 0x27, },
    '¬': { 0x2: 0x2b, },
    '©': { 0x2: 0x2e, },
    'µ': { 0x2: 0x32, },
    '¿': { 0x2: 0x35, },
  },
  deadkeys: {
    'à': [0, ['a', ]],
    'è': [0, ['e', ]],
    'ì': [0, ['i', ]],
    'ò': [0, ['o', ]],
    'ù': [0, ['u', ]],
    'À': [0, ['A', ]],
    'È': [0, ['E', ]],
    'Ì': [0, ['I', ]],
    'Ò': [0, ['O', ]],
    'Ù': [0, ['U', ]],
    '`': [0, [' ', ]],
    'â': [1, ['a', ]],
    'ê': [1, ['e', ]],
    'î': [1, ['i', ]],
    'ô': [1, ['o', ]],
    'û': [1, ['u', ]],
    'Â': [1, ['A', ]],
    'Ê': [1, ['E', ]],
    'Î': [1, ['I', ]],
    'Ô': [1, ['O', ]],
    'Û': [1, ['U', ]],
    '^': [1, [' ', ]],
    'ã': [2, ['a', ]],
    'õ': [2, ['o', ]],
    'ñ': [2, ['n', ]],
    'Ã': [2, ['A', ]],
    'Õ': [2, ['O', ]],
    'Ñ': [2, ['N', ]],
    '~': [2, [' ', ]],
    'ä': [3, ['a', ]],
    'ë': [3, ['e', ]],
    'ï': [3, ['i', ]],
    'ö': [3, ['o', ]],
    'ü': [3, ['u', ]],
    'ÿ': [3, ['y', ]],
    'Ä': [3, ['A', ]],
    'Ë': [3, ['E', ]],
    'Ï': [3, ['I', ]],
    'Ö': [3, ['O', ]],
    'Ü': [3, ['U', ]],
    '¨': [3, [' ', ]],
    'á': [4, ['a', ]],
    'é': [4, ['e', ]],
    'í': [4, ['i', ]],
    'ó': [4, ['o', ]],
    'ú': [4, ['u', ]],
    'ý': [4, ['y', ]],
    'Á': [4, ['A', ]],
    'É': [4, ['E', ]],
    'Í': [4, ['I', ]],
    'Ó': [4, ['O', ]],
    'Ú': [4, ['U', ]],
    'Ý': [4, ['Y', ]],
    'ç': [4, ['c', ]],
    'Ç': [4, ['C', ]],
    '´': [4, [' ', ]],
  },
  accents: [
    {0x0: 0x29, },
    {0x1: 0x7, },
    {0x1: 0x29, },
    {0x3: 0x28, },
    {0x2: 0x28, },
  ]
},
{
  klid: 0x00060408,
  localeName: "el",
  displayName: "Greek Polytonic",
  ctrlRightIsOem8: false,
  keymap: {
    '\x1b': { 0x0: 0x1, 0x1: 0x1, },
    '1': { 0x0: 0x2, },
    '2': { 0x0: 0x3, },
    '3': { 0x0: 0x4, },
    '4': { 0x0: 0x5, },
    '5': { 0x0: 0x6, },
    '6': { 0x0: 0x7, },
    '7': { 0x0: 0x8, },
    '8': { 0x0: 0x9, },
    '9': { 0x0: 0xa, },
    '0': { 0x0: 0xb, },
    '\b': { 0x0: 0xe, 0x1: 0xe, },
    '\t': { 0x0: 0xf, 0x1: 0xf, },
    'ς': { 0x0: 0x11, },
    'ε': { 0x0: 0x12, 0x5: 0x12, },
    'ρ': { 0x0: 0x13, 0x5: 0x13, },
    'τ': { 0x0: 0x14, 0x5: 0x14, },
    'υ': { 0x0: 0x15, 0x5: 0x15, },
    'θ': { 0x0: 0x16, 0x5: 0x16, },
    'ι': { 0x0: 0x17, 0x5: 0x17, },
    'ο': { 0x0: 0x18, 0x5: 0x18, },
    'π': { 0x0: 0x19, 0x5: 0x19, },
    '\r': { 0x0: 0x1c, 0x1: 0x1c, },
    'α': { 0x0: 0x1e, 0x5: 0x1e, },
    'σ': { 0x0: 0x1f, 0x5: 0x1f, },
    'δ': { 0x0: 0x20, 0x5: 0x20, },
    'φ': { 0x0: 0x21, 0x5: 0x21, },
    'γ': { 0x0: 0x22, 0x5: 0x22, },
    'η': { 0x0: 0x23, 0x5: 0x23, },
    'ξ': { 0x0: 0x24, 0x5: 0x24, },
    'κ': { 0x0: 0x25, 0x5: 0x25, },
    'λ': { 0x0: 0x26, 0x5: 0x26, },
    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },
    'χ': { 0x0: 0x2d, 0x5: 0x2d, },
    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },
    'ω': { 0x0: 0x2f, 0x5: 0x2f, },
    'β': { 0x0: 0x30, 0x5: 0x30, },
    'ν': { 0x0: 0x31, 0x5: 0x31, },
    'μ': { 0x0: 0x32, 0x5: 0x32, },
    ',': { 0x0: 0x33, },
    '.': { 0x0: 0x34, },
    '*': { 0x0: 0x37, 0x1: 0x9, },
    ' ': { 0x0: 0x39, 0x1: 0x39, },
    '-': { 0x0: 0x4a, 0x1: 0x4a, },
    '+': { 0x0: 0x4e, 0x1: 0x4e, },
    '<': { 0x0: 0x56, 0x1: 0x33, },
    '/': { 0x0: 0x35, 0x1: 0x35, },
    '\x03': { 0x0: 0x46, 0x1: 0x46, },
    '!': { 0x1: 0x2, },
    '@': { 0x1: 0x3, },
    '#': { 0x1: 0x4, },
    '$': { 0x1: 0x5, },
    '%': { 0x1: 0x6, },
    '^': { 0x1: 0x7, },
    '&': { 0x1: 0x8, },
    '(': { 0x1: 0xa, },
    ')': { 0x1: 0xb, },
    'Ε': { 0x1: 0x12, 0x4: 0x12, },
    'Ρ': { 0x1: 0x13, 0x4: 0x13, },
    'Τ': { 0x1: 0x14, 0x4: 0x14, },
    'Υ': { 0x1: 0x15, 0x4: 0x15, },
    'Θ': { 0x1: 0x16, 0x4: 0x16, },
    'Ι': { 0x1: 0x17, 0x4: 0x17, },
    'Ο': { 0x1: 0x18, 0x4: 0x18, },
    'Π': { 0x1: 0x19, 0x4: 0x19, },
    'Α': { 0x1: 0x1e, 0x4: 0x1e, },
    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },
    'Δ': { 0x1: 0x20, 0x4: 0x20, },
    'Φ': { 0x1: 0x21, 0x4: 0x21, },
    'Γ': { 0x1: 0x22, 0x4: 0x22, },
    'Η': { 0x1: 0x23, 0x4: 0x23, },
    'Ξ': { 0x1: 0x24, 0x4: 0x24, },
    'Κ': { 0x1: 0x25, 0x4: 0x25, },
    'Λ': { 0x1: 0x26, 0x4: 0x26, },
    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },
    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },
    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },
    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },
    'Β': { 0x1: 0x30, 0x4: 0x30, },
    'Ν': { 0x1: 0x31, 0x4: 0x31, },
    'Μ': { 0x1: 0x32, 0x4: 0x32, },
    '>': { 0x1: 0x34, },
    '\x1e': { 0x1: 0x7, },
    '\x1f': { 0x1: 0xc, },
    '²': { 0x3: 0x3, },
    '³': { 0x3: 0x4, },
    '·': { 0x3: 0x1b, },
    '\x7f': { 0x0: 0xe, },
    '\x1d': { 0x0: 0x1b, },
    '\n': { 0x0: 0x1c, },
    '\x1c': { 0x0: 0x28, },
    'Ϛ': { 0x2: 0x2, },
    'Ϟ': { 0x2: 0x3, },
    'Ϡ': { 0x2: 0x4, },
    '£': { 0x2: 0x5, },
    '§': { 0x2: 0x6, },
    '¶': { 0x2: 0x7, },
    '¤': { 0x2: 0x9, },
    '¦': { 0x2: 0xa, },
    '°': { 0x2: 0xb, },
    '±': { 0x2: 0xc, },
    '€': { 0x2: 0x12, },
    '®': { 0x2: 0x13, },
    '¥': { 0x2: 0x15, },
    '©': { 0x2: 0x2e, },
  },
  deadkeys: {
    'ᾱ': [0, ['α', ]],
    'Ᾱ': [0, ['Α', ]],
    'ῑ': [0, ['ι', ]],
    'Ῑ': [0, ['Ι', ]],
    'ῡ': [0, ['υ', ]],
    'Ῡ': [0, ['Υ', ]],
    '¯': [0, ['.', ]],
    '-': [0, [' ', ]],
    'ἆ': [1, ['α', ]],
    'Ἆ': [1, ['Α', ]],
    'ἦ': [1, ['η', ]],
    'Ἦ': [1, ['Η', ]],
    'ἶ': [1, ['ι', ]],
    'Ἶ': [1, ['Ι', ]],
    'ὖ': [1, ['υ', ]],
    'ὦ': [1, ['ω', ]],
    'Ὦ': [1, ['Ω', ]],
    '῏': [1, ['.', ]],
    '=': [1, [' ', ]],
    'ά': [2, ['α', ]],
    'έ': [2, ['ε', ]],
    'ή': [2, ['η', ]],
    'ί': [2, ['ι', ]],
    'ό': [2, ['ο', ]],
    'ύ': [2, ['υ', ]],
    'ώ': [2, ['ω', ]],
    'Ά': [2, ['Α', ]],
    'Έ': [2, ['Ε', ]],
    'Ή': [2, ['Η', ]],
    'Ί': [2, ['Ι', ]],
    'Ύ': [2, ['Υ', ]],
    'Ό': [2, ['Ο', ]],
    'Ώ': [2, ['Ω', ]],
    '´': [2, ['.', ]],
    ';': [2, [' ', ]],
    'ᾶ': [3, ['α', ]],
    'ῆ': [3, ['η', ]],
    'ῖ': [3, ['ι', ]],
    'ῦ': [3, ['υ', ]],
    'ῶ': [3, ['ω', ]],
    '῀': [3, ['.', ]],
    '[': [3, [' ', ]],
    'ὰ': [4, ['α', ]],
    'ὲ': [4, ['ε', ]],
    'ὴ': [4, ['η', ]],
    'ὶ': [4, ['ι', ]],
    'ὸ': [4, ['ο', ]],
    'ὺ': [4, ['υ', ]],
    'ὼ': [4, ['ω', ]],
    'Ὰ': [4, ['Α', ]],
    'Ὲ': [4, ['Ε', ]],
    'Ὴ': [4, ['Η', ]],
    'Ὶ': [4, ['Ι', ]],
    'Ὺ': [4, ['Υ', ]],
    'Ὸ': [4, ['Ο', ]],
    'Ὼ': [4, ['Ω', ]],
    '`': [4, ['.', ]],
    ']': [4, [' ', ]],
    'ά': [5, ['α', ]],
    'έ': [5, ['ε', ]],
    'ί': [5, ['ι', ]],
    'ό': [5, ['ο', ]],
    'ύ': [5, ['υ', ]],
    'ώ': [5, ['ω', ]],
    'ή': [5, ['η', ]],
    'Ά': [5, ['Α', ]],
    'Έ': [5, ['Ε', ]],
    'Ί': [5, ['Ι', ]],
    'Ό': [5, ['Ο', ]],
    'Ύ': [5, ['Υ', ]],
    'Ώ': [5, ['Ω', ]],
    'Ή': [5, ['Η', ]],
    '΄': [5, [' ', '.', ]],
    'ἀ': [6, ['α', ]],
    'Ἀ': [6, ['Α', ]],
    'ἐ': [6, ['ε', ]],
    'Ἐ': [6, ['Ε', ]],
    'ἠ': [6, ['η', ]],
    'Ἠ': [6, ['Η', ]],
    'ἰ': [6, ['ι', ]],
    'Ἰ': [6, ['Ι', ]],
    'ὀ': [6, ['ο', ]],
    'Ὀ': [6, ['Ο', ]],
    'ὐ': [6, ['υ', ]],
    'ὠ': [6, ['ω', ]],
    'Ὠ': [6, ['Ω', ]],
    'ῤ': [6, ['ρ', ]],
    '᾿': [6, ['.', ]],
    '\'': [6, [' ', ]],
    'ΐ': [7, ['ι', ]],
    'ΰ': [7, ['υ', ]],
    '΅': [7, ['.', ]],
    '~': [7, [' ', ]],
    'ἂ': [8, ['α', ]],
    'Ἂ': [8, ['Α', ]],
    'ἒ': [8, ['ε', ]],
    'Ἒ': [8, ['Ε', ]],
    'ἢ': [8, ['η', ]],
    'Ἢ': [8, ['Η', ]],
    'ἲ': [8, ['ι', ]],
    'Ἲ': [8, ['Ι', ]],
    'ὂ': [8, ['ο', ]],
    'Ὂ': [8, ['Ο', ]],
    'ὒ': [8, ['υ', ]],
    'ὢ': [8, ['ω', ]],
    'Ὢ': [8, ['Ω', ]],
    '῍': [8, ['.', ]],
    '\\': [8, [' ', ]],
    'ἄ': [9, ['α', ]],
    'Ἄ': [9, ['Α', ]],
    'ἔ': [9, ['ε', ]],
    'Ἔ': [9, ['Ε', ]],
    'ἤ': [9, ['η', ]],
    'Ἤ': [9, ['Η', ]],
    'ἴ': [9, ['ι', ]],
    'Ἴ': [9, ['Ι', ]],
    'ὄ': [9, ['ο', ]],
    'Ὄ': [9, ['Ο', ]],
    'ὔ': [9, ['υ', ]],
    'ὤ': [9, ['ω', ]],
    'Ὤ': [9, ['Ω', ]],
    '῎': [9, ['.', ]],
    '/': [9, [' ', ]],
    'ᾰ': [10, ['α', ]],
    'Ᾰ': [10, ['Α', ]],
    'ῐ': [10, ['ι', ]],
    'Ῐ': [10, ['Ι', ]],
    'ῠ': [10, ['υ', ]],
    'Ῠ': [10, ['Υ', ]],
    '˘': [10, ['.', ]],
    '_': [10, [' ', ]],
    'ἇ': [11, ['α', ]],
    'Ἇ': [11, ['Α', ]],
    'ἧ': [11, ['η', ]],
    'Ἧ': [11, ['Η', ]],
    'ἷ': [11, ['ι', ]],
    'Ἷ': [11, ['Ι', ]],
    'ὗ': [11, ['υ', ]],
    'Ὗ': [11, ['Υ', ]],
    'ὧ': [11, ['ω', ]],
    'Ὧ': [11, ['Ω', ]],
    '῟': [11, ['.', ]],
    '+': [11, [' ', ]],
    'ϊ': [12, ['ι', ]],
    'ϋ': [12, ['υ', ]],
    'Ϊ': [12, ['Ι', ]],
    'Ϋ': [12, ['Υ', ]],
    '¨': [12, [' ', '.', ]],
    ':': [12, [' ', ]],
    'ΐ': [13, ['ι', ]],
    'ΰ': [13, ['υ', ]],
    '΅': [13, [' ', '.', ]],
    'ᾳ': [14, ['α', ]],
    'ᾼ': [14, ['Α', ]],
    'ῃ': [14, ['η', ]],
    'ῌ': [14, ['Η', ]],
    'ῳ': [14, ['ω', ]],
    'ῼ': [14, ['Ω', ]],
    'ι': [14, ['.', ]],
    '{': [14, [' ', ]],
    '·': [15, ['.', ]],
    '}': [15, [' ', ]],
    'ἁ': [16, ['α', ]],
    'Ἁ': [16, ['Α', ]],
    'ἑ': [16, ['ε', ]],
    'Ἑ': [16, ['Ε', ]],
    'ἡ': [16, ['η', ]],
    'Ἡ': [16, ['Η', ]],
    'ἱ': [16, ['ι', ]],
    'Ἱ': [16, ['Ι', ]],
    'ὁ': [16, ['ο', ]],
    'Ὁ': [16, ['Ο', ]],
    'ὑ': [16, ['υ', ]],
    'Ὑ': [16, ['Υ', ]],
    'ὡ': [16, ['ω', ]],
    'Ὡ': [16, ['Ω', ]],
    'ῥ': [16, ['ρ', ]],
    'Ῥ': [16, ['Ρ', ]],
    '῾': [16, ['.', ]],
    '"': [16, [' ', ]],
    'ῒ': [17, ['ι', ]],
    'ῢ': [17, ['υ', ]],
    '῭': [17, ['.', ]],
    '`': [17, [' ', ]],
    'ἃ': [18, ['α', ]],
    'Ἃ': [18, ['Α', ]],
    'ἓ': [18, ['ε', ]],
    'Ἓ': [18, ['Ε', ]],
    'ἣ': [18, ['η', ]],
    'Ἣ': [18, ['Η', ]],
    'ἳ': [18, ['ι', ]],
    'Ἳ': [18, ['Ι', ]],
    'ὃ': [18, ['ο', ]],
    'Ὃ': [18, ['Ο', ]],
    'ὓ': [18, ['υ', ]],
    'Ὓ': [18, ['Υ', ]],
    'ὣ': [18, ['ω', ]],
    'Ὣ': [18, ['Ω', ]],
    '῝': [18, ['.', ]],
    '|': [18, [' ', ]],
    'ἅ': [19, ['α', ]],
    'Ἅ': [19, ['Α', ]],
    'ἕ': [19, ['ε', ]],
    'Ἕ': [19, ['Ε', ]],
    'ἥ': [19, ['η', ]],
    'Ἥ': [19, ['Η', ]],
    'ἵ': [19, ['ι', ]],
    'Ἵ': [19, ['Ι', ]],
    'ὅ': [19, ['ο', ]],
    'Ὅ': [19, ['Ο', ]],
    'ὕ': [19, ['υ', ]],
    'Ὕ': [19, ['Υ', ]],
    'ὥ': [19, ['ω', ]],
    'Ὥ': [19, ['Ω', ]],
    '῞': [19, ['.', ]],
    '?': [19, [' ', ]],
    'ᾇ': [20, ['α', ]],
    'ᾏ': [20, ['Α', ]],
    'ᾗ': [20, ['η', ]],
    'ᾟ': [20, ['Η', ]],
    'ᾧ': [20, ['ω', ]],
    'ᾯ': [20, ['Ω', ]],
    'ᾁ': [21, ['α', ]],
    'ᾉ': [21, ['Α', ]],
    'ᾑ': [21, ['η', ]],
    'ᾙ': [21, ['Η', ]],
    'ᾡ': [21, ['ω', ]],
    'ᾩ': [21, ['Ω', ]],
    'ᾃ': [22, ['α', ]],
    'ᾋ': [22, ['Α', ]],
    'ᾓ': [22, ['η', ]],
    'ᾛ': [22, ['Η', ]],
    'ᾣ': [22, ['ω', ]],
    'ᾫ': [22, ['Ω', ]],
    'ᾅ': [23, ['α', ]],
    'ᾍ': [23, ['Α', ]],
    'ᾕ': [23, ['η', ]],
    'ᾝ': [23, ['Η', ]],
    'ᾥ': [23, ['ω', ]],
    'ᾭ': [23, ['Ω', ]],
    'ᾆ': [24, ['α', ]],
    'ᾎ': [24, ['Α', ]],
    'ᾖ': [24, ['η', ]],
    'ᾞ': [24, ['Η', ]],
    'ᾦ': [24, ['ω', ]],
    'ᾮ': [24, ['Ω', ]],
    '½': [24, [' ', ]],
    'ᾴ': [25, ['α', ]],
    'ῄ': [25, ['η', ]],
    'ῴ': [25, ['ω', ]],
    'ᾷ': [26, ['α', ]],
    'ῇ': [26, ['η', ]],
    'ῷ': [26, ['ω', ]],
    '«': [26, [' ', ]],
    'ᾲ': [27, ['α', ]],
    'ῂ': [27, ['η', ]],
    'ῲ': [27, ['ω', ]],
    '»': [27, [' ', ]],
    'ᾀ': [28, ['α', ]],
    'ᾈ': [28, ['Α', ]],
    'ᾐ': [28, ['η', ]],
    'ᾘ': [28, ['Η', ]],
    'ᾠ': [28, ['ω', ]],
    'ᾨ': [28, ['Ω', ]],
    'ῗ': [29, ['ι', ]],
    'ῧ': [29, ['υ', ]],
    '῁': [29, [' ', '.', ]],
    'ᾂ': [30, ['α', ]],
    'ᾊ': [30, ['Α', ]],
    'ᾒ': [30, ['η', ]],
    'ᾚ': [30, ['Η', ]],
    'ᾢ': [30, ['ω', ]],
    'ᾪ': [30, ['Ω', ]],
    '¬': [30, [' ', ]],
    'ᾄ': [31, ['α', ]],
    'ᾌ': [31, ['Α', ]],
    'ᾔ': [31, ['η', ]],
    'ᾜ': [31, ['Η', ]],
    'ᾤ': [31, ['ω', ]],
    'ᾬ': [31, ['Ω', ]],
  },
  accents: [
    {0x0: 0xc, },
    {0x0: 0xd, },
    {0x0: 0x10, },
    {0x0: 0x1a, },
    {0x0: 0x1b, },
    {0x0: 0x27, },
    {0x0: 0x28, },
    {0x0: 0x29, },
    {0x0: 0x2b, },
    {0x0: 0x35, },
    {0x1: 0xc, },
    {0x1: 0xd, },
    {0x1: 0x10, },
    {0x1: 0x11, 0x2: 0x27, },
    {0x1: 0x1a, },
    {0x1: 0x1b, },
    {0x1: 0x28, },
    {0x1: 0x29, },
    {0x1: 0x2b, },
    {0x1: 0x35, },
    {0x3: 0xd, },
    {0x3: 0x28, },
    {0x3: 0x2b, },
    {0x3: 0x35, },
    {0x2: 0xd, },
    {0x2: 0x10, },
    {0x2: 0x1a, },
    {0x2: 0x1b, },
    {0x2: 0x28, },
    {0x2: 0x29, },
    {0x2: 0x2b, },
    {0x2: 0x35, },
  ]
},
];

const actionLayout = {
  "ContextMenu": 0x15d,
  "BrowserBack": 0x16a,
  "BrowserFavorites": 0x166,
  "BrowserForward": 0x169,
  "BrowserHome": 0x132,
  "BrowserRefresh": 0x167,
  "BrowserSearch": 0x165,
  "BrowserStop": 0x168,
  "Clear": 0x59,
  "CodeInput": 0x62,
  "Delete": 0x153,
  "ArrowDown": 0x150,
  "End": 0x14f,
  "F1": 0x3b,
  "F2": 0x3c,
  "F3": 0x3d,
  "F4": 0x3e,
  "F5": 0x3f,
  "F6": 0x40,
  "F7": 0x41,
  "F8": 0x42,
  "F9": 0x43,
  "F10": 0x44,
  "F11": 0x57,
  "F12": 0x58,
  "F13": 0x64,
  "F14": 0x65,
  "F15": 0x66,
  "F16": 0x67,
  "F17": 0x68,
  "F18": 0x69,
  "F19": 0x6a,
  "F20": 0x6b,
  "F21": 0x6c,
  "F22": 0x6d,
  "F23": 0x6e,
  "F24": 0x76,
  "Help": 0x63,
  "Home": 0x147,
  "Insert": 0x152,
  "LaunchApp1": 0x16b,
  "LaunchApp2": 0x121,
  "LaunchMail": 0x16c,
  "LaunchMediaPlayer": 0x16d,
  "ArrowLeft": 0x14b,
  "MediaTrackNext": 0x119,
  "MediaPlayPause": 0x122,
  "MediaTrackPrevious": 0x110,
  "MediaStop": 0x124,
  "PageDown": 0x151,
  "PageUp": 0x149,
  "ArrowRight": 0x14d,
  "ScrollLock": 0x46,
  "Standby": 0x15f,
  "PrintScreen": 0x137,
  "ArrowUp": 0x148,
  "AudioVolumeDown": 0x12e,
  "AudioVolumeMute": 0x120,
  "AudioVolumeUp": 0x130,
};

try {
    module.exports.layouts = layouts;
    module.exports.actionLayout = actionLayout;
}
catch(e) {
    // module not found
}

