# Example Plugin for wssshd2

This is an example plugin that demonstrates all the capabilities of the wssshd2 plugin system:

1. **Web Pages**: Adds a new page at `/plugin/example`
2. **Message Bus**: Handles custom WebSocket messages of type `example_message`
3. **Transport Protocols**: Implements a simple echo transport protocol

## Building the Plugin

```bash
cd wssshd2/plugins/example
make
```

This will create `example.so` which is the plugin shared library.

## Installing the Plugin

Copy the `example.so` file to the wssshd2 plugins directory (by default, this is `/usr/local/lib/wssshd/plugins/` or `./plugins/` if running from source).

## Using the Plugin

### Web Interface

Navigate to `http://your-wssshd-server/plugin/example` to see the plugin's custom page.

### Message Bus

The plugin responds to WebSocket messages with type `example_message`. You can send messages like:

```json
{
  "type": "example_message",
  "data": "your data here"
}
```

The plugin will respond with:

```json
{
  "type": "example_response",
  "message": "Hello from plugin!",
  "count": 1
}
```

### Transport Protocol

The plugin implements a simple echo transport protocol that prefixes all data with "ECHO: ".

## Plugin Structure

- `plugin.c`: Main plugin implementation with the required interface functions
- `example.html`: HTML template for the plugin's web page
- `example.js`: JavaScript for client-side functionality
- `Makefile`: Build script for the plugin

## Plugin Interface

Plugins must implement these functions:

- `int plugin_init(wssshd_state_t *state)`: Initialize the plugin
- `void plugin_cleanup(void)`: Clean up plugin resources
- `int plugin_handle_web_request(int client_fd, const http_request_t *req)`: Handle web requests
- `int plugin_handle_message(wssshd_state_t *state, ws_connection_t *conn, const char *message, size_t message_len)`: Handle WebSocket messages
- `int plugin_handle_transport(wssshd_state_t *state, const char *data, size_t data_len, char **response, size_t *response_len)`: Handle custom transport protocols

See `plugin.h` for the complete interface definition.