/**
 * Configuration handling for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef CONFIG_H
#define CONFIG_H

#include <stdbool.h>

// Configuration structure
typedef struct {
    char *config_file;
    char *host;
    int port;
    char *domain;
    char *password;
    char *web_host;
    int web_port;
    bool web_https;
    bool web_proxy_enabled;
    int web_proxy_port;
    bool websocket_tls_only;
    bool debug;
    bool debug_web;
    bool debug_database;
    bool debug_vnc;
    bool debug_rdp;
} wssshd_config_t;

// Function declarations
wssshd_config_t *load_config(int argc, char *argv[]);
void free_config(wssshd_config_t *config);
void print_config(const wssshd_config_t *config);

#endif /* CONFIG_H */