# WSSSH: Warp-Powered Stefy's Spatial Secure Hyperdrive

![WSSH Logo](image.jpg)

**WSSSH** is a universal tunneling system that provides secure access to remote machines through various transport protocols. It consists of multiple components that work together to create a seamless tunneling experience, allowing you to access remote machines through secure relays with support for multiple transport types.

## Features

- **Universal Tunneling**: Support for multiple transport protocols (WebSocket, and more coming soon)
- **Multi-Component Architecture**: Complete tunneling system with server, client, and wrapper tools
- **Intelligent Hostname Parsing**: Automatic client ID and server endpoint detection
- **Drop-in SSH/SCP Replacement**: Use `wsssh` and `wsscp` as direct replacements for standard SSH/SCP commands
- **SSL/TLS Encryption**: All communications are fully encrypted
- **Multi-client Support**: Route connections to different registered clients
- **Professional Web Interface**: Admin panel with user management, HTML5 terminal, and fullscreen support
- **Cross-platform Compatibility**: Works on Linux, macOS, and Windows
- **Debian Packaging**: Easy installation with proper system integration
- **Service Management**: Complete init scripts and watchdog monitoring
- **Advanced Logging**: Automatic log rotation with comprehensive monitoring
- **Multiple Operating Modes**: Interactive, silent, bridge, script, and daemon modes
- **Enterprise Reliability**: Production-grade process supervision and high availability
- **Web Proxy Server**: Built-in HTTP reverse proxy for registered web services, accessible via localhost only for security
- **Server Stability**: Robust error handling with comprehensive crash prevention and graceful client disconnection management

## Architecture

### Core Components

#### Server Component (`wssshd`)
- **C Implementation**: High-performance native C daemon with embedded web interface
- **SQLite Database**: Persistent user management with secure password storage
- **Universal Daemon**: Central server managing connections with multiple transport protocols
- **Client Registration**: Handles client authentication with password-based registration
- **Tunnel Routing**: Routes tunnel requests to appropriate registered clients
- **Web Management Interface**: Professional admin panel with user management and HTML5 terminal
- **Session Management**: Maintains persistent connections and handles reconnection logic
- **Security Features**: Automatic warnings for default credentials and secure session handling

#### Client Tools (`wssshtools/`)

1. **`wssshc`** - WSSH Client Registration
    - Registers client machines with the daemon
    - Maintains persistent connection to the server
    - Automatic reconnection with configurable intervals
    - Minimal dependencies (OpenSSL only)
    - Optimized for embedded systems and resource-constrained environments

2. **`wsssh`** - SSH Wrapper with Tunneling
    - Simplified CLI that eliminates the need to specify "ssh" commands explicitly
    - Intelligent parsing of SSH commands and hostnames
    - Automatic establishment of tunnels
    - Launches SSH client to local tunnel port
    - Direct system integration with no Python runtime required
    - High performance for production environments

3. **`wsscp`** - SCP Wrapper with Tunneling
    - Simplified CLI that eliminates the need to specify "scp" commands explicitly
    - Optimized for file transfer operations through secure tunnels
    - Handles both upload and download operations
    - Consistent design with the SSH wrapper
    - Enterprise-ready performance for large file transfers

4. **`wsssht`** - Tunnel Setup Tool
    - Manual tunnel establishment without automatic command execution
    - Provides connection information for use with any TCP client
    - Supports all tunneling modes and transport options
    - Perfect for integration with third-party tools and custom workflows

## Web Interface

WSSSH provides a comprehensive web-based management interface accessible through the wssshd daemon. The web interface offers professional remote access capabilities with modern browser-based clients.

### Dashboard (`/`)
- **Client Management**: View all registered clients with their connection status
- **Service Access**: Direct access buttons for SSH, VNC, and RDP services per client
- **System Information**: Display of WebSocket port, domain, and client count
- **Real-time Updates**: Automatic refresh of client status every 5 seconds
- **User Authentication**: Secure login/logout with session management

### SSH Terminal (`/terminal/<client_id>`)
- **HTML5 Terminal**: Full-featured terminal emulator using xterm.js
- **Real-time Connection**: WebSocket-based bidirectional communication
- **Username Configuration**: Input field for SSH username
- **Fullscreen Support**: Toggle between windowed and fullscreen modes
- **Responsive Design**: Adapts to different screen sizes
- **Session Management**: Connect/disconnect controls with automatic cleanup

### VNC Remote Desktop (`/vnc/<client_id>`)
- **noVNC Integration**: Browser-based VNC client using the noVNC project
- **Password Authentication**: Secure credential input for VNC connections
- **Zoom Controls**: Toggle between scaled fit and actual size views
- **Fullscreen Mode**: Immersive remote desktop experience
- **Real-time Updates**: Smooth remote desktop interaction
- **Connection Management**: Connect/disconnect with status feedback

### RDP Remote Desktop (`/rdp/<client_id>`)
- **rdp.wasm Integration**: WebAssembly-based RDP client
- **Advanced Configuration**: Comprehensive connection settings modal
  - Authentication (username, password, domain)
  - Display settings (resolution, color depth, graphics implementation)
  - Keyboard layout and input method configuration
  - Advanced options and JSON configuration support
- **Multiple Graphics Backends**: Canvas 2D, WebGL, and WebGL2 support
- **Zoom and Fullscreen**: Flexible viewing options
- **Real-time Performance**: Optimized for smooth remote desktop access

### Web Proxy Server

WSSSH includes a built-in HTTP reverse proxy server that enables web services on registered clients to be accessed through the daemon. The proxy listens only on `127.0.0.1` for security, preventing external access to proxied services.

#### Features
- **Hostname-based Routing**: Automatically routes requests to the correct client based on the requested hostname
- **Client ID Matching**: Supports both direct client ID matching and subdomain patterns (`clientid.domain`)
- **Security-First Design**: Listens exclusively on localhost, requiring VPN or SSH tunnel for remote access
- **Multi-client Support**: Handles concurrent connections to different clients simultaneously

#### Configuration
Enable the web proxy via command line:
```bash
# Enable with default port (9090)
./wssshd --web-proxy

# Enable with custom port
./wssshd --web-proxy 8080
```

Or via configuration file:
```ini
[wssshd]
web-proxy = true
web-proxy-port = 9090
```

#### Usage
1. Register a client with the "web" or "http" service
2. Configure the web service on the client machine
3. Access the web service via the proxy using the hostname pattern:
   - `http://clientid.domain/` → Routes to the registered client's web service
   - The proxy extracts the hostname from the HTTP Host header and forwards to the matching client

#### Client Registration with Web Service
```bash
# Register client with web service
./wssshc --server-ip wssshd.example.com --id mywebserver --password secret --services-path /etc/wsssh.d/

# Configure web service in /etc/wsssh.d/web.conf
[web]
tunnel-host = 127.0.0.1
tunnel-port = 80
```

### Security Features
- **HTTPS Support**: Optional SSL/TLS encryption for web interface
- **Session Security**: Secure WebSocket connections for all remote access
- **Authentication**: User login system with password protection
- **Access Control**: Client-specific service access restrictions

### Browser Compatibility
- **Modern Browsers**: Full support for Chrome, Firefox, Safari, and Edge
- **Mobile Support**: Responsive design works on tablets and smartphones
- **WebAssembly**: RDP functionality requires WebAssembly support
- **WebSocket**: Real-time communication requires WebSocket support

## Installation

### From Source

```bash
# Clone the repository
git clone https://git.nexlab.net/nexlab/wsssh.git
cd wsssh

# Build all components (C implementation with embedded web interface)
./build.sh
```

### Debian Package Installation

#### Server Package (`wsssh-server`)
```bash
# Build the server package
./build.sh --server-only

# Install the server package
sudo dpkg -i dist/wsssh-server*.deb

# Configure the service
sudo cp /usr/share/wsssh/wssshd.conf.example /etc/wssshd.conf
sudo editor /etc/wssshd.conf

# Enable and start the service
sudo systemctl enable wssshd
sudo systemctl start wssshd

# Check service status
sudo systemctl status wssshd
```

#### Client Tools Package (`wsssh-tools`)
```bash
# Build the client tools package
./build.sh --wssshtools-only

# Install the client package
sudo dpkg -i dist/wsssh-tools*.deb

# Verify installation
wssshc --help
wsssh --help
wsscp --help
wsssht --help
```

#### Build Both Packages
```bash
# Build both packages
./build.sh --debian

# Install both packages
sudo dpkg -i dist/wsssh-server*.deb dist/wsssh-tools*.deb
```

### C Implementation Build

To build the C tools from source:

```bash
# Navigate to the tools directory
cd wssshtools

# Configure and build
./configure.sh
make

# Optional: Install system-wide
sudo make install
```

## Quick Start Guide

### 1. Start the Daemon

```bash
# Start the server with basic configuration
./wssshd --host 0.0.0.0 --port 9898 --domain example.com --password mysecret

# Or with web interface enabled
./wssshd --host 0.0.0.0 --port 9898 --domain example.com --password mysecret \
         --web-host 0.0.0.0 --web-port 8080

# Or with web proxy enabled (listens on 127.0.0.1:9090)
./wssshd --host 0.0.0.0 --port 9898 --domain example.com --password mysecret \
         --web-proxy

# Or with web proxy on custom port
./wssshd --host 0.0.0.0 --port 9898 --domain example.com --password mysecret \
         --web-proxy 8080
```

### 2. Register a Client Machine

On each machine you want to access through WSSSH:

```bash
# Register with the server
./wssshc --server-ip <server_ip> --port 9898 --id myclient --password mysecret

# The client will maintain a persistent connection to the server
```

### 3. Connect via SSH

```bash
# Using the SSH wrapper (recommended)
./wsssh user@myclient.example.com

# Using the tunnel setup tool for manual connections
./wsssht --clientid myclient --wssshd-host example.com

# With custom port
./wsssh -p 2222 user@myclient.example.com
```

### 4. Transfer Files via SCP

```bash
# Upload a file
./wsscp localfile user@myclient.example.com:/remote/path/

# Download a file
./wsscp user@myclient.example.com:/remote/file ./localfile

# With custom port
./wsscp -P 2222 localfile user@myclient.example.com:/remote/path/
```

## Operating Modes

### Interactive Mode (Default)
Standard interactive sessions with full user interface and progress indicators.

### Silent Mode
```bash
./wsssh --silent --clientid myclient --wssshd-host example.com
```
Suppresses all informational output, perfect for automation and scripting.

### Bridge Mode
```bash
./wsssht --bridge --clientid myclient --wssshd-host example.com
```
JSON-based communication over stdin/stdout for programmatic integration.

### Script Mode
```bash
./wsssht --script --clientid myclient --wssshd-host example.com
```
JSON protocol with status updates and command processing for scripting environments.

### Daemon Mode
```bash
./wsssht --daemon --clientid myclient --wssshd-host example.com
```
Lazy tunnel initialization that waits for the first connection before establishing the tunnel.

## Hostname Format

WSSSH uses intelligent hostname parsing with the format:
```
<CLIENT_ID>.<WSSSHD_HOST>[:<WSSSHD_PORT>]
```

### Examples:
- `user@myclient.example.com` → Client: `myclient`, Server: `example.com:9898`
- `user@server.datacenter.com:2222` → Client: `server`, Server: `datacenter.com:2222`
- `user@remote` (with config domain `example.com`) → Client: `remote`, Server: `example.com:9898`

## Configuration

### Server Configuration (`/etc/wssshd.conf`)

The wssshd daemon supports configuration via `/etc/wssshd.conf`:

```ini
[wssshd]
host = 0.0.0.0
port = 9898
password = mysecret
domain = example.com
web-host = 0.0.0.0
web-port = 8080
web-https = false
web-proxy = false
web-proxy-port = 9090
```

Configuration options:
- `host`: IP address to bind the WebSocket server (default: 0.0.0.0)
- `port`: WebSocket server port (default: 9898)
- `password`: Registration password for client authentication
- `domain`: Default domain for hostname parsing
- `web-host`: IP address to bind the web interface (default: 0.0.0.0)
- `web-port`: Web interface port (default: 8080)
- `web-https`: Enable HTTPS for web interface (default: false)
- `web-proxy`: Enable web proxy server (default: false)
- `web-proxy-port`: Web proxy listen port (default: 9090)

### Client Configuration (`~/.config/wsssh/wssshc.conf`)

Client registration configuration:

```ini
[wssshc]
# WebSocket server IP address or hostname
server-ip = wssshd.example.com

# WebSocket server port
port = 9898

# Client ID for registration with the server
id = my-client

# Registration password (must match server configuration)
password = my-secret-password

# Reconnection interval in seconds (default: 30)
interval = 30

# Directory containing service configuration files (default: /etc/wsssh.d/)
services-path = /etc/wsssh.d/

# Default service name for tunnel requests (default: ssh)
service = ssh
```

### Tunnel Tool Configuration (`~/.config/wsssh/wsssht.conf`)

Configuration for the wsssht tunnel tool:

```ini
[wssht]
# wssshd server hostname
wssshd-host = mbetter.nexlab.net

# Client ID for the tunnel
clientid = myclient

# Operating mode: interactive, silent, bridge, script
mode = interactive

# Enable daemon mode (true/false)
daemon = false

# Transport types for data channel (comma-separated or 'any')
tunnel = any

# Transport types for control channel (comma-separated or 'any')
tunnel-control = any

# Service type (default: ssh)
service = ssh

# Local tunnel host (default: 127.0.0.1)
tunnel-host = 127.0.0.1

# Connection retry interval in seconds (default: 5)
interval = 5

# Data encoding: hex, base64, or bin (default: hex)
enc = hex
```

### Service Configuration Files

WSSSH supports multiple services per client through individual service configuration files. These files are stored in the `services-path` directory (default: `/etc/wsssh.d/`) and allow you to configure different services like SSH, RDP, VNC, etc.

#### Service Configuration File Format (`/etc/wsssh.d/ssh.conf`)
```ini
[ssh]
# Target host for the tunnel connection
tunnel-host = 192.168.1.100

# Target port for the tunnel connection
tunnel-port = 22

# Optional command to execute before establishing the tunnel
# command = /usr/local/bin/setup-tunnel.sh

# Protocol to use (tcp or udp, default: tcp)
proto = tcp
```

#### Service Configuration File Format (`/etc/wsssh.d/rdp.conf`)
```ini
[rdp]
# Target host for the tunnel connection
tunnel-host = 192.168.1.100

# Target port for the tunnel connection
tunnel-port = 3389

# Protocol to use (tcp or udp, default: tcp)
proto = tcp
```

#### Service Configuration File Format (`/etc/wsssh.d/vnc.conf`)
```ini
[vnc]
# Target host for the tunnel connection
tunnel-host = 192.168.1.100

# Target port for the tunnel connection
tunnel-port = 5900

# Protocol to use (tcp or udp, default: tcp)
proto = tcp
```

#### Service Configuration Directory Setup
```bash
# Create the services directory
sudo mkdir -p /etc/wsssh.d/

# Copy example service configurations
sudo cp service.conf.example /etc/wsssh.d/ssh.conf

# Edit the service configuration
sudo editor /etc/wsssh.d/ssh.conf
```

#### Multiple Services Configuration
You can configure multiple services by creating separate configuration files:

```bash
# SSH service
sudo cp service.conf.example /etc/wsssh.d/ssh.conf
sudo editor /etc/wsssh.d/ssh.conf

# RDP service
sudo cp service.conf.example /etc/wsssh.d/rdp.conf
sudo editor /etc/wsssh.d/rdp.conf

# VNC service
sudo cp service.conf.example /etc/wsssh.d/vnc.conf
sudo editor /etc/wsssh.d/vnc.conf
```

## Advanced Usage Examples

### SSH with Custom Options
```bash
# SSH with custom port and additional options
./wsssh -p 2222 user@myclient.example.com -i ~/.ssh/key -o StrictHostKeyChecking=no

# SSH with specific transport
./wsssh --tunnel websocket user@myclient.example.com

# SSH with custom encoding
./wsssh --enc base64 user@myclient.example.com

# Debug mode to see the actual commands
./wsssh --debug user@myclient.example.com

# SSH with tunnel control transport
./wsssh --tunnel-control websocket user@myclient.example.com
```

### SCP with Advanced Options
```bash
# SCP with recursive transfer
./wsscp -r localdir user@myclient.example.com:/remote/path/

# SCP with bandwidth limit
./wsscp -l 1000 localfile user@myclient.example.com:/remote/path/

# SCP with custom transport
./wsscp --tunnel websocket localfile user@myclient.example.com:/remote/path/

# SCP with custom encoding
./wsscp --enc base64 localfile user@myclient.example.com:/remote/path/

# SCP with tunnel control transport
./wsscp --tunnel-control websocket localfile user@myclient.example.com:/remote/path/
```

### Tunnel Setup for Manual Use
```bash
# Setup tunnel and get connection info
./wsssht --clientid myclient --wssshd-host example.com

# Use with any TCP client
telnet localhost 49234
# or
nc localhost 49234
# or
ssh -p 49234 user@localhost

# Tunnel with specific service
./wsssht ssh://myclient@example.com

# Tunnel with custom encoding
./wsssht --enc base64 myclient@example.com

# Silent mode tunnel
./wsssht --silent myclient@example.com

# Bridge mode for programmatic use
./wsssht --bridge myclient@example.com

# Daemon mode for lazy initialization
./wsssht --daemon myclient@example.com
```

### Client Registration Examples
```bash
# Register with basic options
./wssshc --server-ip 192.168.1.100 --port 9898 --id workstation01 --password mysecret

# Register with custom transports
./wssshc --server-ip server.example.com --id laptop01 --password secret --tunnel websocket --tunnel-control websocket

# Register with custom services path
./wssshc --server-ip server.example.com --id client01 --password secret --services-path /etc/wsssh.d/
```

## Security Considerations

- **SSL/TLS Encryption**: All communications are encrypted
- **Client Authentication**: Unique client IDs prevent unauthorized access
- **Password Protection**: Secure client registration with configurable passwords
- **Network Security**: Restrict daemon access to trusted networks
- **Certificate Management**: Use proper CA-signed certificates in production

## Troubleshooting

### Connection Issues
```bash
# Check if wssshd is running
netstat -tlnp | grep :9898

# Test connection
curl -I https://localhost:9898

# Enable debug output
./wsssh --debug user@myclient.example.com
```

### Client Registration Problems
```bash
# Verify client registration
./wssshc --server-ip <ip> --port 9898 --id <client_id> --password <password>

# Check server logs
tail -f /var/log/wssshd/wssshd.log
```

### SSL Certificate Issues
```bash
# Regenerate certificates
./build.sh

# Check certificate validity
openssl x509 -in cert.pem -text -noout
```

## Development

### Building from Source
```bash
# Build all components (C implementation)
./build.sh

# Clean build artifacts
./clean.sh
```

### C Implementation Details
The server component (`wssshd2/`) is implemented in C for maximum performance and minimal dependencies:
- **SQLite Database**: Persistent user management
- **Embedded Web Interface**: No external web server required
- **Native SSL/TLS**: Direct OpenSSL integration
- **Cross-platform**: Linux, macOS, Windows support
- **Web Proxy Server**: Built-in HTTP reverse proxy for client web services

### Project Structure
```
wsssh/
├── build.sh               # Build script for all components
├── clean.sh               # Clean script
├── wssshd2/               # C server implementation
│   ├── main.c            # Server main entry point
│   ├── web.c             # Embedded web interface with SQLite
│   ├── web_proxy.c       # Web proxy server implementation
│   ├── web_proxy.h       # Web proxy header
│   ├── config.c          # Configuration handling
│   ├── config.h          # Configuration header
│   ├── terminal.c        # Terminal session management
│   ├── websocket.c       # WebSocket protocol handling
│   ├── ssl.c             # SSL/TLS encryption
│   ├── tunnel.c          # Tunnel management
│   ├── assets.c          # Embedded web assets
│   ├── html_pages/       # Embedded HTML templates
│   └── Makefile          # Build configuration
├── wssshtools/            # C client tools
│   ├── wssshc.c          # Client registration tool
│   ├── wsssh.c           # SSH wrapper
│   ├── wsscp.c           # SCP wrapper
│   ├── wsssht.c          # Tunnel setup tool
│   ├── libwsssht/        # Shared libraries
│   ├── man/              # Manual pages
│   └── debian/           # Debian packaging
├── wsssh-server/         # Server Debian package
├── CHANGELOG.md          # Version history
├── DOCUMENTATION.md      # Technical documentation
├── TODO.md               # Development tasks
└── README.md             # This file
```

## Support

- **Documentation**: Comprehensive guides in `DOCUMENTATION.md`
- **Man Pages**: Detailed help for all tools (`man wsssh`, `man wsscp`, etc.)
- **Issues**: Report bugs and request features on GitHub
- **Community**: Join discussions and get help

## Donations

If you find WSSSH useful, please consider supporting the project:

### PayPal
Donate via PayPal to: **info@nexlab.net**

### Cryptocurrency
- **Bitcoin (BTC)**: `bc1q3zlkpu95amtcltsk85y0eacyzzk29v68tgc5hx`
- **Ethereum (ETH)**: `0xdA6dAb526515b5cb556d20269207D43fcc760E51`

Your support helps us continue developing and maintaining this open-source project! ❤️

## License

This project is licensed under the GNU General Public License v3.0 (GPLv3).

Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me

See [LICENSE.md](LICENSE.md) for the full license text.