/*
 * WSSSH Library - Control Channel Messages
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef CONTROL_MESSAGES_H
#define CONTROL_MESSAGES_H

#include <openssl/ssl.h>
#include "wssshlib.h"
#include "tunnel.h"

// Function declarations for control channel messages
int send_json_message(SSL *ssl, const char *type, const char *client_id, const char *request_id);
int send_registration_message(SSL *ssl, const char *client_id, const char *password, const char *tunnel, const char *tunnel_control, const char *wssshd_private_ip);
int send_registration_message_with_services(SSL *ssl, const char *client_id, const char *password, const char *tunnel, const char *tunnel_control, const char *wssshd_private_ip, service_config_t **services, int num_services);
int send_tunnel_request_message(SSL *ssl, const char *client_id, const char *request_id, const char *tunnel, const char *tunnel_control, const char *service);
int send_tunnel_request_message_with_enc(SSL *ssl, const char *client_id, const char *request_id, const char *tunnel, const char *tunnel_control, const char *service, wsssh_encoding_t encoding);
int send_tunnel_close_message(SSL *ssl, const char *request_id, int debug);
int send_tunnel_keepalive_message(SSL *ssl, tunnel_t *tunnel, int debug);
int send_tunnel_keepalive_ack_message(SSL *ssl, const char *request_id, int debug);
int send_ping_frame(SSL *ssl, const char *ping_payload, int payload_len);
int send_pong_frame(SSL *ssl, const char *ping_payload, int payload_len);

#endif // CONTROL_MESSAGES_H