/**
 * Terminal and PTY handling for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef TERMINAL_H
#define TERMINAL_H

#include <stdbool.h>
#include <uuid/uuid.h>
#include "config.h"

// Terminal session structure
typedef struct {
    char request_id[37];  // UUID string
    char client_id[256];
    char username[256];
    pid_t proc_pid;
    int master_fd;
    char command[1024];
    char *output_buffer;
    size_t output_size;
    size_t output_used;
    pthread_mutex_t output_mutex;
} terminal_session_t;

// Function declarations
terminal_session_t *terminal_create_session(const wssshd_config_t *config, const char *username, const char *client_id);
void terminal_free_session(terminal_session_t *session);
bool terminal_send_data(terminal_session_t *session, const char *data);
char *terminal_get_output(terminal_session_t *session, size_t *len);
bool terminal_disconnect(terminal_session_t *session);
bool terminal_resize(terminal_session_t *session, int cols, int rows);
bool terminal_is_running(terminal_session_t *session);

#endif /* TERMINAL_H */