/**
 * RDP and WebSocket proxy handling implementation for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef RDP_H
#define RDP_H

#include <stdbool.h>
#include <uuid/uuid.h>
#include "config.h"

typedef struct {
    char request_id[37];
    char client_id[256];
    char username[50];
    int proc_pid;
    int read_fd;  // pipe read end
    int write_fd; // pipe write end
    bool active;
    bool debug_rdp;
    char *output_buffer;
    size_t output_size;
    size_t output_used;
    pthread_mutex_t output_mutex;
} rdp_session_t;

rdp_session_t *rdp_create_session(const wssshd_config_t *config, const char *client_id, const char *username, bool debug_rdp);
void rdp_free_session(rdp_session_t *session);
bool rdp_send_data(rdp_session_t *session, const char *data, size_t len);
char *rdp_get_output(rdp_session_t *session, size_t *len);
bool rdp_disconnect(rdp_session_t *session);
bool rdp_is_running(rdp_session_t *session);

#endif /* RDP_H */