// Example plugin JavaScript
let ws = null;
let uptimeInterval = null;

function initWebSocket() {
    // Connect to the main WebSocket (this would need to be adapted for the actual plugin system)
    // For now, this is just a demonstration
    console.log('Example plugin JavaScript loaded');
}

function sendExampleMessage() {
    if (!ws || ws.readyState !== WebSocket.OPEN) {
        // For demonstration, we'll just show an alert
        alert('WebSocket not connected. In a real plugin, this would send a message to the server.');
        return;
    }

    const message = {
        type: 'example_message',
        data: 'Hello from the web interface!'
    };

    ws.send(JSON.stringify(message));
}

function updateUptime() {
    const uptimeElement = document.getElementById('uptime');
    if (uptimeElement) {
        const currentUptime = parseInt(uptimeElement.textContent) || 0;
        uptimeElement.textContent = currentUptime + 1;
    }
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', function() {
    console.log('Example plugin page loaded');
    uptimeInterval = setInterval(updateUptime, 1000);
});

// Clean up
window.addEventListener('beforeunload', function() {
    if (uptimeInterval) {
        clearInterval(uptimeInterval);
    }
    if (ws) {
        ws.close();
    }
});