/**
 * Embedded web assets for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef ASSETS_H
#define ASSETS_H

#include <stddef.h>
#include "novnc_assets.h"

// Embedded HTML pages
extern const char *index_html;
extern const char *login_html;
extern const char *terminal_html;
extern const char *users_html;
extern const char *vnc_html;

// Embedded JavaScript libraries
extern const char *xterm_js;
extern const char *xterm_addon_fit_js;

// Embedded CSS
extern const char *novnc_css;

// Embedded images
extern unsigned char image_jpg[];
extern unsigned int image_jpg_len;
extern unsigned char favicon_ico[];
extern unsigned int favicon_ico_len;

// Function to get asset by path
const char *get_embedded_asset(const char *path, size_t *size);

// Function to get noVNC assets
const char *get_novnc_asset(const char *path);

#endif /* ASSETS_H */