# WSSSH: Warp-Powered Stefy's Spatial Secure Hyperdrive Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.7.1] - 2025-09-25

### Fixed
- **RDP Web Interface Issues**: Comprehensive fixes for RDP page functionality
  - Fixed buffer overflow in RDP page JavaScript causing connection failures
  - Added proper keyboard and mouse event handling from rdp.wasm example
  - Implemented try-catch blocks around RDP script initialization
  - Added DOM element existence checks and detailed event listener debugging
  - Fixed RDP page buttons not responding to clicks
  - Removed overly restrictive Content Security Policy (CSP) that blocked JavaScript execution
  - Simplified CSP to allow necessary WebAssembly and JavaScript functionality

### Added
- **RDP Testing Tool**: Added `test_rdp_client` for RDP tunneling testing and validation

### Technical Details
- **WebAssembly Integration**: Improved RDP WebAssembly module loading and error handling
- **Event Handling**: Enhanced keyboard and mouse input processing for RDP sessions
- **Security Policy**: Balanced CSP that allows RDP functionality while maintaining security
- **Debug Logging**: Added comprehensive debug logging for RDP connection troubleshooting

## [1.7.0] - 2025-09-21

### Major Changes
- **Complete Architecture Transition**: Migrated from Python/PyInstaller to native C implementation
  - Replaced Python wssshd with high-performance C daemon (`wssshd2/`)
  - Eliminated Python runtime dependencies for server component
  - Maintained full backward compatibility for client tools
  - Improved performance and reduced resource usage

### Added
- **SQLite Database Integration**: Persistent user management with secure storage
  - Automatic database creation and schema management
  - User authentication with password hashing
  - Admin user role management
  - Security warnings for default credentials
  - Database-backed session management

- **Embedded Web Interface**: Self-contained web server with no external dependencies
  - HTML/CSS/JavaScript assets embedded in binary
  - User management interface with add/edit/delete functionality
  - Real-time terminal interface with fullscreen support
  - Responsive Bootstrap-based design
  - AJAX-powered dynamic content updates

- **Enhanced Security Features**:
  - Automatic security warnings for default admin credentials
  - Proper session management with configurable timeouts
  - Input validation and bounds checking
  - Secure password storage with hashing
  - Admin role-based access control

- **Professional ASCII Art**: Startup banner with project branding
- **Comprehensive Debug Options**: Database, web, and general debug logging
- **Smart Directory Selection**: Automatic root vs user directory detection

### Changed
- **Build System**: Complete overhaul for C implementation
  - Updated build.sh to compile C binaries
  - Modified Debian packaging for C dependencies
  - Added SQLite3 and SSL library dependencies
  - Removed Python/PyInstaller build process

- **Package Architecture**: Updated wsssh-server package for C binary
  - Changed from PyInstaller bundle to native C executable
  - Updated dependencies to include libsqlite3-0 and libssl3
  - Modified package description and metadata
  - Updated man pages for C version options

- **Documentation**: Comprehensive updates for C implementation
  - Updated README.md with new architecture details
  - Modified installation instructions for C build process
  - Updated project structure documentation
  - Removed Python-specific references

### Removed
- **Python Server Implementation**: Complete removal of Python wssshd
  - Deleted wssshd.py entry point
  - Removed wsssd/ Python server directory
  - Eliminated templates/ directory (now embedded)
  - Cleaned up Python-specific build artifacts

### Technical Details
- **Performance Improvements**: Native C implementation with direct system calls
- **Memory Efficiency**: Reduced memory footprint compared to Python runtime
- **Startup Time**: Faster daemon initialization and connection handling
- **Security**: Enhanced with proper bounds checking and input validation
- **Maintainability**: Cleaner C codebase with modular architecture

### Migration Notes
- **Backward Compatibility**: All existing client functionality preserved
- **Configuration**: Existing config files remain compatible
- **API Compatibility**: WebSocket protocol unchanged for client connections
- **Database Migration**: Automatic creation of new SQLite database on first run

## [1.6.7] - 2025-09-21

### Fixed
- **Critical Segmentation Fault in wssshd2**: Fixed server crash when wsscp is interrupted during file transfers
  - Root cause: Use-after-free vulnerability when websocket connections were freed while other threads still referenced them
  - Solution: Implemented comprehensive tunnel cleanup when websocket connections close
  - Added immediate connection state updates when receive operations fail
  - Prevented race conditions between connection cleanup and message forwarding
  - Enhanced thread safety with proper mutex protection for all shared data access

### Technical Details
- **Thread Safety**: Added mutex locks to all shared data structures (clients, tunnels, terminals)
- **Connection Lifecycle**: Proper cleanup of tunnel references when websocket connections close
- **Race Condition Prevention**: Immediate connection state updates prevent stale references
- **Memory Safety**: Eliminated use-after-free crashes during client interruptions
- **Server Stability**: wssshd2 now handles client disconnections gracefully without crashing

### Security
- **Memory Corruption Prevention**: Fixed heap corruption that could be exploited
- **Resource Management**: Proper cleanup prevents resource leaks and dangling pointers
- **Server Resilience**: Enhanced resistance to DoS attacks via connection interruption

## [1.6.6] - 2025-09-20

### Fixed
- **Critical Tunnel Communication Corruption**: Fixed data corruption in WebSocket tunnels between wsssht, wssshd, and wssshc
  - Root cause: Inconsistent encoding between components (wsssht used base64, wssshc used hex)
  - Solution: Implemented consistent hex encoding across all tunnel data transmission
  - Added encoding field to tunnel structures for proper encoding negotiation
  - Fixed `handle_tunnel_data()` to decode using correct encoding type instead of guessing
  - Resolved corruption where hex data was incorrectly decoded as base64

### Added
- **Encoding Options for wsssht**: Added `--enc` option to wsssht for data encoding control
  - `--enc hex`: Hexadecimal encoding (default, backward compatible)
  - `--enc base64`: Base64 encoding for efficiency
  - `--enc bin`: Direct binary data transmission
  - Configuration file support with `enc = hex` option in `wsssht.conf`
  - Automatic encoding negotiation between wsssht and wssshc clients

- **Encoding Options for wsssh and wsscp**: Added optional `--enc` option to wsssh and wsscp
  - Accepts `--enc hex|base64|bin` argument and passes it to wsssht ProxyCommand
  - Allows users to specify encoding preference when using wrapper tools
  - Maintains backward compatibility - option is completely optional

### Technical Details
- **Encoding Architecture**: Extensible encoding system with per-tunnel encoding negotiation
- **Data Integrity**: All encoding modes now preserve data integrity during transmission
- **ProxyCommand Enhancement**: wsssh and wsscp now pass encoding options through ProxyCommand
- **Configuration Consistency**: Encoding settings properly propagated through the tunnel chain

### Security
- **Data Transmission Security**: Fixed corruption that could potentially cause data misinterpretation
- **Protocol Compliance**: Proper encoding negotiation prevents data corruption attacks

### Fixed
- **Memory Corruption in wssshd**: Critical fix for heap corruption causing 'malloc(): invalid next size' errors
  - Added bounds checking and validation for parameter extraction in tunnel request parsing
  - Prevented buffer overflows by limiting parameter lengths to reasonable sizes (< 32 chars)
  - Added null pointer and bounds validation before string operations
  - Increased request message buffer size from 512 to 1024 bytes for safety
  - Fixed potential heap metadata corruption from malformed JSON messages

- **Large WebSocket Frame Issues**: Fixed SSL write failures during large file transfers
  - Reduced MAX_CHUNK_SIZE from 65536 (64KB) to 4096 (4KB) bytes
  - Prevents creation of very large WebSocket frames (131KB+) that cause network timeouts
  - Smaller chunks improve network reliability and reduce connection drop issues
  - Hex-encoded 4KB data creates 8KB frames, which are much more network-friendly
  - Maintains transfer performance while improving stability for large files

- **WebSocket Message Parsing Bounds Checking**: Critical security fix for heap corruption
  - Added comprehensive bounds validation to all WebSocket message parsing in wsssht.c and wssshd2/websocket.c
  - Prevents buffer overflows from malformed JSON messages that could corrupt heap metadata
  - Validates all string operations stay within payload buffer limits
  - Added length validation for data fields to prevent excessive memory allocation
  - Protects against crashes from corrupted or malicious WebSocket frames
  - Enhanced error handling with debug logging for malformed messages

- **Server Stability and DoS Protection**: Critical security fix preventing server crashes
  - wssshd server now validates JSON structure before processing messages
  - Added bounds checking for all parameter extractions (client_id, password, request_id, etc.)
  - Implemented reasonable length limits to prevent buffer overflows:
    * client_id: max 64 characters
    * password: max 256 characters
    * request_id: max 64 characters
    * enc/service/version: max 32 characters each
  - Server logs errors and continues running instead of crashing on malformed packets
  - Defense against DoS attacks via crafted WebSocket messages
  - Heap corruption prevention through validated memory operations

## [1.6.5] - 2025-09-19

### Added
- **Flexible Data Encoding Support**: New `--enc` option for wsssht with multiple encoding modes
  - `--enc hex`: Hexadecimal encoding of binary data (default, backward compatible)
  - `--enc base64`: Base64 encoding of binary data for better efficiency
  - `--enc bin`: Direct binary data transmission without encoding
  - Configuration file support with `enc = hex` option in `wsssht.conf`
  - Automatic encoding negotiation between wsssht and wssshc clients

### Enhanced
- **Tunnel Data Handling**: Improved data channel message processing
  - wssshc now parses `enc` attribute from tunnel requests
  - Support for multiple encoding formats in tunnel data messages
  - Backward compatibility maintained with existing hex encoding
  - Enhanced error handling for unsupported encoding modes

### Technical Details
- **Encoding Architecture**: Extensible encoding system with weight-based selection
  - Clean separation between encoding modes and data transmission
  - Efficient binary data handling for high-performance applications
  - JSON message format updates to include encoding specifications
  - Server-side forwarding maintains data integrity across all encoding modes

### Security
- **Data Integrity**: All encoding modes preserve data integrity during transmission
- **Protocol Compliance**: Proper JSON message formatting for all encoding types
- **Backward Compatibility**: Existing installations continue to work without changes

## [1.6.2] - 2025-09-19

### Fixed
- **Tunnel Close Forwarding**: Critical fix for tunnel closure synchronization between wssshc, server, and wsssht
  - Server now properly forwards `tunnel_close` messages from wssshc to wsssht
  - Prevents wsssht processes from hanging after client-initiated tunnel closure
  - Ensures proper cleanup of tunnel resources on all endpoints
  - Fixed server-side tunnel close message routing in `wsssd/websocket.py`

- **Web Terminal JavaScript Issues**: Comprehensive fixes for web interface terminal functionality
  - Fixed `FitAddon` loading issues by switching from jsdelivr to unpkg CDN
  - Resolved JavaScript variable scoping error (`fitAddon` undefined) in terminal initialization
  - Added proper error handling for xterm.js library loading failures
  - Enhanced debug logging for library loading and terminal initialization
  - Improved cross-browser compatibility for xterm.js components

- **Logo Serving Path**: Fixed web interface logo loading from correct directory
  - Updated Flask routes to serve logo files from `logos/` directory instead of root
  - Added proper PyInstaller support for bundled logo assets
  - Fixed favicon.ico and image.jpg serving for both development and frozen executables

### Added
- **Fullscreen Terminal Support**: Enhanced web terminal with fullscreen toggle functionality
  - Added fullscreen toggle button (⛶/⛝) to terminal interface header
  - Cross-browser fullscreen API support (Chrome, Firefox, Safari, IE11)
  - Automatic terminal resizing when entering/exiting fullscreen mode
  - Backend synchronization of terminal dimensions during fullscreen changes
  - Proper event handling for fullscreen state changes

### Enhanced
- **Web Terminal User Experience**: Improved terminal interface with better controls and responsiveness
  - Added fullscreen button with dynamic icon changes based on state
  - Enhanced terminal resizing with proper backend dimension updates
  - Improved error handling and user feedback for terminal operations
  - Better visual feedback for terminal state changes

### Technical Details
- **Tunnel Close Protocol**: Server now correctly forwards tunnel close messages to both endpoints
- **JavaScript Library Management**: Robust xterm.js loading with fallback CDN and error recovery
- **Fullscreen API**: Comprehensive browser compatibility with proper event handling
- **Asset Management**: Proper static file serving for both development and production environments

## [1.6.1] - 2025-09-18

### Changed
- **Major Code Refactoring**: Complete modularization of `wsssht.c` for improved maintainability
  - Split monolithic 2769-line `wsssht.c` into modular components in `libwsssht/` directory
  - Created `utils.h/c`: Utility functions (print_usage, parse_connection_string, parse_args)
  - Created `modes.h/c`: Mode-specific functions (bridge, script, daemon modes)
  - Created `threads.h/c`: Thread-related functions and structures
  - Created `wsssht.h`: Main header with includes and declarations
  - Reduced main `wsssht.c` to 674 lines (75% size reduction)
  - Maintained 100% backward compatibility and functionality

### Technical Details
- **Modular Architecture**: Clean separation of concerns with focused, single-responsibility modules
- **Build System Updates**: Updated `configure.sh` and `Makefile` to handle new modular structure
- **Code Organization**: Improved developer experience with logical code grouping
- **Maintainability**: Easier debugging, testing, and feature development
- **Documentation**: Updated build system documentation for new structure

## [1.6.0] - 2025-09-18

### Added
- **Multiple Operating Modes**: Complete implementation of various operating modes for wsssht
  - **Interactive Mode**: Standard interactive SSH/SCP sessions (default)
  - **Silent Mode**: Suppresses all informational output for automation
  - **Bridge Mode**: JSON-based communication over stdin/stdout for programmatic use
  - **Script Mode**: JSON protocol with status updates and command processing
  - **Daemon Mode**: Lazy tunnel initialization for resource efficiency
- **Bridge Mode Implementation**: JSON stdin/stdout interface
  - Real-time JSON status updates during tunnel establishment
  - Command processing from stdin with JSON responses
  - Structured error reporting and connection status
  - **Tunnel control channel messages are communicated through stdin/stdout** (JSON protocol)
  - **Tunnel data channel messages remain handled by wsssht** (normal forwarding)
  - Perfect for programmatic integration and automation
- **Script Mode Implementation**: JSON protocol for scripting
  - Periodic status updates (every 30 seconds)
  - Script command processing (`status`, `quit`, `exit`)
  - Timestamped events for monitoring and logging
  - JSON-formatted output for easy parsing by scripts
- **Daemon Mode Implementation**: Lazy tunnel initialization
  - Waits for first connection attempt before establishing tunnel
  - Resource-efficient operation with on-demand tunnel creation
  - Seamless transition to normal operation after first connection
  - Reduced resource usage for intermittent connections
- **Configuration Support**: Extended config file support for new modes
  - `mode` and `daemon` options in `[wssht]` section
  - Command-line options override config file values
  - Backward compatibility with existing configurations

### Enhanced
- **Command-Line Interface**: Extended CLI with new operating mode options
  - `--mode` option with values: interactive, silent, bridge, script
  - Shortcut options: `--silent`, `--bridge`, `--script`, `--daemon`
  - Comprehensive help text and usage examples
  - Updated man pages with new option documentation
- **Configuration System**: Enhanced configuration file support
  - New `[wssht]` section for wsssht-specific options
  - Support for mode and daemon configuration
  - Updated example configuration files
- **Error Handling**: Improved error handling and user feedback
  - Better validation of operating mode parameters
  - Clear error messages for invalid configurations
  - Graceful handling of mode-specific errors

### Technical Details
- **Mode Architecture**: Extensible operating mode system
  - Clean separation of mode-specific logic
  - Shared infrastructure for all operating modes
  - Consistent behavior across different modes
- **JSON Protocol**: Standardized JSON message format
  - Structured status updates and error reporting
  - Timestamped events for monitoring
  - Easy integration with external tools and scripts
- **Resource Management**: Optimized resource usage
  - Lazy initialization reduces startup overhead
  - Efficient memory management across all modes
  - Proper cleanup and resource deallocation

### Documentation
- **README.md**: Updated with comprehensive operating mode documentation
  - Detailed descriptions of each operating mode
  - Usage examples for all modes
  - Configuration examples and best practices
- **Man Pages**: Enhanced manual pages with new options
  - Complete documentation of all new command-line options
  - Updated examples and configuration sections
  - Clear explanations of operating mode differences

## [1.5.0] - 2025-09-17

### Added
- **Peer-to-Peer Tunneling Architecture**: Complete implementation of advanced tunneling system with transport selection
  - Added `--tunnel` option to wsssh and wsscp for data channel transport specification
  - Added `--tunnel-control` option to wsssh, wsscp, and wssshc for control channel transport specification
  - Added `--service` option to wsssh and wsscp for service type specification (default: "ssh")
  - Implemented transport definitions with `is_relay` property and weight-based selection
  - Added WebSocket transport with `is_relay=true` as the primary transport implementation
  - Created comprehensive transport selection logic with weight-based prioritization
  - Implemented "any" transport option that expands to all available transports
  - Added transport list expansion function for proper "any" option handling

### Enhanced
- **Configuration System**: Extended configuration file support for new tunneling options
  - Added `tunnel`, `tunnel-control`, and `service` options to wsssh.conf.example
  - Added `tunnel` and `tunnel-control` options to wsscp.conf.example
  - Enhanced INI-style config parsing with new transport configuration keys
  - Maintained backward compatibility with existing configuration files

- **Server-Side Architecture**: Comprehensive updates to wsssd for advanced tunneling support
  - Modified `Tunnel` class in `wsssd/tunnel.py` with new transport attributes
  - Updated tunnel status object to include `tunnel`, `tunnel_control`, and `service` properties
  - Enhanced tunnel request message handling in `wsssd/websocket.py`
  - Added transport selection and data channel logic for peer-to-peer connections
  - Implemented proper IP address detection and tunnel status tracking

- **Client-Side Implementation**: Complete C implementation updates for tunneling features
  - Updated `wsssh.c` with new command-line options and config file support
  - Updated `wsscp.c` with new command-line options and config file support
  - Updated `wssshc.c` with transport options and wssshd_private_ip parameter
  - Enhanced `wssshlib.c` with transport list expansion functionality
  - Modified tunnel request messages to include transport specifications
  - Added proper transport negotiation and selection logic

### Technical Details
- **Transport System**: Implemented extensible transport architecture with weight-based selection
  - Transport types include `websocket` with `is_relay=true` property
  - Weight-based prioritization (lower numbers = higher priority)
  - Automatic fallback to next available transport on connection failure
  - Support for comma-separated transport lists and "any" expansion

- **Message Format Updates**: Enhanced JSON message formats for tunneling
  - Updated tunnel_request messages to include transport specifications
  - Added transport negotiation in registration messages
  - Maintained backward compatibility with existing message formats
  - Proper error handling for transport-related failures

- **Configuration Management**: Comprehensive config file support
  - INI-style configuration files with hierarchical precedence
  - Command-line options override config file values
  - Optional parameters become required only when not provided in config
  - Enhanced error messages for missing configuration

### Fixed
- **Transport List Expansion**: Critical fix for "any" transport option
  - Implemented `expand_transport_list()` function in `wssshlib.c`
  - Proper expansion of "any" to available transport lists based on channel type
  - Fixed transport negotiation between clients and server
  - Resolved issues with transport selection and fallback logic

- **PyInstaller Template Loading**: Fixed Flask template loading in frozen executables
  - Added `sys` import to `wsssd/web.py` for frozen executable detection
  - Implemented proper template and static folder configuration for PyInstaller bundles
  - Added `app.template_folder` and `app.static_folder` configuration for frozen executables
  - Fixed template loading issues when running wssshd as a standalone executable
  - Ensured web interface works correctly in both development and production environments

### Documentation
- **Man Pages**: Updated all manual pages with new tunneling options
  - Enhanced `wsssh.1` with `--tunnel`, `--tunnel-control`, and `--service` options
  - Enhanced `wsscp.1` with `--tunnel`, `--tunnel-control`, and `--service` options
  - Enhanced `wssshc.1` with `--tunnel` and `--tunnel-control` options
  - Added comprehensive option descriptions and usage examples

### Performance
- **CPU Usage Optimization**: Significantly reduced CPU usage during file transfers
  - Increased select() timeout from 50ms to 200ms in tunnel forwarding threads
  - Reduced polling frequency by 75% to minimize CPU overhead during data transfers
  - Maintained responsiveness while dramatically improving efficiency for bulk transfers
- **Multi-Core CPU Utilization**: Enhanced thread distribution across CPU cores
  - Implemented CPU affinity management for tunnel forwarding threads
  - Added round-robin CPU core assignment to distribute load across available cores
  - Improved parallel processing capabilities for multiple concurrent tunnels

### Technical Details
- **Import Management**: Added explicit `websockets` import to server.py for PyInstaller compatibility
- **Async Task Cleanup**: Proper awaiting of cancelled asyncio tasks to prevent runtime warnings
- **Global Variable Isolation**: Resolved PyInstaller global variable sharing limitations by using parameter passing
- **Function Signature Compatibility**: Updated websocket handler to use keyword-only parameters for `functools.partial` binding
- **I/O Efficiency**: Optimized select() polling intervals to balance responsiveness with CPU efficiency
- **Transport Architecture**: Extensible design ready for future transport implementations
- **Configuration Hierarchy**: Proper precedence handling between command-line and config file options

## [1.4.8] - 2025-09-17

### Fixed
- **Critical SSL Connection Stability Issues**: Comprehensive SSL error handling and connection resilience improvements
  - Fixed WebSocket frame sending failures that caused connection drops
  - Added detailed SSL error reporting with specific error codes and descriptions
  - Implemented automatic retry logic for transient SSL errors (SSL_ERROR_WANT_READ/WRITE)
  - Added 5-second timeout protection for SSL read operations to prevent indefinite hangs
  - Enhanced connection state validation before SSL operations
  - Improved WebSocket frame transmission with retry mechanisms and partial write handling

### Technical Details
- **SSL Error Diagnostics**: Enhanced error reporting using `SSL_get_error()` and `ERR_error_string_n()`
- **Connection Resilience**: Automatic retry for temporary network issues with configurable limits
- **Timeout Protection**: Non-blocking SSL operations with proper timeout handling
- **WebSocket Frame Reliability**: Robust frame transmission with error recovery and completion checking
- **Cross-Tool Consistency**: Applied improvements to all three C tools (wssshc, wsssh, wsscp)

### Changed
- **Error Output Format**: Standardized SSL error messages across all tools for better debugging
- **Connection Handling**: Improved resilience to network interruptions and temporary disconnections
- **Debug Information**: Enhanced diagnostic output with specific error codes and retry information

## [1.4.7] - 2025-09-16

### Fixed
- **Critical Process Exit Bug**: Fixed wsssh process hanging after SSH client disconnection
  - Added `broken` flag to tunnel structure to distinguish between normal closure and broken connections
  - Implemented proper tunnel state tracking for EBADF, EPIPE, and ECONNRESET errors
  - Enhanced error handling in `handle_tunnel_data()` for SSH client disconnections
  - Fixed main loop to immediately kill SSH child process and exit when tunnel breaks
  - Added proper exit code handling: 0 for normal termination, 1 for error conditions
  - Prevented indefinite hanging of wsssh process after tunnel failures

### Technical Details
- **Tunnel State Management**: Added `int broken` field to `tunnel_t` structure for connection state tracking
- **Error Detection**: Enhanced detection of broken SSH connections with proper error classification
- **Process Management**: Improved SSH child process termination logic with immediate cleanup
- **Exit Code Standards**: Implemented standard exit codes (0=success, 1=error) for better automation support
- **Memory Management**: Maintained proper cleanup of tunnel resources in all exit paths

## [1.4.6] - 2025-09-16

### Added
- **Code Refactoring and Library Architecture**: Major refactoring to eliminate code duplication
  - Created shared libraries: `wssshlib.h/.c`, `websocket.h/.c`, `wssh_ssl.h/.c`, `tunnel.h/.c`
  - Extracted ~1500+ lines of duplicate code between wsssh.c and wssshc.c
  - Improved maintainability and code organization with modular architecture
  - Enhanced build system with proper library dependencies

- **SSH Tunneling Improvements**: Enhanced SSH tunnel handling and error recovery
  - Added specific handling for EBADF (Bad file descriptor) errors
  - Improved error handling in handle_tunnel_data for SSH client disconnections
  - Removed aggressive socket validation causing SSH client disconnections
  - Fixed SSH client socket invalidation issue in handle_tunnel_data
  - Added missing SSH client accept() logic in wsssh socket handling
  - Fixed SSH tunneling timing issue with proper data buffering
  - Implemented correct SSH tunneling architecture for wssshc
  - Fixed critical architectural issue in wssshc tunnel handling
  - Enhanced error handling for broken SSH connections

- **Port Option Behavior Correction**: Fixed critical port option behavior
  - `-p`/`-P` options now correctly specify wssshd server port (not SSH/SCP server port)
  - Removed misleading "passed through to ssh/scp" documentation
  - Updated help text to clearly indicate port options are consumed by wsssh/wsscp
  - Fixed argument parsing to properly handle wssshd server port specification

### Changed
- **C Implementation Architecture**: Refactored wsssh.c and wsscp.c to use shared libraries
  - Both tools now link against common libraries for WebSocket, SSL, and tunnel management
  - Reduced binary size and improved memory efficiency
  - Enhanced code reusability and maintainability
  - Consistent behavior between wsssh and wsscp implementations

- **Help Documentation**: Updated help output for both wsssh and wsscp
  - Removed duplicate "Options:" sections
  - Consolidated all options into single, clean "Options:" section
  - Corrected port option descriptions to reflect actual behavior
  - Improved user experience with clearer documentation

### Technical Details
- **Library Dependencies**: New build system properly links wsssh and wsscp against shared libraries
- **Code Deduplication**: Eliminated redundant implementations of WebSocket, SSL, and tunnel functions
- **SSH Tunnel Stability**: Enhanced tunnel reliability with improved error handling and connection management
- **Port Handling**: Fixed hostname parsing and port precedence logic
- **Build System**: Updated configure.sh and Makefile to handle new library structure
- **Backward Compatibility**: All existing functionality preserved, new features are additive

## [1.4.5] - 2025-09-16

### Removed
- **Python Implementations**: Removed Python implementations of wssshc, wsssh, and wsscp
  - Deleted wssshc.py, wsssh.py, and wsscp.py files
  - Removed pyinstaller commands from build.sh for these tools
  - Updated Debian packaging to exclude Python script installations
  - Cleaned up documentation and project structure references
  - Maintained C implementations in wssshtools/ directory

### Changed
- **Build System**: Updated build.sh to only build C tools and wssshd daemon
- **Documentation**: Updated README.md, DOCUMENTATION.md, and project structure to reflect C-only implementations
- **Debian Packaging**: Modified wssshtools/debian/rules to only install wssshd.py and C tools

### Technical Details
- **C Implementation Focus**: Project now focuses exclusively on C implementations for better performance and minimal dependencies
- **Build Simplification**: Removed Python binary building from build process
- **Package Structure**: wsssh-tools package now contains only C tools and wssshd daemon

## [1.4.4] - 2025-09-15

### Added
- **Advanced Logging with Logrotate**: Comprehensive logging system for all daemons
  - Added `/var/log/wssshd/wssshd.log` for main daemon logging with automatic rotation
  - Added `/var/log/wssshc/wssshc.log` for client daemon logging with automatic rotation
  - Configured logrotate with weekly rotation, 52-week retention, and automatic compression
  - Proper file permissions and ownership for security
  - HUP signal handling for log reopening after rotation

- **Init Script Logging Integration**: Enhanced init scripts to redirect output to log files
  - Modified `wssshd.init` to use `start-stop-daemon --output` for proper log redirection
  - Modified `wssshc.init` to redirect output to log files (already implemented)
  - Ensured correct PID storage while maintaining log redirection
  - Fallback mechanisms for different start-stop-daemon versions

- **Logrotate Configuration Files**: Professional log management configuration
  - `/etc/logrotate.d/wssshd` - Configuration for wssshd daemon logs
  - `/etc/logrotate.d/wssshc` - Configuration for wssshc client logs
  - Automatic post-rotation HUP signals to daemons
  - Proper error handling and missing file tolerance

### Changed
- **Service Management**: Init scripts now properly redirect stdout and stderr to log files
- **Log Management**: All daemon output is now captured in managed log files
- **System Integration**: Complete integration with Debian's logrotate system

### Technical Details
- **Log File Locations**:
  - wssshd: `/var/log/wssshd/wssshd.log`
  - wssshc: `/var/log/wssshc/wssshc.log`
  - Watchdog logs: `/var/log/wssshd/watchdog.log` and `/var/log/wssshc/watchdog.log`

- **Log Rotation Policy**:
  - Weekly rotation schedule
  - 52 weeks (1 year) retention period
  - Automatic gzip compression
  - Delayed compression for immediate access to recent logs
  - Proper file ownership (wssshd:wssshd, wssshc:wssshc)

- **Init Script Improvements**:
  - Used `start-stop-daemon --output` option for wssshd
  - Maintained backward compatibility with existing installations
  - Proper error handling for different start-stop-daemon versions

### Security
- **File Permissions**: Log files created with secure permissions (644)
- **User Isolation**: Proper user/group ownership for log files
- **Log Integrity**: Automatic log rotation prevents log file manipulation

## [1.4.4] - 2025-09-15

### Added
- **Dynamic Terminal Sizing**: Web terminal now properly calculates and uses actual browser window dimensions
- **Terminal Resize Support**: Real-time terminal resizing when browser window is resized
- **Force Echo Mode**: SSH connections now force echo mode for better visibility
- **Logrotate Integration**: Both wssshd and wssshc now properly redirect output to log files managed by logrotate
- **Enhanced Logging**: Improved logging configuration with proper log rotation policies

### Fixed
- **Terminal Dimensions**: Fixed hardcoded 24x80 terminal dimensions, now uses actual browser window size
- **Echo Handling**: Resolved password echo issues by letting SSH server control echo behavior
- **Log File Management**: Proper log file rotation and management for daemon processes
- **Web Terminal Applications**: Applications like `top`, `htop`, `vim` now use full terminal area

### Technical Improvements
- **Backend Terminal Sizing**: wssshd.py now accepts and uses dynamic terminal dimensions from frontend
- **Resize API Endpoint**: New `/terminal/<client_id>/resize` endpoint for dynamic resizing
- **Signal Handling**: Proper SIGWINCH signal handling for SSH process size updates
- **Logrotate Configuration**: Added wssshd.log and wssshc.log to respective logrotate configurations
- **Init Script Updates**: Modified init scripts to redirect output to log files with proper permissions

## [1.4.3] - 2025-09-14

### Fixed
- **Debian Package Build System**: Comprehensive fixes for wsssh-server package building
  - Fixed Makefile syntax error in debian/rules by replacing here document with echo commands
  - Resolved "missing separator" error caused by tab characters in PyInstaller spec generation
  - Removed redundant debian/compat file causing debhelper compatibility conflicts
  - Added automatic directory creation in install target to prevent "No such file or directory" errors
  - Implemented binary reuse logic to avoid unnecessary rebuilds of wssshd binary
  - Enhanced build efficiency by copying existing binaries from dist/ directory when available

- **Build Script Improvements**: Enhanced --server-only option functionality
  - Fixed --server-only to automatically enable Debian package building
  - Updated build logic to properly build wsssh-server package when --server-only is used
  - Improved output messages to show wsssh-server package status
  - Added proper dependency checking and error reporting for Debian builds

### Technical Details
- **Makefile Fixes**: Replaced problematic here document with individual echo commands to avoid tab interpretation issues
- **Binary Reuse**: Added logic to check for existing wssshd binary and copy instead of rebuild
- **Directory Management**: Ensured all necessary directories are created before file installation
- **Debhelper Compatibility**: Removed conflicting compat file specification
- **Build Efficiency**: Reduced build times by reusing existing binaries when possible

### Changed
- **Build System**: --server-only option now properly builds wsssh-server Debian package
- **Package Building**: More robust error handling and directory creation
- **Binary Management**: Intelligent reuse of existing build artifacts

## [1.4.1] - 2025-09-13

### Added
- **Watchdog Scripts for High Availability**: Professional daemon monitoring and automatic restart
  - `wssshd-watchdog`: Comprehensive watchdog script for wssshd daemon
    - Monitors daemon process health every 30 seconds
    - Automatic restart on failure with configurable limits
    - Prevents restart loops with 5-restart limit per 5-minute window
    - Detailed logging to /var/log/wssshd/watchdog.log
    - Proper signal handling and cleanup
    - Integration with syslog for system monitoring
  - `wssshc-watchdog`: Watchdog script for wssshc client daemon
    - Identical functionality to wssshd-watchdog
    - Monitors wssshc process and restarts on failure
    - Logging to /var/log/wssshc/watchdog.log
    - Configurable restart limits and intervals

- **Enhanced Init Scripts**: Updated init scripts to use watchdog for daemon management
  - Modified `/etc/init.d/wssshd` to launch daemon through watchdog
  - Modified `/etc/init.d/wssshc` to launch client through watchdog
  - Proper watchdog PID file management
  - Enhanced status reporting showing both daemon and watchdog status
  - Seamless integration with existing service management

- **Professional Service Management**: Enterprise-grade daemon supervision
  - Automatic daemon restart on unexpected termination
  - Configurable monitoring intervals and restart policies
  - Comprehensive logging for troubleshooting and monitoring
  - Non-blocking watchdog operation that doesn't interfere with normal service
  - Proper resource cleanup and signal handling

### Changed
- **Init Script Architecture**: Init scripts now manage watchdog processes instead of daemons directly
- **Service Control**: Enhanced service status reporting with watchdog information
- **Process Management**: Improved process supervision with automatic recovery
- **Logging Integration**: Watchdog logs integrated with system syslog

### Technical Details
- **Watchdog Implementation**: Shell-based watchdog with robust error handling
  - Process health monitoring via PID file validation
  - Configurable check intervals (default: 30 seconds)
  - Restart limit enforcement to prevent infinite loops
  - Proper daemon user/group context preservation
  - Signal-based communication and cleanup

- **System Integration**: Complete integration with Debian init system
  - Watchdog scripts installed to /usr/sbin/
  - Proper file permissions and ownership
  - Integration with package postinst scripts
  - Automatic directory creation and permission setting

- **Configuration Management**: Watchdog behavior controlled via /etc/default files
  - START=yes/no control for service enablement
  - Additional configuration options for watchdog behavior
  - Backward compatibility with existing configurations

### Security
- **Process Isolation**: Watchdog runs with same user/group as monitored daemon
- **File Permissions**: Proper ownership and permissions for watchdog scripts
- **Logging Security**: Secure logging without exposing sensitive information
- **Resource Limits**: Built-in protections against restart loops and resource exhaustion

### Fixed
- **Service Reliability**: Automatic recovery from daemon crashes and failures
- **Process Monitoring**: Proper detection of daemon process termination
- **Resource Management**: Clean PID file management and process cleanup
- **Error Handling**: Robust error handling for various failure scenarios

## [1.4.0] - 2025-09-13

### Added
- **wsssh-server Debian Package**: Complete Debian package for wssshd daemon
  - PyInstaller binary packaging for standalone deployment
  - Comprehensive init script with wssshd user/group support
  - Automatic user/group creation during installation
  - Proper directory structure and permissions
  - Integration with Debian init system and rc2.d
  - /etc/default/wssshd configuration file
  - Professional postinst/postrm scripts for system integration

- **wssshd Man Page**: Complete manual page for wssshd daemon
  - Comprehensive command-line options documentation
  - Configuration file format and examples
  - Web interface usage instructions
  - Security considerations and best practices
  - Signal handling and troubleshooting information

- **Enhanced Build System**: Updated build.sh for wsssh-server package support
  - --server-only option builds only wssshd and wsssh-server package
  - Separate wsssh-server and wsssh-tools package building
  - Improved dependency checking for Python and Debian build tools
  - Better output formatting and package availability reporting

### Changed
- **Package Architecture**: Split into wsssh-server (daemon) and wsssh-tools (clients) packages
- **Build System**: Enhanced build.sh to support selective package building
- **Documentation**: Updated man pages and help text for new package structure

### Technical Details
- **Debian Packaging**: Professional multi-package Debian distribution
- **PyInstaller Integration**: Automated binary creation with dependency bundling
- **System Integration**: Complete init script and service management
- **Security**: Dedicated wssshd user/group with minimal privileges
- **Configuration**: Hierarchical configuration with /etc/default support

### Fixed
- **Package Separation**: Clean separation between server and client components
- **Build Dependencies**: Proper dependency checking and error reporting
- **Service Management**: Robust init script with proper error handling

## [1.3.4] - 2025-09-13

### Added
- **Enhanced WebSocket Connection Management**: Robust ping/pong frame handling and automatic reconnection
  - Fixed ping frame parsing in wsssh.c to properly handle WebSocket ping frames
  - Added automatic pong responses with correct payload echoing
  - Implemented WebSocket reconnection logic for both wsssh.c and wsscp.c
  - Added --interval option for configurable connection retry intervals
  - Smart timing: 1-second WebSocket reconnections vs 30-second initial connection retries

- **Connection Resilience Features**:
  - Automatic WebSocket reconnection during active tunnel operations
  - Configurable retry intervals with --interval option (default: 30 seconds)
  - Up to 3 reconnection attempts with proper error handling
  - Seamless tunnel recovery without disrupting active SSH/SCP sessions
  - Enhanced debug logging for connection state changes

### Changed
- **wsssh.c and wsscp.c Connection Handling**: Both tools now support automatic WebSocket reconnection
- **Ping Frame Processing**: Fixed parse_websocket_frame function to accept ping frames (0x89)
- **Reconnection Timing**: Fast 1-second intervals for WebSocket reconnections, configurable intervals for initial setup
- **Error Recovery**: Improved resilience to network interruptions and temporary disconnections

### Technical Details
- **WebSocket Protocol Compliance**: Proper ping/pong frame handling with RFC 6455 compliance
- **Reconnection Logic**: reconnect_websocket() function for seamless connection recovery
- **Configuration Options**: Added --interval parameter to both wsssh and wsscp
- **Backward Compatibility**: All existing functionality preserved, new features are additive
- **Cross-Tool Consistency**: Identical reconnection behavior between wsssh and wsscp

### Fixed
- **Ping Frame Parsing**: wsssh.c now correctly parses and responds to WebSocket ping frames
- **Connection Recovery**: Automatic reconnection when WebSocket connections are lost
- **Tunnel Stability**: Improved tunnel reliability during network interruptions

## [1.3.2] - 2025-09-13

### Added
- **wssshd Configuration File Support**: Added INI-formatted config file `/etc/wssshd.conf` for wssshd daemon
  - Default host, port, password, domain, web-port, web-host, and web-https settings
  - Command line arguments take precedence over config file values
  - System-wide configuration for server deployment
- **Enhanced wssshd Deployment**: wssshd now supports config file for easier system integration
  - Support for all daemon parameters in config file
  - Automatic config file detection at `/etc/wssshd.conf`
  - Improved server configuration management

### Changed
- **wssshd Parameter Handling**: Command line options override config file values, config file provides defaults
- **wssshd Configuration**: Added system-wide config file support for better deployment practices
- **Cross-Component Consistency**: All components now support config file configuration

### Technical Details
- **Config File Location**: `/etc/wssshd.conf` for system-wide wssshd configuration
- **Config File Format**: INI format with `[wssshd]` section
- **Implementation**: Added config file parsing to wssshd.py using configparser
- **Backward Compatibility**: All existing functionality preserved, config file is optional

## [1.3.2] - 2025-09-13

### Added
- **Enhanced Client Registration Management**: Improved wssshd client disconnection handling
  - Clients are marked as "disconnected" instead of immediately removed from registry
  - 30-second timeout before removing expired client registrations
  - Automatic cleanup of expired clients with periodic background task
  - Better resilience to temporary network disconnections

- **Improved Debug Message Clarity**: Enhanced debug output to distinguish between protocol levels
  - `[WebSocket]` prefix for WebSocket-level messages and events
  - `[TCP Tunnel]` prefix for TCP tunnel-level messages and events
  - Clear separation between close frame handling and tunnel operations
  - More detailed logging for connection state changes

### Changed
- **WebSocket Close Frame Handling**: Close frames no longer immediately terminate client registration
  - Close frames trigger reconnection rather than client removal
  - Client registration persists during temporary disconnections
  - Improved reliability for unstable network conditions

- **Debug Output Format**: Standardized debug message format across all components
  - Consistent prefix system for different protocol layers
  - Clear indication of message source and type
  - Better troubleshooting capabilities

### Technical Details
- **Client Registry Structure**: Enhanced client storage with status and timestamp tracking
  - `clients[client_id] = {'websocket': ws, 'last_seen': timestamp, 'status': 'active'|'disconnected'}`
  - Automatic status transitions based on connection state
  - Timestamp-based expiration for disconnected clients

- **Background Cleanup**: Asynchronous cleanup task running every 10 seconds
  - Removes clients disconnected for more than 30 seconds
  - Maintains registry cleanliness without affecting active connections
  - Non-blocking operation that doesn't interfere with normal processing

- **Web Interface Updates**: Enhanced client status display in web management interface
  - Shows client connection status (active/disconnected)
  - Displays last seen timestamp for disconnected clients
  - Improved API responses with detailed client information

### Security
- **Connection State Tracking**: Better monitoring of client connection states
- **Timeout-based Cleanup**: Prevents accumulation of stale client registrations
- **Maintained Security**: All existing security measures preserved during improvements

## [1.3.1] - 2025-09-13

### Added
- **wssshc Configuration File Support**: Extended INI-formatted config file `~/.config/wsssh/wssshc.conf` to include wssshc parameters
  - Default password, domain, server-ip, port, and id settings for wssshc
  - Command line arguments take precedence over config file values
  - Optional parameters become required only when not provided in config or command line
- **Enhanced wssshc Flexibility**: wssshc now supports config file defaults for all parameters
  - Support for both `server-ip` and `domain` config options (server-ip takes precedence)
  - Automatic fallback to config values when command line options are omitted
  - Improved user experience with optional command line parameters

### Changed
- **wssshc Parameter Handling**: Command line options override config file values, config file provides defaults
- **wssshc Error Messages**: Updated to reflect optional nature of parameters when config is available
- **Cross-Implementation Consistency**: Both Python and C versions of wssshc support identical config file format

### Technical Details
- **Config File Format**: Extended INI format with `[wssshc]` section for wssshc-specific parameters
- **Implementation**: Added config file parsing to both Python (configparser) and C (custom parser) versions
- **Backward Compatibility**: All existing functionality preserved, config file is optional

## [1.3.0] - 2025-09-13

### Added
- **Configuration File Support**: Added INI-formatted config file `~/.config/wsssh/wsssh.conf`
  - Default port and domain settings for wsssh and wsscp
  - Command line arguments take precedence over config file
  - Domain fallback to config when not specified in command line
  - Port fallback to config when not specified via -p/-P options
- **Enhanced CLI Flexibility**: Improved hostname parsing with config-based defaults
  - Support for `user@client` format using config domain
  - Support for `user@client.domain` format overriding config domain
  - Automatic port resolution: command line > config file > error

### Changed
- **Port Precedence**: Command line `-p`/`-P` options override config file port
- **Domain Precedence**: Command line domain specification overrides config domain
- **Error Handling**: Better error messages when port/domain cannot be determined

### Technical Details
- **Config File Format**: Simple INI format with `[default]` section
- **Cross-Implementation**: Consistent behavior between Python and C versions
- **Backward Compatibility**: All existing functionality preserved

## [1.2.0] - 2025-09-13

### Changed
- Improved quality and resolution of all logo and icon assets in the `logos/` directory
- Minor enhancements and optimizations to `wssshtools/wsssh.c` and `wssshtools/wssshc.c` implementations

### Added
- `clean` script for comprehensive cleanup of build artifacts (renamed from clean.sh for consistency)

## [1.1.0] - 2024-09-12

### Added
- **C Implementation**: Complete C version of all tools (`wssshtools/` directory)
  - `wssshc.c`: Lightweight C client for registration (280 lines)
  - `wsssh.c`: Native SSH wrapper with hostname parsing (378 lines)
  - `wsscp.c`: Native SCP wrapper with file transfer support (418 lines)
  - `configure.sh`: Automated build configuration script
  - `Makefile`: GNU Make build system with OpenSSL integration
- **Debian Packaging**: Professional Debian package creation
  - `debian/control`: Package metadata with proper dependencies
  - `debian/rules`: Debhelper build rules
  - `debian/changelog`: Package changelog
  - `debian/copyright`: Copyright and licensing information
  - `debian/compat`: Debhelper compatibility level
- **Simplified CLI**: Removed requirement to specify "ssh"/"scp" commands
  - `wsssh user@host` instead of `wsssh ssh user@host`
  - `wsscp source dest` instead of `wsscp scp source dest`
  - Backward compatibility maintained
- **Donation Integration**: Community support features
  - Web interface donation modal with PayPal and cryptocurrency options
  - Donation information in README and documentation
  - Copy-to-clipboard functionality for crypto addresses
- **Enhanced Build System**: Improved build.sh and clean.sh scripts
  - `--debian` flag for Debian package creation
  - Automatic C tool building when `wssshtools/` exists
  - Comprehensive cleanup of all build artifacts
- **Man Pages**: Comprehensive documentation for C tools
  - `wssshc(1)`: WebSocket SSH client registration
  - `wsssh(1)`: SSH wrapper with tunneling
  - `wsscp(1)`: SCP wrapper with tunneling
  - Professional troff-formatted manual pages
- **Web Interface Enhancements**: Professional admin panel improvements
  - Donation button in navigation bar
  - Responsive modal design
  - JavaScript copy-to-clipboard functionality

### Changed
- **Build System**: Enhanced build.sh to support C compilation and Debian packaging
- **Clean System**: Updated clean.sh to remove C build artifacts and Debian files
- **Documentation**: Comprehensive updates to README and DOCUMENTATION.md
- **Project Structure**: Added `wssshtools/` directory with complete C implementation
- **Git Management**: Added `.gitignore` for proper artifact exclusion
- **Licensing**: Added GPL-3.0 license headers to shell scripts and C implementations for consistency

### Technical Details
- **C Implementation**: Native code with OpenSSL for SSL/TLS WebSocket connections
- **Debian Integration**: Proper system packaging with dependencies (OpenSSL, GCC)
- **Cross-Compilation**: Support for building both Python and C versions
- **Certificate Management**: Improved SSL certificate handling in build process
- **Web Assets**: Enhanced HTML templates with donation modal and improved UX

### Security
- **OpenSSL Integration**: Proper SSL/TLS certificate validation in C implementation
- **Certificate Pinning**: Support for secure certificate management
- **Input Validation**: Enhanced argument parsing and validation

## [1.0.0] - 2024-09-12

### Added
- **Initial release** of WebSocket SSH tunneling system
- **wssshd**: WebSocket SSH Daemon for managing client connections and tunnel routing
- **wssshc**: WebSocket SSH Client for registering machines with the daemon
- **wsssh**: SSH command wrapper with automatic hostname parsing and tunnel establishment
- **wsscp**: SCP command wrapper with WebSocket tunneling support
- **Intelligent hostname parsing**: Support for `<CLIENT_ID>.<HOST>[:<PORT>]` format
- **Automatic port detection**: Priority-based port resolution (hostname suffix > command options > defaults)
- **SSL/TLS encryption**: Secure WebSocket communications with self-signed certificates
- **Client registration system**: Unique client identification and persistent connections
- **Build system**: Automated binary creation using PyInstaller
- **Cross-platform support**: Linux, macOS, and Windows compatibility
- **Comprehensive documentation**: README, installation guides, and usage examples

### Features
- **Drop-in SSH/SCP replacement**: Use `wsssh` and `wsscp` as direct replacements for standard commands
- **Multi-client routing**: Route connections to different registered clients based on hostname
- **Automatic tunnel management**: Dynamic local port allocation and tunnel lifecycle management
- **Debug mode**: Detailed logging for troubleshooting connections and tunnels
- **Reconnection logic**: Automatic reconnection for client registration

### Technical Details
- **WebSocket-based architecture**: Real-time bidirectional communication
- **Async I/O**: High-performance asynchronous operations using asyncio
- **Binary distribution**: Standalone executables with embedded dependencies
- **Certificate management**: Automatic SSL certificate generation and embedding
- **Protocol parsing**: SSH protocol inspection for user authentication routing

### Security
- **Encrypted communications**: All WebSocket traffic protected by SSL/TLS
- **Client authentication**: Unique identifier-based client verification
- **Secure tunneling**: Isolated tunnel sessions per connection

## [0.1.0] - 2024-09-11

### Added
- **Proof of concept** implementation
- Basic WebSocket SSH tunneling functionality
- Initial client-server architecture
- Command-line interface foundation
- SSL certificate generation
- Build system setup

### Changed
- Initial architecture design
- Basic protocol implementation

### Fixed
- Initial connection handling
- Basic error management

---

## Types of changes
- `Added` for new features
- `Changed` for changes in existing functionality
- `Deprecated` for soon-to-be removed features
- `Removed` for now removed features
- `Fixed` for any bug fixes
- `Security` in case of vulnerabilities

## Versioning
This project uses [Semantic Versioning](https://semver.org/).

Given a version number MAJOR.MINOR.PATCH, increment the:

- **MAJOR** version when you make incompatible API changes
- **MINOR** version when you add functionality in a backwards compatible manner
- **PATCH** version when you make backwards compatible bug fixes

Additional labels for pre-release and build metadata are available as extensions to the MAJOR.MINOR.PATCH format.

---

## Development Notes

### Upcoming Features (Roadmap)
- **Enhanced security**: Certificate pinning and mutual TLS authentication
- **Load balancing**: Multi-server daemon support with automatic failover
- **Performance optimization**: Connection pooling and multiplexing
- **GUI client**: Desktop application for easier management
- **REST API**: HTTP API for programmatic tunnel management
- **Container support**: Docker images and Kubernetes integration
- **Monitoring**: Metrics collection and health monitoring
- **Plugin system**: Extensible architecture for custom protocols

### Known Issues
- Self-signed certificate warnings in browsers/clients
- Limited Windows testing (primarily developed on Linux)
- No built-in rate limiting or DDoS protection
- Basic error handling (room for improvement)

### Contributing
Please see [CONTRIBUTING.md](CONTRIBUTING.md) for development guidelines and contribution procedures.