/**
 * VNC and WebSocket proxy handling implementation for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef VNC_H
#define VNC_H

#include <stdbool.h>
#include <uuid/uuid.h>
#include "config.h"

typedef struct {
    char request_id[37];
    char client_id[256];
    char username[50];
    int proc_pid;
    int read_fd;  // pipe read end
    int write_fd; // pipe write end
    bool active;
    bool debug_vnc;
    volatile int thread_stop;
    char *output_buffer;
    size_t output_size;
    size_t output_used;
    pthread_mutex_t output_mutex;
} vnc_session_t;

vnc_session_t *vnc_create_session(const wssshd_config_t *config, const char *client_id, const char *username, bool debug_vnc);
void vnc_free_session(vnc_session_t *session);
bool vnc_send_data(vnc_session_t *session, const char *data, size_t len);
char *vnc_get_output(vnc_session_t *session, size_t *len);
bool vnc_disconnect(vnc_session_t *session);
bool vnc_is_running(vnc_session_t *session);

#endif /* VNC_H */