#include <string.h>
#include "rdp_assets.h"

const char *get_rdp_asset(const char *path, size_t *size) {
const char *rdp_clipboard_js =
"\"use strict\";\n"
"\n"
"// const maxPacketSize = 1600;\n"
"// const headerSize = 8;\n"
"\n"
"const CF = Object.freeze({\n"
"    // TEXT            : 1,\n"
"    BITMAP          : 2,\n"
"    // METAFILEPICT    : 3,\n"
"    // SYLK            : 4,\n"
"    // DIF             : 5,\n"
"    // TIFF            : 6,\n"
"    // OEMTEXT         : 7,\n"
"    // DIB             : 8,\n"
"    // PALETTE         : 9,\n"
"    // PENDATA         : 10,\n"
"    // RIFF            : 11,\n"
"    // WAVE            : 12,\n"
"    UNICODETEXT        : 13,\n"
"    // ENHMETAFILE     : 14,\n"
"    // HDROP           : 15,\n"
"    // LOCALE          : 16,\n"
"    // DIBV5           : 17,\n"
"    // OWNERDISPLAY    : 128,\n"
"    // DSPTEXT         : 129,\n"
"    // DSPBITMAP       : 130,\n"
"    // DSPMETAFILEPICT : 131,\n"
"    // DSPENHMETAFILE  : 142,\n"
"    // PRIVATEFIRST    : 512,\n"
"    // PRIVATELAST     : 767,\n"
"    // GDIOBJFIRST     : 768,\n"
"    // GDIOBJLAST      : 1023,\n"
"});\n"
"\n"
"const CustomCF = Object.freeze({\n"
"    None: 0,\n"
"    FileGroupDescriptorW: 33333,\n"
"});\n"
"\n"
"const Charset = Object.freeze({\n"
"    Ascii: 0,\n"
"    Unicode: 1,\n"
"});\n"
"\n"
"const FileContentsOp = Object.freeze({\n"
"    Size: 1,\n"
"    Range: 2,\n"
"});\n"
"\n"
"const FileAttributes = Object.freeze({\n"
"    Readonly: 0x1,\n"
"    Hidden: 0x2,\n"
"    System: 0x4,\n"
"    Directory: 0x10,\n"
"    Archive: 0x20,\n"
"    Normal: 0x80,\n"
"});\n"
"\n"
"const FileFlags = Object.freeze({\n"
"    Attributes: 0X4,\n"
"    FileSize: 0x40,\n"
"    WriteTime: 0x20,\n"
"    ShowProgressUI: 0x4000,\n"
"});\n"
"\n"
"const ChannelFlags = Object.freeze({\n"
"    First: 1,\n"
"    Last: 2,\n"
"});\n"
"\n"
"const MsgFlags = Object.freeze({\n"
"    None: 0,\n"
"    Ok: 1,\n"
"    Fail: 2,\n"
"    AsciiName: 4,\n"
"});\n"
"\n"
"const CbType = Object.freeze({\n"
"    MonitorReady: 0x0001,\n"
"    FormatList: 0x0002,\n"
"    ListResponse: 0x0003,\n"
"    DataRequest: 0x0004,\n"
"    DataResponse: 0x0005,\n"
"    TempDirectory: 0x0006,\n"
"    Capabilities: 0x0007,\n"
"    FileContentsRequest: 0x0008,\n"
"    FileContentsResponse: 0x0009,\n"
"    Lock: 0x000A,\n"
"    Unlock: 0x000B,\n"
"});\n"
"\n"
"const CbGeneralFlags = Object.freeze({\n"
"    UseLongFormatNames:     0x00000002,\n"
"    StreamFileclipEnabled:  0x00000004,\n"
"    FileclipNoFilePaths:    0x00000008,\n"
"    CanLockClipData:        0x00000010,\n"
"    HugeFileSupportEnabled: 0x00000020\n"
"})\n"
"\n"
"class IdGenerator\n"
"{\n"
"    constructor() {\n"
"        this.ids = [];\n"
"        this.maxId = 0;\n"
"    }\n"
"\n"
"    createId() {\n"
"        if (this.ids.length) {\n"
"            return this.ids.pop();\n"
"        }\n"
"        return this.maxId++;\n"
"    }\n"
"\n"
"    releaseId(id) {\n"
"        this.ids.push(id);\n"
"    }\n"
"}\n"
"\n"
"const chunkSize = 1600;\n"
"const headerSize = 8;\n"
"const fileDescSize = 592;\n"
"const bufferSize = fileDescSize * 3 + headerSize;\n"
"\n"
"class CliprdrBuffer\n"
"{\n"
"    constructor(Module, clipboard) {\n"
"        this.n = bufferSize;\n"
"        this.ptr = Module._malloc(this.n);\n"
"        this.stream = new OutStream(this.ptr, Module);\n"
"        this.clipboard = clipboard;\n"
"        this.Module = Module;\n"
"        this.totalLen = 0;\n"
"        this.channelflags = 0;\n"
"        this.remainingLen = 0;\n"
"    }\n"
"\n"
"    delete() {\n"
"        this.Module._free(this.ptr);\n"
"    }\n"
"\n"
"    beginFormatDescriptorList(count) {\n"
"        this.stream.i = this.ptr;\n"
"        this.stream.u16le(CbType.DataResponse);\n"
"        this.stream.u16le(MsgFlags.Ok);\n"
"        this.stream.u32le(fileDescSize * count);\n"
"        this.totalLen = fileDescSize * count + 8;\n"
"        this.remainingLen = this.totalLen;\n"
"        this.channelflags = ChannelFlags.First;\n"
"        if (this.remainingLen <= chunkSize) {\n"
"            this.channelflags |= ChannelFlags.Last;\n"
"        }\n"
"    }\n"
"\n"
"    addFormatDescriptor(filename, flags, attrs, lastModified, size) {\n"
"        this.stream.u32le(1/*files.length*/);\n"
"        this.stream.u32le(flags);\n"
"        this.stream.bzero(32);\n"
"        this.stream.u32le(attrs);\n"
"        this.stream.bzero(16);\n"
"        // lastWriteTime: specifies the number of 100-nanoseconds intervals that have elapsed since 1 January 1601.\n"
"        this.stream.u64le((lastModified + 11644473600) * 10000000);\n"
"        this.stream.u64lem(size);\n"
"        const byteLength = this.stream.copyStringAsAlignedUTF16(filename, 520 - 2);\n"
"        this.stream.bzero(520 - byteLength);\n"
"\n"
"        const len = this.stream.i - this.ptr;\n"
"        if (len > chunkSize) {\n"
"            this.clipboard.sendRawData(this.ptr, chunkSize, this.totalLen, this.channelflags);\n"
"            const overflowBuffer = new Uint8Array(Module.HEAPU8.buffer,\n"
"                                                  this.ptr + chunkSize,\n"
"                                                  len);\n"
"            this.stream.i = this.ptr;\n"
"            this.stream.copyAsArray(overflowBuffer);\n"
"            this.remainingLen -= chunkSize;\n"
"            this.channelflags = (this.remainingLen <= chunkSize) ? ChannelFlags.Last : 0;\n"
"        }\n"
"    }\n"
"\n"
"    endFormatDescriptorList() {\n"
"        if (this.stream.i != this.ptr) {\n"
"            const len = this.stream.i - this.ptr;\n"
"            this.clipboard.sendRawData(this.ptr, len, this.totalLen, this.channelflags);\n"
"        }\n"
"    }\n"
"}\n"
"\n"
"\n"
"class Cliprdr\n"
"{\n"
"    constructor(DOMBox, syncData, emccModule) {\n"
"        // TODO DOMBox, syncData -> {addFormats, setFileGroupId, ...}\n"
"        this.UTF8Decoder = new TextDecoder(\"utf-8\");\n"
"        this.UTF16Decoder = new TextDecoder(\"utf-16\");\n"
"\n"
"        this.emccModule = emccModule;\n"
"        this.syncData = syncData;\n"
"        this.clipboard = null;\n"
"        this.streams = [];\n"
"        this.lockId = null;\n"
"        this.formats = [];\n"
"        this.fileGroupId = null;\n"
"        this.dataDecoder = null;\n"
"        this.ifile = 0;\n"
"        this.files = []\n"
"        this.streamId = 0;\n"
"        this.remoteFileGroups = [];\n"
"        this.currentFileGroupId = 0;\n"
"        this.fileGroupIdGenerator = new IdGenerator();\n"
"        this.streamIdGenerator = new IdGenerator();\n"
"\n"
"        const buflen = 1600;\n"
"        const bufp = emccModule._malloc(buflen);\n"
"        this.buffer = {\n"
"            capacity: buflen,\n"
"            i: bufp,\n"
"            array: emccModule.HEAPU8.subarray(bufp, bufp + buflen)\n"
"        }\n"
"\n"
"        this.DOMBox = DOMBox;\n"
"        this.DOMFormats = this.DOMBox.appendChild(document.createElement('div'));\n"
"        this.DOMFiles = this.DOMBox.appendChild(document.createElement('div'));\n"
"\n"
"        this.DOMFormats.onclick = (e) => {\n"
"            e.preventDefault();\n"
"            let formatId = e.originalTarget.dataset.formatId;\n"
"            if (formatId) {\n"
"                formatId = Number(formatId);\n"
"                console.log('DOMFormats.onclick:', formatId);\n"
"                const customCf = (formatId === this.fileGroupId)\n"
"                    ? CustomCF.FileGroupDescriptorW\n"
"                    : 0;\n"
"                this.clipboard.sendRequestFormat(formatId, customCf);\n"
"                this.syncData();\n"
"            }\n"
"        };\n"
"\n"
"        this.DOMFiles.onclick = (e) => {\n"
"            e.preventDefault();\n"
"            let ifile = e.originalTarget.dataset.ifile;\n"
"            if (ifile) {\n"
"                ifile = Number(ifile);\n"
"                console.log('DOMFiles.onclick:', ifile);\n"
"                // TODO lock + pos + hugeFileSupport\n"
"                const bytesToRead = 0xffff;\n"
"                this.clipboard.sendFileContentsRequest(\n"
"                    FileContentsOp.Range, this.streamId, ifile, 0, 0, bytesToRead, 0, 0);\n"
"                    // FileContentsOp.Range, this.streamId, ifile, 0, 0, 0xffff,\n"
"                    //   true, this.lockId);\n"
"\n"
"                const fileGroupId = e.originalTarget.parentNode.dataset.fileGroupId;\n"
"                const streamId = this.streamIdGenerator.createId();\n"
"                const fileGroup = this.remoteFileGroups[fileGroupId];\n"
"                ++fileGroup.countRef;\n"
"                this.streams[streamId] = {\n"
"                    fileGroup,\n"
"                    ifile,\n"
"                    file: fileGroup.files[ifile],\n"
"                    offset: 0,\n"
"                    bytesToRead,\n"
"                    datas: [],\n"
"                    isActive: true,\n"
"                };\n"
"                this.syncData();\n"
"            }\n"
"        };\n"
"    }\n"
"\n"
"    free() {\n"
"        this.emccModule._free(this.buffer.i);\n"
"        this.DOMBox.removeChild(this.DOMFormats);\n"
"        this.DOMBox.removeChild(this.DOMFiles);\n"
"        this.cliprdrBuffer.delete();\n"
"    }\n"
"\n"
"    _processWithBuffer(bufLen, f) {\n"
"        const reallocBuf = (this.buffer.capacity < bufLen);\n"
"        if (this.buffer.capacity < bufLen) {\n"
"            const ibuf = this.emccModule._malloc(bufLen);\n"
"            if (!ibuf) {\n"
"                return false;\n"
"            }\n"
"            // TODO first parameter not used\n"
"            f(this.emccModule.HEAPU8.subarray(ibuf, ibuf + bufLen), ibuf);\n"
"            this.emccModule._free(ibuf);\n"
"        }\n"
"        else {\n"
"            // TODO first parameter not used\n"
"            f(this.buffer.array.subarray(0, bufLen), this.buffer.i)\n"
"        }\n"
"\n"
"        return true;\n"
"    }\n"
"\n"
"    setEmcChannel(chann) {\n"
"        this.clipboard = chann;\n"
"        this.cliprdrBuffer = new CliprdrBuffer(this.emccModule, chann);\n"
"    }\n"
"\n"
"    setGeneralCapability(generalFlags) {\n"
"        // TODO reset others values\n"
"        console.log('setGeneralCapability:', generalFlags);\n"
"        // TODO\n"
"        this.lockSupport = !!(generalFlags & CbGeneralFlags.CanLockClipData);\n"
"        // this.fileSupport = !!(generalFlags & CbGeneralFlags.StreamFileclipEnabled);\n"
"        // this.hugeFileSupport = !!(generalFlags & CbGeneralFlags.HugeFileSupportEnabled);\n"
"        return generalFlags & ~CbGeneralFlags.CanLockClipData;\n"
"    }\n"
"\n"
"    _resetUnlockedFileGroup() {\n"
"        // TODO remove streams\n"
"        const fileGroup = this.remoteFileGroups.pop();\n"
"        if (fileGroup) {\n"
"            this.DOMFiles.removeChild(fileGroup.DOMElement);\n"
"        }\n"
"    }\n"
"\n"
"    formatListStart() {\n"
"        this.DOMFiles.innerText = '';\n"
"        this.DOMFormats.innerText = '';\n"
"        this.fileGroupId = null;\n"
"        if (this.lockSupport) {\n"
"            this.currentFileGroupId = this.fileGroupIdGenerator.createId();\n"
"        }\n"
"        else {\n"
"            this._resetUnlockedFileGroup();\n"
"        }\n"
"    }\n"
"\n"
"    formatListFormat(dataName, formatId, customFormatId, isUTF8) {\n"
"        console.log('formatList:', formatId, customFormatId, isUTF8);\n"
"\n"
"        const button = document.createElement('button');\n"
"        button.dataset.formatId = formatId;\n"
"\n"
"        switch (formatId) {\n"
"            case CF.UNICODETEXT: {\n"
"                button.appendChild(new Text(\"UNICODETEXT\"));\n"
"                break;\n"
"            }\n"
"\n"
"            case CF.BITMAP: {\n"
"                button.appendChild(new Text(\"BITMAP\"));\n"
"                break;\n"
"            }\n"
"\n"
"            default: {\n"
"                switch (customFormatId) {\n"
"                    case CustomCF.FileGroupDescriptorW:\n"
"                        button.appendChild(new Text(`${formatId}: FileGroupDescriptorW`));\n"
"                        this.fileGroupId = formatId;\n"
"                        break;\n"
"\n"
"                    case CustomCF.None:\n"
"                        const decoder = (isUTF8 ? this.UTF8Decoder : this.UTF16Decoder);\n"
"                        const name = decoder.decode(dataName);\n"
"                        button.appendChild(new Text(`${formatId}: ${name}`));\n"
"                        break;\n"
"                }\n"
"                break;\n"
"            }\n"
"        }\n"
"\n"
"        this.DOMFormats.appendChild(button);\n"
"    }\n"
"\n"
"    formatListStop() {\n"
"        console.log('formatListStop');\n"
"    }\n"
"\n"
"    formatDataResponse(data, remainingDataLen, formatId, channelFlags) {\n"
"        console.log('formatDataResponse:', remainingDataLen, formatId, channelFlags);\n"
"\n"
"        switch (formatId) {\n"
"            case CF.UNICODETEXT: {\n"
"                if (channelFlags & ChannelFlags.First) {\n"
"                    this.dataDecoder = new TextDecoder(\"utf-16\");\n"
"                }\n"
"\n"
"                if (channelFlags & ChannelFlags.Last) {\n"
"                    const text = this.dataDecoder.decode(data)\n"
"                    console.log(text);\n"
"                }\n"
"                else {\n"
"                    const chunckedText = this.dataDecoder.decode(data, {stream: true});\n"
"                    console.log(chunckedText)\n"
"                }\n"
"                break;\n"
"            }\n"
"\n"
"            // TODO\n"
"            // case CF.BITMAP:\n"
"            //     break;\n"
"\n"
"            default:\n"
"                console.log('Unknown data');\n"
"        }\n"
"    }\n"
"\n"
"    formatDataResponseFileStart(countFile) {\n"
"        console.log('formatDataResponseFileStart:', countFile);\n"
"        this.responseFiles = []\n"
"\n"
"        if (!this.lockSupport) {\n"
"            this._resetUnlockedFileGroup();\n"
"        }\n"
"    }\n"
"\n"
"    formatDataResponseFile(utf16Name, attributes, flags, sizeLow, sizeHigh, lastWriteTimeLow, lastWriteTimeHigh) {\n"
"        const filename = this.UTF16Decoder.decode(utf16Name);\n"
"        console.log('formatDataResponseFile:', filename, attributes, flags, sizeLow, sizeHigh, lastWriteTimeLow, lastWriteTimeHigh);\n"
"        this.responseFiles.push({name: filename, size: (sizeHigh << 32) + sizeLow,})\n"
"    }\n"
"\n"
"    formatDataResponseFileStop() {\n"
"        console.log('formatDataResponseFileStop');\n"
"        const div = document.createElement('div');\n"
"        div.dataset.fileGroupId = this.currentFileGroupId;\n"
"        for (const i in this.responseFiles) {\n"
"            const button = div.appendChild(document.createElement('button'));\n"
"            button.appendChild(new Text(this.responseFiles[i].name));\n"
"            button.dataset.ifile = i;\n"
"        }\n"
"        this.remoteFileGroups[this.currentFileGroupId] = {\n"
"            // TODO used ?\n"
"            fileGroupId: this.currentFileGroupId,\n"
"            files: this.responseFiles,\n"
"            streamIds: {},\n"
"            countRef: 1,\n"
"            DOMElement: div,\n"
"        };\n"
"        this.DOMFiles.appendChild(div);\n"
"    }\n"
"\n"
"    fileContentsResponse(data, streamId, remainingDataLen, channelFlags) {\n"
"        console.log('fileContentsResponse:', data.byteLength, streamId, remainingDataLen, channelFlags);\n"
"\n"
"        const fileStream = this.streams[streamId];\n"
"\n"
"        if (channelFlags & ChannelFlags.Last) {\n"
"            const newOffset = fileStream.offset + fileStream.bytesToRead;\n"
"            console.log('newOffset: ', newOffset);\n"
"            if (fileStream.file.size > newOffset && fileStream.isActive) {\n"
"                fileStream.datas.push(data.buffer.slice(\n"
"                    data.byteOffset, data.byteOffset + data.byteLength));\n"
"                // TODO lock + pos + hugeFileSupport\n"
"                this.clipboard.sendFileContentsRequest(\n"
"                    FileContentsOp.Range, streamId, fileStream.ifile,\n"
"                    newOffset, 0, fileStream.bytesToRead, 0, 0);\n"
"                fileStream.offset = newOffset;\n"
"            }\n"
"            else {\n"
"                // TODO remove this.remoteFileGroups[fileStream.fileGroup.fileGroupId] id countRef == 0\n"
"                const byteLength = Math.min(\n"
"                    data.byteLength, fileStream.file.size - fileStream.offset);\n"
"                fileStream.datas.push(data.buffer.slice(\n"
"                    data.byteOffset, data.byteOffset + byteLength));\n"
"                --fileStream.fileGroup.countRef;\n"
"                delete this.streams[streamId];\n"
"                this.streamIdGenerator.releaseId(streamId);\n"
"\n"
"                const blob = new Blob(fileStream.datas, {type: \"application/octet-stream\"});\n"
"                const objectURL = URL.createObjectURL(blob);\n"
"                cbDownload.href = objectURL;\n"
"                cbDownload.download = fileStream.file.name;\n"
"                cbDownload.click();\n"
"                URL.revokeObjectURL(objectURL);\n"
"            }\n"
"        }\n"
"        else {\n"
"            fileStream.datas.push(data.buffer.slice(\n"
"                data.byteOffset, data.byteOffset + data.byteLength));\n"
"        }\n"
"    }\n"
"\n"
"    formatDataRequest(formatId) {\n"
"        console.log('formatDataRequest:', formatId);\n"
"\n"
"        switch (formatId) {\n"
"            case CF.UNICODETEXT: {\n"
"                const data = sendCbUtf8_data.value;\n"
"                const capacity = data.length * 2 + 2 /*\"\\0\\0\"*/ + 8 /* header size */;\n"
"                if (!this._processWithBuffer(capacity, (arr, ibuffer) => {\n"
"                    let len = this.emccModule.stringToUTF16(data, ibuffer + 8, capacity - 8) + 2;\n"
"\n"
"                    const stream = new OutStream(ibuffer, this.emccModule)\n"
"                    stream.u16le(CbType.DataResponse);\n"
"                    stream.u16le(MsgFlags.Ok);\n"
"                    stream.u32le(len);\n"
"\n"
"                    if (capacity <= 1600) {\n"
"                        this.clipboard.sendRawData(\n"
"                            ibuffer, capacity, capacity, ChannelFlags.First | ChannelFlags.Last);\n"
"                    }\n"
"                    else {\n"
"                        this.clipboard.sendRawData(ibuffer, 1600, capacity, ChannelFlags.First);\n"
"                        let i = 1600;\n"
"                        while (capacity - i > 1600) {\n"
"                            this.clipboard.sendRawData(ibuffer + i, 1600, capacity, 0);\n"
"                            i += 1600;\n"
"                        }\n"
"                        this.clipboard.sendRawData(\n"
"                            ibuffer + i, capacity - i, capacity, ChannelFlags.Last);\n"
"                    }\n"
"                })) {\n"
"                    // TODO malloc error\n"
"                }\n"
"                break;\n"
"            }\n"
"\n"
"            case CustomCF.FileGroupDescriptorW: {\n"
"                const file = sendCbFile_data.files[0];\n"
"\n"
"                if (file.size > 4294967296\n"
"                 && !(this.generalFlags & CbGeneralFlags.HugeFileSupportEnabled)\n"
"                ) {\n"
"                    console.error('Huge file doesn\\'t supported');\n"
"                    this.clipboard.sendHeader(CbType.DataResponse, MsgFlags.Fail, 0);\n"
"                }\n"
"\n"
"                const flags = FileFlags.FileSize | FileFlags.ShowProgressUI /*| FileFlags.WriteTime*/;\n"
"                const attrs = FileAttributes.Normal;\n"
"\n"
"                this.cliprdrBuffer.beginFormatDescriptorList(1);\n"
"                this.cliprdrBuffer.addFormatDescriptor(\n"
"                    file.name, flags, attrs, file.lastModified, file.size);\n"
"                this.cliprdrBuffer.endFormatDescriptorList();\n"
"\n"
"                break;\n"
"            }\n"
"        }\n"
"    }\n"
"\n"
"    fileContentsRequest(streamId, type, lindex, nposLow, nposHigh, szRequested) {\n"
"        console.log(\"fileContentsRequest:\", ...arguments);\n"
"\n"
"        const file = sendCbFile_data.files[lindex];\n"
"        console.log(file.size, file.name);\n"
"\n"
"        switch (type)\n"
"        {\n"
"        case FileContentsOp.Size: {\n"
"            const stream = new OutStream(this.buffer.i, this.emccModule);\n"
"\n"
"            stream.u16le(CbType.FileContentsResponse);\n"
"            stream.u16le(MsgFlags.Ok);\n"
"            const headerSizePos = stream.i;\n"
"            stream.skip(4);\n"
"\n"
"            stream.u32le(streamId);\n"
"            stream.u64le(file.size);\n"
"\n"
"            const totalLen = stream.i - this.buffer.i;\n"
"            stream.i = headerSizePos;\n"
"            stream.u32le(totalLen);\n"
"\n"
"            console.log(totalLen);\n"
"\n"
"            this.clipboard.sendRawData(this.buffer.i, totalLen, totalLen, ChannelFlags.First | ChannelFlags.Last);\n"
"\n"
"            rdpclient.sendBufferedData();\n"
"            break;\n"
"        }\n"
"\n"
"        case FileContentsOp.Range: {\n"
"            // TODO chunk\n"
"            const reader = new FileReader();\n"
"\n"
"            // Closure to capture the file information.\n"
"            reader.onload = (e) => {\n"
"                const contents = new Uint8Array(e.target.result);\n"
"                console.log(contents.length);\n"
"                const stream = new OutStream(this.buffer.i, this.emccModule);\n"
"\n"
"                stream.u16le(CbType.FileContentsResponse);\n"
"                stream.u16le(MsgFlags.Ok);\n"
"                const headerSizePos = stream.i;\n"
"                stream.skip(4);\n"
"\n"
"                stream.u32le(streamId);\n"
"                stream.copyAsArray(contents);\n"
"\n"
"                const totalLen = stream.i - this.buffer.i;\n"
"                stream.i = headerSizePos;\n"
"                stream.u32le(totalLen);\n"
"\n"
"                console.log(totalLen);\n"
"\n"
"                this.clipboard.sendRawData(this.buffer.i, totalLen, totalLen, ChannelFlags.First | ChannelFlags.Last);\n"
"\n"
"                rdpclient.sendBufferedData();\n"
"            };\n"
"\n"
"            reader.readAsArrayBuffer(file);\n"
"            break;\n"
"        }\n"
"        }\n"
"    }\n"
"\n"
"    lock(lockId) {\n"
"        console.log(\"lock:\", lockId);\n"
"        this.lockId = lockId;\n"
"    }\n"
"\n"
"    unlock(lockId) {\n"
"        console.log(\"unlock:\", lockId);\n"
"        this.lockId = null;\n"
"    }\n"
"\n"
"    receiveResponseFail(msgType) {\n"
"        console.log(\"receiveResponseFail\", msgType);\n"
"        // TODO streamId for disable transfer\n"
"    }\n"
"}\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/clipboard.js") == 0) {
        if (size) *size = strlen(rdp_clipboard_js);
        return rdp_clipboard_js;
    }
const char *rdp_mstsc_js =
"\n"
"\n"
"\n"
"// mstsc.js\n"
"(function() {\n"
"\n"
"	/**\n"
"	 * Use for domain declaration\n"
"	 */\n"
"	Mstsc = function () {\n"
"	}\n"
"	\n"
"	Mstsc.prototype = {\n"
"		// shortcut\n"
"		$ : function (id) {\n"
"			return document.getElementById(id);\n"
"		},\n"
"		\n"
"		/**\n"
"		 * Compute screen offset for a target element\n"
"		 * @param el {DOM element}\n"
"		 * @return {top : {integer}, left {integer}}\n"
"		 */\n"
"		elementOffset : function (el) {\n"
"		    var x = 0;\n"
"		    var y = 0;\n"
"		    while (el && !isNaN( el.offsetLeft ) && !isNaN( el.offsetTop )) {\n"
"		        x += el.offsetLeft - el.scrollLeft;\n"
"		        y += el.offsetTop - el.scrollTop;\n"
"		        el = el.offsetParent;\n"
"		    }\n"
"		    return { top: y, left: x };\n"
"		},\n"
"		\n"
"		/**\n"
"		 * Try to detect browser\n"
"		 * @returns {String} [firefox|chrome|ie]\n"
"		 */\n"
"		browser : function () {\n"
"			if (typeof InstallTrigger !== 'undefined') {\n"
"				return 'firefox';\n"
"			}\n"
"			\n"
"			if (!!window.chrome) {\n"
"				return 'chrome';\n"
"			}\n"
"			\n"
"			if (!!document.docuemntMode) {\n"
"				return 'ie';\n"
"			}\n"
"			\n"
"			return null;\n"
"		},\n"
"		\n"
"		/**\n"
"		 * Try to detect language\n"
"		 * @returns\n"
"		 */\n"
"		locale : function () {\n"
"			return window.navigator.userLanguage || window.navigator.language;\n"
"		}\n"
"	}\n"
"	\n"
"})();\n"
"\n"
"this.Mstsc = new Mstsc();\n"
"\n"
"// client.js\n"
"(function() {\n"
"	/**\n"
"	 * Mouse button mapping\n"
"	 * @param button {integer} client button number\n"
"	 */\n"
"	function mouseButtonMap(button) {\n"
"		switch(button) {\n"
"		case 0:\n"
"			return 1;\n"
"		case 2:\n"
"			return 2;\n"
"		default:\n"
"			return 0;\n"
"		}\n"
"	};\n"
"	\n"
"	/**\n"
"	 * Mstsc client\n"
"	 * @param canvas {canvas} rendering element\n"
"	 * @param Module rdp wasm module\n"
"	 */\n"
"	function Client(Module, canvas, stream) {\n"
"		this.canvas = canvas;\n"
"        this.socket = stream;\n"
"		// create renderer\n"
"		//this.render = new Mstsc.Canvas.create(this.canvas); \n"
"		this.activeSession = true;\n"
"		this.config = Object.assign({\n"
"            width: 1024,\n"
"            height: 768,\n"
"            bpp: 16,\n"
"            disabledGraphicOrders: 0, // MultiSelectToInt(disabled_graphics_input, Module.GraphicOrders),\n"
"            username: 'Administrator',\n"
"            password: 'HSCN123!',\n"
"            // getRandomValues: (data) => crypto.getRandomValues(data),\n"
"            verbosity:  0/*0x04000000*/,\n"
"            keylayout: 0x00010409,\n"
"        });\n"
"\n"
"		this.flag = 0;\n"
"\n"
"		console.log('newRdpGraphics2D', newRdpGraphics2D)\n"
"				\n"
"		// optional\n"
"		const LogLevel = Module.LogLevel;\n"
"		Module.log = function(priority, msg) {\n"
"			const logger = (priority === LogLevel.Info) ? console.log\n"
"						: (priority === LogLevel.Warning) ? console.warn\n"
"						: (priority === LogLevel.Error) ? console.error\n"
"						: (priority === LogLevel.Debug) ? (s) => {\n"
"							console.debug(\"%c%s\", 'color:yellow', s)\n"
"						}\n"
"						: console.info;\n"
"			logger(msg);\n"
"		};\n"
"\n"
"		const self = this\n"
"\n"
"		if(typeof(newRdpGraphics2D) === 'undefined') {\n"
"			console.log('no newRdpGraphics2D')\n"
"			return;\n"
"		}\n"
"\n"
"		const gd = newRdpGraphics2D(canvas, Module);\n"
"		self.render = new Module.RdpClient(gd, self.config);\n"
"		self.MouseFlags = Module.MouseFlags;\n"
"		self.InputFlags = Module.InputFlags;\n"
"\n"
"		self.GraphicOrders = Module.GraphicOrders;\n"
"		\n"
"		//self.clipboard = new ClipboardChannel()\n"
"\n"
"		this.install();\n"
"\n"
"	}\n"
"	\n"
"	Client.prototype = {\n"
"		install : function () {\n"
"			var self = this;\n"
"\n"
"			this.sendMouseEvent = function(evt, flags)\n"
"			{\n"
"				evt.preventDefault();\n"
"				evt.stopImmediatePropagation();\n"
"				self.render.writeMouseEvent(evt.offsetX, evt.offsetY, flags);\n"
"				self.sendData();\n"
"			}\n"
"\n"
"			// bind mouse move event\n"
"			this.canvas.addEventListener('mousemove', function (e) {\n"
"				if (!self.socket) return;\n"
"				\n"
"				//self.sendMouseEvent(e, self.flag);\n"
"				//self.sendMouseEvent(e, self.MouseFlags.Move)\n"
"				return false;\n"
"			});\n"
"			this.canvas.addEventListener('mousedown', function (e) {\n"
"				if (!self.socket) return;\n"
"				\n"
"				self.sendMouseButton(e, self.MouseFlags.Down)\n"
"				return false;\n"
"			});\n"
"			this.canvas.addEventListener('mouseup', function (e) {\n"
"				if (!self.socket) return;\n"
"\n"
"				self.sendMouseButton(e, self.MouseFlags.Up)\n"
"				return false;\n"
"			});\n"
"\n"
"			this.canvas.addEventListener('contextmenu', function (e) {\n"
"				e.preventDefault();\n"
"				return false;\n"
"			});\n"
"\n"
"			this.canvas.addEventListener('DOMMouseScroll', function (e) {\n"
"				if (!self.socket || !self.activeSession) return;\n"
"				\n"
"				var isHorizontal = false;\n"
"				var delta = e.detail;\n"
"				var step = Math.round(Math.abs(delta) * 15 / 8);\n"
"				\n"
"				var offset = Mstsc.elementOffset(self.canvas);\n"
"				//self.socket.emit('wheel', e.clientX - offset.left, e.clientY - offset.top, step, delta > 0, isHorizontal);\n"
"				e.preventDefault();\n"
"				return false;\n"
"			});\n"
"			this.canvas.addEventListener('mousewheel', function (evt) {\n"
"				if (!self.socket || !self.activeSession) return;\n"
"				\n"
"				if (evt.deltaY) {\n"
"					const delta = (evt.deltaY < 0)\n"
"						? self.MouseFlags.WheelRotationMask\n"
"						: self.MouseFlags.WheelNegative;\n"
"					self.sendMouseEvent(evt, self.MouseFlags.VerticalWheel | delta);\n"
"				}\n"
"				else if (evt.deltaX && hWheelSupport) {\n"
"					const delta = (evt.deltaX < 0)\n"
"						? self.MouseFlags.WheelRotationMask\n"
"						: self.MouseFlags.WheelNegative;\n"
"					self.sendMouseEvent(evt, self.MouseFlags.HorizontalWheel | delta);\n"
"				}\n"
"				return false;\n"
"			});\n"
"			\n"
"			// bind keyboard event\n"
"			window.addEventListener('keydown', function (e) {\n"
"				if (!self.socket || !self.activeSession) return;\n"
"				\n"
"				self.sendScancodes([Mstsc.scancode(e)], e);\n"
"				return false;\n"
"			});\n"
"			window.addEventListener('keyup', function (e) {\n"
"				if (!self.socket || !self.activeSession) return;\n"
"				\n"
"				//self.sendScancodes([Mstsc.scancode(e)], e);\n"
"				\n"
"				return false;\n"
"			});\n"
"\n"
"			this.sendData = function() {\n"
"				const out = self.render.getOutputData();\n"
"				if (out.length) {\n"
"					self.socket.send(out);\n"
"					self.render.resetOutputData();\n"
"				}\n"
"			};\n"
"			\n"
"			this.socket.onopen = function(e) {\n"
"				self.render.writeFirstPacket();\n"
"				self.sendData();\n"
"				/*\n"
"				self.t = setInterval(function() {\n"
"					console.log('render')\n"
"					self.sendData();\n"
"				}, 1000);*/\n"
"			}\n"
"\n"
"			this.socket.onerror = function(e) {\n"
"				console.log('onerror')\n"
"			}\n"
"			this.socket.onclose = function(e)  {\n"
"				console.log('onclose')\n"
"				self.render.delete();\n"
"\n"
"				clearInterval(self.t);\n"
"			}\n"
"			this.socket.onmessage = function(event)  {\n"
"				//console.log('onmessage', event.data)\n"
"				try {\n"
"					self.render.processInputData(event.data);\n"
"					self.sendData();\n"
"				}\n"
"				catch(e) {\n"
"					console.log('processInputData', e);\n"
"					self.socket = null;\n"
"					self.render = null;\n"
"					clearInterval(self.t);\n"
"\n"
"					var ctx = self.canvas.getContext(\"2d\");\n"
"\n"
"					ctx.font = \"30px Verdana\";\n"
"					// Create gradient\n"
"					var gradient = ctx.createLinearGradient(0, 0, self.canvas.width, 0);\n"
"					gradient.addColorStop(\"0\", \"magenta\");\n"
"					gradient.addColorStop(\"0.5\", \"blue\");\n"
"					gradient.addColorStop(\"1.0\", \"red\");\n"
"\n"
"					// Fill with gradient\n"
"					ctx.strokeStyle = gradient;\n"
"					ctx.strokeText(\"connection losed!~\", self.canvas.width/2 - 150, self.canvas.height/2);\n"
"				}\n"
"			}\n"
"\n"
"			self.sendScancodes = function(scancodes, evt) {\n"
"				if (scancodes) {\n"
"					evt.preventDefault();\n"
"					evt.stopImmediatePropagation();\n"
"					for (let i = 0; i < scancodes.length; ++i) {\n"
"						const scancode = scancodes[i];\n"
"						console.log('Scancode: send', scancode, '0x'+scancode.toString(16));\n"
"						self.render.writeScancodeEvent(scancode);\n"
"					}\n"
"					self.sendData();\n"
"				}\n"
"				else {\n"
"					console.warn('Scancode: unknown keycode', evt.key, evt.code)\n"
"				}\n"
"			}\n"
"\n"
"			this.sendMouseEvent = function (evt, flags)\n"
"			{\n"
"				evt.preventDefault();\n"
"				evt.stopImmediatePropagation();\n"
"				self.render.writeMouseEvent(evt.offsetX, evt.offsetY, flags);\n"
"				self.sendData();\n"
"			}\n"
"		\n"
"			this.sendMouseButton = function (evt, flag)\n"
"			{\n"
"				switch (evt.button) {\n"
"				case 0: return self.sendMouseEvent(evt, flag | self.MouseFlags.LeftButton);\n"
"				case 1: return self.sendMouseEvent(evt, flag | self.MouseFlags.MiddleButton);\n"
"				case 2: return self.sendMouseEvent(evt, flag | self.MouseFlags.RightButton);\n"
"				case 3: return self.sendMouseEvent(evt, flag | self.MouseFlags.Button4); break;\n"
"				case 4: return self.sendMouseEvent(evt, flag | self.MouseFlags.Button5); break;\n"
"				}\n"
"			}\n"
"			\n"
"			return this;\n"
"		}\n"
"	}\n"
"	\n"
"	Mstsc.client = {\n"
"		create : function (Module, gd, canvas, stream) {\n"
"			return new Client(Module, gd, canvas, stream);\n"
"		}\n"
"	}\n"
"})();\n"
"\n"
"\n"
"(function() {\n"
"	// https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/code\n"
"	var KeyMap = {\n"
"	 	\"\" : 0x0000,\n"
"	 	\"Escape\" : 0x0001,\n"
"	 	\"Digit1\" : 0x0002,\n"
"	 	\"Digit2\" : 0x0003,\n"
"	 	\"Digit3\" : 0x0004,\n"
"	 	\"Digit4\" : 0x0005,\n"
"	 	\"Digit5\" : 0x0006,\n"
"		\"Digit6\" : 0x0007,\n"
"	 	\"Digit7\" : 0x0008,\n"
"	 	\"Digit8\" : 0x0009,\n"
"	 	\"Digit9\" : 0x000A,\n"
"	 	\"Digit0\" : 0x000B,\n"
"	 	\"Minus\" : 0x000C,\n"
"	 	\"Equal\" : 0x000D,\n"
" 	 	\"Backspace\" : 0x000E,\n"
" 	 	\"Tab\" : 0x000F,\n"
" 	 	\"KeyQ\" : 0x0010,\n"
" 	 	\"KeyW\" : 0x0011,\n"
" 	 	\"KeyE\" : 0x0012,\n"
" 	 	\"KeyR\" : 0x0013,\n"
" 	 	\"KeyT\" : 0x0014,\n"
" 	 	\"KeyY\" : 0x0015,\n"
" 	 	\"KeyU\" : 0x0016,\n"
" 	 	\"KeyI\" : 0x0017,\n"
" 	 	\"KeyO\" : 0x0018,\n"
" 	 	\"KeyP\" : 0x0019,\n"
" 	 	\"BracketLeft\" : 0x001A,\n"
" 	 	\"BracketRight\" : 0x001B,\n"
" 	 	\"Enter\" : 0x001C,\n"
" 	 	\"ControlLeft\" : 0x001D,\n"
" 	 	\"KeyA\" : 0x001E,\n"
" 	 	\"KeyS\" : 0x001F,\n"
" 	 	\"KeyD\" : 0x0020,\n"
" 	 	\"KeyF\" : 0x0021,\n"
" 	 	\"KeyG\" : 0x0022,\n"
" 	 	\"KeyH\" : 0x0023,\n"
" 	 	\"KeyJ\" : 0x0024,\n"
" 	 	\"KeyK\" : 0x0025,\n"
" 	 	\"KeyL\" : 0x0026,\n"
" 	 	\"Semicolon\" : 0x0027,\n"
" 	 	\"Quote\" : 0x0028,\n"
" 	 	\"Backquote\" : 0x0029,\n"
" 	 	\"ShiftLeft\" : 0x002A,\n"
" 	 	\"Backslash\" : 0x002B,\n"
" 	 	\"KeyZ\" : 0x002C,\n"
" 	 	\"KeyX\" : 0x002D,\n"
" 	 	\"KeyC\" : 0x002E,\n"
" 	 	\"KeyV\" : 0x002F,\n"
" 	 	\"KeyB\" : 0x0030,\n"
" 	 	\"KeyN\" : 0x0031,\n"
" 	 	\"KeyM\" : 0x0032,\n"
" 	 	\"Comma\" : 0x0033,\n"
" 	 	\"Period\" : 0x0034,\n"
" 	 	\"Slash\" : 0x0035,\n"
" 	 	\"ShiftRight\" : 0x0036,\n"
" 	 	\"NumpadMultiply\" : 0x0037,\n"
" 	 	\"AltLeft\" : 0x0038,\n"
" 	 	\"Space\" : 0x0039,\n"
" 	 	\"CapsLock\" : 0x003A,\n"
" 	 	\"F1\" : 0x003B,\n"
" 	 	\"F2\" : 0x003C,\n"
" 	 	\"F3\" : 0x003D,\n"
" 	 	\"F4\" : 0x003E,\n"
" 	 	\"F5\" : 0x003F,\n"
" 	 	\"F6\" : 0x0040,\n"
" 	 	\"F7\" : 0x0041,\n"
" 	 	\"F8\" : 0x0042,\n"
" 	 	\"F9\" : 0x0043,\n"
" 	 	\"F10\" : 0x0044,\n"
" 	 	\"Pause\" : 0x0045,\n"
" 	 	\"ScrollLock\" : 0x0046,\n"
" 	 	\"Numpad7\" : 0x0047,\n"
" 	 	\"Numpad8\" : 0x0048,\n"
" 	 	\"Numpad9\" : 0x0049,\n"
" 	 	\"NumpadSubtract\" : 0x004A,\n"
" 	 	\"Numpad4\" : 0x004B,\n"
" 	 	\"Numpad5\" : 0x004C,\n"
" 	 	\"Numpad6\" : 0x004D,\n"
" 	 	\"NumpadAdd\" : 0x004E,\n"
" 	 	\"Numpad1\" : 0x004F,\n"
" 	 	\"Numpad2\" : 0x0050,\n"
" 	 	\"Numpad3\" : 0x0051,\n"
" 	 	\"Numpad0\" : 0x0052,\n"
" 	 	\"NumpadDecimal\" : 0x0053,\n"
" 	 	\"PrintScreen\" : 0x0054,\n"
" 	 	\"IntlBackslash\" : 0x0056,\n"
" 	 	\"F11\" : 0x0057,\n"
" 	 	\"F12\" : 0x0058,\n"
" 	 	\"NumpadEqual\" : 0x0059,\n"
" 	 	\"F13\" : 0x0064,\n"
" 	 	\"F14\" : 0x0065,\n"
" 	 	\"F15\" : 0x0066,\n"
" 	 	\"F16\" : 0x0067,\n"
" 	 	\"F17\" : 0x0068,\n"
" 	 	\"F18\" : 0x0069,\n"
" 	 	\"F19\" : 0x006A,\n"
" 	 	\"F20\" : 0x006B,\n"
" 	 	\"F21\" : 0x006C,\n"
" 	 	\"F22\" : 0x006D,\n"
" 	 	\"F23\" : 0x006E,\n"
" 	 	\"KanaMode\" : 0x0070,\n"
" 	 	\"Lang2\" : 0x0071,\n"
" 	 	\"Lang1\" : 0x0072,\n"
" 	 	\"IntlRo\" : 0x0073,\n"
" 	 	\"F24\" : 0x0076,\n"
" 	 	\"Convert\" : 0x0079,\n"
" 	 	\"NonConvert\" : 0x007B,\n"
" 	 	\"IntlYen\" : 0x007D,\n"
" 	 	\"NumpadComma\" : 0x007E,\n"
" 	 	\"MediaTrackPrevious\" : 0xE010,\n"
" 	 	\"MediaTrackNext\" : 0xE019,\n"
" 	 	\"NumpadEnter\" : 0xE01C,\n"
" 	 	\"ControlRight\" : 0xE01D,\n"
" 	 	\"VolumeMute\" : 0xE020,\n"
" 	 	\"LaunchApp2\" : 0xE021,\n"
" 	 	\"MediaPlayPause\" : 0xE022,\n"
" 	 	\"MediaStop\" : 0xE024,\n"
" 	 	\"VolumeDown\" : 0xE02E,\n"
" 	 	\"VolumeUp\" : 0xE030,\n"
" 	 	\"BrowserHome\" : 0xE032,\n"
" 	 	\"NumpadDivide\" : 0xE035,\n"
" 	 	\"PrintScreen\" : 0xE037,\n"
" 	 	\"AltRight\" : 0xE038,\n"
" 	 	\"NumLock\" : 0xE045,\n"
" 	 	\"Pause\" : 0xE046,\n"
" 	 	\"Home\" : 0xE047,\n"
" 	 	\"ArrowUp\" : 0xE048,\n"
" 	 	\"PageUp\" : 0xE049,\n"
" 	 	\"ArrowLeft\" : 0xE04B,\n"
" 	 	\"ArrowRight\" : 0xE04D,\n"
" 	 	\"End\" : 0xE04F,\n"
" 	 	\"ArrowDown\" : 0xE050,\n"
" 	 	\"PageDown\" : 0xE051,\n"
" 	 	\"Insert\" : 0xE052,\n"
" 	 	\"Delete\" : 0xE053,\n"
" 	 	\"OSLeft\" : 0xE05B,\n"
" 	 	\"OSRight\" : 0xE05C,\n"
" 	 	\"ContextMenu\" : 0xE05D,\n"
" 	 	\"Power\" : 0xE05E,\n"
" 	 	\"BrowserSearch\" : 0xE065,\n"
" 	 	\"BrowserFavorites\" : 0xE066,\n"
" 	 	\"BrowserRefresh\" : 0xE067,\n"
" 	 	\"BrowserStop\" : 0xE068,\n"
" 	 	\"BrowserForward\" : 0xE069,\n"
" 	 	\"BrowserBack\" : 0xE06A,\n"
" 	 	\"LaunchApp1\" : 0xE06B,\n"
" 	 	\"LaunchMail\" : 0xE06C,\n"
" 	 	\"MediaSelect\" : 0xE06D\n"
"	};\n"
"	\n"
"	var UnicodeToCodeFirefox_FR = {\n"
"		27 : \"Escape\",\n"
"		112 : \"F1\",\n"
"		113 : \"F2\",\n"
"		114 : \"F3\",\n"
"		115 : \"F4\",\n"
"		116 : \"F5\",\n"
"		117 : \"F6\",\n"
"		118 : \"F7\",\n"
"		119 : \"F8\",\n"
"		120 : \"F9\",\n"
"		121 : \"F10\",\n"
"		122 : \"F11\",\n"
"		123 : \"F12\",\n"
"		0 : \"Backquote\",\n"
"		49 : \"Digit1\",\n"
"		50 : \"Digit2\",\n"
"		51 : \"Digit3\",\n"
"		52 : \"Digit4\",\n"
"		53 : \"Digit5\",\n"
"		54 : \"Digit6\",\n"
"		55 : \"Digit7\",\n"
"		56 : \"Digit8\",\n"
"		57 : \"Digit9\",\n"
"		48 : \"Digit0\",\n"
"		169 : \"Minus\",\n"
"		61 : \"Equal\",\n"
"		8 : \"Backspace\",\n"
"		9 : \"Tab\",\n"
"		65 : \"KeyQ\",\n"
"		90 : \"KeyW\",\n"
"		69 : \"KeyE\",\n"
"		82 : \"KeyR\",\n"
"		84 : \"KeyT\",\n"
"		89 : \"KeyY\",\n"
"		85 : \"KeyU\",\n"
"		73 : \"KeyI\",\n"
"		79 : \"KeyO\",\n"
"		80 : \"KeyP\",\n"
"		160 : \"BracketLeft\",\n"
"		164 : \"BracketRight\",\n"
"		13 : \"Enter\",\n"
"		20 : \"CapsLock\",\n"
"		20 : \"CapsLock\",\n"
"		81 : \"KeyA\",\n"
"		83 : \"KeyS\",\n"
"		68 : \"KeyD\",\n"
"		70 : \"KeyF\",\n"
"		71 : \"KeyG\",\n"
"		72 : \"KeyH\",\n"
"		74 : \"KeyJ\",\n"
"		75 : \"KeyK\",\n"
"		76 : \"KeyL\",\n"
"		77 : \"Semicolon\",\n"
"		165 : \"Quote\",\n"
"		170 : \"Backslash\",\n"
"		16 : \"ShiftLeft\",\n"
"		60 : \"IntlBackslash\",\n"
"		87 : \"KeyZ\",\n"
"		88 : \"KeyX\",\n"
"		67 : \"KeyC\",\n"
"		86 : \"KeyV\",\n"
"		66 : \"KeyB\",\n"
"		78 : \"KeyN\",\n"
"		188 : \"KeyM\",\n"
"		59 : \"Comma\",\n"
"		58 : \"Period\",\n"
"		161 : \"Slash\",\n"
"		16 : \"ShiftRight\",\n"
"		17 : \"ControlLeft\",\n"
"		91 : \"OSLeft\",\n"
"		18 : \"AltLeft\",\n"
"		32 : \"Space\",\n"
"		17 : \"ControlLeft\",\n"
"		18 : \"AltRight\",\n"
"		91 : \"OSRight\",\n"
"		93 : \"ContextMenu\",\n"
"		17 : \"ControlRight\",\n"
"		37 : \"ArrowLeft\",\n"
"		38 : \"ArrowUp\",\n"
"		40 : \"ArrowDown\",\n"
"		39 : \"ArrowRight\",\n"
"		144 : \"NumLock\",\n"
"		144 : \"NumLock\",\n"
"		111 : \"NumpadDivide\",\n"
"		106 : \"NumpadMultiply\",\n"
"		109 : \"NumpadSubtract\",\n"
"		103 : \"Numpad7\",\n"
"		104 : \"Numpad8\",\n"
"		105 : \"Numpad9\",\n"
"		107 : \"NumpadAdd\",\n"
"		100 : \"Numpad4\",\n"
"		101 : \"Numpad5\",\n"
"		102 : \"Numpad6\",\n"
"		97 : \"Numpad1\",\n"
"		98 : \"Numpad2\",\n"
"		99 : \"Numpad3\",\n"
"		96 : \"Numpad0\",\n"
"		110 : \"NumpadDecimal\",\n"
"		13 : \"NumpadEnter\",\n"
"		17 : \"ControlLeft\",\n"
"		67 : \"KeyC\",\n"
"		17 : \"ControlLeft\"\n"
"	};\n"
"	\n"
"	var UnicodeToCodeChrome_FR = {\n"
"		27 : \"Escape\",\n"
"		112 : \"F1\",\n"
"		113 : \"F2\",\n"
"		114 : \"F3\",\n"
"		115 : \"F4\",\n"
"		116 : \"F5\",\n"
"		117 : \"F6\",\n"
"		118 : \"F7\",\n"
"		119 : \"F8\",\n"
"		120 : \"F9\",\n"
"		121 : \"F10\",\n"
"		122 : \"F11\",\n"
"		123 : \"F12\",\n"
"		0 : \"Backquote\",\n"
"		49 : \"Digit1\",\n"
"		50 : \"Digit2\",\n"
"		51 : \"Digit3\",\n"
"		52 : \"Digit4\",\n"
"		53 : \"Digit5\",\n"
"		54 : \"Digit6\",\n"
"		55 : \"Digit7\",\n"
"		56 : \"Digit8\",\n"
"		57 : \"Digit9\",\n"
"		48 : \"Digit0\",\n"
"		219 : \"Minus\",\n"
"		187 : \"Equal\",\n"
"		8 : \"Backspace\",\n"
"		9 : \"Tab\",\n"
"		65 : \"KeyQ\",\n"
"		90 : \"KeyW\",\n"
"		69 : \"KeyE\",\n"
"		82 : \"KeyR\",\n"
"		84 : \"KeyT\",\n"
"		89 : \"KeyY\",\n"
"		85 : \"KeyU\",\n"
"		73 : \"KeyI\",\n"
"		79 : \"KeyO\",\n"
"		80 : \"KeyP\",\n"
"		221 : \"BracketLeft\",\n"
"		186 : \"BracketRight\",\n"
"		13 : \"Enter\",\n"
"		20 : \"CapsLock\",\n"
"		20 : \"CapsLock\",\n"
"		81 : \"KeyA\",\n"
"		83 : \"KeyS\",\n"
"		68 : \"KeyD\",\n"
"		70 : \"KeyF\",\n"
"		71 : \"KeyG\",\n"
"		72 : \"KeyH\",\n"
"		74 : \"KeyJ\",\n"
"		75 : \"KeyK\",\n"
"		76 : \"KeyL\",\n"
"		77 : \"Semicolon\",\n"
"		192 : \"Quote\",\n"
"		220 : \"Backslash\",\n"
"		16 : \"ShiftLeft\",\n"
"		60 : \"IntlBackslash\",\n"
"		87 : \"KeyZ\",\n"
"		88 : \"KeyX\",\n"
"		67 : \"KeyC\",\n"
"		86 : \"KeyV\",\n"
"		66 : \"KeyB\",\n"
"		78 : \"KeyN\",\n"
"		188 : \"KeyM\",\n"
"		190 : \"Comma\",\n"
"		191 : \"Period\",\n"
"		223 : \"Slash\",\n"
"		16 : \"ShiftRight\",\n"
"		17 : \"ControlLeft\",\n"
"		91 : \"OSLeft\",\n"
"		18 : \"AltLeft\",\n"
"		32 : \"Space\",\n"
"		17 : \"ControlLeft\",\n"
"		18 : \"AltRight\",\n"
"		91 : \"OSRight\",\n"
"		93 : \"ContextMenu\",\n"
"		17 : \"ControlRight\",\n"
"		37 : \"ArrowLeft\",\n"
"		38 : \"ArrowUp\",\n"
"		40 : \"ArrowDown\",\n"
"		39 : \"ArrowRight\",\n"
"		144 : \"NumLock\",\n"
"		144 : \"NumLock\",\n"
"		111 : \"NumpadDivide\",\n"
"		106 : \"NumpadMultiply\",\n"
"		109 : \"NumpadSubtract\",\n"
"		103 : \"Numpad7\",\n"
"		104 : \"Numpad8\",\n"
"		105 : \"Numpad9\",\n"
"		107 : \"NumpadAdd\",\n"
"		100 : \"Numpad4\",\n"
"		101 : \"Numpad5\",\n"
"		102 : \"Numpad6\",\n"
"		97 : \"Numpad1\",\n"
"		98 : \"Numpad2\",\n"
"		99 : \"Numpad3\",\n"
"		96 : \"Numpad0\",\n"
"		110 : \"NumpadDecimal\",\n"
"		13 : \"NumpadEnter\",\n"
"		17 : \"ControlLeft\",\n"
"		67 : \"KeyC\",\n"
"		17 : \"ControlLeft\"\n"
"	};\n"
"	\n"
"	var UnicodeToCode_EN = {\n"
"		27 : \"Escape\",\n"
"		112 : \"F1\",\n"
"		113 : \"F2\",\n"
"		114 : \"F3\",\n"
"		115 : \"F4\",\n"
"		116 : \"F5\",\n"
"		117 : \"F6\",\n"
"		118 : \"F7\",\n"
"		119 : \"F8\",\n"
"		120 : \"F9\",\n"
"		121 : \"F10\",\n"
"		122 : \"F11\",\n"
"		123 : \"F12\",\n"
"		192 : \"Backquote\",\n"
"		49 : \"Digit1\",\n"
"		50 : \"Digit2\",\n"
"		51 : \"Digit3\",\n"
"		52 : \"Digit4\",\n"
"		53 : \"Digit5\",\n"
"		54 : \"Digit6\",\n"
"		55 : \"Digit7\",\n"
"		56 : \"Digit8\",\n"
"		57 : \"Digit9\",\n"
"		48 : \"Digit0\",\n"
"		173 : \"Minus\",\n"
"		61 : \"Equal\",\n"
"		8 : \"Backspace\",\n"
"		9 : \"Tab\",\n"
"		81 : \"KeyQ\",\n"
"		87 : \"KeyW\",\n"
"		69 : \"KeyE\",\n"
"		82 : \"KeyR\",\n"
"		84 : \"KeyT\",\n"
"		89 : \"KeyY\",\n"
"		85 : \"KeyU\",\n"
"		73 : \"KeyI\",\n"
"		79 : \"KeyO\",\n"
"		80 : \"KeyP\",\n"
"		219 : \"BracketLeft\",\n"
"		221 : \"BracketRight\",\n"
"		13 : \"Enter\",\n"
"		20 : \"CapsLock\",\n"
"		65 : \"KeyA\",\n"
"		83 : \"KeyS\",\n"
"		68 : \"KeyD\",\n"
"		70 : \"KeyF\",\n"
"		71 : \"KeyG\",\n"
"		72 : \"KeyH\",\n"
"		74 : \"KeyJ\",\n"
"		75 : \"KeyK\",\n"
"		76 : \"KeyL\",\n"
"		59 : \"Semicolon\",\n"
"		222 : \"Quote\",\n"
"		220 : \"Backslash\",\n"
"		16 : \"ShiftLeft\",\n"
"		220 : \"IntlBackslash\",\n"
"		90 : \"KeyZ\",\n"
"		88 : \"KeyX\",\n"
"		67 : \"KeyC\",\n"
"		86 : \"KeyV\",\n"
"		66 : \"KeyB\",\n"
"		78 : \"KeyN\",\n"
"		77 : \"KeyM\",\n"
"		188 : \"Comma\",\n"
"		190 : \"Period\",\n"
"		191 : \"Slash\",\n"
"		16 : \"ShiftRight\",\n"
"		17 : \"ControlLeft\",\n"
"		18 : \"AltLeft\",\n"
"		91 : \"OSLeft\",\n"
"		32 : \"Space\",\n"
"		18 : \"AltRight\",\n"
"		91 : \"OSRight\",\n"
"		93 : \"ContextMenu\",\n"
"		17 : \"ControlRight\",\n"
"		37 : \"ArrowLeft\",\n"
"		38 : \"ArrowUp\",\n"
"		40 : \"ArrowDown\",\n"
"		39 : \"ArrowRight\",\n"
"		144 : \"NumLock\",\n"
"		144 : \"NumLock\",\n"
"		111 : \"NumpadDivide\",\n"
"		106 : \"NumpadMultiply\",\n"
"		109 : \"NumpadSubtract\",\n"
"		103 : \"Numpad7\",\n"
"		104 : \"Numpad8\",\n"
"		105 : \"Numpad9\",\n"
"		107 : \"NumpadAdd\",\n"
"		100 : \"Numpad4\",\n"
"		101 : \"Numpad5\",\n"
"		102 : \"Numpad6\",\n"
"		97 : \"Numpad1\",\n"
"		98 : \"Numpad2\",\n"
"		99 : \"Numpad3\",\n"
"		13 : \"NumpadEnter\",\n"
"		96 : \"Numpad0\",\n"
"		110 : \"NumpadDecimal\",\n"
"		17 : \"ControlLeft\"	\n"
"	};\n"
"	\n"
"	\n"
"	var UnicodeToCode = {\n"
"		'firefox' : {\n"
"			'fr' : UnicodeToCodeFirefox_FR,\n"
"			'en' : UnicodeToCode_EN\n"
"		},\n"
"		\n"
"		'chrome' : {\n"
"			'fr' : UnicodeToCodeChrome_FR,\n"
"			'en' : UnicodeToCode_EN\n"
"		}\n"
"	}\n"
"	\n"
"	/**\n"
"	 * Scancode of keyevent\n"
"	 * @param e {keyboardevent}\n"
"	 * @return {integer} scancode\n"
"	 */\n"
"	function scancode (e) {\n"
"		var locale = Mstsc.locale();\n"
"		//locale = (['fr', 'en'].indexOf(locale) > 0 && locale) || 'en';\n"
"	 	locale = 'en';\n"
"		//console.log(KeyMap[e.code || UnicodeToCode[Mstsc.browser() || 'firefox'][locale][e.keyCode]])\n"
"		return KeyMap[e.code || UnicodeToCode[Mstsc.browser() || 'firefox'][locale][e.keyCode]];\n"
"	}\n"
"	\n"
"	Mstsc.scancode = scancode;\n"
"	\n"
"})();\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/mstsc.js") == 0) {
        if (size) *size = strlen(rdp_mstsc_js);
        return rdp_mstsc_js;
    }
const char *rdp_out_stream_js =
"\"use strict\";\n"
"\n"
"class OutStream\n"
"{\n"
"    constructor(ptr, emccModule) {\n"
"        this.i = ptr;\n"
"        this.HEAPU8 = emccModule.HEAPU8;\n"
"        this.emccModule = emccModule;\n"
"    }\n"
"\n"
"    skip(n) {\n"
"        this.i += n;\n"
"    }\n"
"\n"
"    u64lem(x) {\n"
"        if (x > 0xffffffff) {\n"
"            this.u32le(x - 0xffffffff);\n"
"        }\n"
"        else {\n"
"            this.bzero(4);\n"
"        }\n"
"        this.u32le(x);\n"
"    }\n"
"\n"
"    u64le(x) {\n"
"        this.u32le(x);\n"
"        if (x > 0xffffffff) {\n"
"            this.u32le(x - 0xffffffff);\n"
"        }\n"
"        else {\n"
"            this.bzero(4);\n"
"        }\n"
"    }\n"
"\n"
"    u32le(x) {\n"
"        this.HEAPU8[this.i++] = x;\n"
"        this.HEAPU8[this.i++] = (x >> 8);\n"
"        this.HEAPU8[this.i++] = (x >> 16);\n"
"        this.HEAPU8[this.i++] = (x >> 24);\n"
"    }\n"
"\n"
"    u16le(x) {\n"
"        this.HEAPU8[this.i++] = x;\n"
"        this.HEAPU8[this.i++] = (x >> 8);\n"
"    }\n"
"\n"
"    bzero(n) {\n"
"        this.HEAPU8.fill(0, this.i, this.i + n);\n"
"        this.i += n;\n"
"    }\n"
"\n"
"    copyAsArray(array) {\n"
"        this.HEAPU8.set(array, this.i);\n"
"        this.i += array.length;\n"
"    }\n"
"\n"
"    copyStringAsAlignedUTF16(str, maxBytesToWrite) {\n"
"        if (maxBytesToWrite === undefined) {\n"
"            maxBytesToWrite = 0x7FFFFFFF;\n"
"        }\n"
"        let iheap = this.i / 2;\n"
"        const iend = (maxBytesToWrite < str.length * 2) ? (maxBytesToWrite >> 2) : str.length;\n"
"        const HEAPU16 = this.emccModule.HEAPU16;\n"
"        for (let i = 0; i < iend; ++i, ++iheap) {\n"
"            HEAPU16[iheap] = str.charCodeAt(i);\n"
"        }\n"
"        this.i = iheap * 2;\n"
"        return iend * 2;\n"
"    }\n"
"}\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/out_stream.js") == 0) {
        if (size) *size = strlen(rdp_out_stream_js);
        return rdp_out_stream_js;
    }
const char *rdp_rdp_wasm_js =
"\n"
"var WallixModule = (function() {\n"
"  var _scriptDir = typeof document !== 'undefined' && document.currentScript ? document.currentScript.src : undefined;\n"
"  if (typeof __filename !== 'undefined') _scriptDir = _scriptDir || __filename;\n"
"  return (\n"
"function(WallixModule) {\n"
"  WallixModule = WallixModule || {};\n"
"\n"
"null;var Module=typeof WallixModule!==\"undefined\"?WallixModule:{};var readyPromiseResolve,readyPromiseReject;Module[\"ready\"]=new Promise(function(resolve,reject){readyPromiseResolve=resolve;readyPromiseReject=reject});var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var arguments_=[];var thisProgram=\"./this.program\";var quit_=function(status,toThrow){throw toThrow};var ENVIRONMENT_IS_WEB=typeof window===\"object\";var ENVIRONMENT_IS_WORKER=typeof importScripts===\"function\";var ENVIRONMENT_IS_NODE=typeof process===\"object\"&&typeof process.versions===\"object\"&&typeof process.versions.node===\"string\";var scriptDirectory=\"\";function locateFile(path){if(Module[\"locateFile\"]){return Module[\"locateFile\"](path,scriptDirectory)}return scriptDirectory+path}var read_,readAsync,readBinary,setWindowTitle;var nodeFS;var nodePath;if(ENVIRONMENT_IS_NODE){if(ENVIRONMENT_IS_WORKER){scriptDirectory=require(\"path\").dirname(scriptDirectory)+\"/\"}else{scriptDirectory=__dirname+\"/\"}read_=function shell_read(filename,binary){if(!nodeFS)nodeFS=require(\"fs\");if(!nodePath)nodePath=require(\"path\");filename=nodePath[\"normalize\"](filename);return nodeFS[\"readFileSync\"](filename,binary?null:\"utf8\")};readBinary=function readBinary(filename){var ret=read_(filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};readAsync=function readAsync(filename,onload,onerror){if(!nodeFS)nodeFS=require(\"fs\");if(!nodePath)nodePath=require(\"path\");filename=nodePath[\"normalize\"](filename);nodeFS[\"readFile\"](filename,function(err,data){if(err)onerror(err);else onload(data.buffer)})};if(process[\"argv\"].length>1){thisProgram=process[\"argv\"][1].replace(/\\\\/g,\"/\")}arguments_=process[\"argv\"].slice(2);process[\"on\"](\"uncaughtException\",function(ex){if(!(ex instanceof ExitStatus)){throw ex}});process[\"on\"](\"unhandledRejection\",abort);quit_=function(status,toThrow){if(keepRuntimeAlive()){process[\"exitCode\"]=status;throw toThrow}process[\"exit\"](status)};Module[\"inspect\"]=function(){return\"[Emscripten Module object]\"}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){scriptDirectory=self.location.href}else if(typeof document!==\"undefined\"&&document.currentScript){scriptDirectory=document.currentScript.src}if(_scriptDir){scriptDirectory=_scriptDir}if(scriptDirectory.indexOf(\"blob:\")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf(\"/\")+1)}else{scriptDirectory=\"\"}{read_=function(url){var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,false);xhr.send(null);return xhr.responseText};if(ENVIRONMENT_IS_WORKER){readBinary=function(url){var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,false);xhr.responseType=\"arraybuffer\";xhr.send(null);return new Uint8Array(xhr.response)}}readAsync=function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,true);xhr.responseType=\"arraybuffer\";xhr.onload=function(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}onerror()};xhr.onerror=onerror;xhr.send(null)}}setWindowTitle=function(title){document.title=title}}else{}var out=Module[\"print\"]||console.log.bind(console);var err=Module[\"printErr\"]||console.warn.bind(console);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=null;if(Module[\"arguments\"])arguments_=Module[\"arguments\"];if(Module[\"thisProgram\"])thisProgram=Module[\"thisProgram\"];if(Module[\"quit\"])quit_=Module[\"quit\"];var wasmBinary;if(Module[\"wasmBinary\"])wasmBinary=Module[\"wasmBinary\"];var noExitRuntime=Module[\"noExitRuntime\"]||true;if(typeof WebAssembly!==\"object\"){abort(\"no native wasm support detected\")}var wasmMemory;var ABORT=false;var EXITSTATUS;function assert(condition,text){if(!condition){abort(\"Assertion failed: \"+text)}}var UTF8Decoder=typeof TextDecoder!==\"undefined\"?new TextDecoder(\"utf8\"):undefined;function UTF8ArrayToString(heap,idx,maxBytesToRead){var endIdx=idx+maxBytesToRead;var endPtr=idx;while(heap[endPtr]&&!(endPtr>=endIdx))++endPtr;if(endPtr-idx>16&&heap.subarray&&UTF8Decoder){return UTF8Decoder.decode(heap.subarray(idx,endPtr))}else{var str=\"\";while(idx<endPtr){var u0=heap[idx++];if(!(u0&128)){str+=String.fromCharCode(u0);continue}var u1=heap[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}var u2=heap[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u0=(u0&7)<<18|u1<<12|u2<<6|heap[idx++]&63}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}return str}function UTF8ToString(ptr,maxBytesToRead){return ptr?UTF8ArrayToString(HEAPU8,ptr,maxBytesToRead):\"\"}function stringToUTF8Array(str,heap,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|u1&1023}if(u<=127){if(outIdx>=endIdx)break;heap[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;heap[outIdx++]=192|u>>6;heap[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;heap[outIdx++]=224|u>>12;heap[outIdx++]=128|u>>6&63;heap[outIdx++]=128|u&63}else{if(outIdx+3>=endIdx)break;heap[outIdx++]=240|u>>18;heap[outIdx++]=128|u>>12&63;heap[outIdx++]=128|u>>6&63;heap[outIdx++]=128|u&63}}heap[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127)++len;else if(u<=2047)len+=2;else if(u<=65535)len+=3;else len+=4}return len}var UTF16Decoder=typeof TextDecoder!==\"undefined\"?new TextDecoder(\"utf-16le\"):undefined;function UTF16ToString(ptr,maxBytesToRead){var endPtr=ptr;var idx=endPtr>>1;var maxIdx=idx+maxBytesToRead/2;while(!(idx>=maxIdx)&&HEAPU16[idx])++idx;endPtr=idx<<1;if(endPtr-ptr>32&&UTF16Decoder){return UTF16Decoder.decode(HEAPU8.subarray(ptr,endPtr))}else{var str=\"\";for(var i=0;!(i>=maxBytesToRead/2);++i){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)break;str+=String.fromCharCode(codeUnit)}return str}}function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}function lengthBytesUTF16(str){return str.length*2}function UTF32ToString(ptr,maxBytesToRead){var i=0;var str=\"\";while(!(i>=maxBytesToRead/4)){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)break;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}return str}function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferAndViews(buf){buffer=buf;Module[\"HEAP8\"]=HEAP8=new Int8Array(buf);Module[\"HEAP16\"]=HEAP16=new Int16Array(buf);Module[\"HEAP32\"]=HEAP32=new Int32Array(buf);Module[\"HEAPU8\"]=HEAPU8=new Uint8Array(buf);Module[\"HEAPU16\"]=HEAPU16=new Uint16Array(buf);Module[\"HEAPU32\"]=HEAPU32=new Uint32Array(buf);Module[\"HEAPF32\"]=HEAPF32=new Float32Array(buf);Module[\"HEAPF64\"]=HEAPF64=new Float64Array(buf)}var INITIAL_MEMORY=Module[\"INITIAL_MEMORY\"]||16777216;var wasmTable;var __ATPRERUN__=[];var __ATINIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeKeepaliveCounter=0;function keepRuntimeAlive(){return noExitRuntime||runtimeKeepaliveCounter>0}function preRun(){if(Module[\"preRun\"]){if(typeof Module[\"preRun\"]==\"function\")Module[\"preRun\"]=[Module[\"preRun\"]];while(Module[\"preRun\"].length){addOnPreRun(Module[\"preRun\"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function initRuntime(){runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function postRun(){if(Module[\"postRun\"]){if(typeof Module[\"postRun\"]==\"function\")Module[\"postRun\"]=[Module[\"postRun\"]];while(Module[\"postRun\"].length){addOnPostRun(Module[\"postRun\"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnInit(cb){__ATINIT__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module[\"monitorRunDependencies\"]){Module[\"monitorRunDependencies\"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module[\"monitorRunDependencies\"]){Module[\"monitorRunDependencies\"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module[\"preloadedImages\"]={};Module[\"preloadedAudios\"]={};function abort(what){{if(Module[\"onAbort\"]){Module[\"onAbort\"](what)}}what+=\"\";err(what);ABORT=true;EXITSTATUS=1;what=\"abort(\"+what+\"). Build with -s ASSERTIONS=1 for more info.\";var e=new WebAssembly.RuntimeError(what);readyPromiseReject(e);throw e}var dataURIPrefix=\"data:application/octet-stream;base64,\";function isDataURI(filename){return filename.startsWith(dataURIPrefix)}function isFileURI(filename){return filename.startsWith(\"file://\")}var wasmBinaryFile;wasmBinaryFile=\"./rdp.wasm\";if(!isDataURI(wasmBinaryFile)){wasmBinaryFile=locateFile(wasmBinaryFile)}function getBinary(file){try{if(file==wasmBinaryFile&&wasmBinary){return new Uint8Array(wasmBinary)}if(readBinary){return readBinary(file)}else{throw\"both async and sync fetching of the wasm failed\"}}catch(err){abort(err)}}function getBinaryPromise(){if(!wasmBinary&&(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)){if(typeof fetch===\"function\"&&!isFileURI(wasmBinaryFile)){return fetch(wasmBinaryFile,{credentials:\"same-origin\"}).then(function(response){if(!response[\"ok\"]){throw\"failed to load wasm binary file at '\"+wasmBinaryFile+\"'\"}return response[\"arrayBuffer\"]()}).catch(function(){return getBinary(wasmBinaryFile)})}else{if(readAsync){return new Promise(function(resolve,reject){readAsync(wasmBinaryFile,function(response){resolve(new Uint8Array(response))},reject)})}}}return Promise.resolve().then(function(){return getBinary(wasmBinaryFile)})}function createWasm(){var info={\"a\":asmLibraryArg};function receiveInstance(instance,module){var exports=instance.exports;Module[\"asm\"]=exports;wasmMemory=Module[\"asm\"][\"I\"];updateGlobalBufferAndViews(wasmMemory.buffer);wasmTable=Module[\"asm\"][\"O\"];addOnInit(Module[\"asm\"][\"J\"]);removeRunDependency(\"wasm-instantiate\")}addRunDependency(\"wasm-instantiate\");function receiveInstantiationResult(result){receiveInstance(result[\"instance\"])}function instantiateArrayBuffer(receiver){return getBinaryPromise().then(function(binary){return WebAssembly.instantiate(binary,info)}).then(function(instance){return instance}).then(receiver,function(reason){err(\"failed to asynchronously prepare wasm: \"+reason);abort(reason)})}function instantiateAsync(){if(!wasmBinary&&typeof WebAssembly.instantiateStreaming===\"function\"&&!isDataURI(wasmBinaryFile)&&!isFileURI(wasmBinaryFile)&&typeof fetch===\"function\"){return fetch(wasmBinaryFile,{credentials:\"same-origin\"}).then(function(response){var result=WebAssembly.instantiateStreaming(response,info);return result.then(receiveInstantiationResult,function(reason){err(\"wasm streaming compile failed: \"+reason);err(\"falling back to ArrayBuffer instantiation\");return instantiateArrayBuffer(receiveInstantiationResult)})})}else{return instantiateArrayBuffer(receiveInstantiationResult)}}if(Module[\"instantiateWasm\"]){try{var exports=Module[\"instantiateWasm\"](info,receiveInstance);return exports}catch(e){err(\"Module.instantiateWasm callback failed with error: \"+e);return false}}instantiateAsync().catch(readyPromiseReject);return{}}var ASM_CONSTS={445264:function(){let i=0;Module.MouseFlags=Object.freeze({\"HorizontalWheel\":arguments[i++],\"VerticalWheel\":arguments[i++],\"WheelNegative\":arguments[i++],\"WheelRotationMask\":arguments[i++],\"Move\":arguments[i++],\"Up\":arguments[i++],\"Down\":arguments[i++],\"LeftButton\":arguments[i++],\"RightButton\":arguments[i++],\"MiddleButton\":arguments[i++],\"Button4\":arguments[i++],\"Button5\":arguments[i++]})},445674:function(){let i=0;Module.KbdFlags=Object.freeze({\"Down\":arguments[i++],\"Release\":arguments[i++],\"Extended\":arguments[i++],\"Extended1\":arguments[i++]})},445835:function(){let i=0;Module.InputFlags=Object.freeze({\"Scancodes\":arguments[i++],\"MouseX\":arguments[i++],\"FastPath\":arguments[i++],\"Unicode\":arguments[i++],\"HorizontalWheel\":arguments[i++]})},446035:function(){let i=0;Module.GraphicOrders=Object.freeze({\"MultiOpaqueRect\":arguments[i++],\"DstBlt\":arguments[i++],\"MultiDstBlt\":arguments[i++],\"PatBltAndOpaqueRect\":arguments[i++],\"MultiPatBlt\":arguments[i++],\"ScrBlt\":arguments[i++],\"MultiScrBlt\":arguments[i++],\"MemBlt\":arguments[i++],\"Mem3Blt\":arguments[i++],\"LineTo\":arguments[i++],\"Polyline\":arguments[i++],\"PolygonSC\":arguments[i++],\"PolygonCB\":arguments[i++],\"EllipseSC\":arguments[i++],\"EllipseCB\":arguments[i++],\"FastGlyph\":arguments[i++],\"Glyph\":arguments[i++]})},446589:function($0,$1,$2){const msg=UTF8ToString($1,$2);if(Module.log){Module.log($0,msg)}else{console.log(msg)}},446695:function(){let i=0;Module.LogLevel=Object.freeze({\"Error\":arguments[i++],\"Warning\":arguments[i++],\"Notice\":arguments[i++],\"Info\":arguments[i++],\"Debug\":arguments[i++]})}};function mod_exp_js(base_str,modulus_str,exponent_str,out,out_len){let base=BigInt(UTF8ToString(base_str));const modulus=BigInt(UTF8ToString(modulus_str));let exponent=BigInt(UTF8ToString(exponent_str));const int2=BigInt(2);const int1=BigInt(1);let result=BigInt(1);while(exponent){if(exponent%int2===int1){result=result*base%modulus}base=base*base%modulus;exponent=exponent/int2}if(!result){return 0}const hex=result.toString(16);if(hex.length>out_len*2){return 0}out=HEAPU8.subarray(out,out+out_len);let ihex=0;let iout=0;const htoi=i=>i<=57?i-48:i-97+10;if(hex.length&1){out[iout++]=htoi(hex.charCodeAt(ihex++))}for(const endhex=hex.length;ihex<endhex;ihex+=2){out[iout++]=htoi(hex.charCodeAt(ihex))<<4|htoi(hex.charCodeAt(ihex+1))}return iout}function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback==\"function\"){callback(Module);continue}var func=callback.func;if(typeof func===\"number\"){if(callback.arg===undefined){wasmTable.get(func)()}else{wasmTable.get(func)(callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}function ___cxa_allocate_exception(size){return _malloc(size+16)+16}function ExceptionInfo(excPtr){this.excPtr=excPtr;this.ptr=excPtr-16;this.set_type=function(type){HEAP32[this.ptr+4>>2]=type};this.get_type=function(){return HEAP32[this.ptr+4>>2]};this.set_destructor=function(destructor){HEAP32[this.ptr+8>>2]=destructor};this.get_destructor=function(){return HEAP32[this.ptr+8>>2]};this.set_refcount=function(refcount){HEAP32[this.ptr>>2]=refcount};this.set_caught=function(caught){caught=caught?1:0;HEAP8[this.ptr+12>>0]=caught};this.get_caught=function(){return HEAP8[this.ptr+12>>0]!=0};this.set_rethrown=function(rethrown){rethrown=rethrown?1:0;HEAP8[this.ptr+13>>0]=rethrown};this.get_rethrown=function(){return HEAP8[this.ptr+13>>0]!=0};this.init=function(type,destructor){this.set_type(type);this.set_destructor(destructor);this.set_refcount(0);this.set_caught(false);this.set_rethrown(false)};this.add_ref=function(){var value=HEAP32[this.ptr>>2];HEAP32[this.ptr>>2]=value+1};this.release_ref=function(){var prev=HEAP32[this.ptr>>2];HEAP32[this.ptr>>2]=prev-1;return prev===1}}var exceptionLast=0;var uncaughtExceptionCount=0;function ___cxa_throw(ptr,type,destructor){var info=new ExceptionInfo(ptr);info.init(type,destructor);exceptionLast=ptr;uncaughtExceptionCount++;throw ptr}var SYSCALLS={mappings:{},buffers:[null,[],[]],printChar:function(stream,curr){var buffer=SYSCALLS.buffers[stream];if(curr===0||curr===10){(stream===1?out:err)(UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}},varargs:undefined,get:function(){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret},getStr:function(ptr){var ret=UTF8ToString(ptr);return ret},get64:function(low,high){return low}};function ___sys_getpid(){return 42}function ___sys_uname(buf){if(!buf)return-21;var layout={\"__size__\":390,\"domainname\":325,\"machine\":260,\"nodename\":65,\"release\":130,\"sysname\":0,\"version\":195};var copyString=function(element,value){var offset=layout[element];writeAsciiToMemory(value,buf+offset)};copyString(\"sysname\",\"Emscripten\");copyString(\"nodename\",\"emscripten\");copyString(\"release\",\"1.0\");copyString(\"version\",\"#1\");copyString(\"machine\",\"wasm32\");return 0}function __embind_register_bigint(primitiveType,name,size,minRange,maxRange){}function getShiftFromSize(size){switch(size){case 1:return 0;case 2:return 1;case 4:return 2;case 8:return 3;default:throw new TypeError(\"Unknown type size: \"+size)}}function embind_init_charCodes(){var codes=new Array(256);for(var i=0;i<256;++i){codes[i]=String.fromCharCode(i)}embind_charCodes=codes}var embind_charCodes=undefined;function readLatin1String(ptr){var ret=\"\";var c=ptr;while(HEAPU8[c]){ret+=embind_charCodes[HEAPU8[c++]]}return ret}var awaitingDependencies={};var registeredTypes={};var typeDependencies={};var char_0=48;var char_9=57;function makeLegalFunctionName(name){if(undefined===name){return\"_unknown\"}name=name.replace(/[^a-zA-Z0-9_]/g,\"$\");var f=name.charCodeAt(0);if(f>=char_0&&f<=char_9){return\"_\"+name}else{return name}}function createNamedFunction(name,body){name=makeLegalFunctionName(name);return new Function(\"body\",\"return function \"+name+\"() {\\n\"+'    \"use strict\";'+\"    return body.apply(this, arguments);\\n\"+\"};\\n\")(body)}function extendError(baseErrorType,errorName){var errorClass=createNamedFunction(errorName,function(message){this.name=errorName;this.message=message;var stack=new Error(message).stack;if(stack!==undefined){this.stack=this.toString()+\"\\n\"+stack.replace(/^Error(:[^\\n]*)?\\n/,\"\")}});errorClass.prototype=Object.create(baseErrorType.prototype);errorClass.prototype.constructor=errorClass;errorClass.prototype.toString=function(){if(this.message===undefined){return this.name}else{return this.name+\": \"+this.message}};return errorClass}var BindingError=undefined;function throwBindingError(message){throw new BindingError(message)}var InternalError=undefined;function throwInternalError(message){throw new InternalError(message)}function whenDependentTypesAreResolved(myTypes,dependentTypes,getTypeConverters){myTypes.forEach(function(type){typeDependencies[type]=dependentTypes});function onComplete(typeConverters){var myTypeConverters=getTypeConverters(typeConverters);if(myTypeConverters.length!==myTypes.length){throwInternalError(\"Mismatched type converter count\")}for(var i=0;i<myTypes.length;++i){registerType(myTypes[i],myTypeConverters[i])}}var typeConverters=new Array(dependentTypes.length);var unregisteredTypes=[];var registered=0;dependentTypes.forEach(function(dt,i){if(registeredTypes.hasOwnProperty(dt)){typeConverters[i]=registeredTypes[dt]}else{unregisteredTypes.push(dt);if(!awaitingDependencies.hasOwnProperty(dt)){awaitingDependencies[dt]=[]}awaitingDependencies[dt].push(function(){typeConverters[i]=registeredTypes[dt];++registered;if(registered===unregisteredTypes.length){onComplete(typeConverters)}})}});if(0===unregisteredTypes.length){onComplete(typeConverters)}}function registerType(rawType,registeredInstance,options){options=options||{};if(!(\"argPackAdvance\"in registeredInstance)){throw new TypeError(\"registerType registeredInstance requires argPackAdvance\")}var name=registeredInstance.name;if(!rawType){throwBindingError('type \"'+name+'\" must have a positive integer typeid pointer')}if(registeredTypes.hasOwnProperty(rawType)){if(options.ignoreDuplicateRegistrations){return}else{throwBindingError(\"Cannot register type '\"+name+\"' twice\")}}registeredTypes[rawType]=registeredInstance;delete typeDependencies[rawType];if(awaitingDependencies.hasOwnProperty(rawType)){var callbacks=awaitingDependencies[rawType];delete awaitingDependencies[rawType];callbacks.forEach(function(cb){cb()})}}function __embind_register_bool(rawType,name,size,trueValue,falseValue){var shift=getShiftFromSize(size);name=readLatin1String(name);registerType(rawType,{name:name,\"fromWireType\":function(wt){return!!wt},\"toWireType\":function(destructors,o){return o?trueValue:falseValue},\"argPackAdvance\":8,\"readValueFromPointer\":function(pointer){var heap;if(size===1){heap=HEAP8}else if(size===2){heap=HEAP16}else if(size===4){heap=HEAP32}else{throw new TypeError(\"Unknown boolean type size: \"+name)}return this[\"fromWireType\"](heap[pointer>>shift])},destructorFunction:null})}function ClassHandle_isAliasOf(other){if(!(this instanceof ClassHandle)){return false}if(!(other instanceof ClassHandle)){return false}var leftClass=this.$$.ptrType.registeredClass;var left=this.$$.ptr;var rightClass=other.$$.ptrType.registeredClass;var right=other.$$.ptr;while(leftClass.baseClass){left=leftClass.upcast(left);leftClass=leftClass.baseClass}while(rightClass.baseClass){right=rightClass.upcast(right);rightClass=rightClass.baseClass}return leftClass===rightClass&&left===right}function shallowCopyInternalPointer(o){return{count:o.count,deleteScheduled:o.deleteScheduled,preservePointerOnDelete:o.preservePointerOnDelete,ptr:o.ptr,ptrType:o.ptrType,smartPtr:o.smartPtr,smartPtrType:o.smartPtrType}}function throwInstanceAlreadyDeleted(obj){function getInstanceTypeName(handle){return handle.$$.ptrType.registeredClass.name}throwBindingError(getInstanceTypeName(obj)+\" instance already deleted\")}var finalizationGroup=false;function detachFinalizer(handle){}function runDestructor($$){if($$.smartPtr){$$.smartPtrType.rawDestructor($$.smartPtr)}else{$$.ptrType.registeredClass.rawDestructor($$.ptr)}}function releaseClassHandle($$){$$.count.value-=1;var toDelete=0===$$.count.value;if(toDelete){runDestructor($$)}}function attachFinalizer(handle){if(\"undefined\"===typeof FinalizationGroup){attachFinalizer=function(handle){return handle};return handle}finalizationGroup=new FinalizationGroup(function(iter){for(var result=iter.next();!result.done;result=iter.next()){var $$=result.value;if(!$$.ptr){console.warn(\"object already deleted: \"+$$.ptr)}else{releaseClassHandle($$)}}});attachFinalizer=function(handle){finalizationGroup.register(handle,handle.$$,handle.$$);return handle};detachFinalizer=function(handle){finalizationGroup.unregister(handle.$$)};return attachFinalizer(handle)}function ClassHandle_clone(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.preservePointerOnDelete){this.$$.count.value+=1;return this}else{var clone=attachFinalizer(Object.create(Object.getPrototypeOf(this),{$$:{value:shallowCopyInternalPointer(this.$$)}}));clone.$$.count.value+=1;clone.$$.deleteScheduled=false;return clone}}function ClassHandle_delete(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.deleteScheduled&&!this.$$.preservePointerOnDelete){throwBindingError(\"Object already scheduled for deletion\")}detachFinalizer(this);releaseClassHandle(this.$$);if(!this.$$.preservePointerOnDelete){this.$$.smartPtr=undefined;this.$$.ptr=undefined}}function ClassHandle_isDeleted(){return!this.$$.ptr}var delayFunction=undefined;var deletionQueue=[];function flushPendingDeletes(){while(deletionQueue.length){var obj=deletionQueue.pop();obj.$$.deleteScheduled=false;obj[\"delete\"]()}}function ClassHandle_deleteLater(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.deleteScheduled&&!this.$$.preservePointerOnDelete){throwBindingError(\"Object already scheduled for deletion\")}deletionQueue.push(this);if(deletionQueue.length===1&&delayFunction){delayFunction(flushPendingDeletes)}this.$$.deleteScheduled=true;return this}function init_ClassHandle(){ClassHandle.prototype[\"isAliasOf\"]=ClassHandle_isAliasOf;ClassHandle.prototype[\"clone\"]=ClassHandle_clone;ClassHandle.prototype[\"delete\"]=ClassHandle_delete;ClassHandle.prototype[\"isDeleted\"]=ClassHandle_isDeleted;ClassHandle.prototype[\"deleteLater\"]=ClassHandle_deleteLater}function ClassHandle(){}var registeredPointers={};function ensureOverloadTable(proto,methodName,humanName){if(undefined===proto[methodName].overloadTable){var prevFunc=proto[methodName];proto[methodName]=function(){if(!proto[methodName].overloadTable.hasOwnProperty(arguments.length)){throwBindingError(\"Function '\"+humanName+\"' called with an invalid number of arguments (\"+arguments.length+\") - expects one of (\"+proto[methodName].overloadTable+\")!\")}return proto[methodName].overloadTable[arguments.length].apply(this,arguments)};proto[methodName].overloadTable=[];proto[methodName].overloadTable[prevFunc.argCount]=prevFunc}}function exposePublicSymbol(name,value,numArguments){if(Module.hasOwnProperty(name)){if(undefined===numArguments||undefined!==Module[name].overloadTable&&undefined!==Module[name].overloadTable[numArguments]){throwBindingError(\"Cannot register public name '\"+name+\"' twice\")}ensureOverloadTable(Module,name,name);if(Module.hasOwnProperty(numArguments)){throwBindingError(\"Cannot register multiple overloads of a function with the same number of arguments (\"+numArguments+\")!\")}Module[name].overloadTable[numArguments]=value}else{Module[name]=value;if(undefined!==numArguments){Module[name].numArguments=numArguments}}}function RegisteredClass(name,constructor,instancePrototype,rawDestructor,baseClass,getActualType,upcast,downcast){this.name=name;this.constructor=constructor;this.instancePrototype=instancePrototype;this.rawDestructor=rawDestructor;this.baseClass=baseClass;this.getActualType=getActualType;this.upcast=upcast;this.downcast=downcast;this.pureVirtualFunctions=[]}function upcastPointer(ptr,ptrClass,desiredClass){while(ptrClass!==desiredClass){if(!ptrClass.upcast){throwBindingError(\"Expected null or instance of \"+desiredClass.name+\", got an instance of \"+ptrClass.name)}ptr=ptrClass.upcast(ptr);ptrClass=ptrClass.baseClass}return ptr}function constNoSmartPtrRawPointerToWireType(destructors,handle){if(handle===null){if(this.isReference){throwBindingError(\"null is not a valid \"+this.name)}return 0}if(!handle.$$){throwBindingError('Cannot pass \"'+_embind_repr(handle)+'\" as a '+this.name)}if(!handle.$$.ptr){throwBindingError(\"Cannot pass deleted object as a pointer of type \"+this.name)}var handleClass=handle.$$.ptrType.registeredClass;var ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);return ptr}function genericPointerToWireType(destructors,handle){var ptr;if(handle===null){if(this.isReference){throwBindingError(\"null is not a valid \"+this.name)}if(this.isSmartPointer){ptr=this.rawConstructor();if(destructors!==null){destructors.push(this.rawDestructor,ptr)}return ptr}else{return 0}}if(!handle.$$){throwBindingError('Cannot pass \"'+_embind_repr(handle)+'\" as a '+this.name)}if(!handle.$$.ptr){throwBindingError(\"Cannot pass deleted object as a pointer of type \"+this.name)}if(!this.isConst&&handle.$$.ptrType.isConst){throwBindingError(\"Cannot convert argument of type \"+(handle.$$.smartPtrType?handle.$$.smartPtrType.name:handle.$$.ptrType.name)+\" to parameter type \"+this.name)}var handleClass=handle.$$.ptrType.registeredClass;ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);if(this.isSmartPointer){if(undefined===handle.$$.smartPtr){throwBindingError(\"Passing raw pointer to smart pointer is illegal\")}switch(this.sharingPolicy){case 0:if(handle.$$.smartPtrType===this){ptr=handle.$$.smartPtr}else{throwBindingError(\"Cannot convert argument of type \"+(handle.$$.smartPtrType?handle.$$.smartPtrType.name:handle.$$.ptrType.name)+\" to parameter type \"+this.name)}break;case 1:ptr=handle.$$.smartPtr;break;case 2:if(handle.$$.smartPtrType===this){ptr=handle.$$.smartPtr}else{var clonedHandle=handle[\"clone\"]();ptr=this.rawShare(ptr,__emval_register(function(){clonedHandle[\"delete\"]()}));if(destructors!==null){destructors.push(this.rawDestructor,ptr)}}break;default:throwBindingError(\"Unsupporting sharing policy\")}}return ptr}function nonConstNoSmartPtrRawPointerToWireType(destructors,handle){if(handle===null){if(this.isReference){throwBindingError(\"null is not a valid \"+this.name)}return 0}if(!handle.$$){throwBindingError('Cannot pass \"'+_embind_repr(handle)+'\" as a '+this.name)}if(!handle.$$.ptr){throwBindingError(\"Cannot pass deleted object as a pointer of type \"+this.name)}if(handle.$$.ptrType.isConst){throwBindingError(\"Cannot convert argument of type \"+handle.$$.ptrType.name+\" to parameter type \"+this.name)}var handleClass=handle.$$.ptrType.registeredClass;var ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);return ptr}function simpleReadValueFromPointer(pointer){return this[\"fromWireType\"](HEAPU32[pointer>>2])}function RegisteredPointer_getPointee(ptr){if(this.rawGetPointee){ptr=this.rawGetPointee(ptr)}return ptr}function RegisteredPointer_destructor(ptr){if(this.rawDestructor){this.rawDestructor(ptr)}}function RegisteredPointer_deleteObject(handle){if(handle!==null){handle[\"delete\"]()}}function downcastPointer(ptr,ptrClass,desiredClass){if(ptrClass===desiredClass){return ptr}if(undefined===desiredClass.baseClass){return null}var rv=downcastPointer(ptr,ptrClass,desiredClass.baseClass);if(rv===null){return null}return desiredClass.downcast(rv)}function getInheritedInstanceCount(){return Object.keys(registeredInstances).length}function getLiveInheritedInstances(){var rv=[];for(var k in registeredInstances){if(registeredInstances.hasOwnProperty(k)){rv.push(registeredInstances[k])}}return rv}function setDelayFunction(fn){delayFunction=fn;if(deletionQueue.length&&delayFunction){delayFunction(flushPendingDeletes)}}function init_embind(){Module[\"getInheritedInstanceCount\"]=getInheritedInstanceCount;Module[\"getLiveInheritedInstances\"]=getLiveInheritedInstances;Module[\"flushPendingDeletes\"]=flushPendingDeletes;Module[\"setDelayFunction\"]=setDelayFunction}var registeredInstances={};function getBasestPointer(class_,ptr){if(ptr===undefined){throwBindingError(\"ptr should not be undefined\")}while(class_.baseClass){ptr=class_.upcast(ptr);class_=class_.baseClass}return ptr}function getInheritedInstance(class_,ptr){ptr=getBasestPointer(class_,ptr);return registeredInstances[ptr]}function makeClassHandle(prototype,record){if(!record.ptrType||!record.ptr){throwInternalError(\"makeClassHandle requires ptr and ptrType\")}var hasSmartPtrType=!!record.smartPtrType;var hasSmartPtr=!!record.smartPtr;if(hasSmartPtrType!==hasSmartPtr){throwInternalError(\"Both smartPtrType and smartPtr must be specified\")}record.count={value:1};return attachFinalizer(Object.create(prototype,{$$:{value:record}}))}function RegisteredPointer_fromWireType(ptr){var rawPointer=this.getPointee(ptr);if(!rawPointer){this.destructor(ptr);return null}var registeredInstance=getInheritedInstance(this.registeredClass,rawPointer);if(undefined!==registeredInstance){if(0===registeredInstance.$$.count.value){registeredInstance.$$.ptr=rawPointer;registeredInstance.$$.smartPtr=ptr;return registeredInstance[\"clone\"]()}else{var rv=registeredInstance[\"clone\"]();this.destructor(ptr);return rv}}function makeDefaultHandle(){if(this.isSmartPointer){return makeClassHandle(this.registeredClass.instancePrototype,{ptrType:this.pointeeType,ptr:rawPointer,smartPtrType:this,smartPtr:ptr})}else{return makeClassHandle(this.registeredClass.instancePrototype,{ptrType:this,ptr:ptr})}}var actualType=this.registeredClass.getActualType(rawPointer);var registeredPointerRecord=registeredPointers[actualType];if(!registeredPointerRecord){return makeDefaultHandle.call(this)}var toType;if(this.isConst){toType=registeredPointerRecord.constPointerType}else{toType=registeredPointerRecord.pointerType}var dp=downcastPointer(rawPointer,this.registeredClass,toType.registeredClass);if(dp===null){return makeDefaultHandle.call(this)}if(this.isSmartPointer){return makeClassHandle(toType.registeredClass.instancePrototype,{ptrType:toType,ptr:dp,smartPtrType:this,smartPtr:ptr})}else{return makeClassHandle(toType.registeredClass.instancePrototype,{ptrType:toType,ptr:dp})}}function init_RegisteredPointer(){RegisteredPointer.prototype.getPointee=RegisteredPointer_getPointee;RegisteredPointer.prototype.destructor=RegisteredPointer_destructor;RegisteredPointer.prototype[\"argPackAdvance\"]=8;RegisteredPointer.prototype[\"readValueFromPointer\"]=simpleReadValueFromPointer;RegisteredPointer.prototype[\"deleteObject\"]=RegisteredPointer_deleteObject;RegisteredPointer.prototype[\"fromWireType\"]=RegisteredPointer_fromWireType}function RegisteredPointer(name,registeredClass,isReference,isConst,isSmartPointer,pointeeType,sharingPolicy,rawGetPointee,rawConstructor,rawShare,rawDestructor){this.name=name;this.registeredClass=registeredClass;this.isReference=isReference;this.isConst=isConst;this.isSmartPointer=isSmartPointer;this.pointeeType=pointeeType;this.sharingPolicy=sharingPolicy;this.rawGetPointee=rawGetPointee;this.rawConstructor=rawConstructor;this.rawShare=rawShare;this.rawDestructor=rawDestructor;if(!isSmartPointer&&registeredClass.baseClass===undefined){if(isConst){this[\"toWireType\"]=constNoSmartPtrRawPointerToWireType;this.destructorFunction=null}else{this[\"toWireType\"]=nonConstNoSmartPtrRawPointerToWireType;this.destructorFunction=null}}else{this[\"toWireType\"]=genericPointerToWireType}}function replacePublicSymbol(name,value,numArguments){if(!Module.hasOwnProperty(name)){throwInternalError(\"Replacing nonexistant public symbol\")}if(undefined!==Module[name].overloadTable&&undefined!==numArguments){Module[name].overloadTable[numArguments]=value}else{Module[name]=value;Module[name].argCount=numArguments}}function dynCallLegacy(sig,ptr,args){var f=Module[\"dynCall_\"+sig];return args&&args.length?f.apply(null,[ptr].concat(args)):f.call(null,ptr)}function dynCall(sig,ptr,args){if(sig.includes(\"j\")){return dynCallLegacy(sig,ptr,args)}return wasmTable.get(ptr).apply(null,args)}function getDynCaller(sig,ptr){var argCache=[];return function(){argCache.length=arguments.length;for(var i=0;i<arguments.length;i++){argCache[i]=arguments[i]}return dynCall(sig,ptr,argCache)}}function embind__requireFunction(signature,rawFunction){signature=readLatin1String(signature);function makeDynCaller(){if(signature.includes(\"j\")){return getDynCaller(signature,rawFunction)}return wasmTable.get(rawFunction)}var fp=makeDynCaller();if(typeof fp!==\"function\"){throwBindingError(\"unknown function pointer with signature \"+signature+\": \"+rawFunction)}return fp}var UnboundTypeError=undefined;function getTypeName(type){var ptr=___getTypeName(type);var rv=readLatin1String(ptr);_free(ptr);return rv}function throwUnboundTypeError(message,types){var unboundTypes=[];var seen={};function visit(type){if(seen[type]){return}if(registeredTypes[type]){return}if(typeDependencies[type]){typeDependencies[type].forEach(visit);return}unboundTypes.push(type);seen[type]=true}types.forEach(visit);throw new UnboundTypeError(message+\": \"+unboundTypes.map(getTypeName).join([\", \"]))}function __embind_register_class(rawType,rawPointerType,rawConstPointerType,baseClassRawType,getActualTypeSignature,getActualType,upcastSignature,upcast,downcastSignature,downcast,name,destructorSignature,rawDestructor){name=readLatin1String(name);getActualType=embind__requireFunction(getActualTypeSignature,getActualType);if(upcast){upcast=embind__requireFunction(upcastSignature,upcast)}if(downcast){downcast=embind__requireFunction(downcastSignature,downcast)}rawDestructor=embind__requireFunction(destructorSignature,rawDestructor);var legalFunctionName=makeLegalFunctionName(name);exposePublicSymbol(legalFunctionName,function(){throwUnboundTypeError(\"Cannot construct \"+name+\" due to unbound types\",[baseClassRawType])});whenDependentTypesAreResolved([rawType,rawPointerType,rawConstPointerType],baseClassRawType?[baseClassRawType]:[],function(base){base=base[0];var baseClass;var basePrototype;if(baseClassRawType){baseClass=base.registeredClass;basePrototype=baseClass.instancePrototype}else{basePrototype=ClassHandle.prototype}var constructor=createNamedFunction(legalFunctionName,function(){if(Object.getPrototypeOf(this)!==instancePrototype){throw new BindingError(\"Use 'new' to construct \"+name)}if(undefined===registeredClass.constructor_body){throw new BindingError(name+\" has no accessible constructor\")}var body=registeredClass.constructor_body[arguments.length];if(undefined===body){throw new BindingError(\"Tried to invoke ctor of \"+name+\" with invalid number of parameters (\"+arguments.length+\") - expected (\"+Object.keys(registeredClass.constructor_body).toString()+\") parameters instead!\")}return body.apply(this,arguments)});var instancePrototype=Object.create(basePrototype,{constructor:{value:constructor}});constructor.prototype=instancePrototype;var registeredClass=new RegisteredClass(name,constructor,instancePrototype,rawDestructor,baseClass,getActualType,upcast,downcast);var referenceConverter=new RegisteredPointer(name,registeredClass,true,false,false);var pointerConverter=new RegisteredPointer(name+\"*\",registeredClass,false,false,false);var constPointerConverter=new RegisteredPointer(name+\" const*\",registeredClass,false,true,false);registeredPointers[rawType]={pointerType:pointerConverter,constPointerType:constPointerConverter};replacePublicSymbol(legalFunctionName,constructor);return[referenceConverter,pointerConverter,constPointerConverter]})}function heap32VectorToArray(count,firstElement){var array=[];for(var i=0;i<count;i++){array.push(HEAP32[(firstElement>>2)+i])}return array}function runDestructors(destructors){while(destructors.length){var ptr=destructors.pop();var del=destructors.pop();del(ptr)}}function __embind_register_class_constructor(rawClassType,argCount,rawArgTypesAddr,invokerSignature,invoker,rawConstructor){assert(argCount>0);var rawArgTypes=heap32VectorToArray(argCount,rawArgTypesAddr);invoker=embind__requireFunction(invokerSignature,invoker);whenDependentTypesAreResolved([],[rawClassType],function(classType){classType=classType[0];var humanName=\"constructor \"+classType.name;if(undefined===classType.registeredClass.constructor_body){classType.registeredClass.constructor_body=[]}if(undefined!==classType.registeredClass.constructor_body[argCount-1]){throw new BindingError(\"Cannot register multiple constructors with identical number of parameters (\"+(argCount-1)+\") for class '\"+classType.name+\"'! Overload resolution is currently only performed using the parameter count, not actual type info!\")}classType.registeredClass.constructor_body[argCount-1]=function unboundTypeHandler(){throwUnboundTypeError(\"Cannot construct \"+classType.name+\" due to unbound types\",rawArgTypes)};whenDependentTypesAreResolved([],rawArgTypes,function(argTypes){argTypes.splice(1,0,null);classType.registeredClass.constructor_body[argCount-1]=craftInvokerFunction(humanName,argTypes,null,invoker,rawConstructor);return[]});return[]})}function new_(constructor,argumentList){if(!(constructor instanceof Function)){throw new TypeError(\"new_ called with constructor type \"+typeof constructor+\" which is not a function\")}var dummy=createNamedFunction(constructor.name||\"unknownFunctionName\",function(){});dummy.prototype=constructor.prototype;var obj=new dummy;var r=constructor.apply(obj,argumentList);return r instanceof Object?r:obj}function craftInvokerFunction(humanName,argTypes,classType,cppInvokerFunc,cppTargetFunc){var argCount=argTypes.length;if(argCount<2){throwBindingError(\"argTypes array size mismatch! Must at least get return value and 'this' types!\")}var isClassMethodFunc=argTypes[1]!==null&&classType!==null;var needsDestructorStack=false;for(var i=1;i<argTypes.length;++i){if(argTypes[i]!==null&&argTypes[i].destructorFunction===undefined){needsDestructorStack=true;break}}var returns=argTypes[0].name!==\"void\";var argsList=\"\";var argsListWired=\"\";for(var i=0;i<argCount-2;++i){argsList+=(i!==0?\", \":\"\")+\"arg\"+i;argsListWired+=(i!==0?\", \":\"\")+\"arg\"+i+\"Wired\"}var invokerFnBody=\"return function \"+makeLegalFunctionName(humanName)+\"(\"+argsList+\") {\\n\"+\"if (arguments.length !== \"+(argCount-2)+\") {\\n\"+\"throwBindingError('function \"+humanName+\" called with ' + arguments.length + ' arguments, expected \"+(argCount-2)+\" args!');\\n\"+\"}\\n\";if(needsDestructorStack){invokerFnBody+=\"var destructors = [];\\n\"}var dtorStack=needsDestructorStack?\"destructors\":\"null\";var args1=[\"throwBindingError\",\"invoker\",\"fn\",\"runDestructors\",\"retType\",\"classParam\"];var args2=[throwBindingError,cppInvokerFunc,cppTargetFunc,runDestructors,argTypes[0],argTypes[1]];if(isClassMethodFunc){invokerFnBody+=\"var thisWired = classParam.toWireType(\"+dtorStack+\", this);\\n\"}for(var i=0;i<argCount-2;++i){invokerFnBody+=\"var arg\"+i+\"Wired = argType\"+i+\".toWireType(\"+dtorStack+\", arg\"+i+\"); // \"+argTypes[i+2].name+\"\\n\";args1.push(\"argType\"+i);args2.push(argTypes[i+2])}if(isClassMethodFunc){argsListWired=\"thisWired\"+(argsListWired.length>0?\", \":\"\")+argsListWired}invokerFnBody+=(returns?\"var rv = \":\"\")+\"invoker(fn\"+(argsListWired.length>0?\", \":\"\")+argsListWired+\");\\n\";if(needsDestructorStack){invokerFnBody+=\"runDestructors(destructors);\\n\"}else{for(var i=isClassMethodFunc?1:2;i<argTypes.length;++i){var paramName=i===1?\"thisWired\":\"arg\"+(i-2)+\"Wired\";if(argTypes[i].destructorFunction!==null){invokerFnBody+=paramName+\"_dtor(\"+paramName+\"); // \"+argTypes[i].name+\"\\n\";args1.push(paramName+\"_dtor\");args2.push(argTypes[i].destructorFunction)}}}if(returns){invokerFnBody+=\"var ret = retType.fromWireType(rv);\\n\"+\"return ret;\\n\"}else{}invokerFnBody+=\"}\\n\";args1.push(invokerFnBody);var invokerFunction=new_(Function,args1).apply(null,args2);return invokerFunction}function __embind_register_class_function(rawClassType,methodName,argCount,rawArgTypesAddr,invokerSignature,rawInvoker,context,isPureVirtual){var rawArgTypes=heap32VectorToArray(argCount,rawArgTypesAddr);methodName=readLatin1String(methodName);rawInvoker=embind__requireFunction(invokerSignature,rawInvoker);whenDependentTypesAreResolved([],[rawClassType],function(classType){classType=classType[0];var humanName=classType.name+\".\"+methodName;if(methodName.startsWith(\"@@\")){methodName=Symbol[methodName.substring(2)]}if(isPureVirtual){classType.registeredClass.pureVirtualFunctions.push(methodName)}function unboundTypesHandler(){throwUnboundTypeError(\"Cannot call \"+humanName+\" due to unbound types\",rawArgTypes)}var proto=classType.registeredClass.instancePrototype;var method=proto[methodName];if(undefined===method||undefined===method.overloadTable&&method.className!==classType.name&&method.argCount===argCount-2){unboundTypesHandler.argCount=argCount-2;unboundTypesHandler.className=classType.name;proto[methodName]=unboundTypesHandler}else{ensureOverloadTable(proto,methodName,humanName);proto[methodName].overloadTable[argCount-2]=unboundTypesHandler}whenDependentTypesAreResolved([],rawArgTypes,function(argTypes){var memberFunction=craftInvokerFunction(humanName,argTypes,classType,rawInvoker,context);if(undefined===proto[methodName].overloadTable){memberFunction.argCount=argCount-2;proto[methodName]=memberFunction}else{proto[methodName].overloadTable[argCount-2]=memberFunction}return[]});return[]})}var emval_free_list=[];var emval_handle_array=[{},{value:undefined},{value:null},{value:true},{value:false}];function __emval_decref(handle){if(handle>4&&0===--emval_handle_array[handle].refcount){emval_handle_array[handle]=undefined;emval_free_list.push(handle)}}function count_emval_handles(){var count=0;for(var i=5;i<emval_handle_array.length;++i){if(emval_handle_array[i]!==undefined){++count}}return count}function get_first_emval(){for(var i=5;i<emval_handle_array.length;++i){if(emval_handle_array[i]!==undefined){return emval_handle_array[i]}}return null}function init_emval(){Module[\"count_emval_handles\"]=count_emval_handles;Module[\"get_first_emval\"]=get_first_emval}function __emval_register(value){switch(value){case undefined:{return 1}case null:{return 2}case true:{return 3}case false:{return 4}default:{var handle=emval_free_list.length?emval_free_list.pop():emval_handle_array.length;emval_handle_array[handle]={refcount:1,value:value};return handle}}}function __embind_register_emval(rawType,name){name=readLatin1String(name);registerType(rawType,{name:name,\"fromWireType\":function(handle){var rv=emval_handle_array[handle].value;__emval_decref(handle);return rv},\"toWireType\":function(destructors,value){return __emval_register(value)},\"argPackAdvance\":8,\"readValueFromPointer\":simpleReadValueFromPointer,destructorFunction:null})}function _embind_repr(v){if(v===null){return\"null\"}var t=typeof v;if(t===\"object\"||t===\"array\"||t===\"function\"){return v.toString()}else{return\"\"+v}}function floatReadValueFromPointer(name,shift){switch(shift){case 2:return function(pointer){return this[\"fromWireType\"](HEAPF32[pointer>>2])};case 3:return function(pointer){return this[\"fromWireType\"](HEAPF64[pointer>>3])};default:throw new TypeError(\"Unknown float type: \"+name)}}function __embind_register_float(rawType,name,size){var shift=getShiftFromSize(size);name=readLatin1String(name);registerType(rawType,{name:name,\"fromWireType\":function(value){return value},\"toWireType\":function(destructors,value){if(typeof value!==\"number\"&&typeof value!==\"boolean\"){throw new TypeError('Cannot convert \"'+_embind_repr(value)+'\" to '+this.name)}return value},\"argPackAdvance\":8,\"readValueFromPointer\":floatReadValueFromPointer(name,shift),destructorFunction:null})}function __embind_register_function(name,argCount,rawArgTypesAddr,signature,rawInvoker,fn){var argTypes=heap32VectorToArray(argCount,rawArgTypesAddr);name=readLatin1String(name);rawInvoker=embind__requireFunction(signature,rawInvoker);exposePublicSymbol(name,function(){throwUnboundTypeError(\"Cannot call \"+name+\" due to unbound types\",argTypes)},argCount-1);whenDependentTypesAreResolved([],argTypes,function(argTypes){var invokerArgsArray=[argTypes[0],null].concat(argTypes.slice(1));replacePublicSymbol(name,craftInvokerFunction(name,invokerArgsArray,null,rawInvoker,fn),argCount-1);return[]})}function integerReadValueFromPointer(name,shift,signed){switch(shift){case 0:return signed?function readS8FromPointer(pointer){return HEAP8[pointer]}:function readU8FromPointer(pointer){return HEAPU8[pointer]};case 1:return signed?function readS16FromPointer(pointer){return HEAP16[pointer>>1]}:function readU16FromPointer(pointer){return HEAPU16[pointer>>1]};case 2:return signed?function readS32FromPointer(pointer){return HEAP32[pointer>>2]}:function readU32FromPointer(pointer){return HEAPU32[pointer>>2]};default:throw new TypeError(\"Unknown integer type: \"+name)}}function __embind_register_integer(primitiveType,name,size,minRange,maxRange){name=readLatin1String(name);if(maxRange===-1){maxRange=4294967295}var shift=getShiftFromSize(size);var fromWireType=function(value){return value};if(minRange===0){var bitshift=32-8*size;fromWireType=function(value){return value<<bitshift>>>bitshift}}var isUnsignedType=name.includes(\"unsigned\");registerType(primitiveType,{name:name,\"fromWireType\":fromWireType,\"toWireType\":function(destructors,value){if(typeof value!==\"number\"&&typeof value!==\"boolean\"){throw new TypeError('Cannot convert \"'+_embind_repr(value)+'\" to '+this.name)}if(value<minRange||value>maxRange){throw new TypeError('Passing a number \"'+_embind_repr(value)+'\" from JS side to C/C++ side to an argument of type \"'+name+'\", which is outside the valid range ['+minRange+\", \"+maxRange+\"]!\")}return isUnsignedType?value>>>0:value|0},\"argPackAdvance\":8,\"readValueFromPointer\":integerReadValueFromPointer(name,shift,minRange!==0),destructorFunction:null})}function __embind_register_memory_view(rawType,dataTypeIndex,name){var typeMapping=[Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];var TA=typeMapping[dataTypeIndex];function decodeMemoryView(handle){handle=handle>>2;var heap=HEAPU32;var size=heap[handle];var data=heap[handle+1];return new TA(buffer,data,size)}name=readLatin1String(name);registerType(rawType,{name:name,\"fromWireType\":decodeMemoryView,\"argPackAdvance\":8,\"readValueFromPointer\":decodeMemoryView},{ignoreDuplicateRegistrations:true})}function __embind_register_std_string(rawType,name){name=readLatin1String(name);var stdStringIsUTF8=name===\"std::string\";registerType(rawType,{name:name,\"fromWireType\":function(value){var length=HEAPU32[value>>2];var str;if(stdStringIsUTF8){var decodeStartPtr=value+4;for(var i=0;i<=length;++i){var currentBytePtr=value+4+i;if(i==length||HEAPU8[currentBytePtr]==0){var maxRead=currentBytePtr-decodeStartPtr;var stringSegment=UTF8ToString(decodeStartPtr,maxRead);if(str===undefined){str=stringSegment}else{str+=String.fromCharCode(0);str+=stringSegment}decodeStartPtr=currentBytePtr+1}}}else{var a=new Array(length);for(var i=0;i<length;++i){a[i]=String.fromCharCode(HEAPU8[value+4+i])}str=a.join(\"\")}_free(value);return str},\"toWireType\":function(destructors,value){if(value instanceof ArrayBuffer){value=new Uint8Array(value)}var getLength;var valueIsOfTypeString=typeof value===\"string\";if(!(valueIsOfTypeString||value instanceof Uint8Array||value instanceof Uint8ClampedArray||value instanceof Int8Array)){throwBindingError(\"Cannot pass non-string to std::string\")}if(stdStringIsUTF8&&valueIsOfTypeString){getLength=function(){return lengthBytesUTF8(value)}}else{getLength=function(){return value.length}}var length=getLength();var ptr=_malloc(4+length+1);HEAPU32[ptr>>2]=length;if(stdStringIsUTF8&&valueIsOfTypeString){stringToUTF8(value,ptr+4,length+1)}else{if(valueIsOfTypeString){for(var i=0;i<length;++i){var charCode=value.charCodeAt(i);if(charCode>255){_free(ptr);throwBindingError(\"String has UTF-16 code units that do not fit in 8 bits\")}HEAPU8[ptr+4+i]=charCode}}else{for(var i=0;i<length;++i){HEAPU8[ptr+4+i]=value[i]}}}if(destructors!==null){destructors.push(_free,ptr)}return ptr},\"argPackAdvance\":8,\"readValueFromPointer\":simpleReadValueFromPointer,destructorFunction:function(ptr){_free(ptr)}})}function __embind_register_std_wstring(rawType,charSize,name){name=readLatin1String(name);var decodeString,encodeString,getHeap,lengthBytesUTF,shift;if(charSize===2){decodeString=UTF16ToString;encodeString=stringToUTF16;lengthBytesUTF=lengthBytesUTF16;getHeap=function(){return HEAPU16};shift=1}else if(charSize===4){decodeString=UTF32ToString;encodeString=stringToUTF32;lengthBytesUTF=lengthBytesUTF32;getHeap=function(){return HEAPU32};shift=2}registerType(rawType,{name:name,\"fromWireType\":function(value){var length=HEAPU32[value>>2];var HEAP=getHeap();var str;var decodeStartPtr=value+4;for(var i=0;i<=length;++i){var currentBytePtr=value+4+i*charSize;if(i==length||HEAP[currentBytePtr>>shift]==0){var maxReadBytes=currentBytePtr-decodeStartPtr;var stringSegment=decodeString(decodeStartPtr,maxReadBytes);if(str===undefined){str=stringSegment}else{str+=String.fromCharCode(0);str+=stringSegment}decodeStartPtr=currentBytePtr+charSize}}_free(value);return str},\"toWireType\":function(destructors,value){if(!(typeof value===\"string\")){throwBindingError(\"Cannot pass non-string to C++ string type \"+name)}var length=lengthBytesUTF(value);var ptr=_malloc(4+length+charSize);HEAPU32[ptr>>2]=length>>shift;encodeString(value,ptr+4,length+charSize);if(destructors!==null){destructors.push(_free,ptr)}return ptr},\"argPackAdvance\":8,\"readValueFromPointer\":simpleReadValueFromPointer,destructorFunction:function(ptr){_free(ptr)}})}function __embind_register_void(rawType,name){name=readLatin1String(name);registerType(rawType,{isVoid:true,name:name,\"argPackAdvance\":0,\"fromWireType\":function(){return undefined},\"toWireType\":function(destructors,o){return undefined}})}function requireHandle(handle){if(!handle){throwBindingError(\"Cannot use deleted val. handle = \"+handle)}return emval_handle_array[handle].value}function requireRegisteredType(rawType,humanName){var impl=registeredTypes[rawType];if(undefined===impl){throwBindingError(humanName+\" has unknown type \"+getTypeName(rawType))}return impl}function __emval_as(handle,returnType,destructorsRef){handle=requireHandle(handle);returnType=requireRegisteredType(returnType,\"emval::as\");var destructors=[];var rd=__emval_register(destructors);HEAP32[destructorsRef>>2]=rd;return returnType[\"toWireType\"](destructors,handle)}function __emval_lookupTypes(argCount,argTypes){var a=new Array(argCount);for(var i=0;i<argCount;++i){a[i]=requireRegisteredType(HEAP32[(argTypes>>2)+i],\"parameter \"+i)}return a}function __emval_call(handle,argCount,argTypes,argv){handle=requireHandle(handle);var types=__emval_lookupTypes(argCount,argTypes);var args=new Array(argCount);for(var i=0;i<argCount;++i){var type=types[i];args[i]=type[\"readValueFromPointer\"](argv);argv+=type[\"argPackAdvance\"]}var rv=handle.apply(undefined,args);return __emval_register(rv)}function __emval_allocateDestructors(destructorsRef){var destructors=[];HEAP32[destructorsRef>>2]=__emval_register(destructors);return destructors}var emval_symbols={};function getStringOrSymbol(address){var symbol=emval_symbols[address];if(symbol===undefined){return readLatin1String(address)}else{return symbol}}var emval_methodCallers=[];function __emval_call_method(caller,handle,methodName,destructorsRef,args){caller=emval_methodCallers[caller];handle=requireHandle(handle);methodName=getStringOrSymbol(methodName);return caller(handle,methodName,__emval_allocateDestructors(destructorsRef),args)}function __emval_call_void_method(caller,handle,methodName,args){caller=emval_methodCallers[caller];handle=requireHandle(handle);methodName=getStringOrSymbol(methodName);caller(handle,methodName,null,args)}function emval_get_global(){if(typeof globalThis===\"object\"){return globalThis}return function(){return Function}()(\"return this\")()}function __emval_get_global(name){if(name===0){return __emval_register(emval_get_global())}else{name=getStringOrSymbol(name);return __emval_register(emval_get_global()[name])}}function __emval_addMethodCaller(caller){var id=emval_methodCallers.length;emval_methodCallers.push(caller);return id}function __emval_get_method_caller(argCount,argTypes){var types=__emval_lookupTypes(argCount,argTypes);var retType=types[0];var signatureName=retType.name+\"_$\"+types.slice(1).map(function(t){return t.name}).join(\"_\")+\"$\";var params=[\"retType\"];var args=[retType];var argsList=\"\";for(var i=0;i<argCount-1;++i){argsList+=(i!==0?\", \":\"\")+\"arg\"+i;params.push(\"argType\"+i);args.push(types[1+i])}var functionName=makeLegalFunctionName(\"methodCaller_\"+signatureName);var functionBody=\"return function \"+functionName+\"(handle, name, destructors, args) {\\n\";var offset=0;for(var i=0;i<argCount-1;++i){functionBody+=\"    var arg\"+i+\" = argType\"+i+\".readValueFromPointer(args\"+(offset?\"+\"+offset:\"\")+\");\\n\";offset+=types[i+1][\"argPackAdvance\"]}functionBody+=\"    var rv = handle[name](\"+argsList+\");\\n\";for(var i=0;i<argCount-1;++i){if(types[i+1][\"deleteObject\"]){functionBody+=\"    argType\"+i+\".deleteObject(arg\"+i+\");\\n\"}}if(!retType.isVoid){functionBody+=\"    return retType.toWireType(destructors, rv);\\n\"}functionBody+=\"};\\n\";params.push(functionBody);var invokerFunction=new_(Function,params).apply(null,args);return __emval_addMethodCaller(invokerFunction)}function __emval_get_property(handle,key){handle=requireHandle(handle);key=requireHandle(key);return __emval_register(handle[key])}function __emval_incref(handle){if(handle>4){emval_handle_array[handle].refcount+=1}}function __emval_new_cstring(v){return __emval_register(getStringOrSymbol(v))}function __emval_not(object){object=requireHandle(object);return!object}function __emval_run_destructors(handle){var destructors=emval_handle_array[handle].value;runDestructors(destructors);__emval_decref(handle)}function __emval_take_value(type,argv){type=requireRegisteredType(type,\"_emval_take_value\");var v=type[\"readValueFromPointer\"](argv);return __emval_register(v)}var readAsmConstArgsArray=[];function readAsmConstArgs(sigPtr,buf){readAsmConstArgsArray.length=0;var ch;buf>>=2;while(ch=HEAPU8[sigPtr++]){var double=ch<105;if(double&&buf&1)buf++;readAsmConstArgsArray.push(double?HEAPF64[buf++>>1]:HEAP32[buf]);++buf}return readAsmConstArgsArray}function _emscripten_asm_const_int(code,sigPtr,argbuf){var args=readAsmConstArgs(sigPtr,argbuf);return ASM_CONSTS[code].apply(null,args)}function _emscripten_memcpy_big(dest,src,num){HEAPU8.copyWithin(dest,src,src+num)}function _emscripten_resize_heap(requestedSize){var oldSize=HEAPU8.length;requestedSize=requestedSize>>>0;return false}embind_init_charCodes();BindingError=Module[\"BindingError\"]=extendError(Error,\"BindingError\");InternalError=Module[\"InternalError\"]=extendError(Error,\"InternalError\");init_ClassHandle();init_RegisteredPointer();init_embind();UnboundTypeError=Module[\"UnboundTypeError\"]=extendError(Error,\"UnboundTypeError\");init_emval();var asmLibraryArg={\"c\":___cxa_allocate_exception,\"i\":___cxa_throw,\"a\":___sys_getpid,\"A\":___sys_uname,\"y\":__embind_register_bigint,\"C\":__embind_register_bool,\"v\":__embind_register_class,\"r\":__embind_register_class_constructor,\"l\":__embind_register_class_function,\"B\":__embind_register_emval,\"w\":__embind_register_float,\"u\":__embind_register_function,\"p\":__embind_register_integer,\"o\":__embind_register_memory_view,\"x\":__embind_register_std_string,\"t\":__embind_register_std_wstring,\"D\":__embind_register_void,\"k\":__emval_as,\"F\":__emval_call,\"G\":__emval_call_method,\"h\":__emval_call_void_method,\"b\":__emval_decref,\"H\":__emval_get_global,\"g\":__emval_get_method_caller,\"f\":__emval_get_property,\"m\":__emval_incref,\"e\":__emval_new_cstring,\"d\":__emval_not,\"j\":__emval_run_destructors,\"n\":__emval_take_value,\"q\":_emscripten_asm_const_int,\"z\":_emscripten_memcpy_big,\"s\":_emscripten_resize_heap,\"E\":mod_exp_js};var asm=createWasm();var ___wasm_call_ctors=Module[\"___wasm_call_ctors\"]=function(){return(___wasm_call_ctors=Module[\"___wasm_call_ctors\"]=Module[\"asm\"][\"J\"]).apply(null,arguments)};var ___getTypeName=Module[\"___getTypeName\"]=function(){return(___getTypeName=Module[\"___getTypeName\"]=Module[\"asm\"][\"K\"]).apply(null,arguments)};var ___embind_register_native_and_builtin_types=Module[\"___embind_register_native_and_builtin_types\"]=function(){return(___embind_register_native_and_builtin_types=Module[\"___embind_register_native_and_builtin_types\"]=Module[\"asm\"][\"L\"]).apply(null,arguments)};var _malloc=Module[\"_malloc\"]=function(){return(_malloc=Module[\"_malloc\"]=Module[\"asm\"][\"M\"]).apply(null,arguments)};var _free=Module[\"_free\"]=function(){return(_free=Module[\"_free\"]=Module[\"asm\"][\"N\"]).apply(null,arguments)};var dynCall_vijii=Module[\"dynCall_vijii\"]=function(){return(dynCall_vijii=Module[\"dynCall_vijii\"]=Module[\"asm\"][\"P\"]).apply(null,arguments)};var dynCall_vijiii=Module[\"dynCall_vijiii\"]=function(){return(dynCall_vijiii=Module[\"dynCall_vijiii\"]=Module[\"asm\"][\"Q\"]).apply(null,arguments)};Module[\"stringToUTF16\"]=stringToUTF16;var calledRun;function ExitStatus(status){this.name=\"ExitStatus\";this.message=\"Program terminated with exit(\"+status+\")\";this.status=status}dependenciesFulfilled=function runCaller(){if(!calledRun)run();if(!calledRun)dependenciesFulfilled=runCaller};function run(args){args=args||arguments_;if(runDependencies>0){return}preRun();if(runDependencies>0){return}function doRun(){if(calledRun)return;calledRun=true;Module[\"calledRun\"]=true;if(ABORT)return;initRuntime();readyPromiseResolve(Module);if(Module[\"onRuntimeInitialized\"])Module[\"onRuntimeInitialized\"]();postRun()}if(Module[\"setStatus\"]){Module[\"setStatus\"](\"Running...\");setTimeout(function(){setTimeout(function(){Module[\"setStatus\"](\"\")},1);doRun()},1)}else{doRun()}}Module[\"run\"]=run;if(Module[\"preInit\"]){if(typeof Module[\"preInit\"]==\"function\")Module[\"preInit\"]=[Module[\"preInit\"]];while(Module[\"preInit\"].length>0){Module[\"preInit\"].pop()()}}run();\n"
"\n"
"\n"
"  return WallixModule.ready\n"
"}\n"
");\n"
"})();\n"
"if (typeof exports === 'object' && typeof module === 'object')\n"
"  module.exports = WallixModule;\n"
"else if (typeof define === 'function' && define['amd'])\n"
"  define([], function() { return WallixModule; });\n"
"else if (typeof exports === 'object')\n"
"  exports[\"WallixModule\"] = WallixModule;\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/rdp.wasm.js") == 0) {
        if (size) *size = strlen(rdp_rdp_wasm_js);
        return rdp_rdp_wasm_js;
    }
const char *rdp_rdp_graphics_js =
"\"use strict\";\n"
"\n"
"const rgbToCss = function(color) {\n"
"    return '#'+color.toString(16).padStart(6, '0');\n"
"};\n"
"\n"
"// const has_intersection = (x1,y1,w1,h1,x2,y2,w2,h2) =>\n"
"//     ((x2 >= x1 && x2 < x1 + w1) || (x1 >= x2 && x1 < x2 + w2))\n"
"//  && ((y2 >= y1 && y2 < y1 + h1) || (y1 >= y2 && y1 < y2 + h2));\n"
"\n"
"const newRdpPointer = function(canvasElement, module) {\n"
"    const _ecusorCanvas = (function(){\n"
"        try {\n"
"            return new OffsreenCanvas(0,0);\n"
"        }\n"
"        catch (e) {\n"
"            return document.createElement('canvas');\n"
"        }\n"
"    })();\n"
"    const _cusorCanvas = _ecusorCanvas.getContext('2d');\n"
"    const _u8buffer = module.HEAPU8.buffer;\n"
"    const _cachePointers = [];\n"
"\n"
"    _ecusorCanvas.imageSmoothingEnabled = false;\n"
"\n"
"    const _image2CSS = function(idata, w, h, x, y) {\n"
"        const array = new Uint8ClampedArray(_u8buffer, idata, w * h * 4);\n"
"        const image = new ImageData(array, w, h);\n"
"        _ecusorCanvas.width = w;\n"
"        _ecusorCanvas.height = h;\n"
"        _cusorCanvas.putImageData(image, 0, 0);\n"
"        const dataURL = _ecusorCanvas.toDataURL();\n"
"        // console.log('url(' + dataURL + ') ' + x + ' ' + y + ', auto');\n"
"        return 'url(' + dataURL + ') ' + x + ' ' + y + ', auto';\n"
"    };\n"
"\n"
"    return {\n"
"        // @{\n"
"        // implementation for hack\n"
"        _cusorCanvas: _cusorCanvas,\n"
"        _cusorElement: _ecusorCanvas,\n"
"        _cachePointers: _cachePointers,\n"
"        // @}\n"
"\n"
"        newPointer: function(idata, w, h, offset, x, y) {\n"
"            const data = _image2CSS(idata, w, h, x, y);\n"
"            _cachePointers[offset] = data;\n"
"            canvasElement.style.cursor = data;\n"
"        },\n"
"\n"
"        cachedPointer: function(offset) {\n"
"            canvasElement.style.cursor = _cachePointers[offset];\n"
"        },\n"
"    };\n"
"};\n"
"\n"
"const createBuffer = function(bufferLength, module) {\n"
"    let bufferPtr = module._malloc(bufferLength);\n"
"\n"
"    return {\n"
"        delete: function() { module._free(bufferPtr); },\n"
"        getBufferPtr: function() { return bufferPtr; },\n"
"        reserve: function(n) {\n"
"            if (n > bufferLength) {\n"
"                module._free(bufferPtr);\n"
"                bufferLength = n;\n"
"                bufferPtr = module._malloc(n);\n"
"            }\n"
"            return bufferPtr;\n"
"        },\n"
"    };\n"
"};\n"
"\n"
"const newRdpCanvas = function(canvasElement, module, ropError) {\n"
"    const _ctx2d = canvasElement.getContext('2d', {alpha: false});\n"
"    if (!_ctx2d) {\n"
"        return ;\n"
"    }\n"
"\n"
"    let _width = canvasElement.width;\n"
"    let _height = canvasElement.height;\n"
"\n"
"    const _u8buffer = module.HEAPU8.buffer;\n"
"\n"
"    const _imgBuffer = createBuffer(64*64*4, module);\n"
"    let _imgBufferIndex = _imgBuffer.getBufferPtr();\n"
"\n"
"    const _cacheImages = [];\n"
"\n"
"    _ctx2d.imageSmoothingEnabled = false;\n"
"\n"
"    const unsupportedRop = ropError;\n"
"\n"
"    const _transformImage2 = function(dstImg, srcImg, sx, sy, x, y, f) {\n"
"        const destU32a = new Uint32Array(dstImg.data.buffer);\n"
"        const srcU32a = new Uint32Array(srcImg.data.buffer);\n"
"\n"
"        const w = dstImg.width;\n"
"        const len = w * dstImg.height;\n"
"        const srcInc = srcImg.width - w;\n"
"        let isrc = sy * srcImg.width + sx;\n"
"\n"
"        for (let idst = 0; idst < len;) {\n"
"            for (let ie = idst + w; idst < ie; ++idst, ++isrc) {\n"
"                destU32a[idst] = f(srcU32a[isrc] & 0xffffff, destU32a[idst] & 0xffffff)\n"
"                               | 0xff000000;\n"
"            }\n"
"            isrc += srcInc;\n"
"        }\n"
"\n"
"        _ctx2d.putImageData(dstImg, x, y);\n"
"    };\n"
"\n"
"    const _transformDstImage = function(img, sx, sy, dx, dy, dw, dh, f) {\n"
"        const dstImg = _ctx2d.getImageData(dx, dy, dw, dh);\n"
"        _transformImage2(dstImg, img, sx, sy, dx, dy, f);\n"
"    };\n"
"\n"
"    const _copyImage = function(img, sx, sy, dw, dh) {\n"
"        const w = img.width;\n"
"        const h = img.height;\n"
"        const u32av = new Uint32Array(img.data.buffer);\n"
"        const data = new Uint32Array(dh*dw);\n"
"\n"
"        if (0 === sx && w === dw) {\n"
"            data.set(u32av.subarray(sy*dw, dh*dw));\n"
"        }\n"
"        else {\n"
"            let i = sy*w + sx;\n"
"            const ie = i + dh*w;\n"
"            for (; i < ie; ++i, i+=w) {\n"
"                data.set(u8av.slice(i, i+dw));\n"
"            }\n"
"        }\n"
"\n"
"        return new ImageData(new Uint8ClampedArray(data.buffer), dw, dh);\n"
"    };\n"
"\n"
"    const _transformPixels2 = function(sx, sy, dx, dy, dw, dh, f) {\n"
"        const dstImg = _ctx2d.getImageData(dx, dy, w, h);\n"
"        const srcImg = _ctx2d.getImageData(sx, sy, w, h);\n"
"        _transformImage2(dstImg, srcImg, 0, 0, dx, dy, f);\n"
"    };\n"
"\n"
"    const _transformImage = function(img, x, y, f) {\n"
"        const u32a = new Uint32Array(img.data.buffer);\n"
"        const len = img.width * img.height;\n"
"        for (let i = 0; i < len; ++i) {\n"
"            u32a[i] = f(u32a[i] & 0xffffff) | 0xff000000;\n"
"        }\n"
"        _ctx2d.putImageData(img, x, y);\n"
"    };\n"
"\n"
"    const _transformPixels = function(x, y, w, h, f) {\n"
"        const img = _ctx2d.getImageData(x, y, w, h);\n"
"        _transformImage(img, x, y, f);\n"
"    };\n"
"\n"
"    const _transformPixelsBrush = function(orgX, orgY, w, h, backColor, foreColor, brushData, f) {\n"
"        const imgData = _ctx2d.getImageData(orgX, orgY, w, h);\n"
"        const u32a = new Uint32Array(imgData.data.buffer);\n"
"        w = imgData.width;\n"
"        h = imgData.height;\n"
"        for (let y = 0; y < h; ++y) {\n"
"            const brushU8 = brushData[(y + orgY) % 8];\n"
"            const i = y * w;\n"
"            for (let x = 0; x < w; ++x) {\n"
"                const selectColor = (brushU8 & ((1 << 7) >> ((x + orgX) % 8)));\n"
"                u32a[i+x] = f(selectColor ? backColor : foreColor, u32a[i+x] & 0xffffff)\n"
"                          | 0xff000000;\n"
"            }\n"
"        }\n"
"        _ctx2d.putImageData(imgData, orgX, orgY);\n"
"    };\n"
"\n"
"    const drawRect = function(x, y, w, h, color) {\n"
"        // console.log('drawRect');\n"
"        _ctx2d.fillStyle = rgbToCss(color);\n"
"        _ctx2d.fillRect(x,y,w,h);\n"
"    };\n"
"\n"
"    return {\n"
"        // @{\n"
"        // implementation for hack\n"
"        _canvas: canvasElement,\n"
"        _ctx2d: _ctx2d,\n"
"        _cacheImages: _cacheImages,\n"
"        _transformImage2: _transformImage2,\n"
"        _transformDstImage: _transformDstImage,\n"
"        _copyImage: _copyImage,\n"
"        _transformPixels2: _transformPixels2,\n"
"        _transformPixels: _transformPixels,\n"
"        _transformImage: _transformImage,\n"
"        _transformPixelsBrush: _transformPixelsBrush,\n"
"        // @}\n"
"\n"
"        get width() { return _width; },\n"
"        get height() { return _height; },\n"
"\n"
"        delete: function() {\n"
"            // console.log('RdpGraphics: free memory')\n"
"            _imgBuffer.delete();\n"
"        },\n"
"\n"
"        drawRect: drawRect,\n"
"\n"
"        frameMarker: function(isFrameStart) {\n"
"        },\n"
"\n"
"        resizeCanvas: function(w, h, bpp) {\n"
"            // console.log('RdpGraphics: resize(' + w + ', ' + h + ', ' + bpp + ')');\n"
"            canvasElement.width = _width = w;\n"
"            canvasElement.height = _height = h;\n"
"            drawRect(0, 0, w, h, 0);\n"
"        },\n"
"\n"
"        setBmpCacheEntries: function(\n"
"            cache0_nb_entries, cache0_bmp_size, cache0_is_persistent,\n"
"            cache1_nb_entries, cache1_bmp_size, cache1_is_persistent,\n"
"            cache2_nb_entries, cache2_bmp_size, cache2_is_persistent,\n"
"        ) {\n"
"            _cacheImages.length = cache0_nb_entries + cache1_nb_entries + cache2_nb_entries;\n"
"        },\n"
"\n"
"        setBmpCacheIndex: function(byteOffset, bitsPerPixel, w, h, lineSize, imageIdx) {\n"
"            // assume w*h <= 64*64\n"
"            module.convertBmpToImageData(_imgBufferIndex,\n"
"                                         byteOffset, bitsPerPixel, w, h, lineSize);\n"
"            const array = _u8buffer.slice(_imgBufferIndex, _imgBufferIndex + w*h*4);\n"
"            // array is copied by Uint8ClampedArray\n"
"            _cacheImages[imageIdx] = new ImageData(new Uint8ClampedArray(array), w, h);\n"
"        },\n"
"\n"
"        drawMemBlt: function(imageIdx, rop, sx, sy, dx, dy, dw, dh) {\n"
"            const img = _cacheImages[imageIdx];\n"
"            dw = Math.min(img.width - sx, _width - dx, dw);\n"
"            dh = Math.min(img.height - sy, _height - dy, dh);\n"
"\n"
"            if (dw <= 0 || dh <= 0) {\n"
"                return;\n"
"            }\n"
"\n"
"            switch (rop) {\n"
"                case 0x00:\n"
"                    _ctx2d.fillStyle = \"#000\";\n"
"                    _ctx2d.fillRect(dx, dy, dw, dh);\n"
"                    break;\n"
"\n"
"                case 0x55:\n"
"                    const newImg = _copyImage(img, sx, sy, dw, dh);\n"
"                    _transformImage(newImg, dx, dy, (src) => src ^ 0xffffff);\n"
"                    break;\n"
"\n"
"                case 0xCC:\n"
"                    _ctx2d.putImageData(img, dx, dy, sx, sy, dw, dh);\n"
"                    break;\n"
"\n"
"                case 0x22:\n"
"                    _transformDstImage(img, sx, sy, dx, dy, dw, dh, (src, dst) => ~src & dst);\n"
"                    break;\n"
"\n"
"                case 0x66:\n"
"                    _transformDstImage(img, sx, sy, dx, dy, dw, dh, (src, dst) => src ^ dst);\n"
"                    break;\n"
"\n"
"                case 0x88:\n"
"                    _transformDstImage(img, sx, sy, dx, dy, dw, dh, (src, dst) => src & dst);\n"
"                    break;\n"
"\n"
"                case 0xBB:\n"
"                    _transformDstImage(img, sx, sy, dx, dy, dw, dh, (src, dst) => ~src | dst);\n"
"                    break;\n"
"\n"
"                case 0xEE:\n"
"                    _transformDstImage(img, sx, sy, dx, dy, dw, dh, (src, dst) => src | dst);\n"
"                    break;\n"
"\n"
"                case 0xff:\n"
"                    _ctx2d.fillStyle = \"#fff\";\n"
"                    _ctx2d.fillRect(dx, dy, dw, dh);\n"
"                    break;\n"
"\n"
"                default:\n"
"                    unsupportedRop('MemBlt', rop);\n"
"                    break;\n"
"            }\n"
"        },\n"
"\n"
"        drawMem3Blt: function(brushData, orgX, orgY, style,\n"
"                    imageIdx, rop, sx, sy, dx, dy, dw, dh, backColor, foreColor\n"
"        ) {\n"
"            const img = _cacheImages[imageIdx];\n"
"            dw = Math.min(img.width - sx, _width - dx, dw);\n"
"            dh = Math.min(img.height - sy, _height - dy, dh);\n"
"\n"
"            if (dw <= 0 || dh <= 0) {\n"
"                return;\n"
"            }\n"
"\n"
"            foreColor &= 0xffffff;\n"
"\n"
"            switch (rop) {\n"
"                case 0xB8:\n"
"                    _transformDstImage(img, sx, sy, dx, dy, dw, dh,\n"
"                                       (src, dst) => ((dst ^ foreColor) & src) ^ foreColor);\n"
"                    break;\n"
"\n"
"                default:\n"
"                    unsupportedRop('Mem3Blt', rop);\n"
"                    break;\n"
"            }\n"
"        },\n"
"\n"
"        drawImage: function(byteOffset, bitsPerPixel, w, h, lineSize, dx, dy) {\n"
"            let destOffset;\n"
"            if (bitsPerPixel != 32) {\n"
"                destOffset = _imgBuffer.reserve(w*h*4);\n"
"                module.convertBmpToImageData(destOffset, byteOffset,\n"
"                                             bitsPerPixel, w, h, lineSize);\n"
"            }\n"
"            else {\n"
"                destOffset = byteOffset;\n"
"            }\n"
"\n"
"            // buffer is referenced by Uint8ClampedArray\n"
"            const array = new Uint8ClampedArray(_u8buffer, destOffset, w*h*4);\n"
"            _ctx2d.putImageData(new ImageData(array, w, h), dx, dy);\n"
"        },\n"
"\n"
"        drawScrBlt: function(sx, sy, w, h, dx, dy, rop) {\n"
"            // console.log('drawScrBlt');\n"
"            switch (rop) {\n"
"                case 0x00:\n"
"                    _ctx2d.fillStyle = \"#000\";\n"
"                    _ctx2d.fillRect(x,y,w,h);\n"
"                    break;\n"
"                case 0x11: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => ~(src | dst)); break;\n"
"                case 0x22: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => ~src & dst); break;\n"
"                case 0x33: _transformPixels(sx,sy,w,h, (src) => ~src); break;\n"
"                case 0x44: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => src & ~dst); break;\n"
"                case 0x55: _transformPixels(dx,dy,w,h, (dst) => ~dst); break;\n"
"                case 0x66: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => src ^ dst); break;\n"
"                case 0x77: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => ~(src & dst)); break;\n"
"                case 0x88: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => src & dst); break;\n"
"                case 0x99: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => ~(src ^ dst)); break;\n"
"                case 0xaa: break;\n"
"                case 0xbb: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => ~src | dst); break;\n"
"                case 0xcc: _ctx2d.putImageData(_ctx2d.getImageData(sx,sy,w,h), dx,dy); break;\n"
"                case 0xdd: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => src | ~dst); break;\n"
"                case 0xee: _transformPixels2(sx,sy,dx,dy,w,h, (src, dst) => src | dst); break;\n"
"                case 0xff:\n"
"                    _ctx2d.fillStyle = \"#fff\";\n"
"                    _ctx2d.fillRect(x,y,w,h);\n"
"                    break;\n"
"\n"
"                default:\n"
"                    unsupportedRop('ScrBlt', rop);\n"
"                    break;\n"
"            }\n"
"        },\n"
"\n"
"        drawLineTo: function(\n"
"            backMode, startX, startY, endX, endY, backColor, penStyle, penWidth, penColor\n"
"        ) {\n"
"            // console.log('drawLineTo');\n"
"            _ctx2d.save();\n"
"            _ctx2d.fillStyle = rgbToCss(backColor);\n"
"            _ctx2d.strokeStyle = rgbToCss(penColor);\n"
"            // behavior of stroke is strange (transparency color with a odd penWidth)\n"
"            if (!penStyle && startX === endX) {\n"
"                if (endX < startX) {\n"
"                    startX = endX;\n"
"                }\n"
"                if (endY < startY) {\n"
"                    [startY, endY] = [endY, startY];\n"
"                }\n"
"                _ctx2d.fillRect(startX, startY, penWidth||1, endY-startY+1);\n"
"            }\n"
"            else if (!penStyle && startY === endY) {\n"
"                if (endY < startY) {\n"
"                    startY = endY;\n"
"                }\n"
"                if (endX < startX) {\n"
"                    [startX, endX] = [endX, startX];\n"
"                }\n"
"                _ctx2d.fillRect(startX, startY, endX-startX+1, penWidth||1);\n"
"            }\n"
"            else {\n"
"                _ctx2d.beginPath();\n"
"                _ctx2d.moveTo(startX, startY);\n"
"                _ctx2d.lineTo(endX, endY);\n"
"                _ctx2d.lineWidth = penWidth;\n"
"                switch (penStyle) {\n"
"                    case 1: _ctx2d.setLineDash([ 10, 6, 10, 6 ]); break;\n"
"                    case 2: _ctx2d.setLineDash([ 3, 3, 3, 3 ]); break;\n"
"                    case 3: _ctx2d.setLineDash([ 9, 6, 3, 6 ]); break;\n"
"                    case 4: _ctx2d.setLineDash([ 9, 3, 3, 3 ]); break;\n"
"                    case 5: _ctx2d.setLineDash([ 16, 0, 16, 0 ]); break;\n"
"                }\n"
"                // BackMode does not imply the transparency level of what is about too be drawn\n"
"                // canvas.globalAlpha = (backMode === 1 /* TRANSPARENT */? 0.0 : 1.0);\n"
"                _ctx2d.stroke();\n"
"            }\n"
"            _ctx2d.restore();\n"
"        },\n"
"\n"
"        drawPolyline: function(startX, startY, deltas, clipX, clipY, clipW, clipH, penColor) {\n"
"            // console.log('drawPolyline');\n"
"            _ctx2d.save();\n"
"            _ctx2d.strokeStyle = rgbToCss(penColor);\n"
"            _ctx2d.beginPath();\n"
"            _ctx2d.moveTo(startX, startY);\n"
"            let endX = startX;\n"
"            let endY = startY;\n"
"            const iend = deltas.length\n"
"            for (let i = 0; i < iend; i += 2) {\n"
"                endX += deltas[i];\n"
"                endY += deltas[i+1];\n"
"                _ctx2d.lineTo(endX, endY);\n"
"            }\n"
"            _ctx2d.stroke();\n"
"            _ctx2d.restore();\n"
"        },\n"
"\n"
"        drawPatBlt: function(brushData, orgX, orgY, style, x, y, w, h, rop, backColor, foreColor) {\n"
"            switch (rop) {\n"
"                case 0x00:\n"
"                    _ctx2d.fillStyle = \"#000\";\n"
"                    _ctx2d.fillRect(x,y,w,h);\n"
"                    break;\n"
"                case 0x05: _transformPixels(x,y,w,h, (src) => ~(backColor | src)); break;\n"
"                case 0x0f: _transformPixels(x,y,w,h, (src) => ~src); break;\n"
"                case 0x50: _transformPixels(x,y,w,h, (src) => src & ~backColor); break;\n"
"                case 0x55: _transformPixels(x,y,w,h, (src) => src ^ 0xffffff); break;\n"
"                case 0x5a:\n"
"                    if (style === 0x03) {\n"
"                        _transformPixelsBrush(x,y,w,h,backColor,foreColor,brushData,\n"
"                                              (src,c) => src ^ c);\n"
"                    }\n"
"                    else {\n"
"                        _transformPixels(x,y,w,h, (src) => backColor ^ src);\n"
"                    }\n"
"                    break;\n"
"                case 0x5f: _transformPixels(x,y,w,h, (src) => ~(backColor & src)); break;\n"
"                case 0xa0: _transformPixels(x,y,w,h, (src) => backColor & src); break;\n"
"                case 0xa5: _transformPixels(x,y,w,h, (src) => ~(backColor ^ src)); break;\n"
"                case 0xaa: break;\n"
"                case 0xaf: _transformPixels(x,y,w,h, (src) => backColor | ~src); break;\n"
"                case 0xf0:\n"
"                    if (style === 0x03) {\n"
"                        _transformPixelsBrush(x,y,w,h,backColor,foreColor,brushData,\n"
"                                              (src,c) => src);\n"
"                    }\n"
"                    else {\n"
"                        _ctx2d.fillStyle = rgbToCss(backColor);\n"
"                        _ctx2d.fillRect(x,y,w,h);\n"
"                    }\n"
"                    break;\n"
"                case 0xfa: _transformPixels(x,y,w,h, (src) => src | backColor); break;\n"
"                case 0xf5: _transformPixels(x,y,w,h, (src) => src | ~backColor); break;\n"
"                case 0xff:\n"
"                    _ctx2d.fillStyle = \"#fff\";\n"
"                    _ctx2d.fillRect(x,y,w,h);\n"
"                    break;\n"
"\n"
"                default:\n"
"                    unsupportedRop('PatBlt', rop);\n"
"                    break;\n"
"            }\n"
"        },\n"
"\n"
"        drawDstBlt: function(x, y, w, h, rop) {\n"
"            switch (rop) {\n"
"            case 0x00:\n"
"                _ctx2d.fillStyle = \"#000\";\n"
"                _ctx2d.fillRect(x,y,w,h);\n"
"                break;\n"
"            case 0x55: _transformPixels(x,y,w,h, (src) => src ^ 0xffffff); break;\n"
"            // case 0xAA: break;\n"
"            case 0xff:\n"
"                _ctx2d.fillStyle = \"#fff\";\n"
"                _ctx2d.fillRect(x,y,w,h);\n"
"                break;\n"
"\n"
"            default:\n"
"                unsupportedRop('DstBlt', rop);\n"
"                break;\n"
"            }\n"
"        },\n"
"\n"
"        updatePointerPosition: function(x, y) {\n"
"        },\n"
"    };\n"
"};\n"
"\n"
"const isPowerOf2 = function(value) {\n"
"    return (value & (value - 1)) === 0;\n"
"}\n"
"\n"
"const newRdpGL = function(canvasElement, module, ropError) {\n"
"    const glOptions = {\n"
"        preserveDrawingBuffer: true,\n"
"        antialias: false,\n"
"        alpha: false,\n"
"    };\n"
"    const gl = canvasElement.getContext('webgl', glOptions)\n"
"            || canvasElement.getContext('experimental-webgl', glOptions);\n"
"\n"
"    if (!gl) {\n"
"        return ;\n"
"    }\n"
"\n"
"    let _width = canvasElement.width;\n"
"    let _height = canvasElement.height;\n"
"\n"
"    const _u8buffer = module.HEAPU8.buffer;\n"
"    const _u16buffer = module.HEAPU16.buffer;\n"
"\n"
"    const _imgBuffer = createBuffer(64*64*4, module);\n"
"\n"
"    const unsupportedRop = ropError;\n"
"\n"
"    const compilePairShader = function(prog, code) {\n"
"        const fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);\n"
"        const vertexShader = gl.createShader(gl.VERTEX_SHADER);\n"
"\n"
"        gl.attachShader(prog, fragmentShader);\n"
"        gl.attachShader(prog, vertexShader);\n"
"\n"
"        gl.shaderSource(fragmentShader, code);\n"
"        gl.compileShader(fragmentShader);\n"
"\n"
"        return [vertexShader, fragmentShader];\n"
"    };\n"
"\n"
"    const rectProgram = gl.createProgram();\n"
"    const imgProgram = gl.createProgram();\n"
"    const img24Program = gl.createProgram();\n"
"\n"
"    const [rectVertexShader, rectFragmentShader] = compilePairShader(rectProgram, `\n"
"        // precision highp float;\n"
"        precision mediump float;\n"
"\n"
"        uniform vec3 uColor;\n"
"\n"
"        void main() {\n"
"            gl_FragColor = vec4(uColor.x, uColor.y, uColor.z, 1.0);\n"
"        }`);\n"
"\n"
"    const [imgVertexShader, imgFragmentShader] = compilePairShader(imgProgram, `\n"
"        // precision highp float;\n"
"        precision mediump float;\n"
"        uniform sampler2D texture;\n"
"\n"
"        varying vec2 vTex;\n"
"\n"
"        void main() {\n"
"            gl_FragColor = texture2D(texture, vTex);\n"
"        }`);\n"
"\n"
"    const [img24VertexShader, img24FragmentShader] = compilePairShader(img24Program, `\n"
"        // precision highp float;\n"
"        precision mediump float;\n"
"        uniform sampler2D texture;\n"
"\n"
"        varying vec2 vTex;\n"
"\n"
"        void main() {\n"
"            vec4 color = texture2D(texture, vTex);\n"
"            float tmp = color.x;\n"
"            color.x = color.z;\n"
"            color.z = tmp;\n"
"            gl_FragColor = color;\n"
"        }`);\n"
"\n"
"    const programs = [\n"
"        [rectProgram, rectVertexShader, rectFragmentShader],\n"
"        [imgProgram, imgVertexShader, imgFragmentShader],\n"
"        [img24Program, img24VertexShader, img24FragmentShader],\n"
"    ];\n"
"\n"
"    const compileShader = function(shader, code){\n"
"        gl.shaderSource(shader, code);\n"
"        gl.compileShader(shader);\n"
"    };\n"
"\n"
"    const deletePrograms = function() {\n"
"        for (const [prog, vs, fs] of programs) {\n"
"            gl.deleteProgram(prog);\n"
"        }\n"
"    };\n"
"\n"
"    const buildPrograms = function() {\n"
"        const computePosition = `\n"
"            // clip from 0 to 2\n"
"            vec2 zeroToTwo = aLocation / vec2(${_width/2}, ${_height/2});\n"
"\n"
"            // convert 0->2 to -1->+1\n"
"            vec2 clipSpace = (zeroToTwo - 1.0);\n"
"\n"
"            // flip y coordinate\n"
"            vec2 finalPosition = clipSpace * vec2(1, -1);\n"
"\n"
"            gl_Position = vec4(finalPosition, 0, 1);\n"
"        `;\n"
"\n"
"        compileShader(rectVertexShader, `\n"
"            attribute vec2 aLocation;\n"
"\n"
"            void main() {\n"
"                ${computePosition}\n"
"            }`\n"
"        );\n"
"\n"
"        const imgSource = `\n"
"            attribute vec2 aLocation;\n"
"            attribute vec2 aTextureLocation;\n"
"            // uniform vec2 pos;\n"
"\n"
"            varying vec2 vTex;\n"
"\n"
"            void main() {\n"
"                ${computePosition}\n"
"                vTex = aTextureLocation;\n"
"            }`;\n"
"        compileShader(imgVertexShader, imgSource);\n"
"        compileShader(img24VertexShader, imgSource);\n"
"\n"
"        // link in parallel threads\n"
"        for (const [prog, vs, fs] of programs) {\n"
"            gl.linkProgram(prog);\n"
"        }\n"
"\n"
"        let hasError = false;\n"
"        for (const [prog, vs, fs] of programs) {\n"
"            if (!gl.getProgramParameter(prog, gl.LINK_STATUS)) {\n"
"                console.error('Link failed: ' + gl.getProgramInfoLog(prog));\n"
"                console.error('vs info-log: ' + gl.getShaderInfoLog(vs));\n"
"                console.error('fs info-log: ' + gl.getShaderInfoLog(fs));\n"
"                hasError = true;\n"
"            }\n"
"        }\n"
"\n"
"        if (hasError) {\n"
"            const err = gl.getError();\n"
"            deletePrograms();\n"
"            throw new Error(err);\n"
"        }\n"
"\n"
"        rectProgram.aLocation = gl.getAttribLocation(rectProgram, \"aLocation\");\n"
"        imgProgram.aLocation = gl.getAttribLocation(imgProgram, \"aLocation\");\n"
"        imgProgram.aTextureLocation = gl.getAttribLocation(imgProgram, \"aTextureLocation\");\n"
"        img24Program.aLocation = gl.getAttribLocation(img24Program, \"aLocation\");\n"
"        img24Program.aTextureLocation = gl.getAttribLocation(img24Program, \"aTextureLocation\");\n"
"    };\n"
"\n"
"    const initShaders = function(){\n"
"        buildPrograms();\n"
"\n"
"        gl.viewport(0, 0, _width, _height);\n"
"        gl.clearColor(.0, .0, .0, 1.0);\n"
"        gl.clear(gl.COLOR_BUFFER_BIT);\n"
"    };\n"
"\n"
"    initShaders();\n"
"\n"
"    const rectVertexBuffer = gl.createBuffer();\n"
"    const texVertexBuffer = gl.createBuffer();\n"
"    const texture = gl.createTexture();\n"
"    gl.bindTexture(gl.TEXTURE_2D, texture);\n"
"\n"
"    const drawRect = function(x, y, w, h, color) {\n"
"        // console.log('drawRect');\n"
"        gl.useProgram(rectProgram);\n"
"\n"
"        const vertex = [\n"
"            x+w,y, x,y+h, x,y,\n"
"            x+w,y, x,y+h, x+w,y+h\n"
"        ];\n"
"\n"
"        let vertexArray = new Float32Array(vertex);\n"
"        gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"        gl.bufferData(gl.ARRAY_BUFFER, vertexArray, gl.STATIC_DRAW);\n"
"\n"
"        const aLocation = rectProgram.aLocation;\n"
"\n"
"        gl.enableVertexAttribArray(aLocation);\n"
"        gl.vertexAttribPointer(aLocation, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"        const red   = ((color >> 16) & 0xff) / 255.;\n"
"        const green = ((color >> 8 ) & 0xff) / 255.;\n"
"        const blue  = ((color      ) & 0xff) / 255.;\n"
"\n"
"        const uColor = gl.getUniformLocation(rectProgram, \"uColor\");\n"
"\n"
"        gl.uniform3fv(uColor, [red, green, blue]);\n"
"\n"
"        gl.drawArrays(gl.TRIANGLES, 0, /*vertexCount=*/6);\n"
"    };\n"
"\n"
"    return {\n"
"        get width() { return _width; },\n"
"        get height() { return _height; },\n"
"\n"
"        delete() {\n"
"            deletePrograms();\n"
"        },\n"
"\n"
"        frameMarker: function(isFrameStart) {\n"
"        },\n"
"\n"
"        drawRect: drawRect,\n"
"\n"
"        // mendatory for drawRect\n"
"        drawPatBlt: function(brushData, orgX, orgY, style, x, y, w, h, rop, backColor, foreColor) {\n"
"            switch (rop) {\n"
"                case 0x00: drawRect(x,y,w,h, 0); break;\n"
"                // case 0x05: _transformPixels(x,y,w,h, (src) => ~(backColor | src)); break;\n"
"                // case 0x0f: _transformPixels(x,y,w,h, (src) => ~src); break;\n"
"                // case 0x50: _transformPixels(x,y,w,h, (src) => src & ~backColor); break;\n"
"                // case 0x55: _transformPixels(x,y,w,h, (src) => src ^ 0xffffff); break;\n"
"                // case 0x5a:\n"
"                //     if (style === 0x03) {\n"
"                //         _transformPixelsBrush(x,y,w,h,backColor,foreColor,brushData,\n"
"                //                               (src,c) => src ^ c);\n"
"                //     }\n"
"                //     else {\n"
"                //         _transformPixels(x,y,w,h, (src) => backColor ^ src);\n"
"                //     }\n"
"                //     break;\n"
"                // case 0x5f: _transformPixels(x,y,w,h, (src) => ~(backColor & src)); break;\n"
"                // case 0xa0: _transformPixels(x,y,w,h, (src) => backColor & src); break;\n"
"                // case 0xa5: _transformPixels(x,y,w,h, (src) => ~(backColor ^ src)); break;\n"
"                // case 0xaa: break;\n"
"                // case 0xaf: _transformPixels(x,y,w,h, (src) => backColor | ~src); break;\n"
"                case 0xf0:\n"
"                    const fb = gl.createFramebuffer();\n"
"                    gl.bindFramebuffer(gl.FRAMEBUFFER, fb);\n"
"                    // gl.viewport(0, 0, w,h);\n"
"                    // drawRect(0,0,w,h,0xff00ff);\n"
"                    // const attachmentPoint = gl.COLOR_ATTACHMENT0;\n"
"                    // gl.framebufferTexture2D(gl.FRAMEBUFFER, attachmentPoint,\n"
"                    //                         gl.TEXTURE_2D, texture, 0);\n"
"                    gl.activeTexture(gl.TEXTURE1);\n"
"                    // gl.bindTexture(gl.TEXTURE_2D, texture);\n"
"                    // gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, w, h, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);\n"
"                    // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);\n"
"                    // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);\n"
"                    // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);\n"
"                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture, 0);\n"
"\n"
"                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);\n"
"\n"
"                    const program = imgProgram;\n"
"                    gl.useProgram(program);\n"
"\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"                    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                        x,    y,\n"
"                        x,    y+h,\n"
"                        x+w,  y+h,\n"
"                        x+w,  y,\n"
"                    ]), gl.STATIC_DRAW);\n"
"\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"                    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                        0, 1,\n"
"                        0, 0,\n"
"                        1, 0,\n"
"                        1, 1,\n"
"                    ]), gl.STATIC_DRAW);\n"
"\n"
"                    if (isPowerOf2(w) && isPowerOf2(h)) {\n"
"                        gl.generateMipmap(gl.TEXTURE_2D);\n"
"                    }\n"
"                    else {\n"
"                        // wrapping to clamp to edge\n"
"                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);\n"
"                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);\n"
"                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);\n"
"                    }\n"
"\n"
"                    const vloc = program.aLocation;\n"
"                    const tloc = program.aTextureLocation;\n"
"\n"
"                    gl.enableVertexAttribArray(vloc);\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"                    gl.vertexAttribPointer(vloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"                    gl.enableVertexAttribArray(tloc);\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"                    gl.vertexAttribPointer(tloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"                    gl.drawArrays(gl.TRIANGLE_FAN, 0, /*vertexCount=*/4);\n"
"\n"
"                    // if (style === 0x03) {\n"
"                    //     unsupportedRop('PatBlt', rop);\n"
"                    //     // _transformPixelsBrush(x,y,w,h,backColor,foreColor,brushData,\n"
"                    //     //                       (src,c) => src);\n"
"                    // }\n"
"                    // else {\n"
"                    //     drawRect(x,y,w,h, backColor);\n"
"                    // }\n"
"                    break;\n"
"                // case 0xfa: _transformPixels(x,y,w,h, (src) => src | backColor); break;\n"
"                // case 0xf5: _transformPixels(x,y,w,h, (src) => src | ~backColor); break;\n"
"                // case 0xff: drawRect(x,y,w,h, 0xffffff); break;\n"
"\n"
"                default:\n"
"                    unsupportedRop('PatBlt', rop);\n"
"                    break;\n"
"            }\n"
"        },\n"
"\n"
"        resizeCanvas: function(w, h, bpp) {\n"
"            console.log('RdpGraphics: resize(' + w + ', ' + h + ', ' + bpp + ')');\n"
"            if (_width != w || _height != h) {\n"
"                canvasElement.width = _width = w;\n"
"                canvasElement.height = _height = h;\n"
"                initShaders();\n"
"            }\n"
"            drawRect(0, 0, w, h, 0);\n"
"        },\n"
"\n"
"        drawImage: function(byteOffset, bitsPerPixel, w, h, lineSize, dx, dy) {\n"
"            // console.log('img');\n"
"            let program;\n"
"            let xration;\n"
"            let texWidth;\n"
"            let format;\n"
"            let type;\n"
"            let pixels;\n"
"\n"
"            switch (bitsPerPixel) {\n"
"                case 15:\n"
"                    module.transformBmp15ToBmp16(byteOffset, h, lineSize);\n"
"\n"
"                case 16:\n"
"                    xratio = w * 2 / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize / 2;\n"
"                    format = gl.RGB;\n"
"                    type = gl.UNSIGNED_SHORT_5_6_5;\n"
"                    pixels = new Uint16Array(_u16buffer, byteOffset, texWidth*h);\n"
"                    break;\n"
"\n"
"                case 24:\n"
"                    xratio = w * 3 / lineSize;\n"
"                    program = img24Program;\n"
"                    // what to do if is not divisible by 3?\n"
"                    texWidth = lineSize / 3;\n"
"                    format = gl.RGB;\n"
"                    type = gl.UNSIGNED_BYTE;\n"
"                    pixels = new Uint8Array(_u8buffer, byteOffset, lineSize*h);\n"
"                    break;\n"
"\n"
"                case 32:\n"
"                    xratio = w * 4 / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize / 4;\n"
"                    format = gl.RGBA;\n"
"                    type = gl.UNSIGNED_BYTE;\n"
"                    pixels = new Uint8Array(_u8buffer, byteOffset, lineSize*h);\n"
"                    break;\n"
"\n"
"                case 8:\n"
"                    const bufLen = lineSize*h*2;\n"
"                    const pbuf = _imgBuffer.reserve(bufLen);\n"
"                    module.convertBmp8ToBmp16(pbuf, byteOffset, h, lineSize);\n"
"\n"
"                    xratio = w / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize;\n"
"                    format = gl.RGB;\n"
"                    type = gl.UNSIGNED_SHORT_5_6_5;\n"
"                    pixels = new Uint16Array(_u16buffer, pbuf, texWidth*h);\n"
"                    break;\n"
"\n"
"                default:\n"
"                    console.error(`invalid bitsPerPixel: ${bitsPerPixel}`);\n"
"                    return ;\n"
"            }\n"
"\n"
"            gl.useProgram(program);\n"
"\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"            gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                dx,    dy,\n"
"                dx,    dy+h,\n"
"                dx+w,  dy+h,\n"
"                dx+w,  dy,\n"
"            ]), gl.STATIC_DRAW);\n"
"\n"
"            gl.texImage2D(gl.TEXTURE_2D, 0, format, texWidth, h, 0, format, type, pixels);\n"
"\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"            gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                0, 1,\n"
"                0, 0,\n"
"                xratio, 0,\n"
"                xratio, 1,\n"
"            ]), gl.STATIC_DRAW);\n"
"\n"
"            // WebGL1 has different requirements for power of 2 images\n"
"            // vs non power of 2 images so check if the image is a\n"
"            // power of 2 in both dimensions.\n"
"            if (isPowerOf2(texWidth) && isPowerOf2(h)) {\n"
"                gl.generateMipmap(gl.TEXTURE_2D);\n"
"            }\n"
"            else {\n"
"                // wrapping to clamp to edge\n"
"                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);\n"
"                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);\n"
"                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);\n"
"            }\n"
"\n"
"            // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);\n"
"            // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);\n"
"\n"
"            const vloc = program.aLocation;\n"
"            const tloc = program.aTextureLocation;\n"
"\n"
"            gl.enableVertexAttribArray(vloc);\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"            gl.vertexAttribPointer(vloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"            gl.enableVertexAttribArray(tloc);\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"            gl.vertexAttribPointer(tloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"            gl.drawArrays(gl.TRIANGLE_FAN, 0, /*vertexCount=*/4);\n"
"        },\n"
"    };\n"
"};\n"
"\n"
"const newRdpGL2 = function(canvasElement, module, ropError) {\n"
"    const glOptions = {\n"
"        // TODO premultipliedAlpha: true,\n"
"        preserveDrawingBuffer: true,\n"
"        antialias: false,\n"
"        alpha: false,\n"
"    };\n"
"    const gl = canvasElement.getContext('webgl2', glOptions);\n"
"\n"
"    if (!gl) {\n"
"        return ;\n"
"    }\n"
"\n"
"    let _width = canvasElement.width;\n"
"    let _height = canvasElement.height;\n"
"\n"
"    const _u8buffer = module.HEAPU8.buffer;\n"
"    const _u16buffer = module.HEAPU16.buffer;\n"
"\n"
"    const _imgBuffer = createBuffer(64*64*4, module);\n"
"\n"
"    const unsupportedRop = ropError;\n"
"\n"
"    const compilePairShader = function(prog, code) {\n"
"        const fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);\n"
"        const vertexShader = gl.createShader(gl.VERTEX_SHADER);\n"
"\n"
"        gl.attachShader(prog, fragmentShader);\n"
"        gl.attachShader(prog, vertexShader);\n"
"\n"
"        gl.shaderSource(fragmentShader, code);\n"
"        gl.compileShader(fragmentShader);\n"
"\n"
"        return [vertexShader, fragmentShader];\n"
"    };\n"
"\n"
"    const rectProgram = gl.createProgram();\n"
"    const imgProgram = gl.createProgram();\n"
"    const img24Program = gl.createProgram();\n"
"\n"
"    const [rectVertexShader, rectFragmentShader] = compilePairShader(rectProgram, `\n"
"        // precision highp float;\n"
"        precision mediump float;\n"
"\n"
"        uniform vec3 uColor;\n"
"\n"
"        void main() {\n"
"            gl_FragColor = vec4(uColor.x, uColor.y, uColor.z, 1.0);\n"
"        }`);\n"
"\n"
"    const [imgVertexShader, imgFragmentShader] = compilePairShader(imgProgram, `\n"
"        // precision highp float;\n"
"        precision mediump float;\n"
"        uniform sampler2D texture;\n"
"\n"
"        varying vec2 vTex;\n"
"\n"
"        void main() {\n"
"            gl_FragColor = texture2D(texture, vTex);\n"
"        }`);\n"
"\n"
"    const [img24VertexShader, img24FragmentShader] = compilePairShader(img24Program, `\n"
"        // precision highp float;\n"
"        precision mediump float;\n"
"        uniform sampler2D texture;\n"
"\n"
"        varying vec2 vTex;\n"
"\n"
"        void main() {\n"
"            vec4 color = texture2D(texture, vTex);\n"
"            float tmp = color.x;\n"
"            color.x = color.z;\n"
"            color.z = tmp;\n"
"            gl_FragColor = color;\n"
"        }`);\n"
"\n"
"    const programs = [\n"
"        [rectProgram, rectVertexShader, rectFragmentShader],\n"
"        [imgProgram, imgVertexShader, imgFragmentShader],\n"
"        [img24Program, img24VertexShader, img24FragmentShader],\n"
"    ];\n"
"\n"
"    const compileShader = function(shader, code){\n"
"        gl.shaderSource(shader, code);\n"
"        gl.compileShader(shader);\n"
"    };\n"
"\n"
"    const deletePrograms = function() {\n"
"        for (const [prog, vs, fs] of programs) {\n"
"            gl.deleteProgram(prog);\n"
"        }\n"
"    };\n"
"\n"
"    const buildPrograms = function() {\n"
"        const computePosition = `\n"
"            // clip from 0 to 2\n"
"            vec2 zeroToTwo = aLocation / vec2(${_width/2}, ${_height/2});\n"
"\n"
"            // convert 0->2 to -1->+1\n"
"            vec2 clipSpace = (zeroToTwo - 1.0);\n"
"\n"
"            // flip y coordinate\n"
"            vec2 finalPosition = clipSpace * vec2(1, -1);\n"
"\n"
"            gl_Position = vec4(finalPosition, 0, 1);\n"
"        `;\n"
"\n"
"        compileShader(rectVertexShader, `\n"
"            attribute vec2 aLocation;\n"
"\n"
"            void main() {\n"
"                ${computePosition}\n"
"            }`\n"
"        );\n"
"\n"
"        const imgSource = `\n"
"            attribute vec2 aLocation;\n"
"            attribute vec2 aTextureLocation;\n"
"            // uniform vec2 pos;\n"
"\n"
"            varying vec2 vTex;\n"
"\n"
"            void main() {\n"
"                ${computePosition}\n"
"                vTex = aTextureLocation;\n"
"            }`;\n"
"        compileShader(imgVertexShader, imgSource);\n"
"        compileShader(img24VertexShader, imgSource);\n"
"\n"
"        // link in parallel threads\n"
"        for (const [prog, vs, fs] of programs) {\n"
"            gl.linkProgram(prog);\n"
"        }\n"
"\n"
"        let hasError = false;\n"
"        for (const [prog, vs, fs] of programs) {\n"
"            if (!gl.getProgramParameter(prog, gl.LINK_STATUS)) {\n"
"                console.error('Link failed: ' + gl.getProgramInfoLog(prog));\n"
"                console.error('vs info-log: ' + gl.getShaderInfoLog(vs));\n"
"                console.error('fs info-log: ' + gl.getShaderInfoLog(fs));\n"
"                hasError = true;\n"
"            }\n"
"        }\n"
"\n"
"        if (hasError) {\n"
"            const err = gl.getError();\n"
"            deletePrograms();\n"
"            throw new Error(err);\n"
"        }\n"
"\n"
"        rectProgram.aLocation = gl.getAttribLocation(rectProgram, \"aLocation\");\n"
"        imgProgram.aLocation = gl.getAttribLocation(imgProgram, \"aLocation\");\n"
"        imgProgram.aTextureLocation = gl.getAttribLocation(imgProgram, \"aTextureLocation\");\n"
"        img24Program.aLocation = gl.getAttribLocation(img24Program, \"aLocation\");\n"
"        img24Program.aTextureLocation = gl.getAttribLocation(img24Program, \"aTextureLocation\");\n"
"    };\n"
"\n"
"    const initShaders = function(){\n"
"        buildPrograms();\n"
"\n"
"        gl.viewport(0, 0, _width, _height);\n"
"        gl.clearColor(.0, .0, .0, 1.0);\n"
"        gl.clear(gl.COLOR_BUFFER_BIT);\n"
"    };\n"
"\n"
"    initShaders();\n"
"\n"
"    const rectVertexBuffer = gl.createBuffer();\n"
"    const texVertexBuffer = gl.createBuffer();\n"
"    const texture = gl.createTexture();\n"
"    gl.bindTexture(gl.TEXTURE_2D, texture);\n"
"\n"
"    const drawRect = function(x, y, w, h, color) {\n"
"        // console.log('drawRect');\n"
"        gl.useProgram(rectProgram);\n"
"\n"
"        const vertex = [\n"
"            x+w,y, x,y+h, x,y,\n"
"            x+w,y, x,y+h, x+w,y+h\n"
"        ];\n"
"\n"
"        let vertexArray = new Float32Array(vertex);\n"
"        gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"        gl.bufferData(gl.ARRAY_BUFFER, vertexArray, gl.STATIC_DRAW);\n"
"\n"
"        const aLocation = rectProgram.aLocation;\n"
"\n"
"        gl.enableVertexAttribArray(aLocation);\n"
"        gl.vertexAttribPointer(aLocation, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"        const red   = ((color >> 16) & 0xff) / 255.;\n"
"        const green = ((color >> 8 ) & 0xff) / 255.;\n"
"        const blue  = ((color      ) & 0xff) / 255.;\n"
"\n"
"        // TODO external\n"
"        const uColor = gl.getUniformLocation(rectProgram, \"uColor\");\n"
"\n"
"        gl.uniform3fv(uColor, [red, green, blue]);\n"
"\n"
"        gl.drawArrays(gl.TRIANGLES, 0, /*vertexCount=*/6);\n"
"    };\n"
"\n"
"    return {\n"
"        get width() { return _width; },\n"
"        get height() { return _height; },\n"
"\n"
"        delete() {\n"
"            deletePrograms();\n"
"        },\n"
"\n"
"        frameMarker: function(isFrameStart) {\n"
"        },\n"
"\n"
"        drawRect: drawRect,\n"
"\n"
"        // mendatory for drawRect\n"
"        drawPatBlt: function(brushData, orgX, orgY, style, x, y, w, h, rop, backColor, foreColor) {\n"
"            switch (rop) {\n"
"                case 0x00: drawRect(x,y,w,h, 0); break;\n"
"                // case 0x05: _transformPixels(x,y,w,h, (src) => ~(backColor | src)); break;\n"
"                // case 0x0f: _transformPixels(x,y,w,h, (src) => ~src); break;\n"
"                // case 0x50: _transformPixels(x,y,w,h, (src) => src & ~backColor); break;\n"
"                // case 0x55: _transformPixels(x,y,w,h, (src) => src ^ 0xffffff); break;\n"
"                // case 0x5a:\n"
"                //     if (style === 0x03) {\n"
"                //         _transformPixelsBrush(x,y,w,h,backColor,foreColor,brushData,\n"
"                //                               (src,c) => src ^ c);\n"
"                //     }\n"
"                //     else {\n"
"                //         _transformPixels(x,y,w,h, (src) => backColor ^ src);\n"
"                //     }\n"
"                //     break;\n"
"                // case 0x5f: _transformPixels(x,y,w,h, (src) => ~(backColor & src)); break;\n"
"                // case 0xa0: _transformPixels(x,y,w,h, (src) => backColor & src); break;\n"
"                // case 0xa5: _transformPixels(x,y,w,h, (src) => ~(backColor ^ src)); break;\n"
"                // case 0xaa: break;\n"
"                // case 0xaf: _transformPixels(x,y,w,h, (src) => backColor | ~src); break;\n"
"                case 0xf0:\n"
"                    const fb = gl.createFramebuffer();\n"
"                    gl.bindFramebuffer(gl.FRAMEBUFFER, fb);\n"
"                    // gl.viewport(0, 0, w,h);\n"
"                    // drawRect(0,0,w,h,0xff00ff);\n"
"                    // const attachmentPoint = gl.COLOR_ATTACHMENT0;\n"
"                    // gl.framebufferTexture2D(gl.FRAMEBUFFER, attachmentPoint,\n"
"                    //                         gl.TEXTURE_2D, texture, 0);\n"
"                    gl.activeTexture(gl.TEXTURE1);\n"
"                    // gl.bindTexture(gl.TEXTURE_2D, texture);\n"
"                    // gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, w, h, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);\n"
"                    // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);\n"
"                    // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);\n"
"                    // gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);\n"
"                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture, 0);\n"
"\n"
"                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);\n"
"\n"
"                    const program = imgProgram;\n"
"                    gl.useProgram(program);\n"
"\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"                    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                        x,    y,\n"
"                        x,    y+h,\n"
"                        x+w,  y+h,\n"
"                        x+w,  y,\n"
"                    ]), gl.STATIC_DRAW);\n"
"\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"                    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                        0, 1,\n"
"                        0, 0,\n"
"                        1, 0,\n"
"                        1, 1,\n"
"                    ]), gl.STATIC_DRAW);\n"
"\n"
"                    if (isPowerOf2(w) && isPowerOf2(h)) {\n"
"                        gl.generateMipmap(gl.TEXTURE_2D);\n"
"                    }\n"
"                    else {\n"
"                        // wrapping to clamp to edge\n"
"                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);\n"
"                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);\n"
"                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);\n"
"                    }\n"
"\n"
"                    const vloc = program.aLocation;\n"
"                    const tloc = program.aTextureLocation;\n"
"\n"
"                    gl.enableVertexAttribArray(vloc);\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"                    gl.vertexAttribPointer(vloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"                    gl.enableVertexAttribArray(tloc);\n"
"                    gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"                    gl.vertexAttribPointer(tloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"                    gl.drawArrays(gl.TRIANGLE_FAN, 0, /*vertexCount=*/4);\n"
"\n"
"                    // if (style === 0x03) {\n"
"                    //     unsupportedRop('PatBlt', rop);\n"
"                    //     // _transformPixelsBrush(x,y,w,h,backColor,foreColor,brushData,\n"
"                    //     //                       (src,c) => src);\n"
"                    // }\n"
"                    // else {\n"
"                    //     drawRect(x,y,w,h, backColor);\n"
"                    // }\n"
"                    break;\n"
"                // case 0xfa: _transformPixels(x,y,w,h, (src) => src | backColor); break;\n"
"                // case 0xf5: _transformPixels(x,y,w,h, (src) => src | ~backColor); break;\n"
"                // case 0xff: drawRect(x,y,w,h, 0xffffff); break;\n"
"\n"
"                default:\n"
"                    unsupportedRop('PatBlt', rop);\n"
"                    break;\n"
"            }\n"
"        },\n"
"\n"
"        resizeCanvas: function(w, h, bpp) {\n"
"            console.log('RdpGraphics: resize(' + w + ', ' + h + ', ' + bpp + ')');\n"
"            if (_width != w || _height != h) {\n"
"                canvasElement.width = _width = w;\n"
"                canvasElement.height = _height = h;\n"
"                initShaders();\n"
"            }\n"
"            drawRect(0, 0, w, h, 0);\n"
"        },\n"
"\n"
"        drawImage: function(byteOffset, bitsPerPixel, w, h, lineSize, dx, dy) {\n"
"            // console.log('img');\n"
"            let program;\n"
"            let xration;\n"
"            let texWidth;\n"
"            let format;\n"
"            let type;\n"
"            let pixels;\n"
"\n"
"            switch (bitsPerPixel) {\n"
"                case 15:\n"
"                    xratio = w * 2 / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize / 2;\n"
"                    format = gl.RGB565;\n"
"                    type = gl.UNSIGNED_SHORT_5_6_5;\n"
"                    pixels = new Uint16Array(_u16buffer, byteOffset, texWidth*h);\n"
"\n"
"                case 16:\n"
"                    xratio = w * 2 / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize / 2;\n"
"                    format = gl.RGB;\n"
"                    type = gl.UNSIGNED_SHORT_5_6_5;\n"
"                    pixels = new Uint16Array(_u16buffer, byteOffset, texWidth*h);\n"
"                    break;\n"
"\n"
"                case 24:\n"
"                    xratio = w * 3 / lineSize;\n"
"                    program = img24Program;\n"
"                    // what to do if is not divisible by 3?\n"
"                    texWidth = lineSize / 3;\n"
"                    format = gl.RGB;\n"
"                    type = gl.UNSIGNED_BYTE;\n"
"                    pixels = new Uint8Array(_u8buffer, byteOffset, lineSize*h);\n"
"                    break;\n"
"\n"
"                case 32:\n"
"                    xratio = w * 4 / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize / 4;\n"
"                    format = gl.RGBA;\n"
"                    type = gl.UNSIGNED_BYTE;\n"
"                    pixels = new Uint8Array(_u8buffer, byteOffset, lineSize*h);\n"
"                    break;\n"
"\n"
"                case 8:\n"
"                    const bufLen = lineSize*h*2;\n"
"                    const pbuf = _imgBuffer.reserve(bufLen);\n"
"                    module.convertBmp8ToBmp16(pbuf, byteOffset, h, lineSize);\n"
"\n"
"                    xratio = w / lineSize;\n"
"                    program = imgProgram;\n"
"                    texWidth = lineSize;\n"
"                    format = gl.RGB;\n"
"                    type = gl.UNSIGNED_SHORT_5_6_5;\n"
"                    pixels = new Uint16Array(_u16buffer, pbuf, texWidth*h);\n"
"                    break;\n"
"\n"
"                default:\n"
"                    console.error(`invalid bitsPerPixel: ${bitsPerPixel}`);\n"
"                    return ;\n"
"            }\n"
"\n"
"            gl.useProgram(program);\n"
"\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"            gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                dx,    dy,\n"
"                dx,    dy+h,\n"
"                dx+w,  dy+h,\n"
"                dx+w,  dy,\n"
"            ]), gl.STATIC_DRAW);\n"
"\n"
"            gl.texImage2D(gl.TEXTURE_2D, 0, format, texWidth, h, 0, format, type, pixels);\n"
"\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"            gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([\n"
"                0, 1,\n"
"                0, 0,\n"
"                xratio, 0,\n"
"                xratio, 1,\n"
"            ]), gl.STATIC_DRAW);\n"
"\n"
"            gl.generateMipmap(gl.TEXTURE_2D);\n"
"\n"
"            const vloc = program.aLocation;\n"
"            const tloc = program.aTextureLocation;\n"
"\n"
"            gl.enableVertexAttribArray(vloc);\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, rectVertexBuffer);\n"
"            gl.vertexAttribPointer(vloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"            gl.enableVertexAttribArray(tloc);\n"
"            gl.bindBuffer(gl.ARRAY_BUFFER, texVertexBuffer);\n"
"            gl.vertexAttribPointer(tloc, /*numComponents=*/2, gl.FLOAT, false, 0, 0);\n"
"\n"
"            gl.drawArrays(gl.TRIANGLE_FAN, 0, /*vertexCount=*/4);\n"
"        },\n"
"    };\n"
"};\n"
"\n"
"const createCtx = function(...contexts) {\n"
"    const deleters = [];\n"
"    for (const ctx of contexts) {\n"
"        if (ctx.delete) {\n"
"            deleters.push(ctx.delete);\n"
"        }\n"
"    }\n"
"\n"
"    let deleter;\n"
"    switch (deleters.length) {\n"
"        case 0: deleter = function() {}; break;\n"
"        case 1: deleter = deleters[0]; break;\n"
"        default: deleter = () => { for (deleter of deleters) deleter(); }; break;\n"
"    }\n"
"\n"
"    const ret = Object.assign(...contexts);\n"
"    ret.delete = deleter;\n"
"    return ret;\n"
"};\n"
"\n"
"const getDefaultRopError = function() {\n"
"    let loggedMap = {};\n"
"    return function(cmd, rop) {\n"
"        const k = cmd + rop;\n"
"        if (!(k in loggedMap)) {\n"
"            loggedMap[k] = true;\n"
"            console.error(`${cmd}: Unsupported rop 0x${rop.toString(16).padStart(2, '0')}`);\n"
"        }\n"
"    };\n"
"};\n"
"\n"
"const newRdpGraphics2D = function(canvasElement, module, ropError) {\n"
"    ropError = ropError || getDefaultRopError();\n"
"    return createCtx(newRdpCanvas(canvasElement, module, ropError),\n"
"                     newRdpPointer(canvasElement, module));\n"
"};\n"
"\n"
"const newRdpGraphicsGL = function(canvasElement, module, ropError) {\n"
"    ropError = ropError || getDefaultRopError();\n"
"    return createCtx(newRdpGL(canvasElement, module, ropError),\n"
"                     newRdpPointer(canvasElement, module));\n"
"};\n"
"\n"
"const newRdpGraphicsGL2 = function(canvasElement, module, ropError) {\n"
"    ropError = ropError || getDefaultRopError();\n"
"    return createCtx(newRdpGL2(canvasElement, module, ropError),\n"
"                     newRdpPointer(canvasElement, module));\n"
"};\n"
"\n"
"const newRdpGraphics = function(canvasElement, module, ropError) {\n"
"    ropError = ropError || getDefaultRopError();\n"
"    const ctx = newRdpGL2(canvasElement, module, ropError)\n"
"             || newRdpCanvas(canvasElement, module, ropError);\n"
"    return ctx ? createCtx(ctx, newRdpPointer(canvasElement, module)) : undefined;\n"
"};\n"
"\n"
"try {\n"
"    module.exports.newRdpGraphics2D = newRdpGraphics2D;\n"
"    module.exports.newRdpGraphicsGL = newRdpGraphicsGL;\n"
"    module.exports.newRdpGraphicsGL2 = newRdpGraphicsGL2;\n"
"    module.exports.newRdpGraphics = newRdpGraphics;\n"
"    module.exports.newRdpCanvas = newRdpCanvas;\n"
"    module.exports.newRdpGL = newRdpGL;\n"
"    module.exports.newRdpGL2 = newRdpGL2;\n"
"    module.exports.newRdpPointer = newRdpPointer;\n"
"}\n"
"catch (e) {\n"
"    // module not found\n"
"}\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/rdp_graphics.js") == 0) {
        if (size) *size = strlen(rdp_rdp_graphics_js);
        return rdp_rdp_graphics_js;
    }
const char *rdp_reversed_layouts_js =
"// keymap: { text: { mod_flags: scancode } }\n"
"// deadkeys: { text: [ idxAccent, idxKeymap, idxKeymap ? ]\n"
"// accents: [ { mod_flags: scancode } ]\n"
"const layouts = [\n"
"{\n"
"  klid: 0x00000405,\n"
"  localeName: \"cs\",\n"
"  displayName: \"Czech\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '+': { 0x0: 0x2, 0x1: 0x4e, },\n"
"    'ě': { 0x0: 0x3, },\n"
"    'š': { 0x0: 0x4, },\n"
"    'č': { 0x0: 0x5, },\n"
"    'ř': { 0x0: 0x6, },\n"
"    'ž': { 0x0: 0x7, },\n"
"    'ý': { 0x0: 0x8, },\n"
"    'á': { 0x0: 0x9, },\n"
"    'í': { 0x0: 0xa, },\n"
"    'é': { 0x0: 0xb, },\n"
"    '=': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ú': { 0x0: 0x1a, },\n"
"    ')': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ů': { 0x0: 0x27, },\n"
"    '§': { 0x0: 0x28, },\n"
"    ';': { 0x0: 0x29, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '\\\\': { 0x0: 0x56, 0x2: 0x10, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x1a, 0x5: 0x1a, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, 0x5: 0x3, },\n"
"    '3': { 0x1: 0x4, 0x5: 0x4, },\n"
"    '4': { 0x1: 0x5, 0x5: 0x5, },\n"
"    '5': { 0x1: 0x6, 0x5: 0x6, },\n"
"    '6': { 0x1: 0x7, 0x5: 0x7, },\n"
"    '7': { 0x1: 0x8, 0x5: 0x8, },\n"
"    '8': { 0x1: 0x9, 0x5: 0x9, },\n"
"    '9': { 0x1: 0xa, 0x5: 0xa, },\n"
"    '0': { 0x1: 0xb, 0x5: 0xb, },\n"
"    '%': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '(': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '\"': { 0x1: 0x27, 0x5: 0x27, },\n"
"    '!': { 0x1: 0x28, },\n"
"    '\\'': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '?': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, 0x2: 0x11, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0x35, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    'đ': { 0x2: 0x1f, },\n"
"    'Đ': { 0x2: 0x20, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    '$': { 0x2: 0x27, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '¤': { 0x2: 0x2b, },\n"
"    '#': { 0x2: 0x2d, },\n"
"    '&': { 0x2: 0x2e, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"    'Ě': { 0x4: 0x3, },\n"
"    'Š': { 0x4: 0x4, },\n"
"    'Č': { 0x4: 0x5, },\n"
"    'Ř': { 0x4: 0x6, },\n"
"    'Ž': { 0x4: 0x7, },\n"
"    'Ý': { 0x4: 0x8, },\n"
"    'Á': { 0x4: 0x9, },\n"
"    'Í': { 0x4: 0xa, },\n"
"    'É': { 0x4: 0xb, },\n"
"    'Ú': { 0x4: 0x1a, },\n"
"    'Ů': { 0x4: 0x27, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ÿ': [1, ['Y', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'ľ': [2, ['l', ]],\n"
"    'Ľ': [2, ['L', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'å': [3, ['a', ]],\n"
"    'Å': [3, ['A', ]],\n"
"    'ů': [3, ['u', ]],\n"
"    'Ů': [3, ['U', ]],\n"
"    '°': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'ô': [4, ['o', ]],\n"
"    'Ô': [4, ['O', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    '^': [4, [' ', ]],\n"
"    'ă': [5, ['a', ]],\n"
"    'Ă': [5, ['A', ]],\n"
"    'ğ': [5, ['g', ]],\n"
"    'Ğ': [5, ['G', ]],\n"
"    '˘': [5, [' ', ]],\n"
"    'ą': [6, ['a', ]],\n"
"    'Ą': [6, ['A', ]],\n"
"    'ę': [6, ['e', ]],\n"
"    'Ę': [6, ['E', ]],\n"
"    'į': [6, ['i', ]],\n"
"    'Į': [6, ['I', ]],\n"
"    'ų': [6, ['u', ]],\n"
"    'Ų': [6, ['U', ]],\n"
"    '˛': [6, [' ', ]],\n"
"    'à': [7, ['a', ]],\n"
"    'À': [7, ['A', ]],\n"
"    'è': [7, ['e', ]],\n"
"    'È': [7, ['E', ]],\n"
"    'ì': [7, ['i', ]],\n"
"    'Ì': [7, ['I', ]],\n"
"    'ò': [7, ['o', ]],\n"
"    'Ò': [7, ['O', ]],\n"
"    'ù': [7, ['u', ]],\n"
"    'Ù': [7, ['U', ]],\n"
"    '`': [7, [' ', ]],\n"
"    'ė': [8, ['e', ]],\n"
"    'Ė': [8, ['E', ]],\n"
"    'ı': [8, ['i', ]],\n"
"    'İ': [8, ['I', ]],\n"
"    'ż': [8, ['z', ]],\n"
"    'Ż': [8, ['Z', ]],\n"
"    '·': [8, [' ', ]],\n"
"    'ő': [9, ['o', ]],\n"
"    'Ő': [9, ['O', ]],\n"
"    'ű': [9, ['u', ]],\n"
"    'Ű': [9, ['U', ]],\n"
"    '˝': [9, [' ', ]],\n"
"    'ç': [10, ['c', ]],\n"
"    'Ç': [10, ['C', ]],\n"
"    'ģ': [10, ['g', ]],\n"
"    'Ģ': [10, ['G', ]],\n"
"    'ķ': [10, ['k', ]],\n"
"    'Ķ': [10, ['K', ]],\n"
"    'ļ': [10, ['l', ]],\n"
"    'Ļ': [10, ['L', ]],\n"
"    'ņ': [10, ['n', ]],\n"
"    'Ņ': [10, ['N', ]],\n"
"    'ŗ': [10, ['r', ]],\n"
"    'Ŗ': [10, ['R', ]],\n"
"    'ş': [10, ['s', ]],\n"
"    'Ş': [10, ['S', ]],\n"
"    'ţ': [10, ['t', ]],\n"
"    'Ţ': [10, ['T', ]],\n"
"    '¸': [10, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, 0x2: 0xa, },\n"
"    {0x0: 0x2b, 0x2: 0xc, },\n"
"    {0x1: 0xd, 0x2: 0x3, },\n"
"    {0x1: 0x29, 0x2: 0x6, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x8, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xb, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000406,\n"
"  localeName: \"da\",\n"
"  displayName: \"Danish\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'æ': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ø': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '½': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Æ': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ø': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '§': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '|': { 0x2: 0xd, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000407,\n"
"  localeName: \"de-DE\",\n"
"  displayName: \"German\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, 0x5: 0x2, },\n"
"    '2': { 0x0: 0x3, 0x5: 0x3, },\n"
"    '3': { 0x0: 0x4, 0x5: 0x4, },\n"
"    '4': { 0x0: 0x5, 0x5: 0x5, },\n"
"    '5': { 0x0: 0x6, 0x5: 0x6, },\n"
"    '6': { 0x0: 0x7, 0x5: 0x7, },\n"
"    '7': { 0x0: 0x8, 0x5: 0x8, },\n"
"    '8': { 0x0: 0x9, 0x5: 0x9, },\n"
"    '9': { 0x0: 0xa, 0x5: 0xa, },\n"
"    '0': { 0x0: 0xb, 0x5: 0xb, },\n"
"    'ß': { 0x0: 0xc, 0x5: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ü': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '+': { 0x0: 0x1b, 0x1: 0x4e, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '#': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, 0x5: 0x33, },\n"
"    '.': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, 0x4: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, 0x4: 0x2, },\n"
"    '\"': { 0x1: 0x3, 0x4: 0x3, },\n"
"    '§': { 0x1: 0x4, 0x4: 0x4, },\n"
"    '$': { 0x1: 0x5, 0x4: 0x5, },\n"
"    '%': { 0x1: 0x6, 0x4: 0x6, },\n"
"    '&': { 0x1: 0x7, 0x4: 0x7, },\n"
"    '(': { 0x1: 0x9, 0x4: 0x9, },\n"
"    ')': { 0x1: 0xa, 0x4: 0xa, },\n"
"    '=': { 0x1: 0xb, 0x4: 0xb, },\n"
"    '?': { 0x1: 0xc, 0x4: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ü': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '°': { 0x1: 0x29, },\n"
"    '\\'': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, 0x4: 0x33, },\n"
"    ':': { 0x1: 0x34, 0x4: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0x35, },\n"
"    'ẞ': { 0x3: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '@': { 0x2: 0x10, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '~': { 0x2: 0x1b, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '|': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'â': [1, ['a', ]],\n"
"    'ê': [1, ['e', ]],\n"
"    'î': [1, ['i', ]],\n"
"    'ô': [1, ['o', ]],\n"
"    'û': [1, ['u', ]],\n"
"    'Â': [1, ['A', ]],\n"
"    'Ê': [1, ['E', ]],\n"
"    'Î': [1, ['I', ]],\n"
"    'Ô': [1, ['O', ]],\n"
"    'Û': [1, ['U', ]],\n"
"    '^': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x29, },\n"
"    {0x1: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    ';': { 0x0: 0x10, },\n"
"    'ς': { 0x0: 0x11, },\n"
"    'ε': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'ρ': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'τ': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'υ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'θ': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ι': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ο': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'π': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'α': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'σ': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'δ': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'φ': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'γ': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'η': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ξ': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'κ': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'λ': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'χ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'ω': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'β': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'ν': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'μ': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '<': { 0x0: 0x56, 0x1: 0x33, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    ':': { 0x1: 0x10, },\n"
"    'Ε': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Ρ': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Τ': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Υ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Θ': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ι': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ο': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'Π': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'Α': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Δ': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Φ': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Γ': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Η': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ξ': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Κ': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Λ': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Β': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Ν': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Μ': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x28, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '£': { 0x2: 0x5, },\n"
"    '§': { 0x2: 0x6, },\n"
"    '¶': { 0x2: 0x7, },\n"
"    '¤': { 0x2: 0x9, },\n"
"    '¦': { 0x2: 0xa, },\n"
"    '°': { 0x2: 0xb, },\n"
"    '±': { 0x2: 0xc, },\n"
"    '½': { 0x2: 0xd, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '®': { 0x2: 0x13, },\n"
"    '¥': { 0x2: 0x15, },\n"
"    '«': { 0x2: 0x1a, },\n"
"    '»': { 0x2: 0x1b, },\n"
"    '¬': { 0x2: 0x2b, },\n"
"    '©': { 0x2: 0x2e, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ά': [0, ['α', ]],\n"
"    'έ': [0, ['ε', ]],\n"
"    'ί': [0, ['ι', ]],\n"
"    'ό': [0, ['ο', ]],\n"
"    'ύ': [0, ['υ', ]],\n"
"    'ώ': [0, ['ω', ]],\n"
"    'ή': [0, ['η', ]],\n"
"    'Ά': [0, ['Α', ]],\n"
"    'Έ': [0, ['Ε', ]],\n"
"    'Ί': [0, ['Ι', ]],\n"
"    'Ό': [0, ['Ο', ]],\n"
"    'Ύ': [0, ['Υ', ]],\n"
"    'Ώ': [0, ['Ω', ]],\n"
"    'Ή': [0, ['Η', ]],\n"
"    '΄': [0, [' ', ]],\n"
"    'ΐ': [1, ['ι', ]],\n"
"    'ΰ': [1, ['υ', ]],\n"
"    '΅': [1, [' ', ]],\n"
"    'ϊ': [2, ['ι', ]],\n"
"    'ϋ': [2, ['υ', ]],\n"
"    'Ϊ': [2, ['Ι', ]],\n"
"    'Ϋ': [2, ['Υ', ]],\n"
"    '¨': [2, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x27, },\n"
"    {0x1: 0x11, 0x2: 0x27, },\n"
"    {0x1: 0x27, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000409,\n"
"  localeName: \"en-US\",\n"
"  displayName: \"United States - English\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000040a,\n"
"  localeName: \"es-ES\",\n"
"  displayName: \"Spanish\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '¡': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '+': { 0x0: 0x1b, 0x1: 0x4e, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ñ': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'º': { 0x0: 0x29, },\n"
"    'ç': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '·': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '¿': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ñ': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'ª': { 0x1: 0x29, },\n"
"    'Ç': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '|': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '{': { 0x2: 0x28, },\n"
"    '\\\\': { 0x2: 0x29, },\n"
"    '}': { 0x2: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"    'à': [0, ['a', ]],\n"
"    'è': [0, ['e', ]],\n"
"    'ì': [0, ['i', ]],\n"
"    'ò': [0, ['o', ]],\n"
"    'ù': [0, ['u', ]],\n"
"    'À': [0, ['A', ]],\n"
"    'È': [0, ['E', ]],\n"
"    'Ì': [0, ['I', ]],\n"
"    'Ò': [0, ['O', ]],\n"
"    'Ù': [0, ['U', ]],\n"
"    '`': [0, [' ', ]],\n"
"    'á': [1, ['a', ]],\n"
"    'é': [1, ['e', ]],\n"
"    'í': [1, ['i', ]],\n"
"    'ó': [1, ['o', ]],\n"
"    'ú': [1, ['u', ]],\n"
"    'ý': [1, ['y', ]],\n"
"    'Á': [1, ['A', ]],\n"
"    'É': [1, ['E', ]],\n"
"    'Í': [1, ['I', ]],\n"
"    'Ó': [1, ['O', ]],\n"
"    'Ú': [1, ['U', ]],\n"
"    'Ý': [1, ['Y', ]],\n"
"    '´': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'ä': [3, ['a', ]],\n"
"    'ë': [3, ['e', ]],\n"
"    'ï': [3, ['i', ]],\n"
"    'ö': [3, ['o', ]],\n"
"    'ü': [3, ['u', ]],\n"
"    'ÿ': [3, ['y', ]],\n"
"    'Ä': [3, ['A', ]],\n"
"    'Ë': [3, ['E', ]],\n"
"    'Ï': [3, ['I', ]],\n"
"    'Ö': [3, ['O', ]],\n"
"    'Ü': [3, ['U', ]],\n"
"    '¨': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, },\n"
"    {0x0: 0x28, },\n"
"    {0x1: 0x1a, },\n"
"    {0x1: 0x28, },\n"
"    {0x2: 0x5, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000040b,\n"
"  localeName: \"fi\",\n"
"  displayName: \"Finnish\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '§': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '½': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '|': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000040c,\n"
"  localeName: \"fr-FR\",\n"
"  displayName: \"French\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '&': { 0x0: 0x2, 0x5: 0x2, },\n"
"    'é': { 0x0: 0x3, 0x5: 0x3, },\n"
"    '\"': { 0x0: 0x4, 0x5: 0x4, },\n"
"    '\\'': { 0x0: 0x5, 0x5: 0x5, },\n"
"    '(': { 0x0: 0x6, 0x5: 0x6, },\n"
"    '-': { 0x0: 0x7, 0x1: 0x4a, 0x5: 0x7, },\n"
"    'è': { 0x0: 0x8, 0x5: 0x8, },\n"
"    '_': { 0x0: 0x9, 0x5: 0x9, },\n"
"    'ç': { 0x0: 0xa, 0x5: 0xa, },\n"
"    'à': { 0x0: 0xb, 0x5: 0xb, },\n"
"    ')': { 0x0: 0xc, 0x5: 0xc, },\n"
"    '=': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'a': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'z': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '$': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'q': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'm': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ù': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '²': { 0x0: 0x29, },\n"
"    '*': { 0x0: 0x2b, 0x1: 0x37, 0x5: 0x2b, },\n"
"    'w': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    ',': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ';': { 0x0: 0x33, 0x5: 0x33, },\n"
"    ':': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '!': { 0x0: 0x35, 0x5: 0x35, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, 0x4: 0xd, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, 0x4: 0x2, },\n"
"    '2': { 0x1: 0x3, 0x4: 0x3, },\n"
"    '3': { 0x1: 0x4, 0x4: 0x4, },\n"
"    '4': { 0x1: 0x5, 0x4: 0x5, },\n"
"    '5': { 0x1: 0x6, 0x4: 0x6, },\n"
"    '6': { 0x1: 0x7, 0x4: 0x7, },\n"
"    '7': { 0x1: 0x8, 0x4: 0x8, },\n"
"    '8': { 0x1: 0x9, 0x4: 0x9, },\n"
"    '9': { 0x1: 0xa, 0x4: 0xa, },\n"
"    '0': { 0x1: 0xb, 0x4: 0xb, },\n"
"    '°': { 0x1: 0xc, 0x4: 0xc, },\n"
"    'A': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Z': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '£': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Q': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'M': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '%': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'µ': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'W': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    '?': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '.': { 0x1: 0x33, 0x4: 0x33, },\n"
"    '§': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1f': { 0x1: 0x7, },\n"
"    '\\x1c': { 0x1: 0x9, 0x0: 0x2b, },\n"
"    '\\x1e': { 0x1: 0xa, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '{': { 0x2: 0x5, },\n"
"    '[': { 0x2: 0x6, },\n"
"    '|': { 0x2: 0x7, },\n"
"    '\\\\': { 0x2: 0x9, },\n"
"    '^': { 0x2: 0xa, },\n"
"    '@': { 0x2: 0xb, },\n"
"    ']': { 0x2: 0xc, },\n"
"    '}': { 0x2: 0xd, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '¤': { 0x2: 0x1b, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ã': [2, ['a', ]],\n"
"    'Ã': [2, ['A', ]],\n"
"    'ñ': [2, ['n', ]],\n"
"    'Ñ': [2, ['N', ]],\n"
"    'õ': [2, ['o', ]],\n"
"    'Õ': [2, ['O', ]],\n"
"    '~': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, 0x5: 0x1a, },\n"
"    {0x1: 0x1a, 0x4: 0x1a, },\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x8, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000040f,\n"
"  localeName: \"is\",\n"
"  displayName: \"Icelandic\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    'ö': { 0x0: 0xc, 0x5: 0xc, },\n"
"    '-': { 0x0: 0xd, 0x1: 0x4a, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ð': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\'': { 0x0: 0x1b, 0x1: 0x28, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'æ': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '+': { 0x0: 0x2b, 0x1: 0x4e, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    'þ': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    'Ö': { 0x1: 0xc, 0x4: 0xc, },\n"
"    '_': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ð': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    '?': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Æ': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    'Þ': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '@': { 0x2: 0x10, },\n"
"    '~': { 0x2: 0x1b, },\n"
"    '°': { 0x2: 0x29, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '|': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'å': [1, ['a', ]],\n"
"    'Å': [1, ['A', ]],\n"
"    '°': [1, [' ', ]],\n"
"    'ä': [2, ['a', ]],\n"
"    'ë': [2, ['e', ]],\n"
"    'ï': [2, ['i', ]],\n"
"    'ö': [2, ['o', ]],\n"
"    'ü': [2, ['u', ]],\n"
"    'ÿ': [2, ['y', ]],\n"
"    'Ä': [2, ['A', ]],\n"
"    'Ë': [2, ['E', ]],\n"
"    'Ï': [2, ['I', ]],\n"
"    'Ö': [2, ['O', ]],\n"
"    'Ü': [2, ['U', ]],\n"
"    '¨': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'à': [4, ['a', ]],\n"
"    'è': [4, ['e', ]],\n"
"    'ì': [4, ['i', ]],\n"
"    'ò': [4, ['o', ]],\n"
"    'ù': [4, ['u', ]],\n"
"    'À': [4, ['A', ]],\n"
"    'È': [4, ['E', ]],\n"
"    'Ì': [4, ['I', ]],\n"
"    'Ò': [4, ['O', ]],\n"
"    'Ù': [4, ['U', ]],\n"
"    '`': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x28, },\n"
"    {0x0: 0x29, },\n"
"    {0x1: 0x29, },\n"
"    {0x2: 0x28, },\n"
"    {0x2: 0x2b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000410,\n"
"  localeName: \"it-IT\",\n"
"  displayName: \"Italian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    'ì': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'è': { 0x0: 0x1a, },\n"
"    '+': { 0x0: 0x1b, 0x1: 0x4e, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ò': { 0x0: 0x27, },\n"
"    'à': { 0x0: 0x28, },\n"
"    '\\\\': { 0x0: 0x29, },\n"
"    'ù': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '^': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'é': { 0x1: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'ç': { 0x1: 0x27, },\n"
"    '°': { 0x1: 0x28, },\n"
"    '|': { 0x1: 0x29, },\n"
"    '§': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '{': { 0x3: 0x1a, },\n"
"    '}': { 0x3: 0x1b, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '@': { 0x2: 0x27, },\n"
"    '#': { 0x2: 0x28, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000413,\n"
"  localeName: \"nl-NL\",\n"
"  displayName: \"Dutch\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '/': { 0x0: 0xc, 0x1: 0x35, },\n"
"    '°': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '*': { 0x0: 0x1b, 0x1: 0x37, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '+': { 0x0: 0x27, 0x1: 0x4e, },\n"
"    '@': { 0x0: 0x29, },\n"
"    '<': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    ']': { 0x0: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '_': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '\\'': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '|': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '±': { 0x1: 0x27, },\n"
"    '§': { 0x1: 0x29, },\n"
"    '>': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '=': { 0x1: 0x35, },\n"
"    '[': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1c': { 0x0: 0xc, },\n"
"    '\\x1d': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '¹': { 0x2: 0x2, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '¼': { 0x2: 0x5, },\n"
"    '½': { 0x2: 0x6, },\n"
"    '¾': { 0x2: 0x7, },\n"
"    '£': { 0x2: 0x8, },\n"
"    '{': { 0x2: 0x9, },\n"
"    '}': { 0x2: 0xa, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '¶': { 0x2: 0x13, },\n"
"    'ß': { 0x2: 0x1f, },\n"
"    '¬': { 0x2: 0x29, },\n"
"    '«': { 0x2: 0x2c, },\n"
"    '»': { 0x2: 0x2d, },\n"
"    '¢': { 0x2: 0x2e, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '·': { 0x2: 0x34, },\n"
"    '¦': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ä': [0, ['a', ]],\n"
"    'ë': [0, ['e', ]],\n"
"    'ï': [0, ['i', ]],\n"
"    'ö': [0, ['o', ]],\n"
"    'ü': [0, ['u', ]],\n"
"    'ÿ': [0, ['y', ]],\n"
"    'Ä': [0, ['A', ]],\n"
"    'Ë': [0, ['E', ]],\n"
"    'Ï': [0, ['I', ]],\n"
"    'Ö': [0, ['O', ]],\n"
"    'Ü': [0, ['U', ]],\n"
"    '¨': [0, [' ', ]],\n"
"    'á': [1, ['a', ]],\n"
"    'é': [1, ['e', ]],\n"
"    'í': [1, ['i', ]],\n"
"    'ó': [1, ['o', ]],\n"
"    'ú': [1, ['u', ]],\n"
"    'ý': [1, ['y', ]],\n"
"    'Á': [1, ['A', ]],\n"
"    'É': [1, ['E', ]],\n"
"    'Í': [1, ['I', ]],\n"
"    'Ó': [1, ['O', ]],\n"
"    'Ú': [1, ['U', ]],\n"
"    'Ý': [1, ['Y', ]],\n"
"    '´': [1, [' ', ]],\n"
"    'ã': [2, ['a', ]],\n"
"    'õ': [2, ['o', ]],\n"
"    'ñ': [2, ['n', ]],\n"
"    'Ã': [2, ['A', ]],\n"
"    'Õ': [2, ['O', ]],\n"
"    'Ñ': [2, ['N', ]],\n"
"    '~': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'à': [4, ['a', ]],\n"
"    'è': [4, ['e', ]],\n"
"    'ì': [4, ['i', ]],\n"
"    'ò': [4, ['o', ]],\n"
"    'ù': [4, ['u', ]],\n"
"    'À': [4, ['A', ]],\n"
"    'È': [4, ['E', ]],\n"
"    'Ì': [4, ['I', ]],\n"
"    'Ò': [4, ['O', ]],\n"
"    'Ù': [4, ['U', ]],\n"
"    '`': [4, [' ', ]],\n"
"    'ç': [5, ['c', ]],\n"
"    'Ç': [5, ['C', ]],\n"
"    '¸': [5, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, },\n"
"    {0x0: 0x28, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1a, },\n"
"    {0x1: 0x28, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000414,\n"
"  localeName: \"nb\",\n"
"  displayName: \"Norwegian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\\\': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ø': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'æ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '|': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ø': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Æ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '§': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    'µ': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ä': [0, ['a', ]],\n"
"    'ë': [0, ['e', ]],\n"
"    'ï': [0, ['i', ]],\n"
"    'ö': [0, ['o', ]],\n"
"    'ü': [0, ['u', ]],\n"
"    'ÿ': [0, ['y', ]],\n"
"    'Ä': [0, ['A', ]],\n"
"    'Ë': [0, ['E', ]],\n"
"    'Ï': [0, ['I', ]],\n"
"    'Ö': [0, ['O', ]],\n"
"    'Ü': [0, ['U', ]],\n"
"    '¨': [0, [' ', ]],\n"
"    'à': [1, ['a', ]],\n"
"    'è': [1, ['e', ]],\n"
"    'ì': [1, ['i', ]],\n"
"    'ò': [1, ['o', ]],\n"
"    'ù': [1, ['u', ]],\n"
"    'À': [1, ['A', ]],\n"
"    'È': [1, ['E', ]],\n"
"    'Ì': [1, ['I', ]],\n"
"    'Ò': [1, ['O', ]],\n"
"    'Ù': [1, ['U', ]],\n"
"    '`': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000415,\n"
"  localeName: \"pl\",\n"
"  displayName: \"Polish (Programmers)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, 0x0: 0xc, },\n"
"    'Ę': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Ą': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Ś': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    'Ł': { 0x3: 0x26, 0x6: 0x26, },\n"
"    'Ż': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'Ź': { 0x3: 0x2d, 0x6: 0x2d, },\n"
"    'Ć': { 0x3: 0x2e, 0x6: 0x2e, },\n"
"    'Ń': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'ę': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'ą': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ś': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    'ł': { 0x7: 0x26, 0x2: 0x26, },\n"
"    'ż': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'ź': { 0x7: 0x2d, 0x2: 0x2d, },\n"
"    'ć': { 0x7: 0x2e, 0x2: 0x2e, },\n"
"    'ń': { 0x7: 0x31, 0x2: 0x31, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '€': { 0x2: 0x16, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ę': [0, ['e', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ą': [0, ['a', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'ł': [0, ['l', ]],\n"
"    'ż': [0, ['z', ]],\n"
"    'ź': [0, ['x', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ę': [0, ['E', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ą': [0, ['A', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'Ł': [0, ['L', ]],\n"
"    'Ż': [0, ['Z', ]],\n"
"    'Ź': [0, ['X', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    '~': [0, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x1: 0x29, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000416,\n"
"  localeName: \"pt-BR\",\n"
"  displayName: \"Portuguese (Brazil ABNT)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ç': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '\\'': { 0x0: 0x29, },\n"
"    ']': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, 0x1: 0x7e, },\n"
"    ';': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x73, 0x1: 0x35, 0x2: 0x10, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ç': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '\"': { 0x1: 0x29, },\n"
"    '}': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    ':': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, },\n"
"    '?': { 0x1: 0x73, 0x2: 0x11, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '¹': { 0x2: 0x2, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '£': { 0x2: 0x5, },\n"
"    '¢': { 0x2: 0x6, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '§': { 0x2: 0xd, },\n"
"    '°': { 0x2: 0x12, },\n"
"    'ª': { 0x2: 0x1b, },\n"
"    'º': { 0x2: 0x2b, },\n"
"    '₢': { 0x2: 0x2e, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ã': [1, ['a', ]],\n"
"    'õ': [1, ['o', ]],\n"
"    'ñ': [1, ['n', ]],\n"
"    'Ã': [1, ['A', ]],\n"
"    'Õ': [1, ['O', ]],\n"
"    'Ñ': [1, ['N', ]],\n"
"    '~': [1, [' ', ]],\n"
"    'ä': [2, ['a', ]],\n"
"    'ë': [2, ['e', ]],\n"
"    'ï': [2, ['i', ]],\n"
"    'ö': [2, ['o', ]],\n"
"    'ü': [2, ['u', ]],\n"
"    'ÿ': [2, ['y', ]],\n"
"    'Ä': [2, ['A', ]],\n"
"    'Ë': [2, ['E', ]],\n"
"    'Ï': [2, ['I', ]],\n"
"    'Ö': [2, ['O', ]],\n"
"    'Ü': [2, ['U', ]],\n"
"    '¨': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'ô': [4, ['o', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'Ô': [4, ['O', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    '^': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, },\n"
"    {0x0: 0x28, },\n"
"    {0x1: 0x7, },\n"
"    {0x1: 0x1a, },\n"
"    {0x1: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000418,\n"
"  localeName: \"ro-RO\",\n"
"  displayName: \"Romanian (Legacy)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\'': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ă': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'î': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ş': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ţ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    ']': { 0x0: 0x29, },\n"
"    'â': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, 0x2: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ă': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Î': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ş': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ţ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '[': { 0x1: 0x29, },\n"
"    'Â': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x1e': { 0x1: 0x8, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, 0x2: 0x56, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    'đ': { 0x2: 0x1f, },\n"
"    'Đ': { 0x2: 0x20, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    '$': { 0x2: 0x27, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ň': [0, ['n', ]],\n"
"    'č': [0, ['c', ]],\n"
"    'ď': [0, ['d', ]],\n"
"    'š': [0, ['s', ]],\n"
"    'ľ': [0, ['l', ]],\n"
"    'ě': [0, ['e', ]],\n"
"    'ř': [0, ['r', ]],\n"
"    'ť': [0, ['t', ]],\n"
"    'ž': [0, ['z', ]],\n"
"    'Ň': [0, ['N', ]],\n"
"    'Č': [0, ['C', ]],\n"
"    'Ď': [0, ['D', ]],\n"
"    'Š': [0, ['S', ]],\n"
"    'Ľ': [0, ['L', ]],\n"
"    'Ě': [0, ['E', ]],\n"
"    'Ř': [0, ['R', ]],\n"
"    'Ť': [0, ['T', ]],\n"
"    'Ž': [0, ['Z', ]],\n"
"    'ˇ': [0, [' ', ]],\n"
"    'â': [1, ['a', ]],\n"
"    'î': [1, ['i', ]],\n"
"    'ô': [1, ['o', ]],\n"
"    'Â': [1, ['A', ]],\n"
"    'Î': [1, ['I', ]],\n"
"    'Ô': [1, ['O', ]],\n"
"    '^': [1, [' ', ]],\n"
"    'ă': [2, ['a', ]],\n"
"    'Ă': [2, ['A', ]],\n"
"    '˘': [2, [' ', ]],\n"
"    'ů': [3, ['u', ]],\n"
"    'Ů': [3, ['U', ]],\n"
"    '°': [3, [' ', ]],\n"
"    'ą': [4, ['a', ]],\n"
"    'ę': [4, ['e', ]],\n"
"    'Ą': [4, ['A', ]],\n"
"    'Ę': [4, ['E', ]],\n"
"    '˛': [4, [' ', ]],\n"
"    'ż': [5, ['z', ]],\n"
"    'Ż': [5, ['Z', ]],\n"
"    '·': [5, [' ', ]],\n"
"    'ń': [6, ['n', ]],\n"
"    'ć': [6, ['c', ]],\n"
"    'ý': [6, ['y', ]],\n"
"    'á': [6, ['a', ]],\n"
"    'ś': [6, ['s', ]],\n"
"    'ĺ': [6, ['l', ]],\n"
"    'é': [6, ['e', ]],\n"
"    'ŕ': [6, ['r', ]],\n"
"    'ú': [6, ['u', ]],\n"
"    'í': [6, ['i', ]],\n"
"    'ź': [6, ['z', ]],\n"
"    'ó': [6, ['o', ]],\n"
"    'Ń': [6, ['N', ]],\n"
"    'Ć': [6, ['C', ]],\n"
"    'Ý': [6, ['Y', ]],\n"
"    'Á': [6, ['A', ]],\n"
"    'Ś': [6, ['S', ]],\n"
"    'Ĺ': [6, ['L', ]],\n"
"    'É': [6, ['E', ]],\n"
"    'Ŕ': [6, ['R', ]],\n"
"    'Ú': [6, ['U', ]],\n"
"    'Í': [6, ['I', ]],\n"
"    'Ź': [6, ['Z', ]],\n"
"    'Ó': [6, ['O', ]],\n"
"    '´': [6, [' ', ]],\n"
"    'ű': [7, ['u', ]],\n"
"    'ő': [7, ['o', ]],\n"
"    'Ű': [7, ['U', ]],\n"
"    'Ő': [7, ['O', ]],\n"
"    '˝': [7, [' ', ]],\n"
"    'ä': [8, ['a', ]],\n"
"    'ë': [8, ['e', ]],\n"
"    'ü': [8, ['u', ]],\n"
"    'ö': [8, ['o', ]],\n"
"    'Ä': [8, ['A', ]],\n"
"    'Ë': [8, ['E', ]],\n"
"    'Ü': [8, ['U', ]],\n"
"    'Ö': [8, ['O', ]],\n"
"    '¨': [8, [' ', ]],\n"
"    'ç': [9, ['c', ]],\n"
"    'ș': [9, ['s', ]],\n"
"    'ţ': [9, ['t', ]],\n"
"    'Ç': [9, ['C', ]],\n"
"    'Ș': [9, ['S', ]],\n"
"    'Ţ': [9, ['T', ]],\n"
"    '¸': [9, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x6, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xa, },\n"
"    {0x2: 0xb, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000419,\n"
"  localeName: \"ru\",\n"
"  displayName: \"Russian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'щ': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'ы': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ж': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'э': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ё': { 0x0: 0x29, 0x5: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ь': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '.': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '№': { 0x1: 0x4, },\n"
"    ';': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    ':': { 0x1: 0x7, },\n"
"    '?': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Щ': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ж': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Э': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Ё': { 0x1: 0x29, 0x4: 0x29, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ь': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    ',': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '₽': { 0x2: 0x9, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000041a,\n"
"  localeName: \"hr-HR\",\n"
"  displayName: \"Croatian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'š': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'đ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'č': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ć': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ž': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Š': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Đ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Č': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ć': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Ž': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '¤': { 0x2: 0x2b, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'Ç': [0, ['C', ]],\n"
"    'ç': [0, ['c', ]],\n"
"    'Ş': [0, ['S', ]],\n"
"    'ş': [0, ['s', ]],\n"
"    '¸': [0, [' ', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'ľ': [2, ['l', ]],\n"
"    'Ľ': [2, ['L', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'â': [3, ['a', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'Ă': [4, ['A', ]],\n"
"    'ă': [4, ['a', ]],\n"
"    '˘': [4, [' ', ]],\n"
"    'Ů': [5, ['U', ]],\n"
"    'ů': [5, ['u', ]],\n"
"    '°': [5, [' ', ]],\n"
"    'Ę': [6, ['E', ]],\n"
"    'ę': [6, ['e', ]],\n"
"    'Ą': [6, ['A', ]],\n"
"    'ą': [6, ['a', ]],\n"
"    '˛': [6, [' ', ]],\n"
"    'Ż': [7, ['Z', ]],\n"
"    'ż': [7, ['z', ]],\n"
"    '˙': [7, [' ', ]],\n"
"    'Á': [8, ['A', ]],\n"
"    'á': [8, ['a', ]],\n"
"    'Ć': [8, ['C', ]],\n"
"    'ć': [8, ['c', ]],\n"
"    'É': [8, ['E', ]],\n"
"    'é': [8, ['e', ]],\n"
"    'Í': [8, ['I', ]],\n"
"    'í': [8, ['i', ]],\n"
"    'Ĺ': [8, ['L', ]],\n"
"    'ĺ': [8, ['l', ]],\n"
"    'Ń': [8, ['N', ]],\n"
"    'ń': [8, ['n', ]],\n"
"    'Ó': [8, ['O', ]],\n"
"    'ó': [8, ['o', ]],\n"
"    'Ŕ': [8, ['R', ]],\n"
"    'ŕ': [8, ['r', ]],\n"
"    'Ś': [8, ['S', ]],\n"
"    'ś': [8, ['s', ]],\n"
"    'Ú': [8, ['U', ]],\n"
"    'ú': [8, ['u', ]],\n"
"    'Ý': [8, ['Y', ]],\n"
"    'ý': [8, ['y', ]],\n"
"    'Ź': [8, ['Z', ]],\n"
"    'ź': [8, ['z', ]],\n"
"    '´': [8, [' ', ]],\n"
"    'Ű': [9, ['U', ]],\n"
"    'ű': [9, ['u', ]],\n"
"    'Ő': [9, ['O', ]],\n"
"    'ő': [9, ['o', ]],\n"
"    '˝': [9, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, 0x2: 0xd, },\n"
"    {0x1: 0x29, 0x2: 0xc, },\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x6, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xa, },\n"
"    {0x2: 0xb, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000041b,\n"
"  localeName: \"sk\",\n"
"  displayName: \"Slovak\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '+': { 0x0: 0x2, 0x1: 0x4e, },\n"
"    'ľ': { 0x0: 0x3, },\n"
"    'š': { 0x0: 0x4, },\n"
"    'č': { 0x0: 0x5, },\n"
"    'ť': { 0x0: 0x6, },\n"
"    'ž': { 0x0: 0x7, },\n"
"    'ý': { 0x0: 0x8, },\n"
"    'á': { 0x0: 0x9, },\n"
"    'í': { 0x0: 0xa, },\n"
"    'é': { 0x0: 0xb, },\n"
"    '=': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ú': { 0x0: 0x1a, },\n"
"    'ä': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ô': { 0x0: 0x27, },\n"
"    '§': { 0x0: 0x28, },\n"
"    ';': { 0x0: 0x29, },\n"
"    'ň': { 0x0: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '&': { 0x0: 0x56, 0x2: 0x2e, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x1a, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, },\n"
"    '3': { 0x1: 0x4, },\n"
"    '4': { 0x1: 0x5, },\n"
"    '5': { 0x1: 0x6, },\n"
"    '6': { 0x1: 0x7, },\n"
"    '7': { 0x1: 0x8, },\n"
"    '8': { 0x1: 0x9, },\n"
"    '9': { 0x1: 0xa, },\n"
"    '0': { 0x1: 0xb, },\n"
"    '%': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '(': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '\"': { 0x1: 0x27, },\n"
"    '!': { 0x1: 0x28, },\n"
"    ')': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '?': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1d': { 0x1: 0x22, },\n"
"    '\\x1f': { 0x1: 0x35, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\a': { 0x0: 0x22, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x16': { 0x0: 0x2f, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '\\'': { 0x2: 0x19, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    'đ': { 0x2: 0x1f, },\n"
"    'Đ': { 0x2: 0x20, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    '$': { 0x2: 0x27, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '¤': { 0x2: 0x2b, },\n"
"    '>': { 0x2: 0x2c, },\n"
"    '#': { 0x2: 0x2d, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '<': { 0x2: 0x33, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'č': [1, ['c', ]],\n"
"    'Č': [1, ['C', ]],\n"
"    'ď': [1, ['d', ]],\n"
"    'Ď': [1, ['D', ]],\n"
"    'ě': [1, ['e', ]],\n"
"    'Ě': [1, ['E', ]],\n"
"    'ľ': [1, ['l', ]],\n"
"    'Ľ': [1, ['L', ]],\n"
"    'ň': [1, ['n', ]],\n"
"    'Ň': [1, ['N', ]],\n"
"    'ř': [1, ['r', ]],\n"
"    'Ř': [1, ['R', ]],\n"
"    'š': [1, ['s', ]],\n"
"    'Š': [1, ['S', ]],\n"
"    'ť': [1, ['t', ]],\n"
"    'Ť': [1, ['T', ]],\n"
"    'ž': [1, ['z', ]],\n"
"    'Ž': [1, ['Z', ]],\n"
"    'ˇ': [1, [' ', ]],\n"
"    'ů': [2, ['u', ]],\n"
"    'Ů': [2, ['U', ]],\n"
"    '°': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ă': [4, ['a', ]],\n"
"    'Ă': [4, ['A', ]],\n"
"    '˘': [4, [' ', ]],\n"
"    'ą': [5, ['a', ]],\n"
"    'Ą': [5, ['A', ]],\n"
"    'ę': [5, ['e', ]],\n"
"    'Ę': [5, ['E', ]],\n"
"    '˛': [5, [' ', ]],\n"
"    'ż': [6, ['z', ]],\n"
"    'Ż': [6, ['Z', ]],\n"
"    '·': [6, [' ', ]],\n"
"    'ő': [7, ['o', ]],\n"
"    'Ő': [7, ['O', ]],\n"
"    'ű': [7, ['u', ]],\n"
"    'Ű': [7, ['U', ]],\n"
"    '˝': [7, [' ', ]],\n"
"    'ä': [8, ['a', ]],\n"
"    'Ä': [8, ['A', ]],\n"
"    'ö': [8, ['o', ]],\n"
"    'Ö': [8, ['O', ]],\n"
"    'ü': [8, ['u', ]],\n"
"    'Ü': [8, ['U', ]],\n"
"    '¨': [8, [' ', ]],\n"
"    'ç': [9, ['c', ]],\n"
"    'Ç': [9, ['C', ]],\n"
"    'ş': [9, ['s', ]],\n"
"    'Ş': [9, ['S', ]],\n"
"    'ţ': [9, ['t', ]],\n"
"    'Ţ': [9, ['T', ]],\n"
"    '¸': [9, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, 0x2: 0xa, },\n"
"    {0x1: 0xd, 0x2: 0x3, },\n"
"    {0x1: 0x29, 0x2: 0x6, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xb, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000041d,\n"
"  localeName: \"sv-SE\",\n"
"  displayName: \"Swedish\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '§': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '½': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '|': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000041f,\n"
"  localeName: \"tr\",\n"
"  displayName: \"Turkish Q\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '*': { 0x0: 0xc, 0x1: 0x37, },\n"
"    '-': { 0x0: 0xd, 0x1: 0x4a, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ı': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ğ': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ü': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ş': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'i': { 0x0: 0x28, 0x5: 0x28, 0x7: 0x17, 0x2: 0x17, },\n"
"    '\"': { 0x0: 0x29, },\n"
"    ',': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'ö': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ç': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '.': { 0x0: 0x35, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x5, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x29, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\\'': { 0x1: 0x3, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '_': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ğ': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ü': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ş': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'İ': { 0x1: 0x28, 0x3: 0x17, 0x6: 0x17, 0x4: 0x28, },\n"
"    'é': { 0x1: 0x29, },\n"
"    ';': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Ö': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ç': { 0x1: 0x34, 0x4: 0x34, },\n"
"    ':': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x2, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xd, },\n"
"    'Æ': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'æ': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '£': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '½': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '|': { 0x2: 0xd, },\n"
"    '@': { 0x2: 0x10, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '₺': { 0x2: 0x14, },\n"
"    'ß': { 0x2: 0x1f, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', 'ı', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', 'İ', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', 'ı', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', 'İ', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ã': [2, ['a', ]],\n"
"    'õ': [2, ['o', ]],\n"
"    'ñ': [2, ['n', ]],\n"
"    'Ã': [2, ['A', ]],\n"
"    'Õ': [2, ['O', ]],\n"
"    'Ñ': [2, ['N', ]],\n"
"    '~': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'í': [3, ['i', 'ı', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Í': [3, ['I', 'İ', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'à': [4, ['a', ]],\n"
"    'è': [4, ['e', ]],\n"
"    'ì': [4, ['i', 'ı', ]],\n"
"    'ò': [4, ['o', ]],\n"
"    'ù': [4, ['u', ]],\n"
"    'À': [4, ['A', ]],\n"
"    'È': [4, ['E', ]],\n"
"    'Ì': [4, ['I', 'İ', ]],\n"
"    'Ò': [4, ['O', ]],\n"
"    'Ù': [4, ['U', ]],\n"
"    '`': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x1: 0x4, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"    {0x2: 0x27, },\n"
"    {0x2: 0x2b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000422,\n"
"  localeName: \"uk\",\n"
"  displayName: \"Ukrainian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'щ': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ї': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'і': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ж': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'є': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ё': { 0x0: 0x29, 0x5: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ь': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '.': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    'ґ': { 0x0: 0x56, 0x5: 0x56, 0x7: 0x16, 0x2: 0x16, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '№': { 0x1: 0x4, },\n"
"    ';': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    ':': { 0x1: 0x7, },\n"
"    '?': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Щ': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ї': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'І': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ж': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Є': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Ё': { 0x1: 0x29, 0x4: 0x29, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ь': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    ',': { 0x1: 0x35, },\n"
"    'Ґ': { 0x1: 0x56, 0x3: 0x16, 0x6: 0x16, 0x4: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000424,\n"
"  localeName: \"sl\",\n"
"  displayName: \"Slovenian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'š': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'đ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'č': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ć': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ž': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Š': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Đ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Č': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ć': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Ž': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '¤': { 0x2: 0x2b, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'Ç': [0, ['C', ]],\n"
"    'ç': [0, ['c', ]],\n"
"    'Ş': [0, ['S', ]],\n"
"    'ş': [0, ['s', ]],\n"
"    '¸': [0, [' ', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'ľ': [2, ['l', ]],\n"
"    'Ľ': [2, ['L', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'â': [3, ['a', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'Ă': [4, ['A', ]],\n"
"    'ă': [4, ['a', ]],\n"
"    '˘': [4, [' ', ]],\n"
"    'Ů': [5, ['U', ]],\n"
"    'ů': [5, ['u', ]],\n"
"    '°': [5, [' ', ]],\n"
"    'Ę': [6, ['E', ]],\n"
"    'ę': [6, ['e', ]],\n"
"    'Ą': [6, ['A', ]],\n"
"    'ą': [6, ['a', ]],\n"
"    '˛': [6, [' ', ]],\n"
"    'Ż': [7, ['Z', ]],\n"
"    'ż': [7, ['z', ]],\n"
"    '˙': [7, [' ', ]],\n"
"    'Á': [8, ['A', ]],\n"
"    'á': [8, ['a', ]],\n"
"    'Ć': [8, ['C', ]],\n"
"    'ć': [8, ['c', ]],\n"
"    'É': [8, ['E', ]],\n"
"    'é': [8, ['e', ]],\n"
"    'Í': [8, ['I', ]],\n"
"    'í': [8, ['i', ]],\n"
"    'Ĺ': [8, ['L', ]],\n"
"    'ĺ': [8, ['l', ]],\n"
"    'Ń': [8, ['N', ]],\n"
"    'ń': [8, ['n', ]],\n"
"    'Ó': [8, ['O', ]],\n"
"    'ó': [8, ['o', ]],\n"
"    'Ŕ': [8, ['R', ]],\n"
"    'ŕ': [8, ['r', ]],\n"
"    'Ś': [8, ['S', ]],\n"
"    'ś': [8, ['s', ]],\n"
"    'Ú': [8, ['U', ]],\n"
"    'ú': [8, ['u', ]],\n"
"    'Ý': [8, ['Y', ]],\n"
"    'ý': [8, ['y', ]],\n"
"    'Ź': [8, ['Z', ]],\n"
"    'ź': [8, ['z', ]],\n"
"    '´': [8, [' ', ]],\n"
"    'Ű': [9, ['U', ]],\n"
"    'ű': [9, ['u', ]],\n"
"    'Ő': [9, ['O', ]],\n"
"    'ő': [9, ['o', ]],\n"
"    '˝': [9, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, 0x2: 0xd, },\n"
"    {0x1: 0x29, 0x2: 0xc, },\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x6, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xa, },\n"
"    {0x2: 0xb, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000425,\n"
"  localeName: \"et\",\n"
"  displayName: \"Estonian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ü': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'õ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ü': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Õ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '@': { 0x3: 0x3, 0x2: 0x3, },\n"
"    '£': { 0x3: 0x4, 0x2: 0x4, },\n"
"    '$': { 0x3: 0x5, 0x2: 0x5, },\n"
"    '{': { 0x3: 0x8, 0x2: 0x8, },\n"
"    '[': { 0x3: 0x9, 0x2: 0x9, },\n"
"    ']': { 0x3: 0xa, 0x2: 0xa, },\n"
"    '}': { 0x3: 0xb, 0x2: 0xb, },\n"
"    '\\\\': { 0x3: 0xc, 0x2: 0xc, },\n"
"    '§': { 0x3: 0x1b, 0x2: 0x1b, },\n"
"    'Š': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    '^': { 0x3: 0x28, },\n"
"    '½': { 0x3: 0x2b, 0x2: 0x2b, },\n"
"    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    '|': { 0x3: 0x56, 0x2: 0x56, },\n"
"    'š': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    'ž': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x28, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '€': { 0x2: 0x6, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'š': [1, ['s', ]],\n"
"    'Š': [1, ['S', ]],\n"
"    'č': [1, ['c', ]],\n"
"    'Č': [1, ['C', ]],\n"
"    'ž': [1, ['z', ]],\n"
"    'Ž': [1, ['Z', ]],\n"
"    'ˇ': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'õ': [3, ['o', ]],\n"
"    'Õ': [3, ['O', ]],\n"
"    '~': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'ĝ': [4, ['g', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    'Ĝ': [4, ['G', ]],\n"
"    '^': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x29, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x29, },\n"
"    {0x2: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000426,\n"
"  localeName: \"lv\",\n"
"  displayName: \"Latvian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    'f': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'ū': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'g': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'j': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'm': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'v': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'n': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'z': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ē': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'č': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ž': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'h': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'š': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'u': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    's': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'i': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'l': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'd': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'a': { 0x0: 0x24, 0x5: 0x24, },\n"
"    't': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'e': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'c': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '\\xad': { 0x0: 0x29, },\n"
"    'ķ': { 0x0: 0x2b, 0x5: 0x2b, 0x7: 0x2f, 0x2: 0x2f, },\n"
"    'ņ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'b': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ī': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'k': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'p': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'o': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ā': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    'ļ': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4e, },\n"
"    'ģ': { 0x0: 0x56, 0x5: 0x56, 0x7: 0x11, 0x2: 0x11, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x7, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '«': { 0x1: 0x3, 0x2: 0x2, },\n"
"    '»': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, 0x3: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '×': { 0x1: 0x9, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'F': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'Ū': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'G': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'J': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'M': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'V': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'N': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Z': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ē': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'Č': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ž': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'H': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Š': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'U': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'S': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'I': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'L': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'D': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'A': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'T': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'E': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'C': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '?': { 0x1: 0x29, },\n"
"    'Ķ': { 0x1: 0x2b, 0x3: 0x2f, 0x6: 0x2f, 0x4: 0x2b, },\n"
"    'Ņ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'B': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ī': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'K': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'P': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'O': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ā': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, 0x3: 0xd, },\n"
"    ':': { 0x1: 0x34, 0x2: 0x9, },\n"
"    'Ļ': { 0x1: 0x35, 0x4: 0x35, },\n"
"    'Ģ': { 0x1: 0x56, 0x3: 0x11, 0x6: 0x11, 0x4: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '@': { 0x3: 0x3, },\n"
"    '#': { 0x3: 0x4, },\n"
"    '^': { 0x3: 0x7, },\n"
"    '±': { 0x3: 0x8, },\n"
"    '—': { 0x3: 0xc, },\n"
"    'Q': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'Ŗ': { 0x3: 0x13, 0x6: 0x13, },\n"
"    'W': { 0x3: 0x14, 0x6: 0x14, },\n"
"    'Y': { 0x3: 0x15, 0x6: 0x15, },\n"
"    '{': { 0x3: 0x1a, },\n"
"    '}': { 0x3: 0x1b, },\n"
"    'X': { 0x3: 0x2d, 0x6: 0x2d, },\n"
"    'Õ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    '|': { 0x3: 0x56, },\n"
"    'q': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'ŗ': { 0x7: 0x13, 0x2: 0x13, },\n"
"    'w': { 0x7: 0x14, 0x2: 0x14, },\n"
"    'y': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'x': { 0x7: 0x2d, 0x2: 0x2d, },\n"
"    'õ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x1d': { 0x0: 0x2e, },\n"
"    '€': { 0x2: 0x5, },\n"
"    '\"': { 0x2: 0x6, },\n"
"    '’': { 0x2: 0x7, },\n"
"    '–': { 0x2: 0xc, },\n"
"    '=': { 0x2: 0xd, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ń': [0, ['n', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'å': [1, ['a', ]],\n"
"    'Å': [1, ['A', ]],\n"
"    'ė': [1, ['e', ]],\n"
"    'Ė': [1, ['E', ]],\n"
"    'ż': [1, ['z', ]],\n"
"    'Ż': [1, ['Z', ]],\n"
"    'ġ': [1, ['g', ]],\n"
"    '°': [1, [' ', ]],\n"
"    'õ': [2, ['o', ]],\n"
"    'Õ': [2, ['O', ]],\n"
"    '~': [2, [' ', ]],\n"
"    'ä': [3, ['a', ]],\n"
"    'ü': [3, ['u', ]],\n"
"    'ö': [3, ['o', ]],\n"
"    'Ä': [3, ['A', ]],\n"
"    'Ü': [3, ['U', ]],\n"
"    'Ö': [3, ['O', ]],\n"
"    '¨': [3, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x28, 0x2: 0x28, },\n"
"    {0x1: 0x28, },\n"
"    {0x3: 0x6, },\n"
"    {0x3: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000427,\n"
"  localeName: \"lt\",\n"
"  displayName: \"Lithuanian IBM\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '!': { 0x0: 0x2, },\n"
"    '\"': { 0x0: 0x3, },\n"
"    '/': { 0x0: 0x4, 0x1: 0x35, },\n"
"    ';': { 0x0: 0x5, },\n"
"    ':': { 0x0: 0x6, },\n"
"    ',': { 0x0: 0x7, },\n"
"    '.': { 0x0: 0x8, },\n"
"    '?': { 0x0: 0x9, },\n"
"    '(': { 0x0: 0xa, },\n"
"    ')': { 0x0: 0xb, },\n"
"    '_': { 0x0: 0xc, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'ą': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ž': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'į': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '“': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ų': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ė': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '|': { 0x0: 0x2b, 0x1: 0x56, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ū': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'č': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'š': { 0x0: 0x34, 0x5: 0x34, },\n"
"    'ę': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '-': { 0x0: 0x4a, 0x1: 0xc, },\n"
"    '\\\\': { 0x0: 0x56, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, },\n"
"    '3': { 0x1: 0x4, },\n"
"    '4': { 0x1: 0x5, },\n"
"    '5': { 0x1: 0x6, },\n"
"    '6': { 0x1: 0x7, },\n"
"    '7': { 0x1: 0x8, },\n"
"    '8': { 0x1: 0x9, },\n"
"    '9': { 0x1: 0xa, },\n"
"    '0': { 0x1: 0xb, },\n"
"    '=': { 0x1: 0xd, },\n"
"    'Ą': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ž': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Į': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    '”': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ų': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ė': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ū': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Č': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Š': { 0x1: 0x34, 0x4: 0x34, },\n"
"    'Ę': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000042f,\n"
"  localeName: \"mk\",\n"
"  displayName: \"Macedonian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'љ': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'њ': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'е': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'р': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'т': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'ѕ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'у': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'и': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'о': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'п': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ш': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ѓ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'а': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'с': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'д': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'ф': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'г': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'х': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ј': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'к': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'л': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ч': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ќ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    'ж': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'з': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'џ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ц': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'в': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'б': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'н': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'м': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    'ё': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '„': { 0x1: 0x3, },\n"
"    '“': { 0x1: 0x4, },\n"
"    '’': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '‘': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Љ': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Њ': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'Е': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Р': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Т': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Ѕ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'У': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'И': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'О': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'П': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ш': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ѓ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'А': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'С': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Д': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Ф': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Г': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Х': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ј': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'К': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Л': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ч': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ќ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    'Ж': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'З': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Џ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ц': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'В': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Б': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Н': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'М': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    'Ё': { 0x1: 0x56, 0x4: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '€': { 0x2: 0x12, },\n"
"    'Ђ': { 0x2: 0x1a, },\n"
"    'ђ': { 0x2: 0x1b, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'Ћ': { 0x2: 0x27, },\n"
"    'ћ': { 0x2: 0x28, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000438,\n"
"  localeName: \"fo\",\n"
"  displayName: \"Faeroese\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ð': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'æ': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ø': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '½': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ð': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Æ': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ø': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '§': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '|': { 0x2: 0xd, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'à': [1, ['a', ]],\n"
"    'è': [1, ['e', ]],\n"
"    'ì': [1, ['i', ]],\n"
"    'ò': [1, ['o', ]],\n"
"    'ù': [1, ['u', ]],\n"
"    'À': [1, ['A', ]],\n"
"    'È': [1, ['E', ]],\n"
"    'Ì': [1, ['I', ]],\n"
"    'Ò': [1, ['O', ]],\n"
"    'Ù': [1, ['U', ]],\n"
"    '`': [1, [' ', ]],\n"
"    'ä': [2, ['a', ]],\n"
"    'ë': [2, ['e', ]],\n"
"    'ï': [2, ['i', ]],\n"
"    'ö': [2, ['o', ]],\n"
"    'ü': [2, ['u', ]],\n"
"    'ÿ': [2, ['y', ]],\n"
"    'Ä': [2, ['A', ]],\n"
"    'Ë': [2, ['E', ]],\n"
"    'Ï': [2, ['I', ]],\n"
"    'Ö': [2, ['O', ]],\n"
"    'Ü': [2, ['U', ]],\n"
"    '¨': [2, [' ', ]],\n"
"    'ã': [3, ['a', ]],\n"
"    'õ': [3, ['o', ]],\n"
"    'ñ': [3, ['n', ]],\n"
"    'Ã': [3, ['A', ]],\n"
"    'Õ': [3, ['O', ]],\n"
"    'Ñ': [3, ['N', ]],\n"
"    '~': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'ô': [4, ['o', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'Ô': [4, ['O', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    '^': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x1: 0xd, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"    {0x2: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000043a,\n"
"  localeName: \"mt\",\n"
"  displayName: \"Maltese 47-Key\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ġ': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ħ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    'ċ': { 0x0: 0x29, 0x5: 0x29, },\n"
"    'ż': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '€': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ġ': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ħ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    'Ċ': { 0x1: 0x29, 0x4: 0x29, },\n"
"    'Ż': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    'È': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ù': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Ì': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ò': { 0x3: 0x18, 0x6: 0x18, },\n"
"    '{': { 0x3: 0x1a, },\n"
"    '}': { 0x3: 0x1b, },\n"
"    'À': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '~': { 0x3: 0x29, },\n"
"    '|': { 0x3: 0x2b, },\n"
"    'è': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ù': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'ì': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ò': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'à': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '`': { 0x2: 0x29, },\n"
"    '\\\\': { 0x2: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000043b,\n"
"  localeName: \"se-Latn-NO\",\n"
"  displayName: \"Norwegian with Sami\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\\\': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ø': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'æ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '|': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ø': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Æ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '§': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    'Â': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'Ŧ': { 0x3: 0x14, 0x6: 0x14, },\n"
"    'Ï': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Õ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Š': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    'Đ': { 0x3: 0x20, 0x6: 0x20, },\n"
"    'Ǥ': { 0x3: 0x21, 0x6: 0x21, },\n"
"    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },\n"
"    'Ȟ': { 0x3: 0x23, 0x6: 0x23, },\n"
"    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },\n"
"    'Ö': { 0x3: 0x27, 0x6: 0x27, },\n"
"    'Ä': { 0x3: 0x28, 0x6: 0x28, },\n"
"    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'Č': { 0x3: 0x2e, 0x6: 0x2e, },\n"
"    'Ǯ': { 0x3: 0x2f, 0x6: 0x2f, },\n"
"    'Ʒ': { 0x3: 0x30, 0x6: 0x30, },\n"
"    'Ŋ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'â': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'ŧ': { 0x7: 0x14, 0x2: 0x14, },\n"
"    'ï': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'õ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'š': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    'đ': { 0x7: 0x20, 0x2: 0x20, },\n"
"    'ǥ': { 0x7: 0x21, 0x2: 0x21, },\n"
"    'ǧ': { 0x7: 0x22, 0x2: 0x22, },\n"
"    'ȟ': { 0x7: 0x23, 0x2: 0x23, },\n"
"    'ǩ': { 0x7: 0x25, 0x2: 0x25, },\n"
"    'ö': { 0x7: 0x27, 0x2: 0x27, },\n"
"    'ä': { 0x7: 0x28, 0x2: 0x28, },\n"
"    'ž': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'č': { 0x7: 0x2e, 0x2: 0x2e, },\n"
"    'ǯ': { 0x7: 0x2f, 0x2: 0x2f, },\n"
"    'ʒ': { 0x7: 0x30, 0x2: 0x30, },\n"
"    'ŋ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    'µ': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ä': [0, ['a', ]],\n"
"    'Ä': [0, ['A', ]],\n"
"    'ë': [0, ['e', ]],\n"
"    'Ë': [0, ['E', ]],\n"
"    'ï': [0, ['i', ]],\n"
"    'Ï': [0, ['I', ]],\n"
"    'ö': [0, ['o', ]],\n"
"    'Ö': [0, ['O', ]],\n"
"    'ü': [0, ['u', ]],\n"
"    'Ü': [0, ['U', ]],\n"
"    'ẅ': [0, ['w', ]],\n"
"    'Ẅ': [0, ['W', ]],\n"
"    'ÿ': [0, ['y', ]],\n"
"    'Ÿ': [0, ['Y', ]],\n"
"    '¨': [0, [' ', ]],\n"
"    'à': [1, ['a', ]],\n"
"    'À': [1, ['A', ]],\n"
"    'è': [1, ['e', ]],\n"
"    'È': [1, ['E', ]],\n"
"    'ì': [1, ['i', ]],\n"
"    'Ì': [1, ['I', ]],\n"
"    'ò': [1, ['o', ]],\n"
"    'Ò': [1, ['O', ]],\n"
"    'ù': [1, ['u', ]],\n"
"    'Ù': [1, ['U', ]],\n"
"    'ẁ': [1, ['w', ]],\n"
"    'Ẁ': [1, ['W', ]],\n"
"    'ỳ': [1, ['y', ]],\n"
"    'Ỳ': [1, ['Y', ]],\n"
"    '`': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'ĉ': [2, ['c', ]],\n"
"    'Ĉ': [2, ['C', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'ĝ': [2, ['g', ]],\n"
"    'Ĝ': [2, ['G', ]],\n"
"    'ĥ': [2, ['h', ]],\n"
"    'Ĥ': [2, ['H', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'ĵ': [2, ['j', ]],\n"
"    'Ĵ': [2, ['J', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'ŝ': [2, ['s', ]],\n"
"    'Ŝ': [2, ['S', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    'ŵ': [2, ['w', ]],\n"
"    'Ŵ': [2, ['W', ]],\n"
"    'ŷ': [2, ['y', ]],\n"
"    'Ŷ': [2, ['Y', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'ć': [3, ['c', ]],\n"
"    'Ć': [3, ['C', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'ĺ': [3, ['l', ]],\n"
"    'Ĺ': [3, ['L', ]],\n"
"    'ń': [3, ['n', ]],\n"
"    'Ń': [3, ['N', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'ŕ': [3, ['r', ]],\n"
"    'Ŕ': [3, ['R', ]],\n"
"    'ś': [3, ['s', ]],\n"
"    'Ś': [3, ['S', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'ẃ': [3, ['w', ]],\n"
"    'Ẃ': [3, ['W', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    'ź': [3, ['z', ]],\n"
"    'Ź': [3, ['Z', ]],\n"
"    'ǻ': [3, ['å', ]],\n"
"    'Ǻ': [3, ['Å', ]],\n"
"    'ǽ': [3, ['æ', ]],\n"
"    'Ǽ': [3, ['Æ', ]],\n"
"    'ǿ': [3, ['ø', ]],\n"
"    'Ǿ': [3, ['Ø', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'ĩ': [4, ['i', ]],\n"
"    'Ĩ': [4, ['I', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'ũ': [4, ['u', ]],\n"
"    'Ũ': [4, ['U', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000043f,\n"
"  localeName: \"kk\",\n"
"  displayName: \"Kazakh\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '\"': { 0x0: 0x2, },\n"
"    'ә': { 0x0: 0x3, 0x5: 0x3, },\n"
"    'і': { 0x0: 0x4, 0x5: 0x4, },\n"
"    'ң': { 0x0: 0x5, 0x5: 0x5, },\n"
"    'ғ': { 0x0: 0x6, 0x5: 0x6, },\n"
"    ',': { 0x0: 0x7, },\n"
"    '.': { 0x0: 0x8, },\n"
"    'ү': { 0x0: 0x9, 0x5: 0x9, },\n"
"    'ұ': { 0x0: 0xa, 0x5: 0xa, },\n"
"    'қ': { 0x0: 0xb, 0x5: 0xb, },\n"
"    'ө': { 0x0: 0xc, 0x5: 0xc, },\n"
"    'һ': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'щ': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'ы': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ж': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'э': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '(': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, 0x5: 0x56, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ь': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '№': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '-': { 0x0: 0x4a, 0x1: 0x4a, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4e, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    'Ә': { 0x1: 0x3, 0x4: 0x3, },\n"
"    'І': { 0x1: 0x4, 0x4: 0x4, },\n"
"    'Ң': { 0x1: 0x5, 0x4: 0x5, },\n"
"    'Ғ': { 0x1: 0x6, 0x4: 0x6, },\n"
"    ';': { 0x1: 0x7, },\n"
"    ':': { 0x1: 0x8, },\n"
"    'Ү': { 0x1: 0x9, 0x4: 0x9, },\n"
"    'Ұ': { 0x1: 0xa, 0x4: 0xa, },\n"
"    'Қ': { 0x1: 0xb, 0x4: 0xb, },\n"
"    'Ө': { 0x1: 0xc, 0x4: 0xc, },\n"
"    'Һ': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Щ': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ж': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Э': { 0x1: 0x28, 0x4: 0x28, },\n"
"    ')': { 0x1: 0x29, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ь': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, 0x4: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000440,\n"
"  localeName: \"ky-Cyrl\",\n"
"  displayName: \"Kyrgyz Cyrillic\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'щ': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'ы': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ж': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'э': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ё': { 0x0: 0x29, 0x5: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ь': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '.': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '№': { 0x1: 0x4, },\n"
"    ';': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    ':': { 0x1: 0x7, },\n"
"    '?': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Щ': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ж': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Э': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Ё': { 0x1: 0x29, 0x4: 0x29, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ь': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    ',': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    'Ү': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ң': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ө': { 0x3: 0x24, 0x6: 0x24, },\n"
"    'ү': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ң': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ө': { 0x7: 0x24, 0x2: 0x24, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000444,\n"
"  localeName: \"tt-Cyrl\",\n"
"  displayName: \"Tatar (Legacy)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ө': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ә': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ү': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'ы': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ң': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'э': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'һ': { 0x0: 0x29, 0x5: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'җ': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '.': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    'ґ': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '№': { 0x1: 0x4, },\n"
"    ';': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    ':': { 0x1: 0x7, },\n"
"    '?': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ө': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ә': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ү': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ң': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Э': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Һ': { 0x1: 0x29, 0x4: 0x29, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Җ': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    ',': { 0x1: 0x35, },\n"
"    'Ґ': { 0x1: 0x56, 0x4: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '₽': { 0x3: 0x9, },\n"
"    'Ц': { 0x3: 0x11, 0x6: 0x11, },\n"
"    'Ҡ': { 0x3: 0x13, 0x6: 0x13, },\n"
"    'Ғ': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Щ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Ъ': { 0x3: 0x1b, 0x6: 0x1b, },\n"
"    'Ж': { 0x3: 0x27, 0x6: 0x27, },\n"
"    'Ё': { 0x3: 0x29, 0x6: 0x29, },\n"
"    'Ь': { 0x3: 0x32, 0x6: 0x32, },\n"
"    'ц': { 0x7: 0x11, 0x2: 0x11, },\n"
"    'ҡ': { 0x7: 0x13, 0x2: 0x13, },\n"
"    'ғ': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'щ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'ъ': { 0x7: 0x1b, 0x2: 0x1b, },\n"
"    'ж': { 0x7: 0x27, 0x2: 0x27, },\n"
"    'ё': { 0x7: 0x29, 0x2: 0x29, },\n"
"    'ь': { 0x7: 0x32, 0x2: 0x32, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '[': { 0x2: 0x8, },\n"
"    ']': { 0x2: 0x9, },\n"
"    '{': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\'': { 0x2: 0x28, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000450,\n"
"  localeName: \"mn-Cyrl\",\n"
"  displayName: \"Mongolian Cyrillic\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '№': { 0x0: 0x2, },\n"
"    '-': { 0x0: 0x3, 0x1: 0x4a, },\n"
"    '\"': { 0x0: 0x4, },\n"
"    '₮': { 0x0: 0x5, },\n"
"    ':': { 0x0: 0x6, },\n"
"    '.': { 0x0: 0x7, },\n"
"    '_': { 0x0: 0x8, },\n"
"    ',': { 0x0: 0x9, },\n"
"    '%': { 0x0: 0xa, },\n"
"    '?': { 0x0: 0xb, },\n"
"    'е': { 0x0: 0xc, 0x5: 0xc, },\n"
"    'щ': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'ф': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'ж': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'э': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ү': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'к': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'й': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'ы': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'б': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'ө': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'а': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'х': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'р': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'о': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'л': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'д': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'п': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '=': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ё': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'с': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'м': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'и': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'т': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'ь': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'в': { 0x0: 0x34, 0x5: 0x34, },\n"
"    'ю': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x29, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, },\n"
"    '3': { 0x1: 0x4, },\n"
"    '4': { 0x1: 0x5, },\n"
"    '5': { 0x1: 0x6, },\n"
"    '6': { 0x1: 0x7, },\n"
"    '7': { 0x1: 0x8, },\n"
"    '8': { 0x1: 0x9, },\n"
"    '9': { 0x1: 0xa, },\n"
"    '0': { 0x1: 0xb, },\n"
"    'Е': { 0x1: 0xc, 0x4: 0xc, },\n"
"    'Щ': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'Ф': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Ж': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Э': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ү': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'К': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Й': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Б': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Ө': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'А': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Х': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Р': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'О': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Л': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Д': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'П': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ё': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'С': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'М': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'И': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Т': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Ь': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'В': { 0x1: 0x34, 0x4: 0x34, },\n"
"    'Ю': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000452,\n"
"  localeName: \"cy\",\n"
"  displayName: \"United Kingdom Extended\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, 0x3: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '@': { 0x1: 0x28, },\n"
"    '¬': { 0x1: 0x29, },\n"
"    '~': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, 0x3: 0x1b, },\n"
"    'Ẃ': { 0x3: 0x11, 0x6: 0x11, },\n"
"    'É': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ý': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ú': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Í': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '`': { 0x3: 0x28, },\n"
"    'Ç': { 0x3: 0x2e, 0x6: 0x2e, },\n"
"    'ẃ': { 0x7: 0x11, 0x2: 0x11, },\n"
"    'é': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ý': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ú': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'í': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ç': { 0x7: 0x2e, 0x2: 0x2e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '€': { 0x2: 0x5, },\n"
"    '¦': { 0x2: 0x29, },\n"
"  },\n"
"  deadkeys: {\n"
"    'à': [0, ['a', ]],\n"
"    'À': [0, ['A', ]],\n"
"    'è': [0, ['e', ]],\n"
"    'È': [0, ['E', ]],\n"
"    'ì': [0, ['i', ]],\n"
"    'Ì': [0, ['I', ]],\n"
"    'ò': [0, ['o', ]],\n"
"    'Ò': [0, ['O', ]],\n"
"    'ù': [0, ['u', ]],\n"
"    'Ù': [0, ['U', ]],\n"
"    'ẁ': [0, ['w', ]],\n"
"    'Ẁ': [0, ['W', ]],\n"
"    'ỳ': [0, ['y', ]],\n"
"    'Ỳ': [0, ['Y', ]],\n"
"    '`': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ẅ': [1, ['w', ]],\n"
"    'Ẅ': [1, ['W', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ÿ': [1, ['Y', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    'ŵ': [2, ['w', ]],\n"
"    'Ŵ': [2, ['W', ]],\n"
"    'ŷ': [2, ['y', ]],\n"
"    'Ŷ': [2, ['Y', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'ẃ': [3, ['w', ]],\n"
"    'Ẃ': [3, ['W', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, },\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x28, },\n"
"    {0x2: 0x2b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000046e,\n"
"  localeName: \"lb\",\n"
"  displayName: \"Luxembourgish\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'è': { 0x0: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'é': { 0x0: 0x27, },\n"
"    'à': { 0x0: 0x28, },\n"
"    '§': { 0x0: 0x29, 0x2: 0x6, },\n"
"    '$': { 0x0: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x4, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x2, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    'ç': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'ü': { 0x1: 0x1a, },\n"
"    '!': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'ö': { 0x1: 0x27, },\n"
"    'ä': { 0x1: 0x28, },\n"
"    '°': { 0x1: 0x29, 0x2: 0x5, },\n"
"    '£': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '¦': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '|': { 0x2: 0x8, },\n"
"    '¢': { 0x2: 0x9, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '{': { 0x2: 0x28, },\n"
"    '}': { 0x2: 0x2b, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '\"': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000481,\n"
"  localeName: \"mi-Latn\",\n"
"  displayName: \"Maori\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ā': [0, ['a', ]],\n"
"    'ē': [0, ['e', ]],\n"
"    'ī': [0, ['i', ]],\n"
"    'ō': [0, ['o', ]],\n"
"    'ū': [0, ['u', ]],\n"
"    'Ā': [0, ['A', ]],\n"
"    'Ē': [0, ['E', ]],\n"
"    'Ī': [0, ['I', ]],\n"
"    'Ō': [0, ['O', ]],\n"
"    'Ū': [0, ['U', ]],\n"
"    '`': [0, ['`', ]],\n"
"    '~': [0, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000807,\n"
"  localeName: \"de-CH\",\n"
"  displayName: \"Swiss German\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ü': { 0x0: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, },\n"
"    'ä': { 0x0: 0x28, },\n"
"    '§': { 0x0: 0x29, 0x2: 0x6, },\n"
"    '$': { 0x0: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x4, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x2, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    'ç': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'è': { 0x1: 0x1a, },\n"
"    '!': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'é': { 0x1: 0x27, },\n"
"    'à': { 0x1: 0x28, },\n"
"    '°': { 0x1: 0x29, 0x2: 0x5, },\n"
"    '£': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    'È': { 0x5: 0x1a, },\n"
"    'É': { 0x5: 0x27, },\n"
"    'À': { 0x5: 0x28, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '¦': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '|': { 0x2: 0x8, },\n"
"    '¢': { 0x2: 0x9, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '{': { 0x2: 0x28, },\n"
"    '}': { 0x2: 0x2b, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"    'Ü': { 0x4: 0x1a, },\n"
"    'Ö': { 0x4: 0x27, },\n"
"    'Ä': { 0x4: 0x28, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000809,\n"
"  localeName: \"en-GB\",\n"
"  displayName: \"United Kingdom\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, 0x2: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '@': { 0x1: 0x28, },\n"
"    '¬': { 0x1: 0x29, },\n"
"    '~': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, 0x3: 0x2b, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    'É': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ú': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Í': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'é': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ú': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'í': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '€': { 0x2: 0x5, },\n"
"    '¦': { 0x2: 0x29, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000080a,\n"
"  localeName: \"es-MX\",\n"
"  displayName: \"Latin American\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '¿': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '+': { 0x0: 0x1b, 0x1: 0x4e, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ñ': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '{': { 0x0: 0x28, },\n"
"    '|': { 0x0: 0x29, },\n"
"    '}': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '¡': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ñ': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '[': { 0x1: 0x28, },\n"
"    '°': { 0x1: 0x29, },\n"
"    ']': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1c': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x2b, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '@': { 0x2: 0x10, },\n"
"    '~': { 0x2: 0x1b, },\n"
"    '¬': { 0x2: 0x29, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, },\n"
"    {0x1: 0x1a, },\n"
"    {0x2: 0x28, },\n"
"    {0x2: 0x2b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000080c,\n"
"  localeName: \"fr-BE\",\n"
"  displayName: \"Belgian French\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '&': { 0x0: 0x2, 0x5: 0x2, },\n"
"    'é': { 0x0: 0x3, 0x5: 0x3, },\n"
"    '\"': { 0x0: 0x4, 0x5: 0x4, },\n"
"    '\\'': { 0x0: 0x5, 0x5: 0x5, },\n"
"    '(': { 0x0: 0x6, 0x5: 0x6, },\n"
"    '§': { 0x0: 0x7, 0x5: 0x7, },\n"
"    'è': { 0x0: 0x8, 0x5: 0x8, },\n"
"    '!': { 0x0: 0x9, 0x5: 0x9, },\n"
"    'ç': { 0x0: 0xa, 0x5: 0xa, },\n"
"    'à': { 0x0: 0xb, 0x5: 0xb, },\n"
"    ')': { 0x0: 0xc, 0x5: 0xc, },\n"
"    '-': { 0x0: 0xd, 0x1: 0x4a, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'a': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'z': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '$': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'q': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'm': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ù': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '²': { 0x0: 0x29, },\n"
"    'µ': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'w': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    ',': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ';': { 0x0: 0x33, 0x5: 0x33, },\n"
"    ':': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '=': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x35, 0x4: 0x35, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, 0x4: 0x2, },\n"
"    '2': { 0x1: 0x3, 0x4: 0x3, },\n"
"    '3': { 0x1: 0x4, 0x4: 0x4, },\n"
"    '4': { 0x1: 0x5, 0x4: 0x5, },\n"
"    '5': { 0x1: 0x6, 0x4: 0x6, },\n"
"    '6': { 0x1: 0x7, 0x4: 0x7, },\n"
"    '7': { 0x1: 0x8, 0x4: 0x8, },\n"
"    '8': { 0x1: 0x9, 0x4: 0x9, },\n"
"    '9': { 0x1: 0xa, 0x4: 0xa, },\n"
"    '0': { 0x1: 0xb, 0x4: 0xb, },\n"
"    '°': { 0x1: 0xc, 0x4: 0xc, },\n"
"    '_': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'A': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Z': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Q': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'M': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '%': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '³': { 0x1: 0x29, },\n"
"    '£': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'W': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    '?': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '.': { 0x1: 0x33, 0x4: 0x33, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '|': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '{': { 0x2: 0x5, },\n"
"    '[': { 0x2: 0x6, },\n"
"    '^': { 0x2: 0x7, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'á': [2, ['a', ]],\n"
"    'é': [2, ['e', ]],\n"
"    'í': [2, ['i', ]],\n"
"    'ó': [2, ['o', ]],\n"
"    'ú': [2, ['u', ]],\n"
"    'ý': [2, ['y', ]],\n"
"    'Á': [2, ['A', ]],\n"
"    'É': [2, ['E', ]],\n"
"    'Í': [2, ['I', ]],\n"
"    'Ó': [2, ['O', ]],\n"
"    'Ú': [2, ['U', ]],\n"
"    'Ý': [2, ['Y', ]],\n"
"    '´': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, 0x5: 0x1a, },\n"
"    {0x1: 0x1a, 0x4: 0x1a, },\n"
"    {0x3: 0x28, 0x2: 0x28, },\n"
"    {0x3: 0x2b, 0x2: 0x2b, },\n"
"    {0x3: 0x35, 0x2: 0x35, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000813,\n"
"  localeName: \"nl-BE\",\n"
"  displayName: \"Belgian (Period)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '&': { 0x0: 0x2, 0x5: 0x2, },\n"
"    'é': { 0x0: 0x3, 0x5: 0x3, },\n"
"    '\"': { 0x0: 0x4, 0x5: 0x4, },\n"
"    '\\'': { 0x0: 0x5, 0x5: 0x5, },\n"
"    '(': { 0x0: 0x6, 0x5: 0x6, },\n"
"    '§': { 0x0: 0x7, 0x5: 0x7, },\n"
"    'è': { 0x0: 0x8, 0x5: 0x8, },\n"
"    '!': { 0x0: 0x9, 0x5: 0x9, },\n"
"    'ç': { 0x0: 0xa, 0x5: 0xa, },\n"
"    'à': { 0x0: 0xb, 0x5: 0xb, },\n"
"    ')': { 0x0: 0xc, 0x5: 0xc, },\n"
"    '-': { 0x0: 0xd, 0x1: 0x4a, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'a': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'z': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '$': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'q': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'm': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ù': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '²': { 0x0: 0x29, },\n"
"    'µ': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'w': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    ',': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ';': { 0x0: 0x33, 0x5: 0x33, },\n"
"    ':': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '=': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x35, 0x4: 0x35, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, 0x4: 0x2, },\n"
"    '2': { 0x1: 0x3, 0x4: 0x3, },\n"
"    '3': { 0x1: 0x4, 0x4: 0x4, },\n"
"    '4': { 0x1: 0x5, 0x4: 0x5, },\n"
"    '5': { 0x1: 0x6, 0x4: 0x6, },\n"
"    '6': { 0x1: 0x7, 0x4: 0x7, },\n"
"    '7': { 0x1: 0x8, 0x4: 0x8, },\n"
"    '8': { 0x1: 0x9, 0x4: 0x9, },\n"
"    '9': { 0x1: 0xa, 0x4: 0xa, },\n"
"    '0': { 0x1: 0xb, 0x4: 0xb, },\n"
"    '°': { 0x1: 0xc, 0x4: 0xc, },\n"
"    '_': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'A': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Z': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Q': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'M': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '%': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '³': { 0x1: 0x29, },\n"
"    '£': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'W': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    '?': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '.': { 0x1: 0x33, 0x4: 0x33, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '|': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '{': { 0x2: 0x5, },\n"
"    '[': { 0x2: 0x6, },\n"
"    '^': { 0x2: 0x7, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'á': [2, ['a', ]],\n"
"    'é': [2, ['e', ]],\n"
"    'í': [2, ['i', ]],\n"
"    'ó': [2, ['o', ]],\n"
"    'ú': [2, ['u', ]],\n"
"    'ý': [2, ['y', ]],\n"
"    'Á': [2, ['A', ]],\n"
"    'É': [2, ['E', ]],\n"
"    'Í': [2, ['I', ]],\n"
"    'Ó': [2, ['O', ]],\n"
"    'Ú': [2, ['U', ]],\n"
"    'Ý': [2, ['Y', ]],\n"
"    '´': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, 0x5: 0x1a, },\n"
"    {0x1: 0x1a, 0x4: 0x1a, },\n"
"    {0x3: 0x28, 0x2: 0x28, },\n"
"    {0x3: 0x2b, 0x2: 0x2b, },\n"
"    {0x3: 0x35, 0x2: 0x35, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000816,\n"
"  localeName: \"pt-PT\",\n"
"  displayName: \"Portuguese\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '«': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '+': { 0x0: 0x1a, 0x1: 0x4e, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ç': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'º': { 0x0: 0x28, },\n"
"    '\\\\': { 0x0: 0x29, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1a, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '»': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ç': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'ª': { 0x1: 0x28, },\n"
"    '|': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '§': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ã': [1, ['a', ]],\n"
"    'õ': [1, ['o', ]],\n"
"    'ñ': [1, ['n', ]],\n"
"    'Ã': [1, ['A', ]],\n"
"    'Õ': [1, ['O', ]],\n"
"    'Ñ': [1, ['N', ]],\n"
"    '~': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ä': [4, ['a', ]],\n"
"    'ë': [4, ['e', ]],\n"
"    'ï': [4, ['i', ]],\n"
"    'ö': [4, ['o', ]],\n"
"    'ü': [4, ['u', ]],\n"
"    'ÿ': [4, ['y', ]],\n"
"    'Ä': [4, ['A', ]],\n"
"    'Ë': [4, ['E', ]],\n"
"    'Ï': [4, ['I', ]],\n"
"    'Ö': [4, ['O', ]],\n"
"    'Ü': [4, ['U', ]],\n"
"    '¨': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1b, },\n"
"    {0x0: 0x2b, },\n"
"    {0x1: 0x1b, },\n"
"    {0x1: 0x2b, },\n"
"    {0x2: 0x1a, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000081a,\n"
"  localeName: \"sr-Latn-CS\",\n"
"  displayName: \"Serbian (Latin)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'š': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'đ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'č': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ć': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ž': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Š': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Đ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Č': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ć': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '~': { 0x1: 0x29, 0x2: 0x2, },\n"
"    'Ž': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '¤': { 0x2: 0x2b, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ç': [0, ['c', ]],\n"
"    'ş': [0, ['s', ]],\n"
"    'Ç': [0, ['C', ]],\n"
"    'Ş': [0, ['S', ]],\n"
"    '‚': [1, [' ', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'ľ': [2, ['l', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'Ľ': [2, ['L', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ă': [4, ['a', ]],\n"
"    'Ă': [4, ['A', ]],\n"
"    '˘': [4, [' ', ]],\n"
"    'ů': [5, ['u', ]],\n"
"    'Ů': [5, ['U', ]],\n"
"    '°': [5, [' ', ]],\n"
"    'ą': [6, ['a', ]],\n"
"    'ę': [6, ['e', ]],\n"
"    'Ą': [6, ['A', ]],\n"
"    'Ę': [6, ['E', ]],\n"
"    '˛': [6, [' ', ]],\n"
"    'ż': [7, ['z', ]],\n"
"    'Ż': [7, ['Z', ]],\n"
"    '˙': [7, [' ', ]],\n"
"    'ń': [8, ['n', ]],\n"
"    'ć': [8, ['c', ]],\n"
"    'ý': [8, ['y', ]],\n"
"    'á': [8, ['a', ]],\n"
"    'ś': [8, ['s', ]],\n"
"    'ĺ': [8, ['l', ]],\n"
"    'é': [8, ['e', ]],\n"
"    'ŕ': [8, ['r', ]],\n"
"    'ú': [8, ['u', ]],\n"
"    'í': [8, ['i', ]],\n"
"    'ź': [8, ['z', ]],\n"
"    'ó': [8, ['o', ]],\n"
"    'Ń': [8, ['N', ]],\n"
"    'Ć': [8, ['C', ]],\n"
"    'Ý': [8, ['Y', ]],\n"
"    'Á': [8, ['A', ]],\n"
"    'Ś': [8, ['S', ]],\n"
"    'Ĺ': [8, ['L', ]],\n"
"    'É': [8, ['E', ]],\n"
"    'Ŕ': [8, ['R', ]],\n"
"    'Ú': [8, ['U', ]],\n"
"    'Í': [8, ['I', ]],\n"
"    'Ź': [8, ['Z', ]],\n"
"    'Ó': [8, ['O', ]],\n"
"    '´': [8, [' ', ]],\n"
"    'ű': [9, ['u', ]],\n"
"    'ő': [9, ['o', ]],\n"
"    'Ű': [9, ['U', ]],\n"
"    'Ő': [9, ['O', ]],\n"
"    '˝': [9, [' ', ]],\n"
"    'ä': [10, ['a', ]],\n"
"    'ë': [10, ['e', ]],\n"
"    'ü': [10, ['u', ]],\n"
"    'ö': [10, ['o', ]],\n"
"    'Ä': [10, ['A', ]],\n"
"    'Ë': [10, ['E', ]],\n"
"    'Ü': [10, ['U', ]],\n"
"    'Ö': [10, ['O', ]],\n"
"    '¨': [10, [' ', ]],\n"
"    '¸': [11, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, 0x2: 0xd, },\n"
"    {0x0: 0x29, },\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x6, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xa, },\n"
"    {0x2: 0xb, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000083b,\n"
"  localeName: \"se-Latn-SE\",\n"
"  displayName: \"Swedish with Sami\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '§': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '½': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    'Â': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'Ŧ': { 0x3: 0x14, 0x6: 0x14, },\n"
"    'Ï': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Õ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Š': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    'Đ': { 0x3: 0x20, 0x6: 0x20, },\n"
"    'Ǥ': { 0x3: 0x21, 0x6: 0x21, },\n"
"    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },\n"
"    'Ȟ': { 0x3: 0x23, 0x6: 0x23, },\n"
"    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },\n"
"    'Ø': { 0x3: 0x27, 0x6: 0x27, },\n"
"    'Æ': { 0x3: 0x28, 0x6: 0x28, },\n"
"    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'Č': { 0x3: 0x2e, 0x6: 0x2e, },\n"
"    'Ǯ': { 0x3: 0x2f, 0x6: 0x2f, },\n"
"    'Ʒ': { 0x3: 0x30, 0x6: 0x30, },\n"
"    'Ŋ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'â': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'ŧ': { 0x7: 0x14, 0x2: 0x14, },\n"
"    'ï': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'õ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'š': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    'đ': { 0x7: 0x20, 0x2: 0x20, },\n"
"    'ǥ': { 0x7: 0x21, 0x2: 0x21, },\n"
"    'ǧ': { 0x7: 0x22, 0x2: 0x22, },\n"
"    'ȟ': { 0x7: 0x23, 0x2: 0x23, },\n"
"    'ǩ': { 0x7: 0x25, 0x2: 0x25, },\n"
"    'ø': { 0x7: 0x27, 0x2: 0x27, },\n"
"    'æ': { 0x7: 0x28, 0x2: 0x28, },\n"
"    'ž': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'č': { 0x7: 0x2e, 0x2: 0x2e, },\n"
"    'ǯ': { 0x7: 0x2f, 0x2: 0x2f, },\n"
"    'ʒ': { 0x7: 0x30, 0x2: 0x30, },\n"
"    'ŋ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '|': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ẃ': [0, ['w', ]],\n"
"    'Ẃ': [0, ['W', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    'ǻ': [0, ['å', ]],\n"
"    'Ǻ': [0, ['Å', ]],\n"
"    'ǽ': [0, ['æ', ]],\n"
"    'Ǽ': [0, ['Æ', ]],\n"
"    'ǿ': [0, ['ø', ]],\n"
"    'Ǿ': [0, ['Ø', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ẅ': [1, ['w', ]],\n"
"    'Ẅ': [1, ['W', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ÿ': [1, ['Y', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    'ẁ': [2, ['w', ]],\n"
"    'Ẁ': [2, ['W', ]],\n"
"    'ỳ': [2, ['y', ]],\n"
"    'Ỳ': [2, ['Y', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'ĉ': [3, ['c', ]],\n"
"    'Ĉ': [3, ['C', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'ĝ': [3, ['g', ]],\n"
"    'Ĝ': [3, ['G', ]],\n"
"    'ĥ': [3, ['h', ]],\n"
"    'Ĥ': [3, ['H', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'ĵ': [3, ['j', ]],\n"
"    'Ĵ': [3, ['J', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'ŝ': [3, ['s', ]],\n"
"    'Ŝ': [3, ['S', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    'ŵ': [3, ['w', ]],\n"
"    'Ŵ': [3, ['W', ]],\n"
"    'ŷ': [3, ['y', ]],\n"
"    'Ŷ': [3, ['Y', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'ĩ': [4, ['i', ]],\n"
"    'Ĩ': [4, ['I', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'ũ': [4, ['u', ]],\n"
"    'Ũ': [4, ['U', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000843,\n"
"  localeName: \"uz-Cyrl\",\n"
"  displayName: \"Uzbek Cyrillic\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    'ғ': { 0x0: 0xc, 0x5: 0xc, },\n"
"    'ҳ': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ў': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'қ': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ж': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'э': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'ё': { 0x0: 0x29, 0x5: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ь': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '.': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '-': { 0x0: 0x4a, 0x1: 0x4a, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4e, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x2b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '№': { 0x1: 0x4, },\n"
"    ';': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    ':': { 0x1: 0x7, },\n"
"    '?': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    'Ғ': { 0x1: 0xc, 0x4: 0xc, },\n"
"    'Ҳ': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ў': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Қ': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ж': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Э': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Ё': { 0x1: 0x29, 0x4: 0x29, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ь': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    ',': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000085d,\n"
"  localeName: \"iu-Latn\",\n"
"  displayName: \"Inuktitut - Latin\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, 0x1: 0x2, 0x5: 0x2, },\n"
"    '2': { 0x0: 0x3, 0x1: 0x3, 0x5: 0x3, },\n"
"    '3': { 0x0: 0x4, 0x1: 0x4, 0x5: 0x4, },\n"
"    '4': { 0x0: 0x5, 0x1: 0x5, 0x5: 0x5, },\n"
"    '5': { 0x0: 0x6, 0x1: 0x6, 0x5: 0x6, },\n"
"    '6': { 0x0: 0x7, 0x1: 0x7, 0x5: 0x7, },\n"
"    '7': { 0x0: 0x8, 0x1: 0x8, 0x5: 0x8, },\n"
"    '8': { 0x0: 0x9, 0x1: 0x9, 0x5: 0x9, },\n"
"    '9': { 0x0: 0xa, 0x1: 0xa, 0x5: 0xa, },\n"
"    '0': { 0x0: 0xb, 0x1: 0xb, 0x5: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, 0x4: 0xc, },\n"
"    '=': { 0x0: 0xd, 0x2: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, },\n"
"    'w': { 0x0: 0x11, },\n"
"    'e': { 0x0: 0x12, },\n"
"    'r': { 0x0: 0x13, },\n"
"    't': { 0x0: 0x14, },\n"
"    'y': { 0x0: 0x15, },\n"
"    'u': { 0x0: 0x16, },\n"
"    'i': { 0x0: 0x17, },\n"
"    'o': { 0x0: 0x18, },\n"
"    'p': { 0x0: 0x19, },\n"
"    '[': { 0x0: 0x1a, 0x2: 0xa, },\n"
"    ']': { 0x0: 0x1b, 0x2: 0xb, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, },\n"
"    's': { 0x0: 0x1f, },\n"
"    'd': { 0x0: 0x20, },\n"
"    'f': { 0x0: 0x21, },\n"
"    'g': { 0x0: 0x22, },\n"
"    'h': { 0x0: 0x23, },\n"
"    'j': { 0x0: 0x24, },\n"
"    'k': { 0x0: 0x25, },\n"
"    'l': { 0x0: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, },\n"
"    'x': { 0x0: 0x2d, },\n"
"    'c': { 0x0: 0x2e, },\n"
"    'v': { 0x0: 0x2f, },\n"
"    'b': { 0x0: 0x30, },\n"
"    'n': { 0x0: 0x31, },\n"
"    'm': { 0x0: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, 0x4: 0x2b, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x7, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, 0x5: 0xd, 0x3: 0xb, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, },\n"
"    'W': { 0x1: 0x11, },\n"
"    'E': { 0x1: 0x12, },\n"
"    'R': { 0x1: 0x13, },\n"
"    'T': { 0x1: 0x14, },\n"
"    'Y': { 0x1: 0x15, },\n"
"    'U': { 0x1: 0x16, },\n"
"    'I': { 0x1: 0x17, },\n"
"    'O': { 0x1: 0x18, },\n"
"    'P': { 0x1: 0x19, },\n"
"    '{': { 0x1: 0x1a, 0x3: 0x2f, },\n"
"    '}': { 0x1: 0x1b, 0x3: 0x30, },\n"
"    'A': { 0x1: 0x1e, },\n"
"    'S': { 0x1: 0x1f, },\n"
"    'D': { 0x1: 0x20, },\n"
"    'F': { 0x1: 0x21, },\n"
"    'G': { 0x1: 0x22, },\n"
"    'H': { 0x1: 0x23, },\n"
"    'J': { 0x1: 0x24, },\n"
"    'K': { 0x1: 0x25, },\n"
"    'L': { 0x1: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, 0x3: 0x29, },\n"
"    '|': { 0x1: 0x2b, 0x3: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, },\n"
"    'X': { 0x1: 0x2d, },\n"
"    'C': { 0x1: 0x2e, },\n"
"    'V': { 0x1: 0x2f, },\n"
"    'B': { 0x1: 0x30, },\n"
"    'N': { 0x1: 0x31, },\n"
"    'M': { 0x1: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, 0x5: 0x2f, },\n"
"    '−': { 0x5: 0xc, },\n"
"    'ᒋ': { 0x5: 0x10, },\n"
"    'ᐱ': { 0x5: 0x11, },\n"
"    'ᕆ': { 0x5: 0x12, },\n"
"    'ᖖ': { 0x5: 0x13, },\n"
"    'ᙱ': { 0x5: 0x14, },\n"
"    'ᙳ': { 0x5: 0x15, },\n"
"    'ᙵ': { 0x5: 0x16, },\n"
"    'ᖤ': { 0x5: 0x17, },\n"
"    'ᖠ': { 0x5: 0x18, },\n"
"    'ᖦ': { 0x5: 0x19, },\n"
"    'ᔅ': { 0x5: 0x1a, },\n"
"    'ᒍ': { 0x5: 0x1e, },\n"
"    'ᐳ': { 0x5: 0x1f, },\n"
"    'ᕈ': { 0x5: 0x20, },\n"
"    'ᕕ': { 0x5: 0x21, },\n"
"    '(': { 0x5: 0x22, },\n"
"    ')': { 0x5: 0x23, },\n"
"    'ᔪ': { 0x5: 0x24, },\n"
"    'ᕗ': { 0x5: 0x25, },\n"
"    'ᖢ': { 0x5: 0x26, },\n"
"    'ᒐ': { 0x5: 0x2c, },\n"
"    'ᐸ': { 0x5: 0x2d, },\n"
"    'ᕋ': { 0x5: 0x2e, },\n"
"    'ᕼ': { 0x5: 0x30, },\n"
"    'ᓇ': { 0x5: 0x31, },\n"
"    'ᓚ': { 0x5: 0x32, },\n"
"    'ᕙ': { 0x5: 0x35, },\n"
"    '¢': { 0x3: 0x2, },\n"
"    '®': { 0x3: 0x3, },\n"
"    '¼': { 0x3: 0x4, },\n"
"    '½': { 0x3: 0x5, },\n"
"    '¾': { 0x3: 0x6, },\n"
"    '^': { 0x3: 0x7, },\n"
"    '⅔': { 0x3: 0x8, },\n"
"    '©': { 0x3: 0x9, },\n"
"    '÷': { 0x3: 0xa, },\n"
"    'ᒌ': { 0x3: 0x10, },\n"
"    'ᐲ': { 0x3: 0x11, },\n"
"    'ᕇ': { 0x3: 0x12, },\n"
"    'ᙲ': { 0x3: 0x14, },\n"
"    'ᙴ': { 0x3: 0x15, },\n"
"    'ᙶ': { 0x3: 0x16, },\n"
"    'ᖥ': { 0x3: 0x17, },\n"
"    'ᖡ': { 0x3: 0x18, },\n"
"    '”': { 0x3: 0x1a, },\n"
"    '’': { 0x3: 0x1b, },\n"
"    'ᒎ': { 0x3: 0x1e, },\n"
"    'ᐴ': { 0x3: 0x1f, },\n"
"    'ᕉ': { 0x3: 0x20, },\n"
"    'ᕖ': { 0x3: 0x21, },\n"
"    'ᔫ': { 0x3: 0x24, },\n"
"    'ᕘ': { 0x3: 0x25, },\n"
"    'ᖣ': { 0x3: 0x26, },\n"
"    'Ŋ': { 0x3: 0x27, },\n"
"    'Ł': { 0x3: 0x28, },\n"
"    'ᒑ': { 0x3: 0x2c, },\n"
"    'ᐹ': { 0x3: 0x2d, },\n"
"    'ᕌ': { 0x3: 0x2e, },\n"
"    'ᓈ': { 0x3: 0x31, },\n"
"    'ᓛ': { 0x3: 0x32, },\n"
"    'ᕚ': { 0x3: 0x35, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '!': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '%': { 0x2: 0x6, },\n"
"    '&': { 0x2: 0x8, },\n"
"    '•': { 0x2: 0x9, },\n"
"    'ᖐ': { 0x2: 0x10, },\n"
"    'ᐄ': { 0x2: 0x11, },\n"
"    'ᖀ': { 0x2: 0x12, },\n"
"    'ᑮ': { 0x2: 0x13, },\n"
"    'ᑏ': { 0x2: 0x14, },\n"
"    'ᓰ': { 0x2: 0x15, },\n"
"    'ᒦ': { 0x2: 0x16, },\n"
"    'ᓃ': { 0x2: 0x17, },\n"
"    'ᓖ': { 0x2: 0x18, },\n"
"    'ᔩ': { 0x2: 0x19, },\n"
"    '“': { 0x2: 0x1a, },\n"
"    '‘': { 0x2: 0x1b, },\n"
"    'ᖒ': { 0x2: 0x1e, },\n"
"    'ᐆ': { 0x2: 0x1f, },\n"
"    'ᖂ': { 0x2: 0x20, },\n"
"    'ᑰ': { 0x2: 0x21, },\n"
"    'ᑑ': { 0x2: 0x22, },\n"
"    'ᓲ': { 0x2: 0x23, },\n"
"    'ᒨ': { 0x2: 0x24, },\n"
"    'ᓅ': { 0x2: 0x25, },\n"
"    'ᓘ': { 0x2: 0x26, },\n"
"    'ŋ': { 0x2: 0x27, },\n"
"    'ł': { 0x2: 0x28, },\n"
"    'ᖔ': { 0x2: 0x2c, },\n"
"    'ᐋ': { 0x2: 0x2d, },\n"
"    'ᖄ': { 0x2: 0x2e, },\n"
"    'ᑳ': { 0x2: 0x2f, },\n"
"    'ᑖ': { 0x2: 0x30, },\n"
"    'ᓵ': { 0x2: 0x31, },\n"
"    'ᒫ': { 0x2: 0x32, },\n"
"    'ᔮ': { 0x2: 0x35, },\n"
"    'ᖕ': { 0x4: 0x2, },\n"
"    'ᑉ': { 0x4: 0x3, },\n"
"    'ᕐ': { 0x4: 0x4, },\n"
"    'ᒃ': { 0x4: 0x5, },\n"
"    'ᑦ': { 0x4: 0x6, },\n"
"    'ᖅ': { 0x4: 0x7, },\n"
"    'ᒻ': { 0x4: 0x8, },\n"
"    'ᓐ': { 0x4: 0x9, },\n"
"    'ᓪ': { 0x4: 0xa, },\n"
"    'ᔾ': { 0x4: 0xb, },\n"
"    'ᕝ': { 0x4: 0xd, },\n"
"    'ᖏ': { 0x4: 0x10, },\n"
"    'ᐃ': { 0x4: 0x11, },\n"
"    'ᕿ': { 0x4: 0x12, },\n"
"    'ᑭ': { 0x4: 0x13, },\n"
"    'ᑎ': { 0x4: 0x14, },\n"
"    'ᓯ': { 0x4: 0x15, },\n"
"    'ᒥ': { 0x4: 0x16, },\n"
"    'ᓂ': { 0x4: 0x17, },\n"
"    'ᓕ': { 0x4: 0x18, },\n"
"    'ᔨ': { 0x4: 0x19, },\n"
"    'ᒡ': { 0x4: 0x1a, },\n"
"    'ᐞ': { 0x4: 0x1b, },\n"
"    'ᖑ': { 0x4: 0x1e, },\n"
"    'ᐅ': { 0x4: 0x1f, },\n"
"    'ᖁ': { 0x4: 0x20, },\n"
"    'ᑯ': { 0x4: 0x21, },\n"
"    'ᑐ': { 0x4: 0x22, },\n"
"    'ᓱ': { 0x4: 0x23, },\n"
"    'ᒧ': { 0x4: 0x24, },\n"
"    'ᓄ': { 0x4: 0x25, },\n"
"    'ᓗ': { 0x4: 0x26, },\n"
"    'ᖓ': { 0x4: 0x2c, },\n"
"    'ᐊ': { 0x4: 0x2d, },\n"
"    'ᖃ': { 0x4: 0x2e, },\n"
"    'ᑲ': { 0x4: 0x2f, },\n"
"    'ᑕ': { 0x4: 0x30, },\n"
"    'ᓴ': { 0x4: 0x31, },\n"
"    'ᒪ': { 0x4: 0x32, },\n"
"    'ᔭ': { 0x4: 0x35, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000c0c,\n"
"  localeName: \"fr-CA\",\n"
"  displayName: \"Canadian French (Legacy)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ç': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    'è': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '°': { 0x0: 0x29, 0x1: 0x29, 0x2: 0x1a, },\n"
"    'à': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, 0x1: 0x34, },\n"
"    'é': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    'ù': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, 0x2: 0x35, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '?': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ç': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    'È': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'À': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '\\'': { 0x1: 0x33, },\n"
"    'É': { 0x1: 0x35, 0x4: 0x35, },\n"
"    'Ù': { 0x1: 0x56, 0x4: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '¡': { 0x3: 0x2, },\n"
"    '²': { 0x3: 0x3, },\n"
"    '£': { 0x3: 0x4, },\n"
"    '¤': { 0x3: 0x5, },\n"
"    '±': { 0x3: 0xa, },\n"
"    '¿': { 0x3: 0xc, },\n"
"    '®': { 0x3: 0x13, },\n"
"    'Ø': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Þ': { 0x3: 0x19, 0x6: 0x19, },\n"
"    'Æ': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '§': { 0x3: 0x1f, },\n"
"    'Ð': { 0x3: 0x20, 0x6: 0x20, },\n"
"    '©': { 0x3: 0x2e, },\n"
"    'º': { 0x3: 0x32, },\n"
"    '|': { 0x3: 0x56, 0x2: 0xc, },\n"
"    'ø': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'þ': { 0x7: 0x19, 0x2: 0x19, },\n"
"    'æ': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ð': { 0x7: 0x20, 0x2: 0x20, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '¹': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '¼': { 0x2: 0x5, },\n"
"    '½': { 0x2: 0x6, },\n"
"    '¾': { 0x2: 0x7, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '¶': { 0x2: 0x13, },\n"
"    '¥': { 0x2: 0x15, },\n"
"    'ß': { 0x2: 0x1f, },\n"
"    'ª': { 0x2: 0x21, },\n"
"    '¬': { 0x2: 0x29, },\n"
"    '«': { 0x2: 0x2c, },\n"
"    '»': { 0x2: 0x2d, },\n"
"    '¢': { 0x2: 0x2e, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'á': [2, ['a', ]],\n"
"    'é': [2, ['e', ]],\n"
"    'í': [2, ['i', ]],\n"
"    'ó': [2, ['o', ]],\n"
"    'ú': [2, ['u', ]],\n"
"    'ý': [2, ['y', ]],\n"
"    'Á': [2, ['A', ]],\n"
"    'É': [2, ['E', ]],\n"
"    'Í': [2, ['I', ]],\n"
"    'Ó': [2, ['O', ]],\n"
"    'Ú': [2, ['U', ]],\n"
"    'Ý': [2, ['Y', ]],\n"
"    '´': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"    'ç': [4, ['c', ]],\n"
"    'Ç': [4, ['C', ]],\n"
"    'ã': [5, ['a', ]],\n"
"    'õ': [5, ['o', ]],\n"
"    'ñ': [5, ['n', ]],\n"
"    'Ã': [5, ['A', ]],\n"
"    'Õ': [5, ['O', ]],\n"
"    'Ñ': [5, ['N', ]],\n"
"    '~': [5, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, 0x1: 0x1a, },\n"
"    {0x3: 0x1b, },\n"
"    {0x3: 0x27, 0x2: 0x27, },\n"
"    {0x3: 0x2b, 0x2: 0x2b, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00000c1a,\n"
"  localeName: \"sr-Cyrl-CS\",\n"
"  displayName: \"Serbian (Cyrillic)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'љ': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'њ': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'е': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'р': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'т': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'з': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'у': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'и': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'о': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'п': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ш': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ђ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'а': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'с': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'д': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'ф': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'г': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'х': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ј': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'к': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'л': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ч': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ћ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    'ж': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'ѕ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'џ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ц': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'в': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'б': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'н': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'м': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Љ': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Њ': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'Е': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Р': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Т': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'З': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'У': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'И': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'О': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'П': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ш': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ђ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'А': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'С': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Д': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Ф': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Г': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Х': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ј': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'К': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Л': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ч': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ћ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    'Ж': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Ѕ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Џ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ц': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'В': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Б': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Н': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'М': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '€': { 0x2: 0x12, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ѓ': [0, ['г', ]],\n"
"    'ќ': [0, ['к', ]],\n"
"    'Ѓ': [0, ['Г', ]],\n"
"    'Ќ': [0, ['К', ]],\n"
"    '\\'': [0, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xc, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00001009,\n"
"  localeName: \"en-CA\",\n"
"  displayName: \"Canadian French\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '#': { 0x0: 0x29, },\n"
"    '<': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, 0x1: 0x34, },\n"
"    'é': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '«': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x4, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '?': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '|': { 0x1: 0x29, },\n"
"    '>': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '\\'': { 0x1: 0x33, },\n"
"    'É': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '»': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '±': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '¢': { 0x2: 0x5, },\n"
"    '¤': { 0x2: 0x6, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '¦': { 0x2: 0x8, },\n"
"    '²': { 0x2: 0x9, },\n"
"    '³': { 0x2: 0xa, },\n"
"    '¼': { 0x2: 0xb, },\n"
"    '½': { 0x2: 0xc, },\n"
"    '¾': { 0x2: 0xd, },\n"
"    '§': { 0x2: 0x18, },\n"
"    '¶': { 0x2: 0x19, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '~': { 0x2: 0x27, },\n"
"    '{': { 0x2: 0x28, },\n"
"    '\\\\': { 0x2: 0x29, },\n"
"    '}': { 0x2: 0x2b, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '¯': { 0x2: 0x33, },\n"
"    '\\xad': { 0x2: 0x34, },\n"
"    '°': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ç': [1, ['c', ]],\n"
"    'Ç': [1, ['C', ]],\n"
"    '¸': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'ä': [3, ['a', ]],\n"
"    'ë': [3, ['e', ]],\n"
"    'ï': [3, ['i', ]],\n"
"    'ö': [3, ['o', ]],\n"
"    'ü': [3, ['u', ]],\n"
"    'ÿ': [3, ['y', ]],\n"
"    'Ä': [3, ['A', ]],\n"
"    'Ë': [3, ['E', ]],\n"
"    'Ï': [3, ['I', ]],\n"
"    'Ö': [3, ['O', ]],\n"
"    'Ü': [3, ['U', ]],\n"
"    '¨': [3, [' ', ]],\n"
"    'á': [4, ['a', ]],\n"
"    'é': [4, ['e', ]],\n"
"    'í': [4, ['i', ]],\n"
"    'ó': [4, ['o', ]],\n"
"    'ú': [4, ['u', ]],\n"
"    'ý': [4, ['y', ]],\n"
"    'Á': [4, ['A', ]],\n"
"    'É': [4, ['E', ]],\n"
"    'Í': [4, ['I', ]],\n"
"    'Ó': [4, ['O', ]],\n"
"    'Ú': [4, ['U', ]],\n"
"    'Ý': [4, ['Y', ]],\n"
"    '´': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, 0x1: 0x1a, },\n"
"    {0x0: 0x1b, },\n"
"    {0x0: 0x28, 0x1: 0x28, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0x35, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000100c,\n"
"  localeName: \"fr-CH\",\n"
"  displayName: \"Swiss French\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'è': { 0x0: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'é': { 0x0: 0x27, },\n"
"    'à': { 0x0: 0x28, },\n"
"    '§': { 0x0: 0x29, 0x2: 0x6, },\n"
"    '$': { 0x0: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x4, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x2, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    'ç': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'ü': { 0x1: 0x1a, },\n"
"    '!': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'ö': { 0x1: 0x27, },\n"
"    'ä': { 0x1: 0x28, },\n"
"    '°': { 0x1: 0x29, 0x2: 0x5, },\n"
"    '£': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '¦': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '|': { 0x2: 0x8, },\n"
"    '¢': { 0x2: 0x9, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '{': { 0x2: 0x28, },\n"
"    '}': { 0x2: 0x2b, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '\"': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00001809,\n"
"  localeName: \"en-IE\",\n"
"  displayName: \"Irish\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '@': { 0x1: 0x28, },\n"
"    '¬': { 0x1: 0x29, },\n"
"    '~': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    'É': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ú': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Í': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '`': { 0x3: 0x28, },\n"
"    '¦': { 0x3: 0x29, 0x2: 0x29, },\n"
"    'é': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ú': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'í': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '€': { 0x2: 0x5, },\n"
"  },\n"
"  deadkeys: {\n"
"    'à': [0, ['a', ]],\n"
"    'è': [0, ['e', ]],\n"
"    'ì': [0, ['i', ]],\n"
"    'ò': [0, ['o', ]],\n"
"    'ù': [0, ['u', ]],\n"
"    'À': [0, ['A', ]],\n"
"    'È': [0, ['E', ]],\n"
"    'Ì': [0, ['I', ]],\n"
"    'Ò': [0, ['O', ]],\n"
"    'Ù': [0, ['U', ]],\n"
"    '`': [0, [' ', ]],\n"
"    'á': [1, ['a', ]],\n"
"    'é': [1, ['e', ]],\n"
"    'í': [1, ['i', ]],\n"
"    'ó': [1, ['o', ]],\n"
"    'ú': [1, ['u', ]],\n"
"    'ý': [1, ['y', ]],\n"
"    'Á': [1, ['A', ]],\n"
"    'É': [1, ['E', ]],\n"
"    'Í': [1, ['I', ]],\n"
"    'Ó': [1, ['O', ]],\n"
"    'Ú': [1, ['U', ]],\n"
"    'Ý': [1, ['Y', ]],\n"
"    '´': [1, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, },\n"
"    {0x2: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0000201a,\n"
"  localeName: \"bs-Cyrl\",\n"
"  displayName: \"Bosnian (Cyrillic)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'љ': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'њ': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'е': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'р': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'т': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'з': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'у': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'и': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'о': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'п': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ш': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ђ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'а': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'с': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'д': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'ф': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'г': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'х': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ј': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'к': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'л': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ч': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ћ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    'ж': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'ѕ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'џ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ц': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'в': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'б': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'н': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'м': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Љ': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Њ': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'Е': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Р': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Т': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'З': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'У': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'И': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'О': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'П': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ш': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ђ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'А': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'С': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Д': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Ф': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Г': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Х': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ј': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'К': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Л': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ч': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ћ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    'Ж': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Ѕ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Џ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ц': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'В': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Б': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Н': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'М': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '^': { 0x2: 0x4, },\n"
"    '°': { 0x2: 0x6, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ѓ': [0, ['г', ]],\n"
"    'ќ': [0, ['к', ]],\n"
"    'Ѓ': [0, ['Г', ]],\n"
"    'Ќ': [0, ['К', ]],\n"
"    '\\'': [0, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xc, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010402,\n"
"  localeName: \"bg\",\n"
"  displayName: \"Bulgarian (Latin)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010405,\n"
"  localeName: \"cs\",\n"
"  displayName: \"Czech (QWERTY)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '+': { 0x0: 0x2, 0x1: 0x4e, 0x3: 0xd, },\n"
"    'ě': { 0x0: 0x3, },\n"
"    'š': { 0x0: 0x4, },\n"
"    'č': { 0x0: 0x5, },\n"
"    'ř': { 0x0: 0x6, },\n"
"    'ž': { 0x0: 0x7, },\n"
"    'ý': { 0x0: 0x8, },\n"
"    'á': { 0x0: 0x9, },\n"
"    'í': { 0x0: 0xa, },\n"
"    'é': { 0x0: 0xb, },\n"
"    '=': { 0x0: 0xc, 0x2: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ú': { 0x0: 0x1a, },\n"
"    ')': { 0x0: 0x1b, 0x2: 0xb, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ů': { 0x0: 0x27, },\n"
"    '§': { 0x0: 0x28, },\n"
"    ';': { 0x0: 0x29, 0x2: 0x27, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, 0x2: 0xc, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '\\\\': { 0x0: 0x56, 0x2: 0x2b, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x1a, 0x5: 0x1a, 0x2: 0x35, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, 0x5: 0x3, },\n"
"    '3': { 0x1: 0x4, 0x5: 0x4, },\n"
"    '4': { 0x1: 0x5, 0x5: 0x5, },\n"
"    '5': { 0x1: 0x6, 0x5: 0x6, },\n"
"    '6': { 0x1: 0x7, 0x5: 0x7, },\n"
"    '7': { 0x1: 0x8, 0x5: 0x8, },\n"
"    '8': { 0x1: 0x9, 0x5: 0x9, },\n"
"    '9': { 0x1: 0xa, 0x5: 0xa, },\n"
"    '0': { 0x1: 0xb, 0x5: 0xb, },\n"
"    '%': { 0x1: 0xc, 0x2: 0x6, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '(': { 0x1: 0x1b, 0x2: 0xa, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '\"': { 0x1: 0x27, 0x5: 0x27, },\n"
"    '!': { 0x1: 0x28, 0x2: 0x2, },\n"
"    '\\'': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '?': { 0x1: 0x33, 0x3: 0x35, },\n"
"    ':': { 0x1: 0x34, 0x3: 0x27, },\n"
"    '_': { 0x1: 0x35, 0x3: 0xc, },\n"
"    '|': { 0x1: 0x56, 0x3: 0x2b, },\n"
"    '{': { 0x3: 0x1a, },\n"
"    '}': { 0x3: 0x1b, },\n"
"    '~': { 0x3: 0x29, },\n"
"    '×': { 0x3: 0x33, },\n"
"    '÷': { 0x3: 0x34, },\n"
"    '\\x1e': { 0x0: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '^': { 0x2: 0x7, },\n"
"    '&': { 0x2: 0x8, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '¤': { 0x2: 0x28, },\n"
"    '`': { 0x2: 0x29, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"    'ß': { 0x2: 0x56, },\n"
"    'Ě': { 0x4: 0x3, },\n"
"    'Š': { 0x4: 0x4, },\n"
"    'Č': { 0x4: 0x5, },\n"
"    'Ř': { 0x4: 0x6, },\n"
"    'Ž': { 0x4: 0x7, },\n"
"    'Ý': { 0x4: 0x8, },\n"
"    'Á': { 0x4: 0x9, },\n"
"    'Í': { 0x4: 0xa, },\n"
"    'É': { 0x4: 0xb, },\n"
"    'Ú': { 0x4: 0x1a, },\n"
"    'Ů': { 0x4: 0x27, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ÿ': [1, ['Y', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'ľ': [2, ['l', ]],\n"
"    'Ľ': [2, ['L', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'å': [3, ['a', ]],\n"
"    'Å': [3, ['A', ]],\n"
"    'ů': [3, ['u', ]],\n"
"    'Ů': [3, ['U', ]],\n"
"    '°': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'ô': [4, ['o', ]],\n"
"    'Ô': [4, ['O', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    '^': [4, [' ', ]],\n"
"    'ő': [5, ['o', ]],\n"
"    'Ő': [5, ['O', ]],\n"
"    'ű': [5, ['u', ]],\n"
"    'Ű': [5, ['U', ]],\n"
"    '˝': [5, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x2b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x29, },\n"
"    {0x3: 0x28, },\n"
"    {0x3: 0x56, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010407,\n"
"  localeName: \"de-DE\",\n"
"  displayName: \"German (IBM)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    'ß': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ü': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '+': { 0x0: 0x1b, 0x1: 0x4e, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '§': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ü': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '°': { 0x1: 0x29, },\n"
"    '\\'': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0x35, },\n"
"    '²': { 0x3: 0x3, 0x2: 0x3, },\n"
"    '³': { 0x3: 0x4, 0x2: 0x4, },\n"
"    '{': { 0x3: 0x8, 0x2: 0x8, },\n"
"    '[': { 0x3: 0x9, 0x2: 0x9, },\n"
"    ']': { 0x3: 0xa, 0x2: 0xa, },\n"
"    '}': { 0x3: 0xb, 0x2: 0xb, },\n"
"    'ẞ': { 0x3: 0xc, },\n"
"    '@': { 0x3: 0x10, 0x2: 0x10, },\n"
"    '~': { 0x3: 0x1b, 0x2: 0x1b, },\n"
"    'µ': { 0x3: 0x32, 0x2: 0x32, },\n"
"    '|': { 0x3: 0x56, 0x2: 0x56, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '€': { 0x2: 0x12, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'â': [1, ['a', ]],\n"
"    'ê': [1, ['e', ]],\n"
"    'î': [1, ['i', ]],\n"
"    'ô': [1, ['o', ]],\n"
"    'û': [1, ['u', ]],\n"
"    'Â': [1, ['A', ]],\n"
"    'Ê': [1, ['E', ]],\n"
"    'Î': [1, ['I', ]],\n"
"    'Ô': [1, ['O', ]],\n"
"    'Û': [1, ['U', ]],\n"
"    '^': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x29, },\n"
"    {0x1: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek (220)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    ']': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    ';': { 0x0: 0x10, },\n"
"    'ς': { 0x0: 0x11, },\n"
"    'ε': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'ρ': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'τ': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'υ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'θ': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ι': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ο': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'π': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '+': { 0x0: 0x1a, 0x1: 0x4e, },\n"
"    '}': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'α': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'σ': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'δ': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'φ': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'γ': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'η': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ξ': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'κ': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'λ': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '½': { 0x0: 0x29, 0x2: 0xd, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'χ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'ω': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'β': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'ν': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'μ': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1a, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, 0x2: 0x5, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '[': { 0x1: 0xd, },\n"
"    ':': { 0x1: 0x10, },\n"
"    '~': { 0x1: 0x11, },\n"
"    'Ε': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Ρ': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Τ': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Υ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Θ': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ι': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ο': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'Π': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1b, },\n"
"    'Α': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Δ': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Φ': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Γ': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Η': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ξ': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Κ': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Λ': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '±': { 0x1: 0x29, 0x2: 0xc, },\n"
"    '@': { 0x1: 0x2b, },\n"
"    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Β': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Ν': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Μ': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0x35, },\n"
"    '\\x1d': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '§': { 0x2: 0x6, },\n"
"    '¶': { 0x2: 0x7, },\n"
"    '¤': { 0x2: 0x9, },\n"
"    '¦': { 0x2: 0xa, },\n"
"    '°': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '®': { 0x2: 0x13, },\n"
"    '¥': { 0x2: 0x15, },\n"
"    '«': { 0x2: 0x1a, },\n"
"    '»': { 0x2: 0x1b, },\n"
"    '¬': { 0x2: 0x2b, },\n"
"    '©': { 0x2: 0x2e, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ά': [0, ['α', ]],\n"
"    'έ': [0, ['ε', ]],\n"
"    'ί': [0, ['ι', ]],\n"
"    'ό': [0, ['ο', ]],\n"
"    'ύ': [0, ['υ', ]],\n"
"    'ώ': [0, ['ω', ]],\n"
"    'ή': [0, ['η', ]],\n"
"    'Ά': [0, ['Α', ]],\n"
"    'Έ': [0, ['Ε', ]],\n"
"    'Ί': [0, ['Ι', ]],\n"
"    'Ό': [0, ['Ο', ]],\n"
"    'Ύ': [0, ['Υ', ]],\n"
"    'Ώ': [0, ['Ω', ]],\n"
"    'Ή': [0, ['Η', ]],\n"
"    '΄': [0, [' ', ]],\n"
"    'ϊ': [1, ['ι', ]],\n"
"    'ϋ': [1, ['υ', ]],\n"
"    'Ϊ': [1, ['Ι', ]],\n"
"    'Ϋ': [1, ['Υ', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ΐ': [2, ['ι', ]],\n"
"    'ΰ': [2, ['υ', ]],\n"
"    '΅': [2, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x27, },\n"
"    {0x0: 0x28, 0x1: 0x27, },\n"
"    {0x1: 0x28, 0x2: 0x27, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010409,\n"
"  localeName: \"en-US\",\n"
"  displayName: \"United States-Dvorak\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '[': { 0x0: 0xc, },\n"
"    ']': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    '\\'': { 0x0: 0x10, },\n"
"    ',': { 0x0: 0x11, },\n"
"    '.': { 0x0: 0x12, },\n"
"    'p': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'y': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'f': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'g': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'c': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'r': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'l': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '/': { 0x0: 0x1a, 0x1: 0x35, },\n"
"    '=': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'o': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'e': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'u': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'i': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'd': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'h': { 0x0: 0x24, 0x5: 0x24, },\n"
"    't': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'n': { 0x0: 0x26, 0x5: 0x26, },\n"
"    's': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '-': { 0x0: 0x28, 0x1: 0x4a, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    ';': { 0x0: 0x2c, },\n"
"    'q': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'j': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'k': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'x': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'b': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'w': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'v': { 0x0: 0x34, 0x5: 0x34, },\n"
"    'z': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x1b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '{': { 0x1: 0xc, },\n"
"    '}': { 0x1: 0xd, },\n"
"    '\"': { 0x1: 0x10, },\n"
"    '<': { 0x1: 0x11, },\n"
"    '>': { 0x1: 0x12, },\n"
"    'P': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Y': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'F': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'G': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'C': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'R': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'L': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '?': { 0x1: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'O': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'E': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'U': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'I': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'D': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'H': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'T': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'N': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'S': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '_': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    ':': { 0x1: 0x2c, },\n"
"    'Q': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'J': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'K': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'X': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'B': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'W': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'V': { 0x1: 0x34, 0x4: 0x34, },\n"
"    'Z': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0x28, },\n"
"    '\\x1d': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001040a,\n"
"  localeName: \"es-ES\",\n"
"  displayName: \"Spanish Variation\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '÷': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ñ': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ç': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '\\'': { 0x0: 0x29, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '=': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0xc, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xc, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x4, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    'ª': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '(': { 0x1: 0x5, },\n"
"    ')': { 0x1: 0x6, },\n"
"    '¡': { 0x1: 0x7, },\n"
"    '!': { 0x1: 0x8, },\n"
"    '¿': { 0x1: 0x9, },\n"
"    '?': { 0x1: 0xa, },\n"
"    '₧': { 0x1: 0xb, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '×': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ñ': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ç': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '·': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '%': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '|': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '¼': { 0x2: 0x5, },\n"
"    '½': { 0x2: 0x6, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '_': { 0x2: 0x8, },\n"
"    '§': { 0x2: 0xa, },\n"
"    '\\\\': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '$': { 0x2: 0x1e, },\n"
"    '&': { 0x2: 0x1f, },\n"
"    '£': { 0x2: 0x24, },\n"
"    '±': { 0x2: 0x25, },\n"
"    '~': { 0x2: 0x27, },\n"
"    '{': { 0x2: 0x28, },\n"
"    '}': { 0x2: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ä': [0, ['a', ]],\n"
"    'ë': [0, ['e', ]],\n"
"    'ï': [0, ['i', ]],\n"
"    'ö': [0, ['o', ]],\n"
"    'ü': [0, ['u', ]],\n"
"    'ÿ': [0, ['y', ]],\n"
"    'Ä': [0, ['A', ]],\n"
"    'Ë': [0, ['E', ]],\n"
"    'Ï': [0, ['I', ]],\n"
"    'Ö': [0, ['O', ]],\n"
"    'Ü': [0, ['U', ]],\n"
"    '¨': [0, [' ', ]],\n"
"    'à': [1, ['a', ]],\n"
"    'è': [1, ['e', ]],\n"
"    'ì': [1, ['i', ]],\n"
"    'ò': [1, ['o', ]],\n"
"    'ù': [1, ['u', ]],\n"
"    'À': [1, ['A', ]],\n"
"    'È': [1, ['E', ]],\n"
"    'Ì': [1, ['I', ]],\n"
"    'Ò': [1, ['O', ]],\n"
"    'Ù': [1, ['U', ]],\n"
"    '`': [1, [' ', ]],\n"
"    'á': [2, ['a', ]],\n"
"    'é': [2, ['e', ]],\n"
"    'í': [2, ['i', ]],\n"
"    'ó': [2, ['o', ]],\n"
"    'ú': [2, ['u', ]],\n"
"    'ý': [2, ['y', ]],\n"
"    'Á': [2, ['A', ]],\n"
"    'É': [2, ['E', ]],\n"
"    'Í': [2, ['I', ]],\n"
"    'Ó': [2, ['O', ]],\n"
"    'Ú': [2, ['U', ]],\n"
"    '´': [2, [' ', ]],\n"
"    'ã': [3, ['a', ]],\n"
"    'ñ': [3, ['n', ]],\n"
"    'õ': [3, ['o', ]],\n"
"    'Ã': [3, ['A', ]],\n"
"    'Ñ': [3, ['N', ]],\n"
"    'Õ': [3, ['O', ]],\n"
"    '~': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'ô': [4, ['o', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'Ô': [4, ['O', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    '^': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, 0x1: 0xd, },\n"
"    {0x0: 0x1b, 0x1: 0x1b, },\n"
"    {0x0: 0x2b, 0x1: 0x2b, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x34, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001040e,\n"
"  localeName: \"hu\",\n"
"  displayName: \"Hungarian 101-key\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    'ö': { 0x0: 0xb, 0x5: 0xb, },\n"
"    'ü': { 0x0: 0xc, 0x5: 0xc, },\n"
"    'ó': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ő': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ú': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'é': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'á': { 0x0: 0x28, 0x5: 0x28, },\n"
"    'í': { 0x0: 0x29, 0x5: 0x29, 0x2: 0x24, },\n"
"    'ű': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x7, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '\\'': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '!': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '=': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    'Ö': { 0x1: 0xb, 0x4: 0xb, },\n"
"    'Ü': { 0x1: 0xc, 0x4: 0xc, },\n"
"    'Ó': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ő': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ú': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'É': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Á': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'Í': { 0x1: 0x29, 0x2: 0x17, 0x4: 0x29, },\n"
"    'Ű': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '?': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '~': { 0x2: 0x2, },\n"
"    'ˇ': { 0x2: 0x3, },\n"
"    '^': { 0x2: 0x4, },\n"
"    '˘': { 0x2: 0x5, },\n"
"    '°': { 0x2: 0x6, },\n"
"    '˛': { 0x2: 0x7, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '˙': { 0x2: 0x9, },\n"
"    '´': { 0x2: 0xa, },\n"
"    '˝': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    'Ä': { 0x2: 0x12, },\n"
"    '§': { 0x2: 0x13, },\n"
"    '¤': { 0x2: 0x14, },\n"
"    '€': { 0x2: 0x16, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    'ä': { 0x2: 0x1e, },\n"
"    'đ': { 0x2: 0x1f, },\n"
"    'Đ': { 0x2: 0x20, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    '$': { 0x2: 0x27, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '0': { 0x2: 0x29, },\n"
"    '>': { 0x2: 0x2c, },\n"
"    '#': { 0x2: 0x2d, },\n"
"    '&': { 0x2: 0x2e, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '<': { 0x2: 0x32, },\n"
"    ';': { 0x2: 0x33, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010410,\n"
"  localeName: \"it-IT\",\n"
"  displayName: \"Italian (142)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    'ì': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'è': { 0x0: 0x1a, },\n"
"    '+': { 0x0: 0x1b, 0x1: 0x4e, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ò': { 0x0: 0x27, },\n"
"    'à': { 0x0: 0x28, },\n"
"    '\\\\': { 0x0: 0x29, },\n"
"    'ù': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '^': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'é': { 0x1: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'ç': { 0x1: 0x27, },\n"
"    '°': { 0x1: 0x28, },\n"
"    '|': { 0x1: 0x29, },\n"
"    '§': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\x1f': { 0x0: 0x35, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '@': { 0x2: 0x10, },\n"
"    '~': { 0x2: 0x1b, },\n"
"    '`': { 0x2: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010415,\n"
"  localeName: \"pl\",\n"
"  displayName: \"Polish (214)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\'': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'z': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ż': { 0x0: 0x1a, },\n"
"    'ś': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ł': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ą': { 0x0: 0x28, },\n"
"    'ó': { 0x0: 0x2b, },\n"
"    'y': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x2: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Z': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'ń': { 0x1: 0x1a, },\n"
"    'ć': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ł': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'ę': { 0x1: 0x28, },\n"
"    'ź': { 0x1: 0x2b, },\n"
"    'Y': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x2: 0x34, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '¦': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x16, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    'đ': { 0x2: 0x1f, },\n"
"    'Đ': { 0x2: 0x20, },\n"
"    '$': { 0x2: 0x27, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '§': { 0x2: 0x32, },\n"
"  },\n"
"  deadkeys: {\n"
"    'Ą': [0, ['A', ]],\n"
"    'Ę': [0, ['E', ]],\n"
"    'ą': [0, ['a', ]],\n"
"    'ę': [0, ['e', ]],\n"
"    '˛': [0, [' ', ]],\n"
"    'Ż': [1, ['Z', ]],\n"
"    'ż': [1, ['z', ]],\n"
"    '·': [1, [' ', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'Ă': [4, ['A', ]],\n"
"    'ă': [4, ['a', ]],\n"
"    '˘': [4, [' ', ]],\n"
"    'Ů': [5, ['U', ]],\n"
"    'ů': [5, ['u', ]],\n"
"    '°': [5, [' ', ]],\n"
"    'Ŕ': [6, ['R', ]],\n"
"    'Á': [6, ['A', ]],\n"
"    'Ĺ': [6, ['L', ]],\n"
"    'Ć': [6, ['C', ]],\n"
"    'É': [6, ['E', ]],\n"
"    'Í': [6, ['I', ]],\n"
"    'Ń': [6, ['N', ]],\n"
"    'Ó': [6, ['O', ]],\n"
"    'Ú': [6, ['U', ]],\n"
"    'Ý': [6, ['Y', ]],\n"
"    'Ś': [6, ['S', ]],\n"
"    'Ź': [6, ['Z', ]],\n"
"    'ŕ': [6, ['r', ]],\n"
"    'á': [6, ['a', ]],\n"
"    'ĺ': [6, ['l', ]],\n"
"    'ć': [6, ['c', ]],\n"
"    'é': [6, ['e', ]],\n"
"    'í': [6, ['i', ]],\n"
"    'ń': [6, ['n', ]],\n"
"    'ó': [6, ['o', ]],\n"
"    'ú': [6, ['u', ]],\n"
"    'ý': [6, ['y', ]],\n"
"    'ś': [6, ['s', ]],\n"
"    'ź': [6, ['z', ]],\n"
"    '´': [6, [' ', ]],\n"
"    'Ő': [7, ['O', ]],\n"
"    'Ű': [7, ['U', ]],\n"
"    'ő': [7, ['o', ]],\n"
"    'ű': [7, ['u', ]],\n"
"    '˝': [7, [' ', ]],\n"
"    'Ä': [8, ['A', ]],\n"
"    'Ë': [8, ['E', ]],\n"
"    'Ö': [8, ['O', ]],\n"
"    'Ü': [8, ['U', ]],\n"
"    'ä': [8, ['a', ]],\n"
"    'ë': [8, ['e', ]],\n"
"    'ö': [8, ['o', ]],\n"
"    'ü': [8, ['u', ]],\n"
"    '¨': [8, [' ', ]],\n"
"    'Ş': [9, ['S', ]],\n"
"    'Ç': [9, ['C', ]],\n"
"    'Ţ': [9, ['T', ]],\n"
"    'ş': [9, ['s', ]],\n"
"    'ç': [9, ['c', ]],\n"
"    'ţ': [9, ['t', ]],\n"
"    '¸': [9, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, 0x2: 0x7, },\n"
"    {0x1: 0x29, 0x2: 0x9, },\n"
"    {0x2: 0x3, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x6, },\n"
"    {0x2: 0xa, },\n"
"    {0x2: 0xb, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010416,\n"
"  localeName: \"pt-BR\",\n"
"  displayName: \"Portuguese (Brazil ABNT2)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ç': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '\\'': { 0x0: 0x29, },\n"
"    ']': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, 0x1: 0x7e, },\n"
"    ';': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x73, 0x1: 0x35, 0x2: 0x10, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ç': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '\"': { 0x1: 0x29, },\n"
"    '}': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    ':': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, },\n"
"    '?': { 0x1: 0x73, 0x2: 0x11, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '¹': { 0x2: 0x2, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '£': { 0x2: 0x5, },\n"
"    '¢': { 0x2: 0x6, },\n"
"    '¬': { 0x2: 0x7, },\n"
"    '§': { 0x2: 0xd, },\n"
"    '°': { 0x2: 0x12, },\n"
"    'ª': { 0x2: 0x1b, },\n"
"    'º': { 0x2: 0x2b, },\n"
"    '₢': { 0x2: 0x2e, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ã': [1, ['a', ]],\n"
"    'õ': [1, ['o', ]],\n"
"    'ñ': [1, ['n', ]],\n"
"    'Ã': [1, ['A', ]],\n"
"    'Õ': [1, ['O', ]],\n"
"    'Ñ': [1, ['N', ]],\n"
"    '~': [1, [' ', ]],\n"
"    'ä': [2, ['a', ]],\n"
"    'ë': [2, ['e', ]],\n"
"    'ï': [2, ['i', ]],\n"
"    'ö': [2, ['o', ]],\n"
"    'ü': [2, ['u', ]],\n"
"    'ÿ': [2, ['y', ]],\n"
"    'Ä': [2, ['A', ]],\n"
"    'Ë': [2, ['E', ]],\n"
"    'Ï': [2, ['I', ]],\n"
"    'Ö': [2, ['O', ]],\n"
"    'Ü': [2, ['U', ]],\n"
"    '¨': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"    'â': [4, ['a', ]],\n"
"    'ê': [4, ['e', ]],\n"
"    'î': [4, ['i', ]],\n"
"    'ô': [4, ['o', ]],\n"
"    'û': [4, ['u', ]],\n"
"    'Â': [4, ['A', ]],\n"
"    'Ê': [4, ['E', ]],\n"
"    'Î': [4, ['I', ]],\n"
"    'Ô': [4, ['O', ]],\n"
"    'Û': [4, ['U', ]],\n"
"    '^': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, },\n"
"    {0x0: 0x28, },\n"
"    {0x1: 0x7, },\n"
"    {0x1: 0x1a, },\n"
"    {0x1: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010419,\n"
"  localeName: \"ru\",\n"
"  displayName: \"Russian (Typewriter)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '№': { 0x0: 0x2, },\n"
"    '-': { 0x0: 0x3, 0x1: 0x4a, },\n"
"    '/': { 0x0: 0x4, 0x1: 0x35, },\n"
"    '\"': { 0x0: 0x5, },\n"
"    ':': { 0x0: 0x6, },\n"
"    ',': { 0x0: 0x7, },\n"
"    '.': { 0x0: 0x8, },\n"
"    '_': { 0x0: 0x9, },\n"
"    '?': { 0x0: 0xa, },\n"
"    '%': { 0x0: 0xb, },\n"
"    '!': { 0x0: 0xc, },\n"
"    ';': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'й': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ц': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'у': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'к': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'е': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'н': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'г': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ш': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'щ': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'х': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ъ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ф': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'ы': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'в': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'а': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'п': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'р': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'о': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'л': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'д': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ж': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'э': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '|': { 0x0: 0x29, },\n"
"    ')': { 0x0: 0x2b, },\n"
"    'я': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ч': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'с': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'м': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'и': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'т': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'ь': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'б': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'ю': { 0x0: 0x34, 0x5: 0x34, },\n"
"    'ё': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x29, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, },\n"
"    '3': { 0x1: 0x4, },\n"
"    '4': { 0x1: 0x5, },\n"
"    '5': { 0x1: 0x6, },\n"
"    '6': { 0x1: 0x7, },\n"
"    '7': { 0x1: 0x8, },\n"
"    '8': { 0x1: 0x9, },\n"
"    '9': { 0x1: 0xa, },\n"
"    '0': { 0x1: 0xb, },\n"
"    '=': { 0x1: 0xc, },\n"
"    '\\\\': { 0x1: 0xd, },\n"
"    'Й': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Ц': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'У': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'К': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Е': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Н': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Г': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ш': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Щ': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Х': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ъ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'Ф': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Ы': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'В': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'А': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'П': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Р': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'О': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Л': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Д': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ж': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Э': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '(': { 0x1: 0x2b, },\n"
"    'Я': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ч': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'С': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'М': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'И': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Т': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Ь': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Б': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Ю': { 0x1: 0x34, 0x4: 0x34, },\n"
"    'Ё': { 0x1: 0x35, 0x4: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '₽': { 0x2: 0x9, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001041b,\n"
"  localeName: \"sk\",\n"
"  displayName: \"Slovak (QWERTY)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '+': { 0x0: 0x2, 0x1: 0x4e, },\n"
"    'ľ': { 0x0: 0x3, },\n"
"    'š': { 0x0: 0x4, },\n"
"    'č': { 0x0: 0x5, },\n"
"    'ť': { 0x0: 0x6, },\n"
"    'ž': { 0x0: 0x7, },\n"
"    'ý': { 0x0: 0x8, },\n"
"    'á': { 0x0: 0x9, },\n"
"    'í': { 0x0: 0xa, },\n"
"    'é': { 0x0: 0xb, },\n"
"    '=': { 0x0: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ú': { 0x0: 0x1a, },\n"
"    'ä': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ô': { 0x0: 0x27, },\n"
"    '§': { 0x0: 0x28, },\n"
"    ';': { 0x0: 0x29, },\n"
"    'ň': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x2: 0x35, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '&': { 0x0: 0x56, 0x2: 0x2e, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x1a, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, },\n"
"    '2': { 0x1: 0x3, },\n"
"    '3': { 0x1: 0x4, },\n"
"    '4': { 0x1: 0x5, },\n"
"    '5': { 0x1: 0x6, },\n"
"    '6': { 0x1: 0x7, },\n"
"    '7': { 0x1: 0x8, },\n"
"    '8': { 0x1: 0x9, },\n"
"    '9': { 0x1: 0xa, },\n"
"    '0': { 0x1: 0xb, },\n"
"    '%': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '(': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '\"': { 0x1: 0x27, },\n"
"    '!': { 0x1: 0x28, },\n"
"    ')': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '?': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '~': { 0x2: 0x2, },\n"
"    '`': { 0x2: 0x8, },\n"
"    '\\\\': { 0x2: 0x10, },\n"
"    '|': { 0x2: 0x11, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '\\'': { 0x2: 0x19, },\n"
"    '÷': { 0x2: 0x1a, },\n"
"    '×': { 0x2: 0x1b, },\n"
"    'đ': { 0x2: 0x1f, },\n"
"    'Đ': { 0x2: 0x20, },\n"
"    '[': { 0x2: 0x21, },\n"
"    ']': { 0x2: 0x22, },\n"
"    'ł': { 0x2: 0x25, },\n"
"    'Ł': { 0x2: 0x26, },\n"
"    '$': { 0x2: 0x27, },\n"
"    'ß': { 0x2: 0x28, },\n"
"    '¤': { 0x2: 0x2b, },\n"
"    '>': { 0x2: 0x2c, },\n"
"    '#': { 0x2: 0x2d, },\n"
"    '@': { 0x2: 0x2f, },\n"
"    '{': { 0x2: 0x30, },\n"
"    '}': { 0x2: 0x31, },\n"
"    '<': { 0x2: 0x33, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'č': [1, ['c', ]],\n"
"    'Č': [1, ['C', ]],\n"
"    'ď': [1, ['d', ]],\n"
"    'Ď': [1, ['D', ]],\n"
"    'ě': [1, ['e', ]],\n"
"    'Ě': [1, ['E', ]],\n"
"    'ř': [1, ['r', ]],\n"
"    'Ř': [1, ['R', ]],\n"
"    'ľ': [1, ['l', ]],\n"
"    'Ľ': [1, ['L', ]],\n"
"    'ň': [1, ['n', ]],\n"
"    'Ň': [1, ['N', ]],\n"
"    'š': [1, ['s', ]],\n"
"    'Š': [1, ['S', ]],\n"
"    'ť': [1, ['t', ]],\n"
"    'Ť': [1, ['T', ]],\n"
"    'ž': [1, ['z', ]],\n"
"    'Ž': [1, ['Z', ]],\n"
"    'ˇ': [1, [' ', ]],\n"
"    'ů': [2, ['u', ]],\n"
"    'Ů': [2, ['U', ]],\n"
"    '°': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ă': [4, ['a', ]],\n"
"    'Ă': [4, ['A', ]],\n"
"    '˘': [4, [' ', ]],\n"
"    'ą': [5, ['a', ]],\n"
"    'Ą': [5, ['A', ]],\n"
"    'ę': [5, ['e', ]],\n"
"    'Ę': [5, ['E', ]],\n"
"    '˛': [5, [' ', ]],\n"
"    'ż': [6, ['z', ]],\n"
"    'Ż': [6, ['Z', ]],\n"
"    '˙': [6, [' ', ]],\n"
"    'ő': [7, ['o', ]],\n"
"    'Ő': [7, ['O', ]],\n"
"    'ű': [7, ['u', ]],\n"
"    'Ű': [7, ['U', ]],\n"
"    '˝': [7, [' ', ]],\n"
"    'ä': [8, ['a', ]],\n"
"    'Ä': [8, ['A', ]],\n"
"    'ë': [8, ['e', ]],\n"
"    'Ë': [8, ['E', ]],\n"
"    'ö': [8, ['o', ]],\n"
"    'Ö': [8, ['O', ]],\n"
"    'ü': [8, ['u', ]],\n"
"    'Ü': [8, ['U', ]],\n"
"    '¨': [8, [' ', ]],\n"
"    'ç': [9, ['c', ]],\n"
"    'Ç': [9, ['C', ]],\n"
"    'ş': [9, ['s', ]],\n"
"    'Ş': [9, ['S', ]],\n"
"    'ţ': [9, ['t', ]],\n"
"    'Ţ': [9, ['T', ]],\n"
"    '¸': [9, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, 0x2: 0xa, },\n"
"    {0x1: 0xd, 0x2: 0x3, },\n"
"    {0x1: 0x29, 0x2: 0x6, },\n"
"    {0x2: 0x4, },\n"
"    {0x2: 0x5, },\n"
"    {0x2: 0x7, },\n"
"    {0x2: 0x9, },\n"
"    {0x2: 0xb, },\n"
"    {0x2: 0xc, },\n"
"    {0x2: 0xd, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001041f,\n"
"  localeName: \"tr\",\n"
"  displayName: \"Turkish F\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '/': { 0x0: 0xc, 0x1: 0x35, },\n"
"    '-': { 0x0: 0xd, 0x1: 0x4a, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'f': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'g': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'ğ': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'ı': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'o': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'd': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'r': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'n': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'h': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'q': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'w': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'u': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'i': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'e': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'a': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'ü': { 0x0: 0x22, 0x5: 0x22, },\n"
"    't': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'k': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'm': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'y': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ş': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '+': { 0x0: 0x29, 0x1: 0x4e, },\n"
"    'x': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'j': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'ö': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'v': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'c': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'ç': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'z': { 0x0: 0x31, 0x5: 0x31, },\n"
"    's': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'b': { 0x0: 0x33, 0x5: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    ',': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x29, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, 0x3: 0x2c, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '\\'': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '_': { 0x1: 0xd, },\n"
"    'F': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'G': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'Ğ': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'I': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'O': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'D': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'R': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'N': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'H': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Q': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'W': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'U': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'İ': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'E': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'A': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Ü': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'T': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'K': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'M': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Y': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ş': { 0x1: 0x28, 0x4: 0x28, },\n"
"    'X': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'J': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Ö': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'V': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'C': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Ç': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Z': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'S': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'B': { 0x1: 0x33, 0x4: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    ';': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, 0x3: 0x2d, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xd, },\n"
"    '¡': { 0x3: 0x2, },\n"
"    '³': { 0x3: 0x4, },\n"
"    '¤': { 0x3: 0x5, },\n"
"    '¿': { 0x3: 0xc, },\n"
"    '®': { 0x3: 0x13, },\n"
"    'Ø': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Æ': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '§': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    'ª': { 0x3: 0x21, },\n"
"    '©': { 0x3: 0x2e, },\n"
"    'º': { 0x3: 0x32, },\n"
"    '¦': { 0x3: 0x56, },\n"
"    'ø': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'æ': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ß': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    '\\x1c': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x22, },\n"
"    '¹': { 0x2: 0x2, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '¼': { 0x2: 0x5, },\n"
"    '½': { 0x2: 0x6, },\n"
"    '¾': { 0x2: 0x7, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '|': { 0x2: 0xd, },\n"
"    '@': { 0x2: 0x10, },\n"
"    '¶': { 0x2: 0x13, },\n"
"    '¥': { 0x2: 0x15, },\n"
"    '£': { 0x2: 0x19, },\n"
"    '€': { 0x2: 0x20, },\n"
"    '₺': { 0x2: 0x23, },\n"
"    '¬': { 0x2: 0x29, },\n"
"    '«': { 0x2: 0x2c, },\n"
"    '»': { 0x2: 0x2d, },\n"
"    '¢': { 0x2: 0x2e, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '×': { 0x2: 0x33, },\n"
"    '÷': { 0x2: 0x34, },\n"
"    '\\xad': { 0x2: 0x35, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', 'ı', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', 'İ', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', 'ı', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', 'İ', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ã': [2, ['a', ]],\n"
"    'õ': [2, ['o', ]],\n"
"    'ñ': [2, ['n', ]],\n"
"    'Ã': [2, ['A', ]],\n"
"    'Õ': [2, ['O', ]],\n"
"    'Ñ': [2, ['N', ]],\n"
"    '~': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'í': [3, ['i', 'ı', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Í': [3, ['I', 'İ', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'à': [4, ['a', ]],\n"
"    'è': [4, ['e', ]],\n"
"    'ì': [4, ['i', 'ı', ]],\n"
"    'ò': [4, ['o', ]],\n"
"    'ù': [4, ['u', ]],\n"
"    'À': [4, ['A', ]],\n"
"    'È': [4, ['E', ]],\n"
"    'Ì': [4, ['I', 'İ', ]],\n"
"    'Ò': [4, ['O', ]],\n"
"    'Ù': [4, ['U', ]],\n"
"    '`': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x1: 0x4, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"    {0x2: 0x27, },\n"
"    {0x2: 0x2b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010426,\n"
"  localeName: \"lv\",\n"
"  displayName: \"Latvian (QWERTY)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '§': { 0x3: 0x5, },\n"
"    '°': { 0x3: 0x6, },\n"
"    '±': { 0x3: 0x8, },\n"
"    '×': { 0x3: 0x9, },\n"
"    '—': { 0x3: 0xc, },\n"
"    'Ē': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ŗ': { 0x3: 0x13, 0x6: 0x13, },\n"
"    'Ū': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Ī': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Õ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Ā': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Š': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    'Ģ': { 0x3: 0x22, 0x6: 0x22, },\n"
"    'Ķ': { 0x3: 0x25, 0x6: 0x25, },\n"
"    'Ļ': { 0x3: 0x26, 0x6: 0x26, },\n"
"    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'Č': { 0x3: 0x2e, 0x6: 0x2e, },\n"
"    'Ņ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'ē': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ŗ': { 0x7: 0x13, 0x2: 0x13, },\n"
"    'ū': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'ī': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'õ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'ā': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'š': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    'ģ': { 0x7: 0x22, 0x2: 0x22, },\n"
"    'ķ': { 0x7: 0x25, 0x2: 0x25, },\n"
"    'ļ': { 0x7: 0x26, 0x2: 0x26, },\n"
"    'ž': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'č': { 0x7: 0x2e, 0x2: 0x2e, },\n"
"    'ņ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '\\xa0': { 0x2: 0x2, },\n"
"    '«': { 0x2: 0x3, },\n"
"    '»': { 0x2: 0x4, },\n"
"    '€': { 0x2: 0x5, },\n"
"    '’': { 0x2: 0x7, },\n"
"    '–': { 0x2: 0xc, },\n"
"    '\\xad': { 0x2: 0x29, },\n"
"  },\n"
"  deadkeys: {\n"
"    'å': [0, ['a', ]],\n"
"    'Å': [0, ['A', ]],\n"
"    'ė': [0, ['e', ]],\n"
"    'Ė': [0, ['E', ]],\n"
"    'ż': [0, ['z', ]],\n"
"    'Ż': [0, ['Z', ]],\n"
"    'ġ': [0, ['g', ]],\n"
"    '°': [0, [' ', ]],\n"
"    'õ': [1, ['o', ]],\n"
"    'Õ': [1, ['O', ]],\n"
"    '~': [1, [' ', ]],\n"
"    'ä': [2, ['a', ]],\n"
"    'ü': [2, ['u', ]],\n"
"    'ö': [2, ['o', ]],\n"
"    'Ä': [2, ['A', ]],\n"
"    'Ü': [2, ['U', ]],\n"
"    'Ö': [2, ['O', ]],\n"
"    '¨': [2, [' ', ]],\n"
"    'ń': [3, ['n', ]],\n"
"    'ć': [3, ['c', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'ś': [3, ['s', ]],\n"
"    'ź': [3, ['z', ]],\n"
"    'Ń': [3, ['N', ]],\n"
"    'Ć': [3, ['C', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'Ś': [3, ['S', ]],\n"
"    'Ź': [3, ['Z', ]],\n"
"    '´': [3, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x2b, },\n"
"    {0x1: 0x29, },\n"
"    {0x3: 0x28, },\n"
"    {0x2: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00010427,\n"
"  localeName: \"lt\",\n"
"  displayName: \"Lithuanian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    'ą': { 0x0: 0x2, 0x5: 0x2, },\n"
"    'č': { 0x0: 0x3, 0x5: 0x3, },\n"
"    'ę': { 0x0: 0x4, 0x5: 0x4, },\n"
"    'ė': { 0x0: 0x5, 0x5: 0x5, },\n"
"    'į': { 0x0: 0x6, 0x5: 0x6, },\n"
"    'š': { 0x0: 0x7, 0x5: 0x7, },\n"
"    'ų': { 0x0: 0x8, 0x5: 0x8, },\n"
"    'ū': { 0x0: 0x9, 0x5: 0x9, },\n"
"    '9': { 0x0: 0xa, 0x2: 0xa, },\n"
"    '0': { 0x0: 0xb, 0x2: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    'ž': { 0x0: 0xd, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x3: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4e, 0x3: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    'Ą': { 0x1: 0x2, 0x4: 0x2, },\n"
"    'Č': { 0x1: 0x3, 0x4: 0x3, },\n"
"    'Ę': { 0x1: 0x4, 0x4: 0x4, },\n"
"    'Ė': { 0x1: 0x5, 0x4: 0x5, },\n"
"    'Į': { 0x1: 0x6, 0x4: 0x6, },\n"
"    'Š': { 0x1: 0x7, 0x4: 0x7, },\n"
"    'Ų': { 0x1: 0x8, 0x4: 0x8, },\n"
"    'Ū': { 0x1: 0x9, 0x4: 0x9, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Ž': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '!': { 0x3: 0x2, },\n"
"    '@': { 0x3: 0x3, },\n"
"    '#': { 0x3: 0x4, },\n"
"    '$': { 0x3: 0x5, },\n"
"    '%': { 0x3: 0x6, },\n"
"    '^': { 0x3: 0x7, },\n"
"    '&': { 0x3: 0x8, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '1': { 0x2: 0x2, },\n"
"    '2': { 0x2: 0x3, },\n"
"    '3': { 0x2: 0x4, },\n"
"    '4': { 0x2: 0x5, },\n"
"    '5': { 0x2: 0x6, },\n"
"    '6': { 0x2: 0x7, },\n"
"    '7': { 0x2: 0x8, },\n"
"    '8': { 0x2: 0x9, },\n"
"    '=': { 0x2: 0xd, },\n"
"    '€': { 0x2: 0x12, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001043a,\n"
"  localeName: \"mt\",\n"
"  displayName: \"Maltese 48-Key\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ġ': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ħ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    'ċ': { 0x0: 0x29, 0x5: 0x29, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    'ż': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '€': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ġ': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ħ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '@': { 0x1: 0x28, },\n"
"    'Ċ': { 0x1: 0x29, 0x4: 0x29, },\n"
"    '~': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    'Ż': { 0x1: 0x56, 0x4: 0x56, },\n"
"    'È': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ù': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Ì': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ò': { 0x3: 0x18, 0x6: 0x18, },\n"
"    '{': { 0x3: 0x1a, },\n"
"    '}': { 0x3: 0x1b, },\n"
"    'À': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '¬': { 0x3: 0x29, },\n"
"    '|': { 0x3: 0x56, },\n"
"    '£': { 0x7: 0x4, 0x2: 0x4, },\n"
"    'è': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ù': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'ì': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ò': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'à': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '[': { 0x2: 0x1a, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '`': { 0x2: 0x29, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001043b,\n"
"  localeName: \"se-Latn-NO\",\n"
"  displayName: \"Sami Extended Norway\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\\\': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'á': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'š': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'ŧ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ŋ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ø': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'æ': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '|': { 0x0: 0x29, },\n"
"    'đ': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'č': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x3: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    'ž': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Á': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Š': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Ŧ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ŋ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ø': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Æ': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '§': { 0x1: 0x29, },\n"
"    'Đ': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Č': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    'Ž': { 0x1: 0x56, 0x4: 0x56, },\n"
"    'Q': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'W': { 0x3: 0x11, 0x6: 0x11, },\n"
"    'Y': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ï': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Õ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Â': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },\n"
"    'Ǥ': { 0x3: 0x23, 0x6: 0x23, },\n"
"    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },\n"
"    'Ö': { 0x3: 0x27, 0x6: 0x27, },\n"
"    'Ä': { 0x3: 0x28, 0x6: 0x28, },\n"
"    'Ʒ': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'X': { 0x3: 0x2d, 0x6: 0x2d, },\n"
"    'Ǯ': { 0x3: 0x56, 0x6: 0x56, },\n"
"    'q': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'w': { 0x7: 0x11, 0x2: 0x11, },\n"
"    'y': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ï': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'õ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'â': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ǧ': { 0x7: 0x22, 0x2: 0x22, },\n"
"    'ǥ': { 0x7: 0x23, 0x2: 0x23, },\n"
"    'ǩ': { 0x7: 0x25, 0x2: 0x25, },\n"
"    'ö': { 0x7: 0x27, 0x2: 0x27, },\n"
"    'ä': { 0x7: 0x28, 0x2: 0x28, },\n"
"    'ʒ': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'x': { 0x7: 0x2d, 0x2: 0x2d, },\n"
"    'ǯ': { 0x7: 0x56, 0x2: 0x56, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\'': { 0x2: 0x2b, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"  },\n"
"  deadkeys: {\n"
"    'à': [0, ['a', ]],\n"
"    'À': [0, ['A', ]],\n"
"    'è': [0, ['e', ]],\n"
"    'È': [0, ['E', ]],\n"
"    'ì': [0, ['i', ]],\n"
"    'Ì': [0, ['I', ]],\n"
"    'ò': [0, ['o', ]],\n"
"    'Ò': [0, ['O', ]],\n"
"    'ù': [0, ['u', ]],\n"
"    'Ù': [0, ['U', ]],\n"
"    'ẁ': [0, ['w', ]],\n"
"    'Ẁ': [0, ['W', ]],\n"
"    'ỳ': [0, ['y', ]],\n"
"    'Ỳ': [0, ['Y', ]],\n"
"    '`': [0, [' ', ]],\n"
"    'â': [1, ['a', ]],\n"
"    'Â': [1, ['A', ]],\n"
"    'ĉ': [1, ['c', ]],\n"
"    'Ĉ': [1, ['C', ]],\n"
"    'ê': [1, ['e', ]],\n"
"    'Ê': [1, ['E', ]],\n"
"    'ĝ': [1, ['g', ]],\n"
"    'Ĝ': [1, ['G', ]],\n"
"    'ĥ': [1, ['h', ]],\n"
"    'Ĥ': [1, ['H', ]],\n"
"    'î': [1, ['i', ]],\n"
"    'Î': [1, ['I', ]],\n"
"    'ĵ': [1, ['j', ]],\n"
"    'Ĵ': [1, ['J', ]],\n"
"    'ô': [1, ['o', ]],\n"
"    'Ô': [1, ['O', ]],\n"
"    'ŝ': [1, ['s', ]],\n"
"    'Ŝ': [1, ['S', ]],\n"
"    'û': [1, ['u', ]],\n"
"    'Û': [1, ['U', ]],\n"
"    'ŵ': [1, ['w', ]],\n"
"    'Ŵ': [1, ['W', ]],\n"
"    'ŷ': [1, ['y', ]],\n"
"    'Ŷ': [1, ['Y', ]],\n"
"    '^': [1, [' ', ]],\n"
"    'č': [2, ['c', ]],\n"
"    'Č': [2, ['C', ]],\n"
"    'ď': [2, ['d', ]],\n"
"    'Ď': [2, ['D', ]],\n"
"    'ě': [2, ['e', ]],\n"
"    'Ě': [2, ['E', ]],\n"
"    'ǧ': [2, ['g', ]],\n"
"    'Ǧ': [2, ['G', ]],\n"
"    'ȟ': [2, ['h', ]],\n"
"    'Ȟ': [2, ['H', ]],\n"
"    'ǩ': [2, ['k', ]],\n"
"    'Ǩ': [2, ['K', ]],\n"
"    'ľ': [2, ['l', ]],\n"
"    'Ľ': [2, ['L', ]],\n"
"    'ň': [2, ['n', ]],\n"
"    'Ň': [2, ['N', ]],\n"
"    'ř': [2, ['r', ]],\n"
"    'Ř': [2, ['R', ]],\n"
"    'š': [2, ['s', ]],\n"
"    'Š': [2, ['S', ]],\n"
"    'ť': [2, ['t', ]],\n"
"    'Ť': [2, ['T', ]],\n"
"    'ž': [2, ['z', ]],\n"
"    'Ž': [2, ['Z', ]],\n"
"    'ǯ': [2, ['ʒ', ]],\n"
"    'Ǯ': [2, ['Ʒ', ]],\n"
"    'ˇ': [2, [' ', ]],\n"
"    'á': [3, ['a', ]],\n"
"    'Á': [3, ['A', ]],\n"
"    'ć': [3, ['c', ]],\n"
"    'Ć': [3, ['C', ]],\n"
"    'é': [3, ['e', ]],\n"
"    'É': [3, ['E', ]],\n"
"    'í': [3, ['i', ]],\n"
"    'Í': [3, ['I', ]],\n"
"    'ĺ': [3, ['l', ]],\n"
"    'Ĺ': [3, ['L', ]],\n"
"    'ń': [3, ['n', ]],\n"
"    'Ń': [3, ['N', ]],\n"
"    'ó': [3, ['o', ]],\n"
"    'Ó': [3, ['O', ]],\n"
"    'ŕ': [3, ['r', ]],\n"
"    'Ŕ': [3, ['R', ]],\n"
"    'ś': [3, ['s', ]],\n"
"    'Ś': [3, ['S', ]],\n"
"    'ú': [3, ['u', ]],\n"
"    'Ú': [3, ['U', ]],\n"
"    'ẃ': [3, ['w', ]],\n"
"    'Ẃ': [3, ['W', ]],\n"
"    'ý': [3, ['y', ]],\n"
"    'Ý': [3, ['Y', ]],\n"
"    'ź': [3, ['z', ]],\n"
"    'Ź': [3, ['Z', ]],\n"
"    'ǻ': [3, ['å', ]],\n"
"    'Ǻ': [3, ['Å', ]],\n"
"    'ǽ': [3, ['æ', ]],\n"
"    'Ǽ': [3, ['Æ', ]],\n"
"    'ǿ': [3, ['ø', ]],\n"
"    'Ǿ': [3, ['Ø', ]],\n"
"    '´': [3, [' ', ]],\n"
"    'ä': [4, ['a', ]],\n"
"    'Ä': [4, ['A', ]],\n"
"    'ë': [4, ['e', ]],\n"
"    'Ë': [4, ['E', ]],\n"
"    'ï': [4, ['i', ]],\n"
"    'Ï': [4, ['I', ]],\n"
"    'ö': [4, ['o', ]],\n"
"    'Ö': [4, ['O', ]],\n"
"    'ü': [4, ['u', ]],\n"
"    'Ü': [4, ['U', ]],\n"
"    'ẅ': [4, ['w', ]],\n"
"    'Ẅ': [4, ['W', ]],\n"
"    'ÿ': [4, ['y', ]],\n"
"    'Ÿ': [4, ['Y', ]],\n"
"    '¨': [4, [' ', ]],\n"
"    'ã': [5, ['a', ]],\n"
"    'Ã': [5, ['A', ]],\n"
"    'ĩ': [5, ['i', ]],\n"
"    'Ĩ': [5, ['I', ]],\n"
"    'ñ': [5, ['n', ]],\n"
"    'Ñ': [5, ['N', ]],\n"
"    'õ': [5, ['o', ]],\n"
"    'Õ': [5, ['O', ]],\n"
"    'ũ': [5, ['u', ]],\n"
"    'Ũ': [5, ['U', ]],\n"
"    '~': [5, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x1: 0xd, },\n"
"    {0x3: 0x1a, },\n"
"    {0x3: 0x1b, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001080c,\n"
"  localeName: \"fr-BE\",\n"
"  displayName: \"Belgian (Comma)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '&': { 0x0: 0x2, 0x5: 0x2, },\n"
"    'é': { 0x0: 0x3, 0x5: 0x3, },\n"
"    '\"': { 0x0: 0x4, 0x5: 0x4, },\n"
"    '\\'': { 0x0: 0x5, 0x5: 0x5, },\n"
"    '(': { 0x0: 0x6, 0x5: 0x6, },\n"
"    '§': { 0x0: 0x7, 0x5: 0x7, },\n"
"    'è': { 0x0: 0x8, 0x5: 0x8, },\n"
"    '!': { 0x0: 0x9, 0x5: 0x9, },\n"
"    'ç': { 0x0: 0xa, 0x5: 0xa, },\n"
"    'à': { 0x0: 0xb, 0x5: 0xb, },\n"
"    ')': { 0x0: 0xc, 0x5: 0xc, },\n"
"    '-': { 0x0: 0xd, 0x1: 0x4a, 0x5: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'a': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'z': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '$': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'q': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'm': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ù': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '²': { 0x0: 0x29, },\n"
"    'µ': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'w': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    ',': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ';': { 0x0: 0x33, 0x5: 0x33, },\n"
"    ':': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '=': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1b, 0x4: 0x1b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x35, 0x4: 0x35, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x34, 0x4: 0x34, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '1': { 0x1: 0x2, 0x4: 0x2, },\n"
"    '2': { 0x1: 0x3, 0x4: 0x3, },\n"
"    '3': { 0x1: 0x4, 0x4: 0x4, },\n"
"    '4': { 0x1: 0x5, 0x4: 0x5, },\n"
"    '5': { 0x1: 0x6, 0x4: 0x6, },\n"
"    '6': { 0x1: 0x7, 0x4: 0x7, },\n"
"    '7': { 0x1: 0x8, 0x4: 0x8, },\n"
"    '8': { 0x1: 0x9, 0x4: 0x9, },\n"
"    '9': { 0x1: 0xa, 0x4: 0xa, },\n"
"    '0': { 0x1: 0xb, 0x4: 0xb, },\n"
"    '°': { 0x1: 0xc, 0x4: 0xc, },\n"
"    '_': { 0x1: 0xd, 0x4: 0xd, },\n"
"    'A': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Z': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Q': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'M': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '%': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '³': { 0x1: 0x29, },\n"
"    '£': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'W': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    '?': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '.': { 0x1: 0x33, 0x4: 0x33, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '|': { 0x2: 0x2, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '#': { 0x2: 0x4, },\n"
"    '{': { 0x2: 0x5, },\n"
"    '[': { 0x2: 0x6, },\n"
"    '^': { 0x2: 0x7, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"    ']': { 0x2: 0x1b, },\n"
"    '\\\\': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'á': [2, ['a', ]],\n"
"    'é': [2, ['e', ]],\n"
"    'í': [2, ['i', ]],\n"
"    'ó': [2, ['o', ]],\n"
"    'ú': [2, ['u', ]],\n"
"    'ý': [2, ['y', ]],\n"
"    'Á': [2, ['A', ]],\n"
"    'É': [2, ['E', ]],\n"
"    'Í': [2, ['I', ]],\n"
"    'Ó': [2, ['O', ]],\n"
"    'Ú': [2, ['U', ]],\n"
"    'Ý': [2, ['Y', ]],\n"
"    '´': [2, [' ', ]],\n"
"    'à': [3, ['a', ]],\n"
"    'è': [3, ['e', ]],\n"
"    'ì': [3, ['i', ]],\n"
"    'ò': [3, ['o', ]],\n"
"    'ù': [3, ['u', ]],\n"
"    'À': [3, ['A', ]],\n"
"    'È': [3, ['E', ]],\n"
"    'Ì': [3, ['I', ]],\n"
"    'Ò': [3, ['O', ]],\n"
"    'Ù': [3, ['U', ]],\n"
"    '`': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, 0x5: 0x1a, },\n"
"    {0x1: 0x1a, 0x4: 0x1a, },\n"
"    {0x3: 0x28, 0x2: 0x28, },\n"
"    {0x3: 0x2b, 0x2: 0x2b, },\n"
"    {0x3: 0x35, 0x2: 0x35, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0001083b,\n"
"  localeName: \"se-Latn-SE\",\n"
"  displayName: \"Finnish with Sami\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '§': { 0x0: 0x29, },\n"
"    '\\'': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '½': { 0x1: 0x29, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    'Â': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'Ŧ': { 0x3: 0x14, 0x6: 0x14, },\n"
"    'Ï': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Õ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Š': { 0x3: 0x1f, 0x6: 0x1f, },\n"
"    'Đ': { 0x3: 0x20, 0x6: 0x20, },\n"
"    'Ǥ': { 0x3: 0x21, 0x6: 0x21, },\n"
"    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },\n"
"    'Ȟ': { 0x3: 0x23, 0x6: 0x23, },\n"
"    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },\n"
"    'Ø': { 0x3: 0x27, 0x6: 0x27, },\n"
"    'Æ': { 0x3: 0x28, 0x6: 0x28, },\n"
"    'Ž': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'Č': { 0x3: 0x2e, 0x6: 0x2e, },\n"
"    'Ǯ': { 0x3: 0x2f, 0x6: 0x2f, },\n"
"    'Ʒ': { 0x3: 0x30, 0x6: 0x30, },\n"
"    'Ŋ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'â': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'ŧ': { 0x7: 0x14, 0x2: 0x14, },\n"
"    'ï': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'õ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'š': { 0x7: 0x1f, 0x2: 0x1f, },\n"
"    'đ': { 0x7: 0x20, 0x2: 0x20, },\n"
"    'ǥ': { 0x7: 0x21, 0x2: 0x21, },\n"
"    'ǧ': { 0x7: 0x22, 0x2: 0x22, },\n"
"    'ȟ': { 0x7: 0x23, 0x2: 0x23, },\n"
"    'ǩ': { 0x7: 0x25, 0x2: 0x25, },\n"
"    'ø': { 0x7: 0x27, 0x2: 0x27, },\n"
"    'æ': { 0x7: 0x28, 0x2: 0x28, },\n"
"    'ž': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'č': { 0x7: 0x2e, 0x2: 0x2e, },\n"
"    'ǯ': { 0x7: 0x2f, 0x2: 0x2f, },\n"
"    'ʒ': { 0x7: 0x30, 0x2: 0x30, },\n"
"    'ŋ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '|': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ẃ': [0, ['w', ]],\n"
"    'Ẃ': [0, ['W', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    'ǻ': [0, ['å', ]],\n"
"    'Ǻ': [0, ['Å', ]],\n"
"    'ǽ': [0, ['æ', ]],\n"
"    'Ǽ': [0, ['Æ', ]],\n"
"    'ǿ': [0, ['ø', ]],\n"
"    'Ǿ': [0, ['Ø', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'ẅ': [1, ['w', ]],\n"
"    'Ẅ': [1, ['W', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ÿ': [1, ['Y', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    'ẁ': [2, ['w', ]],\n"
"    'Ẁ': [2, ['W', ]],\n"
"    'ỳ': [2, ['y', ]],\n"
"    'Ỳ': [2, ['Y', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'â': [3, ['a', ]],\n"
"    'Â': [3, ['A', ]],\n"
"    'ĉ': [3, ['c', ]],\n"
"    'Ĉ': [3, ['C', ]],\n"
"    'ê': [3, ['e', ]],\n"
"    'Ê': [3, ['E', ]],\n"
"    'ĝ': [3, ['g', ]],\n"
"    'Ĝ': [3, ['G', ]],\n"
"    'ĥ': [3, ['h', ]],\n"
"    'Ĥ': [3, ['H', ]],\n"
"    'î': [3, ['i', ]],\n"
"    'Î': [3, ['I', ]],\n"
"    'ĵ': [3, ['j', ]],\n"
"    'Ĵ': [3, ['J', ]],\n"
"    'ô': [3, ['o', ]],\n"
"    'Ô': [3, ['O', ]],\n"
"    'ŝ': [3, ['s', ]],\n"
"    'Ŝ': [3, ['S', ]],\n"
"    'û': [3, ['u', ]],\n"
"    'Û': [3, ['U', ]],\n"
"    'ŵ': [3, ['w', ]],\n"
"    'Ŵ': [3, ['W', ]],\n"
"    'ŷ': [3, ['y', ]],\n"
"    'Ŷ': [3, ['Y', ]],\n"
"    '^': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'ĩ': [4, ['i', ]],\n"
"    'Ĩ': [4, ['I', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'ũ': [4, ['u', ]],\n"
"    'Ũ': [4, ['U', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x1b, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x1b, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00011009,\n"
"  localeName: \"en-CA\",\n"
"  displayName: \"Canadian Multilingual Standard\",\n"
"  ctrlRightIsOem8: true,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ç': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    'è': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '/': { 0x0: 0x29, 0x1: 0x35, },\n"
"    'à': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    'é': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, 0x21: 0x39, 0x20: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    'ù': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '?': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ç': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    'È': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '\\\\': { 0x1: 0x29, },\n"
"    'À': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '\\'': { 0x1: 0x33, },\n"
"    '\"': { 0x1: 0x34, },\n"
"    'É': { 0x1: 0x35, 0x4: 0x35, },\n"
"    'Ù': { 0x1: 0x56, 0x4: 0x56, },\n"
"    '¡': { 0x21: 0x2, },\n"
"    '£': { 0x21: 0x4, },\n"
"    '€': { 0x21: 0x5, 0x2: 0x12, },\n"
"    '⅜': { 0x21: 0x6, },\n"
"    '⅝': { 0x21: 0x7, },\n"
"    '⅞': { 0x21: 0x8, },\n"
"    '™': { 0x21: 0x9, },\n"
"    '±': { 0x21: 0xa, },\n"
"    '¿': { 0x21: 0xc, },\n"
"    'Ω': { 0x21: 0x10, },\n"
"    'Ł': { 0x21: 0x11, },\n"
"    'Œ': { 0x21: 0x12, },\n"
"    '®': { 0x21: 0x13, },\n"
"    'Ŧ': { 0x21: 0x14, },\n"
"    '¥': { 0x21: 0x15, },\n"
"    '↑': { 0x21: 0x16, },\n"
"    'ı': { 0x21: 0x17, },\n"
"    'Ø': { 0x21: 0x18, },\n"
"    'Þ': { 0x21: 0x19, },\n"
"    'Æ': { 0x21: 0x1e, },\n"
"    '§': { 0x21: 0x1f, },\n"
"    'Ð': { 0x21: 0x20, },\n"
"    'ª': { 0x21: 0x21, },\n"
"    'Ŋ': { 0x21: 0x22, },\n"
"    'Ħ': { 0x21: 0x23, },\n"
"    'Ĳ': { 0x21: 0x24, },\n"
"    'Ŀ': { 0x21: 0x26, },\n"
"    '\\xad': { 0x21: 0x29, },\n"
"    '©': { 0x21: 0x2e, },\n"
"    '‘': { 0x21: 0x2f, },\n"
"    '’': { 0x21: 0x30, },\n"
"    '♪': { 0x21: 0x31, },\n"
"    'º': { 0x21: 0x32, },\n"
"    '×': { 0x21: 0x33, },\n"
"    '÷': { 0x21: 0x34, },\n"
"    '¦': { 0x21: 0x56, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '¤': { 0x2: 0x5, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '}': { 0x2: 0x9, },\n"
"    '[': { 0x2: 0xa, },\n"
"    ']': { 0x2: 0xb, },\n"
"    '¬': { 0x2: 0xd, },\n"
"    '°': { 0x2: 0x27, },\n"
"    '|': { 0x2: 0x29, },\n"
"    '«': { 0x2: 0x2c, },\n"
"    '»': { 0x2: 0x2d, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"    '\\xa0': { 0x2: 0x39, },\n"
"    '¹': { 0x20: 0x2, },\n"
"    '²': { 0x20: 0x3, },\n"
"    '³': { 0x20: 0x4, },\n"
"    '¼': { 0x20: 0x5, },\n"
"    '½': { 0x20: 0x6, },\n"
"    '¾': { 0x20: 0x7, },\n"
"    'ł': { 0x20: 0x11, },\n"
"    'œ': { 0x20: 0x12, },\n"
"    '¶': { 0x20: 0x13, },\n"
"    'ŧ': { 0x20: 0x14, },\n"
"    '←': { 0x20: 0x15, },\n"
"    '↓': { 0x20: 0x16, },\n"
"    '→': { 0x20: 0x17, },\n"
"    'ø': { 0x20: 0x18, },\n"
"    'þ': { 0x20: 0x19, },\n"
"    '~': { 0x20: 0x1b, },\n"
"    'æ': { 0x20: 0x1e, },\n"
"    'ß': { 0x20: 0x1f, },\n"
"    'ð': { 0x20: 0x20, },\n"
"    'ŋ': { 0x20: 0x22, },\n"
"    'ħ': { 0x20: 0x23, },\n"
"    'ĳ': { 0x20: 0x24, },\n"
"    'ĸ': { 0x20: 0x25, },\n"
"    'ŀ': { 0x20: 0x26, },\n"
"    '¢': { 0x20: 0x2e, },\n"
"    '“': { 0x20: 0x2f, },\n"
"    '”': { 0x20: 0x30, },\n"
"    'ŉ': { 0x20: 0x31, },\n"
"    'µ': { 0x20: 0x32, },\n"
"    '―': { 0x20: 0x33, },\n"
"  },\n"
"  deadkeys: {\n"
"    'â': [0, ['a', ]],\n"
"    'ê': [0, ['e', ]],\n"
"    'î': [0, ['i', ]],\n"
"    'ô': [0, ['o', ]],\n"
"    'û': [0, ['u', ]],\n"
"    'Â': [0, ['A', ]],\n"
"    'Ê': [0, ['E', ]],\n"
"    'Î': [0, ['I', ]],\n"
"    'Ô': [0, ['O', ]],\n"
"    'Û': [0, ['U', ]],\n"
"    'Ĉ': [0, ['C', ]],\n"
"    'ĉ': [0, ['c', ]],\n"
"    'Ĝ': [0, ['G', ]],\n"
"    'ĝ': [0, ['g', ]],\n"
"    'Ĥ': [0, ['H', ]],\n"
"    'ĥ': [0, ['h', ]],\n"
"    'Ĵ': [0, ['J', ]],\n"
"    'ĵ': [0, ['j', ]],\n"
"    'Ŝ': [0, ['S', ]],\n"
"    'ŝ': [0, ['s', ]],\n"
"    'Ŵ': [0, ['W', ]],\n"
"    'ŵ': [0, ['w', ]],\n"
"    'Ŷ': [0, ['Y', ]],\n"
"    'ŷ': [0, ['y', ]],\n"
"    '^': [0, [' ', ]],\n"
"    'ä': [1, ['a', ]],\n"
"    'ë': [1, ['e', ]],\n"
"    'ï': [1, ['i', ]],\n"
"    'ö': [1, ['o', ]],\n"
"    'ü': [1, ['u', ]],\n"
"    'ÿ': [1, ['y', ]],\n"
"    'Ä': [1, ['A', ]],\n"
"    'Ë': [1, ['E', ]],\n"
"    'Ï': [1, ['I', ]],\n"
"    'Ö': [1, ['O', ]],\n"
"    'Ü': [1, ['U', ]],\n"
"    'Ÿ': [1, ['Y', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ą': [2, ['a', ]],\n"
"    'ę': [2, ['e', ]],\n"
"    'į': [2, ['i', ]],\n"
"    'ų': [2, ['u', ]],\n"
"    'Ą': [2, ['A', ]],\n"
"    'Ę': [2, ['E', ]],\n"
"    'Į': [2, ['I', ]],\n"
"    'Ų': [2, ['U', ]],\n"
"    '˛': [2, [' ', ]],\n"
"    'å': [3, ['a', ]],\n"
"    'ů': [3, ['u', ]],\n"
"    'Å': [3, ['A', ]],\n"
"    'Ů': [3, ['U', ]],\n"
"    '˚': [3, [' ', ]],\n"
"    'ā': [4, ['a', ]],\n"
"    'ē': [4, ['e', ]],\n"
"    'ī': [4, ['i', ]],\n"
"    'ō': [4, ['o', ]],\n"
"    'ū': [4, ['u', ]],\n"
"    'Ā': [4, ['A', ]],\n"
"    'Ē': [4, ['E', ]],\n"
"    'Ī': [4, ['I', ]],\n"
"    'Ō': [4, ['O', ]],\n"
"    'Ū': [4, ['U', ]],\n"
"    '¯': [4, [' ', ]],\n"
"    'ő': [5, ['o', ]],\n"
"    'ű': [5, ['u', ]],\n"
"    'Ő': [5, ['O', ]],\n"
"    'Ű': [5, ['U', ]],\n"
"    '˝': [5, [' ', ]],\n"
"    'č': [6, ['c', ]],\n"
"    'ď': [6, ['d', ]],\n"
"    'ě': [6, ['e', ]],\n"
"    'ľ': [6, ['l', ]],\n"
"    'ň': [6, ['n', ]],\n"
"    'ř': [6, ['r', ]],\n"
"    'š': [6, ['s', ]],\n"
"    'ť': [6, ['t', ]],\n"
"    'ž': [6, ['z', ]],\n"
"    'Č': [6, ['C', ]],\n"
"    'Ď': [6, ['D', ]],\n"
"    'Ě': [6, ['E', ]],\n"
"    'Ľ': [6, ['L', ]],\n"
"    'Ň': [6, ['N', ]],\n"
"    'Ř': [6, ['R', ]],\n"
"    'Š': [6, ['S', ]],\n"
"    'Ť': [6, ['T', ]],\n"
"    'Ž': [6, ['Z', ]],\n"
"    'ˇ': [6, [' ', ]],\n"
"    'ă': [7, ['a', ]],\n"
"    'ğ': [7, ['g', ]],\n"
"    'ŭ': [7, ['u', ]],\n"
"    'Ă': [7, ['A', ]],\n"
"    'Ğ': [7, ['G', ]],\n"
"    'Ŭ': [7, ['U', ]],\n"
"    '˘': [7, [' ', ]],\n"
"    'ċ': [8, ['c', ]],\n"
"    'ė': [8, ['e', ]],\n"
"    'ġ': [8, ['g', ]],\n"
"    'ż': [8, ['z', ]],\n"
"    'Ċ': [8, ['C', ]],\n"
"    'Ė': [8, ['E', ]],\n"
"    'Ġ': [8, ['G', ]],\n"
"    'İ': [8, ['I', ]],\n"
"    'Ż': [8, ['Z', ]],\n"
"    '·': [8, [' ', ]],\n"
"    'à': [9, ['a', ]],\n"
"    'è': [9, ['e', ]],\n"
"    'ì': [9, ['i', ]],\n"
"    'ò': [9, ['o', ]],\n"
"    'ù': [9, ['u', ]],\n"
"    'À': [9, ['A', ]],\n"
"    'È': [9, ['E', ]],\n"
"    'Ì': [9, ['I', ]],\n"
"    'Ò': [9, ['O', ]],\n"
"    'Ù': [9, ['U', ]],\n"
"    '`': [9, [' ', ]],\n"
"    'ã': [10, ['a', ]],\n"
"    'ĩ': [10, ['i', ]],\n"
"    'ñ': [10, ['n', ]],\n"
"    'õ': [10, ['o', ]],\n"
"    'ũ': [10, ['u', ]],\n"
"    'Ã': [10, ['A', ]],\n"
"    'Ĩ': [10, ['I', ]],\n"
"    'Ñ': [10, ['N', ]],\n"
"    'Õ': [10, ['O', ]],\n"
"    'Ũ': [10, ['U', ]],\n"
"    '~': [10, [' ', ]],\n"
"    'ç': [11, ['c', ]],\n"
"    'ģ': [11, ['g', ]],\n"
"    'ķ': [11, ['k', ]],\n"
"    'ļ': [11, ['l', ]],\n"
"    'ņ': [11, ['n', ]],\n"
"    'ŗ': [11, ['r', ]],\n"
"    'ş': [11, ['s', ]],\n"
"    'ţ': [11, ['t', ]],\n"
"    'Ç': [11, ['C', ]],\n"
"    'Ģ': [11, ['G', ]],\n"
"    'Ķ': [11, ['K', ]],\n"
"    'Ļ': [11, ['L', ]],\n"
"    'Ņ': [11, ['N', ]],\n"
"    'Ŗ': [11, ['R', ]],\n"
"    'Ş': [11, ['S', ]],\n"
"    'Ţ': [11, ['T', ]],\n"
"    '¸': [11, [' ', ]],\n"
"    'á': [12, ['a', ]],\n"
"    'é': [12, ['e', ]],\n"
"    'í': [12, ['i', ]],\n"
"    'ó': [12, ['o', ]],\n"
"    'ú': [12, ['u', ]],\n"
"    'ý': [12, ['y', ]],\n"
"    'Á': [12, ['A', ]],\n"
"    'É': [12, ['E', ]],\n"
"    'Í': [12, ['I', ]],\n"
"    'Ó': [12, ['O', ]],\n"
"    'Ú': [12, ['U', ]],\n"
"    'Ý': [12, ['Y', ]],\n"
"    'Ć': [12, ['C', ]],\n"
"    'ć': [12, ['c', ]],\n"
"    'Ĺ': [12, ['L', ]],\n"
"    'ĺ': [12, ['l', ]],\n"
"    'Ń': [12, ['N', ]],\n"
"    'ń': [12, ['n', ]],\n"
"    'Ŕ': [12, ['R', ]],\n"
"    'ŕ': [12, ['r', ]],\n"
"    'Ś': [12, ['S', ]],\n"
"    'ś': [12, ['s', ]],\n"
"    'Ź': [12, ['Z', ]],\n"
"    'ź': [12, ['z', ]],\n"
"    '´': [12, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x1a, },\n"
"    {0x1: 0x1a, },\n"
"    {0x21: 0xd, },\n"
"    {0x21: 0x1a, },\n"
"    {0x21: 0x1b, },\n"
"    {0x21: 0x27, },\n"
"    {0x21: 0x28, },\n"
"    {0x21: 0x2b, },\n"
"    {0x21: 0x35, 0x20: 0x34, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"    {0x20: 0xd, },\n"
"    {0x20: 0x27, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00011809,\n"
"  localeName: \"en-IE\",\n"
"  displayName: \"Scottish Gaelic\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '#': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\\\': { 0x0: 0x56, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '@': { 0x1: 0x28, },\n"
"    '`': { 0x1: 0x29, },\n"
"    '~': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '|': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    'É': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Ý': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ú': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Í': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '’': { 0x3: 0x28, },\n"
"    '¬': { 0x3: 0x29, },\n"
"    'é': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'ý': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ú': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'í': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '€': { 0x2: 0x5, },\n"
"    '⁊': { 0x2: 0x8, },\n"
"    '¦': { 0x2: 0x29, },\n"
"  },\n"
"  deadkeys: {\n"
"    'à': [0, ['a', ]],\n"
"    'è': [0, ['e', ]],\n"
"    'ì': [0, ['i', ]],\n"
"    'ò': [0, ['o', ]],\n"
"    'ù': [0, ['u', ]],\n"
"    'À': [0, ['A', ]],\n"
"    'È': [0, ['E', ]],\n"
"    'Ì': [0, ['I', ]],\n"
"    'Ò': [0, ['O', ]],\n"
"    'Ù': [0, ['U', ]],\n"
"    '`': [0, [' ', ]],\n"
"    'á': [1, ['a', ]],\n"
"    'é': [1, ['e', ]],\n"
"    'í': [1, ['i', ]],\n"
"    'ó': [1, ['o', ]],\n"
"    'ú': [1, ['u', ]],\n"
"    'ý': [1, ['y', ]],\n"
"    'Á': [1, ['A', ]],\n"
"    'É': [1, ['E', ]],\n"
"    'Í': [1, ['I', ]],\n"
"    'Ó': [1, ['O', ]],\n"
"    'Ú': [1, ['U', ]],\n"
"    'Ý': [1, ['Y', ]],\n"
"    '\\'': [1, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, },\n"
"    {0x2: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00020405,\n"
"  localeName: \"cs\",\n"
"  displayName: \"Czech Programmers\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, 0x2: 0x35, },\n"
"    '=': { 0x0: 0xd, 0x2: 0xc, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, 0x2: 0x29, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, 0x3: 0x1a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, 0x2: 0x2, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, 0x3: 0x28, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, 0x3: 0xc, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, 0x3: 0x1b, },\n"
"    ')': { 0x1: 0xb, 0x2: 0x1b, },\n"
"    '_': { 0x1: 0xc, 0x3: 0x35, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, 0x2: 0x34, },\n"
"    '\"': { 0x1: 0x28, 0x3: 0x27, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, 0x2: 0x33, },\n"
"    '×': { 0x3: 0x33, },\n"
"    '÷': { 0x3: 0x34, },\n"
"    '\\x1e': { 0x0: 0x7, },\n"
"    '\\x1f': { 0x0: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1d': { 0x0: 0x27, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    'ě': { 0x2: 0x3, },\n"
"    'š': { 0x2: 0x4, },\n"
"    'č': { 0x2: 0x5, },\n"
"    'ř': { 0x2: 0x6, },\n"
"    'ž': { 0x2: 0x7, },\n"
"    'ý': { 0x2: 0x8, },\n"
"    'á': { 0x2: 0x9, },\n"
"    'í': { 0x2: 0xa, },\n"
"    'é': { 0x2: 0xb, },\n"
"    '€': { 0x2: 0x12, },\n"
"    'ú': { 0x2: 0x1a, },\n"
"    'ů': { 0x2: 0x27, },\n"
"    '§': { 0x2: 0x28, },\n"
"    'ß': { 0x2: 0x56, },\n"
"  },\n"
"  deadkeys: {\n"
"    'č': [0, ['c', ]],\n"
"    'Č': [0, ['C', ]],\n"
"    'ď': [0, ['d', ]],\n"
"    'Ď': [0, ['D', ]],\n"
"    'ě': [0, ['e', ]],\n"
"    'Ě': [0, ['E', ]],\n"
"    'ř': [0, ['r', ]],\n"
"    'Ř': [0, ['R', ]],\n"
"    'ľ': [0, ['l', ]],\n"
"    'Ľ': [0, ['L', ]],\n"
"    'ň': [0, ['n', ]],\n"
"    'Ň': [0, ['N', ]],\n"
"    'š': [0, ['s', ]],\n"
"    'Š': [0, ['S', ]],\n"
"    'ť': [0, ['t', ]],\n"
"    'Ť': [0, ['T', ]],\n"
"    'ž': [0, ['z', ]],\n"
"    'Ž': [0, ['Z', ]],\n"
"    'ˇ': [0, [' ', ]],\n"
"    'å': [1, ['a', ]],\n"
"    'Å': [1, ['A', ]],\n"
"    'ů': [1, ['u', ]],\n"
"    'Ů': [1, ['U', ]],\n"
"    '°': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'ő': [3, ['o', ]],\n"
"    'Ő': [3, ['O', ]],\n"
"    'ű': [3, ['u', ]],\n"
"    'Ű': [3, ['U', ]],\n"
"    '˝': [3, [' ', ]],\n"
"    'á': [4, ['a', ]],\n"
"    'Á': [4, ['A', ]],\n"
"    'ś': [4, ['s', ]],\n"
"    'Ś': [4, ['S', ]],\n"
"    'ć': [4, ['c', ]],\n"
"    'Ć': [4, ['C', ]],\n"
"    'é': [4, ['e', ]],\n"
"    'É': [4, ['E', ]],\n"
"    'ŕ': [4, ['r', ]],\n"
"    'Ŕ': [4, ['R', ]],\n"
"    'í': [4, ['i', ]],\n"
"    'Í': [4, ['I', ]],\n"
"    'ó': [4, ['o', ]],\n"
"    'Ó': [4, ['O', ]],\n"
"    'ú': [4, ['u', ]],\n"
"    'Ú': [4, ['U', ]],\n"
"    'ý': [4, ['y', ]],\n"
"    'Ý': [4, ['Y', ]],\n"
"    'ĺ': [4, ['l', ]],\n"
"    'Ĺ': [4, ['L', ]],\n"
"    'ń': [4, ['n', ]],\n"
"    'Ń': [4, ['N', ]],\n"
"    'ź': [4, ['z', ]],\n"
"    'Ź': [4, ['Z', ]],\n"
"    '´': [4, [' ', ]],\n"
"    'ä': [5, ['a', ]],\n"
"    'Ä': [5, ['A', ]],\n"
"    'ë': [5, ['e', ]],\n"
"    'Ë': [5, ['E', ]],\n"
"    'ï': [5, ['i', ]],\n"
"    'Ï': [5, ['I', ]],\n"
"    'ö': [5, ['o', ]],\n"
"    'Ö': [5, ['O', ]],\n"
"    'ü': [5, ['u', ]],\n"
"    'Ü': [5, ['U', ]],\n"
"    'ÿ': [5, ['y', ]],\n"
"    'Ÿ': [5, ['Y', ]],\n"
"    '¨': [5, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x3: 0xd, },\n"
"    {0x3: 0x29, },\n"
"    {0x3: 0x2b, },\n"
"    {0x3: 0x56, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x2b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00020408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek (319)\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    '·': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'ς': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'ε': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'ρ': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'τ': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'υ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'θ': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ι': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ο': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'π': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'α': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'σ': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'δ': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'φ': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'γ': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'η': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ξ': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'κ': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'λ': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '’': { 0x0: 0x28, },\n"
"    '½': { 0x0: 0x29, },\n"
"    '²': { 0x0: 0x2b, },\n"
"    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'χ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'ω': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'β': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'ν': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'μ': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '§': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '£': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '¬': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '°': { 0x1: 0xc, },\n"
"    '―': { 0x1: 0x10, 0x4: 0x10, },\n"
"    '¦': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'Ε': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Ρ': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Τ': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Υ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Θ': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ι': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ο': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'Π': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '«': { 0x1: 0x1a, },\n"
"    '»': { 0x1: 0x1b, },\n"
"    'Α': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Δ': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Φ': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Γ': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Η': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ξ': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Κ': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Λ': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '‘': { 0x1: 0x28, },\n"
"    '±': { 0x1: 0x29, },\n"
"    '³': { 0x1: 0x2b, },\n"
"    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Β': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Ν': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Μ': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '©': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '€': { 0x2: 0x12, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ά': [0, ['α', ]],\n"
"    'έ': [0, ['ε', ]],\n"
"    'ί': [0, ['ι', ]],\n"
"    'ό': [0, ['ο', ]],\n"
"    'ύ': [0, ['υ', ]],\n"
"    'ώ': [0, ['ω', ]],\n"
"    'ή': [0, ['η', ]],\n"
"    'Ά': [0, ['Α', ]],\n"
"    'Έ': [0, ['Ε', ]],\n"
"    'Ί': [0, ['Ι', ]],\n"
"    'Ό': [0, ['Ο', ]],\n"
"    'Ύ': [0, ['Υ', ]],\n"
"    'Ώ': [0, ['Ω', ]],\n"
"    'Ή': [0, ['Η', ]],\n"
"    '΄': [0, [' ', ]],\n"
"    'ϊ': [1, ['ι', ]],\n"
"    'ϋ': [1, ['υ', ]],\n"
"    'Ϊ': [1, ['Ι', ]],\n"
"    'Ϋ': [1, ['Υ', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ΐ': [2, ['ι', ]],\n"
"    'ΰ': [2, ['υ', ]],\n"
"    '΅': [2, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x27, },\n"
"    {0x1: 0x27, },\n"
"    {0x2: 0x27, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00020409,\n"
"  localeName: \"en-US\",\n"
"  displayName: \"United States-International\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '¹': { 0x3: 0x2, },\n"
"    '£': { 0x3: 0x5, },\n"
"    '÷': { 0x3: 0xd, },\n"
"    'Ä': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'Å': { 0x3: 0x11, 0x6: 0x11, },\n"
"    'É': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Þ': { 0x3: 0x14, 0x6: 0x14, },\n"
"    'Ü': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ú': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Í': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Ö': { 0x3: 0x19, 0x6: 0x19, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '§': { 0x3: 0x1f, },\n"
"    'Ð': { 0x3: 0x20, 0x6: 0x20, },\n"
"    'Ø': { 0x3: 0x26, 0x6: 0x26, },\n"
"    '°': { 0x3: 0x27, },\n"
"    '¨': { 0x3: 0x28, },\n"
"    '¦': { 0x3: 0x2b, },\n"
"    'Æ': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    '¢': { 0x3: 0x2e, },\n"
"    'Ñ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'Ç': { 0x3: 0x33, 0x6: 0x33, },\n"
"    'ä': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'å': { 0x7: 0x11, 0x2: 0x11, },\n"
"    'é': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'þ': { 0x7: 0x14, 0x2: 0x14, },\n"
"    'ü': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ú': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'í': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'ö': { 0x7: 0x19, 0x2: 0x19, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ð': { 0x7: 0x20, 0x2: 0x20, },\n"
"    'ø': { 0x7: 0x26, 0x2: 0x26, },\n"
"    'æ': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'ñ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    'ç': { 0x7: 0x33, 0x2: 0x33, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '¡': { 0x2: 0x2, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '¤': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '¼': { 0x2: 0x7, },\n"
"    '½': { 0x2: 0x8, },\n"
"    '¾': { 0x2: 0x9, },\n"
"    '‘': { 0x2: 0xa, },\n"
"    '’': { 0x2: 0xb, },\n"
"    '¥': { 0x2: 0xc, },\n"
"    '×': { 0x2: 0xd, },\n"
"    '®': { 0x2: 0x13, },\n"
"    '«': { 0x2: 0x1a, },\n"
"    '»': { 0x2: 0x1b, },\n"
"    'ß': { 0x2: 0x1f, },\n"
"    '¶': { 0x2: 0x27, },\n"
"    '´': { 0x2: 0x28, },\n"
"    '¬': { 0x2: 0x2b, },\n"
"    '©': { 0x2: 0x2e, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '¿': { 0x2: 0x35, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '\\'': [0, [' ', ]],\n"
"    'ç': [0, ['c', ]],\n"
"    'Ç': [0, ['C', ]],\n"
"    'à': [1, ['a', ]],\n"
"    'è': [1, ['e', ]],\n"
"    'ì': [1, ['i', ]],\n"
"    'ò': [1, ['o', ]],\n"
"    'ù': [1, ['u', ]],\n"
"    'À': [1, ['A', ]],\n"
"    'È': [1, ['E', ]],\n"
"    'Ì': [1, ['I', ]],\n"
"    'Ò': [1, ['O', ]],\n"
"    'Ù': [1, ['U', ]],\n"
"    '`': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'ä': [3, ['a', ]],\n"
"    'ë': [3, ['e', ]],\n"
"    'ï': [3, ['i', ]],\n"
"    'ö': [3, ['o', ]],\n"
"    'ü': [3, ['u', ]],\n"
"    'ÿ': [3, ['y', ]],\n"
"    'Ä': [3, ['A', ]],\n"
"    'Ë': [3, ['E', ]],\n"
"    'Ï': [3, ['I', ]],\n"
"    'Ö': [3, ['O', ]],\n"
"    'Ü': [3, ['U', ]],\n"
"    '\"': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x28, },\n"
"    {0x0: 0x29, },\n"
"    {0x1: 0x7, },\n"
"    {0x1: 0x28, },\n"
"    {0x1: 0x29, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x0002083b,\n"
"  localeName: \"se-Latn-SE\",\n"
"  displayName: \"Sami Extended Finland-Sweden\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '+': { 0x0: 0xc, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'á': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'š': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'ŧ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'å': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    'ŋ': { 0x0: 0x1b, 0x5: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ö': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ä': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '§': { 0x0: 0x29, },\n"
"    'đ': { 0x0: 0x2b, 0x5: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'č': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, 0x3: 0x2b, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    'ž': { 0x0: 0x56, 0x5: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '¤': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Á': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'Š': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Ŧ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Å': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    'Ŋ': { 0x1: 0x1b, 0x4: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ö': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ä': { 0x1: 0x28, 0x4: 0x28, },\n"
"    '½': { 0x1: 0x29, },\n"
"    'Đ': { 0x1: 0x2b, 0x4: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Č': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    'Ž': { 0x1: 0x56, 0x4: 0x56, },\n"
"    'Q': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'W': { 0x3: 0x11, 0x6: 0x11, },\n"
"    'Y': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ï': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Õ': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Â': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    'Ǧ': { 0x3: 0x22, 0x6: 0x22, },\n"
"    'Ǥ': { 0x3: 0x23, 0x6: 0x23, },\n"
"    'Ǩ': { 0x3: 0x25, 0x6: 0x25, },\n"
"    'Ø': { 0x3: 0x27, 0x6: 0x27, },\n"
"    'Æ': { 0x3: 0x28, 0x6: 0x28, },\n"
"    'Ʒ': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    'X': { 0x3: 0x2d, 0x6: 0x2d, },\n"
"    'Ǯ': { 0x3: 0x56, 0x6: 0x56, },\n"
"    'q': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'w': { 0x7: 0x11, 0x2: 0x11, },\n"
"    'y': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ï': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'õ': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'â': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ǧ': { 0x7: 0x22, 0x2: 0x22, },\n"
"    'ǥ': { 0x7: 0x23, 0x2: 0x23, },\n"
"    'ǩ': { 0x7: 0x25, 0x2: 0x25, },\n"
"    'ø': { 0x7: 0x27, 0x2: 0x27, },\n"
"    'æ': { 0x7: 0x28, 0x2: 0x28, },\n"
"    'ʒ': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'x': { 0x7: 0x2d, 0x2: 0x2d, },\n"
"    'ǯ': { 0x7: 0x56, 0x2: 0x56, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '@': { 0x2: 0x3, },\n"
"    '£': { 0x2: 0x4, },\n"
"    '$': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '{': { 0x2: 0x8, },\n"
"    '[': { 0x2: 0x9, },\n"
"    ']': { 0x2: 0xa, },\n"
"    '}': { 0x2: 0xb, },\n"
"    '\\\\': { 0x2: 0xc, },\n"
"    '|': { 0x2: 0x29, },\n"
"    '\\'': { 0x2: 0x2b, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '<': { 0x2: 0x33, },\n"
"    '>': { 0x2: 0x34, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'ć': [0, ['c', ]],\n"
"    'Ć': [0, ['C', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'ĺ': [0, ['l', ]],\n"
"    'Ĺ': [0, ['L', ]],\n"
"    'ń': [0, ['n', ]],\n"
"    'Ń': [0, ['N', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'ŕ': [0, ['r', ]],\n"
"    'Ŕ': [0, ['R', ]],\n"
"    'ś': [0, ['s', ]],\n"
"    'Ś': [0, ['S', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'ẃ': [0, ['w', ]],\n"
"    'Ẃ': [0, ['W', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    'ź': [0, ['z', ]],\n"
"    'Ź': [0, ['Z', ]],\n"
"    'ǻ': [0, ['å', ]],\n"
"    'Ǻ': [0, ['Å', ]],\n"
"    'ǽ': [0, ['æ', ]],\n"
"    'Ǽ': [0, ['Æ', ]],\n"
"    'ǿ': [0, ['ø', ]],\n"
"    'Ǿ': [0, ['Ø', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'à': [1, ['a', ]],\n"
"    'À': [1, ['A', ]],\n"
"    'è': [1, ['e', ]],\n"
"    'È': [1, ['E', ]],\n"
"    'ì': [1, ['i', ]],\n"
"    'Ì': [1, ['I', ]],\n"
"    'ò': [1, ['o', ]],\n"
"    'Ò': [1, ['O', ]],\n"
"    'ù': [1, ['u', ]],\n"
"    'Ù': [1, ['U', ]],\n"
"    'ẁ': [1, ['w', ]],\n"
"    'Ẁ': [1, ['W', ]],\n"
"    'ỳ': [1, ['y', ]],\n"
"    'Ỳ': [1, ['Y', ]],\n"
"    '`': [1, [' ', ]],\n"
"    'â': [2, ['a', ]],\n"
"    'Â': [2, ['A', ]],\n"
"    'ĉ': [2, ['c', ]],\n"
"    'Ĉ': [2, ['C', ]],\n"
"    'ê': [2, ['e', ]],\n"
"    'Ê': [2, ['E', ]],\n"
"    'ĝ': [2, ['g', ]],\n"
"    'Ĝ': [2, ['G', ]],\n"
"    'ĥ': [2, ['h', ]],\n"
"    'Ĥ': [2, ['H', ]],\n"
"    'î': [2, ['i', ]],\n"
"    'Î': [2, ['I', ]],\n"
"    'ĵ': [2, ['j', ]],\n"
"    'Ĵ': [2, ['J', ]],\n"
"    'ô': [2, ['o', ]],\n"
"    'Ô': [2, ['O', ]],\n"
"    'ŝ': [2, ['s', ]],\n"
"    'Ŝ': [2, ['S', ]],\n"
"    'û': [2, ['u', ]],\n"
"    'Û': [2, ['U', ]],\n"
"    'ŵ': [2, ['w', ]],\n"
"    'Ŵ': [2, ['W', ]],\n"
"    'ŷ': [2, ['y', ]],\n"
"    'Ŷ': [2, ['Y', ]],\n"
"    '^': [2, [' ', ]],\n"
"    'č': [3, ['c', ]],\n"
"    'Č': [3, ['C', ]],\n"
"    'ď': [3, ['d', ]],\n"
"    'Ď': [3, ['D', ]],\n"
"    'ě': [3, ['e', ]],\n"
"    'Ě': [3, ['E', ]],\n"
"    'ǧ': [3, ['g', ]],\n"
"    'Ǧ': [3, ['G', ]],\n"
"    'ȟ': [3, ['h', ]],\n"
"    'Ȟ': [3, ['H', ]],\n"
"    'ǩ': [3, ['k', ]],\n"
"    'Ǩ': [3, ['K', ]],\n"
"    'ľ': [3, ['l', ]],\n"
"    'Ľ': [3, ['L', ]],\n"
"    'ň': [3, ['n', ]],\n"
"    'Ň': [3, ['N', ]],\n"
"    'ř': [3, ['r', ]],\n"
"    'Ř': [3, ['R', ]],\n"
"    'š': [3, ['s', ]],\n"
"    'Š': [3, ['S', ]],\n"
"    'ť': [3, ['t', ]],\n"
"    'Ť': [3, ['T', ]],\n"
"    'ž': [3, ['z', ]],\n"
"    'Ž': [3, ['Z', ]],\n"
"    'ǯ': [3, ['ʒ', ]],\n"
"    'Ǯ': [3, ['Ʒ', ]],\n"
"    'ˇ': [3, [' ', ]],\n"
"    'ä': [4, ['a', ]],\n"
"    'Ä': [4, ['A', ]],\n"
"    'ë': [4, ['e', ]],\n"
"    'Ë': [4, ['E', ]],\n"
"    'ï': [4, ['i', ]],\n"
"    'Ï': [4, ['I', ]],\n"
"    'ö': [4, ['o', ]],\n"
"    'Ö': [4, ['O', ]],\n"
"    'ü': [4, ['u', ]],\n"
"    'Ü': [4, ['U', ]],\n"
"    'ẅ': [4, ['w', ]],\n"
"    'Ẅ': [4, ['W', ]],\n"
"    'ÿ': [4, ['y', ]],\n"
"    'Ÿ': [4, ['Y', ]],\n"
"    '¨': [4, [' ', ]],\n"
"    'ã': [5, ['a', ]],\n"
"    'Ã': [5, ['A', ]],\n"
"    'ĩ': [5, ['i', ]],\n"
"    'Ĩ': [5, ['I', ]],\n"
"    'ñ': [5, ['n', ]],\n"
"    'Ñ': [5, ['N', ]],\n"
"    'õ': [5, ['o', ]],\n"
"    'Õ': [5, ['O', ]],\n"
"    'ũ': [5, ['u', ]],\n"
"    'Ũ': [5, ['U', ]],\n"
"    '~': [5, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xd, },\n"
"    {0x1: 0xd, },\n"
"    {0x3: 0x1a, },\n"
"    {0x3: 0x1b, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00030402,\n"
"  localeName: \"bg\",\n"
"  displayName: \"Bulgarian\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '.': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    ',': { 0x0: 0x10, 0x4: 0x10, },\n"
"    'у': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'е': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'и': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'ш': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'щ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'к': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'с': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'д': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'з': { 0x0: 0x19, 0x5: 0x19, },\n"
"    'ц': { 0x0: 0x1a, 0x5: 0x1a, },\n"
"    ';': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'ь': { 0x0: 0x1e, },\n"
"    'я': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'а': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'о': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'ж': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'г': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'т': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'н': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'в': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'м': { 0x0: 0x27, 0x5: 0x27, },\n"
"    'ч': { 0x0: 0x28, 0x5: 0x28, },\n"
"    '(': { 0x0: 0x29, },\n"
"    '„': { 0x0: 0x2b, },\n"
"    'ю': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'й': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ъ': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'э': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'ф': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'х': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'п': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'р': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'л': { 0x0: 0x34, 0x5: 0x34, },\n"
"    'б': { 0x0: 0x35, 0x5: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x37, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4, },\n"
"    'ѝ': { 0x0: 0x56, 0x1: 0x1e, 0x5: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x9, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '?': { 0x1: 0x3, },\n"
"    '\"': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '=': { 0x1: 0x7, },\n"
"    ':': { 0x1: 0x8, },\n"
"    '–': { 0x1: 0xa, },\n"
"    '№': { 0x1: 0xb, },\n"
"    '$': { 0x1: 0xc, },\n"
"    '€': { 0x1: 0xd, },\n"
"    'ы': { 0x1: 0x10, },\n"
"    'У': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'Е': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'И': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Ш': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Щ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'К': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'С': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Д': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'З': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Ц': { 0x1: 0x1a, 0x4: 0x1a, },\n"
"    '§': { 0x1: 0x1b, },\n"
"    'Я': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'А': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'О': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Ж': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Г': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Т': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Н': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'В': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'М': { 0x1: 0x27, 0x4: 0x27, },\n"
"    'Ч': { 0x1: 0x28, 0x4: 0x28, },\n"
"    ')': { 0x1: 0x29, },\n"
"    '“': { 0x1: 0x2b, },\n"
"    'Ю': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Й': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ъ': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'Э': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Ф': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Х': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'П': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'Р': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'Л': { 0x1: 0x34, 0x4: 0x34, },\n"
"    'Б': { 0x1: 0x35, 0x4: 0x35, },\n"
"    'Ѝ': { 0x1: 0x56, 0x5: 0x1e, 0x4: 0x56, },\n"
"    'Ы': { 0x5: 0x10, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    'Ь': { 0x4: 0x1e, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00030408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek (220) Latin\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    ']': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '+': { 0x0: 0x1a, 0x1: 0x4e, },\n"
"    '}': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '\\\\': { 0x0: 0x29, },\n"
"    '#': { 0x0: 0x2b, 0x1: 0x4, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1a, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    '[': { 0x1: 0xd, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '|': { 0x1: 0x29, },\n"
"    '@': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0x35, },\n"
"    '\\x1d': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x29, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '£': { 0x2: 0x5, },\n"
"    '§': { 0x2: 0x6, },\n"
"    '¶': { 0x2: 0x7, },\n"
"    '¤': { 0x2: 0x9, },\n"
"    '¦': { 0x2: 0xa, },\n"
"    '°': { 0x2: 0xb, },\n"
"    '±': { 0x2: 0xc, },\n"
"    '½': { 0x2: 0xd, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '«': { 0x2: 0x1a, },\n"
"    '»': { 0x2: 0x1b, },\n"
"    '¬': { 0x2: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ά': [0, ['α', ]],\n"
"    'έ': [0, ['ε', ]],\n"
"    'ί': [0, ['ι', ]],\n"
"    'ό': [0, ['ο', ]],\n"
"    'ύ': [0, ['υ', ]],\n"
"    'ώ': [0, ['ω', ]],\n"
"    'ή': [0, ['η', ]],\n"
"    'Ά': [0, ['Α', ]],\n"
"    'Έ': [0, ['Ε', ]],\n"
"    'Ί': [0, ['Ι', ]],\n"
"    'Ό': [0, ['Ο', ]],\n"
"    'Ύ': [0, ['Υ', ]],\n"
"    'Ώ': [0, ['Ω', ]],\n"
"    'Ή': [0, ['Η', ]],\n"
"    '΄': [0, [' ', ]],\n"
"    'ϊ': [1, ['ι', ]],\n"
"    'ϋ': [1, ['υ', ]],\n"
"    'Ϊ': [1, ['Ι', ]],\n"
"    'Ϋ': [1, ['Υ', ]],\n"
"    '¨': [1, [' ', ]],\n"
"    'ΐ': [2, ['ι', ]],\n"
"    'ΰ': [2, ['υ', ]],\n"
"    '΅': [2, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x27, },\n"
"    {0x0: 0x28, 0x1: 0x27, },\n"
"    {0x1: 0x28, 0x2: 0x27, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00030409,\n"
"  localeName: \"en-US\",\n"
"  displayName: \"United States-Dvorak for left hand\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '[': { 0x0: 0x2, },\n"
"    ']': { 0x0: 0x3, },\n"
"    '/': { 0x0: 0x4, 0x1: 0x35, },\n"
"    'p': { 0x0: 0x5, 0x5: 0x5, },\n"
"    'f': { 0x0: 0x6, 0x5: 0x6, },\n"
"    'm': { 0x0: 0x7, 0x5: 0x7, },\n"
"    'l': { 0x0: 0x8, 0x5: 0x8, },\n"
"    'j': { 0x0: 0x9, 0x5: 0x9, },\n"
"    '4': { 0x0: 0xa, },\n"
"    '3': { 0x0: 0xb, },\n"
"    '2': { 0x0: 0xc, },\n"
"    '1': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    ';': { 0x0: 0x10, },\n"
"    'q': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'b': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'y': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'u': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'r': { 0x0: 0x15, 0x5: 0x15, },\n"
"    's': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'o': { 0x0: 0x17, 0x5: 0x17, },\n"
"    '.': { 0x0: 0x18, },\n"
"    '6': { 0x0: 0x19, },\n"
"    '5': { 0x0: 0x1a, },\n"
"    '=': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    '-': { 0x0: 0x1e, 0x1: 0x4a, },\n"
"    'k': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'c': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'd': { 0x0: 0x21, 0x5: 0x21, },\n"
"    't': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'e': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'a': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'z': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '8': { 0x0: 0x27, },\n"
"    '7': { 0x0: 0x28, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    '\\'': { 0x0: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'g': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'w': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'i': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '0': { 0x0: 0x34, },\n"
"    '9': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x27, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x1b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '{': { 0x1: 0x2, },\n"
"    '}': { 0x1: 0x3, },\n"
"    '?': { 0x1: 0x4, },\n"
"    'P': { 0x1: 0x5, 0x4: 0x5, },\n"
"    'F': { 0x1: 0x6, 0x4: 0x6, },\n"
"    'M': { 0x1: 0x7, 0x4: 0x7, },\n"
"    'L': { 0x1: 0x8, 0x4: 0x8, },\n"
"    'J': { 0x1: 0x9, 0x4: 0x9, },\n"
"    '$': { 0x1: 0xa, },\n"
"    '#': { 0x1: 0xb, },\n"
"    '@': { 0x1: 0xc, },\n"
"    '!': { 0x1: 0xd, },\n"
"    ':': { 0x1: 0x10, },\n"
"    'Q': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'B': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Y': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'U': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'R': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'S': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'O': { 0x1: 0x17, 0x4: 0x17, },\n"
"    '>': { 0x1: 0x18, },\n"
"    '^': { 0x1: 0x19, },\n"
"    '%': { 0x1: 0x1a, },\n"
"    '_': { 0x1: 0x1e, },\n"
"    'K': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'C': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'D': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'T': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'E': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'A': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Z': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '&': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    '\"': { 0x1: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'G': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'W': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'I': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    ')': { 0x1: 0x34, },\n"
"    '(': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x19, },\n"
"    '\\x1f': { 0x1: 0x1e, },\n"
"    '\\x1d': { 0x0: 0x3, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00040408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek (319) Latin\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\'': { 0x0: 0xc, },\n"
"    '+': { 0x0: 0xd, 0x1: 0x4e, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    '\\\\': { 0x0: 0x29, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '-': { 0x0: 0x35, 0x1: 0x4a, },\n"
"    '*': { 0x0: 0x37, 0x1: 0xd, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '<': { 0x0: 0x56, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x8, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '\"': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x7, },\n"
"    '(': { 0x1: 0x9, },\n"
"    ')': { 0x1: 0xa, },\n"
"    '=': { 0x1: 0xb, },\n"
"    '?': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    '|': { 0x1: 0x29, },\n"
"    '@': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    ';': { 0x1: 0x33, },\n"
"    ':': { 0x1: 0x34, },\n"
"    '_': { 0x1: 0x35, },\n"
"    '>': { 0x1: 0x56, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '€': { 0x2: 0x12, },\n"
"  },\n"
"  deadkeys: {\n"
"    'á': [0, ['a', ]],\n"
"    'é': [0, ['e', ]],\n"
"    'í': [0, ['i', ]],\n"
"    'ó': [0, ['o', ]],\n"
"    'ú': [0, ['u', ]],\n"
"    'ý': [0, ['y', ]],\n"
"    'Á': [0, ['A', ]],\n"
"    'É': [0, ['E', ]],\n"
"    'Í': [0, ['I', ]],\n"
"    'Ó': [0, ['O', ]],\n"
"    'Ú': [0, ['U', ]],\n"
"    'Ý': [0, ['Y', ]],\n"
"    '´': [0, [' ', ]],\n"
"    'â': [1, ['a', ]],\n"
"    'ê': [1, ['e', ]],\n"
"    'î': [1, ['i', ]],\n"
"    'ô': [1, ['o', ]],\n"
"    'û': [1, ['u', ]],\n"
"    'Â': [1, ['A', ]],\n"
"    'Ê': [1, ['E', ]],\n"
"    'Î': [1, ['I', ]],\n"
"    'Ô': [1, ['O', ]],\n"
"    'Û': [1, ['U', ]],\n"
"    '^': [1, [' ', ]],\n"
"    'à': [2, ['a', ]],\n"
"    'è': [2, ['e', ]],\n"
"    'ì': [2, ['i', ]],\n"
"    'ò': [2, ['o', ]],\n"
"    'ù': [2, ['u', ]],\n"
"    'À': [2, ['A', ]],\n"
"    'È': [2, ['E', ]],\n"
"    'Ì': [2, ['I', ]],\n"
"    'Ò': [2, ['O', ]],\n"
"    'Ù': [2, ['U', ]],\n"
"    '`': [2, [' ', ]],\n"
"    'ä': [3, ['a', ]],\n"
"    'ë': [3, ['e', ]],\n"
"    'ï': [3, ['i', ]],\n"
"    'ö': [3, ['o', ]],\n"
"    'ü': [3, ['u', ]],\n"
"    'ÿ': [3, ['y', ]],\n"
"    'Ä': [3, ['A', ]],\n"
"    'Ë': [3, ['E', ]],\n"
"    'Ï': [3, ['I', ]],\n"
"    'Ö': [3, ['O', ]],\n"
"    'Ü': [3, ['U', ]],\n"
"    '¨': [3, [' ', ]],\n"
"    'ã': [4, ['a', ]],\n"
"    'õ': [4, ['o', ]],\n"
"    'ñ': [4, ['n', ]],\n"
"    'Ã': [4, ['A', ]],\n"
"    'Õ': [4, ['O', ]],\n"
"    'Ñ': [4, ['N', ]],\n"
"    '~': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x27, },\n"
"    {0x0: 0x28, },\n"
"    {0x0: 0x2b, },\n"
"    {0x1: 0x27, },\n"
"    {0x1: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00040409,\n"
"  localeName: \"en-US\",\n"
"  displayName: \"United States-Dvorak for right hand\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    'j': { 0x0: 0x6, 0x5: 0x6, },\n"
"    'l': { 0x0: 0x7, 0x5: 0x7, },\n"
"    'm': { 0x0: 0x8, 0x5: 0x8, },\n"
"    'f': { 0x0: 0x9, 0x5: 0x9, },\n"
"    'p': { 0x0: 0xa, 0x5: 0xa, },\n"
"    '/': { 0x0: 0xb, 0x1: 0x35, },\n"
"    '[': { 0x0: 0xc, },\n"
"    ']': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    '5': { 0x0: 0x10, },\n"
"    '6': { 0x0: 0x11, },\n"
"    'q': { 0x0: 0x12, 0x5: 0x12, },\n"
"    '.': { 0x0: 0x13, },\n"
"    'o': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'r': { 0x0: 0x15, 0x5: 0x15, },\n"
"    's': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'u': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'y': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'b': { 0x0: 0x19, 0x5: 0x19, },\n"
"    ';': { 0x0: 0x1a, },\n"
"    '=': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    '7': { 0x0: 0x1e, },\n"
"    '8': { 0x0: 0x1f, },\n"
"    'z': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'a': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'e': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    't': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'd': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'c': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'k': { 0x0: 0x27, 0x5: 0x27, },\n"
"    '-': { 0x0: 0x28, 0x1: 0x4a, },\n"
"    '`': { 0x0: 0x29, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    '9': { 0x0: 0x2c, },\n"
"    '0': { 0x0: 0x2d, },\n"
"    'x': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    ',': { 0x0: 0x2f, },\n"
"    'i': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'w': { 0x0: 0x32, 0x5: 0x32, },\n"
"    'v': { 0x0: 0x33, 0x5: 0x33, },\n"
"    'g': { 0x0: 0x34, 0x5: 0x34, },\n"
"    '\\'': { 0x0: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x1f, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x1b, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    'J': { 0x1: 0x6, 0x4: 0x6, },\n"
"    'L': { 0x1: 0x7, 0x4: 0x7, },\n"
"    'M': { 0x1: 0x8, 0x4: 0x8, },\n"
"    'F': { 0x1: 0x9, 0x4: 0x9, },\n"
"    'P': { 0x1: 0xa, 0x4: 0xa, },\n"
"    '?': { 0x1: 0xb, },\n"
"    '{': { 0x1: 0xc, },\n"
"    '}': { 0x1: 0xd, },\n"
"    '%': { 0x1: 0x10, },\n"
"    '^': { 0x1: 0x11, },\n"
"    'Q': { 0x1: 0x12, 0x4: 0x12, },\n"
"    '>': { 0x1: 0x13, },\n"
"    'O': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'R': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'S': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'U': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Y': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'B': { 0x1: 0x19, 0x4: 0x19, },\n"
"    ':': { 0x1: 0x1a, },\n"
"    '&': { 0x1: 0x1e, },\n"
"    'Z': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'A': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'E': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'T': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'D': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'C': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'K': { 0x1: 0x27, 0x4: 0x27, },\n"
"    '_': { 0x1: 0x28, },\n"
"    '~': { 0x1: 0x29, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    '(': { 0x1: 0x2c, },\n"
"    ')': { 0x1: 0x2d, },\n"
"    'X': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    '<': { 0x1: 0x2f, },\n"
"    'I': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'W': { 0x1: 0x32, 0x4: 0x32, },\n"
"    'V': { 0x1: 0x33, 0x4: 0x33, },\n"
"    'G': { 0x1: 0x34, 0x4: 0x34, },\n"
"    '\"': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x11, },\n"
"    '\\x1f': { 0x1: 0x28, },\n"
"    '\\x1d': { 0x0: 0xd, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"  },\n"
"  deadkeys: {\n"
"  },\n"
"  accents: [\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00050408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek Latin\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '-': { 0x0: 0xc, 0x1: 0x4a, },\n"
"    '=': { 0x0: 0xd, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'q': { 0x0: 0x10, 0x5: 0x10, },\n"
"    'w': { 0x0: 0x11, 0x5: 0x11, },\n"
"    'e': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'r': { 0x0: 0x13, 0x5: 0x13, },\n"
"    't': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'y': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'u': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'i': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'o': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'p': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '[': { 0x0: 0x1a, },\n"
"    ']': { 0x0: 0x1b, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'a': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    's': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'd': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'f': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'g': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'h': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'j': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'k': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'l': { 0x0: 0x26, 0x5: 0x26, },\n"
"    ';': { 0x0: 0x27, },\n"
"    '\\'': { 0x0: 0x28, },\n"
"    '\\\\': { 0x0: 0x2b, },\n"
"    'z': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'x': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'c': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'v': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'b': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'n': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'm': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0xd, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    '_': { 0x1: 0xc, },\n"
"    'Q': { 0x1: 0x10, 0x4: 0x10, },\n"
"    'W': { 0x1: 0x11, 0x4: 0x11, },\n"
"    'E': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'R': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'T': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Y': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'U': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'I': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'O': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'P': { 0x1: 0x19, 0x4: 0x19, },\n"
"    '{': { 0x1: 0x1a, },\n"
"    '}': { 0x1: 0x1b, },\n"
"    'A': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'S': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'D': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'F': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'G': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'H': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'J': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'K': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'L': { 0x1: 0x26, 0x4: 0x26, },\n"
"    ':': { 0x1: 0x27, },\n"
"    '\"': { 0x1: 0x28, },\n"
"    '|': { 0x1: 0x2b, },\n"
"    'Z': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'X': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'C': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'V': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'B': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'N': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'M': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '<': { 0x1: 0x33, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '?': { 0x1: 0x35, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '¹': { 0x3: 0x2, },\n"
"    '£': { 0x3: 0x5, },\n"
"    '÷': { 0x3: 0xd, },\n"
"    'Ä': { 0x3: 0x10, 0x6: 0x10, },\n"
"    'Å': { 0x3: 0x11, 0x6: 0x11, },\n"
"    'É': { 0x3: 0x12, 0x6: 0x12, },\n"
"    'Þ': { 0x3: 0x14, 0x6: 0x14, },\n"
"    'Ü': { 0x3: 0x15, 0x6: 0x15, },\n"
"    'Ú': { 0x3: 0x16, 0x6: 0x16, },\n"
"    'Í': { 0x3: 0x17, 0x6: 0x17, },\n"
"    'Ó': { 0x3: 0x18, 0x6: 0x18, },\n"
"    'Ö': { 0x3: 0x19, 0x6: 0x19, },\n"
"    'Á': { 0x3: 0x1e, 0x6: 0x1e, },\n"
"    '§': { 0x3: 0x1f, },\n"
"    'Ð': { 0x3: 0x20, 0x6: 0x20, },\n"
"    'Ø': { 0x3: 0x26, 0x6: 0x26, },\n"
"    '°': { 0x3: 0x27, },\n"
"    '¦': { 0x3: 0x2b, },\n"
"    'Æ': { 0x3: 0x2c, 0x6: 0x2c, },\n"
"    '¢': { 0x3: 0x2e, },\n"
"    'Ñ': { 0x3: 0x31, 0x6: 0x31, },\n"
"    'Ç': { 0x3: 0x33, 0x6: 0x33, },\n"
"    'ä': { 0x7: 0x10, 0x2: 0x10, },\n"
"    'å': { 0x7: 0x11, 0x2: 0x11, },\n"
"    'é': { 0x7: 0x12, 0x2: 0x12, },\n"
"    'þ': { 0x7: 0x14, 0x2: 0x14, },\n"
"    'ü': { 0x7: 0x15, 0x2: 0x15, },\n"
"    'ú': { 0x7: 0x16, 0x2: 0x16, },\n"
"    'í': { 0x7: 0x17, 0x2: 0x17, },\n"
"    'ó': { 0x7: 0x18, 0x2: 0x18, },\n"
"    'ö': { 0x7: 0x19, 0x2: 0x19, },\n"
"    'á': { 0x7: 0x1e, 0x2: 0x1e, },\n"
"    'ð': { 0x7: 0x20, 0x2: 0x20, },\n"
"    'ø': { 0x7: 0x26, 0x2: 0x26, },\n"
"    'æ': { 0x7: 0x2c, 0x2: 0x2c, },\n"
"    'ñ': { 0x7: 0x31, 0x2: 0x31, },\n"
"    'ç': { 0x7: 0x33, 0x2: 0x33, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x2b, },\n"
"    '¡': { 0x2: 0x2, },\n"
"    '²': { 0x2: 0x3, },\n"
"    '³': { 0x2: 0x4, },\n"
"    '¤': { 0x2: 0x5, },\n"
"    '€': { 0x2: 0x6, },\n"
"    '¼': { 0x2: 0x7, },\n"
"    '½': { 0x2: 0x8, },\n"
"    '¾': { 0x2: 0x9, },\n"
"    '‘': { 0x2: 0xa, },\n"
"    '’': { 0x2: 0xb, },\n"
"    '¥': { 0x2: 0xc, },\n"
"    '×': { 0x2: 0xd, },\n"
"    '®': { 0x2: 0x13, },\n"
"    '«': { 0x2: 0x1a, },\n"
"    '»': { 0x2: 0x1b, },\n"
"    'ß': { 0x2: 0x1f, },\n"
"    '¶': { 0x2: 0x27, },\n"
"    '¬': { 0x2: 0x2b, },\n"
"    '©': { 0x2: 0x2e, },\n"
"    'µ': { 0x2: 0x32, },\n"
"    '¿': { 0x2: 0x35, },\n"
"  },\n"
"  deadkeys: {\n"
"    'à': [0, ['a', ]],\n"
"    'è': [0, ['e', ]],\n"
"    'ì': [0, ['i', ]],\n"
"    'ò': [0, ['o', ]],\n"
"    'ù': [0, ['u', ]],\n"
"    'À': [0, ['A', ]],\n"
"    'È': [0, ['E', ]],\n"
"    'Ì': [0, ['I', ]],\n"
"    'Ò': [0, ['O', ]],\n"
"    'Ù': [0, ['U', ]],\n"
"    '`': [0, [' ', ]],\n"
"    'â': [1, ['a', ]],\n"
"    'ê': [1, ['e', ]],\n"
"    'î': [1, ['i', ]],\n"
"    'ô': [1, ['o', ]],\n"
"    'û': [1, ['u', ]],\n"
"    'Â': [1, ['A', ]],\n"
"    'Ê': [1, ['E', ]],\n"
"    'Î': [1, ['I', ]],\n"
"    'Ô': [1, ['O', ]],\n"
"    'Û': [1, ['U', ]],\n"
"    '^': [1, [' ', ]],\n"
"    'ã': [2, ['a', ]],\n"
"    'õ': [2, ['o', ]],\n"
"    'ñ': [2, ['n', ]],\n"
"    'Ã': [2, ['A', ]],\n"
"    'Õ': [2, ['O', ]],\n"
"    'Ñ': [2, ['N', ]],\n"
"    '~': [2, [' ', ]],\n"
"    'ä': [3, ['a', ]],\n"
"    'ë': [3, ['e', ]],\n"
"    'ï': [3, ['i', ]],\n"
"    'ö': [3, ['o', ]],\n"
"    'ü': [3, ['u', ]],\n"
"    'ÿ': [3, ['y', ]],\n"
"    'Ä': [3, ['A', ]],\n"
"    'Ë': [3, ['E', ]],\n"
"    'Ï': [3, ['I', ]],\n"
"    'Ö': [3, ['O', ]],\n"
"    'Ü': [3, ['U', ]],\n"
"    '¨': [3, [' ', ]],\n"
"    'á': [4, ['a', ]],\n"
"    'é': [4, ['e', ]],\n"
"    'í': [4, ['i', ]],\n"
"    'ó': [4, ['o', ]],\n"
"    'ú': [4, ['u', ]],\n"
"    'ý': [4, ['y', ]],\n"
"    'Á': [4, ['A', ]],\n"
"    'É': [4, ['E', ]],\n"
"    'Í': [4, ['I', ]],\n"
"    'Ó': [4, ['O', ]],\n"
"    'Ú': [4, ['U', ]],\n"
"    'Ý': [4, ['Y', ]],\n"
"    'ç': [4, ['c', ]],\n"
"    'Ç': [4, ['C', ]],\n"
"    '´': [4, [' ', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0x29, },\n"
"    {0x1: 0x7, },\n"
"    {0x1: 0x29, },\n"
"    {0x3: 0x28, },\n"
"    {0x2: 0x28, },\n"
"  ]\n"
"},\n"
"{\n"
"  klid: 0x00060408,\n"
"  localeName: \"el\",\n"
"  displayName: \"Greek Polytonic\",\n"
"  ctrlRightIsOem8: false,\n"
"  keymap: {\n"
"    '\\x1b': { 0x0: 0x1, 0x1: 0x1, },\n"
"    '1': { 0x0: 0x2, },\n"
"    '2': { 0x0: 0x3, },\n"
"    '3': { 0x0: 0x4, },\n"
"    '4': { 0x0: 0x5, },\n"
"    '5': { 0x0: 0x6, },\n"
"    '6': { 0x0: 0x7, },\n"
"    '7': { 0x0: 0x8, },\n"
"    '8': { 0x0: 0x9, },\n"
"    '9': { 0x0: 0xa, },\n"
"    '0': { 0x0: 0xb, },\n"
"    '\\b': { 0x0: 0xe, 0x1: 0xe, },\n"
"    '\\t': { 0x0: 0xf, 0x1: 0xf, },\n"
"    'ς': { 0x0: 0x11, },\n"
"    'ε': { 0x0: 0x12, 0x5: 0x12, },\n"
"    'ρ': { 0x0: 0x13, 0x5: 0x13, },\n"
"    'τ': { 0x0: 0x14, 0x5: 0x14, },\n"
"    'υ': { 0x0: 0x15, 0x5: 0x15, },\n"
"    'θ': { 0x0: 0x16, 0x5: 0x16, },\n"
"    'ι': { 0x0: 0x17, 0x5: 0x17, },\n"
"    'ο': { 0x0: 0x18, 0x5: 0x18, },\n"
"    'π': { 0x0: 0x19, 0x5: 0x19, },\n"
"    '\\r': { 0x0: 0x1c, 0x1: 0x1c, },\n"
"    'α': { 0x0: 0x1e, 0x5: 0x1e, },\n"
"    'σ': { 0x0: 0x1f, 0x5: 0x1f, },\n"
"    'δ': { 0x0: 0x20, 0x5: 0x20, },\n"
"    'φ': { 0x0: 0x21, 0x5: 0x21, },\n"
"    'γ': { 0x0: 0x22, 0x5: 0x22, },\n"
"    'η': { 0x0: 0x23, 0x5: 0x23, },\n"
"    'ξ': { 0x0: 0x24, 0x5: 0x24, },\n"
"    'κ': { 0x0: 0x25, 0x5: 0x25, },\n"
"    'λ': { 0x0: 0x26, 0x5: 0x26, },\n"
"    'ζ': { 0x0: 0x2c, 0x5: 0x2c, },\n"
"    'χ': { 0x0: 0x2d, 0x5: 0x2d, },\n"
"    'ψ': { 0x0: 0x2e, 0x5: 0x2e, },\n"
"    'ω': { 0x0: 0x2f, 0x5: 0x2f, },\n"
"    'β': { 0x0: 0x30, 0x5: 0x30, },\n"
"    'ν': { 0x0: 0x31, 0x5: 0x31, },\n"
"    'μ': { 0x0: 0x32, 0x5: 0x32, },\n"
"    ',': { 0x0: 0x33, },\n"
"    '.': { 0x0: 0x34, },\n"
"    '*': { 0x0: 0x37, 0x1: 0x9, },\n"
"    ' ': { 0x0: 0x39, 0x1: 0x39, },\n"
"    '-': { 0x0: 0x4a, 0x1: 0x4a, },\n"
"    '+': { 0x0: 0x4e, 0x1: 0x4e, },\n"
"    '<': { 0x0: 0x56, 0x1: 0x33, },\n"
"    '/': { 0x0: 0x35, 0x1: 0x35, },\n"
"    '\\x03': { 0x0: 0x46, 0x1: 0x46, },\n"
"    '!': { 0x1: 0x2, },\n"
"    '@': { 0x1: 0x3, },\n"
"    '#': { 0x1: 0x4, },\n"
"    '$': { 0x1: 0x5, },\n"
"    '%': { 0x1: 0x6, },\n"
"    '^': { 0x1: 0x7, },\n"
"    '&': { 0x1: 0x8, },\n"
"    '(': { 0x1: 0xa, },\n"
"    ')': { 0x1: 0xb, },\n"
"    'Ε': { 0x1: 0x12, 0x4: 0x12, },\n"
"    'Ρ': { 0x1: 0x13, 0x4: 0x13, },\n"
"    'Τ': { 0x1: 0x14, 0x4: 0x14, },\n"
"    'Υ': { 0x1: 0x15, 0x4: 0x15, },\n"
"    'Θ': { 0x1: 0x16, 0x4: 0x16, },\n"
"    'Ι': { 0x1: 0x17, 0x4: 0x17, },\n"
"    'Ο': { 0x1: 0x18, 0x4: 0x18, },\n"
"    'Π': { 0x1: 0x19, 0x4: 0x19, },\n"
"    'Α': { 0x1: 0x1e, 0x4: 0x1e, },\n"
"    'Σ': { 0x1: 0x1f, 0x4: 0x1f, },\n"
"    'Δ': { 0x1: 0x20, 0x4: 0x20, },\n"
"    'Φ': { 0x1: 0x21, 0x4: 0x21, },\n"
"    'Γ': { 0x1: 0x22, 0x4: 0x22, },\n"
"    'Η': { 0x1: 0x23, 0x4: 0x23, },\n"
"    'Ξ': { 0x1: 0x24, 0x4: 0x24, },\n"
"    'Κ': { 0x1: 0x25, 0x4: 0x25, },\n"
"    'Λ': { 0x1: 0x26, 0x4: 0x26, },\n"
"    'Ζ': { 0x1: 0x2c, 0x4: 0x2c, },\n"
"    'Χ': { 0x1: 0x2d, 0x4: 0x2d, },\n"
"    'Ψ': { 0x1: 0x2e, 0x4: 0x2e, },\n"
"    'Ω': { 0x1: 0x2f, 0x4: 0x2f, },\n"
"    'Β': { 0x1: 0x30, 0x4: 0x30, },\n"
"    'Ν': { 0x1: 0x31, 0x4: 0x31, },\n"
"    'Μ': { 0x1: 0x32, 0x4: 0x32, },\n"
"    '>': { 0x1: 0x34, },\n"
"    '\\x1e': { 0x1: 0x7, },\n"
"    '\\x1f': { 0x1: 0xc, },\n"
"    '²': { 0x3: 0x3, },\n"
"    '³': { 0x3: 0x4, },\n"
"    '·': { 0x3: 0x1b, },\n"
"    '\\x7f': { 0x0: 0xe, },\n"
"    '\\x1d': { 0x0: 0x1b, },\n"
"    '\\n': { 0x0: 0x1c, },\n"
"    '\\x1c': { 0x0: 0x28, },\n"
"    'Ϛ': { 0x2: 0x2, },\n"
"    'Ϟ': { 0x2: 0x3, },\n"
"    'Ϡ': { 0x2: 0x4, },\n"
"    '£': { 0x2: 0x5, },\n"
"    '§': { 0x2: 0x6, },\n"
"    '¶': { 0x2: 0x7, },\n"
"    '¤': { 0x2: 0x9, },\n"
"    '¦': { 0x2: 0xa, },\n"
"    '°': { 0x2: 0xb, },\n"
"    '±': { 0x2: 0xc, },\n"
"    '€': { 0x2: 0x12, },\n"
"    '®': { 0x2: 0x13, },\n"
"    '¥': { 0x2: 0x15, },\n"
"    '©': { 0x2: 0x2e, },\n"
"  },\n"
"  deadkeys: {\n"
"    'ᾱ': [0, ['α', ]],\n"
"    'Ᾱ': [0, ['Α', ]],\n"
"    'ῑ': [0, ['ι', ]],\n"
"    'Ῑ': [0, ['Ι', ]],\n"
"    'ῡ': [0, ['υ', ]],\n"
"    'Ῡ': [0, ['Υ', ]],\n"
"    '¯': [0, ['.', ]],\n"
"    '-': [0, [' ', ]],\n"
"    'ἆ': [1, ['α', ]],\n"
"    'Ἆ': [1, ['Α', ]],\n"
"    'ἦ': [1, ['η', ]],\n"
"    'Ἦ': [1, ['Η', ]],\n"
"    'ἶ': [1, ['ι', ]],\n"
"    'Ἶ': [1, ['Ι', ]],\n"
"    'ὖ': [1, ['υ', ]],\n"
"    'ὦ': [1, ['ω', ]],\n"
"    'Ὦ': [1, ['Ω', ]],\n"
"    '῏': [1, ['.', ]],\n"
"    '=': [1, [' ', ]],\n"
"    'ά': [2, ['α', ]],\n"
"    'έ': [2, ['ε', ]],\n"
"    'ή': [2, ['η', ]],\n"
"    'ί': [2, ['ι', ]],\n"
"    'ό': [2, ['ο', ]],\n"
"    'ύ': [2, ['υ', ]],\n"
"    'ώ': [2, ['ω', ]],\n"
"    'Ά': [2, ['Α', ]],\n"
"    'Έ': [2, ['Ε', ]],\n"
"    'Ή': [2, ['Η', ]],\n"
"    'Ί': [2, ['Ι', ]],\n"
"    'Ύ': [2, ['Υ', ]],\n"
"    'Ό': [2, ['Ο', ]],\n"
"    'Ώ': [2, ['Ω', ]],\n"
"    '´': [2, ['.', ]],\n"
"    ';': [2, [' ', ]],\n"
"    'ᾶ': [3, ['α', ]],\n"
"    'ῆ': [3, ['η', ]],\n"
"    'ῖ': [3, ['ι', ]],\n"
"    'ῦ': [3, ['υ', ]],\n"
"    'ῶ': [3, ['ω', ]],\n"
"    '῀': [3, ['.', ]],\n"
"    '[': [3, [' ', ]],\n"
"    'ὰ': [4, ['α', ]],\n"
"    'ὲ': [4, ['ε', ]],\n"
"    'ὴ': [4, ['η', ]],\n"
"    'ὶ': [4, ['ι', ]],\n"
"    'ὸ': [4, ['ο', ]],\n"
"    'ὺ': [4, ['υ', ]],\n"
"    'ὼ': [4, ['ω', ]],\n"
"    'Ὰ': [4, ['Α', ]],\n"
"    'Ὲ': [4, ['Ε', ]],\n"
"    'Ὴ': [4, ['Η', ]],\n"
"    'Ὶ': [4, ['Ι', ]],\n"
"    'Ὺ': [4, ['Υ', ]],\n"
"    'Ὸ': [4, ['Ο', ]],\n"
"    'Ὼ': [4, ['Ω', ]],\n"
"    '`': [4, ['.', ]],\n"
"    ']': [4, [' ', ]],\n"
"    'ά': [5, ['α', ]],\n"
"    'έ': [5, ['ε', ]],\n"
"    'ί': [5, ['ι', ]],\n"
"    'ό': [5, ['ο', ]],\n"
"    'ύ': [5, ['υ', ]],\n"
"    'ώ': [5, ['ω', ]],\n"
"    'ή': [5, ['η', ]],\n"
"    'Ά': [5, ['Α', ]],\n"
"    'Έ': [5, ['Ε', ]],\n"
"    'Ί': [5, ['Ι', ]],\n"
"    'Ό': [5, ['Ο', ]],\n"
"    'Ύ': [5, ['Υ', ]],\n"
"    'Ώ': [5, ['Ω', ]],\n"
"    'Ή': [5, ['Η', ]],\n"
"    '΄': [5, [' ', '.', ]],\n"
"    'ἀ': [6, ['α', ]],\n"
"    'Ἀ': [6, ['Α', ]],\n"
"    'ἐ': [6, ['ε', ]],\n"
"    'Ἐ': [6, ['Ε', ]],\n"
"    'ἠ': [6, ['η', ]],\n"
"    'Ἠ': [6, ['Η', ]],\n"
"    'ἰ': [6, ['ι', ]],\n"
"    'Ἰ': [6, ['Ι', ]],\n"
"    'ὀ': [6, ['ο', ]],\n"
"    'Ὀ': [6, ['Ο', ]],\n"
"    'ὐ': [6, ['υ', ]],\n"
"    'ὠ': [6, ['ω', ]],\n"
"    'Ὠ': [6, ['Ω', ]],\n"
"    'ῤ': [6, ['ρ', ]],\n"
"    '᾿': [6, ['.', ]],\n"
"    '\\'': [6, [' ', ]],\n"
"    'ΐ': [7, ['ι', ]],\n"
"    'ΰ': [7, ['υ', ]],\n"
"    '΅': [7, ['.', ]],\n"
"    '~': [7, [' ', ]],\n"
"    'ἂ': [8, ['α', ]],\n"
"    'Ἂ': [8, ['Α', ]],\n"
"    'ἒ': [8, ['ε', ]],\n"
"    'Ἒ': [8, ['Ε', ]],\n"
"    'ἢ': [8, ['η', ]],\n"
"    'Ἢ': [8, ['Η', ]],\n"
"    'ἲ': [8, ['ι', ]],\n"
"    'Ἲ': [8, ['Ι', ]],\n"
"    'ὂ': [8, ['ο', ]],\n"
"    'Ὂ': [8, ['Ο', ]],\n"
"    'ὒ': [8, ['υ', ]],\n"
"    'ὢ': [8, ['ω', ]],\n"
"    'Ὢ': [8, ['Ω', ]],\n"
"    '῍': [8, ['.', ]],\n"
"    '\\\\': [8, [' ', ]],\n"
"    'ἄ': [9, ['α', ]],\n"
"    'Ἄ': [9, ['Α', ]],\n"
"    'ἔ': [9, ['ε', ]],\n"
"    'Ἔ': [9, ['Ε', ]],\n"
"    'ἤ': [9, ['η', ]],\n"
"    'Ἤ': [9, ['Η', ]],\n"
"    'ἴ': [9, ['ι', ]],\n"
"    'Ἴ': [9, ['Ι', ]],\n"
"    'ὄ': [9, ['ο', ]],\n"
"    'Ὄ': [9, ['Ο', ]],\n"
"    'ὔ': [9, ['υ', ]],\n"
"    'ὤ': [9, ['ω', ]],\n"
"    'Ὤ': [9, ['Ω', ]],\n"
"    '῎': [9, ['.', ]],\n"
"    '/': [9, [' ', ]],\n"
"    'ᾰ': [10, ['α', ]],\n"
"    'Ᾰ': [10, ['Α', ]],\n"
"    'ῐ': [10, ['ι', ]],\n"
"    'Ῐ': [10, ['Ι', ]],\n"
"    'ῠ': [10, ['υ', ]],\n"
"    'Ῠ': [10, ['Υ', ]],\n"
"    '˘': [10, ['.', ]],\n"
"    '_': [10, [' ', ]],\n"
"    'ἇ': [11, ['α', ]],\n"
"    'Ἇ': [11, ['Α', ]],\n"
"    'ἧ': [11, ['η', ]],\n"
"    'Ἧ': [11, ['Η', ]],\n"
"    'ἷ': [11, ['ι', ]],\n"
"    'Ἷ': [11, ['Ι', ]],\n"
"    'ὗ': [11, ['υ', ]],\n"
"    'Ὗ': [11, ['Υ', ]],\n"
"    'ὧ': [11, ['ω', ]],\n"
"    'Ὧ': [11, ['Ω', ]],\n"
"    '῟': [11, ['.', ]],\n"
"    '+': [11, [' ', ]],\n"
"    'ϊ': [12, ['ι', ]],\n"
"    'ϋ': [12, ['υ', ]],\n"
"    'Ϊ': [12, ['Ι', ]],\n"
"    'Ϋ': [12, ['Υ', ]],\n"
"    '¨': [12, [' ', '.', ]],\n"
"    ':': [12, [' ', ]],\n"
"    'ΐ': [13, ['ι', ]],\n"
"    'ΰ': [13, ['υ', ]],\n"
"    '΅': [13, [' ', '.', ]],\n"
"    'ᾳ': [14, ['α', ]],\n"
"    'ᾼ': [14, ['Α', ]],\n"
"    'ῃ': [14, ['η', ]],\n"
"    'ῌ': [14, ['Η', ]],\n"
"    'ῳ': [14, ['ω', ]],\n"
"    'ῼ': [14, ['Ω', ]],\n"
"    'ι': [14, ['.', ]],\n"
"    '{': [14, [' ', ]],\n"
"    '·': [15, ['.', ]],\n"
"    '}': [15, [' ', ]],\n"
"    'ἁ': [16, ['α', ]],\n"
"    'Ἁ': [16, ['Α', ]],\n"
"    'ἑ': [16, ['ε', ]],\n"
"    'Ἑ': [16, ['Ε', ]],\n"
"    'ἡ': [16, ['η', ]],\n"
"    'Ἡ': [16, ['Η', ]],\n"
"    'ἱ': [16, ['ι', ]],\n"
"    'Ἱ': [16, ['Ι', ]],\n"
"    'ὁ': [16, ['ο', ]],\n"
"    'Ὁ': [16, ['Ο', ]],\n"
"    'ὑ': [16, ['υ', ]],\n"
"    'Ὑ': [16, ['Υ', ]],\n"
"    'ὡ': [16, ['ω', ]],\n"
"    'Ὡ': [16, ['Ω', ]],\n"
"    'ῥ': [16, ['ρ', ]],\n"
"    'Ῥ': [16, ['Ρ', ]],\n"
"    '῾': [16, ['.', ]],\n"
"    '\"': [16, [' ', ]],\n"
"    'ῒ': [17, ['ι', ]],\n"
"    'ῢ': [17, ['υ', ]],\n"
"    '῭': [17, ['.', ]],\n"
"    '`': [17, [' ', ]],\n"
"    'ἃ': [18, ['α', ]],\n"
"    'Ἃ': [18, ['Α', ]],\n"
"    'ἓ': [18, ['ε', ]],\n"
"    'Ἓ': [18, ['Ε', ]],\n"
"    'ἣ': [18, ['η', ]],\n"
"    'Ἣ': [18, ['Η', ]],\n"
"    'ἳ': [18, ['ι', ]],\n"
"    'Ἳ': [18, ['Ι', ]],\n"
"    'ὃ': [18, ['ο', ]],\n"
"    'Ὃ': [18, ['Ο', ]],\n"
"    'ὓ': [18, ['υ', ]],\n"
"    'Ὓ': [18, ['Υ', ]],\n"
"    'ὣ': [18, ['ω', ]],\n"
"    'Ὣ': [18, ['Ω', ]],\n"
"    '῝': [18, ['.', ]],\n"
"    '|': [18, [' ', ]],\n"
"    'ἅ': [19, ['α', ]],\n"
"    'Ἅ': [19, ['Α', ]],\n"
"    'ἕ': [19, ['ε', ]],\n"
"    'Ἕ': [19, ['Ε', ]],\n"
"    'ἥ': [19, ['η', ]],\n"
"    'Ἥ': [19, ['Η', ]],\n"
"    'ἵ': [19, ['ι', ]],\n"
"    'Ἵ': [19, ['Ι', ]],\n"
"    'ὅ': [19, ['ο', ]],\n"
"    'Ὅ': [19, ['Ο', ]],\n"
"    'ὕ': [19, ['υ', ]],\n"
"    'Ὕ': [19, ['Υ', ]],\n"
"    'ὥ': [19, ['ω', ]],\n"
"    'Ὥ': [19, ['Ω', ]],\n"
"    '῞': [19, ['.', ]],\n"
"    '?': [19, [' ', ]],\n"
"    'ᾇ': [20, ['α', ]],\n"
"    'ᾏ': [20, ['Α', ]],\n"
"    'ᾗ': [20, ['η', ]],\n"
"    'ᾟ': [20, ['Η', ]],\n"
"    'ᾧ': [20, ['ω', ]],\n"
"    'ᾯ': [20, ['Ω', ]],\n"
"    'ᾁ': [21, ['α', ]],\n"
"    'ᾉ': [21, ['Α', ]],\n"
"    'ᾑ': [21, ['η', ]],\n"
"    'ᾙ': [21, ['Η', ]],\n"
"    'ᾡ': [21, ['ω', ]],\n"
"    'ᾩ': [21, ['Ω', ]],\n"
"    'ᾃ': [22, ['α', ]],\n"
"    'ᾋ': [22, ['Α', ]],\n"
"    'ᾓ': [22, ['η', ]],\n"
"    'ᾛ': [22, ['Η', ]],\n"
"    'ᾣ': [22, ['ω', ]],\n"
"    'ᾫ': [22, ['Ω', ]],\n"
"    'ᾅ': [23, ['α', ]],\n"
"    'ᾍ': [23, ['Α', ]],\n"
"    'ᾕ': [23, ['η', ]],\n"
"    'ᾝ': [23, ['Η', ]],\n"
"    'ᾥ': [23, ['ω', ]],\n"
"    'ᾭ': [23, ['Ω', ]],\n"
"    'ᾆ': [24, ['α', ]],\n"
"    'ᾎ': [24, ['Α', ]],\n"
"    'ᾖ': [24, ['η', ]],\n"
"    'ᾞ': [24, ['Η', ]],\n"
"    'ᾦ': [24, ['ω', ]],\n"
"    'ᾮ': [24, ['Ω', ]],\n"
"    '½': [24, [' ', ]],\n"
"    'ᾴ': [25, ['α', ]],\n"
"    'ῄ': [25, ['η', ]],\n"
"    'ῴ': [25, ['ω', ]],\n"
"    'ᾷ': [26, ['α', ]],\n"
"    'ῇ': [26, ['η', ]],\n"
"    'ῷ': [26, ['ω', ]],\n"
"    '«': [26, [' ', ]],\n"
"    'ᾲ': [27, ['α', ]],\n"
"    'ῂ': [27, ['η', ]],\n"
"    'ῲ': [27, ['ω', ]],\n"
"    '»': [27, [' ', ]],\n"
"    'ᾀ': [28, ['α', ]],\n"
"    'ᾈ': [28, ['Α', ]],\n"
"    'ᾐ': [28, ['η', ]],\n"
"    'ᾘ': [28, ['Η', ]],\n"
"    'ᾠ': [28, ['ω', ]],\n"
"    'ᾨ': [28, ['Ω', ]],\n"
"    'ῗ': [29, ['ι', ]],\n"
"    'ῧ': [29, ['υ', ]],\n"
"    '῁': [29, [' ', '.', ]],\n"
"    'ᾂ': [30, ['α', ]],\n"
"    'ᾊ': [30, ['Α', ]],\n"
"    'ᾒ': [30, ['η', ]],\n"
"    'ᾚ': [30, ['Η', ]],\n"
"    'ᾢ': [30, ['ω', ]],\n"
"    'ᾪ': [30, ['Ω', ]],\n"
"    '¬': [30, [' ', ]],\n"
"    'ᾄ': [31, ['α', ]],\n"
"    'ᾌ': [31, ['Α', ]],\n"
"    'ᾔ': [31, ['η', ]],\n"
"    'ᾜ': [31, ['Η', ]],\n"
"    'ᾤ': [31, ['ω', ]],\n"
"    'ᾬ': [31, ['Ω', ]],\n"
"  },\n"
"  accents: [\n"
"    {0x0: 0xc, },\n"
"    {0x0: 0xd, },\n"
"    {0x0: 0x10, },\n"
"    {0x0: 0x1a, },\n"
"    {0x0: 0x1b, },\n"
"    {0x0: 0x27, },\n"
"    {0x0: 0x28, },\n"
"    {0x0: 0x29, },\n"
"    {0x0: 0x2b, },\n"
"    {0x0: 0x35, },\n"
"    {0x1: 0xc, },\n"
"    {0x1: 0xd, },\n"
"    {0x1: 0x10, },\n"
"    {0x1: 0x11, 0x2: 0x27, },\n"
"    {0x1: 0x1a, },\n"
"    {0x1: 0x1b, },\n"
"    {0x1: 0x28, },\n"
"    {0x1: 0x29, },\n"
"    {0x1: 0x2b, },\n"
"    {0x1: 0x35, },\n"
"    {0x3: 0xd, },\n"
"    {0x3: 0x28, },\n"
"    {0x3: 0x2b, },\n"
"    {0x3: 0x35, },\n"
"    {0x2: 0xd, },\n"
"    {0x2: 0x10, },\n"
"    {0x2: 0x1a, },\n"
"    {0x2: 0x1b, },\n"
"    {0x2: 0x28, },\n"
"    {0x2: 0x29, },\n"
"    {0x2: 0x2b, },\n"
"    {0x2: 0x35, },\n"
"  ]\n"
"},\n"
"];\n"
"\n"
"const actionLayout = {\n"
"  \"ContextMenu\": 0x15d,\n"
"  \"BrowserBack\": 0x16a,\n"
"  \"BrowserFavorites\": 0x166,\n"
"  \"BrowserForward\": 0x169,\n"
"  \"BrowserHome\": 0x132,\n"
"  \"BrowserRefresh\": 0x167,\n"
"  \"BrowserSearch\": 0x165,\n"
"  \"BrowserStop\": 0x168,\n"
"  \"Clear\": 0x59,\n"
"  \"CodeInput\": 0x62,\n"
"  \"Delete\": 0x153,\n"
"  \"ArrowDown\": 0x150,\n"
"  \"End\": 0x14f,\n"
"  \"F1\": 0x3b,\n"
"  \"F2\": 0x3c,\n"
"  \"F3\": 0x3d,\n"
"  \"F4\": 0x3e,\n"
"  \"F5\": 0x3f,\n"
"  \"F6\": 0x40,\n"
"  \"F7\": 0x41,\n"
"  \"F8\": 0x42,\n"
"  \"F9\": 0x43,\n"
"  \"F10\": 0x44,\n"
"  \"F11\": 0x57,\n"
"  \"F12\": 0x58,\n"
"  \"F13\": 0x64,\n"
"  \"F14\": 0x65,\n"
"  \"F15\": 0x66,\n"
"  \"F16\": 0x67,\n"
"  \"F17\": 0x68,\n"
"  \"F18\": 0x69,\n"
"  \"F19\": 0x6a,\n"
"  \"F20\": 0x6b,\n"
"  \"F21\": 0x6c,\n"
"  \"F22\": 0x6d,\n"
"  \"F23\": 0x6e,\n"
"  \"F24\": 0x76,\n"
"  \"Help\": 0x63,\n"
"  \"Home\": 0x147,\n"
"  \"Insert\": 0x152,\n"
"  \"LaunchApp1\": 0x16b,\n"
"  \"LaunchApp2\": 0x121,\n"
"  \"LaunchMail\": 0x16c,\n"
"  \"LaunchMediaPlayer\": 0x16d,\n"
"  \"ArrowLeft\": 0x14b,\n"
"  \"MediaTrackNext\": 0x119,\n"
"  \"MediaPlayPause\": 0x122,\n"
"  \"MediaTrackPrevious\": 0x110,\n"
"  \"MediaStop\": 0x124,\n"
"  \"PageDown\": 0x151,\n"
"  \"PageUp\": 0x149,\n"
"  \"ArrowRight\": 0x14d,\n"
"  \"ScrollLock\": 0x46,\n"
"  \"Standby\": 0x15f,\n"
"  \"PrintScreen\": 0x137,\n"
"  \"ArrowUp\": 0x148,\n"
"  \"AudioVolumeDown\": 0x12e,\n"
"  \"AudioVolumeMute\": 0x120,\n"
"  \"AudioVolumeUp\": 0x130,\n"
"};\n"
"\n"
"try {\n"
"    module.exports.layouts = layouts;\n"
"    module.exports.actionLayout = actionLayout;\n"
"}\n"
"catch(e) {\n"
"    // module not found\n"
"}\n"
"\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/reversed_layouts.js") == 0) {
        if (size) *size = strlen(rdp_reversed_layouts_js);
        return rdp_reversed_layouts_js;
    }
const char *rdp_scancodes_js =
"\"use strict\";\n"
"\n"
"// https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values\n"
"// https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/code\n"
"// 0xE0 -> 0x0100\n"
"// /!\\ rotate digit code\n"
"// Note: special code has a same value that code (ControlLeft, ArrowDown, etc)\n"
"//\n"
"// test:\n"
"// https://yari-demos.prod.mdn.mozit.cloud/en-US/docs/Web/API/KeyboardEvent/code/_sample_.Exercising_KeyboardEvent.html\n"
"// https://w3c.github.io/uievents/tools/key-event-viewer.html\n"
"\n"
"/// \\return Number | undefined\n"
"const keycodeToSingleScancode = function(code) {\n"
"    switch (code)\n"
"    {\n"
"    case \"KeyA\": return 0x1E;\n"
"    case \"KeyB\": return 0x30;\n"
"    case \"KeyC\": return 0x2E;\n"
"    case \"KeyD\": return 0x20;\n"
"    case \"KeyE\": return 0x12;\n"
"    case \"KeyF\": return 0x21;\n"
"    case \"KeyG\": return 0x22;\n"
"    case \"KeyH\": return 0x23;\n"
"    case \"KeyI\": return 0x17;\n"
"    case \"KeyJ\": return 0x24;\n"
"    case \"KeyK\": return 0x25;\n"
"    case \"KeyL\": return 0x26;\n"
"    case \"KeyM\": return 0x32;\n"
"    case \"KeyN\": return 0x31;\n"
"    case \"KeyO\": return 0x18;\n"
"    case \"KeyP\": return 0x19;\n"
"    case \"KeyQ\": return 0x10;\n"
"    case \"KeyR\": return 0x13;\n"
"    case \"KeyS\": return 0x1F;\n"
"    case \"KeyT\": return 0x14;\n"
"    case \"KeyU\": return 0x16;\n"
"    case \"KeyV\": return 0x2F;\n"
"    case \"KeyW\": return 0x11;\n"
"    case \"KeyX\": return 0x2D;\n"
"    case \"KeyY\": return 0x15;\n"
"    case \"KeyZ\": return 0x2C;\n"
"\n"
"    case \"Comma\": return 0x33;\n"
"    case \"Convert\": return 0x79;\n"
"    case \"Slash\": return 0x35;\n"
"    case \"BracketLeft\": return 0x1A;\n"
"    case \"BracketRight\": return 0x1B;\n"
"    case \"Backslash\": return 0x2B;\n"
"    case \"Quote\": return 0x28;\n"
"    case \"Semicolon\": return 0x27;\n"
"    case \"Period\": return 0x34;\n"
"\n"
"    case \"Space\": return 0x39;\n"
"    case \"Tab\": return 0x0F;\n"
"    case \"PageDown\": return 0x151;\n"
"    case \"PageUp\": return 0x149;\n"
"    case \"Home\": return 0x147;\n"
"    case \"End\": return 0x14F;\n"
"    case \"Delete\": return 0x153;\n"
"    case \"Insert\": return 0x152;\n"
"    case \"Enter\": return 0x1C;\n"
"    case \"Escape\": return 0x01;\n"
"\n"
"    case \"Backquote\": return 0x29;\n"
"    case \"Digit0\": return 0x0B;\n"
"    case \"Digit1\": return 0x02;\n"
"    case \"Digit2\": return 0x03;\n"
"    case \"Digit3\": return 0x04;\n"
"    case \"Digit4\": return 0x05;\n"
"    case \"Digit5\": return 0x06;\n"
"    case \"Digit6\": return 0x07;\n"
"    case \"Digit7\": return 0x08;\n"
"    case \"Digit8\": return 0x09;\n"
"    case \"Digit9\": return 0x0A;\n"
"    case \"Minus\": return 0x0B;\n"
"    case \"Equal\": return 0x0C;\n"
"    case \"Backspace\": return 0x0E;\n"
"\n"
"    case \"ArrowDown\": return 0x150;\n"
"    case \"ArrowLeft\": return 0x14B;\n"
"    case \"ArrowRight\": return 0x14D;\n"
"    case \"ArrowUp\": return 0x148;\n"
"\n"
"    case \"CapsLock\": return 0x3A;\n"
"    case \"ContextMenu\": return 0x15D;\n"
"    case \"ControlLeft\": return 0x1D;\n"
"    case \"ControlRight\": return 0x11D;\n"
"    case \"AltGraph\": return 0x138;\n"
"    case \"AltLeft\": return 0x38;\n"
"    case \"AltRight\": return 0x138;\n"
"    case \"OSLeft\": return 0x15B;\n"
"    case \"OSRight\": return 0x15C;\n"
"    case \"MetaLeft\": return 0x15B;\n"
"    case \"MetaRight\": return 0x15C;\n"
"    case \"ShiftLeft\": return 0x2A;\n"
"    case \"ShiftRight\": return 0x36;\n"
"    case \"KanaMode\": return 0x70;\n"
"\n"
"    case \"NumLock\": return 0x45;\n"
"    case \"Numpad0\": return 0x52;\n"
"    case \"Numpad1\": return 0x4F;\n"
"    case \"Numpad2\": return 0x50;\n"
"    case \"Numpad3\": return 0x51;\n"
"    case \"Numpad4\": return 0x4B;\n"
"    case \"Numpad5\": return 0x4C;\n"
"    case \"NumpadClear\": return 0x4C;\n"
"    case \"Numpad6\": return 0x4D;\n"
"    case \"Numpad7\": return 0x47;\n"
"    case \"Numpad8\": return 0x48;\n"
"    case \"Numpad9\": return 0x49;\n"
"    case \"NumpadAdd\": return 0x4E;\n"
"    case \"NumpadComma\": return 0x7E;\n"
"    case \"NumpadEnter\": return 0x11C;\n"
"    case \"NumpadEqual\": return 0x59;\n"
"    case \"NumpadDivide\": return 0x135;\n"
"    case \"NumpadDecimal\": return 0x53;\n"
"    case \"NumpadMultiply\": return 0x37;\n"
"    case \"NumpadSubtract\": return 0x4A;\n"
"\n"
"    case \"F1\": return 0x3B;\n"
"    case \"F2\": return 0x3C;\n"
"    case \"F3\": return 0x3D;\n"
"    case \"F4\": return 0x3E;\n"
"    case \"F5\": return 0x3F;\n"
"    case \"F6\": return 0x40;\n"
"    case \"F7\": return 0x41;\n"
"    case \"F8\": return 0x42;\n"
"    case \"F9\": return 0x43;\n"
"    case \"F10\": return 0x44;\n"
"    case \"F11\": return 0x57;\n"
"    case \"F12\": return 0x58;\n"
"    case \"F13\": return 0x64;\n"
"    case \"F14\": return 0x65;\n"
"    case \"F15\": return 0x66;\n"
"    case \"F16\": return 0x67;\n"
"    case \"F17\": return 0x68;\n"
"    case \"F18\": return 0x69;\n"
"    case \"F19\": return 0x6A;\n"
"    case \"F20\": return 0x6B;\n"
"    case \"F21\": return 0x6C;\n"
"    case \"F22\": return 0x6D;\n"
"    case \"F23\": return 0x6E;\n"
"    case \"F24\": return 0x76;\n"
"\n"
"    case \"PrintScreen\": return 0x37;\n"
"\n"
"    case \"ScrollLock\": return 0x46;\n"
"\n"
"    case \"Paste\": return 0x10A;\n"
"    case \"Copy\": return 0x118;\n"
"    case \"Cut\": return 0x117;\n"
"\n"
"    case \"AudioVolumeDown\": return 0x12E;\n"
"    case \"AudioVolumeMute\": return 0x120;\n"
"    case \"AudioVolumeUp\": return 0x130;\n"
"    case \"BrowserBack\": return 0x16A;\n"
"    case \"BrowserFavorites\": return 0x166;\n"
"    case \"BrowserForward\": return 0x169;\n"
"    case \"BrowserHome\": return 0x132;\n"
"    case \"BrowserRefresh\": return 0x167;\n"
"    case \"BrowserSearch\": return 0x165;\n"
"    case \"BrowserStop\": return 0x168;\n"
"    case \"LaunchApp1\": return 0x16B;\n"
"    case \"LaunchApp2\": return 0x121;\n"
"    case \"LaunchMail\": return 0x16C;\n"
"    case \"LaunchMediaPlayer\": return 0x16D;\n"
"    case \"MediaPlayPause\": return 0x122;\n"
"    case \"MediaStop\": return 0x124;\n"
"    case \"MediaTrackNext\": return 0x119;\n"
"    case \"MediaTrackPrevious\": return 0x110;\n"
"    case \"VolumeDown\": return 0x12E;\n"
"    case \"VolumeMute\": return 0x120;\n"
"    case \"VolumeUp\": return 0x130;\n"
"\n"
"    case \"Eject\": return 0x12C;\n"
"    case \"Help\": return 0x63;\n"
"    case \"IntlBackslash\": return 0x56;\n"
"    case \"IntlRo\": return 0x73;\n"
"    case \"IntlYen\": return 0x7D;\n"
"    // case \"Lang1\": return 0x1F2; /* key with Korean keyboard layout */\n"
"    // case \"Lang2\": return 0x1F1; /* key with Korean keyboard layout */\n"
"    case \"Lang1\": return 0x72;\n"
"    case \"Lang2\": return 0x71;\n"
"    case \"NonConvert\": return 0x7B;\n"
"    case \"Power\": return 0x15E;\n"
"    case \"Undo\": return 0x108;\n"
"    }\n"
"};\n"
"\n"
"/// \\return Number | undefined\n"
"const numpadCodeToScancode = function(key) {\n"
"    switch (key)\n"
"    {\n"
"    case \"NumpadMultiply\":  /*case \"*\": case \"Multiply\":    */  return 0x37;\n"
"    case \"Numpad7\":         /*case \"7\": case \"Home\":        */  return 0x47;\n"
"    case \"Numpad8\":         /*case \"8\": case \"ArrowUp\":     */  return 0x48;\n"
"    case \"Numpad9\":         /*case \"9\": case \"PageUp\":      */  return 0x49;\n"
"    case \"NumpadSubtract\":  /*case \"-\": case \"Subtract\":    */  return 0x4A;\n"
"    case \"Numpad4\":         /*case \"4\": case \"ArrowLeft\":   */  return 0x4B;\n"
"    case \"Numpad5\":         /*case \"5\": case \"Unidentified\":*/  return 0x4C;\n"
"    case \"NumpadClear\":                                         return 0x4C;\n"
"    case \"Numpad6\":         /*case \"6\": case \"AltRight\":    */  return 0x4D;\n"
"    case \"NumpadAdd\":       /*case \"+\": case \"Add\":         */  return 0x4E;\n"
"    case \"Numpad1\":         /*case \"1\": case \"End\":         */  return 0x4F;\n"
"    case \"Numpad2\":         /*case \"2\": case \"ArrowDown\":   */  return 0x50;\n"
"    case \"Numpad3\":         /*case \"3\": case \"PageDown\":    */  return 0x51;\n"
"    case \"Numpad0\":         /*case \"0\": case \"Insert\":      */  return 0x52;\n"
"    case \"NumpadDecimal\":   /*case \".\": case \"Delete\":      */  return 0x53;\n"
"    case \"NumpadEqual\":     /*case \"=\":                     */  return 0x59;\n"
"    case \"NumpadComma\":     /*case \",\": case \"Separator\":   */  return 0x7E;\n"
"    case \"NumpadEnter\":     /*case \"Enter\":                 */  return 0x11C;\n"
"    case \"NumpadDivide\":    /*case \"/\": case \"Divide\":      */  return 0x135;\n"
"    case \"NumLock\":         /*                              */  return 0x45;\n"
"    }\n"
"};\n"
"\n"
"/// \\brief convert keycode to scancodes\n"
"/// \\return Array[Number] | undefined\n"
"const codeToScancodes = function(code, flag) {\n"
"    const scancode = keycodeToSingleScancode(code);\n"
"    if (scancode) return [scancode | flag];\n"
"    if (code === \"Pause\") return [0x21D | flag, 0x45 | flag];\n"
"};\n"
"\n"
"\n"
"// reverse keylayout mask (see tools/gen_reversed_keymap.py)\n"
"const ShiftMod    = 1 << 0;\n"
"const AltGrMod    = 1 << 1;\n"
"const CapsLockMod = 1 << 2;\n"
"const CtrlMod     = 1 << 3;\n"
"const AltMod      = 1 << 4;\n"
"const OEM8Mod     = 1 << 5;\n"
"const KanaMod     = 1 << 6;\n"
"const KanaLockMod = 1 << 7;\n"
"const NumLockMod  = 1 << 8;\n"
"\n"
"// extra flags\n"
"const RightShiftMod = 1 << 9;\n"
"const RightCtrlMod  = 1 << 10;\n"
"\n"
"// Control scancodes\n"
"const LShiftSC   = 0x2A;\n"
"const RShiftSC   = 0x36;\n"
"const LCtrlSC    = 0x1D;\n"
"const RCtrlSC    = 0x11D;\n"
"const AltSC      = 0x38;\n"
"const AltGrSC    = 0x138;\n"
"const LMetaSC    = 0x15B;\n"
"const RMetaSC    = 0x15C;\n"
"const CapsLockSC = 0x3A;\n"
"const NumLockSC  = 0x45;\n"
"\n"
"// key flags\n"
"const KeyRelease = 0x8000;\n"
"const KeyAcquire = 0;\n"
"\n"
"const SyncFlags = Object.freeze({\n"
"    NoSync:    0,\n"
"    // rdp lock flags\n"
"    ScrollLock: 0x01,\n"
"    NumLock:    0x02,\n"
"    CapsLock:   0x04,\n"
"    KanaLock:   0x08,\n"
"    // control scancodes\n"
"    ControlLeft:  0x0010,\n"
"    ControlRight: 0x0020,\n"
"    ShiftLeft:    0x0040,\n"
"    ShiftRight:   0x0080,\n"
"    AltLeft:      0x0100,\n"
"    AltRight:     0x0200,\n"
"    OSLeft:       0x0400,\n"
"    OSRight:      0x0800,\n"
"    Kana:         0x1000,\n"
"});\n"
"\n"
"const ScancodeByMod = Object.freeze({\n"
"    ControlLeft:  LCtrlSC,\n"
"    ControlRight: RCtrlSC,\n"
"    ShiftLeft:    LShiftSC,\n"
"    ShiftRight:   RShiftSC,\n"
"    AltLeft:      AltSC,\n"
"    AltRight:     AltGrSC,\n"
"    OSLeft:       LMetaSC,\n"
"    OSRight:      RMetaSC,\n"
"    Kana:         0x70,\n"
"});\n"
"\n"
"\n"
"const emptyReversedLayout = {\n"
"    klid: 0,\n"
"    localeName: \"NoKeyboard\",\n"
"    displayName: \"NoKeyboard\",\n"
"    ctrlRightIsOem8: false,\n"
"    keymap: {},\n"
"    actions: {},\n"
"    deadkeys: {},\n"
"    accents: [],\n"
"};\n"
"\n"
"const remappingModByLeftMods = {\n"
"    OS:      'OSLeft',\n"
"    Meta:    'OSLeft',\n"
"    Shift:   'ShiftLeft',\n"
"    Control: 'ControlLeft',\n"
"};\n"
"const remappingModByRightMods = {\n"
"    OS:      'OSRight',\n"
"    Meta:    'OSRight',\n"
"    Shift:   'ShiftRight',\n"
"    Control: 'ControlRight',\n"
"};\n"
"// { code : { key: newcode } }\n"
"const remappingCodeByKeys = {\n"
"    OSLeft: remappingModByLeftMods,\n"
"    MetaLeft: remappingModByLeftMods,\n"
"    ShiftLeft: remappingModByLeftMods,\n"
"    ControlLeft: remappingModByLeftMods,\n"
"    OSRight: remappingModByRightMods,\n"
"    MetaRight: remappingModByRightMods,\n"
"    ShiftRight: remappingModByRightMods,\n"
"    ControlRight: remappingModByRightMods,\n"
"};\n"
"\n"
"\n"
"/// \\return scancodes\n"
"const scancodesForSynchronizedMods = function(syncFlags) {\n"
"    const accu = [];\n"
"\n"
"    accu.push(LShiftSC | ((syncFlags & SyncFlags.ShiftLeft)    ? KeyAcquire : KeyRelease));\n"
"    accu.push(RShiftSC | ((syncFlags & SyncFlags.ShiftRight)   ? KeyAcquire : KeyRelease));\n"
"    accu.push(LCtrlSC  | ((syncFlags & SyncFlags.ControlLeft)  ? KeyAcquire : KeyRelease));\n"
"    accu.push(RCtrlSC  | ((syncFlags & SyncFlags.ControlRight) ? KeyAcquire : KeyRelease));\n"
"    accu.push(AltSC    | ((syncFlags & SyncFlags.AltLeft)      ? KeyAcquire : KeyRelease));\n"
"    accu.push(AltGrSC  | ((syncFlags & SyncFlags.AltRight)     ? KeyAcquire : KeyRelease));\n"
"    accu.push(LMetaSC  | ((syncFlags & SyncFlags.OSLeft)       ? KeyAcquire : KeyRelease));\n"
"    accu.push(RMetaSC  | ((syncFlags & SyncFlags.OSRight)      ? KeyAcquire : KeyRelease));\n"
"    // accu.push(KanaSC   | ((syncFlags & SyncFlags.Kana)         ? KeyAcquire : KeyRelease));\n"
"\n"
"    return accu;\n"
"};\n"
"\n"
"const toHumanReadableMods = function(mods) {\n"
"    return `ShiftLeft: ${(mods & ShiftMod) ? '1' : '0'}\n"
"ShiftRight: ${(mods & RightShiftMod) ? '1' : '0'}\n"
"CtrlLeft: ${(mods & CtrlMod) ? '1' : '0'}\n"
"CtrlRight: ${(mods & RightCtrlMod) ? '1' : '0'}\n"
"Alt: ${(mods & AltMod) ? '1' : '0'}\n"
"AltGr: ${(mods & AltGrMod) ? '1' : '0'}\n"
"OEM8: ${(mods & OEM8Mod) ? '1' : '0'}\n"
"Kana: ${(mods & KanaMod) ? '1' : '0'}\n"
"CapsLock: ${(mods & CapsLockMod) ? '1' : '0'}\n"
"NumLock: ${(mods & NumLockMod) ? '1' : '0'}\n"
"KanaLock: ${(mods & KanaLockMod) ? '1' : '0'}`;\n"
"};\n"
"\n"
"// Keyboard behavior\n"
"//\n"
"// Windows: ctrl+alt = altgr\n"
"//\n"
"//                                | Windows | Linux\n"
"//  Numpad8 + Verrnum off         |    Up   |   Up\n"
"//  Numpad8 + Verrnum off + Shift |    Up   |   8\n"
"//  Numpad8 + Verrnum on          |    8    |   8\n"
"//  Numpad8 + Verrnum on  + Shift |    Up   |   Up\n"
"//\n"
"//  Digit1 + CapsLock off         |    &    |   &   (fr)\n"
"//  Digit1 + CapsLock on          |    1    |   &   (fr)\n"
"//  Digit1 + CapsLock off + Shift |    1    |   1   (fr)\n"
"//  Digit1 + CapsLock on  + Shift |    &    |   1   (fr)\n"
"\n"
"\n"
"class ReversedKeymap\n"
"{\n"
"    // _virtualModFlags:\n"
"    //   - contains left shift (for right and left shift), altgr and oem8\n"
"    //   - ctrl+alt = altgr when _altGrIsCtrlAndAlt\n"
"    //   - eom8 when _rctrlIsOem8 && (_modFlags & RightCtrlMod)\n"
"    // _modFlags: all controls\n"
"\n"
"    constructor(reversedLayout) {\n"
"        this._modFlags = 0;\n"
"        this._virtualModFlags = 0;\n"
"        this._altGrIsCtrlAndAlt = true;\n"
"        this.layout = reversedLayout || emptyReversedLayout;\n"
"    }\n"
"\n"
"    // states for test\n"
"    getModFlags() { return this._modFlags; }\n"
"    getVirtualModFlags() { return this._virtualModFlags; }\n"
"\n"
"    get altGrIsCtrlAndAlt() {\n"
"        return this._altGrIsCtrlAndAlt;\n"
"    }\n"
"\n"
"    set altGrIsCtrlAndAlt(altGrIsCtrlAndAlt) {\n"
"        this._altGrIsCtrlAndAlt = altGrIsCtrlAndAlt;\n"
"        this._updateVirtualMod();\n"
"    }\n"
"\n"
"    get layout() {\n"
"        return this._layout;\n"
"    }\n"
"\n"
"    set layout(reversedLayout) {\n"
"        this._layout = reversedLayout;\n"
"        this._keymap = reversedLayout.keymap;\n"
"        this._deadKeymap = reversedLayout.deadkeys;\n"
"        this._accentKeymap = reversedLayout.accents;\n"
"        this._rctrlIsOem8 = reversedLayout.ctrlRightIsOem8;\n"
"        this._updateVirtualMod();\n"
"    }\n"
"\n"
"    sync(syncFlags) {\n"
"        let modFlags = 0;\n"
"\n"
"        modFlags |= (syncFlags & SyncFlags.ShiftLeft) ? ShiftMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.ShiftRight) ? RightShiftMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.ControlLeft) ? CtrlMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.ControlRight) ? RightCtrlMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.AltLeft) ? AltMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.AltRight) ? AltGrMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.CapsLock) ? CapsLockMod : 0;\n"
"        modFlags |= (syncFlags & SyncFlags.NumLock) ? NumLockMod : 0;\n"
"        // modFlags |= (syncFlags & SyncFlags.KanaLock) ? KanaLockMod : 0;\n"
"        // modFlags |= (syncFlags & SyncFlags.Kana) ? KanaMod : 0;\n"
"        // ignore ScrollLock value\n"
"\n"
"        this._modFlags = modFlags;\n"
"\n"
"        this._updateVirtualMod();\n"
"    }\n"
"\n"
"    keyUp(key, code) {\n"
"        return this.toScancodesAndFlags(key, code, KeyRelease);\n"
"    }\n"
"\n"
"    keyDown(key, code) {\n"
"        return this.toScancodesAndFlags(key, code, KeyAcquire);\n"
"    }\n"
"\n"
"    /// @param flag = 0 (KeyAcquire) or 0x8000 (KeyRelease)\n"
"    toScancodesAndFlags(key, code, flag) {\n"
"        const scancodeByMods = this._keymap[key];\n"
"        if (scancodeByMods) {\n"
"            return this._scancodeByModsToScancodes(scancodeByMods, flag);\n"
"        }\n"
"\n"
"        // dead key\n"
"        const dk = this._deadKeymap[key];\n"
"        if (dk) {\n"
"            const accu = this._scancodeByModsToScancodes(this._accentKeymap[dk[0]], flag);\n"
"            for (let i = 1; i < dk.length; ++i) {\n"
"                accu.push(...this._scancodeByModsToScancodes(this._keymap[dk[i]], flag));\n"
"            }\n"
"            return accu;\n"
"        }\n"
"\n"
"        // use key before code for special configuration such as Esc <-> CapsLock\n"
"        return this._modToScancode(key, flag) ||\n"
"               this._modToScancode(code, flag) ||\n"
"               // transform a named key to scancode. Do not use `code`.\n"
"               codeToScancodes(key, flag);\n"
"    }\n"
"\n"
"    _scancodeByModsToScancodes(scancodeByMods, flag) {\n"
"        let scancode = scancodeByMods[this._virtualModFlags];\n"
"        if (scancode) {\n"
"            return [scancode | flag];\n"
"        }\n"
"\n"
"        // emulate control key up/down\n"
"\n"
"        let expectedModFlags;\n"
"        for (expectedModFlags in scancodeByMods) {\n"
"            scancode = scancodeByMods[expectedModFlags];\n"
"            if (flag === KeyRelease) {\n"
"                return [scancode | flag];\n"
"            }\n"
"            break;\n"
"        }\n"
"\n"
"        // if scancodeByMods\n"
"        if (!scancode) {\n"
"            return;\n"
"        }\n"
"\n"
"        // const release = flag ^ KeyRelease;\n"
"        // const down = flag & KeyRelease;\n"
"        const release = KeyRelease;\n"
"        const down = 0;\n"
"\n"
"        const accu = [];\n"
"\n"
"        // shift\n"
"        if ((this._virtualModFlags ^ expectedModFlags) & ShiftMod) {\n"
"            if (expectedModFlags & ShiftMod) {\n"
"                accu.push(LShiftSC | down);\n"
"            }\n"
"            else {\n"
"                if (this._modFlags & ShiftMod) accu.push(LShiftSC | release);\n"
"                if (this._modFlags & RightShiftMod) accu.push(RShiftSC | release);\n"
"            }\n"
"        }\n"
"\n"
"        // ctrl\n"
"        // if ((this._virtualModFlags ^ expectedModFlags) & CtrlMod) {\n"
"        //     if (expectedModFlags & CtrlMod) {\n"
"        //         accu.push(LCtrlSC | down);\n"
"        //     }\n"
"        //     else {\n"
"        //         if (this._modFlags & CtrlMod) accu.push(LCtrlSC | release);\n"
"        //         if ((this._modFlags & RightCtrlMod) && !this._rctrlIsOem8) accu.push(RCtrlSC | release);\n"
"        //     }\n"
"        // }\n"
"\n"
"        // oem8\n"
"        if ((this._virtualModFlags ^ expectedModFlags) & OEM8Mod) {\n"
"            accu.push(RCtrlSC | ((expectedModFlags & OEM8Mod) ? down : release));\n"
"        }\n"
"\n"
"        // alt\n"
"        // if ((this._virtualModFlags ^ expectedModFlags) & AltMod) {\n"
"        //     accu.push(AltSC | ((expectedModFlags & AltMod) ? down : release));\n"
"        // }\n"
"\n"
"        // altGr\n"
"        if ((this._virtualModFlags ^ expectedModFlags) & AltGrMod) {\n"
"            accu.push(AltGrSC | ((expectedModFlags & AltGrMod) ? down : release));\n"
"        }\n"
"\n"
"        // CapsLock\n"
"        const hasCapLock = (this._virtualModFlags ^ expectedModFlags) & CapsLockMod;\n"
"        if (hasCapLock) {\n"
"            accu.push(CapsLockSC | down);\n"
"            accu.push(CapsLockSC | release);\n"
"        }\n"
"\n"
"        // // KanaMod\n"
"        // if ((this._virtualModFlags ^ expectedModFlags) & KanaMod) {\n"
"        //     accu.push(KanaModSC | ((expectedModFlags & KanaMod) ? down : release));\n"
"        // }\n"
"        //\n"
"        // // KanaLockMod\n"
"        // if ((this._virtualModFlags ^ expectedModFlags) & KanaLockMod) {\n"
"        //     accu.push(KanaLockSC | ((expectedModFlags & KanaLockMod) ? down : release));\n"
"        // }\n"
"\n"
"        let accuLen = accu.length;\n"
"        if (hasCapLock) {\n"
"            accuLen -= 2;\n"
"        }\n"
"\n"
"        accu.push(scancode);\n"
"\n"
"        // reset emulated keys\n"
"        for (let i = 0; i < accuLen; ++i) {\n"
"            accu.push(accu[i] ^ KeyRelease);\n"
"        }\n"
"\n"
"        if (hasCapLock) {\n"
"            accu.push(CapsLockSC | down);\n"
"            accu.push(CapsLockSC | release);\n"
"        }\n"
"\n"
"        return accu;\n"
"    }\n"
"\n"
"    _modToScancode(code, flag) {\n"
"        switch (code) {\n"
"            case \"CapsLock\":\n"
"                if (flag === KeyAcquire) {\n"
"                    this._modFlags ^= CapsLockMod;\n"
"                    this._virtualModFlags ^= CapsLockMod;\n"
"                }\n"
"                return [CapsLockSC | flag];\n"
"\n"
"            case \"NumLock\":\n"
"                if (flag === KeyAcquire) {\n"
"                    this._modFlags ^= NumLockMod;\n"
"                }\n"
"                return [NumLockSC | flag];\n"
"\n"
"            case \"ControlLeft\":\n"
"                this._updateFlags(CtrlMod, flag);\n"
"                return [LCtrlSC | flag];\n"
"\n"
"            case \"ControlRight\":\n"
"                this._updateFlags(RightCtrlMod, flag);\n"
"                return [RCtrlSC | flag];\n"
"\n"
"            case \"AltGraph\":\n"
"            case \"AltRight\":\n"
"                this._updateFlags(AltGrMod, flag);\n"
"                return [AltGrSC | flag];\n"
"\n"
"            case \"Alt\":\n"
"            case \"AltLeft\":\n"
"                this._updateFlags(AltMod, flag);\n"
"                return [AltSC | flag];\n"
"\n"
"            case \"ShiftLeft\":\n"
"                this._updateFlags(ShiftMod, flag);\n"
"                return [LShiftSC | flag];\n"
"\n"
"            case \"ShiftRight\":\n"
"                this._updateFlags(RightShiftMod, flag);\n"
"                return [RShiftSC | flag];\n"
"\n"
"            case \"OSLeft\":\n"
"            case \"MetaLeft\":\n"
"                return [LMetaSC | flag];\n"
"\n"
"            case \"OSRight\":\n"
"            case \"MetaRight\":\n"
"                return [RMetaSC | flag];\n"
"        }\n"
"    }\n"
"\n"
"    _updateFlags(modf, flag) {\n"
"        if (flag === KeyRelease) {\n"
"            this._modFlags &= ~modf;\n"
"        }\n"
"        else {\n"
"            this._modFlags |= modf;\n"
"        }\n"
"        this._updateVirtualMod();\n"
"    }\n"
"\n"
"    _updateVirtualMod() {\n"
"        const ctrl = this._rctrlIsOem8 ? CtrlMod : (CtrlMod | RightCtrlMod);\n"
"        const hasCtrl = this._modFlags & ctrl;\n"
"        const hasAlt = this._modFlags & AltMod;\n"
"        this._virtualModFlags = this._modFlags & (AltGrMod | ShiftMod | CapsLockMod);\n"
"        this._virtualModFlags |= (this._modFlags & RightShiftMod) ? ShiftMod : 0;\n"
"        this._virtualModFlags |= (this._altGrIsCtrlAndAlt && (hasCtrl && hasAlt)) ? AltGrMod : 0;\n"
"        this._virtualModFlags |= (this._rctrlIsOem8 && (this._modFlags & RightCtrlMod)) ? OEM8Mod : 0;\n"
"    }\n"
"};\n"
"\n"
"const scancodeFromScancodeAndFlags = function(scancodeAndFlags) { return scancodeAndFlags & 0xff; };\n"
"const flagsFromScancodeAndFlags = function(scancodeAndFlags) { return scancodeAndFlags & 0xff00; };\n"
"\n"
"\n"
"try {\n"
"    module.exports.scancodesForSynchronizedMods = scancodesForSynchronizedMods;\n"
"    module.exports.scancodeFromScancodeAndFlags = scancodeFromScancodeAndFlags;\n"
"    module.exports.flagsFromScancodeAndFlags = flagsFromScancodeAndFlags;\n"
"    module.exports.keycodeToSingleScancode = keycodeToSingleScancode;\n"
"    module.exports.numpadCodeToScancode = numpadCodeToScancode;\n"
"    module.exports.codeToScancodes = codeToScancodes;\n"
"    module.exports.ReversedKeymap = ReversedKeymap;\n"
"    module.exports.ScancodeByMod = ScancodeByMod;\n"
"    module.exports.KeyRelease = KeyRelease;\n"
"    module.exports.KeyAcquire = KeyAcquire;\n"
"    module.exports.SyncFlags = SyncFlags;\n"
"    module.exports.toHumanReadableMods = toHumanReadableMods;\n"
"}\n"
"catch (e) {\n"
"    // module not found\n"
"}\n"
"\n"
;
    if (strcmp(path, "/rdpwasm/scancodes.js") == 0) {
        if (size) *size = strlen(rdp_scancodes_js);
        return rdp_scancodes_js;
    }
static unsigned char rdp_rdp_wasm[] = {
  0x00, 0x61, 0x73, 0x6d, 0x01, 0x00, 0x00, 0x00, 0x01, 0x85, 0x02, 0x20,
  0x60, 0x03, 0x7f, 0x7f, 0x7f, 0x00, 0x60, 0x02, 0x7f, 0x7f, 0x00, 0x60,
  0x01, 0x7f, 0x00, 0x60, 0x04, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x60, 0x01,
  0x7f, 0x01, 0x7f, 0x60, 0x05, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x60,
  0x03, 0x7f, 0x7f, 0x7f, 0x01, 0x7f, 0x60, 0x02, 0x7f, 0x7f, 0x01, 0x7f,
  0x60, 0x06, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x60, 0x05, 0x7f,
  0x7e, 0x7f, 0x7f, 0x7f, 0x00, 0x60, 0x04, 0x7f, 0x7f, 0x7f, 0x7f, 0x01,
  0x7f, 0x60, 0x00, 0x00, 0x60, 0x05, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x01,
  0x7f, 0x60, 0x09, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x00, 0x60, 0x07, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x60,
  0x08, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x60, 0x0d,
  0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x7f, 0x00, 0x60, 0x0a, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x7f, 0x7f, 0x00, 0x60, 0x07, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x01, 0x7f, 0x60, 0x06, 0x7f, 0x7c, 0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x7f,
  0x60, 0x08, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x7f,
  0x60, 0x04, 0x7f, 0x7e, 0x7f, 0x7f, 0x00, 0x60, 0x06, 0x7f, 0x7f, 0x7f,
  0x7f, 0x7f, 0x7f, 0x01, 0x7f, 0x60, 0x00, 0x01, 0x7f, 0x60, 0x03, 0x7f,
  0x7f, 0x7f, 0x01, 0x7c, 0x60, 0x05, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x01,
  0x7c, 0x60, 0x09, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
  0x01, 0x7f, 0x60, 0x02, 0x7e, 0x7f, 0x01, 0x7f, 0x60, 0x04, 0x7f, 0x7f,
  0x7e, 0x7e, 0x00, 0x60, 0x02, 0x7c, 0x7f, 0x01, 0x7c, 0x60, 0x01, 0x7d,
  0x01, 0x7d, 0x60, 0x03, 0x7f, 0x7e, 0x7e, 0x00, 0x02, 0xcd, 0x01, 0x22,
  0x01, 0x61, 0x01, 0x61, 0x00, 0x17, 0x01, 0x61, 0x01, 0x62, 0x00, 0x02,
  0x01, 0x61, 0x01, 0x63, 0x00, 0x04, 0x01, 0x61, 0x01, 0x64, 0x00, 0x04,
  0x01, 0x61, 0x01, 0x65, 0x00, 0x04, 0x01, 0x61, 0x01, 0x66, 0x00, 0x07,
  0x01, 0x61, 0x01, 0x67, 0x00, 0x07, 0x01, 0x61, 0x01, 0x68, 0x00, 0x03,
  0x01, 0x61, 0x01, 0x69, 0x00, 0x00, 0x01, 0x61, 0x01, 0x6a, 0x00, 0x02,
  0x01, 0x61, 0x01, 0x6b, 0x00, 0x18, 0x01, 0x61, 0x01, 0x6c, 0x00, 0x0f,
  0x01, 0x61, 0x01, 0x6d, 0x00, 0x02, 0x01, 0x61, 0x01, 0x6e, 0x00, 0x07,
  0x01, 0x61, 0x01, 0x6f, 0x00, 0x00, 0x01, 0x61, 0x01, 0x70, 0x00, 0x05,
  0x01, 0x61, 0x01, 0x71, 0x00, 0x06, 0x01, 0x61, 0x01, 0x72, 0x00, 0x08,
  0x01, 0x61, 0x01, 0x73, 0x00, 0x04, 0x01, 0x61, 0x01, 0x74, 0x00, 0x00,
  0x01, 0x61, 0x01, 0x75, 0x00, 0x08, 0x01, 0x61, 0x01, 0x76, 0x00, 0x10,
  0x01, 0x61, 0x01, 0x77, 0x00, 0x00, 0x01, 0x61, 0x01, 0x78, 0x00, 0x01,
  0x01, 0x61, 0x01, 0x79, 0x00, 0x0e, 0x01, 0x61, 0x01, 0x7a, 0x00, 0x06,
  0x01, 0x61, 0x01, 0x41, 0x00, 0x04, 0x01, 0x61, 0x01, 0x42, 0x00, 0x01,
  0x01, 0x61, 0x01, 0x43, 0x00, 0x05, 0x01, 0x61, 0x01, 0x44, 0x00, 0x01,
  0x01, 0x61, 0x01, 0x45, 0x00, 0x0c, 0x01, 0x61, 0x01, 0x46, 0x00, 0x0a,
  0x01, 0x61, 0x01, 0x47, 0x00, 0x19, 0x01, 0x61, 0x01, 0x48, 0x00, 0x04,
  0x03, 0x93, 0x03, 0x91, 0x03, 0x00, 0x02, 0x06, 0x07, 0x01, 0x04, 0x0a,
  0x06, 0x05, 0x06, 0x03, 0x01, 0x11, 0x02, 0x04, 0x00, 0x03, 0x01, 0x01,
  0x01, 0x03, 0x0b, 0x00, 0x04, 0x05, 0x00, 0x05, 0x00, 0x06, 0x00, 0x03,
  0x02, 0x05, 0x05, 0x00, 0x02, 0x00, 0x01, 0x02, 0x01, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x04, 0x0b, 0x01, 0x03, 0x00, 0x06, 0x06, 0x03, 0x01, 0x05,
  0x00, 0x00, 0x07, 0x00, 0x06, 0x07, 0x03, 0x0a, 0x01, 0x05, 0x03, 0x0b,
  0x1a, 0x07, 0x01, 0x1b, 0x06, 0x02, 0x01, 0x00, 0x08, 0x07, 0x04, 0x07,
  0x07, 0x07, 0x01, 0x01, 0x01, 0x00, 0x05, 0x05, 0x00, 0x01, 0x01, 0x03,
  0x01, 0x0e, 0x08, 0x04, 0x01, 0x07, 0x03, 0x08, 0x01, 0x08, 0x01, 0x05,
  0x00, 0x0d, 0x00, 0x03, 0x03, 0x08, 0x04, 0x02, 0x02, 0x01, 0x02, 0x04,
  0x04, 0x06, 0x12, 0x0a, 0x01, 0x01, 0x01, 0x05, 0x02, 0x05, 0x0c, 0x03,
  0x01, 0x01, 0x05, 0x07, 0x04, 0x00, 0x07, 0x05, 0x05, 0x10, 0x04, 0x0b,
  0x02, 0x01, 0x00, 0x03, 0x03, 0x0a, 0x02, 0x03, 0x02, 0x1c, 0x00, 0x03,
  0x07, 0x03, 0x04, 0x0c, 0x1d, 0x07, 0x07, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x0b, 0x07, 0x06, 0x02, 0x0f, 0x00, 0x07, 0x01, 0x03, 0x01, 0x01,
  0x06, 0x01, 0x05, 0x01, 0x02, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x03, 0x01, 0x07, 0x08, 0x03, 0x03, 0x07, 0x07, 0x04, 0x01, 0x00, 0x00,
  0x00, 0x05, 0x08, 0x01, 0x00, 0x01, 0x06, 0x01, 0x0a, 0x03, 0x08, 0x08,
  0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x01, 0x0c,
  0x1e, 0x08, 0x01, 0x05, 0x00, 0x03, 0x03, 0x05, 0x1f, 0x03, 0x05, 0x11,
  0x0d, 0x00, 0x04, 0x06, 0x0a, 0x04, 0x01, 0x04, 0x14, 0x0d, 0x00, 0x02,
  0x04, 0x04, 0x02, 0x02, 0x0e, 0x08, 0x01, 0x08, 0x05, 0x03, 0x03, 0x05,
  0x08, 0x07, 0x04, 0x06, 0x02, 0x04, 0x02, 0x04, 0x04, 0x06, 0x01, 0x13,
  0x04, 0x04, 0x05, 0x02, 0x04, 0x03, 0x0c, 0x00, 0x02, 0x04, 0x02, 0x02,
  0x02, 0x02, 0x01, 0x01, 0x02, 0x04, 0x04, 0x04, 0x09, 0x02, 0x01, 0x01,
  0x01, 0x03, 0x00, 0x05, 0x02, 0x01, 0x01, 0x04, 0x03, 0x00, 0x00, 0x01,
  0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x04, 0x02, 0x02, 0x04, 0x00, 0x01,
  0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x02, 0x04, 0x07, 0x01, 0x00, 0x01,
  0x06, 0x01, 0x08, 0x02, 0x04, 0x00, 0x00, 0x06, 0x06, 0x00, 0x03, 0x03,
  0x05, 0x08, 0x0e, 0x00, 0x01, 0x02, 0x02, 0x05, 0x03, 0x03, 0x03, 0x07,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x03, 0x06, 0x00, 0x01,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0x04, 0x04, 0x00, 0x07,
  0x05, 0x04, 0x07, 0x15, 0x04, 0x02, 0x04, 0x03, 0x05, 0x03, 0x04, 0x06,
  0x0a, 0x04, 0x03, 0x05, 0x03, 0x12, 0x16, 0x05, 0x03, 0x05, 0x04, 0x07,
  0x01, 0x70, 0x01, 0xb2, 0x02, 0xb2, 0x02, 0x05, 0x06, 0x01, 0x01, 0x80,
  0x02, 0x80, 0x02, 0x06, 0x09, 0x01, 0x7f, 0x01, 0x41, 0xc0, 0xb9, 0xdb,
  0x02, 0x0b, 0x07, 0x2b, 0x09, 0x01, 0x49, 0x02, 0x00, 0x01, 0x4a, 0x00,
  0xac, 0x01, 0x01, 0x4b, 0x00, 0xb2, 0x02, 0x01, 0x4c, 0x00, 0xc6, 0x01,
  0x01, 0x4d, 0x00, 0x94, 0x01, 0x01, 0x4e, 0x00, 0x23, 0x01, 0x4f, 0x01,
  0x00, 0x01, 0x50, 0x00, 0x9e, 0x02, 0x01, 0x51, 0x00, 0x9d, 0x02, 0x09,
  0x80, 0x04, 0x01, 0x00, 0x41, 0x01, 0x0b, 0xb1, 0x02, 0xa1, 0x03, 0x98,
  0x03, 0x8e, 0x03, 0x84, 0x03, 0xf2, 0x02, 0xfe, 0x01, 0xea, 0x02, 0xe9,
  0x02, 0xe4, 0x02, 0xa4, 0x01, 0xe0, 0x02, 0xdf, 0x02, 0xdc, 0x02, 0xd8,
  0x02, 0xd5, 0x02, 0xd4, 0x02, 0xd3, 0x02, 0xd2, 0x02, 0xd1, 0x02, 0xc8,
  0x02, 0xcb, 0x01, 0xb6, 0x02, 0xb3, 0x02, 0xb1, 0x02, 0xb9, 0x01, 0xa7,
  0x02, 0xb9, 0x01, 0x9f, 0x02, 0xcb, 0x01, 0x4f, 0x9c, 0x02, 0x9b, 0x02,
  0xab, 0x01, 0xd7, 0x02, 0x45, 0x92, 0x02, 0xad, 0x01, 0x91, 0x02, 0x90,
  0x02, 0x8f, 0x02, 0xa4, 0x01, 0x8e, 0x02, 0xfe, 0x01, 0x8d, 0x02, 0x8c,
  0x02, 0x8b, 0x02, 0x8e, 0x01, 0x8a, 0x02, 0x88, 0x02, 0xb2, 0x03, 0x8e,
  0x01, 0xb1, 0x03, 0xb0, 0x03, 0xaf, 0x03, 0xae, 0x03, 0xad, 0x03, 0xac,
  0x03, 0xab, 0x03, 0xaa, 0x03, 0xad, 0x01, 0xa9, 0x03, 0xa8, 0x03, 0xa7,
  0x03, 0xa4, 0x01, 0xa6, 0x03, 0x88, 0x02, 0xa5, 0x03, 0x8e, 0x01, 0xa4,
  0x03, 0xfb, 0x02, 0xfa, 0x02, 0xf9, 0x02, 0xf8, 0x02, 0xf7, 0x02, 0xf6,
  0x02, 0xd6, 0x02, 0x45, 0xb0, 0x02, 0xaf, 0x02, 0x9a, 0x02, 0x98, 0x02,
  0x97, 0x02, 0x4f, 0x41, 0x94, 0x02, 0x93, 0x02, 0x45, 0x41, 0x8f, 0x01,
  0x4c, 0x4f, 0x41, 0x4c, 0x4f, 0x41, 0x4c, 0x4f, 0x41, 0x96, 0x02, 0x95,
  0x02, 0xa3, 0x03, 0xa2, 0x03, 0xa0, 0x03, 0x45, 0x9f, 0x03, 0x8f, 0x01,
  0x8f, 0x01, 0x45, 0x9e, 0x03, 0x9d, 0x03, 0x9c, 0x03, 0x34, 0x9b, 0x03,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x45, 0x9a, 0x03, 0x99, 0x03,
  0x97, 0x03, 0x34, 0x96, 0x03, 0x95, 0x03, 0x94, 0x03, 0x93, 0x03, 0x92,
  0x03, 0x91, 0x03, 0x90, 0x03, 0x8f, 0x03, 0x8d, 0x03, 0x8c, 0x03, 0x8b,
  0x03, 0x8a, 0x03, 0x89, 0x03, 0x88, 0x03, 0x87, 0x03, 0x86, 0x03, 0x85,
  0x03, 0x83, 0x03, 0x82, 0x03, 0x81, 0x03, 0x80, 0x03, 0x34, 0x4c, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0xff, 0x02, 0xfe,
  0x02, 0x45, 0xfd, 0x02, 0xfc, 0x02, 0x4c, 0x99, 0x02, 0xf0, 0x02, 0xf5,
  0x02, 0xef, 0x02, 0xee, 0x02, 0x45, 0xed, 0x02, 0xf4, 0x02, 0xf3, 0x02,
  0x95, 0x01, 0x95, 0x01, 0x95, 0x01, 0xf1, 0x02, 0xec, 0x02, 0xeb, 0x02,
  0x4f, 0x41, 0x4f, 0x41, 0xe1, 0x02, 0x41, 0xe2, 0x02, 0x41, 0xe3, 0x02,
  0x4f, 0x41, 0xe5, 0x02, 0xe5, 0x01, 0xd9, 0x02, 0xdb, 0x02, 0xda, 0x02,
  0x4f, 0x41, 0x34, 0x34, 0x4c, 0x4c, 0x4c, 0x4c, 0x34, 0x34, 0x4c, 0x4d,
  0x4c, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x88,
  0x01, 0x34, 0x4c, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
  0x34, 0x45, 0x45, 0x34, 0x4c, 0x80, 0x01, 0xcd, 0x02, 0xcc, 0x02, 0xcb,
  0x02, 0xca, 0x02, 0xc9, 0x02, 0x9b, 0x01, 0xc7, 0x02, 0xc6, 0x02, 0x45,
  0x9c, 0x01, 0x9d, 0x01, 0xc5, 0x02, 0xc4, 0x02, 0x45, 0xc3, 0x02, 0xc2,
  0x02, 0xc1, 0x02, 0x88, 0x01, 0xc0, 0x02, 0xbf, 0x02, 0xbe, 0x02, 0xca,
  0x01, 0x4d, 0x88, 0x01, 0xbd, 0x02, 0xc9, 0x01, 0xca, 0x01, 0x4d, 0x88,
  0x01, 0xbc, 0x02, 0xbb, 0x02, 0xba, 0x02, 0xb9, 0x02, 0x4f, 0x41, 0xd0,
  0x02, 0xcf, 0x02, 0x45, 0x41, 0xce, 0x02, 0xde, 0x02, 0xdd, 0x02, 0xe8,
  0x02, 0xe7, 0x02, 0xe6, 0x02, 0xb8, 0x02, 0xb7, 0x02, 0xb5, 0x02, 0xb4,
  0x02, 0xae, 0x02, 0x41, 0xac, 0x02, 0xab, 0x02, 0xaa, 0x02, 0xa9, 0x02,
  0x41, 0xad, 0x02, 0x4f, 0x41, 0x45, 0x45, 0xa8, 0x02, 0xa0, 0x02, 0xa1,
  0x02, 0xa2, 0x02, 0x41, 0xa5, 0x02, 0xa4, 0x02, 0xa3, 0x02, 0x0a, 0xfc,
  0x86, 0x19, 0x91, 0x03, 0x4f, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0xa0,
  0x08, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x20, 0x03, 0x20, 0x02, 0x36, 0x02,
  0x9c, 0x08, 0x20, 0x03, 0x20, 0x03, 0x41, 0x10, 0x6a, 0x22, 0x04, 0x41,
  0x80, 0x08, 0x20, 0x01, 0x20, 0x02, 0x10, 0x98, 0x01, 0x36, 0x02, 0x08,
  0x20, 0x03, 0x20, 0x00, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x04, 0x36,
  0x02, 0x04, 0x41, 0xfd, 0xa0, 0x1b, 0x41, 0xb0, 0x8d, 0x1b, 0x20, 0x03,
  0x10, 0x10, 0x1a, 0x20, 0x03, 0x41, 0xa0, 0x08, 0x6a, 0x24, 0x00, 0x0b,
  0xcc, 0x0c, 0x01, 0x07, 0x7f, 0x02, 0x40, 0x20, 0x00, 0x45, 0x0d, 0x00,
  0x20, 0x00, 0x41, 0x08, 0x6b, 0x22, 0x03, 0x20, 0x00, 0x41, 0x04, 0x6b,
  0x28, 0x02, 0x00, 0x22, 0x01, 0x41, 0x78, 0x71, 0x22, 0x00, 0x6a, 0x21,
  0x05, 0x02, 0x40, 0x20, 0x01, 0x41, 0x01, 0x71, 0x0d, 0x00, 0x20, 0x01,
  0x41, 0x03, 0x71, 0x45, 0x0d, 0x01, 0x20, 0x03, 0x20, 0x03, 0x28, 0x02,
  0x00, 0x22, 0x01, 0x6b, 0x22, 0x03, 0x41, 0xd0, 0xb5, 0x1b, 0x28, 0x02,
  0x00, 0x49, 0x0d, 0x01, 0x20, 0x00, 0x20, 0x01, 0x6a, 0x21, 0x00, 0x20,
  0x03, 0x41, 0xd4, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x47, 0x04, 0x40, 0x20,
  0x01, 0x41, 0xff, 0x01, 0x4d, 0x04, 0x40, 0x20, 0x03, 0x28, 0x02, 0x08,
  0x22, 0x02, 0x20, 0x01, 0x41, 0x03, 0x76, 0x22, 0x04, 0x41, 0x03, 0x74,
  0x41, 0xe8, 0xb5, 0x1b, 0x6a, 0x46, 0x1a, 0x20, 0x02, 0x20, 0x03, 0x28,
  0x02, 0x0c, 0x22, 0x01, 0x46, 0x04, 0x40, 0x41, 0xc0, 0xb5, 0x1b, 0x41,
  0xc0, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x41, 0x7e, 0x20, 0x04, 0x77, 0x71,
  0x36, 0x02, 0x00, 0x0c, 0x03, 0x0b, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02,
  0x0c, 0x20, 0x01, 0x20, 0x02, 0x36, 0x02, 0x08, 0x0c, 0x02, 0x0b, 0x20,
  0x03, 0x28, 0x02, 0x18, 0x21, 0x06, 0x02, 0x40, 0x20, 0x03, 0x20, 0x03,
  0x28, 0x02, 0x0c, 0x22, 0x01, 0x47, 0x04, 0x40, 0x20, 0x03, 0x28, 0x02,
  0x08, 0x22, 0x02, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x01, 0x20, 0x02,
  0x36, 0x02, 0x08, 0x0c, 0x01, 0x0b, 0x02, 0x40, 0x20, 0x03, 0x41, 0x14,
  0x6a, 0x22, 0x02, 0x28, 0x02, 0x00, 0x22, 0x04, 0x0d, 0x00, 0x20, 0x03,
  0x41, 0x10, 0x6a, 0x22, 0x02, 0x28, 0x02, 0x00, 0x22, 0x04, 0x0d, 0x00,
  0x41, 0x00, 0x21, 0x01, 0x0c, 0x01, 0x0b, 0x03, 0x40, 0x20, 0x02, 0x21,
  0x07, 0x20, 0x04, 0x22, 0x01, 0x41, 0x14, 0x6a, 0x22, 0x02, 0x28, 0x02,
  0x00, 0x22, 0x04, 0x0d, 0x00, 0x20, 0x01, 0x41, 0x10, 0x6a, 0x21, 0x02,
  0x20, 0x01, 0x28, 0x02, 0x10, 0x22, 0x04, 0x0d, 0x00, 0x0b, 0x20, 0x07,
  0x41, 0x00, 0x36, 0x02, 0x00, 0x0b, 0x20, 0x06, 0x45, 0x0d, 0x01, 0x02,
  0x40, 0x20, 0x03, 0x20, 0x03, 0x28, 0x02, 0x1c, 0x22, 0x02, 0x41, 0x02,
  0x74, 0x41, 0xf0, 0xb7, 0x1b, 0x6a, 0x22, 0x04, 0x28, 0x02, 0x00, 0x46,
  0x04, 0x40, 0x20, 0x04, 0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x01, 0x0d,
  0x01, 0x41, 0xc4, 0xb5, 0x1b, 0x41, 0xc4, 0xb5, 0x1b, 0x28, 0x02, 0x00,
  0x41, 0x7e, 0x20, 0x02, 0x77, 0x71, 0x36, 0x02, 0x00, 0x0c, 0x03, 0x0b,
  0x20, 0x06, 0x41, 0x10, 0x41, 0x14, 0x20, 0x06, 0x28, 0x02, 0x10, 0x20,
  0x03, 0x46, 0x1b, 0x6a, 0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x01, 0x45,
  0x0d, 0x02, 0x0b, 0x20, 0x01, 0x20, 0x06, 0x36, 0x02, 0x18, 0x20, 0x03,
  0x28, 0x02, 0x10, 0x22, 0x02, 0x04, 0x40, 0x20, 0x01, 0x20, 0x02, 0x36,
  0x02, 0x10, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02, 0x18, 0x0b, 0x20, 0x03,
  0x28, 0x02, 0x14, 0x22, 0x02, 0x45, 0x0d, 0x01, 0x20, 0x01, 0x20, 0x02,
  0x36, 0x02, 0x14, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02, 0x18, 0x0c, 0x01,
  0x0b, 0x20, 0x05, 0x28, 0x02, 0x04, 0x22, 0x01, 0x41, 0x03, 0x71, 0x41,
  0x03, 0x47, 0x0d, 0x00, 0x41, 0xc8, 0xb5, 0x1b, 0x20, 0x00, 0x36, 0x02,
  0x00, 0x20, 0x05, 0x20, 0x01, 0x41, 0x7e, 0x71, 0x36, 0x02, 0x04, 0x20,
  0x03, 0x20, 0x00, 0x41, 0x01, 0x72, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20,
  0x03, 0x6a, 0x20, 0x00, 0x36, 0x02, 0x00, 0x0f, 0x0b, 0x20, 0x03, 0x20,
  0x05, 0x4f, 0x0d, 0x00, 0x20, 0x05, 0x28, 0x02, 0x04, 0x22, 0x01, 0x41,
  0x01, 0x71, 0x45, 0x0d, 0x00, 0x02, 0x40, 0x20, 0x01, 0x41, 0x02, 0x71,
  0x45, 0x04, 0x40, 0x20, 0x05, 0x41, 0xd8, 0xb5, 0x1b, 0x28, 0x02, 0x00,
  0x46, 0x04, 0x40, 0x41, 0xd8, 0xb5, 0x1b, 0x20, 0x03, 0x36, 0x02, 0x00,
  0x41, 0xcc, 0xb5, 0x1b, 0x41, 0xcc, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x20,
  0x00, 0x6a, 0x22, 0x00, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x00, 0x41,
  0x01, 0x72, 0x36, 0x02, 0x04, 0x20, 0x03, 0x41, 0xd4, 0xb5, 0x1b, 0x28,
  0x02, 0x00, 0x47, 0x0d, 0x03, 0x41, 0xc8, 0xb5, 0x1b, 0x41, 0x00, 0x36,
  0x02, 0x00, 0x41, 0xd4, 0xb5, 0x1b, 0x41, 0x00, 0x36, 0x02, 0x00, 0x0f,
  0x0b, 0x20, 0x05, 0x41, 0xd4, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x46, 0x04,
  0x40, 0x41, 0xd4, 0xb5, 0x1b, 0x20, 0x03, 0x36, 0x02, 0x00, 0x41, 0xc8,
  0xb5, 0x1b, 0x41, 0xc8, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x20, 0x00, 0x6a,
  0x22, 0x00, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x00, 0x41, 0x01, 0x72,
  0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x03, 0x6a, 0x20, 0x00, 0x36, 0x02,
  0x00, 0x0f, 0x0b, 0x20, 0x01, 0x41, 0x78, 0x71, 0x20, 0x00, 0x6a, 0x21,
  0x00, 0x02, 0x40, 0x20, 0x01, 0x41, 0xff, 0x01, 0x4d, 0x04, 0x40, 0x20,
  0x05, 0x28, 0x02, 0x08, 0x22, 0x02, 0x20, 0x01, 0x41, 0x03, 0x76, 0x22,
  0x04, 0x41, 0x03, 0x74, 0x41, 0xe8, 0xb5, 0x1b, 0x6a, 0x46, 0x1a, 0x20,
  0x02, 0x20, 0x05, 0x28, 0x02, 0x0c, 0x22, 0x01, 0x46, 0x04, 0x40, 0x41,
  0xc0, 0xb5, 0x1b, 0x41, 0xc0, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x41, 0x7e,
  0x20, 0x04, 0x77, 0x71, 0x36, 0x02, 0x00, 0x0c, 0x02, 0x0b, 0x20, 0x02,
  0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x01, 0x20, 0x02, 0x36, 0x02, 0x08,
  0x0c, 0x01, 0x0b, 0x20, 0x05, 0x28, 0x02, 0x18, 0x21, 0x06, 0x02, 0x40,
  0x20, 0x05, 0x20, 0x05, 0x28, 0x02, 0x0c, 0x22, 0x01, 0x47, 0x04, 0x40,
  0x20, 0x05, 0x28, 0x02, 0x08, 0x22, 0x02, 0x41, 0xd0, 0xb5, 0x1b, 0x28,
  0x02, 0x00, 0x49, 0x1a, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20,
  0x01, 0x20, 0x02, 0x36, 0x02, 0x08, 0x0c, 0x01, 0x0b, 0x02, 0x40, 0x20,
  0x05, 0x41, 0x14, 0x6a, 0x22, 0x02, 0x28, 0x02, 0x00, 0x22, 0x04, 0x0d,
  0x00, 0x20, 0x05, 0x41, 0x10, 0x6a, 0x22, 0x02, 0x28, 0x02, 0x00, 0x22,
  0x04, 0x0d, 0x00, 0x41, 0x00, 0x21, 0x01, 0x0c, 0x01, 0x0b, 0x03, 0x40,
  0x20, 0x02, 0x21, 0x07, 0x20, 0x04, 0x22, 0x01, 0x41, 0x14, 0x6a, 0x22,
  0x02, 0x28, 0x02, 0x00, 0x22, 0x04, 0x0d, 0x00, 0x20, 0x01, 0x41, 0x10,
  0x6a, 0x21, 0x02, 0x20, 0x01, 0x28, 0x02, 0x10, 0x22, 0x04, 0x0d, 0x00,
  0x0b, 0x20, 0x07, 0x41, 0x00, 0x36, 0x02, 0x00, 0x0b, 0x20, 0x06, 0x45,
  0x0d, 0x00, 0x02, 0x40, 0x20, 0x05, 0x20, 0x05, 0x28, 0x02, 0x1c, 0x22,
  0x02, 0x41, 0x02, 0x74, 0x41, 0xf0, 0xb7, 0x1b, 0x6a, 0x22, 0x04, 0x28,
  0x02, 0x00, 0x46, 0x04, 0x40, 0x20, 0x04, 0x20, 0x01, 0x36, 0x02, 0x00,
  0x20, 0x01, 0x0d, 0x01, 0x41, 0xc4, 0xb5, 0x1b, 0x41, 0xc4, 0xb5, 0x1b,
  0x28, 0x02, 0x00, 0x41, 0x7e, 0x20, 0x02, 0x77, 0x71, 0x36, 0x02, 0x00,
  0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0x10, 0x41, 0x14, 0x20, 0x06, 0x28,
  0x02, 0x10, 0x20, 0x05, 0x46, 0x1b, 0x6a, 0x20, 0x01, 0x36, 0x02, 0x00,
  0x20, 0x01, 0x45, 0x0d, 0x01, 0x0b, 0x20, 0x01, 0x20, 0x06, 0x36, 0x02,
  0x18, 0x20, 0x05, 0x28, 0x02, 0x10, 0x22, 0x02, 0x04, 0x40, 0x20, 0x01,
  0x20, 0x02, 0x36, 0x02, 0x10, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02, 0x18,
  0x0b, 0x20, 0x05, 0x28, 0x02, 0x14, 0x22, 0x02, 0x45, 0x0d, 0x00, 0x20,
  0x01, 0x20, 0x02, 0x36, 0x02, 0x14, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02,
  0x18, 0x0b, 0x20, 0x03, 0x20, 0x00, 0x41, 0x01, 0x72, 0x36, 0x02, 0x04,
  0x20, 0x00, 0x20, 0x03, 0x6a, 0x20, 0x00, 0x36, 0x02, 0x00, 0x20, 0x03,
  0x41, 0xd4, 0xb5, 0x1b, 0x28, 0x02, 0x00, 0x47, 0x0d, 0x01, 0x41, 0xc8,
  0xb5, 0x1b, 0x20, 0x00, 0x36, 0x02, 0x00, 0x0f, 0x0b, 0x20, 0x05, 0x20,
  0x01, 0x41, 0x7e, 0x71, 0x36, 0x02, 0x04, 0x20, 0x03, 0x20, 0x00, 0x41,
  0x01, 0x72, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x03, 0x6a, 0x20, 0x00,
  0x36, 0x02, 0x00, 0x0b, 0x20, 0x00, 0x41, 0xff, 0x01, 0x4d, 0x04, 0x40,
  0x20, 0x00, 0x41, 0x03, 0x76, 0x22, 0x01, 0x41, 0x03, 0x74, 0x41, 0xe8,
  0xb5, 0x1b, 0x6a, 0x21, 0x00, 0x02, 0x7f, 0x41, 0xc0, 0xb5, 0x1b, 0x28,
  0x02, 0x00, 0x22, 0x02, 0x41, 0x01, 0x20, 0x01, 0x74, 0x22, 0x01, 0x71,
  0x45, 0x04, 0x40, 0x41, 0xc0, 0xb5, 0x1b, 0x20, 0x01, 0x20, 0x02, 0x72,
  0x36, 0x02, 0x00, 0x20, 0x00, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x28, 0x02,
  0x08, 0x0b, 0x21, 0x02, 0x20, 0x00, 0x20, 0x03, 0x36, 0x02, 0x08, 0x20,
  0x02, 0x20, 0x03, 0x36, 0x02, 0x0c, 0x20, 0x03, 0x20, 0x00, 0x36, 0x02,
  0x0c, 0x20, 0x03, 0x20, 0x02, 0x36, 0x02, 0x08, 0x0f, 0x0b, 0x41, 0x1f,
  0x21, 0x02, 0x20, 0x03, 0x42, 0x00, 0x37, 0x02, 0x10, 0x20, 0x00, 0x41,
  0xff, 0xff, 0xff, 0x07, 0x4d, 0x04, 0x40, 0x20, 0x00, 0x41, 0x08, 0x76,
  0x22, 0x01, 0x20, 0x01, 0x41, 0x80, 0xfe, 0x3f, 0x6a, 0x41, 0x10, 0x76,
  0x41, 0x08, 0x71, 0x22, 0x01, 0x74, 0x22, 0x02, 0x20, 0x02, 0x41, 0x80,
  0xe0, 0x1f, 0x6a, 0x41, 0x10, 0x76, 0x41, 0x04, 0x71, 0x22, 0x02, 0x74,
  0x22, 0x04, 0x20, 0x04, 0x41, 0x80, 0x80, 0x0f, 0x6a, 0x41, 0x10, 0x76,
  0x41, 0x02, 0x71, 0x22, 0x04, 0x74, 0x41, 0x0f, 0x76, 0x20, 0x01, 0x20,
  0x02, 0x72, 0x20, 0x04, 0x72, 0x6b, 0x22, 0x01, 0x41, 0x01, 0x74, 0x20,
  0x00, 0x20, 0x01, 0x41, 0x15, 0x6a, 0x76, 0x41, 0x01, 0x71, 0x72, 0x41,
  0x1c, 0x6a, 0x21, 0x02, 0x0b, 0x20, 0x03, 0x20, 0x02, 0x36, 0x02, 0x1c,
  0x20, 0x02, 0x41, 0x02, 0x74, 0x41, 0xf0, 0xb7, 0x1b, 0x6a, 0x21, 0x01,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x41, 0xc4, 0xb5, 0x1b, 0x28, 0x02,
  0x00, 0x22, 0x04, 0x41, 0x01, 0x20, 0x02, 0x74, 0x22, 0x07, 0x71, 0x45,
  0x04, 0x40, 0x41, 0xc4, 0xb5, 0x1b, 0x20, 0x04, 0x20, 0x07, 0x72, 0x36,
  0x02, 0x00, 0x20, 0x01, 0x20, 0x03, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20,
  0x01, 0x36, 0x02, 0x18, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x41, 0x00, 0x41,
  0x19, 0x20, 0x02, 0x41, 0x01, 0x76, 0x6b, 0x20, 0x02, 0x41, 0x1f, 0x46,
  0x1b, 0x74, 0x21, 0x02, 0x20, 0x01, 0x28, 0x02, 0x00, 0x21, 0x01, 0x03,
  0x40, 0x20, 0x01, 0x22, 0x04, 0x28, 0x02, 0x04, 0x41, 0x78, 0x71, 0x20,
  0x00, 0x46, 0x0d, 0x02, 0x20, 0x02, 0x41, 0x1d, 0x76, 0x21, 0x01, 0x20,
  0x02, 0x41, 0x01, 0x74, 0x21, 0x02, 0x20, 0x04, 0x20, 0x01, 0x41, 0x04,
  0x71, 0x6a, 0x22, 0x07, 0x41, 0x10, 0x6a, 0x28, 0x02, 0x00, 0x22, 0x01,
  0x0d, 0x00, 0x0b, 0x20, 0x07, 0x20, 0x03, 0x36, 0x02, 0x10, 0x20, 0x03,
  0x20, 0x04, 0x36, 0x02, 0x18, 0x0b, 0x20, 0x03, 0x20, 0x03, 0x36, 0x02,
  0x0c, 0x20, 0x03, 0x20, 0x03, 0x36, 0x02, 0x08, 0x0c, 0x01, 0x0b, 0x20,
  0x04, 0x28, 0x02, 0x08, 0x22, 0x00, 0x20, 0x03, 0x36, 0x02, 0x0c, 0x20,
  0x04, 0x20, 0x03, 0x36, 0x02, 0x08, 0x20, 0x03, 0x41, 0x00, 0x36, 0x02,
  0x18, 0x20, 0x03, 0x20, 0x04, 0x36, 0x02, 0x0c, 0x20, 0x03, 0x20, 0x00,
  0x36, 0x02, 0x08, 0x0b, 0x41, 0xe0, 0xb5, 0x1b, 0x41, 0xe0, 0xb5, 0x1b,
  0x28, 0x02, 0x00, 0x41, 0x01, 0x6b, 0x22, 0x00, 0x41, 0x7f, 0x20, 0x00,
  0x1b, 0x36, 0x02, 0x00, 0x0b, 0x0b, 0x83, 0x04, 0x01, 0x03, 0x7f, 0x20,
  0x02, 0x41, 0x80, 0x04, 0x4f, 0x04, 0x40, 0x20, 0x00, 0x20, 0x01, 0x20,
  0x02, 0x10, 0x19, 0x1a, 0x20, 0x00, 0x0f, 0x0b, 0x20, 0x00, 0x20, 0x02,
  0x6a, 0x21, 0x03, 0x02, 0x40, 0x20, 0x00, 0x20, 0x01, 0x73, 0x41, 0x03,
  0x71, 0x45, 0x04, 0x40, 0x02, 0x40, 0x20, 0x00, 0x41, 0x03, 0x71, 0x45,
  0x04, 0x40, 0x20, 0x00, 0x21, 0x02, 0x0c, 0x01, 0x0b, 0x20, 0x02, 0x41,
  0x01, 0x48, 0x04, 0x40, 0x20, 0x00, 0x21, 0x02, 0x0c, 0x01, 0x0b, 0x20,
  0x00, 0x21, 0x02, 0x03, 0x40, 0x20, 0x02, 0x20, 0x01, 0x2d, 0x00, 0x00,
  0x3a, 0x00, 0x00, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x20, 0x02,
  0x41, 0x01, 0x6a, 0x22, 0x02, 0x41, 0x03, 0x71, 0x45, 0x0d, 0x01, 0x20,
  0x02, 0x20, 0x03, 0x49, 0x0d, 0x00, 0x0b, 0x0b, 0x02, 0x40, 0x20, 0x03,
  0x41, 0x7c, 0x71, 0x22, 0x04, 0x41, 0xc0, 0x00, 0x49, 0x0d, 0x00, 0x20,
  0x02, 0x20, 0x04, 0x41, 0x40, 0x6a, 0x22, 0x05, 0x4b, 0x0d, 0x00, 0x03,
  0x40, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20,
  0x02, 0x20, 0x01, 0x28, 0x02, 0x04, 0x36, 0x02, 0x04, 0x20, 0x02, 0x20,
  0x01, 0x28, 0x02, 0x08, 0x36, 0x02, 0x08, 0x20, 0x02, 0x20, 0x01, 0x28,
  0x02, 0x0c, 0x36, 0x02, 0x0c, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x10,
  0x36, 0x02, 0x10, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x14, 0x36, 0x02,
  0x14, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x18, 0x36, 0x02, 0x18, 0x20,
  0x02, 0x20, 0x01, 0x28, 0x02, 0x1c, 0x36, 0x02, 0x1c, 0x20, 0x02, 0x20,
  0x01, 0x28, 0x02, 0x20, 0x36, 0x02, 0x20, 0x20, 0x02, 0x20, 0x01, 0x28,
  0x02, 0x24, 0x36, 0x02, 0x24, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x28,
  0x36, 0x02, 0x28, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x2c, 0x36, 0x02,
  0x2c, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x30, 0x36, 0x02, 0x30, 0x20,
  0x02, 0x20, 0x01, 0x28, 0x02, 0x34, 0x36, 0x02, 0x34, 0x20, 0x02, 0x20,
  0x01, 0x28, 0x02, 0x38, 0x36, 0x02, 0x38, 0x20, 0x02, 0x20, 0x01, 0x28,
  0x02, 0x3c, 0x36, 0x02, 0x3c, 0x20, 0x01, 0x41, 0x40, 0x6b, 0x21, 0x01,
  0x20, 0x02, 0x41, 0x40, 0x6b, 0x22, 0x02, 0x20, 0x05, 0x4d, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x02, 0x20, 0x04, 0x4f, 0x0d, 0x01, 0x03, 0x40, 0x20,
  0x02, 0x20, 0x01, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20, 0x01, 0x41,
  0x04, 0x6a, 0x21, 0x01, 0x20, 0x02, 0x41, 0x04, 0x6a, 0x22, 0x02, 0x20,
  0x04, 0x49, 0x0d, 0x00, 0x0b, 0x0c, 0x01, 0x0b, 0x20, 0x03, 0x41, 0x04,
  0x49, 0x04, 0x40, 0x20, 0x00, 0x21, 0x02, 0x0c, 0x01, 0x0b, 0x20, 0x00,
  0x20, 0x03, 0x41, 0x04, 0x6b, 0x22, 0x04, 0x4b, 0x04, 0x40, 0x20, 0x00,
  0x21, 0x02, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x21, 0x02, 0x03, 0x40, 0x20,
  0x02, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x20,
  0x01, 0x2d, 0x00, 0x01, 0x3a, 0x00, 0x01, 0x20, 0x02, 0x20, 0x01, 0x2d,
  0x00, 0x02, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x01, 0x2d, 0x00, 0x03,
  0x3a, 0x00, 0x03, 0x20, 0x01, 0x41, 0x04, 0x6a, 0x21, 0x01, 0x20, 0x02,
  0x41, 0x04, 0x6a, 0x22, 0x02, 0x20, 0x04, 0x4d, 0x0d, 0x00, 0x0b, 0x0b,
  0x20, 0x02, 0x20, 0x03, 0x49, 0x04, 0x40, 0x03, 0x40, 0x20, 0x02, 0x20,
  0x01, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x01, 0x41, 0x01, 0x6a,
  0x21, 0x01, 0x20, 0x02, 0x41, 0x01, 0x6a, 0x22, 0x02, 0x20, 0x03, 0x47,
  0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x00, 0x0b, 0x38, 0x01, 0x02, 0x7f, 0x20,
  0x00, 0x28, 0x02, 0x04, 0x22, 0x03, 0x20, 0x01, 0x28, 0x02, 0x04, 0x46,
  0x04, 0x7f, 0x02, 0x40, 0x20, 0x03, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02,
  0x00, 0x20, 0x01, 0x28, 0x02, 0x00, 0x20, 0x03, 0x10, 0x2b, 0x22, 0x02,
  0x0d, 0x01, 0x0b, 0x41, 0x00, 0x21, 0x02, 0x0b, 0x20, 0x02, 0x45, 0x05,
  0x41, 0x00, 0x0b, 0x0b, 0x3e, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0x10,
  0x6b, 0x22, 0x02, 0x24, 0x00, 0x20, 0x02, 0x10, 0x00, 0x22, 0x03, 0x36,
  0x02, 0x08, 0x20, 0x02, 0x20, 0x03, 0x36, 0x02, 0x04, 0x20, 0x02, 0x20,
  0x00, 0x41, 0x02, 0x74, 0x41, 0xb0, 0xea, 0x1a, 0x6a, 0x28, 0x02, 0x00,
  0x36, 0x02, 0x00, 0x20, 0x00, 0x20, 0x01, 0x20, 0x02, 0x10, 0x22, 0x20,
  0x02, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x0b, 0x54, 0x01, 0x01, 0x7f, 0x20,
  0x00, 0x41, 0x01, 0x20, 0x00, 0x1b, 0x21, 0x00, 0x02, 0x40, 0x03, 0x40,
  0x20, 0x00, 0x10, 0x94, 0x01, 0x22, 0x01, 0x0d, 0x01, 0x41, 0xbc, 0xb5,
  0x1b, 0x28, 0x02, 0x00, 0x22, 0x01, 0x04, 0x40, 0x20, 0x01, 0x11, 0x0b,
  0x00, 0x0c, 0x01, 0x0b, 0x0b, 0x41, 0x04, 0x10, 0x02, 0x22, 0x00, 0x22,
  0x01, 0x41, 0xf0, 0x93, 0x1b, 0x36, 0x02, 0x00, 0x20, 0x01, 0x41, 0xb8,
  0x92, 0x1b, 0x36, 0x02, 0x00, 0x20, 0x00, 0x41, 0xe0, 0x92, 0x1b, 0x41,
  0x1e, 0x10, 0x08, 0x00, 0x0b, 0x20, 0x01, 0x0b, 0x2a, 0x01, 0x01, 0x7f,
  0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x20, 0x04, 0x20,
  0x03, 0x36, 0x02, 0x0c, 0x20, 0x00, 0x20, 0x01, 0x20, 0x02, 0x20, 0x03,
  0x10, 0x98, 0x01, 0x21, 0x00, 0x20, 0x04, 0x41, 0x10, 0x6a, 0x24, 0x00,
  0x20, 0x00, 0x0b, 0xf2, 0x02, 0x02, 0x02, 0x7f, 0x01, 0x7e, 0x02, 0x40,
  0x20, 0x02, 0x45, 0x0d, 0x00, 0x20, 0x00, 0x20, 0x02, 0x6a, 0x22, 0x03,
  0x41, 0x01, 0x6b, 0x20, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x01,
  0x3a, 0x00, 0x00, 0x20, 0x02, 0x41, 0x03, 0x49, 0x0d, 0x00, 0x20, 0x03,
  0x41, 0x02, 0x6b, 0x20, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x01,
  0x3a, 0x00, 0x01, 0x20, 0x03, 0x41, 0x03, 0x6b, 0x20, 0x01, 0x3a, 0x00,
  0x00, 0x20, 0x00, 0x20, 0x01, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x41, 0x07,
  0x49, 0x0d, 0x00, 0x20, 0x03, 0x41, 0x04, 0x6b, 0x20, 0x01, 0x3a, 0x00,
  0x00, 0x20, 0x00, 0x20, 0x01, 0x3a, 0x00, 0x03, 0x20, 0x02, 0x41, 0x09,
  0x49, 0x0d, 0x00, 0x20, 0x00, 0x41, 0x00, 0x20, 0x00, 0x6b, 0x41, 0x03,
  0x71, 0x22, 0x04, 0x6a, 0x22, 0x03, 0x20, 0x01, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x81, 0x82, 0x84, 0x08, 0x6c, 0x22, 0x01, 0x36, 0x02, 0x00, 0x20,
  0x03, 0x20, 0x02, 0x20, 0x04, 0x6b, 0x41, 0x7c, 0x71, 0x22, 0x04, 0x6a,
  0x22, 0x02, 0x41, 0x04, 0x6b, 0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x04,
  0x41, 0x09, 0x49, 0x0d, 0x00, 0x20, 0x03, 0x20, 0x01, 0x36, 0x02, 0x08,
  0x20, 0x03, 0x20, 0x01, 0x36, 0x02, 0x04, 0x20, 0x02, 0x41, 0x08, 0x6b,
  0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x02, 0x41, 0x0c, 0x6b, 0x20, 0x01,
  0x36, 0x02, 0x00, 0x20, 0x04, 0x41, 0x19, 0x49, 0x0d, 0x00, 0x20, 0x03,
  0x20, 0x01, 0x36, 0x02, 0x18, 0x20, 0x03, 0x20, 0x01, 0x36, 0x02, 0x14,
  0x20, 0x03, 0x20, 0x01, 0x36, 0x02, 0x10, 0x20, 0x03, 0x20, 0x01, 0x36,
  0x02, 0x0c, 0x20, 0x02, 0x41, 0x10, 0x6b, 0x20, 0x01, 0x36, 0x02, 0x00,
  0x20, 0x02, 0x41, 0x14, 0x6b, 0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x02,
  0x41, 0x18, 0x6b, 0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x02, 0x41, 0x1c,
  0x6b, 0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x04, 0x20, 0x03, 0x41, 0x04,
  0x71, 0x41, 0x18, 0x72, 0x22, 0x04, 0x6b, 0x22, 0x02, 0x41, 0x20, 0x49,
  0x0d, 0x00, 0x20, 0x01, 0xad, 0x42, 0x81, 0x80, 0x80, 0x80, 0x10, 0x7e,
  0x21, 0x05, 0x20, 0x03, 0x20, 0x04, 0x6a, 0x21, 0x01, 0x03, 0x40, 0x20,
  0x01, 0x20, 0x05, 0x37, 0x03, 0x18, 0x20, 0x01, 0x20, 0x05, 0x37, 0x03,
  0x10, 0x20, 0x01, 0x20, 0x05, 0x37, 0x03, 0x08, 0x20, 0x01, 0x20, 0x05,
  0x37, 0x03, 0x00, 0x20, 0x01, 0x41, 0x20, 0x6a, 0x21, 0x01, 0x20, 0x02,
  0x41, 0x20, 0x6b, 0x22, 0x02, 0x41, 0x1f, 0x4b, 0x0d, 0x00, 0x0b, 0x0b,
  0x20, 0x00, 0x0b, 0x69, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0x20, 0x6b,
  0x22, 0x05, 0x24, 0x00, 0x20, 0x02, 0x20, 0x03, 0x20, 0x04, 0x10, 0x54,
  0x22, 0x06, 0x04, 0x40, 0x10, 0x00, 0x21, 0x02, 0x20, 0x05, 0x20, 0x06,
  0x36, 0x02, 0x1c, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x18, 0x20, 0x05,
  0x20, 0x04, 0x36, 0x02, 0x14, 0x20, 0x05, 0x20, 0x00, 0x36, 0x02, 0x10,
  0x20, 0x05, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x05, 0x20, 0x02, 0x36,
  0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x04, 0x20, 0x05, 0x41,
  0xd4, 0xf7, 0x03, 0x36, 0x02, 0x00, 0x41, 0x04, 0x41, 0x90, 0xb2, 0x02,
  0x20, 0x05, 0x10, 0x22, 0x0b, 0x20, 0x05, 0x41, 0x20, 0x6a, 0x24, 0x00,
  0x0b, 0xa0, 0x01, 0x01, 0x02, 0x7f, 0x02, 0x7f, 0x02, 0x40, 0x20, 0x02,
  0x41, 0x04, 0x4f, 0x04, 0x40, 0x20, 0x00, 0x20, 0x01, 0x72, 0x41, 0x03,
  0x71, 0x0d, 0x01, 0x03, 0x40, 0x20, 0x00, 0x28, 0x02, 0x00, 0x20, 0x01,
  0x28, 0x02, 0x00, 0x47, 0x0d, 0x02, 0x20, 0x01, 0x41, 0x04, 0x6a, 0x21,
  0x01, 0x20, 0x00, 0x41, 0x04, 0x6a, 0x21, 0x00, 0x20, 0x02, 0x41, 0x04,
  0x6b, 0x22, 0x02, 0x41, 0x03, 0x4b, 0x0d, 0x00, 0x0b, 0x0b, 0x41, 0x00,
  0x0c, 0x01, 0x0b, 0x41, 0x01, 0x0b, 0x21, 0x03, 0x03, 0x40, 0x02, 0x40,
  0x20, 0x03, 0x45, 0x04, 0x40, 0x20, 0x02, 0x0d, 0x01, 0x41, 0x00, 0x0f,
  0x0b, 0x02, 0x40, 0x20, 0x00, 0x2d, 0x00, 0x00, 0x22, 0x03, 0x20, 0x01,
  0x2d, 0x00, 0x00, 0x22, 0x04, 0x46, 0x04, 0x40, 0x20, 0x01, 0x41, 0x01,
  0x6a, 0x21, 0x01, 0x20, 0x00, 0x41, 0x01, 0x6a, 0x21, 0x00, 0x20, 0x02,
  0x41, 0x01, 0x6b, 0x21, 0x02, 0x0c, 0x01, 0x0b, 0x20, 0x03, 0x20, 0x04,
  0x6b, 0x0f, 0x0b, 0x41, 0x00, 0x21, 0x03, 0x0c, 0x01, 0x0b, 0x41, 0x01,
  0x21, 0x03, 0x0c, 0x00, 0x0b, 0x00, 0x0b, 0xa4, 0x04, 0x01, 0x06, 0x7f,
  0x02, 0x40, 0x02, 0x40, 0x20, 0x03, 0x20, 0x02, 0x6b, 0x22, 0x08, 0x41,
  0x01, 0x48, 0x0d, 0x00, 0x20, 0x00, 0x28, 0x02, 0x08, 0x22, 0x05, 0x20,
  0x00, 0x28, 0x02, 0x04, 0x22, 0x06, 0x6b, 0x20, 0x08, 0x4e, 0x04, 0x40,
  0x02, 0x40, 0x20, 0x06, 0x20, 0x01, 0x6b, 0x22, 0x05, 0x20, 0x08, 0x4e,
  0x04, 0x40, 0x20, 0x06, 0x21, 0x04, 0x20, 0x03, 0x21, 0x07, 0x0c, 0x01,
  0x0b, 0x20, 0x06, 0x21, 0x04, 0x20, 0x03, 0x20, 0x02, 0x20, 0x05, 0x6a,
  0x22, 0x07, 0x6b, 0x22, 0x03, 0x41, 0x01, 0x4e, 0x04, 0x40, 0x20, 0x06,
  0x20, 0x07, 0x20, 0x03, 0x10, 0x24, 0x20, 0x03, 0x6a, 0x21, 0x04, 0x0b,
  0x20, 0x00, 0x20, 0x04, 0x36, 0x02, 0x04, 0x20, 0x05, 0x41, 0x01, 0x48,
  0x0d, 0x02, 0x0b, 0x20, 0x06, 0x20, 0x04, 0x22, 0x03, 0x20, 0x08, 0x6b,
  0x22, 0x05, 0x4b, 0x04, 0x40, 0x03, 0x40, 0x20, 0x03, 0x20, 0x05, 0x2d,
  0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x21, 0x03,
  0x20, 0x05, 0x41, 0x01, 0x6a, 0x22, 0x05, 0x20, 0x06, 0x49, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x00, 0x20, 0x03, 0x36, 0x02, 0x04, 0x20, 0x04, 0x20,
  0x01, 0x20, 0x08, 0x6a, 0x6b, 0x22, 0x00, 0x04, 0x40, 0x20, 0x04, 0x20,
  0x00, 0x6b, 0x20, 0x01, 0x20, 0x00, 0x10, 0x4b, 0x0b, 0x20, 0x07, 0x20,
  0x02, 0x6b, 0x22, 0x00, 0x45, 0x0d, 0x01, 0x20, 0x01, 0x20, 0x02, 0x20,
  0x00, 0x10, 0x4b, 0x0f, 0x0b, 0x20, 0x06, 0x20, 0x00, 0x28, 0x02, 0x00,
  0x22, 0x04, 0x6b, 0x20, 0x08, 0x6a, 0x22, 0x07, 0x41, 0x7f, 0x4c, 0x0d,
  0x01, 0x20, 0x01, 0x20, 0x04, 0x6b, 0x21, 0x03, 0x20, 0x03, 0x20, 0x07,
  0x20, 0x05, 0x20, 0x04, 0x6b, 0x22, 0x05, 0x41, 0x01, 0x74, 0x22, 0x09,
  0x20, 0x07, 0x20, 0x09, 0x4b, 0x1b, 0x41, 0xff, 0xff, 0xff, 0xff, 0x07,
  0x20, 0x05, 0x41, 0xff, 0xff, 0xff, 0xff, 0x03, 0x49, 0x1b, 0x22, 0x09,
  0x04, 0x7f, 0x20, 0x09, 0x10, 0x27, 0x05, 0x41, 0x00, 0x0b, 0x22, 0x07,
  0x6a, 0x20, 0x02, 0x20, 0x08, 0x10, 0x24, 0x21, 0x02, 0x20, 0x03, 0x41,
  0x01, 0x4e, 0x04, 0x40, 0x20, 0x07, 0x20, 0x04, 0x20, 0x03, 0x10, 0x24,
  0x1a, 0x0b, 0x20, 0x02, 0x20, 0x08, 0x6a, 0x21, 0x03, 0x20, 0x01, 0x20,
  0x06, 0x47, 0x04, 0x40, 0x20, 0x01, 0x41, 0x7f, 0x73, 0x20, 0x06, 0x6a,
  0x21, 0x02, 0x20, 0x06, 0x20, 0x01, 0x6b, 0x41, 0x07, 0x71, 0x22, 0x05,
  0x04, 0x40, 0x03, 0x40, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x3a,
  0x00, 0x00, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x21, 0x03, 0x20, 0x01, 0x41,
  0x01, 0x6a, 0x21, 0x01, 0x20, 0x05, 0x41, 0x01, 0x6b, 0x22, 0x05, 0x0d,
  0x00, 0x0b, 0x0b, 0x20, 0x02, 0x41, 0x07, 0x4f, 0x04, 0x40, 0x03, 0x40,
  0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x03,
  0x20, 0x01, 0x2d, 0x00, 0x01, 0x3a, 0x00, 0x01, 0x20, 0x03, 0x20, 0x01,
  0x2d, 0x00, 0x02, 0x3a, 0x00, 0x02, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00,
  0x03, 0x3a, 0x00, 0x03, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x04, 0x3a,
  0x00, 0x04, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x05, 0x3a, 0x00, 0x05,
  0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x06, 0x3a, 0x00, 0x06, 0x20, 0x03,
  0x20, 0x01, 0x2d, 0x00, 0x07, 0x3a, 0x00, 0x07, 0x20, 0x03, 0x41, 0x08,
  0x6a, 0x21, 0x03, 0x20, 0x01, 0x41, 0x08, 0x6a, 0x22, 0x01, 0x20, 0x06,
  0x47, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x00, 0x28, 0x02, 0x00, 0x21, 0x04,
  0x0b, 0x20, 0x00, 0x20, 0x07, 0x20, 0x09, 0x6a, 0x36, 0x02, 0x08, 0x20,
  0x00, 0x20, 0x03, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x07, 0x36, 0x02,
  0x00, 0x20, 0x04, 0x45, 0x0d, 0x00, 0x20, 0x04, 0x10, 0x23, 0x0b, 0x0f,
  0x0b, 0x10, 0x37, 0x00, 0x0b, 0xd0, 0x0f, 0x01, 0x18, 0x7f, 0x20, 0x00,
  0x20, 0x01, 0x28, 0x00, 0x10, 0x22, 0x0b, 0x20, 0x01, 0x28, 0x00, 0x20,
  0x22, 0x07, 0x20, 0x01, 0x28, 0x00, 0x30, 0x22, 0x0c, 0x20, 0x01, 0x28,
  0x00, 0x00, 0x22, 0x09, 0x20, 0x01, 0x28, 0x00, 0x24, 0x22, 0x11, 0x20,
  0x01, 0x28, 0x00, 0x34, 0x22, 0x12, 0x20, 0x01, 0x28, 0x00, 0x04, 0x22,
  0x13, 0x20, 0x01, 0x28, 0x00, 0x14, 0x22, 0x14, 0x20, 0x12, 0x20, 0x11,
  0x20, 0x14, 0x20, 0x13, 0x20, 0x0c, 0x20, 0x07, 0x20, 0x0b, 0x20, 0x09,
  0x20, 0x00, 0x28, 0x02, 0x08, 0x22, 0x0f, 0x6a, 0x20, 0x00, 0x28, 0x02,
  0x0c, 0x22, 0x0e, 0x20, 0x00, 0x28, 0x02, 0x14, 0x22, 0x15, 0x20, 0x00,
  0x28, 0x02, 0x10, 0x22, 0x10, 0x73, 0x71, 0x20, 0x15, 0x73, 0x6a, 0x41,
  0x88, 0xb7, 0xd5, 0xc4, 0x02, 0x6b, 0x41, 0x07, 0x77, 0x20, 0x0e, 0x6a,
  0x22, 0x02, 0x6a, 0x20, 0x01, 0x28, 0x00, 0x0c, 0x22, 0x16, 0x20, 0x0e,
  0x6a, 0x20, 0x01, 0x28, 0x00, 0x08, 0x22, 0x17, 0x20, 0x10, 0x6a, 0x20,
  0x13, 0x20, 0x15, 0x6a, 0x20, 0x02, 0x20, 0x0e, 0x20, 0x10, 0x73, 0x71,
  0x20, 0x10, 0x73, 0x6a, 0x41, 0xaa, 0x91, 0xe1, 0xb9, 0x01, 0x6b, 0x41,
  0x0c, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x08, 0x20, 0x02, 0x20, 0x0e, 0x73,
  0x71, 0x20, 0x0e, 0x73, 0x6a, 0x41, 0xdb, 0xe1, 0x81, 0xa1, 0x02, 0x6a,
  0x41, 0x11, 0x77, 0x20, 0x08, 0x6a, 0x22, 0x06, 0x20, 0x02, 0x20, 0x08,
  0x73, 0x71, 0x20, 0x02, 0x73, 0x6a, 0x41, 0x92, 0xe2, 0x88, 0xf2, 0x03,
  0x6b, 0x41, 0x16, 0x77, 0x20, 0x06, 0x6a, 0x22, 0x05, 0x20, 0x06, 0x20,
  0x08, 0x73, 0x71, 0x20, 0x08, 0x73, 0x6a, 0x41, 0xd1, 0xe0, 0x8f, 0xd4,
  0x00, 0x6b, 0x41, 0x07, 0x77, 0x20, 0x05, 0x6a, 0x22, 0x02, 0x6a, 0x20,
  0x01, 0x28, 0x00, 0x1c, 0x22, 0x0d, 0x20, 0x05, 0x6a, 0x20, 0x01, 0x28,
  0x00, 0x18, 0x22, 0x18, 0x20, 0x06, 0x6a, 0x20, 0x08, 0x20, 0x14, 0x6a,
  0x20, 0x02, 0x20, 0x05, 0x20, 0x06, 0x73, 0x71, 0x20, 0x06, 0x73, 0x6a,
  0x41, 0xaa, 0x8c, 0x9f, 0xbc, 0x04, 0x6a, 0x41, 0x0c, 0x77, 0x20, 0x02,
  0x6a, 0x22, 0x03, 0x20, 0x02, 0x20, 0x05, 0x73, 0x71, 0x20, 0x05, 0x73,
  0x6a, 0x41, 0xed, 0xf3, 0xbe, 0xbe, 0x05, 0x6b, 0x41, 0x11, 0x77, 0x20,
  0x03, 0x6a, 0x22, 0x06, 0x20, 0x02, 0x20, 0x03, 0x73, 0x71, 0x20, 0x02,
  0x73, 0x6a, 0x41, 0xff, 0xd5, 0xe5, 0x15, 0x6b, 0x41, 0x16, 0x77, 0x20,
  0x06, 0x6a, 0x22, 0x05, 0x20, 0x03, 0x20, 0x06, 0x73, 0x71, 0x20, 0x03,
  0x73, 0x6a, 0x41, 0xd8, 0xb1, 0x82, 0xcc, 0x06, 0x6a, 0x41, 0x07, 0x77,
  0x20, 0x05, 0x6a, 0x22, 0x02, 0x6a, 0x20, 0x01, 0x28, 0x00, 0x2c, 0x22,
  0x19, 0x20, 0x05, 0x6a, 0x20, 0x01, 0x28, 0x00, 0x28, 0x22, 0x08, 0x20,
  0x06, 0x6a, 0x20, 0x03, 0x20, 0x11, 0x6a, 0x20, 0x02, 0x20, 0x05, 0x20,
  0x06, 0x73, 0x71, 0x20, 0x06, 0x73, 0x6a, 0x41, 0xd1, 0x90, 0xec, 0xa5,
  0x07, 0x6b, 0x41, 0x0c, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x0a, 0x20, 0x02,
  0x20, 0x05, 0x73, 0x71, 0x20, 0x05, 0x73, 0x6a, 0x41, 0xcf, 0xc8, 0x02,
  0x6b, 0x41, 0x11, 0x77, 0x20, 0x0a, 0x6a, 0x22, 0x04, 0x20, 0x02, 0x20,
  0x0a, 0x73, 0x71, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xc2, 0xd0, 0x8c, 0xb5,
  0x07, 0x6b, 0x41, 0x16, 0x77, 0x20, 0x04, 0x6a, 0x22, 0x03, 0x20, 0x04,
  0x20, 0x0a, 0x73, 0x71, 0x20, 0x0a, 0x73, 0x6a, 0x41, 0xa2, 0xa2, 0xc0,
  0xdc, 0x06, 0x6a, 0x41, 0x07, 0x77, 0x20, 0x03, 0x6a, 0x22, 0x02, 0x6a,
  0x20, 0x01, 0x28, 0x00, 0x3c, 0x22, 0x06, 0x20, 0x03, 0x6a, 0x20, 0x01,
  0x28, 0x00, 0x38, 0x22, 0x05, 0x20, 0x04, 0x6a, 0x20, 0x0a, 0x20, 0x12,
  0x6a, 0x20, 0x02, 0x20, 0x03, 0x20, 0x04, 0x73, 0x71, 0x20, 0x04, 0x73,
  0x6a, 0x41, 0xed, 0x9c, 0x9e, 0x13, 0x6b, 0x41, 0x0c, 0x77, 0x20, 0x02,
  0x6a, 0x22, 0x01, 0x20, 0x02, 0x20, 0x03, 0x73, 0x71, 0x20, 0x03, 0x73,
  0x6a, 0x41, 0xf2, 0xf8, 0x9a, 0xcc, 0x05, 0x6b, 0x41, 0x11, 0x77, 0x20,
  0x01, 0x6a, 0x22, 0x04, 0x20, 0x01, 0x20, 0x02, 0x73, 0x71, 0x20, 0x02,
  0x73, 0x6a, 0x41, 0xa1, 0x90, 0xd0, 0xcd, 0x04, 0x6a, 0x41, 0x16, 0x77,
  0x20, 0x04, 0x6a, 0x22, 0x03, 0x20, 0x04, 0x73, 0x20, 0x01, 0x71, 0x20,
  0x04, 0x73, 0x6a, 0x41, 0x9e, 0xb5, 0x87, 0xcf, 0x00, 0x6b, 0x41, 0x05,
  0x77, 0x20, 0x03, 0x6a, 0x22, 0x02, 0x6a, 0x20, 0x03, 0x20, 0x09, 0x6a,
  0x20, 0x04, 0x20, 0x19, 0x6a, 0x20, 0x01, 0x20, 0x18, 0x6a, 0x20, 0x02,
  0x20, 0x03, 0x73, 0x20, 0x04, 0x71, 0x20, 0x03, 0x73, 0x6a, 0x41, 0xc0,
  0x99, 0xfd, 0xfd, 0x03, 0x6b, 0x41, 0x09, 0x77, 0x20, 0x02, 0x6a, 0x22,
  0x04, 0x20, 0x02, 0x73, 0x20, 0x03, 0x71, 0x20, 0x02, 0x73, 0x6a, 0x41,
  0xd1, 0xb4, 0xf9, 0xb2, 0x02, 0x6a, 0x41, 0x0e, 0x77, 0x20, 0x04, 0x6a,
  0x22, 0x03, 0x20, 0x04, 0x73, 0x20, 0x02, 0x71, 0x20, 0x04, 0x73, 0x6a,
  0x41, 0xd6, 0xf0, 0xa4, 0xb2, 0x01, 0x6b, 0x41, 0x14, 0x77, 0x20, 0x03,
  0x6a, 0x22, 0x02, 0x20, 0x03, 0x73, 0x20, 0x04, 0x71, 0x20, 0x03, 0x73,
  0x6a, 0x41, 0xa3, 0xdf, 0xc3, 0xce, 0x02, 0x6b, 0x41, 0x05, 0x77, 0x20,
  0x02, 0x6a, 0x22, 0x01, 0x6a, 0x20, 0x02, 0x20, 0x0b, 0x6a, 0x20, 0x03,
  0x20, 0x06, 0x6a, 0x20, 0x04, 0x20, 0x08, 0x6a, 0x20, 0x01, 0x20, 0x02,
  0x73, 0x20, 0x03, 0x71, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xd3, 0xa8, 0x90,
  0x12, 0x6a, 0x41, 0x09, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x04, 0x20, 0x01,
  0x73, 0x20, 0x02, 0x71, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xff, 0xb2, 0xf8,
  0xba, 0x02, 0x6b, 0x41, 0x0e, 0x77, 0x20, 0x04, 0x6a, 0x22, 0x03, 0x20,
  0x04, 0x73, 0x20, 0x01, 0x71, 0x20, 0x04, 0x73, 0x6a, 0x41, 0xb8, 0x88,
  0xb0, 0xc1, 0x01, 0x6b, 0x41, 0x14, 0x77, 0x20, 0x03, 0x6a, 0x22, 0x02,
  0x20, 0x03, 0x73, 0x20, 0x04, 0x71, 0x20, 0x03, 0x73, 0x6a, 0x41, 0xe6,
  0x9b, 0x87, 0x8f, 0x02, 0x6a, 0x41, 0x05, 0x77, 0x20, 0x02, 0x6a, 0x22,
  0x01, 0x6a, 0x20, 0x02, 0x20, 0x07, 0x6a, 0x20, 0x01, 0x20, 0x03, 0x20,
  0x16, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x20, 0x05, 0x6a, 0x20, 0x01, 0x20,
  0x02, 0x73, 0x20, 0x03, 0x71, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xaa, 0xf0,
  0xa3, 0xe6, 0x03, 0x6b, 0x41, 0x09, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x02,
  0x20, 0x01, 0x73, 0x71, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xf9, 0xe4, 0xab,
  0xd9, 0x00, 0x6b, 0x41, 0x0e, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x01, 0x20,
  0x02, 0x73, 0x71, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xed, 0xa9, 0xe8, 0xaa,
  0x04, 0x6a, 0x41, 0x14, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x0a, 0x20, 0x01,
  0x73, 0x20, 0x02, 0x71, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xfb, 0xad, 0xf0,
  0xb0, 0x05, 0x6b, 0x41, 0x05, 0x77, 0x20, 0x0a, 0x6a, 0x22, 0x04, 0x6a,
  0x20, 0x01, 0x20, 0x0d, 0x6a, 0x20, 0x02, 0x20, 0x17, 0x6a, 0x20, 0x04,
  0x20, 0x0a, 0x73, 0x20, 0x01, 0x71, 0x20, 0x0a, 0x73, 0x6a, 0x41, 0x88,
  0xb8, 0xc1, 0x18, 0x6b, 0x41, 0x09, 0x77, 0x20, 0x04, 0x6a, 0x22, 0x03,
  0x20, 0x04, 0x73, 0x20, 0x0a, 0x71, 0x20, 0x04, 0x73, 0x6a, 0x41, 0xd9,
  0x85, 0xbc, 0xbb, 0x06, 0x6a, 0x41, 0x0e, 0x77, 0x20, 0x03, 0x6a, 0x22,
  0x02, 0x20, 0x03, 0x73, 0x22, 0x01, 0x20, 0x0a, 0x20, 0x0c, 0x6a, 0x20,
  0x01, 0x20, 0x04, 0x71, 0x20, 0x03, 0x73, 0x6a, 0x41, 0xf6, 0xe6, 0xd6,
  0x96, 0x07, 0x6b, 0x41, 0x14, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x04, 0x73,
  0x6a, 0x41, 0xbe, 0x8d, 0x17, 0x6b, 0x41, 0x04, 0x77, 0x20, 0x04, 0x6a,
  0x22, 0x01, 0x6a, 0x20, 0x02, 0x20, 0x19, 0x6a, 0x20, 0x03, 0x20, 0x07,
  0x6a, 0x20, 0x02, 0x20, 0x04, 0x73, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xff,
  0x92, 0xb8, 0xc4, 0x07, 0x6b, 0x41, 0x0b, 0x77, 0x20, 0x01, 0x6a, 0x22,
  0x03, 0x20, 0x01, 0x20, 0x04, 0x73, 0x73, 0x6a, 0x41, 0xa2, 0xc2, 0xf5,
  0xec, 0x06, 0x6a, 0x41, 0x10, 0x77, 0x20, 0x03, 0x6a, 0x22, 0x07, 0x20,
  0x03, 0x73, 0x20, 0x04, 0x20, 0x05, 0x6a, 0x20, 0x01, 0x20, 0x03, 0x73,
  0x20, 0x07, 0x73, 0x6a, 0x41, 0xf4, 0x8f, 0xeb, 0x10, 0x6b, 0x41, 0x17,
  0x77, 0x20, 0x07, 0x6a, 0x22, 0x02, 0x73, 0x6a, 0x41, 0xbc, 0xab, 0x84,
  0xda, 0x05, 0x6b, 0x41, 0x04, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x01, 0x6a,
  0x20, 0x07, 0x20, 0x0d, 0x6a, 0x20, 0x03, 0x20, 0x0b, 0x6a, 0x20, 0x02,
  0x20, 0x07, 0x73, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xa9, 0x9f, 0xfb, 0xde,
  0x04, 0x6a, 0x41, 0x0b, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x0b, 0x20, 0x01,
  0x20, 0x02, 0x73, 0x73, 0x6a, 0x41, 0xa0, 0xe9, 0x92, 0xca, 0x00, 0x6b,
  0x41, 0x10, 0x77, 0x20, 0x0b, 0x6a, 0x22, 0x07, 0x20, 0x0b, 0x73, 0x20,
  0x02, 0x20, 0x08, 0x6a, 0x20, 0x01, 0x20, 0x0b, 0x73, 0x20, 0x07, 0x73,
  0x6a, 0x41, 0x90, 0x87, 0x81, 0x8a, 0x04, 0x6b, 0x41, 0x17, 0x77, 0x20,
  0x07, 0x6a, 0x22, 0x02, 0x73, 0x6a, 0x41, 0xc6, 0xfd, 0xed, 0xc4, 0x02,
  0x6a, 0x41, 0x04, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x01, 0x6a, 0x20, 0x07,
  0x20, 0x16, 0x6a, 0x20, 0x09, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x07,
  0x73, 0x20, 0x01, 0x73, 0x6a, 0x41, 0x86, 0xb0, 0xfb, 0xaa, 0x01, 0x6b,
  0x41, 0x0b, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x07, 0x20, 0x01, 0x20, 0x02,
  0x73, 0x73, 0x6a, 0x41, 0xfb, 0x9e, 0xc3, 0xd8, 0x02, 0x6b, 0x41, 0x10,
  0x77, 0x20, 0x07, 0x6a, 0x22, 0x09, 0x20, 0x07, 0x73, 0x20, 0x02, 0x20,
  0x18, 0x6a, 0x20, 0x01, 0x20, 0x07, 0x73, 0x20, 0x09, 0x73, 0x6a, 0x41,
  0x85, 0xba, 0xa0, 0x24, 0x6a, 0x41, 0x17, 0x77, 0x20, 0x09, 0x6a, 0x22,
  0x02, 0x73, 0x6a, 0x41, 0xc7, 0xdf, 0xac, 0xb1, 0x02, 0x6b, 0x41, 0x04,
  0x77, 0x20, 0x02, 0x6a, 0x22, 0x01, 0x6a, 0x20, 0x02, 0x20, 0x17, 0x6a,
  0x20, 0x07, 0x20, 0x0c, 0x6a, 0x20, 0x02, 0x20, 0x09, 0x73, 0x20, 0x01,
  0x73, 0x6a, 0x41, 0x9b, 0xcc, 0x91, 0xc9, 0x01, 0x6b, 0x41, 0x0b, 0x77,
  0x20, 0x01, 0x6a, 0x22, 0x0c, 0x20, 0x01, 0x73, 0x20, 0x06, 0x20, 0x09,
  0x6a, 0x20, 0x01, 0x20, 0x02, 0x73, 0x20, 0x0c, 0x73, 0x6a, 0x41, 0xf8,
  0xf9, 0x89, 0xfd, 0x01, 0x6a, 0x41, 0x10, 0x77, 0x20, 0x0c, 0x6a, 0x22,
  0x09, 0x73, 0x6a, 0x41, 0x9b, 0xd3, 0xce, 0xda, 0x03, 0x6b, 0x41, 0x17,
  0x77, 0x20, 0x09, 0x6a, 0x22, 0x02, 0x20, 0x0c, 0x41, 0x7f, 0x73, 0x72,
  0x20, 0x09, 0x73, 0x6a, 0x41, 0xbc, 0xbb, 0xdb, 0xde, 0x00, 0x6b, 0x41,
  0x06, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x01, 0x6a, 0x20, 0x02, 0x20, 0x14,
  0x6a, 0x20, 0x05, 0x20, 0x09, 0x6a, 0x20, 0x0c, 0x20, 0x0d, 0x6a, 0x20,
  0x01, 0x20, 0x09, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x02, 0x73, 0x6a, 0x41,
  0x97, 0xff, 0xab, 0x99, 0x04, 0x6a, 0x41, 0x0a, 0x77, 0x20, 0x01, 0x6a,
  0x22, 0x0d, 0x20, 0x02, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x01, 0x73, 0x6a,
  0x41, 0xd9, 0xb8, 0xaf, 0xa3, 0x05, 0x6b, 0x41, 0x0f, 0x77, 0x20, 0x0d,
  0x6a, 0x22, 0x05, 0x20, 0x01, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x0d, 0x73,
  0x6a, 0x41, 0xc7, 0xbf, 0xb1, 0x1b, 0x6b, 0x41, 0x15, 0x77, 0x20, 0x05,
  0x6a, 0x22, 0x02, 0x20, 0x0d, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x05, 0x73,
  0x6a, 0x41, 0xc3, 0xb3, 0xed, 0xaa, 0x06, 0x6a, 0x41, 0x06, 0x77, 0x20,
  0x02, 0x6a, 0x22, 0x01, 0x6a, 0x20, 0x02, 0x20, 0x13, 0x6a, 0x20, 0x05,
  0x20, 0x08, 0x6a, 0x20, 0x0d, 0x20, 0x16, 0x6a, 0x20, 0x01, 0x20, 0x05,
  0x41, 0x7f, 0x73, 0x72, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xee, 0xe6, 0xcc,
  0x87, 0x07, 0x6b, 0x41, 0x0a, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x08, 0x20,
  0x02, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x01, 0x73, 0x6a, 0x41, 0x83, 0x97,
  0xc0, 0x00, 0x6b, 0x41, 0x0f, 0x77, 0x20, 0x08, 0x6a, 0x22, 0x05, 0x20,
  0x01, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x08, 0x73, 0x6a, 0x41, 0xaf, 0xc4,
  0xee, 0xd3, 0x07, 0x6b, 0x41, 0x15, 0x77, 0x20, 0x05, 0x6a, 0x22, 0x01,
  0x20, 0x08, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x05, 0x73, 0x6a, 0x41, 0xcf,
  0xfc, 0xa1, 0xfd, 0x06, 0x6a, 0x41, 0x06, 0x77, 0x20, 0x01, 0x6a, 0x22,
  0x02, 0x6a, 0x20, 0x01, 0x20, 0x12, 0x6a, 0x20, 0x05, 0x20, 0x18, 0x6a,
  0x20, 0x06, 0x20, 0x08, 0x6a, 0x20, 0x02, 0x20, 0x05, 0x41, 0x7f, 0x73,
  0x72, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xa0, 0xb2, 0xcc, 0x0e, 0x6b, 0x41,
  0x0a, 0x77, 0x20, 0x02, 0x6a, 0x22, 0x06, 0x20, 0x01, 0x41, 0x7f, 0x73,
  0x72, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xec, 0xf9, 0xfa, 0xe7, 0x05, 0x6b,
  0x41, 0x0f, 0x77, 0x20, 0x06, 0x6a, 0x22, 0x01, 0x20, 0x02, 0x41, 0x7f,
  0x73, 0x72, 0x20, 0x06, 0x73, 0x6a, 0x41, 0xa1, 0xa3, 0xa0, 0xf0, 0x04,
  0x6a, 0x41, 0x15, 0x77, 0x20, 0x01, 0x6a, 0x22, 0x05, 0x20, 0x06, 0x41,
  0x7f, 0x73, 0x72, 0x20, 0x01, 0x73, 0x6a, 0x41, 0xfe, 0x82, 0xb2, 0xc5,
  0x00, 0x6b, 0x41, 0x06, 0x77, 0x20, 0x05, 0x6a, 0x22, 0x02, 0x20, 0x0f,
  0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20, 0x15, 0x20, 0x06, 0x20, 0x19,
  0x6a, 0x20, 0x02, 0x20, 0x01, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x05, 0x73,
  0x6a, 0x41, 0xcb, 0x9b, 0x94, 0x96, 0x04, 0x6b, 0x41, 0x0a, 0x77, 0x20,
  0x02, 0x6a, 0x22, 0x0f, 0x6a, 0x36, 0x02, 0x14, 0x20, 0x00, 0x20, 0x10,
  0x20, 0x01, 0x20, 0x17, 0x6a, 0x20, 0x0f, 0x20, 0x05, 0x41, 0x7f, 0x73,
  0x72, 0x20, 0x02, 0x73, 0x6a, 0x41, 0xbb, 0xa5, 0xdf, 0xd6, 0x02, 0x6a,
  0x41, 0x0f, 0x77, 0x20, 0x0f, 0x6a, 0x22, 0x01, 0x6a, 0x36, 0x02, 0x10,
  0x20, 0x00, 0x20, 0x01, 0x20, 0x0e, 0x6a, 0x20, 0x05, 0x20, 0x11, 0x6a,
  0x20, 0x01, 0x20, 0x02, 0x41, 0x7f, 0x73, 0x72, 0x20, 0x0f, 0x73, 0x6a,
  0x41, 0xef, 0xd8, 0xe4, 0xa3, 0x01, 0x6b, 0x41, 0x15, 0x77, 0x6a, 0x36,
  0x02, 0x0c, 0x0b, 0x89, 0x03, 0x01, 0x06, 0x7f, 0x23, 0x00, 0x41, 0xb0,
  0x10, 0x6b, 0x22, 0x0a, 0x24, 0x00, 0x20, 0x01, 0x04, 0x40, 0x20, 0x05,
  0x20, 0x07, 0x6a, 0x41, 0x02, 0x6a, 0x21, 0x0e, 0x03, 0x40, 0x20, 0x0a,
  0x20, 0x03, 0x36, 0x02, 0x28, 0x20, 0x0a, 0x20, 0x0b, 0x36, 0x02, 0x24,
  0x20, 0x0a, 0x20, 0x02, 0x36, 0x02, 0x20, 0x20, 0x0a, 0x41, 0x30, 0x6a,
  0x22, 0x05, 0x41, 0xe0, 0xff, 0x01, 0x20, 0x0a, 0x41, 0x20, 0x6a, 0x10,
  0xc8, 0x01, 0x20, 0x05, 0x6a, 0x21, 0x05, 0x20, 0x0b, 0x21, 0x07, 0x41,
  0x00, 0x21, 0x0c, 0x03, 0x40, 0x02, 0x40, 0x20, 0x00, 0x20, 0x07, 0x6a,
  0x2d, 0x00, 0x00, 0x21, 0x07, 0x20, 0x0a, 0x20, 0x06, 0x36, 0x02, 0x18,
  0x20, 0x0a, 0x20, 0x07, 0x36, 0x02, 0x14, 0x20, 0x0a, 0x20, 0x04, 0x36,
  0x02, 0x10, 0x20, 0x05, 0x41, 0xe9, 0xff, 0x01, 0x20, 0x0a, 0x41, 0x10,
  0x6a, 0x10, 0xc8, 0x01, 0x20, 0x05, 0x6a, 0x21, 0x05, 0x20, 0x0c, 0x22,
  0x0d, 0x41, 0x0e, 0x4b, 0x22, 0x0f, 0x0d, 0x00, 0x20, 0x0d, 0x41, 0x01,
  0x6a, 0x22, 0x0c, 0x20, 0x0b, 0x6a, 0x22, 0x07, 0x20, 0x01, 0x49, 0x0d,
  0x01, 0x0b, 0x0b, 0x20, 0x05, 0x20, 0x08, 0x10, 0xc7, 0x01, 0x21, 0x05,
  0x41, 0x00, 0x21, 0x0c, 0x20, 0x0f, 0x04, 0x7f, 0x20, 0x05, 0x05, 0x20,
  0x05, 0x41, 0x99, 0x97, 0x05, 0x41, 0x0f, 0x20, 0x0d, 0x6b, 0x20, 0x0e,
  0x6c, 0x22, 0x05, 0x10, 0x24, 0x20, 0x05, 0x6a, 0x0b, 0x20, 0x09, 0x10,
  0xc7, 0x01, 0x21, 0x07, 0x20, 0x0b, 0x21, 0x05, 0x03, 0x40, 0x02, 0x40,
  0x20, 0x00, 0x20, 0x05, 0x6a, 0x2d, 0x00, 0x00, 0x21, 0x05, 0x20, 0x07,
  0x41, 0x01, 0x6a, 0x22, 0x0d, 0x41, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x07,
  0x41, 0x2e, 0x41, 0x2e, 0x20, 0x05, 0x20, 0x05, 0x41, 0x20, 0x6b, 0x41,
  0xff, 0x01, 0x71, 0x41, 0xde, 0x00, 0x4b, 0x1b, 0x20, 0x05, 0x41, 0xdc,
  0x00, 0x46, 0x1b, 0x3a, 0x00, 0x00, 0x20, 0x0c, 0x41, 0x0e, 0x4b, 0x0d,
  0x00, 0x20, 0x0d, 0x21, 0x07, 0x20, 0x0c, 0x41, 0x01, 0x6a, 0x22, 0x0c,
  0x20, 0x0b, 0x6a, 0x22, 0x05, 0x20, 0x01, 0x49, 0x0d, 0x01, 0x0b, 0x0b,
  0x20, 0x0a, 0x41, 0x30, 0x6a, 0x20, 0x0d, 0x47, 0x04, 0x40, 0x20, 0x0d,
  0x41, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x0a, 0x10, 0x00, 0x22, 0x05, 0x36,
  0x02, 0x08, 0x20, 0x0a, 0x20, 0x05, 0x36, 0x02, 0x04, 0x20, 0x0a, 0x41,
  0xc2, 0xea, 0x03, 0x36, 0x02, 0x00, 0x20, 0x0a, 0x20, 0x0a, 0x41, 0x30,
  0x6a, 0x36, 0x02, 0x0c, 0x41, 0x06, 0x41, 0xdf, 0xb2, 0x02, 0x20, 0x0a,
  0x10, 0x22, 0x0b, 0x20, 0x0b, 0x41, 0x10, 0x6a, 0x22, 0x0b, 0x20, 0x01,
  0x49, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0a, 0x41, 0xb0, 0x10, 0x6a, 0x24,
  0x00, 0x0b, 0x6a, 0x01, 0x03, 0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22,
  0x01, 0x24, 0x00, 0x20, 0x01, 0x41, 0x00, 0x36, 0x02, 0x0c, 0x20, 0x01,
  0x20, 0x00, 0x36, 0x02, 0x04, 0x20, 0x01, 0x20, 0x00, 0x36, 0x02, 0x00,
  0x20, 0x01, 0x20, 0x00, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x01,
  0x21, 0x02, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x20,
  0x03, 0x41, 0x08, 0x6a, 0x22, 0x00, 0x20, 0x02, 0x28, 0x02, 0x04, 0x36,
  0x02, 0x00, 0x20, 0x00, 0x28, 0x02, 0x00, 0x41, 0x01, 0x3a, 0x00, 0x00,
  0x20, 0x02, 0x28, 0x02, 0x08, 0x41, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x03,
  0x41, 0x10, 0x6a, 0x24, 0x00, 0x20, 0x01, 0x41, 0x10, 0x6a, 0x24, 0x00,
  0x0b, 0x97, 0x01, 0x01, 0x04, 0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22,
  0x01, 0x24, 0x00, 0x20, 0x01, 0x41, 0x00, 0x36, 0x02, 0x0c, 0x20, 0x01,
  0x20, 0x00, 0x36, 0x02, 0x04, 0x20, 0x01, 0x20, 0x00, 0x36, 0x02, 0x00,
  0x20, 0x01, 0x20, 0x00, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x01,
  0x21, 0x03, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x02,
  0x7f, 0x20, 0x04, 0x41, 0x08, 0x6a, 0x22, 0x00, 0x20, 0x03, 0x28, 0x02,
  0x04, 0x36, 0x02, 0x00, 0x20, 0x00, 0x28, 0x02, 0x00, 0x2d, 0x00, 0x00,
  0x45, 0x0b, 0x04, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x20, 0x03, 0x28, 0x02,
  0x08, 0x22, 0x02, 0x2d, 0x00, 0x00, 0x22, 0x00, 0x41, 0x01, 0x47, 0x04,
  0x7f, 0x20, 0x00, 0x41, 0x02, 0x71, 0x0d, 0x01, 0x20, 0x02, 0x41, 0x02,
  0x3a, 0x00, 0x00, 0x41, 0x01, 0x05, 0x41, 0x00, 0x0b, 0x0c, 0x01, 0x0b,
  0x00, 0x0b, 0x21, 0x02, 0x0b, 0x20, 0x04, 0x41, 0x10, 0x6a, 0x24, 0x00,
  0x20, 0x01, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x20, 0x02, 0x0b, 0x4a, 0x01,
  0x02, 0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x10,
  0x00, 0x21, 0x04, 0x20, 0x03, 0x20, 0x02, 0x28, 0x02, 0x00, 0x36, 0x02,
  0x0c, 0x20, 0x03, 0x20, 0x04, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x04,
  0x36, 0x02, 0x04, 0x20, 0x03, 0x20, 0x00, 0x41, 0x02, 0x74, 0x41, 0xb0,
  0xea, 0x1a, 0x6a, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20, 0x00, 0x20,
  0x01, 0x20, 0x03, 0x10, 0x22, 0x20, 0x03, 0x41, 0x10, 0x6a, 0x24, 0x00,
  0x0b, 0x58, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0x20, 0x6b, 0x22, 0x04,
  0x24, 0x00, 0x10, 0x00, 0x21, 0x05, 0x20, 0x02, 0x28, 0x02, 0x00, 0x21,
  0x02, 0x20, 0x04, 0x20, 0x03, 0x28, 0x02, 0x00, 0x36, 0x02, 0x10, 0x20,
  0x04, 0x20, 0x02, 0x36, 0x02, 0x0c, 0x20, 0x04, 0x20, 0x05, 0x36, 0x02,
  0x08, 0x20, 0x04, 0x20, 0x05, 0x36, 0x02, 0x04, 0x20, 0x04, 0x20, 0x00,
  0x41, 0x02, 0x74, 0x41, 0xb0, 0xea, 0x1a, 0x6a, 0x28, 0x02, 0x00, 0x36,
  0x02, 0x00, 0x20, 0x00, 0x20, 0x01, 0x20, 0x04, 0x10, 0x22, 0x20, 0x04,
  0x41, 0x20, 0x6a, 0x24, 0x00, 0x0b, 0xe9, 0x21, 0x01, 0x4e, 0x7f, 0x20,
  0x00, 0x20, 0x01, 0x28, 0x00, 0x3c, 0x22, 0x02, 0x41, 0x18, 0x74, 0x20,
  0x02, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20,
  0x02, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x02, 0x41,
  0x18, 0x76, 0x72, 0x72, 0x22, 0x02, 0x20, 0x01, 0x28, 0x00, 0x34, 0x22,
  0x03, 0x41, 0x18, 0x74, 0x20, 0x03, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80,
  0xfc, 0x07, 0x71, 0x72, 0x20, 0x03, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe,
  0x03, 0x71, 0x20, 0x03, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22, 0x03, 0x73,
  0x20, 0x01, 0x28, 0x00, 0x28, 0x22, 0x04, 0x41, 0x18, 0x74, 0x20, 0x04,
  0x41, 0x08, 0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x04,
  0x41, 0x08, 0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x04, 0x41, 0x18,
  0x76, 0x72, 0x72, 0x22, 0x09, 0x20, 0x01, 0x28, 0x00, 0x10, 0x22, 0x04,
  0x41, 0x18, 0x74, 0x20, 0x04, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80, 0xfc,
  0x07, 0x71, 0x72, 0x20, 0x04, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe, 0x03,
  0x71, 0x20, 0x04, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22, 0x13, 0x20, 0x01,
  0x28, 0x00, 0x08, 0x22, 0x04, 0x41, 0x18, 0x74, 0x20, 0x04, 0x41, 0x08,
  0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x04, 0x41, 0x08,
  0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x04, 0x41, 0x18, 0x76, 0x72,
  0x72, 0x22, 0x10, 0x73, 0x73, 0x20, 0x02, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x04, 0x20, 0x01, 0x28, 0x00, 0x1c, 0x22, 0x07, 0x41, 0x18, 0x74, 0x20,
  0x07, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20,
  0x07, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x07, 0x41,
  0x18, 0x76, 0x72, 0x72, 0x22, 0x45, 0x20, 0x01, 0x28, 0x00, 0x14, 0x22,
  0x07, 0x41, 0x18, 0x74, 0x20, 0x07, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80,
  0xfc, 0x07, 0x71, 0x72, 0x20, 0x07, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe,
  0x03, 0x71, 0x20, 0x07, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22, 0x0a, 0x73,
  0x20, 0x03, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x07, 0x73, 0x20, 0x01,
  0x28, 0x00, 0x30, 0x22, 0x05, 0x41, 0x18, 0x74, 0x20, 0x05, 0x41, 0x08,
  0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x05, 0x41, 0x08,
  0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x05, 0x41, 0x18, 0x76, 0x72,
  0x72, 0x22, 0x11, 0x20, 0x09, 0x73, 0x20, 0x04, 0x73, 0x20, 0x01, 0x28,
  0x00, 0x24, 0x22, 0x05, 0x41, 0x18, 0x74, 0x20, 0x05, 0x41, 0x08, 0x74,
  0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x05, 0x41, 0x08, 0x76,
  0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x05, 0x41, 0x18, 0x76, 0x72, 0x72,
  0x22, 0x0e, 0x20, 0x45, 0x73, 0x20, 0x02, 0x73, 0x20, 0x01, 0x28, 0x00,
  0x38, 0x22, 0x05, 0x41, 0x18, 0x74, 0x20, 0x05, 0x41, 0x08, 0x74, 0x41,
  0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x05, 0x41, 0x08, 0x76, 0x41,
  0x80, 0xfe, 0x03, 0x71, 0x20, 0x05, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22,
  0x05, 0x20, 0x01, 0x28, 0x00, 0x0c, 0x22, 0x06, 0x41, 0x18, 0x74, 0x20,
  0x06, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20,
  0x06, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x06, 0x41,
  0x18, 0x76, 0x72, 0x72, 0x22, 0x0c, 0x20, 0x01, 0x28, 0x00, 0x04, 0x22,
  0x06, 0x41, 0x18, 0x74, 0x20, 0x06, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80,
  0xfc, 0x07, 0x71, 0x72, 0x20, 0x06, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe,
  0x03, 0x71, 0x20, 0x06, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22, 0x18, 0x73,
  0x20, 0x0e, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x06, 0x20, 0x01, 0x28,
  0x00, 0x18, 0x22, 0x08, 0x41, 0x18, 0x74, 0x20, 0x08, 0x41, 0x08, 0x74,
  0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x08, 0x41, 0x08, 0x76,
  0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x08, 0x41, 0x18, 0x76, 0x72, 0x72,
  0x22, 0x46, 0x20, 0x13, 0x73, 0x20, 0x11, 0x73, 0x73, 0x41, 0x01, 0x77,
  0x22, 0x08, 0x73, 0x41, 0x01, 0x77, 0x22, 0x12, 0x73, 0x41, 0x01, 0x77,
  0x22, 0x14, 0x73, 0x41, 0x01, 0x77, 0x22, 0x19, 0x20, 0x01, 0x28, 0x00,
  0x2c, 0x22, 0x0d, 0x41, 0x18, 0x74, 0x20, 0x0d, 0x41, 0x08, 0x74, 0x41,
  0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x0d, 0x41, 0x08, 0x76, 0x41,
  0x80, 0xfe, 0x03, 0x71, 0x20, 0x0d, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22,
  0x15, 0x20, 0x0e, 0x73, 0x20, 0x06, 0x73, 0x20, 0x01, 0x28, 0x00, 0x20,
  0x22, 0x0d, 0x41, 0x18, 0x74, 0x20, 0x0d, 0x41, 0x08, 0x74, 0x41, 0x80,
  0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x0d, 0x41, 0x08, 0x76, 0x41, 0x80,
  0xfe, 0x03, 0x71, 0x20, 0x0d, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22, 0x0b,
  0x20, 0x46, 0x73, 0x20, 0x05, 0x73, 0x20, 0x10, 0x20, 0x01, 0x28, 0x00,
  0x00, 0x22, 0x01, 0x41, 0x18, 0x74, 0x20, 0x01, 0x41, 0x08, 0x74, 0x41,
  0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x01, 0x41, 0x08, 0x76, 0x41,
  0x80, 0xfe, 0x03, 0x71, 0x20, 0x01, 0x41, 0x18, 0x76, 0x72, 0x72, 0x22,
  0x16, 0x73, 0x20, 0x0b, 0x73, 0x20, 0x03, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x01, 0x20, 0x0a, 0x20, 0x0c, 0x73, 0x20, 0x15, 0x73, 0x73, 0x41, 0x01,
  0x77, 0x22, 0x0d, 0x73, 0x41, 0x01, 0x77, 0x22, 0x1a, 0x73, 0x41, 0x01,
  0x77, 0x22, 0x1b, 0x20, 0x05, 0x20, 0x11, 0x73, 0x20, 0x08, 0x73, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x1c, 0x20, 0x02, 0x20, 0x06, 0x73, 0x20, 0x12,
  0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x1d, 0x73, 0x20, 0x04, 0x20, 0x08,
  0x73, 0x20, 0x14, 0x73, 0x20, 0x1d, 0x73, 0x41, 0x01, 0x77, 0x22, 0x1e,
  0x20, 0x07, 0x20, 0x12, 0x73, 0x20, 0x19, 0x73, 0x73, 0x41, 0x01, 0x77,
  0x22, 0x1f, 0x73, 0x20, 0x09, 0x20, 0x0b, 0x73, 0x20, 0x01, 0x73, 0x20,
  0x07, 0x73, 0x41, 0x01, 0x77, 0x22, 0x20, 0x20, 0x03, 0x20, 0x15, 0x73,
  0x20, 0x0d, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x21, 0x20, 0x01, 0x20,
  0x05, 0x73, 0x20, 0x1a, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x22, 0x20,
  0x06, 0x20, 0x0d, 0x73, 0x20, 0x1b, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x23, 0x20, 0x08, 0x20, 0x1a, 0x73, 0x20, 0x1c, 0x73, 0x73, 0x41, 0x01,
  0x77, 0x22, 0x24, 0x20, 0x12, 0x20, 0x1b, 0x73, 0x20, 0x1d, 0x73, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x25, 0x20, 0x14, 0x20, 0x1c, 0x73, 0x20, 0x1e,
  0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x26, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x27, 0x20, 0x01, 0x20, 0x04, 0x73, 0x20, 0x20, 0x73, 0x20, 0x19, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x28, 0x20, 0x07, 0x20, 0x0d, 0x73, 0x20, 0x21,
  0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x29, 0x20, 0x19, 0x20, 0x21, 0x73,
  0x73, 0x20, 0x14, 0x20, 0x20, 0x73, 0x20, 0x28, 0x73, 0x20, 0x1f, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x2a, 0x73, 0x41, 0x01, 0x77, 0x22, 0x2b, 0x73,
  0x20, 0x1e, 0x20, 0x28, 0x73, 0x20, 0x2a, 0x73, 0x20, 0x27, 0x73, 0x41,
  0x01, 0x77, 0x22, 0x2c, 0x20, 0x1f, 0x20, 0x29, 0x73, 0x20, 0x2b, 0x73,
  0x73, 0x41, 0x01, 0x77, 0x22, 0x2d, 0x73, 0x20, 0x1a, 0x20, 0x20, 0x73,
  0x20, 0x22, 0x73, 0x20, 0x29, 0x73, 0x41, 0x01, 0x77, 0x22, 0x2e, 0x20,
  0x1b, 0x20, 0x21, 0x73, 0x20, 0x23, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x2f, 0x20, 0x1c, 0x20, 0x22, 0x73, 0x20, 0x24, 0x73, 0x73, 0x41, 0x01,
  0x77, 0x22, 0x30, 0x20, 0x1d, 0x20, 0x23, 0x73, 0x20, 0x25, 0x73, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x31, 0x20, 0x1e, 0x20, 0x24, 0x73, 0x20, 0x26,
  0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x32, 0x20, 0x1f, 0x20, 0x25, 0x73,
  0x20, 0x27, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x33, 0x20, 0x26, 0x20,
  0x2a, 0x73, 0x20, 0x2c, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x34, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x35, 0x20, 0x22, 0x20, 0x28, 0x73, 0x20, 0x2e,
  0x73, 0x20, 0x2b, 0x73, 0x41, 0x01, 0x77, 0x22, 0x36, 0x20, 0x23, 0x20,
  0x29, 0x73, 0x20, 0x2f, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x37, 0x20,
  0x24, 0x20, 0x2e, 0x73, 0x20, 0x30, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x38, 0x20, 0x25, 0x20, 0x2f, 0x73, 0x20, 0x31, 0x73, 0x73, 0x41, 0x01,
  0x77, 0x22, 0x39, 0x20, 0x26, 0x20, 0x30, 0x73, 0x20, 0x32, 0x73, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x3a, 0x20, 0x27, 0x20, 0x31, 0x73, 0x20, 0x33,
  0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x3b, 0x73, 0x20, 0x2c, 0x20, 0x32,
  0x73, 0x20, 0x34, 0x73, 0x20, 0x3b, 0x73, 0x41, 0x01, 0x77, 0x22, 0x41,
  0x20, 0x2d, 0x20, 0x33, 0x73, 0x20, 0x35, 0x73, 0x73, 0x41, 0x01, 0x77,
  0x22, 0x47, 0x73, 0x20, 0x2a, 0x20, 0x2e, 0x73, 0x20, 0x36, 0x73, 0x20,
  0x2d, 0x73, 0x41, 0x01, 0x77, 0x22, 0x3c, 0x20, 0x2b, 0x20, 0x2f, 0x73,
  0x20, 0x37, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x3d, 0x20, 0x30, 0x20,
  0x36, 0x73, 0x20, 0x38, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x3e, 0x20,
  0x31, 0x20, 0x37, 0x73, 0x20, 0x39, 0x73, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x3f, 0x20, 0x32, 0x20, 0x38, 0x73, 0x20, 0x3a, 0x73, 0x73, 0x41, 0x01,
  0x77, 0x22, 0x48, 0x20, 0x33, 0x20, 0x39, 0x73, 0x20, 0x3b, 0x73, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x49, 0x20, 0x34, 0x20, 0x3a, 0x73, 0x20, 0x41,
  0x73, 0x73, 0x41, 0x01, 0x77, 0x22, 0x4d, 0x73, 0x41, 0x01, 0x77, 0x22,
  0x4e, 0x20, 0x2c, 0x20, 0x36, 0x73, 0x20, 0x3c, 0x73, 0x20, 0x35, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x40, 0x20, 0x34, 0x20, 0x3c, 0x73, 0x73, 0x20,
  0x47, 0x73, 0x41, 0x01, 0x77, 0x22, 0x4a, 0x20, 0x2d, 0x20, 0x37, 0x73,
  0x20, 0x3d, 0x73, 0x20, 0x40, 0x73, 0x41, 0x01, 0x77, 0x22, 0x42, 0x20,
  0x3e, 0x20, 0x39, 0x20, 0x32, 0x20, 0x27, 0x20, 0x2a, 0x20, 0x29, 0x20,
  0x22, 0x20, 0x1b, 0x20, 0x08, 0x20, 0x02, 0x20, 0x09, 0x20, 0x0a, 0x20,
  0x00, 0x28, 0x02, 0x10, 0x22, 0x4f, 0x20, 0x16, 0x20, 0x00, 0x28, 0x02,
  0x00, 0x22, 0x43, 0x41, 0x05, 0x77, 0x6a, 0x6a, 0x20, 0x00, 0x28, 0x02,
  0x04, 0x22, 0x4b, 0x20, 0x00, 0x28, 0x02, 0x0c, 0x22, 0x44, 0x20, 0x00,
  0x28, 0x02, 0x08, 0x22, 0x16, 0x73, 0x71, 0x20, 0x44, 0x73, 0x6a, 0x41,
  0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x17, 0x41, 0x1e, 0x77, 0x22,
  0x0f, 0x6a, 0x20, 0x0c, 0x20, 0x4b, 0x41, 0x1e, 0x77, 0x22, 0x0a, 0x6a,
  0x20, 0x18, 0x20, 0x44, 0x6a, 0x20, 0x0a, 0x20, 0x16, 0x73, 0x20, 0x43,
  0x71, 0x20, 0x16, 0x73, 0x6a, 0x20, 0x17, 0x41, 0x05, 0x77, 0x6a, 0x41,
  0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x18, 0x20, 0x0f, 0x20, 0x43,
  0x41, 0x1e, 0x77, 0x22, 0x0c, 0x73, 0x71, 0x20, 0x0c, 0x73, 0x6a, 0x20,
  0x10, 0x20, 0x16, 0x6a, 0x20, 0x17, 0x20, 0x0a, 0x20, 0x0c, 0x73, 0x71,
  0x20, 0x0a, 0x73, 0x6a, 0x20, 0x18, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99,
  0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x17, 0x41, 0x05, 0x77, 0x6a, 0x41,
  0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x4c, 0x20, 0x17, 0x41, 0x1e,
  0x77, 0x22, 0x0a, 0x20, 0x18, 0x41, 0x1e, 0x77, 0x22, 0x10, 0x73, 0x71,
  0x20, 0x10, 0x73, 0x6a, 0x20, 0x0c, 0x20, 0x13, 0x6a, 0x20, 0x17, 0x20,
  0x0f, 0x20, 0x10, 0x73, 0x71, 0x20, 0x0f, 0x73, 0x6a, 0x20, 0x4c, 0x41,
  0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x0c,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22,
  0x13, 0x41, 0x1e, 0x77, 0x22, 0x0f, 0x6a, 0x20, 0x0b, 0x20, 0x4c, 0x41,
  0x1e, 0x77, 0x22, 0x09, 0x6a, 0x20, 0x10, 0x20, 0x46, 0x6a, 0x20, 0x0c,
  0x20, 0x09, 0x20, 0x0a, 0x73, 0x71, 0x20, 0x0a, 0x73, 0x6a, 0x20, 0x13,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22,
  0x10, 0x20, 0x0f, 0x20, 0x0c, 0x41, 0x1e, 0x77, 0x22, 0x0b, 0x73, 0x71,
  0x20, 0x0b, 0x73, 0x6a, 0x20, 0x0a, 0x20, 0x45, 0x6a, 0x20, 0x13, 0x20,
  0x09, 0x20, 0x0b, 0x73, 0x71, 0x20, 0x09, 0x73, 0x6a, 0x20, 0x10, 0x41,
  0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x0c,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22,
  0x13, 0x20, 0x0c, 0x41, 0x1e, 0x77, 0x22, 0x09, 0x20, 0x10, 0x41, 0x1e,
  0x77, 0x22, 0x0a, 0x73, 0x71, 0x20, 0x0a, 0x73, 0x6a, 0x20, 0x0b, 0x20,
  0x0e, 0x6a, 0x20, 0x0c, 0x20, 0x0a, 0x20, 0x0f, 0x73, 0x71, 0x20, 0x0f,
  0x73, 0x6a, 0x20, 0x13, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89,
  0xd4, 0x05, 0x6a, 0x22, 0x0b, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3,
  0x89, 0xd4, 0x05, 0x6a, 0x22, 0x0f, 0x41, 0x1e, 0x77, 0x22, 0x0e, 0x6a,
  0x20, 0x03, 0x20, 0x13, 0x41, 0x1e, 0x77, 0x22, 0x02, 0x6a, 0x20, 0x0a,
  0x20, 0x15, 0x6a, 0x20, 0x0b, 0x20, 0x02, 0x20, 0x09, 0x73, 0x71, 0x20,
  0x09, 0x73, 0x6a, 0x20, 0x0f, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3,
  0x89, 0xd4, 0x05, 0x6a, 0x22, 0x15, 0x20, 0x0e, 0x20, 0x0b, 0x41, 0x1e,
  0x77, 0x22, 0x03, 0x73, 0x71, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x09, 0x20,
  0x11, 0x6a, 0x20, 0x0f, 0x20, 0x02, 0x20, 0x03, 0x73, 0x71, 0x20, 0x02,
  0x73, 0x6a, 0x20, 0x15, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89,
  0xd4, 0x05, 0x6a, 0x22, 0x11, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3,
  0x89, 0xd4, 0x05, 0x6a, 0x22, 0x0b, 0x20, 0x11, 0x41, 0x1e, 0x77, 0x22,
  0x02, 0x20, 0x15, 0x41, 0x1e, 0x77, 0x22, 0x09, 0x73, 0x71, 0x20, 0x09,
  0x73, 0x6a, 0x20, 0x03, 0x20, 0x05, 0x6a, 0x20, 0x11, 0x20, 0x09, 0x20,
  0x0e, 0x73, 0x71, 0x20, 0x0e, 0x73, 0x6a, 0x20, 0x0b, 0x41, 0x05, 0x77,
  0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x11, 0x41, 0x05,
  0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x0e, 0x41,
  0x1e, 0x77, 0x22, 0x03, 0x6a, 0x20, 0x02, 0x20, 0x06, 0x6a, 0x20, 0x0e,
  0x20, 0x11, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x20, 0x0b, 0x41, 0x1e, 0x77,
  0x22, 0x06, 0x73, 0x71, 0x20, 0x06, 0x73, 0x6a, 0x20, 0x01, 0x20, 0x09,
  0x6a, 0x20, 0x11, 0x20, 0x02, 0x20, 0x06, 0x73, 0x71, 0x20, 0x02, 0x73,
  0x6a, 0x20, 0x0e, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4,
  0x05, 0x6a, 0x22, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89,
  0xd4, 0x05, 0x6a, 0x22, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x08, 0x20, 0x01,
  0x41, 0x1e, 0x77, 0x22, 0x09, 0x73, 0x20, 0x04, 0x20, 0x06, 0x6a, 0x20,
  0x01, 0x20, 0x03, 0x20, 0x05, 0x73, 0x71, 0x20, 0x05, 0x73, 0x6a, 0x20,
  0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a,
  0x22, 0x01, 0x73, 0x6a, 0x20, 0x05, 0x20, 0x0d, 0x6a, 0x20, 0x02, 0x20,
  0x03, 0x20, 0x09, 0x73, 0x71, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x01, 0x41,
  0x05, 0x77, 0x6a, 0x41, 0x99, 0xf3, 0x89, 0xd4, 0x05, 0x6a, 0x22, 0x02,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22,
  0x03, 0x41, 0x1e, 0x77, 0x22, 0x04, 0x6a, 0x20, 0x08, 0x20, 0x1a, 0x6a,
  0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x20, 0x01, 0x41, 0x1e, 0x77,
  0x22, 0x01, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x07, 0x20, 0x09, 0x6a,
  0x20, 0x01, 0x20, 0x08, 0x73, 0x20, 0x02, 0x73, 0x6a, 0x20, 0x03, 0x41,
  0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x02,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22,
  0x03, 0x41, 0x1e, 0x77, 0x22, 0x07, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22,
  0x06, 0x73, 0x20, 0x01, 0x20, 0x12, 0x6a, 0x20, 0x04, 0x20, 0x05, 0x73,
  0x20, 0x02, 0x73, 0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1,
  0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x01, 0x73, 0x6a, 0x20, 0x05, 0x20,
  0x20, 0x6a, 0x20, 0x04, 0x20, 0x06, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20,
  0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a,
  0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06,
  0x6a, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x04, 0x6a, 0x20, 0x07, 0x20,
  0x21, 0x6a, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x20, 0x01, 0x41,
  0x1e, 0x77, 0x22, 0x01, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x06, 0x20,
  0x14, 0x6a, 0x20, 0x01, 0x20, 0x07, 0x73, 0x20, 0x02, 0x73, 0x6a, 0x20,
  0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a,
  0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06,
  0x6a, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x07, 0x20, 0x02, 0x41, 0x1e,
  0x77, 0x22, 0x06, 0x73, 0x20, 0x01, 0x20, 0x1c, 0x6a, 0x20, 0x04, 0x20,
  0x05, 0x73, 0x20, 0x02, 0x73, 0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a,
  0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x01, 0x73, 0x6a, 0x20,
  0x05, 0x20, 0x19, 0x6a, 0x20, 0x04, 0x20, 0x06, 0x73, 0x20, 0x03, 0x73,
  0x6a, 0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6,
  0x06, 0x6a, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7,
  0xf6, 0x06, 0x6a, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x04, 0x6a, 0x20,
  0x07, 0x20, 0x28, 0x6a, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x20,
  0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20,
  0x06, 0x20, 0x1d, 0x6a, 0x20, 0x01, 0x20, 0x07, 0x73, 0x20, 0x02, 0x73,
  0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6,
  0x06, 0x6a, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7,
  0xf6, 0x06, 0x6a, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x07, 0x20, 0x02,
  0x41, 0x1e, 0x77, 0x22, 0x06, 0x73, 0x20, 0x01, 0x20, 0x23, 0x6a, 0x20,
  0x04, 0x20, 0x05, 0x73, 0x20, 0x02, 0x73, 0x6a, 0x20, 0x03, 0x41, 0x05,
  0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x01, 0x73,
  0x6a, 0x20, 0x05, 0x20, 0x1e, 0x6a, 0x20, 0x04, 0x20, 0x06, 0x73, 0x20,
  0x03, 0x73, 0x6a, 0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7,
  0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1,
  0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x04,
  0x6a, 0x20, 0x2e, 0x20, 0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x6a, 0x20,
  0x06, 0x20, 0x24, 0x6a, 0x20, 0x01, 0x20, 0x07, 0x73, 0x20, 0x02, 0x73,
  0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6,
  0x06, 0x6a, 0x22, 0x05, 0x20, 0x04, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22,
  0x06, 0x73, 0x73, 0x6a, 0x20, 0x07, 0x20, 0x1f, 0x6a, 0x20, 0x01, 0x20,
  0x06, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x05, 0x41, 0x05, 0x77, 0x6a,
  0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x03, 0x41, 0x05, 0x77,
  0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a, 0x22, 0x01, 0x20, 0x03,
  0x41, 0x1e, 0x77, 0x22, 0x02, 0x72, 0x20, 0x05, 0x41, 0x1e, 0x77, 0x22,
  0x08, 0x71, 0x20, 0x01, 0x20, 0x02, 0x71, 0x72, 0x6a, 0x20, 0x06, 0x20,
  0x25, 0x6a, 0x20, 0x04, 0x20, 0x08, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20,
  0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa1, 0xd7, 0xe7, 0xf6, 0x06, 0x6a,
  0x22, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07,
  0x6b, 0x22, 0x04, 0x41, 0x1e, 0x77, 0x22, 0x07, 0x6a, 0x20, 0x2b, 0x20,
  0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x6a, 0x20, 0x03, 0x41, 0x1e, 0x77,
  0x22, 0x05, 0x20, 0x08, 0x20, 0x2f, 0x6a, 0x20, 0x01, 0x20, 0x03, 0x72,
  0x20, 0x02, 0x71, 0x20, 0x01, 0x20, 0x03, 0x71, 0x72, 0x6a, 0x20, 0x04,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22,
  0x03, 0x20, 0x07, 0x72, 0x71, 0x20, 0x03, 0x20, 0x07, 0x71, 0x72, 0x6a,
  0x20, 0x02, 0x20, 0x26, 0x6a, 0x20, 0x04, 0x20, 0x05, 0x72, 0x20, 0x01,
  0x71, 0x20, 0x04, 0x20, 0x05, 0x71, 0x72, 0x6a, 0x20, 0x03, 0x41, 0x05,
  0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x01, 0x41,
  0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x02,
  0x20, 0x01, 0x41, 0x1e, 0x77, 0x22, 0x04, 0x72, 0x20, 0x03, 0x41, 0x1e,
  0x77, 0x22, 0x03, 0x71, 0x20, 0x02, 0x20, 0x04, 0x71, 0x72, 0x6a, 0x20,
  0x05, 0x20, 0x30, 0x6a, 0x20, 0x01, 0x20, 0x03, 0x72, 0x20, 0x07, 0x71,
  0x20, 0x01, 0x20, 0x03, 0x71, 0x72, 0x6a, 0x20, 0x02, 0x41, 0x05, 0x77,
  0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x01, 0x41, 0x05,
  0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x07, 0x41,
  0x1e, 0x77, 0x22, 0x05, 0x6a, 0x20, 0x2c, 0x20, 0x02, 0x41, 0x1e, 0x77,
  0x22, 0x02, 0x6a, 0x20, 0x01, 0x41, 0x1e, 0x77, 0x22, 0x06, 0x20, 0x03,
  0x20, 0x36, 0x6a, 0x20, 0x01, 0x20, 0x02, 0x72, 0x20, 0x04, 0x71, 0x20,
  0x01, 0x20, 0x02, 0x71, 0x72, 0x6a, 0x20, 0x07, 0x41, 0x05, 0x77, 0x6a,
  0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x01, 0x20, 0x05, 0x72,
  0x71, 0x20, 0x01, 0x20, 0x05, 0x71, 0x72, 0x6a, 0x20, 0x04, 0x20, 0x31,
  0x6a, 0x20, 0x06, 0x20, 0x07, 0x72, 0x20, 0x02, 0x71, 0x20, 0x06, 0x20,
  0x07, 0x71, 0x72, 0x6a, 0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4,
  0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41,
  0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x03, 0x20, 0x02, 0x41, 0x1e,
  0x77, 0x22, 0x04, 0x72, 0x20, 0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x71,
  0x20, 0x03, 0x20, 0x04, 0x71, 0x72, 0x6a, 0x20, 0x06, 0x20, 0x37, 0x6a,
  0x20, 0x01, 0x20, 0x02, 0x72, 0x20, 0x05, 0x71, 0x20, 0x01, 0x20, 0x02,
  0x71, 0x72, 0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86,
  0x91, 0x87, 0x07, 0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4,
  0x86, 0x91, 0x87, 0x07, 0x6b, 0x22, 0x07, 0x41, 0x1e, 0x77, 0x22, 0x05,
  0x6a, 0x20, 0x33, 0x20, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x03, 0x6a, 0x20,
  0x02, 0x41, 0x1e, 0x77, 0x22, 0x06, 0x20, 0x01, 0x20, 0x2d, 0x6a, 0x20,
  0x02, 0x20, 0x03, 0x72, 0x20, 0x04, 0x71, 0x20, 0x02, 0x20, 0x03, 0x71,
  0x72, 0x6a, 0x20, 0x07, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91,
  0x87, 0x07, 0x6b, 0x22, 0x01, 0x20, 0x05, 0x72, 0x71, 0x20, 0x01, 0x20,
  0x05, 0x71, 0x72, 0x6a, 0x20, 0x04, 0x20, 0x38, 0x6a, 0x20, 0x06, 0x20,
  0x07, 0x72, 0x20, 0x03, 0x71, 0x20, 0x06, 0x20, 0x07, 0x71, 0x72, 0x6a,
  0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07,
  0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87,
  0x07, 0x6b, 0x22, 0x03, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x04, 0x72,
  0x20, 0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x71, 0x20, 0x03, 0x20, 0x04,
  0x71, 0x72, 0x6a, 0x20, 0x06, 0x20, 0x3c, 0x6a, 0x20, 0x01, 0x20, 0x02,
  0x72, 0x20, 0x05, 0x71, 0x20, 0x01, 0x20, 0x02, 0x71, 0x72, 0x6a, 0x20,
  0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b,
  0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07,
  0x6b, 0x22, 0x07, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x6a, 0x20, 0x04, 0x20,
  0x3d, 0x6a, 0x20, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x03, 0x20, 0x07, 0x20,
  0x02, 0x41, 0x1e, 0x77, 0x22, 0x06, 0x72, 0x71, 0x20, 0x06, 0x20, 0x07,
  0x71, 0x72, 0x6a, 0x20, 0x01, 0x20, 0x34, 0x6a, 0x20, 0x02, 0x20, 0x03,
  0x72, 0x20, 0x04, 0x71, 0x20, 0x02, 0x20, 0x03, 0x71, 0x72, 0x6a, 0x20,
  0x07, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07, 0x6b,
  0x22, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07,
  0x6b, 0x22, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x07, 0x20, 0x01, 0x41, 0x1e,
  0x77, 0x22, 0x04, 0x73, 0x20, 0x03, 0x20, 0x3a, 0x6a, 0x20, 0x01, 0x20,
  0x05, 0x72, 0x20, 0x06, 0x71, 0x20, 0x01, 0x20, 0x05, 0x71, 0x72, 0x6a,
  0x20, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87, 0x07,
  0x6b, 0x22, 0x01, 0x73, 0x6a, 0x20, 0x06, 0x20, 0x35, 0x6a, 0x20, 0x02,
  0x20, 0x04, 0x72, 0x20, 0x05, 0x71, 0x20, 0x02, 0x20, 0x04, 0x71, 0x72,
  0x6a, 0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xa4, 0x86, 0x91, 0x87,
  0x07, 0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4,
  0xac, 0x03, 0x6b, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x6a, 0x20,
  0x07, 0x20, 0x40, 0x6a, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x06, 0x20,
  0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20,
  0x04, 0x20, 0x3b, 0x6a, 0x20, 0x01, 0x20, 0x07, 0x73, 0x20, 0x02, 0x73,
  0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac,
  0x03, 0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4,
  0xac, 0x03, 0x6b, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x04, 0x20, 0x02,
  0x41, 0x1e, 0x77, 0x22, 0x07, 0x73, 0x20, 0x01, 0x20, 0x3f, 0x6a, 0x20,
  0x05, 0x20, 0x06, 0x73, 0x20, 0x02, 0x73, 0x6a, 0x20, 0x03, 0x41, 0x05,
  0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x01, 0x73,
  0x6a, 0x20, 0x06, 0x20, 0x41, 0x6a, 0x20, 0x05, 0x20, 0x07, 0x73, 0x20,
  0x03, 0x73, 0x6a, 0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc,
  0xf4, 0xac, 0x03, 0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa,
  0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x05,
  0x6a, 0x20, 0x04, 0x20, 0x47, 0x6a, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22,
  0x06, 0x20, 0x01, 0x41, 0x1e, 0x77, 0x22, 0x01, 0x73, 0x20, 0x03, 0x73,
  0x6a, 0x20, 0x07, 0x20, 0x48, 0x6a, 0x20, 0x01, 0x20, 0x04, 0x73, 0x20,
  0x02, 0x73, 0x6a, 0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc,
  0xf4, 0xac, 0x03, 0x6b, 0x22, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa,
  0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x04,
  0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x07, 0x73, 0x20, 0x01, 0x20, 0x38,
  0x20, 0x3c, 0x73, 0x20, 0x3e, 0x73, 0x20, 0x42, 0x73, 0x41, 0x01, 0x77,
  0x22, 0x01, 0x6a, 0x20, 0x05, 0x20, 0x06, 0x73, 0x20, 0x02, 0x73, 0x6a,
  0x20, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03,
  0x6b, 0x22, 0x02, 0x73, 0x6a, 0x20, 0x06, 0x20, 0x49, 0x6a, 0x20, 0x05,
  0x20, 0x07, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x02, 0x41, 0x05, 0x77,
  0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x03, 0x41, 0x05,
  0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x05, 0x41,
  0x1e, 0x77, 0x22, 0x06, 0x6a, 0x20, 0x04, 0x20, 0x4d, 0x6a, 0x20, 0x03,
  0x41, 0x1e, 0x77, 0x22, 0x08, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x02,
  0x73, 0x20, 0x05, 0x73, 0x6a, 0x20, 0x07, 0x20, 0x39, 0x20, 0x3d, 0x73,
  0x20, 0x3f, 0x73, 0x20, 0x01, 0x73, 0x41, 0x01, 0x77, 0x22, 0x07, 0x6a,
  0x20, 0x02, 0x20, 0x04, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x05, 0x41,
  0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x03,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22,
  0x04, 0x41, 0x1e, 0x77, 0x22, 0x05, 0x20, 0x03, 0x41, 0x1e, 0x77, 0x22,
  0x12, 0x73, 0x20, 0x35, 0x20, 0x3d, 0x73, 0x20, 0x42, 0x73, 0x20, 0x4a,
  0x73, 0x41, 0x01, 0x77, 0x22, 0x14, 0x20, 0x02, 0x6a, 0x20, 0x06, 0x20,
  0x08, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x04, 0x41, 0x05, 0x77, 0x6a,
  0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x02, 0x73, 0x6a, 0x20,
  0x08, 0x20, 0x3a, 0x20, 0x3e, 0x73, 0x20, 0x48, 0x73, 0x20, 0x07, 0x73,
  0x41, 0x01, 0x77, 0x22, 0x08, 0x6a, 0x20, 0x06, 0x20, 0x12, 0x73, 0x20,
  0x04, 0x73, 0x6a, 0x20, 0x02, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc,
  0xf4, 0xac, 0x03, 0x6b, 0x22, 0x03, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa,
  0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x04, 0x41, 0x1e, 0x77, 0x22, 0x06,
  0x20, 0x4f, 0x6a, 0x36, 0x02, 0x10, 0x20, 0x00, 0x20, 0x44, 0x20, 0x12,
  0x20, 0x3e, 0x20, 0x40, 0x73, 0x20, 0x01, 0x73, 0x20, 0x14, 0x73, 0x41,
  0x01, 0x77, 0x22, 0x12, 0x6a, 0x20, 0x02, 0x41, 0x1e, 0x77, 0x22, 0x01,
  0x20, 0x05, 0x73, 0x20, 0x03, 0x73, 0x6a, 0x20, 0x04, 0x41, 0x05, 0x77,
  0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x02, 0x41, 0x1e,
  0x77, 0x22, 0x14, 0x6a, 0x36, 0x02, 0x0c, 0x20, 0x00, 0x20, 0x16, 0x20,
  0x3b, 0x20, 0x3f, 0x73, 0x20, 0x49, 0x73, 0x20, 0x08, 0x73, 0x41, 0x01,
  0x77, 0x20, 0x05, 0x6a, 0x20, 0x03, 0x41, 0x1e, 0x77, 0x22, 0x03, 0x20,
  0x01, 0x73, 0x20, 0x04, 0x73, 0x6a, 0x20, 0x02, 0x41, 0x05, 0x77, 0x6a,
  0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22, 0x04, 0x41, 0x1e, 0x77,
  0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20, 0x4b, 0x20, 0x40, 0x20, 0x41,
  0x73, 0x20, 0x4a, 0x73, 0x20, 0x4e, 0x73, 0x41, 0x01, 0x77, 0x20, 0x01,
  0x6a, 0x20, 0x03, 0x20, 0x06, 0x73, 0x20, 0x02, 0x73, 0x6a, 0x20, 0x04,
  0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03, 0x6b, 0x22,
  0x01, 0x6a, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x43, 0x20, 0x3f, 0x20,
  0x42, 0x73, 0x20, 0x07, 0x73, 0x20, 0x12, 0x73, 0x41, 0x01, 0x77, 0x6a,
  0x20, 0x03, 0x6a, 0x20, 0x06, 0x20, 0x14, 0x73, 0x20, 0x04, 0x73, 0x6a,
  0x20, 0x01, 0x41, 0x05, 0x77, 0x6a, 0x41, 0xaa, 0xfc, 0xf4, 0xac, 0x03,
  0x6b, 0x36, 0x02, 0x00, 0x0b, 0x03, 0x00, 0x01, 0x0b, 0xee, 0x02, 0x02,
  0x01, 0x7e, 0x03, 0x7f, 0x20, 0x00, 0x41, 0x18, 0x6a, 0x22, 0x05, 0x20,
  0x00, 0x28, 0x02, 0x00, 0x41, 0x3f, 0x71, 0x22, 0x04, 0x6a, 0x41, 0x80,
  0x01, 0x3a, 0x00, 0x00, 0x20, 0x04, 0x41, 0x01, 0x6a, 0x21, 0x03, 0x02,
  0x7f, 0x20, 0x04, 0x41, 0x38, 0x4f, 0x04, 0x40, 0x20, 0x00, 0x20, 0x03,
  0x6a, 0x41, 0x18, 0x6a, 0x41, 0x00, 0x20, 0x04, 0x41, 0x3f, 0x73, 0x10,
  0x29, 0x1a, 0x20, 0x00, 0x20, 0x05, 0x10, 0x2d, 0x41, 0x00, 0x21, 0x03,
  0x0b, 0x20, 0x00, 0x20, 0x03, 0x6a, 0x41, 0x18, 0x6a, 0x0b, 0x41, 0x00,
  0x41, 0x38, 0x20, 0x03, 0x6b, 0x10, 0x29, 0x1a, 0x20, 0x00, 0x20, 0x00,
  0x29, 0x03, 0x00, 0x22, 0x02, 0x42, 0x35, 0x88, 0x3c, 0x00, 0x57, 0x20,
  0x00, 0x20, 0x02, 0x42, 0x2d, 0x88, 0x3c, 0x00, 0x56, 0x20, 0x00, 0x20,
  0x02, 0x42, 0x25, 0x88, 0x3c, 0x00, 0x55, 0x20, 0x00, 0x20, 0x02, 0x42,
  0x1d, 0x88, 0x3c, 0x00, 0x54, 0x20, 0x00, 0x20, 0x02, 0x42, 0x15, 0x88,
  0x3c, 0x00, 0x53, 0x20, 0x00, 0x20, 0x02, 0x42, 0x0d, 0x88, 0x3c, 0x00,
  0x52, 0x20, 0x00, 0x20, 0x02, 0x42, 0x05, 0x88, 0x3c, 0x00, 0x51, 0x20,
  0x00, 0x20, 0x02, 0x42, 0x03, 0x86, 0x22, 0x02, 0x3c, 0x00, 0x50, 0x20,
  0x00, 0x20, 0x02, 0x37, 0x03, 0x00, 0x20, 0x00, 0x20, 0x05, 0x10, 0x2d,
  0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x08, 0x3a, 0x00, 0x00, 0x20, 0x01,
  0x20, 0x00, 0x28, 0x02, 0x08, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x01, 0x20,
  0x01, 0x20, 0x00, 0x2f, 0x01, 0x0a, 0x3a, 0x00, 0x02, 0x20, 0x01, 0x20,
  0x00, 0x2d, 0x00, 0x0b, 0x3a, 0x00, 0x03, 0x20, 0x01, 0x20, 0x00, 0x28,
  0x02, 0x0c, 0x3a, 0x00, 0x04, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x0c,
  0x41, 0x08, 0x76, 0x3a, 0x00, 0x05, 0x20, 0x01, 0x20, 0x00, 0x2f, 0x01,
  0x0e, 0x3a, 0x00, 0x06, 0x20, 0x01, 0x20, 0x00, 0x2d, 0x00, 0x0f, 0x3a,
  0x00, 0x07, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x10, 0x3a, 0x00, 0x08,
  0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x10, 0x41, 0x08, 0x76, 0x3a, 0x00,
  0x09, 0x20, 0x01, 0x20, 0x00, 0x2f, 0x01, 0x12, 0x3a, 0x00, 0x0a, 0x20,
  0x01, 0x20, 0x00, 0x2d, 0x00, 0x13, 0x3a, 0x00, 0x0b, 0x20, 0x01, 0x20,
  0x00, 0x28, 0x02, 0x14, 0x3a, 0x00, 0x0c, 0x20, 0x01, 0x20, 0x00, 0x28,
  0x02, 0x14, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x0d, 0x20, 0x01, 0x20, 0x00,
  0x2f, 0x01, 0x16, 0x3a, 0x00, 0x0e, 0x20, 0x01, 0x20, 0x00, 0x2d, 0x00,
  0x17, 0x3a, 0x00, 0x0f, 0x0b, 0x5d, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41,
  0x20, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x10, 0x00, 0x21, 0x05, 0x20, 0x01,
  0x28, 0x02, 0x00, 0x21, 0x01, 0x20, 0x02, 0x28, 0x02, 0x00, 0x21, 0x02,
  0x20, 0x04, 0x20, 0x03, 0x28, 0x02, 0x00, 0x36, 0x02, 0x14, 0x20, 0x04,
  0x20, 0x02, 0x36, 0x02, 0x10, 0x20, 0x04, 0x20, 0x01, 0x36, 0x02, 0x0c,
  0x20, 0x04, 0x20, 0x05, 0x36, 0x02, 0x08, 0x20, 0x04, 0x20, 0x05, 0x36,
  0x02, 0x04, 0x20, 0x04, 0x41, 0xf3, 0xe3, 0x03, 0x36, 0x02, 0x00, 0x41,
  0x03, 0x20, 0x00, 0x20, 0x04, 0x10, 0x22, 0x20, 0x04, 0x41, 0x20, 0x6a,
  0x24, 0x00, 0x0b, 0x09, 0x00, 0x41, 0x9e, 0xb4, 0x02, 0x10, 0x48, 0x00,
  0x0b, 0xbd, 0x01, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22,
  0x03, 0x24, 0x00, 0x02, 0x40, 0x20, 0x02, 0x20, 0x00, 0x2d, 0x00, 0x0b,
  0x41, 0x07, 0x76, 0x04, 0x7f, 0x20, 0x00, 0x28, 0x02, 0x08, 0x41, 0xff,
  0xff, 0xff, 0xff, 0x07, 0x71, 0x41, 0x01, 0x6b, 0x05, 0x41, 0x0a, 0x0b,
  0x22, 0x04, 0x4d, 0x04, 0x40, 0x02, 0x7f, 0x20, 0x00, 0x2d, 0x00, 0x0b,
  0x41, 0x07, 0x76, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02, 0x00, 0x0c, 0x01,
  0x0b, 0x20, 0x00, 0x0b, 0x20, 0x01, 0x20, 0x02, 0x10, 0x96, 0x01, 0x21,
  0x01, 0x20, 0x03, 0x41, 0x00, 0x3a, 0x00, 0x0f, 0x20, 0x01, 0x20, 0x02,
  0x6a, 0x20, 0x03, 0x2d, 0x00, 0x0f, 0x3a, 0x00, 0x00, 0x02, 0x40, 0x20,
  0x00, 0x2d, 0x00, 0x0b, 0x41, 0x07, 0x76, 0x04, 0x40, 0x20, 0x00, 0x20,
  0x02, 0x36, 0x02, 0x04, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x20, 0x02, 0x3a,
  0x00, 0x0b, 0x0b, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x20, 0x04, 0x20, 0x02,
  0x20, 0x04, 0x6b, 0x02, 0x7f, 0x20, 0x00, 0x2d, 0x00, 0x0b, 0x41, 0x07,
  0x76, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02, 0x04, 0x0c, 0x01, 0x0b, 0x20,
  0x00, 0x2d, 0x00, 0x0b, 0x0b, 0x22, 0x00, 0x20, 0x00, 0x20, 0x02, 0x20,
  0x01, 0x10, 0x7e, 0x0b, 0x20, 0x03, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x0b,
  0x7f, 0x01, 0x03, 0x7f, 0x20, 0x00, 0x21, 0x01, 0x02, 0x40, 0x20, 0x00,
  0x41, 0x03, 0x71, 0x04, 0x40, 0x03, 0x40, 0x20, 0x01, 0x2d, 0x00, 0x00,
  0x45, 0x0d, 0x02, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x22, 0x01, 0x41, 0x03,
  0x71, 0x0d, 0x00, 0x0b, 0x0b, 0x03, 0x40, 0x20, 0x01, 0x22, 0x02, 0x41,
  0x04, 0x6a, 0x21, 0x01, 0x20, 0x02, 0x28, 0x02, 0x00, 0x22, 0x03, 0x41,
  0x7f, 0x73, 0x20, 0x03, 0x41, 0x81, 0x82, 0x84, 0x08, 0x6b, 0x71, 0x41,
  0x80, 0x81, 0x82, 0x84, 0x78, 0x71, 0x45, 0x0d, 0x00, 0x0b, 0x20, 0x03,
  0x41, 0xff, 0x01, 0x71, 0x45, 0x04, 0x40, 0x20, 0x02, 0x20, 0x00, 0x6b,
  0x0f, 0x0b, 0x03, 0x40, 0x20, 0x02, 0x2d, 0x00, 0x01, 0x21, 0x03, 0x20,
  0x02, 0x41, 0x01, 0x6a, 0x22, 0x01, 0x21, 0x02, 0x20, 0x03, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x01, 0x20, 0x00, 0x6b, 0x0b, 0x83, 0x01, 0x01, 0x02,
  0x7f, 0x23, 0x00, 0x41, 0x30, 0x6b, 0x22, 0x05, 0x24, 0x00, 0x20, 0x05,
  0x20, 0x04, 0x36, 0x02, 0x2c, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x28,
  0x20, 0x05, 0x20, 0x05, 0x29, 0x03, 0x28, 0x37, 0x03, 0x20, 0x20, 0x02,
  0x20, 0x05, 0x41, 0x20, 0x6a, 0x10, 0xa7, 0x01, 0x22, 0x06, 0x04, 0x40,
  0x10, 0x00, 0x21, 0x02, 0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0x1c, 0x20,
  0x05, 0x20, 0x03, 0x36, 0x02, 0x18, 0x20, 0x05, 0x20, 0x04, 0x36, 0x02,
  0x14, 0x20, 0x05, 0x20, 0x00, 0x36, 0x02, 0x10, 0x20, 0x05, 0x20, 0x01,
  0x36, 0x02, 0x0c, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x08, 0x20, 0x05,
  0x20, 0x02, 0x36, 0x02, 0x04, 0x20, 0x05, 0x41, 0xd4, 0xf7, 0x03, 0x36,
  0x02, 0x00, 0x41, 0x04, 0x41, 0x90, 0xb2, 0x02, 0x20, 0x05, 0x10, 0x22,
  0x0b, 0x20, 0x05, 0x41, 0x30, 0x6a, 0x24, 0x00, 0x0b, 0x4a, 0x01, 0x02,
  0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x10, 0x00,
  0x21, 0x04, 0x20, 0x03, 0x20, 0x02, 0x2d, 0x00, 0x00, 0x36, 0x02, 0x0c,
  0x20, 0x03, 0x20, 0x04, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x04, 0x36,
  0x02, 0x04, 0x20, 0x03, 0x20, 0x00, 0x41, 0x02, 0x74, 0x41, 0xb0, 0xea,
  0x1a, 0x6a, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20, 0x00, 0x20, 0x01,
  0x20, 0x03, 0x10, 0x22, 0x20, 0x03, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x0b,
  0xc4, 0x1d, 0x02, 0x08, 0x7f, 0x01, 0x7e, 0x23, 0x00, 0x41, 0x20, 0x6b,
  0x22, 0x0c, 0x24, 0x00, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x04, 0x41, 0x04,
  0x6b, 0x0e, 0x04, 0x01, 0x02, 0x02, 0x00, 0x02, 0x0b, 0x20, 0x03, 0x2d,
  0x00, 0x00, 0x22, 0x08, 0x41, 0x23, 0x47, 0x0d, 0x02, 0x20, 0x03, 0x2d,
  0x00, 0x01, 0x22, 0x05, 0x41, 0x30, 0x47, 0x04, 0x40, 0x41, 0x01, 0x21,
  0x06, 0x41, 0x01, 0x21, 0x09, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x0c, 0x16,
  0x0b, 0x20, 0x03, 0x2d, 0x00, 0x02, 0x22, 0x05, 0x41, 0x30, 0x46, 0x0d,
  0x0a, 0x41, 0x02, 0x21, 0x09, 0x0c, 0x14, 0x0b, 0x20, 0x03, 0x2d, 0x00,
  0x00, 0x22, 0x08, 0x41, 0x23, 0x47, 0x0d, 0x01, 0x41, 0x01, 0x21, 0x07,
  0x20, 0x03, 0x2d, 0x00, 0x01, 0x22, 0x08, 0x41, 0x30, 0x47, 0x0d, 0x11,
  0x41, 0x02, 0x21, 0x07, 0x20, 0x03, 0x2d, 0x00, 0x02, 0x22, 0x08, 0x41,
  0x30, 0x46, 0x0d, 0x08, 0x0c, 0x11, 0x0b, 0x20, 0x04, 0x41, 0x03, 0x49,
  0x0d, 0x01, 0x20, 0x03, 0x2d, 0x00, 0x00, 0x21, 0x08, 0x0b, 0x41, 0xa0,
  0xda, 0x05, 0x21, 0x05, 0x20, 0x08, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30,
  0x47, 0x0d, 0x01, 0x20, 0x03, 0x2d, 0x00, 0x01, 0x41, 0xf8, 0x00, 0x47,
  0x0d, 0x01, 0x20, 0x03, 0x20, 0x04, 0x6a, 0x21, 0x0a, 0x41, 0x02, 0x21,
  0x05, 0x02, 0x40, 0x03, 0x40, 0x20, 0x03, 0x20, 0x05, 0x6a, 0x22, 0x09,
  0x2d, 0x00, 0x00, 0x22, 0x0b, 0x41, 0x30, 0x47, 0x0d, 0x01, 0x20, 0x05,
  0x41, 0x01, 0x6a, 0x22, 0x05, 0x20, 0x04, 0x47, 0x0d, 0x00, 0x0b, 0x20,
  0x04, 0x21, 0x07, 0x0c, 0x0e, 0x0b, 0x20, 0x05, 0x20, 0x04, 0x22, 0x07,
  0x46, 0x0d, 0x0d, 0x02, 0x7f, 0x02, 0x40, 0x20, 0x0b, 0x41, 0x18, 0x74,
  0x41, 0x18, 0x75, 0x22, 0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x0a, 0x4f, 0x04, 0x40, 0x20, 0x05, 0x21, 0x07, 0x20, 0x0b, 0x41,
  0xc1, 0x00, 0x6b, 0x0e, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x0b, 0x20, 0x0b, 0x41,
  0x30, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x0b, 0x41, 0xd7, 0x00, 0x6b, 0x20,
  0x06, 0x41, 0xe1, 0x00, 0x4e, 0x0d, 0x00, 0x1a, 0x20, 0x0b, 0x41, 0x37,
  0x6b, 0x0b, 0x21, 0x08, 0x20, 0x09, 0x41, 0x01, 0x6a, 0x22, 0x05, 0x20,
  0x0a, 0x46, 0x0d, 0x0b, 0x02, 0x40, 0x20, 0x05, 0x2d, 0x00, 0x00, 0x22,
  0x0b, 0x41, 0x30, 0x6b, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41, 0x09,
  0x4d, 0x0d, 0x00, 0x20, 0x0b, 0x41, 0x18, 0x74, 0x41, 0x18, 0x75, 0x21,
  0x06, 0x20, 0x0b, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x05, 0x4d, 0x04, 0x40, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b, 0x21, 0x07,
  0x0c, 0x01, 0x0b, 0x41, 0x00, 0x21, 0x07, 0x20, 0x0b, 0x41, 0xc1, 0x00,
  0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x05, 0x4b, 0x0d, 0x0b, 0x20, 0x06,
  0x41, 0x37, 0x6b, 0x21, 0x07, 0x0b, 0x20, 0x07, 0x20, 0x08, 0x41, 0x04,
  0x74, 0x6a, 0x21, 0x08, 0x20, 0x05, 0x41, 0x01, 0x6a, 0x22, 0x05, 0x20,
  0x0a, 0x46, 0x0d, 0x0b, 0x20, 0x05, 0x2c, 0x00, 0x00, 0x22, 0x06, 0x41,
  0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x49, 0x0d, 0x04, 0x20,
  0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x49,
  0x0d, 0x03, 0x41, 0x00, 0x21, 0x07, 0x20, 0x06, 0x41, 0xc1, 0x00, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x0a, 0x20, 0x06, 0x41,
  0x37, 0x6b, 0x0c, 0x05, 0x0b, 0x41, 0xa0, 0xda, 0x05, 0x21, 0x05, 0x20,
  0x04, 0x0d, 0x00, 0x41, 0xa0, 0xda, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xa8, 0xda, 0x05, 0x21,
  0x05, 0x41, 0xa8, 0xda, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xb0, 0xda, 0x05, 0x21, 0x05, 0x41,
  0xb0, 0xda, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x0d, 0x01, 0x41, 0xb8, 0xda, 0x05, 0x21, 0x05, 0x41, 0xb8, 0xda,
  0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d,
  0x01, 0x41, 0xc0, 0xda, 0x05, 0x21, 0x05, 0x41, 0xc0, 0xda, 0x05, 0x29,
  0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41,
  0xc8, 0xda, 0x05, 0x21, 0x05, 0x41, 0xc8, 0xda, 0x05, 0x29, 0x03, 0x00,
  0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xd0, 0xda,
  0x05, 0x21, 0x05, 0x41, 0xd0, 0xda, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xd8, 0xda, 0x05, 0x21,
  0x05, 0x41, 0xd8, 0xda, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xe0, 0xda, 0x05, 0x21, 0x05, 0x41,
  0xe0, 0xda, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x0d, 0x01, 0x41, 0xe8, 0xda, 0x05, 0x21, 0x05, 0x41, 0xe8, 0xda,
  0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d,
  0x01, 0x41, 0xf0, 0xda, 0x05, 0x21, 0x05, 0x41, 0xf0, 0xda, 0x05, 0x29,
  0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41,
  0xf8, 0xda, 0x05, 0x21, 0x05, 0x41, 0xf8, 0xda, 0x05, 0x29, 0x03, 0x00,
  0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0x80, 0xdb,
  0x05, 0x21, 0x05, 0x41, 0x80, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0x88, 0xdb, 0x05, 0x21,
  0x05, 0x41, 0x88, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0x90, 0xdb, 0x05, 0x21, 0x05, 0x41,
  0x90, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x0d, 0x01, 0x41, 0x98, 0xdb, 0x05, 0x21, 0x05, 0x41, 0x98, 0xdb,
  0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d,
  0x01, 0x41, 0xa0, 0xdb, 0x05, 0x21, 0x05, 0x41, 0xa0, 0xdb, 0x05, 0x29,
  0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41,
  0xa8, 0xdb, 0x05, 0x21, 0x05, 0x41, 0xa8, 0xdb, 0x05, 0x29, 0x03, 0x00,
  0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xb0, 0xdb,
  0x05, 0x21, 0x05, 0x41, 0xb0, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xb8, 0xdb, 0x05, 0x21,
  0x05, 0x41, 0xb8, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xc0, 0xdb, 0x05, 0x21, 0x05, 0x41,
  0xc0, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x0d, 0x01, 0x41, 0xc8, 0xdb, 0x05, 0x21, 0x05, 0x41, 0xc8, 0xdb,
  0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d,
  0x01, 0x41, 0xd0, 0xdb, 0x05, 0x21, 0x05, 0x41, 0xd0, 0xdb, 0x05, 0x29,
  0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41,
  0xd8, 0xdb, 0x05, 0x21, 0x05, 0x41, 0xd8, 0xdb, 0x05, 0x29, 0x03, 0x00,
  0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xe0, 0xdb,
  0x05, 0x21, 0x05, 0x41, 0xe0, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xe8, 0xdb, 0x05, 0x21,
  0x05, 0x41, 0xe8, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xf0, 0xdb, 0x05, 0x21, 0x05, 0x41,
  0xf0, 0xdb, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x0d, 0x01, 0x41, 0xf8, 0xdb, 0x05, 0x21, 0x05, 0x41, 0xf8, 0xdb,
  0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d,
  0x01, 0x41, 0x80, 0xdc, 0x05, 0x21, 0x05, 0x41, 0x80, 0xdc, 0x05, 0x29,
  0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41,
  0x88, 0xdc, 0x05, 0x21, 0x05, 0x41, 0x88, 0xdc, 0x05, 0x29, 0x03, 0x00,
  0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0x90, 0xdc,
  0x05, 0x21, 0x05, 0x41, 0x90, 0xdc, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0x98, 0xdc, 0x05, 0x21,
  0x05, 0x41, 0x98, 0xdc, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xa0, 0xdc, 0x05, 0x21, 0x05, 0x41,
  0xa0, 0xdc, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x0d, 0x01, 0x41, 0xa8, 0xdc, 0x05, 0x21, 0x05, 0x41, 0xa8, 0xdc,
  0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d,
  0x01, 0x41, 0xb0, 0xdc, 0x05, 0x21, 0x05, 0x41, 0xb0, 0xdc, 0x05, 0x29,
  0x03, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41,
  0xb8, 0xdc, 0x05, 0x21, 0x05, 0x41, 0xb8, 0xdc, 0x05, 0x29, 0x03, 0x00,
  0x42, 0x80, 0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xc0, 0xdc,
  0x05, 0x21, 0x05, 0x41, 0xc0, 0xdc, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80,
  0x80, 0x80, 0x80, 0x10, 0x54, 0x0d, 0x01, 0x41, 0xc8, 0xdc, 0x05, 0x21,
  0x05, 0x41, 0xc8, 0xdc, 0x05, 0x29, 0x03, 0x00, 0x42, 0x80, 0x80, 0x80,
  0x80, 0x10, 0x54, 0x0d, 0x01, 0x0c, 0x13, 0x0b, 0x03, 0x40, 0x20, 0x04,
  0x20, 0x05, 0x29, 0x02, 0x00, 0x22, 0x0d, 0x42, 0x20, 0x88, 0xa7, 0x46,
  0x04, 0x40, 0x20, 0x0d, 0xa7, 0x20, 0x03, 0x20, 0x04, 0x10, 0x2b, 0x45,
  0x0d, 0x02, 0x0b, 0x20, 0x05, 0x41, 0x08, 0x6a, 0x22, 0x05, 0x41, 0xd0,
  0xdc, 0x05, 0x47, 0x0d, 0x00, 0x0b, 0x0c, 0x12, 0x0b, 0x20, 0x02, 0x20,
  0x05, 0x41, 0xa0, 0xda, 0x05, 0x6b, 0x41, 0x01, 0x75, 0x41, 0xd0, 0xdc,
  0x05, 0x6a, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x0c, 0x12, 0x0b, 0x20,
  0x06, 0x41, 0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff,
  0x01, 0x71, 0x41, 0x30, 0x6b, 0x0b, 0x21, 0x07, 0x20, 0x07, 0x20, 0x08,
  0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x05, 0x41, 0x01, 0x6a, 0x22,
  0x05, 0x20, 0x0a, 0x46, 0x0d, 0x05, 0x02, 0x7f, 0x20, 0x05, 0x2c, 0x00,
  0x00, 0x22, 0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a,
  0x4f, 0x04, 0x40, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x06, 0x4f, 0x04, 0x40, 0x41, 0x00, 0x21, 0x07, 0x20, 0x06,
  0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d,
  0x07, 0x20, 0x06, 0x41, 0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41,
  0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x30, 0x6b, 0x0b, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08,
  0x20, 0x05, 0x41, 0x01, 0x6a, 0x22, 0x05, 0x20, 0x0a, 0x46, 0x0d, 0x05,
  0x02, 0x7f, 0x20, 0x05, 0x2c, 0x00, 0x00, 0x22, 0x06, 0x41, 0x30, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04, 0x40, 0x20, 0x06, 0x41,
  0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x04, 0x40,
  0x41, 0x00, 0x21, 0x07, 0x20, 0x06, 0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff,
  0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x07, 0x20, 0x06, 0x41, 0x37, 0x6b,
  0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b,
  0x20, 0x06, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30, 0x6b, 0x0b, 0x20, 0x08,
  0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x05, 0x41, 0x01, 0x6a, 0x22,
  0x05, 0x20, 0x0a, 0x46, 0x0d, 0x05, 0x02, 0x7f, 0x20, 0x05, 0x2c, 0x00,
  0x00, 0x22, 0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a,
  0x4f, 0x04, 0x40, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x06, 0x4f, 0x04, 0x40, 0x41, 0x00, 0x21, 0x07, 0x20, 0x06,
  0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d,
  0x07, 0x20, 0x06, 0x41, 0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41,
  0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x30, 0x6b, 0x0b, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08,
  0x20, 0x05, 0x41, 0x01, 0x6a, 0x22, 0x05, 0x20, 0x0a, 0x46, 0x0d, 0x05,
  0x02, 0x7f, 0x20, 0x05, 0x2c, 0x00, 0x00, 0x22, 0x06, 0x41, 0x30, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04, 0x40, 0x20, 0x06, 0x41,
  0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x04, 0x40,
  0x41, 0x00, 0x21, 0x07, 0x20, 0x06, 0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff,
  0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x07, 0x20, 0x06, 0x41, 0x37, 0x6b,
  0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b,
  0x20, 0x06, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30, 0x6b, 0x0b, 0x20, 0x08,
  0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x05, 0x41, 0x01, 0x6a, 0x22,
  0x05, 0x20, 0x0a, 0x46, 0x0d, 0x05, 0x20, 0x05, 0x2c, 0x00, 0x00, 0x22,
  0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04,
  0x40, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x06, 0x49, 0x0d, 0x03, 0x41, 0x00, 0x21, 0x07, 0x20, 0x06, 0x41, 0xc1,
  0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x05, 0x20,
  0x06, 0x41, 0x37, 0x6b, 0x0c, 0x04, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x30, 0x6b, 0x0c, 0x03, 0x0b, 0x41, 0x03, 0x21, 0x07, 0x20,
  0x03, 0x2d, 0x00, 0x03, 0x22, 0x08, 0x41, 0x30, 0x47, 0x0d, 0x08, 0x0c,
  0x09, 0x0b, 0x20, 0x03, 0x2d, 0x00, 0x03, 0x22, 0x05, 0x41, 0x30, 0x47,
  0x04, 0x40, 0x41, 0x03, 0x21, 0x09, 0x0c, 0x0a, 0x0b, 0x20, 0x03, 0x2d,
  0x00, 0x04, 0x22, 0x05, 0x41, 0x30, 0x47, 0x04, 0x40, 0x41, 0x04, 0x21,
  0x09, 0x0c, 0x0a, 0x0b, 0x20, 0x03, 0x2d, 0x00, 0x05, 0x22, 0x05, 0x41,
  0x30, 0x47, 0x04, 0x40, 0x41, 0x05, 0x21, 0x09, 0x0c, 0x0a, 0x0b, 0x41,
  0x00, 0x21, 0x08, 0x20, 0x03, 0x2d, 0x00, 0x06, 0x22, 0x05, 0x41, 0x30,
  0x46, 0x0d, 0x0b, 0x41, 0x06, 0x21, 0x09, 0x20, 0x03, 0x41, 0x06, 0x6a,
  0x0c, 0x0a, 0x0b, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b, 0x0b, 0x21, 0x07,
  0x20, 0x09, 0x41, 0x07, 0x6a, 0x20, 0x09, 0x41, 0x08, 0x6a, 0x20, 0x08,
  0x41, 0xff, 0xff, 0xff, 0xff, 0x00, 0x71, 0x20, 0x08, 0x47, 0x1b, 0x21,
  0x05, 0x20, 0x08, 0x41, 0x04, 0x74, 0x21, 0x08, 0x0b, 0x20, 0x05, 0x20,
  0x0a, 0x47, 0x04, 0x40, 0x20, 0x05, 0x2d, 0x00, 0x00, 0x22, 0x06, 0x41,
  0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x49, 0x0d, 0x0a, 0x20,
  0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x49,
  0x0d, 0x0a, 0x20, 0x06, 0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x06, 0x49, 0x0d, 0x0a, 0x20, 0x07, 0x20, 0x08, 0x41, 0x7f, 0x73,
  0x4d, 0x0d, 0x02, 0x0c, 0x0a, 0x0b, 0x20, 0x0a, 0x21, 0x05, 0x20, 0x07,
  0x20, 0x08, 0x41, 0x7f, 0x73, 0x4b, 0x0d, 0x09, 0x0c, 0x01, 0x0b, 0x41,
  0x00, 0x21, 0x07, 0x20, 0x0a, 0x21, 0x05, 0x0b, 0x20, 0x07, 0x20, 0x08,
  0x6a, 0x0c, 0x01, 0x0b, 0x20, 0x07, 0x41, 0x02, 0x46, 0x0d, 0x06, 0x20,
  0x03, 0x20, 0x07, 0x6a, 0x21, 0x05, 0x41, 0x00, 0x0b, 0x21, 0x08, 0x20,
  0x05, 0x20, 0x0a, 0x47, 0x0d, 0x05, 0x20, 0x08, 0x41, 0x80, 0x80, 0x80,
  0x08, 0x49, 0x0d, 0x04, 0x0c, 0x05, 0x0b, 0x02, 0x40, 0x20, 0x08, 0x41,
  0x30, 0x6b, 0x22, 0x05, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x49, 0x0d,
  0x00, 0x02, 0x40, 0x20, 0x08, 0x41, 0xc1, 0x00, 0x6b, 0x0e, 0x26, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x06, 0x0b, 0x20, 0x08, 0x41, 0x18, 0x74, 0x41, 0x18, 0x75, 0x41,
  0xe1, 0x00, 0x4e, 0x04, 0x40, 0x20, 0x08, 0x41, 0xd7, 0x00, 0x6b, 0x21,
  0x05, 0x0c, 0x01, 0x0b, 0x20, 0x08, 0x41, 0x37, 0x6b, 0x21, 0x05, 0x0b,
  0x20, 0x07, 0x41, 0x01, 0x6a, 0x22, 0x0a, 0x41, 0x04, 0x46, 0x0d, 0x00,
  0x02, 0x40, 0x20, 0x03, 0x20, 0x0a, 0x6a, 0x2d, 0x00, 0x00, 0x22, 0x06,
  0x41, 0x30, 0x6b, 0x22, 0x09, 0x41, 0xff, 0x01, 0x71, 0x41, 0x09, 0x4d,
  0x0d, 0x00, 0x20, 0x06, 0x41, 0x18, 0x74, 0x41, 0x18, 0x75, 0x21, 0x0a,
  0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x05,
  0x4d, 0x04, 0x40, 0x20, 0x0a, 0x41, 0xd7, 0x00, 0x6b, 0x21, 0x09, 0x0c,
  0x01, 0x0b, 0x20, 0x06, 0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x05, 0x4b, 0x0d, 0x05, 0x20, 0x0a, 0x41, 0x37, 0x6b, 0x21, 0x09,
  0x0b, 0x20, 0x09, 0x20, 0x05, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x05, 0x20,
  0x07, 0x41, 0x02, 0x6a, 0x22, 0x07, 0x41, 0x04, 0x46, 0x0d, 0x00, 0x02,
  0x7f, 0x20, 0x03, 0x20, 0x07, 0x6a, 0x2c, 0x00, 0x00, 0x22, 0x07, 0x41,
  0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04, 0x40, 0x20,
  0x07, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f,
  0x04, 0x40, 0x20, 0x07, 0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x06, 0x4f, 0x0d, 0x07, 0x20, 0x07, 0x41, 0x37, 0x6b, 0x0c, 0x02,
  0x0b, 0x20, 0x07, 0x41, 0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x07,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x30, 0x6b, 0x0b, 0x20, 0x05, 0x41, 0x04,
  0x74, 0x6a, 0x21, 0x05, 0x0b, 0x20, 0x05, 0x41, 0x04, 0x76, 0x41, 0x0f,
  0x71, 0x41, 0x80, 0x22, 0x6c, 0x20, 0x05, 0x41, 0x0f, 0x71, 0x41, 0x11,
  0x6c, 0x6a, 0x20, 0x05, 0x41, 0x08, 0x76, 0x41, 0x0f, 0x71, 0x41, 0x80,
  0x80, 0xc4, 0x00, 0x6c, 0x6a, 0x21, 0x08, 0x0c, 0x02, 0x0b, 0x20, 0x03,
  0x20, 0x09, 0x6a, 0x0b, 0x21, 0x07, 0x20, 0x03, 0x41, 0x07, 0x6a, 0x21,
  0x0a, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x05, 0x41, 0x30, 0x6b, 0x22, 0x08,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x49, 0x0d, 0x00, 0x02, 0x40, 0x20,
  0x05, 0x41, 0xc1, 0x00, 0x6b, 0x0e, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0b, 0x20,
  0x05, 0x41, 0x18, 0x74, 0x41, 0x18, 0x75, 0x41, 0xe1, 0x00, 0x4e, 0x04,
  0x40, 0x20, 0x05, 0x41, 0xd7, 0x00, 0x6b, 0x21, 0x08, 0x0c, 0x01, 0x0b,
  0x20, 0x05, 0x41, 0x37, 0x6b, 0x21, 0x08, 0x0b, 0x20, 0x09, 0x41, 0x01,
  0x6a, 0x22, 0x07, 0x41, 0x07, 0x46, 0x0d, 0x04, 0x02, 0x40, 0x20, 0x03,
  0x20, 0x07, 0x6a, 0x22, 0x07, 0x2d, 0x00, 0x00, 0x22, 0x0b, 0x41, 0x30,
  0x6b, 0x22, 0x05, 0x41, 0xff, 0x01, 0x71, 0x41, 0x09, 0x4d, 0x0d, 0x00,
  0x20, 0x0b, 0x41, 0x18, 0x74, 0x41, 0x18, 0x75, 0x21, 0x06, 0x20, 0x0b,
  0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x05, 0x4d, 0x04,
  0x40, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b, 0x21, 0x05, 0x0c, 0x01, 0x0b,
  0x41, 0x00, 0x21, 0x05, 0x20, 0x0b, 0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff,
  0x01, 0x71, 0x41, 0x05, 0x4b, 0x0d, 0x04, 0x20, 0x06, 0x41, 0x37, 0x6b,
  0x21, 0x05, 0x0b, 0x20, 0x05, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21,
  0x08, 0x20, 0x09, 0x41, 0x02, 0x6a, 0x22, 0x07, 0x41, 0x07, 0x46, 0x0d,
  0x04, 0x02, 0x7f, 0x20, 0x03, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x2c, 0x00,
  0x00, 0x22, 0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a,
  0x4f, 0x04, 0x40, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x06, 0x4f, 0x04, 0x40, 0x41, 0x00, 0x21, 0x05, 0x20, 0x06,
  0x41, 0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d,
  0x06, 0x20, 0x06, 0x41, 0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41,
  0xd7, 0x00, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x30, 0x6b, 0x0b, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08,
  0x20, 0x09, 0x41, 0x03, 0x6a, 0x22, 0x07, 0x41, 0x07, 0x46, 0x0d, 0x04,
  0x02, 0x7f, 0x20, 0x03, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x2c, 0x00, 0x00,
  0x22, 0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f,
  0x04, 0x40, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x06, 0x4f, 0x04, 0x40, 0x41, 0x00, 0x21, 0x05, 0x20, 0x06, 0x41,
  0xc1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x06,
  0x20, 0x06, 0x41, 0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0xd7,
  0x00, 0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x30, 0x6b, 0x0b, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20,
  0x09, 0x41, 0x04, 0x6a, 0x22, 0x07, 0x41, 0x07, 0x46, 0x0d, 0x04, 0x02,
  0x7f, 0x20, 0x03, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x2c, 0x00, 0x00, 0x22,
  0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04,
  0x40, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x06, 0x4f, 0x04, 0x40, 0x41, 0x00, 0x21, 0x05, 0x20, 0x06, 0x41, 0xc1,
  0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x06, 0x20,
  0x06, 0x41, 0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0xd7, 0x00,
  0x6b, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30,
  0x6b, 0x0b, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x09,
  0x41, 0x05, 0x6a, 0x22, 0x07, 0x41, 0x07, 0x46, 0x0d, 0x04, 0x02, 0x7f,
  0x20, 0x03, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x2c, 0x00, 0x00, 0x22, 0x06,
  0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04, 0x40,
  0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06,
  0x4f, 0x04, 0x40, 0x41, 0x00, 0x21, 0x05, 0x20, 0x06, 0x41, 0xc1, 0x00,
  0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x06, 0x20, 0x06,
  0x41, 0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b,
  0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30, 0x6b,
  0x0b, 0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x09, 0x41,
  0x06, 0x6a, 0x22, 0x07, 0x41, 0x07, 0x46, 0x0d, 0x04, 0x02, 0x7f, 0x20,
  0x03, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x2c, 0x00, 0x00, 0x22, 0x06, 0x41,
  0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04, 0x40, 0x20,
  0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f,
  0x04, 0x40, 0x41, 0x00, 0x21, 0x05, 0x20, 0x06, 0x41, 0xc1, 0x00, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f, 0x0d, 0x06, 0x20, 0x06, 0x41,
  0x37, 0x6b, 0x0c, 0x02, 0x0b, 0x20, 0x06, 0x41, 0xd7, 0x00, 0x6b, 0x0c,
  0x01, 0x0b, 0x20, 0x06, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30, 0x6b, 0x0b,
  0x20, 0x08, 0x41, 0x04, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x03, 0x20, 0x09,
  0x6a, 0x41, 0x07, 0x6a, 0x22, 0x06, 0x2c, 0x00, 0x00, 0x22, 0x0b, 0x41,
  0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x04, 0x40, 0x20,
  0x0b, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x4f,
  0x04, 0x40, 0x41, 0x00, 0x21, 0x05, 0x20, 0x0b, 0x41, 0xc1, 0x00, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x49, 0x0d, 0x03, 0x20, 0x06, 0x21,
  0x07, 0x0c, 0x05, 0x0b, 0x20, 0x0b, 0x41, 0xd7, 0x00, 0x6b, 0x0c, 0x03,
  0x0b, 0x20, 0x0b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30, 0x6b, 0x0c, 0x02,
  0x0b, 0x41, 0x00, 0x20, 0x06, 0x45, 0x0d, 0x05, 0x1a, 0x0c, 0x07, 0x0b,
  0x20, 0x0b, 0x41, 0x37, 0x6b, 0x0b, 0x21, 0x05, 0x20, 0x06, 0x20, 0x07,
  0x41, 0x02, 0x6a, 0x20, 0x08, 0x41, 0xff, 0xff, 0xff, 0xff, 0x00, 0x71,
  0x20, 0x08, 0x47, 0x1b, 0x21, 0x07, 0x20, 0x08, 0x41, 0x04, 0x74, 0x21,
  0x08, 0x0b, 0x20, 0x07, 0x20, 0x0a, 0x47, 0x04, 0x40, 0x20, 0x07, 0x2d,
  0x00, 0x00, 0x22, 0x06, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x0a, 0x49, 0x0d, 0x05, 0x20, 0x06, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff,
  0x01, 0x71, 0x41, 0x06, 0x49, 0x0d, 0x05, 0x20, 0x06, 0x41, 0xc1, 0x00,
  0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x06, 0x49, 0x0d, 0x05, 0x20, 0x05,
  0x20, 0x08, 0x41, 0x7f, 0x73, 0x4d, 0x0d, 0x02, 0x0c, 0x05, 0x0b, 0x20,
  0x0a, 0x21, 0x07, 0x20, 0x05, 0x20, 0x08, 0x41, 0x7f, 0x73, 0x4b, 0x0d,
  0x04, 0x0c, 0x01, 0x0b, 0x41, 0x00, 0x21, 0x05, 0x20, 0x0a, 0x21, 0x07,
  0x0b, 0x20, 0x05, 0x20, 0x08, 0x6a, 0x0b, 0x21, 0x08, 0x20, 0x07, 0x20,
  0x0a, 0x47, 0x0d, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x08, 0x36, 0x02, 0x00,
  0x0c, 0x01, 0x0b, 0x10, 0x00, 0x21, 0x02, 0x20, 0x0c, 0x41, 0xa7, 0xf8,
  0x02, 0x36, 0x02, 0x1c, 0x20, 0x0c, 0x20, 0x03, 0x36, 0x02, 0x18, 0x20,
  0x0c, 0x20, 0x04, 0x36, 0x02, 0x14, 0x20, 0x0c, 0x20, 0x00, 0x36, 0x02,
  0x10, 0x20, 0x0c, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x0c, 0x20, 0x02,
  0x36, 0x02, 0x08, 0x20, 0x0c, 0x20, 0x02, 0x36, 0x02, 0x04, 0x20, 0x0c,
  0x41, 0xd4, 0xf7, 0x03, 0x36, 0x02, 0x00, 0x41, 0x04, 0x41, 0x90, 0xb2,
  0x02, 0x20, 0x0c, 0x10, 0x22, 0x0b, 0x20, 0x0c, 0x41, 0x20, 0x6a, 0x24,
  0x00, 0x0b, 0x4a, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22,
  0x03, 0x24, 0x00, 0x10, 0x00, 0x21, 0x04, 0x20, 0x03, 0x20, 0x02, 0x2f,
  0x01, 0x00, 0x36, 0x02, 0x0c, 0x20, 0x03, 0x20, 0x04, 0x36, 0x02, 0x08,
  0x20, 0x03, 0x20, 0x04, 0x36, 0x02, 0x04, 0x20, 0x03, 0x20, 0x00, 0x41,
  0x02, 0x74, 0x41, 0xb0, 0xea, 0x1a, 0x6a, 0x28, 0x02, 0x00, 0x36, 0x02,
  0x00, 0x20, 0x00, 0x20, 0x01, 0x20, 0x03, 0x10, 0x22, 0x20, 0x03, 0x41,
  0x10, 0x6a, 0x24, 0x00, 0x0b, 0xfa, 0x01, 0x01, 0x05, 0x7f, 0x20, 0x00,
  0x28, 0x02, 0x04, 0x22, 0x06, 0x45, 0x04, 0x40, 0x41, 0x00, 0x0f, 0x0b,
  0x20, 0x00, 0x28, 0x02, 0x00, 0x21, 0x07, 0x03, 0x40, 0x02, 0x40, 0x20,
  0x03, 0x20, 0x07, 0x6a, 0x22, 0x05, 0x2d, 0x00, 0x00, 0x22, 0x00, 0x45,
  0x0d, 0x00, 0x02, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x20, 0x00, 0x41, 0x04, 0x76, 0x41, 0x08, 0x6b, 0x0e, 0x08, 0x05, 0x05,
  0x05, 0x05, 0x00, 0x00, 0x01, 0x02, 0x04, 0x0b, 0x20, 0x03, 0x20, 0x06,
  0x4f, 0x0d, 0x04, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x21, 0x03, 0x20, 0x00,
  0x41, 0x06, 0x74, 0x41, 0xc0, 0x0f, 0x71, 0x0c, 0x02, 0x0b, 0x20, 0x03,
  0x41, 0x02, 0x6a, 0x22, 0x03, 0x20, 0x06, 0x4b, 0x0d, 0x03, 0x20, 0x00,
  0x41, 0x0c, 0x74, 0x41, 0x80, 0xe0, 0x03, 0x71, 0x20, 0x05, 0x2d, 0x00,
  0x01, 0x41, 0x3f, 0x71, 0x41, 0x06, 0x74, 0x72, 0x0c, 0x01, 0x0b, 0x20,
  0x03, 0x41, 0x03, 0x6a, 0x22, 0x03, 0x20, 0x06, 0x4b, 0x0d, 0x02, 0x20,
  0x05, 0x2d, 0x00, 0x01, 0x41, 0x3f, 0x71, 0x41, 0x0c, 0x74, 0x20, 0x05,
  0x2d, 0x00, 0x02, 0x41, 0x3f, 0x71, 0x41, 0x06, 0x74, 0x72, 0x0b, 0x21,
  0x00, 0x20, 0x00, 0x20, 0x03, 0x20, 0x07, 0x6a, 0x2d, 0x00, 0x00, 0x41,
  0x3f, 0x71, 0x72, 0x21, 0x00, 0x0b, 0x20, 0x04, 0x41, 0x02, 0x6a, 0x22,
  0x05, 0x20, 0x02, 0x4b, 0x0d, 0x00, 0x20, 0x01, 0x20, 0x04, 0x6a, 0x20,
  0x00, 0x3a, 0x00, 0x00, 0x20, 0x01, 0x20, 0x04, 0x41, 0x01, 0x72, 0x6a,
  0x20, 0x00, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x00, 0x20, 0x05, 0x21, 0x04,
  0x20, 0x03, 0x41, 0x01, 0x6a, 0x22, 0x03, 0x20, 0x06, 0x49, 0x0d, 0x01,
  0x0b, 0x0b, 0x20, 0x04, 0x0b, 0x93, 0x02, 0x01, 0x03, 0x7f, 0x20, 0x00,
  0x2d, 0x00, 0x00, 0x41, 0x20, 0x71, 0x45, 0x04, 0x40, 0x02, 0x40, 0x20,
  0x01, 0x21, 0x03, 0x02, 0x40, 0x20, 0x02, 0x20, 0x00, 0x22, 0x01, 0x28,
  0x02, 0x10, 0x22, 0x00, 0x04, 0x7f, 0x20, 0x00, 0x05, 0x02, 0x7f, 0x20,
  0x01, 0x20, 0x01, 0x2d, 0x00, 0x4a, 0x22, 0x00, 0x41, 0x01, 0x6b, 0x20,
  0x00, 0x72, 0x3a, 0x00, 0x4a, 0x20, 0x01, 0x28, 0x02, 0x00, 0x22, 0x00,
  0x41, 0x08, 0x71, 0x04, 0x40, 0x20, 0x01, 0x20, 0x00, 0x41, 0x20, 0x72,
  0x36, 0x02, 0x00, 0x41, 0x7f, 0x0c, 0x01, 0x0b, 0x20, 0x01, 0x42, 0x00,
  0x37, 0x02, 0x04, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x2c, 0x22, 0x00,
  0x36, 0x02, 0x1c, 0x20, 0x01, 0x20, 0x00, 0x36, 0x02, 0x14, 0x20, 0x01,
  0x20, 0x00, 0x20, 0x01, 0x28, 0x02, 0x30, 0x6a, 0x36, 0x02, 0x10, 0x41,
  0x00, 0x0b, 0x0d, 0x01, 0x20, 0x01, 0x28, 0x02, 0x10, 0x0b, 0x20, 0x01,
  0x28, 0x02, 0x14, 0x22, 0x05, 0x6b, 0x4b, 0x04, 0x40, 0x20, 0x01, 0x20,
  0x03, 0x20, 0x02, 0x20, 0x01, 0x28, 0x02, 0x24, 0x11, 0x06, 0x00, 0x1a,
  0x0c, 0x02, 0x0b, 0x02, 0x40, 0x20, 0x01, 0x2c, 0x00, 0x4b, 0x41, 0x00,
  0x48, 0x0d, 0x00, 0x20, 0x02, 0x21, 0x00, 0x03, 0x40, 0x20, 0x00, 0x22,
  0x04, 0x45, 0x0d, 0x01, 0x20, 0x03, 0x20, 0x04, 0x41, 0x01, 0x6b, 0x22,
  0x00, 0x6a, 0x2d, 0x00, 0x00, 0x41, 0x0a, 0x47, 0x0d, 0x00, 0x0b, 0x20,
  0x01, 0x20, 0x03, 0x20, 0x04, 0x20, 0x01, 0x28, 0x02, 0x24, 0x11, 0x06,
  0x00, 0x20, 0x04, 0x49, 0x0d, 0x01, 0x20, 0x03, 0x20, 0x04, 0x6a, 0x21,
  0x03, 0x20, 0x02, 0x20, 0x04, 0x6b, 0x21, 0x02, 0x20, 0x01, 0x28, 0x02,
  0x14, 0x21, 0x05, 0x0b, 0x20, 0x05, 0x20, 0x03, 0x20, 0x02, 0x10, 0x24,
  0x1a, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x14, 0x20, 0x02, 0x6a, 0x36,
  0x02, 0x14, 0x0b, 0x0b, 0x0b, 0x0b, 0xb7, 0x02, 0x01, 0x07, 0x7f, 0x23,
  0x00, 0x41, 0x80, 0x01, 0x6b, 0x22, 0x06, 0x24, 0x00, 0x20, 0x00, 0x28,
  0x02, 0x00, 0x41, 0x80, 0x20, 0x46, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02,
  0xbc, 0x08, 0x21, 0x04, 0x20, 0x06, 0x20, 0x00, 0x41, 0x24, 0x6a, 0x36,
  0x02, 0x10, 0x20, 0x06, 0x41, 0x08, 0x41, 0x10, 0x20, 0x04, 0x41, 0x01,
  0x46, 0x1b, 0x22, 0x07, 0x36, 0x02, 0x14, 0x20, 0x06, 0x20, 0x06, 0x29,
  0x03, 0x10, 0x37, 0x03, 0x08, 0x20, 0x06, 0x41, 0x18, 0x6a, 0x20, 0x06,
  0x41, 0x08, 0x6a, 0x10, 0x82, 0x01, 0x22, 0x04, 0x20, 0x04, 0x28, 0x02,
  0x14, 0x22, 0x08, 0x20, 0x07, 0x41, 0x03, 0x74, 0x6a, 0x22, 0x05, 0x36,
  0x02, 0x14, 0x20, 0x04, 0x20, 0x04, 0x28, 0x02, 0x18, 0x20, 0x05, 0x20,
  0x08, 0x49, 0x6a, 0x36, 0x02, 0x18, 0x20, 0x00, 0x41, 0x14, 0x6a, 0x21,
  0x05, 0x20, 0x08, 0x41, 0x03, 0x76, 0x41, 0x3f, 0x71, 0x22, 0x08, 0x20,
  0x07, 0x6a, 0x41, 0xc0, 0x00, 0x4f, 0x04, 0x7f, 0x20, 0x04, 0x41, 0x1c,
  0x6a, 0x22, 0x0a, 0x20, 0x08, 0x6a, 0x20, 0x05, 0x41, 0xc0, 0x00, 0x20,
  0x08, 0x6b, 0x22, 0x09, 0x10, 0x24, 0x1a, 0x20, 0x04, 0x20, 0x0a, 0x10,
  0x33, 0x41, 0x00, 0x05, 0x20, 0x08, 0x0b, 0x20, 0x04, 0x6a, 0x41, 0x1c,
  0x6a, 0x20, 0x00, 0x20, 0x09, 0x6a, 0x41, 0x14, 0x6a, 0x20, 0x07, 0x20,
  0x09, 0x6b, 0x10, 0x24, 0x1a, 0x20, 0x04, 0x20, 0x05, 0x10, 0x9a, 0x01,
  0x20, 0x00, 0x41, 0x34, 0x6a, 0x22, 0x04, 0x20, 0x07, 0x20, 0x05, 0x10,
  0x53, 0x20, 0x04, 0x20, 0x07, 0x20, 0x05, 0x20, 0x05, 0x10, 0x52, 0x20,
  0x00, 0x28, 0x02, 0xbc, 0x08, 0x41, 0x01, 0x46, 0x04, 0x40, 0x20, 0x00,
  0x41, 0xd1, 0xcd, 0x00, 0x3b, 0x01, 0x14, 0x20, 0x00, 0x41, 0x9e, 0x01,
  0x3a, 0x00, 0x16, 0x0b, 0x20, 0x04, 0x20, 0x07, 0x20, 0x05, 0x10, 0x53,
  0x20, 0x00, 0x41, 0x00, 0x36, 0x02, 0x00, 0x0b, 0x20, 0x00, 0x41, 0x34,
  0x6a, 0x20, 0x02, 0x20, 0x01, 0x20, 0x03, 0x10, 0x52, 0x20, 0x00, 0x20,
  0x00, 0x28, 0x02, 0x00, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x00, 0x20, 0x06,
  0x41, 0x80, 0x01, 0x6a, 0x24, 0x00, 0x0b, 0x06, 0x00, 0x20, 0x00, 0x10,
  0x23, 0x0b, 0x91, 0x02, 0x02, 0x04, 0x7f, 0x01, 0x7e, 0x23, 0x00, 0x41,
  0x30, 0x6b, 0x22, 0x05, 0x24, 0x00, 0x02, 0x40, 0x02, 0x40, 0x20, 0x04,
  0x45, 0x04, 0x40, 0x41, 0x8d, 0xf8, 0x02, 0x21, 0x06, 0x0c, 0x01, 0x0b,
  0x41, 0x01, 0x21, 0x06, 0x41, 0x0a, 0x21, 0x07, 0x20, 0x05, 0x41, 0x20,
  0x6a, 0x02, 0x7f, 0x20, 0x03, 0x20, 0x04, 0x41, 0x01, 0x46, 0x0d, 0x00,
  0x1a, 0x20, 0x03, 0x2d, 0x00, 0x00, 0x41, 0x30, 0x47, 0x04, 0x40, 0x20,
  0x04, 0x21, 0x06, 0x20, 0x03, 0x0c, 0x01, 0x0b, 0x20, 0x04, 0x21, 0x06,
  0x20, 0x03, 0x20, 0x03, 0x2d, 0x00, 0x01, 0x41, 0xf8, 0x00, 0x47, 0x0d,
  0x00, 0x1a, 0x20, 0x04, 0x41, 0x02, 0x6b, 0x21, 0x06, 0x41, 0x10, 0x21,
  0x07, 0x20, 0x03, 0x41, 0x02, 0x6a, 0x0b, 0x22, 0x08, 0x20, 0x06, 0x20,
  0x08, 0x6a, 0x22, 0x08, 0x20, 0x05, 0x41, 0x28, 0x6a, 0x20, 0x07, 0x10,
  0x77, 0x41, 0x90, 0xd1, 0x05, 0x21, 0x06, 0x20, 0x05, 0x28, 0x02, 0x24,
  0x22, 0x07, 0x41, 0x3d, 0x46, 0x0d, 0x00, 0x02, 0x40, 0x20, 0x07, 0x0d,
  0x00, 0x20, 0x05, 0x28, 0x02, 0x20, 0x20, 0x08, 0x47, 0x0d, 0x00, 0x20,
  0x05, 0x29, 0x03, 0x28, 0x22, 0x09, 0x42, 0x00, 0x53, 0x0d, 0x01, 0x20,
  0x02, 0x20, 0x09, 0x37, 0x03, 0x00, 0x0c, 0x02, 0x0b, 0x41, 0x95, 0xe6,
  0x02, 0x21, 0x06, 0x0b, 0x10, 0x00, 0x21, 0x02, 0x20, 0x05, 0x20, 0x06,
  0x36, 0x02, 0x1c, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x18, 0x20, 0x05,
  0x20, 0x04, 0x36, 0x02, 0x14, 0x20, 0x05, 0x20, 0x00, 0x36, 0x02, 0x10,
  0x20, 0x05, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x05, 0x20, 0x02, 0x36,
  0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x04, 0x20, 0x05, 0x41,
  0xd4, 0xf7, 0x03, 0x36, 0x02, 0x00, 0x41, 0x04, 0x41, 0x90, 0xb2, 0x02,
  0x20, 0x05, 0x10, 0x22, 0x0b, 0x20, 0x05, 0x41, 0x30, 0x6a, 0x24, 0x00,
  0x0b, 0x6f, 0x01, 0x01, 0x7f, 0x23, 0x00, 0x41, 0x80, 0x02, 0x6b, 0x22,
  0x05, 0x24, 0x00, 0x02, 0x40, 0x20, 0x04, 0x41, 0x80, 0xc0, 0x04, 0x71,
  0x0d, 0x00, 0x20, 0x02, 0x20, 0x03, 0x4c, 0x0d, 0x00, 0x20, 0x05, 0x20,
  0x01, 0x41, 0xff, 0x01, 0x71, 0x20, 0x02, 0x20, 0x03, 0x6b, 0x22, 0x02,
  0x41, 0x80, 0x02, 0x20, 0x02, 0x41, 0x80, 0x02, 0x49, 0x22, 0x01, 0x1b,
  0x10, 0x29, 0x1a, 0x20, 0x01, 0x45, 0x04, 0x40, 0x03, 0x40, 0x20, 0x00,
  0x20, 0x05, 0x41, 0x80, 0x02, 0x10, 0x3f, 0x20, 0x02, 0x41, 0x80, 0x02,
  0x6b, 0x22, 0x02, 0x41, 0xff, 0x01, 0x4b, 0x0d, 0x00, 0x0b, 0x0b, 0x20,
  0x00, 0x20, 0x05, 0x20, 0x02, 0x10, 0x3f, 0x0b, 0x20, 0x05, 0x41, 0x80,
  0x02, 0x6a, 0x24, 0x00, 0x0b, 0x94, 0x08, 0x02, 0x07, 0x7f, 0x02, 0x7e,
  0x23, 0x00, 0x41, 0xc0, 0x02, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x20, 0x03,
  0x20, 0x01, 0x28, 0x02, 0x04, 0x22, 0x08, 0x36, 0x00, 0x7c, 0x20, 0x00,
  0x28, 0x02, 0xbc, 0x08, 0x21, 0x04, 0x20, 0x03, 0x20, 0x00, 0x41, 0x04,
  0x6a, 0x36, 0x02, 0x10, 0x20, 0x03, 0x41, 0x08, 0x41, 0x10, 0x20, 0x04,
  0x41, 0x01, 0x46, 0x1b, 0x36, 0x02, 0x14, 0x20, 0x03, 0x20, 0x03, 0x29,
  0x03, 0x10, 0x37, 0x03, 0x08, 0x20, 0x03, 0x41, 0x18, 0x6a, 0x20, 0x03,
  0x41, 0x08, 0x6a, 0x10, 0x82, 0x01, 0x22, 0x05, 0x20, 0x05, 0x28, 0x02,
  0x14, 0x22, 0x06, 0x41, 0x20, 0x6a, 0x22, 0x04, 0x36, 0x02, 0x14, 0x20,
  0x05, 0x20, 0x05, 0x28, 0x02, 0x18, 0x20, 0x06, 0x41, 0x5f, 0x4b, 0x6a,
  0x22, 0x09, 0x36, 0x02, 0x18, 0x41, 0x00, 0x21, 0x00, 0x02, 0x40, 0x20,
  0x06, 0x41, 0x03, 0x76, 0x41, 0x3f, 0x71, 0x22, 0x07, 0x41, 0x3c, 0x49,
  0x04, 0x40, 0x41, 0x00, 0x21, 0x06, 0x0c, 0x01, 0x0b, 0x20, 0x05, 0x41,
  0x1c, 0x6a, 0x22, 0x04, 0x20, 0x07, 0x6a, 0x20, 0x03, 0x41, 0xfc, 0x00,
  0x6a, 0x41, 0xc0, 0x00, 0x20, 0x07, 0x6b, 0x22, 0x06, 0x10, 0x24, 0x1a,
  0x20, 0x05, 0x20, 0x04, 0x10, 0x33, 0x20, 0x05, 0x28, 0x02, 0x18, 0x21,
  0x09, 0x20, 0x05, 0x28, 0x02, 0x14, 0x21, 0x04, 0x41, 0x00, 0x21, 0x07,
  0x0b, 0x20, 0x05, 0x20, 0x07, 0x6a, 0x41, 0x1c, 0x6a, 0x20, 0x03, 0x41,
  0xfc, 0x00, 0x6a, 0x20, 0x06, 0x6a, 0x41, 0x04, 0x20, 0x06, 0x6b, 0x10,
  0x24, 0x1a, 0x20, 0x01, 0x28, 0x02, 0x00, 0x21, 0x07, 0x20, 0x05, 0x20,
  0x09, 0x20, 0x08, 0x41, 0x1d, 0x76, 0x6a, 0x20, 0x08, 0x41, 0x03, 0x74,
  0x22, 0x01, 0x20, 0x04, 0x6a, 0x22, 0x06, 0x20, 0x01, 0x49, 0x6a, 0x36,
  0x02, 0x18, 0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0x14, 0x02, 0x40, 0x20,
  0x04, 0x41, 0x03, 0x76, 0x41, 0x3f, 0x71, 0x22, 0x06, 0x20, 0x08, 0x6a,
  0x41, 0xc0, 0x00, 0x49, 0x0d, 0x00, 0x20, 0x05, 0x41, 0x1c, 0x6a, 0x22,
  0x01, 0x20, 0x06, 0x6a, 0x20, 0x07, 0x41, 0xc0, 0x00, 0x20, 0x06, 0x6b,
  0x22, 0x00, 0x10, 0x24, 0x1a, 0x20, 0x05, 0x20, 0x01, 0x10, 0x33, 0x20,
  0x06, 0x41, 0xff, 0x00, 0x73, 0x21, 0x01, 0x41, 0x00, 0x21, 0x06, 0x20,
  0x01, 0x20, 0x08, 0x4f, 0x0d, 0x00, 0x03, 0x40, 0x20, 0x05, 0x20, 0x00,
  0x20, 0x07, 0x6a, 0x10, 0x33, 0x20, 0x00, 0x41, 0xff, 0x00, 0x6a, 0x21,
  0x04, 0x20, 0x00, 0x41, 0x40, 0x6b, 0x22, 0x01, 0x21, 0x00, 0x20, 0x04,
  0x20, 0x08, 0x49, 0x0d, 0x00, 0x0b, 0x20, 0x01, 0x21, 0x00, 0x0b, 0x20,
  0x05, 0x20, 0x06, 0x6a, 0x41, 0x1c, 0x6a, 0x20, 0x00, 0x20, 0x07, 0x6a,
  0x20, 0x08, 0x20, 0x00, 0x6b, 0x10, 0x24, 0x1a, 0x20, 0x05, 0x20, 0x03,
  0x41, 0xa0, 0x02, 0x6a, 0x10, 0x49, 0x20, 0x03, 0x42, 0xfe, 0xb9, 0xeb,
  0xc5, 0xe9, 0x8e, 0x95, 0x99, 0x10, 0x37, 0x03, 0xd8, 0x01, 0x20, 0x03,
  0x42, 0x81, 0xc6, 0x94, 0xba, 0x96, 0xf1, 0xea, 0xe6, 0x6f, 0x37, 0x03,
  0xd0, 0x01, 0x20, 0x03, 0x20, 0x05, 0x29, 0x02, 0x5c, 0x22, 0x0b, 0x42,
  0x20, 0x88, 0x22, 0x0a, 0x37, 0x03, 0xc8, 0x01, 0x20, 0x0b, 0xa7, 0x21,
  0x00, 0x02, 0x7f, 0x20, 0x0a, 0xa7, 0x22, 0x01, 0x41, 0xc0, 0x00, 0x49,
  0x04, 0x40, 0x20, 0x01, 0x0c, 0x01, 0x0b, 0x03, 0x40, 0x20, 0x03, 0x41,
  0xc8, 0x01, 0x6a, 0x20, 0x00, 0x10, 0x2d, 0x20, 0x00, 0x41, 0x40, 0x6b,
  0x21, 0x00, 0x20, 0x01, 0x41, 0x40, 0x6a, 0x22, 0x01, 0x41, 0x3f, 0x4b,
  0x0d, 0x00, 0x0b, 0x20, 0x03, 0x29, 0x03, 0xc8, 0x01, 0x22, 0x0a, 0xa7,
  0x0b, 0x21, 0x04, 0x20, 0x03, 0x41, 0xe0, 0x01, 0x6a, 0x20, 0x00, 0x20,
  0x01, 0x10, 0x24, 0x21, 0x05, 0x20, 0x03, 0x42, 0xdc, 0xb8, 0xf1, 0xe2,
  0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x03, 0xb8, 0x01, 0x20, 0x03,
  0x42, 0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37,
  0x03, 0xb0, 0x01, 0x20, 0x03, 0x42, 0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b,
  0x97, 0xae, 0xdc, 0x00, 0x37, 0x03, 0xa8, 0x01, 0x20, 0x03, 0x42, 0xdc,
  0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x03, 0xa0,
  0x01, 0x20, 0x03, 0x20, 0x0a, 0x42, 0x30, 0x7c, 0x22, 0x0a, 0x37, 0x03,
  0xc8, 0x01, 0x20, 0x03, 0x42, 0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97,
  0xae, 0xdc, 0x00, 0x37, 0x03, 0x98, 0x01, 0x20, 0x03, 0x42, 0xdc, 0xb8,
  0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x03, 0x90, 0x01,
  0x02, 0x40, 0x02, 0x7f, 0x20, 0x04, 0x41, 0x3f, 0x71, 0x22, 0x01, 0x45,
  0x04, 0x40, 0x20, 0x03, 0x41, 0x90, 0x01, 0x6a, 0x21, 0x04, 0x41, 0x30,
  0x0c, 0x01, 0x0b, 0x20, 0x01, 0x20, 0x03, 0x6a, 0x41, 0xe0, 0x01, 0x6a,
  0x21, 0x00, 0x20, 0x01, 0x41, 0x0f, 0x4d, 0x04, 0x40, 0x20, 0x00, 0x42,
  0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x00,
  0x00, 0x20, 0x00, 0x42, 0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae,
  0xdc, 0x00, 0x37, 0x00, 0x28, 0x20, 0x00, 0x42, 0xdc, 0xb8, 0xf1, 0xe2,
  0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x00, 0x20, 0x20, 0x00, 0x42,
  0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x00,
  0x18, 0x20, 0x00, 0x42, 0xdc, 0xb8, 0xf1, 0xe2, 0xc5, 0x8b, 0x97, 0xae,
  0xdc, 0x00, 0x37, 0x00, 0x10, 0x20, 0x00, 0x42, 0xdc, 0xb8, 0xf1, 0xe2,
  0xc5, 0x8b, 0x97, 0xae, 0xdc, 0x00, 0x37, 0x00, 0x08, 0x0c, 0x02, 0x0b,
  0x20, 0x00, 0x20, 0x03, 0x41, 0x90, 0x01, 0x6a, 0x22, 0x04, 0x41, 0xc0,
  0x00, 0x20, 0x01, 0x6b, 0x22, 0x00, 0x10, 0x24, 0x1a, 0x20, 0x03, 0x41,
  0xc8, 0x01, 0x6a, 0x20, 0x05, 0x10, 0x2d, 0x20, 0x00, 0x20, 0x04, 0x6a,
  0x21, 0x04, 0x20, 0x03, 0x29, 0x03, 0xc8, 0x01, 0x21, 0x0a, 0x20, 0x01,
  0x41, 0x10, 0x6b, 0x0b, 0x21, 0x01, 0x20, 0x05, 0x20, 0x04, 0x20, 0x01,
  0x10, 0x24, 0x1a, 0x0b, 0x20, 0x03, 0x20, 0x0a, 0x42, 0x14, 0x7c, 0x37,
  0x03, 0xc8, 0x01, 0x02, 0x40, 0x02, 0x7f, 0x20, 0x0a, 0xa7, 0x41, 0x3f,
  0x71, 0x22, 0x00, 0x45, 0x04, 0x40, 0x20, 0x03, 0x41, 0xa0, 0x02, 0x6a,
  0x21, 0x04, 0x41, 0x14, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x20, 0x03, 0x6a,
  0x41, 0xe0, 0x01, 0x6a, 0x21, 0x01, 0x20, 0x00, 0x41, 0x2b, 0x4d, 0x04,
  0x40, 0x20, 0x01, 0x20, 0x03, 0x29, 0x03, 0xa0, 0x02, 0x37, 0x00, 0x00,
  0x20, 0x01, 0x20, 0x03, 0x29, 0x03, 0xa8, 0x02, 0x37, 0x00, 0x08, 0x20,
  0x01, 0x20, 0x03, 0x28, 0x02, 0xb0, 0x02, 0x36, 0x00, 0x10, 0x0c, 0x02,
  0x0b, 0x20, 0x01, 0x20, 0x03, 0x41, 0xa0, 0x02, 0x6a, 0x22, 0x01, 0x41,
  0xc0, 0x00, 0x20, 0x00, 0x6b, 0x22, 0x04, 0x10, 0x24, 0x1a, 0x20, 0x03,
  0x41, 0xc8, 0x01, 0x6a, 0x20, 0x05, 0x10, 0x2d, 0x20, 0x01, 0x20, 0x04,
  0x6a, 0x21, 0x04, 0x20, 0x00, 0x41, 0x2c, 0x6b, 0x0b, 0x21, 0x01, 0x20,
  0x05, 0x20, 0x04, 0x20, 0x01, 0x10, 0x24, 0x1a, 0x0b, 0x20, 0x03, 0x41,
  0xc8, 0x01, 0x6a, 0x20, 0x03, 0x41, 0x80, 0x01, 0x6a, 0x10, 0x35, 0x20,
  0x02, 0x20, 0x03, 0x29, 0x03, 0x80, 0x01, 0x37, 0x00, 0x00, 0x20, 0x03,
  0x41, 0xc0, 0x02, 0x6a, 0x24, 0x00, 0x0b, 0x03, 0x00, 0x01, 0x0b, 0xed,
  0x03, 0x01, 0x05, 0x7f, 0x20, 0x00, 0x41, 0x00, 0x36, 0x02, 0x08, 0x20,
  0x00, 0x42, 0x00, 0x37, 0x02, 0x00, 0x20, 0x00, 0x20, 0x01, 0x10, 0x51,
  0x02, 0x40, 0x02, 0x40, 0x20, 0x00, 0x28, 0x02, 0x04, 0x22, 0x03, 0x20,
  0x00, 0x28, 0x02, 0x08, 0x22, 0x04, 0x49, 0x04, 0x40, 0x20, 0x03, 0x41,
  0x04, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x22,
  0x04, 0x36, 0x02, 0x04, 0x20, 0x00, 0x28, 0x02, 0x00, 0x21, 0x03, 0x0c,
  0x01, 0x0b, 0x20, 0x03, 0x20, 0x00, 0x28, 0x02, 0x00, 0x22, 0x05, 0x6b,
  0x22, 0x06, 0x41, 0x01, 0x6a, 0x22, 0x03, 0x41, 0x7f, 0x4c, 0x0d, 0x01,
  0x20, 0x06, 0x20, 0x03, 0x20, 0x04, 0x20, 0x05, 0x6b, 0x22, 0x04, 0x41,
  0x01, 0x74, 0x22, 0x07, 0x20, 0x03, 0x20, 0x07, 0x4b, 0x1b, 0x41, 0xff,
  0xff, 0xff, 0xff, 0x07, 0x20, 0x04, 0x41, 0xff, 0xff, 0xff, 0xff, 0x03,
  0x49, 0x1b, 0x22, 0x07, 0x04, 0x7f, 0x20, 0x07, 0x10, 0x27, 0x05, 0x41,
  0x00, 0x0b, 0x22, 0x03, 0x6a, 0x22, 0x04, 0x41, 0x04, 0x3a, 0x00, 0x00,
  0x20, 0x04, 0x41, 0x01, 0x6a, 0x21, 0x04, 0x20, 0x06, 0x41, 0x01, 0x4e,
  0x04, 0x40, 0x20, 0x03, 0x20, 0x05, 0x20, 0x06, 0x10, 0x24, 0x1a, 0x0b,
  0x20, 0x00, 0x20, 0x03, 0x20, 0x07, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00,
  0x20, 0x04, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x03, 0x36, 0x02, 0x00,
  0x20, 0x05, 0x45, 0x0d, 0x00, 0x20, 0x05, 0x10, 0x23, 0x0b, 0x20, 0x00,
  0x20, 0x01, 0x20, 0x04, 0x6a, 0x20, 0x03, 0x6b, 0x10, 0x51, 0x20, 0x02,
  0x41, 0xa0, 0x7f, 0x72, 0x21, 0x04, 0x02, 0x40, 0x20, 0x00, 0x28, 0x02,
  0x04, 0x22, 0x01, 0x20, 0x00, 0x28, 0x02, 0x08, 0x22, 0x03, 0x49, 0x04,
  0x40, 0x20, 0x01, 0x20, 0x04, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x01,
  0x41, 0x01, 0x6a, 0x22, 0x01, 0x36, 0x02, 0x04, 0x20, 0x00, 0x28, 0x02,
  0x00, 0x21, 0x03, 0x0c, 0x01, 0x0b, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02,
  0x00, 0x22, 0x02, 0x6b, 0x22, 0x05, 0x41, 0x01, 0x6a, 0x22, 0x01, 0x41,
  0x7f, 0x4c, 0x0d, 0x01, 0x20, 0x05, 0x20, 0x01, 0x20, 0x03, 0x20, 0x02,
  0x6b, 0x22, 0x03, 0x41, 0x01, 0x74, 0x22, 0x06, 0x20, 0x01, 0x20, 0x06,
  0x4b, 0x1b, 0x41, 0xff, 0xff, 0xff, 0xff, 0x07, 0x20, 0x03, 0x41, 0xff,
  0xff, 0xff, 0xff, 0x03, 0x49, 0x1b, 0x22, 0x06, 0x04, 0x7f, 0x20, 0x06,
  0x10, 0x27, 0x05, 0x41, 0x00, 0x0b, 0x22, 0x03, 0x6a, 0x22, 0x01, 0x20,
  0x04, 0x3a, 0x00, 0x00, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x20,
  0x05, 0x41, 0x01, 0x4e, 0x04, 0x40, 0x20, 0x03, 0x20, 0x02, 0x20, 0x05,
  0x10, 0x24, 0x1a, 0x0b, 0x20, 0x00, 0x20, 0x03, 0x20, 0x06, 0x6a, 0x36,
  0x02, 0x08, 0x20, 0x00, 0x20, 0x01, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20,
  0x03, 0x36, 0x02, 0x00, 0x20, 0x02, 0x45, 0x0d, 0x00, 0x20, 0x02, 0x10,
  0x23, 0x0b, 0x02, 0x40, 0x20, 0x01, 0x20, 0x03, 0x46, 0x0d, 0x00, 0x20,
  0x01, 0x41, 0x01, 0x6b, 0x22, 0x00, 0x20, 0x03, 0x4d, 0x0d, 0x00, 0x03,
  0x40, 0x20, 0x03, 0x2d, 0x00, 0x00, 0x21, 0x01, 0x20, 0x03, 0x20, 0x00,
  0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x01, 0x3a, 0x00,
  0x00, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x22, 0x03, 0x20, 0x00, 0x41, 0x01,
  0x6b, 0x22, 0x00, 0x49, 0x0d, 0x00, 0x0b, 0x0b, 0x0f, 0x0b, 0x10, 0x37,
  0x00, 0x0b, 0xcf, 0x02, 0x01, 0x04, 0x7f, 0x20, 0x01, 0x02, 0x7f, 0x20,
  0x00, 0x2d, 0x00, 0x0b, 0x41, 0x07, 0x76, 0x04, 0x40, 0x20, 0x00, 0x28,
  0x02, 0x04, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x2d, 0x00, 0x0b, 0x0b, 0x22,
  0x02, 0x4b, 0x04, 0x40, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x03, 0x24,
  0x00, 0x20, 0x01, 0x20, 0x02, 0x6b, 0x22, 0x05, 0x04, 0x40, 0x20, 0x00,
  0x2d, 0x00, 0x0b, 0x41, 0x07, 0x76, 0x04, 0x7f, 0x20, 0x00, 0x28, 0x02,
  0x08, 0x41, 0xff, 0xff, 0xff, 0xff, 0x07, 0x71, 0x41, 0x01, 0x6b, 0x05,
  0x41, 0x0a, 0x0b, 0x21, 0x04, 0x02, 0x7f, 0x20, 0x00, 0x2d, 0x00, 0x0b,
  0x41, 0x07, 0x76, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02, 0x04, 0x0c, 0x01,
  0x0b, 0x20, 0x00, 0x2d, 0x00, 0x0b, 0x0b, 0x22, 0x02, 0x20, 0x05, 0x6a,
  0x21, 0x01, 0x20, 0x05, 0x20, 0x04, 0x20, 0x02, 0x6b, 0x4b, 0x04, 0x40,
  0x20, 0x00, 0x20, 0x04, 0x20, 0x01, 0x20, 0x04, 0x6b, 0x20, 0x02, 0x20,
  0x02, 0x41, 0x00, 0x10, 0x6d, 0x0b, 0x20, 0x02, 0x02, 0x7f, 0x20, 0x00,
  0x2d, 0x00, 0x0b, 0x41, 0x07, 0x76, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02,
  0x00, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x0b, 0x22, 0x04, 0x6a, 0x41, 0x00,
  0x20, 0x05, 0x10, 0x29, 0x1a, 0x02, 0x40, 0x20, 0x00, 0x2d, 0x00, 0x0b,
  0x41, 0x07, 0x76, 0x04, 0x40, 0x20, 0x00, 0x20, 0x01, 0x36, 0x02, 0x04,
  0x0c, 0x01, 0x0b, 0x20, 0x00, 0x20, 0x01, 0x3a, 0x00, 0x0b, 0x0b, 0x20,
  0x03, 0x41, 0x00, 0x3a, 0x00, 0x0f, 0x20, 0x01, 0x20, 0x04, 0x6a, 0x20,
  0x03, 0x2d, 0x00, 0x0f, 0x3a, 0x00, 0x00, 0x0b, 0x20, 0x03, 0x41, 0x10,
  0x6a, 0x24, 0x00, 0x0f, 0x0b, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x02,
  0x24, 0x00, 0x02, 0x40, 0x20, 0x00, 0x2d, 0x00, 0x0b, 0x41, 0x07, 0x76,
  0x04, 0x40, 0x20, 0x00, 0x28, 0x02, 0x00, 0x21, 0x03, 0x20, 0x02, 0x41,
  0x00, 0x3a, 0x00, 0x0f, 0x20, 0x01, 0x20, 0x03, 0x6a, 0x20, 0x02, 0x2d,
  0x00, 0x0f, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x01, 0x36, 0x02, 0x04,
  0x0c, 0x01, 0x0b, 0x20, 0x02, 0x41, 0x00, 0x3a, 0x00, 0x0e, 0x20, 0x00,
  0x20, 0x01, 0x6a, 0x20, 0x02, 0x2d, 0x00, 0x0e, 0x3a, 0x00, 0x00, 0x20,
  0x00, 0x20, 0x01, 0x3a, 0x00, 0x0b, 0x0b, 0x20, 0x02, 0x41, 0x10, 0x6a,
  0x24, 0x00, 0x0b, 0x65, 0x01, 0x05, 0x7f, 0x41, 0x08, 0x10, 0x02, 0x22,
  0x04, 0x22, 0x05, 0x22, 0x03, 0x41, 0xf0, 0x93, 0x1b, 0x36, 0x02, 0x00,
  0x20, 0x03, 0x41, 0xf4, 0x92, 0x1b, 0x36, 0x02, 0x00, 0x20, 0x00, 0x10,
  0x39, 0x22, 0x01, 0x41, 0x0d, 0x6a, 0x10, 0x27, 0x22, 0x02, 0x41, 0x00,
  0x36, 0x02, 0x08, 0x20, 0x02, 0x20, 0x01, 0x36, 0x02, 0x04, 0x20, 0x02,
  0x20, 0x01, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x02, 0x41, 0x0c, 0x6a,
  0x20, 0x00, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x10, 0x24, 0x36, 0x02, 0x04,
  0x20, 0x05, 0x41, 0xa4, 0x93, 0x1b, 0x36, 0x02, 0x00, 0x20, 0x04, 0x41,
  0xc4, 0x93, 0x1b, 0x41, 0x21, 0x10, 0x08, 0x00, 0x0b, 0xb3, 0x05, 0x01,
  0x05, 0x7f, 0x23, 0x00, 0x41, 0x10, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x20,
  0x04, 0x20, 0x00, 0x28, 0x02, 0x18, 0x22, 0x02, 0x41, 0x18, 0x74, 0x20,
  0x02, 0x41, 0x08, 0x74, 0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20,
  0x02, 0x41, 0x08, 0x76, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x02, 0x41,
  0x18, 0x76, 0x72, 0x72, 0x36, 0x02, 0x08, 0x20, 0x04, 0x20, 0x00, 0x28,
  0x02, 0x14, 0x22, 0x05, 0x41, 0x18, 0x74, 0x20, 0x05, 0x41, 0x08, 0x74,
  0x41, 0x80, 0x80, 0xfc, 0x07, 0x71, 0x72, 0x20, 0x05, 0x41, 0x08, 0x76,
  0x41, 0x80, 0xfe, 0x03, 0x71, 0x20, 0x05, 0x41, 0x18, 0x76, 0x72, 0x72,
  0x36, 0x02, 0x0c, 0x20, 0x04, 0x41, 0x80, 0x01, 0x3a, 0x00, 0x07, 0x20,
  0x00, 0x20, 0x02, 0x20, 0x05, 0x41, 0x77, 0x4b, 0x6a, 0x36, 0x02, 0x18,
  0x20, 0x00, 0x20, 0x05, 0x41, 0x08, 0x6a, 0x22, 0x03, 0x36, 0x02, 0x14,
  0x20, 0x05, 0x41, 0x03, 0x76, 0x41, 0x3f, 0x71, 0x22, 0x02, 0x41, 0x3f,
  0x46, 0x04, 0x7f, 0x20, 0x00, 0x41, 0x80, 0x01, 0x3a, 0x00, 0x5b, 0x20,
  0x00, 0x20, 0x00, 0x41, 0x1c, 0x6a, 0x10, 0x33, 0x20, 0x00, 0x28, 0x02,
  0x14, 0x21, 0x03, 0x41, 0x01, 0x21, 0x06, 0x41, 0x00, 0x05, 0x20, 0x02,
  0x0b, 0x20, 0x00, 0x41, 0x1c, 0x6a, 0x22, 0x05, 0x6a, 0x20, 0x04, 0x41,
  0x07, 0x6a, 0x20, 0x06, 0x6a, 0x20, 0x06, 0x45, 0x10, 0x24, 0x1a, 0x02,
  0x40, 0x20, 0x03, 0x41, 0xf8, 0x03, 0x71, 0x41, 0xc0, 0x03, 0x46, 0x04,
  0x40, 0x20, 0x03, 0x21, 0x02, 0x0c, 0x01, 0x0b, 0x03, 0x40, 0x41, 0x00,
  0x21, 0x06, 0x20, 0x04, 0x41, 0x00, 0x3a, 0x00, 0x07, 0x20, 0x00, 0x20,
  0x03, 0x41, 0x08, 0x6a, 0x22, 0x02, 0x36, 0x02, 0x14, 0x20, 0x00, 0x20,
  0x00, 0x28, 0x02, 0x18, 0x20, 0x03, 0x41, 0x77, 0x4b, 0x6a, 0x36, 0x02,
  0x18, 0x20, 0x03, 0x41, 0x03, 0x76, 0x41, 0x3f, 0x71, 0x22, 0x03, 0x41,
  0x3f, 0x46, 0x04, 0x40, 0x41, 0x00, 0x21, 0x03, 0x20, 0x00, 0x41, 0x00,
  0x3a, 0x00, 0x5b, 0x20, 0x00, 0x20, 0x05, 0x10, 0x33, 0x41, 0x01, 0x21,
  0x06, 0x20, 0x00, 0x28, 0x02, 0x14, 0x21, 0x02, 0x0b, 0x20, 0x00, 0x20,
  0x03, 0x6a, 0x41, 0x1c, 0x6a, 0x20, 0x04, 0x41, 0x07, 0x6a, 0x20, 0x06,
  0x6a, 0x20, 0x06, 0x45, 0x10, 0x24, 0x1a, 0x20, 0x02, 0x22, 0x03, 0x41,
  0xf8, 0x03, 0x71, 0x41, 0xc0, 0x03, 0x47, 0x0d, 0x00, 0x0b, 0x0b, 0x20,
  0x00, 0x20, 0x02, 0x41, 0x40, 0x6b, 0x36, 0x02, 0x14, 0x20, 0x00, 0x20,
  0x00, 0x28, 0x02, 0x18, 0x20, 0x02, 0x41, 0xbf, 0x7f, 0x4b, 0x6a, 0x36,
  0x02, 0x18, 0x02, 0x40, 0x20, 0x02, 0x41, 0x03, 0x76, 0x41, 0x3f, 0x71,
  0x22, 0x03, 0x41, 0x38, 0x49, 0x04, 0x40, 0x41, 0x00, 0x21, 0x02, 0x0c,
  0x01, 0x0b, 0x20, 0x00, 0x20, 0x03, 0x6a, 0x41, 0x1c, 0x6a, 0x20, 0x04,
  0x41, 0x08, 0x6a, 0x41, 0xc0, 0x00, 0x20, 0x03, 0x6b, 0x22, 0x02, 0x10,
  0x24, 0x1a, 0x20, 0x00, 0x20, 0x05, 0x10, 0x33, 0x41, 0x00, 0x21, 0x03,
  0x0b, 0x20, 0x00, 0x20, 0x03, 0x6a, 0x41, 0x1c, 0x6a, 0x20, 0x04, 0x41,
  0x08, 0x6a, 0x20, 0x02, 0x6a, 0x41, 0x08, 0x20, 0x02, 0x6b, 0x10, 0x24,
  0x1a, 0x20, 0x01, 0x20, 0x00, 0x2d, 0x00, 0x03, 0x3a, 0x00, 0x00, 0x20,
  0x01, 0x20, 0x00, 0x2f, 0x01, 0x02, 0x3a, 0x00, 0x01, 0x20, 0x01, 0x20,
  0x00, 0x28, 0x02, 0x00, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x02, 0x20, 0x01,
  0x20, 0x00, 0x28, 0x02, 0x00, 0x3a, 0x00, 0x03, 0x20, 0x01, 0x20, 0x00,
  0x2d, 0x00, 0x07, 0x3a, 0x00, 0x04, 0x20, 0x01, 0x20, 0x00, 0x2f, 0x01,
  0x06, 0x3a, 0x00, 0x05, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x04, 0x41,
  0x08, 0x76, 0x3a, 0x00, 0x06, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x04,
  0x3a, 0x00, 0x07, 0x20, 0x01, 0x20, 0x00, 0x2d, 0x00, 0x0b, 0x3a, 0x00,
  0x08, 0x20, 0x01, 0x20, 0x00, 0x2f, 0x01, 0x0a, 0x3a, 0x00, 0x09, 0x20,
  0x01, 0x20, 0x00, 0x28, 0x02, 0x08, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x0a,
  0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x08, 0x3a, 0x00, 0x0b, 0x20, 0x01,
  0x20, 0x00, 0x2d, 0x00, 0x0f, 0x3a, 0x00, 0x0c, 0x20, 0x01, 0x20, 0x00,
  0x2f, 0x01, 0x0e, 0x3a, 0x00, 0x0d, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02,
  0x0c, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x0e, 0x20, 0x01, 0x20, 0x00, 0x28,
  0x02, 0x0c, 0x3a, 0x00, 0x0f, 0x20, 0x01, 0x20, 0x00, 0x2d, 0x00, 0x13,
  0x3a, 0x00, 0x10, 0x20, 0x01, 0x20, 0x00, 0x2f, 0x01, 0x12, 0x3a, 0x00,
  0x11, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x10, 0x41, 0x08, 0x76, 0x3a,
  0x00, 0x12, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x10, 0x3a, 0x00, 0x13,
  0x20, 0x00, 0x41, 0x00, 0x41, 0xdc, 0x00, 0x10, 0x29, 0x1a, 0x20, 0x04,
  0x41, 0x10, 0x6a, 0x24, 0x00, 0x0b, 0xa7, 0x01, 0x01, 0x02, 0x7f, 0x23,
  0x00, 0x41, 0x20, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x02, 0x40, 0x02, 0x40,
  0x20, 0x01, 0x28, 0x02, 0x04, 0x22, 0x05, 0x04, 0x40, 0x20, 0x01, 0x28,
  0x02, 0x00, 0x22, 0x01, 0x2d, 0x00, 0x00, 0x20, 0x02, 0x47, 0x0d, 0x01,
  0x20, 0x04, 0x20, 0x05, 0x41, 0x01, 0x6b, 0x36, 0x02, 0x14, 0x20, 0x04,
  0x20, 0x01, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x10, 0x20, 0x04, 0x20, 0x04,
  0x29, 0x03, 0x10, 0x37, 0x03, 0x08, 0x20, 0x00, 0x20, 0x04, 0x41, 0x08,
  0x6a, 0x20, 0x03, 0x10, 0xe8, 0x01, 0x20, 0x04, 0x41, 0x20, 0x6a, 0x24,
  0x00, 0x0f, 0x0b, 0x20, 0x04, 0x20, 0x03, 0x36, 0x02, 0x18, 0x41, 0x03,
  0x41, 0xad, 0xa3, 0x03, 0x20, 0x04, 0x41, 0x18, 0x6a, 0x10, 0x31, 0x0c,
  0x01, 0x0b, 0x20, 0x04, 0x20, 0x03, 0x36, 0x02, 0x18, 0x41, 0x03, 0x41,
  0x9a, 0xf5, 0x02, 0x20, 0x04, 0x41, 0x18, 0x6a, 0x10, 0x31, 0x0b, 0x41,
  0x0c, 0x10, 0x02, 0x22, 0x00, 0x41, 0x00, 0x36, 0x02, 0x08, 0x20, 0x00,
  0x42, 0xda, 0xb3, 0x01, 0x37, 0x02, 0x00, 0x20, 0x00, 0x41, 0xa8, 0xf1,
  0x1a, 0x41, 0x00, 0x10, 0x08, 0x00, 0x0b, 0xd5, 0x02, 0x01, 0x02, 0x7f,
  0x02, 0x40, 0x20, 0x00, 0x20, 0x01, 0x46, 0x0d, 0x00, 0x20, 0x01, 0x20,
  0x00, 0x20, 0x02, 0x6a, 0x22, 0x04, 0x6b, 0x41, 0x00, 0x20, 0x02, 0x41,
  0x01, 0x74, 0x6b, 0x4d, 0x04, 0x40, 0x20, 0x00, 0x20, 0x01, 0x20, 0x02,
  0x10, 0x24, 0x1a, 0x0f, 0x0b, 0x20, 0x00, 0x20, 0x01, 0x73, 0x41, 0x03,
  0x71, 0x21, 0x03, 0x02, 0x40, 0x02, 0x40, 0x20, 0x00, 0x20, 0x01, 0x49,
  0x04, 0x40, 0x20, 0x03, 0x0d, 0x02, 0x20, 0x00, 0x41, 0x03, 0x71, 0x45,
  0x0d, 0x01, 0x03, 0x40, 0x20, 0x02, 0x45, 0x0d, 0x04, 0x20, 0x00, 0x20,
  0x01, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x01, 0x41, 0x01, 0x6a,
  0x21, 0x01, 0x20, 0x02, 0x41, 0x01, 0x6b, 0x21, 0x02, 0x20, 0x00, 0x41,
  0x01, 0x6a, 0x22, 0x00, 0x41, 0x03, 0x71, 0x0d, 0x00, 0x0b, 0x0c, 0x01,
  0x0b, 0x02, 0x40, 0x20, 0x03, 0x0d, 0x00, 0x20, 0x04, 0x41, 0x03, 0x71,
  0x04, 0x40, 0x03, 0x40, 0x20, 0x02, 0x45, 0x0d, 0x05, 0x20, 0x00, 0x20,
  0x02, 0x41, 0x01, 0x6b, 0x22, 0x02, 0x6a, 0x22, 0x03, 0x20, 0x01, 0x20,
  0x02, 0x6a, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x20, 0x03, 0x41, 0x03,
  0x71, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x02, 0x41, 0x03, 0x4d, 0x0d, 0x00,
  0x03, 0x40, 0x20, 0x00, 0x20, 0x02, 0x41, 0x04, 0x6b, 0x22, 0x02, 0x6a,
  0x20, 0x01, 0x20, 0x02, 0x6a, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20,
  0x02, 0x41, 0x03, 0x4b, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x02, 0x45, 0x0d,
  0x02, 0x03, 0x40, 0x20, 0x00, 0x20, 0x02, 0x41, 0x01, 0x6b, 0x22, 0x02,
  0x6a, 0x20, 0x01, 0x20, 0x02, 0x6a, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00,
  0x20, 0x02, 0x0d, 0x00, 0x0b, 0x0c, 0x02, 0x0b, 0x20, 0x02, 0x41, 0x03,
  0x4d, 0x0d, 0x00, 0x03, 0x40, 0x20, 0x00, 0x20, 0x01, 0x28, 0x02, 0x00,
  0x36, 0x02, 0x00, 0x20, 0x01, 0x41, 0x04, 0x6a, 0x21, 0x01, 0x20, 0x00,
  0x41, 0x04, 0x6a, 0x21, 0x00, 0x20, 0x02, 0x41, 0x04, 0x6b, 0x22, 0x02,
  0x41, 0x03, 0x4b, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x02, 0x45, 0x0d, 0x00,
  0x03, 0x40, 0x20, 0x00, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0x00,
  0x20, 0x00, 0x41, 0x01, 0x6a, 0x21, 0x00, 0x20, 0x01, 0x41, 0x01, 0x6a,
  0x21, 0x01, 0x20, 0x02, 0x41, 0x01, 0x6b, 0x22, 0x02, 0x0d, 0x00, 0x0b,
  0x0b, 0x0b, 0x03, 0x00, 0x01, 0x0b, 0x03, 0x00, 0x01, 0x0b, 0x4f, 0x01,
  0x02, 0x7f, 0x23, 0x00, 0x41, 0x20, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x10,
  0x00, 0x21, 0x04, 0x20, 0x01, 0x28, 0x02, 0x00, 0x21, 0x01, 0x20, 0x03,
  0x20, 0x02, 0x28, 0x02, 0x00, 0x36, 0x02, 0x10, 0x20, 0x03, 0x20, 0x01,
  0x36, 0x02, 0x0c, 0x20, 0x03, 0x20, 0x04, 0x36, 0x02, 0x08, 0x20, 0x03,
  0x20, 0x04, 0x36, 0x02, 0x04, 0x20, 0x03, 0x41, 0xf3, 0xe3, 0x03, 0x36,
  0x02, 0x00, 0x41, 0x03, 0x20, 0x00, 0x20, 0x03, 0x10, 0x22, 0x20, 0x03,
  0x41, 0x20, 0x6a, 0x24, 0x00, 0x0b, 0x04, 0x00, 0x20, 0x00, 0x0b, 0x09,
  0x00, 0x41, 0x8a, 0xf3, 0x02, 0x10, 0x48, 0x00, 0x0b, 0xe2, 0x05, 0x01,
  0x05, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x00, 0x28, 0x02,
  0x04, 0x22, 0x03, 0x20, 0x00, 0x28, 0x02, 0x08, 0x22, 0x05, 0x49, 0x04,
  0x40, 0x20, 0x03, 0x20, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x03,
  0x41, 0x01, 0x6a, 0x36, 0x02, 0x04, 0x0c, 0x01, 0x0b, 0x20, 0x03, 0x20,
  0x00, 0x28, 0x02, 0x00, 0x22, 0x03, 0x6b, 0x22, 0x04, 0x41, 0x01, 0x6a,
  0x22, 0x02, 0x41, 0x7f, 0x4c, 0x0d, 0x01, 0x20, 0x04, 0x20, 0x02, 0x20,
  0x05, 0x20, 0x03, 0x6b, 0x22, 0x05, 0x41, 0x01, 0x74, 0x22, 0x06, 0x20,
  0x02, 0x20, 0x06, 0x4b, 0x1b, 0x41, 0xff, 0xff, 0xff, 0xff, 0x07, 0x20,
  0x05, 0x41, 0xff, 0xff, 0xff, 0xff, 0x03, 0x49, 0x1b, 0x22, 0x05, 0x04,
  0x7f, 0x20, 0x05, 0x10, 0x27, 0x05, 0x41, 0x00, 0x0b, 0x22, 0x02, 0x6a,
  0x22, 0x06, 0x20, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x04, 0x41, 0x01, 0x4e,
  0x04, 0x40, 0x20, 0x02, 0x20, 0x03, 0x20, 0x04, 0x10, 0x24, 0x1a, 0x0b,
  0x20, 0x00, 0x20, 0x02, 0x20, 0x05, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00,
  0x20, 0x06, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x02,
  0x36, 0x02, 0x00, 0x20, 0x03, 0x45, 0x0d, 0x00, 0x20, 0x03, 0x10, 0x23,
  0x0b, 0x02, 0x40, 0x20, 0x01, 0x41, 0x80, 0x02, 0x4f, 0x04, 0x40, 0x20,
  0x01, 0x41, 0x08, 0x76, 0x21, 0x05, 0x02, 0x40, 0x20, 0x00, 0x28, 0x02,
  0x04, 0x22, 0x01, 0x20, 0x00, 0x28, 0x02, 0x08, 0x22, 0x02, 0x49, 0x04,
  0x40, 0x20, 0x01, 0x20, 0x05, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x01,
  0x41, 0x01, 0x6a, 0x22, 0x01, 0x36, 0x02, 0x04, 0x0c, 0x01, 0x0b, 0x20,
  0x01, 0x20, 0x00, 0x28, 0x02, 0x00, 0x22, 0x03, 0x6b, 0x22, 0x04, 0x41,
  0x01, 0x6a, 0x22, 0x01, 0x41, 0x7f, 0x4c, 0x0d, 0x03, 0x20, 0x04, 0x20,
  0x01, 0x20, 0x02, 0x20, 0x03, 0x6b, 0x22, 0x02, 0x41, 0x01, 0x74, 0x22,
  0x06, 0x20, 0x01, 0x20, 0x06, 0x4b, 0x1b, 0x41, 0xff, 0xff, 0xff, 0xff,
  0x07, 0x20, 0x02, 0x41, 0xff, 0xff, 0xff, 0xff, 0x03, 0x49, 0x1b, 0x22,
  0x06, 0x04, 0x7f, 0x20, 0x06, 0x10, 0x27, 0x05, 0x41, 0x00, 0x0b, 0x22,
  0x02, 0x6a, 0x22, 0x01, 0x20, 0x05, 0x3a, 0x00, 0x00, 0x20, 0x01, 0x41,
  0x01, 0x6a, 0x21, 0x01, 0x20, 0x04, 0x41, 0x01, 0x4e, 0x04, 0x40, 0x20,
  0x02, 0x20, 0x03, 0x20, 0x04, 0x10, 0x24, 0x1a, 0x0b, 0x20, 0x00, 0x20,
  0x02, 0x20, 0x06, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20, 0x01, 0x36,
  0x02, 0x04, 0x20, 0x00, 0x20, 0x02, 0x36, 0x02, 0x00, 0x20, 0x03, 0x45,
  0x0d, 0x00, 0x20, 0x03, 0x10, 0x23, 0x20, 0x00, 0x28, 0x02, 0x04, 0x21,
  0x01, 0x0b, 0x20, 0x00, 0x28, 0x02, 0x08, 0x22, 0x02, 0x20, 0x01, 0x4b,
  0x04, 0x40, 0x20, 0x01, 0x41, 0x82, 0x01, 0x3a, 0x00, 0x00, 0x0c, 0x04,
  0x0b, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x00, 0x22, 0x01, 0x6b, 0x22,
  0x03, 0x41, 0x01, 0x6a, 0x22, 0x04, 0x41, 0x7f, 0x4c, 0x0d, 0x02, 0x20,
  0x03, 0x20, 0x04, 0x20, 0x02, 0x20, 0x01, 0x6b, 0x22, 0x02, 0x41, 0x01,
  0x74, 0x22, 0x05, 0x20, 0x04, 0x20, 0x05, 0x4b, 0x1b, 0x41, 0xff, 0xff,
  0xff, 0xff, 0x07, 0x20, 0x02, 0x41, 0xff, 0xff, 0xff, 0xff, 0x03, 0x49,
  0x1b, 0x22, 0x02, 0x04, 0x7f, 0x20, 0x02, 0x10, 0x27, 0x05, 0x41, 0x00,
  0x0b, 0x22, 0x04, 0x6a, 0x22, 0x05, 0x41, 0x82, 0x01, 0x3a, 0x00, 0x00,
  0x20, 0x03, 0x41, 0x01, 0x4e, 0x04, 0x40, 0x20, 0x04, 0x20, 0x01, 0x20,
  0x03, 0x10, 0x24, 0x1a, 0x0b, 0x20, 0x00, 0x20, 0x02, 0x20, 0x04, 0x6a,
  0x36, 0x02, 0x08, 0x20, 0x00, 0x20, 0x05, 0x41, 0x01, 0x6a, 0x36, 0x02,
  0x04, 0x20, 0x00, 0x20, 0x04, 0x36, 0x02, 0x00, 0x20, 0x01, 0x45, 0x0d,
  0x01, 0x20, 0x01, 0x10, 0x23, 0x0f, 0x0b, 0x20, 0x01, 0x41, 0x80, 0x01,
  0x49, 0x0d, 0x00, 0x20, 0x00, 0x28, 0x02, 0x04, 0x22, 0x01, 0x20, 0x00,
  0x28, 0x02, 0x08, 0x22, 0x02, 0x49, 0x04, 0x40, 0x20, 0x01, 0x41, 0x81,
  0x01, 0x3a, 0x00, 0x00, 0x0c, 0x03, 0x0b, 0x20, 0x01, 0x20, 0x00, 0x28,
  0x02, 0x00, 0x22, 0x01, 0x6b, 0x22, 0x03, 0x41, 0x01, 0x6a, 0x22, 0x04,
  0x41, 0x7f, 0x4c, 0x0d, 0x01, 0x20, 0x03, 0x20, 0x04, 0x20, 0x02, 0x20,
  0x01, 0x6b, 0x22, 0x02, 0x41, 0x01, 0x74, 0x22, 0x05, 0x20, 0x04, 0x20,
  0x05, 0x4b, 0x1b, 0x41, 0xff, 0xff, 0xff, 0xff, 0x07, 0x20, 0x02, 0x41,
  0xff, 0xff, 0xff, 0xff, 0x03, 0x49, 0x1b, 0x22, 0x02, 0x04, 0x7f, 0x20,
  0x02, 0x10, 0x27, 0x05, 0x41, 0x00, 0x0b, 0x22, 0x04, 0x6a, 0x22, 0x05,
  0x41, 0x81, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x03, 0x41, 0x01, 0x4e, 0x04,
  0x40, 0x20, 0x04, 0x20, 0x01, 0x20, 0x03, 0x10, 0x24, 0x1a, 0x0b, 0x20,
  0x00, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20,
  0x05, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x04, 0x20, 0x00, 0x20, 0x04, 0x36,
  0x02, 0x00, 0x20, 0x01, 0x45, 0x0d, 0x00, 0x20, 0x01, 0x10, 0x23, 0x0b,
  0x0f, 0x0b, 0x10, 0x37, 0x00, 0x0b, 0x20, 0x00, 0x20, 0x01, 0x41, 0x01,
  0x6a, 0x36, 0x02, 0x04, 0x0b, 0xf3, 0x0b, 0x01, 0x09, 0x7f, 0x20, 0x00,
  0x28, 0x02, 0x04, 0x21, 0x04, 0x20, 0x00, 0x28, 0x02, 0x00, 0x21, 0x0a,
  0x20, 0x01, 0x41, 0x08, 0x4f, 0x04, 0x40, 0x20, 0x01, 0x41, 0x03, 0x76,
  0x21, 0x0b, 0x03, 0x40, 0x20, 0x02, 0x2d, 0x00, 0x00, 0x21, 0x05, 0x20,
  0x00, 0x41, 0x08, 0x6a, 0x22, 0x06, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x07, 0x20, 0x06, 0x20,
  0x04, 0x20, 0x07, 0x28, 0x02, 0x00, 0x22, 0x04, 0x6a, 0x22, 0x07, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x08, 0x28, 0x02, 0x00,
  0x22, 0x09, 0x36, 0x02, 0x00, 0x20, 0x08, 0x20, 0x04, 0x36, 0x02, 0x00,
  0x20, 0x03, 0x20, 0x05, 0x20, 0x06, 0x20, 0x04, 0x20, 0x09, 0x6a, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a,
  0x00, 0x00, 0x20, 0x02, 0x2d, 0x00, 0x01, 0x21, 0x05, 0x20, 0x06, 0x20,
  0x0a, 0x41, 0x02, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a,
  0x22, 0x04, 0x20, 0x06, 0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x04, 0x20,
  0x07, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a,
  0x22, 0x08, 0x28, 0x02, 0x00, 0x22, 0x09, 0x36, 0x02, 0x00, 0x20, 0x08,
  0x20, 0x04, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05, 0x20, 0x06, 0x20,
  0x04, 0x20, 0x09, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a,
  0x2d, 0x00, 0x00, 0x73, 0x3a, 0x00, 0x01, 0x20, 0x02, 0x2d, 0x00, 0x02,
  0x21, 0x05, 0x20, 0x06, 0x20, 0x0a, 0x41, 0x03, 0x6a, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x06, 0x20, 0x04, 0x28,
  0x02, 0x00, 0x22, 0x04, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x08, 0x28, 0x02, 0x00, 0x22, 0x09,
  0x36, 0x02, 0x00, 0x20, 0x08, 0x20, 0x04, 0x36, 0x02, 0x00, 0x20, 0x03,
  0x20, 0x05, 0x20, 0x06, 0x20, 0x04, 0x20, 0x09, 0x6a, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a, 0x00, 0x02,
  0x20, 0x02, 0x2d, 0x00, 0x03, 0x21, 0x05, 0x20, 0x06, 0x20, 0x0a, 0x41,
  0x04, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04,
  0x20, 0x06, 0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x04, 0x20, 0x07, 0x6a,
  0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x08,
  0x28, 0x02, 0x00, 0x22, 0x09, 0x36, 0x02, 0x00, 0x20, 0x08, 0x20, 0x04,
  0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05, 0x20, 0x06, 0x20, 0x04, 0x20,
  0x09, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00,
  0x00, 0x73, 0x3a, 0x00, 0x03, 0x20, 0x02, 0x2d, 0x00, 0x04, 0x21, 0x05,
  0x20, 0x06, 0x20, 0x0a, 0x41, 0x05, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x06, 0x20, 0x04, 0x28, 0x02, 0x00,
  0x22, 0x04, 0x20, 0x07, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x02, 0x74, 0x6a, 0x22, 0x08, 0x28, 0x02, 0x00, 0x22, 0x09, 0x36, 0x02,
  0x00, 0x20, 0x08, 0x20, 0x04, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05,
  0x20, 0x06, 0x20, 0x04, 0x20, 0x09, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a, 0x00, 0x04, 0x20, 0x02,
  0x2d, 0x00, 0x05, 0x21, 0x05, 0x20, 0x06, 0x20, 0x0a, 0x41, 0x06, 0x6a,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x06,
  0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x04, 0x20, 0x07, 0x6a, 0x22, 0x07,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x08, 0x28, 0x02,
  0x00, 0x22, 0x09, 0x36, 0x02, 0x00, 0x20, 0x08, 0x20, 0x04, 0x36, 0x02,
  0x00, 0x20, 0x03, 0x20, 0x05, 0x20, 0x06, 0x20, 0x04, 0x20, 0x09, 0x6a,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73,
  0x3a, 0x00, 0x05, 0x20, 0x02, 0x2d, 0x00, 0x06, 0x21, 0x05, 0x20, 0x06,
  0x20, 0x0a, 0x41, 0x07, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74,
  0x6a, 0x22, 0x04, 0x20, 0x06, 0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x04,
  0x20, 0x07, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74,
  0x6a, 0x22, 0x08, 0x28, 0x02, 0x00, 0x22, 0x09, 0x36, 0x02, 0x00, 0x20,
  0x08, 0x20, 0x04, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05, 0x20, 0x06,
  0x20, 0x04, 0x20, 0x09, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74,
  0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a, 0x00, 0x06, 0x20, 0x02, 0x2d, 0x00,
  0x07, 0x21, 0x08, 0x20, 0x06, 0x20, 0x0a, 0x41, 0x08, 0x6a, 0x41, 0xff,
  0x01, 0x71, 0x22, 0x0a, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x06,
  0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x05, 0x20, 0x07, 0x6a, 0x41, 0xff,
  0x01, 0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x07, 0x28, 0x02,
  0x00, 0x22, 0x09, 0x36, 0x02, 0x00, 0x20, 0x07, 0x20, 0x05, 0x36, 0x02,
  0x00, 0x20, 0x03, 0x20, 0x08, 0x20, 0x06, 0x20, 0x05, 0x20, 0x09, 0x6a,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73,
  0x3a, 0x00, 0x07, 0x20, 0x03, 0x41, 0x08, 0x6a, 0x21, 0x03, 0x20, 0x02,
  0x41, 0x08, 0x6a, 0x21, 0x02, 0x20, 0x0b, 0x41, 0x01, 0x6b, 0x22, 0x0b,
  0x0d, 0x00, 0x0b, 0x0b, 0x02, 0x40, 0x20, 0x01, 0x41, 0x07, 0x71, 0x22,
  0x06, 0x45, 0x04, 0x40, 0x20, 0x0a, 0x21, 0x01, 0x0c, 0x01, 0x0b, 0x20,
  0x02, 0x2d, 0x00, 0x00, 0x21, 0x07, 0x20, 0x00, 0x41, 0x08, 0x6a, 0x22,
  0x0b, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x22, 0x01,
  0x41, 0x02, 0x74, 0x6a, 0x22, 0x05, 0x20, 0x0b, 0x20, 0x05, 0x28, 0x02,
  0x00, 0x22, 0x05, 0x20, 0x04, 0x6a, 0x22, 0x08, 0x41, 0xff, 0x01, 0x71,
  0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x09, 0x28, 0x02, 0x00, 0x22,
  0x0c, 0x36, 0x02, 0x00, 0x20, 0x09, 0x20, 0x05, 0x36, 0x02, 0x00, 0x20,
  0x03, 0x20, 0x07, 0x20, 0x0b, 0x20, 0x05, 0x20, 0x0c, 0x6a, 0x41, 0xff,
  0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a, 0x00,
  0x00, 0x20, 0x06, 0x41, 0x01, 0x46, 0x0d, 0x00, 0x20, 0x02, 0x2d, 0x00,
  0x01, 0x21, 0x07, 0x20, 0x0b, 0x20, 0x0a, 0x41, 0x02, 0x6a, 0x41, 0xff,
  0x01, 0x71, 0x22, 0x01, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x0b,
  0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x05, 0x20, 0x08, 0x6a, 0x22, 0x08,
  0x41, 0xff, 0x01, 0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x09,
  0x28, 0x02, 0x00, 0x22, 0x0c, 0x36, 0x02, 0x00, 0x20, 0x09, 0x20, 0x05,
  0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x07, 0x20, 0x0b, 0x20, 0x05, 0x20,
  0x0c, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00,
  0x00, 0x73, 0x3a, 0x00, 0x01, 0x20, 0x06, 0x41, 0x02, 0x46, 0x0d, 0x00,
  0x20, 0x02, 0x2d, 0x00, 0x02, 0x21, 0x07, 0x20, 0x00, 0x41, 0x08, 0x6a,
  0x22, 0x0b, 0x20, 0x0a, 0x41, 0x03, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x22,
  0x01, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x0b, 0x20, 0x04, 0x28,
  0x02, 0x00, 0x22, 0x05, 0x20, 0x08, 0x6a, 0x22, 0x08, 0x41, 0xff, 0x01,
  0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x09, 0x28, 0x02, 0x00,
  0x22, 0x0c, 0x36, 0x02, 0x00, 0x20, 0x09, 0x20, 0x05, 0x36, 0x02, 0x00,
  0x20, 0x03, 0x20, 0x07, 0x20, 0x0b, 0x20, 0x05, 0x20, 0x0c, 0x6a, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a,
  0x00, 0x02, 0x20, 0x06, 0x41, 0x03, 0x46, 0x0d, 0x00, 0x20, 0x02, 0x2d,
  0x00, 0x03, 0x21, 0x07, 0x20, 0x0b, 0x20, 0x0a, 0x41, 0x04, 0x6a, 0x41,
  0xff, 0x01, 0x71, 0x22, 0x01, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20,
  0x0b, 0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x05, 0x20, 0x08, 0x6a, 0x22,
  0x08, 0x41, 0xff, 0x01, 0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22,
  0x09, 0x28, 0x02, 0x00, 0x22, 0x0c, 0x36, 0x02, 0x00, 0x20, 0x09, 0x20,
  0x05, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x07, 0x20, 0x0b, 0x20, 0x05,
  0x20, 0x0c, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d,
  0x00, 0x00, 0x73, 0x3a, 0x00, 0x03, 0x20, 0x06, 0x41, 0x04, 0x46, 0x0d,
  0x00, 0x20, 0x02, 0x2d, 0x00, 0x04, 0x21, 0x07, 0x20, 0x00, 0x41, 0x08,
  0x6a, 0x22, 0x0b, 0x20, 0x0a, 0x41, 0x05, 0x6a, 0x41, 0xff, 0x01, 0x71,
  0x22, 0x01, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04, 0x20, 0x0b, 0x20, 0x04,
  0x28, 0x02, 0x00, 0x22, 0x05, 0x20, 0x08, 0x6a, 0x22, 0x08, 0x41, 0xff,
  0x01, 0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x09, 0x28, 0x02,
  0x00, 0x22, 0x0c, 0x36, 0x02, 0x00, 0x20, 0x09, 0x20, 0x05, 0x36, 0x02,
  0x00, 0x20, 0x03, 0x20, 0x07, 0x20, 0x0b, 0x20, 0x05, 0x20, 0x0c, 0x6a,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73,
  0x3a, 0x00, 0x04, 0x20, 0x06, 0x41, 0x05, 0x46, 0x0d, 0x00, 0x20, 0x02,
  0x2d, 0x00, 0x05, 0x21, 0x07, 0x20, 0x0b, 0x20, 0x0a, 0x41, 0x06, 0x6a,
  0x41, 0xff, 0x01, 0x71, 0x22, 0x01, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x04,
  0x20, 0x0b, 0x20, 0x04, 0x28, 0x02, 0x00, 0x22, 0x05, 0x20, 0x08, 0x6a,
  0x22, 0x08, 0x41, 0xff, 0x01, 0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a,
  0x22, 0x09, 0x28, 0x02, 0x00, 0x22, 0x0c, 0x36, 0x02, 0x00, 0x20, 0x09,
  0x20, 0x05, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x07, 0x20, 0x0b, 0x20,
  0x05, 0x20, 0x0c, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a,
  0x2d, 0x00, 0x00, 0x73, 0x3a, 0x00, 0x05, 0x20, 0x06, 0x41, 0x06, 0x46,
  0x0d, 0x00, 0x20, 0x02, 0x2d, 0x00, 0x06, 0x21, 0x06, 0x20, 0x00, 0x41,
  0x08, 0x6a, 0x22, 0x02, 0x20, 0x0a, 0x41, 0x07, 0x6a, 0x41, 0xff, 0x01,
  0x71, 0x22, 0x01, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x0a, 0x20, 0x02, 0x20,
  0x0a, 0x28, 0x02, 0x00, 0x22, 0x0a, 0x20, 0x08, 0x6a, 0x41, 0xff, 0x01,
  0x71, 0x22, 0x04, 0x41, 0x02, 0x74, 0x6a, 0x22, 0x0b, 0x28, 0x02, 0x00,
  0x22, 0x05, 0x36, 0x02, 0x00, 0x20, 0x0b, 0x20, 0x0a, 0x36, 0x02, 0x00,
  0x20, 0x03, 0x20, 0x06, 0x20, 0x02, 0x20, 0x05, 0x20, 0x0a, 0x6a, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x02, 0x74, 0x6a, 0x2d, 0x00, 0x00, 0x73, 0x3a,
  0x00, 0x06, 0x0b, 0x20, 0x00, 0x20, 0x04, 0x36, 0x02, 0x04, 0x20, 0x00,
  0x20, 0x01, 0x36, 0x02, 0x00, 0x0b, 0xea, 0x03, 0x01, 0x07, 0x7f, 0x20,
  0x00, 0x42, 0x00, 0x37, 0x02, 0x00, 0x03, 0x40, 0x20, 0x00, 0x41, 0x08,
  0x6a, 0x22, 0x04, 0x20, 0x03, 0x41, 0x02, 0x74, 0x6a, 0x20, 0x03, 0x36,
  0x02, 0x00, 0x20, 0x04, 0x20, 0x03, 0x41, 0x01, 0x72, 0x22, 0x05, 0x41,
  0x02, 0x74, 0x6a, 0x20, 0x05, 0x36, 0x02, 0x00, 0x20, 0x04, 0x20, 0x03,
  0x41, 0x02, 0x72, 0x22, 0x05, 0x41, 0x02, 0x74, 0x6a, 0x20, 0x05, 0x36,
  0x02, 0x00, 0x20, 0x04, 0x20, 0x03, 0x41, 0x03, 0x72, 0x22, 0x05, 0x41,
  0x02, 0x74, 0x6a, 0x20, 0x05, 0x36, 0x02, 0x00, 0x20, 0x04, 0x20, 0x03,
  0x41, 0x04, 0x72, 0x22, 0x05, 0x41, 0x02, 0x74, 0x6a, 0x20, 0x05, 0x36,
  0x02, 0x00, 0x20, 0x04, 0x20, 0x03, 0x41, 0x05, 0x72, 0x22, 0x05, 0x41,
  0x02, 0x74, 0x6a, 0x20, 0x05, 0x36, 0x02, 0x00, 0x20, 0x04, 0x20, 0x03,
  0x41, 0x06, 0x72, 0x22, 0x05, 0x41, 0x02, 0x74, 0x6a, 0x20, 0x05, 0x36,
  0x02, 0x00, 0x20, 0x04, 0x20, 0x03, 0x41, 0x07, 0x72, 0x22, 0x05, 0x41,
  0x02, 0x74, 0x6a, 0x20, 0x05, 0x36, 0x02, 0x00, 0x20, 0x03, 0x41, 0x08,
  0x6a, 0x22, 0x03, 0x41, 0x80, 0x02, 0x47, 0x0d, 0x00, 0x0b, 0x41, 0x00,
  0x21, 0x04, 0x03, 0x40, 0x20, 0x00, 0x41, 0x08, 0x6a, 0x22, 0x03, 0x20,
  0x09, 0x41, 0x02, 0x74, 0x22, 0x05, 0x6a, 0x22, 0x07, 0x20, 0x03, 0x20,
  0x02, 0x20, 0x04, 0x6a, 0x2d, 0x00, 0x00, 0x20, 0x06, 0x20, 0x07, 0x28,
  0x02, 0x00, 0x22, 0x06, 0x6a, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x02, 0x74, 0x6a, 0x22, 0x08, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00,
  0x20, 0x08, 0x20, 0x06, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05, 0x41,
  0x04, 0x72, 0x6a, 0x22, 0x06, 0x20, 0x03, 0x20, 0x02, 0x41, 0x00, 0x20,
  0x04, 0x41, 0x01, 0x6a, 0x22, 0x04, 0x20, 0x01, 0x20, 0x04, 0x46, 0x1b,
  0x22, 0x04, 0x6a, 0x2d, 0x00, 0x00, 0x20, 0x06, 0x28, 0x02, 0x00, 0x22,
  0x06, 0x20, 0x07, 0x6a, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41,
  0x02, 0x74, 0x6a, 0x22, 0x08, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20,
  0x08, 0x20, 0x06, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05, 0x41, 0x08,
  0x72, 0x6a, 0x22, 0x06, 0x20, 0x03, 0x20, 0x02, 0x41, 0x00, 0x20, 0x04,
  0x41, 0x01, 0x6a, 0x22, 0x04, 0x20, 0x01, 0x20, 0x04, 0x46, 0x1b, 0x22,
  0x04, 0x6a, 0x2d, 0x00, 0x00, 0x20, 0x06, 0x28, 0x02, 0x00, 0x22, 0x06,
  0x20, 0x07, 0x6a, 0x6a, 0x22, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41, 0x02,
  0x74, 0x6a, 0x22, 0x08, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20, 0x08,
  0x20, 0x06, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20, 0x05, 0x41, 0x0c, 0x72,
  0x6a, 0x22, 0x05, 0x20, 0x03, 0x20, 0x02, 0x41, 0x00, 0x20, 0x04, 0x41,
  0x01, 0x6a, 0x22, 0x04, 0x20, 0x01, 0x20, 0x04, 0x46, 0x1b, 0x22, 0x04,
  0x6a, 0x2d, 0x00, 0x00, 0x20, 0x05, 0x28, 0x02, 0x00, 0x22, 0x05, 0x20,
  0x07, 0x6a, 0x6a, 0x41, 0xff, 0x01, 0x71, 0x22, 0x06, 0x41, 0x02, 0x74,
  0x6a, 0x22, 0x03, 0x28, 0x02, 0x00, 0x36, 0x02, 0x00, 0x20, 0x03, 0x20,
  0x05, 0x36, 0x02, 0x00, 0x41, 0x00, 0x20, 0x04, 0x41, 0x01, 0x6a, 0x22,
  0x03, 0x20, 0x01, 0x20, 0x03, 0x46, 0x1b, 0x21, 0x04, 0x20, 0x09, 0x41,
  0xfc, 0x01, 0x49, 0x21, 0x03, 0x20, 0x09, 0x41, 0x04, 0x6a, 0x21, 0x09,
  0x20, 0x03, 0x0d, 0x00, 0x0b, 0x0b, 0xd8, 0x03, 0x01, 0x05, 0x7f, 0x23,
  0x00, 0x41, 0x20, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x41, 0xc2, 0xfd, 0x02,
  0x21, 0x06, 0x02, 0x40, 0x20, 0x02, 0x41, 0x05, 0x4b, 0x0d, 0x00, 0x20,
  0x03, 0x41, 0x10, 0x6a, 0x21, 0x05, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x20, 0x05,
  0x20, 0x02, 0x45, 0x0d, 0x00, 0x1a, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00,
  0x00, 0x22, 0x04, 0x41, 0x20, 0x6b, 0x20, 0x04, 0x20, 0x04, 0x41, 0xe1,
  0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x1a, 0x49, 0x1b, 0x22, 0x07,
  0x3a, 0x00, 0x10, 0x20, 0x03, 0x41, 0x11, 0x6a, 0x20, 0x02, 0x41, 0x01,
  0x46, 0x0d, 0x00, 0x1a, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x01, 0x22,
  0x04, 0x41, 0x20, 0x6b, 0x20, 0x04, 0x20, 0x04, 0x41, 0xe1, 0x00, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x1a, 0x49, 0x1b, 0x3a, 0x00, 0x11, 0x20,
  0x03, 0x41, 0x12, 0x6a, 0x20, 0x02, 0x41, 0x02, 0x46, 0x0d, 0x00, 0x1a,
  0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x02, 0x22, 0x04, 0x41, 0x20, 0x6b,
  0x20, 0x04, 0x20, 0x04, 0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71,
  0x41, 0x1a, 0x49, 0x1b, 0x3a, 0x00, 0x12, 0x20, 0x03, 0x41, 0x13, 0x6a,
  0x20, 0x02, 0x41, 0x03, 0x46, 0x0d, 0x00, 0x1a, 0x20, 0x03, 0x20, 0x01,
  0x2d, 0x00, 0x03, 0x22, 0x04, 0x41, 0x20, 0x6b, 0x20, 0x04, 0x20, 0x04,
  0x41, 0xe1, 0x00, 0x6b, 0x41, 0xff, 0x01, 0x71, 0x41, 0x1a, 0x49, 0x1b,
  0x3a, 0x00, 0x13, 0x20, 0x03, 0x41, 0x14, 0x6a, 0x20, 0x02, 0x41, 0x04,
  0x46, 0x0d, 0x00, 0x1a, 0x20, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x04, 0x22,
  0x01, 0x41, 0x20, 0x6b, 0x20, 0x01, 0x20, 0x01, 0x41, 0xe1, 0x00, 0x6b,
  0x41, 0xff, 0x01, 0x71, 0x41, 0x1a, 0x49, 0x1b, 0x3a, 0x00, 0x14, 0x20,
  0x03, 0x41, 0x15, 0x6a, 0x0b, 0x20, 0x05, 0x41, 0x7f, 0x73, 0x6a, 0x0e,
  0x05, 0x00, 0x01, 0x02, 0x05, 0x04, 0x07, 0x0b, 0x41, 0xe0, 0xd1, 0x05,
  0x21, 0x02, 0x02, 0x40, 0x20, 0x07, 0x41, 0xff, 0x01, 0x71, 0x41, 0x30,
  0x6b, 0x0e, 0x02, 0x00, 0x06, 0x07, 0x0b, 0x41, 0x90, 0xd2, 0x05, 0x21,
  0x02, 0x0c, 0x05, 0x0b, 0x41, 0xcc, 0xef, 0x03, 0x20, 0x05, 0x41, 0x02,
  0x10, 0x2b, 0x0d, 0x01, 0x41, 0xec, 0xd1, 0x05, 0x21, 0x02, 0x0c, 0x04,
  0x0b, 0x41, 0xb8, 0xe2, 0x03, 0x20, 0x05, 0x41, 0x03, 0x10, 0x2b, 0x45,
  0x04, 0x40, 0x41, 0xf8, 0xd1, 0x05, 0x21, 0x02, 0x0c, 0x04, 0x0b, 0x41,
  0xc7, 0xf9, 0x03, 0x20, 0x05, 0x41, 0x03, 0x10, 0x2b, 0x0d, 0x04, 0x41,
  0x9c, 0xd2, 0x05, 0x21, 0x02, 0x0c, 0x03, 0x0b, 0x41, 0xfd, 0xe9, 0x03,
  0x20, 0x05, 0x41, 0x02, 0x10, 0x2b, 0x0d, 0x03, 0x41, 0xa8, 0xd2, 0x05,
  0x21, 0x02, 0x0c, 0x02, 0x0b, 0x41, 0xd0, 0xfe, 0x03, 0x20, 0x05, 0x41,
  0x05, 0x10, 0x2b, 0x0d, 0x02, 0x41, 0xb4, 0xd2, 0x05, 0x21, 0x02, 0x0c,
  0x01, 0x0b, 0x41, 0x84, 0xd2, 0x05, 0x21, 0x02, 0x20, 0x03, 0x28, 0x02,
  0x10, 0x41, 0xd4, 0xa4, 0xd5, 0xaa, 0x04, 0x47, 0x0d, 0x01, 0x0b, 0x20,
  0x00, 0x20, 0x02, 0x2d, 0x00, 0x08, 0x3a, 0x00, 0x00, 0x41, 0x00, 0x21,
  0x06, 0x0b, 0x20, 0x03, 0x41, 0x20, 0x6a, 0x24, 0x00, 0x20, 0x06, 0x0b,
  0x74, 0x01, 0x01, 0x7f, 0x20, 0x02, 0x45, 0x04, 0x40, 0x20, 0x00, 0x28,
  0x02, 0x04, 0x20, 0x01, 0x28, 0x02, 0x04, 0x46, 0x0f, 0x0b, 0x20, 0x00,
  0x20, 0x01, 0x46, 0x04, 0x40, 0x41, 0x01, 0x0f, 0x0b, 0x20, 0x01, 0x28,
  0x02, 0x04, 0x22, 0x02, 0x2d, 0x00, 0x00, 0x21, 0x01, 0x02, 0x40, 0x20,
  0x00, 0x28, 0x02, 0x04, 0x22, 0x03, 0x2d, 0x00, 0x00, 0x22, 0x00, 0x45,
  0x0d, 0x00, 0x20, 0x00, 0x20, 0x01, 0x47, 0x0d, 0x00, 0x03, 0x40, 0x20,
  0x02, 0x2d, 0x00, 0x01, 0x21, 0x01, 0x20, 0x03, 0x2d, 0x00, 0x01, 0x22,
  0x00, 0x45, 0x0d, 0x01, 0x20, 0x02, 0x41, 0x01, 0x6a, 0x21, 0x02, 0x20,
  0x03, 0x41, 0x01, 0x6a, 0x21, 0x03, 0x20, 0x00, 0x20, 0x01, 0x46, 0x0d,
  0x00, 0x0b, 0x0b, 0x20, 0x00, 0x20, 0x01, 0x46, 0x0b, 0x8a, 0x03, 0x01,
  0x02, 0x7f, 0x23, 0x00, 0x41, 0xc0, 0x06, 0x6b, 0x22, 0x04, 0x24, 0x00,
  0x02, 0x40, 0x20, 0x00, 0x2d, 0x00, 0x80, 0x48, 0x04, 0x40, 0x20, 0x00,
  0x41, 0xe1, 0xc1, 0x04, 0x6a, 0x2d, 0x00, 0x00, 0x41, 0x01, 0x71, 0x04,
  0x40, 0x20, 0x04, 0x10, 0x00, 0x22, 0x01, 0x36, 0x02, 0x28, 0x20, 0x04,
  0x20, 0x01, 0x36, 0x02, 0x24, 0x20, 0x04, 0x41, 0xc2, 0xea, 0x03, 0x36,
  0x02, 0x20, 0x41, 0x06, 0x41, 0xc9, 0xee, 0x02, 0x20, 0x04, 0x41, 0x20,
  0x6a, 0x10, 0x22, 0x0b, 0x20, 0x00, 0x28, 0x02, 0xa4, 0x3f, 0x21, 0x05,
  0x20, 0x04, 0x20, 0x03, 0x3a, 0x00, 0xb1, 0x02, 0x20, 0x04, 0x20, 0x02,
  0x41, 0x07, 0x76, 0x22, 0x01, 0x41, 0x02, 0x71, 0x20, 0x02, 0x41, 0x0f,
  0x76, 0x72, 0x20, 0x01, 0x41, 0x04, 0x71, 0x72, 0x3a, 0x00, 0xb0, 0x02,
  0x20, 0x04, 0x41, 0x0c, 0x41, 0x04, 0x20, 0x00, 0x41, 0xf4, 0xc7, 0x00,
  0x6a, 0x28, 0x02, 0x00, 0x20, 0x00, 0x41, 0xf0, 0xc7, 0x00, 0x6a, 0x28,
  0x02, 0x00, 0x72, 0x22, 0x02, 0x1b, 0x3a, 0x00, 0xb1, 0x04, 0x20, 0x04,
  0x41, 0x84, 0x7f, 0x41, 0x04, 0x20, 0x02, 0x1b, 0x3a, 0x00, 0xb0, 0x04,
  0x20, 0x05, 0x20, 0x04, 0x41, 0xb0, 0x02, 0x6a, 0x22, 0x01, 0x20, 0x02,
  0x04, 0x7f, 0x20, 0x04, 0x41, 0x02, 0x36, 0x02, 0xb4, 0x06, 0x20, 0x04,
  0x20, 0x01, 0x36, 0x02, 0xb0, 0x06, 0x20, 0x04, 0x42, 0x00, 0x37, 0x03,
  0xb8, 0x06, 0x20, 0x04, 0x20, 0x04, 0x29, 0x03, 0xb0, 0x06, 0x37, 0x03,
  0x18, 0x20, 0x00, 0x41, 0xa8, 0x3f, 0x6a, 0x22, 0x02, 0x20, 0x04, 0x41,
  0x18, 0x6a, 0x20, 0x04, 0x41, 0xb8, 0x06, 0x6a, 0x10, 0x44, 0x20, 0x04,
  0x20, 0x04, 0x29, 0x03, 0xb8, 0x06, 0x37, 0x01, 0xb2, 0x04, 0x20, 0x02,
  0x20, 0x01, 0x41, 0x02, 0x20, 0x01, 0x10, 0x40, 0x20, 0x04, 0x41, 0xb0,
  0x04, 0x6a, 0x41, 0x0a, 0x72, 0x05, 0x20, 0x04, 0x41, 0xb0, 0x04, 0x6a,
  0x41, 0x02, 0x72, 0x0b, 0x20, 0x04, 0x41, 0xb0, 0x04, 0x6a, 0x22, 0x02,
  0x6b, 0x22, 0x01, 0x6b, 0x20, 0x02, 0x20, 0x01, 0x10, 0x24, 0x20, 0x01,
  0x41, 0x02, 0x6a, 0x20, 0x05, 0x28, 0x02, 0x00, 0x28, 0x02, 0x20, 0x11,
  0x00, 0x00, 0x20, 0x00, 0x41, 0xe1, 0xc1, 0x04, 0x6a, 0x2d, 0x00, 0x00,
  0x41, 0x01, 0x71, 0x45, 0x0d, 0x01, 0x20, 0x04, 0x10, 0x00, 0x22, 0x00,
  0x36, 0x02, 0x08, 0x20, 0x04, 0x20, 0x00, 0x36, 0x02, 0x04, 0x20, 0x04,
  0x41, 0xc2, 0xea, 0x03, 0x36, 0x02, 0x00, 0x41, 0x06, 0x41, 0xd3, 0x85,
  0x03, 0x20, 0x04, 0x10, 0x22, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x20, 0x01,
  0x41, 0x04, 0x20, 0x02, 0x20, 0x03, 0x41, 0x00, 0x10, 0x84, 0x01, 0x0b,
  0x20, 0x04, 0x41, 0xc0, 0x06, 0x6a, 0x24, 0x00, 0x0b, 0xfb, 0x02, 0x01,
  0x03, 0x7f, 0x23, 0x00, 0x41, 0xc0, 0x06, 0x6b, 0x22, 0x02, 0x24, 0x00,
  0x20, 0x00, 0x20, 0x01, 0x3a, 0x00, 0xdc, 0xc1, 0x04, 0x02, 0x40, 0x20,
  0x00, 0x2d, 0x00, 0x80, 0x48, 0x04, 0x40, 0x20, 0x00, 0x41, 0xe1, 0xc1,
  0x04, 0x6a, 0x2d, 0x00, 0x00, 0x41, 0x01, 0x71, 0x04, 0x40, 0x20, 0x02,
  0x10, 0x00, 0x22, 0x04, 0x36, 0x02, 0x28, 0x20, 0x02, 0x20, 0x04, 0x36,
  0x02, 0x24, 0x20, 0x02, 0x41, 0xc2, 0xea, 0x03, 0x36, 0x02, 0x20, 0x41,
  0x06, 0x41, 0xc9, 0xee, 0x02, 0x20, 0x02, 0x41, 0x20, 0x6a, 0x10, 0x22,
  0x0b, 0x20, 0x00, 0x28, 0x02, 0xa4, 0x3f, 0x21, 0x04, 0x20, 0x02, 0x20,
  0x01, 0x41, 0xe0, 0x00, 0x72, 0x3a, 0x00, 0xb0, 0x02, 0x20, 0x02, 0x41,
  0x0b, 0x41, 0x03, 0x20, 0x00, 0x41, 0xf4, 0xc7, 0x00, 0x6a, 0x28, 0x02,
  0x00, 0x20, 0x00, 0x41, 0xf0, 0xc7, 0x00, 0x6a, 0x28, 0x02, 0x00, 0x72,
  0x22, 0x03, 0x1b, 0x3a, 0x00, 0xb1, 0x04, 0x20, 0x02, 0x41, 0x84, 0x7f,
  0x41, 0x04, 0x20, 0x03, 0x1b, 0x3a, 0x00, 0xb0, 0x04, 0x20, 0x04, 0x20,
  0x02, 0x41, 0xb0, 0x02, 0x6a, 0x22, 0x01, 0x20, 0x03, 0x04, 0x7f, 0x20,
  0x02, 0x41, 0x01, 0x36, 0x02, 0xb4, 0x06, 0x20, 0x02, 0x20, 0x01, 0x36,
  0x02, 0xb0, 0x06, 0x20, 0x02, 0x42, 0x00, 0x37, 0x03, 0xb8, 0x06, 0x20,
  0x02, 0x20, 0x02, 0x29, 0x03, 0xb0, 0x06, 0x37, 0x03, 0x18, 0x20, 0x00,
  0x41, 0xa8, 0x3f, 0x6a, 0x22, 0x03, 0x20, 0x02, 0x41, 0x18, 0x6a, 0x20,
  0x02, 0x41, 0xb8, 0x06, 0x6a, 0x10, 0x44, 0x20, 0x02, 0x20, 0x02, 0x29,
  0x03, 0xb8, 0x06, 0x37, 0x01, 0xb2, 0x04, 0x20, 0x03, 0x20, 0x01, 0x41,
  0x01, 0x20, 0x01, 0x10, 0x40, 0x20, 0x02, 0x41, 0xb0, 0x04, 0x6a, 0x41,
  0x0a, 0x72, 0x05, 0x20, 0x02, 0x41, 0xb0, 0x04, 0x6a, 0x41, 0x02, 0x72,
  0x0b, 0x20, 0x02, 0x41, 0xb0, 0x04, 0x6a, 0x22, 0x03, 0x6b, 0x22, 0x01,
  0x6b, 0x20, 0x03, 0x20, 0x01, 0x10, 0x24, 0x20, 0x01, 0x41, 0x01, 0x6a,
  0x20, 0x04, 0x28, 0x02, 0x00, 0x28, 0x02, 0x20, 0x11, 0x00, 0x00, 0x20,
  0x00, 0x41, 0xe1, 0xc1, 0x04, 0x6a, 0x2d, 0x00, 0x00, 0x41, 0x01, 0x71,
  0x45, 0x0d, 0x01, 0x20, 0x02, 0x10, 0x00, 0x22, 0x00, 0x36, 0x02, 0x08,
  0x20, 0x02, 0x20, 0x00, 0x36, 0x02, 0x04, 0x20, 0x02, 0x41, 0xc2, 0xea,
  0x03, 0x36, 0x02, 0x00, 0x41, 0x06, 0x41, 0xd3, 0x85, 0x03, 0x20, 0x02,
  0x10, 0x22, 0x0c, 0x01, 0x0b, 0x20, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41,
  0x00, 0x20, 0x01, 0x41, 0x00, 0x10, 0x84, 0x01, 0x0b, 0x20, 0x02, 0x41,
  0xc0, 0x06, 0x6a, 0x24, 0x00, 0x0b, 0xa0, 0x06, 0x02, 0x0a, 0x7f, 0x01,
  0x7e, 0x23, 0x00, 0x41, 0x40, 0x6a, 0x22, 0x05, 0x24, 0x00, 0x20, 0x05,
  0x20, 0x04, 0x36, 0x02, 0x34, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x30,
  0x20, 0x05, 0x41, 0x00, 0x3a, 0x00, 0x3f, 0x20, 0x05, 0x20, 0x05, 0x29,
  0x03, 0x30, 0x37, 0x03, 0x28, 0x02, 0x40, 0x02, 0x7f, 0x23, 0x00, 0x41,
  0x10, 0x6b, 0x22, 0x0a, 0x24, 0x00, 0x02, 0x40, 0x20, 0x05, 0x28, 0x02,
  0x2c, 0x22, 0x08, 0x45, 0x04, 0x40, 0x41, 0x8d, 0xf8, 0x02, 0x21, 0x0c,
  0x0c, 0x01, 0x0b, 0x20, 0x05, 0x28, 0x02, 0x28, 0x21, 0x06, 0x02, 0x40,
  0x20, 0x0a, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x20, 0x08, 0x41, 0x01, 0x46, 0x0d, 0x00, 0x20, 0x06, 0x2d,
  0x00, 0x00, 0x41, 0x30, 0x47, 0x0d, 0x00, 0x20, 0x06, 0x2d, 0x00, 0x01,
  0x41, 0xf8, 0x00, 0x46, 0x0d, 0x01, 0x0b, 0x20, 0x06, 0x20, 0x08, 0x6a,
  0x21, 0x09, 0x20, 0x06, 0x21, 0x07, 0x02, 0x40, 0x20, 0x06, 0x02, 0x7f,
  0x02, 0x40, 0x03, 0x40, 0x20, 0x07, 0x2d, 0x00, 0x00, 0x22, 0x0b, 0x41,
  0x30, 0x47, 0x0d, 0x01, 0x20, 0x07, 0x41, 0x01, 0x6a, 0x22, 0x07, 0x20,
  0x09, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x09, 0x0c, 0x01, 0x0b, 0x20, 0x09,
  0x20, 0x07, 0x20, 0x09, 0x46, 0x0d, 0x00, 0x1a, 0x20, 0x0b, 0x41, 0x30,
  0x6b, 0x22, 0x0c, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x49, 0x0d, 0x01,
  0x20, 0x07, 0x0b, 0x22, 0x0b, 0x46, 0x04, 0x40, 0x20, 0x0a, 0x20, 0x06,
  0x36, 0x02, 0x00, 0x41, 0x1c, 0x21, 0x07, 0x20, 0x0a, 0x41, 0x1c, 0x36,
  0x02, 0x04, 0x0c, 0x07, 0x0b, 0x20, 0x0a, 0x20, 0x0b, 0x36, 0x02, 0x00,
  0x41, 0x00, 0x21, 0x07, 0x20, 0x0a, 0x41, 0x00, 0x3a, 0x00, 0x0f, 0x20,
  0x0a, 0x41, 0x00, 0x36, 0x02, 0x04, 0x0c, 0x06, 0x0b, 0x20, 0x09, 0x21,
  0x06, 0x20, 0x0c, 0x21, 0x0b, 0x02, 0x40, 0x20, 0x07, 0x41, 0x01, 0x6a,
  0x22, 0x08, 0x20, 0x09, 0x46, 0x0d, 0x00, 0x20, 0x08, 0x22, 0x06, 0x2d,
  0x00, 0x00, 0x22, 0x0e, 0x41, 0x30, 0x6b, 0x22, 0x08, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x0a, 0x4f, 0x0d, 0x00, 0x41, 0x01, 0x21, 0x0d, 0x20, 0x09,
  0x20, 0x07, 0x41, 0x02, 0x6a, 0x22, 0x06, 0x46, 0x04, 0x40, 0x20, 0x09,
  0x21, 0x06, 0x20, 0x08, 0x21, 0x0b, 0x0c, 0x01, 0x0b, 0x20, 0x08, 0x21,
  0x0b, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x22, 0x08, 0x41, 0x30, 0x6b, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x0d, 0x00, 0x20, 0x07, 0x41, 0x03,
  0x6a, 0x21, 0x06, 0x20, 0x0e, 0x41, 0x0a, 0x6c, 0x20, 0x08, 0x6a, 0x41,
  0x90, 0x04, 0x6b, 0x21, 0x0b, 0x41, 0x02, 0x21, 0x0d, 0x0b, 0x20, 0x0d,
  0x41, 0x02, 0x74, 0x41, 0xe0, 0xd0, 0x05, 0x6a, 0x35, 0x02, 0x00, 0x20,
  0x0c, 0xad, 0x7e, 0x22, 0x0f, 0xa7, 0x21, 0x08, 0x20, 0x06, 0x20, 0x0f,
  0x42, 0x20, 0x88, 0xa7, 0x41, 0x00, 0x47, 0x6b, 0x22, 0x0c, 0x20, 0x09,
  0x46, 0x0d, 0x01, 0x02, 0x40, 0x20, 0x0c, 0x2d, 0x00, 0x00, 0x41, 0x30,
  0x6b, 0x41, 0xff, 0x01, 0x71, 0x22, 0x06, 0x41, 0x0a, 0x49, 0x0d, 0x00,
  0x20, 0x0b, 0x41, 0xff, 0x01, 0x4b, 0x0d, 0x00, 0x41, 0xff, 0x01, 0x20,
  0x0b, 0x6b, 0x20, 0x08, 0x4f, 0x0d, 0x03, 0x0b, 0x41, 0xc4, 0x00, 0x21,
  0x07, 0x20, 0x06, 0x41, 0x09, 0x4b, 0x0d, 0x03, 0x03, 0x40, 0x20, 0x09,
  0x20, 0x09, 0x20, 0x0c, 0x41, 0x01, 0x6a, 0x22, 0x0c, 0x46, 0x0d, 0x05,
  0x1a, 0x20, 0x0c, 0x2d, 0x00, 0x00, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x0a, 0x49, 0x0d, 0x00, 0x0b, 0x0c, 0x03, 0x0b, 0x20, 0x05,
  0x20, 0x08, 0x41, 0x02, 0x6b, 0x36, 0x02, 0x2c, 0x20, 0x05, 0x20, 0x06,
  0x41, 0x02, 0x6a, 0x22, 0x0b, 0x36, 0x02, 0x28, 0x20, 0x0a, 0x20, 0x0b,
  0x20, 0x06, 0x20, 0x08, 0x6a, 0x22, 0x09, 0x20, 0x0a, 0x41, 0x0f, 0x6a,
  0x10, 0x8c, 0x01, 0x20, 0x0a, 0x28, 0x02, 0x04, 0x21, 0x07, 0x0c, 0x04,
  0x0b, 0x41, 0xc4, 0x00, 0x21, 0x07, 0x20, 0x09, 0x20, 0x0b, 0x41, 0xff,
  0x01, 0x4b, 0x0d, 0x02, 0x1a, 0x20, 0x09, 0x41, 0xff, 0x01, 0x20, 0x0b,
  0x6b, 0x20, 0x08, 0x49, 0x0d, 0x02, 0x1a, 0x0b, 0x20, 0x0a, 0x20, 0x08,
  0x20, 0x0b, 0x6a, 0x3a, 0x00, 0x0f, 0x41, 0x00, 0x21, 0x07, 0x0b, 0x20,
  0x0c, 0x0b, 0x36, 0x02, 0x00, 0x20, 0x0a, 0x20, 0x07, 0x36, 0x02, 0x04,
  0x0b, 0x41, 0xc0, 0xd1, 0x05, 0x21, 0x0c, 0x20, 0x07, 0x41, 0x3d, 0x46,
  0x0d, 0x00, 0x02, 0x40, 0x20, 0x07, 0x0d, 0x00, 0x20, 0x0a, 0x28, 0x02,
  0x00, 0x20, 0x09, 0x47, 0x0d, 0x00, 0x20, 0x0a, 0x2d, 0x00, 0x0f, 0x22,
  0x06, 0x41, 0x02, 0x4b, 0x0d, 0x01, 0x20, 0x05, 0x20, 0x06, 0x3a, 0x00,
  0x3f, 0x41, 0x00, 0x21, 0x0c, 0x0c, 0x01, 0x0b, 0x41, 0x95, 0xe6, 0x02,
  0x21, 0x0c, 0x0b, 0x20, 0x0a, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x20, 0x0c,
  0x22, 0x06, 0x45, 0x0b, 0x04, 0x40, 0x20, 0x02, 0x20, 0x05, 0x2d, 0x00,
  0x3f, 0x3a, 0x00, 0x00, 0x0c, 0x01, 0x0b, 0x10, 0x00, 0x21, 0x02, 0x20,
  0x05, 0x20, 0x06, 0x36, 0x02, 0x1c, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02,
  0x18, 0x20, 0x05, 0x20, 0x04, 0x36, 0x02, 0x14, 0x20, 0x05, 0x20, 0x00,
  0x36, 0x02, 0x10, 0x20, 0x05, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x05,
  0x20, 0x02, 0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x04,
  0x20, 0x05, 0x41, 0xd4, 0xf7, 0x03, 0x36, 0x02, 0x00, 0x41, 0x04, 0x41,
  0x90, 0xb2, 0x02, 0x20, 0x05, 0x10, 0x22, 0x0b, 0x20, 0x05, 0x41, 0x40,
  0x6b, 0x24, 0x00, 0x0b, 0x76, 0x02, 0x01, 0x7f, 0x01, 0x7c, 0x23, 0x00,
  0x41, 0x10, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x20, 0x00, 0x28, 0x02, 0x00,
  0x20, 0x01, 0x10, 0x04, 0x22, 0x00, 0x10, 0x05, 0x21, 0x01, 0x20, 0x00,
  0x10, 0x01, 0x20, 0x01, 0x10, 0x03, 0x45, 0x04, 0x40, 0x20, 0x01, 0x41,
  0xe1, 0xb4, 0x1b, 0x20, 0x03, 0x41, 0x0c, 0x6a, 0x10, 0x0a, 0x21, 0x04,
  0x20, 0x03, 0x28, 0x02, 0x0c, 0x10, 0x09, 0x20, 0x02, 0x02, 0x7f, 0x20,
  0x04, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x41, 0x63, 0x20,
  0x04, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x71,
  0x04, 0x40, 0x20, 0x04, 0xab, 0x0c, 0x01, 0x0b, 0x41, 0x00, 0x0b, 0x3b,
  0x01, 0x00, 0x0b, 0x20, 0x01, 0x10, 0x01, 0x20, 0x03, 0x41, 0x10, 0x6a,
  0x24, 0x00, 0x0b, 0x76, 0x02, 0x01, 0x7f, 0x01, 0x7c, 0x23, 0x00, 0x41,
  0x10, 0x6b, 0x22, 0x03, 0x24, 0x00, 0x20, 0x00, 0x28, 0x02, 0x00, 0x20,
  0x01, 0x10, 0x04, 0x22, 0x00, 0x10, 0x05, 0x21, 0x01, 0x20, 0x00, 0x10,
  0x01, 0x20, 0x01, 0x10, 0x03, 0x45, 0x04, 0x40, 0x20, 0x01, 0x41, 0xe3,
  0xb4, 0x1b, 0x20, 0x03, 0x41, 0x0c, 0x6a, 0x10, 0x0a, 0x21, 0x04, 0x20,
  0x03, 0x28, 0x02, 0x0c, 0x10, 0x09, 0x20, 0x02, 0x02, 0x7f, 0x20, 0x04,
  0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x41, 0x63, 0x20, 0x04,
  0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x71, 0x04,
  0x40, 0x20, 0x04, 0xab, 0x0c, 0x01, 0x0b, 0x41, 0x00, 0x0b, 0x36, 0x02,
  0x00, 0x0b, 0x20, 0x01, 0x10, 0x01, 0x20, 0x03, 0x41, 0x10, 0x6a, 0x24,
  0x00, 0x0b, 0x9e, 0x04, 0x02, 0x08, 0x7f, 0x01, 0x7e, 0x23, 0x00, 0x41,
  0xf0, 0x00, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x20, 0x00, 0x42, 0x00, 0x37,
  0x03, 0x40, 0x20, 0x00, 0x42, 0xfe, 0xb9, 0xeb, 0xc5, 0xe9, 0x8e, 0x95,
  0x99, 0x10, 0x37, 0x03, 0x50, 0x20, 0x00, 0x42, 0x81, 0xc6, 0x94, 0xba,
  0x96, 0xf1, 0xea, 0xe6, 0x6f, 0x37, 0x03, 0x48, 0x20, 0x00, 0x41, 0x40,
  0x6b, 0x21, 0x05, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x7f, 0x20, 0x01, 0x28, 0x02, 0x04, 0x22, 0x03, 0x41, 0xc1, 0x00, 0x4f,
  0x04, 0x40, 0x20, 0x04, 0x42, 0xfe, 0xb9, 0xeb, 0xc5, 0xe9, 0x8e, 0x95,
  0x99, 0x10, 0x37, 0x03, 0x10, 0x20, 0x04, 0x42, 0x81, 0xc6, 0x94, 0xba,
  0x96, 0xf1, 0xea, 0xe6, 0x6f, 0x37, 0x03, 0x08, 0x20, 0x01, 0x28, 0x02,
  0x00, 0x21, 0x02, 0x20, 0x04, 0x20, 0x03, 0xad, 0x37, 0x03, 0x00, 0x03,
  0x40, 0x20, 0x04, 0x20, 0x02, 0x10, 0x2d, 0x20, 0x02, 0x41, 0x40, 0x6b,
  0x21, 0x02, 0x20, 0x03, 0x41, 0x40, 0x6a, 0x22, 0x03, 0x41, 0x3f, 0x4b,
  0x0d, 0x00, 0x0b, 0x20, 0x04, 0x41, 0x18, 0x6a, 0x20, 0x02, 0x20, 0x03,
  0x10, 0x24, 0x1a, 0x20, 0x04, 0x20, 0x04, 0x41, 0xe0, 0x00, 0x6a, 0x22,
  0x02, 0x10, 0x35, 0x41, 0x10, 0x21, 0x03, 0x20, 0x01, 0x41, 0x10, 0x36,
  0x02, 0x04, 0x20, 0x01, 0x20, 0x02, 0x36, 0x02, 0x00, 0x20, 0x02, 0x21,
  0x01, 0x41, 0x00, 0x0c, 0x01, 0x0b, 0x20, 0x03, 0x45, 0x04, 0x40, 0x41,
  0x00, 0x21, 0x03, 0x0c, 0x04, 0x0b, 0x20, 0x01, 0x28, 0x02, 0x00, 0x21,
  0x01, 0x20, 0x03, 0x41, 0x01, 0x46, 0x04, 0x40, 0x41, 0x01, 0x21, 0x03,
  0x0c, 0x02, 0x0b, 0x20, 0x03, 0x41, 0x01, 0x71, 0x0b, 0x21, 0x08, 0x20,
  0x03, 0x41, 0x7e, 0x71, 0x21, 0x07, 0x41, 0x00, 0x21, 0x02, 0x03, 0x40,
  0x20, 0x02, 0x20, 0x04, 0x6a, 0x20, 0x01, 0x20, 0x02, 0x6a, 0x22, 0x06,
  0x2d, 0x00, 0x00, 0x41, 0x36, 0x73, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20,
  0x02, 0x6a, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x41, 0xdc, 0x00, 0x73, 0x3a,
  0x00, 0x00, 0x20, 0x04, 0x20, 0x02, 0x41, 0x01, 0x72, 0x22, 0x06, 0x6a,
  0x20, 0x01, 0x20, 0x06, 0x6a, 0x22, 0x09, 0x2d, 0x00, 0x00, 0x41, 0x36,
  0x73, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x06, 0x6a, 0x20, 0x09, 0x2d,
  0x00, 0x00, 0x41, 0xdc, 0x00, 0x73, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x41,
  0x02, 0x6a, 0x21, 0x02, 0x20, 0x07, 0x41, 0x02, 0x6b, 0x22, 0x07, 0x0d,
  0x00, 0x0b, 0x20, 0x08, 0x45, 0x0d, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x04,
  0x6a, 0x20, 0x01, 0x20, 0x02, 0x6a, 0x22, 0x01, 0x2d, 0x00, 0x00, 0x41,
  0x36, 0x73, 0x3a, 0x00, 0x00, 0x20, 0x00, 0x20, 0x02, 0x6a, 0x20, 0x01,
  0x2d, 0x00, 0x00, 0x41, 0xdc, 0x00, 0x73, 0x3a, 0x00, 0x00, 0x0b, 0x20,
  0x03, 0x41, 0x3f, 0x4b, 0x0d, 0x01, 0x0b, 0x20, 0x03, 0x20, 0x04, 0x6a,
  0x41, 0x36, 0x41, 0xc0, 0x00, 0x20, 0x03, 0x6b, 0x22, 0x01, 0x10, 0x29,
  0x1a, 0x20, 0x00, 0x20, 0x03, 0x6a, 0x41, 0xdc, 0x00, 0x20, 0x01, 0x10,
  0x29, 0x1a, 0x0b, 0x20, 0x05, 0x20, 0x05, 0x29, 0x03, 0x00, 0x22, 0x0a,
  0x42, 0x40, 0x7d, 0x37, 0x03, 0x00, 0x20, 0x00, 0x41, 0xd8, 0x00, 0x6a,
  0x02, 0x7f, 0x20, 0x0a, 0xa7, 0x41, 0x3f, 0x71, 0x22, 0x03, 0x04, 0x40,
  0x20, 0x00, 0x41, 0xd8, 0x00, 0x6a, 0x22, 0x01, 0x20, 0x03, 0x6a, 0x20,
  0x04, 0x41, 0xc0, 0x00, 0x20, 0x03, 0x6b, 0x22, 0x02, 0x10, 0x24, 0x1a,
  0x20, 0x05, 0x20, 0x01, 0x10, 0x2d, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x0c,
  0x01, 0x0b, 0x20, 0x05, 0x20, 0x04, 0x10, 0x2d, 0x20, 0x04, 0x41, 0x40,
  0x6b, 0x0b, 0x20, 0x03, 0x10, 0x24, 0x1a, 0x20, 0x04, 0x41, 0xf0, 0x00,
  0x6a, 0x24, 0x00, 0x20, 0x00, 0x0b, 0xd7, 0x05, 0x01, 0x10, 0x7f, 0x20,
  0x02, 0x41, 0x01, 0x74, 0x21, 0x06, 0x20, 0x00, 0x20, 0x02, 0x20, 0x02,
  0x6c, 0x22, 0x04, 0x41, 0x06, 0x6c, 0x6a, 0x21, 0x0a, 0x20, 0x00, 0x20,
  0x04, 0x41, 0x01, 0x74, 0x6a, 0x21, 0x0b, 0x20, 0x00, 0x20, 0x04, 0x41,
  0x02, 0x74, 0x22, 0x04, 0x6a, 0x21, 0x08, 0x20, 0x01, 0x20, 0x04, 0x6a,
  0x21, 0x05, 0x20, 0x02, 0x41, 0x01, 0x6b, 0x22, 0x11, 0x41, 0x01, 0x74,
  0x22, 0x0e, 0x41, 0x01, 0x72, 0x41, 0x01, 0x74, 0x21, 0x0d, 0x20, 0x00,
  0x21, 0x07, 0x20, 0x01, 0x21, 0x04, 0x03, 0x40, 0x20, 0x04, 0x20, 0x0a,
  0x2f, 0x01, 0x00, 0x20, 0x07, 0x2f, 0x01, 0x00, 0x6b, 0x3b, 0x01, 0x00,
  0x20, 0x05, 0x20, 0x0b, 0x2f, 0x01, 0x00, 0x20, 0x08, 0x2f, 0x01, 0x00,
  0x6b, 0x3b, 0x01, 0x00, 0x41, 0x01, 0x21, 0x03, 0x03, 0x40, 0x20, 0x04,
  0x20, 0x03, 0x41, 0x02, 0x74, 0x22, 0x0f, 0x6a, 0x20, 0x0a, 0x20, 0x03,
  0x41, 0x01, 0x74, 0x22, 0x09, 0x6a, 0x2f, 0x01, 0x00, 0x20, 0x07, 0x20,
  0x09, 0x41, 0x02, 0x6b, 0x22, 0x10, 0x6a, 0x2e, 0x01, 0x00, 0x20, 0x07,
  0x20, 0x09, 0x6a, 0x2e, 0x01, 0x00, 0x6a, 0x41, 0x01, 0x6a, 0x41, 0x01,
  0x76, 0x6b, 0x3b, 0x01, 0x00, 0x20, 0x05, 0x20, 0x0f, 0x6a, 0x20, 0x09,
  0x20, 0x0b, 0x6a, 0x2f, 0x01, 0x00, 0x20, 0x08, 0x20, 0x10, 0x6a, 0x2e,
  0x01, 0x00, 0x20, 0x08, 0x20, 0x09, 0x6a, 0x2e, 0x01, 0x00, 0x6a, 0x41,
  0x01, 0x6a, 0x41, 0x01, 0x76, 0x6b, 0x3b, 0x01, 0x00, 0x20, 0x03, 0x41,
  0x01, 0x6a, 0x22, 0x03, 0x20, 0x02, 0x47, 0x0d, 0x00, 0x0b, 0x41, 0x00,
  0x21, 0x03, 0x03, 0x40, 0x20, 0x04, 0x20, 0x03, 0x41, 0x02, 0x74, 0x22,
  0x09, 0x41, 0x02, 0x72, 0x22, 0x0f, 0x6a, 0x20, 0x07, 0x20, 0x03, 0x41,
  0x01, 0x74, 0x22, 0x10, 0x6a, 0x2f, 0x01, 0x00, 0x41, 0x01, 0x74, 0x20,
  0x04, 0x20, 0x09, 0x41, 0x04, 0x6a, 0x22, 0x12, 0x6a, 0x2e, 0x01, 0x00,
  0x20, 0x04, 0x20, 0x09, 0x6a, 0x2e, 0x01, 0x00, 0x6a, 0x41, 0x01, 0x76,
  0x6a, 0x3b, 0x01, 0x00, 0x20, 0x05, 0x20, 0x0f, 0x6a, 0x20, 0x08, 0x20,
  0x10, 0x6a, 0x2f, 0x01, 0x00, 0x41, 0x01, 0x74, 0x20, 0x05, 0x20, 0x12,
  0x6a, 0x2e, 0x01, 0x00, 0x20, 0x05, 0x20, 0x09, 0x6a, 0x2e, 0x01, 0x00,
  0x6a, 0x41, 0x01, 0x76, 0x6a, 0x3b, 0x01, 0x00, 0x20, 0x03, 0x41, 0x01,
  0x6a, 0x22, 0x03, 0x20, 0x11, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x04, 0x20,
  0x0d, 0x6a, 0x20, 0x04, 0x20, 0x0e, 0x41, 0x01, 0x74, 0x22, 0x03, 0x6a,
  0x2f, 0x01, 0x00, 0x20, 0x07, 0x20, 0x0e, 0x6a, 0x2f, 0x01, 0x00, 0x41,
  0x01, 0x74, 0x6a, 0x3b, 0x01, 0x00, 0x20, 0x05, 0x20, 0x0d, 0x6a, 0x20,
  0x03, 0x20, 0x05, 0x6a, 0x2f, 0x01, 0x00, 0x20, 0x08, 0x20, 0x0e, 0x6a,
  0x2f, 0x01, 0x00, 0x41, 0x01, 0x74, 0x6a, 0x3b, 0x01, 0x00, 0x20, 0x05,
  0x20, 0x06, 0x41, 0x01, 0x74, 0x22, 0x03, 0x6a, 0x21, 0x05, 0x20, 0x06,
  0x20, 0x08, 0x6a, 0x21, 0x08, 0x20, 0x06, 0x20, 0x0b, 0x6a, 0x21, 0x0b,
  0x20, 0x03, 0x20, 0x04, 0x6a, 0x21, 0x04, 0x20, 0x06, 0x20, 0x07, 0x6a,
  0x21, 0x07, 0x20, 0x06, 0x20, 0x0a, 0x6a, 0x21, 0x0a, 0x20, 0x0c, 0x41,
  0x01, 0x6a, 0x22, 0x0c, 0x20, 0x02, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x06,
  0x41, 0x01, 0x20, 0x06, 0x41, 0x01, 0x4a, 0x1b, 0x21, 0x0a, 0x41, 0x00,
  0x20, 0x06, 0x6b, 0x21, 0x0b, 0x20, 0x02, 0x41, 0x02, 0x74, 0x21, 0x04,
  0x20, 0x01, 0x20, 0x02, 0x20, 0x06, 0x6c, 0x41, 0x01, 0x74, 0x22, 0x09,
  0x6a, 0x21, 0x0e, 0x41, 0x00, 0x21, 0x07, 0x03, 0x40, 0x20, 0x01, 0x20,
  0x07, 0x41, 0x01, 0x74, 0x22, 0x05, 0x6a, 0x21, 0x0c, 0x20, 0x00, 0x20,
  0x05, 0x6a, 0x21, 0x08, 0x41, 0x00, 0x21, 0x03, 0x03, 0x40, 0x20, 0x08,
  0x20, 0x03, 0x20, 0x04, 0x6c, 0x41, 0x01, 0x74, 0x6a, 0x20, 0x0c, 0x20,
  0x03, 0x20, 0x06, 0x6c, 0x41, 0x01, 0x74, 0x6a, 0x22, 0x0d, 0x2f, 0x01,
  0x00, 0x20, 0x09, 0x20, 0x0d, 0x6a, 0x22, 0x0d, 0x20, 0x0b, 0x41, 0x00,
  0x20, 0x03, 0x1b, 0x41, 0x01, 0x74, 0x6a, 0x2e, 0x01, 0x00, 0x20, 0x0d,
  0x2e, 0x01, 0x00, 0x6a, 0x41, 0x01, 0x6a, 0x41, 0x01, 0x76, 0x6b, 0x3b,
  0x01, 0x00, 0x20, 0x03, 0x41, 0x01, 0x6a, 0x22, 0x03, 0x20, 0x02, 0x47,
  0x0d, 0x00, 0x0b, 0x20, 0x05, 0x20, 0x0e, 0x6a, 0x21, 0x0c, 0x41, 0x00,
  0x21, 0x03, 0x03, 0x40, 0x20, 0x08, 0x20, 0x03, 0x20, 0x04, 0x6c, 0x41,
  0x01, 0x74, 0x6a, 0x22, 0x05, 0x20, 0x06, 0x41, 0x01, 0x74, 0x6a, 0x20,
  0x0c, 0x20, 0x03, 0x20, 0x06, 0x6c, 0x41, 0x01, 0x74, 0x6a, 0x2f, 0x01,
  0x00, 0x41, 0x01, 0x74, 0x20, 0x05, 0x20, 0x04, 0x41, 0x00, 0x20, 0x03,
  0x20, 0x11, 0x48, 0x1b, 0x41, 0x01, 0x74, 0x6a, 0x2e, 0x01, 0x00, 0x20,
  0x05, 0x2e, 0x01, 0x00, 0x6a, 0x41, 0x01, 0x76, 0x6a, 0x3b, 0x01, 0x00,
  0x20, 0x03, 0x41, 0x01, 0x6a, 0x22, 0x03, 0x20, 0x02, 0x47, 0x0d, 0x00,
  0x0b, 0x20, 0x07, 0x41, 0x01, 0x6a, 0x22, 0x07, 0x20, 0x0a, 0x47, 0x0d,
  0x00, 0x0b, 0x0b, 0x12, 0x00, 0x20, 0x02, 0x04, 0x40, 0x20, 0x00, 0x20,
  0x01, 0x20, 0x02, 0x10, 0x24, 0x1a, 0x0b, 0x20, 0x00, 0x0b, 0xb4, 0x03,
  0x01, 0x05, 0x7f, 0x23, 0x00, 0x41, 0xe0, 0x00, 0x6b, 0x22, 0x02, 0x24,
  0x00, 0x20, 0x01, 0x41, 0x01, 0x3a, 0x00, 0x00, 0x02, 0x40, 0x02, 0x40,
  0x20, 0x00, 0x28, 0x02, 0x00, 0x22, 0x06, 0x28, 0x02, 0x04, 0x22, 0x03,
  0x20, 0x06, 0x28, 0x02, 0x08, 0x22, 0x00, 0x6b, 0x22, 0x04, 0x41, 0x02,
  0x4f, 0x04, 0x40, 0x20, 0x06, 0x20, 0x00, 0x41, 0x01, 0x6a, 0x36, 0x02,
  0x08, 0x20, 0x00, 0x2d, 0x00, 0x00, 0x22, 0x04, 0x41, 0x02, 0x46, 0x04,
  0x40, 0x20, 0x06, 0x20, 0x00, 0x41, 0x02, 0x6a, 0x22, 0x04, 0x36, 0x02,
  0x08, 0x20, 0x03, 0x20, 0x04, 0x6b, 0x22, 0x05, 0x20, 0x00, 0x2d, 0x00,
  0x01, 0x22, 0x03, 0x4f, 0x04, 0x40, 0x02, 0x40, 0x20, 0x03, 0x45, 0x04,
  0x40, 0x41, 0x00, 0x21, 0x00, 0x0c, 0x01, 0x0b, 0x20, 0x03, 0x41, 0x03,
  0x71, 0x21, 0x05, 0x02, 0x7f, 0x20, 0x03, 0x41, 0x01, 0x6b, 0x41, 0x03,
  0x49, 0x04, 0x40, 0x41, 0x00, 0x21, 0x01, 0x41, 0x00, 0x0c, 0x01, 0x0b,
  0x20, 0x03, 0x41, 0xfc, 0x01, 0x71, 0x22, 0x01, 0x20, 0x04, 0x6a, 0x41,
  0x04, 0x6b, 0x22, 0x00, 0x2d, 0x00, 0x00, 0x41, 0x10, 0x74, 0x20, 0x00,
  0x2d, 0x00, 0x01, 0x41, 0x08, 0x74, 0x72, 0x20, 0x00, 0x2d, 0x00, 0x02,
  0x72, 0x41, 0x08, 0x74, 0x20, 0x00, 0x2d, 0x00, 0x03, 0x72, 0x0b, 0x21,
  0x00, 0x20, 0x05, 0x45, 0x0d, 0x00, 0x03, 0x40, 0x20, 0x01, 0x20, 0x04,
  0x6a, 0x2d, 0x00, 0x00, 0x20, 0x00, 0x41, 0x08, 0x74, 0x72, 0x21, 0x00,
  0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x20, 0x05, 0x41, 0x01, 0x6b,
  0x22, 0x05, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x06, 0x20, 0x03, 0x20, 0x04,
  0x6a, 0x36, 0x02, 0x08, 0x0c, 0x04, 0x0b, 0x10, 0x00, 0x21, 0x00, 0x20,
  0x02, 0x20, 0x05, 0x36, 0x02, 0x10, 0x20, 0x02, 0x20, 0x03, 0x36, 0x02,
  0x0c, 0x20, 0x02, 0x20, 0x00, 0x36, 0x02, 0x08, 0x20, 0x02, 0x20, 0x00,
  0x36, 0x02, 0x04, 0x20, 0x02, 0x41, 0xf3, 0xe3, 0x03, 0x36, 0x02, 0x00,
  0x41, 0x03, 0x41, 0xa6, 0xc7, 0x04, 0x20, 0x02, 0x10, 0x22, 0x0c, 0x02,
  0x0b, 0x10, 0x00, 0x21, 0x00, 0x20, 0x02, 0x20, 0x04, 0x36, 0x02, 0x30,
  0x20, 0x02, 0x41, 0x02, 0x36, 0x02, 0x2c, 0x20, 0x02, 0x20, 0x00, 0x36,
  0x02, 0x28, 0x20, 0x02, 0x20, 0x00, 0x36, 0x02, 0x24, 0x20, 0x02, 0x41,
  0xf3, 0xe3, 0x03, 0x36, 0x02, 0x20, 0x41, 0x03, 0x41, 0xec, 0xee, 0x00,
  0x20, 0x02, 0x41, 0x20, 0x6a, 0x10, 0x22, 0x0c, 0x01, 0x0b, 0x10, 0x00,
  0x21, 0x00, 0x20, 0x02, 0x20, 0x04, 0x36, 0x02, 0x50, 0x20, 0x02, 0x41,
  0x02, 0x36, 0x02, 0x4c, 0x20, 0x02, 0x20, 0x00, 0x36, 0x02, 0x48, 0x20,
  0x02, 0x20, 0x00, 0x36, 0x02, 0x44, 0x20, 0x02, 0x41, 0xf3, 0xe3, 0x03,
  0x36, 0x02, 0x40, 0x41, 0x03, 0x41, 0xb3, 0xc6, 0x04, 0x20, 0x02, 0x41,
  0x40, 0x6b, 0x10, 0x22, 0x0b, 0x41, 0x00, 0x21, 0x00, 0x20, 0x01, 0x41,
  0x00, 0x3a, 0x00, 0x00, 0x0b, 0x20, 0x02, 0x41, 0xe0, 0x00, 0x6a, 0x24,
  0x00, 0x20, 0x00, 0x0b, 0xdb, 0x02, 0x01, 0x02, 0x7f, 0x20, 0x00, 0x28,
  0x02, 0x04, 0x22, 0x05, 0x20, 0x02, 0x71, 0x21, 0x04, 0x02, 0x40, 0x20,
  0x00, 0x2d, 0x00, 0x00, 0x41, 0x10, 0x71, 0x04, 0x40, 0x20, 0x04, 0x04,
  0x40, 0x20, 0x03, 0x2f, 0x01, 0x00, 0x21, 0x00, 0x20, 0x01, 0x20, 0x01,
  0x28, 0x02, 0x08, 0x22, 0x04, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x08, 0x20,
  0x03, 0x20, 0x00, 0x20, 0x04, 0x2c, 0x00, 0x00, 0x6a, 0x3b, 0x01, 0x00,
  0x0b, 0x20, 0x05, 0x20, 0x02, 0x41, 0x01, 0x74, 0x71, 0x04, 0x40, 0x20,
  0x03, 0x2f, 0x01, 0x02, 0x21, 0x00, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02,
  0x08, 0x22, 0x04, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20,
  0x00, 0x20, 0x04, 0x2c, 0x00, 0x00, 0x6a, 0x3b, 0x01, 0x02, 0x0b, 0x20,
  0x05, 0x20, 0x02, 0x41, 0x02, 0x74, 0x71, 0x04, 0x40, 0x20, 0x03, 0x2f,
  0x01, 0x04, 0x21, 0x00, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22,
  0x04, 0x41, 0x01, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x00, 0x20,
  0x04, 0x2c, 0x00, 0x00, 0x6a, 0x3b, 0x01, 0x04, 0x0b, 0x20, 0x05, 0x20,
  0x02, 0x41, 0x03, 0x74, 0x71, 0x45, 0x0d, 0x01, 0x20, 0x03, 0x2f, 0x01,
  0x06, 0x21, 0x00, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22, 0x01,
  0x41, 0x01, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x00, 0x20, 0x01,
  0x2c, 0x00, 0x00, 0x6a, 0x3b, 0x01, 0x06, 0x0f, 0x0b, 0x20, 0x04, 0x04,
  0x40, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22, 0x00, 0x41, 0x02,
  0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x00, 0x2f, 0x00, 0x00, 0x3b,
  0x01, 0x00, 0x0b, 0x20, 0x05, 0x20, 0x02, 0x41, 0x01, 0x74, 0x71, 0x04,
  0x40, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22, 0x00, 0x41, 0x02,
  0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x00, 0x2f, 0x00, 0x00, 0x3b,
  0x01, 0x02, 0x0b, 0x20, 0x05, 0x20, 0x02, 0x41, 0x02, 0x74, 0x71, 0x04,
  0x40, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22, 0x00, 0x41, 0x02,
  0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x00, 0x2f, 0x00, 0x00, 0x3b,
  0x01, 0x04, 0x0b, 0x20, 0x05, 0x20, 0x02, 0x41, 0x03, 0x74, 0x71, 0x45,
  0x0d, 0x00, 0x20, 0x01, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22, 0x00, 0x41,
  0x02, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x03, 0x20, 0x00, 0x2f, 0x00, 0x00,
  0x3b, 0x01, 0x06, 0x0b, 0x0b, 0x9e, 0x02, 0x01, 0x07, 0x7f, 0x02, 0x40,
  0x20, 0x01, 0x45, 0x0d, 0x00, 0x03, 0x40, 0x20, 0x00, 0x20, 0x07, 0x6a,
  0x2c, 0x00, 0x00, 0x22, 0x06, 0x20, 0x00, 0x20, 0x07, 0x41, 0x01, 0x72,
  0x6a, 0x2d, 0x00, 0x00, 0x22, 0x05, 0x72, 0x41, 0xff, 0x01, 0x71, 0x45,
  0x04, 0x40, 0x20, 0x04, 0x41, 0x01, 0x6a, 0x22, 0x00, 0x20, 0x03, 0x4b,
  0x0d, 0x02, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x41, 0x00, 0x3a, 0x00, 0x00,
  0x20, 0x00, 0x0f, 0x0b, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x20, 0x05,
  0x41, 0x08, 0x4f, 0x04, 0x40, 0x20, 0x04, 0x41, 0x03, 0x6a, 0x22, 0x08,
  0x20, 0x03, 0x4b, 0x0d, 0x05, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x20, 0x05,
  0x41, 0xf0, 0x01, 0x71, 0x41, 0x04, 0x76, 0x41, 0xe0, 0x01, 0x72, 0x3a,
  0x00, 0x00, 0x41, 0x02, 0x21, 0x0a, 0x20, 0x05, 0x41, 0x02, 0x74, 0x41,
  0x3c, 0x71, 0x20, 0x06, 0x41, 0xc0, 0x01, 0x71, 0x41, 0x06, 0x76, 0x72,
  0x41, 0x80, 0x7f, 0x72, 0x21, 0x05, 0x20, 0x04, 0x41, 0x01, 0x6a, 0x0c,
  0x01, 0x0b, 0x20, 0x05, 0x41, 0x01, 0x20, 0x06, 0x41, 0x7f, 0x4a, 0x1b,
  0x45, 0x0d, 0x01, 0x20, 0x04, 0x41, 0x02, 0x6a, 0x22, 0x08, 0x20, 0x03,
  0x4b, 0x0d, 0x04, 0x20, 0x05, 0x41, 0x02, 0x74, 0x41, 0x1c, 0x71, 0x20,
  0x06, 0x41, 0xc0, 0x01, 0x71, 0x41, 0x06, 0x76, 0x72, 0x41, 0x40, 0x72,
  0x21, 0x05, 0x41, 0x01, 0x21, 0x0a, 0x20, 0x04, 0x0b, 0x20, 0x02, 0x6a,
  0x20, 0x05, 0x3a, 0x00, 0x00, 0x20, 0x04, 0x20, 0x0a, 0x6a, 0x21, 0x04,
  0x20, 0x06, 0x41, 0x3f, 0x71, 0x41, 0x80, 0x7f, 0x72, 0x21, 0x06, 0x0c,
  0x01, 0x0b, 0x20, 0x04, 0x41, 0x01, 0x6a, 0x22, 0x08, 0x20, 0x03, 0x4b,
  0x0d, 0x02, 0x0b, 0x20, 0x07, 0x41, 0x02, 0x6a, 0x21, 0x07, 0x20, 0x02,
  0x20, 0x04, 0x6a, 0x20, 0x06, 0x3a, 0x00, 0x00, 0x20, 0x08, 0x21, 0x04,
  0x20, 0x09, 0x41, 0x01, 0x6a, 0x22, 0x09, 0x20, 0x01, 0x47, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x04, 0x0b, 0xe3, 0x01, 0x01, 0x06, 0x7f, 0x02, 0x40,
  0x02, 0x40, 0x20, 0x01, 0x20, 0x00, 0x28, 0x02, 0x04, 0x22, 0x02, 0x20,
  0x00, 0x28, 0x02, 0x00, 0x22, 0x04, 0x6b, 0x22, 0x05, 0x4b, 0x04, 0x40,
  0x20, 0x01, 0x20, 0x05, 0x6b, 0x22, 0x06, 0x20, 0x00, 0x28, 0x02, 0x08,
  0x22, 0x03, 0x20, 0x02, 0x6b, 0x4d, 0x04, 0x40, 0x20, 0x00, 0x20, 0x06,
  0x04, 0x7f, 0x20, 0x02, 0x41, 0x00, 0x20, 0x06, 0x10, 0x29, 0x20, 0x06,
  0x6a, 0x05, 0x20, 0x02, 0x0b, 0x36, 0x02, 0x04, 0x0f, 0x0b, 0x20, 0x01,
  0x41, 0x7f, 0x4c, 0x0d, 0x02, 0x41, 0x00, 0x21, 0x02, 0x02, 0x7f, 0x20,
  0x01, 0x20, 0x03, 0x20, 0x04, 0x6b, 0x22, 0x03, 0x41, 0x01, 0x74, 0x22,
  0x07, 0x20, 0x01, 0x20, 0x07, 0x4b, 0x1b, 0x41, 0xff, 0xff, 0xff, 0xff,
  0x07, 0x20, 0x03, 0x41, 0xff, 0xff, 0xff, 0xff, 0x03, 0x49, 0x1b, 0x22,
  0x03, 0x04, 0x40, 0x20, 0x03, 0x10, 0x27, 0x21, 0x02, 0x0b, 0x20, 0x02,
  0x20, 0x05, 0x6a, 0x0b, 0x41, 0x00, 0x20, 0x06, 0x10, 0x29, 0x1a, 0x20,
  0x05, 0x41, 0x01, 0x4e, 0x04, 0x40, 0x20, 0x02, 0x20, 0x04, 0x20, 0x05,
  0x10, 0x24, 0x1a, 0x0b, 0x20, 0x00, 0x20, 0x02, 0x20, 0x03, 0x6a, 0x36,
  0x02, 0x08, 0x20, 0x00, 0x20, 0x01, 0x20, 0x02, 0x6a, 0x36, 0x02, 0x04,
  0x20, 0x00, 0x20, 0x02, 0x36, 0x02, 0x00, 0x20, 0x04, 0x45, 0x0d, 0x01,
  0x20, 0x04, 0x10, 0x23, 0x0f, 0x0b, 0x20, 0x01, 0x20, 0x05, 0x4f, 0x0d,
  0x00, 0x20, 0x00, 0x20, 0x01, 0x20, 0x04, 0x6a, 0x36, 0x02, 0x04, 0x0b,
  0x0f, 0x0b, 0x10, 0x37, 0x00, 0x0b, 0xa0, 0x06, 0x02, 0x0a, 0x7f, 0x01,
  0x7e, 0x23, 0x00, 0x41, 0x40, 0x6a, 0x22, 0x05, 0x24, 0x00, 0x20, 0x05,
  0x20, 0x04, 0x36, 0x02, 0x34, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x30,
  0x20, 0x05, 0x41, 0x00, 0x3a, 0x00, 0x3f, 0x20, 0x05, 0x20, 0x05, 0x29,
  0x03, 0x30, 0x37, 0x03, 0x28, 0x02, 0x40, 0x02, 0x7f, 0x23, 0x00, 0x41,
  0x10, 0x6b, 0x22, 0x0a, 0x24, 0x00, 0x02, 0x40, 0x20, 0x05, 0x28, 0x02,
  0x2c, 0x22, 0x08, 0x45, 0x04, 0x40, 0x41, 0x8d, 0xf8, 0x02, 0x21, 0x0c,
  0x0c, 0x01, 0x0b, 0x20, 0x05, 0x28, 0x02, 0x28, 0x21, 0x06, 0x02, 0x40,
  0x20, 0x0a, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x20, 0x08, 0x41, 0x01, 0x46, 0x0d, 0x00, 0x20, 0x06, 0x2d,
  0x00, 0x00, 0x41, 0x30, 0x47, 0x0d, 0x00, 0x20, 0x06, 0x2d, 0x00, 0x01,
  0x41, 0xf8, 0x00, 0x46, 0x0d, 0x01, 0x0b, 0x20, 0x06, 0x20, 0x08, 0x6a,
  0x21, 0x09, 0x20, 0x06, 0x21, 0x07, 0x02, 0x40, 0x20, 0x06, 0x02, 0x7f,
  0x02, 0x40, 0x03, 0x40, 0x20, 0x07, 0x2d, 0x00, 0x00, 0x22, 0x0b, 0x41,
  0x30, 0x47, 0x0d, 0x01, 0x20, 0x07, 0x41, 0x01, 0x6a, 0x22, 0x07, 0x20,
  0x09, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x09, 0x0c, 0x01, 0x0b, 0x20, 0x09,
  0x20, 0x07, 0x20, 0x09, 0x46, 0x0d, 0x00, 0x1a, 0x20, 0x0b, 0x41, 0x30,
  0x6b, 0x22, 0x0c, 0x41, 0xff, 0x01, 0x71, 0x41, 0x0a, 0x49, 0x0d, 0x01,
  0x20, 0x07, 0x0b, 0x22, 0x0b, 0x46, 0x04, 0x40, 0x20, 0x0a, 0x20, 0x06,
  0x36, 0x02, 0x00, 0x41, 0x1c, 0x21, 0x07, 0x20, 0x0a, 0x41, 0x1c, 0x36,
  0x02, 0x04, 0x0c, 0x07, 0x0b, 0x20, 0x0a, 0x20, 0x0b, 0x36, 0x02, 0x00,
  0x41, 0x00, 0x21, 0x07, 0x20, 0x0a, 0x41, 0x00, 0x3a, 0x00, 0x0f, 0x20,
  0x0a, 0x41, 0x00, 0x36, 0x02, 0x04, 0x0c, 0x06, 0x0b, 0x20, 0x09, 0x21,
  0x06, 0x20, 0x0c, 0x21, 0x0b, 0x02, 0x40, 0x20, 0x07, 0x41, 0x01, 0x6a,
  0x22, 0x08, 0x20, 0x09, 0x46, 0x0d, 0x00, 0x20, 0x08, 0x22, 0x06, 0x2d,
  0x00, 0x00, 0x22, 0x0e, 0x41, 0x30, 0x6b, 0x22, 0x08, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x0a, 0x4f, 0x0d, 0x00, 0x41, 0x01, 0x21, 0x0d, 0x20, 0x09,
  0x20, 0x07, 0x41, 0x02, 0x6a, 0x22, 0x06, 0x46, 0x04, 0x40, 0x20, 0x09,
  0x21, 0x06, 0x20, 0x08, 0x21, 0x0b, 0x0c, 0x01, 0x0b, 0x20, 0x08, 0x21,
  0x0b, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x22, 0x08, 0x41, 0x30, 0x6b, 0x41,
  0xff, 0x01, 0x71, 0x41, 0x0a, 0x4f, 0x0d, 0x00, 0x20, 0x07, 0x41, 0x03,
  0x6a, 0x21, 0x06, 0x20, 0x0e, 0x41, 0x0a, 0x6c, 0x20, 0x08, 0x6a, 0x41,
  0x90, 0x04, 0x6b, 0x21, 0x0b, 0x41, 0x02, 0x21, 0x0d, 0x0b, 0x20, 0x0d,
  0x41, 0x02, 0x74, 0x41, 0xe0, 0xd0, 0x05, 0x6a, 0x35, 0x02, 0x00, 0x20,
  0x0c, 0xad, 0x7e, 0x22, 0x0f, 0xa7, 0x21, 0x08, 0x20, 0x06, 0x20, 0x0f,
  0x42, 0x20, 0x88, 0xa7, 0x41, 0x00, 0x47, 0x6b, 0x22, 0x0c, 0x20, 0x09,
  0x46, 0x0d, 0x01, 0x02, 0x40, 0x20, 0x0c, 0x2d, 0x00, 0x00, 0x41, 0x30,
  0x6b, 0x41, 0xff, 0x01, 0x71, 0x22, 0x06, 0x41, 0x0a, 0x49, 0x0d, 0x00,
  0x20, 0x0b, 0x41, 0xff, 0x01, 0x4b, 0x0d, 0x00, 0x41, 0xff, 0x01, 0x20,
  0x0b, 0x6b, 0x20, 0x08, 0x4f, 0x0d, 0x03, 0x0b, 0x41, 0xc4, 0x00, 0x21,
  0x07, 0x20, 0x06, 0x41, 0x09, 0x4b, 0x0d, 0x03, 0x03, 0x40, 0x20, 0x09,
  0x20, 0x09, 0x20, 0x0c, 0x41, 0x01, 0x6a, 0x22, 0x0c, 0x46, 0x0d, 0x05,
  0x1a, 0x20, 0x0c, 0x2d, 0x00, 0x00, 0x41, 0x30, 0x6b, 0x41, 0xff, 0x01,
  0x71, 0x41, 0x0a, 0x49, 0x0d, 0x00, 0x0b, 0x0c, 0x03, 0x0b, 0x20, 0x05,
  0x20, 0x08, 0x41, 0x02, 0x6b, 0x36, 0x02, 0x2c, 0x20, 0x05, 0x20, 0x06,
  0x41, 0x02, 0x6a, 0x22, 0x0b, 0x36, 0x02, 0x28, 0x20, 0x0a, 0x20, 0x0b,
  0x20, 0x06, 0x20, 0x08, 0x6a, 0x22, 0x09, 0x20, 0x0a, 0x41, 0x0f, 0x6a,
  0x10, 0x8c, 0x01, 0x20, 0x0a, 0x28, 0x02, 0x04, 0x21, 0x07, 0x0c, 0x04,
  0x0b, 0x41, 0xc4, 0x00, 0x21, 0x07, 0x20, 0x09, 0x20, 0x0b, 0x41, 0xff,
  0x01, 0x4b, 0x0d, 0x02, 0x1a, 0x20, 0x09, 0x41, 0xff, 0x01, 0x20, 0x0b,
  0x6b, 0x20, 0x08, 0x49, 0x0d, 0x02, 0x1a, 0x0b, 0x20, 0x0a, 0x20, 0x08,
  0x20, 0x0b, 0x6a, 0x3a, 0x00, 0x0f, 0x41, 0x00, 0x21, 0x07, 0x0b, 0x20,
  0x0c, 0x0b, 0x36, 0x02, 0x00, 0x20, 0x0a, 0x20, 0x07, 0x36, 0x02, 0x04,
  0x0b, 0x41, 0x80, 0xd5, 0x05, 0x21, 0x0c, 0x20, 0x07, 0x41, 0x3d, 0x46,
  0x0d, 0x00, 0x02, 0x40, 0x20, 0x07, 0x0d, 0x00, 0x20, 0x0a, 0x28, 0x02,
  0x00, 0x20, 0x09, 0x47, 0x0d, 0x00, 0x20, 0x0a, 0x2d, 0x00, 0x0f, 0x22,
  0x06, 0x41, 0x07, 0x4b, 0x0d, 0x01, 0x20, 0x05, 0x20, 0x06, 0x3a, 0x00,
  0x3f, 0x41, 0x00, 0x21, 0x0c, 0x0c, 0x01, 0x0b, 0x41, 0x95, 0xe6, 0x02,
  0x21, 0x0c, 0x0b, 0x20, 0x0a, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x20, 0x0c,
  0x22, 0x06, 0x45, 0x0b, 0x04, 0x40, 0x20, 0x02, 0x20, 0x05, 0x2d, 0x00,
  0x3f, 0x3a, 0x00, 0x00, 0x0c, 0x01, 0x0b, 0x10, 0x00, 0x21, 0x02, 0x20,
  0x05, 0x20, 0x06, 0x36, 0x02, 0x1c, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02,
  0x18, 0x20, 0x05, 0x20, 0x04, 0x36, 0x02, 0x14, 0x20, 0x05, 0x20, 0x00,
  0x36, 0x02, 0x10, 0x20, 0x05, 0x20, 0x01, 0x36, 0x02, 0x0c, 0x20, 0x05,
  0x20, 0x02, 0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x04,
  0x20, 0x05, 0x41, 0xd4, 0xf7, 0x03, 0x36, 0x02, 0x00, 0x41, 0x04, 0x41,
  0x90, 0xb2, 0x02, 0x20, 0x05, 0x10, 0x22, 0x0b, 0x20, 0x05, 0x41, 0x40,
  0x6b, 0x24, 0x00, 0x0b, 0x58, 0x01, 0x02, 0x7f, 0x23, 0x00, 0x41, 0x20,
  0x6b, 0x22, 0x04, 0x24, 0x00, 0x10, 0x00, 0x21, 0x05, 0x20, 0x02, 0x2f,
  0x01, 0x00, 0x21, 0x02, 0x20, 0x04, 0x20, 0x03, 0x28, 0x02, 0x00, 0x36,
  0x02, 0x10, 0x20, 0x04, 0x20, 0x02, 0x36, 0x02, 0x0c, 0x20, 0x04, 0x20,
  0x05, 0x36, 0x02, 0x08, 0x20, 0x04, 0x20, 0x05, 0x36, 0x02, 0x04, 0x20,
  0x04, 0x20, 0x00, 0x41, 0x02, 0x74, 0x41, 0xb0, 0xea, 0x1a, 0x6a, 0x28,
  0x02, 0x00, 0x36, 0x02, 0x00, 0x20, 0x00, 0x20, 0x01, 0x20, 0x04, 0x10,
  0x22, 0x20, 0x04, 0x41, 0x20, 0x6a, 0x24, 0x00, 0x0b, 0xb0, 0x10, 0x00,
  0x41, 0xc8, 0xb4, 0x1b, 0x42, 0xaa, 0xff, 0xff, 0x87, 0xf0, 0xff, 0xff,
  0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xc0, 0xb4, 0x1b, 0x42, 0x80, 0xfe,
  0xff, 0x87, 0xd0, 0xea, 0xff, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xb8,
  0xb4, 0x1b, 0x42, 0xaa, 0xb7, 0xff, 0x87, 0xf0, 0xff, 0xf6, 0xff, 0x00,
  0x37, 0x02, 0x00, 0x41, 0xb0, 0xb4, 0x1b, 0x42, 0x80, 0xb6, 0xff, 0x87,
  0xd0, 0xea, 0xf6, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xa8, 0xb4, 0x1b,
  0x42, 0xaa, 0xed, 0xfe, 0x87, 0xf0, 0xdf, 0xed, 0xff, 0x00, 0x37, 0x02,
  0x00, 0x41, 0xa0, 0xb4, 0x1b, 0x42, 0x80, 0xec, 0xfe, 0x87, 0xd0, 0xca,
  0xed, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0x98, 0xb4, 0x1b, 0x42, 0xaa,
  0xa5, 0xfe, 0x87, 0xf0, 0xdf, 0xe4, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41,
  0x90, 0xb4, 0x1b, 0x42, 0x80, 0xa4, 0xfe, 0x87, 0xd0, 0xca, 0xe4, 0xff,
  0x00, 0x37, 0x02, 0x00, 0x41, 0x88, 0xb4, 0x1b, 0x42, 0xaa, 0xdb, 0xfd,
  0x87, 0xf0, 0xbf, 0xdb, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0x80, 0xb4,
  0x1b, 0x42, 0x80, 0xda, 0xfd, 0x87, 0xd0, 0xaa, 0xdb, 0xff, 0x00, 0x37,
  0x02, 0x00, 0x41, 0xf8, 0xb3, 0x1b, 0x42, 0xaa, 0x93, 0xfd, 0x87, 0xf0,
  0xbf, 0xd2, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xf0, 0xb3, 0x1b, 0x42,
  0x80, 0x92, 0xfd, 0x87, 0xd0, 0xaa, 0xd2, 0xff, 0x00, 0x37, 0x02, 0x00,
  0x41, 0xe8, 0xb3, 0x1b, 0x42, 0xaa, 0xc9, 0xfc, 0x87, 0xf0, 0x9f, 0xc9,
  0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xe0, 0xb3, 0x1b, 0x42, 0x80, 0xc8,
  0xfc, 0x87, 0xd0, 0x8a, 0xc9, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xd8,
  0xb3, 0x1b, 0x42, 0xaa, 0x81, 0xfc, 0x87, 0xf0, 0x9f, 0xc0, 0xff, 0x00,
  0x37, 0x02, 0x00, 0x41, 0xd0, 0xb3, 0x1b, 0x42, 0x80, 0x80, 0xfc, 0x87,
  0xd0, 0x8a, 0xc0, 0xff, 0x00, 0x37, 0x02, 0x00, 0x41, 0xc8, 0xb3, 0x1b,
  0x42, 0xaa, 0xff, 0xef, 0x86, 0xf0, 0xff, 0xff, 0xed, 0x00, 0x37, 0x02,
  0x00, 0x41, 0xc0, 0xb3, 0x1b, 0x42, 0x80, 0xfe, 0xef, 0x86, 0xd0, 0xea,
  0xff, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0xb8, 0xb3, 0x1b, 0x42, 0xaa,
  0xb7, 0xef, 0x86, 0xf0, 0xff, 0xf6, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41,
  0xb0, 0xb3, 0x1b, 0x42, 0x80, 0xb6, 0xef, 0x86, 0xd0, 0xea, 0xf6, 0xed,
  0x00, 0x37, 0x02, 0x00, 0x41, 0xa8, 0xb3, 0x1b, 0x42, 0xaa, 0xed, 0xee,
  0x86, 0xf0, 0xdf, 0xed, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0xa0, 0xb3,
  0x1b, 0x42, 0x80, 0xec, 0xee, 0x86, 0xd0, 0xca, 0xed, 0xed, 0x00, 0x37,
  0x02, 0x00, 0x41, 0x98, 0xb3, 0x1b, 0x42, 0xaa, 0xa5, 0xee, 0x86, 0xf0,
  0xdf, 0xe4, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0x90, 0xb3, 0x1b, 0x42,
  0x80, 0xa4, 0xee, 0x86, 0xd0, 0xca, 0xe4, 0xed, 0x00, 0x37, 0x02, 0x00,
  0x41, 0x88, 0xb3, 0x1b, 0x42, 0xaa, 0xdb, 0xed, 0x86, 0xf0, 0xbf, 0xdb,
  0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0x80, 0xb3, 0x1b, 0x42, 0x80, 0xda,
  0xed, 0x86, 0xd0, 0xaa, 0xdb, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0xf8,
  0xb2, 0x1b, 0x42, 0xaa, 0x93, 0xed, 0x86, 0xf0, 0xbf, 0xd2, 0xed, 0x00,
  0x37, 0x02, 0x00, 0x41, 0xf0, 0xb2, 0x1b, 0x42, 0x80, 0x92, 0xed, 0x86,
  0xd0, 0xaa, 0xd2, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0xe8, 0xb2, 0x1b,
  0x42, 0xaa, 0xc9, 0xec, 0x86, 0xf0, 0x9f, 0xc9, 0xed, 0x00, 0x37, 0x02,
  0x00, 0x41, 0xe0, 0xb2, 0x1b, 0x42, 0x80, 0xc8, 0xec, 0x86, 0xd0, 0x8a,
  0xc9, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41, 0xd8, 0xb2, 0x1b, 0x42, 0xaa,
  0x81, 0xec, 0x86, 0xf0, 0x9f, 0xc0, 0xed, 0x00, 0x37, 0x02, 0x00, 0x41,
  0xd0, 0xb2, 0x1b, 0x42, 0x80, 0x80, 0xec, 0x86, 0xd0, 0x8a, 0xc0, 0xed,
  0x00, 0x37, 0x02, 0x00, 0x41, 0xc8, 0xb2, 0x1b, 0x42, 0xaa, 0xff, 0xdb,
  0x85, 0xf0, 0xff, 0xbf, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0xc0, 0xb2,
  0x1b, 0x42, 0x80, 0xfe, 0xdb, 0x85, 0xd0, 0xea, 0xbf, 0xdb, 0x00, 0x37,
  0x02, 0x00, 0x41, 0xb8, 0xb2, 0x1b, 0x42, 0xaa, 0xb7, 0xdb, 0x85, 0xf0,
  0xff, 0xb6, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0xb0, 0xb2, 0x1b, 0x42,
  0x80, 0xb6, 0xdb, 0x85, 0xd0, 0xea, 0xb6, 0xdb, 0x00, 0x37, 0x02, 0x00,
  0x41, 0xa8, 0xb2, 0x1b, 0x42, 0xaa, 0xed, 0xda, 0x85, 0xf0, 0xdf, 0xad,
  0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0xa0, 0xb2, 0x1b, 0x42, 0x80, 0xec,
  0xda, 0x85, 0xd0, 0xca, 0xad, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0x98,
  0xb2, 0x1b, 0x42, 0xaa, 0xa5, 0xda, 0x85, 0xf0, 0xdf, 0xa4, 0xdb, 0x00,
  0x37, 0x02, 0x00, 0x41, 0x90, 0xb2, 0x1b, 0x42, 0x80, 0xa4, 0xda, 0x85,
  0xd0, 0xca, 0xa4, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0x88, 0xb2, 0x1b,
  0x42, 0xaa, 0xdb, 0xd9, 0x85, 0xf0, 0xbf, 0x9b, 0xdb, 0x00, 0x37, 0x02,
  0x00, 0x41, 0x80, 0xb2, 0x1b, 0x42, 0x80, 0xda, 0xd9, 0x85, 0xd0, 0xaa,
  0x9b, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0xf8, 0xb1, 0x1b, 0x42, 0xaa,
  0x93, 0xd9, 0x85, 0xf0, 0xbf, 0x92, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41,
  0xf0, 0xb1, 0x1b, 0x42, 0x80, 0x92, 0xd9, 0x85, 0xd0, 0xaa, 0x92, 0xdb,
  0x00, 0x37, 0x02, 0x00, 0x41, 0xe8, 0xb1, 0x1b, 0x42, 0xaa, 0xc9, 0xd8,
  0x85, 0xf0, 0x9f, 0x89, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0xe0, 0xb1,
  0x1b, 0x42, 0x80, 0xc8, 0xd8, 0x85, 0xd0, 0x8a, 0x89, 0xdb, 0x00, 0x37,
  0x02, 0x00, 0x41, 0xd8, 0xb1, 0x1b, 0x42, 0xaa, 0x81, 0xd8, 0x85, 0xf0,
  0x9f, 0x80, 0xdb, 0x00, 0x37, 0x02, 0x00, 0x41, 0xd0, 0xb1, 0x1b, 0x42,
  0x80, 0x80, 0xd8, 0x85, 0xd0, 0x8a, 0x80, 0xdb, 0x00, 0x37, 0x02, 0x00,
  0x41, 0xc8, 0xb1, 0x1b, 0x42, 0xaa, 0xff, 0xcb, 0x84, 0xf0, 0xff, 0xbf,
  0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xc0, 0xb1, 0x1b, 0x42, 0x80, 0xfe,
  0xcb, 0x84, 0xd0, 0xea, 0xbf, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xb8,
  0xb1, 0x1b, 0x42, 0xaa, 0xb7, 0xcb, 0x84, 0xf0, 0xff, 0xb6, 0xc9, 0x00,
  0x37, 0x02, 0x00, 0x41, 0xb0, 0xb1, 0x1b, 0x42, 0x80, 0xb6, 0xcb, 0x84,
  0xd0, 0xea, 0xb6, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xa8, 0xb1, 0x1b,
  0x42, 0xaa, 0xed, 0xca, 0x84, 0xf0, 0xdf, 0xad, 0xc9, 0x00, 0x37, 0x02,
  0x00, 0x41, 0xa0, 0xb1, 0x1b, 0x42, 0x80, 0xec, 0xca, 0x84, 0xd0, 0xca,
  0xad, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0x98, 0xb1, 0x1b, 0x42, 0xaa,
  0xa5, 0xca, 0x84, 0xf0, 0xdf, 0xa4, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41,
  0x90, 0xb1, 0x1b, 0x42, 0x80, 0xa4, 0xca, 0x84, 0xd0, 0xca, 0xa4, 0xc9,
  0x00, 0x37, 0x02, 0x00, 0x41, 0x88, 0xb1, 0x1b, 0x42, 0xaa, 0xdb, 0xc9,
  0x84, 0xf0, 0xbf, 0x9b, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0x80, 0xb1,
  0x1b, 0x42, 0x80, 0xda, 0xc9, 0x84, 0xd0, 0xaa, 0x9b, 0xc9, 0x00, 0x37,
  0x02, 0x00, 0x41, 0xf8, 0xb0, 0x1b, 0x42, 0xaa, 0x93, 0xc9, 0x84, 0xf0,
  0xbf, 0x92, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xf0, 0xb0, 0x1b, 0x42,
  0x80, 0x92, 0xc9, 0x84, 0xd0, 0xaa, 0x92, 0xc9, 0x00, 0x37, 0x02, 0x00,
  0x41, 0xe8, 0xb0, 0x1b, 0x42, 0xaa, 0xc9, 0xc8, 0x84, 0xf0, 0x9f, 0x89,
  0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xe0, 0xb0, 0x1b, 0x42, 0x80, 0xc8,
  0xc8, 0x84, 0xd0, 0x8a, 0x89, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xd8,
  0xb0, 0x1b, 0x42, 0xaa, 0x81, 0xc8, 0x84, 0xf0, 0x9f, 0x80, 0xc9, 0x00,
  0x37, 0x02, 0x00, 0x41, 0xd0, 0xb0, 0x1b, 0x42, 0x80, 0x80, 0xc8, 0x84,
  0xd0, 0x8a, 0x80, 0xc9, 0x00, 0x37, 0x02, 0x00, 0x41, 0xc8, 0xb0, 0x1b,
  0x42, 0xaa, 0xff, 0xb7, 0x83, 0xf0, 0xff, 0xff, 0x36, 0x37, 0x02, 0x00,
  0x41, 0xc0, 0xb0, 0x1b, 0x42, 0x80, 0xfe, 0xb7, 0x83, 0xd0, 0xea, 0xff,
  0x36, 0x37, 0x02, 0x00, 0x41, 0xb8, 0xb0, 0x1b, 0x42, 0xaa, 0xb7, 0xb7,
  0x83, 0xf0, 0xff, 0xf6, 0x36, 0x37, 0x02, 0x00, 0x41, 0xb0, 0xb0, 0x1b,
  0x42, 0x80, 0xb6, 0xb7, 0x83, 0xd0, 0xea, 0xf6, 0x36, 0x37, 0x02, 0x00,
  0x41, 0xa8, 0xb0, 0x1b, 0x42, 0xaa, 0xed, 0xb6, 0x83, 0xf0, 0xdf, 0xed,
  0x36, 0x37, 0x02, 0x00, 0x41, 0xa0, 0xb0, 0x1b, 0x42, 0x80, 0xec, 0xb6,
  0x83, 0xd0, 0xca, 0xed, 0x36, 0x37, 0x02, 0x00, 0x41, 0x98, 0xb0, 0x1b,
  0x42, 0xaa, 0xa5, 0xb6, 0x83, 0xf0, 0xdf, 0xe4, 0x36, 0x37, 0x02, 0x00,
  0x41, 0x90, 0xb0, 0x1b, 0x42, 0x80, 0xa4, 0xb6, 0x83, 0xd0, 0xca, 0xe4,
  0x36, 0x37, 0x02, 0x00, 0x41, 0x88, 0xb0, 0x1b, 0x42, 0xaa, 0xdb, 0xb5,
  0x83, 0xf0, 0xbf, 0xdb, 0x36, 0x37, 0x02, 0x00, 0x41, 0x80, 0xb0, 0x1b,
  0x42, 0x80, 0xda, 0xb5, 0x83, 0xd0, 0xaa, 0xdb, 0x36, 0x37, 0x02, 0x00,
  0x41, 0xf8, 0xaf, 0x1b, 0x42, 0xaa, 0x93, 0xb5, 0x83, 0xf0, 0xbf, 0xd2,
  0x36, 0x37, 0x02, 0x00, 0x41, 0xf0, 0xaf, 0x1b, 0x42, 0x80, 0x92, 0xb5,
  0x83, 0xd0, 0xaa, 0xd2, 0x36, 0x37, 0x02, 0x00, 0x41, 0xe8, 0xaf, 0x1b,
  0x42, 0xaa, 0xc9, 0xb4, 0x83, 0xf0, 0x9f, 0xc9, 0x36, 0x37, 0x02, 0x00,
  0x41, 0xe0, 0xaf, 0x1b, 0x42, 0x80, 0xc8, 0xb4, 0x83, 0xd0, 0x8a, 0xc9,
  0x36, 0x37, 0x02, 0x00, 0x41, 0xd8, 0xaf, 0x1b, 0x42, 0xaa, 0x81, 0xb4,
  0x83, 0xf0, 0x9f, 0xc0, 0x36, 0x37, 0x02, 0x00, 0x41, 0xd0, 0xaf, 0x1b,
  0x42, 0x80, 0x80, 0xb4, 0x83, 0xd0, 0x8a, 0xc0, 0x36, 0x37, 0x02, 0x00,
  0x41, 0xc8, 0xaf, 0x1b, 0x42, 0xaa, 0xff, 0xa7, 0x82, 0xf0, 0xff, 0xff,
  0x24, 0x37, 0x02, 0x00, 0x41, 0xc0, 0xaf, 0x1b, 0x42, 0x80, 0xfe, 0xa7,
  0x82, 0xd0, 0xea, 0xff, 0x24, 0x37, 0x02, 0x00, 0x41, 0xb8, 0xaf, 0x1b,
  0x42, 0xaa, 0xb7, 0xa7, 0x82, 0xf0, 0xff, 0xf6, 0x24, 0x37, 0x02, 0x00,
  0x41, 0xb0, 0xaf, 0x1b, 0x42, 0x80, 0xb6, 0xa7, 0x82, 0xd0, 0xea, 0xf6,
  0x24, 0x37, 0x02, 0x00, 0x41, 0xa8, 0xaf, 0x1b, 0x42, 0xaa, 0xed, 0xa6,
  0x82, 0xf0, 0xdf, 0xed, 0x24, 0x37, 0x02, 0x00, 0x41, 0xa0, 0xaf, 0x1b,
  0x42, 0x80, 0xec, 0xa6, 0x82, 0xd0, 0xca, 0xed, 0x24, 0x37, 0x02, 0x00,
  0x41, 0x98, 0xaf, 0x1b, 0x42, 0xaa, 0xa5, 0xa6, 0x82, 0xf0, 0xdf, 0xe4,
  0x24, 0x37, 0x02, 0x00, 0x41, 0x90, 0xaf, 0x1b, 0x42, 0x80, 0xa4, 0xa6,
  0x82, 0xd0, 0xca, 0xe4, 0x24, 0x37, 0x02, 0x00, 0x41, 0x88, 0xaf, 0x1b,
  0x42, 0xaa, 0xdb, 0xa5, 0x82, 0xf0, 0xbf, 0xdb, 0x24, 0x37, 0x02, 0x00,
  0x41, 0x80, 0xaf, 0x1b, 0x42, 0x80, 0xda, 0xa5, 0x82, 0xd0, 0xaa, 0xdb,
  0x24, 0x37, 0x02, 0x00, 0x41, 0xf8, 0xae, 0x1b, 0x42, 0xaa, 0x93, 0xa5,
  0x82, 0xf0, 0xbf, 0xd2, 0x24, 0x37, 0x02, 0x00, 0x41, 0xf0, 0xae, 0x1b,
  0x42, 0x80, 0x92, 0xa5, 0x82, 0xd0, 0xaa, 0xd2, 0x24, 0x37, 0x02, 0x00,
  0x41, 0xe8, 0xae, 0x1b, 0x42, 0xaa, 0xc9, 0xa4, 0x82, 0xf0, 0x9f, 0xc9,
  0x24, 0x37, 0x02, 0x00, 0x41, 0xe0, 0xae, 0x1b, 0x42, 0x80, 0xc8, 0xa4,
  0x82, 0xd0, 0x8a, 0xc9, 0x24, 0x37, 0x02, 0x00, 0x41, 0xd8, 0xae, 0x1b,
  0x42, 0xaa, 0x81, 0xa4, 0x82, 0xf0, 0x9f, 0xc0, 0x24, 0x37, 0x02, 0x00,
  0x41, 0xd0, 0xae, 0x1b, 0x42, 0x80, 0x80, 0xa4, 0x82, 0xd0, 0x8a, 0xc0,
  0x24, 0x37, 0x02, 0x00, 0x41, 0xc8, 0xae, 0x1b, 0x42, 0xaa, 0xff, 0x93,
  0x81, 0xf0, 0xff, 0xbf, 0x12, 0x37, 0x02, 0x00, 0x41, 0xc0, 0xae, 0x1b,
  0x42, 0x80, 0xfe, 0x93, 0x81, 0xd0, 0xea, 0xbf, 0x12, 0x37, 0x02, 0x00,
  0x41, 0xb8, 0xae, 0x1b, 0x42, 0xaa, 0xb7, 0x93, 0x81, 0xf0, 0xff, 0xb6,
  0x12, 0x37, 0x02, 0x00, 0x41, 0xb0, 0xae, 0x1b, 0x42, 0x80, 0xb6, 0x93,
  0x81, 0xd0, 0xea, 0xb6, 0x12, 0x37, 0x02, 0x00, 0x41, 0xa8, 0xae, 0x1b,
  0x42, 0xaa, 0xed, 0x92, 0x81, 0xf0, 0xdf, 0xad, 0x12, 0x37, 0x02, 0x00,
  0x41, 0xa0, 0xae, 0x1b, 0x42, 0x80, 0xec, 0x92, 0x81, 0xd0, 0xca, 0xad,
  0x12, 0x37, 0x02, 0x00, 0x41, 0x98, 0xae, 0x1b, 0x42, 0xaa, 0xa5, 0x92,
  0x81, 0xf0, 0xdf, 0xa4, 0x12, 0x37, 0x02, 0x00, 0x41, 0x90, 0xae, 0x1b,
  0x42, 0x80, 0xa4, 0x92, 0x81, 0xd0, 0xca, 0xa4, 0x12, 0x37, 0x02, 0x00,
  0x41, 0x88, 0xae, 0x1b, 0x42, 0xaa, 0xdb, 0x91, 0x81, 0xf0, 0xbf, 0x9b,
  0x12, 0x37, 0x02, 0x00, 0x41, 0x80, 0xae, 0x1b, 0x42, 0x80, 0xda, 0x91,
  0x81, 0xd0, 0xaa, 0x9b, 0x12, 0x37, 0x02, 0x00, 0x41, 0xf8, 0xad, 0x1b,
  0x42, 0xaa, 0x93, 0x91, 0x81, 0xf0, 0xbf, 0x92, 0x12, 0x37, 0x02, 0x00,
  0x41, 0xf0, 0xad, 0x1b, 0x42, 0x80, 0x92, 0x91, 0x81, 0xd0, 0xaa, 0x92,
  0x12, 0x37, 0x02, 0x00, 0x41, 0xe8, 0xad, 0x1b, 0x42, 0xaa, 0xc9, 0x90,
  0x81, 0xf0, 0x9f, 0x89, 0x12, 0x37, 0x02, 0x00, 0x41, 0xe0, 0xad, 0x1b,
  0x42, 0x80, 0xc8, 0x90, 0x81, 0xd0, 0x8a, 0x89, 0x12, 0x37, 0x02, 0x00,
  0x41, 0xd8, 0xad, 0x1b, 0x42, 0xaa, 0x81, 0x90, 0x81, 0xf0, 0x9f, 0x80,
  0x12, 0x37, 0x02, 0x00, 0x41, 0xd0, 0xad, 0x1b, 0x42, 0x80, 0x80, 0x90,
  0x81, 0xd0, 0x8a, 0x80, 0x12, 0x37, 0x02, 0x00, 0x41, 0xc8, 0xad, 0x1b,
  0x42, 0xaa, 0xff, 0x83, 0x80, 0xf0, 0xff, 0x3f, 0x37, 0x02, 0x00, 0x41,
  0xc0, 0xad, 0x1b, 0x42, 0x80, 0xfe, 0x83, 0x80, 0xd0, 0xea, 0x3f, 0x37,
  0x02, 0x00, 0x41, 0xb8, 0xad, 0x1b, 0x42, 0xaa, 0xb7, 0x83, 0x80, 0xf0,
  0xff, 0x36, 0x37, 0x02, 0x00, 0x41, 0xb0, 0xad, 0x1b, 0x42, 0x80, 0xb6,
  0x83, 0x80, 0xd0, 0xea, 0x36, 0x37, 0x02, 0x00, 0x41, 0xa8, 0xad, 0x1b,
  0x42, 0xaa, 0xed, 0x82, 0x80, 0xf0, 0xdf, 0x2d, 0x37, 0x02, 0x00, 0x41,
  0xa0, 0xad, 0x1b, 0x42, 0x80, 0xec, 0x82, 0x80, 0xd0, 0xca, 0x2d, 0x37,
  0x02, 0x00, 0x41, 0x98, 0xad, 0x1b, 0x42, 0xaa, 0xa5, 0x82, 0x80, 0xf0,
  0xdf, 0x24, 0x37, 0x02, 0x00, 0x41, 0x90, 0xad, 0x1b, 0x42, 0x80, 0xa4,
  0x82, 0x80, 0xd0, 0xca, 0x24, 0x37, 0x02, 0x00, 0x41, 0x88, 0xad, 0x1b,
  0x42, 0xaa, 0xdb, 0x81, 0x80, 0xf0, 0xbf, 0x1b, 0x37, 0x02, 0x00, 0x41,
  0x80, 0xad, 0x1b, 0x42, 0x80, 0xda, 0x81, 0x80, 0xd0, 0xaa, 0x1b, 0x37,
  0x02, 0x00, 0x41, 0xf8, 0xac, 0x1b, 0x42, 0xaa, 0x93, 0x81, 0x80, 0xf0,
  0xbf, 0x12, 0x37, 0x02, 0x00, 0x41, 0xf0, 0xac, 0x1b, 0x42, 0x80, 0x92,
  0x81, 0x80, 0xd0, 0xaa, 0x12, 0x37, 0x02, 0x00, 0x41, 0xe8, 0xac, 0x1b,
  0x42, 0xaa, 0xc9, 0x80, 0x80, 0xf0, 0x9f, 0x09, 0x37, 0x02, 0x00, 0x41,
  0xe0, 0xac, 0x1b, 0x42, 0x80, 0xc8, 0x80, 0x80, 0xd0, 0x8a, 0x09, 0x37,
  0x02, 0x00, 0x41, 0xd8, 0xac, 0x1b, 0x42, 0xaa, 0x81, 0x80, 0x80, 0xf0,
  0x1f, 0x37, 0x02, 0x00, 0x41, 0xd0, 0xac, 0x1b, 0x42, 0x80, 0x80, 0x80,
  0x80, 0xd0, 0x0a, 0x37, 0x02, 0x00, 0x0b, 0x8f, 0x34, 0x01, 0x12, 0x7f,
  0x23, 0x00, 0x41, 0x80, 0x01, 0x6b, 0x22, 0x0d, 0x24, 0x00, 0x20, 0x02,
  0x41, 0x07, 0x6a, 0x41, 0x03, 0x76, 0x22, 0x0e, 0x20, 0x04, 0x41, 0x03,
  0x6a, 0x41, 0xfc, 0xff, 0x03, 0x71, 0x22, 0x0f, 0x6c, 0x22, 0x09, 0x20,
  0x05, 0x6c, 0x22, 0x0b, 0x41, 0xb4, 0x08, 0x41, 0x34, 0x20, 0x02, 0x41,
  0x08, 0x46, 0x1b, 0x22, 0x10, 0x6a, 0x10, 0x27, 0x22, 0x0a, 0x41, 0x00,
  0x3a, 0x00, 0x30, 0x20, 0x0a, 0x42, 0x00, 0x37, 0x02, 0x14, 0x20, 0x0a,
  0x20, 0x0b, 0x36, 0x02, 0x0c, 0x20, 0x0a, 0x20, 0x09, 0x36, 0x02, 0x08,
  0x20, 0x0a, 0x41, 0x01, 0x3a, 0x00, 0x05, 0x20, 0x0a, 0x20, 0x02, 0x3a,
  0x00, 0x04, 0x20, 0x0a, 0x20, 0x05, 0x3b, 0x01, 0x02, 0x20, 0x0a, 0x20,
  0x0f, 0x3b, 0x01, 0x00, 0x20, 0x0a, 0x20, 0x0a, 0x20, 0x10, 0x6a, 0x36,
  0x02, 0x10, 0x20, 0x00, 0x20, 0x0a, 0x36, 0x02, 0x00, 0x20, 0x04, 0x41,
  0x00, 0x20, 0x05, 0x1b, 0x45, 0x04, 0x40, 0x10, 0x00, 0x21, 0x0a, 0x20,
  0x0d, 0x20, 0x02, 0x36, 0x02, 0x68, 0x20, 0x0d, 0x20, 0x07, 0x36, 0x02,
  0x64, 0x20, 0x0d, 0x20, 0x05, 0x36, 0x02, 0x60, 0x20, 0x0d, 0x20, 0x04,
  0x36, 0x02, 0x5c, 0x20, 0x0d, 0x20, 0x0a, 0x36, 0x02, 0x58, 0x20, 0x0d,
  0x20, 0x0a, 0x36, 0x02, 0x54, 0x20, 0x0d, 0x41, 0xf3, 0xe3, 0x03, 0x36,
  0x02, 0x50, 0x41, 0x03, 0x41, 0xb0, 0xd5, 0x00, 0x20, 0x0d, 0x41, 0xd0,
  0x00, 0x6a, 0x10, 0x22, 0x0b, 0x02, 0x40, 0x20, 0x02, 0x41, 0x08, 0x47,
  0x0d, 0x00, 0x20, 0x03, 0x04, 0x40, 0x20, 0x00, 0x28, 0x02, 0x00, 0x41,
  0x34, 0x6a, 0x20, 0x03, 0x41, 0x80, 0x08, 0x10, 0x24, 0x1a, 0x0c, 0x01,
  0x0b, 0x02, 0x40, 0x41, 0xd0, 0xb4, 0x1b, 0x2d, 0x00, 0x00, 0x41, 0x01,
  0x71, 0x0d, 0x00, 0x41, 0xd0, 0xb4, 0x1b, 0x10, 0x30, 0x45, 0x0d, 0x00,
  0x10, 0x64, 0x41, 0xd0, 0xb4, 0x1b, 0x10, 0x2f, 0x0b, 0x20, 0x00, 0x28,
  0x02, 0x00, 0x41, 0x34, 0x6a, 0x41, 0xd0, 0xac, 0x1b, 0x41, 0x80, 0x08,
  0x10, 0x24, 0x1a, 0x0b, 0x20, 0x00, 0x28, 0x02, 0x00, 0x21, 0x03, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x08, 0x04,
  0x40, 0x20, 0x07, 0x10, 0x27, 0x20, 0x06, 0x20, 0x07, 0x10, 0x24, 0x21,
  0x08, 0x20, 0x03, 0x20, 0x07, 0x36, 0x02, 0x18, 0x20, 0x03, 0x20, 0x08,
  0x36, 0x02, 0x14, 0x20, 0x00, 0x28, 0x02, 0x00, 0x22, 0x08, 0x2d, 0x00,
  0x04, 0x21, 0x0f, 0x20, 0x08, 0x28, 0x02, 0x08, 0x21, 0x03, 0x20, 0x08,
  0x2f, 0x01, 0x02, 0x21, 0x10, 0x20, 0x08, 0x2f, 0x01, 0x00, 0x21, 0x0b,
  0x20, 0x08, 0x28, 0x02, 0x10, 0x21, 0x0e, 0x02, 0x40, 0x20, 0x01, 0x41,
  0x20, 0x47, 0x0d, 0x00, 0x02, 0x40, 0x20, 0x02, 0x41, 0x18, 0x6b, 0x0e,
  0x09, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x0b,
  0x20, 0x0d, 0x20, 0x06, 0x41, 0x01, 0x6a, 0x22, 0x02, 0x36, 0x02, 0x7c,
  0x20, 0x06, 0x2d, 0x00, 0x00, 0x21, 0x03, 0x20, 0x0d, 0x20, 0x07, 0x41,
  0x01, 0x6b, 0x22, 0x06, 0x36, 0x02, 0x78, 0x41, 0x01, 0x20, 0x03, 0x41,
  0x07, 0x71, 0x20, 0x03, 0x41, 0x08, 0x71, 0x1b, 0x04, 0x40, 0x10, 0x00,
  0x21, 0x01, 0x20, 0x0d, 0x41, 0x00, 0x36, 0x02, 0x4c, 0x20, 0x0d, 0x20,
  0x01, 0x36, 0x02, 0x48, 0x20, 0x0d, 0x20, 0x01, 0x36, 0x02, 0x44, 0x20,
  0x0d, 0x41, 0xc2, 0xea, 0x03, 0x36, 0x02, 0x40, 0x41, 0x06, 0x41, 0xba,
  0xac, 0x03, 0x20, 0x0d, 0x41, 0x40, 0x6b, 0x10, 0x22, 0x0c, 0x06, 0x0b,
  0x20, 0x03, 0x41, 0x20, 0x71, 0x21, 0x07, 0x20, 0x0b, 0x20, 0x10, 0x6c,
  0x22, 0x0a, 0x41, 0x03, 0x6c, 0x10, 0x27, 0x22, 0x01, 0x20, 0x0a, 0x41,
  0x01, 0x74, 0x6a, 0x21, 0x08, 0x20, 0x01, 0x20, 0x0a, 0x6a, 0x21, 0x09,
  0x02, 0x40, 0x20, 0x03, 0x41, 0x10, 0x71, 0x04, 0x40, 0x20, 0x07, 0x45,
  0x04, 0x40, 0x20, 0x04, 0x20, 0x05, 0x20, 0x0d, 0x41, 0xfc, 0x00, 0x6a,
  0x20, 0x0d, 0x41, 0xf8, 0x00, 0x6a, 0x20, 0x0b, 0x20, 0x01, 0x10, 0x7f,
  0x0b, 0x20, 0x04, 0x20, 0x05, 0x20, 0x0d, 0x41, 0xfc, 0x00, 0x6a, 0x22,
  0x02, 0x20, 0x0d, 0x41, 0xf8, 0x00, 0x6a, 0x22, 0x03, 0x20, 0x0b, 0x20,
  0x01, 0x10, 0x7f, 0x20, 0x04, 0x20, 0x05, 0x20, 0x02, 0x20, 0x03, 0x20,
  0x0b, 0x20, 0x09, 0x10, 0x7f, 0x20, 0x04, 0x20, 0x05, 0x20, 0x02, 0x20,
  0x03, 0x20, 0x0b, 0x20, 0x08, 0x10, 0x7f, 0x0c, 0x01, 0x0b, 0x20, 0x07,
  0x45, 0x04, 0x40, 0x20, 0x0d, 0x20, 0x02, 0x20, 0x04, 0x20, 0x05, 0x6c,
  0x22, 0x03, 0x6a, 0x22, 0x02, 0x36, 0x02, 0x7c, 0x20, 0x06, 0x20, 0x03,
  0x6b, 0x21, 0x06, 0x0b, 0x20, 0x05, 0x04, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x20, 0x05, 0x41, 0x01, 0x46, 0x04, 0x40, 0x20, 0x01, 0x21, 0x0a, 0x0c,
  0x01, 0x0b, 0x02, 0x40, 0x20, 0x05, 0x41, 0xfe, 0xff, 0x03, 0x71, 0x22,
  0x07, 0x41, 0x02, 0x6b, 0x22, 0x03, 0x41, 0x02, 0x71, 0x04, 0x40, 0x20,
  0x01, 0x21, 0x0a, 0x0c, 0x01, 0x0b, 0x20, 0x01, 0x20, 0x02, 0x20, 0x04,
  0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02,
  0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x21, 0x0a, 0x20, 0x06, 0x20,
  0x04, 0x41, 0x01, 0x74, 0x6b, 0x21, 0x06, 0x20, 0x02, 0x20, 0x04, 0x6a,
  0x21, 0x02, 0x20, 0x03, 0x21, 0x07, 0x0b, 0x20, 0x03, 0x41, 0xff, 0xff,
  0x03, 0x71, 0x04, 0x40, 0x20, 0x04, 0x41, 0x02, 0x74, 0x21, 0x03, 0x03,
  0x40, 0x20, 0x06, 0x20, 0x03, 0x6b, 0x21, 0x06, 0x20, 0x0a, 0x20, 0x02,
  0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a,
  0x22, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20,
  0x04, 0x6a, 0x22, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20,
  0x02, 0x20, 0x04, 0x6a, 0x22, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b,
  0x6a, 0x21, 0x0a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x07,
  0x41, 0x04, 0x6b, 0x22, 0x07, 0x41, 0xff, 0xff, 0x03, 0x71, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x05, 0x41, 0x01, 0x71, 0x45, 0x0d, 0x01, 0x0b, 0x20,
  0x0a, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24, 0x1a, 0x20, 0x02, 0x20, 0x04,
  0x6a, 0x21, 0x02, 0x20, 0x06, 0x20, 0x04, 0x6b, 0x21, 0x06, 0x0b, 0x20,
  0x05, 0x41, 0x01, 0x20, 0x05, 0x41, 0x01, 0x4b, 0x1b, 0x22, 0x13, 0x41,
  0x01, 0x71, 0x21, 0x0c, 0x02, 0x40, 0x02, 0x40, 0x20, 0x05, 0x41, 0x02,
  0x49, 0x04, 0x40, 0x20, 0x09, 0x21, 0x0a, 0x0c, 0x01, 0x0b, 0x02, 0x40,
  0x20, 0x13, 0x41, 0xfe, 0xff, 0x03, 0x71, 0x22, 0x07, 0x41, 0x02, 0x6b,
  0x22, 0x03, 0x41, 0x02, 0x71, 0x04, 0x40, 0x20, 0x09, 0x21, 0x0a, 0x0c,
  0x01, 0x0b, 0x20, 0x09, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b,
  0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02, 0x20, 0x04, 0x10, 0x24,
  0x20, 0x0b, 0x6a, 0x21, 0x0a, 0x20, 0x06, 0x20, 0x04, 0x41, 0x01, 0x74,
  0x6b, 0x21, 0x06, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x03,
  0x21, 0x07, 0x0b, 0x20, 0x03, 0x41, 0xff, 0xff, 0x03, 0x71, 0x04, 0x40,
  0x20, 0x04, 0x41, 0x02, 0x74, 0x21, 0x03, 0x03, 0x40, 0x20, 0x06, 0x20,
  0x03, 0x6b, 0x21, 0x06, 0x20, 0x0a, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24,
  0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02, 0x20, 0x04,
  0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02,
  0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a,
  0x22, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x21, 0x0a, 0x20,
  0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x07, 0x41, 0x04, 0x6b, 0x22,
  0x07, 0x41, 0xff, 0xff, 0x03, 0x71, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0c,
  0x45, 0x0d, 0x01, 0x0b, 0x20, 0x0a, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24,
  0x1a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x06, 0x20, 0x04,
  0x6b, 0x21, 0x06, 0x0b, 0x02, 0x40, 0x02, 0x40, 0x20, 0x05, 0x41, 0x02,
  0x49, 0x04, 0x40, 0x20, 0x08, 0x21, 0x05, 0x0c, 0x01, 0x0b, 0x02, 0x40,
  0x20, 0x13, 0x41, 0xfe, 0xff, 0x03, 0x71, 0x22, 0x0a, 0x41, 0x02, 0x6b,
  0x22, 0x03, 0x41, 0x02, 0x71, 0x04, 0x40, 0x20, 0x08, 0x21, 0x05, 0x0c,
  0x01, 0x0b, 0x20, 0x08, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b,
  0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02, 0x20, 0x04, 0x10, 0x24,
  0x20, 0x0b, 0x6a, 0x21, 0x05, 0x20, 0x06, 0x20, 0x04, 0x41, 0x01, 0x74,
  0x6b, 0x21, 0x06, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x03,
  0x21, 0x0a, 0x0b, 0x20, 0x03, 0x41, 0xff, 0xff, 0x03, 0x71, 0x04, 0x40,
  0x20, 0x04, 0x41, 0x02, 0x74, 0x21, 0x03, 0x03, 0x40, 0x20, 0x06, 0x20,
  0x03, 0x6b, 0x21, 0x06, 0x20, 0x05, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24,
  0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02, 0x20, 0x04,
  0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x22, 0x02,
  0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x6a,
  0x22, 0x02, 0x20, 0x04, 0x10, 0x24, 0x20, 0x0b, 0x6a, 0x21, 0x05, 0x20,
  0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x0a, 0x41, 0x04, 0x6b, 0x22,
  0x0a, 0x41, 0xff, 0xff, 0x03, 0x71, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0c,
  0x45, 0x0d, 0x01, 0x0b, 0x20, 0x05, 0x20, 0x02, 0x20, 0x04, 0x10, 0x24,
  0x1a, 0x20, 0x02, 0x20, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x06, 0x20, 0x04,
  0x6b, 0x21, 0x06, 0x0b, 0x20, 0x0d, 0x20, 0x02, 0x36, 0x02, 0x7c, 0x0b,
  0x20, 0x0d, 0x20, 0x06, 0x41, 0x01, 0x6b, 0x36, 0x02, 0x78, 0x0b, 0x02,
  0x40, 0x20, 0x10, 0x45, 0x0d, 0x00, 0x20, 0x0b, 0x45, 0x0d, 0x00, 0x20,
  0x0f, 0x45, 0x0d, 0x00, 0x20, 0x0f, 0x41, 0x05, 0x74, 0x41, 0xe0, 0x01,
  0x6a, 0x41, 0x08, 0x76, 0x22, 0x0a, 0x41, 0x3c, 0x71, 0x21, 0x03, 0x20,
  0x0a, 0x41, 0x03, 0x71, 0x21, 0x05, 0x41, 0x00, 0x21, 0x13, 0x20, 0x0a,
  0x41, 0x01, 0x6b, 0x41, 0x03, 0x49, 0x21, 0x0c, 0x20, 0x01, 0x21, 0x07,
  0x03, 0x40, 0x41, 0x00, 0x21, 0x0f, 0x03, 0x40, 0x20, 0x08, 0x2d, 0x00,
  0x00, 0x22, 0x11, 0x20, 0x07, 0x2d, 0x00, 0x00, 0x41, 0x10, 0x74, 0x20,
  0x09, 0x2d, 0x00, 0x00, 0x41, 0x08, 0x74, 0x72, 0x72, 0x41, 0x80, 0x80,
  0x80, 0x78, 0x72, 0x21, 0x06, 0x41, 0x00, 0x21, 0x04, 0x20, 0x03, 0x21,
  0x02, 0x20, 0x0c, 0x45, 0x04, 0x40, 0x03, 0x40, 0x20, 0x04, 0x20, 0x0e,
  0x6a, 0x20, 0x11, 0x3a, 0x00, 0x00, 0x20, 0x0e, 0x20, 0x04, 0x41, 0x01,
  0x72, 0x22, 0x12, 0x6a, 0x20, 0x06, 0x20, 0x12, 0x41, 0x03, 0x74, 0x76,
  0x3a, 0x00, 0x00, 0x20, 0x0e, 0x20, 0x04, 0x41, 0x02, 0x72, 0x22, 0x12,
  0x6a, 0x20, 0x06, 0x20, 0x12, 0x41, 0x03, 0x74, 0x76, 0x3a, 0x00, 0x00,
  0x20, 0x0e, 0x20, 0x04, 0x41, 0x03, 0x72, 0x22, 0x12, 0x6a, 0x20, 0x06,
  0x20, 0x12, 0x41, 0x03, 0x74, 0x76, 0x3a, 0x00, 0x00, 0x20, 0x04, 0x41,
  0x04, 0x6a, 0x21, 0x04, 0x20, 0x02, 0x41, 0x04, 0x6b, 0x22, 0x02, 0x0d,
  0x00, 0x0b, 0x0b, 0x20, 0x05, 0x22, 0x02, 0x04, 0x40, 0x03, 0x40, 0x20,
  0x04, 0x20, 0x0e, 0x6a, 0x20, 0x06, 0x20, 0x04, 0x41, 0x03, 0x74, 0x76,
  0x3a, 0x00, 0x00, 0x20, 0x04, 0x41, 0x01, 0x6a, 0x21, 0x04, 0x20, 0x02,
  0x41, 0x01, 0x6b, 0x22, 0x02, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0a, 0x20,
  0x0e, 0x6a, 0x21, 0x0e, 0x20, 0x08, 0x41, 0x01, 0x6a, 0x21, 0x08, 0x20,
  0x09, 0x41, 0x01, 0x6a, 0x21, 0x09, 0x20, 0x07, 0x41, 0x01, 0x6a, 0x21,
  0x07, 0x20, 0x0f, 0x41, 0x01, 0x6a, 0x22, 0x0f, 0x41, 0xff, 0xff, 0x03,
  0x71, 0x20, 0x0b, 0x49, 0x0d, 0x00, 0x0b, 0x20, 0x13, 0x41, 0x01, 0x6a,
  0x22, 0x13, 0x41, 0xff, 0xff, 0x03, 0x71, 0x20, 0x10, 0x49, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x01, 0x10, 0x23, 0x0c, 0x05, 0x0b, 0x02, 0x40, 0x20,
  0x0f, 0x41, 0x08, 0x6b, 0x0e, 0x09, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x04, 0x03, 0x02, 0x0b, 0x20, 0x0b, 0x20, 0x04, 0x6b, 0x21, 0x13,
  0x41, 0x00, 0x20, 0x03, 0x6b, 0x21, 0x14, 0x20, 0x03, 0x20, 0x0e, 0x6a,
  0x21, 0x16, 0x20, 0x06, 0x20, 0x07, 0x6a, 0x21, 0x17, 0x20, 0x0e, 0x20,
  0x03, 0x20, 0x10, 0x6c, 0x6a, 0x21, 0x10, 0x20, 0x0e, 0x21, 0x02, 0x41,
  0x7f, 0x21, 0x0b, 0x41, 0xff, 0x01, 0x21, 0x0f, 0x41, 0x00, 0x21, 0x0a,
  0x03, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x06, 0x20, 0x17, 0x49, 0x04,
  0x40, 0x20, 0x06, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x02, 0x40, 0x02, 0x7f,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x22, 0x09, 0x41, 0x04, 0x76,
  0x41, 0x04, 0x6b, 0x0e, 0x0c, 0x03, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x04, 0x02, 0x01, 0x00, 0x05, 0x0b, 0x41, 0x09, 0x21, 0x03, 0x41,
  0x08, 0x21, 0x05, 0x41, 0x0a, 0x21, 0x07, 0x41, 0x0d, 0x21, 0x08, 0x20,
  0x09, 0x41, 0xf8, 0x01, 0x6b, 0x0e, 0x07, 0x0d, 0x0b, 0x0c, 0x07, 0x07,
  0x06, 0x05, 0x07, 0x0b, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22, 0x05, 0x45,
  0x04, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x10, 0x6a, 0x21, 0x05,
  0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0b, 0x20, 0x05, 0x41, 0x01,
  0x74, 0x0c, 0x0d, 0x0b, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22, 0x03, 0x45,
  0x0d, 0x0f, 0x20, 0x03, 0x41, 0x03, 0x74, 0x0c, 0x10, 0x0b, 0x20, 0x09,
  0x41, 0x1f, 0x71, 0x22, 0x03, 0x45, 0x0d, 0x06, 0x20, 0x03, 0x41, 0x03,
  0x74, 0x21, 0x05, 0x41, 0x02, 0x21, 0x03, 0x0c, 0x07, 0x0b, 0x41, 0x06,
  0x21, 0x03, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22, 0x05, 0x0d, 0x11, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x10, 0x6a, 0x21, 0x05, 0x0c, 0x11, 0x0b, 0x20, 0x09, 0x41, 0x05, 0x76,
  0x21, 0x03, 0x20, 0x09, 0x41, 0x1f, 0x71, 0x22, 0x05, 0x0d, 0x03, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x20, 0x6a, 0x21, 0x05, 0x0c, 0x03, 0x0b, 0x41, 0x0e, 0x21, 0x08, 0x0b,
  0x41, 0x01, 0x21, 0x05, 0x20, 0x08, 0x21, 0x03, 0x0c, 0x0f, 0x0b, 0x20,
  0x06, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x21,
  0x03, 0x20, 0x06, 0x2f, 0x00, 0x01, 0x21, 0x05, 0x0b, 0x20, 0x03, 0x22,
  0x07, 0x22, 0x08, 0x41, 0x02, 0x6b, 0x0e, 0x09, 0x01, 0x07, 0x0d, 0x0d,
  0x0c, 0x0a, 0x06, 0x02, 0x03, 0x0d, 0x0b, 0x41, 0x02, 0x21, 0x03, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x01, 0x6a, 0x21, 0x05, 0x0b, 0x41, 0x01, 0x21, 0x0c, 0x20, 0x01, 0x2d,
  0x00, 0x00, 0x21, 0x11, 0x41, 0x02, 0x21, 0x08, 0x20, 0x01, 0x41, 0x01,
  0x6a, 0x21, 0x01, 0x0c, 0x0b, 0x0b, 0x41, 0x03, 0x21, 0x11, 0x41, 0x01,
  0x21, 0x0c, 0x41, 0x09, 0x21, 0x08, 0x0c, 0x0a, 0x0b, 0x41, 0x05, 0x21,
  0x11, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x0a, 0x21, 0x08, 0x20, 0x07, 0x21,
  0x03, 0x0c, 0x09, 0x0b, 0x20, 0x06, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x20,
  0x06, 0x2d, 0x00, 0x02, 0x41, 0x09, 0x74, 0x20, 0x06, 0x2d, 0x00, 0x01,
  0x41, 0x01, 0x74, 0x72, 0x0b, 0x21, 0x05, 0x41, 0x08, 0x21, 0x03, 0x0b,
  0x20, 0x01, 0x2d, 0x00, 0x01, 0x21, 0x15, 0x20, 0x01, 0x2d, 0x00, 0x00,
  0x21, 0x18, 0x41, 0x00, 0x21, 0x12, 0x41, 0x08, 0x21, 0x08, 0x20, 0x01,
  0x41, 0x02, 0x6a, 0x21, 0x01, 0x0c, 0x06, 0x0b, 0x20, 0x01, 0x2d, 0x00,
  0x00, 0x21, 0x15, 0x41, 0x03, 0x21, 0x08, 0x20, 0x01, 0x41, 0x01, 0x6a,
  0x21, 0x01, 0x0c, 0x05, 0x0b, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01,
  0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x01, 0x6a, 0x0b, 0x21, 0x05, 0x41,
  0x07, 0x21, 0x03, 0x0b, 0x20, 0x01, 0x2d, 0x00, 0x01, 0x21, 0x11, 0x20,
  0x01, 0x2d, 0x00, 0x00, 0x21, 0x0b, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x07,
  0x21, 0x08, 0x20, 0x01, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0c, 0x02, 0x0b,
  0x0c, 0x07, 0x0b, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x21, 0x0b, 0x41, 0x06,
  0x21, 0x08, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x0b, 0x02, 0x40,
  0x20, 0x03, 0x20, 0x0f, 0x72, 0x41, 0xff, 0x01, 0x71, 0x0d, 0x00, 0x20,
  0x02, 0x20, 0x16, 0x46, 0x0d, 0x00, 0x20, 0x02, 0x20, 0x0e, 0x20, 0x02,
  0x20, 0x14, 0x6a, 0x22, 0x06, 0x4d, 0x04, 0x7f, 0x20, 0x06, 0x2d, 0x00,
  0x00, 0x05, 0x41, 0x00, 0x0b, 0x20, 0x0b, 0x73, 0x3a, 0x00, 0x00, 0x20,
  0x02, 0x41, 0x01, 0x6a, 0x21, 0x02, 0x20, 0x05, 0x41, 0x01, 0x6b, 0x21,
  0x05, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a, 0x41, 0xff, 0xff, 0x03,
  0x71, 0x20, 0x04, 0x47, 0x0d, 0x00, 0x41, 0x00, 0x21, 0x0a, 0x20, 0x02,
  0x41, 0x00, 0x20, 0x13, 0x10, 0x29, 0x20, 0x13, 0x6a, 0x21, 0x02, 0x0b,
  0x02, 0x40, 0x20, 0x05, 0x45, 0x0d, 0x00, 0x20, 0x02, 0x20, 0x10, 0x49,
  0x04, 0x40, 0x03, 0x40, 0x41, 0x00, 0x21, 0x09, 0x20, 0x0e, 0x20, 0x02,
  0x20, 0x14, 0x6a, 0x22, 0x06, 0x4d, 0x04, 0x40, 0x20, 0x06, 0x2d, 0x00,
  0x00, 0x21, 0x09, 0x0b, 0x02, 0x40, 0x20, 0x08, 0x41, 0x0f, 0x46, 0x0d,
  0x00, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x08, 0x41,
  0x01, 0x6b, 0x0e, 0x0e, 0x04, 0x00, 0x05, 0x02, 0x0a, 0x04, 0x00, 0x06,
  0x01, 0x01, 0x0a, 0x0a, 0x07, 0x08, 0x03, 0x0b, 0x20, 0x0c, 0x41, 0x80,
  0x02, 0x47, 0x0d, 0x00, 0x41, 0x01, 0x21, 0x0c, 0x20, 0x01, 0x2d, 0x00,
  0x00, 0x21, 0x11, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x0b, 0x20,
  0x02, 0x20, 0x0b, 0x41, 0x00, 0x20, 0x0c, 0x20, 0x11, 0x71, 0x1b, 0x20,
  0x09, 0x73, 0x3a, 0x00, 0x00, 0x20, 0x0c, 0x41, 0x01, 0x74, 0x21, 0x0c,
  0x0c, 0x08, 0x0b, 0x20, 0x02, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x3a, 0x00,
  0x00, 0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x0c, 0x07, 0x0b, 0x20,
  0x02, 0x20, 0x09, 0x3a, 0x00, 0x00, 0x0c, 0x06, 0x0b, 0x20, 0x02, 0x20,
  0x09, 0x20, 0x0b, 0x73, 0x3a, 0x00, 0x00, 0x0c, 0x05, 0x0b, 0x20, 0x02,
  0x20, 0x15, 0x3a, 0x00, 0x00, 0x0c, 0x04, 0x0b, 0x20, 0x12, 0x45, 0x0d,
  0x02, 0x20, 0x02, 0x20, 0x15, 0x3a, 0x00, 0x00, 0x41, 0x00, 0x21, 0x12,
  0x0c, 0x03, 0x0b, 0x20, 0x02, 0x41, 0xff, 0x01, 0x3a, 0x00, 0x00, 0x0c,
  0x02, 0x0b, 0x20, 0x02, 0x41, 0x00, 0x3a, 0x00, 0x00, 0x0c, 0x01, 0x0b,
  0x20, 0x02, 0x20, 0x18, 0x3a, 0x00, 0x00, 0x41, 0x01, 0x21, 0x12, 0x0b,
  0x20, 0x02, 0x41, 0x01, 0x6a, 0x21, 0x02, 0x20, 0x05, 0x41, 0x01, 0x6b,
  0x21, 0x05, 0x20, 0x04, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a, 0x41,
  0xff, 0xff, 0x03, 0x71, 0x46, 0x04, 0x40, 0x41, 0x00, 0x21, 0x0a, 0x20,
  0x02, 0x41, 0x00, 0x20, 0x13, 0x10, 0x29, 0x20, 0x13, 0x6a, 0x21, 0x02,
  0x0b, 0x20, 0x05, 0x45, 0x0d, 0x02, 0x20, 0x02, 0x20, 0x10, 0x49, 0x0d,
  0x00, 0x0b, 0x0b, 0x20, 0x0d, 0x10, 0x00, 0x22, 0x00, 0x36, 0x02, 0x18,
  0x20, 0x0d, 0x20, 0x00, 0x36, 0x02, 0x14, 0x20, 0x0d, 0x41, 0xd4, 0xf7,
  0x03, 0x36, 0x02, 0x10, 0x41, 0x04, 0x41, 0xcc, 0xac, 0x04, 0x20, 0x0d,
  0x41, 0x10, 0x6a, 0x10, 0x22, 0x0c, 0x07, 0x0b, 0x20, 0x01, 0x21, 0x06,
  0x20, 0x03, 0x21, 0x0f, 0x20, 0x02, 0x20, 0x10, 0x47, 0x0d, 0x00, 0x0b,
  0x0c, 0x04, 0x0b, 0x20, 0x03, 0x2f, 0x01, 0x02, 0x22, 0x05, 0x45, 0x0d,
  0x03, 0x20, 0x03, 0x28, 0x02, 0x08, 0x22, 0x07, 0x20, 0x04, 0x20, 0x0e,
  0x6c, 0x22, 0x01, 0x6b, 0x21, 0x04, 0x20, 0x03, 0x28, 0x02, 0x10, 0x21,
  0x02, 0x20, 0x05, 0x41, 0x01, 0x47, 0x04, 0x40, 0x20, 0x05, 0x41, 0x01,
  0x71, 0x21, 0x03, 0x20, 0x05, 0x41, 0xfe, 0xff, 0x03, 0x71, 0x21, 0x0a,
  0x03, 0x40, 0x20, 0x02, 0x20, 0x06, 0x20, 0x01, 0x10, 0x24, 0x22, 0x02,
  0x20, 0x01, 0x6a, 0x41, 0x00, 0x20, 0x04, 0x10, 0x29, 0x1a, 0x20, 0x02,
  0x20, 0x07, 0x6a, 0x20, 0x01, 0x20, 0x06, 0x6a, 0x22, 0x05, 0x20, 0x01,
  0x10, 0x24, 0x22, 0x02, 0x20, 0x01, 0x6a, 0x41, 0x00, 0x20, 0x04, 0x10,
  0x29, 0x1a, 0x20, 0x02, 0x20, 0x07, 0x6a, 0x21, 0x02, 0x20, 0x01, 0x20,
  0x05, 0x6a, 0x21, 0x06, 0x20, 0x0a, 0x41, 0x02, 0x6b, 0x22, 0x0a, 0x41,
  0xff, 0xff, 0x03, 0x71, 0x0d, 0x00, 0x0b, 0x20, 0x03, 0x45, 0x0d, 0x04,
  0x0b, 0x20, 0x02, 0x20, 0x06, 0x20, 0x01, 0x10, 0x24, 0x20, 0x01, 0x6a,
  0x41, 0x00, 0x20, 0x04, 0x10, 0x29, 0x1a, 0x0c, 0x03, 0x0b, 0x41, 0x00,
  0x20, 0x03, 0x6b, 0x21, 0x16, 0x20, 0x03, 0x20, 0x0e, 0x6a, 0x21, 0x17,
  0x20, 0x06, 0x20, 0x07, 0x6a, 0x21, 0x18, 0x20, 0x0b, 0x20, 0x04, 0x6b,
  0x41, 0x03, 0x6c, 0x21, 0x14, 0x20, 0x0e, 0x20, 0x03, 0x20, 0x10, 0x6c,
  0x6a, 0x21, 0x10, 0x20, 0x0e, 0x21, 0x02, 0x41, 0x7f, 0x21, 0x0b, 0x41,
  0x00, 0x21, 0x07, 0x41, 0xff, 0x01, 0x21, 0x0f, 0x41, 0x00, 0x21, 0x0a,
  0x03, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x06, 0x20, 0x18, 0x49, 0x04,
  0x40, 0x20, 0x06, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x02, 0x40, 0x02, 0x7f,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x22, 0x08, 0x41, 0x04, 0x76,
  0x41, 0x04, 0x6b, 0x0e, 0x0c, 0x03, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x04, 0x02, 0x01, 0x00, 0x05, 0x0b, 0x41, 0x09, 0x21, 0x03, 0x41,
  0x08, 0x21, 0x05, 0x41, 0x0a, 0x21, 0x13, 0x41, 0x0d, 0x21, 0x09, 0x20,
  0x08, 0x41, 0xf8, 0x01, 0x6b, 0x0e, 0x07, 0x0d, 0x0b, 0x0c, 0x07, 0x07,
  0x06, 0x05, 0x07, 0x0b, 0x20, 0x08, 0x41, 0x0f, 0x71, 0x22, 0x05, 0x45,
  0x04, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x10, 0x6a, 0x21, 0x05,
  0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0b, 0x20, 0x05, 0x41, 0x01,
  0x74, 0x0c, 0x0d, 0x0b, 0x20, 0x08, 0x41, 0x0f, 0x71, 0x22, 0x03, 0x45,
  0x0d, 0x0f, 0x20, 0x03, 0x41, 0x03, 0x74, 0x0c, 0x10, 0x0b, 0x20, 0x08,
  0x41, 0x1f, 0x71, 0x22, 0x03, 0x45, 0x0d, 0x06, 0x20, 0x03, 0x41, 0x03,
  0x74, 0x21, 0x05, 0x41, 0x02, 0x21, 0x03, 0x0c, 0x07, 0x0b, 0x41, 0x06,
  0x21, 0x03, 0x20, 0x08, 0x41, 0x0f, 0x71, 0x22, 0x05, 0x0d, 0x11, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x10, 0x6a, 0x21, 0x05, 0x0c, 0x11, 0x0b, 0x20, 0x08, 0x41, 0x05, 0x76,
  0x21, 0x03, 0x20, 0x08, 0x41, 0x1f, 0x71, 0x22, 0x05, 0x0d, 0x03, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x20, 0x6a, 0x21, 0x05, 0x0c, 0x03, 0x0b, 0x41, 0x0e, 0x21, 0x09, 0x0b,
  0x41, 0x01, 0x21, 0x05, 0x20, 0x09, 0x21, 0x03, 0x0c, 0x0f, 0x0b, 0x20,
  0x06, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x20, 0x08, 0x41, 0x0f, 0x71, 0x21,
  0x03, 0x20, 0x06, 0x2f, 0x00, 0x01, 0x21, 0x05, 0x0b, 0x20, 0x03, 0x22,
  0x13, 0x22, 0x09, 0x41, 0x02, 0x6b, 0x0e, 0x09, 0x01, 0x07, 0x0d, 0x0d,
  0x0c, 0x0a, 0x06, 0x02, 0x03, 0x0d, 0x0b, 0x41, 0x02, 0x21, 0x03, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x01, 0x6a, 0x21, 0x05, 0x0b, 0x41, 0x01, 0x21, 0x0c, 0x20, 0x01, 0x2d,
  0x00, 0x00, 0x21, 0x11, 0x41, 0x02, 0x21, 0x09, 0x20, 0x01, 0x41, 0x01,
  0x6a, 0x21, 0x01, 0x0c, 0x0b, 0x0b, 0x41, 0x03, 0x21, 0x11, 0x41, 0x01,
  0x21, 0x0c, 0x41, 0x09, 0x21, 0x09, 0x0c, 0x0a, 0x0b, 0x41, 0x05, 0x21,
  0x11, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x0a, 0x21, 0x09, 0x20, 0x13, 0x21,
  0x03, 0x0c, 0x09, 0x0b, 0x20, 0x06, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x20,
  0x06, 0x2d, 0x00, 0x02, 0x41, 0x09, 0x74, 0x20, 0x06, 0x2d, 0x00, 0x01,
  0x41, 0x01, 0x74, 0x72, 0x0b, 0x21, 0x05, 0x41, 0x08, 0x21, 0x03, 0x0b,
  0x20, 0x01, 0x2f, 0x00, 0x03, 0x20, 0x01, 0x2d, 0x00, 0x05, 0x41, 0x10,
  0x74, 0x72, 0x21, 0x12, 0x20, 0x01, 0x2f, 0x00, 0x00, 0x20, 0x01, 0x2d,
  0x00, 0x02, 0x41, 0x10, 0x74, 0x72, 0x21, 0x15, 0x41, 0x00, 0x21, 0x07,
  0x41, 0x08, 0x21, 0x09, 0x20, 0x01, 0x41, 0x06, 0x6a, 0x21, 0x01, 0x0c,
  0x06, 0x0b, 0x41, 0x03, 0x21, 0x09, 0x20, 0x01, 0x2f, 0x00, 0x00, 0x20,
  0x01, 0x2d, 0x00, 0x02, 0x41, 0x10, 0x74, 0x72, 0x21, 0x12, 0x20, 0x01,
  0x41, 0x03, 0x6a, 0x21, 0x01, 0x0c, 0x05, 0x0b, 0x20, 0x06, 0x41, 0x02,
  0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x01, 0x6a, 0x0b,
  0x21, 0x05, 0x41, 0x07, 0x21, 0x03, 0x0b, 0x20, 0x01, 0x2f, 0x00, 0x00,
  0x20, 0x01, 0x2d, 0x00, 0x02, 0x41, 0x10, 0x74, 0x72, 0x21, 0x0b, 0x20,
  0x01, 0x2d, 0x00, 0x03, 0x21, 0x11, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x07,
  0x21, 0x09, 0x20, 0x01, 0x41, 0x04, 0x6a, 0x21, 0x01, 0x0c, 0x02, 0x0b,
  0x0c, 0x05, 0x0b, 0x20, 0x01, 0x2f, 0x00, 0x00, 0x20, 0x01, 0x2d, 0x00,
  0x02, 0x41, 0x10, 0x74, 0x72, 0x21, 0x0b, 0x41, 0x06, 0x21, 0x09, 0x20,
  0x01, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x0b, 0x02, 0x40, 0x20, 0x03, 0x20,
  0x0f, 0x72, 0x41, 0xff, 0x01, 0x71, 0x0d, 0x00, 0x20, 0x02, 0x20, 0x17,
  0x46, 0x0d, 0x00, 0x20, 0x02, 0x20, 0x0e, 0x20, 0x02, 0x20, 0x16, 0x6a,
  0x22, 0x06, 0x4d, 0x04, 0x7f, 0x20, 0x06, 0x2f, 0x00, 0x00, 0x20, 0x06,
  0x2d, 0x00, 0x02, 0x41, 0x10, 0x74, 0x72, 0x05, 0x41, 0x00, 0x0b, 0x20,
  0x0b, 0x73, 0x22, 0x06, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x20, 0x06, 0x41,
  0x10, 0x76, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x06, 0x41, 0x08, 0x76,
  0x3a, 0x00, 0x01, 0x20, 0x02, 0x41, 0x03, 0x6a, 0x21, 0x02, 0x20, 0x05,
  0x41, 0x01, 0x6b, 0x21, 0x05, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a,
  0x41, 0xff, 0xff, 0x03, 0x71, 0x20, 0x04, 0x47, 0x0d, 0x00, 0x41, 0x00,
  0x21, 0x0a, 0x20, 0x02, 0x41, 0x00, 0x20, 0x14, 0x10, 0x29, 0x20, 0x14,
  0x6a, 0x21, 0x02, 0x0b, 0x02, 0x40, 0x20, 0x05, 0x45, 0x0d, 0x00, 0x20,
  0x02, 0x20, 0x10, 0x49, 0x04, 0x40, 0x20, 0x15, 0x41, 0x10, 0x76, 0x21,
  0x19, 0x20, 0x15, 0x41, 0x08, 0x76, 0x21, 0x1a, 0x20, 0x12, 0x41, 0x10,
  0x76, 0x21, 0x06, 0x20, 0x12, 0x41, 0x08, 0x76, 0x21, 0x0f, 0x03, 0x40,
  0x41, 0x00, 0x21, 0x08, 0x20, 0x0e, 0x20, 0x02, 0x20, 0x16, 0x6a, 0x22,
  0x13, 0x4d, 0x04, 0x40, 0x20, 0x13, 0x2f, 0x00, 0x00, 0x20, 0x13, 0x2d,
  0x00, 0x02, 0x41, 0x10, 0x74, 0x72, 0x21, 0x08, 0x0b, 0x02, 0x40, 0x20,
  0x09, 0x41, 0x0f, 0x46, 0x0d, 0x00, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x20, 0x09, 0x41, 0x01, 0x6b, 0x0e, 0x0e, 0x04, 0x05, 0x02, 0x07, 0x09,
  0x04, 0x05, 0x08, 0x06, 0x06, 0x09, 0x09, 0x01, 0x00, 0x03, 0x0b, 0x20,
  0x02, 0x41, 0x00, 0x3b, 0x00, 0x00, 0x20, 0x02, 0x41, 0x00, 0x3a, 0x00,
  0x02, 0x0c, 0x08, 0x0b, 0x20, 0x02, 0x41, 0xff, 0x01, 0x3a, 0x00, 0x02,
  0x20, 0x02, 0x41, 0xff, 0xff, 0x03, 0x3b, 0x00, 0x00, 0x0c, 0x07, 0x0b,
  0x20, 0x02, 0x20, 0x06, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x0f, 0x3a,
  0x00, 0x01, 0x20, 0x02, 0x20, 0x12, 0x3a, 0x00, 0x00, 0x0c, 0x06, 0x0b,
  0x20, 0x02, 0x20, 0x08, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x20, 0x08, 0x41,
  0x10, 0x76, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x08, 0x41, 0x08, 0x76,
  0x3a, 0x00, 0x01, 0x0c, 0x05, 0x0b, 0x20, 0x02, 0x20, 0x08, 0x20, 0x0b,
  0x73, 0x22, 0x08, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x20, 0x08, 0x41, 0x10,
  0x76, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x08, 0x41, 0x08, 0x76, 0x3a,
  0x00, 0x01, 0x0c, 0x04, 0x0b, 0x20, 0x0c, 0x41, 0x80, 0x02, 0x47, 0x0d,
  0x00, 0x41, 0x01, 0x21, 0x0c, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x21, 0x11,
  0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x0b,
  0x41, 0x00, 0x20, 0x0c, 0x20, 0x11, 0x71, 0x1b, 0x20, 0x08, 0x73, 0x22,
  0x08, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x20, 0x08, 0x41, 0x10, 0x76, 0x3a,
  0x00, 0x02, 0x20, 0x02, 0x20, 0x08, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x01,
  0x20, 0x0c, 0x41, 0x01, 0x74, 0x21, 0x0c, 0x0c, 0x02, 0x0b, 0x20, 0x01,
  0x2f, 0x00, 0x00, 0x21, 0x08, 0x20, 0x02, 0x20, 0x01, 0x2d, 0x00, 0x02,
  0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x08, 0x3b, 0x00, 0x00, 0x20, 0x01,
  0x41, 0x03, 0x6a, 0x21, 0x01, 0x0c, 0x01, 0x0b, 0x20, 0x07, 0x04, 0x40,
  0x20, 0x02, 0x20, 0x06, 0x3a, 0x00, 0x02, 0x20, 0x02, 0x20, 0x0f, 0x3a,
  0x00, 0x01, 0x20, 0x02, 0x20, 0x12, 0x3a, 0x00, 0x00, 0x41, 0x00, 0x21,
  0x07, 0x0c, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x19, 0x3a, 0x00, 0x02, 0x20,
  0x02, 0x20, 0x1a, 0x3a, 0x00, 0x01, 0x20, 0x02, 0x20, 0x15, 0x3a, 0x00,
  0x00, 0x41, 0x01, 0x21, 0x07, 0x0b, 0x20, 0x02, 0x41, 0x03, 0x6a, 0x21,
  0x02, 0x20, 0x05, 0x41, 0x01, 0x6b, 0x21, 0x05, 0x20, 0x04, 0x20, 0x0a,
  0x41, 0x01, 0x6a, 0x22, 0x0a, 0x41, 0xff, 0xff, 0x03, 0x71, 0x46, 0x04,
  0x40, 0x41, 0x00, 0x21, 0x0a, 0x20, 0x02, 0x41, 0x00, 0x20, 0x14, 0x10,
  0x29, 0x20, 0x14, 0x6a, 0x21, 0x02, 0x0b, 0x20, 0x05, 0x45, 0x0d, 0x02,
  0x20, 0x02, 0x20, 0x10, 0x49, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0d, 0x10,
  0x00, 0x22, 0x00, 0x36, 0x02, 0x08, 0x20, 0x0d, 0x20, 0x00, 0x36, 0x02,
  0x04, 0x20, 0x0d, 0x41, 0xd4, 0xf7, 0x03, 0x36, 0x02, 0x00, 0x41, 0x04,
  0x41, 0xcc, 0xac, 0x04, 0x20, 0x0d, 0x10, 0x22, 0x0c, 0x05, 0x0b, 0x20,
  0x01, 0x21, 0x06, 0x20, 0x03, 0x21, 0x0f, 0x20, 0x02, 0x20, 0x10, 0x47,
  0x0d, 0x00, 0x0b, 0x0c, 0x02, 0x0b, 0x41, 0x00, 0x20, 0x03, 0x6b, 0x21,
  0x16, 0x20, 0x03, 0x20, 0x0e, 0x6a, 0x21, 0x17, 0x20, 0x06, 0x20, 0x07,
  0x6a, 0x21, 0x18, 0x20, 0x0b, 0x20, 0x04, 0x6b, 0x41, 0x01, 0x74, 0x21,
  0x14, 0x20, 0x0e, 0x20, 0x03, 0x20, 0x10, 0x6c, 0x6a, 0x21, 0x10, 0x20,
  0x0e, 0x21, 0x02, 0x41, 0x7f, 0x21, 0x0b, 0x41, 0xff, 0x01, 0x21, 0x0f,
  0x41, 0x00, 0x21, 0x0a, 0x03, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x06,
  0x20, 0x18, 0x49, 0x04, 0x40, 0x20, 0x06, 0x41, 0x01, 0x6a, 0x21, 0x01,
  0x02, 0x40, 0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x22,
  0x09, 0x41, 0x04, 0x76, 0x41, 0x04, 0x6b, 0x0e, 0x0c, 0x03, 0x03, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x02, 0x01, 0x00, 0x05, 0x0b, 0x41,
  0x09, 0x21, 0x03, 0x41, 0x08, 0x21, 0x05, 0x41, 0x0a, 0x21, 0x07, 0x41,
  0x0d, 0x21, 0x08, 0x20, 0x09, 0x41, 0xf8, 0x01, 0x6b, 0x0e, 0x07, 0x0d,
  0x0b, 0x0c, 0x07, 0x07, 0x06, 0x05, 0x07, 0x0b, 0x20, 0x09, 0x41, 0x0f,
  0x71, 0x22, 0x05, 0x45, 0x04, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41,
  0x10, 0x6a, 0x21, 0x05, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0b,
  0x20, 0x05, 0x41, 0x01, 0x74, 0x0c, 0x0d, 0x0b, 0x20, 0x09, 0x41, 0x0f,
  0x71, 0x22, 0x03, 0x45, 0x0d, 0x0f, 0x20, 0x03, 0x41, 0x03, 0x74, 0x0c,
  0x10, 0x0b, 0x20, 0x09, 0x41, 0x1f, 0x71, 0x22, 0x03, 0x45, 0x0d, 0x06,
  0x20, 0x03, 0x41, 0x03, 0x74, 0x21, 0x05, 0x41, 0x02, 0x21, 0x03, 0x0c,
  0x07, 0x0b, 0x41, 0x06, 0x21, 0x03, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22,
  0x05, 0x0d, 0x11, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06,
  0x2d, 0x00, 0x01, 0x41, 0x10, 0x6a, 0x21, 0x05, 0x0c, 0x11, 0x0b, 0x20,
  0x09, 0x41, 0x05, 0x76, 0x21, 0x03, 0x20, 0x09, 0x41, 0x1f, 0x71, 0x22,
  0x05, 0x0d, 0x03, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06,
  0x2d, 0x00, 0x01, 0x41, 0x20, 0x6a, 0x21, 0x05, 0x0c, 0x03, 0x0b, 0x41,
  0x0e, 0x21, 0x08, 0x0b, 0x41, 0x01, 0x21, 0x05, 0x20, 0x08, 0x21, 0x03,
  0x0c, 0x0f, 0x0b, 0x20, 0x06, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x20, 0x09,
  0x41, 0x0f, 0x71, 0x21, 0x03, 0x20, 0x06, 0x2f, 0x00, 0x01, 0x21, 0x05,
  0x0b, 0x20, 0x03, 0x22, 0x07, 0x22, 0x08, 0x41, 0x02, 0x6b, 0x0e, 0x09,
  0x01, 0x07, 0x0d, 0x0d, 0x0c, 0x0a, 0x06, 0x02, 0x03, 0x0d, 0x0b, 0x41,
  0x02, 0x21, 0x03, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06,
  0x2d, 0x00, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x05, 0x0b, 0x41, 0x01, 0x21,
  0x0c, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x21, 0x11, 0x41, 0x02, 0x21, 0x08,
  0x20, 0x01, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x0c, 0x0b, 0x0b, 0x41, 0x03,
  0x21, 0x11, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x09, 0x21, 0x08, 0x0c, 0x0a,
  0x0b, 0x41, 0x05, 0x21, 0x11, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x0a, 0x21,
  0x08, 0x20, 0x07, 0x21, 0x03, 0x0c, 0x09, 0x0b, 0x20, 0x06, 0x41, 0x03,
  0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x02, 0x41, 0x09, 0x74, 0x20,
  0x06, 0x2d, 0x00, 0x01, 0x41, 0x01, 0x74, 0x72, 0x0b, 0x21, 0x05, 0x41,
  0x08, 0x21, 0x03, 0x0b, 0x20, 0x01, 0x2f, 0x00, 0x02, 0x21, 0x12, 0x20,
  0x01, 0x2f, 0x00, 0x00, 0x21, 0x13, 0x41, 0x00, 0x21, 0x15, 0x41, 0x08,
  0x21, 0x08, 0x20, 0x01, 0x41, 0x04, 0x6a, 0x21, 0x01, 0x0c, 0x06, 0x0b,
  0x20, 0x01, 0x2f, 0x00, 0x00, 0x21, 0x12, 0x41, 0x03, 0x21, 0x08, 0x20,
  0x01, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0c, 0x05, 0x0b, 0x20, 0x06, 0x41,
  0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x01, 0x6a,
  0x0b, 0x21, 0x05, 0x41, 0x07, 0x21, 0x03, 0x0b, 0x20, 0x01, 0x2d, 0x00,
  0x02, 0x21, 0x11, 0x20, 0x01, 0x2f, 0x00, 0x00, 0x21, 0x0b, 0x41, 0x01,
  0x21, 0x0c, 0x41, 0x07, 0x21, 0x08, 0x20, 0x01, 0x41, 0x03, 0x6a, 0x21,
  0x01, 0x0c, 0x02, 0x0b, 0x0c, 0x04, 0x0b, 0x20, 0x01, 0x2f, 0x00, 0x00,
  0x21, 0x0b, 0x41, 0x06, 0x21, 0x08, 0x20, 0x01, 0x41, 0x02, 0x6a, 0x21,
  0x01, 0x0b, 0x02, 0x40, 0x20, 0x03, 0x20, 0x0f, 0x72, 0x41, 0xff, 0x01,
  0x71, 0x0d, 0x00, 0x20, 0x02, 0x20, 0x17, 0x46, 0x0d, 0x00, 0x20, 0x02,
  0x20, 0x0e, 0x20, 0x02, 0x20, 0x16, 0x6a, 0x22, 0x06, 0x4d, 0x04, 0x7f,
  0x20, 0x06, 0x2f, 0x00, 0x00, 0x05, 0x41, 0x00, 0x0b, 0x20, 0x0b, 0x73,
  0x3b, 0x00, 0x00, 0x20, 0x02, 0x41, 0x02, 0x6a, 0x21, 0x02, 0x20, 0x05,
  0x41, 0x01, 0x6b, 0x21, 0x05, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a,
  0x41, 0xff, 0xff, 0x03, 0x71, 0x20, 0x04, 0x47, 0x0d, 0x00, 0x41, 0x00,
  0x21, 0x0a, 0x20, 0x02, 0x41, 0x00, 0x20, 0x14, 0x10, 0x29, 0x20, 0x14,
  0x6a, 0x21, 0x02, 0x0b, 0x02, 0x40, 0x20, 0x05, 0x45, 0x0d, 0x00, 0x20,
  0x02, 0x20, 0x10, 0x49, 0x04, 0x40, 0x20, 0x13, 0x41, 0x08, 0x76, 0x21,
  0x07, 0x20, 0x12, 0x41, 0x08, 0x76, 0x21, 0x06, 0x03, 0x40, 0x41, 0x00,
  0x21, 0x09, 0x20, 0x0e, 0x20, 0x02, 0x20, 0x16, 0x6a, 0x22, 0x0f, 0x4d,
  0x04, 0x40, 0x20, 0x0f, 0x2f, 0x00, 0x00, 0x21, 0x09, 0x0b, 0x02, 0x40,
  0x20, 0x08, 0x41, 0x0f, 0x46, 0x0d, 0x00, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x20, 0x08, 0x41, 0x01, 0x6b, 0x0e, 0x0e, 0x04, 0x05, 0x02, 0x07,
  0x09, 0x04, 0x05, 0x08, 0x06, 0x06, 0x09, 0x09, 0x01, 0x00, 0x03, 0x0b,
  0x20, 0x02, 0x41, 0x00, 0x3b, 0x00, 0x00, 0x0c, 0x08, 0x0b, 0x20, 0x02,
  0x41, 0xff, 0xff, 0x03, 0x3b, 0x00, 0x00, 0x0c, 0x07, 0x0b, 0x20, 0x02,
  0x20, 0x06, 0x3a, 0x00, 0x01, 0x20, 0x02, 0x20, 0x12, 0x3a, 0x00, 0x00,
  0x0c, 0x06, 0x0b, 0x20, 0x02, 0x20, 0x09, 0x3b, 0x00, 0x00, 0x0c, 0x05,
  0x0b, 0x20, 0x02, 0x20, 0x09, 0x20, 0x0b, 0x73, 0x3b, 0x00, 0x00, 0x0c,
  0x04, 0x0b, 0x20, 0x0c, 0x41, 0x80, 0x02, 0x47, 0x0d, 0x00, 0x41, 0x01,
  0x21, 0x0c, 0x20, 0x01, 0x2d, 0x00, 0x00, 0x21, 0x11, 0x20, 0x01, 0x41,
  0x01, 0x6a, 0x21, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x0b, 0x41, 0x00, 0x20,
  0x0c, 0x20, 0x11, 0x71, 0x1b, 0x20, 0x09, 0x73, 0x3b, 0x00, 0x00, 0x20,
  0x0c, 0x41, 0x01, 0x74, 0x21, 0x0c, 0x0c, 0x02, 0x0b, 0x20, 0x02, 0x20,
  0x01, 0x2f, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x20, 0x01, 0x41, 0x02, 0x6a,
  0x21, 0x01, 0x0c, 0x01, 0x0b, 0x20, 0x15, 0x04, 0x40, 0x20, 0x02, 0x20,
  0x06, 0x3a, 0x00, 0x01, 0x20, 0x02, 0x20, 0x12, 0x3a, 0x00, 0x00, 0x41,
  0x00, 0x21, 0x15, 0x0c, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x07, 0x3a, 0x00,
  0x01, 0x20, 0x02, 0x20, 0x13, 0x3a, 0x00, 0x00, 0x41, 0x01, 0x21, 0x15,
  0x0b, 0x20, 0x02, 0x41, 0x02, 0x6a, 0x21, 0x02, 0x20, 0x05, 0x41, 0x01,
  0x6b, 0x21, 0x05, 0x20, 0x04, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a,
  0x41, 0xff, 0xff, 0x03, 0x71, 0x46, 0x04, 0x40, 0x41, 0x00, 0x21, 0x0a,
  0x20, 0x02, 0x41, 0x00, 0x20, 0x14, 0x10, 0x29, 0x20, 0x14, 0x6a, 0x21,
  0x02, 0x0b, 0x20, 0x05, 0x45, 0x0d, 0x02, 0x20, 0x02, 0x20, 0x10, 0x49,
  0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0d, 0x10, 0x00, 0x22, 0x00, 0x36, 0x02,
  0x38, 0x20, 0x0d, 0x20, 0x00, 0x36, 0x02, 0x34, 0x20, 0x0d, 0x41, 0xd4,
  0xf7, 0x03, 0x36, 0x02, 0x30, 0x41, 0x04, 0x41, 0xcc, 0xac, 0x04, 0x20,
  0x0d, 0x41, 0x30, 0x6a, 0x10, 0x22, 0x0c, 0x04, 0x0b, 0x20, 0x01, 0x21,
  0x06, 0x20, 0x03, 0x21, 0x0f, 0x20, 0x02, 0x20, 0x10, 0x47, 0x0d, 0x00,
  0x0b, 0x0c, 0x01, 0x0b, 0x41, 0x00, 0x20, 0x03, 0x6b, 0x21, 0x16, 0x20,
  0x03, 0x20, 0x0e, 0x6a, 0x21, 0x17, 0x20, 0x06, 0x20, 0x07, 0x6a, 0x21,
  0x18, 0x20, 0x0b, 0x20, 0x04, 0x6b, 0x41, 0x01, 0x74, 0x21, 0x14, 0x20,
  0x0e, 0x20, 0x03, 0x20, 0x10, 0x6c, 0x6a, 0x21, 0x10, 0x20, 0x0e, 0x21,
  0x02, 0x41, 0x7f, 0x21, 0x0b, 0x41, 0xff, 0x01, 0x21, 0x0f, 0x41, 0x00,
  0x21, 0x0a, 0x03, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x06, 0x20, 0x18,
  0x49, 0x04, 0x40, 0x20, 0x06, 0x41, 0x01, 0x6a, 0x21, 0x01, 0x02, 0x40,
  0x02, 0x7f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x7f, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x00, 0x22, 0x09, 0x41,
  0x04, 0x76, 0x41, 0x04, 0x6b, 0x0e, 0x0c, 0x03, 0x03, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x04, 0x02, 0x01, 0x00, 0x05, 0x0b, 0x41, 0x09, 0x21,
  0x03, 0x41, 0x08, 0x21, 0x05, 0x41, 0x0a, 0x21, 0x07, 0x41, 0x0d, 0x21,
  0x08, 0x20, 0x09, 0x41, 0xf8, 0x01, 0x6b, 0x0e, 0x07, 0x0d, 0x0b, 0x0c,
  0x07, 0x07, 0x06, 0x05, 0x07, 0x0b, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22,
  0x05, 0x45, 0x04, 0x40, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x10, 0x6a,
  0x21, 0x05, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0b, 0x20, 0x05,
  0x41, 0x01, 0x74, 0x0c, 0x0d, 0x0b, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22,
  0x03, 0x45, 0x0d, 0x0f, 0x20, 0x03, 0x41, 0x03, 0x74, 0x0c, 0x10, 0x0b,
  0x20, 0x09, 0x41, 0x1f, 0x71, 0x22, 0x03, 0x45, 0x0d, 0x06, 0x20, 0x03,
  0x41, 0x03, 0x74, 0x21, 0x05, 0x41, 0x02, 0x21, 0x03, 0x0c, 0x07, 0x0b,
  0x41, 0x06, 0x21, 0x03, 0x20, 0x09, 0x41, 0x0f, 0x71, 0x22, 0x05, 0x0d,
  0x11, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00,
  0x01, 0x41, 0x10, 0x6a, 0x21, 0x05, 0x0c, 0x11, 0x0b, 0x20, 0x09, 0x41,
  0x05, 0x76, 0x21, 0x03, 0x20, 0x09, 0x41, 0x1f, 0x71, 0x22, 0x05, 0x0d,
  0x03, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00,
  0x01, 0x41, 0x20, 0x6a, 0x21, 0x05, 0x0c, 0x03, 0x0b, 0x41, 0x0e, 0x21,
  0x08, 0x0b, 0x41, 0x01, 0x21, 0x05, 0x20, 0x08, 0x21, 0x03, 0x0c, 0x0f,
  0x0b, 0x20, 0x06, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x20, 0x09, 0x41, 0x0f,
  0x71, 0x21, 0x03, 0x20, 0x06, 0x2f, 0x00, 0x01, 0x21, 0x05, 0x0b, 0x20,
  0x03, 0x22, 0x07, 0x22, 0x08, 0x41, 0x02, 0x6b, 0x0e, 0x09, 0x01, 0x07,
  0x0d, 0x0d, 0x0c, 0x0a, 0x06, 0x02, 0x03, 0x0d, 0x0b, 0x41, 0x02, 0x21,
  0x03, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x20, 0x06, 0x2d, 0x00,
  0x01, 0x41, 0x01, 0x6a, 0x21, 0x05, 0x0b, 0x41, 0x01, 0x21, 0x0c, 0x20,
  0x01, 0x2d, 0x00, 0x00, 0x21, 0x11, 0x41, 0x02, 0x21, 0x08, 0x20, 0x01,
  0x41, 0x01, 0x6a, 0x21, 0x01, 0x0c, 0x0b, 0x0b, 0x41, 0x03, 0x21, 0x11,
  0x41, 0x01, 0x21, 0x0c, 0x41, 0x09, 0x21, 0x08, 0x0c, 0x0a, 0x0b, 0x41,
  0x05, 0x21, 0x11, 0x41, 0x01, 0x21, 0x0c, 0x41, 0x0a, 0x21, 0x08, 0x20,
  0x07, 0x21, 0x03, 0x0c, 0x09, 0x0b, 0x20, 0x06, 0x41, 0x03, 0x6a, 0x21,
  0x01, 0x20, 0x06, 0x2d, 0x00, 0x02, 0x41, 0x09, 0x74, 0x20, 0x06, 0x2d,
  0x00, 0x01, 0x41, 0x01, 0x74, 0x72, 0x0b, 0x21, 0x05, 0x41, 0x08, 0x21,
  0x03, 0x0b, 0x20, 0x01, 0x2f, 0x00, 0x02, 0x21, 0x12, 0x20, 0x01, 0x2f,
  0x00, 0x00, 0x21, 0x13, 0x41, 0x00, 0x21, 0x15, 0x41, 0x08, 0x21, 0x08,
  0x20, 0x01, 0x41, 0x04, 0x6a, 0x21, 0x01, 0x0c, 0x06, 0x0b, 0x20, 0x01,
  0x2f, 0x00, 0x00, 0x21, 0x12, 0x41, 0x03, 0x21, 0x08, 0x20, 0x01, 0x41,
  0x02, 0x6a, 0x21, 0x01, 0x0c, 0x05, 0x0b, 0x20, 0x06, 0x41, 0x02, 0x6a,
  0x21, 0x01, 0x20, 0x06, 0x2d, 0x00, 0x01, 0x41, 0x01, 0x6a, 0x0b, 0x21,
  0x05, 0x41, 0x07, 0x21, 0x03, 0x0b, 0x20, 0x01, 0x2d, 0x00, 0x02, 0x21,
  0x11, 0x20, 0x01, 0x2f, 0x00, 0x00, 0x21, 0x0b, 0x41, 0x01, 0x21, 0x0c,
  0x41, 0x07, 0x21, 0x08, 0x20, 0x01, 0x41, 0x03, 0x6a, 0x21, 0x01, 0x0c,
  0x02, 0x0b, 0x0c, 0x03, 0x0b, 0x20, 0x01, 0x2f, 0x00, 0x00, 0x21, 0x0b,
  0x41, 0x06, 0x21, 0x08, 0x20, 0x01, 0x41, 0x02, 0x6a, 0x21, 0x01, 0x0b,
  0x02, 0x40, 0x20, 0x03, 0x20, 0x0f, 0x72, 0x41, 0xff, 0x01, 0x71, 0x0d,
  0x00, 0x20, 0x02, 0x20, 0x17, 0x46, 0x0d, 0x00, 0x20, 0x02, 0x20, 0x0e,
  0x20, 0x02, 0x20, 0x16, 0x6a, 0x22, 0x06, 0x4d, 0x04, 0x7f, 0x20, 0x06,
  0x2f, 0x00, 0x00, 0x05, 0x41, 0x00, 0x0b, 0x20, 0x0b, 0x73, 0x3b, 0x00,
  0x00, 0x20, 0x02, 0x41, 0x02, 0x6a, 0x21, 0x02, 0x20, 0x05, 0x41, 0x01,
  0x6b, 0x21, 0x05, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a, 0x41, 0xff,
  0xff, 0x03, 0x71, 0x20, 0x04, 0x47, 0x0d, 0x00, 0x41, 0x00, 0x21, 0x0a,
  0x20, 0x02, 0x41, 0x00, 0x20, 0x14, 0x10, 0x29, 0x20, 0x14, 0x6a, 0x21,
  0x02, 0x0b, 0x02, 0x40, 0x20, 0x05, 0x45, 0x0d, 0x00, 0x20, 0x02, 0x20,
  0x10, 0x49, 0x04, 0x40, 0x20, 0x13, 0x41, 0x08, 0x76, 0x21, 0x07, 0x20,
  0x12, 0x41, 0x08, 0x76, 0x21, 0x06, 0x03, 0x40, 0x41, 0x00, 0x21, 0x09,
  0x20, 0x0e, 0x20, 0x02, 0x20, 0x16, 0x6a, 0x22, 0x0f, 0x4d, 0x04, 0x40,
  0x20, 0x0f, 0x2f, 0x00, 0x00, 0x21, 0x09, 0x0b, 0x02, 0x40, 0x20, 0x08,
  0x41, 0x0f, 0x46, 0x0d, 0x00, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20,
  0x08, 0x41, 0x01, 0x6b, 0x0e, 0x0e, 0x04, 0x05, 0x02, 0x07, 0x09, 0x04,
  0x05, 0x08, 0x06, 0x06, 0x09, 0x09, 0x01, 0x00, 0x03, 0x0b, 0x20, 0x02,
  0x41, 0x00, 0x3b, 0x00, 0x00, 0x0c, 0x08, 0x0b, 0x20, 0x02, 0x41, 0xff,
  0xff, 0x03, 0x3b, 0x00, 0x00, 0x0c, 0x07, 0x0b, 0x20, 0x02, 0x20, 0x06,
  0x3a, 0x00, 0x01, 0x20, 0x02, 0x20, 0x12, 0x3a, 0x00, 0x00, 0x0c, 0x06,
  0x0b, 0x20, 0x02, 0x20, 0x09, 0x3b, 0x00, 0x00, 0x0c, 0x05, 0x0b, 0x20,
  0x02, 0x20, 0x09, 0x20, 0x0b, 0x73, 0x3b, 0x00, 0x00, 0x0c, 0x04, 0x0b,
  0x20, 0x0c, 0x41, 0x80, 0x02, 0x47, 0x0d, 0x00, 0x41, 0x01, 0x21, 0x0c,
  0x20, 0x01, 0x2d, 0x00, 0x00, 0x21, 0x11, 0x20, 0x01, 0x41, 0x01, 0x6a,
  0x21, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x0b, 0x41, 0x00, 0x20, 0x0c, 0x20,
  0x11, 0x71, 0x1b, 0x20, 0x09, 0x73, 0x3b, 0x00, 0x00, 0x20, 0x0c, 0x41,
  0x01, 0x74, 0x21, 0x0c, 0x0c, 0x02, 0x0b, 0x20, 0x02, 0x20, 0x01, 0x2f,
  0x00, 0x00, 0x3b, 0x00, 0x00, 0x20, 0x01, 0x41, 0x02, 0x6a, 0x21, 0x01,
  0x0c, 0x01, 0x0b, 0x20, 0x15, 0x04, 0x40, 0x20, 0x02, 0x20, 0x06, 0x3a,
  0x00, 0x01, 0x20, 0x02, 0x20, 0x12, 0x3a, 0x00, 0x00, 0x41, 0x00, 0x21,
  0x15, 0x0c, 0x01, 0x0b, 0x20, 0x02, 0x20, 0x07, 0x3a, 0x00, 0x01, 0x20,
  0x02, 0x20, 0x13, 0x3a, 0x00, 0x00, 0x41, 0x01, 0x21, 0x15, 0x0b, 0x20,
  0x02, 0x41, 0x02, 0x6a, 0x21, 0x02, 0x20, 0x05, 0x41, 0x01, 0x6b, 0x21,
  0x05, 0x20, 0x04, 0x20, 0x0a, 0x41, 0x01, 0x6a, 0x22, 0x0a, 0x41, 0xff,
  0xff, 0x03, 0x71, 0x46, 0x04, 0x40, 0x41, 0x00, 0x21, 0x0a, 0x20, 0x02,
  0x41, 0x00, 0x20, 0x14, 0x10, 0x29, 0x20, 0x14, 0x6a, 0x21, 0x02, 0x0b,
  0x20, 0x05, 0x45, 0x0d, 0x02, 0x20, 0x02, 0x20, 0x10, 0x49, 0x0d, 0x00,
  0x0b, 0x0b, 0x20, 0x0d, 0x10, 0x00, 0x22, 0x00, 0x36, 0x02, 0x28, 0x20,
  0x0d, 0x20, 0x00, 0x36, 0x02, 0x24, 0x20, 0x0d, 0x41, 0xd4, 0xf7, 0x03,
  0x36, 0x02, 0x20, 0x41, 0x04, 0x41, 0xcc, 0xac, 0x04, 0x20, 0x0d, 0x41,
  0x20, 0x6a, 0x10, 0x22, 0x0c, 0x03, 0x0b, 0x20, 0x01, 0x21, 0x06, 0x20,
  0x03, 0x21, 0x0f, 0x20, 0x02, 0x20, 0x10, 0x47, 0x0d, 0x00, 0x0b, 0x0b,
  0x20, 0x0d, 0x41, 0x80, 0x01, 0x6a, 0x24, 0x00, 0x20, 0x00, 0x0f, 0x0b,
  0x41, 0x0c, 0x10, 0x02, 0x22, 0x00, 0x41, 0x00, 0x36, 0x02, 0x08, 0x20,
  0x00, 0x42, 0xd3, 0x8c, 0x01, 0x37, 0x02, 0x00, 0x20, 0x00, 0x41, 0xa8,
  0xf1, 0x1a, 0x41, 0x00, 0x10, 0x08, 0x00, 0x0b, 0x15, 0x01, 0x01, 0x7f,
  0x20, 0x00, 0x20, 0x01, 0x10, 0xbf, 0x01, 0x22, 0x02, 0x20, 0x00, 0x6b,
  0x20, 0x01, 0x20, 0x02, 0x1b, 0x0b, 0x0c, 0x00, 0x20, 0x00, 0x20, 0x01,
  0x20, 0x01, 0x10, 0x39, 0x10, 0x38, 0x0b, 0x83, 0x01, 0x02, 0x03, 0x7f,
  0x01, 0x7e, 0x02, 0x40, 0x20, 0x00, 0x42, 0x80, 0x80, 0x80, 0x80, 0x10,
  0x54, 0x04, 0x40, 0x20, 0x00, 0x21, 0x05, 0x0c, 0x01, 0x0b, 0x03, 0x40,
  0x20, 0x01, 0x41, 0x01, 0x6b, 0x22, 0x01, 0x20, 0x00, 0x42, 0x0a, 0x80,
  0x22, 0x05, 0x42, 0x76, 0x7e, 0x20, 0x00, 0x7c, 0xa7, 0x41, 0x30, 0x72,
  0x3a, 0x00, 0x00, 0x20, 0x00, 0x42, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x01,
  0x56, 0x21, 0x02, 0x20, 0x05, 0x21, 0x00, 0x20, 0x02, 0x0d, 0x00, 0x0b,
  0x0b, 0x20, 0x05, 0xa7, 0x22, 0x02, 0x04, 0x40, 0x03, 0x40, 0x20, 0x01,
  0x41, 0x01, 0x6b, 0x22, 0x01, 0x20, 0x02, 0x41, 0x0a, 0x6e, 0x22, 0x03,
  0x41, 0x76, 0x6c, 0x20, 0x02, 0x6a, 0x41, 0x30, 0x72, 0x3a, 0x00, 0x00,
  0x20, 0x02, 0x41, 0x09, 0x4b, 0x21, 0x04, 0x20, 0x03, 0x21, 0x02, 0x20,
  0x04, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x01, 0x0b, 0x91, 0x03, 0x01, 0x05,
  0x7f, 0x23, 0x00, 0x41, 0x20, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x20, 0x04,
  0x41, 0x0c, 0x36, 0x02, 0x18, 0x02, 0x40, 0x02, 0x40, 0x20, 0x01, 0x28,
  0x02, 0x04, 0x22, 0x06, 0x20, 0x01, 0x28, 0x02, 0x08, 0x22, 0x03, 0x6b,
  0x22, 0x05, 0x41, 0x0b, 0x4b, 0x04, 0x40, 0x20, 0x01, 0x20, 0x03, 0x41,
  0x04, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20, 0x03, 0x28, 0x00, 0x00,
  0x36, 0x02, 0x00, 0x20, 0x01, 0x20, 0x03, 0x41, 0x05, 0x6a, 0x36, 0x02,
  0x08, 0x20, 0x00, 0x20, 0x03, 0x2d, 0x00, 0x04, 0x3a, 0x00, 0x04, 0x20,
  0x01, 0x20, 0x03, 0x41, 0x06, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20,
  0x03, 0x2d, 0x00, 0x05, 0x3a, 0x00, 0x05, 0x20, 0x01, 0x20, 0x03, 0x41,
  0x08, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20, 0x03, 0x2f, 0x00, 0x06,
  0x3b, 0x01, 0x06, 0x20, 0x01, 0x20, 0x03, 0x41, 0x09, 0x6a, 0x36, 0x02,
  0x08, 0x20, 0x00, 0x20, 0x03, 0x2d, 0x00, 0x08, 0x3a, 0x00, 0x08, 0x20,
  0x01, 0x20, 0x03, 0x41, 0x0a, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20,
  0x03, 0x2d, 0x00, 0x09, 0x22, 0x07, 0x3a, 0x00, 0x09, 0x20, 0x01, 0x20,
  0x03, 0x41, 0x0c, 0x6a, 0x22, 0x05, 0x36, 0x02, 0x08, 0x20, 0x00, 0x20,
  0x03, 0x2f, 0x00, 0x0a, 0x3b, 0x01, 0x0a, 0x02, 0x40, 0x20, 0x07, 0x41,
  0x20, 0x71, 0x04, 0x40, 0x20, 0x02, 0x45, 0x0d, 0x03, 0x20, 0x04, 0x20,
  0x05, 0x36, 0x02, 0x10, 0x20, 0x04, 0x20, 0x06, 0x20, 0x05, 0x6b, 0x36,
  0x02, 0x14, 0x20, 0x02, 0x28, 0x02, 0x00, 0x28, 0x02, 0x08, 0x21, 0x03,
  0x20, 0x04, 0x20, 0x04, 0x29, 0x03, 0x10, 0x37, 0x03, 0x08, 0x20, 0x04,
  0x41, 0x18, 0x6a, 0x20, 0x02, 0x20, 0x04, 0x41, 0x08, 0x6a, 0x20, 0x07,
  0x20, 0x03, 0x11, 0x03, 0x00, 0x20, 0x04, 0x28, 0x02, 0x1c, 0x21, 0x02,
  0x20, 0x00, 0x20, 0x04, 0x28, 0x02, 0x18, 0x22, 0x05, 0x36, 0x02, 0x0c,
  0x20, 0x00, 0x20, 0x02, 0x20, 0x05, 0x6a, 0x36, 0x02, 0x10, 0x0c, 0x01,
  0x0b, 0x20, 0x00, 0x20, 0x05, 0x36, 0x02, 0x0c, 0x20, 0x00, 0x20, 0x06,
  0x36, 0x02, 0x10, 0x0b, 0x20, 0x00, 0x20, 0x05, 0x36, 0x02, 0x14, 0x20,
  0x01, 0x20, 0x01, 0x28, 0x02, 0x04, 0x36, 0x02, 0x08, 0x20, 0x04, 0x41,
  0x20, 0x6a, 0x24, 0x00, 0x20, 0x00, 0x0f, 0x0b, 0x20, 0x04, 0x20, 0x05,
  0x36, 0x02, 0x10, 0x41, 0x03, 0x41, 0x9b, 0x36, 0x20, 0x04, 0x41, 0x18,
  0x6a, 0x20, 0x04, 0x41, 0x10, 0x6a, 0x10, 0x32, 0x0c, 0x01, 0x0b, 0x41,
  0x06, 0x41, 0xd4, 0xb0, 0x03, 0x10, 0x26, 0x0b, 0x41, 0x0c, 0x10, 0x02,
  0x22, 0x00, 0x41, 0x00, 0x36, 0x02, 0x08, 0x20, 0x00, 0x42, 0xf0, 0x2e,
  0x37, 0x02, 0x00, 0x20, 0x00, 0x41, 0xa8, 0xf1, 0x1a, 0x41, 0x00, 0x10,
  0x08, 0x00, 0x0b, 0xb1, 0xfd, 0x01, 0x02, 0x67, 0x7f, 0x03, 0x7e, 0x23,
  0x00, 0x41, 0xd0, 0x03, 0x6b, 0x22, 0x09, 0x24, 0x00, 0x20, 0x00, 0x41,
  0x8c, 0xc8, 0x00, 0x6a, 0x21, 0x4d, 0x20, 0x00, 0x41, 0x9c, 0xc2, 0x04,
  0x6a, 0x21, 0x3d, 0x20, 0x00, 0x41, 0xc8, 0x04, 0x6a, 0x21, 0x4e, 0x20,
  0x00, 0x41, 0xe4, 0xc3, 0x04, 0x6a, 0x21, 0x2a, 0x20, 0x00, 0x41, 0xdf,
  0xc3, 0x04, 0x6a, 0x21, 0x3e, 0x20, 0x09, 0x41, 0x98, 0x03, 0x6a, 0x21,
  0x4f, 0x20, 0x09, 0x41, 0x88, 0x03, 0x6a, 0x21, 0x2b, 0x20, 0x09, 0x41,
  0xa0, 0x03, 0x6a, 0x21, 0x2c, 0x20, 0x09, 0x41, 0x90, 0x03, 0x6a, 0x41,
  0x01, 0x72, 0x21, 0x50, 0x20, 0x09, 0x41, 0x9c, 0x03, 0x6a, 0x21, 0x51,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x03, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x00, 0x2d, 0x00,
  0xe8, 0xc3, 0x08, 0x04, 0x40, 0x20, 0x00, 0x41, 0x00, 0x3a, 0x00, 0xe8,
  0xc3, 0x08, 0x20, 0x00, 0x2f, 0x01, 0xe6, 0xc3, 0x04, 0x21, 0x1a, 0x20,
  0x00, 0x2f, 0x01, 0xe2, 0xc3, 0x04, 0x21, 0x08, 0x0c, 0x01, 0x0b, 0x20,
  0x00, 0x2f, 0x01, 0xe2, 0xc3, 0x04, 0x21, 0x08, 0x20, 0x00, 0x2d, 0x00,
  0xde, 0xc3, 0x04, 0x45, 0x04, 0x40, 0x20, 0x00, 0x41, 0x00, 0x3b, 0x01,
  0xe2, 0xc3, 0x04, 0x20, 0x00, 0x20, 0x00, 0x2f, 0x01, 0xe6, 0xc3, 0x04,
  0x20, 0x08, 0x6a, 0x3b, 0x01, 0xe6, 0xc3, 0x04, 0x20, 0x09, 0x41, 0xb0,
  0x03, 0x6a, 0x20, 0x3e, 0x20, 0x2a, 0x10, 0x76, 0x20, 0x09, 0x2d, 0x00,
  0xb0, 0x03, 0x45, 0x0d, 0x0c, 0x20, 0x00, 0x20, 0x09, 0x2f, 0x01, 0xb2,
  0x03, 0x22, 0x08, 0x3b, 0x01, 0xe2, 0xc3, 0x04, 0x20, 0x00, 0x2f, 0x01,
  0xe4, 0xc3, 0x04, 0x20, 0x00, 0x2f, 0x01, 0xe6, 0xc3, 0x04, 0x22, 0x1a,
  0x6b, 0x41, 0xff, 0xff, 0x03, 0x71, 0x20, 0x08, 0x49, 0x04, 0x40, 0x20,
  0x00, 0x41, 0x01, 0x3a, 0x00, 0xde, 0xc3, 0x04, 0x0c, 0x0d, 0x0b, 0x20,
  0x3e, 0x2d, 0x00, 0x00, 0x04, 0x40, 0x20, 0x00, 0x41, 0x01, 0x3a, 0x00,
  0xe0, 0xc3, 0x04, 0x0c, 0x02, 0x0b, 0x20, 0x09, 0x20, 0x1a, 0x20, 0x2a,
  0x6a, 0x2d, 0x00, 0x09, 0x22, 0x02, 0x3a, 0x00, 0x90, 0x03, 0x20, 0x02,
  0x41, 0xf0, 0x01, 0x71, 0x41, 0xf0, 0x00, 0x6b, 0x22, 0x02, 0x41, 0x90,
  0x01, 0x4f, 0x0d, 0x02, 0x41, 0xc3, 0x03, 0x20, 0x02, 0x41, 0x04, 0x76,
  0x22, 0x02, 0x76, 0x41, 0x01, 0x71, 0x45, 0x0d, 0x02, 0x20, 0x00, 0x20,
  0x02, 0x41, 0xcc, 0xf4, 0x05, 0x6a, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0xe0,
  0xc3, 0x04, 0x0c, 0x01, 0x0b, 0x20, 0x08, 0x20, 0x00, 0x2f, 0x01, 0xe4,
  0xc3, 0x04, 0x20, 0x00, 0x2f, 0x01, 0xe6, 0xc3, 0x04, 0x22, 0x1a, 0x6b,
  0x41, 0xff, 0xff, 0x03, 0x71, 0x4b, 0x0d, 0x0b, 0x20, 0x00, 0x41, 0x00,
  0x3a, 0x00, 0xde, 0xc3, 0x04, 0x20, 0x00, 0x2d, 0x00, 0xdf, 0xc3, 0x04,
  0x04, 0x40, 0x20, 0x00, 0x41, 0x01, 0x3a, 0x00, 0xe0, 0xc3, 0x04, 0x0c,
  0x01, 0x0b, 0x20, 0x09, 0x20, 0x1a, 0x20, 0x2a, 0x6a, 0x2d, 0x00, 0x09,
  0x22, 0x02, 0x3a, 0x00, 0xb0, 0x03, 0x20, 0x02, 0x41, 0xf0, 0x01, 0x71,
  0x41, 0xf0, 0x00, 0x6b, 0x22, 0x02, 0x41, 0x90, 0x01, 0x4f, 0x0d, 0x03,
  0x41, 0xc3, 0x03, 0x20, 0x02, 0x41, 0x04, 0x76, 0x22, 0x02, 0x76, 0x41,
  0x01, 0x71, 0x45, 0x0d, 0x03, 0x20, 0x00, 0x20, 0x02, 0x41, 0xcc, 0xf4,
  0x05, 0x6a, 0x2d, 0x00, 0x00, 0x3a, 0x00, 0xe0, 0xc3, 0x04, 0x0b, 0x20,
  0x2a, 0x20, 0x1a, 0x41, 0xff, 0xff, 0x03, 0x71, 0x6a, 0x41, 0x04, 0x6a,
  0x21, 0x02, 0x20, 0x00, 0x2d, 0x00, 0xe9, 0xc3, 0x08, 0x04, 0x40, 0x20,
  0x02, 0x20, 0x08, 0x41, 0xc2, 0x96, 0x05, 0x41, 0xba, 0x96, 0x05, 0x41,
  0xe0, 0x14, 0x41, 0x02, 0x41, 0xbf, 0x96, 0x05, 0x41, 0x02, 0x41, 0xaf,
  0x9c, 0x05, 0x41, 0xb5, 0x96, 0x05, 0x10, 0x2e, 0x0b, 0x20, 0x09, 0x20,
  0x02, 0x36, 0x02, 0xf8, 0x02, 0x20, 0x09, 0x20, 0x02, 0x36, 0x02, 0xf0,
  0x02, 0x20, 0x09, 0x20, 0x02, 0x20, 0x08, 0x6a, 0x36, 0x02, 0xf4, 0x02,
  0x41, 0xc8, 0x96, 0x1b, 0x20, 0x00, 0x28, 0x02, 0xa8, 0xc2, 0x04, 0x20,
  0x00, 0x2d, 0x00, 0xb9, 0xc2, 0x04, 0x1b, 0x21, 0x0b, 0x02, 0x40, 0x20,
  0x00, 0x2d, 0x00, 0xdf, 0xc3, 0x04, 0x45, 0x04, 0x40, 0x20, 0x00, 0x2d,
  0x00, 0xe0, 0xc3, 0x04, 0x41, 0x01, 0x47, 0x0d, 0x01, 0x0b, 0x20, 0x2a,
  0x20, 0x00, 0x2f, 0x01, 0xe6, 0xc3, 0x04, 0x6a, 0x41, 0x04, 0x6a, 0x21,
  0x08, 0x20, 0x00, 0x2f, 0x01, 0xe2, 0xc3, 0x04, 0x21, 0x04, 0x20, 0x00,
  0x2d, 0x00, 0xe9, 0xc3, 0x08, 0x04, 0x40, 0x20, 0x08, 0x20, 0x04, 0x41,
  0xc2, 0x96, 0x05, 0x41, 0xba, 0x96, 0x05, 0x41, 0xe0, 0x14, 0x41, 0x02,
  0x41, 0xbf, 0x96, 0x05, 0x41, 0x02, 0x41, 0xaf, 0x9c, 0x05, 0x41, 0xb5,
  0x96, 0x05, 0x10, 0x2e, 0x0b, 0x20, 0x09, 0x20, 0x08, 0x2d, 0x00, 0x00,
  0x22, 0x03, 0x41, 0x03, 0x71, 0x22, 0x02, 0x3a, 0x00, 0xb0, 0x03, 0x20,
  0x02, 0x0d, 0x04, 0x20, 0x00, 0x28, 0x02, 0x84, 0x0d, 0x41, 0x10, 0x46,
  0x0d, 0x05, 0x20, 0x04, 0x20, 0x08, 0x6a, 0x21, 0x1a, 0x20, 0x08, 0x41,
  0x02, 0x41, 0x03, 0x20, 0x08, 0x2c, 0x00, 0x01, 0x41, 0x7f, 0x4a, 0x1b,
  0x6a, 0x21, 0x02, 0x02, 0x40, 0x20, 0x03, 0x41, 0x18, 0x74, 0x41, 0x18,
  0x75, 0x41, 0x7f, 0x4a, 0x04, 0x40, 0x20, 0x02, 0x21, 0x08, 0x0c, 0x01,
  0x0b, 0x20, 0x09, 0x41, 0x08, 0x36, 0x02, 0xb0, 0x03, 0x20, 0x1a, 0x20,
  0x02, 0x6b, 0x22, 0x03, 0x41, 0x07, 0x4d, 0x0d, 0x07, 0x20, 0x4e, 0x20,
  0x02, 0x41, 0x08, 0x6a, 0x22, 0x02, 0x20, 0x1a, 0x20, 0x02, 0x6b, 0x22,
  0x02, 0x20, 0x08, 0x10, 0x40, 0x20, 0x02, 0x20, 0x08, 0x6a, 0x21, 0x1a,
  0x0b, 0x20, 0x08, 0x20, 0x1a, 0x46, 0x0d, 0x02, 0x03, 0x40, 0x20, 0x09,
  0x41, 0x01, 0x36, 0x02, 0xb0, 0x03, 0x20, 0x08, 0x20, 0x1a, 0x46, 0x0d,
  0x08, 0x20, 0x09, 0x20, 0x08, 0x2d, 0x00, 0x00, 0x22, 0x06, 0x3a, 0x00,
  0x90, 0x03, 0x20, 0x09, 0x20, 0x06, 0x41, 0x06, 0x76, 0x3a, 0x00, 0x93,
  0x03, 0x20, 0x09, 0x20, 0x06, 0x41, 0x0f, 0x71, 0x3a, 0x00, 0x91, 0x03,
  0x20, 0x09, 0x20, 0x06, 0x41, 0x04, 0x76, 0x41, 0x03, 0x71, 0x3a, 0x00,
  0x92, 0x03, 0x20, 0x09, 0x20, 0x06, 0x41, 0x07, 0x76, 0x41, 0x02, 0x72,
  0x22, 0x04, 0x36, 0x02, 0xb0, 0x03, 0x20, 0x04, 0x20, 0x1a, 0x20, 0x08,
  0x41, 0x01, 0x6a, 0x22, 0x02, 0x6b, 0x22, 0x03, 0x4b, 0x0d, 0x09, 0x41,
  0x00, 0x21, 0x03, 0x20, 0x06, 0x41, 0x18, 0x74, 0x41, 0x18, 0x75, 0x41,
  0x7f, 0x4a, 0x22, 0x04, 0x45, 0x04, 0x40, 0x20, 0x08, 0x2d, 0x00, 0x01,
  0x21, 0x03, 0x20, 0x08, 0x41, 0x02, 0x6a, 0x21, 0x02, 0x0b, 0x20, 0x09,
  0x20, 0x03, 0x3a, 0x00, 0x94, 0x03, 0x20, 0x09, 0x20, 0x02, 0x2f, 0x00,
  0x00, 0x22, 0x08, 0x3b, 0x01, 0x96, 0x03, 0x20, 0x09, 0x20, 0x08, 0x3b,
  0x01, 0xa8, 0x03, 0x20, 0x02, 0x41, 0x02, 0x6a, 0x21, 0x1d, 0x20, 0x08,
  0x04, 0x40, 0x20, 0x1a, 0x20, 0x1d, 0x6b, 0x22, 0x02, 0x20, 0x08, 0x49,
  0x0d, 0x0b, 0x0b, 0x02, 0x40, 0x02, 0x40, 0x20, 0x04, 0x0d, 0x00, 0x20,
  0x03, 0x41, 0x20, 0x71, 0x45, 0x0d, 0x00, 0x20, 0x09, 0x20, 0x08, 0x36,
  0x02, 0x84, 0x03, 0x20, 0x09, 0x20, 0x1d, 0x36, 0x02, 0x80, 0x03, 0x20,
  0x3d, 0x28, 0x02, 0x00, 0x28, 0x02, 0x08, 0x21, 0x02, 0x20, 0x09, 0x20,
  0x09, 0x29, 0x03, 0x80, 0x03, 0x37, 0x03, 0x28, 0x20, 0x09, 0x41, 0xb0,
  0x03, 0x6a, 0x20, 0x3d, 0x20, 0x09, 0x41, 0x28, 0x6a, 0x20, 0x03, 0x41,
  0xff, 0x01, 0x71, 0x20, 0x02, 0x11, 0x03, 0x00, 0x20, 0x09, 0x20, 0x09,
  0x28, 0x02, 0xb0, 0x03, 0x22, 0x02, 0x36, 0x02, 0x98, 0x03, 0x20, 0x09,
  0x20, 0x02, 0x20, 0x09, 0x28, 0x02, 0xb4, 0x03, 0x6a, 0x22, 0x03, 0x36,
  0x02, 0x9c, 0x03, 0x20, 0x09, 0x2f, 0x01, 0x96, 0x03, 0x21, 0x08, 0x0c,
  0x01, 0x0b, 0x20, 0x09, 0x20, 0x1d, 0x36, 0x02, 0x98, 0x03, 0x20, 0x09,
  0x20, 0x08, 0x20, 0x1d, 0x6a, 0x22, 0x03, 0x36, 0x02, 0x9c, 0x03, 0x20,
  0x1d, 0x21, 0x02, 0x0b, 0x20, 0x09, 0x20, 0x02, 0x36, 0x02, 0xa0, 0x03,
  0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0x02, 0x71, 0x04, 0x40,
  0x41, 0x93, 0xe8, 0x03, 0x21, 0x04, 0x20, 0x09, 0x2c, 0x00, 0x91, 0x03,
  0x22, 0x06, 0x41, 0x0b, 0x4d, 0x04, 0x40, 0x20, 0x06, 0x41, 0x02, 0x74,
  0x41, 0xe8, 0xeb, 0x1a, 0x6a, 0x28, 0x02, 0x00, 0x21, 0x04, 0x0b, 0x41,
  0xde, 0xec, 0x03, 0x21, 0x06, 0x20, 0x09, 0x2c, 0x00, 0x92, 0x03, 0x22,
  0x07, 0x41, 0x03, 0x4d, 0x04, 0x40, 0x20, 0x07, 0x41, 0x02, 0x74, 0x41,
  0x98, 0xec, 0x1a, 0x6a, 0x28, 0x02, 0x00, 0x21, 0x06, 0x0b, 0x10, 0x00,
  0x21, 0x07, 0x20, 0x09, 0x20, 0x03, 0x20, 0x02, 0x6b, 0x36, 0x02, 0x24,
  0x20, 0x09, 0x20, 0x06, 0x36, 0x02, 0x20, 0x20, 0x09, 0x20, 0x04, 0x36,
  0x02, 0x1c, 0x20, 0x09, 0x20, 0x07, 0x36, 0x02, 0x18, 0x20, 0x09, 0x20,
  0x07, 0x36, 0x02, 0x14, 0x20, 0x09, 0x41, 0xc2, 0xea, 0x03, 0x36, 0x02,
  0x10, 0x41, 0x06, 0x41, 0xc2, 0xc8, 0x00, 0x20, 0x09, 0x41, 0x10, 0x6a,
  0x10, 0x22, 0x0b, 0x41, 0x01, 0x21, 0x02, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x20, 0x09, 0x2d, 0x00, 0x92, 0x03, 0x22, 0x03, 0x0e,
  0x03, 0x02, 0x01, 0x00, 0x01, 0x0b, 0x20, 0x00, 0x20, 0x00, 0x28, 0x02,
  0xd0, 0xc2, 0x04, 0x36, 0x02, 0xd8, 0xc2, 0x04, 0x0b, 0x20, 0x09, 0x28,
  0x02, 0x9c, 0x03, 0x20, 0x09, 0x28, 0x02, 0xa0, 0x03, 0x6b, 0x22, 0x02,
  0x04, 0x40, 0x20, 0x00, 0x28, 0x02, 0xd8, 0xc2, 0x04, 0x20, 0x09, 0x28,
  0x02, 0x98, 0x03, 0x20, 0x02, 0x10, 0x24, 0x1a, 0x20, 0x00, 0x20, 0x00,
  0x28, 0x02, 0xd8, 0xc2, 0x04, 0x20, 0x02, 0x6a, 0x36, 0x02, 0xd8, 0xc2,
  0x04, 0x20, 0x09, 0x2d, 0x00, 0x92, 0x03, 0x21, 0x03, 0x0b, 0x41, 0x00,
  0x21, 0x02, 0x20, 0x03, 0x41, 0xff, 0x01, 0x71, 0x41, 0x01, 0x47, 0x0d,
  0x01, 0x0b, 0x20, 0x00, 0x28, 0x02, 0xd8, 0xc2, 0x04, 0x21, 0x20, 0x20,
  0x09, 0x20, 0x00, 0x28, 0x02, 0xd0, 0xc2, 0x04, 0x22, 0x07, 0x36, 0x02,
  0x88, 0x03, 0x20, 0x09, 0x20, 0x20, 0x36, 0x02, 0x84, 0x03, 0x20, 0x09,
  0x20, 0x07, 0x36, 0x02, 0x80, 0x03, 0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1,
  0x04, 0x41, 0x80, 0x01, 0x71, 0x04, 0x40, 0x20, 0x09, 0x28, 0x02, 0x9c,
  0x03, 0x21, 0x06, 0x20, 0x09, 0x28, 0x02, 0xa0, 0x03, 0x21, 0x04, 0x20,
  0x09, 0x10, 0x00, 0x22, 0x03, 0x36, 0x02, 0x08, 0x20, 0x09, 0x20, 0x03,
  0x36, 0x02, 0x04, 0x20, 0x09, 0x41, 0xc2, 0xea, 0x03, 0x36, 0x02, 0x00,
  0x20, 0x09, 0x20, 0x06, 0x20, 0x20, 0x20, 0x02, 0x1b, 0x20, 0x04, 0x20,
  0x07, 0x20, 0x02, 0x1b, 0x6b, 0x36, 0x02, 0x0c, 0x41, 0x06, 0x41, 0x97,
  0xc8, 0x00, 0x20, 0x09, 0x10, 0x22, 0x0b, 0x20, 0x4f, 0x20, 0x09, 0x41,
  0x80, 0x03, 0x6a, 0x20, 0x02, 0x1b, 0x21, 0x11, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x09, 0x2d, 0x00, 0x91, 0x03,
  0x0e, 0x0c, 0x0a, 0x00, 0x01, 0x0b, 0x02, 0x03, 0x04, 0x09, 0x05, 0x06,
  0x07, 0x08, 0x09, 0x0b, 0x20, 0x0b, 0x20, 0x0b, 0x28, 0x02, 0x00, 0x28,
  0x02, 0x90, 0x01, 0x11, 0x02, 0x00, 0x20, 0x00, 0x20, 0x11, 0x41, 0x01,
  0x20, 0x0b, 0x10, 0xe2, 0x01, 0x20, 0x0b, 0x20, 0x0b, 0x28, 0x02, 0x00,
  0x28, 0x02, 0x94, 0x01, 0x11, 0x02, 0x00, 0x0c, 0x0a, 0x0b, 0x20, 0x0b,
  0x20, 0x0b, 0x28, 0x02, 0x00, 0x28, 0x02, 0x90, 0x01, 0x11, 0x02, 0x00,
  0x20, 0x00, 0x20, 0x0b, 0x20, 0x11, 0x41, 0x01, 0x10, 0xe1, 0x01, 0x20,
  0x0b, 0x20, 0x0b, 0x28, 0x02, 0x00, 0x28, 0x02, 0x94, 0x01, 0x11, 0x02,
  0x00, 0x0c, 0x09, 0x0b, 0x23, 0x00, 0x41, 0xc0, 0x83, 0x02, 0x6b, 0x22,
  0x05, 0x24, 0x00, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20,
  0x11, 0x28, 0x02, 0x04, 0x22, 0x03, 0x20, 0x11, 0x28, 0x02, 0x08, 0x22,
  0x02, 0x6b, 0x41, 0x02, 0x4f, 0x04, 0x40, 0x20, 0x00, 0x41, 0xa8, 0x3f,
  0x6a, 0x21, 0x27, 0x20, 0x05, 0x41, 0xb0, 0x32, 0x6a, 0x21, 0x33, 0x20,
  0x05, 0x41, 0xb0, 0x3e, 0x6a, 0x21, 0x34, 0x20, 0x05, 0x41, 0xe0, 0xf2,
  0x00, 0x6a, 0x21, 0x35, 0x20, 0x05, 0x41, 0xe0, 0xfe, 0x00, 0x6a, 0x21,
  0x12, 0x20, 0x05, 0x41, 0x90, 0xb3, 0x01, 0x6a, 0x21, 0x1b, 0x20, 0x05,
  0x41, 0x90, 0xbf, 0x01, 0x6a, 0x21, 0x18, 0x20, 0x05, 0x41, 0xe0, 0xc2,
  0x00, 0x6a, 0x22, 0x06, 0x41, 0x08, 0x72, 0x22, 0x1f, 0x21, 0x24, 0x20,
  0x06, 0x41, 0x07, 0x72, 0x22, 0x20, 0x21, 0x07, 0x20, 0x06, 0x41, 0x0c,
  0x72, 0x22, 0x04, 0x21, 0x0d, 0x20, 0x06, 0x41, 0x04, 0x72, 0x21, 0x2f,
  0x20, 0x05, 0x41, 0x91, 0x89, 0x01, 0x6a, 0x21, 0x21, 0x20, 0x00, 0x41,
  0xe2, 0xc1, 0x04, 0x6a, 0x21, 0x30, 0x03, 0x40, 0x20, 0x05, 0x41, 0x02,
  0x36, 0x02, 0xcc, 0x01, 0x20, 0x11, 0x20, 0x02, 0x41, 0x02, 0x6a, 0x22,
  0x0f, 0x36, 0x02, 0x08, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x20, 0x02, 0x2f, 0x00, 0x00, 0x22, 0x06, 0x41,
  0x01, 0x6b, 0x0e, 0x06, 0x00, 0x01, 0x01, 0x02, 0x01, 0x00, 0x01, 0x0b,
  0x20, 0x05, 0x41, 0x00, 0x36, 0x02, 0xc0, 0x01, 0x20, 0x05, 0x42, 0x00,
  0x37, 0x03, 0x90, 0x01, 0x20, 0x05, 0x41, 0x16, 0x36, 0x02, 0x90, 0x83,
  0x01, 0x20, 0x11, 0x28, 0x02, 0x04, 0x20, 0x0f, 0x6b, 0x22, 0x03, 0x41,
  0x15, 0x4b, 0x04, 0x40, 0x20, 0x11, 0x20, 0x02, 0x41, 0x04, 0x6a, 0x36,
  0x02, 0x08, 0x20, 0x02, 0x33, 0x00, 0x02, 0x21, 0x6a, 0x20, 0x11, 0x20,
  0x02, 0x41, 0x06, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x02, 0x31, 0x00, 0x04,
  0x21, 0x69, 0x20, 0x02, 0x31, 0x00, 0x05, 0x21, 0x68, 0x20, 0x11, 0x20,
  0x02, 0x41, 0x08, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x02, 0x2f, 0x00, 0x06,
  0x21, 0x06, 0x20, 0x11, 0x20, 0x02, 0x41, 0x0a, 0x6a, 0x36, 0x02, 0x08,
  0x20, 0x05, 0x20, 0x6a, 0x20, 0x69, 0x42, 0x10, 0x86, 0x84, 0x20, 0x68,
  0x42, 0x18, 0x86, 0x84, 0x42, 0x00, 0x20, 0x02, 0x2f, 0x00, 0x08, 0x22,
  0x03, 0xad, 0x42, 0x30, 0x86, 0x20, 0x06, 0xad, 0x42, 0xff, 0xff, 0x03,
  0x83, 0x42, 0x20, 0x86, 0x84, 0x20, 0x03, 0x41, 0x01, 0x6b, 0x20, 0x06,
  0x41, 0x01, 0x6b, 0x72, 0x41, 0x80, 0x80, 0x02, 0x71, 0x1b, 0x84, 0x37,
  0x03, 0x90, 0x01, 0x20, 0x11, 0x20, 0x02, 0x41, 0x0b, 0x6a, 0x36, 0x02,
  0x08, 0x20, 0x05, 0x20, 0x02, 0x2d, 0x00, 0x0a, 0x3a, 0x00, 0x98, 0x01,
  0x20, 0x11, 0x20, 0x02, 0x41, 0x0c, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x05,
  0x20, 0x02, 0x2d, 0x00, 0x0b, 0x22, 0x03, 0x3a, 0x00, 0x99, 0x01, 0x20,
  0x11, 0x20, 0x02, 0x41, 0x0e, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x05, 0x20,
  0x02, 0x2d, 0x00, 0x0d, 0x3a, 0x00, 0x9a, 0x01, 0x20, 0x11, 0x20, 0x02,
  0x41, 0x10, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x2f, 0x00,
  0x0e, 0x3b, 0x01, 0x9c, 0x01, 0x20, 0x11, 0x20, 0x02, 0x41, 0x12, 0x6a,
  0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x2f, 0x00, 0x10, 0x3b, 0x01,
  0x9e, 0x01, 0x20, 0x11, 0x20, 0x02, 0x41, 0x16, 0x6a, 0x22, 0x0f, 0x36,
  0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x28, 0x00, 0x12, 0x22, 0x06, 0x36,
  0x02, 0xa0, 0x01, 0x02, 0x40, 0x20, 0x03, 0x41, 0x01, 0x71, 0x04, 0x40,
  0x20, 0x05, 0x41, 0x18, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x11, 0x28,
  0x02, 0x04, 0x20, 0x0f, 0x6b, 0x22, 0x03, 0x41, 0x17, 0x4d, 0x0d, 0x01,
  0x20, 0x11, 0x20, 0x02, 0x41, 0x1a, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x05,
  0x20, 0x02, 0x28, 0x00, 0x16, 0x36, 0x02, 0xa8, 0x01, 0x20, 0x11, 0x20,
  0x02, 0x41, 0x1e, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x28,
  0x00, 0x1a, 0x36, 0x02, 0xac, 0x01, 0x20, 0x11, 0x20, 0x02, 0x41, 0x26,
  0x6a, 0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x29, 0x00, 0x1e, 0x37,
  0x03, 0xb0, 0x01, 0x20, 0x11, 0x20, 0x02, 0x41, 0x2e, 0x6a, 0x22, 0x0f,
  0x36, 0x02, 0x08, 0x20, 0x05, 0x20, 0x02, 0x29, 0x00, 0x26, 0x37, 0x03,
  0xb8, 0x01, 0x0b, 0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0x90, 0x83, 0x01,
  0x20, 0x06, 0x20, 0x11, 0x28, 0x02, 0x04, 0x20, 0x0f, 0x6b, 0x22, 0x03,
  0x4d, 0x04, 0x40, 0x20, 0x05, 0x20, 0x0f, 0x36, 0x02, 0xa4, 0x01, 0x02,
  0x40, 0x20, 0x00, 0x28, 0x02, 0xfc, 0xc1, 0x04, 0x22, 0x02, 0x20, 0x00,
  0x28, 0x02, 0x80, 0xc2, 0x04, 0x22, 0x03, 0x46, 0x0d, 0x00, 0x20, 0x05,
  0x2d, 0x00, 0x9a, 0x01, 0x21, 0x06, 0x03, 0x40, 0x20, 0x02, 0x2d, 0x00,
  0x00, 0x20, 0x06, 0x46, 0x0d, 0x01, 0x20, 0x02, 0x41, 0x01, 0x6a, 0x22,
  0x02, 0x20, 0x03, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x03, 0x21, 0x02, 0x0b,
  0x20, 0x02, 0x20, 0x03, 0x46, 0x0d, 0x05, 0x20, 0x30, 0x2d, 0x00, 0x00,
  0x41, 0x02, 0x71, 0x04, 0x40, 0x41, 0x06, 0x41, 0xb9, 0xaf, 0x03, 0x10,
  0x26, 0x20, 0x11, 0x28, 0x02, 0x08, 0x21, 0x0f, 0x0b, 0x20, 0x05, 0x41,
  0x01, 0x36, 0x02, 0xc0, 0x01, 0x20, 0x05, 0x28, 0x02, 0xa0, 0x01, 0x21,
  0x02, 0x20, 0x0b, 0x20, 0x05, 0x41, 0x90, 0x01, 0x6a, 0x20, 0x0b, 0x28,
  0x02, 0x00, 0x28, 0x02, 0x60, 0x11, 0x01, 0x00, 0x20, 0x02, 0x20, 0x0f,
  0x6a, 0x22, 0x31, 0x20, 0x0f, 0x6b, 0x41, 0x06, 0x49, 0x0d, 0x06, 0x03,
  0x40, 0x20, 0x05, 0x20, 0x0f, 0x22, 0x0a, 0x2f, 0x00, 0x00, 0x22, 0x03,
  0x3b, 0x01, 0x8e, 0x02, 0x20, 0x05, 0x20, 0x0a, 0x28, 0x00, 0x02, 0x22,
  0x1c, 0x36, 0x02, 0x88, 0x02, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x1c, 0x41,
  0x05, 0x4b, 0x04, 0x40, 0x20, 0x05, 0x20, 0x1c, 0x41, 0x06, 0x6b, 0x22,
  0x15, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x31, 0x20, 0x0a, 0x41, 0x06,
  0x6a, 0x6b, 0x22, 0x02, 0x20, 0x15, 0x49, 0x0d, 0x01, 0x20, 0x0a, 0x20,
  0x1c, 0x6a, 0x21, 0x0f, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x00,
  0x28, 0x02, 0xc0, 0xc0, 0x04, 0x0e, 0x03, 0x00, 0x01, 0x02, 0x17, 0x0b,
  0x20, 0x03, 0x41, 0xc0, 0x99, 0x03, 0x46, 0x04, 0x40, 0x20, 0x05, 0x41,
  0x06, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x15, 0x41, 0x05, 0x4d, 0x0d,
  0x05, 0x20, 0x0a, 0x28, 0x00, 0x06, 0x41, 0xca, 0xd9, 0xb2, 0xd6, 0x7c,
  0x47, 0x0d, 0x06, 0x20, 0x0a, 0x2f, 0x00, 0x0a, 0x41, 0x80, 0x02, 0x47,
  0x0d, 0x07, 0x20, 0x00, 0x41, 0x01, 0x36, 0x02, 0xc0, 0xc0, 0x04, 0x0c,
  0x17, 0x0b, 0x41, 0x03, 0x41, 0xfc, 0xe1, 0x01, 0x10, 0x26, 0x0c, 0x28,
  0x0b, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x20, 0x03, 0x41, 0xc1, 0x99, 0x03, 0x6b, 0x0e, 0x03, 0x01, 0x02,
  0x00, 0x03, 0x0b, 0x20, 0x05, 0x41, 0x02, 0x36, 0x02, 0x90, 0x83, 0x01,
  0x20, 0x15, 0x41, 0x01, 0x4d, 0x0d, 0x29, 0x20, 0x05, 0x41, 0x05, 0x36,
  0x02, 0x90, 0x83, 0x01, 0x20, 0x1c, 0x41, 0x08, 0x6b, 0x22, 0x03, 0x41,
  0x04, 0x4d, 0x0d, 0x0b, 0x20, 0x0a, 0x2f, 0x00, 0x09, 0x41, 0xc0, 0x00,
  0x47, 0x0d, 0x0c, 0x20, 0x00, 0x20, 0x00, 0x2d, 0x00, 0xc4, 0xc0, 0x04,
  0x41, 0x01, 0x72, 0x22, 0x02, 0x3a, 0x00, 0xc4, 0xc0, 0x04, 0x0c, 0x04,
  0x0b, 0x20, 0x05, 0x41, 0x04, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x15,
  0x41, 0x03, 0x4d, 0x0d, 0x0c, 0x20, 0x0a, 0x2d, 0x00, 0x06, 0x41, 0x01,
  0x47, 0x0d, 0x0d, 0x20, 0x0a, 0x2d, 0x00, 0x07, 0x41, 0x01, 0x47, 0x0d,
  0x0e, 0x20, 0x0a, 0x2f, 0x00, 0x08, 0x41, 0x80, 0x02, 0x47, 0x0d, 0x0f,
  0x20, 0x00, 0x20, 0x00, 0x2d, 0x00, 0xc4, 0xc0, 0x04, 0x41, 0x02, 0x72,
  0x22, 0x02, 0x3a, 0x00, 0xc4, 0xc0, 0x04, 0x0c, 0x03, 0x0b, 0x20, 0x05,
  0x41, 0x01, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x1c, 0x41, 0x06, 0x46,
  0x0d, 0x0f, 0x20, 0x0a, 0x2d, 0x00, 0x06, 0x22, 0x16, 0x45, 0x04, 0x40,
  0x20, 0x00, 0x20, 0x00, 0x2d, 0x00, 0xc4, 0xc0, 0x04, 0x41, 0x04, 0x72,
  0x22, 0x02, 0x3a, 0x00, 0xc4, 0xc0, 0x04, 0x0c, 0x03, 0x0b, 0x20, 0x16,
  0x41, 0x06, 0x6c, 0x22, 0x0c, 0x10, 0x27, 0x22, 0x10, 0x21, 0x02, 0x20,
  0x0c, 0x41, 0x06, 0x6b, 0x22, 0x03, 0x41, 0x06, 0x6e, 0x41, 0x01, 0x6a,
  0x41, 0x07, 0x71, 0x22, 0x06, 0x04, 0x40, 0x03, 0x40, 0x20, 0x02, 0x41,
  0x00, 0x36, 0x01, 0x00, 0x20, 0x02, 0x41, 0x00, 0x3b, 0x01, 0x04, 0x20,
  0x02, 0x41, 0x06, 0x6a, 0x21, 0x02, 0x20, 0x06, 0x41, 0x01, 0x6b, 0x22,
  0x06, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x03, 0x41, 0x2a, 0x4f, 0x04, 0x40,
  0x20, 0x0c, 0x20, 0x10, 0x6a, 0x21, 0x03, 0x03, 0x40, 0x20, 0x02, 0x42,
  0x00, 0x37, 0x01, 0x00, 0x20, 0x02, 0x42, 0x00, 0x37, 0x01, 0x28, 0x20,
  0x02, 0x42, 0x00, 0x37, 0x01, 0x20, 0x20, 0x02, 0x42, 0x00, 0x37, 0x01,
  0x18, 0x20, 0x02, 0x42, 0x00, 0x37, 0x01, 0x10, 0x20, 0x02, 0x42, 0x00,
  0x37, 0x01, 0x08, 0x20, 0x02, 0x41, 0x30, 0x6a, 0x22, 0x02, 0x20, 0x03,
  0x47, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0a, 0x41, 0x07, 0x6a, 0x21, 0x02,
  0x20, 0x16, 0x41, 0x01, 0x20, 0x16, 0x41, 0x01, 0x4b, 0x1b, 0x41, 0x01,
  0x6b, 0x21, 0x0a, 0x41, 0x00, 0x21, 0x06, 0x03, 0x40, 0x20, 0x05, 0x41,
  0x05, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x0f, 0x20, 0x02, 0x6b, 0x22,
  0x03, 0x41, 0x04, 0x4d, 0x0d, 0x11, 0x20, 0x10, 0x20, 0x06, 0x41, 0x06,
  0x6c, 0x6a, 0x22, 0x0c, 0x20, 0x02, 0x2d, 0x00, 0x00, 0x22, 0x03, 0x3a,
  0x00, 0x00, 0x20, 0x03, 0x0d, 0x12, 0x20, 0x0c, 0x20, 0x02, 0x2f, 0x00,
  0x01, 0x3b, 0x01, 0x02, 0x20, 0x0c, 0x20, 0x02, 0x2f, 0x00, 0x03, 0x3b,
  0x01, 0x04, 0x20, 0x06, 0x20, 0x0a, 0x46, 0x0d, 0x02, 0x20, 0x02, 0x41,
  0x05, 0x6a, 0x21, 0x02, 0x20, 0x06, 0x41, 0x01, 0x6a, 0x21, 0x06, 0x0c,
  0x00, 0x0b, 0x00, 0x0b, 0x41, 0x03, 0x41, 0xd5, 0xe2, 0x03, 0x20, 0x05,
  0x41, 0x8e, 0x02, 0x6a, 0x10, 0x3d, 0x0c, 0x29, 0x0b, 0x20, 0x00, 0x20,
  0x00, 0x2d, 0x00, 0xc4, 0xc0, 0x04, 0x41, 0x04, 0x72, 0x3a, 0x00, 0xc4,
  0xc0, 0x04, 0x20, 0x10, 0x10, 0x23, 0x20, 0x00, 0x2d, 0x00, 0xc4, 0xc0,
  0x04, 0x21, 0x02, 0x0b, 0x20, 0x02, 0x41, 0xff, 0x01, 0x71, 0x41, 0x07,
  0x47, 0x0d, 0x15, 0x20, 0x00, 0x41, 0x02, 0x36, 0x02, 0xc0, 0xc0, 0x04,
  0x0c, 0x15, 0x0b, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x20, 0x03, 0x41, 0xc1, 0x99, 0x03, 0x6b, 0x0e, 0x07, 0x19, 0x19,
  0x19, 0x00, 0x01, 0x02, 0x03, 0x04, 0x0b, 0x20, 0x05, 0x41, 0x02, 0x36,
  0x02, 0x90, 0x83, 0x01, 0x20, 0x15, 0x41, 0x01, 0x4d, 0x0d, 0x27, 0x20,
  0x05, 0x41, 0x06, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x1c, 0x41, 0x08,
  0x6b, 0x22, 0x03, 0x41, 0x05, 0x4b, 0x0d, 0x18, 0x20, 0x05, 0x41, 0xd5,
  0xef, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x0c, 0x26, 0x0b, 0x20, 0x05, 0x41,
  0x02, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x15, 0x41, 0x01, 0x4b, 0x0d,
  0x17, 0x0c, 0x26, 0x0b, 0x20, 0x05, 0x41, 0x02, 0x36, 0x02, 0x90, 0x83,
  0x01, 0x20, 0x15, 0x41, 0x01, 0x4d, 0x0d, 0x25, 0x20, 0x00, 0x20, 0x0a,
  0x2d, 0x00, 0x06, 0x3a, 0x00, 0xcc, 0xc0, 0x04, 0x20, 0x00, 0x20, 0x0a,
  0x2d, 0x00, 0x07, 0x3a, 0x00, 0xcd, 0xc0, 0x04, 0x20, 0x05, 0x41, 0x03,
  0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x1c, 0x41, 0x08, 0x6b, 0x22, 0x03,
  0x41, 0x02, 0x4d, 0x0d, 0x23, 0x20, 0x00, 0x20, 0x0a, 0x2d, 0x00, 0x08,
  0x22, 0x02, 0x3a, 0x00, 0xce, 0xc0, 0x04, 0x20, 0x02, 0x41, 0x01, 0x71,
  0x45, 0x0d, 0x10, 0x20, 0x00, 0x20, 0x0a, 0x2f, 0x00, 0x09, 0x22, 0x10,
  0x3b, 0x01, 0xd0, 0xc0, 0x04, 0x20, 0x0a, 0x41, 0x0b, 0x6a, 0x21, 0x02,
  0x02, 0x40, 0x20, 0x10, 0x45, 0x0d, 0x00, 0x41, 0x00, 0x21, 0x03, 0x20,
  0x00, 0x20, 0x10, 0x41, 0x03, 0x74, 0x22, 0x06, 0x10, 0x27, 0x41, 0x00,
  0x20, 0x06, 0x10, 0x29, 0x22, 0x0c, 0x36, 0x02, 0xd4, 0xc0, 0x04, 0x20,
  0x10, 0x41, 0x01, 0x6b, 0x21, 0x0a, 0x03, 0x40, 0x20, 0x05, 0x41, 0x08,
  0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x0f, 0x20, 0x02, 0x6b, 0x22, 0x06,
  0x41, 0x07, 0x4d, 0x0d, 0x13, 0x20, 0x0c, 0x20, 0x03, 0x41, 0x03, 0x74,
  0x6a, 0x22, 0x06, 0x20, 0x02, 0x2f, 0x00, 0x00, 0x3b, 0x01, 0x00, 0x20,
  0x06, 0x20, 0x02, 0x2f, 0x00, 0x02, 0x3b, 0x01, 0x02, 0x20, 0x06, 0x20,
  0x02, 0x2f, 0x00, 0x04, 0x3b, 0x01, 0x04, 0x20, 0x06, 0x20, 0x02, 0x2f,
  0x00, 0x06, 0x3b, 0x01, 0x06, 0x20, 0x02, 0x41, 0x08, 0x6a, 0x21, 0x02,
  0x20, 0x03, 0x20, 0x0a, 0x46, 0x0d, 0x01, 0x20, 0x03, 0x41, 0x01, 0x6a,
  0x21, 0x03, 0x0c, 0x00, 0x0b, 0x00, 0x0b, 0x20, 0x05, 0x41, 0x04, 0x36,
  0x02, 0x90, 0x83, 0x01, 0x20, 0x0f, 0x20, 0x02, 0x6b, 0x22, 0x03, 0x41,
  0x03, 0x4d, 0x0d, 0x23, 0x20, 0x00, 0x20, 0x02, 0x2f, 0x00, 0x00, 0x22,
  0x03, 0x3b, 0x01, 0xd8, 0xc0, 0x04, 0x20, 0x03, 0x41, 0xc1, 0x95, 0x03,
  0x47, 0x0d, 0x12, 0x20, 0x00, 0x20, 0x02, 0x2f, 0x00, 0x02, 0x22, 0x02,
  0x3b, 0x01, 0xda, 0xc0, 0x04, 0x20, 0x02, 0x41, 0x01, 0x46, 0x0d, 0x16,
  0x41, 0x03, 0x41, 0xee, 0xee, 0x03, 0x10, 0x26, 0x0c, 0x28, 0x0b, 0x20,
  0x05, 0x42, 0x00, 0x37, 0x03, 0x80, 0x02, 0x20, 0x05, 0x41, 0x80, 0x80,
  0x88, 0xd6, 0x7c, 0x36, 0x02, 0xec, 0x01, 0x20, 0x05, 0x41, 0xf8, 0xf4,
  0x05, 0x36, 0x02, 0xe8, 0x01, 0x20, 0x05, 0x42, 0x00, 0x37, 0x03, 0xf0,
  0x01, 0x20, 0x05, 0x42, 0x00, 0x37, 0x03, 0xe0, 0x01, 0x20, 0x05, 0x42,
  0x00, 0x37, 0x03, 0xd8, 0x01, 0x20, 0x05, 0x42, 0x00, 0x37, 0x03, 0xd0,
  0x01, 0x41, 0x00, 0x21, 0x02, 0x20, 0x00, 0x2f, 0x01, 0xd0, 0xc0, 0x04,
  0x45, 0x0d, 0x14, 0x03, 0x40, 0x41, 0x00, 0x20, 0x00, 0x28, 0x02, 0xd4,
  0xc0, 0x04, 0x20, 0x02, 0x41, 0x03, 0x74, 0x6a, 0x22, 0x0c, 0x2f, 0x01,
  0x06, 0x22, 0x03, 0x20, 0x03, 0x41, 0x01, 0x6b, 0x20, 0x0c, 0x2f, 0x01,
  0x04, 0x22, 0x06, 0x41, 0x01, 0x6b, 0x72, 0x41, 0x80, 0x80, 0x02, 0x71,
  0x22, 0x03, 0x1b, 0x21, 0x16, 0x41, 0x00, 0x20, 0x06, 0x20, 0x03, 0x1b,
  0x21, 0x10, 0x20, 0x0c, 0x33, 0x01, 0x02, 0x21, 0x69, 0x20, 0x0c, 0x33,
  0x01, 0x00, 0x21, 0x68, 0x02, 0x40, 0x20, 0x05, 0x28, 0x02, 0xd4, 0x01,
  0x22, 0x03, 0x20, 0x05, 0x28, 0x02, 0xd8, 0x01, 0x47, 0x04, 0x40, 0x20,
  0x03, 0x20, 0x16, 0xad, 0x42, 0x30, 0x86, 0x20, 0x10, 0xad, 0x42, 0xff,
  0xff, 0x03, 0x83, 0x42, 0x20, 0x86, 0x84, 0x20, 0x69, 0x42, 0x10, 0x86,
  0x84, 0x20, 0x68, 0x84, 0x37, 0x01, 0x00, 0x20, 0x05, 0x20, 0x03, 0x41,
  0x08, 0x6a, 0x36, 0x02, 0xd4, 0x01, 0x0c, 0x01, 0x0b, 0x20, 0x03, 0x20,
  0x05, 0x28, 0x02, 0xd0, 0x01, 0x22, 0x13, 0x6b, 0x22, 0x17, 0x41, 0x03,
  0x75, 0x22, 0x0c, 0x41, 0x01, 0x6a, 0x22, 0x06, 0x41, 0x80, 0x80, 0x80,
  0x80, 0x02, 0x4f, 0x0d, 0x14, 0x20, 0x06, 0x20, 0x17, 0x41, 0x02, 0x75,
  0x22, 0x03, 0x20, 0x03, 0x20, 0x06, 0x49, 0x1b, 0x41, 0xff, 0xff, 0xff,
  0xff, 0x01, 0x20, 0x0c, 0x41, 0xff, 0xff, 0xff, 0xff, 0x00, 0x49, 0x1b,
  0x22, 0x19, 0x04, 0x7f, 0x20, 0x19, 0x41, 0x80, 0x80, 0x80, 0x80, 0x02,
  0x4f, 0x0d, 0x16, 0x20, 0x19, 0x41, 0x03, 0x74, 0x10, 0x27, 0x05, 0x41,
  0x00, 0x0b, 0x22, 0x06, 0x20, 0x0c, 0x41, 0x03, 0x74, 0x6a, 0x22, 0x03,
  0x20, 0x16, 0xad, 0x42, 0x30, 0x86, 0x20, 0x10, 0xad, 0x42, 0xff, 0xff,
  0x03, 0x83, 0x42, 0x20, 0x86, 0x84, 0x20, 0x69, 0x42, 0x10, 0x86, 0x84,
  0x20, 0x68, 0x84, 0x37, 0x01, 0x00, 0x20, 0x17, 0x41, 0x01, 0x4e, 0x04,
  0x40, 0x20, 0x06, 0x20, 0x13, 0x20, 0x17, 0x10, 0x24, 0x1a, 0x0b, 0x20,
  0x05, 0x20, 0x06, 0x20, 0x19, 0x41, 0x03, 0x74, 0x6a, 0x36, 0x02, 0xd8,
  0x01, 0x20, 0x05, 0x20, 0x03, 0x41, 0x08, 0x6a, 0x36, 0x02, 0xd4, 0x01,
  0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0xd0, 0x01, 0x20, 0x13, 0x45, 0x0d,
  0x00, 0x20, 0x13, 0x10, 0x23, 0x0b, 0x20, 0x02, 0x41, 0x01, 0x6a, 0x22,
  0x02, 0x20, 0x00, 0x2f, 0x01, 0xd0, 0xc0, 0x04, 0x49, 0x0d, 0x00, 0x0b,
  0x0c, 0x14, 0x0b, 0x20, 0x05, 0x10, 0x00, 0x22, 0x02, 0x36, 0x02, 0x28,
  0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x24, 0x20, 0x05, 0x41, 0xf3, 0xe3,
  0x03, 0x36, 0x02, 0x20, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x2c, 0x41,
  0x03, 0x41, 0xe2, 0x80, 0x04, 0x20, 0x05, 0x41, 0x20, 0x6a, 0x10, 0x22,
  0x0c, 0x14, 0x0b, 0x41, 0x03, 0x41, 0x88, 0xd8, 0x03, 0x20, 0x05, 0x41,
  0x88, 0x02, 0x6a, 0x10, 0x31, 0x0c, 0x25, 0x0b, 0x20, 0x05, 0x41, 0xb8,
  0xd8, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02,
  0xb0, 0x02, 0x0c, 0x23, 0x0b, 0x20, 0x05, 0x41, 0xeb, 0xd7, 0x03, 0x36,
  0x02, 0xe0, 0x42, 0x0c, 0x21, 0x0b, 0x41, 0x03, 0x41, 0xf8, 0xae, 0x03,
  0x10, 0x26, 0x0c, 0x22, 0x0b, 0x41, 0x03, 0x41, 0xd6, 0xdb, 0x02, 0x10,
  0x26, 0x0c, 0x21, 0x0b, 0x20, 0x05, 0x41, 0xbb, 0xd0, 0x03, 0x36, 0x02,
  0xe0, 0x42, 0x0c, 0x1c, 0x0b, 0x41, 0x03, 0x41, 0xd7, 0x9f, 0x03, 0x10,
  0x26, 0x0c, 0x1f, 0x0b, 0x20, 0x05, 0x41, 0x9e, 0xdf, 0x03, 0x36, 0x02,
  0xe0, 0x42, 0x0c, 0x1c, 0x0b, 0x41, 0x03, 0x41, 0xe7, 0xdd, 0x03, 0x10,
  0x26, 0x0c, 0x1d, 0x0b, 0x41, 0x03, 0x41, 0xa4, 0xde, 0x03, 0x10, 0x26,
  0x0c, 0x1c, 0x0b, 0x41, 0x03, 0x41, 0xdf, 0xde, 0x03, 0x10, 0x26, 0x0c,
  0x1b, 0x0b, 0x20, 0x05, 0x41, 0xe0, 0xe0, 0x03, 0x36, 0x02, 0xe0, 0x42,
  0x20, 0x05, 0x41, 0x00, 0x36, 0x02, 0xb0, 0x02, 0x0c, 0x19, 0x0b, 0x20,
  0x05, 0x41, 0xca, 0xd4, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x0c, 0x15, 0x0b,
  0x41, 0x03, 0x41, 0x9b, 0xa6, 0x03, 0x10, 0x26, 0x0c, 0x18, 0x0b, 0x41,
  0x03, 0x41, 0xbd, 0x9e, 0x04, 0x10, 0x26, 0x0c, 0x17, 0x0b, 0x20, 0x05,
  0x41, 0x80, 0xda, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x20, 0x05, 0x20, 0x06,
  0x36, 0x02, 0xb0, 0x02, 0x0c, 0x15, 0x0b, 0x41, 0x03, 0x41, 0xbc, 0xee,
  0x03, 0x10, 0x26, 0x0c, 0x15, 0x0b, 0x10, 0x37, 0x00, 0x0b, 0x41, 0xe6,
  0xf5, 0x02, 0x10, 0x48, 0x00, 0x0b, 0x20, 0x05, 0x41, 0x02, 0x36, 0x02,
  0x90, 0x83, 0x01, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x02, 0x40, 0x20, 0x15, 0x41, 0x01, 0x4b, 0x04, 0x40, 0x20, 0x05,
  0x20, 0x0a, 0x2d, 0x00, 0x06, 0x3a, 0x00, 0xec, 0x01, 0x20, 0x05, 0x20,
  0x0a, 0x2d, 0x00, 0x07, 0x3a, 0x00, 0xed, 0x01, 0x20, 0x05, 0x41, 0x0c,
  0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x1c, 0x41, 0x08, 0x6b, 0x22, 0x03,
  0x41, 0x0b, 0x4d, 0x0d, 0x01, 0x20, 0x05, 0x20, 0x0a, 0x2f, 0x00, 0x08,
  0x22, 0x02, 0x3b, 0x01, 0xee, 0x01, 0x20, 0x02, 0x41, 0xc2, 0x95, 0x03,
  0x47, 0x0d, 0x02, 0x20, 0x05, 0x20, 0x0a, 0x2f, 0x00, 0x0a, 0x22, 0x02,
  0x3b, 0x01, 0xf0, 0x01, 0x20, 0x02, 0x0d, 0x03, 0x20, 0x05, 0x20, 0x0a,
  0x2d, 0x00, 0x0c, 0x20, 0x0a, 0x2d, 0x00, 0x0d, 0x22, 0x02, 0x41, 0x08,
  0x74, 0x72, 0x3b, 0x01, 0xf2, 0x01, 0x20, 0x05, 0x20, 0x02, 0x41, 0x02,
  0x76, 0x41, 0x0f, 0x71, 0x22, 0x03, 0x3a, 0x00, 0xaf, 0x02, 0x41, 0x00,
  0x21, 0x02, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x03, 0x41, 0x01,
  0x6b, 0x0e, 0x04, 0x02, 0x00, 0x00, 0x01, 0x00, 0x0b, 0x41, 0x03, 0x41,
  0xed, 0xd5, 0x03, 0x20, 0x05, 0x41, 0xaf, 0x02, 0x6a, 0x10, 0x3b, 0x0c,
  0x1b, 0x0b, 0x41, 0x01, 0x21, 0x02, 0x0b, 0x20, 0x05, 0x20, 0x02, 0x36,
  0x02, 0xf4, 0x01, 0x20, 0x05, 0x20, 0x0a, 0x2d, 0x00, 0x0e, 0x22, 0x16,
  0x3a, 0x00, 0xf8, 0x01, 0x20, 0x16, 0x04, 0x40, 0x20, 0x05, 0x20, 0x16,
  0x41, 0x0a, 0x6c, 0x22, 0x02, 0x10, 0x27, 0x41, 0x00, 0x20, 0x02, 0x10,
  0x29, 0x36, 0x02, 0x80, 0x02, 0x0b, 0x20, 0x05, 0x20, 0x0a, 0x2d, 0x00,
  0x0f, 0x22, 0x02, 0x3a, 0x00, 0xf9, 0x01, 0x20, 0x02, 0x41, 0xc0, 0x00,
  0x47, 0x0d, 0x04, 0x20, 0x05, 0x20, 0x0a, 0x2f, 0x00, 0x10, 0x22, 0x03,
  0x3b, 0x01, 0xfa, 0x01, 0x20, 0x03, 0x04, 0x40, 0x20, 0x03, 0x41, 0x05,
  0x74, 0x22, 0x10, 0x41, 0x04, 0x72, 0x10, 0x27, 0x22, 0x02, 0x20, 0x03,
  0x36, 0x02, 0x00, 0x20, 0x02, 0x41, 0x04, 0x6a, 0x22, 0x0c, 0x21, 0x02,
  0x20, 0x10, 0x41, 0x20, 0x6b, 0x22, 0x03, 0x41, 0x05, 0x76, 0x41, 0x01,
  0x6a, 0x41, 0x03, 0x71, 0x22, 0x06, 0x04, 0x40, 0x03, 0x40, 0x20, 0x02,
  0x42, 0x00, 0x37, 0x02, 0x04, 0x20, 0x02, 0x41, 0x00, 0x36, 0x02, 0x1c,
  0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x14, 0x20, 0x02, 0x41, 0x88, 0xf5,
  0x05, 0x36, 0x02, 0x00, 0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x0c, 0x20,
  0x02, 0x41, 0x20, 0x6a, 0x21, 0x02, 0x20, 0x06, 0x41, 0x01, 0x6b, 0x22,
  0x06, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x03, 0x41, 0xe0, 0x00, 0x4f, 0x04,
  0x40, 0x20, 0x0c, 0x20, 0x10, 0x6a, 0x21, 0x03, 0x03, 0x40, 0x20, 0x02,
  0x42, 0x00, 0x37, 0x02, 0x04, 0x20, 0x02, 0x41, 0x00, 0x36, 0x02, 0x1c,
  0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x14, 0x20, 0x02, 0x41, 0x88, 0xf5,
  0x05, 0x36, 0x02, 0x00, 0x20, 0x02, 0x41, 0x88, 0xf5, 0x05, 0x36, 0x02,
  0x20, 0x20, 0x02, 0x41, 0x88, 0xf5, 0x05, 0x36, 0x02, 0x40, 0x20, 0x02,
  0x42, 0x00, 0x37, 0x02, 0x0c, 0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x24,
  0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x2c, 0x20, 0x02, 0x42, 0x00, 0x37,
  0x02, 0x44, 0x20, 0x02, 0x41, 0x00, 0x36, 0x02, 0x3c, 0x20, 0x02, 0x42,
  0x00, 0x37, 0x02, 0x34, 0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x4c, 0x20,
  0x02, 0x41, 0x00, 0x36, 0x02, 0x5c, 0x20, 0x02, 0x42, 0x00, 0x37, 0x02,
  0x54, 0x20, 0x02, 0x42, 0x00, 0x37, 0x02, 0x6c, 0x20, 0x02, 0x42, 0x00,
  0x37, 0x02, 0x64, 0x20, 0x02, 0x41, 0x00, 0x36, 0x02, 0x7c, 0x20, 0x02,
  0x42, 0x00, 0x37, 0x02, 0x74, 0x20, 0x02, 0x41, 0x88, 0xf5, 0x05, 0x36,
  0x02, 0x60, 0x20, 0x02, 0x41, 0x80, 0x01, 0x6a, 0x22, 0x02, 0x20, 0x03,
  0x47, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x05, 0x20, 0x0c, 0x36, 0x02, 0x84,
  0x02, 0x0b, 0x20, 0x05, 0x20, 0x0a, 0x28, 0x00, 0x12, 0x22, 0x1c, 0x36,
  0x02, 0xfc, 0x01, 0x20, 0x0a, 0x41, 0x16, 0x6a, 0x21, 0x02, 0x20, 0x16,
  0x45, 0x04, 0x40, 0x41, 0x00, 0x21, 0x13, 0x0c, 0x07, 0x0b, 0x20, 0x05,
  0x2d, 0x00, 0xf8, 0x01, 0x22, 0x13, 0x41, 0x01, 0x20, 0x13, 0x41, 0x01,
  0x4b, 0x1b, 0x21, 0x0c, 0x41, 0x00, 0x21, 0x15, 0x20, 0x05, 0x28, 0x02,
  0x80, 0x02, 0x21, 0x06, 0x03, 0x40, 0x20, 0x05, 0x41, 0x05, 0x36, 0x02,
  0x90, 0x83, 0x01, 0x20, 0x0f, 0x20, 0x02, 0x6b, 0x22, 0x03, 0x41, 0x04,
  0x4d, 0x0d, 0x06, 0x20, 0x02, 0x2d, 0x00, 0x00, 0x21, 0x19, 0x20, 0x02,
  0x2d, 0x00, 0x01, 0x21, 0x16, 0x20, 0x02, 0x2d, 0x00, 0x02, 0x21, 0x10,
  0x20, 0x06, 0x20, 0x15, 0x41, 0x0a, 0x6c, 0x6a, 0x22, 0x17, 0x20, 0x02,
  0x2d, 0x00, 0x03, 0x22, 0x03, 0x41, 0x04, 0x76, 0x3a, 0x00, 0x07, 0x20,
  0x17, 0x20, 0x03, 0x41, 0x0f, 0x71, 0x3a, 0x00, 0x06, 0x20, 0x17, 0x20,
  0x10, 0x41, 0x04, 0x76, 0x3a, 0x00, 0x05, 0x20, 0x17, 0x20, 0x10, 0x41,
  0x0f, 0x71, 0x3a, 0x00, 0x04, 0x20, 0x17, 0x20, 0x16, 0x41, 0x04, 0x76,
  0x3a, 0x00, 0x03, 0x20, 0x17, 0x20, 0x16, 0x41, 0x0f, 0x71, 0x3a, 0x00,
  0x02, 0x20, 0x17, 0x20, 0x19, 0x41, 0x04, 0x76, 0x3a, 0x00, 0x01, 0x20,
  0x17, 0x20, 0x19, 0x41, 0x0f, 0x71, 0x3a, 0x00, 0x00, 0x20, 0x17, 0x20,
  0x02, 0x2d, 0x00, 0x04, 0x22, 0x03, 0x41, 0x04, 0x76, 0x3a, 0x00, 0x09,
  0x20, 0x17, 0x20, 0x03, 0x41, 0x0f, 0x71, 0x3a, 0x00, 0x08, 0x20, 0x02,
  0x41, 0x05, 0x6a, 0x21, 0x02, 0x20, 0x0c, 0x20, 0x15, 0x41, 0x01, 0x6a,
  0x22, 0x15, 0x47, 0x0d, 0x00, 0x0b, 0x0c, 0x06, 0x0b, 0x0c, 0x15, 0x0b,
  0x20, 0x05, 0x41, 0xbf, 0xd7, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x0c, 0x13,
  0x0b, 0x41, 0x03, 0x41, 0x9f, 0xd6, 0x03, 0x10, 0x26, 0x0c, 0x16, 0x0b,
  0x41, 0x03, 0x41, 0xdd, 0xd6, 0x03, 0x10, 0x26, 0x0c, 0x15, 0x0b, 0x41,
  0x03, 0x41, 0x8d, 0xd7, 0x03, 0x10, 0x26, 0x0c, 0x14, 0x0b, 0x20, 0x05,
  0x41, 0x86, 0xd4, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x0c, 0x0f, 0x0b, 0x20,
  0x05, 0x20, 0x1c, 0x36, 0x02, 0x90, 0x83, 0x01, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x20, 0x1c, 0x20, 0x0f, 0x20, 0x02,
  0x6b, 0x22, 0x03, 0x4d, 0x04, 0x40, 0x20, 0x05, 0x2f, 0x01, 0xfa, 0x01,
  0x22, 0x10, 0x45, 0x0d, 0x05, 0x20, 0x02, 0x20, 0x1c, 0x6a, 0x21, 0x17,
  0x41, 0x00, 0x21, 0x19, 0x20, 0x05, 0x28, 0x02, 0x84, 0x02, 0x21, 0x0c,
  0x03, 0x40, 0x20, 0x05, 0x41, 0x0d, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20,
  0x17, 0x20, 0x02, 0x6b, 0x22, 0x03, 0x41, 0x0c, 0x4d, 0x0d, 0x02, 0x20,
  0x02, 0x2f, 0x00, 0x00, 0x41, 0xc3, 0x95, 0x03, 0x47, 0x0d, 0x03, 0x20,
  0x02, 0x41, 0x06, 0x6a, 0x21, 0x03, 0x20, 0x02, 0x2f, 0x00, 0x02, 0x22,
  0x16, 0x41, 0x05, 0x4d, 0x04, 0x40, 0x20, 0x17, 0x20, 0x03, 0x6b, 0x21,
  0x22, 0x0c, 0x14, 0x0b, 0x20, 0x17, 0x20, 0x03, 0x6b, 0x22, 0x22, 0x20,
  0x16, 0x41, 0x06, 0x6b, 0x49, 0x0d, 0x13, 0x20, 0x0c, 0x20, 0x19, 0x41,
  0x05, 0x74, 0x6a, 0x22, 0x1e, 0x20, 0x02, 0x2d, 0x00, 0x06, 0x3a, 0x00,
  0x04, 0x20, 0x1e, 0x20, 0x02, 0x2d, 0x00, 0x07, 0x3a, 0x00, 0x05, 0x20,
  0x1e, 0x20, 0x02, 0x2d, 0x00, 0x08, 0x3a, 0x00, 0x06, 0x20, 0x1e, 0x20,
  0x02, 0x2f, 0x00, 0x09, 0x3b, 0x01, 0x08, 0x20, 0x1e, 0x20, 0x02, 0x2f,
  0x00, 0x0b, 0x3b, 0x01, 0x0a, 0x20, 0x1e, 0x20, 0x02, 0x2f, 0x00, 0x0d,
  0x22, 0x25, 0x3b, 0x01, 0x0c, 0x20, 0x1e, 0x20, 0x02, 0x2f, 0x00, 0x0f,
  0x22, 0x15, 0x3b, 0x01, 0x0e, 0x20, 0x1e, 0x20, 0x02, 0x2f, 0x00, 0x11,
  0x22, 0x13, 0x3b, 0x01, 0x10, 0x20, 0x05, 0x20, 0x13, 0x20, 0x15, 0x20,
  0x25, 0x6a, 0x6a, 0x22, 0x03, 0x36, 0x02, 0x90, 0x83, 0x01, 0x20, 0x03,
  0x20, 0x22, 0x4b, 0x0d, 0x04, 0x20, 0x1e, 0x20, 0x25, 0x10, 0x27, 0x41,
  0x00, 0x20, 0x25, 0x10, 0x29, 0x22, 0x03, 0x36, 0x02, 0x14, 0x20, 0x03,
  0x20, 0x02, 0x41, 0x13, 0x6a, 0x22, 0x06, 0x20, 0x25, 0x10, 0x24, 0x1a,
  0x20, 0x1e, 0x20, 0x15, 0x10, 0x27, 0x41, 0x00, 0x20, 0x15, 0x10, 0x29,
  0x22, 0x03, 0x36, 0x02, 0x18, 0x20, 0x03, 0x20, 0x06, 0x20, 0x25, 0x6a,
  0x22, 0x06, 0x20, 0x15, 0x10, 0x24, 0x1a, 0x20, 0x1e, 0x20, 0x13, 0x10,
  0x27, 0x41, 0x00, 0x20, 0x13, 0x10, 0x29, 0x22, 0x03, 0x36, 0x02, 0x1c,
  0x20, 0x03, 0x20, 0x06, 0x20, 0x15, 0x6a, 0x20, 0x13, 0x10, 0x24, 0x1a,
  0x20, 0x02, 0x20, 0x16, 0x6a, 0x21, 0x02, 0x20, 0x10, 0x20, 0x19, 0x41,
  0x01, 0x6a, 0x22, 0x19, 0x47, 0x0d, 0x00, 0x0b, 0x0c, 0x04, 0x0b, 0x20,
  0x05, 0x41, 0xc7, 0xf6, 0x02, 0x36, 0x02, 0xe0, 0x42, 0x0c, 0x13, 0x0b,
  0x20, 0x05, 0x41, 0xa8, 0x81, 0x04, 0x36, 0x02, 0xe0, 0x42, 0x0c, 0x12,
  0x0b, 0x41, 0x03, 0x41, 0xce, 0x81, 0x04, 0x10, 0x26, 0x0c, 0x15, 0x0b,
  0x20, 0x05, 0x41, 0xa8, 0x81, 0x04, 0x36, 0x02, 0xe0, 0x42, 0x20, 0x05,
  0x20, 0x22, 0x36, 0x02, 0xb0, 0x02, 0x0c, 0x13, 0x0b, 0x20, 0x05, 0x2d,
  0x00, 0xf8, 0x01, 0x21, 0x13, 0x0b, 0x20, 0x05, 0x2f, 0x01, 0x9e, 0x01,
  0x21, 0x03, 0x20, 0x05, 0x20, 0x05, 0x2f, 0x01, 0x9c, 0x01, 0x41, 0x3f,
  0x6a, 0x41, 0x40, 0x71, 0x22, 0x02, 0x3b, 0x01, 0x92, 0x02, 0x20, 0x05,
  0x20, 0x02, 0x41, 0x02, 0x74, 0x22, 0x02, 0x3b, 0x01, 0x90, 0x02, 0x41,
  0x00, 0x21, 0x17, 0x20, 0x05, 0x20, 0x03, 0x41, 0x3f, 0x6a, 0x41, 0xc0,
  0xff, 0x03, 0x71, 0x20, 0x02, 0x41, 0x80, 0xfe, 0x03, 0x71, 0x6c, 0x41,
  0x02, 0x74, 0x22, 0x02, 0x10, 0x27, 0x41, 0x00, 0x20, 0x02, 0x10, 0x29,
  0x36, 0x02, 0x94, 0x02, 0x20, 0x05, 0x20, 0x1c, 0x20, 0x13, 0x41, 0x05,
  0x6c, 0x6a, 0x41, 0x0c, 0x6a, 0x36, 0x02, 0xa8, 0x02, 0x20, 0x05, 0x20,
  0x0a, 0x41, 0x08, 0x6a, 0x36, 0x02, 0xa4, 0x02, 0x20, 0x05, 0x20, 0x05,
  0x29, 0x03, 0x90, 0x01, 0x37, 0x03, 0x98, 0x02, 0x20, 0x05, 0x20, 0x05,
  0x41, 0xd0, 0x01, 0x6a, 0x36, 0x02, 0xa0, 0x02, 0x20, 0x10, 0x04, 0x40,
  0x03, 0x40, 0x20, 0x05, 0x28, 0x02, 0x84, 0x02, 0x20, 0x17, 0x41, 0x05,
  0x74, 0x6a, 0x22, 0x13, 0x2d, 0x00, 0x04, 0x21, 0x0c, 0x20, 0x05, 0x28,
  0x02, 0x80, 0x02, 0x21, 0x19, 0x20, 0x05, 0x28, 0x02, 0xf4, 0x01, 0x22,
  0x16, 0x20, 0x13, 0x28, 0x02, 0x14, 0x20, 0x13, 0x2f, 0x01, 0x0c, 0x20,
  0x05, 0x41, 0x90, 0x83, 0x01, 0x6a, 0x10, 0xa0, 0x01, 0x41, 0xc0, 0x1f,
  0x21, 0x02, 0x20, 0x05, 0x2f, 0x01, 0x90, 0xc2, 0x01, 0x21, 0x06, 0x03,
  0x40, 0x20, 0x05, 0x41, 0x90, 0x83, 0x01, 0x6a, 0x22, 0x0a, 0x20, 0x02,
  0x41, 0x01, 0x74, 0x6a, 0x22, 0x10, 0x22, 0x03, 0x20, 0x03, 0x2f, 0x01,
  0x02, 0x20, 0x06, 0x6a, 0x22, 0x03, 0x3b, 0x01, 0x02, 0x20, 0x10, 0x20,
  0x10, 0x2f, 0x01, 0x04, 0x20, 0x03, 0x6a, 0x22, 0x06, 0x3b, 0x01, 0x04,
  0x20, 0x02, 0x41, 0x03, 0x6a, 0x22, 0x02, 0x41, 0x01, 0x74, 0x20, 0x0a,
  0x6a, 0x22, 0x03, 0x20, 0x03, 0x2f, 0x01, 0x00, 0x20, 0x06, 0x6a, 0x22,
  0x06, 0x3b, 0x01, 0x00, 0x20, 0x02, 0x41, 0xff, 0x1f, 0x47, 0x0d, 0x00,
  0x0b, 0x20, 0x05, 0x41, 0x90, 0x83, 0x01, 0x6a, 0x22, 0x02, 0x20, 0x19,
  0x20, 0x0c, 0x41, 0x0a, 0x6c, 0x6a, 0x10, 0xa1, 0x01, 0x20, 0x18, 0x20,
  0x05, 0x41, 0xc0, 0xc3, 0x01, 0x6a, 0x22, 0x03, 0x41, 0x08, 0x10, 0x5c,
  0x20, 0x1b, 0x20, 0x03, 0x41, 0x10, 0x10, 0x5c, 0x20, 0x02, 0x20, 0x03,
  0x41, 0x20, 0x10, 0x5c, 0x20, 0x13, 0x2d, 0x00, 0x05, 0x21, 0x0c, 0x20,
  0x16, 0x20, 0x13, 0x28, 0x02, 0x18, 0x20, 0x13, 0x2f, 0x01, 0x0e, 0x20,
  0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x10, 0xa0, 0x01, 0x41, 0xc0, 0x1f,
  0x21, 0x02, 0x20, 0x05, 0x2f, 0x01, 0xe0, 0x81, 0x01, 0x21, 0x06, 0x03,
  0x40, 0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x22, 0x0a, 0x20, 0x02,
  0x41, 0x01, 0x74, 0x6a, 0x22, 0x10, 0x22, 0x03, 0x20, 0x03, 0x2f, 0x01,
  0x02, 0x20, 0x06, 0x6a, 0x22, 0x03, 0x3b, 0x01, 0x02, 0x20, 0x10, 0x20,
  0x10, 0x2f, 0x01, 0x04, 0x20, 0x03, 0x6a, 0x22, 0x06, 0x3b, 0x01, 0x04,
  0x20, 0x02, 0x41, 0x03, 0x6a, 0x22, 0x02, 0x41, 0x01, 0x74, 0x20, 0x0a,
  0x6a, 0x22, 0x03, 0x20, 0x03, 0x2f, 0x01, 0x00, 0x20, 0x06, 0x6a, 0x22,
  0x06, 0x3b, 0x01, 0x00, 0x20, 0x02, 0x41, 0xff, 0x1f, 0x47, 0x0d, 0x00,
  0x0b, 0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x22, 0x02, 0x20, 0x19,
  0x20, 0x0c, 0x41, 0x0a, 0x6c, 0x6a, 0x10, 0xa1, 0x01, 0x20, 0x12, 0x20,
  0x05, 0x41, 0xc0, 0xc3, 0x01, 0x6a, 0x22, 0x03, 0x41, 0x08, 0x10, 0x5c,
  0x20, 0x35, 0x20, 0x03, 0x41, 0x10, 0x10, 0x5c, 0x20, 0x02, 0x20, 0x03,
  0x41, 0x20, 0x10, 0x5c, 0x20, 0x13, 0x2d, 0x00, 0x06, 0x21, 0x0c, 0x20,
  0x16, 0x20, 0x13, 0x28, 0x02, 0x1c, 0x20, 0x13, 0x2f, 0x01, 0x10, 0x20,
  0x05, 0x41, 0xb0, 0x02, 0x6a, 0x10, 0xa0, 0x01, 0x41, 0xc0, 0x1f, 0x21,
  0x02, 0x20, 0x05, 0x2f, 0x01, 0xb0, 0x41, 0x21, 0x06, 0x03, 0x40, 0x20,
  0x05, 0x41, 0xb0, 0x02, 0x6a, 0x22, 0x0a, 0x20, 0x02, 0x41, 0x01, 0x74,
  0x6a, 0x22, 0x10, 0x22, 0x03, 0x20, 0x03, 0x2f, 0x01, 0x02, 0x20, 0x06,
  0x6a, 0x22, 0x03, 0x3b, 0x01, 0x02, 0x20, 0x10, 0x20, 0x10, 0x2f, 0x01,
  0x04, 0x20, 0x03, 0x6a, 0x22, 0x06, 0x3b, 0x01, 0x04, 0x20, 0x02, 0x41,
  0x03, 0x6a, 0x22, 0x02, 0x41, 0x01, 0x74, 0x20, 0x0a, 0x6a, 0x22, 0x03,
  0x20, 0x03, 0x2f, 0x01, 0x00, 0x20, 0x06, 0x6a, 0x22, 0x06, 0x3b, 0x01,
  0x00, 0x20, 0x02, 0x41, 0xff, 0x1f, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x05,
  0x41, 0xb0, 0x02, 0x6a, 0x22, 0x15, 0x20, 0x19, 0x20, 0x0c, 0x41, 0x0a,
  0x6c, 0x6a, 0x10, 0xa1, 0x01, 0x20, 0x34, 0x20, 0x05, 0x41, 0xc0, 0xc3,
  0x01, 0x6a, 0x22, 0x02, 0x41, 0x08, 0x10, 0x5c, 0x20, 0x33, 0x20, 0x02,
  0x41, 0x10, 0x10, 0x5c, 0x20, 0x15, 0x20, 0x02, 0x41, 0x20, 0x10, 0x5c,
  0x20, 0x05, 0x28, 0x02, 0x94, 0x02, 0x20, 0x13, 0x2f, 0x01, 0x08, 0x41,
  0x08, 0x74, 0x6a, 0x20, 0x05, 0x2f, 0x01, 0x90, 0x02, 0x22, 0x03, 0x20,
  0x13, 0x2f, 0x01, 0x0a, 0x6c, 0x41, 0x06, 0x74, 0x6a, 0x21, 0x02, 0x20,
  0x03, 0x41, 0x80, 0x02, 0x6b, 0x21, 0x0c, 0x41, 0x00, 0x21, 0x22, 0x20,
  0x05, 0x41, 0x90, 0x83, 0x01, 0x6a, 0x21, 0x06, 0x20, 0x05, 0x41, 0xe0,
  0xc2, 0x00, 0x6a, 0x21, 0x03, 0x03, 0x40, 0x41, 0x00, 0x21, 0x13, 0x03,
  0x40, 0x20, 0x03, 0x2e, 0x01, 0x00, 0x21, 0x19, 0x20, 0x06, 0x2f, 0x01,
  0x00, 0x21, 0x0a, 0x20, 0x15, 0x2e, 0x01, 0x00, 0x21, 0x16, 0x20, 0x02,
  0x41, 0xff, 0x01, 0x3a, 0x00, 0x03, 0x20, 0x02, 0x20, 0x0a, 0x41, 0x10,
  0x74, 0x41, 0x80, 0x80, 0x80, 0x80, 0x01, 0x6a, 0x22, 0x10, 0x20, 0x16,
  0x41, 0x8b, 0xce, 0x05, 0x6c, 0x6a, 0x41, 0x15, 0x75, 0x22, 0x0a, 0x41,
  0x00, 0x20, 0x0a, 0x41, 0x00, 0x4a, 0x1b, 0x22, 0x0a, 0x41, 0xff, 0x01,
  0x20, 0x0a, 0x41, 0xff, 0x01, 0x48, 0x1b, 0x3a, 0x00, 0x02, 0x20, 0x02,
  0x20, 0x19, 0x41, 0x98, 0x8a, 0x07, 0x6c, 0x20, 0x10, 0x6a, 0x41, 0x15,
  0x75, 0x22, 0x0a, 0x41, 0x00, 0x20, 0x0a, 0x41, 0x00, 0x4a, 0x1b, 0x22,
  0x0a, 0x41, 0xff, 0x01, 0x20, 0x0a, 0x41, 0xff, 0x01, 0x48, 0x1b, 0x3a,
  0x00, 0x00, 0x20, 0x02, 0x20, 0x19, 0x41, 0x82, 0xd0, 0x7e, 0x6c, 0x20,
  0x10, 0x6a, 0x20, 0x16, 0x41, 0x9e, 0x92, 0x7d, 0x6c, 0x6a, 0x41, 0x15,
  0x75, 0x22, 0x0a, 0x41, 0x00, 0x20, 0x0a, 0x41, 0x00, 0x4a, 0x1b, 0x22,
  0x0a, 0x41, 0xff, 0x01, 0x20, 0x0a, 0x41, 0xff, 0x01, 0x48, 0x1b, 0x3a,
  0x00, 0x01, 0x20, 0x02, 0x41, 0x04, 0x6a, 0x21, 0x02, 0x20, 0x15, 0x41,
  0x02, 0x6a, 0x21, 0x15, 0x20, 0x03, 0x41, 0x02, 0x6a, 0x21, 0x03, 0x20,
  0x06, 0x41, 0x02, 0x6a, 0x21, 0x06, 0x20, 0x13, 0x41, 0x01, 0x6a, 0x22,
  0x13, 0x41, 0xc0, 0x00, 0x47, 0x0d, 0x00, 0x0b, 0x20, 0x02, 0x20, 0x0c,
  0x6a, 0x21, 0x02, 0x20, 0x22, 0x41, 0x3f, 0x49, 0x21, 0x0a, 0x20, 0x22,
  0x41, 0x01, 0x6a, 0x21, 0x22, 0x20, 0x0a, 0x0d, 0x00, 0x0b, 0x20, 0x17,
  0x41, 0x01, 0x6a, 0x22, 0x17, 0x20, 0x05, 0x2f, 0x01, 0xfa, 0x01, 0x49,
  0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0b, 0x20, 0x05, 0x41, 0x90, 0x01, 0x6a,
  0x20, 0x05, 0x41, 0x90, 0x02, 0x6a, 0x20, 0x0b, 0x28, 0x02, 0x00, 0x28,
  0x02, 0x64, 0x11, 0x00, 0x00, 0x20, 0x05, 0x28, 0x02, 0x94, 0x02, 0x22,
  0x02, 0x04, 0x40, 0x20, 0x02, 0x10, 0x23, 0x0b, 0x20, 0x05, 0x28, 0x02,
  0xdc, 0x01, 0x22, 0x02, 0x04, 0x40, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02,
  0xe0, 0x01, 0x20, 0x02, 0x10, 0x23, 0x0b, 0x20, 0x05, 0x28, 0x02, 0xd0,
  0x01, 0x22, 0x02, 0x04, 0x40, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0xd4,
  0x01, 0x20, 0x02, 0x10, 0x23, 0x0b, 0x20, 0x05, 0x41, 0xf8, 0xf4, 0x05,
  0x36, 0x02, 0xe8, 0x01, 0x20, 0x05, 0x28, 0x02, 0x80, 0x02, 0x22, 0x02,
  0x04, 0x40, 0x20, 0x02, 0x10, 0x23, 0x0b, 0x20, 0x05, 0x28, 0x02, 0x84,
  0x02, 0x22, 0x0c, 0x45, 0x0d, 0x00, 0x20, 0x0c, 0x41, 0x04, 0x6b, 0x22,
  0x0a, 0x28, 0x02, 0x00, 0x22, 0x02, 0x04, 0x40, 0x20, 0x0c, 0x20, 0x02,
  0x41, 0x05, 0x74, 0x6a, 0x21, 0x02, 0x03, 0x40, 0x20, 0x02, 0x41, 0x20,
  0x6b, 0x22, 0x03, 0x41, 0x88, 0xf5, 0x05, 0x36, 0x02, 0x00, 0x20, 0x03,
  0x28, 0x02, 0x14, 0x22, 0x06, 0x04, 0x40, 0x20, 0x06, 0x10, 0x23, 0x0b,
  0x20, 0x02, 0x41, 0x08, 0x6b, 0x28, 0x02, 0x00, 0x22, 0x06, 0x04, 0x40,
  0x20, 0x06, 0x10, 0x23, 0x0b, 0x20, 0x02, 0x41, 0x04, 0x6b, 0x28, 0x02,
  0x00, 0x22, 0x02, 0x04, 0x40, 0x20, 0x02, 0x10, 0x23, 0x0b, 0x20, 0x03,
  0x22, 0x02, 0x20, 0x0c, 0x47, 0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x0a, 0x10,
  0x23, 0x0b, 0x20, 0x31, 0x20, 0x0f, 0x6b, 0x41, 0x05, 0x4b, 0x0d, 0x00,
  0x0b, 0x0c, 0x06, 0x0b, 0x20, 0x05, 0x41, 0xc1, 0xed, 0x02, 0x36, 0x02,
  0xe0, 0x42, 0x0c, 0x10, 0x0b, 0x20, 0x05, 0x41, 0x9e, 0xd3, 0x03, 0x36,
  0x02, 0xe0, 0x42, 0x0c, 0x0f, 0x0b, 0x20, 0x05, 0x41, 0xfc, 0x9a, 0x03,
  0x36, 0x02, 0xe0, 0x42, 0x0c, 0x0e, 0x0b, 0x10, 0x00, 0x21, 0x02, 0x20,
  0x05, 0x20, 0x06, 0x36, 0x02, 0x0c, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02,
  0x08, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x04, 0x20, 0x05, 0x41, 0xf3,
  0xe3, 0x03, 0x36, 0x02, 0x00, 0x41, 0x03, 0x41, 0xe3, 0x17, 0x20, 0x05,
  0x10, 0x22, 0x0c, 0x03, 0x0b, 0x20, 0x05, 0x41, 0x06, 0x36, 0x02, 0xcc,
  0x01, 0x20, 0x03, 0x20, 0x0f, 0x6b, 0x22, 0x03, 0x41, 0x05, 0x4b, 0x04,
  0x40, 0x20, 0x11, 0x20, 0x02, 0x41, 0x04, 0x6a, 0x36, 0x02, 0x08, 0x20,
  0x05, 0x20, 0x02, 0x2f, 0x00, 0x02, 0x22, 0x06, 0x3b, 0x01, 0x90, 0x01,
  0x20, 0x11, 0x20, 0x02, 0x41, 0x08, 0x6a, 0x36, 0x02, 0x08, 0x20, 0x05,
  0x20, 0x02, 0x2d, 0x00, 0x04, 0x22, 0x0a, 0x20, 0x02, 0x2d, 0x00, 0x05,
  0x22, 0x0f, 0x41, 0x08, 0x74, 0x72, 0x20, 0x02, 0x2d, 0x00, 0x06, 0x22,
  0x03, 0x41, 0x10, 0x74, 0x72, 0x20, 0x02, 0x2d, 0x00, 0x07, 0x22, 0x02,
  0x41, 0x18, 0x74, 0x72, 0x22, 0x0c, 0x36, 0x02, 0xc0, 0xc3, 0x01, 0x20,
  0x30, 0x2d, 0x00, 0x00, 0x41, 0x02, 0x71, 0x04, 0x40, 0x41, 0x07, 0x41,
  0x9f, 0xe6, 0x00, 0x20, 0x05, 0x41, 0x90, 0x01, 0x6a, 0x20, 0x05, 0x41,
  0xc0, 0xc3, 0x01, 0x6a, 0x10, 0x63, 0x0b, 0x02, 0x40, 0x02, 0x40, 0x02,
  0x40, 0x20, 0x06, 0x0e, 0x02, 0x00, 0x01, 0x02, 0x0b, 0x10, 0x00, 0x21,
  0x02, 0x20, 0x00, 0x29, 0x02, 0x8c, 0xc2, 0x04, 0x21, 0x68, 0x20, 0x05,
  0x20, 0x02, 0x36, 0x02, 0x64, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x68,
  0x20, 0x05, 0x20, 0x68, 0x37, 0x02, 0x6c, 0x20, 0x05, 0x41, 0xe1, 0xf6,
  0x03, 0x36, 0x02, 0x60, 0x41, 0x07, 0x41, 0xa2, 0xc5, 0x04, 0x20, 0x05,
  0x41, 0xe0, 0x00, 0x6a, 0x10, 0x22, 0x02, 0x40, 0x20, 0x00, 0x28, 0x02,
  0x8c, 0xc2, 0x04, 0x45, 0x0d, 0x00, 0x20, 0x0b, 0x20, 0x0b, 0x28, 0x02,
  0x00, 0x28, 0x02, 0x94, 0x01, 0x11, 0x02, 0x00, 0x20, 0x00, 0x2d, 0x00,
  0xfa, 0xc1, 0x04, 0x45, 0x0d, 0x00, 0x10, 0x00, 0x21, 0x02, 0x20, 0x05,
  0x20, 0x00, 0x28, 0x02, 0x90, 0xc2, 0x04, 0x36, 0x02, 0x5c, 0x20, 0x05,
  0x20, 0x02, 0x36, 0x02, 0x58, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x54,
  0x20, 0x05, 0x41, 0xe1, 0xf6, 0x03, 0x36, 0x02, 0x50, 0x41, 0x07, 0x41,
  0xe3, 0x14, 0x20, 0x05, 0x41, 0xd0, 0x00, 0x6a, 0x10, 0x22, 0x20, 0x00,
  0x28, 0x02, 0xf0, 0x47, 0x21, 0x03, 0x20, 0x00, 0x28, 0x02, 0xa4, 0x3f,
  0x21, 0x0a, 0x20, 0x00, 0x28, 0x02, 0xfc, 0x47, 0x21, 0x06, 0x20, 0x05,
  0x20, 0x00, 0x28, 0x02, 0x90, 0xc2, 0x04, 0x22, 0x02, 0x41, 0x18, 0x76,
  0x3a, 0x00, 0xa6, 0x89, 0x01, 0x20, 0x05, 0x20, 0x02, 0x41, 0x10, 0x76,
  0x3a, 0x00, 0xa5, 0x89, 0x01, 0x20, 0x05, 0x20, 0x02, 0x41, 0x08, 0x76,
  0x3a, 0x00, 0xa4, 0x89, 0x01, 0x20, 0x05, 0x20, 0x02, 0x3a, 0x00, 0xa3,
  0x89, 0x01, 0x20, 0x05, 0x42, 0x80, 0x88, 0xd8, 0x80, 0x80, 0x07, 0x37,
  0x00, 0x9b, 0x89, 0x01, 0x20, 0x05, 0x20, 0x06, 0x3a, 0x00, 0x97, 0x89,
  0x01, 0x20, 0x05, 0x20, 0x06, 0x41, 0x18, 0x76, 0x3a, 0x00, 0x9a, 0x89,
  0x01, 0x20, 0x05, 0x20, 0x06, 0x41, 0x10, 0x76, 0x3a, 0x00, 0x99, 0x89,
  0x01, 0x20, 0x05, 0x20, 0x06, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x98, 0x89,
  0x01, 0x20, 0x00, 0x2f, 0x01, 0xee, 0x47, 0x21, 0x06, 0x20, 0x05, 0x41,
  0x96, 0x80, 0xdc, 0x00, 0x36, 0x00, 0x91, 0x89, 0x01, 0x20, 0x05, 0x20,
  0x06, 0x41, 0xe9, 0x07, 0x6a, 0x22, 0x02, 0x3a, 0x00, 0x95, 0x89, 0x01,
  0x20, 0x05, 0x20, 0x02, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x96, 0x89, 0x01,
  0x20, 0x21, 0x02, 0x7f, 0x20, 0x03, 0x45, 0x04, 0x40, 0x20, 0x06, 0x41,
  0x08, 0x76, 0x21, 0x02, 0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x0c,
  0x01, 0x0b, 0x20, 0x05, 0x41, 0x16, 0x36, 0x02, 0xb4, 0x02, 0x20, 0x05,
  0x20, 0x21, 0x36, 0x02, 0xb0, 0x02, 0x20, 0x05, 0x20, 0x05, 0x29, 0x03,
  0xb0, 0x02, 0x37, 0x03, 0x48, 0x20, 0x05, 0x41, 0x08, 0x36, 0x02, 0xe0,
  0x42, 0x20, 0x27, 0x20, 0x05, 0x41, 0xc8, 0x00, 0x6a, 0x20, 0x2f, 0x10,
  0x44, 0x20, 0x27, 0x20, 0x21, 0x41, 0x16, 0x20, 0x21, 0x10, 0x40, 0x20,
  0x00, 0x2f, 0x01, 0xee, 0x47, 0x22, 0x06, 0x41, 0x08, 0x76, 0x21, 0x02,
  0x20, 0x0d, 0x0b, 0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x22, 0x03,
  0x6b, 0x22, 0x0f, 0x6b, 0x20, 0x03, 0x20, 0x0f, 0x10, 0x24, 0x21, 0x03,
  0x20, 0x05, 0x20, 0x06, 0x3a, 0x00, 0xe2, 0x42, 0x20, 0x05, 0x41, 0xe4,
  0x00, 0x3a, 0x00, 0xe0, 0x42, 0x20, 0x05, 0x20, 0x02, 0x3a, 0x00, 0xe1,
  0x42, 0x20, 0x05, 0x41, 0xf0, 0x00, 0x3a, 0x00, 0xe5, 0x42, 0x20, 0x05,
  0x41, 0x83, 0xd6, 0x03, 0x3b, 0x00, 0xe3, 0x42, 0x20, 0x0f, 0x41, 0x16,
  0x6a, 0x22, 0x0f, 0x21, 0x06, 0x20, 0x07, 0x21, 0x02, 0x20, 0x0f, 0x41,
  0xff, 0xff, 0x03, 0x71, 0x41, 0x80, 0x01, 0x4f, 0x04, 0x40, 0x20, 0x05,
  0x20, 0x0f, 0x3a, 0x00, 0xe7, 0x42, 0x20, 0x0f, 0x41, 0x08, 0x76, 0x41,
  0x80, 0x7f, 0x72, 0x21, 0x06, 0x20, 0x24, 0x21, 0x02, 0x0b, 0x20, 0x05,
  0x20, 0x06, 0x3a, 0x00, 0xe6, 0x42, 0x20, 0x03, 0x20, 0x02, 0x20, 0x05,
  0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x22, 0x02, 0x6b, 0x22, 0x03, 0x6b, 0x20,
  0x02, 0x20, 0x03, 0x10, 0x24, 0x22, 0x02, 0x41, 0x01, 0x6b, 0x41, 0x80,
  0x01, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x41, 0x03, 0x6b, 0x41, 0x82, 0xe0,
  0x03, 0x3b, 0x00, 0x00, 0x20, 0x02, 0x41, 0x04, 0x6b, 0x20, 0x03, 0x20,
  0x0f, 0x6a, 0x41, 0x07, 0x6a, 0x22, 0x03, 0x3a, 0x00, 0x00, 0x20, 0x02,
  0x41, 0x05, 0x6b, 0x20, 0x03, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x00, 0x20,
  0x02, 0x41, 0x07, 0x6b, 0x22, 0x02, 0x41, 0x03, 0x3b, 0x00, 0x00, 0x20,
  0x0a, 0x20, 0x02, 0x20, 0x03, 0x20, 0x0a, 0x28, 0x02, 0x00, 0x28, 0x02,
  0x20, 0x11, 0x00, 0x00, 0x0b, 0x20, 0x00, 0x20, 0x0c, 0x36, 0x02, 0x90,
  0xc2, 0x04, 0x20, 0x00, 0x41, 0x01, 0x36, 0x02, 0x8c, 0xc2, 0x04, 0x20,
  0x0b, 0x20, 0x0b, 0x28, 0x02, 0x00, 0x28, 0x02, 0x90, 0x01, 0x11, 0x02,
  0x00, 0x0c, 0x05, 0x0b, 0x10, 0x00, 0x21, 0x06, 0x20, 0x05, 0x20, 0x0c,
  0x36, 0x02, 0x8c, 0x01, 0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0x88, 0x01,
  0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0x84, 0x01, 0x20, 0x05, 0x41, 0xe1,
  0xf6, 0x03, 0x36, 0x02, 0x80, 0x01, 0x41, 0x07, 0x41, 0xa1, 0x15, 0x20,
  0x05, 0x41, 0x80, 0x01, 0x6a, 0x10, 0x22, 0x20, 0x00, 0x41, 0x00, 0x36,
  0x02, 0x8c, 0xc2, 0x04, 0x20, 0x0b, 0x20, 0x0b, 0x28, 0x02, 0x00, 0x28,
  0x02, 0x94, 0x01, 0x11, 0x02, 0x00, 0x20, 0x00, 0x2d, 0x00, 0xfa, 0xc1,
  0x04, 0x45, 0x0d, 0x04, 0x20, 0x00, 0x28, 0x02, 0xf0, 0x47, 0x21, 0x06,
  0x20, 0x00, 0x28, 0x02, 0xa4, 0x3f, 0x21, 0x0c, 0x20, 0x00, 0x28, 0x02,
  0xfc, 0x47, 0x21, 0x10, 0x20, 0x05, 0x20, 0x02, 0x3a, 0x00, 0xa6, 0x89,
  0x01, 0x20, 0x05, 0x20, 0x03, 0x3a, 0x00, 0xa5, 0x89, 0x01, 0x20, 0x05,
  0x20, 0x0f, 0x3a, 0x00, 0xa4, 0x89, 0x01, 0x20, 0x05, 0x20, 0x0a, 0x3a,
  0x00, 0xa3, 0x89, 0x01, 0x20, 0x05, 0x42, 0x80, 0x88, 0xd8, 0x80, 0x80,
  0x07, 0x37, 0x00, 0x9b, 0x89, 0x01, 0x20, 0x05, 0x20, 0x10, 0x3a, 0x00,
  0x97, 0x89, 0x01, 0x20, 0x05, 0x20, 0x10, 0x41, 0x18, 0x76, 0x3a, 0x00,
  0x9a, 0x89, 0x01, 0x20, 0x05, 0x20, 0x10, 0x41, 0x10, 0x76, 0x3a, 0x00,
  0x99, 0x89, 0x01, 0x20, 0x05, 0x20, 0x10, 0x41, 0x08, 0x76, 0x3a, 0x00,
  0x98, 0x89, 0x01, 0x20, 0x00, 0x2f, 0x01, 0xee, 0x47, 0x21, 0x02, 0x20,
  0x05, 0x41, 0x96, 0x80, 0xdc, 0x00, 0x36, 0x00, 0x91, 0x89, 0x01, 0x20,
  0x05, 0x20, 0x02, 0x41, 0xe9, 0x07, 0x6a, 0x22, 0x03, 0x3a, 0x00, 0x95,
  0x89, 0x01, 0x20, 0x05, 0x20, 0x03, 0x41, 0x08, 0x76, 0x3a, 0x00, 0x96,
  0x89, 0x01, 0x02, 0x7f, 0x20, 0x06, 0x45, 0x04, 0x40, 0x20, 0x05, 0x41,
  0xe0, 0xc2, 0x00, 0x6a, 0x21, 0x06, 0x20, 0x02, 0x41, 0x08, 0x76, 0x0c,
  0x01, 0x0b, 0x20, 0x05, 0x41, 0x16, 0x36, 0x02, 0xb4, 0x02, 0x20, 0x05,
  0x20, 0x21, 0x36, 0x02, 0xb0, 0x02, 0x20, 0x05, 0x20, 0x05, 0x29, 0x03,
  0xb0, 0x02, 0x37, 0x03, 0x78, 0x20, 0x05, 0x41, 0x08, 0x36, 0x02, 0xe0,
  0x42, 0x20, 0x27, 0x20, 0x05, 0x41, 0xf8, 0x00, 0x6a, 0x20, 0x2f, 0x10,
  0x44, 0x20, 0x27, 0x20, 0x21, 0x41, 0x16, 0x20, 0x21, 0x10, 0x40, 0x20,
  0x04, 0x21, 0x06, 0x20, 0x00, 0x2f, 0x01, 0xee, 0x47, 0x22, 0x02, 0x41,
  0x08, 0x76, 0x0b, 0x21, 0x0f, 0x20, 0x21, 0x20, 0x06, 0x20, 0x05, 0x41,
  0xe0, 0xc2, 0x00, 0x6a, 0x22, 0x03, 0x6b, 0x22, 0x0a, 0x6b, 0x20, 0x03,
  0x20, 0x0a, 0x10, 0x24, 0x21, 0x06, 0x20, 0x05, 0x20, 0x02, 0x3a, 0x00,
  0xe2, 0x42, 0x20, 0x05, 0x41, 0xe4, 0x00, 0x3a, 0x00, 0xe0, 0x42, 0x20,
  0x05, 0x20, 0x0f, 0x3a, 0x00, 0xe1, 0x42, 0x20, 0x05, 0x41, 0xf0, 0x00,
  0x3a, 0x00, 0xe5, 0x42, 0x20, 0x05, 0x41, 0x83, 0xd6, 0x03, 0x3b, 0x00,
  0xe3, 0x42, 0x20, 0x0a, 0x41, 0x16, 0x6a, 0x22, 0x0f, 0x21, 0x02, 0x20,
  0x20, 0x21, 0x03, 0x20, 0x05, 0x20, 0x0f, 0x41, 0xff, 0xff, 0x03, 0x71,
  0x41, 0x80, 0x01, 0x4f, 0x04, 0x7f, 0x20, 0x05, 0x20, 0x0f, 0x3a, 0x00,
  0xe7, 0x42, 0x20, 0x1f, 0x21, 0x03, 0x20, 0x0f, 0x41, 0x08, 0x76, 0x41,
  0x80, 0x7f, 0x72, 0x05, 0x20, 0x02, 0x0b, 0x3a, 0x00, 0xe6, 0x42, 0x20,
  0x06, 0x20, 0x03, 0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x22, 0x02,
  0x6b, 0x22, 0x03, 0x6b, 0x20, 0x02, 0x20, 0x03, 0x10, 0x24, 0x22, 0x02,
  0x41, 0x01, 0x6b, 0x41, 0x80, 0x01, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x41,
  0x03, 0x6b, 0x41, 0x82, 0xe0, 0x03, 0x3b, 0x00, 0x00, 0x20, 0x02, 0x41,
  0x04, 0x6b, 0x20, 0x03, 0x20, 0x0f, 0x6a, 0x41, 0x07, 0x6a, 0x22, 0x03,
  0x3a, 0x00, 0x00, 0x20, 0x02, 0x41, 0x05, 0x6b, 0x20, 0x03, 0x41, 0x08,
  0x76, 0x3a, 0x00, 0x00, 0x20, 0x02, 0x41, 0x07, 0x6b, 0x22, 0x02, 0x41,
  0x03, 0x3b, 0x00, 0x00, 0x20, 0x0c, 0x20, 0x02, 0x20, 0x03, 0x20, 0x0c,
  0x28, 0x02, 0x00, 0x28, 0x02, 0x20, 0x11, 0x00, 0x00, 0x0c, 0x04, 0x0b,
  0x20, 0x05, 0x10, 0x00, 0x22, 0x02, 0x36, 0x02, 0x38, 0x20, 0x05, 0x20,
  0x02, 0x36, 0x02, 0x34, 0x20, 0x05, 0x41, 0xf3, 0xe3, 0x03, 0x36, 0x02,
  0x30, 0x20, 0x05, 0x20, 0x06, 0x36, 0x02, 0x3c, 0x41, 0x03, 0x41, 0xd0,
  0x8b, 0x01, 0x20, 0x05, 0x41, 0x30, 0x6a, 0x10, 0x22, 0x0c, 0x03, 0x0b,
  0x20, 0x05, 0x20, 0x03, 0x36, 0x02, 0x90, 0x83, 0x01, 0x41, 0x03, 0x41,
  0xe1, 0x25, 0x20, 0x05, 0x41, 0xcc, 0x01, 0x6a, 0x20, 0x05, 0x41, 0x90,
  0x83, 0x01, 0x6a, 0x10, 0x32, 0x0c, 0x0d, 0x0b, 0x10, 0x00, 0x21, 0x02,
  0x20, 0x05, 0x41, 0xc2, 0xea, 0x03, 0x36, 0x02, 0x10, 0x20, 0x05, 0x20,
  0x02, 0x36, 0x02, 0x14, 0x20, 0x05, 0x20, 0x02, 0x36, 0x02, 0x18, 0x20,
  0x05, 0x20, 0x05, 0x2d, 0x00, 0x9a, 0x01, 0x36, 0x02, 0x1c, 0x41, 0x06,
  0x41, 0xde, 0xe6, 0x00, 0x20, 0x05, 0x41, 0x10, 0x6a, 0x10, 0x22, 0x0b,
  0x20, 0x11, 0x20, 0x11, 0x28, 0x02, 0x08, 0x20, 0x05, 0x28, 0x02, 0xa0,
  0x01, 0x6a, 0x36, 0x02, 0x08, 0x0b, 0x20, 0x11, 0x28, 0x02, 0x04, 0x22,
  0x03, 0x20, 0x11, 0x28, 0x02, 0x08, 0x22, 0x02, 0x6b, 0x41, 0x01, 0x4b,
  0x0d, 0x00, 0x0b, 0x0b, 0x20, 0x05, 0x41, 0xc0, 0x83, 0x02, 0x6a, 0x24,
  0x00, 0x0c, 0x09, 0x0b, 0x20, 0x05, 0x20, 0x16, 0x41, 0x04, 0x6b, 0x36,
  0x02, 0x90, 0x83, 0x01, 0x20, 0x05, 0x20, 0x22, 0x36, 0x02, 0xe0, 0x42,
  0x41, 0x03, 0x41, 0xdd, 0x3e, 0x20, 0x05, 0x41, 0x90, 0x83, 0x01, 0x6a,
  0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a, 0x10, 0x32, 0x0c, 0x05, 0x0b,
  0x20, 0x05, 0x41, 0xa5, 0xef, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x0b, 0x20,
  0x05, 0x20, 0x03, 0x36, 0x02, 0xb0, 0x02, 0x0c, 0x02, 0x0b, 0x20, 0x05,
  0x41, 0xf8, 0xd4, 0x03, 0x36, 0x02, 0xe0, 0x42, 0x0b, 0x20, 0x05, 0x20,
  0x15, 0x36, 0x02, 0xb0, 0x02, 0x0b, 0x41, 0x96, 0x20, 0x20, 0x05, 0x41,
  0xe0, 0xc2, 0x00, 0x6a, 0x20, 0x05, 0x41, 0x90, 0x83, 0x01, 0x6a, 0x20,
  0x05, 0x41, 0xb0, 0x02, 0x6a, 0x10, 0x36, 0x0b, 0x41, 0x0c, 0x10, 0x02,
  0x22, 0x00, 0x41, 0x00, 0x36, 0x02, 0x08, 0x20, 0x00, 0x42, 0xa5, 0x27,
  0x37, 0x02, 0x00, 0x0c, 0x1c, 0x0b, 0x20, 0x05, 0x20, 0x03, 0x36, 0x02,
  0xb0, 0x02, 0x41, 0x96, 0x20, 0x20, 0x05, 0x41, 0xe0, 0xc2, 0x00, 0x6a,
  0x20, 0x05, 0x41, 0x90, 0x83, 0x01, 0x6a, 0x20, 0x05, 0x41, 0xb0, 0x02,
  0x6a, 0x10, 0x36, 0x0b, 0x41, 0x0c, 0x10, 0x02, 0x22, 0x00, 0x41, 0x00,
  0x36, 0x02, 0x08, 0x20, 0x00, 0x42, 0xd6, 0x3e, 0x37, 0x02, 0x00, 0x0c,
  0x1a, 0x0b, 0x0c, 0x08, 0x0b, 0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04,
  0x41, 0xc0, 0x00, 0x71, 0x04, 0x40, 0x41, 0x06, 0x41, 0xcb, 0xd7, 0x04,
  0x10, 0x26, 0x0b, 0x20, 0x0b, 0x41, 0x1c, 0x20, 0x0b, 0x28, 0x02, 0x00,
  0x28, 0x02, 0x9c, 0x01, 0x11, 0x01, 0x00, 0x0c, 0x07, 0x0b, 0x20, 0x00,
  0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00, 0x71, 0x04, 0x40, 0x41,
  0x06, 0x41, 0xc5, 0xd6, 0x04, 0x10, 0x26, 0x0b, 0x20, 0x0b, 0x41, 0x1b,
  0x20, 0x0b, 0x28, 0x02, 0x00, 0x28, 0x02, 0x9c, 0x01, 0x11, 0x01, 0x00,
  0x0c, 0x06, 0x0b, 0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0,
  0x00, 0x71, 0x04, 0x40, 0x41, 0x06, 0x41, 0x9d, 0xd7, 0x04, 0x10, 0x26,
  0x0b, 0x20, 0x09, 0x41, 0x04, 0x36, 0x02, 0xb0, 0x03, 0x20, 0x51, 0x20,
  0x09, 0x41, 0x80, 0x03, 0x6a, 0x41, 0x04, 0x72, 0x20, 0x02, 0x1b, 0x28,
  0x02, 0x00, 0x20, 0x2c, 0x20, 0x2b, 0x20, 0x02, 0x1b, 0x22, 0x04, 0x28,
  0x02, 0x00, 0x22, 0x06, 0x6b, 0x22, 0x02, 0x41, 0x03, 0x4d, 0x0d, 0x11,
  0x20, 0x04, 0x20, 0x06, 0x41, 0x02, 0x6a, 0x36, 0x02, 0x00, 0x20, 0x06,
  0x2f, 0x00, 0x00, 0x21, 0x03, 0x20, 0x04, 0x20, 0x06, 0x41, 0x04, 0x6a,
  0x36, 0x02, 0x00, 0x20, 0x00, 0x28, 0x02, 0x88, 0x48, 0x22, 0x02, 0x20,
  0x03, 0x20, 0x06, 0x2f, 0x00, 0x02, 0x20, 0x02, 0x28, 0x02, 0x00, 0x28,
  0x02, 0x30, 0x11, 0x00, 0x00, 0x0c, 0x05, 0x0b, 0x41, 0x01, 0x21, 0x03,
  0x02, 0x40, 0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00,
  0x71, 0x45, 0x0d, 0x00, 0x41, 0x06, 0x41, 0xf2, 0xd6, 0x04, 0x10, 0x26,
  0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00, 0x71, 0x45,
  0x0d, 0x00, 0x41, 0x06, 0x41, 0x9f, 0xcc, 0x00, 0x10, 0x26, 0x20, 0x00,
  0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00, 0x71, 0x45, 0x21, 0x03,
  0x0b, 0x20, 0x2c, 0x20, 0x2b, 0x20, 0x02, 0x1b, 0x22, 0x02, 0x20, 0x02,
  0x28, 0x02, 0x00, 0x22, 0x02, 0x41, 0x02, 0x6a, 0x36, 0x02, 0x00, 0x20,
  0x09, 0x20, 0x02, 0x2f, 0x00, 0x00, 0x22, 0x04, 0x3b, 0x01, 0xa8, 0x03,
  0x20, 0x03, 0x45, 0x04, 0x40, 0x20, 0x09, 0x41, 0x18, 0x3a, 0x00, 0xb0,
  0x03, 0x20, 0x09, 0x41, 0xb0, 0x03, 0x6a, 0x20, 0x09, 0x41, 0xa8, 0x03,
  0x6a, 0x10, 0x87, 0x01, 0x0b, 0x20, 0x09, 0x41, 0xb0, 0x03, 0x6a, 0x22,
  0x03, 0x41, 0x18, 0x20, 0x11, 0x10, 0x89, 0x01, 0x20, 0x00, 0x28, 0x02,
  0xa8, 0xc2, 0x04, 0x22, 0x02, 0x20, 0x04, 0x20, 0x03, 0x20, 0x02, 0x28,
  0x02, 0x00, 0x28, 0x02, 0xa0, 0x01, 0x11, 0x00, 0x00, 0x0c, 0x04, 0x0b,
  0x02, 0x40, 0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00,
  0x71, 0x45, 0x0d, 0x00, 0x41, 0x06, 0x41, 0xf5, 0xd7, 0x04, 0x10, 0x26,
  0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00, 0x71, 0x45,
  0x0d, 0x00, 0x41, 0x06, 0x41, 0xf9, 0xcc, 0x00, 0x10, 0x26, 0x0b, 0x20,
  0x2c, 0x20, 0x2b, 0x20, 0x02, 0x1b, 0x22, 0x02, 0x20, 0x02, 0x28, 0x02,
  0x00, 0x22, 0x02, 0x41, 0x02, 0x6a, 0x36, 0x02, 0x00, 0x20, 0x0b, 0x20,
  0x02, 0x2f, 0x00, 0x00, 0x20, 0x0b, 0x28, 0x02, 0x00, 0x28, 0x02, 0x9c,
  0x01, 0x11, 0x01, 0x00, 0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41,
  0xc0, 0x00, 0x71, 0x45, 0x0d, 0x03, 0x41, 0x06, 0x41, 0xca, 0x80, 0x03,
  0x10, 0x26, 0x0c, 0x03, 0x0b, 0x02, 0x7f, 0x20, 0x00, 0x2d, 0x00, 0xe0,
  0xc1, 0x04, 0x41, 0xc0, 0x00, 0x71, 0x45, 0x04, 0x40, 0x20, 0x2c, 0x20,
  0x2b, 0x20, 0x02, 0x1b, 0x22, 0x03, 0x20, 0x03, 0x28, 0x02, 0x00, 0x22,
  0x04, 0x41, 0x02, 0x6a, 0x22, 0x02, 0x36, 0x02, 0x00, 0x20, 0x04, 0x2d,
  0x00, 0x00, 0x21, 0x04, 0x41, 0x01, 0x0c, 0x01, 0x0b, 0x41, 0x06, 0x41,
  0x9c, 0xd6, 0x04, 0x10, 0x26, 0x20, 0x00, 0x28, 0x02, 0xe0, 0xc1, 0x04,
  0x21, 0x06, 0x20, 0x2c, 0x20, 0x2b, 0x20, 0x02, 0x1b, 0x22, 0x03, 0x20,
  0x03, 0x28, 0x02, 0x00, 0x22, 0x04, 0x41, 0x02, 0x6a, 0x22, 0x02, 0x36,
  0x02, 0x00, 0x20, 0x04, 0x2d, 0x00, 0x00, 0x21, 0x04, 0x41, 0x01, 0x20,
  0x06, 0x41, 0xc0, 0x00, 0x71, 0x45, 0x0d, 0x00, 0x1a, 0x41, 0x06, 0x41,
  0x9f, 0xcc, 0x00, 0x10, 0x26, 0x20, 0x03, 0x28, 0x02, 0x00, 0x21, 0x02,
  0x20, 0x00, 0x2d, 0x00, 0xe0, 0xc1, 0x04, 0x41, 0xc0, 0x00, 0x71, 0x45,
  0x0b, 0x21, 0x07, 0x20, 0x03, 0x20, 0x02, 0x41, 0x02, 0x6a, 0x36, 0x02,
  0x00, 0x20, 0x09, 0x20, 0x02, 0x2f, 0x00, 0x00, 0x22, 0x06, 0x3b, 0x01,
  0xa8, 0x03, 0x20, 0x07, 0x45, 0x04, 0x40, 0x20, 0x09, 0x20, 0x04, 0x3a,
  0x00, 0xb0, 0x03, 0x20, 0x09, 0x41, 0xb0, 0x03, 0x6a, 0x20, 0x09, 0x41,
  0xa8, 0x03, 0x6a, 0x10, 0x87, 0x01, 0x0b, 0x20, 0x09, 0x41, 0xb0, 0x03,
  0x6a, 0x22, 0x03, 0x20, 0x04, 0x41, 0xff, 0x01, 0x71, 0x20, 0x11, 0x10,
  0x89, 0x01, 0x20, 0x00, 0x28, 0x02, 0xa8, 0xc2, 0x04, 0x22, 0x02, 0x20,
  0x06, 0x20, 0x03, 0x20, 0x02, 0x28, 0x02, 0x00, 0x28, 0x02, 0xa0, 0x01,
  0x11, 0x00, 0x00, 0x0c, 0x02, 0x0b, 0x41, 0x03, 0x41, 0x9d, 0xc4, 0x01,
  0x20, 0x50, 0x10, 0x3b, 0x0c, 0x10, 0x0b, 0x20, 0x0b, 0x20, 0x0b, 0x28,
  0x02, 0x00, 0x28, 0x02, 0x90, 0x01, 0x11, 0x02, 0x00, 0x20, 0x4d, 0x20,
  0x11, 0x41, 0x01, 0x20, 0x0b, 0x20, 0x00, 0x2f, 0x01, 0xe8, 0x47, 0x20,
  0x00, 0x2f, 0x01, 0xea, 0x47, 0x10, 0xe0, 0x01, 0x20, 0x0b, 0x20, 0x0b,
  0x28, 0x02, 0x00, 0x28, 0x02, 0x94, 0x01, 0x11, 0x02, 0x00, 0x0b, 0x20,
  0x08, 0x20, 0x1d, 0x6a, 0x22, 0x08, 0x20, 0x1a, 0x47, 0x0d, 0x00, 0x0b,
  0x0c, 0x02, 0x0b, 0x20, 0x0b, 0x21, 0x0a, 0x23, 0x00, 0x41, 0xb0, 0xc8,
  0x00, 0x6b, 0x22, 0x01, 0x24, 0x00, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40, 0x02, 0x40,
  0x02, 0x40, 0x02, 0x40, 0x20, 0x01, 0x41, 0x88, 0xc8, 0x00, 0x6a, 0x20,
  0x09, 0x41, 0xf0, 0x02, 0x6a, 0x10, 0x72, 0x22, 0x02, 0x28, 0x02, 0x10,
  0x20, 0x02, 0x28, 0x02, 0x14, 0x47, 0x04, 0x40, 0x20, 0x02, 0x41, 0x0c,
  0x6a, 0x22, 0x03, 0x28, 0x02, 0x00, 0x2d, 0x00, 0x00, 0x41, 0xfc, 0x01,
  0x71, 0x41, 0x20, 0x46, 0x04, 0x40, 0x41, 0x06, 0x41, 0xae, 0x9e, 0x03,
  0x10, 0x26, 0x20, 0x00, 0x41, 0x01, 0x3a, 0x00, 0xba, 0xc2, 0x04, 0x20,
  0x02, 0x20, 0x02, 0x28, 0x02, 0x0c, 0x36, 0x02, 0x14, 0x20, 0x01, 0x02,
  0x7f, 0x20, 0x01, 0x41, 0xa0, 0x12, 0x6a, 0x21, 0x08, 0x23, 0x00, 0x41,
  0x10, 0x6b, 0x22, 0x06, 0x24, 0x00, 0x20, 0x06, 0x41, 0x02, 0x36, 0x02,
  0x0c, 0x02, 0x40, 0x02, 0x40, 0x20, 0x03, 0x28, 0x02, 0x04, 0x20, 0x03,
  0x28, 0x02, 0x08, 0x22, 0x04, 0x6b, 0x22, 0x02, 0x41, 0x01, 0x4b, 0x04,
  0x40, 0x20, 0x03, 0x20, 0x04, 0x41, 0x02, 0x6a, 0x36, 0x02, 0x08, 0x20,
  0x04, 0x2d, 0x00, 0x00, 0x22, 0x03, 0x41, 0x02, 0x76, 0x22, 0x02, 0x41,
  0x08, 0x47, 0x0d, 0x01, 0x20, 0x04, 0x2d, 0x00, 0x01, 0x21, 0x02, 0x20,
  0x08, 0x41, 0x08, 0x3a, 0x00, 0x00, 0x20, 0x08, 0x20, 0x02, 0x20, 0x03,
  0x41, 0x08, 0x74, 0x72, 0x41, 0x07, 0x76, 0x41, 0x07, 0x71, 0x36, 0x02,
  0x04, 0x20, 0x06, 0x41, 0x10, 0x6a, 0x24, 0x00, 0x20, 0x08, 0x0c, 0x03,
  0x0b, 0x20, 0x06, 0x20, 0x02, 0x36, 0x02, 0x08, 0x41, 0x03, 0x41, 0x8d,
  0x2c, 0x20, 0x06, 0x41, 0x0c, 0x6a, 0x20, 0x06, 0x41, 0x08, 0x6a, 0x10,
  0x32, 0x0c, 0x01, 0x0b, 0x20, 0x06, 0x41, 0x08, 0x36, 0x02, 0x08, 0x20,
  0x06, 0x20, 0x02, 0x36, 0x02, 0x04, 0x23, 0x00, 0x41, 0x20, 0x6b, 0x22,
  0x03, 0x24, 0x00, 0x10, 0x00, 0x21, 0x02, 0x20, 0x06, 0x28, 0x02, 0x08,
  0x21, 0x00, 0x20, 0x03, 0x20, 0x06, 0x28, 0x02, 0x04, 0x36, 0x02, 0x10,
  0x20, 0x03, 0x20, 0x00, 0x36, 0x02, 0x0c, 0x20, 0x03, 0x20, 0x02, 0x36,
  0x02, 0x08, 0x20, 0x03, 0x20, 0x02, 0x36, 0x02, 0x04, 0x20, 0x03, 0x41,
  0xf3, 0xe3, 0x03, 0x36, 0x02, 0x00, 0x41, 0x03, 0x41, 0xf6, 0xab, 0x03,
  0x20, 0x03, 0x10, 0x22, 0x20, 0x03, 0x41, 0x20, 0x6a, 0x24, 0x00, 0x0b,
  0x41, 0x0c, 0x10, 0x02, 0x22, 0x00, 0x41, 0x00, 0x36, 0x02, 0x08, 0x20,
  0x00, 0x42, 0x88, 0x27, 0x37, 0x02, 0x00, 0x20, 0x00, 0x41, 0xa8, 0xf1,
  0x1a, 0x41, 0x00, 0x10, 0x08, 0x00, 0x0b, 0x28, 0x02, 0x04, 0x22, 0x02,
  0x41, 0x04, 0x4c, 0x04, 0x7f, 0x20, 0x02, 0x41, 0x02, 0x74, 0x41, 0x80,
  0xeb, 0x1a, 0x6a, 0x28, 0x02, 0x00, 0x05, 0x41, 0x98, 0x8f, 0x04, 0x0b,
  0x36, 0x02, 0xf0, 0x44, 0x20, 0x01, 0x20, 0x02, 0x36, 0x02, 0xf0, 0x47,
  0x23, 0x00, 0x41, 0x20, 0x6b, 0x22, 0x04, 0x24, 0x00, 0x10, 0x00, 0x21,
  0x03, 0x20, 0x01, 0x41, 0xf0, 0xc4, 0x00, 0x6a, 0x28, 0x02, 0x00, 0x21,
  0x02, 0x20, 0x04, 0x20, 0x01, 0x41, 0xf0, 0xc7, 0x00, 0x6a, 0x28, 0x02,
  0x00, 0x36, 0x02, 0x10, 0x20, 0x04, 0x20, 0x02, 0x