/**
 * SSL/TLS utilities for wssshd
 *
 * Copyright (C) 2024 Stefy Lanza <stefy@nexlab.net> and SexHack.me
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef SSL_H
#define SSL_H

#include <openssl/ssl.h>
#include <openssl/err.h>

// SSL context management
SSL_CTX *ssl_create_context(void);
void ssl_cleanup(void);

// Certificate handling
int ssl_load_certificates(SSL_CTX *ctx, const char *cert_file, const char *key_file);
int ssl_generate_self_signed_cert(const char *cert_file, const char *key_file);

#endif /* SSL_H */