#include <string.h>
#include "plugin_assets.h"

const char *get_plugin_asset(const char *path, size_t *size) {
const char *plugin_example_example_html =
"<!DOCTYPE html>\n"
"<html>\n"
"<head>\n"
"    <title>Example Plugin</title>\n"
"    <script src=\"/plugin/example/example.js\"></script>\n"
"</head>\n"
"<body>\n"
"    <h1>Example Plugin Page</h1>\n"
"    <p>This is a custom page provided by the example plugin.</p>\n"
"    <p>Plugin uptime: <span id=\"uptime\">0</span> seconds</p>\n"
"    <button onclick=\"sendExampleMessage()\">Send Example Message</button>\n"
"    <div id=\"messages\"></div>\n"
"</body>\n"
"</html>\n";
    if (strcmp(path, "/plugin/example/example.html") == 0) {
        if (size) *size = strlen(plugin_example_example_html);
        return plugin_example_example_html;
    }
const char *plugin_example_example_js =
"// Example plugin JavaScript\n"
"let ws = null;\n"
"let uptimeInterval = null;\n"
"\n"
"function initWebSocket() {\n"
"    // Connect to the main WebSocket (this would need to be adapted for the actual plugin system)\n"
"    // For now, this is just a demonstration\n"
"    console.log('Example plugin JavaScript loaded');\n"
"}\n"
"\n"
"function sendExampleMessage() {\n"
"    if (!ws || ws.readyState !== WebSocket.OPEN) {\n"
"        // For demonstration, we'll just show an alert\n"
"        alert('WebSocket not connected. In a real plugin, this would send a message to the server.');\n"
"        return;\n"
"    }\n"
"\n"
"    const message = {\n"
"        type: 'example_message',\n"
"        data: 'Hello from the web interface!'\n"
"    };\n"
"\n"
"    ws.send(JSON.stringify(message));\n"
"}\n"
"\n"
"function updateUptime() {\n"
"    const uptimeElement = document.getElementById('uptime');\n"
"    if (uptimeElement) {\n"
"        const currentUptime = parseInt(uptimeElement.textContent) || 0;\n"
"        uptimeElement.textContent = currentUptime + 1;\n"
"    }\n"
"}\n"
"\n"
"// Initialize when page loads\n"
"document.addEventListener('DOMContentLoaded', function() {\n"
"    console.log('Example plugin page loaded');\n"
"    uptimeInterval = setInterval(updateUptime, 1000);\n"
"});\n"
"\n"
"// Clean up\n"
"window.addEventListener('beforeunload', function() {\n"
"    if (uptimeInterval) {\n"
"        clearInterval(uptimeInterval);\n"
"    }\n"
"    if (ws) {\n"
"        ws.close();\n"
"    }\n"
"});\n";
    if (strcmp(path, "/plugin/example/example.js") == 0) {
        if (size) *size = strlen(plugin_example_example_js);
        return plugin_example_example_js;
    }
    return NULL;
}
