#!/usr/bin/env python3
"""Check model information - pipeline class is now detected at runtime"""
import sys
import os
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from videogen import MODELS, detect_model_type, get_pipeline_for_task

print("=" * 60)
print("MODEL CHECK - Pipeline is detected at runtime")
print("=" * 60)
print("\nPipeline class is now determined at RUNTIME based on:")
print("  1. Model ID (e.g., Wan-AI/Wan2.2-I2V-A14B)")
print("  2. Task type (t2v, i2v, t2i, i2i, v2v)")
print("\nThis means the stored 'class' field in config is ignored!")
print()

# Show Wan models
for name, info in MODELS.items():
    model_id = info.get("id", "")
    if "wan" in name.lower() or "wan" in model_id.lower():
        print(f"\nName: {name}")
        print(f"ID: {info.get('id')}")
        print(f"Stored Class: {info.get('class')} (IGNORED)")
        print(f"Supports I2V: {info.get('supports_i2v')}")
        
        # Show what pipeline would be used for each task
        print(f"\nRuntime pipeline selection:")
        for task in ["t2v", "i2v", "v2v"]:
            pipeline = get_pipeline_for_task(model_id, task)
            print(f"  {task.upper()}: {pipeline}")
        
        print(f"Tags: {info.get('tags')}")
