# Network Monitoring Suite

A comprehensive Windows network monitoring and SSL interception toolkit that can run under Wine on Linux.

## Features

- **Network Connection Monitoring**: Tracks TCP connections and logs internal vs external traffic
- **Comprehensive SSL/TLS Interception**: Hooks 9 different SSL implementations:
  - OpenSSL/LibreSSL (`SSL_write`, `SSL_read`)
  - Windows Schannel (`EncryptMessage`, `DecryptMessage`)
  - NSS (Mozilla) (`SSL_Write`, `SSL_Read`)
  - GnuTLS (`gnutls_record_send`, `gnutls_record_recv`)
  - mbed TLS (`mbedtls_ssl_write`, `mbedtls_ssl_read`)
  - wolfSSL (`wolfSSL_write`, `wolfSSL_read`)
  - Botan TLS (simplified C++ API hooking)
- **DLL Injection**: Loads monitoring DLL into target processes
- **Syscall Monitoring**: Logs DLL loading and function resolution calls
- **Packet Capture**: Generates Wireshark-compatible PCAP files and raw dumps per connection
- **VNC Server**: Remote desktop access to monitored Windows applications

## Components

- `network_monitor.exe`: Main monitoring application with DLL injection
- `ssl_hook.dll`: SSL hooking and syscall monitoring DLL
- `packet_capture.dll`: Packet capture and logging functionality
- `bgvnc.exe`: VNC server for remote desktop access

## Output Files

The suite generates multiple log files organized by connection:

### Global Logs
1. `internal_traffic.log` - Internal network connection details
2. `external_traffic.log` - External network connection details
3. `ssl_log.txt` - SSL traffic hex dumps
4. `syscall_log.txt` - DLL loading and function calls with timestamps

### Per-Connection Files
For each unique TCP connection, the following files are created:

**Binary dumps:**
- `tcp_dump_{internal|external}_{src_ip}:{src_port}-{dest_ip}:{dest_port}.bin`

**Hex dumps:**
- `tcp_hexdump_{internal|external}_{src_ip}:{src_port}-{dest_ip}:{dest_port}.log`

**Wireshark PCAP files:**
- `tcp_wireshark_{internal|external}_{src_ip}:{src_port}-{dest_ip}:{dest_port}.pcap`

### Example File Names
- `tcp_dump_internal_192.168.1.100:12345-10.0.0.1:443.bin`
- `tcp_hexdump_external_192.168.1.100:54321-8.8.8.8:53.log`
- `tcp_wireshark_internal_192.168.1.100:12345-10.0.0.1:443.pcap`

## Building

### Prerequisites

#### For Linux Cross-Compilation:
- Linux system (Ubuntu/Debian recommended)
- MinGW-w64 cross-compiler
- Git
- Microsoft Detours library (for full hooking functionality - optional but recommended)

#### For Native Windows Compilation:
- Windows 10/11
- Visual Studio 2019/2022 with C++ build tools
- Git
- Microsoft Detours library

### Quick Start

#### Linux (Limited Functionality - No Detours)
```bash
sudo apt-get update
sudo apt-get install gcc-mingw-w64
git clone <repository-url>
cd network-monitoring-suite
./configure.sh
make NO_DETOURS=1
```

#### Linux (Full Functionality with Detours)
```bash
# 1. Install base dependencies
sudo apt-get update
sudo apt-get install gcc-mingw-w64 git p7zip-full

# 2. Download and extract Microsoft Detours on Windows
# On Windows machine:
git clone https://github.com/microsoft/Detours.git
cd Detours
# Open Visual Studio Developer Command Prompt
nmake

# 3. Copy Detours files to Linux
# Create directory on Linux
sudo mkdir -p /usr/local/detours

# Copy from Windows (adjust paths as needed)
# scp user@windows:/path/to/Detours/include/* /usr/local/detours/include/
# scp user@windows:/path/to/Detours/lib.X64/* /usr/local/detours/lib64/

# 4. Build the project
cd network-monitoring-suite
./configure.sh
make
```

#### Windows (Native Build)
```cmd
# Install Visual Studio Build Tools if not already installed
# Download from: https://visualstudio.microsoft.com/downloads/

# Clone and build Detours
git clone https://github.com/microsoft/Detours.git
cd Detours
nmake

# Copy Detours to project directory
xcopy include\* ..\network-monitoring-suite\detours\include\ /Y /I
xcopy lib.X64\* ..\network-monitoring-suite\detours\lib64\ /Y /I

# Build the project
cd ..\network-monitoring-suite
nmake /f Makefile.win
```

### Detailed Linux Build Instructions

#### Step 1: Install MinGW-w64 Cross-Compiler
```bash
# Ubuntu/Debian
sudo apt-get update
sudo apt-get install gcc-mingw-w64

# Verify installation
x86_64-w64-mingw32-gcc --version
```

#### Step 2: Obtain Microsoft Detours
Microsoft Detours is proprietary software and must be built on Windows. Here's the complete process:

**On Windows:**
1. Install Visual Studio 2019/2022 with "Desktop development with C++" workload
2. Open "Developer Command Prompt for VS 2019/2022"
3. Run these commands:
```cmd
git clone https://github.com/microsoft/Detours.git
cd Detours
nmake
```

**Transfer to Linux:**
```bash
# On Linux machine
sudo mkdir -p /usr/local/detours

# Use scp, rsync, or shared folder to copy:
# /path/to/Detours/include/ -> /usr/local/detours/include/
# /path/to/Detours/lib.X64/ -> /usr/local/detours/lib64/

# Verify files are present
ls -la /usr/local/detours/include/
ls -la /usr/local/detours/lib64/
```

#### Step 3: Configure and Build
```bash
# Clone the repository
git clone <repository-url>
cd network-monitoring-suite

# Run configuration script
./configure.sh

# Build with full functionality
make

# Or build without Detours (limited functionality)
make NO_DETOURS=1
```

### Detailed Windows Build Instructions

#### Prerequisites:
- Windows 10/11
- Visual Studio 2019/2022 with C++ build tools
- Git for Windows

#### Step 1: Install Visual Studio Build Tools
1. Download Visual Studio Installer
2. Select "Desktop development with C++"
3. Install the components

#### Step 2: Build Microsoft Detours
```cmd
# Open Developer Command Prompt for VS
git clone https://github.com/microsoft/Detours.git
cd Detours
nmake
```

#### Step 3: Build the Project
```cmd
# Copy Detours to project (adjust paths)
xcopy Detours\include\* network-monitoring-suite\detours\include\ /Y /I
xcopy Detours\lib.X64\* network-monitoring-suite\detours\lib64\ /Y /I

# Build using provided Makefile.win
cd network-monitoring-suite
nmake /f Makefile.win
```

### Manual Build Commands

#### Linux Cross-Compilation (Without Detours):
```bash
x86_64-w64-mingw32-gcc network_monitor.c -o network_monitor.exe -lws2_32 -liphlpapi -static
x86_64-w64-mingw32-gcc -shared ssl_hook.c -o ssl_hook.dll -DNO_DETOURS -static
x86_64-w64-mingw32-gcc -shared packet_capture.c -o packet_capture.dll -lws2_32 -static
x86_64-w64-mingw32-gcc bgvnc.c -o bgvnc.exe -lws2_32 -lgdi32 -luser32 -static
```

#### Linux Cross-Compilation (With Detours):
```bash
x86_64-w64-mingw32-gcc network_monitor.c -o network_monitor.exe -lws2_32 -liphlpapi -static
x86_64-w64-mingw32-gcc -shared ssl_hook.c -o ssl_hook.dll -I/usr/local/detours/include -L/usr/local/detours/lib64 -ldetours -lsspi -static
x86_64-w64-mingw32-gcc -shared packet_capture.c -o packet_capture.dll -lws2_32 -static
x86_64-w64-mingw32-gcc bgvnc.c -o bgvnc.exe -lws2_32 -lgdi32 -luser32 -static
```

#### Windows Native Compilation:
```cmd
# Using provided Makefile.win
nmake /f Makefile.win

# Or manual compilation with cl.exe:
cl network_monitor.c /link ws2_32.lib iphlpapi.lib /out:network_monitor.exe
cl /LD ssl_hook.c detours.lib /I detours\include /link /out:ssl_hook.dll
cl /LD packet_capture.c ws2_32.lib /out:packet_capture.dll
cl bgvnc.c /link ws2_32.lib gdi32.lib user32.lib /out:bgvnc.exe
```

### Build Configuration

#### Linux Build Options:
- `NO_DETOURS=1`: Build without Detours (limited SSL hooking functionality)
- `DETOURS_PATH=/custom/path`: Specify custom Detours installation path
- Clean build: `make clean`

#### Windows Build Options:
- Uses `Makefile.win` for native Windows compilation
- Requires Detours in `detours\` subdirectory
- Clean build: `nmake /f Makefile.win clean`

#### Environment Variables:
- `DETOURS_PATH`: Custom path to Detours installation (Linux default: `/usr/local/detours`)

### Troubleshooting

#### Linux Issues:
- **"cannot find -ldetours"**: Ensure Detours is properly installed in `/usr/local/detours`
- **"x86_64-w64-mingw32-gcc: command not found"**: Install MinGW-w64: `sudo apt-get install gcc-mingw-w64`
- **Permission denied**: Use `sudo` for system-wide installations

#### Windows Issues:
- **"nmake: command not found"**: Use Visual Studio Developer Command Prompt
- **Missing headers**: Ensure all Visual Studio components are installed
- **Linker errors**: Verify Detours library paths are correct

#### General Issues:
- **Build fails with warnings**: Warnings are normal; the build should still succeed
- **Runtime issues**: Ensure all DLLs are in the same directory as executables
- **UAC/Admin rights**: Some features may require administrator privileges

## Usage

### Network Monitor with SSL Interception

```bash
wine network_monitor.exe "C:\path\to\target.exe" arg1 arg2
```

### VNC Remote Desktop

```bash
wine bgvnc.exe "C:\Windows\System32\mstsc.exe" /v:remote-server
# Connect VNC client to localhost:5900
```

## Legal Notice

This software is for educational and research purposes only. Users are responsible for complying with applicable laws and regulations regarding network monitoring and data interception in their jurisdiction.

## License

GPLv3 - See LICENSE file for details.

## Author

Stefy Lanza <stefy@sexhack.me>