/*
 * Network Monitoring Suite - Main Monitor
 * Copyright (C) 2024 Stefy Lanza <stefy@sexhack.me>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <winsock2.h>
#include <windows.h>
#include <iphlpapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <tlhelp32.h>

// #pragma comment(lib, "ws2_32.lib")
// #pragma comment(lib, "iphlpapi.lib")

int is_internal_ip(DWORD ip) {
    BYTE b1 = (ip >> 24) & 0xFF;
    BYTE b2 = (ip >> 16) & 0xFF;
    // BYTE b3 = (ip >> 8) & 0xFF;
    // BYTE b4 = ip & 0xFF;
    if (b1 == 10) return 1;
    if (b1 == 172 && b2 >= 16 && b2 <= 31) return 1;
    if (b1 == 192 && b2 == 168) return 1;
    if (b1 == 127) return 1; // loopback
    return 0;
}

BOOL InjectDLL(HANDLE hProcess, const char* dllPath) {
    LPVOID pRemoteBuf = VirtualAllocEx(hProcess, NULL, strlen(dllPath) + 1, MEM_COMMIT, PAGE_READWRITE);
    if (!pRemoteBuf) return FALSE;

    if (!WriteProcessMemory(hProcess, pRemoteBuf, dllPath, strlen(dllPath) + 1, NULL)) {
        VirtualFreeEx(hProcess, pRemoteBuf, 0, MEM_RELEASE);
        return FALSE;
    }

    HMODULE hKernel32 = GetModuleHandle("kernel32.dll");
    LPVOID pLoadLibrary = GetProcAddress(hKernel32, "LoadLibraryA");

    HANDLE hThread = CreateRemoteThread(hProcess, NULL, 0, (LPTHREAD_START_ROUTINE)pLoadLibrary, pRemoteBuf, 0, NULL);
    if (!hThread) {
        VirtualFreeEx(hProcess, pRemoteBuf, 0, MEM_RELEASE);
        return FALSE;
    }

    WaitForSingleObject(hThread, INFINITE);
    CloseHandle(hThread);
    VirtualFreeEx(hProcess, pRemoteBuf, 0, MEM_RELEASE);
    return TRUE;
}

int main() {
    char program[256];
    printf("Enter program to start: ");
    fgets(program, sizeof(program), stdin);
    program[strcspn(program, "\n")] = 0;

    STARTUPINFO si = {0};
    si.cb = sizeof(si);
    PROCESS_INFORMATION pi;
    if (!CreateProcess(NULL, program, NULL, NULL, FALSE, CREATE_SUSPENDED, NULL, NULL, &si, &pi)) {
        printf("Failed to start process\n");
        return 1;
    }

    // Inject DLL before resuming
    if (!InjectDLL(pi.hProcess, "ssl_hook.dll")) {
        printf("Failed to inject DLL\n");
        TerminateProcess(pi.hProcess, 1);
        CloseHandle(pi.hProcess);
        CloseHandle(pi.hThread);
        return 1;
    }

    ResumeThread(pi.hThread);

    DWORD pid = pi.dwProcessId;
    Sleep(2000); // Wait for process to potentially establish connections

    FILE* internal_log = fopen("internal_traffic.log", "a");
    FILE* external_log = fopen("external_traffic.log", "a");

    PMIB_TCPTABLE_OWNER_PID tcpTable;
    DWORD size = 0;
    GetExtendedTcpTable(NULL, &size, FALSE, AF_INET, TCP_TABLE_OWNER_PID_ALL, 0);
    tcpTable = (PMIB_TCPTABLE_OWNER_PID)malloc(size);
    if (GetExtendedTcpTable(tcpTable, &size, FALSE, AF_INET, TCP_TABLE_OWNER_PID_ALL, 0) == NO_ERROR) {
        for (DWORD i = 0; i < tcpTable->dwNumEntries; i++) {
            MIB_TCPROW_OWNER_PID row = tcpTable->table[i];
            if (row.dwOwningPid == pid) {
                DWORD localIP = row.dwLocalAddr;
                DWORD remoteIP = row.dwRemoteAddr;
                char log_entry[256];
                sprintf(log_entry, "Connection: Local %lu.%lu.%lu.%lu:%u -> Remote %lu.%lu.%lu.%lu:%u State:%lu\n",
                    (localIP >> 24) & 0xFF, (localIP >> 16) & 0xFF, (localIP >> 8) & 0xFF, localIP & 0xFF, ntohs(row.dwLocalPort),
                    (remoteIP >> 24) & 0xFF, (remoteIP >> 16) & 0xFF, (remoteIP >> 8) & 0xFF, remoteIP & 0xFF, ntohs(row.dwRemotePort),
                    row.dwState);

                if (is_internal_ip(remoteIP)) {
                    fprintf(internal_log, "%s", log_entry);
                } else {
                    fprintf(external_log, "%s", log_entry);
                }
                printf("%s", log_entry);
            }
        }
    }
    fclose(internal_log);
    fclose(external_log);
    free(tcpTable);
    CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);
    return 0;
}