/*
 * Network Monitoring Suite - SSL Hook Header
 * Copyright (C) 2024 Stefy Lanza <stefy@sexhack.me>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef SSL_HOOK_H
#define SSL_HOOK_H

#include <windows.h>
#define SECURITY_WIN32
#include <sspi.h>
#include <stdio.h>

// Function pointer types for SSL functions
typedef int (*SSL_write_t)(void* ssl, const void* buf, int num);
typedef int (*SSL_read_t)(void* ssl, void* buf, int num);

// Function pointer types for Schannel functions
typedef SECURITY_STATUS (*EncryptMessage_t)(PCtxtHandle phContext, ULONG fQOP, PSecBufferDesc pMessage, ULONG MessageSeqNo);
typedef SECURITY_STATUS (*DecryptMessage_t)(PCtxtHandle phContext, PSecBufferDesc pMessage, ULONG MessageSeqNo, PULONG pfQOP);

// Original function pointers
extern SSL_write_t original_SSL_write;
extern SSL_read_t original_SSL_read;
extern EncryptMessage_t original_EncryptMessage;
extern DecryptMessage_t original_DecryptMessage;

// Hooked functions
int hooked_SSL_write(void* ssl, const void* buf, int num);
int hooked_SSL_read(void* ssl, void* buf, int num);
SECURITY_STATUS hooked_EncryptMessage(PCtxtHandle phContext, ULONG fQOP, PSecBufferDesc pMessage, ULONG MessageSeqNo);
SECURITY_STATUS hooked_DecryptMessage(PCtxtHandle phContext, PSecBufferDesc pMessage, ULONG MessageSeqNo, PULONG pfQOP);

// Function pointer types for syscall monitoring
typedef HMODULE (*LoadLibraryA_t)(LPCSTR lpLibFileName);
typedef HMODULE (*LoadLibraryW_t)(LPCWSTR lpLibFileName);
typedef FARPROC (*GetProcAddress_t)(HMODULE hModule, LPCSTR lpProcName);

// Original function pointers for syscall monitoring
extern LoadLibraryA_t original_LoadLibraryA;
extern LoadLibraryW_t original_LoadLibraryW;
extern GetProcAddress_t original_GetProcAddress;

// Hooked functions for syscall monitoring
HMODULE hooked_LoadLibraryA(LPCSTR lpLibFileName);
HMODULE hooked_LoadLibraryW(LPCWSTR lpLibFileName);
FARPROC hooked_GetProcAddress(HMODULE hModule, LPCSTR lpProcName);

// Helper functions
void log_data(const char* direction, const void* buf, int num);
void log_syscall(const char* syscall_name, const char* details);

// Packet capture function
__declspec(dllimport) void log_unencrypted_traffic(DWORD src_ip, DWORD dest_ip, WORD src_port, WORD dest_port, const BYTE* data, int len, int is_internal);

#endif