# Network Monitoring Suite

A comprehensive Windows network monitoring and SSL interception toolkit that can run under Wine on Linux.

## Features

- **Network Connection Monitoring**: Tracks TCP connections and logs internal vs external traffic
- **SSL/TLS Interception**: Hooks OpenSSL and Windows Schannel to capture unencrypted traffic
- **DLL Injection**: Loads monitoring DLL into target processes
- **Syscall Monitoring**: Logs DLL loading and function resolution calls
- **Packet Capture**: Generates Wireshark-compatible PCAP files and raw dumps
- **VNC Server**: Remote desktop access to monitored Windows applications

## Components

- `network_monitor.exe`: Main monitoring application with DLL injection
- `ssl_hook.dll`: SSL hooking and syscall monitoring DLL
- `packet_capture.dll`: Packet capture and logging functionality
- `bgvnc.exe`: VNC server for remote desktop access

## Output Files

The suite generates multiple log files organized by connection:

### Global Logs
1. `internal_traffic.log` - Internal network connection details
2. `external_traffic.log` - External network connection details
3. `ssl_log.txt` - SSL traffic hex dumps
4. `syscall_log.txt` - DLL loading and function calls with timestamps

### Per-Connection Files
For each unique TCP connection, the following files are created:

**Binary dumps:**
- `tcp_dump_{internal|external}_{src_ip}:{src_port}-{dest_ip}:{dest_port}.bin`

**Hex dumps:**
- `tcp_hexdump_{internal|external}_{src_ip}:{src_port}-{dest_ip}:{dest_port}.log`

**Wireshark PCAP files:**
- `tcp_wireshark_{internal|external}_{src_ip}:{src_port}-{dest_ip}:{dest_port}.pcap`

### Example File Names
- `tcp_dump_internal_192.168.1.100:12345-10.0.0.1:443.bin`
- `tcp_hexdump_external_192.168.1.100:54321-8.8.8.8:53.log`
- `tcp_wireshark_internal_192.168.1.100:12345-10.0.0.1:443.pcap`

## Building

### Prerequisites

- Linux system with MinGW-w64 cross-compiler
- Microsoft Detours library (for full hooking functionality - optional)

### Quick Start (Limited Functionality)

```bash
./configure.sh
make NO_DETOURS=1
```

### Full Build with Detours Support

#### 1. Install Base Dependencies

```bash
sudo apt-get update
sudo apt-get install gcc-mingw-w64 git
```

#### 2. Build Microsoft Detours (Requires Windows)

On a Windows machine with Visual Studio Build Tools:

```cmd
git clone https://github.com/microsoft/Detours.git
cd Detours
nmake
```

Copy the built Detours to your Linux machine:

```bash
# Create Detours directory on Linux
sudo mkdir -p /usr/local/detours

# Copy from Windows (adjust paths as needed)
# scp user@windows:/path/to/Detours/include/* /usr/local/detours/include/
# scp user@windows:/path/to/Detours/lib.X64/* /usr/local/detours/lib64/
```

#### 3. Configure and Build

```bash
./configure.sh
make
```

### Manual Build Commands

#### Without Detours (Limited functionality):
```bash
x86_64-w64-mingw32-gcc network_monitor.c -o network_monitor.exe -lws2_32 -liphlpapi -static
x86_64-w64-mingw32-gcc -shared ssl_hook.c -o ssl_hook.dll -DNO_DETOURS -static
x86_64-w64-mingw32-gcc -shared packet_capture.c -o packet_capture.dll -lws2_32 -static
x86_64-w64-mingw32-gcc bgvnc.c -o bgvnc.exe -lws2_32 -lgdi32 -luser32 -static
```

#### With Detours (Full functionality):
```bash
x86_64-w64-mingw32-gcc network_monitor.c -o network_monitor.exe -lws2_32 -liphlpapi -static
x86_64-w64-mingw32-gcc -shared ssl_hook.c -o ssl_hook.dll -L/usr/local/detours/lib64 -ldetours -lsspi -static
x86_64-w64-mingw32-gcc -shared packet_capture.c -o packet_capture.dll -lws2_32 -static
x86_64-w64-mingw32-gcc bgvnc.c -o bgvnc.exe -lws2_32 -lgdi32 -luser32 -static
```

### Build Options

- `NO_DETOURS=1`: Build without Detours (limited SSL hooking)
- `DETOURS_PATH=/custom/path`: Specify custom Detours installation path

## Usage

### Network Monitor with SSL Interception

```bash
wine network_monitor.exe "C:\path\to\target.exe" arg1 arg2
```

### VNC Remote Desktop

```bash
wine bgvnc.exe "C:\Windows\System32\mstsc.exe" /v:remote-server
# Connect VNC client to localhost:5900
```

## Legal Notice

This software is for educational and research purposes only. Users are responsible for complying with applicable laws and regulations regarding network monitoring and data interception in their jurisdiction.

## License

GPLv3 - See LICENSE file for details.

## Author

Stefy Lanza <stefy@sexhack.me>