"""
Copyleft (C) 2026 Stefy Lanza <stefy@nexlab.net>

AISBF - AI Service Broker Framework || AI Should Be Free

A modular proxy server for managing multiple AI provider integrations.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

Why did the programmer quit his job? Because he didn't get arrays!

A modular proxy server for managing multiple AI provider integrations.
"""

from .config import config, Config, ProviderConfig, RotationConfig, AppConfig, AutoselectConfig, AutoselectModelInfo
from .context import ContextManager, get_context_config_for_model
from .models import (
    Message,
    ChatCompletionRequest,
    ChatCompletionResponse,
    Model,
    Provider,
    ErrorTracking
)
from .providers import (
    BaseProviderHandler,
    GoogleProviderHandler,
    OpenAIProviderHandler,
    AnthropicProviderHandler,
    OllamaProviderHandler,
    get_provider_handler,
    PROVIDER_HANDLERS
)
from .handlers import RequestHandler, RotationHandler, AutoselectHandler
from .utils import count_messages_tokens, split_messages_into_chunks, get_max_request_tokens_for_model

__version__ = "0.3.0"
__all__ = [
    # Config
    "config",
    "Config",
    "ProviderConfig",
    "RotationConfig",
    "AppConfig",
    "AutoselectConfig",
    "AutoselectModelInfo",
    # Models
    "Message",
    "ChatCompletionRequest",
    "ChatCompletionResponse",
    "Model",
    "Provider",
    "ErrorTracking",
    "AutoselectModelInfo",
    "AutoselectConfig",
    # Providers
    "BaseProviderHandler",
    "GoogleProviderHandler",
    "OpenAIProviderHandler",
    "AnthropicProviderHandler",
    "OllamaProviderHandler",
    "get_provider_handler",
    "PROVIDER_HANDLERS",
    # Handlers
    "RequestHandler",
    "RotationHandler",
    "AutoselectHandler",
    # Context
    "ContextManager",
    "get_context_config_for_model",
    # Utils
    "count_messages_tokens",
    "split_messages_into_chunks",
    "get_max_request_tokens_for_model",
]
