#!/bin/bash

if [ $# -lt 1 ]; then
  echo "Usage: $0 <openvpn_config_file> [key_files...]"
  exit 1
fi

CONFIG=$1
shift

mkdir -p config/includes.chroot/etc/openvpn
cp "$CONFIG" config/includes.chroot/etc/openvpn/client.conf

for key in "$@"; do
  cp "$key" config/includes.chroot/etc/openvpn/
done

# Create hook to start OpenVPN on boot
cat > config/hooks/live/start-openvpn.hook.chroot << 'EOF'
#!/bin/bash
systemctl enable openvpn@client
systemctl start openvpn@client
EOF

chmod +x config/hooks/live/start-openvpn.hook.chroot