@echo off
echo MBetter ISO to USB Creator
echo ==========================
echo.

REM Check if ISO file exists
if not exist "live-image-amd64.iso" (
    echo ERROR: live-image-amd64.iso not found in current directory!
    echo Please ensure the ISO file is in the same directory as this script.
    pause
    exit /b 1
)

echo Available disks:
echo.

REM List disks using diskpart
(
echo list disk
) | diskpart

echo.
echo WARNING: This will erase all data on the selected disk!
echo Make sure you select the correct disk number for your USB drive.
echo.
set /p DISK_NUM="Enter the disk number for your USB drive: "

if "%DISK_NUM%"=="" (
    echo ERROR: No disk number entered.
    pause
    exit /b 1
)

echo.
echo You selected disk %DISK_NUM%
set /p CONFIRM="Are you sure you want to erase disk %DISK_NUM%? (yes/no): "

if /i not "%CONFIRM%"=="yes" (
    echo Operation cancelled.
    pause
    exit /b 0
)

echo.
echo Preparing USB drive...

REM Use diskpart to clean and format the USB
(
echo select disk %DISK_NUM%
echo clean
echo create partition primary
echo format fs=fat32 quick label="MBETTER"
echo active
echo exit
) | diskpart

if errorlevel 1 (
    echo ERROR: Failed to prepare USB drive.
    pause
    exit /b 1
)

echo.
echo USB drive prepared successfully.
echo.

REM Get the drive letter for the USB
for /f "tokens=2" %%i in ('wmic logicaldisk where "deviceid like '%%:'" get deviceid ^| findstr /r "[A-Z]:"') do (
    set "DRIVE_LETTER=%%i"
    goto :found_drive
)
:found_drive

if "%DRIVE_LETTER%"=="" (
    echo ERROR: Could not detect USB drive letter.
    pause
    exit /b 1
)

echo Copying ISO contents to USB drive %DRIVE_LETTER%...
echo This may take several minutes...
echo.

REM Use PowerShell to mount ISO and copy contents
powershell -Command "& { $isoPath = Join-Path $PSScriptRoot 'live-image-amd64.iso'; $mountResult = Mount-DiskImage -ImagePath $isoPath -PassThru; $driveLetter = ($mountResult | Get-Volume).DriveLetter; Copy-Item -Path ($driveLetter + ':\*') -Destination '%DRIVE_LETTER%' -Recurse -Force; Dismount-DiskImage -ImagePath $isoPath; }"

if errorlevel 1 (
    echo ERROR: Failed to copy ISO contents to USB.
    pause
    exit /b 1
)

echo.
echo SUCCESS: USB drive created successfully!
echo.
echo Your MBetter USB install media is ready at drive %DRIVE_LETTER%
echo You can now boot from this USB drive to install or run MBetter live system.
echo.
echo IMPORTANT: Make sure your BIOS/UEFI is set to boot from USB first.
echo.
pause