#!/bin/bash

echo "MBetter ISO Build Script"
echo "========================"

# Check if root password has been set
if grep -q "d-i passwd/root-password password changeme" config/preseed/debian-installer.cfg; then
    echo "Root password not set. Please enter a root password for the ISO:"
    read -s -p "Enter root password: " ROOT_PASS
    echo
    read -s -p "Confirm root password: " ROOT_PASS_CONFIRM
    echo

    if [ "$ROOT_PASS" != "$ROOT_PASS_CONFIRM" ]; then
        echo "ERROR: Passwords do not match!"
        exit 1
    fi

    if [ -z "$ROOT_PASS" ]; then
        echo "ERROR: Password cannot be empty!"
        exit 1
    fi

    echo "Setting root password..."
    ./set_root_password.sh "$ROOT_PASS"
fi

echo "Root password is set. Proceeding with build..."

# Check if running as root (lb build needs sudo)
if [ "$EUID" -ne 0 ]; then
    echo "ERROR: This script must be run with sudo privileges."
    echo "Usage: sudo ./build.sh"
    exit 1
fi

echo "Starting ISO build..."
echo "Running lb config..."
lb config 2>&1 | tee -a build.log
echo "Running lb build..."
lb build 2>&1 | tee -a build.log

BUILD_EXIT_CODE=$?

if [ $BUILD_EXIT_CODE -eq 0 ]; then
    echo "Build completed successfully!"
    echo "ISO file: $(ls live-image-amd64.iso 2>/dev/null || ls *.iso 2>/dev/null || echo 'Not found')"
else
    echo "Build failed. Check build.log for errors."
    exit 1
fi