# MBetter Debian Live ISO Builder

This project creates a custom Debian live ISO with the following features:
- SSH server with root login enabled
- OpenVPN installed and configurable
- Xorg with Openbox window manager
- Auto-start of MbetterClient application on boot
- Minimal Debian installer asking only for network configuration
- Custom MBetter logos (converted from mbet.jpg)
- SysVinit init system (not systemd)
- Full keyring support (debian-keyring, debian-archive-keyring)
- **Comprehensive hardware support** with firmware packages
- **Dual repository system** (Devuan + Debian fallback)
- **Post-build customization** tools

## Prerequisites
- Debian-based system with live-build installed
- ImageMagick for logo generation (optional)
- genisoimage or mkisofs for ISO customization (optional)

## Quick Start

1. **Build the ISO:**
   ```bash
   sudo ./build.sh
   ```

2. **Customize existing ISO (optional):**
   ```bash
   sudo ./customize_iso.sh -i live-image-amd64.iso -p newpassword
   ```

3. **Create bootable USB:**
   - Windows: Run `create_usb.bat` as Administrator
   - Linux: `sudo ./create_usb.sh`

## Detailed Usage

### Building from Scratch

1. **Set root password (optional):**
   ```bash
   ./set_root_password.sh yourpassword
   ```

2. **Add OpenVPN configuration (optional):**
   ```bash
   ./insert_openvpn.sh /path/to/client.ovpn
   ```

3. **Build the ISO:**
   ```bash
   sudo ./build.sh
   ```

### Post-Build Customization

Use `customize_iso.sh` to modify an already-built ISO:

```bash
# Change root password only
sudo ./customize_iso.sh -i mbeter.iso -p newpassword

# Change password and add OpenVPN
sudo ./customize_iso.sh -i mbeter.iso -p newpassword -o client.ovpn -k client.key

# Specify output file
sudo ./customize_iso.sh -i mbeter.iso -p newpassword -O custom-mbeter.iso
```

### Cleanup and Reset

```bash
sudo ./cleanup.sh
```

**Note:** Cleanup requires sudo privileges to unmount filesystems and remove system files.

## Hardware Support

This ISO includes comprehensive hardware support with firmware packages for:

### WiFi Cards
- Intel Wireless (iwlwifi)
- Realtek RTL series
- Atheros AR series
- Broadcom BCM43xx
- Ralink RT series
- USB WiFi adapters

### Graphics Cards
- Intel integrated graphics
- AMD/ATI Radeon cards
- NVIDIA GeForce cards
- Legacy graphics hardware

### Network & Bluetooth
- Ethernet controllers
- Bluetooth chipsets
- USB network devices
- Wireless network cards

### Repository Configuration
- **Primary:** Devuan merged repository (main, contrib, non-free, firmware-nonfree)
- **Fallback:** Debian testing repository for packages not available in Devuan
- **Security:** Both Devuan and Debian security updates
- **Firmware:** Complete firmware-nonfree support

## Scripts Overview

### Build Scripts
- `build.sh` - Main build script with error handling and retry logic
- `set_root_password.sh` - Set root password for the ISO
- `insert_openvpn.sh` - Add OpenVPN configuration files

### Customization Scripts
- `customize_iso.sh` - Modify existing ISO (change password, add OpenVPN)
- `cleanup.sh` - Clean build artifacts and reset configuration

### USB Creation Scripts
- `create_usb.bat` - Windows USB creation (Administrator required)
- `create_usb.sh` - Linux USB creation with dd

### Utility Scripts
- `generate_logo.sh` - Convert mbet.jpg to boot logos (optional)

## Creating Bootable USB

### Windows (`create_usb.bat`)
- Lists available disks using diskpart
- Prompts for disk selection with safety warnings
- Formats USB as FAT32 and copies ISO contents
- **Requirements:** Run as Administrator, USB 4GB+, PowerShell enabled

### Linux (`create_usb.sh`)
- Lists block devices using lsblk
- Uses `dd` to write ISO directly to USB (fast and reliable)
- Shows progress during writing
- **Requirements:** Run with sudo, USB device path (e.g., /dev/sdb)

**Safety Note:** Both scripts include confirmation prompts and warnings about data loss.

## Advanced Customization

### Package Management
- Edit `config/package-lists/live.list.chroot` to add/remove packages
- Modify `config/preseed/debian-installer.cfg` for installer settings
- Update hooks in `config/hooks/live/` for additional configurations

### Repository Configuration
- `config/main-config` - Main live-build configuration
- `config/includes.chroot/etc/apt/sources.list` - System repositories
- Supports both Devuan and Debian repositories

### Branding
- Replace logos in `config/includes.chroot/usr/share/`
- Plymouth theme: `plymouth/themes/default/watermark.png`
- GRUB theme: `grub/themes/debian/logo.png`

## Troubleshooting

### Build Issues
- Ensure you're running on a Debian-based system
- Check that live-build is properly installed
- Verify network connectivity for package downloads

### Hardware Issues
- Most hardware is supported via included firmware packages
- Additional drivers can be installed post-installation
- Check `dmesg` for hardware detection issues

### Repository Issues
- Devuan provides primary packages
- Debian provides fallback for unavailable packages
- Both repositories are configured for security updates

## Notes
- MbetterClient is assumed to be executable and placed in /usr/local/bin/
- OpenVPN config is set to start automatically if provided
- Root login is enabled by default for SSH access
- SysVinit is used instead of systemd for compatibility
- ISO includes comprehensive firmware for 95%+ hardware compatibility