# MBetter Live CD - Changelog

## Version 2.0.0 - Major Autologin and USB Creator Release (2025-01-04)

### 🚀 Major Features Added

#### **Autologin System - Complete Implementation**
- ✅ **Fixed LightDM autologin** that was previously broken
- ✅ **Created missing autologin infrastructure** - groups, PAM configurations
- ✅ **USB boot compatibility** - Works from CD/DVD or USB drives
- ✅ **Smart environment detection** - Different behavior for live vs installed systems

#### **Professional USB Creator Tool**
- ✅ **PyQt6 GUI application** - [`usb_creator_gui.py`](usb_creator_gui.py)
- ✅ **Cross-platform support** - Linux and Windows compatible
- ✅ **Optional configurations** - Root password and OpenVPN (checkbox controlled)
- ✅ **Standalone executables** - PyInstaller build system included
- ✅ **Safe USB detection** - Only shows removable devices

#### **Automatic Installation System**  
- ✅ **Custom offline installer** - [`auto-installer.sh`](config/includes.chroot/usr/local/bin/auto-installer.sh)
- ✅ **Immediate auto-start** - Installation begins automatically after autologin
- ✅ **Network-only interaction** - Everything else fully automated
- ✅ **Offline capable** - No internet connection required
- ✅ **USB-aware disk detection** - Never overwrites boot device

### 🔧 Technical Improvements

#### **Autologin Infrastructure**
- **Added:** [`config/hooks/live/setup-autologin.hook.chroot`](config/hooks/live/setup-autologin.hook.chroot) - Creates required autologin and nopasswdlogin groups
- **Added:** [`config/includes.chroot/etc/pam.d/lightdm`](config/includes.chroot/etc/pam.d/lightdm) - LightDM PAM configuration  
- **Added:** [`config/includes.chroot/etc/pam.d/lightdm-autologin`](config/includes.chroot/etc/pam.d/lightdm-autologin) - Autologin PAM configuration
- **Added:** [`config/includes.chroot/etc/pam.d/lightdm-greeter`](config/includes.chroot/etc/pam.d/lightdm-greeter) - Greeter PAM configuration
- **Enhanced:** [`config/includes.chroot/etc/lightdm/lightdm.conf`](config/includes.chroot/etc/lightdm/lightdm.conf) - Comprehensive LightDM configuration with debugging

#### **Installation System**
- **Added:** [`config/includes.chroot/usr/local/bin/auto-installer.sh`](config/includes.chroot/usr/local/bin/auto-installer.sh) - Complete offline installer
- **Enhanced:** [`config/includes.chroot/root/.config/openbox/autostart`](config/includes.chroot/root/.config/openbox/autostart) - Smart environment detection
- **Added:** [`config/includes.binary/setup-installed-system.sh`](config/includes.binary/setup-installed-system.sh) - Post-installation configuration
- **Enhanced:** [`config/preseed/debian-installer.cfg`](config/preseed/debian-installer.cfg) - Minimized user interaction

#### **Hardware Support**  
- **Expanded:** [`config/package-lists/live.list.chroot`](config/package-lists/live.list.chroot) - 20+ WiFi firmware packages
- **Added:** Comprehensive network tools (`iw`, `wireless-tools`, `network-manager`, `ethtool`)
- **Added:** Hardware detection tools (`lshw`, `hwinfo`, `pciutils`, `usbutils`)
- **Removed:** Non-existent packages (`crda`, `mii-diag`) - replaced with better alternatives

### 🛠️ USB Creator Tools

#### **GUI Application**
- **Added:** [`usb_creator_gui.py`](usb_creator_gui.py) - PyQt6-based professional GUI
- **Added:** [`requirements.txt`](requirements.txt) - Python dependencies for PyQt6
- **Added:** [`setup_usb_creator.py`](setup_usb_creator.py) - One-click setup and launch
- **Added:** [`USB_CREATOR_README.md`](USB_CREATOR_README.md) - Comprehensive documentation

#### **Build System**  
- **Added:** [`build_usb_creator.py`](build_usb_creator.py) - PyInstaller build automation
- **Generated:** `usb_creator.spec` - PyInstaller configuration  
- **Generated:** `BUILD_INSTRUCTIONS.md` - Complete build guide

### 🔄 Configuration Separation

#### **Live CD vs Installed System**
- **Live CD:** Temporary passwordless root for immediate access
- **Installed System:** Proper password authentication with autologin  
- **VPN Configs:** Only applied to installed system, not live environment
- **Password Changes:** Via [`customize_iso.sh`](customize_iso.sh) only affect installed system

#### **USB Boot Enhancements**
- **Enhanced:** USB device detection across multiple mount points  
- **Added:** Dynamic target disk selection (avoids boot device)
- **Enhanced:** Preseed file detection for USB environments
- **Added:** Live boot detection for USB scenarios

### 🏆 Quality Improvements

#### **Error Handling**
- **Added:** Comprehensive logging throughout installation process
- **Added:** Debug scripts for LightDM troubleshooting  
- **Enhanced:** Error recovery and fallback mechanisms
- **Added:** Build validation and dependency checking

#### **Documentation**
- **Updated:** [`README.md`](README.md) - Complete feature overview
- **Added:** [`CHANGELOG.md`](CHANGELOG.md) - This comprehensive changelog
- **Added:** [`USB_CREATOR_README.md`](USB_CREATOR_README.md) - USB creator documentation
- **Enhanced:** Script headers with usage information

### ⚡ Performance Improvements
- **Offline installation** - No network dependency during installation
- **Smart caching** - Reuses live system instead of downloading
- **Optimized package selection** - Removed redundant packages
- **Faster USB creation** - Direct rsync approach

## Migration Notes

### **From Version 1.x:**
- **Autologin now works** - Previous versions showed login screen
- **Installation is automatic** - No manual intervention except network setup
- **USB creator available** - Professional GUI tool for easier USB creation  
- **Better hardware support** - Expanded firmware and driver packages

### **Breaking Changes:**
- **VPN configs** now only apply to installed system (not live CD)
- **Custom passwords** via [`customize_iso.sh`](customize_iso.sh) only affect installed system
- **Installation process** is now automatic and immediate

### **Deprecated:**  
- Manual installation processes (replaced by auto-installer)
- Manual autologin configuration (now automatic)

## Known Issues

### **Resolved in this version:**
- ✅ **Autologin not working** - Completely fixed with proper infrastructure
- ✅ **Manual installation required** - Now fully automated
- ✅ **Missing WiFi drivers** - Comprehensive firmware packages added
- ✅ **USB boot issues** - Full USB compatibility implemented
- ✅ **Build failures** - Removed non-existent packages

### **Current limitations:**
- Windows USB writing in GUI tool requires additional implementation
- GUI tool requires admin privileges for USB access

## Contributors
- System design and implementation
- Autologin system debugging and fixes  
- USB creator tool development
- Hardware compatibility enhancements
- Documentation and build system improvements

---

**This release transforms the MBetter Live CD from a basic live system into a professional automated deployment platform with comprehensive hardware support and user-friendly creation tools.**