# MBetter USB Creator - Build Instructions

## Prerequisites

### Linux:
```bash
# Install Python and Qt dependencies
sudo apt update
sudo apt install python3 python3-pip python3-pyqt6 genisoimage

# Install Python dependencies
pip3 install -r requirements.txt
```

### Windows:
```cmd
# Install Python 3.9+ from python.org
# Install dependencies
pip install -r requirements.txt

# Install 7-zip (required for ISO extraction)
# Download from: https://www.7-zip.org/
```

## Building Standalone Executable

### Automatic Build:
```bash
# Run the build script (installs deps and builds)
python3 build_usb_creator.py
```

### Manual Build:
```bash
# Install dependencies
pip3 install -r requirements.txt

# Build executable
pyinstaller --clean usb_creator.spec
```

## Running

### From Source:
```bash
# Linux (requires sudo)
sudo python3 usb_creator_gui.py

# Windows (run as Administrator)
python usb_creator_gui.py
```

### Standalone Executable:
```bash
# Linux
sudo ./dist/MBetterUSBCreator

# Windows
# Right-click → Run as Administrator
dist\MBetterUSBCreator.exe
```

## Features

- ✓ Cross-platform (Linux/Windows)
- ✓ ISO file selection and validation
- ✓ USB device auto-detection
- ✓ Optional root password configuration
- ✓ Optional OpenVPN config integration
- ✓ Progress indicators and logging
- ✓ Safe USB device selection (prevents system disk selection)
- ✓ Standalone executable (no Python installation required)

## Usage

1. **Select ISO**: Browse for your MBetter ISO file
2. **Choose USB**: Select target USB device from dropdown
3. **Configure Password** (Optional): Set custom root password for installed system
4. **Add VPN Config** (Optional): Include OpenVPN configuration files
5. **Create USB**: Click to start the USB creation process

The created USB will:
- Boot to live environment with autologin
- Automatically start installation process
- Use your custom root password (if set)
- Include VPN configuration in installed system (if provided)
- Work completely offline
