"""
Database package for Fixture Manager
Handles migrations and database versioning
"""

from .migrations import (
    get_migration_manager,
    run_migrations,
    get_migration_status,
    DatabaseVersion
)

# Import functions from the manager module for backward compatibility
from .manager import (
    init_database_manager,
    get_db_manager,
    DatabaseManager
)

__all__ = [
    'get_migration_manager',
    'run_migrations',
    'get_migration_status',
    'DatabaseVersion',
    'init_database_manager',
    'get_db_manager',
    'DatabaseManager'
]