"""
Migration script to add match_reports table for comprehensive match-level reporting
"""

def upgrade():
    """Add match_reports table"""
    from app import db
    from app.models import MatchReport
    
    # Create the table
    db.create_all()
    
    print("✓ match_reports table created successfully")

def downgrade():
    """Remove match_reports table"""
    from app import db
    from sqlalchemy import text
    
    # Drop the table
    db.session.execute(text("DROP TABLE IF EXISTS match_reports"))
    db.session.commit()
    
    print("✓ match_reports table dropped successfully")

if __name__ == '__main__':
    upgrade()