#!/usr/bin/env python
"""
Backfill script to set fixture_active_time for existing active fixtures
Run this once to update existing data after adding the fixture_active_time column
"""

import sys
import os

# Add the project root to Python path
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from app import create_app, db
from app.models import Match
import logging

def main():
    """Backfill fixture active times for existing data"""
    app = create_app()
    
    with app.app_context():
        print("Starting backfill of fixture_active_time...")
        
        # Run the backfill
        updated_count = Match.backfill_fixture_active_times()
        
        print(f"Backfill completed. Updated {updated_count} matches.")
        
        # Verify the results
        fixtures_with_time = db.session.query(Match.fixture_id).filter(
            Match.fixture_active_time.isnot(None)
        ).distinct().count()
        
        active_fixtures_total = db.session.query(Match.fixture_id).filter(
            Match.active_status == True
        ).distinct().count()
        
        print(f"Fixtures with active time: {fixtures_with_time}")
        print(f"Total active fixtures: {active_fixtures_total}")
        
        if fixtures_with_time > 0:
            print("✅ Backfill successful! The /api/updates endpoint should now return data.")
        else:
            print("⚠️  No fixtures were updated. Check if there are active fixtures in the database.")

if __name__ == '__main__':
    main()