# -*- mode: python ; coding: utf-8 -*-

import sys
import os
from pathlib import Path

# Get the project root directory
project_root = Path('.')

# Hidden imports for Flask and other dynamic imports
hidden_imports = [
    'flask',
    'flask_sqlalchemy',
    'flask_login',
    'flask_wtf',
    'flask_jwt_extended',
    'pymysql',
    'cryptography',
    'pandas',
    'openpyxl',
    'xlrd',
    'daemon',
    'daemon.daemon',
    'daemon.pidfile',
    'lockfile',
    'bcrypt',
    'werkzeug',
    'wtforms',
    'dotenv',
    'gunicorn',
    'psutil',
    'watchdog',
    'click',
    'colorlog',
    'marshmallow',
    'sqlalchemy',
    'sqlalchemy.dialects.mysql',
    'sqlalchemy.pool',
    'email_validator',
    'jinja2',
    'markupsafe',
    'itsdangerous',
    'blinker',
    'redis',
    'ipaddress',
    'urllib.parse',
    'datetime',
    'threading',
    'concurrent.futures',
    'hashlib',
    'secrets',
    'time',
    'json',
    'csv',
    'zipfile',
    'tempfile',
    'shutil',
    'subprocess',
    'signal',
    'logging.handlers',
    'app.auth',
    'app.auth.routes',
    'app.auth.forms',
    'app.main',
    'app.main.routes',
    'app.api',
    'app.api.routes',
    'app.upload',
    'app.upload.routes',
    'app.upload.forms',
    'app.upload.file_handler',
    'app.upload.fixture_parser',
    'app.utils',
    'app.utils.security',
    'app.utils.logging',
    'app.models',
    'app.database',
]

# Data files to include
datas = [
    ('database/schema.sql', 'database/'),
    ('.env.example', '.'),
    ('README.md', '.'),
    ('install.sh', '.'),
    ('app/templates', 'app/templates/'),
]

# Binaries (empty for now)
binaries = []

# Analysis with typing explicitly excluded
a = Analysis(
    ['fixture_daemon.py'],
    pathex=[str(project_root)],
    binaries=binaries,
    datas=datas,
    hiddenimports=hidden_imports,
    hookspath=[],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[
        'tkinter',
        'matplotlib',
        'scipy',
        'PIL',
        'PyQt5',
        'PyQt6',
        'PySide2',
        'PySide6',
        'torch',
        'torchvision',
        'torchaudio',
        'tensorflow',
        'keras',
        'transformers',
        'sklearn',
        'xgboost',
        'lightgbm',
        'catboost',
        'test',
        'unittest',
        'doctest',
        'pdb',
        'pydoc',
        'typing',  # Exclude typing package to avoid PyInstaller conflict
    ],
    win_no_prefer_redirects=False,
    win_private_assemblies=False,
    cipher=None,
    noarchive=False,
)

# Remove duplicate entries
pyz = PYZ(a.pure, a.zipped_data, cipher=None)

# Create the executable
exe = EXE(
    pyz,
    a.scripts,
    a.binaries,
    a.zipfiles,
    a.datas,
    [],
    name='fixture-manager',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=False,
    upx_exclude=[],
    runtime_tmpdir=None,
    console=True,
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
    icon=None,
)