-- ============================================
-- Reset Reports Sync Data for Full Resync
-- ============================================
-- This SQL script resets all reports sync data
-- collected until now, forcing clients to perform
-- a full resync on their next sync attempt
-- ============================================

-- WARNING: This will DELETE all reports sync data!
-- Make sure to backup your database before running this!

-- ============================================
-- Option 1: Reset for a specific client
-- ============================================

-- Delete all sync logs for specific client
-- DELETE FROM report_sync_logs WHERE client_id = 'YOUR_CLIENT_ID_HERE';

-- Delete all match reports for specific client
-- DELETE FROM match_reports WHERE client_id = 'YOUR_CLIENT_ID_HERE';

-- Delete all extraction stats for specific client
-- DELETE FROM extraction_stats WHERE client_id = 'YOUR_CLIENT_ID_HERE';

-- Delete all bets for specific client
-- DELETE FROM bets WHERE client_id = 'YOUR_CLIENT_ID_HERE';

-- Delete all report syncs for specific client
-- DELETE FROM report_syncs WHERE client_id = 'YOUR_CLIENT_ID_HERE';


-- ============================================
-- Option 2: Reset for ALL clients (Full Reset)
-- ============================================

-- Delete all sync logs
DELETE FROM report_sync_logs;

-- Delete all match reports
DELETE FROM match_reports;

-- Delete all extraction stats
DELETE FROM extraction_stats;

-- Delete all bets (bet_details will be cascade deleted)
DELETE FROM bets;

-- Delete all report syncs
DELETE FROM report_syncs;


-- ============================================
-- Option 3: Reset for multiple specific clients
-- ============================================

-- Delete sync logs for multiple clients
DELETE FROM report_sync_logs 
WHERE client_id IN (
    'client_id_1',
    'client_id_2',
    'client_id_3'
);

-- Delete match reports for multiple clients
DELETE FROM match_reports 
WHERE client_id IN (
    'client_id_1',
    'client_id_2',
    'client_id_3'
);

-- Delete extraction stats for multiple clients
DELETE FROM extraction_stats 
WHERE client_id IN (
    'client_id_1',
    'client_id_2',
    'client_id_3'
);

-- Delete bets for multiple clients
DELETE FROM bets 
WHERE client_id IN (
    'client_id_1',
    'client_id_2',
    'client_id_3'
);

-- Delete report syncs for multiple clients
DELETE FROM report_syncs 
WHERE client_id IN (
    'client_id_1',
    'client_id_2',
    'client_id_3'
);


-- ============================================
-- Option 4: Reset syncs after a specific date
-- ============================================

-- Delete sync logs after specific date
DELETE FROM report_sync_logs 
WHERE created_at >= '2026-01-01 00:00:00';

-- Delete match reports after specific date
DELETE FROM match_reports 
WHERE created_at >= '2026-01-01 00:00:00';

-- Delete extraction stats after specific date
DELETE FROM extraction_stats 
WHERE created_at >= '2026-01-01 00:00:00';

-- Delete bets after specific date
DELETE FROM bets 
WHERE created_at >= '2026-01-01 00:00:00';

-- Delete report syncs after specific date
DELETE FROM report_syncs 
WHERE created_at >= '2026-01-01 00:00:00';


-- ============================================
-- Verification Queries (Run after reset to verify)
-- ============================================

-- Check if all data is deleted for specific client
SELECT 
    'report_syncs' as table_name,
    COUNT(*) as record_count
FROM report_syncs 
WHERE client_id = 'YOUR_CLIENT_ID_HERE'

UNION ALL

SELECT 
    'bets' as table_name,
    COUNT(*) as record_count
FROM bets 
WHERE client_id = 'YOUR_CLIENT_ID_HERE'

UNION ALL

SELECT 
    'extraction_stats' as table_name,
    COUNT(*) as record_count
FROM extraction_stats 
WHERE client_id = 'YOUR_CLIENT_ID_HERE'

UNION ALL

SELECT 
    'match_reports' as table_name,
    COUNT(*) as record_count
FROM match_reports 
WHERE client_id = 'YOUR_CLIENT_ID_HERE'

UNION ALL

SELECT 
    'report_sync_logs' as table_name,
    COUNT(*) as record_count
FROM report_sync_logs 
WHERE client_id = 'YOUR_CLIENT_ID_HERE';


-- Check if all data is deleted for all clients
SELECT 
    'report_syncs' as table_name,
    COUNT(*) as record_count
FROM report_syncs

UNION ALL

SELECT 
    'bets' as table_name,
    COUNT(*) as record_count
FROM bets

UNION ALL

SELECT 
    'extraction_stats' as table_name,
    COUNT(*) as record_count
FROM extraction_stats

UNION ALL

SELECT 
    'match_reports' as table_name,
    COUNT(*) as record_count
FROM match_reports

UNION ALL

SELECT 
    'report_sync_logs' as table_name,
    COUNT(*) as record_count
FROM report_sync_logs;


-- ============================================
-- Reset Auto-Increment (Optional - for clean slate)
-- ============================================

-- Reset auto-increment for report_syncs table
ALTER TABLE report_syncs AUTO_INCREMENT = 1;

-- Reset auto-increment for bets table
ALTER TABLE bets AUTO_INCREMENT = 1;

-- Reset auto-increment for extraction_stats table
ALTER TABLE extraction_stats AUTO_INCREMENT = 1;

-- Reset auto-increment for match_reports table
ALTER TABLE match_reports AUTO_INCREMENT = 1;

-- Reset auto-increment for report_sync_logs table
ALTER TABLE report_sync_logs AUTO_INCREMENT = 1;


-- ============================================
-- Notes
-- ============================================

-- 1. Replace 'YOUR_CLIENT_ID_HERE' with actual client ID
-- 2. For Option 2 (Full Reset), comment out other options
-- 3. For Option 3, add/remove client IDs as needed
-- 4. For Option 4, adjust date as needed
-- 5. Run verification queries after reset to confirm
-- 6. Auto-increment reset is optional - only if you want clean IDs

-- After running this SQL:
-- - All clients will query /api/reports/last-sync and get "No sync records found"
-- - Clients will perform full sync on next sync attempt
-- - All historical data will be re-sent to server